#!/usr/bin/X11/tixwish
#  File: add.tcl
# 
#      This file is part of minkowsky
# 
#      Copyright (C) 2001-2002 by Rdiger Goetz
#      Author: Rdiger Goetz <minkowsky@r-goetz.de>
# 
#      Time-stamp: <26-May-2002 13:03:59 goetz>
# 
#      This program is free software; you can redistribute it and/or modify
#      it under the terms of the GNU General Public License as published by
#      the Free Software Foundation; either version 2 of the License, or
#      (at your option) any later version.
# 
#      This program is distributed in the hope that it will be useful,
#      but WITHOUT ANY WARRANTY; without even the implied warranty of
#      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#      GNU General Public License for more details.
# 
#      You should have received a copy of the GNU General Public License
#      along with this program; if not, write to the Free Software
#      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#  

proc editDateDialog {  } {
    global edd_init edd_einl edd_part edd_ext
    global edd_startD edd_stopD edd_startT edd_stopT
    global edd_room edd_flags edd_group 
    global eddo_ok eddo_abb eddo_prvTeilnLines cputype eddo_addButtonTitel
    global fnt12 bfnt  fnt bnft12  fnt18 bfnt18 curr_perms
    global eddv_titel eddo_titel
    global edd_fttid eddv_onPartPage
    global eddv_TTdirty _calText _buttonText
    global edd_editTyp edd_titel



    
    set edd_fttid -1
    set eddv_TTdirty 1

    set eddo_prvTeilnLines 0

    if { [winfo exists .edd ] == 1 } { return }
    killDateToolTip
    toplevel .edd
    busyCursor .edd
    wm title .edd [format "%s : %s" $edd_editTyp $edd_titel ]
    centerWin .edd 957 628
#    raiseLock .edd
    
    frame .edd.h -relief ridge -bd 2 -bg "#FFEFD5"
    frame .edd.e
    frame .edd.b
    pack .edd.h  -side top -fill x -pady 4
    pack .edd.e .edd.b -side top -fill x

    set eddo_titel .edd.h.t
    label .edd.h.l -text "$_calText(Titel) " -width 6 -font $bfnt18  -bg "#FFEFD5"
    entry $eddo_titel -width 42  -state disabled -font $fnt18 -bg "#FFF8E8" -vcmd {checkEntryText %P 200  %d %S ""} -validate key
    pack .edd.h.l  -side left   -expand 0  -padx 6  
    pack $eddo_titel -side left   -expand 1 -fill both -padx 6 -ipady 2
    bind $eddo_titel <KeyPress> {modiWinTitel}

    tixNoteBook .edd.e.nb 
    .edd.e.nb add times -label $_calText(AddPageTimes)   -raisecmd EDDoffPartPage
    .edd.e.nb add part  -label $_calText(AddPagePart) -state disabled  -raisecmd EDDonPartPage
    .edd.e.nb add details -label $_calText(AddPageDetails) -state disabled  -raisecmd EDDoffPartPage
    pack .edd.e.nb -side top -fill x
    set eddv_onPartPage 0

    set eddo_abb .edd.b.abb
    button $eddo_abb -state disabled -text $_buttonText(Cancel) -command {
	closeWin .edd
	set eddLock 0
    }
    pack $eddo_abb -side left 

    set eddo_ok .edd.b.ok
    button $eddo_ok -state disabled  -text $eddo_addButtonTitel -command sendDate
    pack $eddo_ok -side right



    drawEDDtimes   [.edd.e.nb subwidget times ]
    drawEDDdetails [.edd.e.nb subwidget details ]
    drawEDDpart    [.edd.e.nb subwidget part ]
    .edd.e.nb raise times
    
#     update
#     puts [wm geometry .edd]
#    centerWin .edd 950 576
    update
    bind .edd <Alt-q> {exitClient}
    focus -force .edd
    stdCursor .edd
}

proc EDDonPartPage { } {
    global eddv_onPartPage
    global edd_fttid
    global eddv_TTdirty

    set eddv_onPartPage 1
    if { $edd_fttid >= 0 } {
	after cancel $edd_fttid
    }
    if { $eddv_TTdirty ==1 } {
	fillTimeTable
    }
}
proc EDDoffPartPage { } {
    global eddv_onPartPage
    set eddv_onPartPage 0
}

proc modiWinTitel {  } {
    global edd_titel  edd_editTyp
    wm title .edd [format "%s : %s" $edd_editTyp $edd_titel ]
}






proc drawEDDtimes {win } {

     frame $win.l 
     frame $win.r  -relief raised -bd 2
     pack $win.l  $win.r -side left -fill both
  
     frame $win.l.t -relief raised -bd 2
     frame $win.l.m -relief raised -bd 2
     frame $win.l.b -relief raised -bd 2
     pack $win.l.t $win.l.m $win.l.b -side top -fill both -ipady 1 -ipadx 2 -padx 2


    drawEDDtimesZO $win.l.t
#    drawEDDtimesProps $win.l.b
    drawEDDtimesRepeat $win.l.m
    drawEDDtimesRemind $win.r
}

proc drawEDDtimesZO {win} {
    global fnt bfnt fnt12 bfnt12 pfnt pbfnt pfnt12 pbfnt12
    global roomList  eddo_room
    global eddo_startDy eddo_startDm eddo_startDd eddo_startTh eddo_startTm  eddo_startCl 
    global eddo_stopDy eddo_stopDm eddo_stopDd eddo_stopTh eddo_stopTm  eddo_stopCl
    global eddo_repeat eddo_repeat2 eddo_repeat3 eddo_repeat4
    global eddo_noTime eddo_nonBlock
    global edd_startDd edd_startDm edd_startDy edd_stopDd edd_stopDm edd_stopDy
    global selDateCalIcon
    global _calText _buttonText _allgText _dateOrder

    frame $win.l
    frame $win.v -relief ridge -bd 2
    pack $win.l -side top -fill x -pady 2
    pack $win.v -side top -fill x -pady 2

    frame $win.v.b
    frame $win.v.e 
    frame $win.v.t
    frame $win.v.s
    frame $win.v.r -relief raised -bd 3
    pack $win.v.b $win.v.e  $win.v.s $win.v.t -side top -fill x -pady 5
    pack $win.v.r -side top -fill x -pady 8

    
    label $win.l.l -text $_calText(AddSecTimesPlace) -font $bfnt12 -width 55
    pack $win.l.l -side left

    set eddo_startDy $win.v.b.sY
    set eddo_startDm $win.v.b.sM
    set eddo_startDd $win.v.b.sD
    set eddo_startCl $win.v.b.cl
    set eddo_startTh $win.v.b.sh
    set eddo_startTm $win.v.b.sm
    label $win.v.b.sl -text $_calText(Beginn) -width 14 -font $bfnt




    label $win.v.b.s1 -text $_allgText(dateSep) -font $bfnt
    label $win.v.b.s2 -text $_allgText(dateSep) -font $bfnt

    tixControl $eddo_startDd  \
 	-state disabled -min 0 -max 31 -integer 1 -command setTTdirty \
 	-options {  entry.width 2  label.width 0 label.justify center } -selectmode immediate \
 	-autorepeat true -validatecmd validateStartDatesDay
    tixControl $eddo_startDm -options { entry.width 2 label.width 0 label.justify center}\
  	-state disabled	-min 0 -max 12 -integer 1 -validatecmd validateStartDatesMon\
 	-command setTTdirty -selectmode immediate -autorepeat true
    tixControl $eddo_startDy -options { entry.width 4}  -state disabled -min 1999 -max 2100 -integer 1  -command setTTdirty -selectmode immediate -autorepeat true -validatecmd validateStartDatesYear

    button $eddo_startCl -image [image create pixmap -data $selDateCalIcon] -command {
	set x [ winfo rootx $eddo_startCl]
	set y [expr  [ winfo rooty $eddo_startCl] + [ winfo height $eddo_startCl] ]
	set dlist [ displayYearCalAtPosition $edd_startDd $edd_startDm $edd_startDy $x $y .edd ]
	set edd_startDd [lindex $dlist 0]
	set edd_startDm [lindex $dlist 1]
	set edd_startDy [lindex $dlist 2]
    }

    tixControl $eddo_startTh -options { entry.width 2} -label "     " -state disabled -min 0 -max 23 -integer 1  -command setTTdirty -selectmode immediate -autorepeat true -validatecmd validateStartDatesHour
    tixControl $eddo_startTm -options { entry.width 2 incr.bd 1 decr.bd 1} -label ":" -state disabled -min 0 -max 59 -integer 1  -command setTTdirty -selectmode immediate -autorepeat true -validatecmd validateStartDatesMin
    label $win.v.b.l -text " " -width 1 -font $bfnt
    if { $_dateOrder == "de" } {
	pack  $win.v.b.sl $eddo_startDd $win.v.b.s1 $eddo_startDm $win.v.b.s2 $eddo_startDy  $eddo_startCl -side left
	pack $eddo_startTh $eddo_startTm $win.v.b.l -side left
    } else {
	pack  $win.v.b.sl $eddo_startDm $win.v.b.s1 $eddo_startDd $win.v.b.s2 $eddo_startDy  $eddo_startCl -side left
	pack $eddo_startTh $eddo_startTm $win.v.b.l -side left
    }
    pack forget [ $eddo_startDd subwidget incr]
    pack forget [ $eddo_startDd subwidget decr]
    pack forget [ $eddo_startDm subwidget incr]
    pack forget [ $eddo_startDm subwidget decr]
    pack forget [ $eddo_startDy subwidget incr]
    pack forget [ $eddo_startDy subwidget decr]


    set eddo_stopDy $win.v.e.sY
    set eddo_stopDm $win.v.e.sM
    set eddo_stopDd $win.v.e.sD
    set eddo_stopCl $win.v.e.cl
    set eddo_stopTh $win.v.e.sg
    set eddo_stopTm $win.v.e.sm
    label $win.v.e.sl -text $_calText(Ende) -width 14 -font $bfnt
    label $win.v.e.s1 -text $_allgText(dateSep) -font $bfnt
    label $win.v.e.s2 -text $_allgText(dateSep) -font $bfnt
    tixControl $eddo_stopDd -state disabled -min 0 -max 31 -integer 1  -command setTTdirty \
	-options {  entry.width 2 } -selectmode immediate -autorepeat true -validatecmd validateStopDatesDay
    tixControl $eddo_stopDm -options { entry.width 2 } -state disabled -min 0 -max 12 -integer 1  \
	-validatecmd validateStopDatesMon 	-command setTTdirty -selectmode immediate -autorepeat true
    tixControl $eddo_stopDy -options { entry.width 4}  -state disabled -min 1999 -max 2100 -integer 1  -command setTTdirty -selectmode immediate -autorepeat true -validatecmd validateStopDatesYear
    button $eddo_stopCl -image [image create pixmap -data $selDateCalIcon] -command {
	set x [ winfo rootx $eddo_stopCl]
	set y [expr  [ winfo rooty $eddo_stopCl] + [ winfo height $eddo_stopCl] ]
	set dlist [ displayYearCalAtPosition $edd_stopDd $edd_stopDm $edd_stopDy $x $y  .edd]
	set edd_stopDd [lindex $dlist 0]
	set edd_stopDm [lindex $dlist 1]
	set edd_stopDy [lindex $dlist 2]
    }

    tixControl $eddo_stopTh -options { entry.width 2} -label "     " -state disabled -min 0 -max 23 -integer 1  -command setTTdirty -selectmode immediate -autorepeat true -validatecmd validateStopDatesHour
    tixControl $eddo_stopTm -options { entry.width 2} -label ":" -state disabled -min 0 -max 59 -integer 1  -command setTTdirty -selectmode immediate -autorepeat true -validatecmd validateStopDatesMin
    label $win.v.e.l -text " " -width 1 -font $bfnt
    if { $_dateOrder == "de" } {
	pack  $win.v.e.sl $eddo_stopDd $win.v.e.s1 $eddo_stopDm $win.v.e.s2 $eddo_stopDy  $eddo_stopCl -side left
	pack $eddo_stopTh $eddo_stopTm $win.v.e.l -side left
    } else {
	pack  $win.v.e.sl $eddo_stopDm $win.v.e.s1 $eddo_stopDd $win.v.e.s2 $eddo_stopDy  $eddo_stopCl -side left
	pack $eddo_stopTh $eddo_stopTm $win.v.e.l -side left
    }

    pack forget [ $eddo_stopDd subwidget incr]
    pack forget [ $eddo_stopDd subwidget decr]
    pack forget [ $eddo_stopDm subwidget incr]
    pack forget [ $eddo_stopDm subwidget decr]
    pack forget [ $eddo_stopDy subwidget incr]
    pack forget [ $eddo_stopDy subwidget decr]

    set datelem "$eddo_stopDd $eddo_stopDm $eddo_stopDy $eddo_stopTh $eddo_stopTm $eddo_startDd $eddo_startDm $eddo_startDy $eddo_startTh $eddo_startTm"
    foreach w $datelem {
	$w subwidget entry configure  -font $pfnt
    }
    set datelem "$eddo_stopTh $eddo_stopTm $eddo_startTh $eddo_startTm"
    foreach w $datelem {
	$w subwidget label configure  -font $bfnt
	}

    set eddo_noTime $win.v.t.c
    label $win.v.t.l -text " " -width 14 -font $bfnt
    checkbutton $eddo_noTime -text $_calText(TerminOhneUhrzeit) -font $bfnt
    pack $win.v.t.l $eddo_noTime -side left

    set eddo_nonBlock $win.v.s.c
    label $win.v.s.l -text " " -width 14 -font $bfnt
    checkbutton $eddo_nonBlock -text $_calText(schwebenderTermin) -font $bfnt
    pack $win.v.s.l $eddo_nonBlock -side left

    frame $win.v.o 
    pack  $win.v.o -side top -fill x

    set eddo_room $win.v.o.m
    tixOptionMenu $eddo_room  -options {menubutton.width 14 label.width 14 } -label "$_allgText(Ort)" -state disabled  -command {setTTdirty }
    $eddo_room subwidget label configure -font $bfnt
    $eddo_room subwidget menubutton configure  -font $bfnt12
    pack   $eddo_room -side left 
    foreach room $roomList { $eddo_room add command $room -label $room }

}

proc drawEDDtimesProps { win } {
    global groupList  eddo_group eddo_priv eddo_gpri  eddo_prior
    global bfnt fnt pbfnt pfnt bfnt12
    global _calText

    frame $win.l 
    frame $win.g -relief ridge -bd 2
    frame $win.s -relief ridge -bd 2
    frame $win.p -relief ridge -bd 2
    pack $win.l -side top -fill both  -ipady 1  -pady 3
    pack $win.g $win.s  $win.p -side top -fill both  -ipady 2 -pady 1

    label $win.l.l -text $_calText(addRest) -font $bfnt12
    pack $win.l.l -side left

    set eddo_group $win.g.m
    tixOptionMenu $eddo_group -options {menubutton.width 14 label.width 22 label.font $pbfnt} \
	-label $_calText(addGroupOfDate) -state disabled  
    $eddo_group subwidget label configure -font $bfnt
    $eddo_group subwidget menubutton configure  -font $fnt
    pack $eddo_group -side left -expand 0
    foreach group $groupList { 
	$eddo_group add command $group -label $group 
    }
    $eddo_group subwidget menubutton configure  -font $bfnt12

    set eddo_priv $win.s.p
    set eddo_gpri $win.s.g
    label $win.s.l -text $_calText(addPrivatStatus)  -font $bfnt -width 22
    checkbutton $eddo_priv -text $_calText(private) -state disabled   -font $fnt
    checkbutton $eddo_gpri -text $_calText(private4Group) -state disabled   -font $fnt
    pack $win.s.l $eddo_priv $eddo_gpri -side left

    set eddo_prior $win.p.s
    label $win.p.l -text $_calText(addPriority)  -font $bfnt -width 22
    label $win.p.n -text "$_calText(addPriorityLow) "  -font $fnt 
    scale $eddo_prior -state disabled -from 0 -to 7  -length  163 -resolution 1 -orient horizontal -showvalue 0
    label $win.p.h -text " $_calText(addPriorityHigh)"  -font $fnt 
    pack $win.p.l $win.p.n $eddo_prior $win.p.h -side left 
}

proc drawEDDtimesRepeat {win} {
    global edd_repEna edd_repTyp edd_repIntervall edd_repInterTyp edd_repCount edd_repInf
    global eddo_repEna eddo_repTyp eddo_repInf eddo_repCount eddo_repInter eddo_repItyp
    global eddo_repL1 eddo_repL2 eddo_repL3
    global bfnt fnt pbfnt pfnt fnt12 bfnt12
    global eddv_repTyp eddv_repUnit eddo_repUntilLabel
    global edd_repStopD  edd_repStopM  edd_repStopY
    global eddo_repStopD eddo_repStopM eddo_repStopY
    global eddo_repWT edd_repWT 
    global _calText weekDaysAbk  _dateOrder _allgText

    frame $win.l 
    frame $win.u -relief ridge -bd 2
    pack  $win.l $win.u  -side top -fill x -pady 3

    label $win.l.l -text $_calText(addRepeat)   -font $bfnt12
    pack $win.l.l -side left

    frame $win.u.1
    frame $win.u.2
    frame $win.u.3
    frame $win.u.4
    frame $win.u.5
    frame $win.u.6
    pack  $win.u.1 $win.u.2 $win.u.3 $win.u.4 $win.u.5 -side top -fill x -padx 2 -pady 8
    pack $win.u.6 -side top -fill x -padx 2 -pady 10
    label $win.u.6.l -text ""
    pack $win.u.6.l -side left

    set eddo_repEna   $win.u.1.c
    set eddo_repTyp   $win.u.2.t
    set eddo_repWT    $win.u.3.wt
    set eddo_repL1    $win.u.4.l
    set eddo_repL3    $win.u.5.l
    set eddo_repInf   $win.u.4.i
    set eddo_repStopD $win.u.4.d
    set eddo_repStopM $win.u.4.m
    set eddo_repStopY $win.u.4.y
    set eddo_repInter $win.u.5.i
    set eddo_repItyp  $win.u.5.t


    checkbutton $eddo_repEna -text $_calText(addRepeatDate) -font $bfnt -command {toggleRepeat} 
    pack $eddo_repEna -side left
    
    tixOptionMenu $eddo_repTyp  -options {menubutton.width 19 label.width 13 } \
	-label $_calText(addRepeatInterVall) -state disabled
    #Mit C-define und eddv_repTyp (-> initPartStatus) asyncron halten
    $eddo_repTyp add command tag   -label $_calText(addRepeatDay)
    $eddo_repTyp add command wtag  -label $_calText(addRepeatWorkingDay)
    $eddo_repTyp add command woche -label $_calText(addRepeatWeek)
    $eddo_repTyp add command monat -label $_calText(addRepeatMonth)
    $eddo_repTyp add command jeden -label $_calText(addRepeatEvery1)
    $eddo_repTyp add command alle  -label $_calText(addRepeatEvery2)
    $eddo_repTyp subwidget menubutton configure  -font $bfnt12
    $eddo_repTyp subwidget label configure  -font $bfnt
    pack $eddo_repTyp -side left

    tixSelect $eddo_repWT -label "$_calText(addRepeatExcept)  " -allowzero true -radio false -orientation horizontal
    $eddo_repWT subwidget label configure -font $bfnt -width 13 -anchor ne -justify right

    pack $eddo_repWT -side left
#    set wds "Mo Di Mi Do Fr Sa So"
    set j 1
    for { set i  0 } {$i <7 } {incr i} {
 	$eddo_repWT add $j -text [lindex $weekDaysAbk $i] -width 2
	set j [ expr $j*2]
    }
    

    label $eddo_repL1 -text $_calText(addRepeatTimes) -width 13 -font $bfnt  -foreground grey65
    checkbutton $eddo_repInf -variable edd_repEna -text "$_calText(addRepeatUnlimit) "\
	-font $bfnt -command {toggleRepeatCount}  -state disabled

    pack $eddo_repL1  $eddo_repInf   -side left
    set eddo_repUntilLabel $win.u.4.l0
    label $eddo_repUntilLabel -text " $_calText(bis2) " -font $bfnt -width 5
    tixControl $eddo_repStopD -label $_allgText(dateSep) -labelside right -state disabled -min 0 -max 31 -integer 1  -command setTTdirty -options {  entry.width 2 } -selectmode immediate -autorepeat true
    tixControl $eddo_repStopM -options { entry.width 2} -label $_allgText(dateSep) -labelside right -state disabled -min 0 -max 12 -integer 1 -validatecmd adoptMaxRepStopDay -command setTTdirty -selectmode immediate -autorepeat true
    tixControl $eddo_repStopY -options { entry.width 4}  -state disabled -min 1999 -max 2100 -integer 1  -command setTTdirty -selectmode immediate -autorepeat true
    if { $_dateOrder == "de" } {
	pack $eddo_repUntilLabel $eddo_repStopD $eddo_repStopM $eddo_repStopY -side left -padx 0 -ipadx 0
    } else { 
	pack $eddo_repUntilLabel $eddo_repStopM $eddo_repStopD $eddo_repStopY -side left -padx 0 -ipadx 0
    }

    label $eddo_repL3 -text $_calText(addRepeatEveryText) -width 13 -font $bfnt  -foreground grey65
    tixControl $eddo_repInter  -min 0 -max 31 -options {  entry.width 2  label.foreground grey65} \
	 -state disabled -selectmode immediate -autorepeat true
    $eddo_repInter subwidget label configure -font $bfnt
    label $win.u.4.s -text "  " -width 1
    tixOptionMenu $eddo_repItyp  -options {menubutton.width 8} -state disabled
    #Mit C-define und eddv_repUnit (-> initPartStatus) asyncron halten
    $eddo_repItyp add command stunden -label $_calText(addRepeatEveryHours)
    $eddo_repItyp add command tage    -label $_calText(addRepeatEveryDays)
    $eddo_repItyp add command woche   -label $_calText(addRepeatEveryWeeks)
    $eddo_repItyp add command monate  -label $_calText(addRepeatEveryMonth)
    $eddo_repItyp add command jahre   -label $_calText(addRepeatEveryYears)
    $eddo_repItyp subwidget menubutton configure  -font $bfnt12
    
    pack $eddo_repL3  $eddo_repInter $win.u.4.s $eddo_repItyp -side left
    $eddo_repTyp configure -command {toggleRepeatSpecial}
}

proc drawEDDtimesRemind { win } {
    global bfnt fnt pbfnt pfnt fnt12 bfnt12
    global eddo_reminder
    global edd_part
    global eddo_remWann1 eddo_remWann2 eddo_remWie eddo_remWer eddo_remAls1 eddo_remAls2
    global eddv_remVal eddv_remUnit eddv_remWeg eddv_remZiel eddv_remAls
    global _calText

    set eddv_remAls R

    frame $win.l
    frame $win.r 
    frame $win.d
    pack $win.l  -side top -fill x -pady 2 -ipady 1
    pack $win.r $win.d -side top -fill x

    label $win.l.l -text $_calText(addRemind) -font $bfnt12
    pack $win.l.l -side left

    set eddo_reminder $win.r.r
    tixCObjView $eddo_reminder -width 520  -height 388 -scrollbar   y
    $eddo_reminder subwidget vsb configure -width 12
    pack $eddo_reminder -side top


    frame $win.d.l 
    frame $win.d.r 
    pack $win.d.l -side left -fill both
    pack $win.d.r -side right -fill both

    frame $win.d.l.a
    frame $win.d.l.t
    frame $win.d.l.m
    pack $win.d.l.a $win.d.l.t $win.d.l.m -side top -fill x

    set eddo_remAls1  $win.d.l.a.einl
    set eddo_remAls2 $win.d.l.a.rem
    set eddo_remWann1 $win.d.l.t.wann1
    set eddo_remWann2 $win.d.l.t.wann2 
    set eddo_remWie $win.d.l.t.wie
    set eddo_remWer $win.d.l.m.wer
    
    label $win.d.l.a.l -text $_calText(addRemindSend)  -font $bfnt -width 10
    radiobutton $eddo_remAls1 -value "E" -text $_calText(addRemindInvite) -font $bfnt -variable eddv_remAls -width 16
    radiobutton $eddo_remAls2 -value "R" -text $_calText(addRemindRemind) -font $bfnt -variable eddv_remAls -width 16
    pack $win.d.l.a.l  $eddo_remAls1 $eddo_remAls2 -side left

    label $win.d.l.t.s -text "   " -font $bfnt -width 8
    set eddv_remVal 1
    tixControl $eddo_remWann1  -min 1 -max 99 -options {  entry.width 4  } -variable eddv_remVal -selectmode immediate -autorepeat true
    tixOptionMenu $eddo_remWann2  -options {menubutton.width 9} -variable eddv_remUnit
    $eddo_remWann2 add command Tage -label $_calText(addRemindDays)
    $eddo_remWann2 add command Stunden -label $_calText(addRemindHours) 
    $eddo_remWann2 add command Minuten -label $_calText(addRemindMin)
    $eddo_remWann2  subwidget menubutton configure  -font $bfnt12
    label $win.d.l.t.wann3 -text $_calText(addRemindBeforeBy) -font $bfnt12 -width 10 -justify center
    
    tixOptionMenu $eddo_remWie  -options {menubutton.width 9 }  -variable eddv_remWeg
    $eddo_remWie add command E-mail -label $_calText(addRemindByMail)
    $eddo_remWie add command Fenster -label $_calText(addRemindByDialog)
    $eddo_remWie  subwidget menubutton configure  -font $bfnt12
    pack  $win.d.l.t.s $eddo_remWann1 $eddo_remWann2 $win.d.l.t.wann3 $eddo_remWie -side left
    

    label $win.d.l.m.s -text "   " -font $bfnt12 -width 8
    label $win.d.l.m.l -text "  $_calText(addRemindTo) " -font $bfnt12 -width 7
    tixOptionMenu $eddo_remWer  -options {menubutton.width 34}  -variable eddv_remZiel
    updateReminderUser
    label $win.d.l.m.s2 -text "   " -font $bfnt12 -width 4
 
    $eddo_remWer subwidget menubutton configure  -font $bfnt12
    pack $win.d.l.m.s $win.d.l.m.l $eddo_remWer $win.d.l.m.s2 -side left

    button $win.d.r.go -text $_calText(addRemindAdd) -font $bfnt12 -command {addRemind}
    pack $win.d.r.go -side bottom -pady 2
}


proc drawEDDpart { win } {

    frame $win.l -relief ridge -bd 2
    frame $win.r 
    pack $win.l $win.r -side left -fill x

    frame $win.r.t -relief ridge -bd 2
    frame $win.r.b -relief ridge -bd 2
    pack $win.r.t  -side top -fill both 
    pack $win.r.b -side top -fill x

    drawEDDlist $win.l
    drawEDDselect $win.r.t
    drawEDDtimeTable $win.r.b
}

proc drawEDDdetails { win } {
    global fnt bfnt fnt12 bfnt12 pfnt pbfnt pfnt12 pbfnt12
    global eddo_comm eddo_commb eddo_detail eddo_newComm
    global eddo_newCommentLabel eddo_commLabel
    global _calText

    frame $win.l 
    frame $win.r -relief raised -bd 2
    pack $win.l $win.r -side left -fill x -padx 2 -pady 1
    
    
    frame $win.l.d  -relief raised -bd 2
    frame $win.l.p  -relief raised -bd 2
    pack $win.l.d $win.l.p -side top -fill x

    frame $win.l.d.f -relief ridge -bd 2
    pack $win.l.d.f -fill both -side top
   
    #details
    set lwin $win.l.d.f
    set eddo_detail $lwin.text
    label $lwin.l -text "$_calText(addDetails):" -font $bfnt
    tixScrolledText $eddo_detail -width 468 -height 344
    $eddo_detail subwidget text configure -font $fnt
    $eddo_detail subwidget text configure -state disabled
    $eddo_detail subwidget hsb configure -width 12
    $eddo_detail subwidget vsb configure -width 12
    pack  $lwin.l $eddo_detail -side top    -fill x   -padx 2

    drawEDDtimesProps $win.l.p

    set eddo_newCommentLabel $win.r.l
    set eddo_newComm $win.r.n
    label $eddo_newCommentLabel -text "$_calText(addNewComments)" -font $bfnt
    tixScrolledText $eddo_newComm  -width 320 -height 100
    pack $eddo_newCommentLabel $eddo_newComm  -side top -fill x   -padx 2
    $eddo_newComm  subwidget vsb configure -width 12
    $eddo_newComm  subwidget hsb configure -width 12

    set eddo_commb $win.r.b
    button $eddo_commb -text " $_calText(addAddNewComment) " -command addComm
    pack $eddo_commb -side top -pady 8   -padx 2
    
    set eddo_comm $win.r.text
    set eddo_commLabel $win.r.u
    label $eddo_commLabel -text " $_calText(addComments)" -font $bfnt -anchor nw -justify left
    tixScrolledText $eddo_comm -width 455 -height 322
    $eddo_comm  subwidget hsb configure -width 12
    $eddo_comm  subwidget vsb configure -width 12
    $eddo_comm subwidget text configure -state disabled
    $eddo_comm subwidget text configure -font $fnt12
    pack $eddo_commLabel  -side top   -padx 2 -fill x
    pack  $eddo_comm -side top   -expand 1 -fill both   -padx 2
  
}





#PERM einbauen

proc toggleRepeat {  } {
    global edd_repEna curr_perms eddo_repStopD
    global eddo_repEna eddo_repTyp eddo_repInf  eddo_repInter eddo_repItyp
    global eddo_repL1 eddo_repL2 eddo_repL3 
    global eddo_repWT
    global edd_shiftCount

    if { $edd_repEna == 1} {
	if { $curr_perms(rz) == 1} {
	    $eddo_repTyp   configure -state normal
	    $eddo_repInf   configure -state normal
	}
	$eddo_repL1    configure -foreground black
	$eddo_repStopD subwidget label configure  -foreground black
    } else {
	$eddo_repTyp   configure -state disabled
	$eddo_repInf   configure -state disabled
	$eddo_repL1    configure -foreground grey65
	$eddo_repStopD subwidget label configure -foreground grey65
    }
    toggleRepeatCount 
    toggleRepeatSpecial x
}

proc toggleRepeatCount {  } {
    global edd_repInf edd_repEna curr_perms
    global eddo_repCount 
    global eddo_repL2 eddo_repUntilLabel
    global eddo_repStopD eddo_repStopM eddo_repStopY
    global edd_repStopD edd_repStopM edd_repStopY edd_startDy edd_startDm edd_startDd
    global tyear tmon tday

    if { $edd_repInf == 0 && $edd_repEna == 1} {
	$eddo_repStopD configure -state normal
	$eddo_repStopM configure -state normal
	$eddo_repStopY configure -state normal
	$eddo_repUntilLabel  configure -fg black
	set start [format "%4d%02d%02d" $edd_startDy $edd_startDm $edd_startDd ]
	set rep   [format "%4d%02d%02d" $edd_repStopY $edd_repStopM $edd_repStopD  ]
	if { $rep< $start  } {
	    set edd_repStopD $tday
	    set edd_repStopM $tmon
	    set edd_repStopY $tyear
	}
	if { $curr_perms(rz) != 1} {
	    $eddo_repStopD configure -state disabled
	    $eddo_repStopM configure -state disabled
	    $eddo_repStopY configure -state disabled
	    $eddo_repUntilLabel  configure -fg grey60
	}
    } else {
	$eddo_repStopD configure -state disabled
	$eddo_repStopM configure -state disabled
	$eddo_repStopY configure -state disabled
	$eddo_repUntilLabel  configure -fg grey60
    }
}
proc toggleRepeatSpecial { val } {
    global edd_repTyp edd_repEna
    global eddo_repInter eddo_repItyp eddo_repWT
    global eddo_repL3 curr_perms


    $eddo_repInter configure -state disabled
    $eddo_repItyp  configure -state disabled
    $eddo_repL3    configure -foreground grey65
    $eddo_repInter subwidget label configure -foreground grey65
    $eddo_repWT    configure -state disabled
    $eddo_repWT    subwidget label configure -foreground grey65

    if {$edd_repEna == 1} {
	if { $edd_repTyp == "alle"} {
	    if { $curr_perms(rz) == 1} {
		$eddo_repInter configure -state normal
		$eddo_repItyp  configure -state normal
	    }
	    $eddo_repInter subwidget label configure -foreground black
	    $eddo_repL3    configure -foreground black
	}
	if { $edd_repTyp == "tag"} {
	    if { $curr_perms(rz) == 1} {
		$eddo_repWT    configure -state normal
	    }
	    $eddo_repWT  subwidget label configure -foreground black
	}
    }
}


proc updateReminderUser { } {
    global eddo_remWer edd_part curr_perms fullUsername edd_groupsOfUser
    global username

    set entList [$eddo_remWer entries]
    foreach ent $entList { $eddo_remWer delete $ent }

    if { $curr_perms(wt) == 1 && $curr_perms(wz) == 1} {
	$eddo_remWer add command alle -label "Alle"	
	$eddo_remWer add command intern -label "interne Teilnehmer"
	$eddo_remWer add command extern -label "externe Teilnehmer"
    }
    foreach part $edd_part { 
	if { $curr_perms(wt) == 1 && $curr_perms(wz) == 1} {
	    $eddo_remWer add command [lindex $part 1] -label [lindex $part 5]
	} else { 
	    if { [lindex $part 6] == "u" } {
		if { $username == [lindex $part 1] } {
		    $eddo_remWer add command [lindex $part 1] -label [lindex $part 5]
		}
	    } elseif { [lindex $part 6] == "g" } {
		if { [lsearch $edd_groupsOfUser [lindex $part 1] ] >= 0} {
		    $eddo_remWer add command [lindex $part 1] -label [lindex $part 5]
		}		    
	    }
	}
    }    
}
proc addRemind { } {
    global eddv_remVal eddv_remUnit eddv_remWeg eddv_remZiel eddv_remAls 
    global edd_reminder eddo_remWer

    set full [ $eddo_remWer entrycget $eddv_remZiel -label ]

    lappend edd_reminder "$eddv_remVal $eddv_remUnit $eddv_remWeg $eddv_remZiel {$full} $eddv_remAls"
    fillReminder
}

proc validateStartDatesDay { val } {
    global edd_startDy edd_startDm edd_startDd edd_startTh edd_startTm 
    global edd_stopDy edd_stopDm edd_stopDd edd_stopTh edd_stopTm 
    global monlen

    if { $val <1} { set val 1}
    set ml [ lindex $monlen  $edd_startDm ]
    if { $edd_startDm == 2} {
	if { [expr $edd_startDy % 4] == 0} {incr ml }
    }
    if { $val > $ml } { set val  $ml}

    if { [validateDates $edd_startDy $edd_startDm $val $edd_startTh $edd_startTm $edd_stopDy $edd_stopDm $edd_stopDd $edd_stopTh $edd_stopTm] == 0 } { return $val }
    return $edd_startDd
}
proc validateStartDatesMon { val } {
    global edd_startDy edd_startDm edd_startDd edd_startTh edd_startTm 
    global edd_stopDy edd_stopDm edd_stopDd edd_stopTh edd_stopTm 
    global monlen

    if { $val <1} { set val 1}
    if { $val > 12  } { set val 12}

    if { [validateDates $edd_startDy $val $edd_startDd $edd_startTh $edd_startTm $edd_stopDy $edd_stopDm $edd_stopDd $edd_stopTh $edd_stopTm] == 0 } { return $val }
    return $edd_startDm
}
proc validateStartDatesYear { val } {
    global edd_startDy edd_startDm edd_startDd edd_startTh edd_startTm 
    global edd_stopDy edd_stopDm edd_stopDd edd_stopTh edd_stopTm 
    if { [validateDates $val $edd_startDm $edd_startDd $edd_startTh $edd_startTm $edd_stopDy $edd_stopDm $edd_stopDd $edd_stopTh $edd_stopTm] == 0 } { return $val }
    return $edd_startDy
}
proc validateStartDatesHour { val } {
    global edd_startDy edd_startDm edd_startDd edd_startTh edd_startTm 
    global edd_stopDy edd_stopDm edd_stopDd edd_stopTh edd_stopTm 
 
    if {$val <0 } {set val 0}
    if {$val >23} {set val 23}
    if { [validateDates $edd_startDy $edd_startDm $edd_startDd $val $edd_startTm $edd_stopDy $edd_stopDm $edd_stopDd $edd_stopTh $edd_stopTm] == 0 } { 
	return $val 
    }

    return $edd_startTh
}
proc validateStartDatesMin { val } {
    global edd_startDy edd_startDm edd_startDd edd_startTh edd_startTm 
    global edd_stopDy edd_stopDm edd_stopDd edd_stopTh edd_stopTm 

    if {$val <0 } {set val 0}
    if {$val >60} {set val 60}
    if { [validateDates $edd_startDy $edd_startDm $edd_startDd $edd_startTh $val $edd_stopDy $edd_stopDm $edd_stopDd $edd_stopTh $edd_stopTm] == 0 } { return $val }
    return $edd_startTm
}
proc validateStopDatesDay { val } {
    global edd_startDy edd_startDm edd_startDd edd_startTh edd_startTm 
    global edd_stopDy edd_stopDm edd_stopDd edd_stopTh edd_stopTm 
    global monlen

    if { $val <1} { set val 1}
    set ml [ lindex $monlen  $edd_stopDm ]
    if { $edd_stopDm == 2} {
	if { [expr $edd_stopDy % 4] == 0} {incr ml }
    }
    if { $val > $ml } { set val  $ml}

    if { [validateDates $edd_startDy $edd_startDm $edd_startDd $edd_startTh $edd_startTm $edd_stopDy $edd_stopDm $val $edd_stopTh $edd_stopTm] == 0 } { return $val }
    return $edd_stopDd
}
proc validateStopDatesMon { val } {
    global edd_startDy edd_startDm edd_startDd edd_startTh edd_startTm 
    global edd_stopDy edd_stopDm edd_stopDd edd_stopTh edd_stopTm 
    global monlen

    if { $val <1} { set val 1}
    if { $val > 12  } { set val 12}

    if { [validateDates $edd_startDy $edd_startDm $edd_startDd $edd_startTh $edd_startTm $edd_stopDy $val $edd_stopDd $edd_stopTh $edd_stopTm] == 0 } { return $val }
    return $edd_stopDm
}
proc validateStopDatesYear { val } {
    global edd_startDy edd_startDm edd_startDd edd_startTh edd_startTm 
    global edd_stopDy edd_stopDm edd_stopDd edd_stopTh edd_stopTm 
    if { [validateDates $edd_startDy $edd_startDm $edd_startDd $edd_startTh $edd_startTm $val $edd_stopDm $edd_stopDd $edd_stopTh $edd_stopTm] == 0 } { return $val }
    return $edd_stopDy
}
proc validateStopDatesHour { val } {
    global edd_startDy edd_startDm edd_startDd edd_startTh edd_startTm 
    global edd_stopDy edd_stopDm edd_stopDd edd_stopTh edd_stopTm 

    if {$val <0 } {set val 0}
    if {$val >23} {set val 23}
    if { [validateDates $edd_startDy $edd_startDm $edd_startDd $edd_startTh $edd_startTm $edd_stopDy $edd_stopDm $edd_stopDd $val $edd_stopTm] == 0 } { return $val }
    return $edd_stopTh
}
proc validateStopDatesMin { val } {
    global edd_startDy edd_startDm edd_startDd edd_startTh edd_startTm 
    global edd_stopDy edd_stopDm edd_stopDd edd_stopTh edd_stopTm 

    if {$val <0 } {set val 0}
    if {$val >60} {set val 60}
    if { [validateDates $edd_startDy $edd_startDm $edd_startDd $edd_startTh $edd_startTm $edd_stopDy $edd_stopDm $edd_stopDd $edd_stopTh $val] == 0 } { return $val }
    return $edd_stopTm
}
proc validateDates { startDy startDm startDd startTh startTm stopDy stopDm stopDd stopTh stopTm} { 
    global edd_startDy edd_startDm edd_startDd edd_startTh edd_startTm 
    global edd_stopDy edd_stopDm edd_stopDd edd_stopTh edd_stopTm 

    set start [format "%04d02d%02d%02d%02d" $startDy $startDm $startDd $startTh $startTm ]
    set stop  [format "%04d02d%02d%02d%02d" $stopDy  $stopDm  $stopDd  $stopTh  $stopTm ]
    if { $stop < $start } {
	set edd_stopDy $edd_startDy
	set edd_stopDm $edd_startDm
	set edd_stopDd $edd_startDd
	set edd_stopTh $edd_startTh
	set edd_stopTm $edd_startTm
	return -1
    }
    return 0
}

proc adoptMaxRepStopDay { mon } {
    global eddo_repStopD monlen

    $eddo_repStopD configure -max [ lindex monlen  $mon ]
    return $mon
}
proc adoptMaxStartDay { mon } {
    global  monlen  eddo_startDd
    global edd_startDy edd_startDm edd_startDd edd_startTh edd_startTm 
    global edd_stopDy edd_stopDm edd_stopDd edd_stopTh edd_stopTm 

    set erg [validateDates $edd_startDy $mon $edd_startDd $edd_startTh $edd_startTm $edd_stopDy $edd_stopDm $edd_stopDd $edd_stopTh $edd_stopTm]
    $eddo_startDd configure -max [ lindex monlen  $mon ]
    if { $erg == 0} { return $mon}
    return $edd_startDm
}
proc adoptMaxStopDay { mon } {
    global  monlen  eddo_stopDd
    global edd_startDy edd_startDm edd_startDd edd_startTh edd_startTm 
    global edd_stopDy edd_stopDm edd_stopDd edd_stopTh edd_stopTm 

    set erg [validateDates $edd_startDy $edd_startDm $edd_startDd $edd_startTh $edd_startTm $edd_stopDy $mon $edd_stopDd $edd_stopTh $edd_stopTm]
#    validateDates 
    $eddo_stopDd configure -max [ lindex monlen  $mon ]
    if { $erg == 0} { return $mon}
    return $edd_stopDm
}
    

proc drawEDDlist { win } {
    global eddo_teilnehmer eddo_teilnehmer_sel eddo_teilTitel
    global cputype
    global fnt12 pfnt12 bfnt12 sbfnt12 bfnt11 bfnt10 bfnt
    global roomList eddo_room2
    global adStatusPopWin adTypePopWin partStatus partStatusStr
    global _calText _allgText

    frame $win.l -relief raised -bd 1
    frame $win.o -relief flat -bd 1
    pack $win.l $win.o -side top -fill both -expand 1 
    
    frame $win.l.t 
    frame $win.l.l
    pack $win.l.t $win.l.l -side top -fill both -expand 1 
    
    set eddo_teilTitel $win.l.t
    label $win.l.t.1 -relief raised -bd 2 -text $_calText(addPartListName)   -width 33 -font $bfnt12 -justify center -anchor n
    label $win.l.t.2 -relief raised -bd 2 -text $_calText(addPartListStatus) -width 11 -font $bfnt12  -justify center -anchor n
    label $win.l.t.3 -relief raised -bd 2 -text $_calText(addPartListPerms)  -width 15 -font $bfnt12  -justify center -anchor n
    label $win.l.t.4 -relief raised -bd 2 -text " X "   -font $bfnt12 -justify center -anchor n
    label $win.l.t.5 -relief raised -bd 2 -text "   " -font $bfnt12 
    pack $win.l.t.1 $win.l.t.2 $win.l.t.3 $win.l.t.4 $win.l.t.5 -side left -expand 0  -ipady 0 -pady 0  -fill x
    

    set adStatusPopWin $win.statusPop
    tixPopupMenu $adStatusPopWin -title "$_calText(Status):" -spring false
    set anz [ llength $partStatus]
    for { set i 1 } { $i <$anz } {incr i} {
	$adStatusPopWin subwidget menu add command -label [lindex $partStatusStr $i] -command "adSetPartStatus $i"
    }

    set adTypePopWin $win.typePop
    tixPopupMenu $adTypePopWin -title $_calText(addPartPopupType) -spring false
    $adTypePopWin subwidget menu add command -label $_calText(typeInvite) -command {setType E}
    $adTypePopWin subwidget menu add command -label $_calText(typePart) -command {setType T}
    $adTypePopWin subwidget menu add command -label $_calText(typeInfo) -command {setType i}

    set eddo_teilnehmer $win.l.c 
    tixCObjView $eddo_teilnehmer -width 470  -height 448 -scrollbar y
    $eddo_teilnehmer subwidget hsb configure -width 12
    $eddo_teilnehmer subwidget vsb configure -width 12
    $eddo_teilnehmer subwidget canvas configure -background grey95
    pack $eddo_teilnehmer -side left -expand 0  -fill y      
    set eddo_teilnehmer_sel ""

    set eddo_room2 $win.o.o
    tixOptionMenu $eddo_room2  -options {menubutton.width 20 label.width 14 } -label $_allgText(Ort)  -state disabled  -command {updateTT}
    $eddo_room2 subwidget label configure -font $bfnt12
    $eddo_room2 subwidget menubutton configure  -font $bfnt12
    pack   $eddo_room2 -side left 
    foreach room $roomList { $eddo_room2 add command $room -label $room }
}

proc drawEDDselect { win } {
    global bfnt12 _calText

    tixNoteBook $win.nb -ipadx 2 -ipady 0   -height 276
    $win.nb subwidget nbframe configure  -font $bfnt12
    $win.nb add userGroups -label  " $_calText(addPartUserGroups) " -underline -1
    $win.nb add addressen -label  " $_calText(addPartExternalPart) " -underline -1
    $win.nb add defPerms -label  " $_calText(addPartdefPermissions) "  -underline -1
    pack $win.nb -fill both 
    
    drawEDDselectLocal [ $win.nb subwidget userGroups ]
    drawEDDselectExtern [ $win.nb subwidget addressen ]
    drawEDDdefPerms [ $win.nb subwidget defPerms ]
}

proc drawEDDselectLocal { win } {
    global groupList userList groupListExeptDonts userListExeptDonts dontList setListNames
    global eddo_users eddo_groups
    global eddo_addEinl eddo_addTeiln eddo_addInfo
    global fnt bfnt _calText

    frame $win.b
    frame $win.u
    frame $win.g
    pack $win.b -side left
    pack $win.u -side left -padx 4
    pack $win.g -side left

    set eddo_addEinl  $win.b.addE
    set eddo_addTeiln $win.b.addG
    set eddo_addInfo  $win.b.addI
    button $eddo_addEinl  -command {addSelection E} -text "<- $_calText(addPartAsInvitor)" -font $fnt -width 15
    button $eddo_addTeiln -command {addSelection T} -text "<- $_calText(addPartAsPart)" -font $fnt -width 15
    button $eddo_addInfo  -command {addSelection i} -text "<- $_calText(addPartInfoOnly)" -font $fnt -width 15
    pack $eddo_addEinl $eddo_addTeiln $eddo_addInfo -side top -pady 12

    set eddo_users $win.u.b
    tixScrolledListBox $eddo_users -scrollbar auto -height 214 -width 168 -options {listbox.selectMode extended}
    $eddo_users subwidget vsb configure -width 12
    $eddo_users subwidget hsb configure -width 12
    $eddo_users subwidget listbox configure -font $fnt
    pack $eddo_users -fill x
    foreach user $userListExeptDonts { 
	$eddo_users subwidget listbox insert end  $user
    }

    set eddo_groups $win.g.b
    tixScrolledListBox $eddo_groups -scrollbar auto -height 214 -width 160 -options {listbox.selectMode extended}
    $eddo_groups subwidget listbox configure -font $fnt
    pack $eddo_groups -fill both
    foreach group $groupListExeptDonts { 
	$eddo_groups subwidget listbox insert end  $group 
    }
    $eddo_groups subwidget listbox insert end  "------------------------"
    foreach set   $setListNames { 
	set lab "Set $set"
	$eddo_groups subwidget listbox insert end  $lab
    }
    $eddo_groups subwidget vsb configure -width 12
    $eddo_groups subwidget hsb configure -width 12
}

proc drawEDDselectExtern { win } {
    global extList
    global eddo_extern
    global eddo_addExt
    global fnt bfnt _calText

    frame $win.b
    frame $win.e
    pack $win.b -side left
    pack $win.e -side left -padx 4

    set eddo_addExt   $win.b.addE
    button $eddo_addExt -command {addSelection A} -text  "<- $_calText(addPartAsPart)" -font $fnt
    pack  $eddo_addExt -side top -pady 10

    set eddo_extern $win.e.b
    tixScrolledListBox $eddo_extern -scrollbar auto -height 214 -width 320 -options {listbox.selectMode extended}
    $eddo_extern subwidget vsb configure -width 12
    $eddo_extern subwidget hsb configure -width 12
    $eddo_extern subwidget listbox configure -font $fnt
    pack $eddo_extern -fill both
    foreach user $extList { 
	$eddo_extern subwidget listbox insert end  $user
    }
}
proc drawEDDdefPerms { win } {
    global edd_defPerm_ELZ edd_defPerm_ELU edd_defPerm_ELT edd_defPerm_ELR 
    global edd_defPerm_ESZ edd_defPerm_ESU edd_defPerm_EST edd_defPerm_ESR
    global edd_defPerm_TLZ edd_defPerm_TLU edd_defPerm_TLT edd_defPerm_TLR 
    global edd_defPerm_TSZ edd_defPerm_TSU edd_defPerm_TST edd_defPerm_TSR
    global edd_defPerm_ALZ edd_defPerm_ALU edd_defPerm_ALT edd_defPerm_ALR 
    global edd_defPerm_ASZ edd_defPerm_ASU edd_defPerm_AST edd_defPerm_ASR
    global edd_defPerm_ILZ edd_defPerm_ILU edd_defPerm_ILT edd_defPerm_ILR 
    global edd_defPerm_ISZ edd_defPerm_ISU edd_defPerm_IST edd_defPerm_ISR
    global edd_defPerm_ED  edd_defPerm_TD  edd_defPerm_AD  edd_defPerm_ID  
    global up_defEinlPerm up_defTeilnPerm up_defInfoPerm up_defExtPerm
    global bfnt fnt bfnt12 fnt12
    global _calText _allgText _buttonText

    if { [ string range $up_defEinlPerm 0 0] != "-" } { set edd_defPerm_ELZ 1} else { set edd_defPerm_ELZ 0}
    if { [ string range $up_defEinlPerm 1 1] != "-" } { set edd_defPerm_ELU 1} else { set edd_defPerm_ELU 0}
    if { [ string range $up_defEinlPerm 2 2] != "-" } { set edd_defPerm_ELT 1} else { set edd_defPerm_ELT 0}
    if { [ string range $up_defEinlPerm 3 3] != "-" } { set edd_defPerm_ELR 1} else { set edd_defPerm_ELR 0}
    if { [ string range $up_defEinlPerm 4 4] != "-" } { set edd_defPerm_ESZ 1} else { set edd_defPerm_ESZ 0}
    if { [ string range $up_defEinlPerm 5 5] != "-" } { set edd_defPerm_ESU 1} else { set edd_defPerm_ESU 0}
    if { [ string range $up_defEinlPerm 6 6] != "-" } { set edd_defPerm_EST 1} else { set edd_defPerm_EST 0}
    if { [ string range $up_defEinlPerm 7 7] != "-" } { set edd_defPerm_ESR 1} else { set edd_defPerm_ESR 0}
    if { [ string range $up_defEinlPerm 8 8] != "-" } { set edd_defPerm_ED  1} else { set edd_defPerm_ED  0}

    if { [ string range $up_defTeilnPerm 0 0] != "-" } { set edd_defPerm_TLZ 1} else { set edd_defPerm_TLZ 0}
    if { [ string range $up_defTeilnPerm 1 1] != "-" } { set edd_defPerm_TLU 1} else { set edd_defPerm_TLU 0}
    if { [ string range $up_defTeilnPerm 2 2] != "-" } { set edd_defPerm_TLT 1} else { set edd_defPerm_TLT 0}
    if { [ string range $up_defTeilnPerm 3 3] != "-" } { set edd_defPerm_TLR 1} else { set edd_defPerm_TLR 0}
    if { [ string range $up_defTeilnPerm 4 4] != "-" } { set edd_defPerm_TSZ 1} else { set edd_defPerm_TSZ 0}
    if { [ string range $up_defTeilnPerm 5 5] != "-" } { set edd_defPerm_TSU 1} else { set edd_defPerm_TSU 0}
    if { [ string range $up_defTeilnPerm 6 6] != "-" } { set edd_defPerm_TST 1} else { set edd_defPerm_TST 0}
    if { [ string range $up_defTeilnPerm 7 7] != "-" } { set edd_defPerm_TSR 1} else { set edd_defPerm_TSR 0}
    if { [ string range $up_defTeilnPerm 8 8] != "-" } { set edd_defPerm_TD  1} else { set edd_defPerm_TD  0}

    if { [ string range $up_defExtPerm 0 0] != "-" } { set edd_defPerm_ALZ 1} else { set edd_defPerm_ALZ 0}
    if { [ string range $up_defExtPerm 1 1] != "-" } { set edd_defPerm_ALU 1} else { set edd_defPerm_ALU 0}
    if { [ string range $up_defExtPerm 2 2] != "-" } { set edd_defPerm_ALT 1} else { set edd_defPerm_ALT 0}
    if { [ string range $up_defExtPerm 3 3] != "-" } { set edd_defPerm_ALR 1} else { set edd_defPerm_ALR 0}
    if { [ string range $up_defExtPerm 4 4] != "-" } { set edd_defPerm_ASZ 1} else { set edd_defPerm_ASZ 0}
    if { [ string range $up_defExtPerm 5 5] != "-" } { set edd_defPerm_ASU 1} else { set edd_defPerm_ASU 0}
    if { [ string range $up_defExtPerm 6 6] != "-" } { set edd_defPerm_AST 1} else { set edd_defPerm_AST 0}
    if { [ string range $up_defExtPerm 7 7] != "-" } { set edd_defPerm_ASR 1} else { set edd_defPerm_ASR 0}
    set edd_defPerm_AD 0

    if { [ string range $up_defInfoPerm 0 0] != "-" } { set edd_defPerm_ILZ 1} else { set edd_defPerm_ILZ 0}
    if { [ string range $up_defInfoPerm 1 1] != "-" } { set edd_defPerm_ILU 1} else { set edd_defPerm_ILU 0}
    if { [ string range $up_defInfoPerm 2 2] != "-" } { set edd_defPerm_ILT 1} else { set edd_defPerm_ILT 0}
    if { [ string range $up_defInfoPerm 3 3] != "-" } { set edd_defPerm_ILR 1} else { set edd_defPerm_ILR 0}



    frame $win.t -relief raised -bd 1
    frame $win.b
    pack $win.t  -side top -fill x -ipady 0 -pady 0
    pack $win.b -side top -fill x -pady 2


    
    frame $win.t.1
    frame $win.t.2 
    frame $win.t.3 
    frame $win.t.4 
    frame $win.t.5
    pack $win.t.1 -side left -fill x
    pack $win.t.2 $win.t.3 $win.t.4   $win.t.5 -side left -fill x -padx 1 

    label $win.t.1.l -text "  "
    frame $win.t.1.c -relief flat -bd 2
    pack $win.t.1.l $win.t.1.c  -side top -padx 1 -pady 2
    label $win.t.2.l -text $_calText(typeInvite) -font $bfnt
    frame $win.t.2.c -relief ridge -bd 2
    pack  $win.t.2.l $win.t.2.c  -side top -padx 1 -pady 2
    label $win.t.3.l -text $_calText(typePart) -font $bfnt
    frame $win.t.3.c -relief ridge -bd 2
    pack  $win.t.3.l $win.t.3.c  -side top -padx 1 -pady 2
    label $win.t.4.l -text $_calText(typeExtern) -font $bfnt
    frame $win.t.4.c -relief ridge -bd 2
    pack  $win.t.4.l $win.t.4.c  -side top -padx 1 -pady 2
    label $win.t.5.l -text $_calText(typeInfoShort) -font $bfnt
    frame $win.t.5.c -relief ridge -bd 2
    pack  $win.t.5.l $win.t.5.c  -side top -padx 1 -pady 2
    
    frame  $win.t.1.c.0
    frame  $win.t.1.c.1
    frame  $win.t.1.c.2
    frame  $win.t.1.c.3
    frame  $win.t.1.c.4
    frame  $win.t.1.c.5
    pack $win.t.1.c.0 $win.t.1.c.1 $win.t.1.c.2 $win.t.1.c.3 $win.t.1.c.4 $win.t.1.c.5 -side top -fill x
    label $win.t.1.c.0.l -text "   "
    label $win.t.1.c.1.l -text $_calText(permCoords) -font $bfnt -width 14
    label $win.t.1.c.2.l -text $_calText(permTexts) -font $bfnt -width 14
    label $win.t.1.c.3.l -text $_calText(permParts) -font $bfnt -width 14
    label $win.t.1.c.4.l -text $_calText(permComments) -font $bfnt -width 14
    label $win.t.1.c.5.l -text $_calText(permDelete) -font $bfnt -width 14
    
    pack $win.t.1.c.0.l -side left -fill x -pady 3
    pack $win.t.1.c.1.l $win.t.1.c.2.l $win.t.1.c.3.l $win.t.1.c.4.l $win.t.1.c.5.l -side left -fill x -pady 6




    frame  $win.t.2.c.0
    frame  $win.t.2.c.1
    frame  $win.t.2.c.2
    frame  $win.t.2.c.3
    frame  $win.t.2.c.4
    frame  $win.t.2.c.5
    pack $win.t.2.c.0 $win.t.2.c.1 $win.t.2.c.2 $win.t.2.c.3 $win.t.2.c.4 $win.t.2.c.5 -side top -fill x
    label $win.t.2.c.0.l -text $_allgText(permRead) -font $bfnt12 -width 6
    label $win.t.2.c.0.s -text $_allgText(permModi) -font $bfnt12 -width 6
    checkbutton $win.t.2.c.1.l -variable edd_defPerm_ELZ
    checkbutton $win.t.2.c.2.l -variable edd_defPerm_ELU
    checkbutton $win.t.2.c.3.l -variable edd_defPerm_ELT
    checkbutton $win.t.2.c.4.l -variable edd_defPerm_ELR
    checkbutton $win.t.2.c.1.s -variable edd_defPerm_ESZ
    checkbutton $win.t.2.c.2.s -variable edd_defPerm_ESU
    checkbutton $win.t.2.c.3.s -variable edd_defPerm_EST
    checkbutton $win.t.2.c.4.s -variable edd_defPerm_ESR
    checkbutton $win.t.2.c.5.d -variable edd_defPerm_ED
    pack $win.t.2.c.0.l -side left  -fill x -pady 3 -padx 0
    pack $win.t.2.c.0.s -side right -fill x -pady 3 -padx 0
    pack $win.t.2.c.1.l $win.t.2.c.2.l $win.t.2.c.3.l $win.t.2.c.4.l -side left -fill x -pady 3 -padx 3
    pack $win.t.2.c.1.s $win.t.2.c.2.s $win.t.2.c.3.s $win.t.2.c.4.s -side right -fill x -pady 3
    pack $win.t.2.c.5.d -side top -pady 3

    frame  $win.t.3.c.0
    frame  $win.t.3.c.1
    frame  $win.t.3.c.2
    frame  $win.t.3.c.3
    frame  $win.t.3.c.4
    frame  $win.t.3.c.5
    pack $win.t.3.c.0 $win.t.3.c.1 $win.t.3.c.2 $win.t.3.c.3 $win.t.3.c.4 $win.t.3.c.5 -side top -fill x
    label $win.t.3.c.0.l -text $_allgText(permRead) -font $bfnt12 -width 6
    label $win.t.3.c.0.s -text $_allgText(permModi) -font $bfnt12 -width 6
    checkbutton $win.t.3.c.1.l -variable edd_defPerm_TLZ
    checkbutton $win.t.3.c.2.l -variable edd_defPerm_TLU
    checkbutton $win.t.3.c.3.l -variable edd_defPerm_TLT
    checkbutton $win.t.3.c.4.l -variable edd_defPerm_TLR
    checkbutton $win.t.3.c.1.s -variable edd_defPerm_TSZ
    checkbutton $win.t.3.c.2.s -variable edd_defPerm_TSU
    checkbutton $win.t.3.c.3.s -variable edd_defPerm_TST
    checkbutton $win.t.3.c.4.s -variable edd_defPerm_TSR
    checkbutton $win.t.3.c.5.d -variable edd_defPerm_TD
    pack $win.t.3.c.0.l -side left  -fill x -pady 3 -padx 0
    pack $win.t.3.c.0.s -side right -fill x -pady 3 -padx 0
    pack $win.t.3.c.1.l $win.t.3.c.2.l $win.t.3.c.3.l $win.t.3.c.4.l -side left -fill x -pady 3 -padx 3
    pack $win.t.3.c.1.s $win.t.3.c.2.s $win.t.3.c.3.s $win.t.3.c.4.s -side right -fill x -pady 3
    pack $win.t.3.c.5.d -side top  -pady 3

    frame  $win.t.4.c.0
    frame  $win.t.4.c.1
    frame  $win.t.4.c.2
    frame  $win.t.4.c.3
    frame  $win.t.4.c.4
    frame  $win.t.4.c.5
    pack $win.t.4.c.0 $win.t.4.c.1 $win.t.4.c.2 $win.t.4.c.3 $win.t.4.c.4 $win.t.4.c.5 -side top -fill x
    label $win.t.4.c.0.l -text $_allgText(permRead) -font $bfnt12 -width 6
    label $win.t.4.c.0.s -text $_allgText(permModi) -font $bfnt12 -width 6
    checkbutton $win.t.4.c.1.l -variable edd_defPerm_ALZ
    checkbutton $win.t.4.c.2.l -variable edd_defPerm_ALU
    checkbutton $win.t.4.c.3.l -variable edd_defPerm_ALT
    checkbutton $win.t.4.c.4.l -variable edd_defPerm_ALR
    checkbutton $win.t.4.c.1.s -variable edd_defPerm_ASZ
    checkbutton $win.t.4.c.2.s -variable edd_defPerm_ASU
    checkbutton $win.t.4.c.3.s -variable edd_defPerm_AST
    checkbutton $win.t.4.c.4.s -variable edd_defPerm_ASR
    label $win.t.4.c.5.d  -text " "
    set edd_defPerm_AD 0
    pack $win.t.4.c.0.l -side left  -fill x -pady 3 -padx 0
    pack $win.t.4.c.0.s -side right -fill x -pady 3 -padx 0
    pack $win.t.4.c.1.l $win.t.4.c.2.l $win.t.4.c.3.l $win.t.4.c.4.l -side left -fill x -pady 3 -padx 3
    pack $win.t.4.c.1.s $win.t.4.c.2.s $win.t.4.c.3.s $win.t.4.c.4.s -side right -fill x -pady 3
    pack $win.t.4.c.5.d -side top -pady 5

    frame  $win.t.5.c.0
    frame  $win.t.5.c.1
    frame  $win.t.5.c.2
    frame  $win.t.5.c.3
    frame  $win.t.5.c.4
    frame  $win.t.5.c.5
    pack $win.t.5.c.0 $win.t.5.c.1 $win.t.5.c.2 $win.t.5.c.3 $win.t.5.c.4 $win.t.5.c.5 -side top -fill x -padx 3
    label $win.t.5.c.0.l -text $_allgText(permRead) -font $bfnt12 -width 6
    checkbutton $win.t.5.c.1.l -variable edd_defPerm_ILZ -text "  "
    checkbutton $win.t.5.c.2.l -variable edd_defPerm_ILU -text "  "
    checkbutton $win.t.5.c.3.l -variable edd_defPerm_ILT -text "  "
    checkbutton $win.t.5.c.4.l -variable edd_defPerm_ILR -text "  "
    label $win.t.5.c.5.d  -text " "
    set edd_defPerm_ISZ 0
    set edd_defPerm_ISU 0 
    set edd_defPerm_IST 0
    set edd_defPerm_ISR 0
    set edd_defPerm_ID 0
    pack $win.t.5.c.0.l  -side left -fill x -padx 2 -pady 1
    pack $win.t.5.c.1.l $win.t.5.c.2.l $win.t.5.c.3.l $win.t.5.c.4.l -side right -fill x -pady 3
    pack $win.t.5.c.5.d -side top -pady 5

    button $win.b.ok -text $_buttonText(Apply) -command {acceptPerms -}
    button $win.b.save  -text "$_buttonText(Apply) & $_buttonText(Save)" -command {acceptPerms s}
    pack $win.b.ok $win.b.save -side right -padx 5
}
proc acceptPerms { mode } {
    global edd_defPerm_ELZ edd_defPerm_ELU edd_defPerm_ELT edd_defPerm_ELR 
    global edd_defPerm_ESZ edd_defPerm_ESU edd_defPerm_EST edd_defPerm_ESR
    global edd_defPerm_TLZ edd_defPerm_TLU edd_defPerm_TLT edd_defPerm_TLR 
    global edd_defPerm_TSZ edd_defPerm_TSU edd_defPerm_TST edd_defPerm_TSR
    global edd_defPerm_ALZ edd_defPerm_ALU edd_defPerm_ALT edd_defPerm_ALR 
    global edd_defPerm_ASZ edd_defPerm_ASU edd_defPerm_AST edd_defPerm_ASR
    global edd_defPerm_ILZ edd_defPerm_ILU edd_defPerm_ILT edd_defPerm_ILR 
    global edd_defPerm_ISZ edd_defPerm_ISU edd_defPerm_IST edd_defPerm_ISR
    global edd_defPerm_ED  edd_defPerm_TD  edd_defPerm_AD  edd_defPerm_ID  
    global up_defEinlPerm up_defTeilnPerm up_defInfoPerm up_defExtPerm


    set up_defEinlPerm  [ rlist2str "$edd_defPerm_ELZ $edd_defPerm_ELU $edd_defPerm_ELT $edd_defPerm_ELR $edd_defPerm_ESZ $edd_defPerm_ESU $edd_defPerm_EST $edd_defPerm_ESR $edd_defPerm_ED" ]
    set up_defTeilnPerm [ rlist2str "$edd_defPerm_TLZ $edd_defPerm_TLU $edd_defPerm_TLT $edd_defPerm_TLR $edd_defPerm_TSZ $edd_defPerm_TSU $edd_defPerm_TST $edd_defPerm_TSR $edd_defPerm_TD" ]
    set up_defExtPerm   [ rlist2str "$edd_defPerm_ALZ $edd_defPerm_ALU $edd_defPerm_ALT $edd_defPerm_ALR $edd_defPerm_ASZ $edd_defPerm_ASU $edd_defPerm_AST $edd_defPerm_ASR $edd_defPerm_AD" ]
    set up_defInfoPerm [ rlist2str "$edd_defPerm_ILZ $edd_defPerm_ILU $edd_defPerm_ILT $edd_defPerm_ILR $edd_defPerm_ISZ $edd_defPerm_ISU $edd_defPerm_IST $edd_defPerm_ISR $edd_defPerm_ID" ]
    if {$mode == "s"} { writeUserPrefs}
}

proc rlist2str { list } {
    global datePermRefStr

    set clist [split $datePermRefStr {} ]
    set pstr ""
    for {set i 0 } { $i<9} { incr i} {
	if { [lindex $list $i] == 1 } { 
	    set c [lindex $clist $i ]
	} else  {
	    set c "-"
	}
	set pstr "$pstr$c"
    }
    return  $pstr
}

proc addSelection { type } {
    global eddo_users eddo_groups edd_currUserPerm  eddo_extern
    global groupList userList groupListExeptDonts userListExeptDonts edd_part edd_part_quick extList
    global up_defEinlPerm up_defTeilnPerm up_defInfoPerm up_defExtPerm
    global edd_teilnChange curr_perms
    global setList setListNames dontList

    set edd_teilnChange 1
    set selection  [$eddo_users subwidget listbox curselection]
    set newTeiln ""
    foreach sel $selection {
	set user [lindex $userListExeptDonts $sel]
	if { [lsearch $edd_part_quick $user] <0} {
	    switch $type {
		E { set perm $up_defEinlPerm}
		T { set perm $up_defTeilnPerm}
		A { set perm $up_defExtPerm}
		i { set perm $up_defInfoPerm}
		* { set perm $up_defTeilnPerm}
	    }
	    set ent [format "$type $user  UKN - $perm {%s} u" [ getFullUserName $user u]]
	    lappend edd_part $ent
	}
    }
    set selection  [$eddo_groups subwidget listbox curselection]
    set groupAnz [llength $groupListExeptDonts]
    foreach sel $selection {
	switch $type {
	    E { set perm $up_defEinlPerm}
	    T { set perm $up_defTeilnPerm}
	    A { set perm $up_defExtPerm}
	    i { set perm $up_defInfoPerm}
	    * { set perm $up_defTeilnPerm}
	}
	if { $sel < $groupAnz } {
	    set group [lindex $groupListExeptDonts $sel]
	    if { [lsearch $edd_part_quick $group] <0} {
		set ent "$type $group  UKN - $perm {Gruppe $group} g"
		lappend edd_part $ent
	    }
	} elseif { $sel > $groupAnz } {
	    set snam [lindex $setListNames [expr $sel- $groupAnz -1 ] ]
#  	    puts "adding Set $snam"
	    foreach usr $setList($snam) {
		set user [string range $usr 2 end]
#		puts "checking for $usr -> $user"
		if { [lsearch $edd_part_quick $usr] <0} {
		    if { $dontList($usr) == 0 } {
			set ent [format "$type $user  UKN - $perm {%s} u"   [ getFullUserName $user u]]
			lappend edd_part $ent
		    }
		}
		
	    }
	}
    }

     set selection  [$eddo_extern subwidget listbox curselection]
     foreach sel $selection {
 	set user [lindex $extList $sel]
 	if { [lsearch $edd_part_quick $user] <0} {
 	    switch $type {
 		E { set perm $up_defEinlPerm}
 		T { set perm $up_defTeilnPerm}
 		A { set perm $up_defExtPerm}
 		i { set perm $up_defInfoPerm}
 		* { set perm $up_defTeilnPerm}
 	    }
 	    set ent "$type {$user}  UKN - $perm {$user} a"
 	    lappend edd_part $ent
 	}
     }
   
    if { $curr_perms(rt) == 1} {
	fillTeiln 
    }
    updateReminderUser
}

proc drawEDDtimeTable { win } {
    global eddo_tt  eddo_tt_list


    set eddo_tt $win.c
    canvas $eddo_tt -width 470 -height 223
    pack $eddo_tt -side left 
    set eddo_tt_list ""
    __drawEDDtimeTable
}
proc redrawEDDtimeTable {  } {
    global eddo_tt 

    $eddo_tt delete all
    __drawEDDtimeTable
    fillTimeTable
}

proc __drawEDDtimeTable { } {
    global eddo_tt 
    global eddv_day eddv_mon eddv_year
    global  eddtt_x0 eddtt_y0 eddtt_dx eddtt_dy
    global tt_wList tt_startDay tt_stopDay


    set wt "Mo Di Mi Do Fr Sa So"

    set day   $eddv_day
    set mon   $eddv_mon
    set year $eddv_year

    set ret [ calcDate $eddv_day $eddv_mon $eddv_year 6 ]
    set tt_startDay [ format "%4d%02d%02d" $eddv_year $eddv_mon $eddv_day ]
    set tt_stopDay [ format "%4d%02d%02d" [lindex $ret 2] [lindex $ret 1] [lindex $ret 0] ]
    set tt_wList "$tt_startDay "
    for { set i 1} {$i<7} {incr i} {
	set ret [ calcDate $eddv_day $eddv_mon $eddv_year $i ]
	lappend tt_wList [ format "%4d%02d%02d" [lindex $ret 2] [lindex $ret 1] [lindex $ret 0] ]
    }


    set eddtt_x0 40
    set eddtt_dx 56
    set eddtt_y0 30
    set eddtt_dy  8
    set dx05 [expr $eddtt_dx/2]

    $eddo_tt create rectangle 0 0 470 223 -fill grey95 -outline grey95
    $eddo_tt create rectangle 1 1 470 223 -fill grey95 -outline grey25

    for {set i 0} { $i <8 } { incr i} {
	set x [ expr $eddtt_x0 +$eddtt_dx*$i]
	$eddo_tt create line $x 0 $x 221
	set x [ expr $eddtt_x0 +$dx05 +$eddtt_dx*$i]
	if { $i<7 } {
	    $eddo_tt create text $x 16 -anchor n -justify center -text [ format "%2d.%2d.%02d"  $day $mon [expr $year %100] ] 
	    $eddo_tt create text $x 3 -anchor n -justify center -text [lindex $wt [weekDayByDate $day $mon $year]]
	    set ret  [ calcDate $day $mon $year 1 ]
	    set day  [ lindex $ret 0]
	    set mon  [ lindex $ret 1]
	    set year [ lindex $ret 2]
	}
    }

    set fnt -b&h-lucidatypewriter-bold-r-*-*-14-*-*-*-*-*-*-*
    rButton $eddo_tt 4 3 38 15 TTweekBackB
    rButton $eddo_tt 4 16 38 28 TTweekForwB
    rButton $eddo_tt 434 3 469 15 TTdayBackB
    rButton $eddo_tt 434 16 469 28 TTdayForwB

    $eddo_tt create text 16 14 -text "   <<  " -anchor n -justify left -font  $fnt -tag TTweekBack
    $eddo_tt create text 448 14 -text "   >>  " -anchor n -justify left -font  $fnt -tag TTweekForw
    $eddo_tt create text 16 1 -text "   <  " -anchor n -justify left -font $fnt -tag TTdayBack
    $eddo_tt create text 448 1 -text "   >  " -anchor n -justify left -font $fnt -tag TTdayForw
    $eddo_tt bind TTweekBack  <ButtonPress> {changeTimeTable -7}
    $eddo_tt bind TTweekForw  <ButtonPress> {changeTimeTable 7}
    $eddo_tt bind TTdayBack   <ButtonPress> {changeTimeTable -1}
    $eddo_tt bind TTdayForw   <ButtonPress> {changeTimeTable 1}
    $eddo_tt bind TTweekBackB <ButtonPress> {changeTimeTable -7}
    $eddo_tt bind TTweekForwB <ButtonPress> {changeTimeTable 7}
    $eddo_tt bind TTdayBackB  <ButtonPress> {changeTimeTable -1}
    $eddo_tt bind TTdayForwB  <ButtonPress> {changeTimeTable 1}
    
    for { set i 0} { $i<=24} {incr i 2} {
	set y [ expr $eddtt_y0 + $eddtt_dy*$i]
	$eddo_tt create line 0  $y 470 $y
	set y [ expr $eddtt_y0 + $eddtt_dy+ $eddtt_dy*$i]
	$eddo_tt create line 40 $y 431 $y
	if { $i>0 } {
	    set y [ expr 30+$i*8 +2]
	    $eddo_tt create text 6 $y -text [format "%2d:00" $i] -anchor sw
	    $eddo_tt create text 434 $y -text [format "%2d:00" $i] -anchor sw
	}
    }
}

proc rButton { win x0 y0 x1 y1 tag} {


    set fc grey80
    set uc white
    set lc grey40
    $win create rectangle $x0 $y0 $x1 $y1 -fill $fc -outline $fc -tag $tag
    $win create line $x0 $y1 $x0 $y0 -fill $uc
    $win create line $x0 $y0 $x1 $y0 -fill $uc
    $win create line $x0 $y1 $x1 $y1  -fill $lc
    $win create line $x1 $y1 $x1 $y0 -fill $lc
    
    incr x0
    incr y0
    incr x1 -1
    incr y1 -1
    $win create line $x0 $y1 $x0 $y0 -fill $uc
    $win create line $x0 $y0 $x1 $y0 -fill $uc
    $win create line $x0 $y1 $x1 $y1  -fill $lc
    $win create line $x1 $y1 $x1 $y0 -fill $lc
}
proc changeTimeTable { step } {
    global eddv_day eddv_mon eddv_year eddo_tt_list
    set ret  [ calcDate $eddv_day $eddv_mon $eddv_year $step ]
    set eddv_day  [ lindex $ret 0]
    set eddv_mon  [ lindex $ret 1]
    set eddv_year [ lindex $ret 2]


    redrawEDDtimeTable
}

proc setTTdirty { val } {
    global eddv_TTdirty
    set eddv_TTdirty 1
}
proc updateTTcurDate { val } {
    fillTimeTableCurDate
}

proc updateTT { val } {
    fillTimeTableDelayed
}


proc fillAll_1st { } {
    global  eddo_abb eddo_ok
    global edd_repStopD  edd_repStopM  edd_repStopY
    global eddo_repStopD 
    fillTitel
    fillTimes
    fillRepeats
    fillReminder
    .edd.e.nb pageconfigure times  -state normal
    $eddo_abb configure -state normal
#    puts "RepeatStop: => $edd_repStopD $edd_repStopM $edd_repStopY // [$eddo_repStopD cget -value]"
#    unLock
    fillRest
#    puts "RepeatStop: => $edd_repStopD $edd_repStopM $edd_repStopY // [$eddo_repStopD cget -value]"
    .edd.e.nb pageconfigure  details -state normal
    fillTeiln
    .edd.e.nb pageconfigure part  -state normal
    $eddo_ok configure -state normal
#    puts "RepeatStop: => $edd_repStopD $edd_repStopM $edd_repStopY // [$eddo_repStopD cget -value]"
    
}

proc fillTimeTable { } {
    global edd_part
    global eddv_day eddv_mon eddv_year
    global eddtt_x0 eddtt_y0 eddtt_dx eddtt_dy eddo_tt eddo_tt_list
    global edd_teilnChange  edd_TTdateList
    global edd_startDy edd_startDm edd_startDd edd_startTh edd_startTm 
    global edd_stopDy edd_stopDm edd_stopDd edd_stopTh edd_stopTm 
    global edd_room
    global TTcacheTime TTcacheUser TTcache TTcacheCtime
    global tt_wList tt_startDay tt_stopDay
    global isLock
    global edd_fttid edd_did
    global eddv_TTdirty

    set eddv_TTdirty 0
    if { [winfo exists .edd ] == 0 } { return}
    
    set  edd_fttid -2

    if { [llength $eddo_tt_list] > 0}  {
	foreach tag $eddo_tt_list { $eddo_tt delete $tag}
	set eddo_tt_list ""
	update
    }

    set updateCache 0
    if { [lindex $TTcacheTime 0] != $tt_startDay || [lindex $TTcacheTime 1] != $tt_stopDay } {
	set updateCache 1
	set TTcacheTime "$tt_startDay $tt_stopDay"
	set TTcacheCtime [ request lastChangeDate ]
	if { $TTcacheCtime == "Error" } { return }
# 	if { [string first $TTcacheCtime "ServerDown"] >=0 } {ServerDownDialog}
    }

    set tim [ request lastChangeDate ]
    if { $tim == "Error" } { return }
#    if { [string first $tim "ServerDown"] >=0 } {ServerDownDialog}
    if { $TTcacheCtime < $tim} { 
	set updateCache 1 
    }    
    if { $updateCache == 1} { 
	set TTcacheUser "" 
    }

#Cache auffllen
    set uList ""
    set ustrList  ""
    foreach part $edd_part {
	
	set ustr [format "%s-%s" [lindex $part 0] [lindex $part 1] ]
	if { [ lsearch $TTcacheUser $ustr] <0 } {
	    set str [format "%s {%s}" [lindex $part 6] [lindex $part 1]]
	    set uList "$uList $str"
	    lappend ustrList $ustr
	}
    }
    set ustr [format "r-%s" $edd_room ]
    if { [ lsearch $TTcacheUser $ustr] <0 } {
	set str [format "r {%s}" $edd_room]
	set uList "$uList $str"
	lappend ustrList $ustr
    }

    if { [llength  $uList] >1 } {
	set dates [request getBlockedTimes $edd_did $tt_startDay $tt_stopDay $uList]
	if { $dates == "Error" } { return }
#	if { [string first $dates "ServerDown"] >=0 } {ServerDownDialog}
    }
    for {set i 0 } { $i < [ llength $ustrList] } {incr i } {
	set ustr [lindex $ustrList $i ]
	lappend TTcacheUser $ustr
	set TTcache($ustr) [format "%s {%s}" [string range $ustr 0 0 ] [ lindex $dates $i ]]
	lappend edd_TTdateList $TTcache($ustr)
    }
    
#Cache auslesen
    set edd_TTdateList ""
    foreach part $edd_part {
	set ustr [format "%s-%s" [lindex $part 0] [lindex $part 1] ]
	lappend edd_TTdateList $TTcache($ustr)
    }
    set ustr [format "r-%s" $edd_room ]
    lappend edd_TTdateList $TTcache($ustr)


#TieTabel zeichenn    
    foreach val $edd_TTdateList {
	set type [lindex $val 0]
	set dates [lindex $val 1]

	foreach date  $dates {
	    set startD [lindex $date 0]
	    set startT [lindex $date 1]
	    set stopD  [lindex $date 2]
	    set stopT  [lindex $date 3]

	    set day0 [ lsearch $tt_wList $startD]
	    set day1 [ lsearch $tt_wList $stopD]

	    if {$day0<0} {set day0 0}
	    if {$day1>6} {set day1 6}

	    for {set day $day0} {$day<=$day1} {incr day} {
		if { [lindex $tt_wList $day] == $startD} {
		    set t0 $startT
		} else {
		    set t0 0
		}
		if { [lindex $tt_wList $day] == $stopD} {
		    set t1 $stopT
		} else {
		    set t1 2359
		}
		
		switch $type {
		    I {	drawDate2TT  $day $t0 $t1 red        0  f }
		    E {	drawDate2TT  $day $t0 $t1 DarkOrange 1  f }
		    T {	drawDate2TT  $day $t0 $t1 green4     2  f }
		    r {	drawDate2TT  $day $t0 $t1 brown      3  f }
		}
	    }
	}
    }
    for { set i 0} { $i<=24} {incr i 2} {
	set y [ expr $eddtt_y0 + $eddtt_dy*$i]
	$eddo_tt create line 40  $y 431 $y
	set y [ expr $eddtt_y0 + $eddtt_dy+ $eddtt_dy*$i]
	$eddo_tt create line 40 $y 431 $y
    }
    fillTimeTableCurDate
#    if { $selfLocked ==1} { unLock }
}
proc fillTimeTableCurDate { } {
    global edd_part
    global eddtt_x0 eddtt_y0 eddtt_dx eddtt_dy eddo_tt eddo_tt_list
    global edd_startDy edd_startDm edd_startDd edd_startTh edd_startTm 
    global edd_stopDy edd_stopDm edd_stopDd edd_stopTh edd_stopTm 
    global tt_wList tt_startDay tt_stopDay
    global eddv_dateMoveTyp

    $eddo_tt delete currDateTag

    set eddv_dateMoveTyp ""
    set startD [format "%4d%02d%02d" $edd_startDy $edd_startDm $edd_startDd ]
    set stopD [format "%4d%02d%02d" $edd_stopDy $edd_stopDm $edd_stopDd ]
    if { $stopD > [lindex $tt_wList 0] } {
	if { $startD < [lindex $tt_wList 6] } {
	
	    if { $startD < [lindex $tt_wList 0] } {
		set day0 0
		set min0 0
	    } else {
		set day0 [ lsearch $tt_wList $startD]
		set min0 [ expr $edd_startTh*60+$edd_startTm ]
	    }
	    if { $stopD > [lindex $tt_wList 6] } {
		set day1 6
		set min1 1439
	    } else {
		set day1 [ lsearch $tt_wList $stopD]
		set min1 [ expr $edd_stopTh*60+$edd_stopTm ]
	    }
	    set x0 [expr $eddtt_x0 +$day0*$eddtt_dx +2]
	    set x1 [expr $eddtt_x0 +$day0*$eddtt_dx +$eddtt_dx -1 ]
	    set y0 [expr $eddtt_y0 + int(floor(double($min0)/60 * $eddtt_dy)) ]
	    set y1 [expr $eddtt_y0 + int(ceil(double($min1)/60 * $eddtt_dy)) ]
	    
	    $eddo_tt create line $x0 $y0 $x1 $y0 -fill blue -width 2 -tag "currDateTag tt_chBeg" 
	    $eddo_tt create line $x1 $y0 $x1 $y1 -fill blue -width 2 -tag "currDateTag tt_moveR" 
	    $eddo_tt create line $x1 $y1 $x0 $y1 -fill blue -width 2 -tag "currDateTag tt_chEnd" 
	    $eddo_tt create line $x0 $y1 $x0 $y0 -fill blue -width 2 -tag "currDateTag tt_moveL" 
	    $eddo_tt bind currDateTag <Enter> {$eddo_tt configure -cursor hand2 }
	    $eddo_tt bind currDateTag <Leave> {$eddo_tt configure -cursor left_ptr}
	    $eddo_tt bind tt_chEnd <ButtonPress> {set eddv_dateMoveTyp "ce" }
	    $eddo_tt bind tt_chBeg <ButtonPress> {set eddv_dateMoveTyp "cb" }
	    $eddo_tt bind tt_moveR <ButtonPress> {
		set eddv_dateMoveTyp "mr" 
		setMoveStartDateOffset %x %y
	    }
	    $eddo_tt bind tt_moveL <ButtonPress> {
		set eddv_dateMoveTyp "ml" 
		setMoveStartDateOffset %x %y
	    }
	    bind $eddo_tt <Leave> { set eddv_dateMoveTyp "" }
	    bind $eddo_tt <ButtonRelease> { setCursorDate2Date %x %y}
	}
    }
}
proc setMoveStartDateOffset { x y } {
    global eddtt_x0 eddtt_dx eddtt_y0 eddtt_dy tt_wList eddv_dateMoveTyp
    global edd_startTh edd_startTm edd_stopTh edd_stopTm
    global eddv_mdoff1 eddv_mdoff2 eddv_mdrefDay

    set eddv_mdrefDay [ expr int(floor( double($x-$eddtt_x0)/double($eddtt_dx))) ]
    set m  [ expr int(floor( double($y-$eddtt_y0)/double($eddtt_dy) *60.)) ]
    set min [expr ($m % 60)]
    set h   [ expr ($m -$min)/60 ]

    set m0 [ expr $edd_startTh*60+ $edd_startTm]
    set m1 [ expr $edd_stopTh *60+ $edd_stopTm]
    set m  [ expr $h*60+ $min]
    set eddv_mdoff1 [expr $m -$m0]
    set eddv_mdoff2 [expr $m1-$m]
}
proc setCursorDate2Date {x y } {
    global eddtt_x0 eddtt_dx eddtt_y0 eddtt_dy tt_wList eddv_dateMoveTyp
    global edd_startTh edd_startTm edd_stopTh edd_stopTm
    global eddv_mdoff1 eddv_mdoff2 eddv_mdrefDay
    global edd_startDy edd_startDm edd_startDd edd_stopDy edd_stopDm edd_stopDd


    set di [ expr int(floor( double($x-$eddtt_x0)/double($eddtt_dx))) ]
    set m  [ expr int(floor( double($y-$eddtt_y0)/double($eddtt_dy) *60.)) ]
    set min [expr ($m % 60)]
    set h   [ expr ($m -$min)/60 ]
    set min [ expr int(5*round(double($min)/5.)) ]
    if {$h<0} {
	set h 0
	set min 0
    }
    if {$h >23 } {
	set h 24
	set min 0
    }

    if { $eddv_dateMoveTyp == "ce" } {
	set edd_stopTh $h
	set edd_stopTm $min
    }
    if { $eddv_dateMoveTyp == "cb" } {
	set edd_startTh $h
	set edd_startTm $min
    }

    if { $eddv_dateMoveTyp == "mr" || $eddv_dateMoveTyp == "ml"} {
	set m0 [ expr $m -$eddv_mdoff1 ]
	set m1 [ expr $m +$eddv_mdoff2 ]
	set edd_startTm [ expr  ($m0 % 60)]
	set edd_startTh [ expr (($m0 -$edd_startTm) / 60)]
	set edd_startTm [expr int(5*round(double($edd_startTm)/5.)) ]
	set edd_stopTm  [ expr  ($m1 % 60)]
	set edd_stopTh  [ expr (($m1 -$edd_stopTm) / 60)]
	set edd_stopTm  [expr int(5*round(double($edd_stopTm)/5.)) ]

	set startD [format "%4d%02d%02d" $edd_startDy $edd_startDm $edd_startDd ]
	set stopD [format "%4d%02d%02d" $edd_stopDy $edd_stopDm $edd_stopDd ]

	set dshift [ expr $di - $eddv_mdrefDay ]
	set d0 [expr [ lsearch  $tt_wList $startD] +$dshift ]
	set d1 [expr [ lsearch  $tt_wList $stopD ] +$dshift ]
#	puts [ lsearch  tt_wList $startD]

	set startD [lindex $tt_wList $d0 ]
	set stopD [lindex $tt_wList $d1 ]
	set edd_startDy [expr $startD /10000 ]
	set edd_startDm [expr ($startD /100) % 100 ]
	set edd_startDd [expr $startD %100 ]
	set edd_stopDy [expr $stopD /10000 ]
	set edd_stopDm [expr ($stopD /100) % 100 ]
	set edd_stopDd [expr $stopD %100 ]

    }
    set eddv_dateMoveTyp "" 
    updateTTcurDate 0
}

proc box { can x0 y0 x1 y1 color tag } {
    $can create line $x0 $y0 $x1 $y0 -fill $color -width 2 -tag $tag
    $can create line $x1 $y0 $x1 $y1 -fill $color -width 2 -tag $tag
    $can create line $x1 $y1 $x0 $y1 -fill $color -width 2 -tag $tag
    $can create line $x0 $y1 $x0 $y0 -fill $color -width 2 -tag $tag
}
proc drawDate2TT { day start stop color l stat } {
    global  eddtt_x0 eddtt_y0 eddtt_dx eddtt_dy eddo_tt eddo_tt_list

    if { [winfo exists $eddo_tt] } {

	set dx [expr $eddtt_dx -2 ]
	
	set t0 [ expr floor(double($start)/100) + double($start%100)/60]
	set t1 [ expr floor(double($stop) /100) + double($start%100)/60.]
	
	set x0 [expr $eddtt_x0 +$day *$eddtt_dx +$l*$dx/4  +3]
	set x1 [expr $eddtt_x0 +$day *$eddtt_dx +($l+1)*$dx/4 ]
	set y0 [expr $eddtt_y0 + int(floor($t0 * $eddtt_dy)) ]
	set y1 [expr $eddtt_y0 + int(ceil($t1 * $eddtt_dy)) ]
	
	if { $stat == "f" } {
	    $eddo_tt create rectangle $x0 $y0 $x1 $y1 -fill $color -outline $color -tag tt
	} else {
	    box $eddo_tt $x0 $y0 $x1 $y1 $color tt
	}
	lappend eddo_tt_list tt
    }
}

proc fillTimes { } {
    global eddo_startDy eddo_startDm eddo_startDd eddo_startTh eddo_startTm eddo_startCl
    global eddo_stopDy eddo_stopDm eddo_stopDd eddo_stopTh eddo_stopTm eddo_stopCl
    global edd_startDy edd_startDm edd_startDd edd_startTh edd_startTm 
    global edd_stopDy edd_stopDm edd_stopDd edd_stopTh edd_stopTm 
    global curr_perms
    global eddo_room eddo_room2 edd_room
    global eddo_noTime edd_noTime
    global eddo_nonBlock edd_nonBlock
    global edd_shiftCount edd_repEna


    if { $curr_perms(rz) == 1} {
	$eddo_startDd configure -state normal
	$eddo_startDm configure -state normal
	$eddo_startDy configure -state normal
	$eddo_startCl configure -state normal
	$eddo_startTh configure -state normal
	$eddo_startTm configure -state normal

	$eddo_stopDd configure -state normal
	$eddo_stopDm configure -state normal
	$eddo_stopDy configure -state normal
	$eddo_stopCl configure -state normal
	$eddo_stopTh configure -state normal
	$eddo_stopTm configure -state normal

	$eddo_startDd configure -variable edd_startDd
	$eddo_startDm configure -variable edd_startDm
	$eddo_startDy configure -variable edd_startDy
	$eddo_startTh configure -variable edd_startTh
	$eddo_startTm configure -variable edd_startTm

 	$eddo_stopDd configure -variable edd_stopDd
	$eddo_stopDm configure -variable edd_stopDm
	$eddo_stopDy configure -variable edd_stopDy
	$eddo_stopTh configure -variable edd_stopTh
	$eddo_stopTm configure -variable edd_stopTm
	
	$eddo_room  configure -state normal
 	$eddo_room  configure -variable edd_room
	$eddo_room2 configure -state normal
 	$eddo_room2 configure -variable edd_room

	$eddo_noTime configure -state normal
	$eddo_noTime configure -variable edd_noTime
	$eddo_noTime configure -command toggleTimes
	$eddo_nonBlock configure -state normal
	$eddo_nonBlock configure -variable edd_nonBlock
	update

    }
    if { $curr_perms(wz) == 0 } {
	$eddo_startDd configure -state disabled
	$eddo_startDm configure -state disabled
	$eddo_startDy configure -state disabled
	$eddo_startCl configure -state disabled
	$eddo_startTh configure -state disabled
	$eddo_startTm configure -state disabled
	
	$eddo_stopDd configure -state disabled
	$eddo_stopDm configure -state disabled
	$eddo_stopDy configure -state disabled
	$eddo_stopCl configure -state disabled
	$eddo_stopTh configure -state disabled
	$eddo_stopTm configure -state disabled

	$eddo_room  configure -state disabled
	$eddo_room2 configure -state disabled
	$eddo_noTime configure -state disabled
	$eddo_nonBlock configure -state disabled
    }
	update

    if { $edd_shiftCount >0 && $edd_repEna == 1} {
	$eddo_startDd configure -state disabled
	$eddo_startDm configure -state disabled
	$eddo_startDy configure -state disabled
	$eddo_startCl configure -state disabled
	$eddo_startTh configure -state disabled
	$eddo_startTm configure -state disabled
    }
    toggleTimes
} 
proc toggleTimes { } {
    global edd_noTime  eddo_startTh eddo_startTm eddo_stopTh eddo_stopTm
    global curr_perms edd_shiftCount edd_repEna 

    if { $edd_noTime == 1} {
	$eddo_startTh configure -state disabled
	$eddo_startTm configure -state disabled
	$eddo_stopTh configure -state disabled
	$eddo_stopTm configure -state disabled
    } else {
	if { $curr_perms(wz) == 1 } {
	    if {$edd_shiftCount >0 && $edd_repEna == 1} {
		$eddo_startTh configure -state disabled
		$eddo_startTm configure -state disabled
	    } else {
		$eddo_startTh configure -state normal
		$eddo_startTm configure -state normal
	    }
	    $eddo_stopTh configure -state normal
	    $eddo_stopTm configure -state normal
	}
    }
}
proc fillTitel {  } {
    global edd_titel eddo_titel edd_editTyp curr_perms
    global eddo_detail edd_detail
    
    if { $curr_perms(r) ==1} {
	$eddo_detail subwidget text configure -state normal
	$eddo_detail subwidget text delete 0.0 end
	$eddo_detail subwidget text insert end $edd_detail

	$eddo_titel configure -textvariable edd_titel
	$eddo_titel configure -state normal
	wm title .edd [format "%s : %s" $edd_editTyp $edd_titel ]
    } 
    if {  $curr_perms(w) ==0} {
	$eddo_titel configure -state disabled 
	$eddo_detail subwidget text configure -state disabled
    }
}

proc fillRepeats { } {
    global edd_repEna edd_repTyp edd_repIntervall edd_repInterTyp edd_repCount edd_repInf
    global eddo_repEna eddo_repTyp eddo_repInf eddo_repCount eddo_repInter eddo_repItyp
    global eddo_repL1 eddo_repL2 eddo_repL3
    global bfnt fnt pbfnt pfnt fnt12 bfnt12  curr_perms
    global edd_shiftCount
    global edd_repStopD  edd_repStopM  edd_repStopY
    global eddo_repStopD eddo_repStopM eddo_repStopY
    global eddo_repWT edd_repWT

    if { $curr_perms(rz) == 1} {
	$eddo_repEna configure -state normal
	$eddo_repTyp configure -state normal
	$eddo_repInf configure -state normal
	$eddo_repStopD configure -state normal
	$eddo_repStopM configure -state normal
	$eddo_repStopY configure -state normal
	$eddo_repInter configure -state normal
	$eddo_repItyp  configure -state normal
	$eddo_repWT  configure -state normal

#	puts "RepeatStop: -> $edd_repStopD $edd_repStopM $edd_repStopY // [$eddo_repStopD cget -value]"
	$eddo_repEna configure -variable edd_repEna
	$eddo_repTyp configure -variable edd_repTyp
	$eddo_repInf configure -variable edd_repInf
	$eddo_repStopD configure -variable edd_repStopD
#	puts "<RepeatStop: -> $edd_repStopD $edd_repStopM $edd_repStopY // [$eddo_repStopD cget -value]"
	$eddo_repStopM configure -variable edd_repStopM
	$eddo_repStopY configure -variable edd_repStopY
	$eddo_repInter configure -variable edd_repIntervall
	$eddo_repItyp  configure -variable edd_repInterTyp
	$eddo_repWT    configure -variable edd_repWT

	$eddo_repEna configure -state disabled
	$eddo_repTyp configure -state disabled
	$eddo_repInf configure -state disabled
	$eddo_repStopD configure -state disabled
	$eddo_repStopM configure -state disabled
	$eddo_repStopY configure -state disabled
	$eddo_repInter configure -state disabled
	$eddo_repItyp  configure -state disabled
	$eddo_repWT    configure -state disabled
    }
    if { $curr_perms(wz) == 1} {
	if { $edd_shiftCount == 0} {
	    $eddo_repEna configure -state normal
	} else {
	    $eddo_repEna configure -state disabled
	}
    }
    toggleRepeat 
}

proc fillReminder { } {
    global edd_reminder eddo_reminder
    global fnt bfnt fnt12 bfnt12 pfnt12 pbfnt
    global eddv_remVal eddv_remUnit eddv_remWeg eddv_remZiel
    global curr_perms edd_groupsOfUser groupList username
    global curr_perms
    global _calText _reminderTransl _reminderTranslPart

    set y 15
    set dy 16
    set can [$eddo_reminder subwidget canvas]
    $can delete all
    set c 0
    set rn 0
    foreach reminder $edd_reminder {
	set off  [lindex $reminder 0]
	set unit $_reminderTransl([lindex $reminder 1])
	set weg  $_reminderTransl([lindex $reminder 2])
	set user [lindex $reminder 3]
	set ziel [lindex $reminder 4]
	set als  [lindex $reminder 5]
	if { [array names _reminderTranslPart $ziel] == $ziel } {
	    set ziel $_reminderTranslPart($ziel)
	}

	set prm 0
	if { $curr_perms(rt)==1 && $curr_perms(rz)==1} {
	    set prm 1
	} else {
	    if { $user == "alle" } {
		set prm 2
	    } else {
		if { [lsearch $groupList $user] < 0 } {
		    if {$user == $username } {
			set prm 3
		    } 
		} else {
		    if { [lsearch $edd_groupsOfUser $user] >=0 } {
			set prm 4
		    } 
		}
	    }
	}

	if { $prm > 0} {
	    if { $als == "E" } {
		set tstr $_calText(addRemindInvite)
	    } else {
		set tstr $_calText(addRemindRemind)
	    }
	    set txt [format "%5.2f %7s %6s %3s %7s %2s %-20s (%10s)" \
			 $off $unit $_calText(addRemindBefore)  $_calText(addRemindVia) \
			 $weg $_calText(addRemindTo) [nameStrTrunc $ziel 21] $tstr]
	    $can create text 2 $y -text  $txt -font $pfnt12 -justify left -anchor sw
	    if { $user == $username  || ($curr_perms(wt) == 1 && $curr_perms(wz)==1)} {
		$can create text 492 [expr $y-0]  -text "X" -anchor sw -tag del -font $pbfnt -fill red 
	    }
	    $can create line 0 $y 520 $y -fill grey98

	    incr c
	    incr y $dy
	    incr rn
	}
    }
    $eddo_reminder adjustscrollregion
    $can bind del <Button> { removeReminder %y}
}

proc removeReminder { y } {
    global edd_reminder eddo_reminder 

    set h [expr 16 * [llength $edd_reminder]]
    set f [lindex [$eddo_reminder subwidget vsb get] 0]
    set yk [ expr int(floor($f*$h)) +$y]
    set nr [expr int(floor($yk /16))]
    set edd_reminder [lreplace $edd_reminder $nr $nr ]
    fillReminder
    $eddo_reminder adjustscrollregion
}

proc fillRest {  } {
    global eddo_comm edd_comm   eddo_commb eddo_newComm eddo_newCommentLabel eddo_commLabel
    global curr_perms edd_cmd
    

    if { $curr_perms(rk) ==1} {
	$eddo_comm   subwidget text configure -state normal
	$eddo_comm   subwidget text delete 0.0 end
	$eddo_comm   subwidget text insert end $edd_comm
    }

    if { $curr_perms(wk) == 0 || $edd_cmd == "addDate" } { 
	$eddo_commb  configure -state disabled
	$eddo_newComm  subwidget text configure -state disabled -bg grey80
	$eddo_newCommentLabel configure -fg grey60
	$eddo_comm  subwidget text configure  -bg grey80 
	$eddo_commLabel configure -fg grey60
   } else {
	$eddo_commb  configure -state normal
	$eddo_newComm  subwidget text configure -state normal -bg grey95
	$eddo_newCommentLabel configure -fg black
	$eddo_comm  subwidget text configure  -bg grey95
	$eddo_commLabel configure -fg black
    }
    
    
}

proc addComm { } {
    global  username edd_comm edd_did  eddo_newComm

    set tmp  [ braces2parenthesis [ $eddo_newComm subwidget text get -text 0.0 end] ]
    regsub -all -lineanchor {^} $tmp "$username: " new_comm

#    set list [ $eddo_newComm subwidget text dump -text 0.0 end]
#    set new_comm ""
#    set l [llength $list]
#    for { set i 1} {$i < $l } {incr i 3 } {
#	set new_comm [format "%s%s" $new_comm [ lindex $list $i] ]
#    }
    set new_comm [string trim $new_comm]
#    set new_comm "$new_comm\""

    set ret [transfer addComm $edd_did $username $new_comm]
    if { [ string first "ServerDown" $ret ] >= 0 } { ServerDownDialog}

    set edd_comm [ request updateComm $edd_did]
    if { [ string first "ServerDown" $edd_comm ] >= 0 } { ServerDownDialog}
    closeWin .ac
    fillRest
}
proc fillTeiln {  } {
    global edd_init  edd_part eddo_teilnehmer edd_part_quick edd_teil_dy
    global partStatus partStatusStr edd_currUser
    global eddo_addEinl eddo_addTeiln eddo_addInfo eddo_prvTeilnLines edd_groupsOfUser
    global eddo_priv eddo_gpri edd_priv edd_gpri 
    global username edd_currUserPerm eddo_teilTitel
    global curr_perms fnt12 bfnt12 pfnt12 pbfnt12
    global eddv_part   eddo_prior edd_priority edd_group eddo_group
    global datePartType

    set datePartTypeColor(I) "red"
    set datePartTypeColor(E) "DarkOrange"
    set datePartTypeColor(T) "green4"
    set datePartTypeColor(A) "blue2"
    set datePartTypeColor(i) "black"

    $eddo_teilnehmer subwidget canvas delete all
#    $eddo_teilnehmer subwidget canvas create rectangle 0 0 464 220 -fill grey95 -outline grey95
    
    for { set i 0} { $i < $eddo_prvTeilnLines} {incr i} { 
	$eddo_teilnehmer subwidget canvas bind perm$i <ButtonPress> {} 
	$eddo_teilnehmer subwidget canvas bind stat-$i <ButtonPress> {} 
	$eddo_teilnehmer subwidget canvas bind del$i <ButtonPress> {}
	$eddo_teilnehmer subwidget canvas bind type-$i <ButtonPress> {} 
    }

    set y 3
    set dy 15
    set edd_teil_dy $dy

    set edd_part_quick ""
    set own_glist ""
    set c 0
    set eddv_part ""
    set eddt_tmp_part ""

    foreach val $edd_part {
	set type  [ lindex $val 0]
	set name  [ lindex $val 1]
	set stat  [ lindex $val 2]
	set flags [ lindex $val 3]
	set uperm [ lindex $val 4]
	set fulln [ lindex $val 5]
	set ugType [ lindex $val 6]
	
	if { $ugType =="g" } {
	    if { [lsearch $edd_groupsOfUser $name] >0 } {
		lappend own_glist $c 
	    }
	}
	set nTag "$ugType-$name"
	    
	lappend edd_part_quick $name
	if { $curr_perms(rt)   ==1 || $edd_currUser == $name} {

	    lappend eddv_part $val
	    lappend eddt_tmp_part  $name

	    $eddo_teilnehmer subwidget canvas create oval 2 [expr $y -1] 15 [expr $y+$dy -2 ] -fill white -outline grey80
	    set y2 [expr $y +1]
	    $eddo_teilnehmer subwidget canvas create text 8 $y2 -text " $datePartType($type) " -anchor n -justify center -fill $datePartTypeColor($type) -font $pbfnt12
	    $eddo_teilnehmer subwidget canvas addtag type-$c closest 8 [expr $y+4] 
	    $eddo_teilnehmer subwidget canvas addtag $nTag closest 8 [expr $y+4] 

	    $eddo_teilnehmer subwidget canvas create text 24 $y -text [nameStrTrunc $fulln 30]  -anchor nw -tag name$c -font $pfnt12
	    set id [lsearch $partStatus $stat ]
	    if { $id <=0} { set id 0 }
	    $eddo_teilnehmer subwidget canvas create text 240 $y -text [ lindex $partStatusStr $id] -anchor nw -tag "stat-$c $nTag" -font $pfnt12
	    
	    set admin 0
	    if { $name == $username } {
		if { $edd_currUserPerm != $uperm } {
		    set admin 1
		}
	    }
	    if { $admin == 0} {
		set str [format "r=%4s w=%-5s" [string range $uperm 0 3] [string range $uperm 4 8] ]
		$eddo_teilnehmer subwidget canvas create text 326 $y -text $str -anchor nw -tag perm$c -font $pfnt12
	    } else {
		set str [format "r=%4s w=%-5s" [string range $edd_currUserPerm 0 3] [string range $edd_currUserPerm 4 8] ]
		$eddo_teilnehmer subwidget canvas create text 326 $y -text $str -anchor nw -tag perm$c \
		    -font $pfnt12 -fill IndianRed4
		regsub -all -- - $uperm " " p2
		set str [format "r=%4s w=%-5s" [string range $p2 0 3] [string range $p2 4 8] ]
		$eddo_teilnehmer subwidget canvas create text 326 $y -text $str -anchor nw -tag perm$c\
		    -font $pfnt12
	    }
	    if { $name != $edd_init && $curr_perms(wt) ==1} {
		$eddo_teilnehmer subwidget canvas create text 432 [expr $y -2 ] -text ">>" -anchor nw -tag del$c -font -b&h-lucidatypewriter-bold-r-*-*-14-*-*-*-*-*-*-* -fill red
	    }
	    
	    incr c
	    incr y $dy
	    set y1 [expr $y-2]
	    $eddo_teilnehmer subwidget canvas create line 0 $y1 448 $y1 -fill grey75
	}
    }
    
    if { $c == 0} {
	$eddo_teilTitel.1 configure -foreground grey60
	$eddo_teilTitel.2 configure -foreground grey60
	$eddo_teilTitel.3 configure -foreground grey60
	$eddo_teilTitel.4 configure -foreground grey60
    } else {
	$eddo_teilTitel.1 configure -foreground black
	$eddo_teilTitel.2 configure -foreground black
	$eddo_teilTitel.3 configure -foreground black
	$eddo_teilTitel.4 configure -foreground black
    }

    if { $curr_perms(wt) ==1} {
	for { set i 0} { $i < $c} {incr i} { 
	    $eddo_teilnehmer subwidget canvas bind perm$i <ButtonPress> {changePermDialog  %y %X %Y} 
#	    $eddo_teilnehmer subwidget canvas bind stat$i <ButtonPress> {changeStatusDialog %x %y %X %Y} 
	    $eddo_teilnehmer subwidget canvas bind stat-$i <ButtonPress> {changeStatusPopup %x %y } 
	    if { $name != $edd_init} {
		$eddo_teilnehmer subwidget canvas bind del$i <ButtonPress> {removeTeilnehmer %y}
	    }
#	    $eddo_teilnehmer subwidget canvas bind art$i <ButtonPress> {changeType-$Dialog %y %X %Y} 
	    $eddo_teilnehmer subwidget canvas bind type-$i <ButtonPress> {changeTypePopup %x %y } 
#	    puts "eddo_teilnehmer subwidget canvas bind type-$i <ButtonPress> {changeTypePopup %x %y } "
	}
	$eddo_addEinl  configure -state normal
	$eddo_addTeiln configure -state normal
	$eddo_addInfo  configure -state normal
	
    } else {
	set i [ lsearch $eddt_tmp_part $edd_currUser ]
	if { $i >= 0} {
#	    $eddo_teilnehmer subwidget canvas bind stat$i <ButtonPress> {changeStatusDialog  %x %y %X %Y}
	    $eddo_teilnehmer subwidget canvas bind stat-$i <ButtonPress> {changeStatusPopup  %x %y }
	    if { $edd_currUser == $edd_init} {
		$eddo_teilnehmer subwidget canvas bind perm$i <ButtonPress> {changePermDialog  %y %X %Y} 
	    }
	}
	foreach i $own_glist {
#	    $eddo_teilnehmer subwidget canvas bind stat$i <ButtonPress> {changeStatusDialog  %x %y %X %Y}
	    $eddo_teilnehmer subwidget canvas bind stat-$i <ButtonPress> {changeStatusPopup  %x %y}
	}
	
	
	$eddo_addEinl  configure -state disabled
	$eddo_addTeiln configure -state disabled
	$eddo_addInfo  configure -state disabled
    }
    set eddo_prvTeilnLines $c    


    #    if { $curr_perms(rt)   ==1 || $edd_currUser == $name} { }
    if { $curr_perms(rt)   ==1 } {
	$eddo_priv  configure -state normal
	$eddo_gpri  configure -state normal
	$eddo_group configure -state normal
	$eddo_prior configure -state normal
	$eddo_group configure -variable edd_group
	$eddo_priv  configure -variable edd_priv
	$eddo_gpri  configure -variable edd_gpri
	$eddo_prior configure -variable edd_priority
    }
    #    if { $curr_perms(wt)   ==1 || $edd_currUser == $name} {}
    if { $curr_perms(wt)   ==0} {
	$eddo_group configure -state disabled
	$eddo_priv  configure -state disabled
	$eddo_gpri  configure -state disabled
	$eddo_prior configure -state disabled
    }
    $eddo_teilnehmer adjustscrollregion
#     global edd_fttid
#     if { $edd_fttid >= 0 } {
# 	after cancel $edd_fttid
#     }
#     set edd_fttid [ after 2500 fillTimeTable]
    fillTimeTableDelayed
}
proc fillTimeTableDelayed { } {
    global edd_fttid eddv_onPartPage
    
    if { $edd_fttid >= 0 } {
	after cancel $edd_fttid
    }
    if { $eddv_onPartPage == 1} {
	set edd_fttid [ after 2000 fillTimeTable]
    }
}
proc removeTeilnehmer { y } { 
    global edd_teil_dy  edd_part edd_currUserPerm edd_teilnChange eddo_teilnehmer

    set h [expr 16 * [llength $edd_part]]
    set f [lindex [$eddo_teilnehmer subwidget vsb get] 0]
    set yk [ expr int(floor($f*$h)) +$y]

    set id [expr int(floor($yk/$edd_teil_dy) ) ]
    set edd_part [lreplace $edd_part $id $id  ]
    fillTeiln 
    set edd_teilnChange 1
}

# proc changeTypeDialog { y gx gy } {
#     global edd_part edd_teil_dy edd_current_ent eddo_teilnehmer eddv_part

    

#     set id [expr int(floor($y/$edd_teil_dy) ) ]
#     set edd_current_ent [ lindex $eddv_part $id]
#     set oldType [lindex $edd_current_ent 0]
#     if { $oldType == "E" || $oldType == "T"|| $oldType == "i" } {
# 	toplevel .ctd
# 	button .ctd.einl -text "Einladener" -command {setType E}
# 	button .ctd.teil -text "Teilnehmer" -command {setType T}
# 	button .ctd.info -text "Information" -command {setType i}
# 	button .ctd.abbr -text "Abbruch" -command {closeWin .ctd }
# 	pack .ctd.einl .ctd.teil .ctd.info .ctd.abbr  -side top -fill x
# 	wm geometry .ctd  +$gx+$gy
# 	update
# 	grab .ctd
#     }
# }

proc changeTypePopup { x y} {
    global  adTypePopWin eddo_teilnehmer edd_current_ent eddv_part


    set cwin [$eddo_teilnehmer subwidget canvas]
    set tags [$cwin gettags [ $cwin find closest $x $y]]
    puts "TAGS: '$tags'"
    set i [lsearch -glob $tags "type-*"]
    if { $i >= 0 } {
	set nr [ lindex [ split [lindex $tags $i] - ] 1 ]
	set edd_current_ent [lindex $eddv_part $nr]
	$adTypePopWin post $eddo_teilnehmer $x $y
    }
}
proc setType { type } {
    global edd_part  edd_current_ent 

    set id [ lsearch $edd_part $edd_current_ent]
    set ent [lreplace $edd_current_ent 0 0 $type ]
    set edd_part [lreplace $edd_part $id $id $ent]
    fillTeiln 
}

proc changeStatusPopup { x y} {
    global  adStatusPopWin eddo_teilnehmer edd_current_ent eddv_part


    set cwin [$eddo_teilnehmer subwidget canvas]
    set tags [$cwin gettags [ $cwin find closest $x $y]]
#    puts "TAGS: '$tags'"
    set i [lsearch -glob $tags "stat-*"]
    if { $i >= 0 } {
	set nr [ lindex [ split [lindex $tags $i] - ] 1 ]
	set edd_current_ent [lindex $eddv_part $nr]
	$adStatusPopWin post $eddo_teilnehmer $x $y
    }
}
proc adSetPartStatus  { status } {
    global edd_part  edd_current_ent  eddv_part partStatus
#    puts "prv: $edd_part"
    set id [ lsearch $edd_part $edd_current_ent]
    set ent [lreplace $edd_current_ent 2 2 [lindex $partStatus $status ] ]
    set edd_part [lreplace $edd_part $id $id $ent]
#    puts "$ent @ $id -> $edd_part"
    fillTeiln 
}
# proc changeStatusDialog { x y gx gy } {
#     global edd_part edd_teil_dy edd_current_ent eddo_teilnehmer eddv_part

# #FIXME gekrzte Listen


#     set id [expr int(floor($y/$edd_teil_dy) ) ]
#     set edd_current_ent [lindex $eddv_part $id]
#     set oldType [lindex $edd_current_ent 0]
#     toplevel .csd
#     button .csd.unk -text "unbekannt" -command {setStatus UKN}
#     button .csd.ok  -text " O.K." -command {setStatus OK}
#     button .csd.opn -text " unsicher." -command {setStatus OPEN}
#     button .csd.no  -text "abgesagt" -command {setStatus NO}
#     button .csd.psh  -text "verschieben" -command {setStatus PUSH}
# #    button .csd.ign  -text "ignorieren" -command {setStatus IGNO}
#     button .csd.abb -text "Abbruch" -command {closeWin .csd }
#     pack .csd.ok .csd.opn .csd.no .csd.unk .csd.psh  .csd.abb  -side top -fill x
#     wm geometry .csd  +$gx+$gy
#     #	wm title .cpd [format "ndere Rechte fr %s" [ lindex edd_current_ent 1 ]]
#     update
#     grab .csd
# }

# proc setStatus { stat } {
#     global edd_part  edd_current_ent eddo_teilnehmer edd_currUserPerm eddv_part
#     set id [ lsearch $edd_part $edd_current_ent]
#     set ent [lreplace $edd_current_ent 2 2 $stat ]
#     set edd_part [lreplace $edd_part $id $id $ent]
#     closeWin .csd
#     fillTeiln 
# }

proc changePermDialog { y gx gy} {
    global edd_part edd_teil_dy edd_current_ent eddv_part
    global edd_cb_rz edd_cb_ru edd_cb_rt edd_cb_rk
    global edd_cb_wz edd_cb_wu edd_cb_wt edd_cb_wk edd_cb_d
    global fnt12 bfnt12 bfnt
    global _buttonText _allgText _calText
    
    set id [expr int(floor($y/$edd_teil_dy) ) ]
    set edd_current_ent [ lindex $eddv_part $id]
    set perm  [lindex $edd_current_ent 4] 

    if { [ string range  $perm 0 0]  != "-"} { set edd_cb_rz 1} else { set edd_cb_rz 0}
    if { [ string range  $perm 1 1]  != "-"} { set edd_cb_ru 1} else { set edd_cb_ru 0}
    if { [ string range  $perm 2 2]  != "-"} { set edd_cb_rt 1} else { set edd_cb_rt 0}
    if { [ string range  $perm 3 3]  != "-"} { set edd_cb_rk 1} else { set edd_cb_rk 0}
    if { [ string range  $perm 4 4]  != "-"} { set edd_cb_wz 1} else { set edd_cb_wz 0}
    if { [ string range  $perm 5 5]  != "-"} { set edd_cb_wu 1} else { set edd_cb_wu 0}
    if { [ string range  $perm 6 6]  != "-"} { set edd_cb_wt 1} else { set edd_cb_wt 0}
    if { [ string range  $perm 7 7]  != "-"} { set edd_cb_wk 1} else { set edd_cb_wk 0}
    if { [ string range  $perm 8 8]  != "-"} { set edd_cb_d  1} else { set edd_cb_d  0}

    if { [winfo exists .cpd ] == 1 } { return }
    toplevel .cpd 
    frame .cpd.v -relief raised -bd 1
    frame .cpd.b -relief flat
    pack .cpd.v .cpd.b  -side top -fill x


    frame .cpd.v.l 
    frame .cpd.v.r
    frame .cpd.v.d 
    frame .cpd.v.w 
    pack .cpd.v.l  .cpd.v.r .cpd.v.d .cpd.v.w -side left -fill both

    label .cpd.v.l.l -text " "  -font $bfnt12
    label .cpd.v.r.l -text $_allgText(permRead) -font $bfnt12
    label .cpd.v.d.l -text " "  -font $bfnt12
    label .cpd.v.w.l -text $_allgText(permModi) -font $bfnt12
    pack .cpd.v.l.l .cpd.v.r.l .cpd.v.d.l .cpd.v.w.l -side top -fill x

    label .cpd.v.l.1 -text $_calText(permCoords) -width 18 -font $bfnt12
    label .cpd.v.l.2 -text $_calText(permTexts) -width 18 -font $bfnt12
    label .cpd.v.l.3 -text $_calText(permParts) -width 18 -font $bfnt12
    label .cpd.v.l.4 -text $_calText(permComments) -width 18 -font $bfnt12
    label .cpd.v.l.5 -text $_calText(permDelete) -width 18 -font $bfnt12

    checkbutton .cpd.v.r.1 -variable edd_cb_rz -font $bfnt12
    checkbutton .cpd.v.r.2 -variable edd_cb_ru -font $bfnt12
    checkbutton .cpd.v.r.3 -variable edd_cb_rt -font $bfnt12
    checkbutton .cpd.v.r.4 -variable edd_cb_rk -font $bfnt12
    label       .cpd.v.r.5 -text " "  -font $bfnt12 

    label       .cpd.v.d.1 -text " "  -font $bfnt12
    label       .cpd.v.d.2 -text " " -font $bfnt12
    label       .cpd.v.d.3 -text " " -font $bfnt12
    label       .cpd.v.d.4 -text " " -font $bfnt12
    checkbutton .cpd.v.d.5 -variable edd_cb_d -font $bfnt12

    checkbutton .cpd.v.w.1 -variable edd_cb_wz
    checkbutton .cpd.v.w.2 -variable edd_cb_wu
    checkbutton .cpd.v.w.3 -variable edd_cb_wt
    checkbutton .cpd.v.w.4 -variable edd_cb_wk
    label       .cpd.v.w.5 -text " "  -font $bfnt12


    pack .cpd.v.l.1 .cpd.v.l.2 .cpd.v.l.3  .cpd.v.l.4  .cpd.v.l.5 -side top -pady 3 -padx 2
    pack .cpd.v.r.1 .cpd.v.r.2 .cpd.v.r.3  .cpd.v.r.4 -side top
    pack .cpd.v.r.5 -side top -pady 3
    pack .cpd.v.d.1 .cpd.v.d.2 .cpd.v.d.3  .cpd.v.d.4 -side top -pady 3
    pack .cpd.v.d.5 -side top 
    pack .cpd.v.w.1 .cpd.v.w.2 .cpd.v.w.3  .cpd.v.w.4 -side top -padx 2
    pack .cpd.v.w.5 -side top -pady 3 -padx 2

   
    button .cpd.b.abb -text $_buttonText(Cancel) -command {closeWin .cpd} -width 13 -font $bfnt12
    button .cpd.b.ok  -text $_buttonText(Accept) -command {changePerm}    -width 13 -font $bfnt12
    pack .cpd.b.abb -side left
    pack .cpd.b.ok -side right
    wm geometry .cpd +$gx+$gy
    wm title .cpd [format "%s %s" $_calText(addPartWmPerm) [ lindex edd_current_ent 1 ]]
    update
    grab .cpd
}
proc changePerm { } {
    global edd_part edd_current_ent edd_currUserPerm edd_currUser
    global edd_cb_rz edd_cb_ru edd_cb_rt edd_cb_rk
    global edd_cb_wz edd_cb_wu edd_cb_wt edd_cb_wk edd_cb_d
    
    set id [ lsearch $edd_part $edd_current_ent]
    set prm [ rlist2str "$edd_cb_rz $edd_cb_ru $edd_cb_rt $edd_cb_rk $edd_cb_wz $edd_cb_wu $edd_cb_wt $edd_cb_wk $edd_cb_d"]
    set ent [lreplace $edd_current_ent 4 4 $prm]
    set edd_part [lreplace $edd_part $id $id $ent]
    
    closeWin .cpd
    if { [lindex $edd_current_ent 1] == $edd_currUser } {
	set edd_currUserPerm  $prm 
	set perm  [perm2rw $edd_currUserPerm ]
	fillTimes 
	fillTitel 
	fillTeiln 
	fillRest  
    } else {
	fillTeiln 
    }
}

proc cancleDate { } {
    global edd_cmd edd_did

    if { $edd_cmd == "modifyDate" } {
	set ret [request cancelEditDate $edd_did]
#	if { [string first $ret "ServerDown"] >=0 } {ServerDownDialog}
    }
}
proc sendDate { } {
    global edd_init  edd_part edd_titel edd_detail edd_comm edd_currUserPerm
    global edd_startDy edd_startDm edd_startDd edd_startTh edd_startTm 
    global edd_stopDy edd_stopDm edd_stopDd edd_stopTh edd_stopTm 
    global edd_noTime edd_nonBlock
    global edd_room edd_igni edd_priv edd_gpri edd_group
    global userList groupList roomList
    global edd_currUser edd_editTyp edd_groupsOfUser
    global edd_cmd username edd_did
    global eddo_comm eddo_detail edd_priority
    global ewList eddLock
    global edd_repEna edd_repTyp edd_repIntervall edd_repInterTyp edd_repCount edd_repInf
    global edd_repStopD  edd_repStopM  edd_repStopY
    global edd_reminder eddv_repTyp eddv_repUnit  edd_repWT


    set edd_comm   [ braces2parenthesis [ $eddo_comm   subwidget text get -text 0.0 end] ]
    set edd_detail [ braces2parenthesis [ $eddo_detail subwidget text get -text 0.0 end] ]

#    set commList [$eddo_comm   subwidget text dump -text 0.0 end ]
#    set l [llength $commList]
#    set edd_comm ""
#    for { set i 1} {$i < $l } {incr i 3 } {
#	set edd_comm [format "%s%s" $edd_comm [ lindex $commList $i] ]
#    }
#    set commList [$eddo_detail   subwidget text dump -text 0.0 end ]
#    set l [llength $commList]
#    set edd_detail ""
#    for { set i 1} {$i < $l } {incr i 3 } {
#	set edd_detail [format "%s%s" $edd_detail  [ lindex $commList $i] ]
#    }

    set edd_comm [string trim $edd_comm]
    set edd_detail [string trim $edd_detail]

    set eList ""
    set tList ""
    set aList ""
    set iList ""
    foreach val $edd_part {
	set type  [ lindex $val 0]
	set name  [ lindex $val 1]
	set stat  [ lindex $val 2]
	set flags [ lindex $val 3]
	set uperm [ lindex $val 4]
	set ugType [ lindex $val 6]
	
	set ent [format "{%s} %d %d %d %d %s"  $name \
		     [ statusVal $stat] [flagVal $flags] [permVal $uperm] [isGroup $ugType] $type]
	lappend tList $ent
    }	

    set startD [format "%4d%02d%02d" $edd_startDy $edd_startDm $edd_startDd]
    set startT [format "%2d%02d"  $edd_startTh $edd_startTm]
    set stopD [format "%4d%02d%02d"   $edd_stopDy $edd_stopDm $edd_stopDd]
    set stopT [format "%2d%02d"  $edd_stopTh $edd_stopTm ]

    if { $edd_repInf == 1 } { 
	set edd_repStop 0
    } else { 
	set edd_repStop [ expr $edd_repStopD +$edd_repStopM *100 + $edd_repStopY *10000]
    }
    set repTyp [lsearch $eddv_repTyp $edd_repTyp]
    if {$edd_repEna == 0 }  { set repTyp 0 }
    set repUnit 0
    if {$edd_repTyp == "alle" } {set repUnit [lsearch $eddv_repUnit $edd_repInterTyp]}
    if {$edd_repTyp == "tag" } {
	foreach wt $edd_repWT {
	    incr repUnit $wt
	}
    }
	
    set ret [transfer $edd_cmd $edd_did $username $edd_init $tList $startD $startT $stopD $stopT  $edd_titel $edd_detail $edd_room $edd_group $edd_priv $edd_gpri $repTyp $edd_repStop $edd_repIntervall $repUnit $edd_priority $edd_reminder $edd_noTime $edd_nonBlock]
    if { [string first $ret "ServerDown"] >=0 } {ServerDownDialog}
#    if { [string range $ret 0 2] == "ERR" } {
#	ErrorDialog $ret
#    }
    closeWin .edd
    drawUsersCalendar
    if { $edd_cmd == "modifyDate" } {
	if { [string range $ret 0 3] == "WARN" } {
	    set ewList [ lrange $ret 3 end ]
	    modifyIncompleteDialog 
	}
    }
    set eddLock 0
}

proc statusVal { str } {
    global partStatus
    return [ lsearch $partStatus $str]
}
proc flagVal { str } {
    if { $str == "-" } {
	return 0
    }
    return 0
}
proc val2flag { val } {
    return "-"
}
proc permVal { str } {
    global datePermRefStr

    set ref $datePermRefStr
    set sum 0
    set w 1
    for { set i 0 } {$i <9 } {incr i} {
	set j [expr $i +4]
	if { [ string range $str $i $i ] == [ string range $ref $i $i ] } { incr sum $w }
	set w [ expr $w *2]
    }
    return [expr $sum]
}

proc val2perm { val } {
    global datePermSym

    set perm ""
    if { [ expr $val & 256 ] > 0 } { set perm "$datePermSym(dd)$perm"} else { set perm "-$perm"}
    if { [ expr $val & 128 ] > 0 } { set perm "$datePermSym(wk)$perm"} else { set perm "-$perm"}
    if { [ expr $val &  64 ] > 0 } { set perm "$datePermSym(wt)$perm"} else { set perm "-$perm"}
    if { [ expr $val &  32 ] > 0 } { set perm "$datePermSym(w)$perm"} else { set perm "-$perm"}
    if { [ expr $val &  16 ] > 0 } { set perm "$datePermSym(wz)$perm"} else { set perm "-$perm"}
    if { [ expr $val &   8 ] > 0 } { set perm "$datePermSym(rk)$perm"} else { set perm "-$perm"}
    if { [ expr $val &   4 ] > 0 } { set perm "$datePermSym(rt)$perm"} else { set perm "-$perm"}
    if { [ expr $val &   2 ] > 0 } { set perm "$datePermSym(r)$perm"} else { set perm "-$perm"}
    if { [ expr $val &   1 ] > 0 } { set perm "$datePermSym(rz)$perm"} else { set perm "-$perm"}

    return $perm
} 
proc isGroup { str } {
    if { $str == "g" } {
	return 1
    }
    if { $str == "a" } {
	return 2
    }
    return 0
}

proc modifyIncompleteDialog {  } {
    global fnt bfnt edd_did
    
    if { [winfo exists .ew ] == 1 } { return }
    toplevel .ew
    frame .ew.t -relief raised -bd 2
    frame .ew.b 
    pack .ew.t .ew.b -side top -fill x
    
    label .ew.t.l -text "Achtung"  -anchor n  -justify center -font $bfnt
    message .ew.t.m -width 380 -text "Ein anderer Benutzer hat zwischenzeitlich den termin gendert. Es wurden nur nderungen angenommen, die unabhnigig sind." -font $fnt
    pack .ew.t.l .ew.t.m -side top -fill x

    button .ew.b.hlp -text "  Erklrung  " -command modifyErkl
    button .ew.b.det -text "   Details   " -command modifyIncompleteDetails
    button .ew.b.edi -text " Wiederholen " -command {
	destroy .ew 
	editDate $edd_did}
    button .ew.b.clo -text "    O.K.     " -command {closeWin .ew}
    pack .ew.b.hlp .ew.b.det -side left 
    pack .ew.b.clo .ew.b.edi -side right
    
    grab .ew
    centerWin .ew 400 112
}

proc modifyIncompleteDetails { } {
    global fnt bfnt fnt10 ewList

    if { [winfo exists .ewd ] == 1 } { return }
    toplevel .ewd
    frame .ewd.t -relief raised -bd 2
    frame .ewd.b 
    pack .ewd.t .ewd.b  -side top -fill x


    label .ewd.t.l -text "nderungen im Detail"  -anchor n  -justify center -font $bfnt
    frame .ewd.t.u 
    pack .ewd.t.l  .ewd.t.u -side top -fill x

    frame .ewd.t.u.l
    frame .ewd.t.u.r
    pack .ewd.t.u.l .ewd.t.u.r -side left -fill x

    label .ewd.t.u.l.l -text "Angenommene nderungen" -font $fnt
    tixScrolledText .ewd.t.u.l.t -width 200 -height 150
    pack .ewd.t.u.l.l .ewd.t.u.l.t -side top
    .ewd.t.u.l.t   subwidget text configure -font  $fnt10

    
    set list [lindex $ewList 0]
    set str [ join $list '\n' ]
    .ewd.t.u.l.t   subwidget text insert end $str

    label .ewd.t.u.r.l -text "Abgelehnete nderungen" -font $fnt
    tixScrolledText .ewd.t.u.r.t -width 200 -height 150
    pack .ewd.t.u.r.l .ewd.t.u.r.t -side top
    .ewd.t.u.r.t   subwidget text configure -font  $fnt10

    set list [lindex $ewList 1]
    set str [ join $list '\n' ]
    .ewd.t.u.r.t   subwidget text insert end $str
    
 

    button .ewd.b.c -text "  O.K.  " -command {destroy .ewd}
    pack .ewd.b.c -side right

    grab .ewd

    centerWin .ewd 408 222
}

proc modifyErkl { } {
    global progname
    global fnt bfnt

    if { [winfo exists .ewh ] == 1 } { return }
    toplevel .ewh
    
    frame .ewh.t -relief raised -bd 2
    frame .ewh.b 
    pack .ewh.t .ewh.b -side top -fill x
    
    label .ewh.t.l -text "Erklrung"  -anchor n  -justify center -font $bfnt
    message .ewh.t.m -width 280 -text "
  Wenn zwei Nutzer gleichzeitig einen Termin 
bearbeiten,kann es passieren, dass sie dieselbe 
Eigenschaft eines Termins in unterschiedlicher-
weise ndern.In diesem Fall bernimmt $progname 
alle nderungen desjenigen Nutzers der zuerst 
den Dialog beendet hat. 
  Alle Nutzer, die davor mit dem Bearbeiten 
begonnen haben, aber ihre nderungen erst 
dannach abschicken, werden anders behandelt.
Bei ihnen werden nur nderungen von solchen 
Eigenschaften des fraglichen Termins 
bernommen, die nicht schon von dem ersten 
Nutzer verndert wurden. 
  Sie werden aber mit einem Dialog auf diese 
Tatsache hingewiesen. Welche Eigenschaften 
gendert wurden und welchenicht, kann mit dem 
Knopf 'Details' abgefragt werden.
  Wird ader nderungsdialog gestartet nachdem 
der erste Nutzer seinen nderungen abgeschickt 
hat, so ist dieser Vorgang vollkommen unabhnig 
davon.
"

    pack .ewh.t.l .ewh.t.m -side top -fill x -padx 4 -pady 4


    button .ewh.b.clo -text "    O.K.     " -command {closeWin .ewh}
    pack .ewh.b.clo  -side right
    
    centerWin .ewh 306 400
    grab .ewh
}

proc newDate {user startD startHour startMin stopHour stopMin } {
    invite $user - - $startD $startHour $startMin $stopHour $stopMin
}
proc invite { user who wig startD startHour startMin stopHour stopMin } {
    global edd_init  edd_part edd_titel edd_detail edd_comm edd_currUserPerm
    global edd_startDy edd_startDm edd_startDd edd_startTh edd_startTm 
    global edd_stopDy edd_stopDm edd_stopDd edd_stopTh edd_stopTm 
    global edd_noTime edd_nonBlock
    global edd_room edd_igni edd_priv edd_gpri edd_group
    global userList groupList roomList edd_priority
    global edd_currUser edd_editTyp edd_groupsOfUser
    global eddv_day eddv_mon eddv_year
    global edd_cmd eddo_addButtonTitel edd_teilnChange
    global edd_did eddo_ok eddo_abb 
    global edd_repEna edd_repTyp edd_repIntervall edd_repInterTyp edd_repCount edd_repInf
    global edd_repStopD  edd_repStopM  edd_repStopY
    global edd_reminder
    global fullUsername fullUserNames curr_perms
    global eddo_tt_list
    global TTcacheTime TTcacheUser TTcache TTcacheCtime
    global edd_shiftCount
    global eddo_repStopD eddo_repStopM eddo_repStopY
    global extList
    global lastListUpdate
    global edd_FillTimes _calText datePermRefStr

    set edd_FillTimes 0

    

#    doLock
    set edd_did -1
    set edd_teilnChange 1
    set edd_cmd "addDate"

    set ret [request getInfo4NewDate $user]
    if { $ret == "Error" } { return }
#    if { [string first $ret "ServerDown"] >=0 } {ServerDownDialog}    
    
    set edd_groupsOfUser [lindex $ret 0]
    set extList [lsort -command compareNames  [lindex $ret 1]]
    set utim [ lindex $ret 2]
    if { $utim > $lastListUpdate } {
	getNewLists
    }
#    set edd_groupsOfUser [request groupListByUser $user]
#    if { $edd_groupsOfUser == "Error" } { return }
##    if { [string first $edd_groupsOfUser "ServerDown"] >=0 } {ServerDownDialog}

    set edd_currUserPerm $datePermRefStr
    set edd_init $user
    set edd_currUser $user 
    if { $who == "-" } {
	set edd_part "{I $user UKN - $datePermRefStr {$fullUsername} u}" 
    } else {
	#FIXME
#	set full [getFullUserName $who $wig ]
	set edd_part "{I $user UKN - $datePermRefStr {$fullUsername} u} {T $who UKN - $datePermRefStr {$fullUserNames($wig-$who)} $wig}" 
    }
    set edd_startDy [expr $startD /10000 ]
    set edd_startDm [expr ($startD /100) % 100 ]
    set edd_startDd [expr $startD %100 ]

    set edd_stopDy [expr $startD /10000 ]
    set edd_stopDm [expr ($startD /100) %100 ]
    set edd_stopDd [expr $startD %100 ]

    if { $startHour >=0} {
	set edd_startTh $startHour
	set edd_startTm $startMin
	if { $stopHour >=0} {
	    set edd_stopTh $stopHour
	    set edd_stopTm $stopMin
	} else {
	    set edd_stopTh $edd_startTh
	    incr edd_stopTh
	    set edd_stopTm $edd_startTm
	}
	if { $edd_stopTh >=24} {
	    set edd_stopTh 23
	    set edd_stopTm 59
	}
	set edd_noTime 0
    } else {
	set edd_startTh 8
	set edd_startTm 0
	set edd_stopTh 18
	set edd_stopTm 0
	set edd_noTime 1
    }
    set ret [ calcDate $edd_startDd $edd_startDm $edd_startDy -3]
    set eddv_day  [ lindex $ret 0 ]
    set eddv_mon  [ lindex $ret 1 ]
    set eddv_year [ lindex $ret 2 ]

    set edd_room [lindex $roomList 0]
    set edd_group [getPrimGroup $user]
    set edd_igno  0
    set edd_priv  0
    set edd_gpri  0
    set edd_titel $_calText(addDefaultTitle)
    set edd_detail ""
    set edd_repEna 0
    set edd_repTyp "woche"
    set edd_repIntervall 0
    set edd_repInterTyp "tage"
#    set edd_repCount 0
    set edd_repStopD $edd_stopDd
    set edd_repStopM $edd_stopDm
    set edd_repStopY $edd_stopDy
    set edd_repInf   1
    set edd_repWT ""
    set edd_reminder ""
    set edd_nonBlock 0
#    set edd_reminder "{1 Stunden E-mail alle} {15 Minuten E-mail $fullUsername}"

    set edd_comm   ""
    set edd_shiftCount 0
    set edd_priority 3



    set eddo_addButtonTitel $_calText(addAddDate)

    perm2rw $edd_currUserPerm
    set eddo_tt_list ""
    set TTcacheUsers ""
    set TTcacheTime  "0 0"
    set TTcacheCtime 0
    set edd_editTyp $_calText(addTypeNew)
    editDateDialog 

    wm title .edd [format "%s : %s" $edd_editTyp $edd_titel ]
    fillAll_1st
    update
#    $eddo_abb configure -state normal
#    $eddo_ok configure -state normal
#    unLock
}

proc editDate { did } {
    global edd_init  edd_part edd_titel edd_detail edd_comm edd_currUserPerm
    global edd_startDy edd_startDm edd_startDd edd_startTh edd_startTm 
    global edd_stopDy edd_stopDm edd_stopDd edd_stopTh edd_stopTm 
    global edd_room edd_igni edd_priv edd_gpri edd_group
    global userList groupList roomList edd_priority
    global edd_currUser edd_editTyp edd_groupsOfUser edd_priority
    global eddv_day eddv_mon eddv_year 
    global edd_repEna edd_repTyp edd_repIntervall edd_repInterTyp edd_repCount edd_repInf
    global edd_repStopD  edd_repStopM  edd_repStopY
    global edd_reminder edd_noTime edd_nonBlock
    global edd_cmd username
    global partStatus partStatusStr permValues curr_perms
    global eddo_addButtonTitel edd_teilnChange
    global edd_did  eddo_ok eddo_abb 
    global eddv_repTyp eddv_repUnit
    global eddo_tt_list
    global TTcacheTime TTcacheUser TTcache TTcacheCtime
    global curr_perms
    global edd_shiftCount
    global eddo_repStopD eddo_repStopM eddo_repStopY
    global extList
    global lastListUpdate
    global edd_FillTimes edd_repWT
    global _calText

    set edd_FillTimes 0

#    doLock

    set edd_did $did
    set edd_teilnChange 1
    set ret [ request getDateAndAquire $username $did]
    if { $ret == "Error" } { return }
#    if { [string first $ret "ServerDown"] >=0 } {ServerDownDialog}
#     set rt [request aquireDate $username $did]
#    if { $adr_list == "Error" } { return }
##     if { [string first $rt "ServerDown"] >=0 } {ServerDownDialog}

    set edd_currUserPerm [val2perm [ lindex $ret  0]]
    set edd_currUser $username
    set edd_init [ lindex $ret  1]
    set part [ lindex $ret  2]
    set edd_part ""
    foreach val $part {
	set ent [ format "%s {%s} %s %s %s {%s} %s" [lindex $val 5] [lindex $val 0] \
		      [lindex $partStatus [lindex $val 1]] [val2flag [lindex $val 2]] \
		      [ val2perm [lindex $val 3] ] [lindex $val 6] [lindex $val 4] ]
		      
	lappend edd_part $ent
    }

    set startD [ lindex $ret  3]
    set startT [ lindex $ret  4]
    set edd_startDy [expr $startD /10000 ]
    set edd_startDm [expr ($startD /100) % 100 ]
    set edd_startDd [expr $startD %100 ]
    set edd_startTh [expr $startT /100 ]
    set edd_startTm [expr $startT %100 ]
    set stopD  [ lindex $ret  5]
    set stopT  [ lindex $ret  6]
    set edd_stopDy [expr $stopD /10000 ]
    set edd_stopDm [expr ($stopD /100) % 100 ]
    set edd_stopDd [expr $stopD %100 ]
    set edd_stopTh [expr $stopT /100 ]
    set edd_stopTm [expr $stopT %100 ]
    set val [ calcDate $edd_startDd $edd_startDm $edd_startDy -3]
    set eddv_day  [ lindex $val 0 ]
    set eddv_mon  [ lindex $val 1 ]
    set eddv_year [ lindex $val 2 ]

    set edd_titel [ lindex $ret  7]
    set edd_detail [ lindex $ret  8]
    set edd_room [ lindex $ret  9]
    set edd_group [ lindex $ret 10]
    set edd_priv [ lindex $ret 11]
    set edd_gpri [ lindex $ret 12]

    #FIXME Repaet und reminder aus Termin

    set v [lindex $ret 13]
    if {$v == 0 } {
	set edd_repEna 0
	set edd_repTyp "tag"
    } else {
	set edd_repEna 1
	set edd_repTyp [lindex $eddv_repTyp $v]
    }
#    set edd_repCount [lindex $ret 14]
    set rstop [lindex $ret 14]
#    puts ">>>> rstop=$rstop startD=$startD"
    if { $rstop < $startD } {
	set edd_repInf 1
    } else {
	set edd_repInf 0
    }
    set edd_repStopD [expr $rstop /10000 ]
    set edd_repStopM [expr ($rstop /100) % 100 ]
    set edd_repStopY [expr $rstop %100 ]
#    puts "RepeatStop: $rstop -> $edd_repStopD $edd_repStopM $edd_repStopY"

    set edd_repIntervall [lindex $ret 15] 
    if { $edd_repTyp == "alle" } {
	set edd_repInterTyp [lindex $eddv_repUnit [lindex $ret 16] ] 
	set edd_repWT ""
    }
    if { $edd_repTyp == "tag" } {
	set edd_repInterTyp ""
	set edd_repWT ""
	set bf [lindex $ret 16]
#	puts "bf=$bf"
	for { set v 64} {$v >0 } { set v [expr $v/2]} {
#	    puts "v=$v -> [expr $bf / $v]"
	    if { [expr $bf / $v] >=1 } {
		lappend edd_repWT $v
#		puts "                -> appende -> $edd_repWT"
		set bf [expr $bf -$v]
	    }
	}
    }
    set edd_priority [lindex $ret 17]
    set edd_reminder [lindex $ret 18]
    set edd_noTime [lindex $ret 19]
    set edd_comm [ lindex $ret 20]
    set edd_shiftCount [lindex $ret 21]
    set edd_nonBlock [lindex $ret 22]
    set edd_groupsOfUser [lindex $ret 23]
    #fixme only update time
    set extList [lsort -command compareNames [lindex $ret 24]]
#     puts "EXT-LISt : [lindex $ret 24]"
#     puts "EXT-LISt : '$extList'"
    set utim [ lindex $ret 25]

    set edd_cmd "modifyDate"
    set eddo_addButtonTitel $_calText(addModifyDate)
    if { $utim > $lastListUpdate } {
	getNewLists
    }
#    set edd_groupsOfUser [request groupListByUser $username]
    if { [string first $edd_groupsOfUser "ServerDown"] >=0 } {ServerDownDialog}

    perm2rw $edd_currUserPerm
    set edd_editTyp $_calText(addTypeModify)

    set eddo_tt_list ""
    set TTcacheUsers ""
    set TTcacheTime  "0 0"
    set TTcacheCtime 0

    editDateDialog 
    if { $curr_perms(rt) == 1} {
	wm title .edd [format "%s : %s" $edd_editTyp $edd_titel ]
    }
    fillAll_1st 
    update
#     $eddo_abb configure -state normal
#     $eddo_ok configure -state normal
#    unLock
}

proc perm2rw { perm } { 
    global curr_perms datePermSym

    set curr_perms(rz) 0
    set curr_perms(r) 0
    set curr_perms(rt) 0
    set curr_perms(rk) 0
    set curr_perms(wz) 0
    set curr_perms(w) 0
    set curr_perms(wt) 0
    set curr_perms(wk) 0
    set curr_perms(dd) 0
    set curr_perms(w)  0
    set curr_perms(r)  0
    
    if { [string range $perm 8 8] == "$datePermSym(dd)" } { set curr_perms(dd) 1 }
    if { [string range $perm 7 7] == "$datePermSym(wk)" } { set curr_perms(wk) 1 }
    if { [string range $perm 3 3] == "$datePermSym(rk)" } { set curr_perms(rk) 1 }
    if { [string range $perm 6 6] == "$datePermSym(wt)" } { set curr_perms(wt) 1 }
    if { [string range $perm 2 2] == "$datePermSym(rt)" } { set curr_perms(rt) 1 }
    if { [string range $perm 5 5] == "$datePermSym(w)" } { set curr_perms(w) 1 }
    if { [string range $perm 1 1] == "$datePermSym(r)" } { set curr_perms(r) 1 }
    if { [string range $perm 4 4] == "$datePermSym(wz)" } { set curr_perms(wz) 1 }
    if { [string range $perm 0 0] == "$datePermSym(rz)" } { set curr_perms(rz) 1 }

    if { [expr  $curr_perms(rz)+$curr_perms(r)+$curr_perms(rt)+$curr_perms(rk)] >0 } { set curr_perms(r) 1}
    if { [expr  $curr_perms(wz)+$curr_perms(w)+$curr_perms(wt)+$curr_perms(wk)] >0 } { set curr_perms(w) 1}

}
 

#Request an Server

proc getPrimGroup { user} {
    set pg "Office"
    return $pg
}


proc initPartStatus { } {
    global partStatus partStatusStr permValues
    global lastUserList lastGroupList lastRoomList
    global eddv_repTyp eddv_repUnit eddv_repTypStr
    
    set lastUserList 0 
    set lastGroupList 0 
    set lastRoomList 0

#     set partStatus "??? UKN OK NO OPEN PUSH IGNO"
#     set partStatusStr "unbekannt unbekannt zugesagt abgesagt unsicher verschieben ignorieren ??? ??? ??? ??? ???"
#     set partStatus "??? UKN OK NO OPEN PUSH"
#     set partStatusStr "unbekannt unbekannt zugesagt abgesagt unsicher verschieben ???  ??? ??? ??? ??? ???"

    set eddv_repTyp "off tag woche monat jeden alle wtag"
    set eddv_repTypStr "off tglich wchentlich monatlich {jeden ...} {alle ...} {wochen-tglich}"
    set eddv_repUnit "stunden tage woche monate jahre"

}
