#!/usr/bin/X11/tixwish
#  File: addresss.tcl
# 
#      This file is part of minkowsky
# 
#      Copyright (C) 2001-2002 by Rdiger Goetz
#      Author: Rdiger Goetz <minkowsky@r-goetz.de>
# 
#      Time-stamp: <30-May-2002 19:59:02 goetz>
# 
#      This program is free software; you can redistribute it and/or modify
#      it under the terms of the GNU General Public License as published by
#      the Free Software Foundation; either version 2 of the License, or
#      (at your option) any later version.
# 
#      This program is distributed in the hope that it will be useful,
#      but WITHOUT ANY WARRANTY; without even the implied warranty of
#      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#      GNU General Public License for more details.
# 
#      You should have received a copy of the GNU General Public License
#      along with this program; if not, write to the Free Software
#      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#  


proc printAdrView { } {
}


proc drawAddress { } {
    global env  adrCurListEntry  

    set adrCurListEntry ""
    drawAddressNew
}
proc fillAddress { } {
    global env
    global adr_list
    global adrDirList  adrDirOpen username adrFilter 

    set adr_list [request getAdrList $username ]
    if { $adr_list == "Error" } { return }
    
    set adrDirList [ request getAdrFolders  $username ]
    if { $adrDirList == "Error" } { return }

    if { [array exists adrDirOpen] == 0 } { set adrDirOpen(0) 1}
    foreach dir $adrDirList {
	set dirid [lindex $dir 0]	
	if { [array names adrDirOpen $dirid] == "" } {
	    set adrDirOpen($dirid)  [lindex $dir 4] 
	}
    }
    foreach adr $adr_list {
	set aid [lindex $adr 0]
	set adrFilter($aid) 1
    }
    set used [time fillAddressNew]
    puts "\ntime used for fillAddressNew: $used\n================================================================\n\n"

}

proc drawAddressNew { } {
    global adrWin username adro_list adrHStyle bfnt12 fnt12 adrColList adrSwidth adrSheight
    global adrStartItem adrSelection adrPrevItem adrDirSelStyle adrDirStyle
    global adr_list adrCurItem  adrColXmax adrXmax
    global adrSearchIndex adrSearchIndexList adrSearchString adrSearchStringClearID
    global adrSortField adrSortCol  adrHSortStyle adrHStyle
    global adrColList2 adrColWidth
    global _addrText
    global inPrintDialog
    
    set adrColList(0) " {-1 $_addrText(Name) 20} {5 $_addrText(Company) 25} {15-17 $_addrText(Adr) 30} {8 $_addrText(Telefon) 18} {11 $_addrText(FAX) 18} {12 $_addrText(Internet) 30}  {21 $_addrText(Descr) 40} {25 ? 3}"
    set adrColList(1) " {-1 -    25} {7 - 25} {18-19 - 30} {9    -    18} {99 -  18} {13 - 30}  {+ - 40} {99 ? 2}"
    set adrColList(2) " {-1 -    25} {99 - 25} {20 - 30} {10    -   18} {99 -  18} {14  - 25} {+ - 40} {99 ? 2}"


    set adrColList2 " {name $_addrText(Name) 20} {2 $_addrText(Company) 25 5 7 } {m3 $_addrText(Adr) 30 {15 16 17} {18 19} 20}  {3 $_addrText(Telefon) 18 8 9 10} {1 $_addrText(FAX) 18 11} {3 $_addrText(Internet) 30 12 13 14}  {cont $_addrText(Descr) 40 21 } {1 ? 3 25}"

    set adrSearchIndexList  "4 7 19 8 11 12 21 25"
    set adrSearchIndex 4
    set adrSearchStringClearID -1
    set adrSearchString ""
    
    set adrSortCol   0
    set adrSortField [lindex $adrSearchIndexList $adrSortCol]

    set adrHierDepth 0
    tixScrolledHList $adrWin.l -width $adrSwidth  -height $adrSheight -options {
	hlist.header  true
	hlist.columns 32
	hlist.selectborderwidth 5
	hlist.drawbranch 0
	hlist.selectBackground DarkGoldenRod1
    }
    

    pack $adrWin.l -fill both -side top 
    set adro_list [$adrWin.l subwidget hlist]
    $adro_list configure -font $fnt12 -drawbranch 1 -background  "#FFF8F0" -indent [font measure $fnt12 "00"] -gap 10 -pady 10 -selectmode single

    set adrHStyle [tixDisplayStyle text  -refwindow $adro_list \
		       -fg black -anchor c \
		       -padx 8 -pady 2 -font $bfnt12]
    set adrHSortStyle [tixDisplayStyle text  -refwindow $adro_list \
		       -fg black -anchor c \
			   -padx 8 -pady 2 -font $bfnt12 -fg DarkGoldenRod4 ]
		       


    set col 0
    foreach ent $adrColList(0) {
	if { $col ==  $adrSortCol } {
	    $adro_list header create $col -itemtype text -text [lindex $ent 1] -style $adrHSortStyle
	} else {
	    $adro_list header create $col -itemtype text -text [lindex $ent 1] -style $adrHStyle
	}
	$adro_list column width  $col -char [lindex $ent 2 ]
	incr col
    }
    for { set i $col } { $i< 32 }  {incr i } {
	$adro_list column width 0
	$adro_list header create $i -borderwidth 0 -relief flat
    }
    set col 0
    foreach ent $adrColList2 {
	set adrColWidth($col) [$adro_list column width  $col]
	incr col
    }


    set adrSelection ""
    set adrPrevItem ""

    bind $adro_list <ButtonPress-1> {
	$adro_list selection clear 
 	set adrStartItem [$adro_list nearest  %y]
# 	puts "adrStartItem = $adrStartItem"
    }
    bind $adro_list <ButtonRelease-1> { 
	if { [winfo exists .pr ] == 0 } {
	    set adrCurItem [$adro_list nearest  %y]
	    if { $adrCurItem == $adrStartItem } {
		set adrSelection $adrStartItem
		update
		after 1 drawSelection
	    } else {
		if { [lsearch $adrSelection $adrStartItem] <0 } {
		    set adrSelection "$adrSelection $adrStartItem"
		}
		adrMoveSelection
	    }
	}
    }
    bind $adro_list <Control-ButtonRelease-1> { 
	set adrStartItem [$adro_list nearest  %y]
	if { [lsearch $adrSelection $adrStartItem] <0 } {
	    set adrSelection "$adrSelection $adrStartItem"
	}
	update
	after 1 drawSelection
    }
    bind $adro_list <Double-Button-1> adrOpenSelItem

    bind $adro_list <ButtonPress-3> { 
	$adro_list selection clear 
	set adrSelection ""
    }
    bind $adro_list <ButtonRelease-3> {
	adrViewItem [$adro_list nearest  %y]
    }
}

proc adrMoveSelection { } {
    global adrSelection  adrCurItem adrDirList
    global adr_list aid2idx adro_list idx2aid  dirid2idx adrPath adrDirPath idx2dirid

    set obj   [string range   [lindex [split  $adrCurItem .] end] 0 2 ]
    if { $obj == "Dir" || $adrCurItem == "." } {
	if { $adrCurItem == "." } { set destid 0 } else {
	    set idx [trimLead0  [string range   [lindex [split  $adrCurItem .] end] 3 end ]]
	    set destid $idx2dirid($idx)
	}
	set selList [lsort $adrSelection]
	reconnectEntriesToDir $destid $selList
    }
    adrColorizeAdrList
    $adro_list selection clear 
    set adrSelection ""
    update
}
proc reconnectEntriesToDir { destid entList } {
    global adrSelection  adrCurItem adrDirList
    global adr_list aid2idx adro_list idx2aid  dirid2idx adrPath adrDirPath
    global username  idx2dirid
    
    set moveCmd  "transfer moveAdrObjToFolder $username $destid"
    foreach ent $entList {
	set list [split  $ent .]
	set obj  [lindex $list end]
	set type   [string range   $obj  0 2 ]
	set idx [trimLead0 [string range   $obj  3 end ]]
	if { $type == "adr" } {
	    set adr [lindex  $adr_list $idx]
	    set adr [lreplace $adr 26 26 $destid]
	    set adr_list [lreplace $adr_list $idx $idx $adr]
	    lappend moveCmd "adr" $idx2aid($idx)
	}
	if { $type == "Dir" } {
	    set dirid $idx2dirid($idx)
	    set dir [lindex $adrDirList $idx]
	    set dir [ lreplace $dir 2 2 $destid]
	    set adrDirList [ lreplace $adrDirList $idx $idx $dir]
	    lappend moveCmd "dir" $dirid
	}
    }
    eval $moveCmd 
    set adrDirList [ request getAdrFolders  $username ]
    if { $adrDirList == "Error" } { return }
    set adr_list [request getAdrList $username ]     
    if { $adr_list == "Error" } { return }
    fillAddressNew
}
proc drawSelection { } {
    global adro_list adrSelection
    
    foreach sel $adrSelection {
	$adro_list selection set $sel
    }
}
proc drawAdrFilterDialog { } {
    global editMode fnt bfnt adfList
    global addc_namet addc_name1 addc_nameM addc_name2  addc_compS addc_comp addc_compPos
    global addc_fon addc_fon2 addc_fon3 addc_fax addc_mail addc_mail2 addc_www
    global addc_adr1a addc_adr1b addc_adr1c addc_plz1 addc_city1 addc_cntry1
    global addc_descrS 
    global _buttonText _addrText

    if { [winfo exists .adf ] == 1 } { return }
    clearCurrent
    if { [info exists adfList] == 1 } {
	set addc_namet    [lindex $adfList  1]
	set addc_name1    [lindex $adfList  2]
	set addc_nameM    [lindex $adfList  3]
	set addc_name2    [lindex $adfList  4]
	set addc_compS    [lindex $adfList  5]
	set addc_compPos  [lindex $adfList  6]
	set addc_comp     [lindex $adfList  7]
	set addc_fon      [lindex $adfList  8]
	set addc_fon2     [lindex $adfList  9]
	set addc_fon3     [lindex $adfList 10]
	set addc_fax      [lindex $adfList 11]
	set addc_mail     [lindex $adfList 12]
	set addc_mail2    [lindex $adfList 13]
	set addc_www      [lindex $adfList 14]
	set addc_adr1a    [lindex $adfList 15]
	set addc_adr1b    [lindex $adfList 16]
	set addc_adr1c    [lindex $adfList 17]
	set addc_plz1     [lindex $adfList 18]
	set addc_city1    [lindex $adfList 19]
	set addc_cntry1   [lindex $adfList 20]
	set addc_descrS   [lindex $adfList 21]
    }
    
    toplevel .adf
    busyCursor .adf
    frame .adf.a -relief raised -bd 1
    frame .adf.b 
    pack .adf.a .adf.b -side top -fill x
    frame .adf.a.l  
    pack .adf.a.l   -side left -fill both  -padx 1 -pady 1
    
    centerWin .adf 426 783
    drawAdrView .adf.a.l -1

    button .adf.b.do -text $_addrText(ButtonFilter) -width 12 -font $bfnt -command {
	.adf.b.do configure -state disabled
	.adf.b.cf configure -state disabled
	.adf.b.abb configure -state disabled
	filterAdress
	update
	closeWin .adf
    }
    pack .adf.b.do -side right
    button .adf.b.cf -text $_addrText(ButtonClearFilter) -width 14 -font $fnt -command {
	.adf.b.do configure -state disabled
	.adf.b.cf configure -state disabled
	.adf.b.abb configure -state disabled
	clearAdrFilter
	update
	closeWin .adf
    }
    pack .adf.b.cf -side right -padx 4
    button .adf.b.abb -text $_buttonText(Cancel) -width 12  -font $fnt -command {
	closeWin .adf
    }
    pack .adf.b.abb -side left
    update
#    puts [wm geometry .adf]
    grab .adf
    wm title .adf $_addrText(wmTitel_adf)
    bind .adf <Return> {
	.adf.b.do configure -state disabled
	.adf.b.cf configure -state disabled
	.adf.b.abb configure -state disabled
	filterAdress
	update
	closeWin .adf
    }
    stdCursor .adf
}

proc clearAdrFilter { } {
    global adr_list adrFilter
    foreach adr $adr_list {
	set aid [lindex $adr 0]
	set adrFilter($aid) 1
    }
    fillAddressNew
}
proc filterAdress { } {
    global addc_namet addc_name1 addc_nameM addc_name2  addc_compS addc_comp addc_compPos
    global addc_fon addc_fon2 addc_fon3 addc_fax addc_mail addc_mail2 addc_www
    global addc_adr1a addc_adr1b addc_adr1c addc_plz1 addc_city1 addc_cntry1
    global addc_descrS 
    global adr_list adrFilter  adfList

    


    set adfList [ list "" $addc_namet $addc_name1 $addc_nameM $addc_name2 $addc_compS $addc_compPos $addc_comp \
		      $addc_fon $addc_fon2 $addc_fon3 $addc_fax $addc_mail $addc_mail2 $addc_www \
		      $addc_adr1a $addc_adr1b $addc_adr1c $addc_plz1 $addc_city1 $addc_cntry1 \
		      $addc_descrS "" "" "" "" "" "" ]
    set j 0
    for {set i 0 } {$i < 25 } { incr i}  {
	set f [lindex $adfList $i ]
	if { $f != "" } {
	    set filter($j) $f
	    set filterPos($j) $i
	    incr j
	}
    }

    if { $j > 0 } {
	foreach adr [lsort  -integer -index 0 $adr_list] {
	    set aid [lindex $adr 0]
	    set adrFilter($aid) 1
	    for { set i 0 } {$i < $j } {incr i } {
		if { [string match $filter($i) [lindex $adr $filterPos($i)] ] != 1} {
		    set adrFilter($aid) 0
		    break
		}
	    }
	}
    } else { 
	foreach adr $adr_list {
	    set aid [lindex $adr 0]
	    set adrFilter($aid) 1
	}
    }
    fillAddressNew
}
proc fillAddressNew { } {
    global adro_list adr_list adrColList adrDirList adrDirPath adrDirLastEntry adrDirLevel bfnt12 adrDirOpen
    global fnt12 adrDirStyle adrDirSelStyle adrItemstyle
    global adrDirChilds  adrMaxDirID adrDirIDlist aid2idx idx2aid  adrCols dirid2idx adrPath
    global adrNames adrNamesOT adrFilter adro_list adrCurListEntry idx2dirid
    global adrSortField adrColXmax adrXmax
    global adrLoadFirst _addrText
    global adrLastSearchMatch adrLastSearchMatchHidden adrLastSearchMatchCheckDepth
    global username
    
    set adrLastSearchMatch ""
    set adrLastSearchMatchHidden 0
    set adrLastSearchMatchCheckDepth 0
    set idx 0
    
    set adr_list [lsort  -index $adrSortField -dictionary $adr_list ]
    foreach adr $adr_list {
	set aid [ lindex  $adr 0]
	set aid2idx($aid) $idx
	set idx2aid($idx) $aid
	if { [lindex $adr 3] == "" || [lindex $adr 3] == " "} {
	    set name [string trim [format "%s %s" [lindex $adr 2] [lindex $adr 4]]]
	} else {
	    set name [string trim [format "%s %s. %s" [lindex $adr 2] [lindex $adr 3] [lindex $adr 4]]]
	}
	set adrNamesOT($aid) $name
	if { [lindex $adr 3] == "" || [lindex $adr 3] == " "} {
	    set name [string trim [format "%s %s %s" [lindex $adr 1] [lindex $adr 2] [lindex $adr 4]]]
	} else {
	    set name [string trim [format "%s %s %s. %s" [lindex $adr 1] [lindex $adr 2] [lindex $adr 3] [lindex $adr 4]]]
	}
	set adrNames($aid) $name
	incr idx
	if { $adrFilter($aid) == 0 } { 
	    continue
	}
    }

    set adrDirStyle  [tixDisplayStyle text  -refwindow $adro_list \
			  -fg "#B02000" -bg "#FFFDFB"  -font $bfnt12]
    set adrDirSelStyle  [tixDisplayStyle text  -refwindow $adro_list \
			     -fg "#B02000" -bg DarkGOldenRod2  -font $bfnt12]
    set adrItemstyle(0-0)  [tixDisplayStyle text  -refwindow $adro_list \
				-bg "#F8F8F8" -fg black  -font $fnt12 -pady 2 ]
    set adrItemstyle(1-0)  [tixDisplayStyle text  -refwindow $adro_list \
				-bg "#F0F0F0" -fg black  -font $fnt12 -pady 2 ]
    set adrItemstyle(0-1)  [tixDisplayStyle text  -refwindow $adro_list \
				-bg "#FCF8F4" -fg black  -font $fnt12 -pady 2 ]
    set adrItemstyle(1-1)  [tixDisplayStyle text  -refwindow $adro_list \
				-bg "#F4F0EC" -fg black  -font $fnt12 -pady 2 ]
    set adrCols [ llength $adrColList(0) ]
    

    $adro_list delete all
    #time sonsuming !!!
    #	     update 
    set adrMaxDirID 0
    set maxDirLevel 1
    set adrDirIDlist ""
    set idx 0
    set adrDirList [ lsort -index 1 $adrDirList ]
    set dirsProcessed 0
    set dirAnz [llength $adrDirList ]

    foreach dir  $adrDirList  {
	set parent [lindex $dir 2]
	set dirid  [lindex $dir 0]
	set dirnam [lindex $dir 1]

	if { $parent == $dirid} {
	}

	set dirid2idx($dirid) $idx
	set idx2dirid($idx)  $dirid
	if { $dirid > $adrMaxDirID } {set adrMaxDirID $dirid }
	lappend adrDirIDlist $dirid
	set adrDirChilds($dirid) ""
	set adrNames(d$dirid)  "$_addrText(Folder)  [lindex $dir 1 ]"
	set adrDirLevel($dirid) -1
	incr idx
	if { $parent == -1 } {
	    set adrDirLevel($dirid) 1
	    set adrDirPath($dirid) "."
	    incr dirsProcessed
	    set adrDirLevel(-1) -1
	} else {
	    set adrDirLevel($dirid) -1
	}
    }

    while { $dirsProcessed < $dirAnz } {
	set oldDP $dirsProcessed 
	foreach dir  $adrDirList  {
	    set parent [lindex $dir 2]
	    set dirid  [lindex $dir 0]
	    set dirnam [lindex $dir 1]
	    set idx $dirid2idx($dirid)
	    if { $adrDirLevel($dirid)<0 } {
		if { $adrDirLevel($parent) >= 0 } {
		    set adrDirLevel($dirid) [expr $adrDirLevel($parent) +1 ]
		    if { $adrDirLevel($dirid) > $maxDirLevel} { set maxDirLevel $adrDirLevel($dirid) }
		    set adrDirPath($dirid) [format "%s.Dir%06d" $adrDirPath($parent) $idx]	
		    set ent "$adrDirPath($dirid) Dir $idx $dirid"
		    lappend adrDirChilds($parent) $ent
		    incr dirsProcessed
		} 
	    }
	}
	if { $oldDP == $dirsProcessed } {
	    #There is a loop in the folder structure. We reconnect all remaining folder to the rootfolder
	    set cmd "transfer moveAdrObjToFolder $username 0"
	    foreach dir  $adrDirList  {
		set parent 0
		set dirid  [lindex $dir 0]
		set dirnam [lindex $dir 1]
		set idx $dirid2idx($dirid)
		if { $adrDirLevel($dirid)<0 } {
		    if { $adrDirLevel($parent) >= 0 } {
			set adrDirLevel($dirid) [expr $adrDirLevel($parent) +1 ]
			if { $adrDirLevel($dirid) > $maxDirLevel} { set maxDirLevel $adrDirLevel($dirid) }
			set adrDirPath($dirid) [format "%s.Dir%06d" $adrDirPath($parent) $idx]	
			set ent "$adrDirPath($dirid) Dir $idx $dirid"
			lappend adrDirChilds($parent) $ent
			incr dirsProcessed
			set cmd "$cmd dir $dirid"
		    } 
		}
	    }
	    eval $cmd
	    WarnDialog $_addrText(WarnFolderStructDamage)
	}
    }

    foreach adr $adr_list {
	set aid [lindex $adr 0]
	if { $adrFilter($aid) == 0 } { continue}
	set dirid [lindex $adr 26]
	if { [lsearch $adrDirIDlist $dirid] <0 } {
	    set dirid 0
	}
	set idx $aid2idx($aid)
	set adrPath($aid) [format "%s.adr%06d" $adrDirPath($dirid) $idx]
	set ent "$adrPath($aid) adr $idx $aid"
	lappend adrDirChilds($dirid) $ent
    }

    foreach dirid $adrDirIDlist {
	set adrDirChilds($dirid) [lsort $adrDirChilds($dirid) ]
    }



    foreach dir   $adrDirList  {
	set parent [lindex $dir 2]
	set dirid  [lindex $dir 0]
	if { $parent == -1 } {
	    adrListDir $dir $dirid -1 "-"
	}
    }    

    $adro_list column width  0 -char [expr  [lindex [lindex $adrColList(0) 0 ] 2 ] + 2*$maxDirLevel]
    if { $adrCurListEntry != "" } {
	catch {$adro_list see $adrCurListEntry }
    }
    set adrCurListEntry ""
    
    adrColorizeAdrList
    set xmax  [ $adro_list column width 0 ]
    set adrColXmax(0) $xmax
    for { set i 1} { $i < 32 } {incr i} {
	set w [ $adro_list column width $i]
	set xmax [ expr $xmax + $w ]
	set adrColXmax($i) $xmax
    }
    set adrXmax $xmax
    after 250 {focus $adro_list}
    
    global adrSearchIndex adrSearchIndexList adrSearchString adrSearchStringClearID
    
    
    
    
    bind $adro_list <KeyPress> {
	adrDoSearch %x %A
    }
    global adrWin
    update
    
    set adrListHeaderWin [lindex [winfo children $adro_list] 0 ]
    bind $adrListHeaderWin <Button-1> {adrSetSortField %x }
}

proc adrSetSortField { xp } {
    global adro_list adrColXmax adrCols adrSearchIndexList  adrSortField adrSortCol adrHSortStyle adrHStyle
    set offset [expr [$adro_list xview]]
    set xk [expr $xp + $offset]
    set col 0
    while { $adrColXmax($col) < $xk } {
	incr col
	if { $col == 32 } { break }
    }
    if { $col >=$adrCols } { 
	set col $adrCols
	incr col -1
    }
    $adro_list header configure $adrSortCol  -style $adrHStyle
    set adrSortCol $col
    set adrSortField [lindex $adrSearchIndexList $col]
    $adro_list header configure $adrSortCol  -style $adrHSortStyle
    fillAddressNew
}
proc adrDoSearch { xp key } {
    global adro_list adrColXmax adrCols adrSearchIndexList adrSearchIndex adrSearchString adrSearchStringClearID
    global adrSearchString  adr_list aid2idx adrPath  adrSelection
    global adrLastSearchMatch adrLastSearchMatchHidden  adrLastSearchMatchCheckDepth
    
    
    if { $key == "" } { return}
    set offset [expr [$adro_list xview]]
    set xk [expr $xp + $offset]
    set col 0
    while { $adrColXmax($col) < $xk } {
	incr col
	if { $col == 32 } { break }
    }
    if { $col >=$adrCols } { 
	set col $adrCols
	incr col -1
    }
    set idx [lindex $adrSearchIndexList $col]
    if { $idx != $adrSearchIndex } {
	set adrSearchString ""
	set adrSearchIndex $idx
    } else {
	if { $adrSearchStringClearID >=0 } {
	    after cancel $adrSearchStringClearID
	}
    }
    set adrSearchString [format "%s%s" $adrSearchString $key ]
    set aid -1
    foreach adr $adr_list {
	if { [matchString $adrSearchString [lindex $adr $adrSearchIndex] ] == 1 } {
 	    set aid [lindex $adr 0] 
 	    break
 	}

    }
    if { $aid >=0} {
	set idx $aid2idx($aid)
#	puts "found aid=$aid/idx=$idx : [lindex [lindex $adr_list $idx] $adrSearchIndex] -> $adrPath($aid)"
	$adro_list selection clear
	set adrSelection ""
	#	puts "$adrLastSearchMatchHidden : $adrPath($aid) != $adrLastSearchMatch ?"
	if {$adrLastSearchMatchHidden == 1 } {
	    if { $adrPath($aid) != $adrLastSearchMatch} {
#		puts "\t\tHiding old match"
		$adro_list hide entry $adrLastSearchMatch
	    }
	}
	if { [ $adro_list info hidden $adrPath($aid)] == 1 } {
	    $adro_list show entry $adrPath($aid)
	    set adrLastSearchMatchHidden  1
	    set adrLastSearchMatchCheckDepth 0
	    after 15000 adrCheckSelection4HiddenSearchResult
	    set parent [$adro_list info parent $adrPath($aid)]
	    while { [$adro_list info hidden $parent] == 1 } {
		$adro_list show entry $parent
		set parent [$adro_list info parent $parent]
	    }
	}
	catch {$adro_list see $adrPath($aid)}
	$adro_list anchor set $adrPath($aid)
	$adro_list selection set $adrPath($aid)
	set adrLastSearchMatch $adrPath($aid)
#	puts "selection: [$adro_list info selection]"
	update
#     } else {
# 	puts "nothing found"
    }
    set adrSearchStringClearID [after 1000 { set adrSearchString "" }]
}

proc adrCheckSelection4HiddenSearchResult { } {
    global adrLastSearchMatch adro_list  adrLastSearchMatchCheckDepth

    if { $adrLastSearchMatch == "" } { return}

    set stillSeletced [$adro_list selection includes $adrLastSearchMatch]
#    puts "selction: [$adro_list info selection]  <- $adrLastSearchMatch => $stillSeletced /$adrLastSearchMatchCheckDepth "
    if { $stillSeletced == 0 } {
#	$adro_list hide entry $adrLastSearchMatch
	adrHideEntries $adrLastSearchMatch
    } else {
	incr adrLastSearchMatchCheckDepth
	if {$adrLastSearchMatchCheckDepth <60} {
	    after 15000 adrCheckSelection4HiddenSearchResult
	} else {
	    adrHideEntries $adrLastSearchMatch
#	    $adro_list hide entry $adrLastSearchMatch
	}
    }
}
proc adrHideEntries { ent } {
    global adro_list adrDirOpen

    $adro_list hide entry $ent
    set parent [$adro_list info parent $ent]
    set hs [ $adro_list info hidden $parent ]
    set pparent [$adro_list info parent $parent]
    set dirid [trimLead0 [string range [lindex [ split $pparent .] end]  3 end ] ]
#    puts "PARENT : hidden=$hs  open=$adrDirOpen($dirid)"
    while {$hs == 0 && $adrDirOpen($dirid) == 0 } {
	$adro_list hide entry $parent
	set parent $pparent
	set pparent [$adro_list info parent $parent]
	set dirid [trimLead0 [string range [lindex [ split $pparent .] end]  3 end ] ]
	set hs [ $adro_list info hidden $parent ]
#	puts "PARENT : hidden=$hs  open=$adrDirOpen($dirid)"
    }
}
proc adrListDir { dir dirid parent after} {
    global adrDirChilds adrDirList dirid2idx adr_list idx2dirid

    adrAddDir2Dir [lindex $dir 1]  $dirid $parent  "-"
 

    set last "-"
    set c 0
    foreach ent $adrDirChilds($dirid) {
	incr c
	set path [lindex $ent 0]
	set type [lindex $ent 1]
	set idx  [lindex $ent 2]
	set id   [lindex $ent 3]
	
	if { $type == "Dir" } {
	    adrListDir [lindex $adrDirList $idx] $id $dirid $last
	    set last $path
	}
	if { $type == "adr" } {
	    adrAddAdr2Dir [lindex $adr_list $idx] $idx $id $dirid $last
	    set last $path
	}			   
    }
    adrOpenCloseDir $dirid
}

proc adrAddDir2Dir { dirnam dirid parent  after} {
    global adrDirLevel adrDirPath adro_list adrDirStyle adrDirLastEntry adrCols 

    if { $parent == -1 } {
	set row [$adro_list add $adrDirPath($dirid) -itemtype text -text $dirnam -style $adrDirStyle]
    } else { 
	if { $after == "-" } {
	    set row [$adro_list add $adrDirPath($dirid) -itemtype text -text $dirnam -style $adrDirStyle]
	} else {
	    set row [$adro_list add $adrDirPath($dirid) -itemtype text -text $dirnam -style $adrDirStyle -after $after]
	}
    }
    for { set i 1} { $i < $adrCols } {incr i} {
	$adro_list item create $row  $i -itemtype text  -text ""  -style $adrDirStyle
    }
}

proc adrColorizeAdrList { } {
    global adrItemstyle adro_list adrCols
    

    set sum1 0
    set sum2 0
    set sum3 0
    set path "."
    set ic 0
    while { $path != "" } {
	if { [$adro_list info hidden $path] == 0 } {
	    if { [string match "*adr*" $path] == 1} {
		$adro_list entryconfigure $path -style $adrItemstyle($ic-0)
		set j 0
		for { set i 1} { $i < $adrCols } {incr i} {
		    
		    set j [ expr $j ^ 1]
		    $adro_list item configure $path $i  -style $adrItemstyle($ic-$j)
		}
		set ic [ expr $ic ^ 1]
	    }
	}
	set path [ $adro_list info next $path]
    }
}
proc adrAddAdr2Dir { adr idx aid dirid after } { 
    global adrColList  adro_list adrItemstyle   fnt12 bfnt12 adrDirPath idx2aid aid2idx
    global adrPath adrNames
 
    set name "$adrNames($aid)\n"
    set w  [lindex [lindex $adrColList(0) 0] 2 ]
    set txt [ strTrunc2 $name  $w   $fnt12]


    if { $after != "-" } {
	set row [$adro_list add $adrPath($aid) -itemtype text  -text $txt -after $after -style $adrItemstyle(0-0) ] 
    } else {
	set row [$adro_list add $adrPath($aid) -itemtype text  -text $txt -style $adrItemstyle(0-0) ]
    }
    
    fillAddressLine	$adr $row $adrItemstyle(0-0) $aid
}
proc fillAddressLine {  adr row style aid} {
    global adrColList2 adro_list fnt12  adrNamesOT adrColWidth

    set i 0 
    foreach ent $adrColList2 {
	set type  [lindex $ent 0]
	set chars [lindex $ent 2]
	set txt1 ""
	set txt2 ""
	set txt3 ""
	if { $type == "name" } {
	    set txt1 [lindex $adr 1]
	    set txt2 $adrNamesOT($aid)
	} elseif { $type == "cont" } {
	    set txt1 [lindex $adr [lindex $ent 3] ]
	} elseif { $type == "1" } {
	    set txt1  [lindex $adr [lindex $ent 3] ]
	} elseif { $type == "2" } {
	    set txt1  [lindex $adr [lindex $ent 3] ]
	    set txt2  [lindex $adr [lindex $ent 4] ]
	} elseif { $type == "3" } {
	    set txt1  [lindex $adr [lindex $ent 3] ]
	    set txt2  [lindex $adr [lindex $ent 4] ]
	    set txt3  [lindex $adr [lindex $ent 5] ]
	} elseif { $type == "m1" } {
	    foreach nr [lindex $ent 3] {   set txt1 "$txt1 [lindex $adr $nr]"}
	} elseif { $type == "m2" } {
	    foreach nr [lindex $ent 3] {   set txt1 "$txt1 [lindex $adr $nr]"}
	    foreach nr [lindex $ent 4] {   set txt2 "$txt2 [lindex $adr $nr]"}
	} elseif { $type == "m3" } {
	    foreach nr [lindex $ent 3] {   set txt1 "$txt1 [lindex $adr $nr]"}
	    foreach nr [lindex $ent 4] {   set txt2 "$txt2 [lindex $adr $nr]"}
	    foreach nr [lindex $ent 5] {   set txt3 "$txt3 [lindex $adr $nr]"}
	}
	if { $type == "cont" } {
	    set txt [strWarpTrunc3 $txt1 $adrColWidth($i) $fnt12 3]
	} else {
	    set txt1 [ strTrunc3 $txt1 $adrColWidth($i) $fnt12  $chars ]
	    set txt2 [ strTrunc3 $txt2 $adrColWidth($i) $fnt12  $chars ]
	    set txt3 [ strTrunc3 $txt3 $adrColWidth($i) $fnt12  $chars ]
	    set txt "$txt1\n$txt2\n$txt3"
	}
	$adro_list item create $row  $i -itemtype text  -text $txt  -style $style
	incr i
    }
}

proc adrFolderDefOpenState4All { } {
    global adrDirList adrDirPath adrDirOpen

    foreach dir $adrDirList {
	set dirid [lindex $dir 0]
	if { $dirid >0 } {
	    set adrDirOpen($dirid) [lindex $dir 4] 
	} else {
	    set adrDirOpen($dirid) 1
	}
    }

    foreach dir $adrDirList {
	set dirid [lindex $dir 0]
	set parent [lindex $dir 2]
	if { $dirid > 0 } {
	    if { $adrDirOpen($parent) == 1 } {adrOpenCloseDir $dirid }
	} else {
	    adrOpenCloseDir $dirid
	}
    }
}
proc adrFolderOpenAll { } {
    global adrDirList
    foreach dir $adrDirList {
	set dirid [lindex $dir 0]
	set adrDirOpen($dirid) 1
    }
    
}
proc adrFolderCloseAll { } {
    global adrDirList
    foreach dir $adrDirList {
	set dirid [lindex $dir 0]
	set adrDirOpen($dirid) 0
    }
    
}
proc adrOpenSelItem { } { 
    global adro_list adrDirOpen adr_list adrv_sel  adro_descr addc_descr  adrDirPath adrLastSel idx2dirid
    global adrSelection

    update
    set sel [$adro_list info selection ]
    if { $sel == "" } {return}

    $adro_list selection clear $sel 
    $adro_list anchor clear
    set adrSelection ""

    set obj [lindex [split  $sel .] end]
    if { [string range $obj 0 2] == "Dir" || $sel == "." } {
	set dirid -1
	if { [string range $obj 0 2] == "Dir" } {
	    set idx [trimLead0 [string range $obj 3 end ]]
	    set dirid $idx2dirid($idx)
	}
	if { $sel == "." } { set dirid 0}
#	puts "$sel -> dirid=$dirid"
	if { $dirid >=0} {
	    set adrDirOpen($dirid) [ expr $adrDirOpen($dirid) ^ 1 ]
	    adrOpenCloseDir $dirid
	} 
    }
    set adrLastSel $sel
    update
    after 5 {  
	update
	$adro_list selection clear $adrLastSel 
	$adro_list anchor clear
	update
    }
    after 50 {  
	update
	$adro_list selection clear $adrLastSel 
	$adro_list anchor clear
	update
    }
    after 500 {  
	update
	$adro_list selection clear $adrLastSel 
	$adro_list anchor clear
	update
    }
}

proc adrOpenCloseDir { dirid  } {
    global adrDirOpen adro_list adrDirPath adrLastSearchMatch
    
    if { $adrDirOpen($dirid) == 0 } {
	foreach ent [$adro_list info children $adrDirPath($dirid)] {
	    $adro_list hide entry $ent
	}
#	set adrDirOpen($dirid) 0
    } else {
	foreach ent [$adro_list info children $adrDirPath($dirid)] {
	    $adro_list show entry  $ent
	    if { $ent == $adrLastSearchMatch} { set adrLastSearchMatch ""}
	}
#	set adrDirOpen($dirid) 1
	adrColorizeAdrList
    }
}
proc adrViewItem { sel } {
    global adro_list adrDirOpen adr_list adrv_sel  adro_descr addc_descr  adrDirPath adrLastSel idx2aid
    global adrCurListEntry idx2dirid
    update
    $adro_list selection clear $sel 
    $adro_list anchor clear

    set adrCurListEntry $sel
    set obj [lindex [split  $sel .] end]
    set idx [trimLead0 [string range $obj 3 end ] ]
    if { [string range $obj 0 2] == "adr" } {
	set aid $idx2aid($idx)
#	set adr [lindex $adr_list $idx]
	set adrv_sel $aid
	if { [setSelection2Current $aid] < 0} { return}
	viewAddressDialog  0
    }  else  {
	set dirid $idx2dirid($idx)
#	set dirid [trimLead0 [string range $obj 3 end ] ]
	viewAdrFolder $dirid
    }
    set adrLastSel $sel
    update
    after 5 {  
	update
	$adro_list selection clear $adrLastSel 
	$adro_list anchor clear
	update
    }
    after 50 {  
	update
	$adro_list selection clear $adrLastSel 
	$adro_list anchor clear
	update
    }
    after 500 {  
	update
	$adro_list selection clear $adrLastSel 
	$adro_list anchor clear
	update
    }
}

proc newAddress { } {
    global adro_list idx2aid
    
    set sel [$adro_list info selection ]
    if { $sel != ""} {
	set obj [lindex [split  $sel .] end]
	if {[string range $obj 0 2] == "Dir" } {
	    clearCurrent
	} else {
	    set idx [trimLead0 [string range $obj 3 end ] ]
	    set aid $idx2aid($idx)
	    setSelection2Current $aid
	    partialClearCurrent
	}
    } else {
	clearCurrent
    }
    viewAddressDialog 1
}

proc viewAddressDialog { newAdr } {
    global editMode fnt bfnt addr_id adrCurListEntry adro_list adrNames  addc_perm
    global _buttonText _addrText windHeight windWidth
    global adrViewWidgetList adrViewButtonList

    if { [winfo exists .adv ] == 1 } { return }
    set editMode $newAdr
    set adrNames(-1) $_addrText(newAddressName)
    toplevel .adv
    busyCursor .adv

    frame .adv.a -relief raised -bd 1
    frame .adv.b 
    pack .adv.a .adv.b -side top -fill x
    frame .adv.a.l  
    frame .adv.a.r 
    pack .adv.a.l  .adv.a.r -side left -fill both  -padx 1 -pady 1
    
#    centerWin .adv 1148 794
    set vadWidth 1148
    set vadHeight 794
    set noteOffx  0
    set noteOffy  0
    if {$windHeight < 800 } { 
	set vadHeight 704
	set noteOffy -90
    }
    if { $windWidth < 1148 } {
	set noteOffx [expr $windWidth -1148 ]
	incr vadWidth $noteOffx
    }

    centerWin .adv $vadWidth $vadHeight
    drawAdrView .adv.a.l $editMode
    drawNotizBlock .adv.a.r [expr 720 + $noteOffx] [expr 720 + $noteOffy ] $addr_id $addc_perm

    set adro_button .adv.b.do
    button .adv.b.do -text $_buttonText(Close) -width 20 -font $fnt -command {
	.adv.b.do  configure -state disabled
	.adv.b.mod configure -state disabled
	.adv.b.del configure -state disabled
	closeNotiz
	if {$editMode == 1} {
	    changeAddress
	}
	closeWin .adv
	if { $adrCurListEntry != "" } {
	    catch {$adro_list see $adrCurListEntry}
	}
    }
    pack .adv.b.do -side right
    button .adv.b.mod -text $_buttonText(Modify) -width 20  -font $fnt -command {
	set editMode [expr ($editMode+1) %2]
	if { $editMode == 1} {
	    .adv.b.mod configure -text $_buttonText(ApplyChange)
	    .adv.b.do  configure -text $_buttonText(Accept)
	    foreach ent $adrViewWidgetList {
		$ent configure  -state normal -relief sunken -bg grey95
	    }
	    foreach ent $adrViewButtonList {
		$ent configure  -state normal 
	    }
	} else { 
	    .adv.b.mod configure -text $_buttonText(Modify)
	    .adv.b.do configure -text $_buttonText(Close) 
	    if { $addc_perm =="rwn" } { .adv.b.del configure -state normal}
	    foreach ent $adrViewWidgetList {
		$ent configure  -state disabled -relief flat -bg grey88
	    }
	    foreach ent $adrViewButtonList {
		$ent configure  -state  disabled
	    }
	    changeAddressNoRedraw
	    after 10 {
		adrRefillAddressFromADVinBG
	    }
	}
    }
    pack .adv.b.mod -side right -pady 3
    button .adv.b.ass -text $_addrText(AssignFolder) -width 20 -font $fnt -command adrDirListWin
    pack .adv.b.ass -side right -pady 3


    button .adv.b.del -text $_buttonText(Delete) -width 20 -font $fnt  -command {
	.adv.b.do  configure -state disabled
	.adv.b.mod configure -state disabled
	.adv.b.del configure -state disabled
	checkDelAdrDialog
    }
    pack .adv.b.del -side right -padx 10 -pady 3


    if { $newAdr== 1} {
	.adv.b.do  configure -text $_buttonText(Accept)
	.adv.b.mod configure -text $_addrText(ApplyChange) 
	.adv.b.del configure -state disabled
    }
    if { $addc_perm !="rwn" } { 
	.adv.b.mod configure -state disabled
	.adv.b.del configure -state disabled
    }
    
    button .adv.b.abb -text $_buttonText(Cancel) -width 20 -font $fnt   -command { destroy .adv }
    pack .adv.b.abb -side left
    wm title .adv "$_addrText(wmTitel_adv) \"$adrNames($addr_id)\""
    update 
    stdCursor .adv
}

proc adrRefillAddressFromADVinBG { } {
    set statDo  [ .adv.b.do  cget -state ]
    set statMod [ .adv.b.mod cget -state ]
    set statDel [ .adv.b.del cget -state ]
    set statAbb [ .adv.b.abb cget -state ]
    set statAss [ .adv.b.ass cget -state ]
    .adv.b.do  configure -state disabled
    .adv.b.mod configure -state disabled
    .adv.b.del configure -state disabled
    .adv.b.abb configure -state disabled
    .adv.b.ass configure -state disabled
    update
    
    fillAddressNew

    .adv.b.do  configure -state $statDo
    .adv.b.mod configure -state $statMod
    .adv.b.del configure -state $statDel
    .adv.b.abb configure -state $statAbb
    .adv.b.ass configure -state $statAss
    update
}

proc setSelection2Current { aid } {
    global adro_list adr_list adro_descr addr_id addc_owner adro_button
    global addc_namet addc_name1 addc_nameM addc_name2  addc_compS addc_comp addc_compPos
    global addc_fon addc_fon2 addc_fon3 addc_fon4  addc_fax addc_mail addc_mail2 addc_www
    global addc_adr1a addc_adr1b addc_adr1c addc_plz1 addc_city1 addc_cntry1
    global addc_adr2a addc_adr2b addc_adr2c addc_plz2 addc_city2 addc_cntry2
    global addc_adrPa addc_adrPb addc_adrPc addc_plzP addc_cityP addc_cntryP 
    global addc_fonP addc_faxP addc_infoP addc_mailP addc_wwwP
    global addc_descrS addc_descr  addc_geb addc_info  
    global addc_owner addc_notes addc_ro
    global addc_bank1 addc_konto1 addc_blz1 addc_kname1 
    global addc_bank2 addc_konto2 addc_blz2 addc_kname2 addc_steuer
    global addc_create addc_modify addc_creator addc_modifier addc_perm 
    global username


    set adr [ request getFullAdr $username $aid]
    if { $adr == "Error" } { return -1 }
    set addr_id       [lindex $adr  0]
    set addc_namet    [lindex $adr  1]
    set addc_name1    [lindex $adr  2]
    set addc_nameM    [lindex $adr  3]
    set addc_name2    [lindex $adr  4]
    set addc_compS    [lindex $adr  5]
    set addc_compPos  [lindex $adr  6]
    set addc_comp     [lindex $adr  7]
    set addc_fon      [lindex $adr  8]
    set addc_fon2     [lindex $adr  9]
    set addc_fon3     [lindex $adr 10]
    set addc_fon4     [lindex $adr 11]
    set addc_fonP     [lindex $adr 12]
    set addc_fax      [lindex $adr 13]
    set addc_faxP     [lindex $adr 14]
    set addc_mail     [lindex $adr 15]
    set addc_mail2    [lindex $adr 16]
    set addc_mailP    [lindex $adr 17]
    set addc_www      [lindex $adr 18]
    set addc_wwwP     [lindex $adr 19]

    set addc_adr1a    [lindex $adr 20]
    set addc_adr1b    [lindex $adr 21]
    set addc_adr1c    [lindex $adr 22]
    set addc_plz1     [lindex $adr 23]
    set addc_city1    [lindex $adr 24]
    set addc_cntry1   [lindex $adr 25]
    set addc_adr2a    [lindex $adr 26]
    set addc_adr2b    [lindex $adr 27]
    set addc_adr2c    [lindex $adr 28]
    set addc_plz2     [lindex $adr 29]
    set addc_city2    [lindex $adr 30]
    set addc_cntry2   [lindex $adr 31]
    set addc_adrPa    [lindex $adr 32]
    set addc_adrPb    [lindex $adr 33]
    set addc_adrPc    [lindex $adr 34]
    set addc_plzP     [lindex $adr 35]
    set addc_cityP    [lindex $adr 36]
    set addc_cntryP   [lindex $adr 37]

    set addc_descrS [lindex $adr 38]
    set addc_descr  [lindex $adr 39]
    set addc_info   [lindex $adr 40]
    set addc_infoP  [lindex $adr 41]
    set addc_geb    [lindex $adr 42]
    set addc_kname1 [lindex $adr 43]
    set addc_konto1 [lindex $adr 44]
    set addc_bank1  [lindex $adr 45]
    set addc_blz1   [lindex $adr 46]
    set addc_kname2 [lindex $adr 47]
    set addc_konto2 [lindex $adr 48]
    set addc_bank2  [lindex $adr 49]
    set addc_blz2   [lindex $adr 50]
    set addc_steuer [lindex $adr 51]
    set addc_owner  [lindex $adr 52]
    set addc_notes  [lindex $adr 53]
    set addc_ro     [lindex $adr 54]
    set addc_create [lindex $adr 56]
    set addc_modify [lindex $adr 57]
    set addc_creator [lindex $adr 58]
    set addc_modifier [lindex $adr 59]
    set addc_perm   [lindex $adr 61]
    return 0
}
proc partialClearCurrent {  } {
    global adro_list adr_list adro_descr addr_id addc_owner adro_button
    global addc_namet addc_name1 addc_nameM addc_name2  addc_compS addc_comp addc_compPos
    global addc_fon addc_fon2 addc_fon3 addc_fon4  addc_fax addc_mail addc_mail2 addc_www
    global addc_adr1a addc_adr1b addc_adr1c addc_plz1 addc_city1 addc_cntry1
    global addc_adr2a addc_adr2b addc_adr2c addc_plz2 addc_city2 addc_cntry2
    global addc_adrPa addc_adrPb addc_adrPc addc_plzP addc_cityP addc_cntryP 
    global addc_fonP addc_faxP addc_infoP addc_mailP addc_wwwP
    global addc_descrS addc_descr  addc_geb addc_info  
    global addc_owner addc_notes addc_ro
    global addc_bank1 addc_konto1 addc_blz1 addc_kname1 
    global addc_bank2 addc_konto2 addc_blz2 addc_kname2 addc_steuer
    global addc_create addc_modify addc_creator addc_modifier today username  


    set addr_id     -1
    set addc_namet  ""
    set addc_name1  ""
    set addc_nameM  ""
    set addc_name2  ""
    set addc_compPos ""
    set addc_fonP   ""
    set p [string first "@" $addc_mail]
    set addc_mail [string range $addc_mail $p end]
    set p [string first "@" $addc_mail2]
    set addc_mail2 [string range $addc_mail2 $p end]

    set addc_adr2a   ""
    set addc_adr2b  ""
    set addc_adr2c  ""
    set addc_plz2   ""
    set addc_city2  ""
    set addc_cntry2 ""


    set addc_adrPa  ""
    set addc_adrPb  ""
    set addc_adrPc  ""
    set addc_plzP   ""
    set addc_cityP  ""
    set addc_cntryP ""
    set addc_faxP   ""
    set addc_mailP  ""
    set addc_wwwP   ""
    set addc_geb    ""
    set addc_infoP  ""
    set addc_create $today
    set addc_modify $today
    set addc_creator $username
    set addc_modifier $username
    set addc_perm "rwn"
}

proc clearCurrent {  } {
    global adro_list adr_list adro_descr addr_id addc_owner adro_button
    global addc_namet addc_name1 addc_nameM addc_name2  addc_compS addc_comp addc_compPos
    global addc_fon addc_fon2 addc_fon3 addc_fon4  addc_fax addc_mail addc_mail2 addc_www
    global addc_adr1a addc_adr1b addc_adr1c addc_plz1 addc_city1 addc_cntry1
    global addc_adr2a addc_adr2b addc_adr2c addc_plz2 addc_city2 addc_cntry2
    global addc_adrPa addc_adrPb addc_adrPc addc_plzP addc_cityP addc_cntryP 
    global addc_fonP addc_faxP addc_infoP addc_mailP addc_wwwP
    global addc_descrS addc_descr  addc_geb addc_info  
    global addc_owner addc_notes addc_ro
    global addc_bank1 addc_konto1 addc_blz1 addc_kname1 
    global addc_bank2 addc_konto2 addc_blz2 addc_kname2 addc_steuer
    global addc_create addc_modify addc_creator addc_modifier today username addc_perm


    set addr_id     -1
    set addc_namet  ""
    set addc_name1  ""
    set addc_name2  ""
    set addc_compS  ""
    set addc_comp   ""
    set addc_compPos ""
    set addc_fon    ""
    set addc_fonP   ""
    set addc_fax    ""
    set addc_mail   ""
    set addc_www    ""

    set addc_adr1a  ""
    set addc_adr1b  ""
    set addc_adr1c  ""
    set addc_plz1   ""
    set addc_city1  ""
    set addc_cntry1 ""
    set addc_descrS ""
    set addc_descr  ""
    set addc_owner  ""
    set addc_notes  ""
    set addc_ro     ""


    set addc_nameM  ""
    set addc_fon2   ""
    set addc_fon3   ""
    set addc_fon4   ""
    set addc_mail2  ""

    set addc_adr2a   ""
    set addc_adr2b  ""
    set addc_adr2c  ""
    set addc_plz2   ""
    set addc_city2  ""
    set addc_cntry2 ""

    set addc_bank1  ""
    set addc_konto1 ""
    set addc_blz1   ""
    set addc_kname1 ""
    set addc_bank2  ""
    set addc_konto2 ""
    set addc_blz2   ""
    set addc_kname2 ""
    set addc_steuer ""

    set addc_adrPa  ""
    set addc_adrPb  ""
    set addc_adrPc  ""
    set addc_plzP   ""
    set addc_cityP  ""
    set addc_cntryP ""
    set addc_faxP   ""
    set addc_mailP  ""
    set addc_wwwP   ""
    set addc_geb    ""
    set addc_infoP  ""
    set addc_info   ""  
    set addc_create $today
    set addc_modify $today
    set addc_creator $username
    set addc_modifier $username
    set addc_perm "rwn"
    set addc_owner  "Allgemein"
    set addc_notes  "Allgemein"
    set addc_ro     "Allgemein"
}



proc changeAddressNoRedraw { } {
    return [_changeAddress 0 ]
}
proc changeAddress { } {
    return [_changeAddress 1 ]
}
proc _changeAddress { doRedraw } {
    global adro_list adr_list adro_descr addr_id addc_owner adro_button
    global addc_namet addc_name1 addc_nameM addc_name2  addc_compS addc_comp addc_compPos
    global addc_fon addc_fon2 addc_fon3 addc_fon4  addc_fax addc_mail addc_mail2 addc_www
    global addc_adr1a addc_adr1b addc_adr1c addc_plz1 addc_city1 addc_cntry1
    global addc_adr2a addc_adr2b addc_adr2c addc_plz2 addc_city2 addc_cntry2
    global addc_adrPa addc_adrPb addc_adrPc addc_plzP addc_cityP addc_cntryP 
    global addc_fonP addc_faxP addc_infoP addc_mailP addc_wwwP
    global addc_descrS addc_descr  addc_geb addc_info  
    global addc_owner addc_notes addc_ro
    global addc_bank1 addc_konto1 addc_blz1 addc_kname1 
    global addc_bank2 addc_konto2 addc_blz2 addc_kname2 addc_steuer
    global username aid2idx username idx2aid
    global addc_create addc_modify addc_creator addc_modifier today username adrFilter adrNames
    global adro_descr adro_info adro_infoP

    closeNotiz
    if { $addr_id <0 } {set add 1 } else { set add 0}
    
#    set addc_descr ""
#     set list [ $adro_descr dump -text 0.0 end]
#     set l [llength $list] 
#     for { set i 1} {$i < $l } {incr i 3 } {
# 	set addc_descr "$addc_descr [lindex $list $i ]"
#     }
    set addc_descr [ braces2parenthesis [ $adro_descr get 0.0 end] ]
    set addc_info  [ braces2parenthesis [ $adro_info  get 0.0 end] ]
    set addc_infoP [ braces2parenthesis [ $adro_infoP get 0.0 end] ]
    
    set aid [ transfer changeAdr $addr_id $addc_namet $addc_name1 $addc_nameM $addc_name2 $addc_compS $addc_compPos $addc_comp $addc_fon $addc_fon2 $addc_fon3 $addc_fon4 $addc_fonP $addc_fax $addc_faxP $addc_mail $addc_mail2 $addc_mailP $addc_www $addc_wwwP $addc_adr1a $addc_adr1b $addc_adr1c $addc_plz1 $addc_city1 $addc_cntry1 $addc_adr2a $addc_adr2b $addc_adr2c $addc_plz2 $addc_city2 $addc_cntry2 $addc_adrPa $addc_adrPb $addc_adrPc $addc_plzP $addc_cityP $addc_cntryP $addc_descrS $addc_descr $addc_info $addc_infoP $addc_geb $addc_kname1 $addc_konto1 $addc_bank1 $addc_blz1 $addc_kname2 $addc_konto2 $addc_bank2 $addc_blz2 $addc_steuer $addc_owner $addc_notes $addc_ro $username]
    if { $aid == "Error" } { return}

    set adr [ request getAdr $username $aid]
    if { $adr == "Error" } { return}
    if { $add == 1 } { 
	set idx [llength $adr_list]
	lappend adr_list $adr
	set addr_id $aid
	set aid2idx($aid) $idx
	set idx2aid($idx) $aid
	set adrFilter($aid) 1
	if { [lindex $adr 3] == "" || [lindex $adr 3] == " "} {
	    set name [string trim [format "%s %s %s" [lindex $adr 1] [lindex $adr 2] [lindex $adr 4]]]
	} else {
	    set name [string trim [format "%s %s %s. %s" [lindex $adr 1] [lindex $adr 2] [lindex $adr 3] [lindex $adr 4]]]
	}
	set adrNames($aid) $name	
    } else {
	set idx $aid2idx($aid)
	set adr_list [lreplace $adr_list $idx $idx $adr]
    }

    set addc_modify $today
    set addc_modifier $username
    if { $doRedraw == 1 } {  
	fillAddressNew
    }

    #Rueckgae fuer NotizNBlock
    return $addr_id
}






proc drawAdrView { win edit } {
    global adro_list adr_list adro_descr addr_id addc_owner adro_button
    global addc_namet addc_name1 addc_nameM addc_name2 
    global addc_fon addc_fon2 addc_fonH addc_fonP addc_fax addc_mail addc_mail2 addc_www
    global addc_compS addc_comp   addc_compPos
    global addc_descrS addc_descr addc_owner addc_notes addc_ro
    global bfnt fnt fnt8 username groupList
    global adrViewWidgetList adrViewSmallWidgetList adrViewButtonList
    global _addrText addc_perm windHeight _buttonText
    global addo_permLine

    if {$edit == 1 } {
	set state "normal"
	set rel "sunken"
	set bg "grey95"
    } else {
	set state "disabled"
	set rel "flat"
	set bg "grey88"
    }

    set adrViewWidgetList ""
    set adrViewSmallWidgetList ""
    set adrViewButtonList ""

    frame $win.f -relief raised -bd 1
    frame $win.r -relief raised -bd 1
    pack $win.f  $win.r -side top -fill both
    frame $win.f.0 -relief  ridge -bd 2
    frame $win.f.1 -relief  ridge -bd 2
    frame $win.f.2 -relief  ridge -bd 2
    pack $win.f.0 $win.f.1  -side top -fill x -pady 4 -ipady 2
    pack  $win.f.2 -side top -fill x 

    
    #Name
    frame $win.f.0.h -relief flat
    frame $win.f.0.v -relief flat
    pack $win.f.0.h $win.f.0.v -side top -fill x
    label $win.f.0.h.l -text "Name" -font $bfnt
    entry $win.f.0.v.t -textvariable addc_namet -width  6 -font $fnt -state $state  -relief $rel -bg $bg -vcmd {checkEntryText %P 15  %d %S ""} -validate key
    entry $win.f.0.v.1 -textvariable addc_name1 -width 20 -font $fnt -state $state  -relief $rel -bg $bg -vcmd {checkEntryText %P 63  %d %S ""} -validate key
    entry $win.f.0.v.m -textvariable addc_nameM -width  1 -font $fnt -state $state -relief $rel -bg $bg -vcmd {checkEntryText %P 1  %d %S " "} -validate key
    label $win.f.0.v.d -text "." -font $bfnt
    entry $win.f.0.v.2 -textvariable addc_name2 -width 20 -font $fnt -state $state -relief $rel -bg $bg -vcmd {checkEntryText %P 63  %d %S ""} -validate key
    pack $win.f.0.h.l $win.f.0.v.t $win.f.0.v.1 $win.f.0.v.m  $win.f.0.v.d $win.f.0.v.2 -side left -fill x
    lappend adrViewWidgetList $win.f.0.v.t $win.f.0.v.1 $win.f.0.v.m $win.f.0.v.2 
    lappend adrViewSmallWidgetList $win.f.0.v.t $win.f.0.v.1 $win.f.0.v.m $win.f.0.v.2 
    
    #Firma
    frame $win.f.1.h -relief flat
    frame $win.f.1.l -relief flat
    frame $win.f.1.s -relief flat
    frame $win.f.1.v -relief flat
    pack $win.f.1.h  $win.f.1.l $win.f.1.s $win.f.1.v -side top -fill x
    label $win.f.1.h.l -text $_addrText(Company) -font $bfnt
    label $win.f.1.l.l -text $_addrText(ShortForm) -font $fnt8 -width 42
    label $win.f.1.l.p -text $_addrText(Position) -font $fnt8
    entry $win.f.1.s.v -textvariable addc_compS -width 15 -font $fnt -state $state -relief $rel -bg $bg\
	 -vcmd {checkEntryText %P 15  %d %S ""} -validate key

    label $win.f.1.s.s -text " " -font $fnt -width 10
    entry $win.f.1.s.p -textvariable addc_compPos -width 24 -font $fnt -state $state -relief $rel -bg $bg -vcmd {checkEntryText %P 31  %d %S ""} -validate key
    entry $win.f.1.v.v -textvariable addc_comp  -width 50 -font $fnt -state $state -relief $rel -bg $bg -vcmd {checkEntryText %P 63  %d %S ""} -validate key
    pack $win.f.1.h.l $win.f.1.l.l $win.f.1.l.p $win.f.1.s.v $win.f.1.s.s $win.f.1.s.p $win.f.1.v.v -side left -fill x

    lappend adrViewWidgetList $win.f.1.s.v $win.f.1.v.v  $win.f.1.s.p
    lappend adrViewSmallWidgetList $win.f.1.s.v $win.f.1.v.v  $win.f.1.s.p
    
    tixNoteBook $win.f.2.nb -ipadx 4 -ipady 4 
    $win.f.2.nb add addr -label  $_addrText(PageAddress) -underline -1
    $win.f.2.nb add tele -label  $_addrText(PageCommu) -underline -1
    $win.f.2.nb add bank -label  $_addrText(PageBank) -underline -1
    $win.f.2.nb add misc -label  $_addrText(PageMisc) -underline -1
    $win.f.2.nb add priv -label  $_addrText(PagePrivate) -underline -1
    pack $win.f.2.nb -side top

    drawAdrViewAdress  [$win.f.2.nb subwidget  addr] $state  $rel $bg 
    drawAdrViewTeleKom [$win.f.2.nb subwidget  tele] $state  $rel $bg 
    drawAdrViewBank    [$win.f.2.nb subwidget  bank] $state  $rel $bg 
    drawAdrViewMisc    [$win.f.2.nb subwidget  misc] $state  $rel $bg 
    drawAdrViewPrivat  [$win.f.2.nb subwidget  priv] $state  $rel $bg 

    set permMenuState "disabled" 
    if { $addc_perm == "rwn" } { 
	if { $edit == 1} {
	    set permMenuState normal 
	}
    }
    if { $windHeight > 800 } {
	if { $addc_perm == "rwn" } { 
	    lappend adrViewWidgetList $win.r.1.0.o $win.r.1.1.n $win.r.1.2.r 
	}
	drawAdrPerms $win.r $edit
	$win.r.1.0.o configure  -state $permMenuState
	$win.r.1.1.n configure  -state $permMenuState
	$win.r.1.2.r configure  -state $permMenuState
    } else {
	frame $win.r.0 -relief flat
	frame $win.r.1 -relief flat
	pack $win.r.0 $win.r.1  -side top -fill x -pady 2
	label $win.r.0.l -text $_addrText(AdrAccess)
	pack $win.r.0.l -side left
	set  addo_permLine $win.r.1.g

	label $addo_permLine -text  [strTrunc "[adrPermGroup2Name $addc_owner]/[adrPermGroup2Name $addc_notes]/[adrPermGroup2Name $addc_ro]" 40 ] -font $bfnt
	button $win.r.1.b -text $_buttonText(Modify) -font $fnt -command adrPermModiDialog -state disabled
	pack $addo_permLine  -side left
	pack $win.r.1.b  -side right
	if { $addc_perm == "rwn" } { 
	    lappend adrViewButtonList $win.r.1.b
	}
    }
    
    if { $edit == -1 } {
	$win.r.1.0.o configure  -state disabled
	$win.r.1.1.n configure  -state disabled
	$win.r.1.2.r configure  -state disabled
	$win.f.2.nb pageconfigure  priv  -state disabled

	foreach wid $adrViewSmallWidgetList { 
	    $wid configure  -state normal -relief sunken -bg grey95
	}
    }
}
proc adrPermModiDialog {  } {
    global addc_perm addc_owner addc_notes addc_ro
    global _adr_back_owner _adr_back_notes _adr_back_ro
    global addo_permLine
    global _addrText _buttonText

    toplevel .apmd 
    wm title .apmd $_addrText(AccessDialogTitle)
    centerWin .apmd 412 178
    frame .apmd.t -relief raised -bd 1
    frame .apmd.b -relief flat
    pack .apmd.t .apmd.b -side top -fill x
    
    set _adr_back_owner $addc_owner
    set _adr_back_notes $addc_notes
    set _adr_back_ro    $addc_ro
    drawAdrPerms .apmd.t 1

    button .apmd.b.can -text $_buttonText(Cancel) -command {
	set addc_owner $_adr_back_owner
	set addc_notes $_adr_back_notes
	set addc_ro    $_adr_back_ro
	$addo_permLine configure -text  [strTrunc "[adrPermGroup2Name $addc_owner]/[adrPermGroup2Name $addc_notes]/[adrPermGroup2Name $addc_ro]" 40 ]
	destroy .apmd
    }
    button .apmd.b.ok -text $_buttonText(Accept) -command {
	$addo_permLine configure -text [strTrunc "[adrPermGroup2Name $addc_owner]/[adrPermGroup2Name $addc_notes]/[adrPermGroup2Name $addc_ro]" 40 ]
	destroy .apmd
    }
    pack .apmd.b.can -side left
    pack .apmd.b.ok -side right
}
proc adrPermGroup2Name { grp } {
    global _addrText
    if { $grp == "Allgemein" } {
	return $_addrText(LabelAllg)
    }
    return $grp
}

proc drawAdrPerms { win edit} {
    global addc_perm addc_owner addc_notes addc_ro
    global userList groupList username
    global _addrText fnt bfnt



    frame $win.0 -relief flat
    frame $win.1 -relief flat
    pack $win.0 $win.1  -side top -fill x -pady 6
    label $win.0.l -text $_addrText(AdrAccess)
    pack $win.0.l -side left
    
    frame $win.1.0 -relief flat
    frame $win.1.1 -relief flat
    frame $win.1.2 -relief flat
    pack $win.1.0 $win.1.1 $win.1.2 -side top -fill x
    
    tixOptionMenu  $win.1.0.o -options {menubutton.width 22 label.width 24} -label $_addrText(AccessAll)
    $win.1.0.o subwidget label configure -font $bfnt 
    $win.1.0.o subwidget menubutton configure -font $fnt -disabledforeground grey30 -fg black
    tixOptionMenu  $win.1.1.n -options {menubutton.width 22 label.width 24} -label $_addrText(AccessNotes)
    $win.1.1.n subwidget label configure -font $bfnt
    $win.1.1.n subwidget menubutton configure -font $fnt -disabledforeground grey30 -fg black
    tixOptionMenu  $win.1.2.r -options {menubutton.width 22 label.width 24} -label $_addrText(AccessRO)
    $win.1.2.r subwidget label configure -font $bfnt
    $win.1.2.r subwidget menubutton configure -font $fnt -disabledforeground grey30 -fg black
    pack $win.1.0.o $win.1.1.n $win.1.2.r -side left 


    $win.1.0.o add command Allgemein -label $_addrText(LabelAllg)
    $win.1.0.o add separator sep1
    $win.1.0.o add command $username -label $username
    if { $addc_owner != "" } {
	if { $addc_owner != "Allgemein" } {
	    if { $addc_owner  != $username} {
		if { [lsearch $groupList $addc_owner ]< 0 } {
		    $win.1.0.o add command $addc_owner -label $addc_owner
		}
	    }
	}
    }
    $win.1.0.o add separator sep2

    $win.1.1.n add command Allgemein -label $_addrText(LabelAllg)
    $win.1.1.n add separator sep1
    $win.1.1.n add command $username -label $username
    if { $addc_notes != "" } {
	if { $addc_notes != "Allgemein" } {
	    if { $addc_notes  != $username} {
		if { [lsearch $groupList $addc_notes ]< 0 } {
		    $win.1.1.n add command $addc_notes -label $addc_notes
		}
	    }
	}
    }
    $win.1.1.n add separator sep2

    $win.1.2.r add command Allgemein -label $_addrText(LabelAllg)
    $win.1.2.r add separator sep1
    $win.1.2.r add command $username -label $username
    if { $addc_ro != "" } {
	if { $addc_ro != "Allgemein" } {
	    if { $addc_ro  != $username} {
		if { [lsearch $groupList $addc_ro ]< 0 } {
		    $win.1.2.r add command $addc_ro -label $addc_ro
		}
	    }
	}
    }
    $win.1.2.r add separator sep2
    foreach group $groupList {
	$win.1.0.o add command $group -label $group
	$win.1.1.n add command $group -label $group
	$win.1.2.r add command $group -label $group
    }
    
    $win.1.0.o configure  -variable addc_owner
    $win.1.1.n configure  -variable addc_notes
    $win.1.2.r configure  -variable addc_ro
#    puts ">>>> $addc_owner $addc_notes $addc_ro  <<<< state=$permMenuState"

}

proc drawAdrViewAdress {win state  rel bg  } {
    global addc_adr1a addc_adr1b addc_adr1c addc_plz1 addc_city1 addc_cntry1
    global addc_adr2a addc_adr2b addc_adr2c addc_plz2 addc_city2 addc_cntry2
    global bfnt fnt fnt8
    global adrViewWidgetList adrViewSmallWidgetList
    global _addrText

    frame $win.l -relief ridge  -bd 2
#    frame $win.m -relief flat
    frame $win.r -relief ridge -bd 2
    frame $win.t  -relief ridge -bd 2
    frame $win.m  -relief ridge -bd 2
    pack $win.l $win.r $win.t $win.m -side top -fill x
    for { set i 0 } {$i <8 } {incr i} {
	frame $win.l.$i -relief flat
	frame $win.r.$i -relief flat
	pack $win.l.$i $win.r.$i -side top -fill x
    }

    label $win.l.0.l -text $_addrText(Adr1)  -font $bfnt
    entry $win.l.1.l -textvariable addc_adr1a -width 48 -font $fnt -state $state -relief $rel -bg $bg -vcmd {checkEntryText %P 63  %d %S ""} -validate key
    entry $win.l.2.l -textvariable addc_adr1b -width 48 -font $fnt -state $state -relief $rel -bg $bg -vcmd {checkEntryText %P 63  %d %S ""} -validate key
    entry $win.l.3.l -textvariable addc_adr1c -width 48 -font $fnt -state $state -relief $rel -bg $bg -vcmd {checkEntryText %P 63  %d %S ""} -validate key
    label $win.l.4.l -text $_addrText(PLZort) -font $fnt8
    entry $win.l.5.l -textvariable addc_plz1  -width  7 -font $fnt -state $state -relief $rel -bg $bg -vcmd {checkEntryText %P 15  %d %S ""} -validate key
    entry $win.l.5.l2 -textvariable addc_city1 -width 40 -font $fnt -state $state -relief $rel -bg $bg -vcmd {checkEntryText %P 63  %d %S ""} -validate key
    label $win.l.6.l -text $_addrText(Staat)  -font $fnt8
    entry $win.l.7.l -textvariable addc_cntry1 -width 48 -font $fnt -state $state -relief $rel -bg $bg -vcmd {checkEntryText %P 63  %d %S ""} -validate key

    label $win.r.0.l -text $_addrText(Adr2)  -font $bfnt
    entry $win.r.1.l -textvariable addc_adr2a -width 48 -font $fnt -state $state -relief $rel -bg $bg -vcmd {checkEntryText %P 63  %d %S ""} -validate key
    entry $win.r.2.l -textvariable addc_adr2b -width 48 -font $fnt -state $state -relief $rel -bg $bg -vcmd {checkEntryText %P 63  %d %S ""} -validate key
    entry $win.r.3.l -textvariable addc_adr2c -width 48 -font $fnt -state $state -relief $rel -bg $bg -vcmd {checkEntryText %P 63  %d %S ""} -validate key
    label $win.r.4.l -text $_addrText(PLZort) -font $fnt8
    entry $win.r.5.l -textvariable addc_plz2  -width  7 -font $fnt -state $state -relief $rel -bg $bg -vcmd {checkEntryText %P 15  %d %S ""} -validate key
    entry $win.r.5.l2 -textvariable addc_city2 -width 40 -font $fnt -state $state -relief $rel -bg $bg -vcmd {checkEntryText %P 63  %d %S ""} -validate key
    label $win.r.6.l -text $_addrText(Staat)  -font $fnt8
    entry $win.r.7.l -textvariable addc_cntry2 -width 48 -font $fnt -state $state -relief $rel -bg $bg -vcmd {checkEntryText %P 63  %d %S ""} -validate key

    for { set i 0 } {$i <8 } {incr i} {
	pack $win.l.$i.l $win.r.$i.l -side left -fill x
    }
    pack $win.l.5.l2 $win.r.5.l2 -side left -fill x

    lappend adrViewWidgetList  $win.l.1.l $win.l.2.l $win.l.3.l $win.l.5.l $win.l.5.l2 $win.l.7.l
    lappend adrViewWidgetList  $win.r.1.l $win.r.2.l $win.r.3.l $win.r.5.l $win.r.5.l2 $win.r.7.l
    lappend adrViewSmallWidgetList  $win.l.1.l $win.l.2.l $win.l.3.l $win.l.5.l $win.l.5.l2 $win.l.7.l

    label $win.t.l -text $_addrText(Telefon) -font $bfnt -width 10
    entry $win.t.e -textvariable addc_fon   -width 38 -font $fnt -state $state -relief $rel -bg $bg -vcmd {checkEntryText %P 31  %d %S ""} -validate key
    pack $win.t.l $win.t.e -side left 
    
    label $win.m.l -text $_addrText(mail) -font $bfnt -width 10
    entry $win.m.e -textvariable addc_mail -width 38 -font $fnt -state $state -relief $rel -bg $bg -vcmd {checkEntryText %P 63  %d %S ""} -validate key
    pack $win.m.l $win.m.e  -side left

    lappend adrViewWidgetList $win.t.e $win.m.e
    lappend adrViewSmallWidgetList $win.t.e $win.m.e
}

proc drawAdrViewTeleKom { win state  rel bg } {
    global addc_fon addc_fon2 addc_fon3 addc_fon4 addc_fax addc_mail addc_mail2 addc_www
    global bfnt fnt fnt8
    global adrViewWidgetList adrViewSmallWidgetList
    global _addrText

    frame $win.f -relief ridge -bd 2
    frame $win.i -relief ridge -bd 2
    pack $win.f $win.i -side top -pady 4 -ipady 2 -ipadx 2

    frame $win.f.h -relief flat
    frame $win.f.1 -relief flat
    frame $win.f.l -relief flat
    frame $win.f.2 -relief flat
    frame $win.f.f -relief flat
    frame $win.f.fl -relief flat
    pack $win.f.h  $win.f.1 $win.f.l $win.f.2 $win.f.fl  $win.f.f -side top -fill x -ipadx 2 -ipady 2
    label $win.f.h.l -text $_addrText(Telefon) -font $bfnt
    entry $win.f.1.1 -textvariable addc_fon   -width 22 -font $fnt -state $state -relief $rel -bg $bg -vcmd {checkEntryText %P 31  %d %S ""} -validate key
    label $win.f.1.s -text "    " -font $fnt
    entry $win.f.1.2 -textvariable addc_fon2  -width 22 -font $fnt -state $state -relief $rel -bg $bg -vcmd {checkEntryText %P 31  %d %S ""} -validate key
    label $win.f.l.1 -text $_addrText(Handy) -font $fnt8 -width 40
    label $win.f.l.2 -text "" -font $fnt8
    entry $win.f.2.1 -textvariable addc_fon3  -width 22 -font $fnt -state $state -relief $rel -bg $bg -vcmd {checkEntryText %P 31  %d %S ""} -validate key
    label $win.f.2.s -text "    " -font $fnt
    entry $win.f.2.2 -textvariable addc_fon4  -width 22 -font $fnt -state $state -relief $rel -bg $bg -vcmd {checkEntryText %P 31  %d %S ""} -validate key
    label $win.f.fl.1 -text $_addrText(FAX) -font $fnt8 -width 40
    entry $win.f.f.1 -textvariable addc_fax   -width 22 -font $fnt -state $state -relief $rel -bg $bg -vcmd {checkEntryText %P 31  %d %S ""} -validate key
    pack $win.f.h.l $win.f.1.1 $win.f.l.1 $win.f.2.1  $win.f.fl.1 $win.f.f.1 -side left -fill x
    pack            $win.f.1.s            $win.f.2.s   -side left -fill x
    pack            $win.f.1.2 $win.f.l.2 $win.f.2.2   -side left -fill x
    lappend adrViewWidgetList $win.f.1.1 $win.f.1.2 $win.f.2.1 $win.f.2.2 $win.f.f.1
    lappend adrViewSmallWidgetList $win.f.1.1 $win.f.1.2 $win.f.2.1 $win.f.f.1

    frame $win.i.h -relief flat
    frame $win.i.l1 -relief flat
    frame $win.i.m1 -relief flat
    frame $win.i.l2 -relief flat
    frame $win.i.m2 -relief flat
    frame $win.i.lw -relief flat
    frame $win.i.w  -relief flat
    pack $win.i.h $win.i.l1 $win.i.m1 $win.i.l2 $win.i.m2 $win.i.lw $win.i.w -side top -fill x -ipadx 2 -ipady 2

    label $win.i.h.l -text $_addrText(Internet) -font $bfnt
    label $win.i.l1.l -text $_addrText(mail) -font $fnt8 -width 60
    entry $win.i.m1.e -textvariable addc_mail -width 48 -font $fnt -state $state -relief $rel -bg $bg -vcmd {checkEntryText %P 63  %d %S " "} -validate key
    label $win.i.l2.l -text $_addrText(mail) -font $fnt8 -width 60
    entry $win.i.m2.e -textvariable addc_mail2 -width 48 -font $fnt -state $state -relief $rel -bg $bg -vcmd {checkEntryText %P 63  %d %S " "} -validate key
    label $win.i.lw.l -text $_addrText(WWW) -font $fnt8 -width 60
    entry $win.i.w.e -textvariable addc_www -width 48 -font $fnt -state $state -relief $rel -bg $bg -vcmd {checkEntryText %P 127  %d %S " "} -validate key
    pack $win.i.h.l $win.i.l1.l $win.i.m1.e $win.i.l2.l $win.i.m2.e $win.i.lw.l $win.i.w.e -side top -fill x
    lappend adrViewWidgetList $win.i.m1.e  $win.i.m2.e  $win.i.w.e 
    lappend adrViewSmallWidgetList $win.i.m1.e   $win.i.w.e 
}

proc drawAdrViewBank    { win state  rel bg } {
    global addc_bank1 addc_konto1 addc_blz1 addc_kname1 
    global addc_bank2 addc_konto2 addc_blz2 addc_kname2 addc_steuer
    global bfnt fnt fnt8
    global adrViewWidgetList adrViewSmallWidgetList
    global _addrText

    frame $win.0 -relief ridge -bd 2
    frame $win.1 -relief ridge -bd 2
    frame $win.2 -relief ridge -bd 2
    pack $win.0 $win.1 $win.2 -side top -fill x -padx 2 -pady 8

    frame $win.0.l -relief flat
    frame $win.0.0 -relief flat
    frame $win.0.1 -relief flat
    frame $win.0.2 -relief flat
    frame $win.0.3 -relief flat
    pack $win.0.l  -side top -fill x -padx 2 -pady 3
    pack  $win.0.0 $win.0.1 $win.0.2 $win.0.3  -side top -fill x -padx 2
    
    label $win.0.l.l -text $_addrText(Konto1) -font $bfnt
    label $win.0.0.l -text $_addrText(KontoInh) -width 15 -font $bfnt
    label $win.0.1.l -text $_addrText(KontoNum) -width 15 -font $bfnt
    label $win.0.2.l -text $_addrText(Bank) -width 15 -font $bfnt
    label $win.0.3.l -text $_addrText(BLZ) -width 15 -font $bfnt
    entry $win.0.0.e -textvariable addc_kname1 -font $fnt -width 30 -state $state -relief $rel -bg $bg -vcmd {checkEntryText %P 31  %d %S ""} -validate key
    entry $win.0.1.e -textvariable addc_konto1 -font $fnt -width 30 -state $state -relief $rel -bg $bg -vcmd {checkEntryText %P 15  %d %S ""} -validate key
    entry $win.0.2.e -textvariable addc_bank1  -font $fnt -width 30 -state $state -relief $rel -bg $bg -vcmd {checkEntryText %P 31  %d %S ""} -validate key
    entry $win.0.3.e -textvariable addc_blz1   -font $fnt -width 30 -state $state -relief $rel -bg $bg -vcmd {checkEntryText %P 15  %d %S ""} -validate key
    pack $win.0.l.l -side left
    pack $win.0.0.l  $win.0.1.l  $win.0.2.l  $win.0.3.l  -side left
    pack $win.0.0.e  $win.0.1.e  $win.0.2.e  $win.0.3.e  -side left
    lappend adrViewWidgetList $win.0.0.e  $win.0.1.e  $win.0.2.e  $win.0.3.e

    frame $win.1.l -relief flat
    frame $win.1.0 -relief flat
    frame $win.1.1 -relief flat
    frame $win.1.2 -relief flat
    frame $win.1.3 -relief flat
    pack $win.1.l  -side top -fill x -padx 2 -pady 3
    pack  $win.1.0 $win.1.1 $win.1.2 $win.1.3  -side top -fill x -padx 2
    
    label $win.1.l.l -text $_addrText(Konto2) -font $bfnt
    label $win.1.0.l -text $_addrText(KontoInh) -width 15 -font $bfnt
    label $win.1.1.l -text $_addrText(KontoNum) -width 15 -font $bfnt
    label $win.1.2.l -text $_addrText(Bank) -width 15 -font $bfnt
    label $win.1.3.l -text $_addrText(BLZ) -width 15 -font $bfnt
    entry $win.1.0.e -textvariable addc_kname2 -font $fnt -width 30 -state $state -relief $rel -bg $bg -vcmd {checkEntryText %P 31  %d %S ""} -validate key
    entry $win.1.1.e -textvariable addc_konto2 -font $fnt -width 30 -state $state -relief $rel -bg $bg -vcmd {checkEntryText %P 15  %d %S ""} -validate key
    entry $win.1.2.e -textvariable addc_bank2  -font $fnt -width 30 -state $state -relief $rel -bg $bg -vcmd {checkEntryText %P 31  %d %S ""} -validate key
    entry $win.1.3.e -textvariable addc_blz2   -font $fnt -width 30 -state $state -relief $rel -bg $bg -vcmd {checkEntryText %P 15  %d %S ""} -validate key
    pack $win.1.l.l -side left
    pack $win.1.0.l  $win.1.1.l  $win.1.2.l  $win.1.3.l  -side left
    pack $win.1.0.e  $win.1.1.e  $win.1.2.e  $win.1.3.e  -side left
    lappend adrViewWidgetList  $win.1.0.e  $win.1.1.e  $win.1.2.e  $win.1.3.e 

    frame $win.2.0 -relief flat
    pack  $win.2.0  -side top -fill x -padx 2

    label $win.2.0.l -text $_addrText(SteurNum) -width 15 -font $bfnt
    entry $win.2.0.e -textvariable addc_steuer -font $fnt -width 30 -state $state -relief $rel -bg $bg -vcmd {checkEntryText %P 31  %d %S ""} -validate key
    pack $win.2.0.l  $win.2.0.e -side left
    lappend adrViewWidgetList $win.2.0.e 
}

proc drawAdrViewMisc    { win state rel bg  } {
    global addc_descrS addc_descr addc_info   adro_descr adro_info
    global bfnt fnt fnt8 fnt12
    global adrViewWidgetList adrViewSmallWidgetList
    global addc_create addc_modify addc_creator addc_modifier  fullUserNames
    global _addrText adro_info

    frame $win.0 -relief ridge -bd 2
    frame $win.1 -relief ridge -bd 2
    frame $win.2 -relief ridge -bd 2
    pack $win.0 $win.1  $win.2 -side top -fill x -padx 2 -pady 3

    frame  $win.0.0 -relief flat
    frame  $win.0.1 -relief flat
    frame  $win.0.2 -relief flat
    frame  $win.0.3 -relief flat
    frame  $win.0.4 -relief flat
    pack  $win.0.0 -side top -fill x -padx 2 -pady 6
    pack  $win.0.1 $win.0.2 $win.0.3 $win.0.4 -side top -fill x -padx 2 -pady 2
    
    set adro_descr $win.0.4.e
    label $win.0.0.l -text $_addrText(Descr) -font $bfnt
    label $win.0.1.l -text $_addrText(ShortForm) -font $fnt8
    entry $win.0.2.e -textvariable addc_descrS  -font $fnt -width 48 -state $state -relief $rel -bg $bg -vcmd {checkEntryText %P 63  %d %S ""} -validate key
    label $win.0.3.l -text $_addrText(detailed) -font $fnt8
    text  $adro_descr -width 48 -height 6 -font $fnt 
    pack $win.0.0.l $win.0.1.l $win.0.2.e $win.0.3.l  $win.0.4.e -side left
    $adro_descr insert end $addc_descr
    if { $state == "disabled" } {
	$adro_descr configure -state $state -relief $rel -bg $bg
    }

    set adro_info $win.1.1.e
    frame  $win.1.0 -relief flat
    frame  $win.1.1 -relief flat
    pack  $win.1.0 -side top -fill x -padx 2 -pady 6
    pack  $win.1.1  -side top -fill x -padx 2 -pady 2
    label $win.1.0.l -text $_addrText(infos) -font $bfnt
    text  $adro_info -width 48 -height 6 -font $fnt 
    pack $win.1.0.l $win.1.1.e  $win.0.4.e -side left
    $adro_info insert end $addc_info
    if { $state == "disabled" } {
	$adro_info configure -state $state -relief $rel -bg $bg
    }
   
    lappend adrViewWidgetList $adro_descr $win.0.2.e $adro_info
    lappend adrViewSmallWidgetList  $win.0.2.e 

    frame $win.2.0 -relief flat 
    frame $win.2.1 -relief flat 
    pack $win.2.0 $win.2.1 -side top -fill x
    
    label $win.2.0.l -text $_addrText(createAt) -width 12 -font $fnt12
    label $win.2.0.d -text [date2Str $addc_create ] -width 12 -font $fnt12
    label $win.2.0.b -text $_addrText(by) -width 7 -font $fnt12
    label $win.2.0.u -text $fullUserNames(u-$addc_creator) -width 20 -font $fnt12
    label $win.2.1.l -text $_addrText(modifiedAt) -width 12 -font $fnt12
    label $win.2.1.d -text [date2Str $addc_modify ] -width 12 -font $fnt12
    label $win.2.1.b -text $_addrText(by) -width 7 -font $fnt12
    label $win.2.1.u -text $fullUserNames(u-$addc_modifier)  -width 20 -font $fnt12

    pack $win.2.0.l $win.2.0.d $win.2.0.b $win.2.0.u -side left
    pack $win.2.1.l $win.2.1.d $win.2.1.b $win.2.1.u -side left
}
proc drawAdrViewPrivat { win state  rel bg } {
    global addc_adrPa addc_adrPb addc_adrPc addc_plzP addc_cityP addc_cntryP  adro_infoP
    global addc_fonP addc_faxP addc_infoP addc_mailP addc_wwwP
    global bfnt fnt fnt8
    global adrViewWidgetList adrViewSmallWidgetList
    global _addrText adro_infoP

    frame $win.0 -relief ridge -bd 2
    frame $win.1 -relief ridge -bd 2
    frame $win.2 -relief ridge -bd 2
    frame $win.3 -relief ridge -bd 2
    frame $win.4 -relief ridge -bd 2
    pack $win.0 $win.1 $win.2 $win.3  $win.4 -side top -fill x -padx 2 -pady 2

    for { set i 0 } {$i <8 } {incr i} {
	frame $win.0.$i -relief flat
	pack $win.0.$i -side top -fill x
    }
    label $win.0.0.l -text $_addrText(Adr) -font $bfnt
    entry $win.0.1.l -textvariable addc_adrPa -width 48 -font $fnt -state $state -relief $rel -bg $bg -vcmd {checkEntryText %P 63  %d %S ""} -validate key
    entry $win.0.2.l -textvariable addc_adrPb -width 48 -font $fnt -state $state -relief $rel -bg $bg -vcmd {checkEntryText %P 63  %d %S ""} -validate key
    entry $win.0.3.l -textvariable addc_adrPc -width 48 -font $fnt -state $state -relief $rel -bg $bg -vcmd {checkEntryText %P 63  %d %S ""} -validate key
    label $win.0.4.l -text $_addrText(PLZort) -font $fnt8
    entry $win.0.5.l -textvariable addc_plzP  -width  7 -font $fnt -state $state -relief $rel -bg $bg -vcmd {checkEntryText %P 15  %d %S ""} -validate key
    entry $win.0.5.l2 -textvariable addc_cityP -width 40 -font $fnt -state $state -relief $rel -bg $bg -vcmd {checkEntryText %P 63  %d %S ""} -validate key
    label $win.0.6.l -text $_addrText(Staat) -font $fnt8
    entry $win.0.7.l -textvariable addc_cntryP -width 48 -font $fnt -state $state -relief $rel -bg $bg -vcmd {checkEntryText %P 63  %d %S ""} -validate key
    lappend adrViewWidgetList $win.0.1.l $win.0.2.l $win.0.3.l $win.0.5.l $win.0.5.l2 $win.0.7.l
    for { set i 0 } {$i <8 } {incr i} {
	pack $win.0.$i.l  -side left -fill x
    }
    pack $win.0.5.l2  -side left -fill x

    frame $win.1.0 -relief flat
    frame $win.1.1 -relief flat
    pack $win.1.0 $win.1.1 -side top -fill x 
    label $win.1.0.1 -text $_addrText(Telefon) -font $bfnt -width 11
    label $win.1.1.1 -text $_addrText(FAX) -font $bfnt -width 11
    entry $win.1.0.e -textvariable addc_fonP  -font $fnt -width 37 -state $state -relief $rel -bg $bg -vcmd {checkEntryText %P 31  %d %S ""} -validate key
    entry $win.1.1.e -textvariable addc_faxP  -font $fnt -width 37 -state $state -relief $rel -bg $bg -vcmd {checkEntryText %P 31  %d %S ""} -validate key
    pack $win.1.0.1 $win.1.0.e $win.1.1.1 $win.1.1.e -side left
    lappend adrViewWidgetList $win.1.0.e $win.1.1.e

    frame $win.2.0 -relief flat
    frame $win.2.1 -relief flat
    pack $win.2.0 $win.2.1 -side top -fill x 
    label $win.2.0.1 -text $_addrText(mail) -font $bfnt -width 11
    label $win.2.1.1 -text $_addrText(WWW) -font $bfnt -width 11
    entry $win.2.0.e -textvariable addc_mailP -font $fnt -width 37 -state $state -relief $rel -bg $bg -vcmd {checkEntryText %P 63  %d %S ""} -validate key
    entry $win.2.1.e -textvariable addc_wwwP  -font $fnt -width 37 -state $state -relief $rel -bg $bg -vcmd {checkEntryText %P 127 %d %S ""} -validate key
    pack $win.2.0.1 $win.2.0.e $win.2.1.1 $win.2.1.e -side left
    lappend adrViewWidgetList $win.2.0.e $win.2.1.e

    label $win.3.l -text $_addrText(Birthday) -font  $bfnt -width 11
    entry $win.3.e -textvariable addc_geb -font $fnt -width 37 -state $state -relief $rel -bg $bg -vcmd {checkEntryText %P 16  %d %S ""} -validate key
    pack $win.3.l $win.3.e -side left
    
    label $win.4.l -text $_addrText(infos) -font  $bfnt -width 11
 
    set adro_infoP $win.4.e
    text  $adro_infoP -width 37 -height 4 -font $fnt 
    pack $win.4.l $win.4.e -side left
    $adro_infoP insert end $addc_infoP
    if { $state == "disabled" } {
	$adro_infoP configure -state $state -relief $rel -bg $bg
    }
    lappend adrViewWidgetList $win.3.e  $adro_infoP
}




proc delAddress { } { 
    global addr_id username adr_list adrCurListEntry


    set adrCurListEntry ""
    request delAdr $username $addr_id

    fillAddress
}

proc checkDelAdrDialog { } {
    global adrNames addr_id
    global bfnt  eddLock
    global _buttonText _addrText


    if { [winfo exists .cda ] == 1 } { return }
    toplevel .cda
    frame .cda.t -relief raised -bd 1
    frame .cda.b 
    pack .cda.t  -side top -fill x
    pack .cda.b -side top -fill x -pady 3

    drawDelDialogLines .cda.t $_addrText(delAdr1) $_addrText(delAdr2) $adrNames($addr_id) $_addrText(delAdrSort) $bfnt
#     label .cda.t.1 -text $_addrText(delAdr1) -font $bfnt -justify center -anchor n
#     label .cda.t.2 -text "\"$adrNames($addr_id)\""  -font $bfnt -justify center -anchor n
#     label .cda.t.3 -text $_addrText(delAdr2)  -font $bfnt -justify center -anchor n
#     pack .cda.t.1 .cda.t.2 .cda.t.3 -side top -fill x
    
    button .cda.b.abb -text $_buttonText(noWide)   -font $bfnt -command {
	closeWin .cda
    }
    pack .cda.b.abb -side right
    button .cda.b.del -text $_buttonText(yesWide)  -font $bfnt -command {
	closeWin .cda
	delAddress
	update
	closeWin  .adv
    }
    pack .cda.b.del -side left
    centerWin .cda 208 96
    update
#    puts [wm geometry .cda]
    grab .cda

}

proc delAddressFolder { } { 
    global curDirid username adr_list adrCurListEntry


    set adrCurListEntry ""
    request delAdrFolder $username $curDirid

    fillAddress
}

proc checkDelAdrFolderDialog { } {
    global adrNames curDirid
    global bfnt  eddLock
    global _buttonText _addrText


    if { [winfo exists .cda] == 1 } { return }
    toplevel .cda
    frame .cda.t -relief raised -bd 1
    frame .cda.b 
    pack .cda.t  -side top -fill x
    pack .cda.b -side top -fill x -pady 3

    drawDelDialogLines .cda.t $_addrText(delFolder1) $_addrText(delFolder2) $adrNames(d$curDirid) $_addrText(delFolderSort) $bfnt
#     label .cda.t.1 -text $_addrText(delFolder1)     -font $bfnt -justify center -anchor n
#     label .cda.t.2 -text "\"$adrNames(d$curDirid)\""  -font $bfnt -justify center -anchor n
#     label .cda.t.3 -text $_addrText(delFolder2)  -font $bfnt -justify center -anchor n
#     pack .cda.t.1 .cda.t.2 .cda.t.3 -side top -fill x
    
    button .cda.b.abb -text $_buttonText(noWide)   -font $bfnt -command {
	.afv.b.do  configure -state normal
	.afv.b.mod configure -state normal
	.afv.b.del configure -state normal
	closeWin .cda
    }
    pack .cda.b.abb -side right
    button .cda.b.del -text $_buttonText(yesWide)  -font $bfnt -command {
	closeWin .cda
	delAddressFolder
	update
	closeWin  .afv
    }
    pack .cda.b.del -side left
    centerWin .cda 240 96
    update
#    puts [wm geometry .cda]
    grab .cda

}

proc termin4Address {str} {
    if { $str == 1} {
	return "+"
    }
    return " "
}





proc makeAdrFolderDialog { } {
    global fnt bfnt newAdrFolderName
    global _addrText _buttonText

    if { [winfo exists .naf ] == 1 } { return }
    toplevel .naf

    frame  .naf.t -relief raised -bd 1
    frame  .naf.b -relief flat
    pack  .naf.t  .naf.b -side top -fill x
    
    frame .naf.t.0 -relief flat
    frame .naf.t.1 -relief flat
    pack .naf.t.0 .naf.t.1 -side top
    centerWin  .naf 320 102

    label  .naf.t.0.l -text $_addrText(NewAdrFolder) -justify left -anchor nw -font $bfnt
    label  .naf.t.1.l -text $_addrText(NameOfFolder) -justify left -anchor nw -font $bfnt
    entry  .naf.t.1.e -textvariable newAdrFolderName -justify left  -font $fnt  -vcmd {checkEntryText %P 63  %d %S ""} -validate key
    pack  .naf.t.0.l -side top -fill x -pady 4 -padx 8
    pack   .naf.t.1.l .naf.t.1.e -side left -fill x -pady 8 -padx 4

    button  .naf.b.ok -text $_buttonText(Create) -font $bfnt -command createAdrFolder

    button  .naf.b.abb -text $_buttonText(Cancel) -command {destroy .naf} -font $fnt
    pack  .naf.b.abb -side left -padx 2 -pady 2
    pack  .naf.b.ok -side right -padx 2 -pady 2
    grab .naf
    wm title .naf $_addrText(wmTitel_naf)
#gemetry 215x102
    update
#    puts [wm geometry .naf]
    centerWin  .naf 320 102
    bind .naf <Return> createAdrFolder
}
proc createAdrFolder { } {
    global username newAdrFolderName  adrDirList adrDirOpen
    destroy .naf
    set dirid [ transfer makeAdrFolder $username  $newAdrFolderName Allgemein 0 ]
    if { $dirid != "Error" } {
	set adrDirList [ request getAdrFolders  $username ]
	if { $adrDirList == "Error" } { return}
	set adrDirOpen($dirid) 1
	fillAddressNew
    }
}



proc viewAdrFolder { dirid } {
    global addf_name addf_owner adrDirList addf_id addf_opened
    global bfnt fnt  editMode  dirid2idx groupList adrDirPath
    global curDirid windHeight
    global _buttonText _addrText

    set curDirid $dirid

#    puts "getting Folder view for dir $dirid:"
    set idx $dirid2idx($dirid)
#    puts "\t-> idx=$idx  ->  [lindex $adrDirList $idx]"
    set addf_name  [lindex [lindex $adrDirList $idx] 1]
    set addf_owner [lindex [lindex $adrDirList $idx ] 3]
    set addf_opened [lindex [lindex $adrDirList $idx ] 4]
    set addf_perm   [lindex [lindex $adrDirList $idx ] 5]
    set editMode 0
    set addf_id $dirid

    if { [winfo exists .afv ] == 1 } { return }
    toplevel .afv
    busyCursor .afv
    frame .afv.t -relief raised -bd 1
    frame .afv.b -relief flat
    pack .afv.t .afv.b -side top -fill x
    wm title .afv "$_addrText(wmTitel_afv)  $addf_name"

    set vadHeight 804
    set noteOffy  0
    if {$windHeight < 804 } { 
	set vadHeight 704
	set noteOffy -100
    }


    centerWin .afv 722 $vadHeight

    frame .afv.t.t -relief raised -bd 1
    frame .afv.t.n -relief raised -bd 1
    pack .afv.t.t .afv.t.n -side top -fill x

    frame .afv.t.t.0
    frame .afv.t.t.1
    pack .afv.t.t.0 .afv.t.t.1 -side top -fill x
    label .afv.t.t.0.l -text $_addrText(Name) -width 7 -font $bfnt
    entry .afv.t.t.0.e -textvariable addf_name -width 30 -font $fnt -state disabled  -relief flat -bg grey88 -vcmd {checkEntryText %P 63  %d %S ""} -validate key
    
    tixOptionMenu  .afv.t.t.0.o -options {menubutton.width 15 label.width 26 label.disabledforeground grey40}\
	-label $_addrText(changeableBy) 
    .afv.t.t.0.o subwidget menubutton configure -font $fnt
    .afv.t.t.0.o add command Allgemein -label Allgemein
    foreach group $groupList {
	.afv.t.t.0.o add command $group -label $group
    }
    .afv.t.t.0.o subwidget label configure -font $bfnt -bg "#D0D0D0" -fg black
    .afv.t.t.0.o subwidget menubutton configure  -relief flat  -bg "#D0D0D0" -disabledforeground grey40
    .afv.t.t.0.o configure -variable addf_owner -state disabled 
    
    pack  .afv.t.t.0.l .afv.t.t.0.e   -side left
    pack  .afv.t.t.0.o -side right -padx 4

    checkbutton .afv.t.t.1.c -text $_addrText(defOpen) -font $bfnt -width 45 -variable addf_opened -state disabled -anchor nw -justify left -disabledforeground grey40

    pack .afv.t.t.1.c -side right -padx 4

    set aidList [concat d$dirid [ getAdrNotizAid $adrDirPath($dirid)] ]
#    puts "AID-LIST: /$aidList/"
    drawNotizBlock .afv.t.n 720 [expr 688 + $noteOffy ] $aidList $addf_perm
    
    button .afv.b.do -text $_buttonText(Close) -width 20 -font $bfnt -command {
	closeNotiz
	if {$editMode == 1} {
	    changeAdrFolder
	}
	closeWin .afv
    }
    pack .afv.b.do -side right
    button .afv.b.mod -text $_buttonText(Modify) -width 20  -font $fnt -command {
	set editMode [expr ($editMode+1) %2]
	if { $editMode == 1} {
	    .afv.b.mod configure -text $_buttonText(ApplyChange)
	    .afv.t.t.0.e configure -state normal -relief sunken -bg grey95
	    .afv.t.t.0.o configure -state normal -relief raised -bg grey95
	    .afv.t.t.1.c configure -state normal  -disabledforeground grey40
	    .afv.t.t.0.o subwidget menubutton configure -relief raised 
	    .afv.t.t.0.o subwidget label configure  -bg "#D0D0D0"  -fg black
	} else { 
	    .afv.b.mod configure -text $_buttonText(Modify)
	    .afv.t.t.0.e configure -state disabled -relief flat -bg grey88
	    .afv.t.t.0.o configure -state disabled -relief flat -bg grey88
	    .afv.t.t.1.c configure -state disabled
	    .afv.t.t.0.o subwidget menubutton configure -relief flat  -bg "#D0D0D0"  -disabledforeground black
	    .afv.t.t.0.o subwidget label configure  -bg "#D0D0D0"  -fg black

	    changeAdrFolder
	}
    }
    pack .afv.b.mod -side right

    button .afv.b.del -text $_buttonText(Delete) -width 20 -font $fnt  -command {
	.afv.b.do  configure -state disabled
	.afv.b.mod configure -state disabled
	.afv.b.del configure -state disabled
	checkDelAdrFolderDialog
    }
    pack .afv.b.del -side right -padx 16 
    if { $addf_perm != "rwn" } {
	.afv.b.mod configure -state disabled
	.afv.b.del configure -state disabled
    }
    update
#    puts [ wm geometry .afv ]
    grab .afv
    stdCursor .afv
}

proc getAdrNotizAid { path } {
    global adro_list idx2aid idx2dirid

#    puts "looking for adr imn $path"
    set aidList "" 
    set list [$adro_list info children $path]
    foreach ent $list { 
	set list [split  $ent .]
	set obj  [lindex $list end]
	set type   [string range   $obj  0 2 ]
	    set idx [trimLead0 [string range   $obj  3 end ]]
	if { $type == "adr" } {
	    lappend aidList $idx2aid($idx)
	} elseif { $type == "Dir" } {
	    set list2 [getAdrNotizAid $ent]
	    set aidList [concat $aidList $list2 ]
	    lappend aidList "d$idx2dirid($idx)"
	}
    }
    return $aidList
}

proc changeAdrFolder { } {
    global username addf_id addf_name addf_owner adrDirList dirid2idx addf_opened

    if { [transfer changeAdrFolder  $username $addf_id $addf_name $addf_owner $addf_opened] == "Error" } { return}

    set idx $dirid2idx($addf_id)
    set dir [lindex $adrDirList $idx]
    set parent [lindex $dir 2]
    set dir "$addf_id {$addf_name} $parent {$addf_owner} $addf_opened"
    set adrDirList [lreplace $adrDirList $idx $idx $dir]
    fillAddressNew
}



proc adrDirListWin { } {
    global adrDirList   dirid2idx adlCurNetry adlList fnt adrNames idx2dirid
    global _buttonText _addrText

    if { [winfo exists .adl ] == 1 } { return }
    toplevel .adl 
    busyCursor .adl
    frame .adl.t -relief raised -bd 2
    frame .adl.b
    pack .adl.t .adl.b -side top -fill x
    tixScrolledHList .adl.t.l -width 240 -height 400 -options {
	hlist.header  false
	hlist.columns 1
	hlist.drawbranch 1
	hlist.selectBackground DarkGoldenRod1
	hlist.background "#FFFDFB" 
    }
    pack .adl.t.l -side top

    button .adl.b.abb -text $_buttonText(Cancel)  -font $fnt -command {destroy .adl}
    pack .adl.b.abb -side left

    set adlList [.adl.t.l subwidget hlist]
    centerWin .adl 244 434
    wm title .adl $_addrText(wmTitel_adl)
    foreach dir $adrDirList {
	set parent [lindex $dir 2]
	set dirid  [lindex $dir 0]
	if { $parent == -1 } {
	    adrDirWinAddDir $dir $dirid 
	}
    }
    update
    grab .adl
    
    bind  $adlList  <ButtonRelease-1> {
	.adl.b.abb configure -state disabled
	after 25 reassignAdr2Dir %y
    }
    stdCursor .adl
}
proc adrDirWinAddDir { dir dirid  } {
    global  adrDirChilds adrDirList idx2dirid

    set parent [lindex $dir 2]

    addDir2DirList [lindex $dir 1]  $dirid $parent  -
    foreach ent $adrDirChilds($dirid) {
	set path [lindex $ent 0]
	set type [lindex $ent 1]
	set idx  [lindex $ent 2]
# 	set obj [lindex [split  $ent .] end]
# 	set type [ string range $obj 0 2]
# 	set idx [trimLead0 [string range $obj 3 end]]
	
	if { $type == "Dir" } {
	    set id $idx2dirid($idx)
	    set dir  [lindex $adrDirList $idx]
	    adrDirWinAddDir $dir $id
	}
    }
}
proc reassignAdr2Dir { yk } {
    global adlList adrNames username addr_id adrCurListEntry idx2dirid
    
    if { [winfo exists .adv ] == 1} {
	set statDo  [ .adv.b.do  cget -state ]
	set statMod [ .adv.b.mod cget -state ]
	set statDel [ .adv.b.del cget -state ]
	set statAbb [ .adv.b.abb cget -state ]
	set statAss [ .adv.b.ass cget -state ]
	.adv.b.do  configure -state disabled
	.adv.b.mod configure -state disabled
	.adv.b.del configure -state disabled
	.adv.b.abb configure -state disabled
	.adv.b.ass configure -state disabled
    }


    if { $addr_id < 0 } {
	changeAddressNoRedraw
    }

    set adlCurEntry [$adlList  nearest  $yk]
    after 1
    destroy .adl
    update

#    puts "entry : $adlCurEntry $addr_id=$adrNames($addr_id)"
    set list [split  $adlCurEntry .]
    set obj  [lindex $list end]
    if { $obj == "" } {
	set dirid 0
    } else {
	set idx [trimLead0 [string range   $obj  3 end ]]
	set dirid $idx2dirid($idx)
#	set dirid [trimLead0 [string range   $obj  3 end ]]
    }
#    puts "\t-> diris=$dirid = $adrNames(d$dirid)"
    transfer moveAdrObjToFolder $username $dirid  adr $addr_id
    set adrCurListEntry ""
    fillAddress
    update
    if { [winfo exists .adv ] == 1} {
	.adv.b.do  configure -state $statDo
	.adv.b.mod configure -state $statMod
	.adv.b.del configure -state $statDel
	.adv.b.abb configure -state $statAbb
	.adv.b.ass configure -state $statAss
    }
}

proc addDir2DirList {dirnam dirid parent  after} {
    global adrDirLevel adrDirPath adro_list adrDirStyle adrDirLastEntry adrCols  adlList

    if { $parent == -1 } {
	set row [$adlList add $adrDirPath($dirid) -itemtype text -text $dirnam -style $adrDirStyle]
    } else { 
	if { $after == "-" } {
	    set row [$adlList add $adrDirPath($dirid) -itemtype text -text $dirnam -style $adrDirStyle]
	} else {
	    set row [$adlList add $adrDirPath($dirid) -itemtype text -text $dirnam -style $adrDirStyle -after $after]
	}
    }
}
