#!/usr/bin/X11/tixwish
#  File: cal.tcl
# 
#      This file is part of minkowsky
# 
#      Copyright (C) 2001-2002 by Rdiger Goetz
#      Author: Rdiger Goetz <minkowsky@r-goetz.de>
# 
#      Time-stamp: <25-May-2002 19:53:52 goetz>
# 
#      This program is free software; you can redistribute it and/or modify
#      it under the terms of the GNU General Public License as published by
#      the Free Software Foundation; either version 2 of the License, or
#      (at your option) any later version.
# 
#      This program is distributed in the hope that it will be useful,
#      but WITHOUT ANY WARRANTY; without even the implied warranty of
#      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#      GNU General Public License for more details.
# 
#      You should have received a copy of the GNU General Public License
#      along with this program; if not, write to the Free Software
#      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#  

proc displayYearCalAtPosition { day mon year x y win} {
    global callerRequest sDay sMon sYear
    set sDay $day
    set sMon $mon
    set sYear $year
    
    set callerRequest "getDate"
    _displayYearCal $day $mon $year
#     set x 0
#     set y 0
    wm geometry .cov 226x290+$x+$y
    wm transient .cov $win
    grab .cov
    update 
    tkwait window .cov
    return "$sDay $sMon $sYear"
}
proc displayYearCal { day mon year} {
    global callerRequest
    set callerRequest "jump"
    _displayYearCal $day $mon $year
    update
}
proc _displayYearCal { day mon year} {
    global fnt bfnt10 bfnt fnt10 monLen
    global covDay covMon covYear covWin
    global weekDaysAbk   covDHwin covDin
    global covStartDay covStartMon covStartYear
    global tyear tmon tday        covTodatDwin
    global _calText _buttonText monAbk
    global callerRequest

    if { [winfo exists .cov] == 1 } { return }
    toplevel .cov 
    wm geometry .cov 226x290

    set covDay $day
    set covMon $mon
    set covYear $year
    set covStartDay  $covDay
    set covStartMon  $covMon
    set covStartYear $covYear
    set covDHwin ""
    
    set off 3

    frame .cov.y -relief raised -bd 1
    frame .cov.m -relief raised -bd 1
    frame .cov.c -relief raised -bd 1
    frame .cov.b -relief flat
    pack .cov.y .cov.m .cov.c .cov.b  -side top -fill x -pady 1

    button .cov.y.l -text "<<" -bd 1 -command COVlastYear
    frame .cov.y.y 
    button .cov.y.r -text ">>" -bd 1 -command COVnextYear
    pack .cov.y.l -side left -fill x 
    pack .cov.y.y -side left -fill x -expand 1
    pack .cov.y.r -side right -fill x 
    
    label .cov.y.y.l -text $year -anchor n -font $bfnt
    pack  .cov.y.y.l -side top -fill x

    frame .cov.m.1 
    frame .cov.m.2
    pack .cov.m.1  .cov.m.2 -side top -fill x
    for { set i 1} { $i<=6} {incr i} {
	button .cov.m.1.$i -text [lindex $monAbk $i] -bd 1 -font $bfnt10 -width 1 -command {COVswitchMon}
	pack .cov.m.1.$i -side left -fill x -expand 1
	bind .cov.m.1.$i <Button> {set covWin %W}
    }
    for { set i 7} { $i<=12} {incr i} {
	button .cov.m.2.$i -text [lindex $monAbk $i] -bd 1 -font $bfnt10 -width 1 -command {COVswitchMon}
	pack .cov.m.2.$i -side left -fill x -expand 1
	bind .cov.m.2.$i <Button> {set covWin %W}
    }
    if { $mon < 7} {
	 .cov.m.1.$mon configure -fg red4 -bg wheat -activebackground wheat -activeforeground red4
    } else {
	.cov.m.2.$mon configure -fg red4 -bg wheat -activebackground wheat -activeforeground red4
    }

    frame  .cov.c.d
    pack .cov.c.d -side top -fill x
    for {set d 1} {$d<=7} {incr d} {
 	label .cov.c.d.$d -text [lindex $weekDaysAbk [expr $d -1 ]] -relief raised -bd 1  -width 2 -font $bfnt10 -anchor n
 	pack .cov.c.d.$d -side left -fill x -expand 1  -padx 1
    }
    for {set w 0} {$w<=5} {incr w} {
	frame  .cov.c.$w 
	pack .cov.c.$w  -side top -fill x
	for {set d 1} {$d<=7} {incr d} {
	    button .cov.c.$w.$d -text "" -width 1 -font $fnt10 -command jump2CalDate
	    pack .cov.c.$w.$d  -side left
	    bind .cov.c.$w.$d <Button> {set covDwin %W}
	}
    }
    fillMonInCalView 0

    wm title .cov $_calText(NaviTitle)
    button .cov.b.today -text $_calText(Heute) -command {
	set covDay  $tday
	set covMon  $tmon
	set covYear $tyear
	COVTodaysYear
    }	

    button .cov.b.cancel -text $_buttonText(Cancel) -command {
	set covDay  $covStartDay
	set covMon  $covStartMon
	set covYear $covStartYear
	set sDay  $covDay
	set sMon  $covMon
	set sYear $covYear
	announceDate2Caller
	destroy .cov
    }
    button .cov.b.close -text $_buttonText(Close) -command {
	destroy .cov
    }
    pack .cov.b.today .cov.b.cancel -side left  -padx 1 -pady 1
    pack .cov.b.close -side right -padx 1 -pady 1
}
proc fillMonInCalView { upd } {
    global monlen
    global fnt fnt10 bfnt10  covDHwin covWDList
    global covMon covDay covYear
    global holidays holidayNames holidayMonth
    global tday tmon tyear covTodatDwin

    if { $covDHwin != "" } {   
	$covDHwin configure  -bg lightgray -activebackground lightgray
    }
    set off [weekDayByDate 1 $covMon $covYear]

    set moff 0
    if { $covMon  == 2 } {
	if {[ expr $covYear % 4] == 0 } { set moff 1} 
    } 
    set ml [expr [lindex $monlen $covMon] + $moff]
    if { $covDay > $ml } { set covDay $ml}

    set mtag [format "%04d-%02d" $covYear $covMon]
    if { [lsearch $holidayMonth $mtag] >=0 } {
	set hlist $holidays($mtag)
    } else {
	set hlist ""
    }

    for {set w 0} {$w<=5} {incr w} {
	for {set d 1} {$d<=7} {incr d} {
	    set wd [expr $w*7+$d -$off]
	    if { $wd <=0  || $wd > $ml} {
		.cov.c.$w.$d configure -text ""  -width 1 -font $fnt10 -relief flat -state disabled 
	    } else {
		.cov.c.$w.$d configure  -text $wd -width 1 -font $fnt10 -relief raised -state normal
	    }
		
	    if { $covDay == $wd} {
		.cov.c.$w.$d configure -bg wheat -activebackground wheat
		set covDHwin .cov.c.$w.$d
	    }
	    #Holidays
	    if { $d >5} {
		.cov.c.$w.$d configure -fg red4 -activeforeground red4 
	    } elseif { [lsearch $hlist $wd] >=0} {
		.cov.c.$w.$d configure -fg red4 -activeforeground red4 
	    } else {	    
		.cov.c.$w.$d configure -fg black -activeforeground  black
	    }
	    if { $covYear == $tyear }  {
		if { $covMon == $tmon }  {
		    if { $wd == $tday }  {
			.cov.c.$w.$d configure -font  $bfnt10
			set covTodatDwin .cov.c.$w.$d
		    }
		}
	    }
	    set covWDList($w-$d) $wd
	}
    }
    if { $upd == 1 } {update  }
}

proc jump2CalDate { } {
    global covWDList covDwin covDay covYear covMon covDHwin
    global sDay sMon sYear 

    set list [split $covDwin .]
    set w [lindex  $list 3]
    set d [lindex  $list 4]
    set covDay $covWDList($w-$d)

    $covDHwin configure  -bg lightgray -activebackground lightgray
    .cov.c.$w.$d configure -bg wheat -activebackground wheat
    set covDHwin .cov.c.$w.$d

    set sDay  $covDay
    set sMon  $covMon
    set sYear $covYear

#    puts "$sDay $sMon $sYear"
    announceDate2Caller
}
proc  COVswitchMon {} {
    global covWin covMon covDay covYear
    global sDay sMon sYear 

    if {$covMon <=6} {
	.cov.m.1.$covMon configure  -fg black -bg lightgray -activebackground lightgray -activeforeground black
    } else {
	.cov.m.2.$covMon configure  -fg black -bg lightgray -activebackground lightgray -activeforeground black
    }
    set covMon [lindex [split $covWin .] 4]

#    puts " DATE $covDay $covMon $covYear"
    fillMonInCalView 1
#    puts ">DATE $covDay $covMon $covYear"

    if {$covMon <=6} {
#	puts [.cov.m.1.$covMon cget -bg]
	update
	.cov.m.1.$covMon configure  -fg red4 -bg wheat -activebackground wheat -activeforeground red4
    } else {
	.cov.m.2.$covMon configure  -fg red4 -bg wheat -activebackground wheat -activeforeground red4
    }
    set sDay  $covDay
    set sMon  $covMon
    set sYear $covYear
    announceDate2Caller
}

proc COVlastYear { } {
    global covMon covDay covYear
    global sDay sMon sYear 
    
    incr covYear -1
    
    .cov.y.y.l configure -text $covYear

    fillMonInCalView 1

    set sDay  $covDay
    set sMon  $covMon
    set sYear $covYear
    announceDate2Caller
}
proc COVnextYear { } {
    global covMon covDay covYear
    global sDay sMon sYear 

    incr covYear 1
    
    .cov.y.y.l configure -text $covYear
    fillMonInCalView 1
    set sDay  $covDay
    set sMon  $covMon
    set sYear $covYear
    announceDate2Caller
}
proc COVTodaysYear { } {
    global covMon covDay covYear
    global sDay sMon sYear  tyear

    set covYear $tyear
    
    .cov.y.y.l configure -text $covYear
    fillMonInCalView 1
    set sDay  $covDay
    set sMon  $covMon
    set sYear $covYear
    announceDate2Caller
}

proc announceDate2Caller { } {
    global sDay sMon sYear
    global callerRequest

#    puts "Caller: $callerRequest"

    if { $callerRequest == "jump" } {
#	puts "JUMP !"
	jump2Date 
    }     
#    puts "done"
}

