/* File: client.cc
 *
 *     This file is part of minkowsky
 *
 *     Copyright (C) 2001-2002 by Rdiger Goetz
 *     Author: Rdiger Goetz <minkowsky@r-goetz.de>
 *
 *     Time-stamp: <28-May-2002 19:55:03 goetz>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#define _GNU_SOURCE
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>  
#include <string.h>
#include <math.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <unistd.h>  
#include <errno.h>    
#include <netinet/in.h>  
#include <netdb.h>

#ifdef MACOSX
#	include <pthread.h>
#	include "tk.h"
#	include "tclInt.h"
#	include <tix.h>
#	include "locale.h"

//#	include <Carbon/Carbon.h>
//#	include "tkMacOSX.h"
//#	include "tkMacOSXEvent.h"

#	ifndef MAX_PATH_LEN
#		define MAX_PATH_LEN 1024
#	endif

#else
#	include <tcl.h>
#	include <tk.h>
#	include <tix.h>
#	include <time.h>     
#	include <signal.h>
#	include <sys/poll.h>  
#	include <X11/Xlib.h>
#endif

#define MAX_CLIENTS 1000
#ifndef MASTERPORT
#define MASTERPORT  41999
#endif
 
//struct sockaddr_in mySocketAddress,masterSocketAddress;
int port,masterPort=MASTERPORT;
int mySocket,masterSocket;
char binPath[1024],terminHost[256];
char curUserName[32], curPasswd[32];
int socketsUp=false;
int myCid =-1;


int send2Socket(int socket,char *msg);
int send2DamagedSocket(int socket,char *msg);
int openSocket(char *host,int port);
//char *wait4Message(int socket, char *t,int l);
// char *wait4Message(int socket);
char *wait4Message(int socket,int timeout);
// char *wait4Message(int socket, int *ack);
// char *wait4Message(int socket, int *ack,int id);
char *wait4Message(int socket, int *ack, int needAck,int timeout,int id);
void startTCL (int argc, char *argv[] );
int initApsh(Tcl_Interp *interp);
int transfer(ClientData cData, Tcl_Interp *interp, int argc, char *argv[]);
int checkServer(ClientData cData, Tcl_Interp *interp, int argc, char *argv[]);
int tryReconnect(ClientData cData, Tcl_Interp *iqnterp, int argc, char *argv[]);
int weekDayByDate(ClientData cData, Tcl_Interp *interp, int argc, char *argv[]);
int weekDayByDateStr(ClientData cData, Tcl_Interp *interp, int argc, char *argv[]);
int currentTime(ClientData cData, Tcl_Interp *interp, int argc, char *argv[]);
int closeSocket (ClientData cData, Tcl_Interp *interp, int argc, char *argv[]);
int closeSocket ();
int closeApp(ClientData cData, Tcl_Interp *interp, int argc, char *argv[]);
void closeApp(int val);
void gotData(int val);
#ifdef MACOSX
void setGotData(int);
#else
void setGotData(int,siginfo_t *,void *);
#endif
void pipebroken(int val);
void timerStop(int val);
int reconnect();
int reconnect(Tcl_Interp *interp);
int currentDateTime(ClientData cData, Tcl_Interp *interp, int argc, char *argv[]);
int timeBetween(ClientData cData, Tcl_Interp *interp, int argc, char *argv[]);
int setTagList(ClientData cData, Tcl_Interp *interp, int argc, char *argv[]);
int getTag(ClientData cData, Tcl_Interp *interp, int argc, char *argv[]);
int getBinPath(ClientData cData, Tcl_Interp *interp, int argc, char *argv[]);
int mouseStatus(ClientData cData, Tcl_Interp *interp, int argc, char *argv[]);
#ifdef MACOSX 
int mouseStatus(void);
#endif
int matchString(ClientData cData, Tcl_Interp *interp, int argc, char *argv[]);
char *nextElement(char *t);
char *skip2NonWS(char*t);
int logIntoServer(ClientData cData, Tcl_Interp *interp, int argc, char *argv[]);

int cl_logIntoServer();
int transfer(char *buffer,char **inp);
int transfer(char *buffer,char **inp, int depth);
char * strTrim (char *t);
void cleanMessagePipe(int socket);

char tclMsg[16384];
int verbose=false;
typedef struct
{
 int x0,y0,x1,y1;
 char tag[64];
}canvasTags;

canvasTags *canvasList[8]={NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL};
int canvasListLength[8];
int autoInstallMRR=false;
int startGUI=true;
char cmdFile[1024],command[16384];
int cmdFromFile=false;
char username[256];
char password[256];

#define MSG_BUFFER_LEN 16384
char msgFromServer[MSG_BUFFER_LEN+4096],*bigMsgFromServer=NULL;

char globalBuffer[500000];
FILE *fpl=NULL;

struct sigaction sigioAction;// = {NULL,setGotData,0,SA_SIGINFO,NULL};
sigset_t sigio_set;
int dataAvailable=false;
int timerStopped=false;
int comID =0;

int main(int argc, char *argv[])
{


 char buffer[16384],*p,*t,*s;
 int off=0,ac,i;
 FILE *fp;
 int useTestBin=false;
 char testBinPath[1024];
 char configFile[1024];

#ifdef MACOSX
 strcpy(configFile,"/Library/Preferences/minkowsky");
 setenv("HOSTTYPE","macintosh",true);
// printf("Called as '%s'\n\n",argv[0]);
#else
 strcpy(configFile,"/etc/minkowsky");
#endif
 off=0;
 ac=1;
 // printf("argc=%d\n",argc);
 password[0]='\0';
 username[0]='\0';
 while(ac <argc)
  {
   //   printf("arg: %s\n",argv[ac]);
   if(strcmp(argv[ac],"-v")==0)
    {
     fpl= fopen("minko.log","w");
     verbose=true;
     off++;
     //     argc--;
    }
   else if (strcmp(argv[ac],"-bin")==0)
    {
     useTestBin=true;
     ac++;
     strcpy(testBinPath,argv[ac]);
     off++;
     off++;
    }
   else if (strcmp(argv[ac],"-f")==0)
    {
     ac++;
     strcpy(configFile,argv[ac]);
     off++;
     off++;
    }
   else if (strcmp(argv[ac],"-u")==0)
    {
     ac++;
     strcpy(username,argv[ac]);
     off++;
     off++;
    }
   else if (strcmp(argv[ac],"-p")==0)
    {
     ac++;
     strcpy(password,argv[ac]);
     off++;
     off++;
    }
   else if (strcmp(argv[ac],"-F")==0)
    {
     startGUI=false;
     cmdFromFile=true;
     ac++;
     strcpy(cmdFile,argv[ac]);
     off++;
     off++;
    }
   else if (strcmp(argv[ac],"-c")==0)
    {
     startGUI=false;
     strcpy(command,"");
     off=argc;
     for(i=ac+1; i<argc; i++)
      {
       strcat(command,argv[i]);
       strcat(command," ");
      }
     break;
    }
   else
    break;
   ac++;
  }
 argc -= off;
 
 strcpy(binPath,"");
 strcpy(terminHost,"");

 fp=fopen(configFile,"r");
 if(fp!=NULL)
  {
   //   printf("reading configuration from %s\n",configFile);
   p=fgets(buffer,8190,fp);
   while(p!=NULL)
    {
     if(strncmp(buffer,"MINKO_PATH",10)==0)
      {
      #ifdef MACOSX
        char cwd[4096];
        strcpy(binPath,argv[0]);
        t=strstr(binPath,"Contents/MacOS");
        *t='\0';
        strcat(binPath,"Contents/Resources");
//        sprintf(binPath,"%s/minkowsky-client.app/Contents/Resources",getcwd(cwd,4095));
      #else
       t=skip2NonWS(buffer+11);
       s= t+strlen(t)-1;
       if(*s=='\n')
	*s='\0';
       sprintf(binPath,"%s/client",t);
       #endif
      }
     else if (strncmp(buffer,"MINKO_SERVER",12)==0)
       {
       t=skip2NonWS(buffer+13);
       s= t+strlen(t)-1;
       if(*s=='\n')
	*s='\0';
       strcpy(terminHost,t);
      }
     else if (strncmp(buffer,"AUTO_INSTALL_MRR",16)==0)
      {
//        t=skip2NonWS(buffer+17);
//        if(atoi(t)==0)
       autoInstallMRR=true;
      }
      else if (strncmp(buffer,"MINKO_AUTO_MRR",14)==0)
      {
//        t=skip2NonWS(buffer+17);
//        if(atoi(t)==0)
       autoInstallMRR=true;
      }
    p=fgets(buffer,8190,fp);
   
    }
  }


 p=getenv("MINKO_PATH");
 if(p==NULL)
   p=getenv("TERMIN_BIN_PATH");

 if(p!=NULL)
  {
   p[strlen(p)-1]='\0';
   t=strrchr(p,'/');
   *t='\0';
  }

 if(p!=NULL)
  if(binPath[0]=='\0')
   sprintf(binPath,"%s/client",p);

 // printf("p=%p, binPath=%s\n",p,binPath);

 p=getenv("MINKO_SERVER");
 if(p==NULL)
  p=getenv("TERMIN_HOST");
 
 if(p!=NULL)
  if(terminHost[0]=='\0')
   strcpy(terminHost,p);
 if(terminHost[0]=='\0')
  strcpy(terminHost,"localhost");


 if(useTestBin)
  {
   strcpy(binPath,testBinPath);
  }
 
 fclose(fp);


 signal(SIGTERM,closeApp);  
 signal(SIGINT ,closeApp);  
 signal(SIGALRM,timerStop);  
 // signal(SIGIO, gotData);
 // sigemptyset(&sigio_set);
 #ifdef MACOSX
 signal(SIGIO, setGotData);
 //sigioAction.sa_handler = setGotData;
 //sigioAction.sa_mask    = 0;
 //sigioAction.sa_flags   = SA_SIGINFO;
 #else
 sigioAction.sa_handler   = NULL;
 sigioAction.sa_restorer  = NULL;
 sigioAction.sa_sigaction = setGotData;
 // sigioAction.sa_mask      = sigio_set;
 sigemptyset(&sigioAction.sa_mask);
 sigioAction.sa_flags     = SA_SIGINFO;
 sigaction(SIGIO,&sigioAction,NULL);
 #endif
 signal(SIGPIPE, pipebroken);

//#ifdef NEVER

 if(startGUI)
  {
  startTCL(argc,argv+off);
  }
#ifndef MACOSX
 // FIXME: For some reason the doesn't work on MacOSX, why ????????????
 else
  {
   char *inp,pr[1024];

   if(cmdFromFile)
    {
     fp =fopen(cmdFile,"r");
     if(fp == NULL)
      {
       printf("Can't open commandfile '%s'\n",cmdFile);
       exit(-1);
      }
    }
      
   cl_logIntoServer();
//    printf("sleeping\n");
//    sleep (2);
   if(cmdFromFile)
    {
     char buffer[500000];
     char line[16384];
     buffer[0]='\0';

     while(fgets(line,16383,fp) != NULL)
      {
       strTrim(line);
//        printf("\tline = '%s'\n",line);
       if(line[0] == '\0')
	{
	 transfer(buffer,&inp);
// 	 printf("ERG:\n%s\n----------------------------------------\n",inp);
	 buffer[0]='\0';
	}
       else
	{
	 strcat(buffer,line);
	 strcat(buffer," ");
	}
//        printf("\tbuffer='%s'\n",buffer);
      }
     if(buffer[0] !='\0')
      {
       transfer(buffer,&inp);
       printf("ERG:\n%s\n----------------------------------------\n",inp);
      }
     fclose(fp);
    }
   else
    {
     int len;
     transfer(command,&inp);
//      printf("sizeof(ret)=%d @%p \n",strlen(inp),inp);
     if((len=strlen(inp))>4096)
      {
       strncpy(pr,inp,1023);
       pr[1023]='\0';
       printf("ERG:\n%s ... '%s'\n----------------------------------------\n",pr,inp+len-1000);
      }
     else
      printf("ERG:\n%s\n----------------------------------------\n",inp);

    }
   closeApp(0);
  }
#endif // ! MACOSX
}

int cl_logIntoServer()
{
 char *cp[4],cdata[4][256],res[1024];
 ClientData cData;
 Tcl_Interp interp;

  printf("Minkowsky Commandline client\n\n");

 cp[0]=cdata[0];
 cp[1]=cdata[1];
 cp[2]=cdata[2];

 if(username[0] == '\0' || password[0]=='\0')
  printf("you need to authenticate to login\n");
 
 if(username[0] == '\0')
  {
   printf("Username: ");
   strcpy(cdata[0],"login");
   fgets(cdata[1],255,stdin);
   printf("\n");
  }
 else
  cp[1] = username;

 if(username[0] == '\0' || password[0]=='\0')
  strcpy(cdata[2],getpass("Password: "));
 else
  cp[2] =    password ;

 interp.result=res;
 logIntoServer(cData,&interp,2,cp);
 return(0);
}

int logIntoServer(ClientData cData, Tcl_Interp *interp, int argc, char *argv[])
{
 // char cmd[256],buffer[16384];
 char cmd[256],*buffer;

 strncpy(curUserName,argv[1],31);
 curUserName[31]='\0';
 strncpy(curPasswd,argv[2],31);
 curPasswd[31]='\0';


 mySocket= masterSocket=openSocket(terminHost,MASTERPORT);
 sprintf(cmd,"connect %s %s",argv[1],argv[2]);
 send2Socket(mySocket,cmd);
 // wait4Message(mySocket,buffer,16383);
 int retries=3;
 int slp=100000;
 do
  {
   buffer = wait4Message(mySocket,2000);
//    printf("-> %p %d\n",buffer,retries);
   if(buffer==NULL)
    {
     retries --;
     usleep(slp);
     slp *=2;
     printf("retry %d %d\n",retries,slp);
    }
  }while(buffer==NULL && retries >0);
 if(verbose)
  printf(">Got '%s' from %s:%d\n",buffer,terminHost,MASTERPORT);
 if(buffer ==NULL)
  {
   interp->result="Error: {Server not responding}";
   return TCL_OK;
  }
 if ( strcmp(buffer,"denied")==0)
  {
   interp->result="Error: {Keine Zugangsberechtigung}";
   return TCL_OK;
  }
 if ( strcmp(buffer,"noResource")==0)
  {
   interp->result="Error {Server berlastet}";
   return TCL_OK;
  }
 if ( strcmp(buffer,"noConnection")==0)
  {
   interp->result="Error (Port berlastet)}";
   return TCL_OK;
  }

 if( strncmp(buffer,"connected",9)!= 0 )
  {
   printf("Error : Connection to server '%s' broken\nServer doesn't answer correctly\n(answer='%s' instead of 'connected')",terminHost,buffer);
   sprintf(interp->result,"Error : Connection to server '%s' broken\nServer doesn't answer correctly\n(answer='%s' instead of 'connected cid')",terminHost,buffer);
   return TCL_OK;
  }
     
 send2Socket(mySocket,"client connected");
 myCid=atoi(buffer+9);
 if(verbose)
  printf("sent 'client connected on cid=%d'\n",myCid);
 // wait4Message(mySocket,buffer,16383);
 buffer = wait4Message(mySocket,2000);
 if(verbose)
  printf(">> Reply: '%s'\n",buffer);
 interp->result="OK";
 socketsUp=true;
 return TCL_OK;
}

int reconnect()
{
 char cmd[256],*buffer=NULL,*t=NULL;
 int retries=8;
 int slp=100000;

 if(mySocket>=0)
  {
   send2DamagedSocket(mySocket,"exit");
   closeSocket();
  }
 if(verbose)
  printf("Trying to reconnect to server\n");

 retries=8;
 do
  {
   mySocket= masterSocket=openSocket(terminHost,MASTERPORT);
   if(mySocket <0)
    {
     retries --;
     usleep(250000);
    }
  }while(mySocket<0 && retries >0);

 if(mySocket >=0)
  {
   sprintf(cmd,"reconnect %s %s %d",curUserName,curPasswd,myCid);
   cleanMessagePipe(mySocket);
   send2Socket(mySocket,cmd);
   t=buffer = wait4Message(mySocket,2000);

   retries=8;
   while (buffer == NULL && retries >0 )
    {
     if(verbose)
      printf("retry %d %d\n",retries,slp);
     retries --;
     t=buffer = wait4Message(mySocket,2000);
    }while(buffer==NULL && retries >0);
  }

 if(t==NULL)
  {
   if(verbose)
    printf("Server still unreachable\n");
   return(false);
  }
 
 if ( strcmp(buffer,"denied")==0)
  {
   if(verbose)
    printf("Error: {Keine Zugangsberechtigung}");
   return false;
  }
 if ( strcmp(buffer,"noResource")==0)
  {
   if(verbose)
    printf("Error {Server berlastet}");
   return false;
  }
 if ( strcmp(buffer,"noConnection")==0)
  {
   if(verbose)
    printf("Error (Port berlastet)}");
   return false;
  }
 usleep(10000);

 send2Socket(mySocket,"client connected");
 if(verbose)
  printf("sent 'client connected on cid=%d'\n",myCid);
 myCid=atoi(buffer+9);
 // wait4Message(mySocket,buffer,16383);
 wait4Message(mySocket,2000);
 socketsUp=true;
 
 return true;
}


int openSocket(char *master,int port)
{
 struct hostent     *he;
 struct sockaddr_in  server;
 int ret,flg;
 int lsocket=-1;

 lsocket=socket(AF_INET,SOCK_STREAM,0);

 if ((he = gethostbyname(master)) == NULL)
  {
   puts("error resolving hostname..");
   exit(1);
  }

 memcpy(&server.sin_addr, he->h_addr_list[0], he->h_length);
 server.sin_family = AF_INET;
 server.sin_port = htons(port);

 if( (ret=connect(lsocket, (struct sockaddr *)&server, sizeof(server))) != 0)
  {
   printf("Can't establish connection to server \n");
   return(-1);
  }
 
 flg = fcntl(lsocket, F_SETOWN,getpid());
 #ifndef MACOSX
 flg = fcntl(lsocket, F_SETSIG,SIGIO);
 #endif
 flg = fcntl(lsocket, F_SETFL, O_NONBLOCK|O_ASYNC);
 if(verbose)
  printf("ret=%d, lsocket=%d\n",ret,lsocket);
 return(lsocket);
}
 
int send2Socket(int socket,char *msg)
{
 int ret;
 if(verbose)
  printf("sending on %d '%s'\n",socket,msg);
 ret=send(socket,msg,strlen(msg)+1,0);
 return(ret);
}
int send2DamagedSocket(int socket,char *msg)
{
 int ret;
 if(verbose)
  printf("sending on %d '%s' (NOSIG)\n",socket,msg);
 #ifdef MACOSX
 ret=send(socket,msg,strlen(msg)+1,0);
  #else  
 ret=send(socket,msg,strlen(msg)+1,MSG_NOSIGNAL);
 #endif
 return(ret);
}
void cleanMessagePipe(int socket)
{
#ifndef MACOSX
 char **inp,t[65536];
 int ret;
 struct pollfd ps={socket,POLLIN,0};
 int timeout=1;

 if((ret=poll(&ps,(unsigned int) 1,timeout))>=0)
  {
   ret =recv(socket,t,65535,0);
  }
#endif
}

char *wait4Message(int socket,int timeout)
{
 int ack;
 return(wait4Message(socket,&ack,false,timeout,-1));
}

char *wait4Message(int socket, int *ack,int needAck ,int timeout,int comID)
{
 int ret,tl,rt=3,off,l;
 char *s,*t;
// struct pollfd ps={socket,POLLIN,0};
 // int timeout=500;
 int retries =6;
 int slp=500,slp2=0;
 int size=-1;
// char pr[256];
 char *oldBuffer;
// int pollret;
 struct itimerval timer,never;
 timer.it_interval.tv_sec  = 0;
 timer.it_interval.tv_usec = 0;
 timer.it_value   .tv_sec  = (int)floor(timeout/1000.);
 timer.it_value   .tv_usec = (timeout%1000)*1000;
 never.it_interval.tv_sec  = 0;
 never.it_interval.tv_usec = 0;
 never.it_value   .tv_sec  = 31536000;
 never.it_value   .tv_usec = 0;

 struct timeval tv;

 oldBuffer = bigMsgFromServer;
 t = msgFromServer;
 l = MSG_BUFFER_LEN;
 *t='\0';
 ret=0;
 tl=0;
 *ack=false;
 do
  {
   if(verbose)
    {
     printf("%4d:\twaiting 4 data (timeout =%d.%06d sec %04d)\n",comID,
	    timer.it_value.tv_sec,timer.it_value.tv_usec,timeout);
     gettimeofday(&tv,NULL);
     printf("\t\t\t\t time: %d:%6d\n",tv.tv_sec%1000,tv.tv_usec);
    }
   timerStopped =false;
   setitimer(ITIMER_REAL,&timer,NULL);
   while(!dataAvailable)
    {
     if(timerStopped)
      if(!dataAvailable)
       {
	if(verbose)
	 {
	  gettimeofday(&tv,NULL);
	  printf("WARNING: got no data within timeout @%d:%6d\n",tv.tv_sec%1000,tv.tv_usec);
	 }
	dataAvailable=false;
	return(NULL);
       }
    }
   setitimer(ITIMER_REAL,&never,NULL);
   timerStopped =false;
   ret =recv(socket,t,32,MSG_PEEK);
   if(verbose)
    printf("%4d: RECV %d -> %d\n",comID,ret,retries);
   
   if(ret<=0)
    {
     retries --;
     usleep(250000);
    }
   if(retries<0)
    {
     printf("%c\n",7);
     dataAvailable=false;
     return(NULL);
    }
  }while (ret<=0);

 double tim0,tim1;
 for(;; )
  { //endless loop
   ret =recv(socket,t+tl,l-tl,0);
   if(verbose)
    if(ret <64)
     {
      if(ret>0)
       {
	t[tl+ret]='\0';
	printf("%4d > anz= %4d      : '%s'\n",comID,ret,t+tl);
       }
      else
       printf("%4d > anz= %4d\n",comID,ret);
      if(ret>4)
       printf("%4d > %2X %2X %2X %2X %2X : '%s'\n",comID,*(t+tl),*(t+tl+1),*(t+tl+2),*(t+tl+3),*(t+tl+4),t+tl+4);
     }
   if(ret>0)
    {
     gettimeofday(&tv,NULL);
     tim0 = tv.tv_sec+tv.tv_usec/1000000.;
     if(tl==0)
      {
       if(strncmp(t,"ACK",3)==0)
	{
	 t += 4;
	 ret-=4;
	 *ack=true;
	 if( verbose )
	  printf("\t\t\t\t\tACK-> '%c%c%c%c%c ...'/%d\n ",t[0],t[1],t[2],t[3],t[4],tl);
	}
       if(t[tl] == '%' && t[tl+1] == '#' && ret >0)
	{
	 size = atoi(t+3);
	 if(verbose)
	  printf("%4d: size of msg : %d\n",comID,size);
	 if(size > MSG_BUFFER_LEN)
	  {
	   bigMsgFromServer = new char [size + 16384];
	   memcpy(bigMsgFromServer,t,ret +1);
	   t= bigMsgFromServer;
	   l = size + 16384;
	   rt=4*size/32768;
	   if(verbose)
	    printf("switching to bigmem done (%p,l=%d,rt=%d)\n",t,l,rt);
	   slp =size/100;
	   slp2=100;
	   if(slp >500000)
	    slp=5000000;
	   usleep(slp);
	  }
	 s= strstr(t+3,"%#");
	 s++;
	 s++;
	 off = s-t;
	 tl = ret-off;
	 t=s;
	}
       else 
	tl+=ret;
      }
     else
      tl+=ret;

     // Check for end of trandmission
     s= t+tl-4;
     if(s[0]=='E')
      if(s[1]=='O')
       {
	if(s[2]=='T')
	 {
	  if(verbose)
	   printf("got EOT: '%s' from %s\ntl=%d\n ACK=%d; size=%d\n",s,t,tl-4,*ack,size);
	  if(!*ack || size==-1)
	   {
	    if(verbose)
	     printf("got EOT but no ACK or missing size\n");
	    if(needAck)
	     {
	      cleanMessagePipe(socket);
	      dataAvailable=false;
	      return(NULL);
	     }
	   }
	  break;
	 }
       }
     if(tl<size)
      usleep(slp2);
    }
   else
    {
     rt--;
     gettimeofday(&tv,NULL);
     tim1 = tv.tv_sec+tv.tv_usec/1000000.;
     if(tim1 -tim0 > 2000000 )
      break;
     usleep(100);
//      if(rt==0)
//       {
//        break;
//       }
    }
   if(verbose)
    printf("\t\tcurrent msglen=%d\n",tl);
  }

 if(oldBuffer != NULL)
  {
   delete oldBuffer ;
   if(oldBuffer == bigMsgFromServer )
    bigMsgFromServer =NULL;
  }


 if(ret>0)
  {
   if(verbose)
    if(size >16784)
     if(fpl!=NULL)
      {
       fprintf(fpl,"BIG-transfer size=%d:\n%s\n\n\n",size,t);
       fflush(fpl);
      }
   if(needAck)
    {
     if(tl > size+5)
      {
       printf("\nWARNING: transfers data too big (transfer=%d, announced=%d\n\n",tl, size);
       *ack=false;
       dataAvailable=false;
       return(NULL);
      }
     if(tl < size+5)
      {
       printf("\nWARNING: transfers data too small (transfer=%d, announced=%d\n\n",tl, size);
       *ack=false;
       dataAvailable=false;
       return(NULL);
      }
    }
//    printf("setting stringterm at %s\n",s);
   *s='\0';
//    printf("returning '%s'\n",t);
   if(tl==0)
    {
     printf("%c\n",7);
     dataAvailable=false;
     return(NULL);
    }
   dataAvailable=false;
   return(t);
  }
 dataAvailable=false;
 return(NULL);
}

#ifdef MACOSX
void setGotData(int val)
#else
void setGotData(int val, siginfo_t *info,void * ptr)
#endif
{
 char tmp[64];
 int anz;

 if(val == SIGIO)
  {
   anz =recv(mySocket,tmp,63,MSG_PEEK);
   dataAvailable =true;
//    printf("sig %2d, code=%3d, fd=%4d: msg-peek: %d '%s'\n",
// 	  info->si_signo,info->si_code,info->si_fd,
// 	  anz,tmp);
  }
}
void timerStop (int value)
{
 timerStopped=true;
}
void pipebroken (int value)
{
 printf("\n\n!!!!!!!!!!\n PIPE BROKEN %d %c\n\n\n",value,7);
}



void startTCL (int argc, char *argv[] )
{
 char *cp[16],cmd[256];
 int count=2,i;

//#ifdef NEVER
 cp[0]="run";
 sprintf(cmd,"%s/main.tcl",binPath);
 cp[1]=cmd;
 for(i=1;i<argc; i++)
  {
   cp[i+1] =argv[i];
   count++;
  }
 if(autoInstallMRR)
  {
   cp[count]="-mrr";
   count ++;
  }
// printf("starting %s %s\n\n\n",cp[0],cp[1]);
 Tk_Main(count,cp,initApsh);
//#endif //NEVER
}

int initApsh(Tcl_Interp *interp)
{

//#ifdef NEVER
// Tcl_Command token;
 if (Tcl_Init(interp) == TCL_ERROR) {
  return TCL_ERROR;
 }
 if (Tk_Init(interp) == TCL_ERROR) {
  return TCL_ERROR;
 }
 
//#ifdef NEVER
 #ifdef NOTSKIP
 #ifdef MACOSX
    Tcl_MacOSXOpenBundleResources (interp, "com.tcltk.tklibrary", 
            1, MAX_PATH_LEN, tkLibPath);

    /* 
     * FIXME: This is currently a hack...  I set the tcl_library, and
     * tk_library, but apparently that's not enough to get slave interpreters,
     * even unsafe ones, to find the library code.  They seem to ignore 
     * this and look at the var set in TclGetLibraryPath.  So I override
     * that here.  There must be a better way to do this!
     */
         
    if (tclLibPath[0] != '\0') {
        pathPtr = Tcl_NewStringObj(tclLibPath, -1);
    } else {
        pathPtr = TclGetLibraryPath();
    }

    if (tkLibPath[0] != '\0') {
        Tcl_Obj *objPtr;
            
        Tcl_SetVar(interp, "tk_library", tkLibPath, TCL_GLOBAL_ONLY);
        objPtr = Tcl_NewStringObj(tkLibPath, -1);
        Tcl_ListObjAppendElement(NULL, pathPtr, objPtr);
    }
    
    TclSetLibraryPath(pathPtr);
#endif
#endif

 
 
 if (Tix_Init(interp) == TCL_ERROR) {
  return TCL_ERROR;
 }
 Tcl_CreateCommand(interp,"server"    ,transfer    ,(ClientData) NULL,(Tcl_CmdDeleteProc *) NULL);
 Tcl_CreateCommand(interp,"login"    ,logIntoServer,(ClientData) NULL,(Tcl_CmdDeleteProc *) NULL);
 Tcl_CreateCommand(interp,"weekDayByDate",weekDayByDate,(ClientData) NULL,(Tcl_CmdDeleteProc *) NULL);
 Tcl_CreateCommand(interp,"weekDayByDateStr",weekDayByDateStr,(ClientData) NULL,(Tcl_CmdDeleteProc *) NULL);
 Tcl_CreateCommand(interp,"currentTime",currentTime,(ClientData) NULL,(Tcl_CmdDeleteProc *) NULL);
 Tcl_CreateCommand(interp,"currentDateTime",currentDateTime,(ClientData) NULL,(Tcl_CmdDeleteProc *) NULL);
 Tcl_CreateCommand(interp,"timeBetween",timeBetween,(ClientData) NULL,(Tcl_CmdDeleteProc *) NULL);
 Tcl_CreateCommand(interp,"closeSocket",closeSocket,(ClientData) NULL,(Tcl_CmdDeleteProc *) NULL);
 Tcl_CreateCommand(interp,"closeApp",closeApp,(ClientData) NULL,(Tcl_CmdDeleteProc *) NULL);
 Tcl_CreateCommand(interp,"setTagList",setTagList ,(ClientData) NULL,(Tcl_CmdDeleteProc *) NULL);
 Tcl_CreateCommand(interp,"getTag",getTag ,(ClientData) NULL,(Tcl_CmdDeleteProc *) NULL);
 Tcl_CreateCommand(interp,"getBinPath",getBinPath ,(ClientData) NULL,(Tcl_CmdDeleteProc *) NULL);
 Tcl_CreateCommand(interp,"checkServer",checkServer ,(ClientData) NULL,(Tcl_CmdDeleteProc *) NULL);
 Tcl_CreateCommand(interp,"tryReconnect",tryReconnect,(ClientData) NULL,(Tcl_CmdDeleteProc *) NULL);
 Tcl_CreateCommand(interp,"mouseStatus",mouseStatus,(ClientData) NULL,(Tcl_CmdDeleteProc *) NULL);
 Tcl_CreateCommand(interp,"matchString",matchString,(ClientData) NULL,(Tcl_CmdDeleteProc *) NULL);
 
// #endif //NEVER
 return TCL_OK;
}


int transfer(ClientData cData, Tcl_Interp *interp, int argc, char *argv[])
{
// char buffer[500000],*inp,*t;
 char *buffer,*inp,*t;
 int i;

buffer	= globalBuffer;


 strcpy(buffer,"");
 for(i=1;i<argc;i++)
  {
   if(strlen(argv[i])==0)
    strcat(buffer,"{ } ");
   else
    {
     t=strchr(argv[i],' ');
     if(t!=NULL)
      strcat(buffer,"{");
     strcat(buffer,argv[i]);
     if(t!=NULL)
      strcat(buffer,"}");
     strcat(buffer," ");
    }
  }
 strcat(buffer," ");
 transfer(buffer,&inp);
 interp->result=inp;
 return TCL_OK;
}

int transfer(char *buffer,char **inp)
{
 return(transfer(buffer,inp,0));
}
int transfer(char *buffer,char **inp,int depth)
{
 int sl=5;
 int ack=false;
 char pr[1524];
// char cmd[256];
 static int delay =25;


 comID++;

 if (depth == 0)
  delay =0;

 if(depth >4)
  {
   strcpy(msgFromServer,"Error:    ServerDown : Die Verbindung zum Termin-Server ist unterbrochen");
   *inp = msgFromServer;
   return(false);
  }
 if (depth >0)
  {
   sleep(depth);
//    delay *= 2;
//    sprintf(cmd,"registerDelay %d\n",delay);
//   send2Socket(mySocket,cmd);
   cleanMessagePipe(mySocket);
  }


 if(socket <0)
  if(!reconnect())
   {
    strcpy(msgFromServer,"    ServerDown : Die Verbindung zum Termin-Server ist unterbrochen");
    *inp = msgFromServer;
    return(false);
   }
 send2Socket(mySocket,buffer);

 *inp =wait4Message(mySocket,&ack,true,2000,comID);
 if (*inp == NULL)
  return(transfer(buffer,inp,depth+1));

 while(!ack)
  {
   socketsUp =false;
   fprintf(stderr,"Server down\n");
   send2Socket(mySocket,"exit");
   closeSocket();
   if(verbose)
    printf("reconnecting\n");
   while(!reconnect())
    {
     if(verbose)
      printf("reconnecting\n");
     sleep(sl);
     sl *= 2;
     if (sl >200)
      {
       strcpy(msgFromServer,"    ServerDown : Die Verbindung zum Termin-Server ist unterbrochen");
       *inp = msgFromServer;
       return(false);
      }
    }
   send2Socket(mySocket,buffer);
   *inp = wait4Message(mySocket,&ack,true,2000,comID);
   if (*inp == NULL)
    {
     usleep(50000);
     return(transfer(buffer,inp,depth+1));
    }
  }
 if(verbose)
  {
   int len;
   if( (len=strlen(*inp)) >4000)
    {
     strncpy(pr,*inp,1500);
     pr[1500]='\0';
     printf("got: '%s         ...       %s' \ngot %ld bytes\n",pr, (*inp)+len-1000,strlen(*inp));
    }
   else
    printf("got: %s\n",*inp);
   usleep(250);
   printf("transfer completed\n");
  }
 usleep(1000);
 return (true);
}

int checkServer(ClientData cData, Tcl_Interp *interp, int argc, char *argv[])
{
 char *t;
// int i,sl=5,lost=false;

 if(verbose)
  {
   char txt[256];
   time_t tim=time(NULL);
   strftime(txt,255,"%Y%m%d %H %M %S",localtime(&tim));   
   if(verbose)
    printf("checking Server @ %s\n",txt);
  }

 struct sockaddr_in address[4];
 int ip ;
 #ifdef MACOSX
 int len;
 #else
 socklen_t len;
 #endif
 // address.sa_data = buffer;
 len = 4*sizeof(struct sockaddr);
 getpeername(mySocket, (struct sockaddr *)&address,&len);
 ip = (int) address->sin_addr.s_addr;
 if(verbose)
  printf("socket is connected to %d.%d.%d.%d\n",
	 (ip & 0xFF000000)>>24 ,
	 (ip & 0xFF0000)>>16 ,
	 (ip & 0xFF00)>> 8 ,
	 (ip & 0xFF) );

 send2Socket(mySocket,"ServerUp?");
 // t=wait4Message(mySocket,inp,500000);
 t=wait4Message(mySocket,4000);
 if(t==NULL || strcmp(t,"ServerIsUp")!=0)
  {
   if(verbose)
    printf("SERVER IS UNREACHABLE (%p %s)\n",t,t);
   send2DamagedSocket(mySocket,"exit");
   closeSocket();
   socketsUp =false;
   interp->result="down";
  }
 else
  interp->result="up";
 return TCL_OK;
}
int tryReconnect(ClientData cData, Tcl_Interp *interp, int argc, char *argv[])
{
// char buffer[500000],inp[16384],*t,*s;
// int i,sl=5,lost=false,count=13;

 if(verbose)
  printf("TryReconnect started\n");
 if(mySocket>0)
  {
   send2Socket(mySocket,"exit");
   closeSocket();
   socketsUp =false;
  }
 if(reconnect())
  {
   interp->result="up";
   if(verbose)
    printf("reconnect success\n");
  }
 else
  {
   if(verbose)
    printf("reconnect failed\n");
   interp->result="down";
  }
 return TCL_OK;
}



int weekDayByDate(ClientData cData, Tcl_Interp *interp, int argc, char *argv[])
{
 struct tm tm,*tmp;
 int tim;

 tm.tm_mday = atoi(argv[1]);
 tm.tm_mon  = atoi(argv[2])-1;
 tm.tm_year = atoi(argv[3])-1900;
 tm.tm_hour = 12;
 tm.tm_min  =tm.tm_sec =0;
 tmp=&tm;
 tim = mktime(&tm);
 tmp =localtime((const time_t *)&tim);
 sprintf(interp->result,"%d",(tmp->tm_wday+6) %7);
 return(TCL_OK);
}
int weekDayByDateStr(ClientData cData, Tcl_Interp *interp, int argc, char *argv[])
{
 struct tm tm,*tmp;
 int tim;
 int day,mon,year,dat;
 
 dat = atoi(argv[1]);
 day = dat % 100;
 mon = ((dat -day)/100) %100;
 year= (dat-day - 100 *mon) /10000;

 tm.tm_mday = day;
 tm.tm_mon  = mon;
 tm.tm_year = year;
 tm.tm_hour = 12;
 tm.tm_min  =tm.tm_sec =0;
 tmp=&tm;
 tim = mktime(&tm);
 tmp =localtime((const time_t *)&tim);
 sprintf(interp->result,"%d",(tmp->tm_wday+6) %7);
 return(TCL_OK);
}
int currentTime(ClientData cData, Tcl_Interp *interp, int argc, char *argv[])
{
 sprintf(interp->result,"%d",(int)time(NULL));
 return TCL_OK;
}
int currentDateTime(ClientData cData, Tcl_Interp *interp, int argc, char *argv[])
{
 time_t tim=time(NULL);
 strftime(tclMsg,255,"%Y%m%d %H %M",localtime(&tim));   
 interp->result = tclMsg;
 return TCL_OK;
}
int timeBetween(ClientData cData, Tcl_Interp *interp, int argc, char *argv[])
{
 int startD,startT,stopD,stopT;
 int start,stop,delta;
 struct tm tm;

 startD = atoi(argv[1]);
 startT = atoi(argv[2]);
 stopD  = atoi(argv[3]);
 stopT  = atoi(argv[4]);
 
 tm.tm_mday = startD % 100;
 tm.tm_mon  = ((startD-tm.tm_mday)/100)%100;
 tm.tm_year = (startD-100*tm.tm_mon-tm.tm_mday)/10000 -1900;
 tm.tm_min  = startT %100;
 tm.tm_hour = (startT-tm.tm_min)/100; 
 tm.tm_sec  = 0;
 tm.tm_isdst= -1;
 start      = mktime(&tm);

 if(startD>0)
  {
   tm.tm_mday = stopD % 100;
   tm.tm_mon  = ((stopD-tm.tm_mday)/100)%100;
   tm.tm_year = (stopD-100*tm.tm_mon-tm.tm_mday)/10000 -1900;
   tm.tm_min  = stopT %100;
   tm.tm_hour = (stopT-tm.tm_min)/100;
   tm.tm_sec  = 0;
   tm.tm_isdst= -1;
   stop      = mktime(&tm);
  }
 else
  stop =time(NULL);

 delta = stop-start;
 sprintf(interp->result,"%d",delta);
 return TCL_OK;
}

// int checkServer(ClientData cData, Tcl_Interp *interp, int argc, char *argv[])
// {
//  char *t;
//  t=wait4Message(mySocket,tclMsg,16383);
//  interp->result=tclMsg;
//  return TCL_OK;
// }


int closeSocket (ClientData cData, Tcl_Interp *interp, int argc, char *argv[])
{
 closeSocket();
 return TCL_OK;
}
int closeSocket ()
{
 int ret;
 ret = close(mySocket);
 if(verbose)
  printf("mysocket closed ret=%d\n",ret);
 ret = close(masterSocket);
 if(verbose)
  printf("sockets closed ret=%d\n",ret);
 mySocket=-1;
 return(0);
}

int closeApp(ClientData cData, Tcl_Interp *interp, int argc, char *argv[])
{
 closeApp(0);
 return TCL_OK;
}
void closeApp(int value)
{
 send2Socket(mySocket,"exit");

 closeSocket();
 if(verbose)
  printf("Terminator-Client terminates %d\n",value);
 usleep(500000);
 exit(0);
}

int getTag(ClientData cData, Tcl_Interp *interp, int argc, char *argv[])
{
 int x,y,i,id;

 id = (atoi(argv[1]) % 8);
 x=atoi(argv[2]);
 y=atoi(argv[3]);
 // printf("look on List %d (len=%d) for (%d %d)",id,canvasListLength[id],x,y);
 for(i=0;i<canvasListLength[id]; i++)
  {
//    printf("testing %s=(%d %d %d %d_ for (%d %d)\n",canvasList[id][i].tag,
// 	  canvasList[id][i].x0,canvasList[id][i].y0,canvasList[id][i].x1,canvasList[id][i].y1,x,y);
   if(canvasList[id][i].x0<=x)
    if(canvasList[id][i].y0<=y)
     if(x<=canvasList[id][i].x1)
      if(y<=canvasList[id][i].y1)
       {
// 	printf("Thats it '%s'\n",canvasList[id][i].tag);
	interp->result=canvasList[id][i].tag;
	return TCL_OK;
       }
  }
 interp->result="-";
 return TCL_OK;
}
int getBinPath(ClientData cData, Tcl_Interp *interp, int argc, char *argv[])
{
 strcpy(interp->result,binPath);
 return TCL_OK;
}
int setTagList(ClientData cData, Tcl_Interp *interp, int argc, char *argv[])
{
 // usages id anz list
 // list-elem = {tag x0 y0 x1 y1}
 int anz,i,id;
 char *t,*s;
 
 id = (atoi(argv[1]) % 8);

 anz = atoi(argv[2]);
 if ( canvasList[id] !=NULL)
  delete canvasList[id];
 canvasList[id] = new canvasTags [anz];
 t= argv[3];
 //  printf("new TagList on id=%d : '%s'\n",id,t);
 for(i=0;i<anz ; i++)
  {
   s=t;
   t=nextElement(t);
   strcpy(canvasList[id][i].tag,s);

   s=t;
   t=nextElement(t);
   canvasList[id][i].x0 = atoi(s);
   s=t;
   t=nextElement(t);
   canvasList[id][i].y0 = atoi(s);
   s=t;
   t=nextElement(t);
   canvasList[id][i].x1 = atoi(s);
   s=t;
   t=nextElement(t);
   canvasList[id][i].y1 = atoi(s);
  }

 canvasListLength[id]=anz;
 return(TCL_OK);
}


int matchString(ClientData cData, Tcl_Interp *interp, int argc, char *argv[])
{
 int len;

 if(argc <3)
  interp->result = "0";
 else 
  {
   len = strlen(argv[1]);
   if(strncasecmp(argv[2],argv[1],len)==0)
    interp->result = "1";
   else
    interp->result = "0";
  }

 return TCL_OK;
}
char *nextElement(char *t)
{
 char *p;

 while (*t== ' ')
  t++;
 p=strchr(t,' ');
 if(p != NULL)
  *p='\0';
 return(p+1);
}

char *skip2NonWS(char*t)
{
 while(*t==' ' ||*t=='\t')
  t++;
 return(t);
}

#ifdef MACOSX
int mouseStatus(ClientData cData, Tcl_Interp *interp, int argc, char *argv[])
{

 sprintf(interp->result,"%d",mouseStatus());
 return(TCL_OK);
}
#else
int mouseStatus(ClientData cData, Tcl_Interp *interp, int argc, char *argv[])
{
 Tk_Window tkwin;
 Display *display;
 Window w;
 Window root_return, child_return;
 int root_x_return, root_y_return;
 int win_x_return, win_y_return;
 unsigned int mask_return;

 tkwin = Tk_NameToWindow(interp,".",Tk_MainWindow(interp)); // Ich kenne noch kein Tk_Window
 w = Tk_WindowId(tkwin);
 display = Tk_Display(tkwin);
 if(XQueryPointer(display, w, &root_return, &child_return,&root_x_return, &root_y_return,&win_x_return, &win_y_return,&mask_return))
  {
   sprintf(interp->result,"%d",mask_return);
  }
 else
  {
   strcpy(interp->result,"-1");
  }
 return TCL_OK;
}
#endif
char * strTrim (char *t)
{
 char *s,*z;

 s= t+strlen(t)-1;
 while (*s ==' ' || *s=='\n' || *s=='\t')
  s--;
 if(s[1] !='\0' && s>t)
  s[1]='\0';

 s=t;
 while(*s ==' ' || *s=='\n' || *s=='\t')
  s++;
 if(s>t)
  {
   z=t;
   while(*s!='\0')
    {
     *z=*s;
     z++;
     s++;
    }
   // t++;
   *z='\0';
  }
 return(t);
}
