#!/usr/bin/X11/tixwish
#  File: groupSel.tcl
# 
#      This file is part of minkowsky
# 
#      Copyright (C) 2001-2002 by Rdiger Goetz
#      Author: Rdiger Goetz <minkowsky@r-goetz.de>
# 
#      Time-stamp: <25-May-2002 19:22:45 goetz>
# 
#      This program is free software; you can redistribute it and/or modify
#      it under the terms of the GNU General Public License as published by
#      the Free Software Foundation; either version 2 of the License, or
#      (at your option) any later version.
# 
#      This program is distributed in the hope that it will be useful,
#      but WITHOUT ANY WARRANTY; without even the implied warranty of
#      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#      GNU General Public License for more details.
# 
#      You should have received a copy of the GNU General Public License
#      along with this program; if not, write to the Free Software
#      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#  

proc groupSelector { win  height} {
    global bfnt fnt12 bfnt16 bfnt12 bfnt16
    global gs_userHeight gs_groupHeight gs_roomHeight
    global GSwin _allgText _buttonText _ballonText _gselText GSchanged ballon
    global gsWidth 
    
    frame $win.f -relief raised -bd 1
    pack $win.f -side bottom -fill x
    set GSwin $win.f

    frame $GSwin.t  -relief raised -bd 2
    frame $GSwin.ut -relief raised -bd 1
    frame $GSwin.ul -relief flat   -bd 1
    frame $GSwin.gt -relief raised -bd 1
    frame $GSwin.gl -relief flat  -bd 1
    frame $GSwin.rt -relief raised -bd 1
    frame $GSwin.rl -relief flat  -bd 1
    frame $GSwin.bt -relief flat   -bd 1
    pack  $GSwin.bt  $GSwin.rl $GSwin.rt  $GSwin.gl $GSwin.gt  $GSwin.ul $GSwin.ut $GSwin.t  -side bottom -fill x

    label $GSwin.t.l  -text $_allgText(calSelection) -font $bfnt16
    label $GSwin.ut.l -text $_allgText(Users) -font $bfnt
    label $GSwin.gt.l -text "$_allgText(Gruppen) & $_allgText(Sets) " -font $bfnt
    label $GSwin.rt.l -text $_allgText(Raume) -font $bfnt
    pack  $GSwin.t.l $GSwin.ut.l $GSwin.gt.l $GSwin.rt.l -side left

    
    set gh $gs_groupHeight
    set rh $gs_roomHeight
    set uh $gs_userHeight
    tixScrolledWindow $GSwin.ul.s -height $uh -scrollbar {auto -x} -width $gsWidth
    tixScrolledWindow $GSwin.gl.s -height $gh -scrollbar {auto -x} -width $gsWidth
    tixScrolledWindow $GSwin.rl.s -height $rh -scrollbar {auto -x} -width $gsWidth
    pack $GSwin.ul.s $GSwin.gl.s $GSwin.rl.s -side left -fill x

    $GSwin.ul.s subwidget vsb configure -width 10
    $GSwin.gl.s subwidget vsb configure -width 10
    $GSwin.rl.s subwidget vsb configure -width 10

    button $GSwin.bt.show -text $_buttonText(Show)  -command GSshow  -state disabled -font $bfnt12 -width 7 
    button $GSwin.bt.save -text $_gselText(ButSaveSet)   -command saveSet -state disabled -font $bfnt12 -width 12
    pack $GSwin.bt.show $GSwin.bt.save  -side left -fill x
    set GSchanged 0
    
    $ballon bind $GSwin.t.l      -balloonmsg $_ballonText(GS_TitelCal)
    $ballon bind $GSwin.bt.show  -balloonmsg $_ballonText(GS_Show)
    $ballon bind $GSwin.bt.save  -balloonmsg $_ballonText(GS_SaveSet)
}

proc getGSsectionHeights { height } {
    set bheight [expr $height -86]
    set gh [ expr int (floor($bheight*.25))]
    set rh [ expr int (floor($bheight*.15))]
    set uh [ expr $bheight - $gh -$rh ]
    return "$uh $gh $rh"
}
    
proc activateGSlist { } {
    global GSwin GSactiv GSchanged
    set GSactiv 1
    setGSshowButtonStatus
#     if { $GSchanged == 1 } {
# 	$GSwin.bt.show configure-state  normal
#     } else {
# 	$GSwin.bt.show configure-state  disabled
#     }
    $GSwin.bt.save configure -state  normal
}
proc setGSshowButtonStatus { } {
    global GSwin GSactiv GSchanged

    if { $GSactiv == 1 && $GSchanged == 1 } {
	$GSwin.bt.show configure -state  normal
    } else {
	$GSwin.bt.show configure -state  disabled
    }
}
proc fillGroupSelector { } {
    global userList groupList roomList fullUserNameList fullUserNames
    global setList  usersByGroup
    global bfnt fnt12 bfnt12
    global groupListExclusiveIcon groupListAllIcon groupListEmptyIcon
    global curGSbutton curGSgroup
    global GSwin
    global cur_Cal
    global colorList
    global imgGreyData
    global setList setListNames dontList
    global setLines ballon _ballonText

    set imgGreyData "/* XPM */
    static char * dummy_xpm[] = {
    \"8 8 1 1\",
    \".      c #D3D3D3\",
    \"........\",
    \"........\",
    \"........\",
    \"........\",
    \"........\",
    \"........\",
    \"........\",
    \"........\"};"
    image create pixmap gsimgGrey -data $imgGreyData

    set i 0
    
    set swin [$GSwin.ul.s subwidget window]
    foreach user $userList {
	global sel-u-$user
	global gsimg-$user

	if { $dontList(u-$user) == 1 } { continue }
	frame $swin.u$user
	pack $swin.u$user -side top -fill x
	button $swin.u$user.ex -image [image create pixmap -data $groupListExclusiveIcon] -command setGSexclusive
	$ballon bind  $swin.u$user.ex     -balloonmsg $_ballonText(GS_excl)

        set gsimg-$user [getSelectorImage [lindex $colorList(u-$user) 0] [lindex $colorList(u-$user) 1] $user]
	checkbutton $swin.u$user.cb -variable sel-u-$user -padx 0  -command clearGSRoombutton -selectcolor "#D3D3D3" -image gsimgGrey -selectimage gsimg-$user -indicatoron 0
   
	label $swin.u$user.l  -text $fullUserNames(u-$user) -width 20 -justify left -font $bfnt12 
	set sel-u-$user 0
	pack $swin.u$user.ex  $swin.u$user.cb $swin.u$user.l  -side left -pady 0 -ipady 0 -padx 0 -ipadx 0 -fill x
	bind $swin.u$user.ex <ButtonPress> { 
	    set curGSbutton %W
	    set curGSgroup U
	}
	bind $swin.u$user.ex <Double-Button-1>  {
	    GSshow
	}
	bind $swin.u$user.l <Double-Button-1> { addCalAndShow u %W }
    }
    set swin [$GSwin.gl.s subwidget window]
    foreach group $groupList {
	global sel-g-$group

	if { $dontList(g-$group) == 1 } { continue }
	
	frame $swin.g$group
	pack $swin.g$group -side top -fill x
	button $swin.g$group.al -image [image create pixmap -data $groupListAllIcon] -command addAllUser2GS
	$ballon bind  $swin.g$group.al    -balloonmsg $_ballonText(GS_GroupAll)

	checkbutton $swin.g$group.cb -variable sel-g-$group  -padx 0 -selectcolor  $colorList(g-$group) -command clearGSRoombutton 
	label $swin.g$group.l  -text $group -width 20 -justify left -font $bfnt12 
	set sel-g-$group 0
	pack $swin.g$group.al  $swin.g$group.cb $swin.g$group.l -side left -pady 0 -ipady 0 -fill x
	bind $swin.g$group.al <ButtonPress> {
	    set curGSbutton %W
	    set curGSgroup G
	}
	bind $swin.g$group.al <Double-Button-1>  {
	    GSshow
	}
	bind $swin.g$group.l <Double-Button-1> { addCalAndShow g %W }
    }
    if { [llength $setListNames ] > 0 } {
	frame $swin.sep -relief sunken -bd 1 -height 2
	pack $swin.sep -fill x -side top -pady 2
    }
    set setLines 0
    foreach setname $setListNames {
	frame $swin.s$setname
	pack $swin.s$setname -side top -fill x
	button $swin.s$setname.al -image [image create pixmap -data $groupListAllIcon] -command addAllSetMembers2GS
	$ballon bind  $swin.s$setname.al    -balloonmsg $_ballonText(GS_SetAll)
	label $swin.s$setname.l  -text "      $setname" -width 26 -justify left -font $bfnt12 
	pack $swin.s$setname.al $swin.s$setname.l -side left -pady 0 -ipady 0 -fill x
	bind $swin.s$setname.al <ButtonPress> {
	    set curGSbutton %W
	    set curGSgroup S
	}
	bind $swin.s$setname.al <Double-Button-1>  {
	    GSshow
	}
	incr setLines
    }



    set swin [$GSwin.rl.s subwidget window]
    foreach room $roomList {
	global sel-r-$room

	if { $dontList(r-$room) == 1 } { continue }
	frame $swin.r$room
	pack $swin.r$room -side top -fill x
	button $swin.r$room.al -image [image create pixmap -data $groupListEmptyIcon] -relief flat -state disabled
	checkbutton $swin.r$room.cb -variable sel-r-$room  -padx 0 -selectcolor brown -command setRoom2GS
	label $swin.r$room.l  -text $room -width 20 -justify left -font $bfnt12
	set sel-r-$room 0
	pack $swin.r$room.al  $swin.r$room.cb $swin.r$room.l -side left -pady 0 -ipady 0 -fill x
	bind $swin.r$room.cb <ButtonPress> {
	    set curGSbutton %W
	    set curGSgroup R
	}
	bind $swin.r$room.l <Double-Button-1> { addCalAndShow r %W }
    }
    clearGSbutton "-"
    foreach usr $cur_Cal {
	set typ [string range $usr 0 0]
	if  { $typ == "r" } {
	    setRoom2GS
	} else {
	    clearGSRoombutton
	}
	set sel-$usr 1
    }
}

proc displayPresence { } {
    global GSwin userPresence userListExeptDonts toolSelection


    set swin [$GSwin.ul.s subwidget window]
    foreach user $userListExeptDonts {
	if  { $toolSelection == "A" } {
	    if { $userPresence($user) == 1 } {
		$swin.u$user.l configure -fg grey25
	    } else {
		$swin.u$user.l configure -fg grey50 
	    }
	} else {
	    if { $userPresence($user) == 1 } {
		$swin.u$user.l configure -fg black
	    } else {
		$swin.u$user.l configure -fg grey40
	    }

	}
    }
    
}

proc getSelectorImage { col1 col2 user} {
#    puts "COLORS($user): '$col1' '$Acol2'"
    global imgdata-$user
    set imgdata-$user [format "/* XPM */
static char * dummy_xpm[] = {
    \"8 8 2 1\",
    \"       c %s\",
    \".      c %s\",
    \"        \",
    \"        \",
    \"        \",
    \"        \",
    \"        \",
    \"........\",
    \"........\",
    \"........\"};" $col2 $col1 ]
image create pixmap gsimg-$user -data [set imgdata-$user]
return gsimg-$user
}

proc  setRoom2GS {  } { 
    global curGSbutton curGSgroup GSchanged

    set el [ split $curGSbutton .]
    set l [ llength $el ]
    set win "r-[string range [ lindex $el [expr $l -2]] 1 end]"
    set GSchanged 1
    setGSshowButtonStatus

    clearGSbutton $win 
}
proc addAllUser2GS { } {
    global userList groupList usersByGroup
    global curGSbutton GSchanged

    set el [ split $curGSbutton .]
    set l [ llength $el ]
    set win [string range [ lindex $el [expr $l -2]] 1 end]

    foreach user $usersByGroup($win) {
	global sel-u-$user
	set sel-u-$user 1
    }
    global sel-g-$win
    set sel-g-$win 1
    clearGSRoombutton
    set GSchanged 1
    setGSshowButtonStatus
}
proc addAllSetMembers2GS { } {
    global setList
    global curGSbutton GSchanged

    set el [ split $curGSbutton .]
    set l [ llength $el ]
    set win [string range [ lindex $el [expr $l -2]] 1 end]

    
    foreach ent $setList($win) {
	global sel-$ent
	set sel-$ent 1
    }
    clearGSRoombutton
    set GSchanged 1
    setGSshowButtonStatus
}
proc addCalAndShow { grp but } {
    global toolSelection
    set el [ split $but .]
    set l [ llength $el ]
    set who "$grp-[string range [ lindex $el [expr $l -2]] 1 end]"
    if { $grp == "r" } {
	if {$toolSelection == "K" } { clearGSbutton $who }
    } else {
	global sel-$who
	clearGSRoombutton
	if {$toolSelection != "T" } { set sel-$who 1 }
    }
    GSshow
}
proc setGSexclusive { } {
    global curGSbutton curGSgroup GSchanged

    set el [ split $curGSbutton .]
    set l [ llength $el ]
    set who "u-[string range [ lindex $el [expr $l -2]] 1 end]"
    clearGSbutton $who
    set GSchanged 1
    setGSshowButtonStatus
#    puts "setExcl for [ lindex $el [expr $l -2]]"
}
proc clearGSbutton { who } {
    global GSwin GSchanged
    global userList groupList roomList fullUserNameList fullUserNames

    set swin [$GSwin.ul.s subwidget window]
    foreach user $userList {
	global sel-u-$user
	set sel-u-$user 0
    }
    set swin [$GSwin.gl.s subwidget window]
    foreach group $groupList {
	global sel-g-$group
	set sel-g-$group 0
    }
    set swin [$GSwin.rl.s subwidget window]
    foreach room $roomList {
	global sel-r-$room
	set sel-r-$room 0
    }
    if { $who != "-" } {  
	global sel-$who
	set sel-$who 1
    }
    set GSchanged 1
    setGSshowButtonStatus
}
proc clearGSRoombutton {  } {
    global GSwin GSchanged
    global  roomList 
    foreach room $roomList {
	global sel-r-$room
	set sel-r-$room 0
    }
    set GSchanged 1
    setGSshowButtonStatus
}

proc getGSselection { } {
    global GSwin
    global userList groupList roomList fullUserNameList fullUserNames
    global cur_Cal
    
    set list ""
    set swin [$GSwin.ul.s subwidget window]
    foreach user $userList {
	global sel-u-$user
	set val [set sel-u-$user]
	if { $val == 1} {
	    lappend list "u-$user"
	}
    }
    set swin [$GSwin.gl.s subwidget window]
    foreach group $groupList {
	global sel-g-$group
	set val [set sel-g-$group]
	if { $val == 1} {
	    lappend list "g-$group"
	}
    }
    set swin [$GSwin.rl.s subwidget window]
    foreach room $roomList {
	global sel-r-$room
	set val [set sel-r-$room]
	if { $val == 1} {
	    lappend list "r-$room"
	}
    }
    return $list
}    

proc GSshow { } {
    global GSwin
    global userList groupList roomList fullUserNameList fullUserNames
    global cur_Cal GSchanged
    
    set cur_Cal [ getGSselection]
#    drawCal
    drawNewView
    set GSchanged 0
    setGSshowButtonStatus
}


proc resetGSselection { } {
    global toolSelection roomList groupList GSwin GSactiv userList setListNames dontList
    global userListExeptDonts groupListExeptDonts
    global  _allgText 

#    puts "GSactive=$GSactiv tool=$toolSelection"
    if {$GSactiv == 1} { 
	switch  $toolSelection  {
	    T {
		$GSwin.t.l configure -state normal -text $_allgText(taskSelection)
		set swin [$GSwin.ul.s subwidget window]
		foreach user $userList {
		    if { $dontList(u-$user) == 1 } { continue }
		    $swin.u$user.ex configure -state normal   
		    $swin.u$user.cb configure -state normal   
		    $swin.u$user.l  configure -fg black 
		}
		set swin [$GSwin.gl.s subwidget window]
		foreach group $groupList {
		    if { $dontList(g-$group) == 1 } { continue }
		    $swin.g$group.al configure -state normal   
		    $swin.g$group.cb configure -state disabled
		    $swin.g$group.l  configure -fg black 	
		}
		foreach setname $setListNames {
		    $swin.s$setname.al configure -state normal   
		    $swin.s$setname.l  configure -fg black 	
		}
		set swin [$GSwin.rl.s subwidget window]
		foreach room $roomList {
		    $swin.r$room.cb configure -state disabled
		    $swin.r$room.l  configure -fg grey50
		}
		$GSwin.bt.show configure -state  normal
		$GSwin.bt.save configure -state  normal
	    } 
	    K {
		$GSwin.t.l configure -state normal -text $_allgText(calSelection)
		set swin [$GSwin.ul.s subwidget window]
		foreach user $userList {
		    if { $dontList(u-$user) == 1 } { continue }
		    $swin.u$user.ex configure -state normal   
		    $swin.u$user.cb configure -state normal   
		    $swin.u$user.l  configure -fg black 
		}
		set swin [$GSwin.gl.s subwidget window]
		foreach group $groupList {
		    if { $dontList(g-$group) == 1 } { continue }
		    $swin.g$group.al configure -state normal   
		    $swin.g$group.cb configure -state normal
		    $swin.g$group.l  configure -fg black 	
		}
		foreach setname $setListNames {
		    $swin.s$setname.al configure -state normal   
		    $swin.s$setname.l  configure -fg black 	
		}
		set swin [$GSwin.rl.s subwidget window]
		foreach room $roomList {
		    $swin.r$room.cb configure -state normal
		    $swin.r$room.l  configure -fg black
		}
		$GSwin.bt.show configure -state  normal
		$GSwin.bt.save configure -state  normal
	    } 
	    A {
		$GSwin.t.l configure -state disabled
		set swin [$GSwin.ul.s subwidget window]
		foreach user $userListExeptDonts  {
#		    if { $dontList(u-$user) == 1 } { continue }
#		    puts "disable User $user"
		    $swin.u$user.ex configure -state disabled
		    $swin.u$user.cb configure -state disabled
		    $swin.u$user.l  configure -fg grey50
		}
		set swin [$GSwin.gl.s subwidget window]
		foreach group $groupListExeptDonts {
#		    if { $dontList(g-$group) == 1 } { continue }
#		    puts "disable Group $group"
		    $swin.g$group.al configure -state disabled
		    $swin.g$group.cb configure -state disabled
		    $swin.g$group.l  configure -fg grey50	
		}
		foreach setname $setListNames {
		    $swin.s$setname.al configure -state disabled
		    $swin.s$setname.l  configure -fg grey50	
		}
		set swin [$GSwin.rl.s subwidget window]
		foreach room $roomList {
#		    puts "disable Room $room"
		    $swin.r$room.cb configure -state disabled
		    $swin.r$room.l  configure -fg grey50
		}
		$GSwin.bt.show configure -state  disabled
		$GSwin.bt.save configure -state  disabled
	    }
	}
    }
    
    if {  [info exists userList ] == 1} {
	getPresence
	displayPresence
    }
}

proc saveSet { } {
    global setList setListNames setName  bfnt12 _buttonText _allgText _gselText
    
    if { [winfo exists .ssd ] == 1 } { return }
    toplevel .ssd
    wm title .ssd $_gselText(wmTitel_ssd)
    frame .ssd.t -relief raised -bd 1
    frame .ssd.b -relief flat -bd 1
    pack .ssd.t .ssd.b -side top -fill x

    label .ssd.t.l -text "$_gselText(wmTitel_ssd) : " -font $bfnt12
    entry .ssd.t.e  -textvariable setName -width 20  -vcmd {checkEntryText %P 63  %d %S ""} -validate key
    pack .ssd.t.l  .ssd.t.e -side left

    button .ssd.b.abb -text $_buttonText(Cancel) -command {destroy .ssd} -font $bfnt12
    label .ssd.b.l -text "  " -font $bfnt12
    button .ssd.b.ok  -text "$_allgText(Set) $_buttonText(Save)" -font $bfnt12 -command {
	checkSaveSet 
	destroy .ssd
    }
    pack .ssd.b.abb   .ssd.b.l -side left
    pack .ssd.b.ok  -side right
    grab .ssd
    centerWin .ssd 256 56
    update 
#    puts [wm geometry .ssd]
}
proc checkSaveSet { } {
    global setList setListNames setName  bfnt12 fnt12 _buttonText _allgText _gselText

    if { [lsearch $setListNames $setName] >=0 } {
	if { [winfo exists .css ] == 1 } { return }
	toplevel .css
	wm title .css $_gselText(wmTitle_css)
	frame .css.t -relief raised -bd 1
	frame .css.b -relief flat -bd 1
	pack .css.t .css.b -side top -fill x
	message .css.t.l -text "$_gselText(SetExisting1) '$setName'\n$_gselText(SetExisting2)" -font $fnt12 -width 250    
	pack .css.t.l  -side top -fill x
	button .css.b.abb -text $_buttonText(Cancel)  -font $bfnt12 -command {
	    destroy .css
	    destroy .ssd
	}
	label .css.b.l -text "  " -font $bfnt12
	button .css.b.ok  -text $_buttonText(Replace) -font $bfnt12 -command { 
	    doSaveSet 1
	    destroy .css
	    destroy .ssd
	}
	pack .css.b.abb  .css.b.l  -side left
	pack .css.b.ok  -side right
	grab .css
	centerWin .css 254 84
	update 
    } else {
	doSaveSet 0
    }
}
proc doSaveSet { override  } {
    global setList setListNames setName  GSwin groupListAllIcon fnt12 username setLines

    set setList($setName) [getGSselection]
    
    set ret [transfer saveSet  $username $setName $override $setList($setName) ]
    if { [string first $ret "ServerDown"] >=0 } {ServerDownDialog}

    if { $override == 0 } {
	lappend setListNames $setName

	

	set swin [$GSwin.gl.s subwidget window]
	if { $setLines == 0 } {
	    frame $swin.sep -relief sunken -bd 1 -height 2
	    pack $swin.sep -fill x -side top -pady 2
	}
	frame $swin.s$setName
	pack $swin.s$setName -side top -fill x
	button $swin.s$setName.al -image [image create pixmap -data $groupListAllIcon] -command addAllSetMembers2GS
	label $swin.s$setName.l  -text "      $setName" -width 26 -justify left -font $fnt12 
	pack $swin.s$setName.al $swin.s$setName.l -side left -pady 0 -ipady 0 -fill x
	bind $swin.s$setName.al <ButtonPress> {
	    set curGSbutton %W
	    set curGSgroup S
	}
	bind $swin.s$setName.al <Double-Button-1>  {
	    GSshow
	}
	incr setLines
    }
}
