#!/usr/bin/X11/tixwish
#  File: help.tcl
# 
#      This file is part of minkowsky
# 
#      Copyright (C) 2001-2002 by Rdiger Goetz
#      Author: Rdiger Goetz <minkowsky@r-goetz.de>
# 
#      Time-stamp: <28-May-2002 20:19:17 goetz>
# 
#      This program is free software; you can redistribute it and/or modify
#      it under the terms of the GNU General Public License as published by
#      the Free Software Foundation; either version 2 of the License, or
#      (at your option) any later version.
# 
#      This program is distributed in the hope that it will be useful,
#      but WITHOUT ANY WARRANTY; without even the implied warranty of
#      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#      GNU General Public License for more details.
# 
#      You should have received a copy of the GNU General Public License
#      along with this program; if not, write to the Free Software
#      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#  

proc helpGetDocPath { } {
    global langType docBasePath _allgText

    set dirList "$langType en de default"
    foreach lang $dirList {
	set docPath "$docBasePath/$lang"
	if { [ file exists $docPath] == 1 } {
	    if { [ file isdirectory $docPath] == 1 } {
		if { [ file readable $docPath/index.html] == 1 } {
		    break
		}
	    }
	}
	set docPath ""
    }
    if { $docPath == "" } {
	set testPath "$docBasePath"
	if { [ file exists $testPath] == 1 } {
	    if { [ file readable $testPath/index.html] == 1 } {
		set docPath $testPath
	    }
	}
    }
    if { $docPath == "" } {
	_ErrorDialog $_allgText(ErrorNoHelpTitle) $_allgText(ErrorNoHelpText)
	return "Error"
    }
    return $docPath
}

proc displayHelp { } {
    global docBasePath langType _allgText
    global docPath  buglfile helpNaviFile helpIndexFile upd_browserID upd_browserCmd

    set docPath [ helpGetDocPath ]
    if { $docPath == "Error" } { return }

    if { $upd_browserID == "minkowsky" } {
	_displayHelp 0
	renderHelp $docPath/index.html
    } else { 
	createHelpPages
	switch $upd_browserID {
	    kfm          { catch { exec kfm $helpIndexFile &} }
	    konqueror    { catch { exec konqueror $helpIndexFile &} }
	    mozilla      { catch { exec mozilla $helpIndexFile) & } }
	    netscape     { catch { exec netscape -remote "openBrowser($helpIndexFile) &" } }
	    user         {
		regsub -all {%s} $upd_browserCmd $helpIndexFile cmd
		puts "BROWSER: '$cmd'"
		catch {eval "exec $cmd &" }
#		set err [catch { eval "exec cmd &" }]
#		puts "-> $err"
	    }
	}
    }
}

proc displayLoginHelp { } {
    global docPath

    set docPath [ helpGetDocPath ]
    if { $docPath == "Error" } { return }

    _displayHelp 1
    renderHelp $docPath/login.html
}

proc _displayHelp { doGrab } {
    global docPath fnt12 bfnt buglfile _helpText _buttonText
    
    set buglfile ""
    if { [winfo exists .hlp ] == 1 } { return }
    toplevel .hlp
    wm title .hlp $_helpText(wmTitle)
    frame .hlp.t
    frame .hlp.h -relief raised -bd 1
    frame .hlp.b 
    pack .hlp.t .hlp.h .hlp.b -fill x -side top  -expand 1
    
    button .hlp.t.i  -width 14 -text $_helpText(Contents) -relief raised -bd 1 -command {renderHelp $docPath/index.html} -font $fnt12
    button .hlp.t.e  -width 11 -text $_helpText(intro) -relief raised -bd 1 -command {renderHelp $docPath/index.html\#intro} -font $fnt12
    button .hlp.t.k  -width 11 -text $_helpText(cal) -relief raised -bd 1 -command {renderHelp $docPath/kal.html} -font $fnt12
    button .hlp.t.t  -width 16 -text $_helpText(proj) -relief raised -bd 1 -command {renderHelp $docPath/proj.html} -font $fnt12
    button .hlp.t.a  -width 11 -text $_helpText(addr) -relief raised -bd 1 -command {renderHelp $docPath/address.html} -font $fnt12
    button .hlp.t.z  -width 14 -text $_helpText(perm) -relief raised -bd 1 -command {renderHelp $docPath/rechte.html}
    button .hlp.t.f  -width 11 -text $_helpText(faq) -relief raised -bd 1 -command {renderHelp $docPath/FAQ.html} -font $fnt12
    button .hlp.t.g  -width 14 -text $_helpText(grp) -relief raised -bd 1 -font $fnt12 -command {
	set buglfile [format "/tmp/minko-%05d-bugl.html" [pid] ]
	exportUsersAndGroups $buglfile
#	puts $buglfile
	renderHelp $buglfile
    }
    pack  .hlp.t.i .hlp.t.e .hlp.t.k .hlp.t.t  .hlp.t.a .hlp.t.z .hlp.t.f  .hlp.t.g -side left -fill x

    label .hlp.b.msg -text "" -font $fnt12
    button .hlp.b.ok -text $_buttonText(Close) -command {
	if { $buglfile != "" } {
	    catch {file delete  $buglfile}
	}
	destroy .hlp
    }  -font $bfnt
    pack .hlp.b.msg -side left -padx 4
    pack .hlp.b.ok -side right
    
    htmlView .hlp.h.html  960 680
    pack .hlp.h.html -side left -fill x  -expand 1
    centerWin .hlp 962 740
    update
#    renderHelp $docPath/index.html
    if { $doGrab == 1} { grab .hlp }
#    puts [wm geometry .hlp]
}

proc disableBrowserButtons { fname } {
    .hlp.t.i  configure -state disable
    .hlp.t.e  configure -state disable
    .hlp.t.k  configure -state disable
    .hlp.t.t  configure -state disable 
    .hlp.t.a  configure -state disable
    .hlp.t.z  configure -state disable
    .hlp.t.f  configure -state disable 
    .hlp.t.g  configure -state disable
    .hlp.b.ok configure -state disable
    .hlp.b.msg configure -text "processing '$fname';     OK I know I'm slow ;-)"
}
proc enableBrowserButtons { } {
    .hlp.t.i  configure -state normal
    .hlp.t.e  configure -state normal
    .hlp.t.k  configure -state normal
    .hlp.t.t  configure -state normal 
    .hlp.t.a  configure -state normal
    .hlp.t.z  configure -state normal
    .hlp.t.f  configure -state normal 
    .hlp.t.g  configure -state normal
    .hlp.b.ok configure -state normal
    .hlp.b.msg configure -text ""
}
proc renderHelp { fname} {
#    .hlp.b.ok configure -state disable
    disableBrowserButtons $fname
    renderHTML $fname
#    puts "render done"
    enableBrowserButtons
#    .hlp.b.ok configure -state normal
}


proc createHelpPages { } {
    global docPath  buglfile helpNaviFile helpIndexFile _helpText
    
    set buglfile  [format "/tmp/minko-%05d-bugl.html" [pid] ]
    set helpIndexFile [format "/tmp/minko-%05d-index.html" [pid] ]
    set helpNaviFile [format "/tmp/minko-%05d-navi.html" [pid] ]
    exportUsersAndGroups $buglfile

    set fid [open $helpIndexFile "w" ]
    puts $fid "<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML//EN\">"
    puts $fid "<html>"
    puts $fid "  <head>"
    puts $fid "    <title>$_helpText(wmTitle)</title>"
    puts $fid "  </head>\n\n"
    puts $fid "    <frameset rows=\"64,*\">"
    puts $fid "      <frame src=\"$helpNaviFile\" name=\"navi\">"
    puts $fid "      <frame src=\"$docPath/index.html\" name=\"help\">"
    puts $fid "    </frameset>"
    puts $fid "  <body bgcolor=\"\#FFFCF8\" LINK=\"#B05800\" VLINK=\"#6030000\">"
    puts $fid "  </body>"
    puts $fid "</html>"
    close $fid
    
    set fid [open $helpNaviFile "w" ]
    puts $fid "<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML//EN\">"
    puts $fid "<html>"
    puts $fid "  <head>"
    puts $fid "    <title>$_helpText(wmTitle) </title>"
    puts $fid "  </head>\n\n"
    puts $fid "  <body bgcolor=\"\#FFFCF8\" LINK=\"#B05800\" VLINK=\"#6030000\">"
    puts $fid "    <table width]=\"100%\" border=\"2\">"
    puts $fid "      <tr>"
    puts $fid "        <td width =\"13%\"><A HREF=\"$docPath/index.html\" target=\"help\">$_helpText(Contents)</A></TD>"
    puts $fid "        <td width =\"12%\"><A HREF=\"$docPath/intro.html\" target=\"help\">$_helpText(intro)</A></TD>"
    puts $fid "        <td width =\"12%\"><A HREF=\"$docPath/kal.html\" target=\"help\">$_helpText(cal)</A></TD>"
    puts $fid "        <td width =\"13%\"><A HREF=\"$docPath/proj.html\" target=\"help\">$_helpText(proj)</A></TD>"
    puts $fid "        <td width =\"12%\"><A HREF=\"$docPath/address.html\" target=\"help\">$_helpText(addr)</A></TD>"
    puts $fid "        <td width =\"13%\"><A HREF=\"$docPath/rechte.html\" target=\"help\">$_helpText(perm)</A></TD>"
    puts $fid "        <td width =\"12%\"><A HREF=\"$docPath/FAQ.html\" target=\"help\">$_helpText(faq)</A></TD>"
    puts $fid "        <td width =\"13%\"><A HREF=\"$buglfile\" target=\"help\">$_helpText(grp)</A></TD>"
    puts $fid "      </tr>"
    puts $fid "    </table>"
    puts $fid "  </body>"
    puts $fid "</html>"
    close $fid


    
}
