#!/usr/bin/X11/tixwish
#  File: html.tcl
# 
#      This file is part of minkowsky
# 
#      Copyright (C) 2001-2002 by Rdiger Goetz
#      Author: Rdiger Goetz <minkowsky@r-goetz.de>
# 
#      Time-stamp: <19-Apr-2002 17:15:00 goetz>
# 
#      This program is free software; you can redistribute it and/or modify
#      it under the terms of the GNU General Public License as published by
#      the Free Software Foundation; either version 2 of the License, or
#      (at your option) any later version.
# 
#      This program is distributed in the hope that it will be useful,
#      but WITHOUT ANY WARRANTY; without even the implied warranty of
#      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#      GNU General Public License for more details.
# 
#      You should have received a copy of the GNU General Public License
#      along with this program; if not, write to the Free Software
#      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#  

proc htmlView { win  width height } {
    global __html__workLine __html__textwin __html__mainwin __html__plotEna __html__font __html__indent
    global __html__winWidth
    tixScrolledText $win -height $height -width $width -scrollbar auto
    set __html__winWidth $width
#    pack $win -side left -fill x
    set __html__mainwin $win
    set __html__textwin [$win subwidget text  ]
}

proc renderHTML { fname} {
    global __html__workLine __html__textwin __html__mainwin __html__plotEna __html__font __html__indent
    global __html__winWidth  __html__underline __html__justify __html__href
    global __html__parseDepth  __html__inTable __html__tnr __html__tableText __html__plotTable
    

    set __html__bottom 0

    $__html__textwin configure -state normal
    $__html__textwin delete 0.0 end
    update

    $__html__textwin configure -cursor spider
    initHTML
    set __html__parseDepth 0
    set __html__inTable 0
    set __html__plotTable 0
    set __html__tnr 0
    update
    after 10

    set __html__winWidth [winfo width $__html__textwin]
    set __html__workLine($__html__parseDepth) ""
    set jumpMark [openHTMLFile $fname]
    set __html__plotEna 0
    selectFont
    set __html_ident 0
    $__html__textwin configure -wrap word

    parseTagsAndText

    if { $jumpMark !="" } {
	jump2Mark $jumpMark
    }
    $__html__textwin configure -cursor left_ptr
    $__html__textwin configure -state disabled
    bind $__html__textwin <Configure> updateHTMLWindowParameters

}

proc parseTagsAndText { } {
    global __html__workLine __html__textwin __html__mainwin __html__plotEna __html__font __html__indent
    global __html__winWidth  __html__underline __html__justify __html__href
    global __html__parseDepth  __html__inTable __html__tableText  __html__tableCell __html__tnr
    global __html__plotTable

    while { [string length $__html__workLine($__html__parseDepth) ] >0 } {
	set txt ""
	set tag ""
	set p0 -1 
	set p1 -1

	#Suche den nchsten Tag-Block
	set p0 [getNextOpenTagChar ]
	if {$p0 >=0} {
	    set p1 [getNextCloseTagChar]
	    while { $p1 <0 } {	    
		if { [extend__Html__WorkLine ] <= 0} { break }
	    }
	}

	#wenn ein Tag gefunden wurde bertrage den Text vor dem Tag  nach txt
	if {$p0 >0} {
	    if { $p1> $p0} {
		set txt [ string range $__html__workLine($__html__parseDepth) 0 [expr $p0 -1] ]
	    } else {
		set txt $__html__workLine($__html__parseDepth)
	    }
	} else {
	    set txt ""
	}

	
	#wenn ein Tag gefunden wurde bertrage TagBlock nach tag
	if {$p0 >=0} {
	    if { $p1>$p0} {
		set tag [ string range $__html__workLine($__html__parseDepth) $p0 $p1]
		set __html__workLine($__html__parseDepth)  [ string range $__html__workLine($__html__parseDepth) [expr $p1+1] end] 
	    }
	} else { 
	    set txt $__html__workLine($__html__parseDepth)
	    set __html__workLine($__html__parseDepth) ""
	}

	#Wenn die Ausgabe aktiv ist gebe den Text (nach text-Parsen aug &..;-Strukturen) aus.
 	if { $__html__inTable > 0 } {
	    if {$__html__plotTable  == 0} {
		if { [string length $txt ] > 0 } {
		    set __html__tableText($__html__tableCell) "$__html__tableText($__html__tableCell) $txt"
		}
	    } else {
		set ttags "$__html__font($__html__inTable) $__html__indent($__html__inTable) $__html__underline($__html__inTable) $__html__justify($__html__inTable) $__html__href"
		$__html__textwin insert end [parseText $txt] $ttags
		global __html__fontWeight __html__fontType
		update
	    }
 	} else  {
	    if { $__html__plotEna == 1} {
		set ttags "$__html__font($__html__inTable) $__html__indent($__html__inTable) $__html__underline($__html__inTable) $__html__justify($__html__inTable) $__html__href"
		set txt [string trimright [parseText $txt]]
		set txt "$txt "
		$__html__textwin insert end $txt $ttags
		update
	    }
 	}

	#Parse das tag
	parseTag $tag

	#Erweitere ggfs den Workline
 	if { [string length $__html__workLine($__html__parseDepth) ] ==0 } {
 	    extend__Html__WorkLine
 	}

    }
}
proc updateHTMLWindowParameters { } { 
    global __html__winWidth __html__textwin __html__curFile

    update
    set __html__winWidth [winfo width $__html__textwin]
    set y [lindex [$__html__textwin yview] 0]
    renderHTML  $__html__curFile
    $__html__textwin yview moveto $y

}
proc addText {text } {
    global __html__xk
    global __html__yk
    global __html__width
    global __html__font
    global __html__textwin
    
    $__html__textwin create text $__html__xk $__html__yk
}

proc parseText {text } {
    global __html__workText
    set __html__workText $text
    _parseText 0
    return $__html__workText 
}
proc _parseText { start } {
    global __html__workText
    global __html__textTagList  __html__textSubList
    global __html__PRE

    if {$start>0} {
	set txt0 [string range $__html__workText 0 [expr $start -1]]
	set txt1 [string range $__html__workText $start end ]
    } else {
	set txt0 ""
	set txt1 $__html__workText
    }

    set p1 [ string first "&" $txt1 ]
    set p1a [ expr $p1 + $start ]
    if { $p1 >= 0} {
	set txt2  [ string range $txt1 [expr $p1 +1] end ]
	set txt1  [ string range $txt1 0 [expr $p1-1]]
	set p2   [ string first ";" $txt2 ]
	if { $p2 >0 } {
	    set tag  [string range $txt2 0 [expr $p2-1]]
	    set txt2 [string range $txt2 [expr $p2 +1] end ]
	    set idx [lsearch $__html__textTagList $tag]
	    if { $idx >=0} {
		set tag [lindex $__html__textSubList $idx ]
	    } else {
		set c "&"
		set tag "$c$tag;"
	    }
	} else {
	    set tag "&"
	}
	set __html__workText "$txt0$txt1$tag$txt2"
	incr p1a
	_parseText $p1a
    }
}


proc parseTag { tag } {
    global __html__textwin __html__plotEna __html__plotTable
    global __html__listType __html__font __html__indentLevel
    global __html__fontType 
    global __html__fontWeight 
    global __html__fontSlant 
    global __html__listLevel 
    global __html__hrImg __html__winWidth
    global __html__bulletImg
    global __html__underline
    global __html__justify
    global __html__href 
    global __html__inTable __html__tableText __html__tableCell __html__tnr
    global __html__tableRow __html__tableCol
    global __html__tableRowAnz __html__tableColAnz
    global __html__tableColWidth __html_table_RowHeight
    global __html__winWidth
    global __html__curTableWin
    global __html__bgcolor
    global __html__indent
    global __html__tableBorder
    global __html__tableSpacing
    global __html__PRE
    global __html__parseDepth

    set tag [string trim [ string trim $tag <>]]
    set  p [ string first " "  $tag]
    if { $p >0 } {
	set ctag [string range $tag  0 [expr $p -1] ]
	set opts [string range $tag  [expr $p +1]  end]
    } else {
	set ctag $tag
	set opts ""
    }
    set etag 0
    if { [ string range $ctag 0 0] == "/" } { 
	set etag 1
	set ctag [ string range $ctag 1 end]
    }
    set ctag [string toupper $ctag]
    set uopts [string toupper $opts]

    if { $__html__inTable > 0 && $__html__plotTable == 0} { 
	parseTable $tag $etag $ctag $opts 
	return
    }


    if { $etag == 0} {
	switch $ctag {
	    H1     { 
		addNL 
		addNL 
		selectHFont 1}
	    H2     { 
		addNL 
		addNL 
		selectHFont 2}
	    H3     { 
		addNL 
		addNL 
		selectHFont 3}
	    H4     { 
		addNL 
		addNL 
		selectHFont 4}
	    UL     {
		incr __html__listLevel($__html__inTable)
		set __html__listType($__html__inTable-$__html__listLevel($__html__inTable)) "U"
		increaseIndent
		addNL
	    }
	    OL     {
		incr __html__listLevel($__html__inTable)
		set __html__listType($__html__inTable-$__html__listLevel($__html__inTable)) "0"
		increaseIndent
		addNL
	    }
	    DIR    {
		increaseIndent
	    }
	    LI     {
		set ttags "$__html__font($__html__inTable) indent-$__html__indentLevel($__html__inTable)"
		if { $__html__listType($__html__inTable-$__html__listLevel($__html__inTable)) == "U" } {
		    set l [expr $__html__listLevel($__html__inTable) %3]
		    $__html__textwin insert end " " $ttags
		    $__html__textwin image create end -image $__html__bulletImg($l)
		} else {
		    incr __html__listType($__html__inTable-$__html__listLevel($__html__inTable))
		    $__html__textwin insert end \
			"$__html__listType($__html__inTable-$__html__listLevel($__html__inTable)))"  $ttags
		}
	    }
	    IMG   {insertImage $opts}
	    CENTER   { set __html__justify($__html__inTable) "center" }
	    STRONG   { 
		set __html__fontWeight($__html__inTable) "strong"
		selectFont
	    }
	    B   { 
		set __html__fontWeight($__html__inTable) "strong"
		selectFont
	    }
	    EM  { 
		set __html__fontSlant($__html__inTable) "em"
		selectFont
	    }
	    TT  {
		set __html__fontType($__html__inTable) "fixed"
		selectFont
	    }
	    CODE  {
		set __html__fontType($__html__inTable) "fixed"
		selectFont
	    }
	    PRE {
		addNL
		set __html__PRE($__html__parseDepth) 1
		set __html__fontType($__html__inTable) "fixed"
		selectFont
	    }
	    HR { parseHR $opts
# 		addNL
# 		for { set x 0} { [expr $x +24] < $__html__winWidth} {incr x 24} {
# 		    $__html__textwin image create end -image $__html__hrImg 
# 		}
# 		addNL
	    }
	    TABLE {
		
		set idx [lsearch -glob $uopts BORDER=*]
		if { $idx >=0 } {
		    set __html__tableBorder [lindex [ split [lindex $opts $idx] = ] 1]
		} else {
		    set __html__tableBorder 0
		}
		set idx [lsearch -glob $uopts CELLSPACING=*]
		if { $idx >=0 } {
		    # 1 abziehen, da beim einbetten eine Windows mit -padx 0 bereits eine Lcke vvon 1 
		    # entsteht
		    set __html__tableSpacing [expr [lindex [ split [lindex $opts $idx] = ] 1] -1]
		} else {
		    set __html__tableSpacing -1
		}
		incr __html__inTable 
		incr __html__tnr
		set __html__tableRow($__html__tnr) -1
		set __html__tableCol($__html__tnr) -1
		set __html__tableRowAnz($__html__tnr) 0
		set __html__tableColAnz($__html__tnr) 0
		set __html__tableColWidth($__html__tnr-0) 0
		set __html__tableCell [ format "%03d-%03d-%03d" $__html__tnr -1 -1 ]
		set __html__tableText($__html__tableCell) ""
		set __html__tableCell [ format "%03d-%03d-%03d" $__html__tnr 0 -1 ]
		set __html__tableText($__html__tableCell) ""
		$__html__textwin insert end "\n"
	    }
	    A { parseAnchor $opts   }
	    U { set __html__underline($__html__inTable) "underlined"}
	    ADDRESS {}
	    !-- {skip2CommEnd}
	    FONT   { setFontOpts $opts}
	    BR     { addNL }
	    P      { addNL }
	    BODY   { 
		parseBodyOpts $opts
		set __html__plotEna 1 
	    }
	    default {
		if {[string length [ string trim $ctag]] >0} {
		    if { $__html__plotEna == 1} {
			$__html__textwin insert end "<$ctag $opts>"}
		}
	    }
	}
    } else {
	switch $ctag {
	    H1     { 
		selectFont 
		addNL 
		addNL 
	    }
	    H2     { 
		selectFont 
		addNL 
		addNL 
	    }
	    H3    { 
		selectFont 
		addNL 
	    }
	    H4    { 
		selectFont 
		addNL 
	    }
	    UL     {
		decreaseIndent
		incr __html__listLevel($__html__inTable) -1
	    }
	    OL     {
		decreaseIndent
		incr __html__listLevel($__html__inTable) -1
	    }
	    DIR     {
		decreaseIndent
	    }
	    LI     {addNL}
	    CENTER   { set __html__justify($__html__inTable) "left" }
	    STRONG   { 
		set __html__fontWeight($__html__inTable) "normal"
		selectFont
	    }
	    B   { 
		set __html__fontWeight($__html__inTable) "normal"
		selectFont
	    }
	    EM  { 
		set __html__fontSlant($__html__inTable) "normal"
		selectFont
	    }
	    TT  {
		set __html__fontType($__html__inTable) "prop"
		selectFont
	    }
	    CODE  {
		set __html__fontType($__html__inTable) "prop"
		selectFont
	    }
	    PRE {
		addNL
		set __html__PRE($__html__parseDepth) 0
		set __html__fontType($__html__inTable) "prop"
		selectFont
	    }
	    TABLE {
	    }
	    P    {addNL}
	    A    {parseEndAnchor   }
	    U { set __html__underline($__html__inTable) "notUnderlined"}
	    ADDRESS {addNL}
	    FONT {closeLastFontOpts}
	    BODY { set __html__plotEna 0 }
	    default {
		if {[string length [ string trim $ctag]] >0} {
		    if { $__html__plotEna == 1} {
			$__html__textwin insert end "</$ctag $opts>"}
		}
	    }
	}
    }

}
proc parseTable { tag etag ctag opts } { 
    global __html__textwin __html__plotEna __html__workLine __html__parseDepth
    global __html__listType __html__font __html__indentLevel
    global __html__fontType 
    global __html__fontWeight 
    global __html__fontSlant 
    global __html__listLevel 
    global __html__hrImg __html__winWidth
    global __html__bulletImg
    global __html__underline
    global __html__justify
    global __html__href 
    global __html__inTable __html__tableText __html__tableCell __html__tnr
    global __html__tableRow __html__tableCol
    global __html__tableRowAnz __html__tableColAnz
    global __html__tableColWidth __html_table_RowHeight
    global __html__winWidth
    global __html__curTableWin
    global __html__bgcolor
    global __html__indent
    global __html__plotTable
    global __html__tableBorder
    global __html__tableSpacing

    if { $etag ==0}  {
	
	#Verteile Text in die Variablen
	switch $ctag {
	    TR {
		incr __html__tableRow($__html__tnr)
		incr __html__tableRowAnz($__html__tnr)
	    }
	    TH -
	    TD {
		incr __html__tableCol($__html__tnr)
		if { $__html__tableCol($__html__tnr) >= $__html__tableColAnz($__html__tnr)} {
		    for { set i $__html__tableColAnz($__html__tnr) } { $i <= $__html__tableCol($__html__tnr) } { incr i } {
			set __html__tableCell [ format "%03d-%03d-%03d" $__html__tnr \
						    $__html__tableRow($__html__tnr) $i ]
			set __html__tableText($__html__tableCell) ""
			set __html__tableColWidth($__html__tnr-$i) 0
		    }
		    set  __html__tableColAnz($__html__tnr)  $__html__tableCol($__html__tnr)
		    incr __html__tableColAnz($__html__tnr)
		}
		set __html__tableCell [ format "%03d-%03d-%03d" $__html__tnr \
					    $__html__tableRow($__html__tnr) \
					    $__html__tableCol($__html__tnr) ]
		set __html__tableText($__html__tableCell) ""
		foreach opt $opts {
		    set list [split $opt =]
		    set para [string toupper [lindex $list 0]]
		    set val  [string trim [lindex $list 1] \" ]
		    if { $para == "WIDTH" } {
			if { [string first % $val ] > 0 } {
			    set w [expr __html_winWidth * $val /100]
			} else {
			    set w $val
			}
			if { $w > $__html__tableColWidth($__html__tnr-$__html__tableCol($__html__tnr))} {
			    set __html__tableColWidth($__html__tnr-$__html__tableCol($__html__tnr)) $w 
			}
		    }
		}
	    }
	    default { 
		if { $ctag != "" } {
		    set __html__tableText($__html__tableCell) "$__html__tableText($__html__tableCell) <$tag>"
		}
	    }
	}
	return
    } else { 
	switch $ctag {
	    TR {
		set __html__tableCol($__html__tnr) -1
		set __html__tableCell [ format "%03d-%03d-%03d" $__html__tnr \
					    $__html__tableRow($__html__tnr) \
					    $__html__tableCol($__html__tnr) ]
	    }
	    TH -
	    TD { }
	    TABLE {
		#Stelle fest wieviel Spalten keine Breitenangabe haben  und wie breit die definierten
		# Breiten zusammen sind
		set c 0
		set sw 0
		#ul ist der tableDepthIndex der TAbellenumgebung
		set ul [expr $__html__inTable -1]
		#xi ist die ussere Einrckung
		set xi [expr $__html__indentLevel($ul) * 40 +16]
		# bw ist die Restbreite der Tabelle
		set bw [ expr $__html__winWidth -  $xi -$__html__tableColAnz($__html__tnr)]
		for { set i 0 } { $i < $__html__tableColAnz($__html__tnr) } { incr i } {
		    if { $__html__tableColWidth($__html__tnr-$i) == 0 } {
			incr c
		    } else {
			incr sw $__html__tableColWidth($__html__tnr-$i)
		    }
		}


		#Bestimme nun die Breite der Spalten, so dass 
		# 1. Jede Splate min 20 Pixel breit ist
		# 2. Jede Splate mit Angabe die eingeforderte Breite auch bekommt, sofern genung Platz da ist
		# 3. Jede Spalte ohe Angabe gleichberit ist.
		if {$c > 0 } {
		    if { [expr 20*$c + $sw] < $bw } {
			set tw [ expr int(floor(($bw - $sw) / $c)) ]
			set f 1
		    } else { 
			set tw 20
			set f [ expr double($bw - 20*$c)/$sw]

		    }
		    for { set i 0 } { $i < $__html__tableColAnz($__html__tnr) } { incr i } {
			if { $__html__tableColWidth($__html__tnr-$i) == 0 } {
			    set __html__tableColWidth($__html__tnr-$i) $tw
			} else {
			    set __html__tableColWidth($__html__tnr-$i) \
				[expr int(floor($f * $__html__tableColWidth($__html__tnr-$i)))]
			}
		    }
		} else {
		    if { $sw > $bw } {
			set f [ expr double($bw)/$sw]
			for { set i 0 } { $i < $__html__tableColAnz($__html__tnr) } { incr i } {
			    set __html__tableColWidth($__html__tnr-$i) \
				[expr int(floor($f * $__html__tableColWidth($__html__tnr-$i)))]
			}
		    }
		}



		# Baue nun fr jede Spalte ein embeddeb window mit der entsprechenden Breite
		# Hhe ist vorlufig eine Zeile

		set __html__plotTable 1
		for { set i 0 } { $i < $__html__tableRowAnz($__html__tnr) } { incr i } {
		    set x0 $xi
		    set ttags "nowrap $__html__indent($ul)"
		    $__html__textwin insert end "\n "  $ttags
		    
		    for { set j 0 } { $j < $__html__tableColAnz($__html__tnr) } { incr j } {


			set cell [ format "%03d-%03d-%03d" $__html__tnr $i $j]

			set tableTag "table-$__html__tnr-$j"
			set x1 [ expr $__html__tableColWidth($__html__tnr-$j) + $x0 ]
			set xr [expr $__html__winWidth -$x1]
			set w  [format "%d" [expr $x1 -$x0 ]]

			set twin "$__html__textwin.tw-$__html__tnr-$i-$j"
			set ttag "text"
			tixScrolledText $twin -scrollbar none  -width $w -background $__html__bgcolor -bd 0 
			$__html__textwin window create "end  -1 chars " -window $twin -stretch 1 \
			    -padx $__html__tableSpacing -pady $__html__tableSpacing
			

			$twin subwidget text configure -wrap word 
			$twin subwidget text configure -background $__html__bgcolor
			$twin subwidget text configure -height 1
			$twin subwidget text configure -bd $__html__tableBorder
			$twin subwidget text configure -relief solid
			
			$twin subwidget text configure -highlightbackground $__html__bgcolor
			$twin subwidget hsb configure -width 0
			$twin subwidget vsb configure -width 0

			$twin subwidget text tag configure $ttag -lmargin1 1
			$twin subwidget text tag configure $ttag -lmargin2 1
			$twin subwidget text tag configure $ttag -rmargin 1
			
			set textWinBack $__html__textwin
			set __html__textwin [$twin subwidget text]
			incr __html__parseDepth
			set __html__workLine($__html__parseDepth) $__html__tableText($cell)

			initTableHTML $__html__textwin
			selectFont

			parseTagsAndText
			incr __html__parseDepth -1
			set __html__textwin $textWinBack

#			$twin subwidget text insert end [parseText $__html__tableText($cell)] $ttag
			set x0 $x1
			incr x0
		    }
		}
		set __html__plotTable 0
		#Erweitere nun die Zellen soweit das jede Zelle allen Inhalt anzeigt.
		update
		$__html__textwin see end
		for { set i 0 } { $i < $__html__tableRowAnz($__html__tnr) } { incr i } {
		    set hmax 1
		    for { set j 0 } { $j < $__html__tableColAnz($__html__tnr) } { incr j } {
			set twin "$__html__textwin.tw-$__html__tnr-$i-$j"
			set yv [ lindex [$twin subwidget text yview] 1 ]
			set h 1
			while { $yv <1 } {
			    incr h
			    $twin subwidget text configure -height $h
			    update
			    set yv [ lindex [$twin subwidget text yview] 1 ]
			}
		    }

		}
		update
		$__html__textwin see 1.0
		set __html__tableText($__html__tableCell) ""
		incr __html__inTable -1
	    }
	    default { 
		if { $ctag != "" } {
		    set __html__tableText($__html__tableCell) "$__html__tableText($__html__tableCell) <$tag>"}
	    }
	}
	return
    }
}

proc increaseIndent {} {
    global __html__indent __html__indentLevel __html__inTable
    incr __html__indentLevel($__html__inTable)
    set __html__indent($__html__inTable) "indent$__html__indentLevel($__html__inTable)"
}
proc decreaseIndent {} {
    global __html__indent __html__indentLevel __html__inTable
    incr __html__indentLevel($__html__inTable) -1
    set __html__indent($__html__inTable) "indent$__html__indentLevel($__html__inTable)"
}
proc addNL { } {
    global __html__plotEna __html__textwin	
    if { $__html__plotEna == 1} {
	$__html__textwin insert end "\n"
    }
}
proc addSpace { } {
    global __html__plotEna __html__textwin	
    if { $__html__plotEna == 1} {
	$__html__textwin insert end " "
    }
}
proc setFontOpts { opts } {
    global __html__fontTagOptList
    lappend __html__fontTagOptList $opts
    parsefontTagOptList
}
proc closeLastFontOpts { } {
    global __html__fontTagOptList
    set __html__fontTagOptList [lreplace $__html__fontTagOptList end end ]
    parsefontTagOptList
}
proc parsefontTagOptList { } {
    global __html__fontTagOptList
    global __html__fontLevel
    global __html__fontColor
    global __html__fontLevelDef
    global __html__fontColorDef
    global __html__inTable

    set __html__fontColor($__html__inTable) $__html__fontColorDef
    set __html__fontLevel($__html__inTable) $__html__fontLevelDef

    
    set list [join $__html__fontTagOptList]
    foreach ent $list { 
	set ol [split $ent =]
	set opt [ string toupper [lindex $ol 0]]
	set para [string trim [lindex $ol 1] \"]
	if { $opt == "COLOR" } {
	    set __html__fontColor($__html__inTable) $para
	}
	if { $opt == "SIZE" } {
	    set __html__fontLevel($__html__inTable) $para
	}
    }
    makeFontTypeTtags $__html__fontColor($__html__inTable)
    selectFont
}
proc selectFont {} {
    global __html__fontSizeList __html__fontOffset __html__textwin
    global __html__fontLevel
    global __html__fontType
    global __html__fontWeight
    global __html__fontSlant
    global __html__textwin
    global __html__font
    global __html__fontColor
    global __html__inTable

    set fam "helvetica"
    set weight "medium"
    set slant "r"
    if { $__html__fontType($__html__inTable)   == "fixed" } { set fam "lucidatypewriter"}
    if { $__html__fontWeight($__html__inTable) == "strong" } { set weight "bold"}
    if { $__html__fontSlant($__html__inTable)  == "em" } { set slant "o"}
    set size [lindex $__html__fontSizeList [expr $__html__fontOffset + $__html__fontLevel($__html__inTable)] ]

    set font [format "-*-%s-%s-%s-*-*-%s-*-*-*-*-*-*-*-%s" $fam $weight $slant $size $__html__fontColor($__html__inTable)]


    set __html__font($__html__inTable) $font
}
proc selectHFont {level} {
    global __html__fontSizeList __html__fontOffset __html__textwin
    global __html__fontLevel
    global __html__fontType
    global __html__fontWeight
    global __html__fontSlant
    global __html__textwin
    global __html__font
    global __html__fontColor
    global __html__inTable

    set fam "helvetica"
    set weight "bold"
    set slant "r"
    if { $__html__fontType($__html__inTable)   == "fixed" } { set fam "lucidatypewriter"}
    if { $__html__fontSlant($__html__inTable)  == "em" } { set slant "o"}
    set size [lindex $__html__fontSizeList [expr $__html__fontOffset + $__html__fontLevel($__html__inTable) + (5-$level)] ]

    set font [format "-*-%s-%s-%s-*-*-%s-*-*-*-*-*-*-*-%s" $fam $weight $slant $size $__html__fontColor($__html__inTable)]

    set __html__font($__html__inTable) $font
}
    

proc parseHR { opts} {
    global __html__winWidth __html__textwin __html__hrImg 
    
    set width $__html__winWidth
    if { [llength $opts] >0} {
	foreach ent $opts { 
	    set ol [split $ent =]
	    set opt [ string toupper [lindex $ol 0]]
	    set para [string trim [lindex $ol 1] \"]
	    if { $opt == "WIDTH" } {
		set width $para
	    }
	}
    }
    
    addNL
    for { set x 0} { [expr $x +24] < $width} {incr x 24} {
	$__html__textwin image create end -image $__html__hrImg 
    }
    addNL
}
proc parseAnchor {opts } {
    global __html__fontColor __html__href __html__textwin __html__underline
    global __html__anchorNames __html__anchorPostion
    global __html__AnchorType __html__inTable

    foreach ent $opts { 
	set ol [split $ent =]
	set opt [ string toupper [lindex $ol 0]]
	set para [string trim [lindex $ol 1] \"]
	if { $opt == "HREF" } {
	    set __html__fontColor($__html__inTable) DarkOrange2
	    selectFont
	    set __html__href "HREF=$para"
	    $__html__textwin tag bind $__html__href <ButtonPress> {jump2ref %x %y}
	    $__html__textwin tag bind $__html__href <Enter> {enterLink}
	    $__html__textwin tag bind $__html__href <Leave> {leaveLink}
	    set __html__underline($__html__inTable) "underlined"
	    set __html__AnchorType "HREF"
	    addSpace
	    
	}
 	if { $opt == "NAME" } {
	    set pos  [$__html__textwin index "end linestart -1 chars "]
	    lappend __html__anchorNames $para
	    lappend __html__anchorPostion $pos
	    set __html__AnchorType "NAME"
	}
   }
}
proc parseEndAnchor { } {
    global __html__AnchorType __html__underline __html__href __html__inTable
    if { $__html__AnchorType=="HREF" } {
	set __html__underline($__html__inTable) "notUnderlined"
	set __html__href ""
	parsefontTagOptList
	addSpace
    }
}
proc enterLink { } {
    global __html__textwin
    $__html__textwin configure -cursor hand2
}
  
proc leaveLink { } {
    global __html__textwin
    $__html__textwin configure -cursor left_ptr
}

proc jump2ref { x y} {
    global __html__textwin  __html__curFile
    global __html__anchorNames __html__anchorPostion
    set list [$__html__textwin tag names current]
    foreach ent $list {
	set ol [split $ent =]
	if { [lindex $ol 0 ] == "HREF"} {
	    set url [lindex $ol 1]
	    if { [string range $url 0 3] == "http" } {
		puts "sorry  http kann ich noch nich"
		return
	    } elseif  { [string range $url 0 3] == "file" } {
		set fname [string range $url 7 end]
	    } elseif  { [string range $url 0 0] == "/" } {
		set fname $url
	    } elseif  { [string range $url 0 0] == "#" } {
		set dest [string range $url 1 end]
		jump2Mark $dest		
		return
	    } else {
		set path [file dirname $__html__curFile]
		set fname "$path/$url"
	    }

	    renderHTML $fname
	} 
    }
}
proc jump2Mark { dest } {
    global __html__anchorNames __html__anchorPostion
    global __html__textwin
    set idx [lsearch $__html__anchorNames $dest]
    set pos [lindex $__html__anchorPostion $idx]
#    $__html__textwin see $pos
    $__html__textwin yview $pos
}
proc insertImage {opts} {
    global __html__textwin 
    global __html__curFile
    global __html__imgCount

    foreach ent $opts { 
	set ol [split $ent =]
	set opt [ string toupper [lindex $ol 0]]
	set para [string trim [lindex $ol 1] \"]
	if {$opt=="SRC"} {
	    if { [string range $para 0 3] == "http" } {
		puts "sorry  http kann ich noch nich"
		return
	    } elseif  { [string range $para 0 3] == "file" } {
		set fname [string range $para 7 end]
	    } elseif  { [string range $para 0 0] == "/" } {
		set fname $para
	    } else {
		set path [file dirname $__html__curFile]
		set fname "$path/$para"
	    }

#	    addNL
	    set img [image create photo -format GIF -file $fname]
	    set tag "image$__html__imgCount"
	    $__html__textwin image create "end  -1 chars " -image $img -align top
	    addNL
	}
    }
}
proc insertImageOLD {opts} {
    global __html__textwin 
    global __html__curFile
    global __html__imgCount

    foreach ent $opts { 
	set ol [split $ent =]
	set opt [ string toupper [lindex $ol 0]]
	set para [string trim [lindex $ol 1] \"]
	if {$opt=="SRC"} {
	    if { [string range $para 0 3] == "http" } {
		puts "sorry  http kann ich noch nich"
		return
	    } elseif  { [string range $para 0 3] == "file" } {
		set fname [string range $para 7 end]
	    } elseif  { [string range $para 0 0] == "/" } {
		set fname $para
	    } else {
		set path [file dirname $__html__curFile]
		set fname "$path/$para"
	    }

	    addNL
	    set iname "image$__html__imgCount"
	    set img [image create photo $iname -format GIF -file $fname]
	    set tag "image$__html__imgCount"
# 	    set iwin "$__html__textwin.image$__html__imgCount"
# 	    set w  [image width $iname]
# 	    set h  [image height $iname]
# 	    canvas $iwin -width $w  -heigth $h
# 	    $iwin create image 0 0 -anchor nw -image $iname
# 	    $__html__textwin window create end -window $iwin -stretch 1
	    $__html__textwin image create end -image $img -align top
	    addNL
	}
    }
}

proc parseBodyOpts { opts} {
    global __html__textwin  __html__bgcolor

    foreach ent $opts { 
	set ol [split $ent =]
	set opt [ string toupper [lindex $ol 0]]
	set para [string trim [lindex $ol 1] \"]
	if { $opt == "BGCOLOR" } {
	    $__html__textwin configure -background $para
	    set __html__bgcolor $para
	}
    }
}
proc skip2CommEnd { } {
    global __html__workLine
    global __html__parseDepth

#    puts $__html__workLine
    set p [string first "-->" $__html__workLine($__html__parseDepth)]
    while {$p< 0} {
	if { [extend__Html__WorkLine ] <= 0} { break }
	set p [string first "-->" $__html__workLine($__html__parseDepth)]
    }
    if {$p >=0} {
	set __html__workLine($__html__parseDepth) [string range $__html__workLine($__html__parseDepth) [expr $p +3] end]
    }
    if { [string length $__html__workLine($__html__parseDepth)] ==0 } {
	extend__Html__WorkLine
    }
}
    

proc getNextOpenTagChar { } {
    return [getNextChar "\<"]
}
proc getNextCloseTagChar { } {
    return [getNextChar "\>"]
}


# Liefert den Index des nchsten Vorkommens des Zeichens 'c'
# Zeichen innerhalb von "..." werden dabei ignoriert
proc getNextChar { c} {
    global __html__workLine
    global __html__parseDepth

    #Finde das nchste 'c' und das nchste '"'
    set p  [string first $c $__html__workLine($__html__parseDepth) ]
    set q0 [string first \" $__html__workLine($__html__parseDepth) ]
    
    #Wenn es kein '"' gibt ist 'p' der Index auf das nchste c (ggfs. ist dieser -1)
    if { $q0<0} {
	return $p
    } else {
	# Wenn es ein '"' gibt , sollte das nchste 'c' davor oder nach dem 2. '"' liegen
	# Ergo wenn p < q0 ist p der gesuchte Index
	if { $p < $q0 } {
	    return $p
	} else {
	    # Wenn p> q0 suche nach dem nchsten '"'. Erweitere dazu ggfs die Workline
	    set line2 [ string range $__html__workLine($__html__parseDepth) [expr $q0 +1] end ]
	    set q [string first \"  $line2 ]
	    while { $q<0 } {
		if { [extend__Html__WorkLine ] <= 0} { break }
	    }
	    # Wenn die workline nicht mehr erweitert werden kann, breche ab.
	    # Wen dann kein 2. '"' gefunden wurde, ist der Text defekt, liefere -1 zurck
	    if {$q <0} {
		return -1
	    }
	    #Bilde in q1 den Index des 2. '"' bzgl. des Gesammt Textes
	    set q1 [expr $q0 + 1 +$q]
	    if { $p > $q1 } {
		#FIXME zwei Strings vor p ?
		return $p
	    } else {
		#Wenn p kleiner als q1 dann schneide den ersten String heraus und gebe ihn als
		# String aus und rufe getNextChar rekursiv auf.
		set line2 [ string range $__html__workLine($__html__parseDepth) [expr $q1 +1] end ]
		set p0 [ getNextOpenTag $line2]
		if { $p0 >=0 } {
		    set p [expr $q1+1 +$p0]
		    return $p
		} else {
		    return  -1
		}
	    }
	}
    }
}

proc openHTMLFile { fname } {
    global __html__workFileID __html__workLine
    global __html__curFile
    global __html__parseDepth


    set p [string first "#" $fname]
#    puts "$fname -> $p"
    if {$p >0} {
	incr p -1
	set file [string range $fname 0 $p]
	incr p 2
	set jumpMark [string range $fname  $p end ]
    } else {
	set file $fname
	set jumpMark ""
    }
#    puts "\t\t-> $file // $jumpMark"

    set __html__workFileID [open $file ]
    set __html__curFile $file
    extend__Html__WorkLine
    return $jumpMark
}
proc extend__Html__WorkLine { } {
    global __html__workFileID  __html__workLine
    global __html__parseDepth
    global __html__PRE

    if { $__html__parseDepth == 0} {
	set count [gets $__html__workFileID line]
	if { $__html__PRE($__html__parseDepth) == 1 } { set line "$line\n" }

	
	if { $__html__PRE($__html__parseDepth) == 0 } {
	    if { $count >0 } {
		set line [string trim $line]
		while { [string first "  " $line] >0 } {
		    regsub -all " +" $line " " line
		}
	    } 
	} else {
	    set lin $line
	    regsub -all \t $lin "        " line
	}
	set __html__workLine($__html__parseDepth) "$__html__workLine($__html__parseDepth) $line"

	if { $__html__PRE($__html__parseDepth) == 0 } {
	    set __html__workLine($__html__parseDepth) [string trim $__html__workLine($__html__parseDepth)]
	}

	while { [ string length $__html__workLine($__html__parseDepth)] == 0 } {
	    set count [gets $__html__workFileID line]
	    if { $__html__PRE($__html__parseDepth) == 1 } { set line "$line\n" }
	    if { $__html__PRE($__html__parseDepth) == 0 } {
		if { $count >0 } {
		    set line [string trim $line]
		    while { [string first "  " $line] >0 } {
			regsub -all " +" $line " " line
		    }
		}
	    } else {
		set lin $line
		regsub -all \t $lin "        " line
	    }
	    set __html__workLine($__html__parseDepth) "$__html__workLine($__html__parseDepth) $line"
	    if { $__html__PRE($__html__parseDepth) == 0 } {
		set __html__workLine($__html__parseDepth) [string trim $__html__workLine($__html__parseDepth)]
	    }
	    if { [eof $__html__workFileID] } { break}
	}
    } else {
	set count 0
    }

    return $count
}
proc initHTML { } {
    global __html__fontLevel 
    global __html__fontType  
    global __html__fontWeight 
    global __html__fontSlant 
    global __html__fontColor     
    global __html__indentLevel 
    global __html__indent 
    global __html__underline 
    global __html__justify 
    global __html__listLevel 
    global __html__textwin
    global __html__anchorNames __html__anchorPostion
    global __html__PRE


    set __html__fontLevel(0) 3
    set __html__fontType(0)  "prop"
    set __html__fontWeight(0) "normal"
    set __html__fontSlant(0) "normal"
    set __html__fontColor(0) "black"
    set __html__anchorNames ""
    set __html__anchorPostion ""
    set __html__PRE(0) 0

    initHTMLwindow $__html__textwin

    set __html__indentLevel(0) 0
    set __html__indent(0) "indent0"

    set __html__underline(0) "notUnderlined"
    set __html__justify(0) "left"
    set __html__listLevel(0) 0
}
proc initTableHTML { win} {
    global __html__fontLevel 
    global __html__fontType  
    global __html__fontWeight 
    global __html__fontSlant 
    global __html__fontColor     
    global __html__indentLevel 
    global __html__indent 
    global __html__underline 
    global __html__justify 
    global __html__listLevel 
    global __html__inTable

    set __html__fontLevel($__html__inTable) 3
    set __html__fontType($__html__inTable)  "prop"
    set __html__fontWeight($__html__inTable) "normal"
    set __html__fontSlant($__html__inTable) "normal"
    set __html__fontColor($__html__inTable) "black"

    initHTMLwindow $win

    set __html__indentLevel($__html__inTable) 0
    set __html__indent($__html__inTable) "indent0"

    set __html__underline($__html__inTable) "notUnderlined"
    set __html__justify($__html__inTable) "left"
    set __html__listLevel($__html__inTable) 0

}
proc initHTMLwindow { win } {
    global __html__textTagList  __html__textSubList
    global __html__fontSizeList __html__fontOffset
    global __html__fontLevel
    global __html__fontLevelDef
    global __html__fontType
    global __html__fontWeight
    global __html__fontSlant
    global __html__textwin
    global __html__indentLevel
    global __html__indent
    global __html__listType
    global __html__fontTagOptList
    global __html__textColors
    global __html__fontColor
    global __html__fontColorDef
    global __html__underline 
    global __html__justify
    global __html__listLevel 
    global __html__href
    global __html__hrImg
    global __html__bulletImg
    global __html__imgCount
    
    set __html__imgCount 0

    set __html__href ""
    set __html__fontOffset 7
    set __html__fontLevelDef 3
    set __html__textColors ""
    set __html__fontColorDef "black"

    set __html__fontTagOptList ""

    set __html__textTagList "auml ouml uuml Auml Ouml Uuml szlig gt lt nbsp"
    set __html__textSubList "       < > { }"
    set __html__fontSizeList "6 6 6 6 6 6 8 10 11 12 14 16 18 20 24 30 40 40 40"

    makeFontTypeTtags black
    makeFontTypeTtags DarkOrange2

    for {set i 0} {$i<64} {incr i} {
	set tag "indent$i"
	$win tag configure $tag -lmargin1 [expr 40*$i+8]
	$win tag configure $tag -lmargin2 [expr 40*$i+8]
    }
    for {set i 0} {$i<64} {incr i} {
	set tag "indent-$i"
	$win tag configure $tag -lmargin1 [expr 40*$i-20+8]
    }
    
    set tag "underlined"
    $win tag configure $tag -underline 1
    set tag "notUnderlined"
    $win tag configure $tag -underline 0
    set tag "center"
    $win tag configure $tag -justify center
    set tag "left"
    $win tag configure $tag -justify left
    set tag "right"
    $win tag configure $tag -justify right
    set tag "nowrap"
    $win tag configure $tag -wrap none

    set hrXPM {
/* XPM */
static char * pull_xpm[] = {
"24 3  2 1",
" 	c none",
"-	c #000000",
"                        ",
"------------------------",
"                        "};
}
set __html__hrImg [image create pixmap -data $hrXPM]
    set bulletXPM {
/* XPM */
static char * pull_xpm[] = {
"14 14 2 1",
" 	c none",
"*	c #000000",
"              ",
"              ",
"              ",
"      **      ",
"     ****     ",
"    ******    ",
"   ********   ",
"   ********   ",
"    ******    ",
"     ****     ",
"      **      ",
"              ",
"              ",
"              "};
}
set __html__bulletImg(0) [image create pixmap -data $bulletXPM]
    set bulletXPM {
/* XPM */
static char * pull_xpm[] = {
"14 14 2 1",
" 	c none",
"*	c #000000",
"              ",
"              ",
"              ",
"     ****     ",
"    ******    ",
"   ********   ",
"   ********   ",
"   ********   ",
"   ********   ",
"    ******    ",
"     ****     ",
"              ",
"              ",
"              "};
}
set __html__bulletImg(1) [image create pixmap -data $bulletXPM]
    set bulletXPM {
/* XPM */
static char * pull_xpm[] = {
"14 14 2 1",
" 	c none",
"*	c #000000",
"              ",
"              ",
"              ",
"    ******    ",
"   ********   ",
"   ***  ***   ",
"   **    **   ",
"   **    **   ",
"   ***  ***   ",
"   ********   ",
"    ******    ",
"              ",
"              ",
"              "};
}
set __html__bulletImg(2) [image create pixmap -data $bulletXPM]
}

proc makeFontTypeTtags { color } {
    global  __html__textwin 
    _makeFontTypeTtags $__html__textwin $color
}
proc _makeFontTypeTtags { win  color } {
    global __html__fontSizeList  __html__textColors

    if { [lsearch $__html__textColors $color] <0 } {
	foreach size $__html__fontSizeList {
	    set fnt [format "-*-%s-%s-%s-*-*-%s-*-*-*-*-*-*-*" "helvetica" "bold" "r" $size]
	    $win tag configure $fnt-$color  -font $fnt
	    $win tag configure $fnt-$color  -foreground $color
	    set fnt [format "-*-%s-%s-%s-*-*-%s-*-*-*-*-*-*-*" "helvetica" "medium" "r" $size]
	    $win tag configure $fnt-$color  -font $fnt
	    $win tag configure $fnt-$color  -foreground $color
	    set fnt [format "-*-%s-%s-%s-*-*-%s-*-*-*-*-*-*-*" "helvetica" "bold" "o" $size]
	    $win tag configure $fnt-$color  -font $fnt
	    $win tag configure $fnt-$color  -foreground $color
	    set fnt [format "-*-%s-%s-%s-*-*-%s-*-*-*-*-*-*-*" "helvetica" "medium" "o" $size]
	    $win tag configure $fnt-$color  -font $fnt
	    $win tag configure $fnt-$color  -foreground $color
	    set fnt [format "-*-%s-%s-%s-*-*-%s-*-*-*-*-*-*-*" "lucidatypewriter" "bold" "r" $size]
	    $win tag configure $fnt-$color  -font $fnt
	    $win tag configure $fnt-$color  -foreground $color
	    set fnt [format "-*-%s-%s-%s-*-*-%s-*-*-*-*-*-*-*" "lucidatypewriter" "medium" "r" $size]
	    $win tag configure $fnt-$color  -font $fnt
	    $win tag configure $fnt-$color  -foreground $color
	    set fnt [format "-*-%s-%s-%s-*-*-%s-*-*-*-*-*-*-*" "lucidatypewriter" "bold" "o" $size]
	    $win tag configure $fnt-$color  -font $fnt
	    $win tag configure $fnt-$color  -foreground $color
	    set fnt [format "-*-%s-%s-%s-*-*-%s-*-*-*-*-*-*-*" "lucidatypewriter" "medium" "o" $size]
	    $win tag configure $fnt-$color  -font $fnt
	    $win tag configure $fnt-$color  -foreground $color
	}
	lappend __html__textColors $color
    }
}
    
