#!/usr/bin/X11/tixwish
#  File: lang.tcl
# 
#      This file is part of minkowsky
# 
#      Copyright (C) 2001-2002 by Rdiger Goetz
#      Author: Rdiger Goetz <minkowsky@r-goetz.de>
# 
#      Time-stamp: <25-May-2002 19:55:24 goetz>
# 
#      This program is free software; you can redistribute it and/or modify
#      it under the terms of the GNU General Public License as published by
#      the Free Software Foundation; either version 2 of the License, or
#      (at your option) any later version.
# 
#      This program is distributed in the hope that it will be useful,
#      but WITHOUT ANY WARRANTY; without even the implied warranty of
#      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#      GNU General Public License for more details.
# 
#      You should have received a copy of the GNU General Public License
#      along with this program; if not, write to the Free Software
#      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#  
proc getLanguageSettings { } {
    global env langType languages TclBinPath _allgText
    
#    set languages "en de"
    
#    foreach lang $languages {source $TclBinPath/lang_$lang.tcl }
#    set defLanguage [lindex $languages 0]


    set  list [glob $TclBinPath/lang_*.tcl]

    set languages ""
    foreach ent $list {
	set file [ file tail $ent]
	set lang [string range $file 5 6]
	lappend languages $lang
    }


    if { $list == "" } {
	puts "no language modul installed. Please install at least one modul"
	exit -1
    }
    if { [ lsearch $languages "de"] > -1 }  {
	set defLanguage "de"
    } elseif { [ lsearch $languages "en"] > -1 }  {
	set defLanguage "en"
    } else {
	[lindex $languages 0]
    }


    if { $langType != "" } {
	if { [ lsearch $languages $langType] <0 }  {
	    set langType ""
	}
    }
    


    if { $langType == "" } {
	if { [array names env LANG] == "" } {
	    set langType en
	} else {
	    switch -exact $env(LANG) {
		german { set langType de}
		default {
		    set langType $env(LANG) 
		    if { [ string length $langType] > 2} {
			set langType [string range $langType 0 1]
		    }
		}
	    }
	}
    }



    #set all text in the default language
    if { [lsearch $languages $langType] >= 0 } {
	set cmd "language[string toupper $langType]"
    } else {
	set langType $defLanguage
	set cmd "language[string toupper $defLanguage]"
    }
	
    source $TclBinPath/lang_$langType.tcl	
    eval $cmd
}

