#!/usr/bin/X11/tixwish
#  File: lang_en.tcl
# 
#      This file is part of minkowsky
# 
#      Copyright (C) 2001-2002 by Rdiger Goetz
#      Author: Rdiger Goetz <minkowsky@r-goetz.de>
# 
#      Time-stamp: <30-May-2002 21:49:28 goetz>
# 
#      This program is free software; you can redistribute it and/or modify
#      it under the terms of the GNU General Public License as published by
#      the Free Software Foundation; either version 2 of the License, or
#      (at your option) any later version.
# 
#      This program is distributed in the hope that it will be useful,
#      but WITHOUT ANY WARRANTY; without even the implied warranty of
#      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#      GNU General Public License for more details.
# 
#      You should have received a copy of the GNU General Public License
#      along with this program; if not, write to the Free Software
#      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#  
proc languageEN { } {
    global _buttonText _addrText _allgText _gselText _noteText _calText _prefText _projText _ballonText
    global _reminderTransl _reminderTranslPart _helpText
    global weekDays weekDaysAbk monAbk monNames monlen  progname longProgName
    global _dateOrder
    global dringlichStr depStr TODOstatStr
    global partStatus partStatusStr

    global datePermRefStr datePermSym datePartType

    set datePermRefStr "ltpcltpcd"
    set datePermSym(rz) "l"
    set datePermSym(r) "t"
    set datePermSym(rt) "p"
    set datePermSym(rk) "c"
    set datePermSym(wz) "l"
    set datePermSym(w) "t"
    set datePermSym(wt) "p"
    set datePermSym(wk) "c"
    set datePermSym(dd) "d"
    
    set datePartType(I) "I"
    set datePartType(E) "V"
    set datePartType(T) "P"
    set datePartType(A) "e"
    set datePartType(i) "i"

    # general text variables
    set _dateOrder "en"
    set progname "Minkowsky"
    set longProgName "Minkowsky Space/Time Management"


    set weekDays "Monday Tuesday Wednesday Thursday Friday Saturday Sunday Monday Tuesday Wednesday Thursday Friday Saturday Sunday "
    set weekDaysAbk "Mo Tu We Th Fr Sa Su"
    set monlen "0 31 28 31 30 31 30 31 31 30 31 30 31"
    set monAbk "??? Jan. Feb. Mar. Apr. May June July Aug. Sep. Oct. Nov. Dec."
    set monNames  "??? January February March April May June July August September October November December"

    #proj/Todo
    set dringlichStr "{very low} low reduced normal increased high {very high} highest"
    set TODOstatStr "done new opend cancled pending stopped {work in progress} delayed"
    set depStr "{work in Progress} delayed done deleted stopped {done by 'm' %} {at Milestone 'm'}"

    #claendar
    set partStatus "??? UKN OK NO OPEN PUSH"
    set partStatusStr "undefined undefined confirmed cancel uncertain shift? ???  ??? ??? ??? ??? ???"
#     set eddv_repTyp "off tag woche monat jeden alle wtag"
#     set eddv_repTypStr "off tglich wchentlich monatlich {jeden ...} {alle ...} {wochen-tglich}"
#     set eddv_repUnit "stunden tage woche monate jahre"




    set _buttonText(Cancel)             "Cancel"
    set _buttonText(OK)                 "O.K."
    set _buttonText(Accept)             "Accept"
    set _buttonText(Apply)              "Apply"
    set _buttonText(Add)                "Add"
    set _buttonText(Change)             "Change"
    set _buttonText(Modify)             "Modify"
    set _buttonText(ApplyChange)        "Apply Changes"
    set _buttonText(Delete)             "Delete"
    set _buttonText(Close)              "Close"
    set _buttonText(no)                 "NO"
    set _buttonText(yes)                "yes"
    set _buttonText(noWide)             "    NO    "
    set _buttonText(yesWide)            "  yes  "
    set _buttonText(Create)             "Create"
    set _buttonText(Show)               "Show"    
    set _buttonText(Save)               "Save"
    set _buttonText(Replace)            "Replace"
    set _buttonText(Print)              "Print"
    set _buttonText(Help)               " Help "
    set _buttonText(login)              " Login "
    
    set _allgText(specialThanks)        "Special Thanks to"

    set _allgText(User)                 "User"  
    set _allgText(Users)                "Users" 
    set _allgText(Gruppe)               "Group" 
    set _allgText(GruppeAbk)            "Gr." 
    set _allgText(Gruppen)              "Groups"
    set _allgText(Set)                  "Set"   
    set _allgText(Sets)                 "Sets"
    set _allgText(Ort)                  "Location"
    set _allgText(Raum)                 "Room"
    set _allgText(Raume)                "Rooms"
    set _allgText(Ort)                  "Location"
    set _allgText(PageKal)              "  Calendar"
    set _allgText(PageTodo)             "  Tasks and Projects  "
    set _allgText(PageAdr)              "  Addresses  "
    set _allgText(Fatal)                "Fatal Error"
    set _allgText(FATAL)                "FATAL ERROR"
    set _allgText(Error)                "Error"
    set _allgText(ERROR)                "ERROR"
    set _allgText(Warn)                 "Warning"
    set _allgText(WARN)                 "WARNING"
    set _allgText(Attention)            "Attention"
    set _allgText(ATTENTION)            "ATTENTION"
    set _allgText(Reason)               "Reason"
    set _allgText(calSelection)         "Calendar Selection"
    set _allgText(taskSelection)        "Task List Selection"

    set _allgText(errorOnTransfer1)      "An error occured on the server while processing\n  the command"
    set _allgText(errorOnTransfer2)      "reason is"

    set _allgText(wmTitle_pr)           "Print"
    set _allgText(Printer)              "Printer"
    set _allgText(LabelPrint2File)      "print to file"
    set _allgText(LabelPrint2FileShow)  "print to file and display"
    set _allgText(Options)              "Options"
    set _allgText(PrintType)            "Format"
    set _allgText(PrintLinesPerList)    "max. lines in participant list"
    set _allgText(PrintIgnoreInit)      "  ignore Initiator"
    set _allgText(PrintIgnoreWeekEnd)   "  ignore Weekends"
    set _allgText(PrintCalWeekView)     "Weck view"
    set _allgText(PrintCalMonthView)    "Month view"
    set _allgText(PrintCalListView)     "List"
    set _allgText(PrintCalCurView)      "current View"
    set _allgText(PrintCalVom)          "from"
    set _allgText(PrintCalBis)          "to"
    set _allgText(PrintCapWarn1)        "The Printer preferences in contain the printer"
    set _allgText(PrintCapWarn2)        "twice."
    set _allgText(PrintCapWarn3)        "ignores the second entry. Please inform your system administrator about this problem."
    set _allgText(ServerDown1a)         "Connection to"
    set _allgText(ServerDown1b)         " server has been lost.\nPlease contact your system administrator and start"
    set _allgText(ServerDown1c)         "when the problem is fixed."
    set _allgText(ServerDown2a)         "Connection to"
    set _allgText(ServerDown2b)         " server has been lost.\n"
    set _allgText(ServerDown2c)         "tries to reestablish the communication.\n"
    set _allgText(ServerBack-a)         "The connection to"
    set _allgText(ServerBack-b)         "server\nhas been reestablished\nHowever the last user action got lost\n Plese repeat it."

    set _allgText(wmTitle_log)          "Login to"
    set _allgText(loginUserName)        "Username"
    set _allgText(loginPassword)        "Password" 
    set _allgText(loginMeterStart)      "starting"
    set _allgText(loginMeterConnect)    "contacting Server"
    set _allgText(loginMeterPref)       "read User Preferences"
    set _allgText(loginMeterLists)      "getting user lists"
    set _allgText(loginMeterCal)        "creating calendar"
    set _allgText(loginMeterAdr)        "creating addressbook"
    set _allgText(loginMeterProj1)      "getting project lists"
    set _allgText(loginMeterProj2)      "creating project view"
    set _allgText(loginMeterDone)       "done"

    set _allgText(wmTitelAbout)         "About"
    set _allgText(AboutMinkoFunc)       "Space/Time Management"
    set _allgText(AboutVon)             "by"
    set _allgText(AboutVersion)         "Version"
    set _allgText(AboutVom)             "built date:"

    set _allgText(Perms)                "Permissions"
    set _allgText(permRead)             "Read"
    set _allgText(permModi)             "Modify"
    set _allgText(permDelete)           "Delete"

    set _allgText(dateSep)              "/"

    set _allgText(ErrorNoHelpTitle)     "Error: No Online Help"
    set _allgText(ErrorNoHelpText)      "No Online Help found"



    set _gselText(wmTitel_ssd)          "Name of Set"
    set _gselText(wmTitle_css)          "Set name existing"
    set _gselText(SetExisting1)         "A Set named"
    set _gselText(SetExisting2)         "is already existing, replace it ?"
    set _gselText(ButSaveSet)           "Save Set"

    set _addrText(ButtonFilter)         "Filter"
    set _addrText(ButtonClearFilter)    "ClearFilter"
    set _addrText(AssignFolder)         "Assign to Folder"
    set _addrText(ApplyChange)          "Apply Changes"
    set _addrText(wmTitel_adf)          "Define Adress Filter"
    set _addrText(wmTitel_naf)          "Create New Adress Folder"
    set _addrText(wmTitel_adv)          "Adresss"
    set _addrText(wmTitel_afv)          "Adresss Folder"
    set _addrText(wmTitel_adl)          "Assign Adress to Folder"
    set _addrText(newAddressName)       "New Addres"
    set _addrText(delAdr1)              "Do you really want to delete"
    set _addrText(delAdr2)              "delete this address"
    set _addrText(delAdrSort)           "12O"
    set _addrText(delFolder1)           "Do you really want to delete"
    set _addrText(delFolder2)           "this address folder "
    set _addrText(delFolderSort)        "12O"
    set _addrText(Folder)               "Folder"
    set _addrText(WarnFolderStructDamage) "Warning: Parts of the folder structure seem\nto be damaged (e.g. a loop in the structure).\nTherefore all folders within the damaged \nsection of the folder structure are reconnected\n to the root folder.\n Please move them to their correct location"


    set _addrText(PageAddress)          "Addresses"
    set _addrText(PageCommu)            "Communication"
    set _addrText(PageBank)             " Bank "
    set _addrText(PageMisc)             " Misc "
    set _addrText(PagePrivate)          "Private"
    set _addrText(Pageprivate)          "private"
    set _addrText(private)              "private"
    set _addrText(priv)                 "priv."
    set _addrText(Name)                 "Name"
    set _addrText(Company)              "Company"
    set _addrText(ShortCompanyName)     "short Company Name"
    set _addrText(ShortForm)            "short"
    set _addrText(Position)             "Position"
    set _addrText(AdrAccess)            "Access Permissions"
    set _addrText(AccessAll)            "Full Access:"
    set _addrText(AccessNotes)          "Read Only + write Memo :"
    set _addrText(AccessRO)             "Read Only:"
    set _addrText(AccessDialogTitle)    "Change Access Permssions"
    set _addrText(LabelAllg)            "Public"
    set _addrText(All)                  "All"
    set _addrText(Adr)                  "Address"
    set _addrText(Adr1)                 "Address 1"
    set _addrText(Adr2)                 "Address 2"
    set _addrText(PLZort)               "Zip/City"
    set _addrText(Staat)                "Country"
    set _addrText(Telefon)              "Telephone"
    set _addrText(Telefone)             "Telephones"
    set _addrText(mail)                 "e-Mail"
    set _addrText(mails)                "e-Mails"
    set _addrText(Handy)                "mobile"
    set _addrText(FAX)                  "FAX"
    set _addrText(Internet)             "Internet"
    set _addrText(WWW)                  "Web-URL"
    set _addrText(BankKonto)            "Bank Account"
    set _addrText(Konto1)               "Account 1"
    set _addrText(Konto2)               "Account 2"
    set _addrText(KontoInh)             "Account Holder:"
    set _addrText(KontoNum)             "Account Number:"
    set _addrText(Bank)                 "Bank          :"
    set _addrText(BLZ)                  "Bank code     :"
    set _addrText(SteurNum)             "tax number    :"
    set _addrText(SteurNumm)            "tax number"
    set _addrText(Descr)                "Description"
    set _addrText(ShortDescr)           "short Description"
    set _addrText(detailed)             "detailed"
    set _addrText(infos)                "further info"
    set _addrText(createAt)             "create on "
    set _addrText(by)                   " by "
    set _addrText(modifiedAt)           "modified on "
    set _addrText(Birthday)             "Birthday "

    set _addrText(NewAdrFolder)         "Create new Address Folder"
    set _addrText(NameOfFolder)         "Name of Folder: "
    set _addrText(changeableBy)         "can be modified by: "
    set _addrText(defOpen)              "is open by default"

    set _addrText(PrintTelefonList)     "Telephone List"
    set _addrText(PrintAdresssList)     "Address List"
    set _addrText(PrintprivAddrList)    "private Address List"
    set _addrText(PrintFullList)        "Full List"
    set _addrText(PrintCustomList)      "Custom"
    set _addrText(PrintPageFormat)      "Pageformat"
    set _addrText(PrintFormat)          "Format"
    set _addrText(PrintAddrSel)         "Address to print" 
    set _addrText(PrintCurrent)         "current Addresses"
    set _addrText(PrintAll)             "all Addresses"
    set _addrText(PrintSeclected)       "selected Addresses"

    
    set _noteText(Note)                 "Memo pad"
    set _noteText(NoteGenricNewTitle)   "new Memo"
    set _noteText(NoteNewTitle)         "Title of new mmeo:"
    set _noteText(wmTitel_ntd)          "New Memo"
    set _noteText(wmTitel_npr)          "Print Memo"
    set _noteText(wmTitel_snm)          "Send Memo"
    set _noteText(NoteMailError1)       "Can't send this memo\nResone: "   
    set _noteText(NoteMailError1)       "No mail sent."   
    set _noteText(NoteSendMail)         "Sending memo   "
    set _noteText(NoteSendMailTo)       "to:"
    set _noteText(NoteButtonSendMail)   "Send Mail"
    set _noteText(NotePrintTextTitle)   "Memo to address"
    set _noteText(NotePrintTextCreator) "created by"
    set _noteText(NotePrintTextAm)      "on"
    set _noteText(NotePrintTextUm)      "at"


#     set _calText(JumpTo)                "Jump to"
#     set _calText(ButJump)               "Jump"
    set _calText(NaviTitle)             "Calendar Navigation"
    set _calText(CalOfUser)             "Calendar of"
    set _calText(CalOfGroup)            "Calendar of the"
    set _calText(CalOfSets)             "Calendar of the selected set of users"
    set _calText(delDate1)              "Do you really want to delete this appointment:"
    set _calText(delDate2)              "?"
    set _calText(private4Group)         "group only"
    set _calText(private)               "private"
    set _calText(Zeit)                  "Time"
    set _calText(HiddenTitle)           "hidden Title"
    set _calText(von)                   "from"
    set _calText(bis)                   "to" 
    set _calText(bis2)                  "until"
    set _calText(Details)               "Details"
    set _calText(Teilnehmer)            "Participant"
    set _calText(Status)                "Status"
    set _calText(Termin)                "Appointment"
    set _calText(suspendDate1)          "Do really wnat to suspend the appointment"
    set _calText(suspendDate2)          "?"
    set _calText(am)                    "on"
    set _calText(um)                    "at"
    set _calText(Heute)                 "Today"
    set _calText(sendAnn)               "Send Notification to"
    set _calText(partAll)               "All"
    set _calText(partInternal)          "Internals"
    set _calText(partExternal)          "Externals"
    set _calText(partNoone)             "noone"
    set _calText(shiftDateTime)         "Shift Appointment to ..."
    set _calText(shiftDateRoom)         "Move Appointment to  ..."
    set _calText(Beginn)                "Begin"
    set _calText(Ende)                  "End"  
    set _calText(shiftDateDetails)      "Datails about the shift"
    set _calText(butShift)              "Shift"
    set _calText(wmTitelShiftDate1)     "Shift appointment"
    set _calText(wmTitelShiftDate2)     ""
    #add.tcl
    set _calText(Titel)                 "Title"
    set _calText(AddPageTimes)          "Date, Time & Location"
    set _calText(AddPagePart)           "Participants"
    set _calText(AddPageDetails)        "Details and Comments"
    set _calText(AddSecTimesPlace)      "Location in Time and Space"
    set _calText(TerminOhneUhrzeit)     "Appointment with only Date specified"
    set _calText(schwebenderTermin)     "Non Blocking Appointment"
    set _calText(addRest)               "Other Properties"
    set _calText(addGroupOfDate)        "Administrative Group"
    set _calText(addPrivatStatus)       "Privacy-Status"
    set _calText(addPriority)           "Priority"
    set _calText(addPriorityLow)        "low"
    set _calText(addPriorityHigh)       "high"
    set _calText(addRepeat)             "Repeat"
    set _calText(addRepeatDate)         "Repeat Appointment"
    set _calText(addRepeatInterVall)    "Interval "
    set _calText(addRepeatDay)          "daily"
    set _calText(addRepeatWorkingDay)   "on working days"
    set _calText(addRepeatWeek)         "weekly"
    set _calText(addRepeatMonth)        "monthly"
    set _calText(addRepeatEvery1)       "on fixed day in month"
    set _calText(addRepeatEvery2)       "every ..."
    set _calText(addRepeatExcept)       "except"
    set _calText(addRepeatTimes)        "Repeat"
    set _calText(addRepeatUnlimit)      "ever"
    set _calText(addRepeatEveryText)    "Repeat every"
    set _calText(addRepeatEveryHours)   "Hours"
    set _calText(addRepeatEveryDays)    "Days"
    set _calText(addRepeatEveryWeeks)   "Weeks"
    set _calText(addRepeatEveryMonth)   "Month"
    set _calText(addRepeatEveryYears)   "Years"
    set _calText(addRemind)             "Reminder"
    set _calText(addRemindSend)         "Send"
    set _calText(addRemindInvite)       "Invitation"
    set _calText(addRemindRemind)       "Reminder"
    set _calText(addRemindDays)         "Days"
    set _calText(addRemindHours)        "Hours"
    set _calText(addRemindMin)          "Minutes"
    set _calText(addRemindBeforeBy)     "before by"
    set _calText(addRemindBefore)       "before"
    set _calText(addRemindVia)          "via"
    set _calText(addRemindByMail)       "E-mail"
    set _calText(addRemindByDialog)     "Dialog"
    set _calText(addRemindTo)           "to"
    set _calText(addRemindAdd)          "Add"

    set _reminderTransl(Minuten)            "Minutes"
    set _reminderTransl(Stunden)            "Hours"
    set _reminderTransl(Tage)               "Days"
    set _reminderTransl(E-mail)             "E-mail"
    set _reminderTransl(Fenster)            "Dialog"
    set _reminderTransl(Signal)             "Signal"
    set _reminderTranslPart(alle)               "all"
    set _reminderTranslPart(Alle)               "All"
    set _reminderTranslPart(intern)             "internal"
    set tag "interne Teilnehmer"
    set _reminderTranslPart($tag) "internal Participants"
    set _reminderTranslPart(extern)             "extern"
    set tag "externe Teilnehmer"
    set _reminderTranslPart($tag) "external Participants"

#Teilnehmer / Liste
    set _calText(addPartListName)       "Name"
    set _calText(addPartListStatus)     "Status"
    set _calText(addPartListPerms)      "Permission"
    set _calText(addPartPopupType)      "Type"


#Teilnehmer / 
    set _calText(addPartWmPerm)         "Modify Permissions of"

#Teilnehmer / Auswahllist
    set _calText(addPartUserGroups)     "User / Groups"
    set _calText(addPartExternalPart)   "external Participants"
    set _calText(addPartdefPermissions) "Permission defaults"
    set _calText(addPartAsInvitor)      "inviting"
    set _calText(addPartAsPart)         "participating"
    set _calText(addPartInfoOnly)       "Information only"
 
#Teilnehmer / Rechte
    set _calText(permCoords)            "Time / Location"
    set _calText(permTexts)             "Texts"
    set _calText(permParts)             "Participants"
    set _calText(permComments)          "Comments"
    set _calText(permDelete)            "delete date"
    set _calText(typeInit)              "initiating"
    set _calText(typeInvite)            "inviting"
    set _calText(typePart)              "participating"
    set _calText(typeExtern)            "external"
    set _calText(typeInfo)              "informed"
    set _calText(typeInfoShort)         "inform."
#details
    set _calText(addDetails)            "Details"
    set _calText(addNewComments)        "new comment"
    set _calText(addAddNewComment)      "add new comment"
    set _calText(addComments)           "comments"
#buttons
    set _calText(addAddDate)            "Add Appointment"
    set _calText(addModifyDate)         "Modify Appointment"
    set _calText(addTypeNew)            "Add Appointment"
    set _calText(addTypeModify)         "Modify Appointment"
    set _calText(addDefaultTitle)       "New Appointment"

    set _calText(ErrorCantDelete)        "Can't delete Appointment"

#Aufgaben Projekte
#main
    set _projText(mainStatus)           "Status"
    set _projText(mainName)             "Task or Project"
    set _projText(mainStart)            "Begin"
    set _projText(mainEnd)              "target date"
    set _projText(mainProgress)         "Progess"
    set _projText(mainWorker)           "Operator(s)"
    set _projText(mainInit)             "Initiator"
    set _projText(mainDring)            "U"

    set _projText(Legend)               "Legend"
    set _projText(LegendStati)          "Status"
    set _projText(LegendNew)            "new Task"
    set _projText(LegendDone)           "Task done"
    set _projText(LegendOpen)           "Task opened"  
    set _projText(LegendCanceled)       "Task canceled"
    set _projText(LegendPending)        "Task pending"
    set _projText(LegendSuspended)      "Task stopped"
    set _projText(LegendWIP)            "Work in progress"
    set _projText(LegendDelayed)        "Task delayed"
    set _projText(LegendUrgency)        "Urgency"
    set _projText(projTitel)            "Title"
    set _projText(projDescr)            "Description"
    set _projText(projWorker)           "Operators(s)"
    set _projText(projwmViewTitle)      "Project"
    set _projText(projDel1)             "Do you really want to delete the project"
    set _projText(projDel2)             "?"
    set _projText(projFinishDate)       "target date"
    set _projText(projPrivate)          "private Project"
    set _projText(projOperator)         "Operators"
    set _projText(projTaskList)         "Tasklist"
    set _projText(projWmTitle)          "Modify Project"
    set _projText(projnewTask)          "new Task"
    set _projText(projChgPermWmTitle)   "Modify project permissions"
    set _projText(projPermText1)        "Permission of"
    set _projText(projPermText2)        "on this project"
    set _projText(projWritePerm)        "Write permission on this project"
    set _projText(projDeletePerm)       "delete permission on this project"
    set _projText(projDependWmTitle)    "Dependencies of tasks"
    set _projText(projDependText1)      "The task"
    set _projText(projDependText2)      "is activated, if the task"
    set _projText(projDependText3)      "is"
    set _projText(projDependText4)      ";    m="

    set _projText(todo)                 "Task"
    set _projText(todoTitel)            "Title"
    set _projText(todoStatus)           "Status"
    set _projText(todoTaskDone1)        "Task done by"
    set _projText(todoTaskDone2)        ""
    set _projText(todoPriority)         "Priority"
    set _projText(todoDescr)            "Description"
    set _projText(todoMilestones)       "Milestones"
    set _projText(todoWmTitle)          "Task"
    set _projText(todoDel1)             "Do you really want to delete the Task"
    set _projText(todoDel2)             "?"
    set _projText(todoDefaultTitle)     "New Task"
    set _projText(totoModiPageCoords)   "Times and Status"
    set _projText(totoModiPageDescr)    "Description" 
    set _projText(totoModiPageWorker)   "Operator(s)"
    set _projText(totoModiPageReminder) "Reminder"
    set _projText(totoModiPageMilest)   "Milesstones"
    set _projText(todoTypeModify)       "Modify Task"
    set _projText(todoTypeNew)          "New Task"
    set _projText(todoModiTimesHeader)  "Task to be done"
    set _projText(todoModiTimesFrom)    "from"
    set _projText(todoModiTimesTo)      "to"
    set _projText(todoModiCurStatus)    "current Status"
    set _projText(todoModiComplete)     "Done by %"
    set _projText(todoModiUrgency)      "Urgency"
    set _projText(todoModiUrgencyDyn)   "dynamic"
    set _projText(todoModiGroupAssign1) "This Task is assigned to group"
    set _projText(todoModiGroupAssign2) ""
    set _projText(todoModiPublic)       "Public"
    set _projText(todoModiPrivate)      "private Task"
    set _projText(todoLoadText1)        "expected share of working time of"
    set _projText(todoLoadText2)        "on this task"
    set _projText(todoWritePerm)        "Write permission on this task"
    set _projText(todoDeletePerm)       "delete permission on this task"
    set _projText(todoRemind)           "Reminder"
    set _projText(todoRemindSend)       "Send"
    set _projText(todoRemindWarning)    "Warning"
    set _projText(todoRemindRemind)     "Reminder"
    set _projText(todoRemindDays)       "Day(s)"
    set _projText(todoRemindHours)      "Hour(s)"
    set _projText(todoRemindMin)        "Minute(s)"
    set _projText(todoRemindBefore)     "before"
    set _projText(todoRemindAfter)      "after"
    set _projText(todoRemind_A)         " deadline a "
    set _projText(todoRemindBy)         "als"
    set _projText(todoRemindByMail)     "E-mail"
    set _projText(todoRemindByDialog)   "FDialog"
    set _projText(todoRemindTo)         "to"
    set _projText(todoRemindAdd)        "Add"
    set _projText(todoReminderAll)      "All"
    set _projText(todoMilesDone)        "done"
    set _projText(todoMilesName)        "Name of Milestone"
    set _projText(todoMilesComplete)    "equivalent completeness level"

#pref panel
    set _prefText(PageRights)           "Permissions"
    set _prefText(PageCalRights)        "Calendar"
    set _prefText(PageDateRights)       "Dates"
    set _prefText(PageSecurity)         "Security"
    set _prefText(PagePwdSecurity)      "Password"
    set _prefText(PageLayout)           "Layout"
    set _prefText(PageCalLayout)        "Calendar"
    set _prefText(PageRemLayout)        "Reminder"
    set _prefText(PageBrwLayout)        "Browser"
    set _prefText(Wmtitle)              "User Preferences"
    set _prefText(panelTitle)           "Configuration panels"
    set _prefText(descrPerm)            "Use this panel the set the access permissions to your own calendar and the the dafault persimmions for participants in new appoinxtments"
    set _prefText(descrLayout)          "Use this panel to set various layout options."
    set _prefText(descrSecurity)        "Use this panel for your security settings"

    set _prefText(calPermGroup)         "Groups with special permiss."
    set _prefText(calLayoutOptions)     "Display options"
    set _prefText(calLayoutIgnored)     "Display ignored appointments"
    set _prefText(calLayoutInformed)    "Display informational appointments"
    set _prefText(calLayoutToolTipps)   "Display ToolTips"
    set _prefText(calLayoutMainTime)    "Main Time"
    set _prefText(calLayoutFrom)        "from"
    set _prefText(calLayoutTo)          "to"
    set _prefText(calLayout_oClock)     "o'Clock"
    set _prefText(calLayoutLines)       "Number of \"lines\" reserved for appointsments without time specified"
    set _prefText(calLayoutLines4Day)   "in days calendar"
    set _prefText(calLayoutLines4Week)  "in weeks calendar"
    set _prefText(calLayoutLines4Month) "in month calendar"
    set _prefText(calLayoutLines4Group) "in groups calendar"
    set _prefText(reminderSignal)       "Reminder accoustic signal"
    set _prefText(reminderSignalBeep)   "Beep"
    set _prefText(reminderSignalCmd)    "by command: "
    set _prefText(reminderType)           "Type"
    set _prefText(reminderTypeDateInvite) "Inviation (Appointment)"
    set _prefText(reminderTypeDateRemind) "Reminder  (Appointment)"
    set _prefText(reminderTypeTaskRemind) "Reminder  (Task)"
    set _prefText(reminderTypeTaskDelay)  "Warning   (Task delayed)"
    set _prefText(reminderalwaysAs)       "always as"
    set _prefText(reminderalwaysLike)     "always as"
    set _prefText(reminderalwaysIn)       "always in"
    set _prefText(reminderalwaysMail)     "Mail"
    set _prefText(reminderalwaysDate)     "specified"
    set _prefText(reminderalwaysDialog)   "Dialog"
    set _prefText(securityPassword)     "Password"
    set _prefText(securityPasswordRep)  "Repeat"
    set _prefText(ErrorPwd)             "The passwords doen't match"
    set _prefText(browserSelection)     "Select the online help browser"
    set _prefText(browserOwn)           "other :"


    #Ballonhelp Toolbar
    set  _ballonText(MainExit)              "Exit"
    set  _ballonText(MainHome)              "Return to startpoint"
    set  _ballonText(MainPrefs)             "Preferences"
    set  _ballonText(MainHelp)              "Online Help" 
    set  _ballonText(MainAbout)             "About"
    set  _ballonText(MainCalPrint)          "Print Calendar"
    set  _ballonText(MainCalReload)         "Reload Calendar from Server"
    set  _ballonText(MainCalNew)            "New Appointment"
    set  _ballonText(MainCalDay)            "Day view"
    set  _ballonText(MainCalWeek)           "Week view"
    set  _ballonText(MainCalMonth)          "Month view"
    set  _ballonText(MainCalToday)          "Today's Calendar"
    set  _ballonText(MainCalNavigator)      "Calendar Navigation"
    set  _ballonText(MainCalSwitchIgnore)   "Visiablity of ignored Appointments"
    set  _ballonText(MainCalSwitchInfo)     "Visiablity of informational Appointments"
    set  _ballonText(MainCalSwitchGroup)    "Multiple or single calenders for groups"
    set  _ballonText(MainProjPrint)         "Print Tasklist"
    set  _ballonText(MainProjReload)        "Reload Tasklist from Server"
    set  _ballonText(MainProjNew)           "New Task"
    set  _ballonText(MainProjNewProj)       "New Project"
    set  _ballonText(MainAdrPrint)          "Print Adressbook"
    set  _ballonText(MainAdrReload)         "Reload Adressbook from Server"
    set  _ballonText(MainAdrNew)            "new Adress"
    set  _ballonText(MainAdrNewFolder)      "new Adress Folder"
    set  _ballonText(MainAdrFilter)         "Filter Adresses"

    set _ballonText(GS_TitelCal)            "Select the calendars which should be dispalyed"
    set _ballonText(GS_TitelProj)           "Select the tasklists which should be dispalyed"
    set _ballonText(GS_excl)                "Select this user exclusively"
    set _ballonText(GS_GroupAll)            "Select all Members of this Group"
    set _ballonText(GS_SetAll)              "Select all Members of this Set"
    set _ballonText(GS_Show)                "Display the current selection"
    set _ballonText(GS_SaveSet)             "Save the the current selection as new Set"

    set _ballonText(viewDate_Ignore)        "Ignore this Appointment"
    set _ballonText(viewDate_noReminder)    "Disable (Enable) Reminder for this Appointment"
    set _ballonText(viewDate_Delete)        "Delete this Appointment"
    set _ballonText(viewDate_DeleteRepAll)  "Delete this repeated Appointmant totally"
    set _ballonText(viewDate_Susepend)      "Suspend this repeated Appointmant,\naka delete it at this date"
    set _ballonText(viewDate_Modify)        "Modify this Appointment"
    set _ballonText(viewDate_Shift)         "Shift this repeated Appointment for this date"
    set _ballonText(viewDate_Ignore)        "Enabled (disable) Ignorance to this Appointment"
    set _ballonText(viewDate_SetStatus)     "Set your Status about for this Appointment here"

    set _ballonText(notiz_New)              "New Memo"
    set _ballonText(notiz_SisplayType)      "Display as tree or list"
    set _ballonText(notiz_FolderViewType)   "Display also memos of addresse included or not"
    set _ballonText(notiz_Protect)          "Disable (Enable) write protection on this memo\n Enable write protection will prevent undo."
    set _ballonText(notiz_Undo)             "Undo edits"
    set _ballonText(notiz_Print)            "Print Memo"
    set _ballonText(notiz_Mail)             "Send memo by e-mail"
    set _ballonText(notiz_Answer)           "New Follow up"


    set _helpText(wmTitle)                  "Minkowsky Help"
    set _helpText(Contents)                 "Contents"
    set _helpText(intro)                    "Introduction"
    set _helpText(cal)                      "Calendar"
    set _helpText(proj)                     "Tasks and Projects"
    set _helpText(addr)                     "Address Book"
    set _helpText(perm)                     "Acces Permissions"
    set _helpText(faq)                      "FAQ"
    set _helpText(grp)                      "Users and Groups"
}
