#!/usr/bin/X11/tixwish
#  File: main.tcl
# 
#      This file is part of minkowsky
# 
#      Copyright (C) 2001-2002 by Rdiger Goetz
#      Author: Rdiger Goetz <minkowsky@r-goetz.de>
# 
#      Time-stamp: <30-May-2002 22:59:19 goetz>
# 
#      This program is free software; you can redistribute it and/or modify
#      it under the terms of the GNU General Public License as published by
#      the Free Software Foundation; either version 2 of the License, or
#      (at your option) any later version.
# 
#      This program is distributed in the hope that it will be useful,
#      but WITHOUT ANY WARRANTY; without even the implied warranty of
#      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#      GNU General Public License for more details.
# 
#      You should have received a copy of the GNU General Public License
#      along with this program; if not, write to the Free Software
#      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#  

proc createNewItem { } {
    global toolSelection username today

    if { $toolSelection == "K" } {
#	newDate $username $today 1200
	invite $username - - $today 12 0 -1 -1
    } elseif { $toolSelection == "T" } {
	newTODO
    } elseif { $toolSelection == "A" } {
	newAddress
    }
}

#proc drawNewView { which } {
proc drawNewView {  } {
    global toolSelection 

#     puts "\n\n\n\nDRAW NEW view invoked by [info level -1]"
#     after 500

    switch $toolSelection {
	K {drawCalendar}
	A {
	    fillAddress
	}
	T { 
	    getProjTodoLists
	    refillTODO 
	}
    }
    getPresence
    displayPresence
}

proc jumpHome { } {
    global toolSelection username GSchanged calTyp

    switch $toolSelection {
	K {
	    set calTyp "w"
	    clearGSbutton "u-$username"
	    jump2Today
	    set GSchanged 0
	    setGSshowButtonStatus
	}
	A {
	    clearAdrFilter
	    adrFolderDefOpenState4All
	}
	T { 
	    clearGSbutton "u-$username"
	    GSshow
	}
    }
    
}

proc printCurCanvas { } {
    global  selPrinter printFile _buttonText
    
    set printFile ""
    if { $selPrinter == "nolp__file__" || $selPrinter ==  "nolp__gv____" } {

 	set dialog [tix filedialog tixFileSelectDialog]
 	$dialog config -command setPrinterFile
	$dialog subwidget fsbox configure -pattern *.ps
	$dialog subwidget fsbox subwidget dirlist subwidget vsb configure -width 12
	$dialog subwidget fsbox subwidget dirlist subwidget hsb configure -width 12
	$dialog subwidget fsbox subwidget filelist subwidget vsb configure -width 12
	$dialog subwidget fsbox subwidget filelist subwidget hsb configure -width 12

	set bb [$dialog subwidget btns]
	set ok   [$bb subwidget ok]
	set filt [$bb subwidget apply]
	set hlp [$bb subwidget help]
	set abb [$bb subwidget cancel]
	$abb configure -text $_buttonText(Cancel)
	pack forget $hlp $ok $filt $abb
	pack $abb -side left -padx 5 -pady 10
	pack $ok -side right  -padx 5 -pady 10
	pack $filt -side right  -padx 10 -pady 10
 	$dialog popup
	grab $dialog
    } else {
	_printCurCanvas	
    }
#    closeWin .pr
}
proc setPrinterFile {file} {
    global printFile
    set printFile $file

    _printCurCanvas
}
proc _printCurCanvas { } {
    global toolSelection   printMode printModeCal
    
    switch $toolSelection {
	K {
	    set printModeCal $printMode
	    printCal 
	}
	A {printAdrList}
	T {printProjs}
    }
    update
    after 50
    closeWin .pr
}

proc printDialog { } {
    global printerList printerFullNames stdPrinter selPrinter printMode
    global bfnt fnt fnt10 fnt12 toolSelection 
    global _allgText _buttonText

    if { [winfo exists .pr ] == 1 } { return }

    set printMode c
    
    if { [info exists selPrinter ] == 0 } {
	set selPrinter [lindex $printerList $stdPrinter ]
    }

    if { $selPrinter == "" } {
	set selPrinter [lindex $printerList $stdPrinter ]
    }

    toplevel .pr
    busyCursor .pr

    frame .pr.t -relief raised -bd 1
    frame .pr.c 
    frame .pr.b 
    pack .pr.t .pr.c  -side top -fill x 
    pack .pr.b -side top -fill x  -pady 2
    

    frame .pr.t.0
    tixLabelFrame .pr.t.1 -label $_allgText(PrintType) -labelside acrosstop -padx 2 -pady 2
    tixLabelFrame .pr.t.2 -label $_allgText(Options) -labelside acrosstop -padx 0 -pady 0
    .pr.t.1 subwidget label configure -font $fnt10
    .pr.t.2 subwidget label configure -font $fnt10
    pack  .pr.t.0  -side top  -fill x -pady 4  -padx 4
    
    tixOptionMenu .pr.t.0.pr -label "$_allgText(Printer) :  " -options {menubutton.width 46 label.width 9 }
    .pr.t.0.pr subwidget label configure -font $bfnt
    .pr.t.0.pr subwidget menubutton configure -font $fnt
    .pr.t.0.pr subwidget menu configure -font $bfnt
    foreach printer $printerList {
 	.pr.t.0.pr add command $printer -label $printerFullNames($printer)
    }
    .pr.t.0.pr add separator fileSep
    .pr.t.0.pr add command nolp__file__ -label $_allgText(LabelPrint2File) 
    .pr.t.0.pr add command nolp__gv____ -label $_allgText(LabelPrint2FileShow) 
    .pr.t.0.pr subwidget menubutton configure -width 32
    .pr.t.0.pr configure -variable selPrinter
    

    pack .pr.t.0.pr -side left

    switch $toolSelection {
	K {
	    printCalDialog .pr.t.1
	    printCalOptionsDialog .pr.t.2 
	    canvas  .pr.c.c -width 580 -height 866 -background white
	    centerWin .pr 380 384
	}
	A { 
	    printAdrDialog .pr.t.1
	    printAdrOptionsDialog .pr.t.2 
	    canvas  .pr.c.c -width 538 -height 765 -background white
	    centerWin .pr 450 700
	}
	T { 
	    centerWin .pr 200 76
	}
	- { 
	    destroy .pr
	    return
	}
    }
    

    button .pr.b.abb -text $_buttonText(Cancel) -command {closeWin .pr}
    pack .pr.b.abb -side left

    button .pr.b.pr -text $_buttonText(Print) -command printCurCanvas
    pack .pr.b.pr -side right
    
#    if {$toolSelection == "K"} {
#  	update 
# 	puts [wm geometry .pr]
# 	centerWin .pr 380 365
#    } else {
#	centerWin .pr 200 76
#    }
    wm title .pr $_allgText(wmTitle_pr)
    update 
    grab .pr
    stdCursor .pr
    
#     global toolSelection   
}

proc togglePRdates { } {
    global printMode

    .pr.t.1.1.d configure -state disabled
    .pr.t.1.1.m configure -state disabled
    .pr.t.1.1.y configure -state disabled
    .pr.t.1.2.m configure -state disabled
    .pr.t.1.2.y configure -state disabled
    .pr.t.1.3.d configure -state disabled
    .pr.t.1.3.m configure -state disabled
    .pr.t.1.3.y configure -state disabled
    .pr.t.1.4.d configure -state disabled
    .pr.t.1.4.m configure -state disabled
    .pr.t.1.4.y configure -state disabled

    .pr.t.2.2.t configure -state disabled
    .pr.t.2.3.i configure -state disabled
    .pr.t.2.4.i configure -state disabled

    if {$printMode  == "w"} {
	.pr.t.1.1.d configure -state normal
	.pr.t.1.1.m configure -state normal
	.pr.t.1.1.y configure -state normal
	.pr.t.2.2.t configure -state normal
	.pr.t.2.3.i configure -state normal
    } elseif  {$printMode  == "m"} {
	.pr.t.1.2.m configure -state normal
	.pr.t.1.2.y configure -state normal
	.pr.t.2.2.t configure -state normal
	.pr.t.2.3.i configure -state normal
	.pr.t.2.4.i configure -state normal
    } elseif  {$printMode  == "l"} {
	.pr.t.1.3.d configure -state normal
	.pr.t.1.3.m configure -state normal
	.pr.t.1.3.y configure -state normal
	.pr.t.1.4.d configure -state normal
	.pr.t.1.4.m configure -state normal
	.pr.t.1.4.y configure -state normal
	.pr.t.2.3.i configure -state normal
	.pr.t.2.4.i configure -state normal
    } 
}
proc compBySize {v1 v2} {
    return [ expr [ string length $v1] - [ string length $v2]]
}
proc WarnDialog {  msg } {
    global _allgText
    if { [winfo exists .err] == 1 } {
	tkwait window .err
    }
    _ErrorDialog $_allgText(Warn) $msg
}
proc ErrorDialog {  msg } {
    global _allgText
    if { [winfo exists .err] == 1 } {
	tkwait window .err
    }
    _ErrorDialog $_allgText(Error) $msg
}
proc _ErrorDialog { title msg } {
    global _allgText _buttonText fnt bfnt lbfnt
    if { [winfo exists .err ] == 1 } { return }
    toplevel .err 
    
    frame .err.t -relief raised -bd 1
    frame .err.b -relief flat
    pack .err.t -side top -fill x
    pack .err.b -side bottom -fill x -pady 4

    set list [split $msg \n]
    set count [llength $list]
    set lt [lindex [lsort -decreasing -command compBySize $list  ] 0 ]
    set w [expr [font measure $lbfnt -displayof .err $lt] ] 
#     puts "w=$w <- lt=$lt"
    label .err.t.lab -text $title -font $lbfnt -fg red -relief raised -bd 1 -anchor n -justify center
    message .err.t.msg -text $msg -font $lbfnt -width $w
    button .err.b.but -text " $_buttonText(OK) " -command {closeWin .err} -font $bfnt
    pack .err.t.lab -side top -fill x
    pack .err.t.msg -side top -expand 1 -fill x
    pack .err.b.but -side bottom -pady 3
    set h [expr $count*24 +24+48+8]
    set lt [lindex [lsort -decreasing -command compBySize $list  ] 0 ]
    incr w 16
    wm title .err $title
    centerWin .err $w $h
    grab .err
    bind .err <Return> {closeWin .err}
    bind .err <KP_Enter> {closeWin .err}
    update
}
proc FatalErrorDialog { msg } {
    global _allgText _buttonText
    if { [winfo exists .ferr ] == 1 } { return }
    toplevel .ferr
    
    label .ferr.lab -text $_allgText(Fatal)  -font -*-helvetica-bold-r-*-*-17-*-*-*-*-*-*-* -fg red
    message .ferr.msg -text $msg -font -*-helvetica-bold-r-*-*-17-*-*-*-*-*-*-* -width 300
    button .ferr.but -text " $_buttonText(OK) " -command {exitClient}
    pack .ferr.lab .ferr.msg  -side top
    pack  .ferr.but -side bottom
    wm title .ferr $_allgText(Fatal)
    centerWin .ferr 320 120
    grab .ferr 
}
proc ServerDownDialog { } {
    global _allgText _buttonText
    global progname sdDialogRunning
    
    if { $sdDialogRunning == 0} {
	if { [winfo exists .sdd ] == 1 } { return }
	set sdDialogRunning 1
	toplevel .sdd
	label .sdd.lab -text $_allgText(Fatal)  -font -*-helvetica-bold-r-*-*-17-*-*-*-*-*-*-* -fg red
	message .sdd.msg -text [format "%s %s%s %s %s" $_allgText(ServerDown1a) $progname $_allgText(ServerDown1b) $progname $_allgText(ServerDown1c)] -font -*-helvetica-bold-r-*-*-17-*-*-*-*-*-*-* -width 300
	button .sdd.but -text " $_buttonText(OK) " -command {exitClient}
	pack .sdd.lab .sdd.msg  -side top
	pack  .sdd.but -side bottom
	wm title .sdd $_allgText(Error)
	centerWin .sdd 320 160
	update
	grab .sdd
    }
}
proc ServerDownDialog2 { } {
    global _allgText _buttonText
    global progname sdDialogRunning username

	
    

    if { $sdDialogRunning == 0} {
	set sdDialogRunning 1
	for { set j 0 } { $j < 4 } {incr j}  {
	    if { $username  == "goetz" } {	    catch {exec /lan/bin/woi} }
	    if { [tryReconnect] == "up" } {
		set sdDialogRunning 0
		return
	    }
	    for  { set s 0 } { $s<10} { incr s } {
		update
		after 100
	    }
	}

	if { [winfo exists .pr ] == 1 } { destroy .sdd }
	toplevel .sdd
	label .sdd.lab -text $_allgText(ATTENTION)  -font -*-helvetica-bold-r-*-*-17-*-*-*-*-*-*-* -fg red
	message .sdd.msg -text [format "%s %s%s %s %s" $_allgText(ServerDown2a) $progname $_allgText(ServerDown2b) $progname $_allgText(ServerDown2c)] -font -*-helvetica-bold-r-*-*-17-*-*-*-*-*-*-* -width 300
	pack .sdd.lab   -side top
	pack  .sdd.msg  -side top -fill y
	wm title .sdd $_allgText(Error)
	centerWin .sdd 320 108
	grab .sdd
	wm transient .sdd .
	after 50
	update
	for { set i 0 } { $i < 5 } {incr i} {
	    for { set j 0 } { $j < 12 } {incr j}  {
		if { [tryReconnect] == "up" } {
		    destroy .sdd
		    set sdDialogRunning 0
		    return
		} 
		for  { set s 0 } { $s<50} { incr s } {
		    update
		    after 100
		}
	    }
	    if { $i<4 } {
		for  { set s 0 } { $s<300} { incr s } {
		    update
		    after 100
		}
	    }
	}
	destroy .sdd
	set sdDialogRunning 0
	ServerDownDialog
    }
}
proc ServerBackDialog { } {
    global _allgText _buttonText
    global progname sdDialogRunning
    
    if { $sdDialogRunning == 0} {
	set sdDialogRunning 1
	if { [winfo exists .sbd ] == 1 } { return }
	toplevel .sbd
	label .sbd.lab -text $_allgText(Warn)  -font -*-helvetica-bold-r-*-*-17-*-*-*-*-*-*-* -fg red
	message .sbd.msg -text [format "%s %s%s" $_allgText(ServerBack-a) $progname $_allgText(ServerBack-b)] -font -*-helvetica-bold-r-*-*-17-*-*-*-*-*-*-* -width 300
	button .sbd.but -text " $_buttonText(OK) " -command {destroy .sbd }
	pack .sbd.lab .sbd.msg  -side top
	pack  .sbd.but -side bottom
	wm title .sbd $_allgText(Warn)
	centerWin .sbd 320 160
	update
	grab .sbd
    }
}

proc loginDialog { prefUser retry } {
    global username password env cputype progname
    global bfnt fnt minkoIcon128 docBasePath _allgText _buttonText
    global env

    if { [winfo exists .log ] == 1 } { return }
    toplevel .log

    if { [ array names env LANG] == "" } { 
	set lang "empty"
    } else {
	set lang $env(LANG)
    }
    
    wm title .log "$_allgText(wmTitle_log) $progname"
    frame .log.t -relief raised -bd 1
    frame .log.b -relief flat
    pack .log.t .log.b -side top -fill x -padx 2

    frame .log.t.l 
    frame .log.t.r
    pack .log.t.l -side left -fill both
    pack .log.t.r -side left -fill both -padx 8 -pady 12

    
    button .log.t.l.b -image  [image create pixmap -data $minkoIcon128]
    pack .log.t.l.b

#    label .log.t.r.0 -text "" -font $bfnt
    label .log.t.r.1 -text $_allgText(loginUserName) -width 16 -font $bfnt
    entry .log.t.r.2 -textvariable username -width 16 -font $fnt  -vcmd {checkEntryText %P 16  %d %S " "} -validate key
    label .log.t.r.3 -text "" -font $bfnt

    label .log.t.r.4 -text $_allgText(loginPassword) -width 16 -font $bfnt
    entry .log.t.r.5 -textvariable password -width 16 -font $fnt -show * -vcmd {checkEntryText %P 16  %d %S " "} -validate key
    for {set i 1} {$i<= 5} {incr i} { pack .log.t.r.$i -side top}

    button .log.b.c -text $_buttonText(Cancel) -command exitClient -font $bfnt
    button .log.b.h -text $_buttonText(Help)  -font $bfnt -command { 
	set docBasePath "$TclBinPath/../html"
	displayLoginHelp 
    }
    button .log.b.o -text $_buttonText(login)  -command doLogin -font $bfnt
    pack .log.b.c .log.b.h -side left
    pack .log.b.o -side right

    if { $prefUser == "-" } {
	
	set file [ format "%s/.kapa" $env(HOME)]
	if { [file exists $file] ==1 } {
	    set fid [ open $file "r" ]
	    set username [gets $fid ]
	    close $fid
	} else { 
	    catch {set username $env(USER) }
	}
    } else {
	set username $prefUser
    }
    if { $retry == 1}  {
	focus .log.t.r.5
	.log.t.r.5 selection range 0 end
    }
    centerWin .log 296 170
    
    update
    bind .log <Return>  {doLogin}
    bind .log <KP_Enter>  {doLogin}
    bind . <Return>  {doLogin}
    bind . <KP_Enter>  {doLogin}
    grab .log
# puts "BIND: [bind . ] [bind . ]"
# puts "BIND: [bind .log ] [bind .log ]"
    
}

proc doLogin { } {
    global username password env cur_Cal primCurCal fullUsername eddLock kalWin selCalObj refreshEna progname 
    global prvCal bfnt12 adr_list ToolBarButtons GSchanged
    global up_displayIgnore up_displayInfo up_displayToolTips showIgnore ignoreInfo ballon
    global ignoreIcon_in ignoreIcon_out ignoreInfoIcon_in ignoreInfoIcon_out
    global curWindowWidth curWindowHeight  _allgText  logedIn

    closeWin .log

    openMeter "$_allgText(loginMeterStart) $progname" $_allgText(loginMeterConnect) 1
    update
    busyCursor .met
    if { $password == "" } { set password "" }
    set ret [login $username $password]
    if { [string range $ret  0 2] == "ERR" } {
	closeMeter
	update
	ErrorDialog $ret
	update
	tkwait window .err
	bind . <Return>  {doLogin}
	bind . <KP_Enter>  {doLogin}
	loginDialog - 1
	return
    }
    if { [lindex $ret 0] == "OK" } {

	updateMeter 9 $_allgText(loginMeterPref)
	
	check4NewLists
	readUserPrefs	
	# setze aktuelle Password als default pwd
	if { $password != "" } {set up_pwd $password } else {set up_pwd "" }
	set showIgnore $up_displayIgnore
	set ignoreInfo [ expr 1- $up_displayInfo]
	if { $ignoreInfo == 1} {
	    .t.t.c.k.ii configure -image [image create pixmap -data $ignoreInfoIcon_out]
	} else {
	    .t.t.c.k.ii configure -image [image create pixmap -data $ignoreInfoIcon_in]
	}
	if { $showIgnore == 0 } {
	    .t.t.c.k.ig configure -image [image create pixmap -data $ignoreIcon_out]
	} else {
	    .t.t.c.k.ig configure -image [image create pixmap -data $ignoreIcon_in]
	}

	if { $up_displayToolTips == 0 } {$ballon configure -state none }
	    
	
 	set file [ format "%s/.termine" $env(HOME)]
 	set fid [ open $file "w" ]
 	puts $fid $username
 	close $fid
	set cur_Cal "u-$username"
	set primCurCal $username
	set prvCal $username
	

	updateMeter 23 $_allgText(loginMeterLists) 
	set fullUsername  [getFullUserName $username u] 
	fillGroupSelector
	set GSchanged 0 
	getPresence
	displayPresence
	updateMeter 31 $_allgText(loginMeterCal)
	drawCal
	updateMeter 49 $_allgText(loginMeterAdr)

	fillAddress
	updateMeter 79 $_allgText(loginMeterProj1)
	getProjTodoLists 
	updateMeter 99 $_allgText(loginMeterProj2)
	fillTODO 
	updateMeter 100 $_allgText(loginMeterDone) 
	foreach but $ToolBarButtons {
	    $but configure -state normal
	}
	activateGSlist
	update
	set eddLock 0
	set refreshEna 1 
	closeMeter
	update
	set geo [ split [wm geometry . ] +x ]
	set curWindowWidth [lindex $geo 0]
	set curWindowHeight [lindex $geo 1]
	bind . <Return>  dummy
	bind . <KP_Enter>  dummy
	bind . <Alt-q> {exitClient}
	bind . <Configure> {resizeMinkowsky }
	set logedIn 1
    } elseif {[lindex $ret 0] == "FATAL" } {
	FatalErrorDialog [string range $ret 13 end]
    } else {
	ErrorDialog $ret
	closeMeter
	tkwait window .err
	bind . <Return>  {doLogin}
	bind . <KP_Enter>  {doLogin}
	loginDialog - 1
    }
    update 
    stdCursor .
}

proc dummy { } {
#    puts "dummy"
}




proc getSizes { w h } { 
    global canWidth canHeight xmax ymax
    global canHeight  ymax gsHeight
    global GSwin gsWidth
    global todoCanWidth todoCanHeight  todoCanHeight2 todoWidth todoHeight todoHeight2 todoLegendWidth
    global gs_userHeight gs_groupHeight gs_roomHeight
    global adrWidth adrHeight adrSwidth adrSheight
    global osType


    if { $osType == "macintosh" } {
        incr w -32
        incr h -32
    }
     set gsWidth [expr  88 +int(floor(0.08 * $w)) ]
    set xmax  [expr  $w -$gsWidth -23]
    set canWidth $xmax
    

    set gsHeight [expr $h - 99 ]
    set canHeight [expr $h- 77 ]
    set ymax  [expr $h -78]
    set hl [ getGSsectionHeights $gsHeight]
    set gs_groupHeight [ lindex $hl 1]
    set gs_roomHeight [ lindex $hl 2]
    set gs_userHeight [ lindex $hl 0]

    set todoWidth  [ expr $w -$gsWidth -22 ]
    set todoHeight [ expr $h -104] 
    set todoHeight2 [ expr $h -104 -102] 
    set todoCanWidth  [expr $w -$gsWidth -36 ]
    set todoLegendWidth  $todoCanWidth
    if { $todoCanWidth <972 } {  set todoCanWidth  972}
    set todoCanHeight [ expr $h -125] 
    set todoCanHeight2 [ expr $h -125 -102] 
    set adrSwidth  [ expr $w -$gsWidth -24 ]
    set adrSheight [ expr $h -75 ]
    set adrWidth   [ expr $w -$gsWidth -31 ]
    if { $adrWidth < 968 } { set adrWidth 968}
    set adrHeight  [ expr $h -99 ] 






#     set [expr 125 +int(floor(0.05 * $w)) ]
#     set xmax  [expr  $w -207]
#     set canWidth $xmax
    

#     set gsHeight [expr $h - 99 ]
#     set canHeight [expr $h- 77 ]
#     set ymax  [expr $h -78]
#     set hl [ getGSsectionHeights $gsHeight]
#     set gs_groupHeight [ lindex $hl 1]
#     set gs_roomHeight [ lindex $hl 2]
#     set gs_userHeight [ lindex $hl 0]

#     set todoWidth  [ expr $w -202]
#     set todoHeight [ expr $h -104] 
#     set todoHeight2 [ expr $h -104 -82] 
#     set todoCanWidth  [expr $w-216] 
#     if { $todoCanWidth <972 } {  set todoCanWidth  972}
#     set todoCanHeight [ expr $h -125] 
#     set todoCanHeight2 [ expr $h -125 -82] 
#     set adrSwidth  [ expr $w -208]
#     set adrSheight [ expr $h -75 ]
#     set adrWidth   [ expr $w -215]
#     if { $adrWidth < 968 } { set adrWidth 968}
#     set adrHeight  [ expr $h -99 ] 




#     puts "todoHeight=$todoHeight todoCanHeight=$todoCanHeight"
#     puts "adrSheight=$adrSheight adrHeight=$adrHeight"
#     puts "adrSwidth=$adrSwidth   adrWidth=$adrWidth "
}





proc centerWin { win w h } {
    set masterGeo [ split [ wm geometry .] x+ ]
    set mdx [lindex $masterGeo 0 ]
    set mdy [lindex $masterGeo 1 ]
    set mx [lindex $masterGeo 2 ]
    set my [lindex $masterGeo 3 ]
    
    set x [expr $mx + $mdx/2 -$w/2 ]
    set y [expr $my + $mdy/2 -$h/2 ]
    
    set geo [format "%dx%d+%d+%d" $w $h  $x $y ]
    wm geometry $win $geo
    wm transient $win .
}

proc centerWin2 { win } {

    set masterGeo [ split [ wm geometry .] x+ ]
    set mdx [lindex $masterGeo 0 ]
    set mdy [lindex $masterGeo 1 ]
    set mx [lindex $masterGeo 2 ]
    set my [lindex $masterGeo 3 ]

    set w [ winfo reqwidth $win]
    set h [ winfo reqheight $win]
    
    set x [expr $mx + $mdx/2 -$w/2 ]
    set y [expr $my + $mdy/2 -$h/2 ]
#    puts "ReqGeo : $w x $h"
    
    set geo [format "%dx%d+%d+%d" $w $h  $x $y ]
#    wm geometry $win $geo
    wm transient $win .
    update
    
    set w [ winfo width $win]
    set h [ winfo height $win]
    set x [expr $mx + $mdx/2 -$w/2 ]
    set y [expr $my + $mdy/2 -$h/2 ]
#    puts "ReqGeo : $w x $h"
    
    set geo [format "%dx%d+%d+%d" $w $h  $x $y ]
    wm geometry $win $geo
    update
}

proc readUserPrefs { } {
    global up_defEinlPerm up_defTeilnPerm up_defInfoPerm up_defExtPerm username
    global up_beep up_signalCommand up_calPerm
    global uCalKernStart uCalKernEnd uGlobalSlotsD uGlobalSlotsW uGlobalSlotsM uGlobalSlotsWG can
    global up_displayIgnore up_displayInfo up_displayToolTips
    global up_remDate up_remEinl up_remTodo up_remMahn setList setListNames
    global upd_browserID upd_browserCmd

    set ret [ request getUserPrefs $username]
    if { [string first $ret "ServerDown"] >=0 } {ServerDownDialog}
    if { $ret == "Error" } { return }
    set grp [lindex $ret 0]
    set up_defEinlPerm  [lindex $grp 0]
    set up_defTeilnPerm [lindex $grp 1]
    set up_defInfoPerm  [lindex $grp 2]
    set up_defExtPerm   [lindex $grp 3]
    set up_beep           [lindex $ret 1]
    set up_signalCommand  [lindex $ret 2]
    set grp [lindex $ret 3]
    foreach ent $grp { 
	set group [lindex $ent 0]
	set up_calPerm($group) [lindex $ent 1]
    }
    if { [lindex $ret 4] != "" } {
	set calFormat  [lindex $ret 4]
	set uCalKernStart  [lindex $calFormat 0]
	set uCalKernEnd    [lindex $calFormat 1]
	set uGlobalSlotsD  [lindex $calFormat 2]
	set uGlobalSlotsW  [lindex $calFormat 3]
	set uGlobalSlotsM  [lindex $calFormat 4]
	set uGlobalSlotsWG [lindex $calFormat 5]
	$can delete all
	drawWeekGrid
    }
    set up_displayIgnore   [lindex $ret 5]
    set up_displayInfo     [lindex $ret 6]
    set up_displayToolTips [lindex $ret 7]
    set rem [lindex $ret 8]
	set up_remDate [lindex $rem 0]
    set up_remEinl [lindex $rem 1]
    set up_remTodo [lindex $rem 2]
    set up_remMahn [lindex $rem 3]
    set sList [lindex $ret 9]
    set setListNames ""
    foreach set $sList {
	set name [lindex $set 0]
	set setList($name) [lindex $set 1]
	lappend setListNames $name
    }
    set upd_browserID  [lindex $ret 10]
    set upd_browserCmd [lindex $ret 11]
}
proc writeUserPrefs { } {
    global up_defEinlPerm up_defTeilnPerm up_defInfoPerm up_defExtPerm username
    global up_beep up_signalCommand up_calPerm up_pwd
    global uCalKernStart uCalKernEnd uGlobalSlotsD uGlobalSlotsW uGlobalSlotsM uGlobalSlotsWG
    global up_displayIgnore up_displayInfo up_displayToolTips
    global up_remDate up_remEinl up_remTodo up_remMahn
    global password
    global upd_browserID upd_browserCmd


    set ret [transfer saveUserPrefs $username $up_defEinlPerm $up_defTeilnPerm $up_defInfoPerm $up_defExtPerm $up_beep "$up_signalCommand"  [array get up_calPerm] "$up_pwd" "$uCalKernStart $uCalKernEnd $uGlobalSlotsD $uGlobalSlotsW $uGlobalSlotsM $uGlobalSlotsWG" $up_displayIgnore $up_displayInfo $up_displayToolTips  "$up_remDate $up_remEinl $up_remTodo $up_remMahn" $upd_browserID $upd_browserCmd ]
    if { [string first $ret "ServerDown"] >=0 } {ServerDownDialog}

#    if { $ret == "Error" } { return }
#     if { [string first $ret "ServerDown"] >=0 } {ServerDownDialog}
#     if { [string range $ret 0 2] == "ERR" } {
# 	ErrorDialog $ret
#     } 

}


proc openMeter { titel msg doGrab} {
    global bfnt bfnt12  animImg fnt12
    global metStat
    global metLock
    
    update
    if { [winfo exists .met ] == 1 } { return }
    toplevel .met
    frame .met.t
    frame .met.m
    pack .met.t -side top -fill x
    pack .met.m -side top -fill x -padx 4

    button .met.t.b -image  [image create pixmap -data $animImg(0)] -bd 2
    pack .met.t.b -side top
    set metStat 0

    tixMeter .met.m.l -value 0 -text $msg   -width 140 -fillcolor DarkGoldenRod1 -relief raised -bd 2
#    label .met.m.l -text $msg -font $fnt12 -justify center -anchor n
    pack .met.m.l -side top
    wm title .met $titel
    centerWin .met 140 164
    update
    set metGrab 0
    if {$doGrab} { 
	grab .met
	set metLock 1
    } 
#else { unLock}
}
proc updateMeter {val msg} {
    global metStat animImg
    .met.m.l  configure -text "$msg  "
    set stat [expr int(floor($val*12.5/100+.05))]
    for {set i $metStat} { $i <$stat } {incr i} {
	set v [expr double($stat*8) /100.]
	.met.m.l configure -value $v
	.met.t.b configure -image  [image create pixmap -data $animImg($i)]
	update
	after  50
    }
    .met.m.l configure -value [expr double($val) /100.]
    set metStat $stat
    update
}
proc closeMeter {} {
    global  animImg metLock
    .met.t.b configure -image  [image create pixmap -data $animImg(12)]
    update
    after 250
    closeWin .met
    #     if { $metLock == 1} { unLock}
}


proc closeWin { win} {
#    doLock
    destroy $win
    update
    redrawMainCanvas
#    unLock
}
proc exitClient { } {
    closeApp
    after 500
    exit
}

proc aboutMinkowsky { } {
    global fnt bfnt progname hbfnt lfnt  lbfnt minkoIcon128 bfnt12 fnt10 fnt12 bfnt10
    global minkoVersion minkoRelDate _allgText _buttonText

    if { [winfo exists .ab ] == 1 } { return }
    toplevel .ab
    wm title .ab "$_allgText(wmTitelAbout) $progname"
    frame .ab.t -relief raised -bd 1
    frame .ab.d -relief raised -bd 1
    frame .ab.b -relief flat

    pack .ab.t .ab.d -side top -fill x -expand 1
    pack .ab.b -side top -fill x -pady 2

    frame .ab.t.l 
    frame .ab.t.r 
    pack .ab.t.l  -side left -fill both
    pack  .ab.t.r -side left -fill both -padx 4 -pady 4 -expand 1
    
    button .ab.t.l.b -image  [image create pixmap -data $minkoIcon128]
    pack .ab.t.l.b
    
    label .ab.t.r.1 -text [string toupper $progname ] -justify center -font $hbfnt  -anchor n 
    if {[font measure $lbfnt $_allgText(AboutMinkoFunc)] <200 } {
	label .ab.t.r.2 -text $_allgText(AboutMinkoFunc) -justify center -font $lbfnt  -anchor n
	label .ab.t.r.3 -text "" -justify left -font $bfnt12 -anchor nw
    } else {
	frame .ab.t.r.2
	frame .ab.t.r.3
	set p [string first "-" $_allgText(AboutMinkoFunc)]
	if { $p<0 } {	set p [string first " " $_allgText(AboutMinkoFunc)] }
	label .ab.t.r.2.l -text [string range $_allgText(AboutMinkoFunc) 0 $p] -justify center -font $lbfnt  -anchor n
	incr p 
	label .ab.t.r.3.r -text [string range $_allgText(AboutMinkoFunc) $p end] -justify center -font $lbfnt  -anchor n
	pack .ab.t.r.2.l -side left
	pack .ab.t.r.3.r -side right
    }
    label .ab.t.r.4 -text "(c) 2000/2001 R\"udiger Goetz" -justify left -font $bfnt12 -anchor nw 
#    label .ab.t.r.5 -text "(c) 2001/2002 by R. Goetz" -justify right -font $fnt12 -anchor ne -relief ridge -bd 2
    
    for {set i 1} {$i<4} {incr i } {
	pack .ab.t.r.$i -side top -fill x
    }
    pack .ab.t.r.$i -side top -fill x -pady 3

    frame .ab.t.r.6 
    frame .ab.t.r.7 
    label .ab.t.r.6.l -text "$_allgText(AboutVersion) $minkoVersion" -justify left -font $fnt12 -anchor nw
    label .ab.t.r.7.r -text "   $_allgText(AboutVom)  $minkoRelDate" -justify left -font $fnt12 -anchor nw
    pack .ab.t.r.7 .ab.t.r.6 -side bottom -fill x
    pack .ab.t.r.6.l -side left
    pack .ab.t.r.7.r -side right

    label .ab.d.t -text $_allgText(specialThanks) -font $bfnt  -anchor nw 
    label .ab.d.1 -text "     Stefan Kamphausen, Nils Hltge" -font $fnt -anchor nw 
    label .ab.d.2 -text "     " -font $fnt -anchor nw 
    label .ab.d.3 -text "     " -font $fnt -anchor nw 
    pack  .ab.d.t -side top -fill x -pady 4
    pack  .ab.d.t .ab.d.1 .ab.d.2 .ab.d.3 -side top -fill x

    button .ab.b.ok -text $_buttonText(Close) -command { closeWin .ab}
    pack .ab.b.ok -side right
    
    centerWin .ab 348 254
    update 
    puts [wm geometry .ab]
    grab .ab
}

proc aboutThanks { } {
    
}

proc getPrinterList { } {
    global printerList stdPrinter env printerFullNames
    set fid [open "/etc/printcap" ]
    
    set capList ""
    set c [gets $fid line]
    set store 1
    while {! [eof $fid] } {
	if { $c > 0} {
	    set line [string trim $line]
	    set sc [string range  $line 0 0]
	    if { $sc != "\#" && $sc !=":" } {
		set p [ string first ":" $line ]
		if { $p>0} {
		    incr p -1
		    lappend capList [string range $line 0 $p]
		} else {
		    lappend capList $line
		}
	    }
	}
	set c [gets $fid line]
    }
#    puts "CapList: $capList"
    set printerList ""
    set i 0
    set stdPrinter 0
    set defPrinter ""
    set myPr ""
    catch { set myPr $env(PRINTER)}
    if { [ string length $myPr ] > 0 } { set defPrinter $myPr}

    set stdPrinter -1
    set stdPr -1
    foreach line $capList {
	set prl [split $line | ]
	set pr [ lindex $prl  0]

	if { [lsearch $printerList $pr] >=0 } {
	    warnAboutPrintCap $pr
	} else {
	    if { [ lsearch $prl $defPrinter] >=0 } {
		set stdPrinter $i
	    }
	    if { [ lsearch $prl "lp"] >=0 } {
		set stdPr $i
	    }
	    lappend printerList $pr
	    set printerFullNames($pr) [lindex $prl end]
	    incr i
	}
    }
    if { $stdPrinter < 0} {
	if { $stdPr>=0 } {
	    set stdPrinter $stdPr
	}
    }
    if { $stdPrinter < 0} {
	set stdPrinter 0
    }
}

proc warnAboutPrintCap { pr } {
    global bfnt fnt  _allgText _buttonText progname


    update 
    after 100
    if { [winfo exists .prw ] == 1 } { return }
    toplevel .prw
    
    frame .prw.t -relief raised -bd 1
    frame .prw.b 
    pack .prw.t .prw.b -side top -fill x -expand 1

    label .prw.t.l -text "$_allgText(Warn):" -fg red2 -font $bfnt
    message .prw.t.m -text "$_allgText(PrintCapWarn1) $pr $_allgText(PrintCapWarn2) $progname $_allgText(PrintCapWarn3)" -font $fnt -width 240
    pack .prw.t.l  .prw.t.m  -side top -fill x
    button .prw.b.ok -text "  $_buttonText(OK)  " -command {destroy .prw}
    pack .prw.b.ok -side right
    wm title .prw $_allgText(WARN)
    centerWin .prw 250 140
    update
   # puts [wm geometry .prw]
    tkwait window .prw
}
proc checkAutoStartMRR { } {
    global env TclBinPath osType

    if { $osType == "macintosh" } {
    } else {
    set HomeDir $env(HOME)

    #KDE1
    set file(KDE1) "$HomeDir/Desktop/Autostart/mrr.kdelnk"
    set file(KDE2) "$HomeDir/.kde2/Autostart/startMrr.sh"
    set sourceFile(KDE1) "$TclBinPath/mrr.kdelnk"
    set sourceFile(KDE2) "$TclBinPath/startMrr.sh"

    set Enivronments "KDE1 KDE2"
    foreach envi $Enivronments {
	set dir [file dirname $file($envi)]
#	puts "$envi -> $dir"
	if {! [file exists $dir] } { 
#	    puts "creating $dir"
	    exec mkdirhier $dir
	}
#	puts "$dir -> [file isdirectory $dir ]"
	if { [file isdirectory $dir ] } {
#	    puts "$file($envi) ---> [file exists $file($envi)]"
	    if { [file exists $file($envi)] == 0 } {
#		puts "copying"
		file copy -force $sourceFile($envi) $file($envi)
	    }
	}
    }
    }
}

proc busyCursor wins  {
    foreach win [concat  . $wins ] {
	$win configure -cursor watch
    }
}
proc stdCursor wins  {
    foreach win [concat  . $wins ] {
	$win configure -cursor ""
    }
}

set TclBinPath [getBinPath]
source $TclBinPath/utils.tcl
source $TclBinPath/add.tcl
source $TclBinPath/viewDate.tcl
source $TclBinPath/wochenView.tcl
source $TclBinPath/prefs.tcl
source $TclBinPath/addresss.tcl
source $TclBinPath/todo.tcl
source $TclBinPath/images.tcl
source $TclBinPath/help.tcl
source $TclBinPath/html.tcl
source $TclBinPath/anim.tcl
source $TclBinPath/cal.tcl
source $TclBinPath/printCal.tcl
source $TclBinPath/printAdr.tcl
source $TclBinPath/groupSel.tcl
source $TclBinPath/version.tcl
source $TclBinPath/notiz.tcl
source $TclBinPath/lang.tcl

getMinkoVersion
#puts "osType=$osType"


set langType ""
set anz  [llength $argv]
#puts  "argc=$anz argv='$argv'"
set prefUser "-"
set lastArg [expr $anz -1]
for {set i 0 } { $i < $anz} { incr i } {
    set arg [lindex $argv $i]
    if { [string range $arg 0 0] == "-" } {
	if { $arg == "-mrr" } {
	    checkAutoStartMRR
	} elseif  { $arg == "-lang" } {
	    incr i
	    set langType [lindex $argv $i]
	}
    } else {
	set prefUser [lindex $argv 0]
    } 
}


getLanguageSettings


set toolSelection K
set calTyp "w"


set day 1
set mon 0
set year 2001

set day [string trimleft [exec date +%d] 0 ]
set mon [string trimleft [exec date +%m] 0 ]
set year [exec date +%Y]
set tday $day
set tmon $mon
set tyear $year
set curOffset [exec date +%w]
set curOffset [expr ($curOffset+6) % 7]
set uCalKernStart 7
set uCalKernEnd 20
set uGlobalSlotsD 3
set uGlobalSlotsW 3
set uGlobalSlotsWG 2
set uGlobalSlotsM 3
set up_displayIgnore   0
set up_displayInfo     1
set up_displayToolTips 1
set pw_partLines 99
set pw_ignoInit 0
set printModeCal w

set adrLoadFirst 1

set dlist [calcDate $day $mon $year [expr -1 *$curOffset ] ]
set day  [lindex $dlist 0]
set mon  [lindex $dlist 1]
set year [lindex $dlist 2]
set curDay    $day
set curMon    $mon
set curYear   $year
set thisWeekStartD $day
set thisWeekStartM $mon
set thisWeekStartY $year
#set curOffset 0

#incr day [expr -1 *$wdOffset ]
#set wdOffset 0
set lastListUpdate 0
set lastMembrUpdate 0
set showIgnore 0
set ignoreInfo 0
set showUsersInGroupCal 0
set curTimeMark ""
set calTyp w
set groupOnlyCommon 0
set groupByUsers 0
set sdDialogRunning 0
set refreshEna 0
set isLock 0
set lastRefresh 0
set holidayMonth ""
set GSactiv 0
set delayDateToolTip_id -1
set delayDateToolTip_block 0
set logedIn 0
set up_pwd ""
#set calSplitHour 25
initPartStatus
initTODO


set pbfnt6 -*-lucidatypewriter-medium-r-*-*-6-*-*-*-*-*-*-*
set bpfnt6 -*-lucidatypewriter-medium-r-*-*-6-*-*-*-*-*-*-*
set pfnt6 -*-lucidatypewriter-medium-r-normal-sans-6-*-*-*-*-*-*-*
set fnt6  -*-helvetica-medium-r-*-*-6-*-*-*-*-*-*-*
set bfnt6 -*-helvetica-bold-r-*-*-6-*-*-*-*-*-*-*
set ifnt6 -*-helvetica-medium-o-*-*-6*-*-*-*-*-*-*
set bifnt6 -*-helvetica-bold-o-*-*-6*-*-*-*-*-*-*

set fnt7 -*-helvetica-medium-r-*-*-7-*-*-*-*-*-*-*

set pbfnt8 -*-lucidatypewriter-medium-r-*-*-8-*-*-*-*-*-*-*
set bpfnt8 -*-lucidatypewriter-medium-r-*-*-8-*-*-*-*-*-*-*
set pfnt8 -*-lucidatypewriter-medium-r-normal-sans-8-*-*-*-*-*-*-*
set fnt8  -*-helvetica-medium-r-*-*-8-*-*-*-*-*-*-*
set bfnt8 -*-helvetica-bold-r-*-*-8-*-*-*-*-*-*-*
set ifnt8 -*-helvetica-medium-o-*-*-8-*-*-*-*-*-*-*
set bifnt8 -*-helvetica-bold-o-*-*-8-*-*-*-*-*-*-*

set pbfnt9 -*-lucidatypewriter-medium-r-*-*-9-*-*-*-*-*-*-*
set bpfnt9 -*-lucidatypewriter-medium-r-*-*-9-*-*-*-*-*-*-*
set pfnt9 -*-lucidatypewriter-medium-r-normal-sans-9-*-*-*-*-*-*-*
set fnt9  -*-helvetica-medium-r-*-*-9-*-*-*-*-*-*-*
set bfnt9 -*-helvetica-bold-r-*-*-9-*-*-*-*-*-*-*
set ifnt9 -*-helvetica-medium-o-*-*-9-*-*-*-*-*-*-*
set bifnt9 -*-helvetica-bold-o-*-*-9-*-*-*-*-*-*-*


set pbfnt10 -*-lucidatypewriter-medium-r-*-*-10-*-*-*-*-*-*-*
set bpfnt10 -*-lucidatypewriter-medium-r-*-*-10-*-*-*-*-*-*-*
set pfnt10 -*-lucidatypewriter-medium-r-normal-sans-10-*-*-*-*-*-*-*
set fnt10  -*-helvetica-medium-r-*-*-10-*-*-*-*-*-*-*
set bfnt10 -*-helvetica-bold-r-*-*-10-*-*-*-*-*-*-*
set ifnt10 -*-helvetica-medium-o-*-*-14-*-*-*-*-*-*-*
set bifnt10  -*-helvetica-bold-o-*-*-14-*-*-*-*-*-*-*

set pbfnt11 -*-lucidatypewriter-medium-r-*-*-11-*-*-*-*-*-*-*
set bpfnt11 -*-lucidatypewriter-medium-r-*-*-11-*-*-*-*-*-*-*
set pfnt11 -*-lucidatypewriter-medium-r-normal-sans-11-*-*-*-*-*-*-*
set fnt11  -*-helvetica-medium-r-*-*-11-*-*-*-*-*-*-*
set bfnt11 -*-helvetica-bold-r-*-*-11-*-*-*-*-*-*-*
set ifnt11 -*-helvetica-medium-o-*-*-11-*-*-*-*-*-*-*
set bifnt11  -*-helvetica-bold-o-*-*-11-*-*-*-*-*-*-*

set pbfnt12 -*-lucidatypewriter-medium-r-*-*-12-*-*-*-*-*-*-*
set bpfnt12 -*-lucidatypewriter-medium-r-*-*-12-*-*-*-*-*-*-*
set pfnt12 -*-lucidatypewriter-medium-r-normal-sans-12-*-*-*-*-*-*-*
set fnt12  -*-helvetica-medium-r-*-*-12-*-*-*-*-*-*-*
set bfnt12 -*-helvetica-bold-r-*-*-12-*-*-*-*-*-*-*
set ifnt12  -*-helvetica-medium-o-*-*-12-*-*-*-*-*-*-*
set bifnt12  -*-helvetica-bold-o-*-*-12-*-*-*-*-*-*-*


set pbfnt -*-lucidatypewriter-medium-r-*-*-14-*-*-*-*-*-*-*
set bpfnt -*-lucidatypewriter-medium-r-*-*-14-*-*-*-*-*-*-*
set pfnt -*-lucidatypewriter-medium-r-normal-sans-14-*-*-*-*-*-*-*
set fnt  -*-helvetica-medium-r-*-*-14-*-*-*-*-*-*-*
set ifnt  -*-helvetica-medium-o-*-*-14-*-*-*-*-*-*-*
set bifnt  -*-helvetica-bold-o-*-*-14-*-*-*-*-*-*-*
set bfnt -*-helvetica-bold-r-*-*-14-*-*-*-*-*-*-*
set bifnt -*-helvetica-bold-o-*-*-14-*-*-*-*-*-*-*

set pbfnt16 -*-lucidatypewriter-medium-r-*-*-16-*-*-*-*-*-*-*
set bpfnt16 -*-lucidatypewriter-medium-r-*-*-16-*-*-*-*-*-*-*
set pfnt16 -*-lucidatypewriter-medium-r-normal-sans-16-*-*-*-*-*-*-*
set fnt16  -*-helvetica-medium-r-*-*-16-*-*-*-*-*-*-*
set bfnt16 -*-helvetica-bold-r-*-*-16-*-*-*-*-*-*-*
set ifnt16 -*-helvetica-medium-o-*-*-16-*-*-*-*-*-*-*
set bifnt16  -*-helvetica-bold-o-*-*-16-*-*-*-*-*-*-*

set sbfnt -*-helvetica-bold-r-*-*-11-*-*-*-*-*-*-*
set wpfnt -*-fixed-medium-r-*-*-10-*-*-*-*-*-*-*

set pbfnt18 -*-lucidatypewriter-medium-r-*-*-18-*-*-*-*-*-*-*
set bpfnt18 -*-lucidatypewriter-medium-r-*-*-18-*-*-*-*-*-*-*
set pfnt18 -*-lucidatypewriter-medium-r-normal-sans-18-*-*-*-*-*-*-*
set fnt18  -*-helvetica-medium-r-*-*-18-*-*-*-*-*-*-*
set bfnt18 -*-helvetica-bold-r-*-*-18-*-*-*-*-*-*-*
set ifnt18 -*-helvetica-medium-o-*-*-18-*-*-*-*-*-*-*
set bifnt18  -*-helvetica-bold-o-*-*-18-*-*-*-*-*-*-*

set lfnt -*-helvetica-medium-r-*-*-18-*-*-*-*-*-*-*
set lbfnt -*-helvetica-bold-r-*-*-18-*-*-*-*-*-*-*
set hbfnt -*-helvetica-bold-r-*-*-24-*-*-*-*-*-*-*

 
set eddLock 1
initIcons
set lastProjTodoChange 0


wm title . $longProgName

frame .t -relief raised -bd 1 -width 840
frame .n
pack .t .n -side top -fill both -expand 1

. configure -cursor watch

#Ballonhelp 

set ballon .t.bal
tixBalloon $ballon  -initwait 2000 -state balloon


#Toolbar
set ToolBarButtons ""
frame .t.t 
pack .t.t  -side top -fill x -expand 1 
button .t.t.q  -image [image create pixmap -data $quitIcon] -command exitClient -state disabled
lappend ToolBarButtons .t.t.q
pack .t.t.q  -side left  -fill y
$ballon bind .t.t.q -balloonmsg "$_ballonText(MainExit) $progname"

#Diese Label wird zum grabben gebraucht
label .t.t.s0 -text " " -width 2  
pack .t.t.s0 -side left

button .t.t.rl -image [image create pixmap -data $reloadIcon ] -command { drawNewView } -state disabled
pack .t.t.rl -side left -fill y -padx 1
lappend ToolBarButtons .t.t.rl
$ballon bind .t.t.rl -balloonmsg $_ballonText(MainCalReload)

button .t.t.ho -image [image create pixmap -data $jumpHomeIcon] -command {jumpHome} -state disabled
lappend ToolBarButtons .t.t.ho
pack .t.t.ho -side left  -fill y -padx 1
$ballon bind .t.t.ho -balloonmsg $_ballonText(MainHome)


button .t.t.pr -image [image create pixmap -data $printerIcon ]  -command printDialog -state disabled
pack .t.t.pr -side left -fill y -padx 1
lappend ToolBarButtons .t.t.pr
$ballon bind .t.t.pr -balloonmsg $_ballonText(MainCalPrint)

label .t.t.s0a -text " " -width 2
pack .t.t.s0a -side left

button .t.t.n  -image [image create pixmap -data $newIcon] -command {createNewItem } -state disabled
lappend ToolBarButtons .t.t.n
pack .t.t.n  -side left  -fill y -padx 1
$ballon bind .t.t.n -balloonmsg $_ballonText(MainCalNew)

frame .t.t.c -relief   flat -bd 0
pack .t.t.c -side left -fill x


frame .t.t.c.k -relief flat -bd 0
frame .t.t.c.a -relief flat -bd 0
frame .t.t.c.t -relief flat -bd 0
pack .t.t.c.k .t.t.c.a .t.t.c.t -side left -fill x

label .t.t.c.k.s1 -text " " -width 2
pack .t.t.c.k.s1 -side left

#Buttons im Kalender Toolbar
button .t.t.c.k.tv -image [image create pixmap -data $dayCalIcon] -command {switch2CalTyp d} -state disabled
button .t.t.c.k.wv -image [image create pixmap -data $weekCalIcon] -command {switch2CalTyp w} -state disabled
button .t.t.c.k.mv -image [image create pixmap -data $monthCalIcon] -command {switch2CalTyp m} -state disabled
lappend ToolBarButtons .t.t.c.k.tv .t.t.c.k.wv .t.t.c.k.mv
pack .t.t.c.k.tv .t.t.c.k.wv .t.t.c.k.mv  -side left 
$ballon bind .t.t.c.k.tv -balloonmsg $_ballonText(MainCalDay)
$ballon bind .t.t.c.k.wv -balloonmsg $_ballonText(MainCalWeek)
$ballon bind .t.t.c.k.mv -balloonmsg $_ballonText(MainCalMonth)

label .t.t.c.k.s2 -text " " -width 2
pack .t.t.c.k.s2 -side left


button .t.t.c.k.gh -image [image create pixmap -data $goHomeIcon] -command {jump2Today} -state disabled
button .t.t.c.k.jt -image [image create pixmap -data $jumpIcon] -command {jump2DateDialog} -state disabled
lappend ToolBarButtons .t.t.c.k.gh .t.t.c.k.jt
pack .t.t.c.k.gh .t.t.c.k.jt -side left -padx 1
$ballon bind .t.t.c.k.gh  -balloonmsg $_ballonText(MainCalToday)
$ballon bind .t.t.c.k.jt  -balloonmsg $_ballonText(MainCalNavigator)



label .t.t.c.k.s2b -text " " -width 2
pack .t.t.c.k.s2b -side left

button .t.t.c.k.ii -image [image create pixmap -data $ignoreInfoIcon_in]  -state disabled -command {
    set ignoreInfo [ expr $ignoreInfo ^ 1]
    if { $ignoreInfo == 1} {
	.t.t.c.k.ii configure -image [image create pixmap -data $ignoreInfoIcon_out]
    } else {
	.t.t.c.k.ii configure -image [image create pixmap -data $ignoreInfoIcon_in]
    }
    drawCal
}
button .t.t.c.k.ig -image [image create pixmap -data $ignoreIcon_out] -state disabled -command {
    set showIgnore [ expr $showIgnore ^ 1]
    if { $showIgnore == 0 } {
	.t.t.c.k.ig configure -image [image create pixmap -data $ignoreIcon_out]
    } else {
	.t.t.c.k.ig configure -image [image create pixmap -data $ignoreIcon_in]
    }
    drawCal
}
button .t.t.c.k.mc -image [image create pixmap -data $multiUserGroupCalIcon_out] -state disabled  -command {
    set groupByUsers [ expr $groupByUsers ^ 1]
    if { $groupByUsers == 0 } {
	.t.t.c.k.mc configure -image [image create pixmap -data $multiUserGroupCalIcon_out]
    } else {
	.t.t.c.k.mc configure -image [image create pixmap -data $multiUserGroupCalIcon_in]
    }
    if { [llength $cur_Cal] >1 || [string range [lindex $cur_Cal 0] 0 0 ] == "g" } { drawCal }
}
lappend ToolBarButtons .t.t.c.k.ii .t.t.c.k.ig  .t.t.c.k.mc
pack .t.t.c.k.ii .t.t.c.k.ig  .t.t.c.k.mc  -side left 

$ballon bind .t.t.c.k.ii -balloonmsg $_ballonText(MainCalSwitchInfo)
$ballon bind .t.t.c.k.ig -balloonmsg $_ballonText(MainCalSwitchIgnore)
$ballon bind .t.t.c.k.mc -balloonmsg $_ballonText(MainCalSwitchGroup)

pack forget .t.t.c.k

#Buttons im Projecttoolsbar

button .t.t.c.t.np  -image [image create pixmap -data $newProjIcon] -state disabled -command {
    if { $toolSelection == "T" } {newProj }
}
lappend ToolBarButtons .t.t.c.t.np
pack .t.t.c.t.np -side left -padx 1
$ballon bind .t.t.c.t.np -balloonmsg $_ballonText(MainProjNewProj)
pack forget .t.t.c.t

#Buttons im Address-Toolbar
button .t.t.c.a.af  -image [image create pixmap -data $adrFolderIcon] -state disabled -command {
    if { $toolSelection == "A" } {makeAdrFolderDialog }
}
button .t.t.c.a.fil -image [image create pixmap -data $adrFilterIcon] -state disabled -command {
    if { $toolSelection == "A" } {drawAdrFilterDialog }
}
lappend ToolBarButtons .t.t.c.a.af .t.t.c.a.fil 
pack .t.t.c.a.af -side left -padx 1
pack .t.t.c.a.fil -side left -padx 8
$ballon bind .t.t.c.a.af -balloonmsg $_ballonText(MainAdrNewFolder)
$ballon bind .t.t.c.a.fil -balloonmsg $_ballonText(MainAdrFilter)
pack forget .t.t.c.a





label .t.t.sr -text " " -width 2

button .t.t.up -image [image create pixmap -data $userPrefsIcon] -state disabled  -command {drawPrefsDialog}
button .t.t.ttt -image [image create pixmap -data $minkoIcon24] -state disabled -command aboutMinkowsky
button .t.t.h -image [image create pixmap -data $helpIcon]  -state disabled -command { 
    set docBasePath "$TclBinPath/../html"
    displayHelp 
}

lappend ToolBarButtons .t.t.ttt .t.t.h  .t.t.up
pack .t.t.ttt .t.t.h -side right -fill y
pack .t.t.up -side right -padx 12 -fill y


$ballon bind .t.t.up -balloonmsg $_ballonText(MainPrefs)
$ballon bind .t.t.ttt -balloonmsg "$_ballonText(MainAbout) $progname"
$ballon bind .t.t.h -balloonmsg $_ballonText(MainHelp)


#Notebook
tixNoteBook .n.nb -ipadx 2 -ipady 2 -dynamicgeometry 0
frame  .n.gs -relief flat -bd 1

 .n.nb add kalender -label " $_allgText(PageKal)  " -underline -1 
 .n.nb add todo -label " $_allgText(PageTodo)  " -underline -1 -state normal
 .n.nb add addressen -label "$_allgText(PageAdr)  " -underline -1 
pack .n.nb .n.gs -side left -fill both -expand 1

set kalWin [ .n.nb subwidget kalender]
set todWin [ .n.nb subwidget todo]
set adrWin [ .n.nb subwidget addressen]

frame $kalWin.c -relief ridge
pack $kalWin.c  -side top -fill both -expand 1

set rootWidth  [lindex [wm maxsize .] 0]
set rootHeight [lindex [wm maxsize .] 1]
set todoLegendOpen 0




set windWidth  1183
set windHeight 837
set scroll ""
set yScrollOn 0
if  { $windHeight > $rootHeight} { set windHeight $rootHeight }
if  { $windWidth  > $rootWidth } { set windWidth  $rootWidth  }
#puts "$rootWidth $rootHeight -> $windWidth $windHeight"
getSizes $windWidth $windHeight


if {[ string first $scroll "y"] >=0 } {
#    set xmax [expr $xmax -16]
}
    
if {$scroll == ""} {set scroll "none" }


groupSelector .n.gs $gsHeight
tixCObjView $kalWin.c.can -width $canWidth -height $canHeight -scrollbar $scroll
$kalWin.c.can subwidget vsb configure -width 12
$kalWin.c.can subwidget hsb configure -width 12

pack $kalWin.c.can -fill both  -expand 1
set can [ $kalWin.c.can subwidget canvas]
set canParent $kalWin.c.can


# $ballon bind $can -balloonmsg "Die Kalenderbersicht:
# * Durch klick auf eine freie Flche wird eine neuer Termin angelegt
# * Durch Klick auf einen Termin kann dieser detailiert betrachtet oder 
#   gendert werden
# * Nache einem  Rechtklich auf einen Termin wird man die Kuzrbersicht 
#   eines Termins angezeigt. Hier kann ein Termin auch gelscht werden.
# * Mit den Tasten link und rechts oben in der Kalenderbersicht kann 
#   der Kalender um einen Tage oder eine Woche vor oder zurckgeschoben 
#   werden."

set calDrawn 0
set today [format "%4d%02d%02d" $tyear $tmon $tday]


wm resizable . 0 0 



#set cputype $env(CPUTYPE)
getPrinterList
drawWeekGrid 
update
setTagList 1 [llength $gridTagKOList] [join $gridTagKOList]
drawAddress
drawToDo 
initAdrPrint


animImages
drawCurrentTime
pack .t.t.c.k
update
#puts "start Login"
loginDialog $prefUser 0
set _geo [split [wm geometry .] +x ]
set extWindowWidth [lindex $_geo 0]
set extWindowHeight [lindex $_geo 1]


.n.nb pageconfigure kalender -raisecmd {
     update
    busyCursor .
    set toolSelection K
    pack forget .t.t.c.a
    pack forget .t.t.c.t
    pack .t.t.c.k
    $ballon unbind .t.t.n 
    $ballon unbind .t.t.rl 
    $ballon unbind .t.t.pr
    $ballon unbind $GSwin.t.l
    $ballon bind .t.t.n  -balloonmsg $_ballonText(MainCalNew)
    $ballon bind .t.t.pr -balloonmsg $_ballonText(MainCalPrint)
    $ballon bind .t.t.rl -balloonmsg $_ballonText(MainCalReload)
    $ballon bind $GSwin.t.l   -balloonmsg $_ballonText(GS_TitelCal)
    resetGSselection
    update
    stdCursor  .
}
.n.nb pageconfigure todo  -raisecmd {
     update
    busyCursor .
    set toolSelection T
    pack forget .t.t.c.k
    pack forget .t.t.c.a
    pack .t.t.c.t
    $ballon unbind .t.t.n 
    $ballon unbind .t.t.rl 
    $ballon unbind .t.t.pr
    $ballon unbind $GSwin.t.l
    $ballon bind .t.t.n  -balloonmsg $_ballonText(MainProjNew)
    $ballon bind .t.t.pr -balloonmsg $_ballonText(MainProjPrint)
    $ballon bind .t.t.rl -balloonmsg $_ballonText(MainProjReload)
    $ballon bind $GSwin.t.l   -balloonmsg $_ballonText(GS_TitelProj)
    resetGSselection
    update
    stdCursor .
}
.n.nb pageconfigure addressen  -raisecmd {
     update
    busyCursor .
    set toolSelection A
    pack forget .t.t.c.k
    pack forget .t.t.c.t
    pack .t.t.c.a
    update
    $ballon unbind .t.t.n 
    $ballon unbind .t.t.rl
    $ballon unbind .t.t.pr
    $ballon bind .t.t.n  -balloonmsg $_ballonText(MainAdrNew)
    $ballon bind .t.t.pr -balloonmsg $_ballonText(MainAdrPrint)
    $ballon bind .t.t.rl -balloonmsg $_ballonText(MainAdrReload)
    focus $adro_list
    update
    resetGSselection
    update
    stdCursor .
}


wm resizable . 1 1 
wm minsize . 828 592




. configure -cursor ""

proc resizeMinkowsky { } {
    global resizeCHG
    global configX configY
    
    bind . <Configure> dummy
    set m [mouseStatus]
#    puts "CHECK Resize $m"
    set resizeCHG 0
    doResize
    while { [expr $m  & 256] == 256} {
#	puts "resize Frames"
	doResize
#	puts "resize Frames done"
 	after 50
 	set m [mouseStatus]
#	puts "CHECK Mouse $m"
 	update
    }
    if { $resizeCHG==1} {
	doResize
	update
	#    puts "redraw canvas"
	drawNewView
	update
    }
    #    puts "reactivate Resize"
    after 500 {	bind . <Configure> {resizeMinkowsky } }
}
proc doResize { } {
    global kalWin canWidth windWidth xmax
    global canHeight windHeighh ymax gsHeight
    global extWindowWidth extWindowHeight GSwin
    global todWin todoWin adro_list adrWin
    global todoCanWidth todoCanHeight  todoCanHeight2 todoWidth todoHeight todoHeight2 todoLegendWidth
    global adrWidth adrHeight adrSwidth adrSheight
    global gs_userHeight gs_groupHeight gs_roomHeight gsWidth
    global todoLegendOpen
    global curWindowWidth curWindowHeight
    global toolSelection
    global resizeCHG
#    global resizeID 

    switch $toolSelection {
	K {.n.nb raise kalender}
	T {.n.nb raise todo}
	A {.n.nb raise addressen}
    }

    set geo [split [wm geometry .] +x ]
    set w [lindex $geo 0]
    set h [lindex $geo 1]

#    puts "\t\tresizing frames\n"

    if { [ expr abs($w - $curWindowWidth)] >1  || [ expr abs($h - $curWindowHeight)] >1 } {
	set resizeCHG 1
	getSizes $w $h
#	puts "\t\tresize Frames : $curWindowWidth -> $w  x  $curWindowHeight -> $h"
	set curWindowWidth $w
	set curWindowHeight $h
	
	$kalWin.c.can configure -width $canWidth
	$kalWin.c.can configure -height $canHeight
#	puts "1"
	if {$todoLegendOpen == 1} {
	    $todoWin.l configure -width $todoCanWidth  -height $todoCanHeight2
	    $todWin.l.s configure -width $todoWidth  -height $todoHeight2
	} else {
	    $todoWin.l configure -width $todoCanWidth  -height $todoCanHeight 
	    $todWin.l.s configure -width $todoWidth  -height $todoHeight  
	}
	$todWin.e.sw configure -width $todoLegendWidth
#	puts "todoCanWidth : $todoCanWidth"
#	puts "2"
	$adrWin.l configure -height $adrSheight -width $adrSwidth
#	$adro_list configure -height $adrHeight -width $adrWidth
	$GSwin.ul.s configure -height $gs_userHeight -width $gsWidth
	$GSwin.gl.s configure -height $gs_groupHeight -width $gsWidth 
	$GSwin.rl.s configure -height $gs_roomHeight -width $gsWidth 
	puts "3"
	update idletasks
#	puts "4"

	set geo [split [wm geometry .] +x ]
	puts "5"
	set w [lindex $geo 0]
	set h [lindex $geo 1]
#	puts "\t\tFrames resized to $w $h "
    } 

}

proc stdBindings { winList} { 
    foreach win $winList {
	bind . <Alt-q> {exitClient}
	bind . <Alt-p> {printDialog}
	bind . <Alt-r> {drawNewView}
    }

}

