#!/usr/bin/X11/tixwish
#  File: notiz.tcl
# 
#      This file is part of minkowsky
# 
#      Copyright (C) 2001-2002 by Rdiger Goetz
#      Author: Rdiger Goetz <minkowsky@r-goetz.de>
# 
#      Time-stamp: <26-May-2002 12:13:35 goetz>
# 
#      This program is free software; you can redistribute it and/or modify
#      it under the terms of the GNU General Public License as published by
#      the Free Software Foundation; either version 2 of the License, or
#      (at your option) any later version.
# 
#      This program is distributed in the hope that it will be useful,
#      but WITHOUT ANY WARRANTY; without even the implied warranty of
#      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#      GNU General Public License for more details.
# 
#      You should have received a copy of the GNU General Public License
#      along with this program; if not, write to the Free Software
#      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#  
#!/usr/X11R6/bin/tixwish

proc initNotiz { } {
    global notizRW notiz
    set nidList [lsort [array names notiz ]]
    foreach nid $nidList {
	set notizRW($nid) "R"
    }
}
proc drawNotizBlock {win  width height  adrIdList perm} {
    global fnt fnt12
    global notiz notizChildAnz notizChildList notizAnz notizDone
    global notizPrintIcon notizEmailIcon notizNewIcon notizStdCursor notizROIcon notizRWIcon notizUndoIcon
    global  notizTreeIcon notizLinearIcon
    global notizRW notizWin notizWidth notizWinPathDepth
    global notizTree notizTreeButton 
    global notizBallon  notizPermState
    global notizMainAdrId notizAidList notizAidAnz notizAidListOrig notizMainAdrIsDir
    global notizSubButton notizDirWithAdrNotesIcon  notizDirWithOutAdrNotesIcon notizDisplayAdrNotes
    global _noteText _ballonText
    global notizCheckLineCountID

    set notizCheckLineCountID -1

    puts "NOTIX : $perm"
    
    if { $perm == "rwn" || $perm == "r-n" } {
	set notizPermState "normal"
    } else {
	set notizPermState "disabled"
    }

    set notizMainAdrId [lindex $adrIdList 0] 
    if { [string range $notizMainAdrId 0 0] == "d" } { 
	set notizMainAdrIsDir 1 
	set notizDisplayAdrNotes 1
    } else { 
	    set notizMainAdrIsDir 0
	}
    if { $notizMainAdrId == "-1" } {
	set notizAidList "-1"
    } elseif { $notizMainAdrId == "-2" }  {
	set notizAidList [lrange $adrIdList 1 end]
    } else {
	set notizAidList $adrIdList
    }
    set notizAidListOrig $notizAidList
 
    set notizAidAnz [llength $notizAidList]
    if { [lindex $notizAidList 0 ] >= 0 } {
	    getNotizList $notizAidList
    }

    if { [array exists notzAnz ] == 0 } {
	set notizAnz(-1) 0
	set notiz(-1) ""
	set notizDone(-1) 0
    }
    foreach aid $notizAidList {
	if { [lsearch [ array names notizAnz] $aid ] ==-1  } {
	    set notizAnz($aid) 0
	    set ID "$aid-0"
	    set notizChildAnz($ID) 0
	    set notizChildList($ID) ""
	    set notizDone($ID) 0
	}
    }

    set img {
	/* XPM */
	static char * notixzMail_xpm[] = {
	    "16 16 3 1",
	    " 	c none"
	    ".	c #000000000000",
	    "X	c #FFFFFFFFFFFF",
	    "                ",
	    "                ",
	    " .............. ",
	    " ..XXXXXXXXXX.. ",
	    " .X.XXXXXXXX.X. ",
	    " .XX.XXXXXX.XX. ",
	    " .XXX.XXXX.XXX. ",
	    " .XXXX.XX.XXXX. ",
	    " .XXX.X..X.XXX. ",
	    " .XX.XXXXXX.XX. ",
	    " .X.XXXXXXXX.X. ",
	    " ..XXXXXXXXXX.. ",
	    " .............. ",
	    "                ",
	    "                ",
	    "                "};
    }
    set notizEmailIcon [image create pixmap -data $img]
    set img {
	/* XPM */
	static char * notizPrint_xpm[] = {
	    "16 16 5 1",
	    " 	c none",
	    ".	c #000000000000",
	    "X	c #FFFFFFFFFFFF",
	    "o	c #FAFAF0F0E6E6",
	    "O	c #FFFF00000000",
	    "                ",
	    "      ......... ",
	    "      .XXXXXXX. ",
	    "     .X.X.X.X.  ",
	    "     .XXXXXXX.  ",
	    "    .X..X.X..   ",
	    "    .XXXXXXX.   ",
	    "   .X...XX..    ",
	    "   .XXXXXXX.    ",
	    "  ............  ",
	    " .oooooooooooo. ",
	    " .ooooooooOoOo. ",
	    " .ooooooooOoOo. ",
	    " .oooooooooooo. ",
	    "  ............  ",
	    "                "};
    }
    set notizPrintIcon [image create pixmap -data $img ]
    
    set img {
	/* XPM */
	static char * notizNew_xpm[] = {
	    "16 16 8 1",
	    " 	c none",
	    ".	c #9E7996589658",
	    "X	c #FFFFF3CEEFBE",
	    "o	c #000000000000",
	    "O	c #86177DF779E7",
	    "+	c #E79DE38DDF7D",
	    "@	c #FFFFF7DEF7DE",
	    "#	c #FFFFFFFFFFFF",
	    "                ",
	    " .............. ",
	    " .XXXXXXXXXXooo ",
	    " .XXXXXXXXXoooO ",
	    " .XXXXXXXXooo+o ",
	    " .XXXXXXXooo+o. ",
	    " .XXXXXXooo+o+. ",
	    " ......ooo+oO.. ",
	    " @@.XXXoo+o+XX. ",
	    " @@.XXoo#o+XXX. ",
	    " @@.XXoXXXXXXX. ",
	    " @@.XoXXXXXXXX. ",
	    " @@.XoXXXXXXXX. ",
	    " @@.XXXXXXXXXX. ",
	    " @@............ ",
	    "                "};
    }
    set notizNewIcon [image create pixmap -data $img ]

    set img {
	/* XPM */
	static char * notizNew_xpm[] = {
	    "16 16 3 1",
	    " 	c none"
	    ".	c #000000000000",
	    "X	c #FFFFFFFFFFFF",
	    "                ",
	    "                ",
	    "            ... ",
	    "          ....X ",
	    "         ....X. ",
	    "       ...X.X.X ",
	    "      ...X.X.X  ",
	    "     ...X.X.X   ",
	    "    ..XX.X.X    ",
	    "   .. ..X.X     ",
	    "  ..            ",
	    "  .             ",
	    " .              ",
	    "                ",
	    "                ",
	    "                "};
    }
    set notizRWIcon [image create pixmap -data $img ]

    set img {
	/* XPM */
	static char * notizRO_xpm[] = {
	    "16 16 4 1",
	    " 	c none",
	    ".	c #FFFF00000000",
	    "X	c #000000000000",
	    "o	c #FFFFFFFFFFFF",
	    "                ",
	    " ..       ..    ",
	    " ..      .. XXX ",
	    " ...    . XXXXo ",
	    " ...   .XXXXXoX ",
	    "  ..   .XXoXoXo ",
	    "  ... X.XoXoXo  ",
	    "   ....XoXoXo   ",
	    "    ...oXoXo    ",
	    "   XX...oXo     ",
	    "  XX ....       ",
	    "  X .. ...      ",
	    " X ..   ...     ",
	    "   ..    ...    ",
	    "   ..     ...   ",
	    "    .           "};
    }
    set notizROIcon [image create pixmap -data $img ]
    set img {
	/* XPM */
	static char * notizUndo_xpm[] = {
	    "16 16 2 1",
	    " 	c none",
	    ".	c #BEFB965879E7",
	    "                ",
	    "                ",
	    "                ",
	    "    .           ",
	    "   ..           ",
	    "  .........     ",
	    " ............   ",
	    "  ...........   ",
	    "   ..     ....  ",
	    "    .      ...  ",
	    "           ...  ",
	    "           ...  ",
	    "           ...  ",
	    "           ...  ",
	    "           ...  ",
    "                "};
    }
    set notizUndoIcon [image create pixmap -data $img ]

    set img { 
	/* XPM */
	static char * notizLinear_xpm[] = {
	    "16 16 3 1",
	    " 	c #E79DDB6CD75C",
	    ".	c #69A669A66185",
	    "X	c #FFFFF7DEF7DE",
	    "                ",
	    " .............. ",
	    " .XXXXXXXXXXXX. ",
	    " .XXXXXXXXXXXX. ",
	    " .............. ",
	    " .XXXXXXXXXXXX. ",
	    " .XXXXXXXXXXXX. ",
	    " .............. ",
	    " .XXXXXXXXXXXX. ",
	    " .XXXXXXXXXXXX. ",
	    " .............. ",
	    " .XXXXXXXXXXXX. ",
	    " .XXXXXXXXXXXX. ",
	    " .............. ",
	    "                ",
	    "                "};
    }
    set notizLinearIcon [image create pixmap -data $img ]

    set img {
	/* XPM */
	static char * notizTree_xpm[] = {
	    "16 16 3 1",
	    " 	c #E79DDB6CD75C",
	    ".	c #69A669A66185",
	    "X	c #FFFFF7DEF7DE",
	    "                ",
	    " .............. ",
	    " .XXXXXXXXXXXX. ",
	    " .XXXXXXXXXXXX. ",
	    " .............. ",
	    "    .XXXXXXXXX. ",
	    "    .XXXXXXXXX. ",
	    "    ........... ",
	    "       .XXXXXX. ",
	    "       .XXXXXX. ",
	    " .............. ",
	    " .XXXXXXXXXXXX. ",
	    " .XXXXXXXXXXXX. ",
	    " .............. ",
	    "                ",
	    "                "};
    }
    set notizTreeIcon [image create pixmap -data $img ]

    set img {
	/* XPM */
	static char * notizWithSubNotes_xpm[] = {
	    "16 16 4 1",
	    " 	c #FFFFFFFFFFFF",
	    ".	c #000000000000",
	    "X	c #FFFFF7DEF7DE",
	    "o	c #EFBEBEFB4924",
	    "     ......     ",
	    "    .XXXXXX.    ",
	    "  ..XXXXXooX..  ",
	    " .XXooXXooooXX. ",
	    " .XooooXooooXX. ",
	    ".XXooooXXooXXXX.",
	    ".XXXooXXXXXXXXX.",
	    ".XXXXXXXXXooXXX.",
	    ".XXXXXXXXooooXX.",
	    ".XXXXooXXooooXX.",
	    ".XXXooooXXooXXX.",
	    " .XXooooXXXXXX. ",
	    " .XXXooXXXXXXX. ",
	    "  ..XXXXXXXX..  ",
	    "    .XXXXXX.    ",
	    "     ......     "};
    }
    set notizDirWithAdrNotesIcon [image create pixmap -data $img ]
    set img {
	/* XPM */
	static char * notizWithOutSubNotes_xpm[] = {
	    "16 16 4 1",
	    " 	c #FFFFFFFFFFFF",
	    ".	c #000000000000",
	    "X	c #FFFFF7DEF7DE",
	    "o	c #FFFFDF7DB6DA",
	    "     ......     ",
	    "    .XXXXXX.    ",
	    "  ..XXXXXooX..  ",
	    " .XXooXXooooXX. ",
	    " .XooooXooooXX. ",
	    ".XXooooXXooXXXX.",
	    ".XXXooXXXXXXXXX.",
	    ".XXXXXXXXXooXXX.",
	    ".XXXXXXXXooooXX.",
	    ".XXXXooXXooooXX.",
	    ".XXXooooXXooXXX.",
	    " .XXooooXXXXXX. ",
	    " .XXXooXXXXXXX. ",
	    "  ..XXXXXXXX..  ",
	    "    .XXXXXX.    ",
	    "     ......     "};
    }
    set notizDirWithOutAdrNotesIcon [image create pixmap -data $img ]

    frame $win.b -relief raised -bd 1 -bg "#F8F0E8" 

    set notizWin $win.txt
    set notizWinPathDepth [llength [split $notizWin .]]
    incr notizWinPathDepth

    tixScrolledText $win.txt -scrollbar y  -width $width  -bd 0  -height $height
    pack $win.b $win.txt -side top -fill x -expand 1
    set w [expr ($width-20)/[font measure $fnt12 "0"] ]
    $win.txt subwidget text configure -width $w
    $win.txt subwidget text configure -bg "#E0DBD0"
    $win.txt subwidget vsb configure -width 12

    label $win.b.l -text $_noteText(Note) -bg "#F8F0E8" 
    pack $win.b.l -side left


    if {$notizMainAdrId == "-2" }  {
	label $win.b.nw -text " " -width 2 -font $fnt12 -bg "#F8F0E8"
    } else {
	button $win.b.nw -image $notizNewIcon -bg  "#F8F0E8" -activebackground "#F8F0E8" -cursor hand2 -command newNotiz -state $notizPermState
	bind $win.b.nw <Button> { set curNotizWin %W}
    }
    pack $win.b.nw -side right -padx 20
    label $win.b.spc -text " " -width 4 -font $fnt12 -bg "#F8F0E8"
    pack $win.b.spc -side right -padx 29

    set notizTreeButton $win.b.tr 
    button $notizTreeButton -image $notizTreeIcon  -bg  "#F8F0E8" -activebackground "#F8F0E8" -cursor hand2 -command toggleNotizTree
    pack $win.b.tr -side right 
    set notizTree 1
    
    if {$notizMainAdrIsDir == 1 } {
	set notizSubButton $win.b.sb
	button $notizSubButton -image $notizDirWithAdrNotesIcon  -bg  "#F8F0E8" -activebackground "#F8F0E8" -cursor hand2 -command toggelAdrNotiz
	pack $win.b.sb -side right 
    }

    set notizWidth $width
#    puts $notizWin
    set notizBallon $win.bal
    tixBalloon $notizBallon  -initwait 2000 -state balloon

    fillNotizBlock
    set notizStdCursor [$win.txt subwidget text cget -cursor]


    $notizBallon bind $win.b.nw -balloonmsg $_ballonText(notiz_New)
    $notizBallon bind $win.b.tr -balloonmsg $_ballonText(notiz_SisplayType)
    if {$notizMainAdrIsDir == 1 } {
	$notizBallon bind $notizSubButton -balloonmsg $_ballonText(notiz_FolderViewType)
    }
}

proc toggleNotizTree { } {
    global notizTree notizTreeButton notizTreeIcon notizLinearIcon 
    
    set notizTree [ expr ($notizTree +1 )%2 ]
    if { $notizTree == 1 } {
	$notizTreeButton  configure -image $notizTreeIcon
    } else {
	$notizTreeButton  configure -image $notizLinearIcon
    } 
    
    fillNotizBlock
}

proc toggelAdrNotiz { } {
    global notizSubButton notizDirWithAdrNotesIcon  notizDirWithOutAdrNotesIcon notizDisplayAdrNotes
    global notizAidList notizAidListOrig notizAidAnz notizMainAdrId
    
    set notizDisplayAdrNotes [ expr ($notizDisplayAdrNotes+1 ) %2 ]
    if { $notizDisplayAdrNotes == 0 } {
	$notizSubButton configure -image $notizDirWithOutAdrNotesIcon
	set notizAidAnz 1
	set notizAidList $notizMainAdrId
    } else {
	$notizSubButton configure -image $notizDirWithAdrNotesIcon
	set notizAidList $notizAidListOrig
	set notizAidAnz [llength $notizAidList]
    }
    fillNotizBlock
}

proc fillNotizBlock {  } {
    global notiz notizChildAnz notizChildList notizAnz notizDone
    global notizWin notizWidth
    global notizRW  notizTree notizAidList
    

    
    $notizWin subwidget text configure -state normal
    $notizWin subwidget text delete 0.0 end
    set nidList ""
#     puts "notizAidList = $notizAidList"
#     puts "notiz-array-names: [array names notiz]"
    foreach aid  $notizAidList {
	set pat "$aid-*"
	set list [lsort [array names notiz $pat ]]
	set nidList [concat  $nidList  $list]
    }

#     puts "nidList: /$nidList/"
    set nidList2 ""
    foreach nid $nidList { 
	set notizDone($nid) 0
	if { [lindex $notiz($nid) 5] <0 || $notizTree == 0} {
	    set date [lindex $notiz($nid) 3]
	    set time [lindex $notiz($nid) 4]
	    lappend nidList2 "$date $time $nid [lindex $notiz($nid) 5]"
	}
    }
#     puts "-> nidList2: /$nidList2/"
    
    foreach ent [lsort -decreasing $nidList2] { 
	set nid [lindex $ent 2]
# 	puts "$nid -> done=$notizDone($nid)"
	if { $notizDone($nid) == 0 } {
	    drawNotiz  [$notizWin subwidget text] 0 $nid  [expr $notizWidth -32]
	}
    }
    $notizWin subwidget text configure -state disabled
    $notizWin subwidget text tag add all 0.0 end
    $notizWin subwidget text tag configure all -justify  right
}

proc drawNotiz {win  indent nid width} {
    global fnt12 fnt bfnt ifnt
    global notiz notizChildAnz notizChildList notizAnz  notizDone notizLines
    global notizPrintIcon notizEmailIcon notizNewIcon notizStdCursor notizRWIcon notizROIcon notizUndoIcon
    global notizRW notizPermState
    global curNotizWin  notizWin notizBallon adrNames notizAidAnz
    global widthOfNotiz
    global _ballonText
    
    set notizDone($nid)  1
    set indentWidth [expr $indent * [font measure $fnt12 " "]]
    set aid [lindex [split $nid - ] 0]

#     puts "draw Notiz $win $nid"

    set nwin "$win.$nid"
    frame $nwin -relief flat 
    pack $nwin -side top
#    puts "nqwin=$nwin"
    frame $nwin.t -relief raised -bd 1  -bg "#F8F0E8" 

    set w0 [font measure $fnt12 "0"]
    set w [expr int(floor(($width-$indentWidth)/$w0)) ]
    set widthOfNotiz($nid)  [expr $w * $w0]
    text $nwin.l -height 1 -relief ridge -borderwidth 2 -background "#F8F4F0" -width $w -wrap word -font $fnt12
    pack $nwin.t -side top -fill x
    pack $nwin.l -side top -fill x 
    
    label $nwin.t.l1 -text " [date2lstr [lindex $notiz($nid) 3]] [time2Str [lindex $notiz($nid) 4]], " -font $fnt -bg  "#F8F0E8"
    label $nwin.t.l2 -text "[lindex $notiz($nid) 2]" -font $ifnt -bg  "#F8F0E8"
    label $nwin.t.l3 -text ": [lindex $notiz($nid) 6]" -font $bfnt -bg  "#F8F0E8"
    pack $nwin.t.l1 $nwin.t.l2 $nwin.t.l3 -side left
    
    if { $notizAidAnz >1 } {
	label $nwin.t.l4 -text " ($adrNames($aid))" -font $ifnt -bg  "#F8F0E8"
	pack $nwin.t.l4 -side left
    }
	
    button $nwin.t.ud -image $notizUndoIcon -bg  "#F8F0E8"  -cursor hand2 -activebackground "#F8F0E8" -command undoNotiz -state $notizPermState
    if { $notizRW($nid) == "RW" } {
	button $nwin.t.rw -image $notizRWIcon -bg  "#F8F0E8" -cursor hand2 -activebackground "#F8F0E8" -command toggleNotizRWstate -state $notizPermState
	$nwin.t.ud configure -state normal
    } else {
	button $nwin.t.rw -image $notizROIcon -bg  "#F8F0E8" -cursor hand2  -activebackground "#F8F0E8" -command toggleNotizRWstate -state $notizPermState
	$nwin.t.ud configure -state disabled
    }
    bind $nwin.t.ud <Button> { set curNotizWin %W}
    bind $nwin.t.rw <Button> { set curNotizWin %W}
    button $nwin.t.pr -image $notizPrintIcon -bg  "#F8F0E8" -cursor hand2 -activebackground "#F8F0E8" -command {printNotizDialog} -state $notizPermState
    button $nwin.t.em -image $notizEmailIcon -bg  "#F8F0E8" -cursor hand2 -activebackground "#F8F0E8" -command sendNotizByMailDialog -state $notizPermState
    button $nwin.t.nw -image $notizNewIcon -bg  "#F8F0E8" -cursor hand2  -activebackground "#F8F0E8" -command newNotiz -state $notizPermState
    bind $nwin.t.ud <Button> { set curNotizWin %W}
    bind $nwin.t.pr <Button> { set curNotizWin %W}
    bind $nwin.t.em <Button> { set curNotizWin %W}
    bind $nwin.t.nw <Button> { set curNotizWin %W}
    bind $nwin.t.rw <Button> { set curNotizWin %W}
    $notizBallon bind $nwin.t.rw -balloonmsg $_ballonText(notiz_Protect)
    $notizBallon bind $nwin.t.ud -balloonmsg $_ballonText(notiz_Undo)
    $notizBallon bind $nwin.t.pr -balloonmsg $_ballonText(notiz_Print) 
    $notizBallon bind $nwin.t.em -balloonmsg $_ballonText(notiz_Mail)
    $notizBallon bind $nwin.t.nw -balloonmsg $_ballonText(notiz_Answer)



    label $nwin.t.spc -text " " -bg  "#F8F0E8"
    label $nwin.t.sp2 -text " " -bg  "#F8F0E8"
    pack $nwin.t.nw $nwin.t.spc $nwin.t.pr $nwin.t.em $nwin.t.sp2 $nwin.t.rw $nwin.t.ud  -side right 

    $win window create "end  " -window $nwin -stretch 0
    $win insert end "\n"

    fillNotiz $nid

    if { $notizRW($nid) == "RW" } {
	$nwin.l configure  -state normal
	bind $nwin.l <Return> {
	    set curNotizWin %W
	    notizAddLine
	}
    } else {
	$nwin.l configure  -state disabled
    }
    set aid [lindex [split $nid -] 0 ] 
    incr indent 3
    foreach id2 $notizChildList($nid) {
	set nid2 "$aid-$id2"
	if { $notizDone($nid2) == 0 } {
	    drawNotiz  $win $indent $nid2  $width
	}
    }
}

proc insertNewLineIntoNote { text width font doTrim } {
    set line ""
    set txt ""


#    puts "inserting line into Note: ''$text''"
    set tlist [ split $text \n ]
    foreach block $tlist {
#	puts "next block '$block'"
	regsub -all "\"" $block "\\\"" blk
	foreach word $blk {
	    if { [font measure $font $word] >= $width } {
		set txt "$txt$line\n$word\n"
		set line ""
	    } elseif { [ font measure $font "$line $word"] >=$width } {
		set txt "$txt$line\n"
		set line $word
	    } else {
		if { $line == "" } { 
		    set line $word
		} else {
		    set line "$line $word"
		}
	    }
	}
	set txt "$txt$line\n"
	set line ""
    }
    if { $doTrim } {
	set txt [string trim $txt]
    }
    return $txt
}
proc check4NewLineInsertion { code  win } {
    global curNotizWin fnt12  widthOfNotiz  fnt12 
    global notizCheckLineCountID

    set curNotizWin $win
    set idlist [ getCurIDs ]
    set nwin [lindex $idlist  0]
    set nid [lindex $idlist  1]

    set curNotizWin $win
    set ascii [expr $code & 0xFF]
#    puts "check4NewLineInsertion:  '$code/$ascii' "
    if { $ascii == 13 } {
#	puts "\t\t\t\t\t NewLine"
	$curNotizWin insert end "\n"
	notizAddLine
    } else {
	if { $notizCheckLineCountID >= 0 } {   after cancel $notizCheckLineCountID }
	set notizCheckLineCountID [ after 250 checkLineCount ]
    }
}
proc checkLineCount { } {
    global notizCheckLineCountID
    global   widthOfNotiz fnt12

    set notizCheckLineCountID -1
    update
    set idlist [ getCurIDs ]
    set nwin [lindex $idlist  0]
    set idlist [ getCurIDs ]
    set nid [lindex $idlist  1]
    set ntxt [insertNewLineIntoNote  [$nwin.l get   0.0 end ] $widthOfNotiz($nid) $fnt12 0 ]
    set tlist [ split $ntxt \n ]
    set lines [ llength $tlist ]
    $nwin.l configure -height $lines
    update
}
proc fillNotiz { nid } {
    global notizWin fnt12 widthOfNotiz
    global notiz notizChildAnz notizChildList notizAnz  notizDone notizLines notizRW notizWinPathDepth

    set nwin "$notizWin.text.$nid"
    $nwin.l configure  -state normal


#    set ntxt [string trimright [lindex $notiz($nid) 7]]
    set ntxt [insertNewLineIntoNote  [lindex $notiz($nid) 7] $widthOfNotiz($nid) $fnt12 1 ]
    set tlist [ split $ntxt \n ]
    set lines [ llength $tlist ]
    if { $lines <=0 } { set lines 1}
    set notizLines($nid) $lines
    
    $nwin.l delete 0.0 end
    $nwin.l configure -height $lines 
    $nwin.l insert end $ntxt "$nid"
    update
    if { $notizRW($nid) == "R" } {
	$nwin.l configure  -state disabled
    }
}

proc toggleNotizRWstate { } {
    global notizRW  curNotizWin notizRWIcon notizROIcon notiz notizWinPathDepth notizWinPathDepth
#    puts $curNotizWin
    
    set idlist [ getCurIDs ]
    set nwin [lindex $idlist  0]
    set nid [lindex $idlist  1]


    if { $notizRW($nid) == "RW" } {
	set notizRW($nid) "R" 
    } else  {
	set notizRW($nid) "RW" 
    }

    if { $notizRW($nid) == "RW" } {
	$nwin.t.rw configure -image $notizRWIcon
	$nwin.l configure  -state normal
	bind $nwin.l <KeyPress> {check4NewLineInsertion %N %W}
	$nwin.t.ud configure -state normal
    } else {
	$nwin.t.rw configure -image $notizROIcon 
	changeNotiz $nwin $nid
    }
}
proc notizAddLine { } {
    global curNotizWin notizLines notizWinPathDepth widthOfNotiz  fnt12

    set idlist [ getCurIDs ]
    set nwin [lindex $idlist  0]
    set nid [lindex $idlist  1]

    set ntxt [insertNewLineIntoNote  [$curNotizWin get   0.0 end ] $widthOfNotiz($nid) $fnt12 0 ]
    set tlist [ split $ntxt \n ]
    set lines [ llength $tlist ]
    set notizLines($nid) $lines
    $nwin.l configure -height  $notizLines($nid)
    update
}
proc  undoNotiz { } {
    global curNotizWin notizWinPathDepth

    set idlist [ getCurIDs ]
    set nwin [lindex $idlist  0]
    set nid [lindex $idlist  1]
#    set wlist [ split $curNotizWin .]
#    set nwin [ join [ lrange $wlist 0 $notizWinPathDepth] .]
#    set nid [lindex $wlist $notizWinPathDepth]
    fillNotiz $nid
}

proc createNewNotiz { } {
    global curNotizWin username notiz notizRW notizChildList notizChildAnz notizLines
    global newNid newNotizTitel notizWinPathDepth  notizMainAdrId  notizAidList

    set idlist [ getCurIDwithParent ]
#    puts ">>> $curNotizWin -> '$idlist'"
    set nwin [lindex $idlist  0]
    set parent [lindex $idlist 4]
    set aid  [lindex $idlist  3]
#     puts "aid (new) = $aid ($idlist)"
#     if { $parent <0 } {
# 	set aid $notizMainAdrId
#     } else {
# 	set aid [lindex $idlist  2]
#     }
#    set wlist [ split $curNotizWin .]
#    set nwin [ join [ lrange $wlist 0 $notizWinPathDepth] .]
#    set nid [lindex $wlist $notizWinPathDepth]
#    if { [ llength $wlist ] < [expr 2+$notizWinPathDepth] } {
#	set parent -1
#	set aid $notizMainAdrId
#    } else {
#	set parent [lindex [ split [lindex $wlist $notizWinPathDepth] -] 1]
#	set aid [ lindex [split $nid -] 0]
#    }
    set date [exec date +"%Y%m%d"]
    set time [ exec date +"%H%M" ]

    if { $aid < 0 } { 
	set aid [ changeAddressNoRedraw] 
	if { [winfo exists .adv ] == 1} {
	    set statDo  [ .adv.b.do  cget -state ]
	    set statMod [ .adv.b.mod cget -state ]
	    set statDel [ .adv.b.del cget -state ]
	    set statAbb [ .adv.b.abb cget -state ]
	    set statAss [ .adv.b.ass cget -state ]
	    .adv.b.do  configure -state disabled
	    .adv.b.mod configure -state disabled
	    .adv.b.del configure -state disabled
	    .adv.b.abb configure -state disabled
	    .adv.b.ass configure -state disabled
	    update
	}
	fillAddressNew
	if { [winfo exists .adv ] == 1} {
	    .adv.b.do  configure -state $statDo
	    .adv.b.mod configure -state $statMod
	    .adv.b.del configure -state $statDel
	    .adv.b.abb configure -state $statAbb
	    .adv.b.ass configure -state $statAss
	    update
	}

	set notizAnz($aid) 0
	set notizMainAdrId $aid 
	set notizAidList "$aid"
    }
    set nnid [transfer addNotiz $username $aid $parent $date $time $newNotizTitel "" ]
    if { $nnid == "Error" } { return }

    if {$parent >= 0 } {
	set pnid "$aid-$parent"
	incr notizChildAnz($pnid)
	lappend notizChildList($pnid) $nnid
    }

    set ID "$aid-$nnid"

#    puts "New Nid: $ID"
    set notiz($ID) "$aid $nnid $username $date $time $parent { $newNotizTitel } {}"
    set notizRW($ID) "RW"
    set notizChildAnz($ID) 0
    set notizChildList($ID) ""
    set notizLines($ID) 1
    set newNid $ID

    fillNotizBlock
}
proc newNotiz {  } { 
    global newNotizTitel fnt bfnt curNotizWin notizWinPathDepth notiz _noteText _buttonText
    global notizPermState

    if { [ winfo exists .ntd] ==1 } { return}
    if { $notizPermState ==  "disabled" } { return}
 

    set idlist [ getCurIDwithParent ]
    set nwin [lindex $idlist  0]
    set nid [lindex $idlist  1]
    set parent [lindex $idlist 4 ]
    if { $parent <0 } {
	set newNotizTitel $_noteText(NoteGenricNewTitle)
    } else {
	set newNotizTitel "Re: [lindex $notiz($nid) 6]"
    }
#     set wlist [ split $curNotizWin .]
#     set nwin [ join [ lrange $wlist 0 $notizWinPathDepth] .]
#     set nid [lindex $wlist $notizWinPathDepth]
#     if { [ llength $wlist ] < [expr 2+$notizWinPathDepth] } {
# 	 set newNotizTitel "neue Notiz"
#     } else {
# 	set newNotizTitel "Re: [lindex $notiz($nid) 6]"
#     }
   
    toplevel .ntd

    frame  .ntd.t -relief raised -bd 1
    frame  .ntd.b -relief flat
    pack  .ntd.t  .ntd.b -side top -fill x
    
    label  .ntd.t.l -text $_noteText(NoteNewTitle) -justify left -anchor nw -font $bfnt
    entry  .ntd.t.e -textvariable newNotizTitel -justify left  -font $fnt  -vcmd {checkEntryText %P 100  %d %S ""} -validate key
    pack  .ntd.t.l  -side top -fill x -pady 4 -padx 8
    pack   .ntd.t.e -side top -fill x -pady 8 -padx 8

    button  .ntd.b.ok -text $_buttonText(Apply) -font $bfnt -command {
	destroy .ntd
	createNewNotiz
    }
    button  .ntd.b.abb -text $_buttonText(Cancel) -command {destroy .ntd} -font $fnt
    pack  .ntd.b.abb -side left -padx 2 -pady 2
    pack  .ntd.b.ok -side right -padx 2 -pady 2
    grab .ntd
    wm title .ntd $_noteText(wmTitel_ntd) 
#gemetry 215x102
    centerWin  .ntd 215 102
}

proc changeNotiz { nwin nid } {
    global notiz fnt12  widthOfNotiz 

    set text [braces2parenthesis [insertNewLineIntoNote [$nwin.l get   0.0 end ] $widthOfNotiz($nid) $fnt12 1 ] ]
    set list $notiz($nid) 
    set list "[lrange $list 0 6] {$text}"
    set notiz($nid) "[lrange $notiz($nid) 0 6] {$text}"

    if { [transfer changeNotiz [lindex [split  $nid - ] 0 ] [lindex [split  $nid - ] 1 ] $text]== "Error" } {return}
    $nwin.l configure  -state disabled
    $nwin.t.ud configure -state disabled
    fillNotiz $nid
}
proc getNotizList {  aidList } {
    global username 
    global notiz notizAnz notizChilds notizChildList notizRW notizChildAnz

    if { [lindex $aidList 0] <0} { return }
#    set ret  [eval " request getNotiz $username $aidList"] 
    set listAll [eval " request getNotiz $username $aidList"] 
    if { $listAll == "Error" } { return }

    set aidAnz [ llength $aidList]
    for {set i 0 } { $i < $aidAnz } {incr i } {
	set aid [ lindex $aidList $i]
	set list [lindex [lindex $listAll $i] 1]
	set notizAnz($aid) 0
#	puts "AID: $aid -> ///$list///"
	foreach ent $list { 
#	    puts "ent: ///$ent///"
	    set id [lindex $ent 0]
	    set notiz($id) [lindex $ent 1]
	    incr  notizAnz($aid)
	    set notizChildAnz($id) 0
	    set notizChildList($id) ""
	    set notizRW($id) "R"
#	    puts "$id ->childAnz= $notizChildAnz($id)"
	}
	if { $notizAnz($aid) != 0 } {
	    set pat "$aid-*"
	    foreach nid [array names notiz $pat] {
		set pnid [ lindex $notiz($nid) 5]
#		puts "$nid: $notiz($nid) -> $pnid"
		if { $pnid >=0 } {
		    set id "$aid-$pnid"
		    incr notizChildAnz($id)
		    lappend notizChildList($id) [lindex [split $nid - ] 1]
		}
	    }
	}
    }
}

proc printNotizDialog { } {
    global printerList printerFullNames stdPrinter selPrinter printMode
    global bfnt fnt _buttonText _allgText _noteText


    if { [ winfo exists .npr] ==1 } { return}
    toplevel .npr

    frame .npr.t -relief raised -bd 1
    frame .npr.c 
    frame .npr.b 
    pack .npr.t .npr.c  -side top -fill x 
    pack .npr.b -side top -fill x  -pady 2
    

    frame .npr.t.0
    frame .npr.t.1 -relief ridge -bd 2
    pack  .npr.t.0  -side top  -fill x -pady 4  -padx 4

    tixOptionMenu .npr.t.0.npr -label "$_allgText(Printer):  "  -variable selPrinter
    .npr.t.0.npr subwidget label configure -font $bfnt
    .npr.t.0.npr subwidget menubutton configure -font $fnt
    .npr.t.0.npr subwidget menu configure -font $bfnt
    foreach printer $printerList {
	.npr.t.0.npr add command $printer -label $printerFullNames($printer)
    }
    .npr.t.0.npr add separator fileSep
    .npr.t.0.npr add command nolp__file__ -label $_allgText(LabelPrint2File)
    .npr.t.0.npr add command nolp__gv____ -label $_allgText(LabelPrint2FileShow)
    .npr.t.0.npr subwidget menubutton configure -width 48

    set selPrinter [lindex $printerList $stdPrinter ]
    pack .npr.t.0.npr -side left

    
    button .npr.b.abb -text $_buttonText(Cancel) -command {closeWin .npr}
    pack .npr.b.abb -side left

    button .npr.b.npr -text $_buttonText(Print) -command printNotiz
    pack .npr.b.npr -side right
    
    centerWin .npr 320 76
    wm title .npr $_noteText(wmTitel_npr)
    update 
    grab .npr
    
#     global toolSelection   
}

proc  printNotiz { } {
    global curNotizWin notizWinPathDepth selPrinter notiz  notizRW notizROIcon addc_curName fullUserNames adrNames
    global _noteText

    set idlist [ getCurIDs ]
    set nwin [lindex $idlist  0]
    set nid [lindex $idlist  1]
    set aid [lindex $idlist 3]


    set  $notizRW($nid) "R"
    $nwin.t.rw configure -image $notizROIcon 
    set text [string trimright [$nwin.l get   0.0 end ] ]
    set list $notiz($nid) 
    set notiz($nid) "[lrange $notiz($nid) 0 6] {$text}"
    changeNotiz $nwin $nid
    $nwin.l configure  -state disabled
    $nwin.t.ud configure -state disabled


    set tmp "/tmp/pr.[pid].ps"
#     set fid [ open $tmp "w" ]
#     puts $fid ""
#     puts $fid "$_noteText(NotePrintTextTitle) '$adrNames($aid)': [lindex $notiz($nid) 6]"
#     puts $fid ""
     set un "u-[lindex $notiz($nid) 2]"
     set user $fullUserNames($un)
#     puts $fid "$_noteText(NotePrintTextCreator) $user $_noteText(NotePrintTextAm) [date2Str [lindex $notiz($nid) 3]] $_noteText(NotePrintTextUm) [time2Str [lindex $notiz($nid) 4]]:" 
#     puts $fid ""
#     puts $fid [lindex $notiz($nid) 6]
#     puts $fid "________________________________________________________________________________"
#     puts $fid [lindex $notiz($nid) 7]
#     close $fid
    
    plotNotiz $adrNames($aid) [lindex $notiz($nid) 6] $user [lindex $notiz($nid) 7] $tmp 
    exec lpr -P $selPrinter $tmp
#    exec gv -media a4  $tmp
    destroy .npr


    fillNotiz $nid
    file delete $tmp
}

proc plotNotiz { adr title user txt file } {
    global fnt8 fnt10 bfnt10 fnt12 bfnt12 fnt bfnt bfnt16 bfnt18
    global curYear longProgName minkoVersion

    set now [ currentDateTime ]
    set dstr [format "%s; %2d:%02d" [dateToStr [lindex $now 0] 4] [lindex $now 1] [lindex $now 2] ] 
    
    set txt [string trim $txt]

    if { [ winfo exists .pnw] } { destroy .pnw}


    toplevel .pnw
    set win .pnw.c
    canvas $win -width 538 -height 773 -bg white
    pack $win
    wm iconify .pnw
    
    
    $win create rectangle 0 0 537 48 -outline grey40 -fill grey40
    $win create rectangle 0 0 535 46 -outline grey92 -fill grey90
    $win create rectangle 2 2 535 46 -outline grey86 -fill grey86
    
    
    $win create text 6 6 -anchor nw -text "Memo " -font $bfnt
    $win create text 6 20 -anchor nw -text "to" -font $bfnt12
    $win create text 6 34 -anchor nw -text "by" -font $bfnt12
    $win create text 30 20 -anchor nw -text "'$adr'" -font $bfnt12 -tag t1
    $win create text 30 34 -anchor nw -text "$user" -font $bfnt12 -tag t1
    set xk [ lindex [$win bbox t1] 2] 
    incr xk 6
    
    $win create text $xk 6  -anchor nw -text $title -font -adobe-helvetica-bold-r-normal-*-16-*-*-*-*-*-*-* 
    $win create text 528 34 -anchor ne -text $dstr  -font -adobe-helvetica-medium-r-normal-*-12-*-*-*-*-*-*-* -justify right 

    
    $win create rectangle 0 50 537 765 -outline black -fill white
    $win create text 4 54 -anchor nw -font $fnt10 -text $txt -width 538
    
    $win create text 536 767 -text "created by $longProgName $minkoVersion ($curYear)" -justify right -anchor ne -font $fnt8

    update
    $win postscript -file $file -x 0 -y 0 -pagex 1c -pagey 1c -width 538 -height 773 -pagewidth 19c -pageheight 27c -pageanchor sw
    destroy .pnw
}


# proc nextNID  { } {
#     global addr_id notizAnz
    
# #    puts "notizAnz=$notizAnz($addr_id)"
#     incr notizAnz($addr_id)
#     set nid $notizAnz($addr_id)
#     return $nid
# }


proc closeNotiz { }  {
    global notiz notizWin  notizRW notizAidList

    foreach aid $notizAidList {
	set pat "$aid-*"
	foreach nid [array names notiz $pat] {
	    if { $notizRW($nid) == "RW" } {
		set nwin "[$notizWin subwidget text].$nid"	
		#	    puts "$notizWin -> $nwin"
		set text [braces2parenthesis [string trimright [$nwin.l get   0.0 end ] ]]
		set list $notiz($nid) 
		set list "[lrange $list 0 6] {$text}"
		set notiz($nid) "[lrange $notiz($nid) 0 6] {$text}"
		
		transfer changeNotiz $aid [lindex [split  $nid - ] 1 ] $text
	    }
	}
    }  
}


#Send Notiz by Mail

proc sendNotizByMail { } {
    global curNotizWin notizWinPathDepth notiz notizMailAdd notizRW  notizROIcon _noteText
    
    set idlist [ getCurIDs ]
    set nwin [lindex $idlist  0]
    set nid [lindex $idlist  1]
    set aid [lindex $idlist  3]
    set nnid [lindex $idlist 2]

    if { $notizRW($nid) ==  "RW"  } {
	set  $notizRW($nid) "R"
	$nwin.t.rw configure -image $notizROIcon 
	set text [braces2parenthesis [string trimright [$nwin.l get   0.0 end ] ]]
	set list $notiz($nid) 
	set notiz($nid) "[lrange $notiz($nid) 0 6] {$text}"
	
	set ret [changeNotiz $nwin $nid]
	if { [string range $ret 0 4]  == "Error" } {
	    #	     ErrorDialog "Notiz konnte am Server nicht gendert werden\nGrund: $ret\nDaher wuird keine e-mail verschickt"
	    ErrorDialog "$_noteText(NoteMailError1) $ret\n$_noteText(NoteMailError2)"
	    return
	 }



     } 
    transfer sendNotizByMail $aid $nnid [split $notizMailAdd]
    destroy .snm
}

proc sendNotizByMailDialog {  } {
    global fnt ifnt bfnt fnt12 bifnt
    global userListExeptDonts  groupListExeptDonts setListNames
    global notizMailAdd notizMailFirstSet
    global curNotizWin notizWinPathDepth notiz _noteText _allgText _buttonText

    if { [ winfo exists .snm] ==1 } { return}
    set idlist [ getCurIDs ]
    set nwin [lindex $idlist  0]
    set nid [lindex $idlist  1]
#    set wlist [ split $curNotizWin .]
#    set nwin [ join [ lrange $wlist 0 $notizWinPathDepth] .]
#    set nid [lindex $wlist $notizWinPathDepth]
    
    set notizTitel [lindex $notiz($nid) 6]

    toplevel .snm
    
    frame .snm.t -relief flat
    frame .snm.b -relief flat 
    pack .snm.t  -side top -fill x 
    pack  .snm.b -side top -fill x -padx 4 -pady 4
    

    frame .snm.t.0 -relief raised -bd 1
    frame .snm.t.3 -relief raised -bd 1

    pack .snm.t.0 .snm.t.3 -side top -fill x 

    label .snm.t.0.l -text $_noteText(NoteSendMail) -font $bfnt
    label .snm.t.0.l2 -text " \"$notizTitel\"" -font $bifnt
    pack .snm.t.0.l .snm.t.0.l2  -side left -fill x -padx 6 -pady 2

    frame .snm.t.3.t -relief flat 
    frame .snm.t.3.c -relief flat 
    frame .snm.t.3.u -relief flat 
    frame .snm.t.3.g -relief flat 
    pack .snm.t.3.t .snm.t.3.c .snm.t.3.u .snm.t.3.g -side left -padx 4 -pady 2

    label .snm.t.3.t.h -text $_noteText(NoteSendMailTo) -font $bfnt -justify left -anchor nw
    tixScrolledListBox .snm.t.3.t.l  -scrollbar auto -height 320 -width 166 -options {listbox.selectMode extended}
    pack .snm.t.3.t.h .snm.t.3.t.l -side top -fill x

    label .snm.t.3.c.h -text "   " -font $fnt12 -justify left -anchor nw 
    button .snm.t.3.c.add -text " << " -font $bfnt -command addMailNotizSelection
    label .snm.t.3.c.m -text "   " -font $fnt12 -justify left -anchor nw
    button .snm.t.3.c.rem -text " >> " -font $bfnt -command removeMailNotizSelection
    label .snm.t.3.c.b -text "   " -font $fnt12 -justify left -anchor nw
    pack .snm.t.3.c.h .snm.t.3.c.add .snm.t.3.c.m .snm.t.3.c.rem .snm.t.3.c.b -fill both -side top

    label .snm.t.3.u.h -text "$_allgText(Users):" -font $fnt12 -justify left -anchor nw
    tixScrolledListBox .snm.t.3.u.l  -scrollbar auto -height 320 -width 166 -options {listbox.selectMode extended}
    pack .snm.t.3.u.h .snm.t.3.u.l -side top -fill x

    label .snm.t.3.g.h -text "$_allgText(Gruppen):" -font $fnt12 -justify left -anchor nw
    tixScrolledListBox .snm.t.3.g.l  -scrollbar auto -height 320 -width 166 -options {listbox.selectMode extended}
    pack .snm.t.3.g.h .snm.t.3.g.l -side top -fill x

    .snm.t.3.t.l subwidget vsb configure -width 12
    .snm.t.3.t.l subwidget hsb configure -width 12
    .snm.t.3.u.l subwidget vsb configure -width 12
    .snm.t.3.u.l subwidget hsb configure -width 12
    .snm.t.3.g.l subwidget vsb configure -width 12
    .snm.t.3.g.l subwidget hsb configure -width 12

    set notizMailAdd ""
    fillNotizMailAdd
    
    foreach user $userListExeptDonts { 
	.snm.t.3.u.l	 subwidget listbox insert end  $user
    }

    set notizMailFirstSet 0
    foreach group $groupListExeptDonts { 
	.snm.t.3.g.l subwidget listbox insert end  $group 
	incr notizMailFirstSet
    }
    incr notizMailFirstSet
    .snm.t.3.g.l subwidget listbox insert end  "------------------"
    foreach set   $setListNames { 
	set lab "Set $set"
	.snm.t.3.g.l subwidget listbox insert end  $lab
    }


    button .snm.b.send  -text $_noteText(NoteButtonSendMail) -font $bfnt  -command sendNotizByMail
    button .snm.b.abb  -text $_buttonText(Cancel) -font $fnt -command { destroy .snm}

    pack  .snm.b.send -side right
    pack  .snm.b.abb -side left 
    
    wm title .snm "$_noteText(wmTitel_snm) $notizTitel"
    centerWin .snm 582 406
    update
#    puts [wm geometry .snm]
    grab .snm
}

proc fillNotizMailAdd { } {
    global notizMailAdd
    
    .snm.t.3.t.l subwidget listbox delete 0 end
    foreach ent $notizMailAdd {
	.snm.t.3.t.l subwidget listbox insert end  $ent
    }
}


proc addMailNotizSelection { } {
    global userListExeptDonts  groupListExeptDonts setListNames
    global notizMailAdd notizMailFirstSet
    global setList dontList _allgText
   
    set selection  [.snm.t.3.u.l  subwidget listbox curselection]
    if { [llength $selection] >0 } {
	foreach sel $selection {
	    set user [lindex $userListExeptDonts $sel]
	    if { [lsearch $notizMailAdd $user] <0} {
		lappend notizMailAdd $user
	    }
	}
    }
    set selection  [.snm.t.3.g.l  subwidget listbox curselection]
    if { [llength $selection] >0 } {
	foreach sel $selection {
	    if { $sel < $notizMailFirstSet } {
		set group "$_allgText(Gruppe) [lindex $groupListExeptDonts $sel]"
		if { [lsearch $notizMailAdd $group] < 0} {
		    lappend notizMailAdd $group
		}
	    } else {
		set snam [lindex $setListNames [expr $sel-$notizMailFirstSet] ]
		foreach usr $setList($snam) {
		    if { [lsearch $notizMailAdd $usr] <0} {
			if { $dontList($usr) == 0 } {
			    set type [string range $usr 0 0]
			    set nam  [string range $usr 2 end]
			    if { $type == "u" } {
				if { [lsearch $notizMailAdd $nam] <0} {
				    lappend notizMailAdd $nam
				}
			    } elseif  { $type == "g" } {
				if { [lsearch $notizMailAdd "$_allgText(Gruppe) $nam"] <0} {
				    lappend notizMailAdd "$_allgText(Gruppe) $nam"
				}
			    }
			}
		    }
		}
		
	    }
	}
    }
    fillNotizMailAdd    
}

proc removeMailNotizSelection { } {
    global notizMailAdd

    set selection [lsort -decreasing -integer [.snm.t.3.t.l  subwidget listbox curselection] ]
    if { [llength $selection] >0 } {
	foreach sel $selection { 
	    set notizMailAdd [lreplace $notizMailAdd $sel $sel ]
	}
    }
    .snm.t.3.t.l  subwidget listbox selection clear 0 end
    fillNotizMailAdd
}

proc getCurIDs { } {
    global curNotizWin notizWinPathDepth

    set wlist [ split $curNotizWin .]
    set nwin [ join [ lrange $wlist 0 $notizWinPathDepth] .]
    set nid [lindex $wlist $notizWinPathDepth]
    set nnid [ lindex [split $nid -] 1 ]
    set aid [ lindex [split $nid -] 0 ]
    return "$nwin $nid $nnid $aid"
}

proc getCurIDwithParent { } {
    global curNotizWin notizWinPathDepth notizMainAdrId

    set wlist [ split $curNotizWin .]
    set nwin [ join [ lrange $wlist 0 $notizWinPathDepth] .]
    set nid [lindex $wlist $notizWinPathDepth]
    set nnid [ lindex [split $nid -] 1 ]
    set aid [ lindex [split $nid -] 0 ]
    if { [ llength $wlist ]  < [expr 2+$notizWinPathDepth] } {
	set parent -1
	set nid "$notizMainAdrId--1"
	set nnid -1
	set aid  $notizMainAdrId
    } else {
	set parent [lindex [ split [lindex $wlist $notizWinPathDepth] -] 1]
    }
    return "$nwin $nid $nnid $aid $parent"
}
