#!/usr/bin/X11/tixwish
#  File: prefs.tcl
# 
#      This file is part of minkowsky
# 
#      Copyright (C) 2001-2002 by Rdiger Goetz
#      Author: Rdiger Goetz <minkowsky@r-goetz.de>
# 
#      Time-stamp: <28-May-2002 21:34:18 goetz>
# 
#      This program is free software; you can redistribute it and/or modify
#      it under the terms of the GNU General Public License as published by
#      the Free Software Foundation; either version 2 of the License, or
#      (at your option) any later version.
# 
#      This program is distributed in the hope that it will be useful,
#      but WITHOUT ANY WARRANTY; without even the implied warranty of
#      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#      GNU General Public License for more details.
# 
#      You should have received a copy of the GNU General Public License
#      along with this program; if not, write to the Free Software
#      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#  
proc drawPrefsDialog { } {
    global updo_calPermlist _allgText _prefText _buttonText
    global up_displayToolTips ballon
    global prefWins prefWin prefsDoOpen prefStartState
    global bfnt fnt12 fnt

    if { [winfo exists .upd ] == 1 } { return }
    set prefsDoOpen 0
    set prefStartState "?"
    
    toplevel .upd
    
    frame .upd.n -relief raised -bd 1
    frame .upd.b
    pack .upd.n .upd.b -side top -fill x


    frame .upd.n.t -relief sunken -bd 1
    frame .upd.n.nb -relief flat
    pack .upd.n.t .upd.n.nb -side left -fill both

    set prefWin ".upd.n.nb"
    set prefWins(Permissions) "$prefWin.perms"
    set prefWins(Permissions->Calendar) "$prefWin.calPerms"
    set prefWins(Permissions->Date) "$prefWin.defPerms"
    set prefWins(Layout) "$prefWin.layout"
    set prefWins(Layout->Calendar) "$prefWin.calLayout"
    set prefWins(Layout->Reminder) "$prefWin.remLayout"
    set prefWins(Layout->Browser) "$prefWin.brwLayout"
    set prefWins(Security) "$prefWin.security"
    set prefWins(Security->Password) "$prefWin.pwdSecurity"


    frame $prefWin.perms       -relief flat -width 600 
    frame $prefWin.calPerms    -relief flat -width 600 
    frame $prefWin.defPerms    -relief flat -width 600 
    frame $prefWin.layout      -relief flat -width 600 
    frame $prefWin.calLayout   -relief flat -width 600 
    frame $prefWin.remLayout   -relief flat -width 600 
    frame $prefWin.brwLayout   -relief flat -width 600 
    frame $prefWin.security    -relief flat -width 600 
    frame $prefWin.pwdSecurity -relief flat -width 600 
    drawUPDPerms       $prefWin.perms   
    drawUPDcalPerms    $prefWin.calPerms
    drawUPDdatePerms   $prefWin.defPerms
    drawUPDlayout      $prefWin.layout
    drawUPDcalLayout   $prefWin.calLayout
    drawUPDremLayout   $prefWin.remLayout
    drawUPDbrwLayout   $prefWin.brwLayout
    drawUPDsecurity    $prefWin.security 
    drawUPDpwdSecurity $prefWin.pwdSecurity

    pack propagate $prefWin.perms 0
    pack $prefWin.perms -side top -fill x -padx 2 -pady 2
    $prefWin.perms configure -width 600 -height 312 
    puts "[pack info  $prefWin.perms]"

    label .upd.n.t.l -text $_prefText(panelTitle) -relief raised -bd 1 -font $bfnt
    tixTree .upd.n.t.t  -browsecmd {prefs_activate } -options {
	hlist.separator "->"
	hlist.width 20
	hlist.height 20
    }
    
    pack .upd.n.t.l  .upd.n.t.t -fill both -side top
    .upd.n.t.t subwidget vsb configure -width 12
    .upd.n.t.t subwidget hsb configure -width 12
    set tree [ .upd.n.t.t subwidget hlist]
    $tree configure -font $fnt12

    $tree add Permissions -itemtype text -text $_prefText(PageRights)
    $tree add "Permissions->Calendar" -itemtype text -text $_prefText(PageCalRights) 
    $tree add "Permissions->Date"    -itemtype text -text $_prefText(PageDateRights) 
    $tree add "Layout"      -itemtype text -text $_prefText(PageLayout) 
    $tree add "Layout->Calendar"   -itemtype text -text $_prefText(PageCalLayout)
    $tree add "Layout->Reminder"   -itemtype text -text $_prefText(PageRemLayout)
    $tree add "Layout->Browser"    -itemtype text -text $_prefText(PageBrwLayout)
    $tree add "Security"         -itemtype text -text $_prefText(PageSecurity)
    $tree add "Security->Password"         -itemtype text -text $_prefText(PagePwdSecurity) 
    .upd.n.t.t setmode Permissions close
    .upd.n.t.t setmode Layout close
    .upd.n.t.t setmode Security close
    .upd.n.t.t close Permissions 
    .upd.n.t.t close Layout 
    .upd.n.t.t close Security 
    bind $tree <ButtonRelease> +prefsDisaOpenClose
    bind $tree <ButtonPress> +prefsEnaOpenClose
    button .upd.b.abb -text $_buttonText(Cancel) -font $fnt -command {closeWin .upd}
    button .upd.b.ok  -text $_buttonText(Apply)  -font $bfnt  -command {
 	if { [up_getChanges] == 0} {
 	    validateSignalCmd
 	    writeUserPrefs
 	    destroy .upd
 	    drawNewView
	    if { $up_displayToolTips == 0 } {
 		$ballon configure  -state none
 	    } else {
 		$ballon configure  -state balloon
 	    }
 	}
    }
    pack .upd.b.abb -side left 
    pack .upd.b.ok -side right

    wm title .upd $_prefText(Wmtitle)
    centerWin .upd 766 356
    update
    $updo_calPermlist subwidget listbox selection set 0  0
}

proc prefsEnaOpenClose { } {
    global prefsDoOpen
    set prefsDoOpen 1
}
proc prefsDisaOpenClose { } {
    global prefsDoOpen
    set prefsDoOpen 0
}

proc prefs_activate { path } {
    global prefWins prefwin prefsDoOpen prefStartState

#    puts "\nPATH=$path"

    if { $prefsDoOpen == 1} {
	foreach pw [array names prefWins] { 
	    pack forget $prefWins($pw)
	}
	pack propagate $prefWins($path) 0
	$prefWins($path) configure -width 600 -height 312 

	pack $prefWins($path) -fill x -side top
	update
#	puts "width($prefWins($path)) = [pack info $prefWins($path) ] [winfo width $prefWins($path)] "
	if { [string first "->" $path] == -1 } {
	    if  { [.upd.n.t.t getmode $path ] == "close" } {
		.upd.n.t.t  close $path 
	    } else { 
		.upd.n.t.t  open $path 
	    }
	}
    }
}


proc drawUPDPerms { win } {
    global fnt bfnt _prefText
    frame $win.f -relief ridge 
    pack $win.f -side top -fill both
    message $win.f.m -text $_prefText(descrPerm) -width 580
    pack $win.f.m -side top -fill x    
}
proc drawUPDcalPerms { win } {
    global fnt bfnt fnt12 bfnt12 pfnt pfnt12
    global groupList
    global up_defEinlPerm up_defTeilnPerm up_defInfoPerm up_defExtPerm up_calPerm
    global updo_calPermlist updo_group updo_check chg_perm
    global _prefText  _allgText _calText _buttonText
    
    frame $win.l
    frame $win.m 
    frame $win.r
    pack $win.l  $win.m $win.r -side left -fill both -padx 6 -pady 3
    
#Was ist
    label  $win.l.l -text $_prefText(calPermGroup) -font $bfnt -anchor nw
    tixScrolledListBox $win.l.g -scrollbar y -height 284 -width 202 -options {listbox.selectMode single} -browsecmd changeSelection
    $win.l.g subwidget vsb configure -width 12
    $win.l.g subwidget hsb configure -width 12
    $win.l.g subwidget listbox configure -font $pfnt12
    pack $win.l.l $win.l.g -fill both -side top -fill x
    set updo_calPermlist $win.l.g

#Rechte von Gruppe Allg bertragen
    array set chg_perm [perm2List $up_calPerm(default)]
    
#rechte
    label  $win.m.l -text $_allgText(Perms) -font $bfnt -anchor nw
    frame $win.m.r -relief ridge -bd 2
    frame $win.m.b
    frame $win.m.t
    pack $win.m.l  $win.m.r  -side top -fill  x
    pack $win.m.t  $win.m.b  -side bottom -fill  x


    
    frame $win.m.r.l
    frame $win.m.r.r
    pack $win.m.r.l $win.m.r.r -side left 
    
    label $win.m.r.l.1 -text ""
    label $win.m.r.l.2 -text $_calText(permCoords)   -width 13 -font $bfnt
    label $win.m.r.l.3 -text $_calText(permTexts)    -width 13 -font $bfnt
    label $win.m.r.l.4 -text $_calText(permParts)    -width 13 -font $bfnt
    label $win.m.r.l.5 -text $_calText(permComments) -width 13 -font $bfnt
    label $win.m.r.l.6 -text $_calText(permDelete)   -width 13 -font $bfnt
    pack $win.m.r.l.1 -side top
    pack $win.m.r.l.2 $win.m.r.l.3 $win.m.r.l.4 $win.m.r.l.5  $win.m.r.l.6 -side top -pady 2

    frame $win.m.r.r.1
    frame $win.m.r.r.2
    frame $win.m.r.r.3
    frame $win.m.r.r.4
    frame $win.m.r.r.5
    frame $win.m.r.r.6
    pack $win.m.r.r.1 $win.m.r.r.2 $win.m.r.r.3 $win.m.r.r.4 $win.m.r.r.5 $win.m.r.r.6 -side top -fill x
    
    label $win.m.r.r.1.l -text "$_allgText(permRead)  " -font $bfnt 
    label $win.m.r.r.1.s -text "$_allgText(permModi)" -font $bfnt
    label $win.m.r.r.2.ll -text "  "
    label $win.m.r.r.3.ll -text "  "
    label $win.m.r.r.4.ll -text "  "
    label $win.m.r.r.5.ll -text "  "
    label $win.m.r.r.2.lr -text " "
    label $win.m.r.r.3.lr -text " "
    label $win.m.r.r.4.lr -text " "
    label $win.m.r.r.5.lr -text " "
    checkbutton $win.m.r.r.2.l -variable chg_perm(rz)
    checkbutton $win.m.r.r.2.s -variable chg_perm(wz)
    checkbutton $win.m.r.r.3.l -variable chg_perm(r)
    checkbutton $win.m.r.r.3.s -variable chg_perm(w)
    checkbutton $win.m.r.r.4.l -variable chg_perm(rt)
    checkbutton $win.m.r.r.4.s -variable chg_perm(wt)
    checkbutton $win.m.r.r.5.l -variable chg_perm(rk)
    checkbutton $win.m.r.r.5.s -variable chg_perm(wk)
    checkbutton $win.m.r.r.6.d -variable chg_perm(dd)
    pack                 $win.m.r.r.2.ll $win.m.r.r.3.ll $win.m.r.r.4.ll $win.m.r.r.5.ll -side left
    pack                 $win.m.r.r.2.lr $win.m.r.r.3.lr $win.m.r.r.4.lr $win.m.r.r.5.lr -side right
    pack $win.m.r.r.1.l  $win.m.r.r.2.l  $win.m.r.r.3.l  $win.m.r.r.4.l  $win.m.r.r.5.l -side left
    pack $win.m.r.r.1.s  $win.m.r.r.2.s  $win.m.r.r.3.s  $win.m.r.r.4.s  $win.m.r.r.5.s -side right
    pack $win.m.r.r.6.d -side top -fill x
    set updo_check $win.m.r.r

    button $win.m.t.out -text "$_buttonText(Delete) >>>" -command upd_remSelection -font $bfnt -width 10
    button $win.m.t.in  -text "<<< $_buttonText(Add)" -command upd_addSelection -font $bfnt -width 10
    pack $win.m.t.out $win.m.t.in -side left -fill x
    button $win.m.b.b -text $_buttonText(Apply) -command upd_changePerm -font $bfnt
    pack $win.m.b.b -side top -fill x -pady 4

    #Gruppenauswahl
    label  $win.r.l -text $_allgText(Gruppen) -font $bfnt -anchor nw
    tixScrolledListBox $win.r.g -scrollbar y -height 284 -width 162 -options {listbox.selectMode extended}
    $win.r.g subwidget vsb configure -width 12
    $win.r.g subwidget hsb configure -width 12
    $win.r.g subwidget listbox configure -font $pfnt12
    pack $win.r.l $win.r.g -fill both
    set updo_group $win.r.g
    upd_updateCalPermList
#    update
#    $updo_calPermlist subwidget listbox selection set 0  0
}

proc upd_updateCalPermList { } {
    global updo_calPermlist up_calPerm updo_group groupList
    
    $updo_calPermlist subwidget listbox delete  0 end
    set gpList [lsort [ array names up_calPerm]]
    set idx [lsearch $gpList "default" ]
    set gpList [format "default %s"  [lreplace  $gpList $idx $idx ] ] 
    foreach group $gpList {
	if { $up_calPerm($group) != "off" } {
	    $updo_calPermlist subwidget listbox insert end  [format "%-16s %9s" $group $up_calPerm($group) ]
	}
    }
#    $updo_calPermlist subwidget listbox insert end "1234567890123456789012345678901234567890"

    $updo_group subwidget listbox delete  0 end
    foreach group $groupList {
	if { [lsearch $gpList $group ]<0 } {
	    $updo_group subwidget listbox insert end  $group
	} else {
	    if { $up_calPerm($group) == "off" } {
		$updo_group subwidget listbox insert end  $group
	    }
	}
    }
#    $updo_group subwidget listbox insert end "1234567890123456789012345678901234567890"

}
proc upd_addSelection { } {
    global updo_calPermlist updo_group up_calPerm chg_perm
    
    set selection  [$updo_group subwidget listbox curselection]
    set elemList [$updo_group subwidget listbox get 0 end]
    foreach sel $selection {
	set group [lindex $elemList $sel]
	set up_calPerm($group) [val2perm [List2Val [array get chg_perm]]]
    }
    upd_updateCalPermList
}
proc upd_remSelection { } {
    global updo_calPermlist up_calPerm

    set selection  [$updo_calPermlist subwidget listbox curselection]
    set elemList [$updo_calPermlist subwidget listbox get 0 end]
    foreach sel $selection {
	set group [lindex [lindex $elemList $sel] 0]
	if { $group !="default" } { set up_calPerm($group)  "off" }
    }
    upd_updateCalPermList
}
proc upd_changePerm { } {
    global updo_calPermlist up_calPerm chg_perm

    set selection  [$updo_calPermlist subwidget listbox curselection]
    if { $selection == "" } {
	upd_addSelection
    } else {
	set elemList [$updo_calPermlist subwidget listbox get 0 end]
	foreach sel $selection {
	    set group [lindex [lindex $elemList $sel] 0 ]
	    set up_calPerm($group)  [val2perm [List2Val [array get chg_perm]]]
	}
	upd_updateCalPermList
    }
}
proc changeSelection { } {
    global updo_calPermlist up_calPerm updo_check chg_perm
    
    set selection  [$updo_calPermlist subwidget listbox curselection]
    set elemList [$updo_calPermlist subwidget listbox get 0 end]
    set group [lindex [lindex $elemList $selection] 0]
    array set chg_perm [perm2List $up_calPerm($group)]
}


proc dummy { } { }
proc drawUPDdatePerms {win } {
    global upd_ePerm upd_tPerm upd_aPerm upd_iPerm
    global up_defEinlPerm up_defTeilnPerm up_defInfoPerm up_defExtPerm
    global bfnt fnt bfnt12 fnt12
    global _calText _allgText

    array set upd_ePerm [perm2List $up_defEinlPerm]
    array set upd_tPerm [perm2List $up_defTeilnPerm]
    array set upd_aPerm [perm2List $up_defExtPerm]
    array set upd_iPerm [perm2List $up_defInfoPerm]

#    puts [perm2List $up_defEinlPerm]
#    puts [array get upd_ePerm]

    frame $win.t 
    pack $win.t  -side top -fill x -ipady 0 -pady 0


    
    frame $win.t.0
    frame $win.t.1
    frame $win.t.2 
    frame $win.t.3 
    frame $win.t.4 
    frame $win.t.5
    pack $win.t.0 $win.t.1 $win.t.2 $win.t.3 $win.t.4   $win.t.5 -side left -fill x -padx 6

    label $win.t.0.l -text "  " -width 2
    pack $win.t.0.l

    label $win.t.1.l -text "  "
    frame $win.t.1.c -relief flat -bd 2
    pack $win.t.1.l $win.t.1.c  -side top -padx 1 -pady 2 -fill x
    label $win.t.2.l -text $_calText(typeInvite) -font $bfnt
    frame $win.t.2.c -relief ridge -bd 2
    pack  $win.t.2.l $win.t.2.c  -side top -padx 1 -pady 2 -fill x
    label $win.t.3.l -text $_calText(typePart) -font $bfnt
    frame $win.t.3.c -relief ridge -bd 2
    pack  $win.t.3.l $win.t.3.c  -side top -padx 1 -pady 2 -fill x
    label $win.t.4.l -text $_calText(typeExtern) -font $bfnt
    frame $win.t.4.c -relief ridge -bd 2
    pack  $win.t.4.l $win.t.4.c  -side top -padx 1 -pady 2 -fill x
    label $win.t.5.l -text $_calText(typeInfo) -font $bfnt
    frame $win.t.5.c -relief ridge -bd 2
    pack  $win.t.5.l $win.t.5.c  -side top -padx 1 -pady 2 -fill x
    
    frame  $win.t.1.c.0
    frame  $win.t.1.c.1
    frame  $win.t.1.c.2
    frame  $win.t.1.c.3
    frame  $win.t.1.c.4
    frame  $win.t.1.c.5
    pack $win.t.1.c.0 $win.t.1.c.1 $win.t.1.c.2 $win.t.1.c.3 $win.t.1.c.4 $win.t.1.c.5 -side top -fill x
    label $win.t.1.c.0.l -text "   "
    label $win.t.1.c.1.l -text $_calText(permCoords)   -font $bfnt -width 15
    label $win.t.1.c.2.l -text $_calText(permTexts)    -font $bfnt -width 15
    label $win.t.1.c.3.l -text $_calText(permParts)    -font $bfnt -width 15
    label $win.t.1.c.4.l -text $_calText(permComments) -font $bfnt -width 15
    label $win.t.1.c.5.l -text $_calText(permDelete)   -font $bfnt -width 15
    
    pack $win.t.1.c.0.l -side left -fill x -pady 3
    pack $win.t.1.c.1.l $win.t.1.c.2.l $win.t.1.c.3.l $win.t.1.c.4.l $win.t.1.c.5.l -side left -fill x -pady 3




    frame  $win.t.2.c.0
    frame  $win.t.2.c.1
    frame  $win.t.2.c.2
    frame  $win.t.2.c.3
    frame  $win.t.2.c.4
    frame  $win.t.2.c.5
    pack $win.t.2.c.0 $win.t.2.c.1 $win.t.2.c.2 $win.t.2.c.3 $win.t.2.c.4 $win.t.2.c.5 -side top -fill x
    label $win.t.2.c.0.l -text " $_allgText(permRead) " -font $bfnt12
    label $win.t.2.c.0.s -text " $_allgText(permModi) " -font $bfnt12
    label $win.t.2.c.1.ll -text "   "
    label $win.t.2.c.2.ll -text "   "
    label $win.t.2.c.3.ll -text "   "
    label $win.t.2.c.4.ll -text "   "
    label $win.t.2.c.1.lr -text "  "
    label $win.t.2.c.2.lr -text "  "
    label $win.t.2.c.3.lr -text "  "
    label $win.t.2.c.4.lr -text "  "
    checkbutton $win.t.2.c.1.l -variable upd_ePerm(rz)
    checkbutton $win.t.2.c.2.l -variable upd_ePerm(r)
    checkbutton $win.t.2.c.3.l -variable upd_ePerm(rt)
    checkbutton $win.t.2.c.4.l -variable upd_ePerm(rk)
    checkbutton $win.t.2.c.1.s -variable upd_ePerm(wz)
    checkbutton $win.t.2.c.2.s -variable upd_ePerm(w)
    checkbutton $win.t.2.c.3.s -variable upd_ePerm(wt)
    checkbutton $win.t.2.c.4.s -variable upd_ePerm(wk)
    checkbutton $win.t.2.c.5.d -variable upd_ePerm(dd)
    pack  $win.t.2.c.1.ll  $win.t.2.c.2.ll  $win.t.2.c.3.ll  $win.t.2.c.4.ll -side left
    pack  $win.t.2.c.1.lr  $win.t.2.c.2.lr  $win.t.2.c.3.lr  $win.t.2.c.4.lr -side right
    pack $win.t.2.c.0.l $win.t.2.c.1.l $win.t.2.c.2.l $win.t.2.c.3.l $win.t.2.c.4.l -side left -fill x -pady 0
    pack $win.t.2.c.0.s $win.t.2.c.1.s $win.t.2.c.2.s $win.t.2.c.3.s $win.t.2.c.4.s -side right -fill x -pady 0
    pack $win.t.2.c.5.d -side top

    frame  $win.t.3.c.0
    frame  $win.t.3.c.1
    frame  $win.t.3.c.2
    frame  $win.t.3.c.3
    frame  $win.t.3.c.4
    frame  $win.t.3.c.5
    pack $win.t.3.c.0 $win.t.3.c.1 $win.t.3.c.2 $win.t.3.c.3 $win.t.3.c.4 $win.t.3.c.5 -side top -fill x
    label $win.t.3.c.0.l -text " $_allgText(permRead) " -font $bfnt12
    label $win.t.3.c.0.s -text " $_allgText(permModi) " -font $bfnt12
    label $win.t.3.c.1.ll -text "  "
    label $win.t.3.c.2.ll -text "  "
    label $win.t.3.c.3.ll -text "  "
    label $win.t.3.c.4.ll -text "  "
    label $win.t.3.c.1.lr -text " "
    label $win.t.3.c.2.lr -text " "
    label $win.t.3.c.3.lr -text " "
    label $win.t.3.c.4.lr -text " "
    checkbutton $win.t.3.c.1.l -variable upd_tPerm(rz)
    checkbutton $win.t.3.c.2.l -variable upd_tPerm(r)
    checkbutton $win.t.3.c.3.l -variable upd_tPerm(rt)
    checkbutton $win.t.3.c.4.l -variable upd_tPerm(rk)
    checkbutton $win.t.3.c.1.s -variable upd_tPerm(wz)
    checkbutton $win.t.3.c.2.s -variable upd_tPerm(w)
    checkbutton $win.t.3.c.3.s -variable upd_tPerm(wt)
    checkbutton $win.t.3.c.4.s -variable upd_tPerm(wk)
    checkbutton $win.t.3.c.5.d -variable upd_tPerm(dd)
    pack  $win.t.3.c.1.ll  $win.t.3.c.2.ll  $win.t.3.c.3.ll  $win.t.3.c.4.ll -side left
    pack  $win.t.3.c.1.lr  $win.t.3.c.2.lr  $win.t.3.c.3.lr  $win.t.3.c.4.lr -side right
    pack $win.t.3.c.0.l $win.t.3.c.1.l $win.t.3.c.2.l $win.t.3.c.3.l $win.t.3.c.4.l -side left -fill x -pady 0
    pack $win.t.3.c.0.s $win.t.3.c.1.s $win.t.3.c.2.s $win.t.3.c.3.s $win.t.3.c.4.s -side right -fill x -pady 0
    pack $win.t.3.c.5.d -side top 

    frame  $win.t.4.c.0
    frame  $win.t.4.c.1
    frame  $win.t.4.c.2
    frame  $win.t.4.c.3
    frame  $win.t.4.c.4
    frame  $win.t.4.c.5
    pack $win.t.4.c.0 $win.t.4.c.1 $win.t.4.c.2 $win.t.4.c.3 $win.t.4.c.4 $win.t.4.c.5 -side top -fill x
    label $win.t.4.c.0.l -text " $_allgText(permRead) " -font $bfnt12
    label $win.t.4.c.0.s -text " $_allgText(permModi) " -font $bfnt12
    label $win.t.4.c.1.ll -text "   "
    label $win.t.4.c.2.ll -text "   "
    label $win.t.4.c.3.ll -text "   "
    label $win.t.4.c.4.ll -text "   "
    label $win.t.4.c.1.lr -text "  "
    label $win.t.4.c.2.lr -text "  "
    label $win.t.4.c.3.lr -text "  "
    label $win.t.4.c.4.lr -text "  "
    label $win.t.4.c.5.d  -text "  "
    checkbutton $win.t.4.c.1.l -variable upd_aPerm(rz)
    checkbutton $win.t.4.c.2.l -variable upd_aPerm(r)
    checkbutton $win.t.4.c.3.l -variable upd_aPerm(rt)
    checkbutton $win.t.4.c.4.l -variable upd_aPerm(rk)
    checkbutton $win.t.4.c.1.s -variable upd_aPerm(wz)
    checkbutton $win.t.4.c.2.s -variable upd_aPerm(w)
    checkbutton $win.t.4.c.3.s -variable upd_aPerm(wt)
    checkbutton $win.t.4.c.4.s -variable upd_aPerm(wk)
     set edd_defPerm_AD 0
    pack  $win.t.4.c.1.ll  $win.t.4.c.2.ll  $win.t.4.c.3.ll  $win.t.4.c.4.ll -side left
    pack  $win.t.4.c.1.lr  $win.t.4.c.2.lr  $win.t.4.c.3.lr  $win.t.4.c.4.lr -side right
    pack $win.t.4.c.0.l $win.t.4.c.1.l $win.t.4.c.2.l $win.t.4.c.3.l $win.t.4.c.4.l -side left -fill x -pady 0
    pack $win.t.4.c.0.s $win.t.4.c.1.s $win.t.4.c.2.s $win.t.4.c.3.s $win.t.4.c.4.s -side right -fill x -pady 0
    pack $win.t.4.c.5.d -side top -pady 2

    frame  $win.t.5.c.0
    frame  $win.t.5.c.1
    frame  $win.t.5.c.2
    frame  $win.t.5.c.3
    frame  $win.t.5.c.4
    frame  $win.t.5.c.5
    pack $win.t.5.c.0 $win.t.5.c.1 $win.t.5.c.2 $win.t.5.c.3 $win.t.5.c.4 $win.t.5.c.5 -side top -fill x
    label $win.t.5.c.0.l -text " $_allgText(permRead) " -font $bfnt12 -anchor n
    checkbutton $win.t.5.c.1.l -variable upd_iPerm(rz)
    checkbutton $win.t.5.c.2.l -variable upd_iPerm(r)
    checkbutton $win.t.5.c.3.l -variable upd_iPerm(rt)
    checkbutton $win.t.5.c.4.l -variable upd_iPerm(rk)
    label $win.t.5.c.5.d  -text " "
    pack $win.t.5.c.0.l  -side top -fill x
    pack $win.t.5.c.1.l $win.t.5.c.2.l $win.t.5.c.3.l $win.t.5.c.4.l -side top -fill x -pady 0
    pack $win.t.5.c.5.d -side top -pady 2
}
proc up_getChanges { } {
    global upd_ePerm upd_tPerm upd_aPerm upd_iPerm
    global up_defEinlPerm up_defTeilnPerm up_defInfoPerm up_defExtPerm
    global up_pwd up_pwd2
    global _prefText

    if { $up_pwd != $up_pwd2 } {
	puts "$up_pwd $up_pwd2"
	ErrorDialog $_prefText(ErrorPwd)
	return -1
    }

    set up_defEinlPerm   [val2perm [List2Val [array get upd_ePerm]]]
    set up_defTeilnPerm  [val2perm [List2Val [array get upd_tPerm]]]
    set up_defExtPerm    [val2perm [List2Val [array get upd_aPerm]]]
    set up_defInfoPerm   [val2perm [List2Val [array get upd_iPerm]]]
    return 0
}

proc drawUPDlayout { win } {
    global fnt bfnt _prefText
    frame $win.f -relief ridge 
    pack $win.f -side top -fill both
    message $win.f.m -text $_prefText(descrLayout) -width 580
    pack $win.f.m -side top -fill x    
}

proc drawUPDcalLayout {win } {
    global up_beep up_signalCommand updo_signal
    global uCalKernStart uCalKernEnd uGlobalSlotsD uGlobalSlotsW uGlobalSlotsM uGlobalSlotsWG
    global bfnt fnt bfnt12
    global up_displayIgnore up_displayInfo up_displayToolTips showIgnore ignoreInfo
    global _prefText

    frame $win.k -relief ridge -bd 2
    frame $win.a -relief ridge -bd 2
    frame $win.z -relief ridge -bd 2
    pack $win.k $win.a $win.z -fill x -pady 1 -padx 1  -ipadx 1
    
    frame $win.a.0
    frame $win.a.1
    frame $win.a.2
    frame $win.a.3
    pack $win.a.0 $win.a.1 $win.a.2 $win.a.3 -side top -fill x -pady 1 -padx 2 -ipadx 2
    
    label  $win.a.0.l  -text $_prefText(calLayoutOptions) -font $bfnt
    pack $win.a.0.l  -side left
    checkbutton $win.a.1.c -text $_prefText(calLayoutIgnored) -font $bfnt -variable  up_displayIgnore
    checkbutton $win.a.2.c -text $_prefText(calLayoutInformed) -font $bfnt -variable  up_displayInfo
    checkbutton $win.a.3.c -text $_prefText(calLayoutToolTipps) -font $bfnt -variable  up_displayToolTips
    pack  $win.a.1.c  $win.a.2.c  $win.a.3.c  -side left 
    
    frame  $win.k.0
    frame  $win.k.1
    pack  $win.k.0 $win.k.1  -side top -fill x -pady 1 -padx 2 -ipadx 2

    label  $win.k.0.l  -text $_prefText(calLayoutMainTime) -width 12 -font $bfnt
    pack $win.k.0.l  -side left
    tixControl $win.k.1.s -label " $_prefText(calLayoutFrom) " -min 0 -max $uCalKernEnd -variable uCalKernStart -selectmode immediate -autorepeat true -integer 1  -options { entry.width 2  }
    tixControl $win.k.1.e -label " $_prefText(calLayoutTo) " -min $uCalKernStart -max 24 -variable uCalKernEnd -selectmode immediate -autorepeat true -integer 1  -options { entry.width 2 } 
    label $win.k.1.l -text " $_prefText(calLayout_oClock)"  -font $bfnt 
    pack  $win.k.1.s $win.k.1.e $win.k.1.l -side left 
    $win.k.1.s  subwidget label configure -font $bfnt 
    $win.k.1.e  subwidget label configure -font $bfnt 

    frame  $win.z.3
    frame  $win.z.4
    frame  $win.z.5
    pack $win.z.3 $win.z.4 $win.z.5  -side top -fill x -pady 1 -padx 2 -ipadx 2

    label $win.z.3.l -text $_prefText(calLayoutLines) -font $bfnt
    pack $win.z.3.l -side left
    
    tixControl $win.z.4.d -label "        $_prefText(calLayoutLines4Day)" -min 0 -max 20 -variable uGlobalSlotsD -selectmode immediate -autorepeat true -integer 1  -options { entry.width 2 label.width 22 label.font $bfnt}
    tixControl $win.z.4.w -label "        $_prefText(calLayoutLines4Week)" -min 0 -max 10 -variable uGlobalSlotsW -selectmode immediate -autorepeat true -integer 1  -options { entry.width 2 label.width 22 label.font $bfnt}
    tixControl $win.z.5.m -label "        $_prefText(calLayoutLines4Month)" -min 0 -max 10 -variable uGlobalSlotsM -selectmode immediate -autorepeat true -integer 1  -options { entry.width 2 label.width 22 label.font $bfnt} 
    tixControl $win.z.5.g -label "        $_prefText(calLayoutLines4Group)" -min 0 -max 10 -variable uGlobalSlotsWG -selectmode immediate -autorepeat true -integer 1  -options { entry.width 2 label.width 22 label.font $bfnt} 
    pack $win.z.4.d $win.z.4.w -side left
    pack $win.z.5.m $win.z.5.g -side left
    $win.z.4.d  subwidget label configure -font $bfnt 
    $win.z.4.w  subwidget label configure -font $bfnt 
    $win.z.5.m  subwidget label configure -font $bfnt 
    $win.z.5.g  subwidget label configure -font $bfnt 

   
    
}
proc drawUPDremLayout {win } {
    global up_beep up_signalCommand updo_signal
    global uCalKernStart uCalKernEnd uGlobalSlotsD uGlobalSlotsW uGlobalSlotsM uGlobalSlotsWG
    global bfnt fnt bfnt12
    global up_remDate up_remEinl up_remTodo up_remMahn
    global  _prefText

    frame $win.f -relief ridge -bd 2
    frame $win.r -relief ridge -bd 2
    pack $win.f $win.r  -fill x -pady 1 -padx 2  -ipadx 2
    
    frame  $win.f.1
    frame  $win.f.2
    frame  $win.f.3
    pack  $win.f.1 $win.f.2 $win.f.3 -side top -fill x -pady 1 -padx 2  -ipadx 2

    label $win.f.1.l -text $_prefText(reminderSignal) 
    radiobutton $win.f.2.r -variable up_beep -value 1 -text $_prefText(reminderSignalBeep) -width 16 -command  up_toogleSignalCommand  -anchor nw  -font $bfnt
    radiobutton $win.f.3.r -variable up_beep -value 0 -text $_prefText(reminderSignalCmd) -width 16 -command  up_toogleSignalCommand -anchor nw  -font $bfnt
    entry $win.f.3.e -textvariable up_signalCommand -width 40 -state disabled  -vcmd {checkEntryText %P 100  %d %S ""} -validate key
    if { $up_beep == 0 } { $win.f.3.e configure -state normal}
    pack  $win.f.1.l $win.f.2.r $win.f.3.r $win.f.3.e -side left 
    set updo_signal $win.f.3.e

    frame  $win.r.0
    frame  $win.r.1
    frame  $win.r.2
    frame  $win.r.3
    frame  $win.r.4
    frame  $win.r.5
    pack  $win.r.0 $win.r.1 $win.r.2 $win.r.3 $win.r.4  $win.r.5 -side top -fill x -pady 1 -padx 2  -ipadx 2

    label  $win.r.0.l -text $_prefText(reminderType) -width 25 -font $bfnt
    label  $win.r.1.l -text "" -width 25 -font $bfnt
    label  $win.r.2.l -text $_prefText(reminderTypeDateInvite) -width 28 -font $bfnt -justify left 
    label  $win.r.3.l -text $_prefText(reminderTypeDateRemind) -width 28 -font $bfnt -justify left 
    label  $win.r.4.l -text $_prefText(reminderTypeTaskRemind) -width 28 -font $bfnt -justify left 
    label  $win.r.5.l -text $_prefText(reminderTypeTaskDelay)  -width 28 -font $bfnt -justify left 
    
    label $win.r.0.m -text $_prefText(reminderalwaysAs)     -justify center -anchor n -width 12
    label $win.r.1.m -text $_prefText(reminderalwaysMail)   -justify center -anchor n -width 12
    label $win.r.0.t -text $_prefText(reminderalwaysLike)   -justify center -anchor n -width 12
    label $win.r.1.t -text $_prefText(reminderalwaysDate)   -justify center -anchor n -width 12
    label $win.r.0.d -text $_prefText(reminderalwaysIn)     -justify center -anchor n -width 12
    label $win.r.1.d -text $_prefText(reminderalwaysDialog) -justify center -anchor n -width 12

#    puts "UP_REM: '$up_remDate'  '$up_remEinl'  '$up_remTodo'  '$up_remMahn'"
    radiobutton $win.r.2.m -value  1 -variable up_remEinl -text "         "  -font $bfnt -width 7
    radiobutton $win.r.2.t -value  0 -variable up_remEinl -text "         "  -font $bfnt  -width 7
    radiobutton $win.r.2.d -value -1 -variable up_remEinl -text "         "  -font $bfnt  -width 7
    radiobutton $win.r.3.m -value  1 -variable up_remDate -text "         "  -font $bfnt  -width 7
    radiobutton $win.r.3.t -value  0 -variable up_remDate -text "         "  -font $bfnt  -width 7
    radiobutton $win.r.3.d -value -1 -variable up_remDate -text "         "  -font $bfnt  -width 7
    radiobutton $win.r.4.m -value  1 -variable up_remTodo -text "         "  -font $bfnt  -width 7
    radiobutton $win.r.4.t -value  0 -variable up_remTodo -text "         "  -font $bfnt  -width 7
    radiobutton $win.r.4.d -value -1 -variable up_remTodo -text "         "  -font $bfnt  -width 7
    radiobutton $win.r.5.m -value  1 -variable up_remMahn -text "         "  -font $bfnt  -width 7
    radiobutton $win.r.5.t -value  0 -variable up_remMahn -text "         "  -font $bfnt  -width 7
    radiobutton $win.r.5.d -value -1 -variable up_remMahn -text "         "  -font $bfnt  -width 7

    pack $win.r.0.l $win.r.0.m $win.r.0.t $win.r.0.d -side left 
    pack $win.r.1.l $win.r.1.m $win.r.1.t $win.r.1.d -side left 
    pack $win.r.2.l $win.r.2.m $win.r.2.t $win.r.2.d -side left 
    pack $win.r.3.l $win.r.3.m $win.r.3.t $win.r.3.d -side left 
    pack $win.r.4.l $win.r.4.m $win.r.4.t $win.r.4.d -side left 
    pack $win.r.5.l $win.r.5.m $win.r.5.t $win.r.5.d -side left 
}
proc validateSignalCmd { } {
    global up_signalCommand

    set c 0
    set pp 0
    set p [string first "\"" [string range $up_signalCommand $pp end] ]
    while {$p >=0} {
	incr c
	set pp $p
	incr pp
	set p [string first "\"" [string range $up_signalCommand $pp end] ]
    }
    if { [expr $c %2] == 1} { set up_signalCommand "$up_signalCommand\"" }
    return 1
}
proc up_toogleSignalCommand { } {
    global up_beep updo_signal
    
#    puts "up_toogleSignalCommand"
    if { $up_beep == 1} {
	$updo_signal configure  -state disabled
    } else {
	$updo_signal configure  -state normal
    }
}

proc drawUPDbrwLayout { win } {
    global fnt bfnt pfnt12 _prefText
    global upd_browserID upd_browserCmd

    frame $win.f -relief ridge -bd 2
    pack $win.f -side top -fill x -padx 2 -pady 2

    for { set n 0 } { $n < 7} { incr  n } {
	frame $win.f.$n 
	pack $win.f.$n -side top -fill x
    }
    label $win.f.0.l -text $_prefText(browserSelection) -font $bfnt
    pack $win.f.0.l -side left  -fill x -padx 4    -pady 4  
    
    radiobutton $win.f.1.r -text "Minkowsky's Browswer" -value "minkowsky" -variable upd_browserID -width 25 -font $bfnt -anchor nw   
    radiobutton $win.f.2.r -text "kfm (KDE1)" -value "kfm" -variable upd_browserID -width 25 -font $bfnt -anchor nw -state disabled
    radiobutton $win.f.3.r -text "konqueror (KDE2)" -value "konqueror" -variable upd_browserID -width 25 -font $bfnt -anchor nw
    radiobutton $win.f.4.r -text "Mozilla" -value "mozilla" -variable upd_browserID -width 25 -font $bfnt -anchor nw 
    radiobutton $win.f.5.r -text "Netscape" -value "netscape" -variable upd_browserID -width 25 -font $bfnt -anchor nw 
    radiobutton $win.f.6.r -text $_prefText(browserOwn) -value "user" -variable upd_browserID -width 25 -font $bfnt -anchor nw   
    label $win.f.1.l -text "" -font $pfnt12
    label $win.f.2.l -text "(kfm %s)" -font $pfnt12
    label $win.f.3.l -text "(konqueror %s)" -font $pfnt12
    label $win.f.4.l -text "(mozilla %s\")" -font $pfnt12
    label $win.f.5.l -text "(netscape  -remote \"openBrowser(%s)\")" -font $pfnt12
    entry $win.f.6.l -font $pfnt12 -textvariable upd_browserCmd -width 48  -vcmd {checkEntryText %P 63  %d %S ""} -validate key
    for { set n 1 } { $n < 7} { incr  n } {
	pack  $win.f.$n.r  $win.f.$n.l -side left  -fill x -padx 4  
    }
}
proc drawUPDsecurity { win } {
    global fnt bfnt _prefText
    frame $win.f -relief ridge 
    pack $win.f -side top -fill both
    message $win.f.m -text $_prefText(descrPerm) -width 580
    pack $win.f.m -side top -fill x    
}

proc drawUPDpwdSecurity { win} {
    global up_pwd bfnt up_pwd2 fnt _prefText

    frame $win.f -relief ridge -bd 2
    pack $win.f -fill x -pady 2 -padx 2 -ipady 2 -ipadx 2
    frame  $win.f.1
    frame  $win.f.2

    set up_pwd ""
    set up_pwd2 ""
    
    pack  $win.f.1 $win.f.2 -side top -fill x -pady 2 -padx 2 -ipady 2 -ipadx 2

    
    label $win.f.1.l -text $_prefText(securityPassword) -width 15 -font $bfnt
    label $win.f.2.l -text $_prefText(securityPasswordRep) -width 15 -font $bfnt
    entry $win.f.1.e -textvariable up_pwd  -font $fnt -width 16 -show +  -vcmd {checkEntryText %P 16  %d %S " "} -validate key
    entry $win.f.2.e -textvariable up_pwd2  -font $fnt -width 16 -show +  -vcmd {checkEntryText %P 16  %d %S " "} -validate key
    pack $win.f.1.l $win.f.2.l $win.f.1.e $win.f.2.e -side left 
}

proc perm2List {perm} {
   
    set chg_perm(rz) 0
    set chg_perm(r) 0
    set chg_perm(rt) 0
    set chg_perm(rk) 0
    set chg_perm(wz) 0
    set chg_perm(w) 0
    set chg_perm(wt) 0
    set chg_perm(wk) 0
    set chg_perm(dd) 0
    set chg_perm(w)  0
    set chg_perm(r)  0
    
    if { [string range $perm 8 8] == "d" } { set chg_perm(dd) 1 }
    if { [string range $perm 7 7] == "k" } { set chg_perm(wk) 1 }
    if { [string range $perm 3 3] == "k" } { set chg_perm(rk) 1 }
    if { [string range $perm 6 6] == "t" } { set chg_perm(wt) 1 }
    if { [string range $perm 2 2] == "t" } { set chg_perm(rt) 1 }
    if { [string range $perm 5 5] == "" } { set chg_perm(w) 1 }
    if { [string range $perm 1 1] == "" } { set chg_perm(r) 1 }
    if { [string range $perm 4 4] == "z" } { set chg_perm(wz) 1 }
    if { [string range $perm 0 0] == "z" } { set chg_perm(rz) 1 }

    if { [expr  $chg_perm(rz)+$chg_perm(r)+$chg_perm(rt)+$chg_perm(rk)] >0 } { set chg_perm(r) 1}
    if { [expr  $chg_perm(wz)+$chg_perm(w)+$chg_perm(wt)+$chg_perm(wk)] >0 } { set chg_perm(w) 1}

#    puts "PERM $perm ->   $chg_perm(rz) $chg_perm(r) $chg_perm(rt) $chg_perm(rk) $chg_perm(wz) $chg_perm(w) $chg_perm(wt) $chg_perm(wk) "
    return [array get chg_perm]
}

proc List2Val {list } {
#    global chg_perm
    array set chg_perm $list
    set rperm [expr $chg_perm(rz) +$chg_perm(r)*2 +$chg_perm(rt)*4 +$chg_perm(rk)*8 ]
    set wperm [expr $chg_perm(wz) +$chg_perm(w)*2 +$chg_perm(wt)*4 +$chg_perm(wk)*8 ]
    set perm [ expr $rperm +$wperm *16 + $chg_perm(dd)*256]
    return $perm
}
proc exportUsersAndGroups { file } {
    global userList groupList groupsByUser usersByGroups  lastMembrUpdate
    global pfnt fnt bfnt bfnt
    
    set t [request lastUListUpdate]
    if { $t == "Error" } { return }
    
#     puts "last known update :  $lastMembrUpdate"
#     puts "last       update :  $t"

    if { $t > $lastMembrUpdate } { 
	set ret [request getMemberLists]
	if { $ret == "Error" } { return }
	set lastMembrUpdate [lindex $ret 0]
    } else {
	return
    }

    set fid [open $file "w"]

    set fList [lindex $ret 1]
#     puts ""
#     puts "-> /$fList/"
    foreach ent $fList {
	set user [lindex $ent 0]
	set list ""
	set glist [lindex $ent 1]
# 	puts "$ent  =>  $user /$glist/"
	foreach grp $glist {
	    set list "$list $grp "
	}
	set groupsByUser($user) [string trim [string trim [lsort -dictionary $list ] ,] ]
    }
    set fList [lindex $ret 0]
#     puts ""
#     puts "-> /$fList/"
    foreach ent [lindex $ret 2] {
	set grp [lindex $ent 0]
	set list ""
	foreach user [lindex $ent 1] {
	    set list "$list $user,"
	}
	set usersByGroups($grp) [string trim [string trim [lsort -dictionary $list] ,] ]
    }

    puts $fid "<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML//EN\">"
    puts $fid "<html>"
    puts $fid "  <head>"
    puts $fid "    <title>Kapa Dokumentation</title>"
    puts $fid "  </head>\n\n"
    puts $fid "  <body bgcolor=\"\#FFFCF8\" LINK=\"#B05800\" VLINK=\"#6030000\">"
    puts $fid "<H1><A NAME=\"users\"></A>Benutzer-Liste</H1>"
    puts $fid "(<A HREF=\"\#groups\">Gruppen-Liste</A> siehe <A HREF=\"\#groups\">unten</A>)"
    puts $fid "<BR><BR>"
    puts $fid "<TABLE BORDER=1>"
    puts $fid "<TR><TD WIDTH=\"120\"><B>Benutzer</B></TD><TD WIDTH=\"640\"><B> ... ist Mitglied in ...</B></TD></TR>"
    foreach user [lsort -dictionary [array names groupsByUser]] {
	puts -nonewline $fid [format "<TR><TD><B>%s,</TD><TD>" $user ]
	set start 0
	foreach grp $groupsByUser($user) {
	    if { $start != 0 } { puts -nonewline $fid ", " } else { set start 1}
	    puts -nonewline $fid [format "%s"  $grp]
	}
	puts $fid "</TD></TR>"
    }
    puts $fid "</TABLE>"
    puts $fid "<H1><A NAME=\"groups\"></A>Gruppen-Liste</H1>"
    puts $fid "(<A HREF=\"\#users\">Benutzer-Liste</A> siehe <A HREF=\"\#users\">unten</A>)"
    puts $fid "<BR><BR>"
    puts $fid "<TABLE BORDER=1>"
    puts $fid "<TR><TD WIDTH=\"120\"><B>Gruppe</B></TD><TD WIDTH=\"640\"><B> Gruppen-Mitglieder</B></TD></TR>"
    foreach grp [lsort -dictionary [array names usersByGroups]] {
	puts $fid [format "<TR><TD>%s,</TD><TD>%s</TD></TR>"  $grp $usersByGroups($grp) ]
    }
    puts $fid "</TABLE>"
    puts $fid " <BR><BR><BR><BR><BR><BR><BR><BR><BR><BR><BR><BR><BR>"
    puts $fid " </BODY></HTML>"
    close $fid
}
