#!/usr/bin/X11/tixwish
#  File: addresss.tcl
# 
#      This file is part of minkowsky
# 
#      Copyright (C) 2001-2002 by Rdiger Goetz
#      Author: Rdiger Goetz <minkowsky@r-goetz.de>
# 
#      Time-stamp: <30-May-2002 22:55:48 goetz>
# 
#      This program is free software; you can redistribute it and/or modify
#      it under the terms of the GNU General Public License as published by
#      the Free Software Foundation; either version 2 of the License, or
#      (at your option) any later version.
# 
#      This program is distributed in the hope that it will be useful,
#      but WITHOUT ANY WARRANTY; without even the implied warranty of
#      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#      GNU General Public License for more details.
# 
#      You should have received a copy of the GNU General Public License
#      along with this program; if not, write to the Free Software
#      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#  

proc initAdrPrint { } {
    global adrPrintSel adrPrintPos adrPrintFieldCount adrPrintWidth adrPrintLabel adrPrintLines adrPrintHeight
    global adrFieldList   adrPrintSelection printPageFormat
    global adrPrintTemplates adrPrintTemplate adrPrintTemplatesList 
    global printPageFormatList
    global _addrText

    set printPageFormatList(A4p) "{A4 portrait} 538 765 19c 29c 0"
    set printPageFormatList(A4l) "{A4 landscape} 765 538 29c 19c 1"

    set  adrFieldList "
 {{name  {$_addrText(Name)}                            {$_addrText(Name)}                    name }
  {cpos  {$_addrText(Position)}                        {$_addrText(Position)}                 6 }}
 {{comp  {$_addrText(Company) $_addrText(Name)}        {$_addrText(Company)}                  7 } 
  {compS {$_addrText(ShortCompanyName)}                {$_addrText(Company)}                  5 }}
 {{adr1  {$_addrText(Adr) 1}                           {$_addrText(Adr) \#1}                {20 21 22 {23 24} 25}}
  {adr2  {$_addrText(Adr) 2}                           {$_addrText(Adr) \#2}                {26 27 28 {29 30} 31}}}
 {{tel1  {$_addrText(Telefon) 1}                       {$_addrText(Telefon) \#1}               8 }
  {tel2  {$_addrText(Telefon) 2}                       {$_addrText(Telefon) \#2}               9 }}
 {{tel3  {$_addrText(Telefon) 3}                       {$_addrText(Telefon) \#3}              10 }
  {tel4  {$_addrText(Telefon) 4}                       {$_addrText(Telefon) \#4}              11 }}
 {{fax   {$_addrText(FAX)}                             {$_addrText(FAX)}                      13 }
  {telA  {$_addrText(All) $_addrText(Telefone)}        {$_addrText(Telefon)}                 { 8 9 10 11} }}
 {{mail1 {$_addrText(mail) 1}                          {$_addrText(mail) \#1}                 15}
  {mail2 {$_addrText(mail) 2}                          {$_addrText(mail) \#2}                 16 }}
 {{mailA {$_addrText(All) $_addrText(mails)}           {$_addrText(mail)}                    {15 16}}
  {www   {$_addrText(WWW)}                             {$_addrText(WWW)}                      18 }}
 {{bank1 {$_addrText(BankKonto) 1}                     {$_addrText(BankKonto) \#1}           {43 44 46 45} }
  {bank2 {$_addrText(BankKonto) 2}                     {$_addrText(BankKonto) \#2}           {47 48 50 49} }}
 {{desc  {$_addrText(Descr)}                           {$_addrText(Descr)}                    39 } 
  {descS {$_addrText(ShortDescr)}                      {$_addrText(ShortDescr)}               38 }}
 {{info  {$_addrText(infos)}                           {$_addrText(infos)}                    40}
  {str   {$_addrText(SteurNumm)}                       {$_addrText(SteurNumm)}                 51}}
 {{-     -                                             -                                       0}
  {-     -                                             -                                       0}}
 {{adrP  {$_addrText(private) $_addrText(Adr)}         {$_addrText(private) $_addrText(Adr)} {32 33 34 {35 36} 37}}
  {telP  {$_addrText(private) $_addrText(Telefon)}     {$_addrText(priv) $_addrText(Telefon)} 12 }}
 {{mailP {$_addrText(private) $_addrText(mail)}        {$_addrText(private) $_addrText(mail)} 17 }
  {faxP  {$_addrText(private) $_addrText(FAX)}         {$_addrText(private) $_addrText(FAX)}  14}}
 {{wwwP  {$_addrText(private) $_addrText(WWW)}         {$_addrText(priv) $_addrText(WWW)}     19}
  {geb   {$_addrText(Birthday)}                        {$_addrText(Birthday)}                 42}}
 {{infoP {$_addrText(infos) ($_addrText(private)) }    {$_addrText(infos) ($_addrText(private))}   41}
  {-     -                       -                           0}}
 "


    foreach f $adrFieldList {
	set n [lindex [lindex $f 0] 0 ]
	set adrPrintSel($n) 0
	set adrPrintPos($n) 0
	set adrPrintLabel($n) [lindex [lindex $f 0] 2]
	set adrPrintLines($n) [lindex [lindex $f 0] 3]
	set adrPrintHeight($n) [llength $adrPrintLines($n)]
	set n [lindex [lindex $f 1] 0 ]
	set adrPrintSel($n) 0
	set adrPrintPos($n) 0
	set adrPrintLabel($n) [lindex [lindex $f 1] 2]
	set adrPrintLines($n) [lindex [lindex $f 1] 3]
	set adrPrintHeight($n) [llength $adrPrintLines($n)]
    }
    set adrPrintSel(name) 1
    set adrPrintPos(name) 1
    set adrPrintFieldCount 1

    set adrPrintTemplates(tel) "{$_addrText(PrintTelefonList)} name comp telA fax mailA www telP mailP"
    set adrPrintTemplates(adr) "{$_addrText(PrintAdresssList)} name cpos comp adr1 tel1 tel4 fax mail1 www"
    set adrPrintTemplates(padr) "{$_addrText(PrintprivAddrList)} name adrP telP faxP mailP wwwP comp adr1 tel1 tel4 fax mail1"
    set adrPrintTemplates(all) "{$_addrText(PrintFullList)}  name cpos comp compS adr1 adr2 telA fax mailA www descS desc bank1 bank2 str info adrP telP faxP mailP wwwP geb infoP"
    set adrPrintTemplates(custom) "{$_addrText(PrintCustomList)} name "
    set adrPrintTemplatesList "tel adr padr all custom"

    set adrPrintTemplate "tel"
    set adrPrintSelection filter
    set printPageFormat A4p
}

proc printAdrDialog { win } {
    global adrPrintSel adrPrintPos adrPrintFieldCount adrPrintSelWin
    global adrFieldList   adrPrintTemplate adrPrintTemplates adrPrintTemplatesList 
    global fnt12 pfnt12 bfnt12 bfnt printPageFormat printPageFormatList
    global adrPrintDoSetTempl
    global _addrText 

    pack  $win  -side top  -fill x -padx 2 -pady 2 -expand 1
    set fwin [$win subwidget frame]

    set adrPrintDoSetTempl 1
    frame $fwin.p
    pack $fwin.p -side top -fill x -padx 2 -pady 4
    tixOptionMenu $fwin.p.p -options {menubutton.width 40 label.width 12} \
 	-label "$_addrText(PrintPageFormat) :" 
    $fwin.p.p subwidget label configure -font $bfnt
    $fwin.p.p subwidget menubutton configure  -font $bfnt12
    foreach ent [array names printPageFormatList ] {
	$fwin.p.p add command $ent  -label [lindex $printPageFormatList($ent) 0]
    }
    $fwin.p.p configure -variable printPageFormat
    pack $fwin.p.p -side left -fill x

    frame $fwin.m
    pack $fwin.m -side top -fill x -padx 2 -pady 4
    tixOptionMenu $fwin.m.m -options {menubutton.width 40 label.width 12} \
 	-label "$_addrText(PrintFormat) :" 
    $fwin.m.m subwidget label configure -font $bfnt
    $fwin.m.m subwidget menubutton configure  -font $bfnt12
    foreach tmpl $adrPrintTemplatesList {
 	$fwin.m.m add command $tmpl -label [lindex $adrPrintTemplates($tmpl) 0]
    }
    pack $fwin.m.m -side left -fill x



    set lines [ llength $adrFieldList]
    for {set i 0} {$i < $lines} { incr i } {
	frame $fwin.$i  
	pack $fwin.$i -side top -fill x
    }


    set l 0
    foreach  list $adrFieldList {

	set s 1
	foreach ent $list {
	    
	    set name [lindex $ent 0]
	    set lab  [lindex $ent 1]

	    if { $name != "-" } {
		checkbutton $fwin.$l.c$s -variable adrPrintSel($name) 
		tixControl  $fwin.$l.e$s  -integer 1 \
		    -labelside right -options { entry.width 2 label.width 20 label.justify left }\
		    -label " $lab" -variable adrPrintPos($name)
 		set cmd "$fwin.$l.c$s configure -command {adrPrintUpdatePos $name}"
 		eval $cmd
 		set cmd "$fwin.$l.e$s configure -validatecmd {adrPrintVerifyPos $name}"
 		eval $cmd
		if { $adrPrintSel($name) == 0 } {
		    set adrPrintPos($name) 0
		    $fwin.$l.e$s configure -state disabled
		}
		
		set adrPrintSelWin($name) $fwin.$l.e$s
	    } else  {
		label $fwin.$l.c$s -text ""
		label $fwin.$l.e$s -text ""
	    }
	    incr s
	}


	incr l
    }


     for {set i 0} {$i < $lines } { incr i } {
	 label $fwin.$i.s -text "  " -font $pfnt12
	 if { [winfo class $fwin.$i.e1] == "TixControl" } {
	     $fwin.$i.e1 subwidget entry configure -font $pfnt12
	     $fwin.$i.e1 subwidget entry configure -font $fnt12
	 }
	 if { [winfo class $fwin.$i.e2] == "TixControl" } {
	     $fwin.$i.e2 subwidget entry configure -font $pfnt12
	     $fwin.$i.e2 subwidget entry configure -font $fnt12
	 }
	 pack $fwin.$i.c1 $fwin.$i.e1 $fwin.$i.s $fwin.$i.c2 $fwin.$i.e2 -side left -pady 2
     }

    puts ">>>$adrPrintTemplate"
    $fwin.m.m configure -variable adrPrintTemplate
    $fwin.m.m configure  -command { adrPrintSetTempl } 
    adrPrintSetTempl [set [$fwin.m.m cget -variable]]
    set adrPrintDoSetTempl 0
}

proc printAdrOptionsDialog { win } {
    global adrPrintSelection
    global bfnt12 bfnt
    global _addrText

    pack  $win  -side top  -fill x -padx 2 -pady 2 -expand 1
    set fwin [$win subwidget frame]

    frame $fwin.p
    pack $fwin.p -side top -fill x -padx 2 -pady 4
    tixOptionMenu $fwin.p.p -options {menubutton.width 33 label.width 18} \
 	-label "$_addrText(PrintAddrSel) :" 
    $fwin.p.p subwidget label configure -font $bfnt
    $fwin.p.p subwidget menubutton configure  -font $bfnt12
    $fwin.p.p add command filter  -label $_addrText(PrintCurrent)  
    $fwin.p.p add command all     -label $_addrText(PrintAll)
    $fwin.p.p add command sel     -label $_addrText(PrintSeclected)
    $fwin.p.p configure -variable adrPrintSelection

    pack $fwin.p.p -side left -fill x
}
proc adrPrintSetTempl { v } {
    global adrPrintTemplates adrPrintTemplate adrPrintTemplatesList
    global adrPrintSel adrPrintPos adrPrintFieldCount adrPrintSelWin
    global adrPrintDoSetTempl

    set adrPrintDoSetTempl 1
    if { $v != "custom" } {
	foreach f [array names adrPrintSel ] {
	    set n [lindex $f 0]
	    if { $n != "-" } {
		set adrPrintSel($n) 0
		set adrPrintPos($n) 0
		$adrPrintSelWin($n) configure -state disabled
	    }
	    
	}
	set i 0
	set adrPrintFieldCount 0
	foreach f $adrPrintTemplates($v) {
	    if { $i >0 } {
		incr adrPrintFieldCount
		$adrPrintSelWin($f) configure -state normal
		set adrPrintSel($f) 1
		set adrPrintPos($f) $i
	    }
	    incr i
	}
    }
    set adrPrintDoSetTempl 0

}

proc adrPrintVerifyPos { f v} {
    global adrPrintPos adrPrintFieldCount adrPrintSel adrPrintTemplate adrPrintDoSetTempl
    
    if { $adrPrintDoSetTempl == 0 } {  set adrPrintTemplate "custom"}
    if { $adrPrintSel($f) == 0 } { return 0}
    if { $v < 1  }  { return  1 }
    if { $v > $adrPrintFieldCount } { return $adrPrintFieldCount}

    if { $v != $adrPrintPos($f) } {
	foreach n [array names adrPrintPos] {
	    if { $adrPrintPos($n) == $v } {
		set adrPrintPos($n) $adrPrintPos($f)
	    }
	}
    }
    return $v
}

proc adrPrintUpdatePos {  f } {
    global adrPrintSel adrPrintPos adrPrintFieldCount adrPrintSelWin adrPrintTemplate adrPrintDoSetTempl


    if { $adrPrintDoSetTempl == 0 } { set adrPrintTemplate "custom" }
    set win $adrPrintSelWin($f)
    if { $adrPrintSel($f) == 1 } { 
	incr adrPrintFieldCount 
	$win configure -state normal
	set adrPrintPos($f)  $adrPrintFieldCount
	foreach n [array names adrPrintPos] {
	    if { $adrPrintPos($n) > 0 } {
		$adrPrintSelWin($n) configure -max $adrPrintFieldCount
	    }
	}

    } else {
	incr adrPrintFieldCount  -1
	set pos   $adrPrintPos($f) 
	foreach n [array names adrPrintPos] {
	    if { $adrPrintPos($n) > $pos } {
		incr adrPrintPos($n) -1
	    }
	}
	$win configure -state disabled
	set adrPrintPos($f) 0
	
    }
}

proc adrPrint2Canvas { cwin format  file } {
    global adrPrintSel adrPrintPos adrPrintWidth adrPrintFieldCount adrPrintLabel adrPrintSelection
    global adrPrintLines adrPrintHeight adrPrintCanvasFields apc_xl apc_xr
    global adr_list adrFilter adrSortField adrNamesOT
    global bfnt12 fnt10 fnt8 username printPageFormatList



    set cwidth  [ lindex $printPageFormatList($format) 1]
    set cheight [ lindex $printPageFormatList($format) 2]
    set pwidth  [ lindex $printPageFormatList($format) 3]
    set pheight [ lindex $printPageFormatList($format) 4]
    set rotate  [ lindex $printPageFormatList($format) 5]
    
    set page_dx [expr $cwidth +8]
    set page_dy [expr $cheight +8]
    foreach f [array names adrPrintSel ] {
	set n [lindex $f 0]
	if { $n != "-" } {
	    if { $adrPrintSel($n) == 1} {
		set adrPrintCanvasFields($adrPrintPos($n)) $n
	    }
	}
    }

    global adrSelection idx2aid
    #count the lines to be displayed
    puts "counting lines"
    set anz 0
    set aidList ""
    if {$adrPrintSelection == "sel" } {
	foreach adr [lsort  -index $adrSortField -dictionary $adr_list ] {
	    set aid [lindex $adr 0]
	    set adrPrint($aid) 0
	}
	if { $adrSelection == "" } { return 0}
	puts ">>> $adrSelection <<<"
 	foreach ent $adrSelection {
 	    set obj  [lindex [split  $ent .] end]
 	    set type   [string range   $obj  0 2 ]
 	    set idx [trimLead0 [string range   $obj  3 end ]]
 	    if { $type == "adr" } {
 		set adrPrint($idx2aid($idx)) 1
 		incr anz
 	    }
 	}
	foreach adr [lsort  -index $adrSortField -dictionary $adr_list ] {
	    set aid [lindex $adr 0]
	    if { $adrPrint($aid) == 1 } {
		lappend aidList $aid
	    }
	}
    }
    if {$adrPrintSelection == "all" } {
	foreach adr [lsort  -index $adrSortField -dictionary $adr_list ] {
	    set aid [lindex $adr 0]
	    incr anz
	    lappend aidList $aid
	}
    }
    if {$adrPrintSelection == "filter" } {
	foreach adr [lsort  -index $adrSortField -dictionary $adr_list ] {
	    set aid [lindex $adr 0]
	    if { $adrFilter($aid) == 1 } {
		incr anz
		lappend aidList $aid
	    }
	}
    }
    if {$anz == 0} { 
	puts "nothing to print"
	return 0
    }
    if {$aidList == ""} { 
	puts "nothing to print"
	return 0
    }


    #get the data
    updateMeter 10 "getting data"
    set aList [request getFullAdr $username $aidList]
    if { [string range $aList 0 4] == "Error" } { return 0 }

    # we need a list, and if with only one element
    if { $anz == 1 } { 
	set aList "{ $aList }"
    }
    updateMeter 35 "getting data"

    #get the data and calculate the column width
    for { set p 1 } { $p <= $adrPrintFieldCount} { incr p } {
	set n $adrPrintCanvasFields($p)
	set lw($p) [font measure $bfnt12 $adrPrintLabel($n) ]
	incr lw($p) 8
    }
    set c 1
    foreach fadr $aList {
 	set aid [lindex $fadr 0]

	set p [expr 40 + int(floor(10 * (double($c) / double($anz)))) ]
	updateMeter $p "darwing"
	puts "aid=$aid : //$fadr//"
	for { set p 1 } { $p <= $adrPrintFieldCount} { incr p } {
	    set n $adrPrintCanvasFields($p)
	    foreach line $adrPrintLines($n) {
		set txt ""
		foreach f $line {
		    if { $f == "name"} {
			puts "aid=$aid -> $adrNamesOT($aid)"
			set txt "[lindex $fadr 1] $adrNamesOT($aid)"
		    } else {
			set txt "$txt [lindex $fadr $f]"
		    }
		}
		set txt [string trim $txt]
		set w -1
		foreach t [split $txt \n ] {
		    set w [ font measure $fnt8 $t ]
		    if { $w > $lw($p) } { set lw($p) $w }
		}
 	    }
 	}
	incr c
     }

    updateMeter 50 "drawing"

    #determine the colums width, left and right x coordinates
    set pages 1
    set pageStart(0) 0
    set pageEnd(0) $cwidth
    set page 0
    set apc_xr(0) 0
    for { set p 1 } { $p <= $adrPrintFieldCount} { incr p } {
	incr lw($p) 2
	set pp [expr $p -1]
	set apc_xl($p) [expr $apc_xr($pp) +0 ]
	set apc_xr($p) [expr $apc_xl($p) + $lw($p) +5]
	if { $apc_xr($p) > $pageEnd($page) } {
	    set pp $page
	    incr page
	    set pageStart($page) [expr $pageStart($pp) +$page_dx]
	    set pageEnd($page)   [expr $pageEnd($pp) +$page_dx]
	    incr pages
	    set apc_xl($p) $pageStart($page)
	    set apc_xr($p) [expr $apc_xl($p) + $lw($p) +5]
	}
	set xkt($p) [expr $apc_xl($p) +3]
    }

    $cwin configure -width $pageEnd($page)
    update
    


    # The head of page 0 and start

    set lines [adrPrintGHeadline $cwin 0 ]
    set dy [expr $lines *9 +2]
    set yk 20
    set vpage 0
    set vpages 1
    set vpageTop(0) 0
    set vpageBottom(0) [expr $cheight -20 ]
    


	    

    set c  1
    foreach fadr $aList {

	set p [expr 55 + int(floor(40 * (double($c) / double($anz)))) ]
	updateMeter $p "darwing"

	set aid [lindex $fadr 0]

	puts "aid=$aid : //$fadr//"
	set ykt(0) [expr $yk +13]
	for { set i 0 } { $i < $lines } { incr i } {
	    set ykt($i) [expr $yk +1 +$i*9]
	}
	set yk2 [expr $yk +$dy]
	while { $yk2 > $vpageBottom($vpage) } {
	    set pp $vpage
	    incr vpage
	    incr vpages
	    set vpageTop($vpage)    [expr $vpageTop($pp) +$page_dx]
	    set vpageBottom($vpage) [expr $vpageBottom($pp) +$page_dx]
	    adrPrintGHeadline $cwin $vpageTop($pp)
	    set yk [expr $vpageTop($pp) +20]
	    set ykt(0) [expr $yk +17]
	    for { set i 0 } { $i < $lines } { incr i } {
		set ykt($i) [expr $yk +1 +$i*9 ]
	    }
	    set yk2 [expr $yk +$dy]
	}
	
	for { set p 1 } { $p <= $adrPrintFieldCount} { incr p } {
	    set n $adrPrintCanvasFields($p)
	    $cwin create rectangle $apc_xl($p) $yk $apc_xr($p) $yk2 -fill white -outline black
	    set l 0
	    foreach line $adrPrintLines($n) {
		set txt ""
		foreach f $line {
		    if { $f == "name"} {
			set txt "[lindex $fadr 1] $adrNamesOT($aid)"
		    } else {
			set txt "$txt [lindex $fadr $f]"
		    }
		}
		set txt [string trim $txt]
		$cwin create text $xkt($p) $ykt($l) -text $txt -fill black  -anchor nw -justify left -font $fnt8
		incr l
	    }
	}
	incr yk $dy
	incr c
    }

    updateMeter 90 "writing"
    set tpages [ expr $pages * $vpages]
    set fid [open $file "w"]
    set page 1
    set panchor "sw"
    if { $rotate =="1" } {set panchor "nw" }

    for { set j 0 } { $j < $vpages } { incr j } {
	for { set i 0 } { $i < $pages } { incr i } {
	    set xk [expr $i *$page_dx]
	    set yk [expr $j *$page_dy]
	    puts "$i $j $xk $yk : $cwidth $pwidth $cheight $pheight"
	    set txt [$cwin  postscript  -colormode gray \
			 -pagewidth  $pwidth -width $cwidth \
			 -pageheight $pheight -height $cheight\
			 -pagey 1c -y $yk \
			 -pagex 1c -x $xk \
			 -pageanchor $panchor -rotate $rotate ]
	    if { $i == 0  && $j ==0 } {
#		set pstext $txt 
		set p1 [string first "%%Trailer" $txt]
		set endTxt [ string range $txt $p1 end]
		incr p1 -1
		set txt [string range $txt 0 $p1 ]
		set p2 [string first "%%Pages" $txt]
		set p3 [string first "%%" $txt [expr $p2 +4]]
		incr p2 -1
		set txt "[string range $txt 0 $p2]%%Pages: $tpages\n[string range $txt $p3 end ]"
		puts $fid $txt
	    } else  {
		set p0 [string first "%%Page: " $txt]
		set p1 [string first "%%Trailer" $txt]
		incr p1 -1
		set txt [string range $txt $p0 $p1]
		#		set txt [string replace  $txt 8 10 "$pn $pn"]  
		set txt "[string range $txt 0 7] $page $page [string range $txt 10 end]"
		puts $fid $txt
	    }
	    incr page
	}
    }
    puts $fid $endTxt
    close $fid
    updateMeter 95 "sending"
	
    return 1
}
proc adrPrintGHeadline {cwin  y0  } {
    global adrPrintFieldCount adrPrintLabel adrPrintHeight adrPrintCanvasFields apc_xl apc_xr
    global bfnt12

    set yk $y0 
    set ykt(0) [expr $yk +17]
    set yk2 [expr $yk +19]
    set yk3 [expr $yk +20]
    set dy 0
    set lines 0
    for { set p 1 } { $p <= $adrPrintFieldCount} { incr p } {
	set xkt [expr ($apc_xl($p)+$apc_xr($p))/2 ]
	$cwin create rectangle $apc_xl($p) $yk $apc_xr($p) $yk2 -fill white -outline black
	$cwin create line $apc_xl($p) $yk3 $apc_xr($p) $yk3 -fill black
	$cwin create text $xkt $ykt(0) -text $adrPrintLabel($adrPrintCanvasFields($p)) -fill black \
	    -anchor s -justify center -font $bfnt12
	if { $lines < $adrPrintHeight($adrPrintCanvasFields($p)) } {
	    set lines $adrPrintHeight($adrPrintCanvasFields($p))
	}
    }
    return $lines
}


proc printAdrList { } {
    global  selPrinter cputype printMode  env printFile 
    global printPageFormatList printPageFormat

    if { $selPrinter == "nolp__file__" || $selPrinter ==  "nolp__gv____" } {
 	set file $printFile
    } else {
 	set file [format "/tmp/minko-%d-%d.ps" [pid] [currentTime] ]
    }

    openMeter "Print Address List" "preparing pages" 1
    if { [adrPrint2Canvas .pr.c.c $printPageFormat $file ] == 1 } {
	if { $selPrinter ==  "nolp__gv____" } {
	    set ret [ exec gv -media a4 $file &]
	} elseif { $selPrinter != "nolp__file__"  } {
	    set ret [exec lpr -P$selPrinter $file]	
	    file delete $file
	}
    }
    closeMeter
    destroy .pr
}

