#!/usr/bin/X11/tixwish
#  File: printCal.tcl
# 
#      This file is part of minkowsky
# 
#      Copyright (C) 2001-2002 by Rdiger Goetz
#      Author: Rdiger Goetz <minkowsky@r-goetz.de>
# 
#      Time-stamp: <30-May-2002 20:34:15 goetz>
# 
#      This program is free software; you can redistribute it and/or modify
#      it under the terms of the GNU General Public License as published by
#      the Free Software Foundation; either version 2 of the License, or
#      (at your option) any later version.
# 
#      This program is distributed in the hope that it will be useful,
#      but WITHOUT ANY WARRANTY; without even the implied warranty of
#      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#      GNU General Public License for more details.
# 
#      You should have received a copy of the GNU General Public License
#      along with this program; if not, write to the Free Software
#      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#  

# .pr.t.1
proc printCalDialog { win } {
    global printMode calTyp
    global bfnt fnt fnt10 fnt12
    global prStartD prStartM prStartY prStopD prStopM prStopY
    global curDay curMon curYear monlen
    global pwDay pwMon pwYear 
    global printModeCal 
    global pw_skipWeekend
    global _allgText _buttonText
    
    set pwDay $curDay
    set pwMon $curMon
    set pwYear $curYear

    pack  $win  -side top  -fill x -padx 2 -pady 1 -expand 1
    set fwin [$win subwidget frame]

    set printMode $printModeCal

# 	frame .pr.t.2 -relief ridge -bd 2
# 	pack .pr.t.2 -side top -fill x -pady 4  -padx 4




    frame $fwin.1
    frame $fwin.2
    frame $fwin.3
    frame $fwin.4
    frame $fwin.5
    pack $fwin.1 $fwin.2 $fwin.3 $fwin.4 $fwin.5 -side top -fill x -padx 3 -pady 3
    
    radiobutton $fwin.1.r -variable printMode -value w -text $_allgText(PrintCalWeekView) -command togglePRdates -font $bfnt
    radiobutton $fwin.2.r -variable printMode -value m -text $_allgText(PrintCalMonthView) -command togglePRdates -font $bfnt
    radiobutton $fwin.3.r -variable printMode -value l -text $_allgText(PrintCalListView) -command togglePRdates -font $bfnt
    radiobutton $fwin.5.r -variable printMode -value c -text $_allgText(PrintCalCurView) -command togglePRdates -font $bfnt
    pack $fwin.1.r $fwin.2.r $fwin.3.r $fwin.5.r -side left

    tixControl $fwin.1.d  -label "   $_allgText(PrintCalVom)" -min 0 -max 31 -integer 1  \
	-options {  entry.width 2 label.width 8 } -variable pwDay -selectmode immediate -autorepeat true
    tixControl $fwin.1.m -options { entry.width 2} -label "." -min 0 -max 12 -integer 1 -variable pwMon    -selectmode immediate -autorepeat true
    tixControl $fwin.1.y -options { entry.width 4} -label "." -min 1999 -max 2100 -integer 1  -variable pwYear   -selectmode immediate -autorepeat true
    pack $fwin.1.y $fwin.1.m $fwin.1.d -side right 
    $fwin.1.d subwidget label configure -font $bfnt
    $fwin.1.d subwidget entry configure -font $fnt
    $fwin.1.m subwidget label configure -font $bfnt
    $fwin.1.m subwidget entry configure -font $fnt
    $fwin.1.y subwidget label configure -font $bfnt
    $fwin.1.y subwidget entry configure -font $fnt
    $fwin.1.d  configure -state normal
    $fwin.1.m  configure -state normal
    $fwin.1.y  configure -state normal
    
    tixControl $fwin.2.m -options { entry.width 2 } -min 0 -max 12 -integer 1 -variable pwMon    -selectmode immediate -autorepeat true
    tixControl $fwin.2.y -options { entry.width 4} -label "." -min 1999 -max 2100 -integer 1  -variable pwYear   -selectmode immediate -autorepeat true
    pack $fwin.2.y $fwin.2.m  -side right 
    $fwin.2.m subwidget label configure -font $bfnt
    $fwin.2.m subwidget entry configure -font $fnt
    $fwin.2.y subwidget label configure -font $bfnt
    $fwin.2.y subwidget entry configure -font $fnt
    $fwin.2.m  configure -state disabled
    $fwin.2.y  configure -state disabled

    switch $calTyp {
	d { set prStartD $curDay
	    set prStartM $curMon
	    set prStartY $curYear
	    set prStopD $curDay
	    set prStopM $curMon
	    set prStopY $curYear
	}	
	w {
	    set shift  [ weekDayByDate $curDay $curMon $curYear]
	    set ret [calcDate $curDay $curMon $curYear [expr -1* $shift]]
	    set prStartD  [lindex $ret 0]
	    set prStartM  [lindex $ret 1]
	    set prStartY  [lindex $ret 2]
	    set ret [calcDate  $prStartD $prStartM $prStartY  7]
	    set prStopD  [lindex $ret 0]
	    set prStopM  [lindex $ret 1]
	    set prStopY  [lindex $ret 2]
	}
	m {
	    set prStartD  1
	    set prStartM $curMon
	    set prStartY $curYear
	    set shift  [ weekDayByDate 1 $curMon $curYear]
	    set ret [calcDate  $prStartD $prStartM $prStartY  [expr -1* $shift]]
	    set prStartD  [lindex $ret 0]
	    set prStartM  [lindex $ret 1]
	    set prStartY  [lindex $ret 2]

	    set prStopD [ lindex $monlen $curMon]
	    if {$curMon == 2} {
		if { [expr $curYear %4 ] == 0} {
		    incr prStopD
		}
	    }
	    set prStopM $curMon
	    set prStopY $curYear
	    set shift  [ weekDayByDate $prStopD $curMon $curYear]
	    set ret [calcDate  $prStopD $prStopM $prStopY  [expr 6-$shift]]
	    set prStopD  [lindex $ret 0]
	    set prStopM  [lindex $ret 1]
	    set prStopY  [lindex $ret 2]
	}
    }
    
    label $fwin.3.s -text "    " -font $fnt
    tixControl $fwin.3.d  -label $_allgText(PrintCalVom) -min 0 -max 31 -integer 1  \
	-options {  entry.width 2 label.width 8 } -variable prStartD -selectmode immediate -autorepeat true
    tixControl $fwin.3.m -options { entry.width 2} -label "." -min 0 -max 12 -integer 1 -variable prStartM -selectmode immediate -autorepeat true
    tixControl $fwin.3.y -options { entry.width 4} -label "." -min 1999 -max 2100 -integer 1  -variable prStartY -selectmode immediate -autorepeat true
    $fwin.3.d subwidget label configure -font $bfnt
    $fwin.3.d subwidget entry configure -font $fnt
    $fwin.3.m subwidget label configure -font $bfnt
    $fwin.3.m subwidget entry configure -font $fnt
    $fwin.3.y subwidget label configure -font $bfnt
    $fwin.3.y subwidget entry configure -font $fnt
    $fwin.3.d  configure -state disabled
    $fwin.3.m  configure -state disabled
    $fwin.3.y  configure -state disabled
    pack $fwin.3.y $fwin.3.m $fwin.3.d $fwin.3.s -side right
    
    label $fwin.4.s -text "    " -font $fnt
    tixControl $fwin.4.d  -label $_allgText(PrintCalBis) -min 0 -max 31 -integer 1  \
	-options {  entry.width 2 label.width 8 } -variable prStopD -selectmode immediate -autorepeat true
    tixControl $fwin.4.m -options { entry.width 2} -label "." -min 0 -max 12 -integer 1 -variable prStopM -selectmode immediate -autorepeat true
    tixControl $fwin.4.y -options { entry.width 4} -label "." -min 1999 -max 2100 -integer 1  -variable prStopY -selectmode immediate -autorepeat true
    $fwin.4.d subwidget label configure -font $bfnt
    $fwin.4.d subwidget entry configure -font $fnt
    $fwin.4.m subwidget label configure -font $bfnt
    $fwin.4.m subwidget entry configure -font $fnt
    $fwin.4.y subwidget label configure -font $bfnt
    $fwin.4.y subwidget entry configure -font $fnt
    $fwin.4.d  configure -state disabled
    $fwin.4.m  configure -state disabled
    $fwin.4.y  configure -state disabled
    pack $fwin.4.y $fwin.4.m $fwin.4.d $fwin.4.s -side right

#    canvas  .pr.c.c -width 580 -Aeight 866 -background white
}

proc printCalOptionsDialog { win } {
    global bfnt fnt12
    global pw_ignoInit pw_partLines
    global pw_skipWeekend
    global _allgText _buttonText


    pack $win -side top -fill x -pady 2  -padx 2

    set fwin [$win subwidget frame]
    frame $fwin.1 
    frame $fwin.2
    frame $fwin.3
    frame $fwin.4
    
    pack $fwin.1  $fwin.2 $fwin.3  $fwin.4 -side top -fill x -padx 3 -pady 3
    
    tixControl $fwin.2.t  -label $_allgText(PrintLinesPerList)  -min 0 -max 99 -integer 1  -labelside right \
	-options {  entry.width 2  } -variable pw_partLines -selectmode immediate -autorepeat true
    $fwin.2.t subwidget entry configure -font $bfnt
    checkbutton $fwin.3.i -text $_allgText(PrintIgnoreInit) -variable pw_ignoInit -font $bfnt
    checkbutton $fwin.4.i -text $_allgText(PrintIgnoreWeekEnd) -variable pw_skipWeekend -font $bfnt
    pack $fwin.2.t  $fwin.3.i $fwin.4.i -side left -padx 10
}

proc printCal {  } {
    global can selPrinter cputype printMode  env printFile

    if { $selPrinter == "nolp__file__" || $selPrinter ==  "nolp__gv____" } {
 	set file $printFile
    } else {
 	set file [format "/tmp/minko-%d-%d.ps" [pid] [currentTime] ]
    }

    openMeter "Printing" "Bereite Ausdruck vor" 1
    if {$printMode == "c" } {	
	$can postscript -colormode gray -file $file -rotate 1  -pageheight  19.0c -pagey 1.5c -pagex 1.5c -pageanchor nw
    } elseif {$printMode == "w" } {
	printWeekCal $file
    } elseif {$printMode == "m" } {
	printMonthCal $file
    } else  {
	fillPrintCanvas - $file
    }
    set ret [catch {set host $env(HOST)} ]
    if { $ret != 0 } { set host "???" }
	
     if { $selPrinter ==  "nolp__gv____" } {
 	set ret [ exec gv -media a4 $file &]
     } elseif { $selPrinter != "nolp__file__"  } {
	 set ret [exec lpr -P$selPrinter $file]	
	 file delete $file
     }

    closeMeter
    #file delete $file
}


#WochenKalender

proc printWeekCal {file} {
    global groupOnlyCommon showIgnore ignoreInfo selPrinter
    global username cur_Cal
    global pwDay pwMon pwYear 
    global pwvCan
    global pw_ignoInit pw_printNoPart

    set shift  [ weekDayByDate $pwDay $pwMon $pwYear]
    set ret [calcDate $pwDay $pwMon $pwYear [expr -1* $shift]]
    set pwDay  [lindex $ret 0]
    set pwMon  [lindex $ret 1]
    set pwYear [lindex $ret 2]
    set first [format "%04d%02d%02d"  $pwYear $pwMon $pwDay]
    set last [calcDate2dstr $first 6]


    set fid [open $file "w"]
    set fileName [file rootname $file ]

    set calList [request getUserCal $username  $cur_Cal $first $last  $showIgnore $ignoreInfo [expr 1 - $groupOnlyCommon]]
    if { $calList == "Error" } { return}
    #FIXME Sortierung nach Proritt und Zeit
    set calList [lsort -command compareCalEntries $calList]

    openPWView $cur_Cal $first $last
    updateMeter 5  "Hole Daten"

    set dstr  $first
    for { set d 0} { $d < 7 } {incr d} {
	set day($dstr) $d
	set dstr [calcDate2dstr $dstr  1]
    }
    set anz 0
    set allDatesList ""
    foreach date $calList { 
	set startD [lindex $date 0]
	set stopD [lindex $date 2]
	set did    [lindex $date 6]

	lappend allDatesList "$did $startD"
	if { $startD ==$stopD} {
	    set wd $day($startD)
	    lappend dateList($wd) "$did-$startD"
	    set datum($wd) $startD
	    incr anz
	} else {
	    set thisDate $startD
	    while { $thisDate <= $stopD } {
		set wd $day($thisDate)
		lappend dateList($wd) "$did-$startD"
		set datum($wd) $thisDate
		incr anz
		set thisDate [calcDate2dstr $thisDate 1]
		if { $thisDate > $last } {
		    break
		}
	    }
	}
    } 

    set y0byWd "44 44 316 316 588 588 724"
    set ymbyWd "288 288 560 560 832 696 832"
    set x0byWd "1 301 1 301 1 301 301"
    set x1byWd "300 600 300 600 300 600 600"

    set dc 0
    set list  [eval  request getMultiBriefDate $username [join $allDatesList ] ]
    if { $list == "Error" } { return}

    foreach ent $list {
	set did [lindex $ent 0]
	set startD [lindex $ent 2]
	set dateInfo($did-$startD) $ent
    }
    updateMeter 20  "Bereite Ausdruck vor"

    foreach wd [ array names dateList] {
	set isBlocked 0
	set x0 [lindex $x0byWd $wd]
	set xmax  [lindex $x1byWd $wd]
	set y0 [lindex $y0byWd $wd]
	set ymax [lindex $ymbyWd $wd]
	set pw_printNoPart 0
	foreach did $dateList($wd) {
	    updateMeter [expr int(floor(double($dc)/$anz*72)+20) ] "Bereite Ausdruck vor"
	    incr dc
	    set ent $dateInfo($did)

	    set titel [lindex $ent 1]
	    set startD [lindex $ent 2]
	    set startT [lindex $ent 3]
	    set stopD  [lindex $ent 4]
	    set stopT  [lindex $ent 5]
	    set room  [lindex $ent 6]
	    set part [lindex $ent 10]
	    set noTime [lindex $ent 13]
	    if { $isBlocked == 0 } {
		set einl ""
		set teiln ""
		foreach ent $part {
		    set name  [ lindex $ent 1]
		    set stat  [ lindex $ent 0]
		    set ugType [ lindex $ent 3]
		    if { $ugType == "g" } {   set name "Gruppe $name"}
		    if { $stat == "I" && $pw_ignoInit == 0 } { set einl "$einl $name," }
		    if { $stat == "E" } { set einl "$einl $name," }
		    if { $stat == "T" || $stat == "A" } { set teiln "$teiln $name," }
		}
		set ret [addDate2Canvas $x0 $y0 $xmax $ymax $datum($wd) $startD $startT $stopD $stopT $titel $room $einl $teiln $noTime ]
		if {$ret<0  } { 
		    set isBlocked 1
		    addMoreDates $x0 $y0
		} else {
		    set y0 $ret
		}
	    }	    
	}
    }
    updateMeter 92 "Bereite Ausdruck vor"
    update

    $pwvCan postscript  -colormode gray -file $file  -pagey 0.5c -pagex 0.40c -pageanchor sw 
    updateMeter 100 "Schicke Daten zum Drucker"
    update
    after 250
    update 
    destroy .pwv
}

proc openPWView {who from to } {
    global username fullUserNames curYear longProgName
    global pwvCan  cur_Cal
    global weekDays
    global hbfnt lbfnt bfnt fnt8 bfnt12
    global progname minkoVersion

    if { [ winfo exists .pwv] } { destroy .pwv}
    toplevel .pwv

    set start [date2Str $from]
    set stop [date2Str $to]

    tixCObjView .pwv.s -width 640 -height 870
    pack .pwv.s -side top
    wm iconify .pwv
#    wm withdraw .pwv
#    update 

    set pwvCan [.pwv.s subwidget canvas ]
    $pwvCan configure -height 850
    $pwvCan configure -width 610
    .pwv.s adjustscrollregion
    
    $pwvCan  create rectangle 1 1 601 25 -fill grey80 -outline black
#    set fwho $fullUserNames(u-$who)
    set fwho [calUserList2NameList $cur_Cal]

    set txt "Wochenkalender von $fwho von $start bis $stop"
    if { [font measure $lbfnt $txt] > 608 } {
	set txt "Wochenkalender von $start bis $stop   von"
	$pwvCan create text 301 2 -text $txt -justify center -anchor n -font $bfnt12
	set txt $fwho
	set l [ string length $txt]
	if {[font measure $bfnt12 $txt ] > 608 } { set txt "$txt ..." }
	while { [font measure $bfnt12 $txt ] > 608 } {
	    incr l -1
	    set txt "[string range $txt 0 $l] ..."
	} 
	$pwvCan create text 301 14 -text $txt -justify center -anchor n -font $bfnt12
    } else  {
	$pwvCan create text 301 5 -text $txt -justify center -anchor n -font $lbfnt
    }
    $pwvCan create rectangle 1  26 301 298 -fill white -outline black
    $pwvCan create rectangle 1 298 301 570 -fill white -outline black
    $pwvCan create rectangle 1 570 301 842 -fill white -outline black
    $pwvCan create rectangle 301  26 601 298 -fill white -outline black
    $pwvCan create rectangle 301 298 601 570 -fill white -outline black
    $pwvCan create rectangle 301 570 601 842 -fill white -outline black
    
    $pwvCan create rectangle 1  26 301  42 -fill grey90 -outline black
    $pwvCan create rectangle 1 298 301 314 -fill grey90 -outline black
    $pwvCan create rectangle 1 570 301 586 -fill grey90 -outline black
    $pwvCan create rectangle 301  26 601  42 -fill grey90 -outline black
    $pwvCan create rectangle 301 298 601 314 -fill grey90 -outline black
    $pwvCan create rectangle 301 570 601 586 -fill grey90 -outline black
    $pwvCan create rectangle 301 706 601 722 -fill grey90 -outline black

    set datum $from
    $pwvCan create text  10  30 -text [format "%s, den %s" [lindex $weekDays 0] [ date2Str $datum]] -justify left -anchor nw -font $bfnt
    set datum [calcDate2dstr $datum 1]
    $pwvCan create text 310  30 -text [format "%s, den %s" [lindex $weekDays 1] [ date2Str $datum]] -justify left -anchor nw -font $bfnt
    set datum [calcDate2dstr $datum 1]
    $pwvCan create text  10 302 -text [format "%s, den %s" [lindex $weekDays 2] [ date2Str $datum]] -justify left -anchor nw -font $bfnt
    set datum [calcDate2dstr $datum 1]
    $pwvCan create text 310 302 -text [format "%s, den %s" [lindex $weekDays 3] [ date2Str $datum]] -justify left -anchor nw -font $bfnt
    set datum [calcDate2dstr $datum 1]
    $pwvCan create text  10 574 -text [format "%s, den %s" [lindex $weekDays 4] [ date2Str $datum]] -justify left -anchor nw -font $bfnt
    set datum [calcDate2dstr $datum 1]
    $pwvCan create text 310 574 -text [format "%s, den %s" [lindex $weekDays 5] [ date2Str $datum]] -justify left -anchor nw -font $bfnt
    set datum [calcDate2dstr $datum 1]
    $pwvCan create text 310 710 -text [format "%s, den %s" [lindex $weekDays 6] [ date2Str $datum]] -justify left -anchor nw -font $bfnt
    
    $pwvCan create text 600 843 -text "created by $longProgName $minkoVersion ($curYear)" -justify right -anchor ne -font $fnt8
    
}

proc addDate2Canvas { x0 y0 xmax ymax thisDate startD start stopD stop title room einl teiln noTime} {
    global pwvCan amdy
    global bfnt10 fnt10 bfnt8 fnt8 pfnt8 pbfnt8 fnt7
    global pw_printNoPart pw_partLines

    set startTime [ time2Str $start]
    set stopTime  [ time2Str $stop]
    
    set x1 [ expr $x0 +2]
    set x1b [ expr $x0 +2]
    set x2 [ expr $x0 +30]
    set x3 [ expr $x0 +35]
    set x4 [ expr $x0 +60]
    set x5 [ expr $x0 +105]
    set x6 [ expr $x0 +105]
    set y1 [ expr $y0 +0 ]
    set y2 [ expr $y0 +10]
    set y3 [ expr $y0 +19]
    set y4 [ expr $y0 +19]
    
    set einl [string trim $einl ", "]
    set list(0) [string trim "$einl; $teiln" " ," ]
    set yl(0) $y4
    set lanz 0
    set l -1

    if {$pw_partLines ==0 } {set pw_printNoPart 1 }
    if { $pw_printNoPart == 0} {
	set dc ""
	set lw [ expr ($xmax - $x0) - 105 -4]
	set lastLine [ expr $pw_partLines -1]
	while { [string length $list($lanz) ] > 0 } {
	    incr lanz
	    incr l
	    set list($lanz) ""
	    set list($l) [string trim $list($l) " ,;" ]
	    set dc ","
	    set inName 0
	    while { [ font measure $fnt7 $list($l) ] > $lw } {
		set p1 [string last "," $list($l) ]
		set p2 [string last ";" $list($l) ]
		set p3 [string last " " $list($l) ]
		if { $p1 > $p2 } {
		    set p $p1
		    set dc ","
		} else  {
		    set p $p2
		    set dc ";"
		}
		if { $p3 > $p } {
		    set p $p3
		    set dc " "
		}
		set txt [string trim [string trim [ string range $list($l)  $p end ] " "] "," ]
		if { [string length $list($lanz) ] > 0 } { 
		    if { $dc != " " } {
			set list($lanz) "$dc$list($lanz)"
			set inName 0
		    } else {
			set inName 1
			set list($lanz) " $txt$list($lanz)"
		    }
		} else {
		    #		if { $dc == ";" } {
		    set list($lanz) "$dc$txt"
		    #		} else { 
		    #		    set list($lanz) $txt
		    #		}
		}
		incr p -1
		set list($l) [string range $list($l) 0 $p ]
	    }
	    #	set lw 170
	    if { [string length $list($lanz) ] > 0 || $dc == ";"} {
		set list($l) "$list($l)$dc"
	    }
	    if {$l == $lastLine } {
		if { $inName == 1} {
		    set p [string last "," $list($l) ]
		    set p2 [string last ";" $list($l) ]
		    if { $p2 > $p } {set p $p2}
		    set list($l)  [string range $list($l) 0 $p ]
		}
		set list($l) "$list($l) ..."
		if { [ font measure $fnt7 $list($l) ] > $lw } {
		    set p [string last "," $list($l) ]
		    set p2 [string last ";" $list($l) ]
		    if { $p2 > $p } {set p $p2}
		    set list($l)  [string range $list($l) 0 $p ]
		    set p [string last "," $list($l) ]
		    set p2 [string last ";" $list($l) ]
		    if { $p2 > $p } {set p $p2}
		    set list($l)  [string range $list($l) 0 $p ]
		    set list($l) "$list($l) ..."
		}

		break
	    }
	}
    }
    if { $lanz >1 } {
 	for { set l 1} {$l <$lanz } {incr l } {
	    set lp [expr $l -1]
 	    set yl($l) [expr $yl($lp) +8  ]
	    set ylm $yl($l)
 	}
    } else {
	set ylm $yl(0)
    }
    if { $pw_printNoPart == 1 } {
	set ylm [expr $y2+8]
    } else {
	incr ylm 9
    }
    if { $ylm > $ymax } {
	if { $pw_printNoPart == 0 } {
	    set pw_printNoPart 1
	    set ylm [expr $y2+9]
	    if { $ylm > $ymax } {return -1}
	} else  {
	    return -1
	}
    }

    if { $noTime == 1} {
	    $pwvCan create text $x1 $y1 -text "ganztgig" -font $fnt10 -justify left -anchor nw
    } else {
	if { $thisDate != $startD } {
	    if  {$thisDate != $stopD } {
		set startDate  [ date2Str $startD]
		set stopDate  [ date2Str $stopD]
		$pwvCan create text $x1  $y1 -text "$startDate," -font $fnt8 -justify left -anchor nw
		$pwvCan create text $x3  $y1 -text "$startTime" -font $fnt8 -justify left -anchor nw
		$pwvCan create text $x2  $y2 -text "-"       -font $fnt8 -justify left -anchor nw
		$pwvCan create text $x1  $y3 -text "$stopDate," -font $fnt8 -justify left -anchor nw
		$pwvCan create text $x3  $y3 -text "$stopTime" -font $fnt8 -justify left -anchor nw
	    } else  {
		set startDate  [ date2Str $startD]
		set stopDate  [ date2Str $stopD]
		$pwvCan create text $x1  $y1 -text "$startDate," -font $fnt8 -justify left -anchor nw
		$pwvCan create text $x3  $y1 -text "$startTime" -font $fnt8 -justify left -anchor nw
		$pwvCan create text $x2  $y2 -text "-"       -font $fnt8 -justify left -anchor nw
		$pwvCan create text $x3  $y2 -text "$stopTime" -font $fnt8 -justify left -anchor nw
	    }
	} else {
	    if { $startD == $stopD } {
		$pwvCan create text $x1 $y1 -text $startTime  -font $fnt8 -justify left -anchor nw
		$pwvCan create text $x2 $y1 -text "-"       -font $fnt8 -justify left -anchor nw
		$pwvCan create text $x3 $y1 -text $stopTime   -font $fnt8 -justify left -anchor nw
	    } else {
		set stopDate  [ date2Str $stopD]
		$pwvCan create text $x1  $y1 -text $startTime -font $fnt8 -justify left -anchor nw
		$pwvCan create text $x2  $y1 -text "-"       -font $fnt8 -justify left -anchor nw
		$pwvCan create text $x1  $y2 -text "$stopDate," -font $fnt8 -justify left -anchor nw
		$pwvCan create text $x3  $y2 -text "$stopTime" -font $fnt8 -justify left -anchor nw
		#	    $pwvCan create text $x3 $y3 -text $stopTime -font $fnt8 -justify left -anchor nw
	    }
	}
    }
    $pwvCan create text $x4 $y1 -text $title      -font $bfnt10 -justify left -anchor nw

    $pwvCan create text $x4 $y2 -text "Ort"          -font $fnt8 -justify left -anchor nw
    $pwvCan create text $x5 $y2 -text "$room"        -font $fnt8 -justify left -anchor nw
    if { $pw_printNoPart == 0 } {
	$pwvCan create text $x4 $y4 -text "Teilnehmer"   -font $fnt7 -justify left -anchor nw
	$pwvCan create text $x5 $yl(0) -text $list(0) -font $fnt7 -justify left -anchor nw
	for { set l 1} {$l <$lanz } {incr l } {
	    $pwvCan create text $x6 $yl($l) -text $list($l) -font $fnt7 -justify left -anchor nw
	}
    }
    return $ylm
}
proc addMoreDates { x0 y0} {
    global pwvCan  bfnt10
    
    $pwvCan create text [expr $x0+145] [expr $y0 +2] -text "... weitere Termine ... " -font $bfnt10 -justify center -anchor n

}

proc printMonthCal {file} {
    global groupOnlyCommon showIgnore ignoreInfo selPrinter
    global username cur_Cal
    global pwDay pwMon pwYear 
    global pwvCan
    global monlen
    global pw_ignoInit
    global pw_printNoPart 
    global pw_skipWeekend


    set dayCount [lindex $monlen $pwMon]
    if { [expr $pwYear %4] == 0  && $pwMon == 2} { incr dayCount}
    
    set shift  [ weekDayByDate 1 $pwMon $pwYear]
    set ret [calcDate 1 $pwMon $pwYear [expr -1* $shift]]
    set begDay  [lindex $ret 0]
    set begMon  [lindex $ret 1]
    set begYear [lindex $ret 2]
    set first [format "%04d%02d%02d"  $begYear $begMon $begDay]
    incr dayCount $shift
    
    set endDay [lindex $monlen $pwMon]
    if { [expr $pwYear %4] == 0  && $pwMon == 2} { incr endDay}
    set shift  [expr 6-[ weekDayByDate $endDay $pwMon $pwYear] ]
    set ret [calcDate $endDay $pwMon $pwYear  $shift ]
    set endDay  [lindex $ret 0]
    set endMon  [lindex $ret 1]
    set endYear [lindex $ret 2]
    set last [format "%04d%02d%02d"  $endYear $endMon $endDay]
    incr dayCount $shift

    set weekCount [expr int(floor($dayCount /7)) ]
    set over [expr $dayCount -7*$weekCount]




    set dstr  $first
    for { set w 0 } { $w < $weekCount } {incr  w} { set dayList($w) ""}
    set allDaysList ""
    for { set w 0 } { $w < $weekCount } {incr  w} {
	for { set d 0} { $d < 7 } {incr d} {
	    lappend dayList($w) $dstr 
	    set dstr [calcDate2dstr $dstr  1]
	    set week($w-$d) $w
	    set day($w-$d) $d
	}
	lappend allDaysList $dayList($w) 
    }
    


    set fid [open $file "w"]
    set fileName [file rootname $file ]

    set calList [request getUserCal $username  $cur_Cal $first $last  $showIgnore $ignoreInfo [expr 1 - $groupOnlyCommon]]
    if { $calList == "Error" } { return}

    #FIXME Sortierung nach Proritt und Zeit
    set calList [lsort -command compareCalEntries $calList]

    openPMView $cur_Cal $first $last $pwMon $weekCount 1170 1710

    updateMeter 5  "Hole Daten"

    set anz 0
    set allDatesList ""
    foreach date $calList { 
	set startD [lindex $date 0]
	set stopD [lindex $date 2]
	set did    [lindex $date 6]

	lappend allDatesList "$did $startD"
	if { $startD ==$stopD} {
	    set wn [lsearch -glob $allDaysList *$startD* ]
	    set wd [lsearch -exact $dayList($wn) $startD ]
	    lappend dateList($wn-$wd) "$did-$startD"
	    set datum($wn-$wd) $startD
	    incr anz
	} else {
	    set thisDate $startD
	    while { $thisDate <= $stopD } {
		set wn [lsearch -glob $allDaysList *$thisDate* ]
		set wd [lsearch -exact $dayList($wn) $thisDate ]
		lappend dateList($wn-$wd) "$did-$startD"
		set datum($wn-$wd) $thisDate
		incr anz
		set thisDate [calcDate2dstr $thisDate 1]
		if { $thisDate > $last } {
		    break
		}
	    }
	}
    } 

    global mpx_cal mpy_cal1 mpy_cal2 mpdy_cal mpx_right  mpy_bottom


    set lstart 0
    set adanz [llength $allDatesList ]
    while { $lstart < $adanz }  {
	set last [ expr $lstart +49 ]
	if { $last > $adanz } { set last "end" }
	set dc 0
#	set list  [eval  request getMultiBriefDate $username [join $allDatesList ] ]
	set list  [eval  request getMultiBriefDate $username [join [lrange $allDatesList $lstart $last ] ] ]
	if { $list == "Error" } { return}

	foreach ent $list {
	    set did [lindex $ent 0]
	    set startD [lindex $ent 2]
	    set dateInfo($did-$startD) $ent
	}
	incr lstart 50
    }
    updateMeter 20 "Bereite Ausdruck vor"

    foreach idx [ array names dateList] {
	set wd [ lindex [split $idx -] 1]
	if { $pw_skipWeekend == 1} {
	    if { $wd >4 } { continue} 
	}
	set x0 [expr $mpx_cal($day($idx)) +2]
	set x1 [expr $mpx_cal([expr $day($idx) +1]) ]
	set y0 [expr $mpy_cal1($week($idx)) +4 ]
	set y1 [expr $mpy_cal2($week($idx)) -16 ]
	set isBlocked 0
	set pw_printNoPart 0
	foreach did $dateList($idx) {
	    updateMeter [expr int(floor(double($dc)/$anz*72)+20) ] "bereite Ausdruck vor"
	    incr dc
	    set ent $dateInfo($did)
	    set did   [lindex $ent 0]
	    set titel [lindex $ent 1]
	    set startD [lindex $ent 2]
	    set startT [lindex $ent 3]
	    set stopD  [lindex $ent 4]
	    set stopT  [lindex $ent 5]
	    set room  [lindex $ent 6]
	    set part [lindex $ent 10]
	    set noTime [lindex $ent 13]
	    if { $isBlocked == 0 } {
		set einl ""
		set teiln ""
		foreach ent $part {
		    set name  [ lindex $ent 1]
		    set stat  [ lindex $ent 0]
		    set ugType [ lindex $ent 3]
		    if { $ugType == "g" } {   set name "Gruppe $name"}
		    if { $stat == "I" && $pw_ignoInit == 0 } { set einl "$einl $name," }
		    if { $stat == "E" } { set einl "$einl $name," }
		    if { $stat == "T" || $stat == "A" } { set teiln "$teiln $name," }
		}
		set ret [addDate2MonthCanvas $x0 $y0 $x1 $y1 $datum($idx) $startD $startT $stopD $stopT $titel $room $einl $teiln $noTime ]
		if {$ret<0  } { 
		    set isBlocked 1
		    addMoreDatesinMonth [expr int(floor(($x0+$x1)/2))] $y0
		} else {
		    set y0 $ret
		}
	    }
	}
    }  

    updateMeter 92 "Bereite Ausdruck vor"
    update
    $pwvCan postscript  -colormode gray -file $file  -pagewidth  19.5c -pageheight 28.5c -width $mpx_right -height $mpy_bottom  -pagey 0.5c -pagex 10.75c -pageanchor s 
    updateMeter 100 "Schicke Daten zum Drucker"
    destroy .pwv  

}
proc openPMView { who from to mon   weekCount cwidth cheight } {
    global username fullUserNames curYear longProgName
    global pwvCan 
    global weekDays monNames
    global hbfnt lbfnt bfnt fnt10 bfnt10 fnt12 bfnt12 fnt8 bfnt8
    global mpx_cal mpy_cal1 mpy_cal2 mpdy_cal mpx_right  mpy_bottom
    global pw_skipWeekend

    if { [ winfo exists .pwv] } { destroy .pwv}
    toplevel .pwv

    set start [date2Str $from]
    set stop [date2Str $to]
    
    tixCObjView .pwv.s -width 620 -height 866
    pack .pwv.s -side top
    wm iconify .pwv
    wm withdraw .pwv

    set pwvCan [.pwv.s subwidget canvas ]
    $pwvCan configure -height $cwidth
    $pwvCan configure -width $cheight
    .pwv.s adjustscrollregion

    set mpy_title 1
    set mpy_head  43
    set mpy_weekStart 58
    set dy [ expr int(floor(($cheight - $mpy_weekStart -12)/ $weekCount)) ]
    set mpdy_cal [expr $dy -10]


    for { set w 0 } {$w <= $weekCount} {incr w} {
	set mpy_cal0($w) [expr $w * $dy + $mpy_weekStart ]
	set mpy_cal1($w) [expr $w * $dy + $mpy_weekStart + 12]
	set mpy_cal2($w) [expr $w * $dy + $mpy_weekStart + $dy]
    }
    set mpy_foot [expr $weekCount * $dy + $mpy_weekStart +2]
    set mpy_bottom [expr $mpy_foot +10]

    set mpx_center [expr int(floor($cwidth /2))]
    set mpx_left 1
    if { $pw_skipWeekend == 1} {
	set weekDayAnz 5
    } else {
	set weekDayAnz 7
    }

    set mpdx [ expr int(floor( ($cwidth-1)/$weekDayAnz))]
    for { set w 0 } { $w <=$weekDayAnz } {incr w} {
	set mpx_cal($w) [expr $mpx_left + $w * $mpdx ]
	set mpx_calCenter($w) [expr int(floor($mpx_left + $w * $mpdx +$mpdx/2))]
    }
    set mpx_right [expr $mpx_left + $weekDayAnz * $mpdx ]
    
    
    $pwvCan  create rectangle $mpx_left $mpy_title $mpx_right $mpy_head -fill grey80 -outline black
    set fwho [calUserList2NameList $who]
    $pwvCan create text $mpx_center [expr $mpy_title+4] -text "Monatskalender [lindex $monNames $mon] fr" -justify center -anchor n -font $lbfnt
    $pwvCan create text $mpx_center [expr $mpy_title+24] -text $fwho -justify center -anchor n -font $lbfnt

    wm title .pwv "Monatskalender [lindex $monNames $mon] fr $fwho"

    $pwvCan  create rectangle $mpx_left  $mpy_head  $mpx_right $mpy_weekStart -fill grey90 -outline black
    for { set d 0 } { $d < $weekDayAnz } {incr d } {
	$pwvCan create text $mpx_calCenter($d) [expr $mpy_head +4] -text [lindex $weekDays $d] -font $bfnt12 -justify center -anchor n
	$pwvCan create line $mpx_cal($d) $mpy_head $mpx_cal($d) $mpy_cal1(0) -fill black
    }
    $pwvCan create line $mpx_cal($weekDayAnz) $mpy_head $mpx_cal($weekDayAnz) $mpy_cal1(0) -fill black
    set datum $from
    for {set w 0 } { $w< $weekCount} {incr w} {
	for { set d 0 } { $d < $weekDayAnz} {incr d } {
	    set dr [expr $d +1]
	    $pwvCan create rectangle $mpx_cal($d) $mpy_cal1($w) $mpx_cal($dr) $mpy_cal2($w) -fill white -outline black
	    $pwvCan create rectangle $mpx_cal($d) $mpy_cal0($w) $mpx_cal($dr) $mpy_cal1($w) -fill grey95 -outline black
	    $pwvCan create text [expr $mpx_cal($d)+2 ] [expr $mpy_cal0($w) +3] -text [ date2Str $datum] -justify left -font $fnt10 -anchor nw
	    set datum [calcDate2dstr $datum 1]
	}
	if { $pw_skipWeekend == 1} {
	    #Wochenend durchspulen
	    set datum [calcDate2dstr $datum 1]
	    set datum [calcDate2dstr $datum 1]
	}
    }
    $pwvCan create text $mpx_right $mpy_foot -text [format "%c %d by %s" 169 $curYear $longProgName] -anchor ne -justify right -font $fnt10

}


proc addDate2MonthCanvas { x0 y0 xmax ymax thisDate startD start stopD stop title room einl teiln noTime} {
    global pwvCan amdy
    global bfnt8 fnt8 bfnt6 fnt6 pfnt6 pbfnt6 fnt10 bfnt10 fnt12 bfnt12 bfnt11
    global pw_printNoPart pw_partLines
    global pw_skipWeekend

    set startTime [ time2Str $start]
    set stopTime  [ time2Str $stop]
    
    set x1 [ expr $x0 +6]
    set x2 [ expr $x0 +52]
    set x3 [ expr $x0 +60]
    set x2b [ expr $x0 +72]
    set x3b [ expr $x0 +80]
    set x2c [ expr $xmax -76]
    set x3c [ expr $xmax -68]
    if { $pw_skipWeekend == 1} {
	set x2b [ expr $x0 +82]
	set x3b [ expr $x0 +90]
	set x2c [ expr $xmax -96]
	set x3c [ expr $xmax -88]
    }

    set xt [ expr $x0 +2 ]
    set xl [ expr $x0 +6 ]
    set xc [ expr $x0 +60]
    set y1 [ expr $y0 +0 ]
    set y2 [ expr $y0 +10]
    set y3 [ expr $y0 +19]
    set y4 [ expr $y0 +28]
    
    set einl [string trim $einl ", "]
    set list(0) [string trim "$einl, $teiln" " ," ]
    set yl(0) $y4
    set lanz 0
    set l -1

    set width [expr ($xmax - $x0)]
    set lw [ expr $width  - 58  ]

    if {$pw_partLines ==0 } {set pw_printNoPart 1 }
    if { $pw_printNoPart == 0} {
	set dc ""
	set lastLine [ expr $pw_partLines -1]
	while { [string length $list($lanz) ] > 0 } {
	    incr lanz
	    incr l
	    set list($lanz) ""
	    set list($l) [string trim $list($l) " ,;" ]
	    set dc ","
	    set inName 0
	    while { [ font measure $fnt10 $list($l) ] > $lw } {
		set p1 [string last "," $list($l) ]
		set p2 [string last ";" $list($l) ]
		set p3 [string last " " $list($l) ]
		if { $p1 > $p2 } {
		    set p $p1
		    set dc ","
		} else  {
		    set p $p2
		    set dc ";"
		}
		if { $p3 > $p } {
		    set p $p3
		    set dc " "
		}
		set txt [string trim [string trim [ string range $list($l)  $p end ] " "] "," ]
		if { [string length $list($lanz) ] > 0 } { 
		    if { $dc != " " } {
			set list($lanz) "$dc$list($lanz)"
			set inName 0
		    } else {
			set inName 1
			set list($lanz) " $txt$list($lanz)"
		    }
		} else {
		    #		if { $dc == ";" } {
		    set list($lanz) "$dc$txt"
		    #		} else { 
		    #		    set list($lanz) $txt
		    #		}
		}
		incr p -1
		set list($l) [string range $list($l) 0 $p ]
	    }
	    if { [string length $list($lanz) ] > 0 || $dc == ";"} {
		set list($l) "$list($l)$dc"
	    }
	    if {$l == $lastLine } {
		if { $inName == 1} {
		    set p [string last "," $list($l) ]
		    set p2 [string last ";" $list($l) ]
		    if { $p2 > $p } {set p $p2}
		    set list($l)  [string range $list($l) 0 $p ]
		}
		set list($l) "$list($l) ..."
		if { [ font measure $fnt10 $list($l) ] > $lw } {
		    set p [string last "," $list($l) ]
		    set p2 [string last ";" $list($l) ]
		    if { $p2 > $p } {set p $p2}
		    set list($l)  [string range $list($l) 0 $p ]
		    set p [string last "," $list($l) ]
		    set p2 [string last ";" $list($l) ]
		    if { $p2 > $p } {set p $p2}
		    set list($l)  [string range $list($l) 0 $p ]
		    set list($l) "$list($l) ..."
		}

		break
	    }
	}
    }

    if { $lanz >1 } {
 	for { set l 1} {$l <$lanz } {incr l } {
	    set lp [expr $l -1]
 	    set yl($l) [expr $yl($lp) +9  ]
	    set ylm $yl($l)
 	}
    } else {
	set ylm $yl(0)
    }

    if { $pw_printNoPart == 1 } {
	set ylm [expr $y3+8]
    } else {
	incr ylm 11
    }
    if { $ylm > $ymax } {
	if { $pw_printNoPart == 0 } {
	    set pw_printNoPart 1
	    set ylm [expr $y3+9]
	    if { $ylm > $ymax } {return -1}
	} else  {
	    return -1
	}
    }
#    incr ylm 12
#     if { $ylm > $ymax } {
# 	return -1}

    if { $noTime == 1} {
	    $pwvCan create text $x1 $y2 -text "ganztgig" -font $fnt10 -justify left -anchor nw
    } else {
	if { $thisDate != $startD } {
	    if  {$thisDate != $stopD } {
		set startDate  [ date2Str $startD]
		set stopDate  [ date2Str $stopD]
		$pwvCan create text $x1  $y2 -text "$startDate, $startTime" -font $fnt10 -justify left -anchor nw
		$pwvCan create text $x2c $y2 -text "-"       -font $fnt10 -justify left -anchor nw
		$pwvCan create text $x3c $y2 -text "$stopDate, $stopTime" -font $fnt10 -justify left -anchor nw
	    } else  {
		set startDate  [ date2Str $startD]
		set stopDate  [ date2Str $stopD]
		$pwvCan create text $x1  $y2 -text "$startDate, $startTime" -font $fnt10 -justify left -anchor nw
		$pwvCan create text $x2b $y2 -text "-"       -font $fnt10 -justify left -anchor nw
		$pwvCan create text $x3b $y2 -text "$stopTime" -font $fnt10 -justify left -anchor nw
	    }
	} else {
	    if { $startD == $stopD } {
		$pwvCan create text $x1 $y2 -text $startTime  -font $fnt10 -justify left -anchor nw
		$pwvCan create text $x2 $y2 -text "-"       -font $fnt10 -justify left -anchor nw
		$pwvCan create text $x3 $y2 -text $stopTime   -font $fnt10 -justify left -anchor nw
	    } else {
		set stopDate  [ date2Str $stopD]
		$pwvCan create text $x1 $y2 -text $startTime -font $fnt10 -justify left -anchor nw
		$pwvCan create text $x2c $y2 -text "-"       -font $fnt10 -justify left -anchor nw
		$pwvCan create text $x3c $y2 -text "$stopDate, $stopTime" -font $fnt10 -justify left -anchor nw
	    }
	}
    }
    set titel $title
    set w [expr $width - 12]
    set len [ string length $title]
    set tl [font measure $bfnt11 $titel ]
    while { $tl > $w } { 
	incr len -1
	set titel "[ string range $title 0 $len] ..."
	set tl [font measure $bfnt11 $titel ]
    }
    $pwvCan create text $xt $y1 -text $titel  -font $bfnt11 -justify left -anchor nw

    set raum $room
    set len [ string length $room]
    set tl [font measure $fnt10 $raum ]
    while { $tl > $lw } { 
	incr len -1
	set raum "[ string range $room 0 $len] ..."
	set tl [font measure $fnt10 $raum ]
    }
    $pwvCan create text $xl $y3 -text "Ort"          -font $fnt10 -justify left -anchor nw
    $pwvCan create text $xc $y3 -text "$raum"        -font $fnt10 -justify left -anchor nw
    if { $pw_printNoPart == 0 } {
	$pwvCan create text $xl $y4 -text "Teilnehmer"   -font $fnt10 -justify left -anchor nw
	$pwvCan create text $xc $yl(0) -text $list(0) -font $fnt10 -justify left -anchor nw
	for { set l 1} {$l <$lanz } {incr l } {
	    $pwvCan create text $xc $yl($l) -text $list($l) -font $fnt10 -justify left -anchor nw
	}
    }
    return $ylm
}
proc addMoreDatesinMonth { x0 y0} {
    global pwvCan  bfnt8 bfnt10
    
    $pwvCan create text [expr $x0] [expr $y0+2] -text "... weitere Termine ... " -font $bfnt10 -justify center -anchor n

}


#Liste


proc fillPrintCanvas {win bfile} {
    global cur_Cal groupOnlyCommon username showIgnore ignoreInfo
    global bfnt12 fnt12 fnt10
    global userList groupList roomList partStatusStr
    global prStartD prStartM prStartY prStopD prStopM prStopY
    global pw_ignoInit
    global pw_skipWeekend

    set first [format "%04d%02d%02d" $prStartY $prStartM $prStartD]
    set last  [format "%04d%02d%02d" $prStopY $prStopM $prStopD]
    set calList [request getUserCal $username  $cur_Cal $first $last  $showIgnore $ignoreInfo [expr 1 - $groupOnlyCommon]]
    if { $calList == "Error" } { return}

#    if { [string first $calList "ServerDown"] >=0 } {ServerDownDialog}

    if { [ winfo exists .pwv] } { destroy .pwv}
    toplevel .pwv
    tixCObjView .pwv.s -width 620 -height 866
    pack .pwv.s -side top
    wm iconify .pwv
    wm withdraw .pwv

    set win [.pwv.s subwidget canvas ]
    $win configure -height 842
    $win configure -width 595
    .pwv.s adjustscrollregion

    set x1 2
    set x2 [expr $x1 +100] 
    set x3 [expr $x1 +158] 
    set x4 [expr $x1 +218]
    set xw 580
    set ymax 800
    set yh 832

    set file "$bfile.tmp"
    set fid [open $file "w"]

    set fc 0
    set dy 18
    set dy2 4
    set dy3 12
    set lc 0
    set calList [lsort -command compareCalEntries2 $calList]
    set anz [llength $calList]
    set allDatesList ""
    foreach date $calList { 
	set startD [lindex $date 0]
	set did    [lindex $date 6]
	lappend allDatesList "$did $startD"
    }

    set ystart [drawListPrintPageHead $win 1 $xw $yh ]
    set y $ystart

    set dateList [eval  request getMultiBriefDate $username [join $allDatesList ] ]
    if { $dateList == "Error" } { return}

    foreach ent $dateList { 
	updateMeter [expr int(floor(double($lc)/$anz*100)) ] "Bereite Ausdruck vor"
	set titel [lindex $ent 1]
	set startD [lindex $ent 2]
	set startT [lindex $ent 3]
	set stopD  [lindex $ent 4]
	set stopT  [lindex $ent 5]
	set room  [lindex $ent 6]
	set details [lindex $ent 7]
	set priv ""
 	if { [lindex $ent 9] == 1} { set priv "gruppeninterner Termin"}
 	if { [lindex $ent 8] == 1} { set priv "privater Termin "}
	set part [lindex $ent 10]
 	set group [lindex $ent 11]
 	set repTyp [lindex $ent 12]
	set noTime [lindex $ent 13]
	


	set startWD [weekDayByDateStr $startD]
	if { $startD == $stopD} {
	    if { $startWD >4} {
		continue
	    }
	}
 	
 	set m0 [expr $startT %100]
 	set h0 [expr ($startT -$m0 ) /100 ]
 	set m1 [expr $stopT %100]
 	set h1 [expr ($stopT -$m0 ) /100 ]
 	set uList ""
 	foreach ent $part {
 	    set name  [ lindex $ent 1]
 	    set stat  [ lindex $ent 2]
 	    set ugType [ lindex $ent 3]
	    if { [lindex $ent 0] != "I" || $pw_ignoInit == 0 } {
		set uList [format "%s%s (%s), " $uList $name [lindex $partStatusStr $stat]]
	    }
 	}
	incr y 2

	set yl [expr $y -6]
 	$win create line 0 $yl $xw $yl
	if {$noTime == 1} {
	    $win create text $x1 $y -font $fnt12 -text [format "%s" [date2lstr $startD] ] -anchor nw
	    $win create text $x2 $y -font $fnt12 -text [format "-  %s" [date2lstr $stopD] ] -anchor nw
	} else {
	    $win create text $x1 $y -font $fnt12 \
		-text [format "%s, %2d:%02d" [date2lstr $startD] $h0 $m0 ] -anchor nw
	    $win create text $x2 $y -font $fnt12 \
		-text [format "-  %s, %2d:%02d" [date2lstr $stopD] $h1 $m1] -anchor nw
	}
 	$win create text $x4 $y -font $bfnt12  -text  [strTrunc  $titel 45 ] -anchor nw


 	incr y $dy3
 	$win create text $x3 $y -font $fnt10 -text "Ort " -anchor nw
 	$win create text $x4 $y -font $fnt10 -text $room    -width 320 -anchor nw 
 	incr y $dy3
 	$win create text $x3 $y -font $fnt10 -text "Details: " -anchor nw
 	$win create text $x4 $y -font $fnt10 -text $details -width 320 -anchor nw -tag o$lc
	set yl [ lindex [ $win bbox o$lc ] 3]
	while {$y< $yl } {incr y $dy3}

 	$win create text $x3 $y -font $fnt10 -text "Teilnehmer: " -anchor nw
 	$win create text $x4 $y -font $fnt10 -text $uList -width 320 -anchor nw -tag p$lc
	set yl [ lindex [ $win bbox p$lc ] 3]
	while {$y< $yl } {incr y $dy3}

 	if { $priv != "" } {
 	    $win create text $x4 $y -font $fnt10 -text $priv -anchor nw
 	    incr y $dy3
 	}
	incr y $dy2
	incr lc
	if { $y > $ymax } {
	    update
	    set txt [$win  postscript  -colormode gray -pagewidth  19.5c -width 580 -pageheight 27c -height $yh -pagey 0c -pageanchor s]
	    if { $fc == 0 } { 
		set pstext $txt 
		set p1 [string first "%%Trailer" $txt]
		incr p1 -1
		set txt [string range $txt 0 $p1 ]
#		set p0 [expr [string first "%%Pages:" $txt] + 9]
#		set txt [string replace $txt $p0 $p0 "$fc"]  
		puts $fid $txt
	    } else {
		set pn [expr $fc+1]
		set p0 [string first "%%Page: " $txt]
		set p1 [string first "%%Trailer" $txt]
		incr p1 -1
		set txt [string range $txt $p0 $p1]
		#		set txt [string replace  $txt 8 10 "$pn $pn"]  
		set txt "[string range $txt 0 7] $pn $pn [string range $txt 10 end]"
		puts $fid $txt
	    }
	    
	    incr fc
	    $win delete all
	    set ystart [drawListPrintPageHead $win [expr $fc+1] $xw $yh]
	    set y $ystart
	}
    }
    if {$y >$ystart} {
	update
	puts $fid [$win  postscript -colormode gray -pagewidth  19.5c -width 580 -pageheight 27c -height $yh -pagey 0c -pageanchor s]
	incr fc
    }
    if {$fc > 1 } {
	set p1 [string first "%%Trailer" $pstext]
	puts $fid [string range $pstext  $p1 end]
    }
    close $fid

    set fid [open $file "r"]
    set oid [open $bfile "w"]
    set incomment 1
    while { ! [eof $fid ] } {
	set line [gets $fid]
	if { [string first $line "%%EndComments"] == 0 } {set incomment 0}
	if { [string first $line "%%Pages:"] == 0  && $incomment == 1 } {
	    puts $oid "%%Pages: $fc"
	} else {
	    puts $oid $line
	}
    }
    close $fid
    close $oid
    file delete $file
    destroy .pwv
    
#    closeMeter
}
proc drawListPrintPageHead {win pn w h } {
    global cur_Cal  lbfnt fullUserNames fnt8 progname minkoVersion tyear
    global prStartD prStartM prStartY prStopD prStopM prStopY

    set xm [expr $w /2]
    set xr [expr $w -1]
    set yu [expr $h -10]
    set yc [expr $yu +2]

    $win create rectangle 0 0 $xr $yu -outline black -fill white 
    set dates [format "von %2d.%2d.%4d bis %2d.%2d.%4d" $prStartD $prStartM $prStartY $prStopD $prStopM $prStopY ]
    $win create text $xm 5 -anchor n -justify center -text "Kalender $dates" -font $lbfnt -tag "calTitle"
    set names ""
    foreach ent $cur_Cal { 
	set names ", $fullUserNames($ent)"
    }
    set names [string trimleft $names ", "]
    $win create text $xm 25 -anchor n -justify center -text "fr $names" -font $lbfnt -width 500 -tag "calNames calTitle"
    set y [ lindex [$win bbox calNames] 3]
    $win create rectangle 0 0 $xr $y  -outline black -fill grey90 -tag "calHead"
    $win lower calHead calTitle
    incr y 4
    
    $win create text 1 $yc -anchor nw -justify left -text "Seite $pn" -font $fnt8
    $win create text $xr $yc -anchor ne -justify right -text [format "%c $tyear by $progname $minkoVersion" 169 ] -font $fnt8
    
    return $y
}

