/* File: reminder.cc
 *
 *     This file is part of minkowsky
 *
 *     Copyright (C) 2001-2002 by Rdiger Goetz
 *     Author: Rdiger Goetz <minkowsky@r-goetz.de>
 *
 *     Time-stamp: <19-Apr-2002 17:15:00 goetz>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <math.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <unistd.h>  
#include <errno.h>    
#include <netinet/in.h>  
#include <fcntl.h>  
#include <netdb.h>
#include <tcl.h>
#include <tk.h>
#include <tix.h>
#include <time.h>     
#include <signal.h>     
#include <sys/poll.h>              

#define MAX_CLIENTS 1000
#ifndef MASTERPORT
#define MASTERPORT  41999
#endif

#define REMINDER_EINLADUNG  0x0100
#define REMINDER_ERINNERUNG 0x0200
#define REMINDER_MAHNUNG    0x0400
#define REMINDER_SHIFT      0x0800

//struct sockaddr_in mySocketAddress,masterSocketAddress;
int port,masterPort=MASTERPORT;
int mySocket,masterSocket;
char binPath[1024],terminHost[256],testBinPath[256];
char curUserName[32], curPasswd[32];
int socketsUp=false;

int useTestBin=false;

int logIntoServer ();
int check4MasterMessage(int socket,char *t, int l);
char *skip2nonWS(char *t);
void closeApp(int value);
int send2Socket(int socket,char *msg);
int openSocket(char *master,int port);
char *wait4Message(int socket, char *t,int l);
int closeSocket ();
int split(char *txt,char **tp ,int max);
void startTCL();
int check4Event(ClientData cData, Tcl_Interp *interp, int argc, char *argv[]);
int reconnect(ClientData cData, Tcl_Interp *interp, int argc, char *argv[]);
int initApsh(Tcl_Interp *interp); 
int closeSocket ();

int verbose=true;

int main(int argc, char *argv[])
{
 char buffer[16384],*p,*p2=NULL,*p3=NULL,file[1024],*t,*s;
 int off=0,ac;
 FILE *fp;
 int useTestBin=false;
 char testBinPath[1024];
 char cmd[256],*tp[16];
 int canz;
 char configFile[1024];

 strcpy(configFile,"/etc/minkowsky");
 off=0;
 ac=1;
 while(ac <argc)
  {
   if (strcmp(argv[ac],"-f")==0)
    {
     ac++;
     strcpy(configFile,argv[ac]);
     off++;
    }
   else if (strcmp(argv[ac],"-bin")==0)
    {
     useTestBin=true;
     ac++;
     strcpy(testBinPath,argv[ac]);
     off++;
    }
   off++;
   ac++;
  }
 argc -= off;
 
 strcpy(binPath,"");
 strcpy(terminHost,"");

 fp=fopen(configFile,"r");
 if(fp!=NULL)
  {
   p=fgets(buffer,8190,fp);
   while(p!=NULL)
    {
     if(strncmp(buffer,"MINKO_PATH",10)==0)
      {
       t=skip2nonWS(buffer+11);
       s= t+strlen(t)-1;
       if(*s=='\n')
	*s='\0';
       sprintf(binPath,"%s/client",t);
      }
     else if (strncmp(buffer,"MINKO_SERVER",12)==0)
       {
       t=skip2nonWS(buffer+13);
       s= t+strlen(t)-1;
       if(*s=='\n')
	*s='\0';
       strcpy(terminHost,t);
      }
     p=fgets(buffer,8190,fp);
   
    }
  }


 p=getenv("MINKO_PATH");
 if(p==NULL)
   p=getenv("TERMIN_BIN_PATH");

 if(p!=NULL)
  {
   p[strlen(p)-1]='\0';
   t=strrchr(p,'/');
   *t='\0';
  }

 if(p!=NULL)
  if(binPath[0]=='\0')
   sprintf(binPath,"%s/client",p);

 if(useTestBin)
  strcpy(binPath,testBinPath);

 p=getenv("MINKO_SERVER");
 if(p==NULL)
  p=getenv("TERMIN_HOST");
 
 if(p!=NULL)
  if(terminHost[0]=='\0')
   strcpy(terminHost,p);
 if(terminHost[0]=='\0')
  strcpy(terminHost,"localhost");


 // strcpy(binPath,"/home/goetz/projects/minko/termin/client");
 

 signal(SIGTERM,closeApp);  
 signal(SIGINT ,closeApp);  

 int wt = 5;
 while ( !logIntoServer())
  {
   fprintf(stderr,"Server not responding retrying\n");
   sleep(wt);
   if(wt<120) 
    wt=wt*2;
  }

 startTCL();

}



int logIntoServer ()
{
 char cmd[256],buffer[16384];

 mySocket= openSocket(terminHost,MASTERPORT);
 sprintf(cmd,"openReminder %s",getenv("USER"));
 send2Socket(mySocket,cmd);
 wait4Message(mySocket,buffer,16383);
 if(verbose)
  printf("Got %s from %s \n",buffer,terminHost);
 if ( strcmp(buffer,"noResource")==0)
  {
   fprintf(stderr,"Error {Server berlastet}\n");
   return false;
  }
 if ( strcmp(buffer,"noConnection")==0)
  {
   fprintf(stderr,"Error (Port berlastet)}");
   return false;
  }
 usleep(10000);
 return(true);
}
int openSocket(char *master,int port)
{
 struct hostent     *he;
 struct sockaddr_in  server;
 int ret,flg;
 int lsocket;

 lsocket=socket(AF_INET,SOCK_STREAM,0);

 if ((he = gethostbyname(master)) == NULL)
  {
   puts("error resolving hostname..");
   exit(1);
  }

 memcpy(&server.sin_addr, he->h_addr_list[0], he->h_length);
 server.sin_family = AF_INET;
 server.sin_port = htons(port);

 ret=connect(lsocket, (struct sockaddr *)&server, sizeof(server));
 flg = fcntl(lsocket, F_SETFL, O_NONBLOCK);
 if(verbose)
  printf("ret=%d, lsocket=%d\n",ret,lsocket);
 return(lsocket);
}
 
int send2Socket(int socket,char *msg)
{
 int ret;
 if(verbose)
  printf("sending %s \n",msg);

 ret=send(socket,msg,strlen(msg)+1,0);
 return(ret);
}
char *wait4Message(int socket, char *t,int l)
{
 int ret,tl,rt=3;
 char *s;
 struct pollfd ps={socket,POLLIN,0};
 int timeout=500000;
 int retries =8;
 int slp=500000;

 *t='\0';
 ret=0;
 tl=0;
 for(;; )
  {
   while((ret=poll(&ps,(unsigned int) 1,timeout))<1)
    {
     if(verbose)
      printf("server down %d %d\n",ret,ps.revents);
     usleep(slp);
     slp *= 2;
     retries --;
     if(retries<0)
      return(NULL);
    }
   ret =recv(socket,t+tl,l-tl,0);
   if(ret>0)
    {
     tl+=ret;
     //     tl--; //(null char abtrennen)
     s= t+tl-4;
     //     printf("\n+++++++++++++++++++++++++++++msg='%s' \t TERM='%s'\n",t,s);
     if(s[0]=='E')
      if(s[1]=='O')
       if(s[2]=='T')
	{
	 //	 printf("goet term\n");
	 break;
	}
    }
   else
    {
     rt--;
     if(rt==0)
      break;
    }
  }
 if(ret>0)
  {
   //   printf("got '%s'\n",t);
   *s='\0';
   return(t);
  }
 return(NULL);
}

int check4MasterMessage(int socket,char *t, int l)
{
 char buffer[16384];
 int ret,tl,ttl=16,st=2000;
 ret=recv(socket,t,l,0);
 if(ret>0)
  {
   tl=ret;
   while(t[tl-1] !='\0')
    {
     ret=recv(socket,buffer,1024,0);
     if(ret>0)
      {
       strcat(t,buffer);
       tl +=ret;
      }
     else
      {
       if(ttl<=0)
	break;
       printf("trying to get data from client ; ttl=%d\n",ttl);
       usleep(st);
       st =st*2;
       ttl--;
      }
    }
   return(ret);
  }
 return(-1);
}


char *skip2nonWS(char *t)
{
 while(*t==' ' || *t== '\t')
  {
   if(*t=='\n' || *t=='\0')
    return(NULL);
   t++;
  }
 if(*t=='\n' || *t=='\0')
  return(NULL);
 return(t);
}
void closeApp(int value)
{
 send2Socket(mySocket,"exit");

 closeSocket();
 if(verbose)
  printf("Terminator-Client terminates %d\n",value);
 usleep(500000);
 exit(0);
}
int closeSocket ()
{
 int ret;
 ret = shutdown(mySocket,2);
 ret = close(mySocket);
 if(verbose)
  printf("mysocket closed ret=%d\n",ret);
 mySocket=-1;
}
int split(char *txt,char **tp ,int max)
{
 int sc=0,bc=0,qc=0;
 int i=0,anz;
 char *s,*t;

 s=skip2nonWS(txt);
 if(s==NULL)
  tp[0]=txt;
 else
  {
   tp[i]=s;
   i++;

   for(t=s; *t!='\0'; t++)
    {
     // Alle "" '' {}-Blcke dedektieren
     if(sc==0 && qc==0) // In Quotes und strings nicht nach {}-Blcken suchen
      {
       if(*t=='{')
	bc++;
       if(*t=='}')
	bc--;
      }
     if(*t=='"')
      sc =sc ^1;
     if(*t=='\'')
      qc =qc ^1;

     if(sc==0 && qc==0 && bc==0)// In "" '' {}-Blcken  nicht nach WS suchen
      if(*t==' ' || *t=='\t')
       {
	if(t==s)             // Falls t auf den Nachfolger des letzten tp zeigt (d.h. meherer WS hinter einander
	 {                   // verschiebe den letzten tp nur , sonst lege einen neunen an
	  tp[i-1]=t;
	  s=t+1;
	 }
	else
	 {
	  tp[i]=t;
	  i++;
	  if(i==max)
	   break;
	  s=t+1;
	 }
       }	
    }
  }

 anz=i;
 for(i=0;i<anz;i++)
  {
   s=skip2nonWS(tp[i]);
   if(s==NULL)
    anz=i;
   else
    {
     tp[i]=s;
     s--;
     if(s>=txt)
      *s='\0';
    }
  }

 for(i=0;i<anz;i++)
  {
   s=tp[i];
   if(*s=='{')
    {
     tp[i]=s+1;
     s=strrchr(tp[i],'}');
     *s='\0';
    }
   if(*s=='"')
    {
     tp[i]=s+1;
     s=strrchr(tp[i],'"');
     *s='\0';
    }
   if(*s=='\'')
    {
     tp[i]=s+1;
     s=strrchr(tp[i],'\'');
     *s='\0';
    }
  }


 if (anz >0)
  {
   s=tp[anz-1]+strlen(tp[anz-1])-1;
   while (*s== ' ' || *s =='\t')
    s--;
   s++;
   *s='\0';
  }
 return(anz);
}


void startTCL()
{
 char *cmd[16],script[4096];
 
 
 sprintf(script,"%s/reminder.tcl",binPath);
 cmd[0]="";
 cmd[1]=script;
 printf("->TCL: %s %s\n",cmd[0],cmd[1]);
 Tk_Main(2,cmd,initApsh);
}

int check4Event(ClientData cData, Tcl_Interp *interp, int argc, char *argv[])
{
 char buffer[16384],*p,*p2=NULL,*p3=NULL,file[1024],*t,*s;
 int canz;
 if( (canz=check4MasterMessage(mySocket,buffer,16383)) >0)
  {
   printf("\t\tGot '%s'\n",buffer);
   if(strncmp(buffer,"remind",6)==0  )
     interp->result = buffer+7;
   else if (strncmp(buffer,"ServerUp",8)==0)
     interp->result = buffer;
   printf("interp: '%s'\n",interp->result);
  } 
 else
  {
   interp->result="";
  }
 return TCL_OK;
}
int reconnect(ClientData cData, Tcl_Interp *interp, int argc, char *argv[])
{
 int ret;
 verbose =true;

 closeSocket();
 sleep(1);
 int wt = 5;
 while ( !logIntoServer())
  {
   fprintf(stderr,"Server not responding retrying\n");
   sleep(wt);
   if(wt<60) 
    wt=wt*2;
  }
 strcpy(interp->result,"connected");
 return (TCL_OK);
}

int currentTime(ClientData cData, Tcl_Interp *interp, int argc, char *argv[])
{
 sprintf(interp->result,"%d",time(NULL));
 return TCL_OK;
}

int initApsh(Tcl_Interp *interp)
{
 Tcl_Command token;
 if (Tcl_Init(interp) == TCL_ERROR) {
  return TCL_ERROR;
 }
 if (Tk_Init(interp) == TCL_ERROR) {
  return TCL_ERROR;
 }
 Tcl_CreateCommand(interp,"check",check4Event,(ClientData) NULL,(Tcl_CmdDeleteProc *) NULL);
 Tcl_CreateCommand(interp,"reconnect",reconnect,(ClientData) NULL,(Tcl_CmdDeleteProc *) NULL);
 Tcl_CreateCommand(interp,"currentTime",currentTime,(ClientData) NULL,(Tcl_CmdDeleteProc *) NULL);
 return TCL_OK;
}
