#!/usr/bin/X11/tixwish
#  File: reminder.tcl
# 
#      This file is part of minkowsky
# 
#      Copyright (C) 2001-2002 by Rdiger Goetz
#      Author: Rdiger Goetz <minkowsky@r-goetz.de>
# 
#      Time-stamp: <22-Apr-2002 12:48:49 goetz>
# 
#      This program is free software; you can redistribute it and/or modify
#      it under the terms of the GNU General Public License as published by
#      the Free Software Foundation; either version 2 of the License, or
#      (at your option) any later version.
# 
#      This program is distributed in the hope that it will be useful,
#      but WITHOUT ANY WARRANTY; without even the implied warranty of
#      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#      GNU General Public License for more details.
# 
#      You should have received a copy of the GNU General Public License
#      along with this program; if not, write to the Free Software
#      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#  


proc display { } {
    global alist list 
    global INVITE REMIND MAHNUNG SUSPEND
    global curWin



    set list $alist
    set type [lindex $list 0]
    if { $type == "suspend" } { 
	tryReconnect
	return
    }
    puts "DISPLAY message type : $type"


    set tim [currentTime]
    set win ".d-$tim"


    if { $type == $REMIND } { 
	mkBasicWin $win
	Erinnerung  $win
    } elseif { $type == $INVITE } { 
	mkBasicWin $win
	Einladung $win
    } else  { 
	return 
    }
    
    
    set signal [lindex $list 10 ]
    if { $signal == "..beep" } {
	puts "SIGNAL beep"
	puts "\a"
	after 200
	puts "\a"
	after 200
	puts "\a"
    } else {
	set cmd [ parseSignalCmd $signal $list]
	puts "Signal : '$signal' -> '$cmd'"
#	eval {exec $cmd }
    }    
    button $win.b.ok -text "   O.K.  " -command {
	puts "curWin = '$curWin'"
	destroy $curWin
    }
    pack $win.b.ok -side top
    
    bind $win <Enter> {getCurWin %W}

    update
#    puts [wm geometry  .]
}

proc mkBasicWin {win } {
    toplevel $win
    frame $win.m -relief raised -bd 1
    frame $win.b -relief flat
    
    pack  $win.m $win.b -fill x -side top -pady 2
}
proc getCurWin { win} {
    global curWin
    set list [split $win .]
    set w [lindex $list 1]
    set curWin ".$w"
#    puts " '$win' -> '$list' -> '$w' -> '$curWin'"
}
proc parseSignalCmd { cmd list } {
    global INVITE REMIND MAHNUNG

    set type   [lindex $list 0]
    set startD [lindex $list 1]
    set startT [lindex $list 2]
    set stopD  [lindex $list 3]
    set stopT  [lindex $list 4]
    set room   [lindex $list 5]
    set title  [lindex $list 6]
    
    if { $type == $REMIND } {
	set left [left2Str [lindex $list 7] [lindex $list 8] [lindex $list 9] ]
	regsub "%l" $cmd $left cmd2
    } else {
	regsub "\[l\:.*:\:l\]" $cmd  "" cmd2
    }
    regsub "%T"  $cmd2 $title  cmd
    regsub "%t0" $cmd  $startT cmd2
    regsub "%t1" $cmd2 $stopT  cmd 
    regsub %t    $cmd  $startT cmd2
    puts "cmd='$cmd'"
    regsub "%d0" $cmd2 $startD cmd 
    regsub "%d1" $cmd  $stopD  cmd2
    regsub %d    $cmd2 $startD cmd 
    regsub "%r"  $cmd  $room   cmd2
    
    return $cmd2
}

proc Erinnerung { win } {
    global list

    global lfont font bfont sfont pfont mfont

   
    wm title $win "Minkowsky:   TerminErinnerung" 
    frame $win.m.h -relief  raised -bd 1
    frame $win.m.b 
    pack  $win.m.h -side top  -fill x 
    pack  $win.m.b -side top  -fill x -padx 8 -pady 8

    label $win.m.h.l -text "Minkowsky:   TerminErinnerung"  -fg red4 -font $bfont -justify center -anchor n
    pack  $win.m.h.l -side top 

    frame $win.m.b.h
    frame $win.m.b.d -relief ridge  -bd 2
    pack $win.m.b.h $win.m.b.d -side top -fill x

    frame $win.m.b.h.i
    frame $win.m.b.h.t
    frame $win.m.b.d.d
    frame $win.m.b.d.b
    frame $win.m.b.d.e
    frame $win.m.b.d.r
    
    pack $win.m.b.h.i $win.m.b.h.t -side top  -fill x -padx 8
    pack $win.m.b.d.d -side top  -fill x
    pack $win.m.b.d.b  $win.m.b.d.e $win.m.b.d.r -side top  -fill x -padx 8

#     puts [lindex $list 5]
#     puts [lindex $list 6]
#     puts [lindex $list 7]
#     puts [lindex $list 8]
#     puts [lindex $list 9]
    set title [string trim [lindex $list 6]]
    label $win.m.b.h.i.l1 -text "In [left2Str [lindex $list 7] [lindex $list 8] [lindex $list 9] ] " -fg red3 -font $bfont -justify center -anchor n
    label $win.m.b.h.i.l2 -text "findet folgender Termin statt:" -fg red3 -font $bfont -justify center -anchor n
    label $win.m.b.h.t.l -text $title -font $lfont -justify center -anchor n
    label $win.m.b.d.d.l -text "Termindaten:" -font $mfont 
    label $win.m.b.d.b.l -text "Beginn " -font $pfont -width 7
    label $win.m.b.d.e.l -text "Ende   " -font $pfont -width 7
    label $win.m.b.d.r.l -text "Ort    " -font $pfont -width 7
    label $win.m.b.d.b.t -text "[ lindex $list 1], [ lindex $list 2] Uhr" -font $sfont
    label $win.m.b.d.e.t -text "[lindex $list 3], [ lindex $list 4] Uhr" -font $sfont
    label $win.m.b.d.r.t -text "[lindex $list 5]" -font $sfont
    
    
    pack $win.m.b.h.t.l -side top -fill x -pady 16
    pack $win.m.b.h.i.l1 -side top -fill x 
    pack $win.m.b.h.i.l2 -side top -fill x 
    pack $win.m.b.d.d.l -side left
    pack $win.m.b.d.b.l $win.m.b.d.b.t $win.m.b.d.e.l  $win.m.b.d.e.t $win.m.b.d.r.l $win.m.b.d.r.t -side left -fill x
    
    wm geometry $win 300x264
    update
    puts "Minko reminder"
}

proc Einladung { win } {
    global list

    global lfont font bfont sfont pfont mfont

   
    frame $win.m.h -relief  raised -bd 1
    frame $win.m.b 
    pack  $win.m.h -side top  -fill x 
    pack  $win.m.b -side top  -fill x -padx 8 -pady 8

    label $win.m.h.l -text "Minkowsky:   Einladung"  -fg red4 -font $bfont -justify center -anchor n
    pack  $win.m.h.l -side top 

    frame $win.m.b.h
    frame $win.m.b.d -relief ridge  -bd 2
    pack $win.m.b.h $win.m.b.d -side top -fill x

    frame $win.m.b.h.i
    frame $win.m.b.h.t
    frame $win.m.b.d.d
    frame $win.m.b.d.b
    frame $win.m.b.d.e
    frame $win.m.b.d.r
    
    pack $win.m.b.h.i $win.m.b.h.t -side top  -fill x -padx 8
    pack $win.m.b.d.d -side top  -fill x
    pack $win.m.b.d.b  $win.m.b.d.e $win.m.b.d.r -side top  -fill x -padx 8

    set title [string trim [lindex $list 6]]
    label $win.m.b.h.i.l1 -text "[lindex $list 7]"  -font $bfont -justify center -anchor n
    label $win.m.b.h.i.l2 -text "laden zu folgendem Termin ein::"  -font $bfont -justify center -anchor n
    label $win.m.b.h.t.l -text $title -font $lfont -justify center -anchor n
    label $win.m.b.d.d.l -text "Termindaten:" -font $mfont 
    label $win.m.b.d.b.l -text "Beginn " -font $pfont -width 7
    label $win.m.b.d.e.l -text "Ende   " -font $pfont -width 7
    label $win.m.b.d.r.l -text "Ort    " -font $pfont -width 7
    label $win.m.b.d.b.t -text "[ lindex $list 1], [ lindex $list 2] Uhr" -font $sfont
    label $win.m.b.d.e.t -text "[lindex $list 3], [ lindex $list 4] Uhr" -font $sfont
    label $win.m.b.d.r.t -text "[lindex $list 5]" -font $sfont
    
    
    pack $win.m.b.h.t.l -side top -fill x -pady 16
    pack $win.m.b.h.i.l1 -side top -fill x 
    pack $win.m.b.h.i.l2 -side top -fill x 
    pack $win.m.b.d.d.l -side left
    pack $win.m.b.d.b.l $win.m.b.d.b.t $win.m.b.d.e.l  $win.m.b.d.e.t $win.m.b.d.r.l $win.m.b.d.r.t -side left -fill x
    
    wm geometry $win 300x232
    wm title $win "Minkowsky:   Einladung"
}


proc left2Str { tim1 tim2  unit} {


    puts "format : $tim1 $tim2  $unit"
    if { $tim2 > 0} {
	switch $unit {
	    m { set str [ format "%d Minuten, %2d Sekunden" $tim1 $tim2 ] }
	    h { set str [ format "%d Stunden, %2d Minuten" $tim1 $tim2 ] }
	    d { set str [ format "%d Tagen, %2d Stunden" $tim1 $tim2] }
	    default { set str "???" }
	}
    } else {
	switch $unit {
	    m { set str [ format "%d Minuten" $tim1] }
	    h { set str [ format "%d Stunden" $tim1] }
	    d { set str [ format "%d Tagen" $tim1] }
	    default { set str "???" }
	}
    }
    return   $str
}

proc tryReconnect { } {
    while { 1 == 1 } {
	after 15000
	reconnect
    }
}

set lfont -*-helvetica-bold-normal-*-18-*-*-*-*-*-*-*
set font -*-helvetica-medium-r-normal-*-14-*-*-*-*-*-*-*
set bfont -*-helvetica-bold-r-normal-*-14-*-*-*-*-*-*-*
set sfont -*-helvetica-medium-r-normal-*-12-*-*-*-*-*-*-*
set pfont -*-lucidatypewriter-bold-r-normal-*-12-*-*-*-*-*-*-*
set mfont -*-helvetica-medium-r-normal-*-10-*-*-*-*-*-*-*

set INVITE  256
set REMIND  512
set MAHNUNG 1024

wm withdraw .
#puts "window withdrawn"
update
set terminate 0
while { $terminate ==  0 } {
    set alist [check]
    if {[llength $alist] > 0 } { 
	puts ""
	puts "DISPLAY //$alist//"
	display 
    } 
    after 250
    update
}
