#!/usr/bin/X11/tixwish
#  File: todo.tcl
# 
#      This file is part of minkowsky
# 
#      Copyright (C) 2001-2002 by Rdiger Goetz
#      Author: Rdiger Goetz <minkowsky@r-goetz.de>
# 
#      Time-stamp: <25-May-2002 20:01:30 goetz>
# 
#      This program is free software; you can redistribute it and/or modify
#      it under the terms of the GNU General Public License as published by
#      the Free Software Foundation; either version 2 of the License, or
#      (at your option) any later version.
# 
#      This program is distributed in the hope that it will be useful,
#      but WITHOUT ANY WARRANTY; without even the implied warranty of
#      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#      GNU General Public License for more details.
# 
#      You should have received a copy of the GNU General Public License
#      along with this program; if not, write to the Free Software
#      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#  

proc printProjs { } {
    global tddCan selPrinter todoDy todoLines

    set file [format "/tmp/kapa-%d-%d.ps" [pid] [currentTime] ]
    if { $todoLines <=55 } {
	$tddCan postscript -colormode gray -file $file  -pagewidth  19.0c  -pagey 15c -pageanchor s
	set ret [exec lpr -P$selPrinter $file]
    } else {
	set i 0
	set fileList ""
	set h [ expr 55 * $todoDy]
	for{ set l 0 } { $l< $todoLines } { incr l 55} {
	    set file [format "/tmp/kapa-%d-%d-%d.ps" [pid] [currentTime]  $i]
	    lappend fileList $file
	    set y [ expr $l*$todoDy]
	    $tddCan postscript -colormode gray -file $file  -pagewidth  19.0c  -pagey 15c -pageanchor s -y $y -height $h
	}
	set file [format "/tmp/kapa-%d-%d.ps" [pid] [currentTime] ]
	exec psmerge -o$file $fileList
	set ret [exec lpr -P$selPrinter $file]
    }

    
}




proc getProjTodoLists { } {
    global lastProjTodoChange  tdd_todoList tdd_projList prvTodo username TODOstati nextDummyId tdd_todoPID 
    global  cur_Cal
 
    set change 0
    set t [request getLastProjTodoChange]
    if { $t == "Error" } { return $change}



#FIXME relaod on Cal change
    if { $t > $lastProjTodoChange  || $cur_Cal != $prvTodo } {
	set lastProjTodoChange  $t
	set ret [request getProjLists $username $cur_Cal ]
	if { $ret == "Error" } { return $change}
	if { [string range $ret 0 2] == "ERR" } {
	    #FIXME
	    set cur_Cal $prvCal   
	    setCurCalMenuTitel
	    drawNewView
	    return
	}
	set tList [lindex $ret 0]
	set pList [lindex $ret 1]
	
	if {$cur_Cal != $prvTodo } {
	    #Nehme erst mal alle Projecte und Termine raus
	    foreach tid [array names tdd_todoPID] {
		set pid $tdd_todoPID($tid)
		if { $pid <0 } {
		    set tdd_projList($pid) [lreplace $tdd_projList($pid) 1 1 DELETED]
		} 
		set tdd_todoPID($tid) 0
	    }
	    
	    foreach tid [array names tdd_todoList] {
		set tdd_todoList($tid) [lreplace $tdd_todoList($tid) 0 0 -1]
	    }
	    foreach pid [array names tdd_projList] {
		set tdd_projList($pid) [lreplace $tdd_projList($pid) 1 1 DELETED]
	    }
	}


	set nextDummyId -1
	foreach tid [array names tdd_todoPID] {
	    set pid $tdd_todoPID($tid)
	    if { $pid <0 } {
		set tdd_projList($pid) [lreplace $tdd_projList($pid) 1 1 DELETED]
	    } 
	    set tdd_todoPID($tid) 0
	}
	set tdd_todoPID(-) 0


	foreach todo $tList {
	    if {[ llength $todo] >=14 } {
		set tid [ lindex $todo 0]
		set stat [lindex $TODOstati [lindex $todo 2] ]
		set todo [ lreplace $todo 2 2 $stat]
		set tdd_todoList($tid) $todo 
		addDummyProject $tid -1
	    }
	}
	getAll_TodoDringlich
	getAll_TodoComplete

	foreach proj $pList {
	    extractProjArray $proj
	}
	
	set change 1
	set prvToDo $cur_Cal
    }
    return $change
}

proc addDummyProject { tid pid} {
    global tdd_projList tdd_todoList nextDummyId tdd_todoPID tdd_todoList
    
    if { $pid>=0 } { 
	set tdd_todoPID($tid) $pid
	return 0
    }

    
    set createDummy 0
    set tidList [array names tdd_todoPID $tid]
    if { [llength $tidList] <= 0} {
	set createDummy 1
    } elseif {$tdd_todoPID($tid)>=0  } {
   	    set createDummy 1
    }

    if { $createDummy == 1} {
 	set todo $tdd_todoList($tid)
 	set tdd_todoPID($tid) $nextDummyId
 	set uList ""
 	foreach usr [lindex $todo 7] {
 	    set ent [format "%s %s" [lindex $usr 0] [lindex $usr 2]]
 	    lappend uList $ent
 	}
	 #             ID typ prm oc stat tit start stop ul init dr comp todos ...
	 #                         ===== ==== ==== ===== == ==== == ==== ==
 	set tdd_projList($nextDummyId) \
 	    [format " -1 TODO {} OPEN %s \"%s\" %d  %d {%s}  %s %d %d {{%d {} 0}}  {} {} __allgemein" \
 	     [lindex $todo 2] [lindex $todo 3] [lindex $todo 4] [lindex $todo 5] $uList\
 	     [lindex $todo 8] [lindex $todo 9] [lindex $todo 6] $tid ]
 	incr nextDummyId -1
     }
}
proc removeDummyProject { tid } {
    global tdd_projList tdd_todoList tdd_todoPID
    
    set idx $tdd_todoPID($tid) 
    set tdd_projList($idx) " -1 DELETED {} OPEN WIP \"\" 0   0 {}  0 0 0 {{$tid {} 0}}  {} {} __allgemein"
    set tdd_todoPID($tid)  0
}

proc extractProjArray { inp } {
    global tdd_projList depType

    set pid [lindex $inp 0]

    set todos [ lindex $inp 8]
    set tlist ""
    foreach todo $todos {
	set tid [lindex $todo 0]
	set lvl [lindex $todo 2]
	set dlist ""
	foreach dep [lindex $todo 1] {
	    set ent [format "%d %s %d" [lindex $dep 0] [lindex $depType [lindex $dep 1]] [lindex $dep 2]]
	    lappend dlist $ent
	}
	set ent "$tid {$dlist} $lvl"
	lappend tlist $ent
    }
    set tdd_projList($pid)  [format "%d PROJ %s %s NEW {%s} 0 %d {%s} %s 3 0 {%s} {%s} {%s} %s" \
				 [lindex $inp 0] [lindex $inp 1] [lindex $inp 2] [lindex $inp 3] \
				 [lindex $inp 5] [lindex $inp 6] [lindex $inp 7] $tlist \
				 [lindex $inp 9] [lindex $inp 10] [lindex $inp 11] ]
    
    getProjValues $pid
}
proc getProjValues { pid } {
    global TODOstati tdd_todoList TODOstatVal tdd_projList tdd_todoPID username
    global tdd_todoDring tdd_todoCompl


    set statVal 0
    set compl 0
    set mean 0
    set max 0
    set start 99999999
    checkTodoStatus $pid
    set tids [array names tdd_todoList]
#    puts "checkTodoStatus for $pid done\n\n\n"
    foreach ent [lindex $tdd_projList($pid) 12] {
	set tid [lindex $ent 0]
	if { [lsearch $tids $tid ] <0 } { continue }

	set todo $tdd_todoList($tid)
	if { $tdd_todoPID($tid) <0} {removeDummyProject $tid }
	set tdd_todoPID($tid) $pid

	if { $TODOstatVal([lindex $todo 2 ]) > $statVal } { set statVal $TODOstatVal([lindex $todo 2 ])}
	incr compl $tdd_todoCompl($tid)
	if { $max < $tdd_todoDring($tid) } { set max  $tdd_todoDring($tid) }
	incr mean $tdd_todoDring($tid)
	if { $start > [lindex $todo 4] } {set  start [lindex $todo 4]}
    }
    set anz  [llength [lindex $tdd_projList($pid) 12]]
    if { $anz == 0 } {
	set tdd_projList($pid) [lreplace $tdd_projList($pid) 1 1 DELETED]
	set ret [transfer deleteProject $username $pid]
    } else {
	set stat [lindex $TODOstati $statVal ]
	set dring [ expr int(floor( (( double($mean) / $anz) + $max)/2.+.49 ))]
	set compl [ expr  $compl / $anz]
	
	
	set list               [lreplace $tdd_projList($pid) 4 4 $stat]
	set list               [lreplace $list  6  6 $start]
	set list               [lreplace $list 10 10 $dring]
	set tdd_projList($pid) [lreplace $list 11 11 $compl]
    }
#    puts "getProjValues($pid) done\n"
}
proc checkTodoStatus { pid} {
    global tdd_todoList tdd_projList tdd_todoCompl username TODOstatVal today

    set tids [array names tdd_todoList]
    set tlist [lindex $tdd_projList($pid) 12 ]
    foreach ent $tlist {
	set tid1 [lindex $ent 0]
	set dList [lindex $ent 1]
	set notDone 0
	set chg 0
	
	if { [lsearch $tids $tid1 ] <0 } { 
	    set list [ lindex $tdd_projList($pid) 12 ] 
	    set ct [ lsearch $list $ent]
	    if { $ct >=0 } {
		set list [lreplace $list $ct $ct ]
		set tdd_projList($pid) [lreplace $tdd_projList($pid) 12 12 $list]
	    }
	    continue 
	}
	set stat [lindex $tdd_todoList($tid1) 2]
	if {$today > [lindex $tdd_todoList($tid1) 5] && $stat != "DONE" && $stat !="HOLD" && $stat !="KILL"} {
	    set tdd_todoList($tid1) [lreplace $tdd_todoList($tid1) 2 2 "DELAY"]
	    set chg 1
	} else {
	    if { [llength $dList] >0 } {
		foreach dep $dList {
		    set tid2 [lindex $dep 0]
		    set typ [lindex $dep 1]
		    set val [lindex $dep 2]
		    set stat [lindex $tdd_todoList($tid2) 2]
		    set mstones [lindex $tdd_todoList($tid2) 12]
		    switch $typ {
			ONCOMPL { if { $tdd_todoCompl($tid2) <$val} { set notDone 1}}
			ONMILES { if { [lindex [lindex $mstones $val] 0] == 0 }  { set notDone 1}}
			ONDONE  { if { $stat != "DONE" }  { set notDone 1}}
			ONDELAY { if { $stat != "DELAY" }  { set notDone 1}}
			ONKILL  { if { $stat != "KILL" }  { set notDone 1}}
			ONWIP   { if { $stat != "WIP" }  { set notDone 1}}
			ONHOLD  { if { $stat != "HOLD" }  { set notDone 1}}
		    }
		    if { $notDone == 1} { break}
		}
		set stat [lindex $tdd_todoList($tid1) 2]
		if { $notDone == 0 } {
		    if { $stat == "WAIT" || $stat == "NEW"} {
			set tdd_todoList($tid1) [lreplace $tdd_todoList($tid1) 2 2 "OPEN"]
			#FIXME benachrichtigugn an bearbeiter
			set chg 1
		    }
		} else {
		    if { $stat == "OPEN" ||  $stat == "NEW" } {
			set tdd_todoList($tid1) [lreplace $tdd_todoList($tid1) 2 2 "WAIT"]
			set chg 1
		    }		
		}
	    }

	    if { $chg == 1} {
		transfer changeStatus4Todo $username $tid1 $TODOstatVal([lindex $tdd_todoList($tid1) 2])
	    }
	}
    }
}
			 

proc drawToDo { } {
    global bfnt12 tddCan todWin todoWin
    global tddo_sortDir down12Img up12Img down10Img up10Img 
    global tddo_sortStat  tddo_sortTitel tddo_sortStart tddo_sortStop
    global tddo_sortCompl tddo_sortUsers tddo_sortInit  tddo_sortDring
    global tddo_sortDring
    global todoCanWidth todoCanHeight todoWidth todoHeight todoLegendWidth
    global _projText
#    toplevel .tdd


#    doLock

    frame $todWin.l -relief raised  -bd 1
    frame $todWin.e -relief raised   -bd 1
    pack  $todWin.l $todWin.e -side top -fill both -expand 1

    tixScrolledWindow $todWin.l.s -width $todoWidth -scrollbar "auto -y"  -height $todoHeight
    $todWin.l.s subwidget hsb configure -width 12
    set todoWin [$todWin.l.s subwidget window ]
    pack $todWin.l.s -side top -fill x -expand 1

    frame $todoWin.t
    tixCObjView $todoWin.l -width $todoCanWidth -scrollbar y -height $todoCanHeight
    set tddCan [$todoWin.l subwidget  canvas]
    $todoWin.l subwidget canvas configure -background grey95
    $todoWin.l subwidget vsb configure -width 10
    $todoWin.l subwidget hsb configure -width 12
    pack $todoWin.t $todoWin.l -side top -fill both


    set tddo_sortStat  $todoWin.t.1
    set tddo_sortTitel $todoWin.t.2
    set tddo_sortStart $todoWin.t.3
    set tddo_sortStop  $todoWin.t.4
    set tddo_sortCompl $todoWin.t.5
    set tddo_sortUsers $todoWin.t.6
    set tddo_sortInit  $todoWin.t.7
    set tddo_sortDring $todoWin.t.8
    set tddo_sortDir   $todoWin.t.9

    label $tddo_sortStat  -text $_projText(mainStatus)   -width  6 -relief raised -bd 1 -font $bfnt12 -justify center -anchor n
    label $tddo_sortTitel -text $_projText(mainName)     -width 50 -relief raised -bd 1 -font $bfnt12 -justify center -anchor n
    label $tddo_sortStart -text $_projText(mainStart)    -width 10 -relief raised -bd 1 -font $bfnt12 -justify center -anchor n
    label $tddo_sortStop  -text $_projText(mainEnd)      -width 10 -relief raised -bd 1 -font $bfnt12 -justify center -anchor n
    label $tddo_sortCompl -text $_projText(mainProgress) -width 16 -relief raised -bd 1 -font $bfnt12 -justify center -anchor n
    label $tddo_sortUsers -text $_projText(mainWorker)   -width 27 -relief raised -bd 1 -font $bfnt12 -justify center -anchor n
    label $tddo_sortInit  -text $_projText(mainInit)     -width 11 -relief raised -bd 1 -font $bfnt12 -justify center -anchor n
    label $tddo_sortDring -text $_projText(mainDring)    -width 2 -relief raised -bd 1 -font $bfnt12 -justify center -anchor n
    button $tddo_sortDir -image $up10Img        -width 10 -relief raised -bd 1 -font $bfnt12 -justify center -anchor n
    pack $tddo_sortStat $tddo_sortTitel $tddo_sortStart $tddo_sortStop $tddo_sortCompl $tddo_sortUsers $tddo_sortInit  -side left 
    pack $tddo_sortDring  -side left  -ipadx 2
    pack $tddo_sortDir -side left

    tixScrolledWindow $todWin.e.sw  -scrollbar "auto -y" -relief flat -width $todoLegendWidth
    pack $todWin.e.sw -fill x

    $todWin.e.sw subwidget window configure -relief flat
    $todWin.e.sw subwidget hsb configure -width 12
    
    drawTDDLegende $todWin.e.sw 
    drawClosedLegend $todWin.e.sw
    fillTODO
    
    bind $tddo_sortDir <ButtonPress> toggleSortDir
    bind $tddo_sortStat  <ButtonPress> setSortModeStatus
    bind $tddo_sortTitel <ButtonPress> setSortModeTitel
    bind $tddo_sortDring <ButtonPress> setSortModeDring
    bind $tddo_sortStart <ButtonPress> setSortModeStart
    bind $tddo_sortStop  <ButtonPress> setSortModeStop
    bind $tddo_sortCompl <ButtonPress> setSortModeCompl
    bind $tddo_sortUsers <ButtonPress> setSortModeUsers
    bind $tddo_sortInit  <ButtonPress> setSortModeInit

    bind . <Alt-q> {exitClient}
    update
#    unLock
}

proc drawTDDLegende { swin } {
    global todoStatIcon fnt bfnt bfnt12 todWin
    global dringlichStr TODOstatStr TODOstati dringlichColor objOpenMini
    global _projText

    set win [ $swin subwidget window ]
    
    frame $win.0
    frame $win.1
    frame $win.2
    frame $win.3
    pack $win.0 $win.1 $win.2 $win.3 -fill x
    
    button $win.0.b -image  [image create pixmap -data $objOpenMini]  -relief flat -command { drawClosedLegend $todWin.e}
    label $win.0.l -text $_projText(Legend) -font $bfnt
    pack $win.0.b  $win.0.l -side left

    label $win.1.0 -text "$_projText(LegendStati):   " -font $bfnt -width 15
    pack $win.1.0 -side left
    button $win.1.b1 -image  [image create pixmap -data $todoStatIcon(NEW)] -background white -activebackground white
    label $win.1.l1  -text  "= $_projText(LegendNew)  " -font $fnt -width 24
    pack $win.1.b1 $win.1.l1 -side left
    button $win.1.b2 -image  [image create pixmap -data $todoStatIcon(DONE)] -background white -activebackground white
    label $win.1.l2  -text  "= $_projText(LegendDone)" -font $fnt -width 21
    pack $win.1.b2 $win.1.l2 -side left
    button $win.1.b3 -image  [image create pixmap -data $todoStatIcon(OPEN)] -background white -activebackground white
    label $win.1.l3  -text  "= $_projText(LegendOpen)" -font $fnt -width 16
    pack $win.1.b3 $win.1.l3 -side left
    button $win.1.b4 -image  [image create pixmap -data $todoStatIcon(KILL)] -background white -activebackground white
    label $win.1.l4  -text  "= $_projText(LegendCanceled)" -font $fnt -width 23
    pack $win.1.b4 $win.1.l4 -side left
    label $win.2.0 -text "         " -font $fnt -width 15
    pack $win.2.0 -side left
    button $win.2.b5 -image  [image create pixmap -data $todoStatIcon(WAIT)] -background white -activebackground white
    label $win.2.l5  -text  "= $_projText(LegendPending)" -font $fnt -width 24
    pack $win.2.b5 $win.2.l5 -side left
    button $win.2.b6 -image  [image create pixmap -data $todoStatIcon(HOLD)] -background white -activebackground white
    label $win.2.l6  -text  "= $_projText(LegendSuspended)" -font $fnt -width 21
    pack $win.2.b6 $win.2.l6 -side left
    button $win.2.b7 -image  [image create pixmap -data $todoStatIcon(WIP)] -background white -activebackground white
    label $win.2.l7  -text  "= $_projText(LegendWIP)" -font $fnt -width 16
    pack $win.2.b7 $win.2.l7 -side left
    button $win.2.b8 -image  [image create pixmap -data $todoStatIcon(DELAY)] -background white -activebackground white
    label $win.2.l8  -text  "= $_projText(LegendDelayed)" -font $fnt -width 23
    pack $win.2.b8 $win.2.l8 -side left

    label $win.3.0 -text "$_projText(LegendUrgency):" -font $bfnt -width 15
    pack $win.3.0 -side left

    set anz [llength $dringlichStr]
    for {set i 0} {$i<$anz} {incr i} {
	label $win.3.l$i -text [format "%d = %s" $i [lindex $dringlichStr $i]] -width 14 -foreground [lindex $dringlichColor $i] -font $bfnt12
	pack $win.3.l$i -side left
    }
    $swin configure -height 128

}

proc drawClosedLegend { swin } {
    global objCloseMini todWin todoWin todoHeight todoCanHeight todoLegendOpen


    $swin configure -height 26
    set win [ $swin subwidget window ]


    pack forget $win.1
    pack forget $win.2
    pack forget $win.3
 
#    puts "drawCloseLegend"
    $win.0.b configure -image  [image create pixmap -data $objCloseMini]  
    $win.0.b configure  -command { drawOpenLegend $todWin.e.sw}
    $todoWin.l configure -height $todoCanHeight
    $todWin.l.s configure -height $todoHeight
    update
    set todoLegendOpen 0
}
proc drawOpenLegend { swin } {
    global objOpenMini todWin  todoWin todoHeight2 todoCanHeight2   todoLegendOpen

    $swin configure -height 128
    set win [ $swin subwidget window ]

#    puts "drawOpen-Legend"
    $win.0.b configure -image  [image create pixmap -data $objOpenMini]  
    $win.0.b configure  -command { drawClosedLegend $todWin.e.sw}
    pack $win.1 $win.2 $win.3 -fill x -side top
    $todoWin.l configure -height $todoCanHeight2
    $todWin.l.s configure -height $todoHeight2
    
    update
    set todoLegendOpen 1
}

proc refillTODO { } {
    global tddCan
    $tddCan delete tddObj
    update
    fillTODO
}


proc toggleSortDir { } {
    global projSortDirection tddo_sortDir up12Img down12Img up10Img down10Img

    if { $projSortDirection == "-decreasing" } {
	set projSortDirection "-increasing"
	$tddo_sortDir configure -image $down10Img
    } else {
	set projSortDirection "-decreasing"
	$tddo_sortDir configure -image $up10Img
    }
    refillTODO
}

proc markSortKeys { } {
    global projSortMode projSortMode2 projSortMode3
    global tddo_sortStat  tddo_sortTitel tddo_sortStart tddo_sortStop
    global tddo_sortCompl tddo_sortUsers tddo_sortInit  tddo_sortDring
    global tddo_sortDring

    $tddo_sortStat  configure -foreground black
    $tddo_sortTitel configure -foreground black
    $tddo_sortStart configure -foreground black
    $tddo_sortStop  configure -foreground black
    $tddo_sortCompl configure -foreground black
    $tddo_sortUsers configure -foreground black
    $tddo_sortInit  configure -foreground black

    set mode1Color "#EE0000"
    set mode2Color "#C84040"
    set mode3Color "#804040"
    switch $projSortMode3 {
	stat   { $tddo_sortStat  configure -foreground $mode3Color }
	titel  { $tddo_sortTitel configure -foreground $mode3Color }
	dring  { $tddo_sortDring configure -foreground $mode3Color }
	start  { $tddo_sortStart configure -foreground $mode3Color }
	stop   { $tddo_sortStop  configure -foreground $mode3Color }
	compl  { $tddo_sortCompl configure -foreground $mode3Color }
	users  { $tddo_sortUsers configure -foreground $mode3Color }
	init   { $tddo_sortInit  configure -foreground $mode3Color }
    }
    switch $projSortMode2 {
	stat   { $tddo_sortStat  configure -foreground $mode2Color }
	titel  { $tddo_sortTitel configure -foreground $mode2Color }
	dring  { $tddo_sortDring configure -foreground $mode2Color }
	start  { $tddo_sortStart configure -foreground $mode2Color }
	stop   { $tddo_sortStop  configure -foreground $mode2Color }
	compl  { $tddo_sortCompl configure -foreground $mode2Color }
	users  { $tddo_sortUsers configure -foreground $mode2Color }
	init   { $tddo_sortInit  configure -foreground $mode2Color }
    }
    switch $projSortMode {
	stat   { $tddo_sortStat  configure -foreground $mode1Color }
	titel  { $tddo_sortTitel configure -foreground $mode1Color }
	dring  { $tddo_sortDring configure -foreground $mode1Color }
	start  { $tddo_sortStart configure -foreground $mode1Color }
	stop   { $tddo_sortStop  configure -foreground $mode1Color }
	compl  { $tddo_sortCompl configure -foreground $mode1Color }
	users  { $tddo_sortUsers configure -foreground $mode1Color }
	init   { $tddo_sortInit  configure -foreground $mode1Color }
    }
}
proc setSortModeStatus { } {
    global projSortMode projSortMode2 projSortMode3 tddo_sortStat
    set projSortMode3 $projSortMode2
    set projSortMode2 $projSortMode
    set projSortMode "stat"

    refillTODO
}
proc setSortModeTitel { } {
    global projSortMode projSortMode2 projSortMode3 tddo_sortTitel
    set projSortMode3 $projSortMode2
    set projSortMode2 $projSortMode
    set projSortMode "titel"
    refillTODO
}
proc setSortModeDring { } {
    global projSortMode projSortMode2 projSortMode3 tddo_sortTitel
    set projSortMode3 $projSortMode2
    set projSortMode2 $projSortMode
    set projSortMode "dring"
    refillTODO
}
proc setSortModeStart { } {
    global projSortMode projSortMode2 projSortMode3 tddo_sortStart
    set projSortMode3 $projSortMode2
    set projSortMode2 $projSortMode
    set projSortMode "start"
    refillTODO
}
proc setSortModeStop { } {
    global projSortMode projSortMode2 projSortMode3 tddo_sortStop
    set projSortMode3 $projSortMode2
    set projSortMode2 $projSortMode
    set projSortMode "stop"
    refillTODO
}
proc setSortModeCompl { } {
    global projSortMode projSortMode2 projSortMode3 tddo_sortCompl
    set projSortMode3 $projSortMode2
    set projSortMode2 $projSortMode
    set projSortMode "compl"
    refillTODO
}
proc setSortModeUsers { } {
    global projSortMode projSortMode2 projSortMode3 tddo_sortUsers
    set projSortMode3 $projSortMode2
    set projSortMode2 $projSortMode
    set projSortMode "users"
    refillTODO
}
proc setSortModeInit { } {
    global projSortMode projSortMode2 projSortMode3 tddo_sortInit
    set projSortMode3 $projSortMode2
    set projSortMode2 $projSortMode
    set projSortMode "init"
    refillTODO
}
proc compareProj { p1 p2 } {
    global projSortMode projSortMode2 projSortMode3 tdd_projList

    set diff [compProjBy $p1 $p2 $projSortMode]
    if {$diff == 0} { set diff [compProjBy $p1 $p2 $projSortMode2]}
    if {$diff == 0} { set diff [compProjBy $p1 $p2 $projSortMode3]}
    return $diff
}
proc compProjBy { pid1 pid2 typ} {
    global TODOstatVal tdd_projList

    set p1 $tdd_projList($pid1)
    set p2 $tdd_projList($pid2)
    set diff 0
    switch $typ {
	stat   { set diff [ expr $TODOstatVal([lindex $p1 4]) - $TODOstatVal([lindex $p2 4]) ] }
	titel  { set diff [ string compare [lindex $p1 5] [lindex $p2 5] ]}
	start  { set diff [ expr [lindex $p1 6]  - [lindex $p2 6] ] 	}
	stop   { set diff [ expr [lindex $p1 7]  - [lindex $p2 7] ] 	}
	compl  { set diff [ expr [lindex $p1 11] - [lindex $p2 11]] }
	dring  { set diff [ expr [lindex $p1 10] - [lindex $p2 10]] }
	users  { 
	    set ustr1 ""
	    foreach usr [lindex $p1 8] {	lappend ustr1 [lindex $usr 0]}
	    set ustr2 ""
	    foreach usr [lindex $p2 8] {	lappend ustr2 [lindex $usr 0]}
	    set diff [ string compare $ustr1 $ustr2] 
	}
	init   { set diff [ string compare [lindex $p1 9] [lindex $p2 9] ]}
    }
    return $diff
}

proc compareTodo { p1 p2 } {
    global projSortMode projSortMode2 projSortMode3 tdd_todoList

    set diff [compTodoBy $p1 $p2 $projSortMode]
    if {$diff == 0} { set diff [compTodoBy $p1 $p2 $projSortMode2]}
    if {$diff == 0} { set diff [compTodoBy $p1 $p2 $projSortMode3]}
    return $diff
}

proc compTodoBy {tid1 tid2 typ } {
    global TODOstatVal tdd_todoList tdd_todoDring tdd_todoCompl

    set p1 $tdd_todoList($tid1)
    set p2 $tdd_todoList($tid2)

    set diff 0
    switch $typ {
	stat   { set diff [ expr $TODOstatVal([lindex $p1 2]) - $TODOstatVal([lindex $p2 2]) ] }
	titel  { set diff [ string compare [lindex $p1 3] [lindex $p2 3] ]}
	start  { set diff [ expr [lindex $p1 4]  - [lindex $p2 4] ] 	}
	stop   { set diff [ expr [lindex $p1 5]  - [lindex $p2 5] ] 	}
	compl  { set diff [ expr $tdd_todoCompl($tid1) - $tdd_todoCompl($tid2) ] }
	dring  { set diff [ expr $tdd_todoDring($tid1) - $tdd_todoDring($tid2) ] }
	users  { 
	    set ustr1 ""
	    foreach usr [lindex $p1 7] {	lappend ustr1 [lindex $usr 0]}
	    set ustr2 ""
	    foreach usr [lindex $p2 7] {	lappend ustr2 [lindex $usr 0]}
	    set diff [ string compare $ustr1 $ustr2] 
	}
	init   { set diff [ string compare [lindex $p1 8] [lindex $p2 8] ]}
    }
    return $diff
}
proc fillTODO { } {
    global tddCan tdd_projList tdd_todoList
    global tddCan bfnt fnt bfnt12 fnt12 pfnt12 pbfnt12 pfnt pbfnt
    global dringlichStr TODOstatStr TODOstati dringlichColor
    global tdd_todoDring tdd_todoCompl
    global objCloseMini objOpenMini
    global tddLines
    global projSortMode projSortDirection
    global todoLines todoDy
#FIZME Projeckte sortieren

    set y 2
    set dy 25
    set todoDy $dy
    set lc 0
    set pidx 0
    switch -glob $projSortMode {
	id {set pidList [lsort -integer $projSortDirection [array names tdd_projList]]  }
	default {set pidList [lsort -command compareProj $projSortDirection [array names tdd_projList]]  
	}
    }
    markSortKeys
    getAll_TodoDringlich
    getAll_TodoComplete
    foreach pid $pidList { 
	set proj $tdd_projList($pid)
	$tddCan create rectangle 1 $y 972 [expr $y+25] -fill grey95 -outline grey95 -tag tddObj
	if { [lindex $proj 1] == "PROJ" } {
	    if { [lindex  $proj 3] == "CLOSE" } {
		$tddCan create image 2 $y -anchor nw -image [image create pixmap -data $objCloseMini]  -tag tddObj
	    } else {
		$tddCan create image 2 $y -anchor nw -image [image create pixmap -data $objOpenMini] -tag tddObj
	    } 

	    getProjValues $pid
	    set proj $tdd_projList($pid)
	    set ustr ""
	    foreach usr [lindex $proj 8] {
		if { [string length $ustr] > 0} {
		    set ustr [format "%s, %s" $ustr [lindex $usr 0]]
		} else  {
		    set ustr  [lindex $usr 0]
		}
	    }

 	    drawTODOitem $y $pbfnt12 [lindex $proj 4] [lindex $proj 5] \
		"     -" [date2lstr [lindex $proj 7] ] [lindex $proj 11] \
		[strTrunc $ustr 25] [lindex $proj 9] [lindex $proj 10] 0
	    set tddLines($lc) "PROJ $pid"
	    incr lc
	    if { [lindex  $proj 3] == "OPEN" } {
		set tidList ""
		foreach ent [lindex $proj 12] {
		    set tid [ lindex $ent 0]
		    lappend tidList $tid
		}
		
		set tList $tidList
		switch -glob $projSortMode {
		    id {set tList [lsort -integer $projSortDirection $tidList]  }
		    default {set tList [lsort $projSortDirection -command compareTodo $tidList]  
		    }
		}
		
		foreach tid $tList {
		    set todo $tdd_todoList($tid)
		    incr y $dy
		    set ustr ""
		    foreach usr [lindex $todo 7] {
			if { [string length $ustr] > 0} {
			    set ustr [format "%s, %s" $ustr [lindex $usr 0]]
			} else  {
			    set ustr  [lindex $usr 0]
			}
		    }
		    $tddCan create rectangle 1 $y 972 [expr $y+25] -fill grey95 -outline grey95 -tag tddObj
		    drawTODOitem $y $pfnt12 [lindex $todo 2] [lindex $todo 3] \
			[date2lstr [lindex $todo 4]] [date2lstr [lindex $todo 5]] \
			$tdd_todoCompl($tid) $ustr [lindex $todo 8]  $tdd_todoDring($tid) 28
		    set tddLines($lc) "TODO $tid"
		    incr lc
		}
	    }	
	    incr y $dy
	} elseif { [lindex $proj 1] == "TODO" } { 
	    set list [lindex $proj 12]
	    set ent [lindex $list 0]
	    set tid [lindex $ent 0]
#	    puts "/$proj/\n\t  ---->   /$list/ ---->   /$ent/   --> $tid"
	    set todo $tdd_todoList($tid)
#	    puts "TODO: /$todo/"
	    set ustr ""
	    foreach usr [lindex $todo 7] {
		if { [string length $ustr] > 0} {
		    set ustr [format "%s, %s" $ustr [lindex $usr 0]]
		} else  {
		    set ustr  [lindex $usr 0]
		}
	    }
	    $tddCan create rectangle 1 $y 972 [expr $y+25] -fill grey95 -outline grey95 -tag tddObj
	    drawTODOitem $y $pfnt12 [lindex $todo 2] [lindex $todo 3] \
		[date2lstr [lindex $todo 4]] [date2lstr [lindex $todo 5]] \
		$tdd_todoCompl($tid) $ustr [lindex $todo 8]  $tdd_todoDring($tid) 0 
	    set tddLines($lc) "TODO $tid"
	    incr lc
	    incr y $dy	    
	}	
    }
    set todoLines $lc
    $tddCan bind tddObj <ButtonPress> {actionTODO %x %y %b}
}
proc getAll_TodoDringlich { } {
    global tdd_todoList
    
    foreach tid [array names tdd_todoList] {
#	puts [format "is $tid dyman: %d %d" [lindex $tdd_todoList($tid) 0] [lindex $tdd_todoList($tid) 10]]
	if { [lindex $tdd_todoList($tid) 0] > 0 } {
	    getTodoDringlich $tid
	}
    }
}
proc getTodoDringlich { tid  } {
    global tdd_todoList tdd_todoDring
    
    set dring [lindex $tdd_todoList($tid) 9]
    if { [lindex $tdd_todoList($tid) 10] == 1} {
	set glen [timeBetween [lindex $tdd_todoList($tid) 4]  900 [lindex $tdd_todoList($tid) 5] 1900 ]
#	puts " >>> $glen "
	set ulen [timeBetween [lindex $tdd_todoList($tid) 4]  900 -1 -1]
#	puts " >>> $ulen "
	set delta [expr double($ulen/$glen)*100 - [lindex $tdd_todoList($tid) 6] ]
#	puts [format "DRRRING:  %s/%s vs %d -> %s" $ulen $glen [lindex $tdd_todoList($tid) 6] $delta ]
	if { $delta <-10 } { incr dring }
	if { $delta <-25 } { incr dring }
	if { $delta >10 } { incr dring -1}
	if { $delta >25 } { incr dring -1}
	if { $dring <0 } {set dring 0}
	if { $dring >7 } {set dring 7}
    }
    set tdd_todoDring($tid) $dring
}
proc getAll_TodoComplete { } {
    global tdd_todoList
    
    foreach tid [array names tdd_todoList] {
	if { [lindex $tdd_todoList($tid) 0] > 0 } {
	    getTodoComplete $tid
	}
    }
}
proc getTodoComplete { tid  } {
    global tdd_todoList tdd_todoCompl
    
    set compl [ lindex $tdd_todoList($tid) 6]
    foreach ent [lindex $tdd_todoList($tid)  12] {
	if { [ lindex $ent 0] == 1} {
	    if {$compl < [ lindex $ent 2]}  {
		set compl  [ lindex $ent 2]
	    }
	}
    }
    set tdd_todoCompl($tid) $compl
}

proc drawTODOitem { y titelFont stat titel start stop complete users init dring shift} {
    global tddCan bfnt fnt bfnt12 fnt12 pfnt12 pbfnt12 pbfnt11 todoStatIcon dringlichColor
 

    set col [lindex $dringlichColor $dring]
    #stat-image
    set y2 [expr $y +8]
    $tddCan create image [expr  20+$shift] $y -anchor nw -image [image create pixmap -data $todoStatIcon($stat)] -tag tddObj
    $tddCan create text [expr  48 +$shift] $y2 -anchor nw -font $titelFont -text $titel -tag tddObj -fill $col
    drawDringSymbol 946 [expr $y +12] $dring
    $tddCan create text 400 $y2 -anchor nw -font $pfnt12 -text $start -tag tddObj -fill $col
    $tddCan create text 477 $y2 -anchor nw -font $pfnt12 -text $stop     -tag tddObj -fill $col
    $tddCan create rectangle 549 [expr $y2 +2] 659 [expr $y2 +14] -fill grey35 -outline black -tag tddObj
    $tddCan create rectangle 550 [expr $y2 +3] [expr 558+int(100*(double($complete)/100))] [expr $y2 +13] -fill "#FFAE1A" -outline "#FFAE1A" -tag tddObj
    $tddCan create text 651 [expr $y2+3] -anchor ne -text [format "%d%%" $complete] -font $pbfnt11 -fill white -tag tddObj 
    $tddCan create text 665 $y2 -anchor nw -font $pfnt12 -text [strTrunc $users 27]    -tag tddObj -fill $col
    $tddCan create text 859 $y2 -anchor nw -font $pfnt12 -text $init     -tag tddObj -fill $col
}
proc drawDringSymbol { x y dring } {
    global tddCan dringlichColor

   
    set x0 [ expr $x -1 -$dring ]
    set x1 [ expr $x +1 +$dring ]
    set y0 [ expr $y -1 -$dring ]
    set y1 [ expr $y +1 +$dring ]
    set col [lindex $dringlichColor $dring ]
    $tddCan create oval $x0 $y0 $x1 $y1 -fill $col -outline $col -tag tddObj
    
}

#FIXME scrolling 
proc actionTODO { x y b} {
    global tddLines tdd_projList tdd_todoList
    global currID

#    doLock
    set lc [expr (int(floor($y/25)))]
    set id [lindex $tddLines($lc) 1]
#    puts "AT: $x $y $b -> $lc $id -> $tddLines($lc) ;"
    if {$b == 1} {
	if { [lindex $tddLines($lc) 0] =="PROJ"}  {
	    if {$x < 18 } {
		set proj $tdd_projList($id)
#		puts [lindex $proj 3]
		if { [lindex $proj 3] ==  "OPEN" } {
		    set proj [ lreplace $proj 3 3 "CLOSE" ]
		} else {
		    set proj [ lreplace $proj 3 3 "OPEN" ]
		}
		set tdd_projList($id)  $proj
		refillTODO
	    } else {
		set perm [lindex $tdd_projList($id) 2]
#		puts "perm(proj) =$perm"
		if {$perm =="r" || $perm == "rw" || $perm == "rwd"} {
		    setCurrProj $id
#		    puts "->drawPED"
		    drawPED
		}
	    }
	} else  {
#	    puts " - > $tdd_todoList($id)"
	    set perm [lindex $tdd_todoList($id) 1]
	    if {$perm =="r" || $perm == "rw" || $perm == "rwd"} {
		setCurrentTODO $id
		drawChangeTODO
	    }
	}
    } elseif {$b == 3} {
	if { [lindex $tddLines($lc) 0] =="PROJ"}  {
	    set currID $id
	    viewProjDialog
	} else {
	    set currID $id
	    viewTodoDialog
#	    puts "delete TODO $id"
	}
    }
#    unLock
}

proc viewProjDialog { } {
    global currID tdd_projList username  curProjTitel
    global bfnt fnt bfnt12 fnt12
    global _projText _buttonText _allgText

#    doLock
    if { [winfo exists .vpd ] == 1 } { return }
    toplevel .vpd
    busyCursor .vpd

    
    frame .vpd.t -relief raised -bd 1
    frame .vpd.b 
    pack .vpd.t  -side top -fill x
    pack .vpd.b -side bottom -fill x
    
    frame .vpd.t.0 -relief ridge -bd 2
    frame .vpd.t.1
    pack .vpd.t.0 -side top -fill x -ipadx 6 -ipady 8
    pack .vpd.t.1 -side top -fill x

    label .vpd.t.0.l -text "$_projText(projTitel):" -width 6 -font $bfnt
    set curProjTitel [lindex $tdd_projList($currID) 5]
    label .vpd.t.0.t -text [strTrunc $curProjTitel 66] -width 60 -font $bfnt -anchor n -justify center
    pack .vpd.t.0.l .vpd.t.0.t -side left -fill x

    frame .vpd.t.1.l -relief ridge -bd 2
    label .vpd.t.1.m -text " " 
    frame .vpd.t.1.r -relief ridge -bd 2
    pack .vpd.t.1.l .vpd.t.1.m .vpd.t.1.r  -side left -fill x


    label .vpd.t.1.l.l -text $_projText(projDescr) -font $bfnt
    tixScrolledText .vpd.t.1.l.t  -width 300 -height 200
    .vpd.t.1.l.t subwidget vsb configure -width 8
    .vpd.t.1.l.t subwidget hsb configure -width 8
    .vpd.t.1.l.t subwidget text configure -font $fnt12
    .vpd.t.1.l.t subwidget text insert end [lindex $tdd_projList($currID) 14]
    .vpd.t.1.l.t subwidget text configure  -state disabled
    pack .vpd.t.1.l.l .vpd.t.1.l.t  -side top

    label .vpd.t.1.r.l -text $_projText(projWorker) -font $bfnt
    tixScrolledListBox .vpd.t.1.r.b -width 240 -height 200 -state disabled
    .vpd.t.1.r.b subwidget vsb configure -width 8
    .vpd.t.1.r.b subwidget hsb configure -width 8
    .vpd.t.1.r.b subwidget listbox configure -font $fnt12
    foreach usr [lindex $tdd_projList($currID) 8] {
	.vpd.t.1.r.b subwidget listbox insert end [lindex $usr 0]
    }
    pack .vpd.t.1.r.l .vpd.t.1.r.b  -side top


    button .vpd.del -text $_buttonText(Delete) -command { checkDelProjDialog }
    button .vpd.ed  -text $_buttonText(Modify) -command {
	closeWin .vpd
	setCurrProj $currID
	drawPED
    }
    set perm [lindex $tdd_projList($currID) 2]
    if { $perm != "rw" && $perm != "rwd" } {
	if { $perm == "r" } {
	    .vpd.ed configure -text " $_allgText(permRead) "
	} else {
	    .vpd.ed configure -state disabled
	}
    }
   if { $perm != "rwd" } {
	.vpd.del configure -state disabled
    } 
    button .vpd.ok -text $_buttonText(Close) -command { closeWin .vpd}
    pack .vpd.ok .vpd.ed .vpd.del -side right
   centerWin .vpd 556 292
    update
    wm title .vpd "$_projText(projwmViewTitle)  [lindex $tdd_projList($currID) 5]"
#   puts [wm geometry .vpd]
#    unLock
    grab .vpd
    stdCursor .vpd
}

proc checkDelProjDialog { } {
    global curProjTitel
    global bfnt  eddLock _buttonText _projText


    if { [winfo exists .cdd ] == 1 } { return }
    toplevel .cdd
    frame .cdd.t -relief raised -bd 1
    frame .cdd.b 
    pack .cdd.t  -side top -fill x
    pack .cdd.b -side top -fill x -pady 3

    label .cdd.t.1 -text $_projText(projDel1)  -font $bfnt -justify center -anchor n
    label .cdd.t.2 -text "\"$curProjTitel\""  -font $bfnt -justify center -anchor n
    label .cdd.t.3 -text $_projText(projDel2)   -font $bfnt -justify center -anchor n
    pack .cdd.t.1 .cdd.t.2 .cdd.t.3 -side top -fill x
    
    button .cdd.b.abb -text $_buttonText(noWide)   -font $bfnt -command {
	closeWin .cdd
#	closeWin .vpd
    }
    pack .cdd.b.abb -side right
    button .cdd.b.del -text " $_buttonText(yes) "  -font $bfnt -command {
	closeWin  .cdd
	closeWin .vpd
	deleteCurrProj
	set eddLock 0
    }
    pack .cdd.b.del -side left
    centerWin .cdd 272 92 
    update
#    puts [wm geometry .cdd]
    grab .cdd

}


proc deleteCurrProj { } {
    global currID tdd_projList username 

    closeWin .vpd
    set ret [request deleteProject $username $currID]
    if { $ret == "Error" } { return }
    set tdd_projList($currID) [lreplace $tdd_projList($currID) 1 1 DELETED]
    updateDummyProj
    refillTODO
		
}
proc updateDummyProj { } {
    global tdd_projList nextDummyId tdd_todoPID tdd_todoList

    
    foreach tid [array names tdd_todoList] {
#	puts "tid=$tid => pid=$tdd_todoPID($tid)"
	if { $tdd_todoPID($tid)>=0 } {
	    set tdd_todoPID($tid) T
	}
    }
    foreach pid [array names tdd_projList] {
	#berprfen ob Proj nicht gelscht ist
	if { [ lindex $tdd_projList($pid) 1] == "PROJ" } {
	    foreach ent [lindex tdd_projList($pid) 12 ] {
		set tid [lindex $ent 0]
		set tdd_todoPID($tid) $pid
#		puts ">> tid=$tid => pid=$tdd_todoPID($tid)"
	    }
	}
    }
    foreach tid [array names tdd_todoList] {
	if { $tdd_todoPID($tid) == "T" } {
	    addDummyProject $tid -1
#	    puts ">>>> tid=$tid => pid=$tdd_todoPID($tid)"
	}
    }
}
proc viewTodoDialog { } {
    global currID tdd_todoList username  tdd_todoCompl tdd_todoDring 
    global bfnt fnt bfnt12 fnt12 
    global todoStatIcon TODOstatStr TODOstatVal dringlichStr dringlichColor
    global done12Img open12Img
    global curTodoTitel
    global _projText _buttonText _allgText

#    doLock
    if { [winfo exists .vtd ] == 1 } { return }
    toplevel .vtd
    wm title .vtd "$_projText(todoWmTitle) [lindex $tdd_todoList($currID) 3]"
    busyCursor .vtd
    
    frame .vtd.t -relief raised -bd 1
    frame .vtd.b 
    pack .vtd.t  -side top -fill x
    pack .vtd.b -side bottom -fill x
    
    frame .vtd.t.0 -relief ridge -bd 2
    frame .vtd.t.1 
    frame .vtd.t.2 -relief ridge -bd 2
    pack .vtd.t.0 -side top -fill x -ipadx 6 -ipady 8
    pack .vtd.t.1 -side top -fill x -ipadx 20
    pack .vtd.t.2 -side top -fill x -ipadx 20

    label .vtd.t.0.l -text "$_projText(todoTitel) :" -width 6 -font $bfnt
    set curTodoTitel [lindex $tdd_todoList($currID) 3]
    label .vtd.t.0.t -text [strTrunc $curTodoTitel 66] -width 66 -font $bfnt -anchor n -justify center
    pack .vtd.t.0.l .vtd.t.0.t -side left



    frame .vtd.t.1.l -relief ridge -bd 2
    frame .vtd.t.1.r -relief ridge -bd 2
    pack .vtd.t.1.l -side left -fill x
    pack .vtd.t.1.r -side right -fill x


    frame .vtd.t.1.l.0
    frame .vtd.t.1.l.1
    frame .vtd.t.1.l.2
    frame .vtd.t.1.l.3
    pack .vtd.t.1.l.0 .vtd.t.1.l.1 .vtd.t.1.l.3  .vtd.t.1.l.2 -side top -fill x -padx 3 -pady 1

    label .vtd.t.1.l.0.t -text "      "  -font $bfnt
    pack .vtd.t.1.l.0.t  -side left
    
    label .vtd.t.1.l.1.sl -text $_projText(todoStatus) -width 10 -font $bfnt
    button .vtd.t.1.l.1.sb -image [image create pixmap -data $todoStatIcon([lindex $tdd_todoList($currID) 2])] \
	-relief flat
    label .vtd.t.1.l.1.st -text [lindex $TODOstatStr $TODOstatVal([lindex $tdd_todoList($currID) 2 ]) ] -width 16 -font $bfnt12
    pack .vtd.t.1.l.1.sl .vtd.t.1.l.1.sb .vtd.t.1.l.1.st -side left

    label .vtd.t.1.l.2.c -text [format "$_projText(todoTaskDone1) %3d %% $_projText(todoTaskDone2)" $tdd_todoCompl($currID)] -font $bfnt -width 31
    pack .vtd.t.1.l.2.c -side left 

    label .vtd.t.1.l.3.pl -text $_projText(todoPriority) -width 10 -font $bfnt
#    puts [format "tdd_todoDring($currID) -> %s / %s" [lindex $dringlichStr $tdd_todoDring($currID)] [lindex $dringlichColor $tdd_todoDring($currID)]]
    label .vtd.t.1.l.3.pt -text [lindex $dringlichStr $tdd_todoDring($currID)] -font $bfnt -foreground [lindex $dringlichColor $tdd_todoDring($currID)]
    pack .vtd.t.1.l.3.pl .vtd.t.1.l.3.pt -side left

    frame .vtd.t.1.r.0
    frame .vtd.t.1.r.1
    pack  .vtd.t.1.r.0 .vtd.t.1.r.1  -side top -fill x -padx 3 -pady 1

    label .vtd.t.1.r.0.t -text $_projText(todoDescr) -font $bfnt
    pack .vtd.t.1.r.0.t  -side left
    tixScrolledText .vtd.t.1.r.1.t  -width 300 -height 72
    .vtd.t.1.r.1.t subwidget vsb configure -width 8
    .vtd.t.1.r.1.t subwidget hsb configure -width 8
    .vtd.t.1.r.1.t subwidget text configure -font $fnt12
    .vtd.t.1.r.1.t subwidget text insert end [lindex $tdd_todoList($currID) 11]
    .vtd.t.1.r.1.t subwidget text configure  -state disabled
    pack .vtd.t.1.r.1.t -side left

    
    label .vtd.t.2.l -text  $_projText(todoMilestones) -font $bfnt
    pack .vtd.t.2.l -side top -fill x

    set miles [lindex $tdd_todoList($currID) 12]
    for {set i 0 } {$i <8 } {incr i} {
	set stone [lindex $miles $i]

	frame .vtd.t.2.$i
	pack .vtd.t.2.$i  -side top -fill x -padx 4
	label .vtd.t.2.$i.n -text [format "%d)" [expr $i+1]]  -width 3 -font $fnt12
	if { [lindex $stone 0] == 1 } {
	    button .vtd.t.2.$i.s -image $done12Img -relief flat
	} else {
	    button .vtd.t.2.$i.s -image $open12Img -relief flat
	}
	label .vtd.t.2.$i.t -text [strTrunc [lindex $stone 1] 64 ] -width 64 -font $fnt12
	label .vtd.t.2.$i.l -text " = "  -width 3 -font $fnt12
	label .vtd.t.2.$i.p -text [format " %3d %%"  [lindex $stone 2] ] -font $fnt12
	pack .vtd.t.2.$i.n .vtd.t.2.$i.s .vtd.t.2.$i.t  .vtd.t.2.$i.l -side left
	pack .vtd.t.2.$i.p  -side right
    }
    
    button .vtd.del -text $_buttonText(Delete) -command { checkDelTodoDialog  }
    button .vtd.ed  -text $_buttonText(Modify) -command {
	closeWin .vtd
	setCurrentTODO $currID
	drawChangeTODO
    }

    set perm   [lindex $tdd_todoList($currID) 1]
    if { $perm != "rw" && $perm != "rwd" } {
	if { $perm == "r" } {
	    .vtd.ed configure -text " $allgText(permRead) "
	} else {
	    .vtd.ed configure -state disabled
	}
    }
    if { $perm != "rwd" } {
	.vtd.del configure -state disabled
    } 
    button .vtd.ok -text $_buttonText(Close) -command { closeWin .vtd}
    pack .vtd.ok .vtd.ed .vtd.del -side right -padx 4 -pady 2
    centerWin .vtd 572 356
    update
#    puts [wm geometry .vtd]
#    unLock
    grab .vtd
    stdCursor .vtd
}
proc checkDelTodoDialog { } {
    global curTodoTitel
    global bfnt  eddLock
    global _buttonText _projText

    if { [winfo exists .cdd ] == 1 } { return }
    toplevel .cdd
    frame .cdd.t -relief raised -bd 1
    frame .cdd.b 
    pack .cdd.t  -side top -fill x
    pack .cdd.b -side top -fill x -pady 3

    label .cdd.t.1 -text $_projText(todoDel1) -font $bfnt -justify center -anchor n
    label .cdd.t.2 -text "\"$curTodoTitel\""  -font $bfnt -justify center -anchor n
    label .cdd.t.3 -text $_projText(todoDel2)  -font $bfnt -justify center -anchor n
    pack .cdd.t.1 .cdd.t.2 .cdd.t.3 -side top -fill x
    
    button .cdd.b.abb -text $_buttonText(noWide)   -font $bfnt -command {
	closeWin .cdd
    }
    pack .cdd.b.abb -side right
    button .cdd.b.del -text " $_buttonText(yes) "  -font $bfnt -command {
	closeWin  .cdd
	closeWin .vtd
	deleteCurrTodo
	set eddLock 0
    }
    pack .cdd.b.del -side left
    centerWin .cdd 276 92 
    update
#    puts [wm geometry .cdd]
    grab .cdd

}
proc deleteCurrTodo { } {
    global currID tdd_todoList username  tdd_todoPID

    closeWin .vtd
    set ret [request deleteTodo $username $currID]
    if { $ret == "Error" } { return }
    set tdd_todoList($currID) [lreplace $tdd_todoList($currID) 0 0 -1 ]
    if {$tdd_todoPID($currID)<0} {removeDummyProject $currID}
    refillTODO
}

proc newTODO { } {
    clearCurrentTODO
    drawChangeTODO
}

proc setCurrentTODO { tid} {
    global tddv_titel tddv_descr tddv_wperm tddv_dperm
    global tddv_start tddv_stop tddv_users
    global tddv_status tddv_compl tddv_dring tddv_dynam
    global tddv_startD tddv_startM tddv_startY
    global tddv_stopD tddv_stopM tddv_stopY
    global tddv_id tddv_miles tddv_group tddv_init tddv_reminder
    global tdd_todoList
    global dringlichStr TODOstatStr TODOstati dringlichColor
    global tdd_button  tdd_type
    global tddv_mStat tddv_mTitel tddv_mCompl
    global _buttonText _projText

    set todo $tdd_todoList($tid)
    set tddv_id $tid
    set perm   [lindex $todo 1]
#    puts "PERM=$perm"
    if {$perm =="rw" || $perm == "rwd" } {
	set tddv_wperm 1
	if { $perm == "rwd" } {
	    set tddv_dperm 1
	} else {
	    set tddv_dperm 0
	}
    } else {
	set tddv_wperm 0
	set tddv_dperm 0
    }

    set tddv_status [lindex $todo 2]
    set tddv_titel  [lindex $todo 3]

    set datum [date2list [lindex $todo 4]]
    set tddv_startD [lindex $datum 0]
    set tddv_startM [lindex $datum 1]
    set tddv_startY [lindex $datum 2]
    set datum [date2list [lindex $todo 5]]
    set tddv_stopD  [lindex $datum 0]
    set tddv_stopM  [lindex $datum 1]
    set tddv_stopY  [lindex $datum 2]


    set tddv_compl  [lindex $todo 6]
    set tddv_users  [lindex $todo 7]
    set tddv_init   [lindex $todo 8]
    set tddv_dring  [lindex $todo 9]
    set tddv_dynam  [lindex $todo 10]
    set tddv_descr  [lindex $todo 11]
    set tddv_miles  [lindex $todo 12]
    for {set i 1} {$i<=8} {incr i} {
	set j [expr $i-1]
	set tddv_mStat($i)  [lindex [lindex $tddv_miles $j] 0]
	set tddv_mTitel($i) [lindex [lindex $tddv_miles $j] 1]
	set tddv_mCompl($i) [lindex [lindex $tddv_miles $j] 2]
    }
    set tddv_reminder [lindex $todo 13]
    set tddv_group [lindex $todo 14]

    set tdd_button $_buttonText(Modify)
    set tdd_type   $_projText(todoTypeModify)
}
proc clearCurrentTODO { } {
    global tddv_titel tddv_descr tddv_wperm  tddv_dperm
    global tddv_start tddv_stop tddv_users 
    global tddv_status tddv_compl tddv_dring tddv_dynam
    global tddv_startD tddv_startM tddv_startY
    global tddv_stopD tddv_stopM tddv_stopY tddv_id tddv_group tddv_init tddv_reminder
    global tdd_todoList
    global dringlichStr TODOstatStr TODOstati dringlichColor
    global today username
    global tdd_button tdd_type
    global tddv_mStat tddv_mTitel tddv_mCompl
    global _projText _buttonText

    set tddv_id -1
    set tddv_status NEW
    set tddv_titel  $_projText(todoDefaultTitle)
    set tddv_wperm 1
    set tddv_dperm 1

    set datum [date2list $today]
    set tddv_startD [lindex $datum 0]
    set tddv_startM [lindex $datum 1]
    set tddv_startY [lindex $datum 2]
    set datum [calcDate $tddv_startD $tddv_startM $tddv_startY 7]
    set tddv_stopD  [lindex $datum 0]
    set tddv_stopM  [lindex $datum 1]
    set tddv_stopY  [lindex $datum 2]


    set tddv_compl  0
    set tddv_users  "{$username 25 rw}"
    set tddv_init   $username
    set tddv_dring  3
    set tddv_dynam  0
    set tddv_descr  ""
    set tddv_miles  {}
    for {set i 1} {$i<=8} {incr i} {
	set tddv_mStat($i)  0
	set tddv_mTitel($i) ""
	set tddv_mCompl($i) 0
    }
    set tddv_reminder ""
    set tddv_group "__allgemein"
    set tdd_button $_buttonText(Create)
    set tdd_type   $_projText(todoTypeNew)
}


proc drawChangeTODO { } {
    global tddv_titel tddo_titel tdd_descr tddv_wperm tddv_id
    global tddv_start tddv_stop
    global tddv_status tddv_compl tddv_dring tddv_dynam
    global tddv_users
    global fnt bfnt fnt12 bfnt12 pfnt12 pbfnt12
    global tdd_button tddo_button tdd_type
    global tddo_titel
    global _projText _buttonText

    if { [winfo exists .tdc ] == 1 } { return }
    toplevel .tdc
    busyCursor .tdc
    
    frame .tdc.t -relief raised -bd 1
    frame .tdc.b 
    pack .tdc.t .tdc.b -side top -fill x

    frame .tdc.t.t
    frame .tdc.t.n
    pack .tdc.t.t  -side top  -pady 2 -fill x
    pack .tdc.t.n -side top -fill x

    label .tdc.t.t.l -text "$_projText(todo) :"
    set tddo_titel .tdc.t.t.e
    entry $tddo_titel  -textvariable tddv_titel -width 60  -vcmd {checkEntryText %P 200  %d %S ""} -validate key
    pack .tdc.t.t.l .tdc.t.t.e -side left

    tixNoteBook .tdc.t.n.b  -ipadx 2 -ipady 2
    .tdc.t.n.b  subwidget nbframe configure  -font $bfnt12
    .tdc.t.n.b add zeit -label $_projText(totoModiPageCoords)
    .tdc.t.n.b add descr -label $_projText(totoModiPageDescr)
    .tdc.t.n.b add users -label $_projText(totoModiPageWorker)
    .tdc.t.n.b add reminder -label $_projText(totoModiPageReminder)
    .tdc.t.n.b add miles -label $_projText(totoModiPageMilest)
    pack .tdc.t.n.b -fill x
    
    drawChangeTODOZeiten   [ .tdc.t.n.b subwidget zeit ]
    drawChangeTODODescr    [ .tdc.t.n.b subwidget descr ]
    drawChangeTODOUsers    [ .tdc.t.n.b subwidget users ]
    drawChangeTODOReminder [ .tdc.t.n.b subwidget reminder ]
    drawChangeTODOMiles    [ .tdc.t.n.b subwidget miles ]

    button .tdc.b.abb -text " $_buttonText(Cancel) " -command {closeWin .tdc }
    pack .tdc.b.abb -side left 
    set tddo_button .tdc.b.chg

    button .tdc.b.del -text " $_buttonText(Delete) " -command  {
	set currID $tddv_id
	set curTodoTitel $tddv_titel
	checkDelTodoDialog
    }
    pack .tdc.b.del -side left  -padx 12
    if { $tddv_id <0 } { .tdc.b.del  configure -state disabled }

    button $tddo_button -text $tdd_button -command {changeTODO } -width 10
    pack $tddo_button -side right 
    setPerm4ChangeDialog

    wm title .tdc "$tdd_type: $tddv_titel"
#    wm title .tdc [format "$t'%s' %s" $tddv_titel [ string tolower $tdd_button] ]

    centerWin .tdc 500 320
    update
    grab .tdc
    stdCursor .tdc
#    puts [wm geometry .tdc]
#    wm geometry .tdc -200+200
}
proc setPerm4ChangeDialog { } {
    global tddv_wperm tddo_button
    global tddo_titel
    global tddo_startD tddo_startM tddo_startY
    global tddo_stopD tddo_stopM tddo_stopY
    global tddo_status tddo_compl tddo_dring tddo_dynam
    global tddo_descr tddo_users
    global tddo_addU tddo_remU  tddo_group
    global tddo_mTitel tddo_mStat tddo_mCompl
    global _buttonText
    
    if { $tddv_wperm == 0 } { 
	set widgets "$tddo_titel $tddo_startD $tddo_startM $tddo_startY $tddo_stopD $tddo_stopM $tddo_stopY $tddo_status $tddo_compl $tddo_dring $tddo_dynam $tddo_addU $tddo_remU  $tddo_group "

	foreach widget $widgets {
	    $widget configure -state disabled
	}
	for {set i 1} {$i <=8} {incr i } {
	    $tddo_mStat($i)  configure -state disabled
	    $tddo_mTitel($i) configure -state disabled
	    $tddo_mCompl($i) configure -state disabled
	}
	$tddo_users configure -state disabled
	$tddo_descr subwidget text configure -state disabled

	$tddo_status subwidget menubutton configure -disabledforeground grey25
	$tddo_status subwidget label      configure -foreground grey25
	$tddo_dring  subwidget menubutton configure -disabledforeground grey25
	$tddo_dring  subwidget label      configure -foreground grey25
	$tddo_group  subwidget menubutton configure -disabledforeground grey25
	$tddo_group  subwidget label      configure -foreground grey25
	$tddo_dynam  configure -disabledforeground grey25
	
	$tddo_button configure -text " $_buttonText(Close) "
    }
}

proc changeTODO { } {
    global tddv_titel tddv_descr tddv_perm
    global tddv_start tddv_stop tddv_users tddv_init
    global tddv_status tddv_compl tddv_dring tddv_dynam
    global tddv_startD tddv_startM tddv_startY
    global tddv_stopD tddv_stopM tddv_stopY tddv_id tddv_group tddv_miles tddv_reminder
    global tdd_todoList 
    global dringlichStr TODOstatStr TODOstati dringlichColor
    global today username
    global tdd_button TODOstati
    global tddo_descr tddv_mStat tddv_mTitel tddv_mCompl
    global currTodo
    

    set tddv_miles ""
    for {set i 1} { $i <9 } {incr i} {
	set ent "$tddv_mStat($i) {$tddv_mTitel($i)} $tddv_mCompl($i)"
	lappend tddv_miles $ent
    }
#    puts $tddv_miles
#    puts tddv_users

#    set tddv_descr ""
#     set list [ $tddo_descr subwidget text dump -text 0.0 end]
#     set l [llength $list]
#     for { set i 1} {$i < $l } {incr i 3 } {
# 	set tddv_descr [format "%s%s" $tddv_descr [ lindex $list $i] ]
#     }
    set tddv_descr [braces2parenthesis [ $tddo_descr subwidget text get  0.0 end] ]
    set tddv_descr [string trim $tddv_descr ]


    set status [lsearch $TODOstati $tddv_status]
    set tid [transfer changeTodo  $tddv_id $username $status $tddv_titel [format "%04d%02d%02d" $tddv_startY $tddv_startM $tddv_startD] [format "%04d%02d%02d" $tddv_stopY $tddv_stopM $tddv_stopD] $tddv_compl $tddv_users $tddv_init $tddv_dring $tddv_dynam $tddv_descr $tddv_miles $tddv_reminder $tddv_group]
    if { $tid == "Error" } { 
	closeWin .tdc
	return 
    }

#    puts "dynam for $tid $tddv_dynam"
    
    set todo [request getTODO $username  $tid]
    if { $todo== "Error" } { 
	closeWin .tdc
	return 
    }
    set stat [lindex $TODOstati [lindex $todo 2] ]
    set todo [ lreplace $todo 2 2 $stat]
    set tdd_todoList($tid) $todo
    if { $tddv_id <0 } {   addDummyProject $tid -1}
    refillTODO
#     foreach tid [lsort [array names tdd_todoList]] { 
# 	puts "TID=$tid: $tdd_todoList($tid)"
#     }
    getTodoDringlich $tid
    getTodoComplete $tid
#    puts " -> /$currTodo/"
    closeWin .tdc
}

proc drawChangeTODOZeiten { win } {
    global tddv_status tddv_compl tddv_dring tddv_dynam
    global tddo_status tddo_compl tddo_dring tddo_dynam
    global fnt bfnt fnt12 bfnt12 pfnt12 pbfnt12
    global tddv_startD tddv_startM tddv_startY
    global tddo_startD tddo_startM tddo_startY tddo_startC
    global tddv_stopD tddv_stopM tddv_stopY
    global tddo_stopD tddo_stopM tddo_stopY tddo_stopC
    global dringlichStr TODOstatStr TODOstati dringlichColor
    global _allgText _projText  _dateOrder selDateCalIcon

    frame $win.t -relief ridge -bd 2
    frame $win.b -relief ridge -bd 2
    pack $win.t $win.b -side top -fill x -pady 2 


    frame  $win.t.1
    frame  $win.t.2
    frame  $win.t.3
    pack  $win.t.1 $win.t.2 $win.t.3 -side top -fill x -pady 1 

    label $win.t.1.l -text $_projText(todoModiTimesHeader)
    pack $win.t.1.l -side left
    set tddo_startD $win.t.2.d
    set tddo_startM $win.t.2.m
    set tddo_startY $win.t.2.y
    set tddo_startC $win.t.2.c

    label $win.t.2.l1 -text "    $_projText(todoModiTimesFrom) " -width 9 -font $bfnt12
    label $win.t.2.s1 -text "$_allgText(dateSep) " -width 2 -font $bfnt12
    label $win.t.2.s2 -text "$_allgText(dateSep) " -width 2 -font $bfnt12

    tixControl $tddo_startD  -min 0 -max 31 -integer 1 -options {  entry.width 2  } \
	-variable tddv_startD  -selectmode immediate -autorepeat true
    tixControl $tddo_startM  -min 0 -max 12 -integer 1 -options {  entry.width 2 } \
	-variable tddv_startM -selectmode immediate -autorepeat true
    tixControl $tddo_startY  -min 1900 -max 9999 -integer 1 -options {  entry.width 4  } \
	-variable tddv_startY -selectmode immediate -autorepeat true
    button $tddo_startC -image [image create pixmap -data $selDateCalIcon] -command {
	set x [ winfo rootx $tddo_startC]
	set y [expr  [ winfo rooty $tddo_startC] + [ winfo height $tddo_startC] ]
	set dlist [ displayYearCalAtPosition $tddv_startD $tddv_startM $tddv_startY $x $y .tdc]
	set tddv_startD [lindex $dlist 0]
	set tddv_startM [lindex $dlist 1]
	set tddv_startY [lindex $dlist 2]
    }

    switch $_dateOrder {
	de  {pack $win.t.2.l1 $tddo_startD $win.t.2.s1 $tddo_startM $win.t.2.s2 $tddo_startY $tddo_startC -side left}
	en  -
	default
	{pack $win.t.2.l1 $tddo_startM $win.t.2.s1 $tddo_startD $win.t.2.s2 $tddo_startY $tddo_startC -side left}
    }
    pack forget [ $tddo_startD subwidget incr ]
    pack forget [ $tddo_startM subwidget incr ]
    pack forget [ $tddo_startY subwidget incr ]
    pack forget [ $tddo_startD subwidget decr ]
    pack forget [ $tddo_startM subwidget decr ]
    pack forget [ $tddo_startY subwidget decr ]

    set tddo_stopD $win.t.3.d
    set tddo_stopM $win.t.3.m
    set tddo_stopY $win.t.3.y
    set tddo_stopC $win.t.3.c 
    label $win.t.3.l1 -text "    $_projText(todoModiTimesTo) " -width 9 -font $bfnt12
    label $win.t.3.s1 -text "$_allgText(dateSep) " -width 2 -font $bfnt12
    label $win.t.3.s2 -text "$_allgText(dateSep) " -width 2 -font $bfnt12
    tixControl $tddo_stopD -min 0 -max 31 -integer 1 -options {  entry.width 2  } \
	-variable tddv_stopD -selectmode immediate -autorepeat true
    tixControl $tddo_stopM -min 0 -max 12 -integer 1 -options {  entry.width 2  } \
	-variable tddv_stopM -selectmode immediate -autorepeat true
    tixControl $tddo_stopY -min 1900 -max 9999 -integer 1 -options {  entry.width 4  } \
	-variable tddv_stopY -selectmode immediate -autorepeat true
    button $tddo_stopC -image [image create pixmap -data $selDateCalIcon] -command {
	set x [ winfo rootx $tddo_stopC]
	set y [expr  [ winfo rooty $tddo_stopC] + [ winfo height $tddo_stopC] ]
	set dlist [ displayYearCalAtPosition $tddv_stopD $tddv_stopM $tddv_stopY $x $y .tdc]
	set tddv_stopD [lindex $dlist 0]
	set tddv_stopM [lindex $dlist 1]
	set tddv_stopY [lindex $dlist 2]
    }
    switch $_dateOrder {
	de  {pack $win.t.3.l1 $tddo_stopD $win.t.3.s1 $tddo_stopM $win.t.3.s2 $tddo_stopY $tddo_stopC  -side left}
	en  -
	default
	{pack $win.t.3.l1 $tddo_stopM $win.t.3.s1 $tddo_stopD $win.t.3.s2 $tddo_stopY $tddo_stopC  -side left}
    }
    pack forget [ $tddo_stopD subwidget incr ]
    pack forget [ $tddo_stopM subwidget incr ]
    pack forget [ $tddo_stopY subwidget incr ]
    pack forget [ $tddo_stopD subwidget decr ]
    pack forget [ $tddo_stopM subwidget decr ]
    pack forget [ $tddo_stopY subwidget decr ]


    frame  $win.b.1
    frame  $win.b.2
    frame  $win.b.3
    pack  $win.b.1 $win.b.2 $win.b.3 -side top -fill x -pady 1

    
    set tddo_status $win.b.1.o
    tixOptionMenu $tddo_status -options {menubutton.width 15 label.width 20} -label $_projText(todoModiCurStatus)
    $tddo_status subwidget label configure -font $bfnt12
    for {set i 0} {$i<[llength  $TODOstatStr ]} {incr i } {
	$tddo_status add command [lindex $TODOstati $i] -label [lindex $TODOstatStr $i]
    }
    pack $tddo_status -side left
    $tddo_status configure -variable tddv_status

    set tddo_compl $win.b.2.s
    label  $win.b.2.l -text "$_projText(todoModiComplete):" -width 20 -height 2 -anchor nw -font $bfnt12
    scale $win.b.2.s -from 0 -to 100 -resolution 1 -variable tddv_compl -orient horizontal -length 200 -font $bfnt12
    pack $win.b.2.l  $tddo_compl -side left

    set tddo_dring $win.b.3.o
    set tddo_dynam $win.b.3.c
    tixOptionMenu $tddo_dring -options {menubutton.width 20 label.width 20} -label $_projText(todoModiUrgency) 
    $tddo_dring subwidget label configure -font $bfnt12
    for {set i 0} {$i<[llength  $TODOstatStr ]} {incr i } {
	$tddo_dring add command  $i -label [lindex $dringlichStr $i]
    }
    label $win.b.3.l -text "  "
    checkbutton $tddo_dynam -text $_projText(todoModiUrgencyDyn) -variable $tddv_dynam  -font $bfnt12 -variable tddv_dynam
    pack $tddo_dring $win.b.3.l $tddo_dynam -side left
#    puts "$tddv_status $tddv_dring"
    $tddo_dring configure -variable tddv_dring
    
#    puts "$tddv_status $tddv_dring"

}
proc drawChangeTODODescr  { win } {
    global tddv_descr tddo_descr
    global fnt12

    frame $win.f -relief ridge -bd 2
    pack  $win.f -padx 2 -pady 2 -fill x 

    set tddo_descr $win.f.t
    tixScrolledText $win.f.t  -width 480 -height 192
    pack $win.f.t  -side left
    $win.f.t subwidget vsb configure -width 12
    $win.f.t subwidget hsb configure -width 12
    $win.f.t subwidget text configure -font $fnt12
    $win.f.t subwidget text insert end $tddv_descr
}
proc drawChangeTODOUsers  { win } {
    global tddv_users tddo_users tddo_potUsers  tddl_groupStart tddo_group tddo_addU tddo_remU
    global tddo_addU tddo_remU
    global userList groupList tddv_group
    global fnt12 bfnt12 fnt bfnt pfnt12 
    global _allgText _projText

    frame $win.f -relief ridge -bd 2
    frame $win.g -relief ridge -bd 2
    pack  $win.f $win.g -padx 2 -pady 2 -fill x
    
    frame $win.f.l
    frame $win.f.m
    frame $win.f.r
    pack $win.f.l $win.f.m $win.f.r -side left -fill both

    set tddo_users $win.f.l.l
    tixScrolledListBox   $tddo_users -scrollbar y -height 152 -width 242 -options {listbox.selectMode extended}
    $tddo_users subwidget vsb configure -width 12
    $tddo_users subwidget hsb configure -width 12
    $tddo_users subwidget listbox configure -font $pfnt12
    pack $tddo_users -side top 

    set tddo_addU  $win.f.m.add
    set tddo_remU  $win.f.m.rem
    label $win.f.m.1 -text " " -height 3
    button $tddo_addU -text "  <<<  " -command addTDCselction
    label $win.f.m.2 -text " " -height 1
    button $tddo_remU -text "  >>>  " -command delTDCselction
    pack $win.f.m.1 $tddo_addU $win.f.m.2 $tddo_remU -side top -fill y

    set tddo_potUsers $win.f.r.l
    tixScrolledListBox  $tddo_potUsers -scrollbar y -height 152 -width 180 -options {listbox.selectMode extended}
    $tddo_potUsers subwidget vsb configure -width 12
    $tddo_potUsers subwidget hsb configure -width 12
    $tddo_potUsers subwidget listbox configure -font $pfnt12
    pack $tddo_potUsers -side top 
    set tddl_groupStart 0
    foreach user $userList {
	$tddo_potUsers subwidget listbox insert end $user
	incr tddl_groupStart
    }
#    $tddo_potUsers subwidget listbox insert end "12345678901234567890"
    foreach group $groupList {
	$tddo_potUsers subwidget listbox insert end "_allgText(Gruppe) $group"
    }

    set tddo_group $win.g.m
    tixOptionMenu $tddo_group -options {menubutton.width 20} -label "$_projText(todoModiGroupAssign1) "
    $tddo_group subwidget label configure -font $bfnt12
    $tddo_group subwidget menubutton configure  -font $fnt12
    $tddo_group subwidget menu configure  -font $bfnt12
    label $win.g.l -text " $_projText(todoModiGroupAssign2)." -font $bfnt12
    pack $tddo_group $win.g.l -side left
    $tddo_group add command __allgemein -label $_projText(todoModiPublic)
    $tddo_group add separator sep1
    foreach group $groupList {
	$tddo_group add command $group -label $group
    }
    $tddo_group add separator sep2
    $tddo_group add command _privToDo -label $_projText(todoModiPrivate) 
    $tddo_group configure -variable tddv_group


    fillTDCusers
    bind [$tddo_users subwidget listbox] <ButtonPress> {changeLastDialog %y %b}
}

proc refillTDCusers { } {
    global tddv_users tddo_users tddo_potUsers  tddl_groupStart

    $tddo_users subwidget listbox delete 0 end
#    puts "redarw for $tddv_users"
    fillTDCusers
}
proc fillTDCusers { } {
    global tddv_users tddo_users tddo_potUsers  tddl_groupStart
    
    foreach user $tddv_users { 
	$tddo_users subwidget listbox insert end \
	    [format "%-20s %3s %3d%%" [strTrunc [lindex $user 0] 23] [lindex $user 2] [lindex $user 1] ]
    }
#     $tddo_users subwidget listbox insert end \
# 	[format "%-20s %2s %3d%%" "12345678901234567890" "rw" 100 ]
}

proc addTDCselction {  } {
    global tddv_users tddo_users tddo_potUsers  tddl_groupStart
    global groupList userList _allgText
    
    set selection  [$tddo_potUsers subwidget listbox curselection]

    foreach sel $selection {
	if {$sel > $tddl_groupStart } {
	    set user [format "{$_allgText(Gruppe) %s} 25" [lindex $groupList [expr $sel -$tddl_groupStart]]]
	} else {
	    set user [format "{%s} 25 r" [lindex $userList $sel ]]
	}
#FIXME Duppletten vermeiden
	lappend tddv_users $user 
    }
    refillTDCusers
}
proc delTDCselction {  } {
    global tddv_users tddo_users tddo_potUsers  tddl_groupStart
    
    set selection  [$tddo_users subwidget listbox curselection]
    
    foreach sel [lsort -decreasing $selection ] {
	set tddv_users [lreplace $tddv_users $sel $sel ]
    }
    refillTDCusers
}
proc changeLastDialog { y b } {
    global currSel currLast tddv_users fnt12 currRight tddv_init  username curr_delRight cldo_del
    global fullUserNames
    global _projText _buttonText

    if { $b ==3 } {
#	puts "change Last $y"
	#FIXME (vielw User)
	if { [winfo exists .cld ] == 1 } { return }
	set yk [expr $y]
	set currSel [expr int(floor($yk/15))]
	
	set user [lindex $tddv_users $currSel]
	set currUser [lindex $user 0]
	set currLast [lindex $user 1]
	set currRight [lindex $user 2]
	if { $currRight == "rwd" } {
	    set currRight rw
	    set curr_delRight 1
	} else {
	    set curr_delRight 0
	}


	toplevel .cld
	frame .cld.e -relief raised -bd 2
	frame .cld.r -relief raised -bd 2
	frame .cld.b 
	pack .cld.e .cld.r .cld.b -side top -fill x

	label .cld.e.1 -text $_projText(todoLoadText1) -font $fnt12 -anchor n -justify center
	label .cld.e.2 -text $fullUserNames(u-$currUser) -font $fnt12 -anchor n -justify center
	label .cld.e.3 -text $_projText(todoLoadText2) -font $fnt12 -anchor n -justify center
	scale .cld.e.s -from 0 -to 100 -resolution 1 -length 200 -orient horizontal -variable currLast
	pack .cld.e.1 .cld.e.2 .cld.e.3  .cld.e.s -side top 


	frame .cld.r.1
	frame .cld.r.2
	pack .cld.r.1 .cld.r.2 -side top -fill x
	checkbutton .cld.r.1.c -text $_projText(todoWritePerm) -onvalue rw -offvalue r -variable currRight -command toggleDelTodo -font $fnt12
	pack .cld.r.1.c -side left
	set cldo_del .cld.r.2.c
	label .cld.r.2.l -text "  "
	checkbutton $cldo_del -text $_projText(todoDeletePerm) -variable curr_delRight -state disabled -font $fnt12
	if { $curr_delRight == 1} {
	    $cldo_del configure -state normal
	}
	
	pack .cld.r.2.l $cldo_del -side left

	if { $currUser == $tddv_init } {
	    set currRight rw
	    set curr_delRight 1
	    .cld.r.1.c configure -state disabled
	    $cldo_del configure -state disabled
	} else {
	    toggleDelTodo
	}

	button .cld.b.abb -text $_buttonText(Cancel) -command {destroy .cld}
	pack .cld.b.abb -side left
	button .cld.b.chg -text " $_buttonText(Modify) " -command {changeLast}
	pack .cld.b.chg -side right
	
#	update
#	wm geometry .cld -300+300
	centerWin .cld 272 175
	update
	puts stdout [wm geometry .cld]
	grab .cld
    }
}

proc  toggleDelTodo { } {
    global currRight cldo_del  curr_delRight 
    if { $currRight == "rw" } {
	$cldo_del configure -state normal
    } else {
	$cldo_del configure -state disabled
	set curr_delRight 0
    }
}

proc changeLast { } {
    global currSel currLast tddv_users currRight curr_delRight 

    if { $currRight ==  "rw" } {
	if {$curr_delRight == 1} {
	    set currRight rwd
	}
    }
    set user [lindex $tddv_users $currSel]
    set user [lreplace $user 1 2 $currLast $currRight]
    set tddv_users [lreplace $tddv_users $currSel $currSel $user]
    destroy .cld
    refillTDCusers
}

proc drawChangeTODOReminder {win } {
    global bfnt fnt pbfnt pfnt fnt12 bfnt12
    global tddo_reminder
    global edd_part
    global tddo_remWann1 tddo_remWann2 tddo_remWie tddo_remWer tddo_remAls
    global tddv_remVal tddv_remUnit tddv_remWeg tddv_remZiel tddv_remAls
    global _projText _allgText 

    frame $win.l
    frame $win.r 
    frame $win.d
    pack $win.l  -side top -fill x -pady 2
    pack $win.r $win.d -side top -fill x

    label $win.l.l -text $_projText(todoRemind) -font $bfnt12
    pack $win.l.l -side left

    set tddo_reminder $win.r.r
    tixCObjView $tddo_reminder -width 480  -height 116 -scrollbar   y
    $tddo_reminder subwidget vsb configure -width 12
    pack $tddo_reminder -side top


    frame $win.d.l
    frame $win.d.r
    pack $win.d.l $win.d.r -side left -fill both

    frame $win.d.l.1
    frame $win.d.l.2
    pack  $win.d.l.1 $win.d.l.2 -side top -fill x

    set tddo_remWann1 $win.d.l.1.w1
    set tddo_remWann2 $win.d.l.1.w2
    set tddo_remWann3 $win.d.l.1.w3
    set tddo_remAls   $win.d.l.1.t
    set tddo_remWie   $win.d.l.2.wie
    set tddo_remWer   $win.d.l.2.wer
    
    set tddv_remVal 1
    label $win.d.l.1.l -text $_projText(todoRemindSend) -width 9 -font $bfnt12
    tixControl $tddo_remWann1  -min 1 -max 31 -options {  entry.width 4  } -variable tddv_remVal -selectmode immediate -autorepeat true
    tixOptionMenu $tddo_remWann2  -options {menubutton.width 8} -variable tddv_remUnit
    $tddo_remWann2 add command Tage -label $_projText(todoRemindDays)
    $tddo_remWann2 add command Stunden -label $_projText(todoRemindHours)
    $tddo_remWann2 add command Minuten -label $_projText(todoRemindMin)
    $tddo_remWann2  subwidget menubutton configure  -font $bfnt12
#    label $win.m.wann3 -text "vorher " -font $fnt12
    label $tddo_remAls -text $_projText(todoRemindRemind) -width 9 -font $bfnt12
    tixOptionMenu $tddo_remWann3  -options {menubutton.width 6} -variable tddv_remAls -command toggleRemState
    $tddo_remWann3 add command R -label $_projText(todoRemindBefore)
    $tddo_remWann3 add command M -label $_projText(todoRemindAfter)
    $tddo_remWann3  subwidget menubutton configure  -font $bfnt12
    label $win.d.l.1.l2 -text $_projText(todoRemind_A)  -font $bfnt12 
    pack $win.d.l.1.l $tddo_remWann1 $tddo_remWann2 $tddo_remWann3 $win.d.l.1.l2 $tddo_remAls -side left
    
    label $win.d.l.2.l -text "   $_projText(todoRemindBy) "  -font $bfnt12 -width 9
    tixOptionMenu $tddo_remWie  -options {menubutton.width 12 }  -variable tddv_remWeg
    $tddo_remWie add command E-mail -label $_projText(todoRemindByMail)
    $tddo_remWie add command Fenster -label $_projText(todoRemindByDialog)
#    $tddo_remWie disable Fenster
    $tddo_remWie subwidget menubutton configure  -font $bfnt12

    label $win.d.l.2.l2 -text " $_projText(todoRemindTo) "  -font $bfnt12 -width 4
    tixOptionMenu $tddo_remWer  -options {menubutton.width 20}  -variable tddv_remZiel
    updateTodoReminderUser
    $tddo_remWer subwidget menubutton configure  -font $bfnt12
    label $win.d.l.2.l3 -text " "  -font $bfnt12 -width 2
    pack  $win.d.l.2.l $tddo_remWie $win.d.l.2.l2  $tddo_remWer $win.d.l.2.l3  -side left

    button $win.d.r.go -text $_projText(todoRemindAdd) -font $bfnt12 -command {addRemind2Todo}
    pack $win.d.r.go -side bottom
    fillTodoReminder
}
proc toggleRemState { val } {
    global tddv_remAls  tddo_remAls  _projText 
    if { $tddv_remAls == "M" } {
	$tddo_remAls configure -text $_projText(todoRemindWarning)
    } else {
	$tddo_remAls configure -text $_projText(todoRemindRemind)
    }
}
proc fillTodoReminder { } {
    global tddv_reminder tddo_reminder
    global pfnt12 pbfnt username tddv_wperm
    global _projText

    set y 15
    set dy 16
    set can [$tddo_reminder subwidget canvas]
    $can delete all
    set c 0
    set rn 0
    foreach reminder $tddv_reminder {
	set off  [lindex $reminder 0]
	set unit [lindex $reminder 1]
	set weg  [lindex $reminder 2]
	set user [lindex $reminder 3]
	set ziel [lindex $reminder 4]
	set als  [lindex $reminder 5]
	
	if { $als == "M" } {
	    set tstr "$_projText(todoRemindAfter)"
	} else {
	    set tstr "$_projText(todoRemindBefore)"
	}

	$can create text 2 $y -text [format "%5.2f %7s %8s via %7s an %-28s" $off $unit $tstr $weg \
					 [nameStrTrunc $ziel 28]] -font $pfnt12 -justify left -anchor sw
	if { $user == $username  || $tddv_wperm==1 } {
	    $can create text 452 [expr $y-0]  -text "X" -anchor sw -tag del -font $pbfnt -fill red 
	}
	$can create line 0 $y 480 $y -fill grey98
	
	incr c
	incr y $dy
	incr rn
    }
    $tddo_reminder adjustscrollregion
    $can bind del <Button> { removeTodoReminder %y}
}
proc removeTodoReminder { y  } {
    global tddv_reminder tddo_reminder 

    set h [expr 16 * [llength $tddv_reminder]]
    set f [lindex [$tddo_reminder subwidget vsb get] 0]
    set yk [ expr int(floor($f*$h)) +$y]
    set nr [expr int(floor($yk /16))]
    set tddv_reminder [lreplace $tddv_reminder $nr $nr ]
    fillTodoReminder
    $tddo_reminder adjustscrollregion
    
}
proc updateTodoReminderUser { } {
    global tddo_remWer tdd_part tddv_wperm fullUsername tdd_groupsOfUser
    global username tddv_users fullUserNames _projText


    set entList [$tddo_remWer entries]
    foreach ent $entList { $tddo_remWer delete $ent }

    if { $tddv_wperm == 1} {
	$tddo_remWer add command alle -label $_projText(todoReminderAll)
    }
#    puts $tddv_users
#    return
    foreach part $tddv_users {
	set name [lindex $part 0]
	set full $fullUserNames(u-$name)
	if { $tddv_wperm == 1} {
	    $tddo_remWer add command $name -label $full
	} else { 
	    if { $username == [lindex $part 1] } {
		$tddo_remWer add command $name -label $full
	    }
	}
    }    
}
proc addRemind2Todo { } {
    global tddv_remVal tddv_remUnit tddv_remWeg tddv_remZiel tddv_remAls
    global tddv_reminder tddo_remWer

    set full [ $tddo_remWer entrycget $tddv_remZiel -label ]

    lappend tddv_reminder "$tddv_remVal $tddv_remUnit $tddv_remWeg $tddv_remZiel {$full} $tddv_remAls"
    fillTodoReminder
}

proc drawChangeTODOMiles  { win } {
    global tddv_miles
    global bfnt12 fnt12 fnt10 pbfnt12
    global tddv_mTitel tddv_mStat tddv_mCompl
    global tddo_mTitel tddo_mStat tddo_mCompl
    global tddo_mScale
    global _projText

#    puts "$tddv_mTitel(1)"
    
    frame $win.f -relief ridge -bd 2
    pack $win.f -side top -pady 2 -padx 2 -fill x
    
    frame $win.f.0
    frame $win.f.1
    frame $win.f.2
    frame $win.f.3
    frame $win.f.4
    frame $win.f.5
    frame $win.f.6
    frame $win.f.7
    frame $win.f.8
    
    for {set i 0} {$i<=8} {incr i} { pack $win.f.$i -side top -fill x}


    for {set i 1} {$i <=8} {incr i } {
	set tddo_mStat($i) $win.f.$i.c
	set tddo_mTitel($i) $win.f.$i.t
	set tddo_mCompl($i) $win.f.$i.s
    }

    set tddo_mScale $win.f
    label $win.f.0.l -text " #" -width 3 -font $bfnt12
    label $win.f.0.c -text $_projText(todoMilesDone) -width 6 -font $bfnt12
    label $win.f.0.t -text $_projText(todoMilesName) -width 22 -font $bfnt12
    label $win.f.0.p -text "" -width 1
    label $win.f.0.s -text $_projText(todoMilesComplete) -font $bfnt12
    pack $win.f.0.l $win.f.0.c $win.f.0.t  $win.f.0.p $win.f.0.s   -side left
    
    label $win.f.1.l -text "1: " -width 3 -font $bfnt12
    checkbutton $tddo_mStat(1) -variable tddv_mStat(1) -text " " -width 3
    entry $tddo_mTitel(1) -textvariable tddv_mTitel(1) -font $fnt12 -width 20  -vcmd {checkEntryText %P 127  %d %S ""} -validate key
    label $win.f.1.p -text " " -width 2
    scale $tddo_mCompl(1) -variable tddv_mCompl(1) -from 0 -to 100 -orien horizontal -length 164 -font $fnt10 -width 12 -showvalue 0 -command {setMileScaleValue 1}
    label $win.f.1.d -text [format " %3d%%" 0] -font $pbfnt12
    
    label $win.f.2.l -text "2: " -width 3 -font $bfnt12
    checkbutton $tddo_mStat(2) -variable tddv_mStat(2) -text " " -width 3
    entry $tddo_mTitel(2) -textvariable tddv_mTitel(2) -font $fnt12 -width 20 -vcmd {checkEntryText %P 127  %d %S ""} -validate key
    label $win.f.2.p -text " " -width 2
    scale $tddo_mCompl(2) -variable tddv_mCompl(2) -from 0 -to 100 -orien horizontal -length 164 -font $fnt10 -width 12 -showvalue 0 -command {setMileScaleValue 2}
    label $win.f.2.d -text [format " %3d%%" 0] -font $pbfnt12
    
    label $win.f.3.l -text "3: " -width 3 -font $bfnt12
    checkbutton $tddo_mStat(3) -variable tddv_mStat(3) -text " " -width 3
    entry $tddo_mTitel(3) -textvariable tddv_mTitel(3) -font $fnt12 -width 20 -vcmd {checkEntryText %P 127  %d %S ""} -validate key
    label $win.f.3.p -text " " -width 2
    scale $tddo_mCompl(3) -variable tddv_mCompl(3) -from 0 -to 100 -orien horizontal -length 164 -font $fnt10 -width 12 -showvalue 0 -command {setMileScaleValue 3}
    label $win.f.3.d -text [format " %3d%%" 0] -font $pbfnt12
    
    label $win.f.4.l -text "4: " -width 3 -font $bfnt12
    checkbutton $tddo_mStat(4) -variable tddv_mStat(4) -text " " -width 3
    entry $tddo_mTitel(4) -textvariable tddv_mTitel(4) -font $fnt12 -width 20 -vcmd {checkEntryText %P 127  %d %S ""} -validate key
    label $win.f.4.p -text " " -width 2
    scale $tddo_mCompl(4) -variable tddv_mCompl(4) -from 0 -to 100 -orien horizontal -length 164 -font $fnt10 -width 12 -showvalue 0 -command {setMileScaleValue 4}
    label $win.f.4.d -text [format " %3d%%" 0] -font $pbfnt12
    
    label $win.f.5.l -text "5: " -width 3 -font $bfnt12
    checkbutton $tddo_mStat(5) -variable tddv_mStat(5) -text " " -width 3
    entry $tddo_mTitel(5) -textvariable tddv_mTitel(5) -font $fnt12 -width 20 -vcmd {checkEntryText %P 127  %d %S ""} -validate key
    label $win.f.5.p -text " " -width 2
    scale $tddo_mCompl(5) -variable tddv_mCompl(5) -from 0 -to 100 -orien horizontal -length 164 -font $fnt10 -width 12 -showvalue 0 -command {setMileScaleValue 5}
    label $win.f.5.d -text [format " %3d%%" 0] -font $pbfnt12
    
    label $win.f.6.l -text "6: " -width 3 -font $bfnt12
    checkbutton $tddo_mStat(6) -variable tddv_mStat(6) -text " " -width 3
    entry $tddo_mTitel(6) -textvariable tddv_mTitel(6) -font $fnt12 -width 20 -vcmd {checkEntryText %P 127  %d %S ""} -validate key
    label $win.f.6.p -text " " -width 2
    scale $tddo_mCompl(6) -variable tddv_mCompl(6) -from 0 -to 100 -orien horizontal -length 164 -font $fnt10 -width 12 -showvalue 0 -command {setMileScaleValue 6}
    label $win.f.6.d -text [format " %3d%%" 0] -font $pbfnt12
    
    label $win.f.7.l -text "7: " -width 3 -font $bfnt12
    checkbutton $tddo_mStat(7) -variable tddv_mStat(7) -text " " -width 3
    entry $tddo_mTitel(7) -textvariable tddv_mTitel(7) -font $fnt12 -width 20 -vcmd {checkEntryText %P 127  %d %S ""} -validate key
    label $win.f.7.p -text " " -width 2
    scale $tddo_mCompl(7) -variable tddv_mCompl(7) -from 0 -to 100 -orien horizontal -length 164 -font $fnt10 -width 12 -showvalue 0 -command {setMileScaleValue 7}
    label $win.f.7.d -text [format " %3d%%" 0] -font $pbfnt12
    
    label $win.f.8.l -text "8: " -width 3 -font $bfnt12
    checkbutton $tddo_mStat(8) -variable tddv_mStat(8) -text " " -width 3
    entry $tddo_mTitel(8) -textvariable tddv_mTitel(8) -font $fnt12 -width 20 -vcmd {checkEntryText %P 127  %d %S ""} -validate key
    label $win.f.8.p -text " " -width 2
    scale $tddo_mCompl(8) -variable tddv_mCompl(8) -from 0 -to 100 -orien horizontal -length 164 -font $fnt10 -width 12 -showvalue 0 -command {setMileScaleValue 8}
    label $win.f.8.d -text [format " %3d%%" 0] -font $pbfnt12



    for {set i 1} {$i<=8} {incr i} { 
	pack $win.f.$i.l $win.f.$i.c $win.f.$i.t  $win.f.$i.p $win.f.$i.s $win.f.$i.d -side left
    }
}

proc setMileScaleValue { line  val} {
    global tddo_mScale pbfnt12 tddv_mCompl

    $tddo_mScale.$line.d configure -text [format " %3d%%" $tddv_mCompl($line)] -font $pbfnt12
}

#PROJECT-Dialog
proc newProj { } {
    clearCurrProj
    drawPED
}

proc clearCurrProj {  } {
    global tdpv_titel tdpv_descr tdpv_todos tdpv_stopD tdpv_stopM tdpv_stopY
    global tdpv_id tdpv_group tdpv_users tdpv_init username
    global tdd_projList today
    global tdpv_wperm 1

    set tdpv_id -1
    set tdpv_wperm 1
    set tdpv_titel "Neues Projekt"
    set datum [date2list $today]
    set tdpv_stopD  [lindex $datum 0]
    set tdpv_stopM  [lindex $datum 1]
    set tdpv_stopY  [lindex $datum 2]
    set tdpv_todos ""
    set tdpv_descr ""
    set tdpv_group "__allgemein"
    set tdpv_users ""
    set tdpv_init $username
}

proc setCurrProj { pid } {
    global tdpv_titel tdpv_descr tdpv_todos tdpv_stopD tdpv_stopM tdpv_stopY
    global tdpv_id tdpv_group tdpv_users tdpv_init
    global tdd_projList
    global tdpv_wperm

    set pok 0

#    foreach id [array names tdd_projList] {
    set proj $tdd_projList($pid)
#	if { [lindex $proj 0] == $pid } {
#	    set pok 1
#	    break
#	}
#    }
#    if {$pok == 1} {
    
    set tdpv_id $pid
    if { [lindex $proj 2] == "rw" || [lindex $proj 2] == "rwd" } {
	set tdpv_wperm 1
    } else {
	set tdpv_wperm 0
    }
    set tdpv_titel [lindex $proj 5]
    set datum [date2list [lindex $proj 7 ]]
    set tdpv_stopD  [lindex $datum 0]
    set tdpv_stopM  [lindex $datum 1]
    set tdpv_stopY  [lindex $datum 2]
    set tdpv_todos [lindex $proj 12]
    set tdpv_descr [lindex $proj 14]
    set tdpv_group [lindex $proj 15]
    set tdpv_users [lindex $proj 8]
    set tdpv_init  [lindex $proj 9]
#    }
}

proc drawPED { } {
    global tdpv_dring tdpv_dynam tdpv_titel tdpv_descr tdpv_todos today tdpo_todos tdpo_can
    global fnt bfnt fnt12 bfnt12 pfnt12 pfnt11 pfnt10
    global tdpo_descr dringlichStr
    global tdpo_group tdpv_group groupList tdpo_users tdpv_users
    global tdpv_stopD tdpv_stopM tdpv_stopY
    global tdpo_stopD tdpo_stopM tdpo_stopY tdpo_stopC
    global ped_ignoreMouse tdpo_titel tdpo_add tdpo_new
    global _projText _buttonText _allgText selDateCalIcon _dateOrder
    global windHeight
    global tdpo_buttonPressed 

    if { [winfo exists .ped] ==  1} { return}
    set ped_ignoreMouse 0
    
    set hOffset 0
    if { $windHeight <  820 } {
	set hOffset [ expr $windHeight -820 ]
	puts "$windHeight -> hOffset=$hOffset"
    }

#    puts $tdpv_group
    toplevel .ped
    busyCursor .ped
    wm title .ped "$_projText(projWmTitle) : $tdpv_titel"

    frame .ped.t -relief raised -bd 1
    frame .ped.b 
    pack .ped.t .ped.b -side top -fill x


    frame .ped.t.t 
    frame .ped.t.c
    pack .ped.t.t  .ped.t.c -side top -fill x

    frame .ped.t.t.l -relief ridge -bd 2
    frame .ped.t.t.r -relief ridge -bd 2
    frame .ped.t.c.l -relief flat  -bd 2
    frame .ped.t.c.r -relief flat  -bd 2
    pack .ped.t.t.l .ped.t.t.r -side left -padx 1
    pack .ped.t.c.l .ped.t.c.r -side left -padx 1

    frame .ped.t.t.l.0
    frame .ped.t.t.l.1
    frame .ped.t.t.l.2
    frame .ped.t.t.l.3
    pack  .ped.t.t.l.0 .ped.t.t.l.1 .ped.t.t.l.2 .ped.t.t.l.3 -side top -fill x -pady 2


    set tdpo_titel .ped.t.t.l.0.e
    label .ped.t.t.l.0.l -text $_projText(projTitel) -width 15 -font $bfnt12
    entry $tdpo_titel -textvariable tdpv_titel -width 70 -font $fnt12  -vcmd {checkEntryText %P 200  %d %S ""} -validate key
    pack .ped.t.t.l.0.l $tdpo_titel  -side left

    set tdpo_descr .ped.t.t.l.1.t
    label .ped.t.t.l.1.l -text $_projText(projDescr) -width 15 -font $bfnt12 -anchor nw
    tixScrolledText $tdpo_descr  -width 508 -height 85
    $tdpo_descr subwidget vsb configure -width 12
    $tdpo_descr subwidget hsb configure -width 12
    $tdpo_descr subwidget text configure -font $fnt12
    pack .ped.t.t.l.1.l $tdpo_descr -side left
    
    label .ped.t.t.l.2.l -text $_projText(projFinishDate) -width 15 -font $bfnt12
    set tdpo_stopD .ped.t.t.l.2.d
    set tdpo_stopM .ped.t.t.l.2.m
    set tdpo_stopY .ped.t.t.l.2.y
    set tdpo_stopC .ped.t.t.l.2.c
    set tdpo_group .ped.t.t.l.2.gd
    label .ped.t.t.l.2.s1 -text $_allgText(dateSep) -font $bfnt
    label .ped.t.t.l.2.s2 -text $_allgText(dateSep) -font $bfnt

    tixControl $tdpo_stopD  -min 0 -max 31 -integer 1 -options {  entry.width 2 } \
	-variable tdpv_stopD -selectmode immediate -autorepeat true
    tixControl $tdpo_stopM  -min 0 -max 12 -integer 1 -options {  entry.width 2  } \
	-variable tdpv_stopM -selectmode immediate -autorepeat true
    tixControl $tdpo_stopY -min 1900 -max 9999 -integer 1 -options {  entry.width 4  } \
	-variable tdpv_stopY -selectmode immediate -autorepeat true

    button $tdpo_stopC -image [image create pixmap -data $selDateCalIcon] -command {
	set x [ winfo rootx $tdpo_stopC]
	set y [expr  [ winfo rooty $tdpo_stopC] + [ winfo height $tdpo_stopC] ]
	set dlist [ displayYearCalAtPosition $tdpv_stopD $tdpv_stopM $tdpv_stopY $x $y .ped]
	set tdpv_stopD [lindex $dlist 0]
	set tdpv_stopM [lindex $dlist 1]
	set tdpv_stopY [lindex $dlist 2]
    }
    switch $_dateOrder {
	de { pack .ped.t.t.l.2.l $tdpo_stopD .ped.t.t.l.2.s1 $tdpo_stopM .ped.t.t.l.2.s2 \ 
	    tdpo_stopY $tdpo_stopC -side left }
	en -
	default { pack .ped.t.t.l.2.l $tdpo_stopM .ped.t.t.l.2.s1 $tdpo_stopD .ped.t.t.l.2.s2 \
		      $tdpo_stopY $tdpo_stopC -side left}
    }
    pack forget [ $tdpo_stopD subwidget incr]
    pack forget [ $tdpo_stopM subwidget incr]
    pack forget [ $tdpo_stopY subwidget incr]
    pack forget [ $tdpo_stopD subwidget decr]
    pack forget [ $tdpo_stopM subwidget decr]
    pack forget [ $tdpo_stopY subwidget decr]

    tixOptionMenu $tdpo_group -options {menubutton.width 20 label.width 10} -label $_allgText(Gruppe)
#    pack .ped.t.t.l.2.l  $tdpo_stopD $tdpo_stopM  $tdpo_stopY  -side left
    pack $tdpo_group -side right
    $tdpo_group add command __allgemein -label $_projText(todoModiPublic)
    foreach group $groupList {
	$tdpo_group add command $group -label $group
    }
    $tdpo_group add separator sep2
    $tdpo_group add command _privProj -label $_projText(projPrivate)
    $tdpo_group configure -variable tdpv_group



    set tdpo_can .ped.t.c.l.can 
    tixCObjView $tdpo_can -width 616 -height [expr 596 + $hOffset] 
    $tdpo_can subwidget vsb configure -width 12
    $tdpo_can subwidget hsb configure -width 12
    pack $tdpo_can
    $tdpo_can subwidget canvas configure -background grey95

    set tdpo_buttonPressed 0
    bind [$tdpo_can subwidget canvas] <Leave> {
	if {  [expr [mouseStatus]  & 256] == 256 } {   
	    set xk %x
	    set yk %y
	    if { $xk >0  && $xk < 616} {
		if { $yk <0} { 
		    pedScrollUp
		} else {
		    pedScrollDown
		}
	    }
	}
    }


    frame .ped.t.t.r.0
    frame .ped.t.t.r.1
    pack .ped.t.t.r.0 .ped.t.t.r.1 -side top -fill x -padx 1 -pady 1
    label .ped.t.t.r.0.l -text $_projText(projOperator)   -font $bfnt12
    pack .ped.t.t.r.0.l  -side left
    set tdpo_users  .ped.t.t.r.1.l
    tixScrolledListBox $tdpo_users -scrollbar auto -height 136 -width 336 -options {listbox.selectMode single}
    $tdpo_users subwidget vsb configure -width 12
    $tdpo_users subwidget hsb configure -width 12
    $tdpo_users subwidget listbox configure -font $pfnt12
    pack $tdpo_users 
    bind [$tdpo_users subwidget listbox] <ButtonPress> {changeProjPermDialog %y %b}


    frame .ped.t.c.r.0
    frame .ped.t.c.r.1
    frame .ped.t.c.r.2
    pack .ped.t.c.r.0 .ped.t.c.r.1  .ped.t.c.r.2 -side top -fill x -padx 1 -pady 1

    label .ped.t.c.r.0.l -text "$_projText(projTaskList): " -font $bfnt12
    pack .ped.t.c.r.0.l -side left
    set tdpo_todos .ped.t.c.r.1.l
    tixScrolledListBox $tdpo_todos -scrollbar auto -height [expr 548 + $hOffset]  -width 336 -options {listbox.selectMode single}
    $tdpo_todos subwidget vsb configure -width 12
    $tdpo_todos subwidget hsb configure -width 12
    $tdpo_todos subwidget listbox configure -font $pfnt12
    pack $tdpo_todos 

    set tdpo_add .ped.t.c.r.2.add
    set tdpo_new .ped.t.c.r.2.new
    button $tdpo_add -text "     <<<    " -command {addTODO2Proj} -width 20
    button $tdpo_new -text $_projText(projnewTask) -command newTODO -width 20
    pack $tdpo_add $tdpo_new -side left -fill x

    
    button .ped.b.abb -text " $_buttonText(Cancel) " -command {closeWin .ped}
    pack .ped.b.abb -side left
    button .ped.b.chg -text " $_buttonText(Modify) " -command {changeProj}
    pack .ped.b.chg -side right
    
    fillPED
    fillPEDusers

    drawPEDtodos
    setPerm4PED
    centerWin .ped 972 [expr 800 + $hOffset]
    update
    grab .ped
    bind .ped <Alt-q> {exitClient}
    stdCursor .ped


#    puts [format "ped: %s" [wm geometry .ped]]
}

proc pedScrollUp { } {
    global tdpo_can tdpo_buttonPressed
    set can [$tdpo_can subwidget canvas]
    if {  [expr [mouseStatus]  & 256] == 256 } {   
	set pos0 [lindex [$tdpo_can subwidget vsb get] 0 ] 
	set pos1 [lindex [$tdpo_can subwidget vsb get] 1 ]
	set len [expr $pos1 - $pos0 ]

	set pos0 [expr $pos0 - 0.125]
	if { $pos0 < 0.0 } {  set pos0 0.0 }
	set pos1 [expr $pos0 + $len]
	$tdpo_can subwidget vsb  set $pos0 $pos1
	set cmd "[$tdpo_can subwidget vsb cget -command] moveto $pos0"
	eval $cmd
	if { $pos0 > 0.0 } {
	    after 500 pedScrollUp
	}
	update
    }
}
proc pedScrollDown { } {
    global tdpo_can tdpo_buttonPressed
    set can [$tdpo_can subwidget canvas]
    if {  [expr [mouseStatus]  & 256] == 256 } {   
	set pos0 [lindex [$tdpo_can subwidget vsb get] 0 ] 
	set pos1 [lindex [$tdpo_can subwidget vsb get] 1 ]
	set len [expr $pos1 - $pos0 ]

	set pos1 [expr $pos1 + 0.125]
	if { $pos1 > 1.0 } {  set pos1 1.0 }
	set pos0 [expr $pos1 - $len]
	$tdpo_can subwidget vsb  set $pos0 $pos1
	set cmd "[$tdpo_can subwidget vsb cget -command] moveto $pos0"
	eval $cmd

	if { $pos1 < 1.0 } {
	    after 500 pedScrollDown
	}
	update
    }
}


proc setPerm4PED { } {
    global ped_ignoreMouse 
    global tdpo_titel tdpo_descr tdpo_group  tdpo_add tdpo_new
    global tdpo_stopD tdpo_stopM tdpo_stopY
    global tdpo_users 
    global tdpv_wperm

    if { $tdpv_wperm == 0 } {
	set widgets "$tdpo_titel $tdpo_group $tdpo_add $tdpo_new $tdpo_stopD $tdpo_stopM $tdpo_stopY"
	
	foreach widget $widgets {
	    $widget configure -state disabled
	}
	$tdpo_descr subwidget text configure -state disabled
	$tdpo_users configure -state disabled
	set ped_ignoreMouse 1
	$tdpo_group  subwidget menubutton configure -disabledforeground grey25
	$tdpo_group  subwidget label      configure -foreground grey25
    }

}

proc refillPED { } {
    global  tdpo_todos
    $tdpo_todos subwidget listbox delete 0 end
    fillPED
    refillPEDusers
}
proc fillPED { } {
    global tdd_todoList tdpo_todos

    foreach tid [array names tdd_todoList] {
	set todo $tdd_todoList($tid)
	if { [lindex $todo 0 ] >0 } {
#	    $tdpo_todos subwidget listbox insert end [format "%5d: %-40s" [lindex $todo 0 ] "1234567890123456789012345678901234567890"] 
	    $tdpo_todos subwidget listbox insert end [format "%5d: %-40s" [lindex $todo 0 ] [strTrunc [lindex $todo 3 ] 40 ] ]
	}
    }
}
proc refillPEDusers { } {
    global  tdpo_users
    $tdpo_users subwidget listbox delete 0 end
    fillPEDusers
}

proc fillPEDusers {} {
    global  tdpo_users tdpv_users
    foreach usr $tdpv_users {
	$tdpo_users subwidget listbox insert end [format "%-40s  %2s" [lindex $usr 0] [lindex $usr 1]]
    }
}

proc changeProjPermDialog { y b  } {
    global tdpv_users currUser currSel currDperm currWperm cppo_del tdpv_init
    global _projText _buttonText

    if { $b ==3 } {
	if { [winfo exists .cpp ] == 1 } { return }
	#FIXME (vielw User)
	set yk [expr $y]
	set currSel [expr int(floor($yk/15))]
	set user [lindex $tdpv_users $currSel]
	set currUser [lindex $user 0]
	set currPerm [lindex $user 1]
	if { $currPerm == "rw" || $currPerm == "rwd" } { set currWperm 1} else { set currWperm 0}
	if {  $currPerm == "rwd" } { set currDperm 1} else { set currDperm 0}

	toplevel .cpp
	wm title .cpp $_projText(projChgPermWmTitle)
	frame .cpp.e -relief raised -bd 1
	frame .cpp.b 
	pack .cpp.e .cpp.b -side top -fill x

	frame .cpp.e.0
	frame .cpp.e.1
	frame .cpp.e.2
	pack .cpp.e.0 .cpp.e.1 .cpp.e.2 -side top -fill x -padx 4 -pady 3
	
	label .cpp.e.0.l -text "$_projText(projPermText1) $currUser $_projText(projPermText2):"
	checkbutton .cpp.e.1.c -text $_projText(projWritePerm)  -variable currWperm -command toggleDelProj
	set cppo_del .cpp.e.2.c
	label  .cpp.e.2.l -text "  "
	checkbutton $cppo_del -text $_projText(projDeletePerm) -variable currDperm
	pack .cpp.e.0.l .cpp.e.1.c $cppo_del .cpp.e.2.l -side left -fill x

	if { $currUser == $tdpv_init } {
	    set currWperm 1
	    set currDperm 1
	    .cpp.e.1.c configure -state disabled
	    $cppo_del configure -state disabled
	} else {
	    toggleDelProj
	}

	button .cpp.b.abb -text $_buttonText(Cancel) -command {destroy .cpp}
	pack .cpp.b.abb -side left
	button .cpp.b.chg -text $_buttonText(Modify) -command {changeProjPerm}
	pack .cpp.b.chg -side right
	centerWin .cpp 288 116
	update
#	puts [wm geometry .cpp]
	grab .cpp
    }
}
proc  toggleDelProj { } {
    global currWperm cppo_del  currDperm
    if { $currWperm == 1 } {
	$cppo_del configure -state normal
    } else {
	$cppo_del configure -state disabled
	set currDperm 0
    }
}
proc changeProjPerm { } {
    global currSel currUser currWperm currDperm  tdpv_users
 
    set perm "r"
    if { $currWperm == 1} {
	if {$currDperm == 1} {
	    set perm "rwd"
	} else {
	    set perm "rw"
	}
    }
    set user "$currUser $perm"
    set tdpv_users [lreplace $tdpv_users $currSel $currSel $user]
    destroy .cpp
    refillPEDusers
}

proc addTODO2Proj { } {
    global tdpo_todos tdd_todoList tdpo_can tdpv_todos tdpv_users
    
    set sel  [lindex [$tdpo_todos subwidget listbox curselection] 0]

    set tid [string trimright [lindex [$tdpo_todos subwidget listbox get $sel] 0] :]
    foreach ent $tdpv_todos {
	if { [lindex $ent 0] == $tid } { return} 
    }

    set ent "$tid {} 5"
    lappend tdpv_todos $ent

    set changed 0
    foreach usr [lindex $tdd_todoList($tid) 7] {
	set flag 0
	foreach usr2 $tdpv_users {
#	    puts [format "%s =%s ?" [lindex $usr 0]  [lindex $usr2 0] ]
	    if { [lindex $usr 0] == [lindex $usr2 0] } {
		set flag 1
		break
	    }
	}
	if { $flag == 0} {
	    set ent [format "%s r" [lindex $usr 0] ]
	    lappend tdpv_users $ent
	    set changed 1
	}
    }
    if { $changed == 1} { refillPEDusers }

    $tdpo_can subwidget canvas delete all
    drawPEDtodos
}
proc updatePEDusers { } {
    global tdpv_users tdpv_todos tdd_todoList
    

#    puts "updating userList"
    set newList ""
    foreach td $tdpv_todos {
	set tid [lindex $td 0]

	foreach usr [lindex $tdd_todoList($tid) 7] {
	    set flag 0

#	    puts "checking $usr from $tid"

	    #Suche den user aus dem TODO in der alten Userliste des Projectes,
	    # um seinen Eintrag zu bernehmen
	    foreach usr2 $tdpv_users {
		if { [lindex $usr 0] == [lindex $usr2 0] } {
		    set ent $usr2
		    set flag 1
		    break
		}
	    }
	    
#	    puts " -> $flag $ent"
	    # Wenn der Eintrag gefudnen wurde, such, ob der User schon in der neuen List ist
	    if { $flag == 1} {
		foreach usr2 $newList {
		    if { [lindex $usr 0] == [lindex $usr2 0] } {
			set flag 2
			break
		    }
		}
		#Wenn der User noch nicht in der neuen List ist, bernehme in dorthin
		if { $flag == 1 } {
		    lappend newList $ent
		}
#		puts " ---> $flag $newList"
	    }
	}
    }
    set tdpv_users $newList
    refillPEDusers
}

proc drawPEDtodos { } {
    global tdpv_todos tdpo_can tdd_todoList dringlichColor2
    global fnt12 pfnt12 pfnt10 pfnt11 bfnt fnt fnt10 fnt12 fnt8
    global todoStatIcon mileStoneIcon
    global tdpo_buttonPressed 


    set colorRing "blue2 green3 red1 DarkOrange2 DeepPink peru purple2 cyan2 magenta2 yellow2 black gold3 SteelBlue NavyBlue ForestGreen goldenrod3"


    set can [$tdpo_can subwidget canvas]
    for {set i 0} { $i <8  } {incr i} { 
	set lvlx($i) 48
	set lvlOff($i) [expr -36 + 4*$i]
	set lvlYoff($i) 3
	set yk0 [expr $i*72+1]
	set yk1 [expr $i*72+71]
	$can create rectangle 3 $yk0  597 $yk1 -fill grey95 -outline grey75 -tag level$i

    }

    set tlist ""
    foreach ent $tdpv_todos {
	set tid [lindex $ent 0]
	set dcount($tid) 0
    }
	
    
    set cid 0
    foreach ent $tdpv_todos {
#	puts ">>$cid: $ent"
	set tid [lindex $ent 0]
	set lvl [lindex $ent 2]
	set todo $tdd_todoList($tid)
	set dring [lindex $todo 9]
	
	set yk0 [expr $lvl*72+28]
	set yk1 [expr $yk0+24]
	set yk2 [expr $yk0+38]
	set yk3 [expr $yk0+39]
	set xk0 [expr $lvlx($lvl)]
	set xk1 [expr $xk0+3  ]
	set xk2 [expr $xk0+148]

	set col [lindex $colorRing $cid]
	$can create rectangle $xk0 $yk0 $xk2 $yk3 -fill [lindex $dringlichColor2 $dring] -outline $col -width 3 -tag todo$tid
	$can create rectangle $xk0 $yk0 $xk2 $yk1  -fill $col -width 3 -outline $col -tag todo$tid
	$can create text $xk1 $yk2 -anchor sw -text [strTrunc [lindex $todo 3] 24] -font $pfnt10 -tag todo$tid

	set todoXk($tid) $xk0
	set todoYk($tid) $yk0
	set todoCol($tid) $col
	
	incr lvlx($lvl) 196
	incr cid
	while {$cid> 15} { incr cid -16}
    }

    foreach ent $tdpv_todos {
	set tid [lindex $ent 0]
	set tlvl [lindex $ent 2]
#	puts "$ent"
	foreach  dep [lindex $ent 1] {
	    set id [lindex $dep 0]
	    set typ [lindex $dep 1]
	    set val [lindex $dep 2]

#	    puts "dep: $dep"

	    foreach ent2 $tdpv_todos {
		if { [lindex $ent2 0] == $id} { set lvl [lindex $ent2 2] }
	    }
	    
	    set xd [expr $todoXk($tid) -1]
	    set xt [expr $xd +$lvlOff($tlvl)]
	    set xs [expr $todoXk($id) + $dcount($id)*24+12]

	    set yd [ expr $todoYk($tid)+17]
	    set ys [ expr $todoYk($id)-1]
	    set yt [ expr $ys - $lvlYoff($lvl) ]

#	    puts "$xs $xt $xd $ys $yt $yd"

	    $can create line  $xs $ys $xs $yt -fill $todoCol($tid) -width 2
	    $can create line $xs $yt $xt $yt -fill $todoCol($tid) -width 2
	    $can create line $xt $yt $xt $yd -fill $todoCol($tid) -width 2
	    $can create line  $xt $yd $xd $yd -arrow last -arrowshape {  8 8 3} -fill $todoCol($tid) -width 2

	    set x0 [expr $todoXk($id) + $dcount($id)*24 +0]
	    set x1 [expr $todoXk($id) + $dcount($id)*24 +23]
	    set y0 [ expr $todoYk($id)+0]
	    set y1 [ expr $todoYk($id)+23]
	    set tag dep$id-$tid
#	    puts $tag
	    switch $typ {
		ONCOMPL { 
		    $can create rectangle $x0 $y0 $x1 $y1 -fill white -outline black -tag $tag
		    set y0 [ expr $todoYk($id)+15]
		    set y1 [ expr $todoYk($id)+23]
		    $can create rectangle $x0 $y0 $x1 $y1 -fill grey35 -outline black -tag $tag
		    set x0 [expr $todoXk($id) + $dcount($id)*24 +2]
		    set x1 [expr $todoXk($id) + $dcount($id)*24 +2 +int(floor(20. *double($val) /100.))]
		    set y0 [ expr $todoYk($id)+16]
		    set y1 [ expr $todoYk($id)+22]
		    $can create rectangle $x0 $y0 $x1 $y1 -fill "#FFAE1A" -outline "#FFAE1A" -tag $tag
		    set y0 [ expr $todoYk($id)+13]
		    set xt [expr $todoXk($id) + $dcount($id)*24 +22]
		    $can create text $xt $y0 -anchor se -text [format "%3d%%" $val] -font $fnt8
		}
		ONDONE {
		    $can create rectangle $x0 $y0 $x1 $y1 -fill white -outline black -tag $tag
		    $can create image [expr $x0+1] $y0 -image [image create pixmap -data $todoStatIcon(DONE)] -anchor nw  -tag $tag
		}
		ONDELAY {
		    $can create rectangle $x0 $y0 $x1 $y1 -fill white -outline black -tag $tag
		    $can create image [expr $x0+1] $y0 -image [image create pixmap -data $todoStatIcon(DELAY)] -anchor nw  -tag $tag
		}
		ONWIP {
		    $can create rectangle $x0 $y0 $x1 $y1 -fill white -outline black -tag $tag
		    $can create image [expr $x0+1] $y0 -image [image create pixmap -data $todoStatIcon(WIP)] -anchor nw  -tag $tag
		}
		ONKILL {
		    $can create rectangle $x0 $y0 $x1 $y1 -fill white -outline black -tag $tag
		    $can create image [expr $x0+1] $y0 -image [image create pixmap -data $todoStatIcon(KILL)] -anchor nw  -tag $tag
		}
		ONHOLD {
		    $can create rectangle $x0 $y0 $x1 $y1 -fill white -outline black -tag $tag
		    $can create image [expr $x0+1] $y0 -image [image create pixmap -data $todoStatIcon(HOLD)] -anchor nw  -tag $tag
		}
		ONMILES {
		    $can create rectangle $x0 $y0 $x1 $y1 -fill white -outline black -tag $tag
		    $can create image [expr $x0+1] $y0 -image [image create pixmap -data $mileStoneIcon] -anchor nw  -tag $tag
		    set x0 [expr $todoXk($id) + $dcount($id)*24 +12]
		    set y1 [ expr $todoYk($id)+ 22]
		    $can create text $x0 $y1 -text $val -font $bfnt -anchor s -justify center
		}
	    }

	    incr dcount($id)
	    set lvlYoff($lvl) [expr  $lvlYoff($lvl)+ 3]
	}
    }


    $can create rectangle 560 540 592 572 -fill grey40 -outline grey40 -tag waste
    $can create polygon   564 544 568 568 584 568 588 544 564 544 -fill MediumVioletRed -outline black -tag waste

    bind $can <ButtonPress> {
	setPEDSource %x %y %b
	set tdpo_buttonPressed 1
    }
    bind $can <ButtonRelease> {
	setPEDDest %x %y %b
	set tdpo_buttonPressed 0
    }
}

proc setPEDSource { x y b } {
    global tdpo_can tpdc_source  tpdc_source2 tpdc_sourceTyp
    global ped_ignoreMouse

    if { $ped_ignoreMouse == 1 } {return }

    set list [$tdpo_can subwidget canvas bbox all]
    set w [lindex $list 2]
    set h [lindex $list 3]
    set yoff [ expr int(floor([lindex [$tdpo_can subwidget vsb get] 0] * $h)) ]
    set xoff [ expr int(floor([lindex [$tdpo_can subwidget hsb get] 0] * $w)) ]
    puts "offset $xoff,$yoff on $x,$y"
    incr x $xoff
    incr y $yoff
    puts "                                 ->  $x,$y"
    set tpdc_source -1
    if {$b == 1} {
	set idxs [ $tdpo_can subwidget canvas find overlapping  [expr $x -2] [expr $y-2] [expr $x +2] [expr $y+2 ]]
	puts "SOURCE $idxs"
	set tags ""
	foreach idx $idxs {
	    lappend tags [lindex [ $tdpo_can subwidget canvas gettags $idx ] 0]
	}
	puts "     -> $tags"
	set i [ lsearch -glob $tags dep* ]
	if {$i>-1 } {
	    set tag [lindex $tags $i]
	    set list [split [string  range $tag 3 end ] -]
	    set tpdc_source  [lindex $list 0]
	    set tpdc_source2 [lindex $list 1]
	    set tpdc_sourceTyp DEP
#0	    puts "                                -> $tag"
	    return
	}
	set i [ lsearch -glob $tags todo* ]
	if {$i>-1 } {
	    set tag [lindex $tags $i]
	    set tpdc_source [string  range $tag 4 end ]
	    set tpdc_source2 ""
	    set tpdc_sourceTyp TODO
#	    puts "                                -> $tag"
	    return
	}
   }
    
}
proc setPEDDest { x y b } {
    global tdpo_can tpdc_source tdpv_todos tpdc_dest tpdc_source2 tpdc_sourceTyp
    global ped_ignoreMouse


    if { $ped_ignoreMouse == 1 } {return }

    set list [$tdpo_can subwidget canvas bbox all]
    set w [lindex $list 2]
    set h [lindex $list 3]
    set yoff [ expr int(floor([lindex [$tdpo_can subwidget vsb get] 0] * $h)) ]
    set xoff [ expr int(floor([lindex [$tdpo_can subwidget hsb get] 0] * $w)) ]
    incr x $xoff
    incr y $yoff
    if {$b == 1} {
	if { $tpdc_source>=0} {
	    set idxs [ $tdpo_can subwidget canvas find overlapping  [expr $x -2] [expr $y-2] [expr $x +2] [expr $y+2 ]]
#	    puts "DEST $idxs "
	    set tags ""
	    foreach idx $idxs {
		lappend tags [lindex [ $tdpo_can subwidget canvas gettags $idx ] 0]
	    }
#	    puts "          -> $tags"
	    set i [ lsearch -glob $tags todo* ]
	    if { $i >-1 } {
		set tag [lindex $tags $i]
		if { [string range $tag 0 3] == "todo" } {
		    set tpdc_dest [ string  range $tag 4 end ]
		    if {$tpdc_source != $tpdc_dest } { 
			dependDialog
		    } else  {
			setCurrentTODO $tpdc_dest
			drawChangeTODO
		    }
		    return
		}
	    }
	    if { [ lsearch  $tags waste ] >-1 } {
		if { $tpdc_sourceTyp == "TODO" } {
		    set anz [llength $tdpv_todos]
		    for { set i 0} {$i < $anz} {incr i} {
			if { [lindex [lindex $tdpv_todos $i] 0] == $tpdc_source} {
			    set tdpv_todos [lreplace $tdpv_todos $i $i]
			    updatePEDusers
			    $tdpo_can subwidget canvas delete all
			    drawPEDtodos
			    set tpdc_sourceTyp ""
			    return
			}
		    }
		} elseif { $tpdc_sourceTyp == "DEP" } {
		    set anz [llength $tdpv_todos]
		    for { set i 0} {$i < $anz} {incr i} {
			if { [lindex [lindex $tdpv_todos $i] 0] == $tpdc_source2} {
			    set todo  [lindex $tdpv_todos $i]
			    set dList [lindex $todo 1]
			    set anz2  [llength $dList]
			    for { set j 0} {$j < $anz2 } {incr j} {
				set dep [lindex $dList $j]
				if { [lindex $dep 0] == $tpdc_source } {
				    set dList [ lreplace $dList $j $j ]
				    break
				}
			    }
			    set todo [format "%d {%s} %d" [lindex $todo 0] $dList [lindex $todo 2]]
			    set tdpv_todos [lreplace $tdpv_todos $i $i $todo]
			    set tpdc_sourceTyp ""
			    $tdpo_can subwidget canvas delete all
			    drawPEDtodos
			    return
			}
		    }

		}

	    }
	    set i [ lsearch -glob $tags level* ]
	    if { $i >-1 } {
		set tag [lindex $tags $i]
		if { [string range $tag 0 4] == "level" } {
		    set lvl [ string  range $tag 5 end ]
		    for { set i 0} {$i < [llength $tdpv_todos]} { incr i} {
			if { [lindex [lindex $tdpv_todos $i] 0] == $tpdc_source} {
			    set ent [format "%s {%s} %d" [lindex [lindex $tdpv_todos $i] 0] [lindex [lindex $tdpv_todos $i] 1] $lvl ]
			    set tdpv_todos [lreplace $tdpv_todos $i $i $ent]
			    $tdpo_can subwidget canvas delete all
			    drawPEDtodos
			    return
			}
		    }
		}
	    }
	}
    }
}

proc dependDialog { } {
    global tdpo_can tpdc_source tdpv_todos tpdc_dest tdd_todoList
    global depStr depType
    global tdpDepType  tdpDepVal
    global fnt bfnt12 pfnt bfnt
    global _projText _buttonText

    if { [winfo exists .pdd ] == 1 } { return }
    toplevel .pdd
    wm title .pdd  $_projText(projDependWmTitle)

    set tdpDepType ONDONE
    set tdpDepVal 0
    
    frame .pdd.f -relief raised -bd 1 
    frame .pdd.b 
    pack .pdd.f .pdd.b -side top -fill x -ipadx 3 -ipady 3

    frame .pdd.f.0
    frame .pdd.f.1
    frame .pdd.f.2
    frame .pdd.f.3
    frame .pdd.f.4
    pack .pdd.f.0 .pdd.f.1 .pdd.f.2 .pdd.f.3 .pdd.f.4  -side top -fill x

    label .pdd.f.0.l -text $_projText(projDependText1) -font $bfnt
    label .pdd.f.1.l -text "  [strTrunc [lindex $tdd_todoList($tpdc_dest) 3] 40 ]" -font $bfnt
    label .pdd.f.2.l -text $_projText(projDependText2) -font $bfnt
    label .pdd.f.3.l -text "  [strTrunc [lindex $tdd_todoList($tpdc_source) 3] 40 ]" -font $bfnt
    

    pack .pdd.f.0.l  .pdd.f.1.l .pdd.f.2.l .pdd.f.3.l -side left

    label .pdd.f.4.l1 -text $_projText(projDependText3) -font $bfnt
    tixOptionMenu .pdd.f.4.o  -options {menubutton.width 20}
    .pdd.f.4.o subwidget label configure -font $bfnt12
    for {set i 0} {$i<[llength  $depType ]} {incr i } {
	.pdd.f.4.o add command [lindex $depType $i] -label [lindex $depStr $i]
    }
    label .pdd.f.4.l2 -text  $_projText(projDependText4)
    tixControl .pdd.f.4.v  -label "" -min 0 -max 100 -integer 1 -options {  entry.width 3 } -variable tdpDepVal -selectmode immediate -autorepeat true
    pack .pdd.f.4.l1 .pdd.f.4.o .pdd.f.4.l2  .pdd.f.4.v -side left
    .pdd.f.4.o configure -variable tdpDepType
    .pdd.f.4.o configure -command setPEDDepValState
    setPEDDepValState $tdpDepType
    button .pdd.b.abb -text $_buttonText(Cancel) -command {closeWin .pdd}
    button .pdd.b.add -text " $_buttonText(Accept) " -command {addDep}
    pack  .pdd.b.abb -side left
    pack  .pdd.b.add -side right

    centerWin  .pdd 320  150
    update
#    puts [wm geometry .pdd]
    grab .pdd
}

proc setPEDDepValState {val } {
    global tdpDepType tdpDepVal 
    
    switch $tdpDepType {
	ONWIP { .pdd.f.4.v configure -state disabled } 
	ONDELAY { .pdd.f.4.v configure -state disabled } 
	ONDONE { .pdd.f.4.v configure -state disabled } 
	ONKILL { .pdd.f.4.v configure -state disabled } 
	ONHOLD { .pdd.f.4.v configure -state disabled } 
	
	ONCOMPL {
	    .pdd.f.4.v configure -state normal
	    .pdd.f.4.v configure -min 0
	    .pdd.f.4.v configure -max 100
	    
	}
	ONMILES {
	    .pdd.f.4.v configure -state normal
	    .pdd.f.4.v configure -min 1
	    .pdd.f.4.v configure -max 7
	    if {$tdpDepVal <1 } { set tdpDepVal 1}
	    if {$tdpDepVal >7 } { set tdpDepVal 7}
	}

    }
}

proc addDep { } {
    global tdpDepType  tdpDepVal tpdc_source tdpv_todos tpdc_dest tdpo_can


    for { set i 0} {$i < [llength $tdpv_todos]} { incr i} {
	if { [lindex [lindex $tdpv_todos $i] 0] == $tpdc_dest} {
	    set ent [lindex $tdpv_todos $i]
	    set dep [lindex $ent 1]
	    set newDep [format "%d %s %d" $tpdc_source $tdpDepType  $tdpDepVal ]
	    if { $dep == "" } {
		set dep "{$newDep}"
	    }	else {
		lappend dep $newDep
	    }
	    set ent [format "%s {%s} %d" [lindex $ent 0] $dep [lindex $ent 2] ]
	    set tdpv_todos [lreplace $tdpv_todos $i $i $ent]
	}
    }
    closeWin .pdd
    $tdpo_can subwidget canvas delete all
    drawPEDtodos
}

proc changeProj { } {
    global tdpv_group tdpv_titel tdpv_stop tdpv_init tdpv_descr tdpv_reminder tdpv_users
    global tdpv_stopY tdpv_stopM tdpv_stopD 
    global tdpv_todos tdpv_id username tdd_projList 
    global tdpo_descr  depTypeVal

    if { $tdpv_id<0} {
	set oc "OPEN"
    } else {
	set oc [lindex $tdd_projList($tdpv_id) 3]
    }
    set stop [ format "%4d%02d%02d" $tdpv_stopY $tdpv_stopM $tdpv_stopD ]
    set tdpv_reminder ""

    set tdpv_descr ""
#     set list [ $tdpo_descr subwidget text dump -text 0.0 end]
#     set l [llength $list]
#     for { set i 1} {$i < $l } {incr i 3 } {
# 	set tdpv_descr [format "%s%s" $tdpv_descr [ lindex $list $i] ]
#     }
    set tdpv_descr [braces2parenthesis [ $tdpo_descr subwidget text get  0.0 end] ]
    set tdpv_descr [string trim $tdpv_descr ]

    set tlist ""
    foreach ent $tdpv_todos { 
	set depList [lindex $ent 1]
	set dlist ""
	foreach dep $depList {
	    set typ [lindex $dep 1 ]
	    set dep [lreplace $dep 1 1 $depTypeVal($typ)]
	    lappend dlist $dep
	}
	set ent [lreplace $ent 1 1 $dlist]
	lappend tlist $ent
    }


    set pid [ request changeProject $tdpv_id $username $oc $tdpv_titel 0 $stop $tdpv_users $tdpv_init \
		  $tlist $tdpv_reminder  $tdpv_descr $tdpv_group]
    if { $pid == "Error" } { 
	closeWin .ped
	return 
    }

#    puts " -> $pid"


    
    set proj [request getProject $username $pid]
    if { $proj == "Error" } { 
	closeWin .ped
	return 
    }

    extractProjArray $proj
    refillTODO


    closeWin .ped
}

#Utis
proc initTODO { } { 
    global dringlichStr TODOstatStr TODOstati dringlichColor dringlichColor2  depType depTypeVal
    global projSortMode projSortMode2 projSortMode3 projSortDirection TODOstatVal

    global tdd_todoList tdd_projList nextDummyId prvTodo

    set nextDummyId -1
    set projSortMode "id"
    set projSortMode2 "id"
    set projSortMode3 "id"
    set projSortDirection "-decreasing"
    set prvTodo ""

#    set dringlichStr "{sehr niedrig} niedrig verringert normal erhht hoch {sehr hoch} {am hchsten}"
    set dringlichColor "grey50 grey40 grey25 black green4 blue2 DarkOrange2 red"
    set dringlichColor2 "grey60 grey75 grey90 white #90FF90 #B0B0FF #FFD080 #FFA0A0"


    # Mit defines in server/todo.h syncron halten
    set TODOstati "DONE NEW OPEN KILL WAIT  HOLD WIP DELAY"
#    set TODOstatStr "erledigt neu offen abgesagt wartend angehalten {in Arbeit} berzogen"
    for {set i 0} {$i < [llength $TODOstati]} {incr i} {
	set stat [lindex $TODOstati $i]
	set TODOstatVal($stat) $i
    }
#    puts [format "STAT-Vals: %s" [array names TODOstatVal]]

    # Mit defines in server/todo.h syncron halten
    set depType "ONWIP ONDELAY ONDONE ONKILL ONHOLD ONCOMPL ONMILES"
    for {set i 0} {$i < [llength $depType]} {incr i} {
	set typ [lindex $depType $i]
	set depTypeVal($typ) $i
    }
    initProjImages
#    initDummyLists
}
proc initDummyLists { } {

    #TODO-Item%
    # ID perm status Titel start stop completion {{users aufwand perm} ... }  init dringlichkeit -dynamisch Beschr 
    # 0     1     2   3     4         5       6                     7     8              9         10     11
    #
    # {Milestone-list}  {reminder-list} group ... [ dummy-ID]
    #     12                 13           14         end
    #
    # Milestoine-Item: Status  Titel  compl
    #                    0       1       2      
    #
    # beim sendTODO ist perm durch username ersetzt
    # 
    # dummy ID wird bei Project-freien TODOs als backreferenz auf das Dummyproject gesetzt
    #Project-Item
    # ID type perm open/close status Titel start stop {users ... } init dringl. complete {todo-List} 
    # 0   1     2        3       4     5     6     7       8         9     10         11         12
    # 
    # {reminder-list} Beschr group 
    #     13           14     15
    # type = TODO -> einfahces TODO
    # type = PROJ -> project
    #
    # dringlich, status und complete werden aus den untergeordeneten Projecten abgeleitet
    # TODO-List: pro TODO : {TODO-ID  {depend-List} lvl}
    # Depend-List: jedes Depend: {tid type val}
}

proc organiseTODOlist { } { 
    global tdd_todoList

}

proc val2DateStr { day mon year} {
    
}


##### nach images.tcl

proc initProjImages { } {
    global objOpenIcon objOpenMini
    global objCloseIcon objCloseMini
    global todoStatIcon mileStoneIcon

set objOpenIcon { 
/* XPM */
static char * objOpen_xpm[] = {
"24 24 3 1",
" 	c none",
".	c #000000000000",
"X	c #FFFFAEAE1A1A",
"                        ",
"                        ",
"                        ",
"                        ",
"                        ",
"                        ",
" .......................",
"  .XXXXXXXXXXXXXXXXXXX. ",
"   .XXXXXXXXXXXXXXXXX.  ",
"    .XXXXXXXXXXXXXXX.   ",
"     .XXXXXXXXXXXXX.    ",
"      .XXXXXXXXXXX.     ",
"       .XXXXXXXXX.      ",
"        .XXXXXXX.       ",
"         .XXXXX.        ",
"          .XXX.         ",
"           .X.          ",
"            .           ",
"                        ",
"                        ",
"                        ",
"                        ",
"                        ",
"                        "};
}
set objCloseIcon { 
/* XPM */
static char * objOpen_xpm[] = {
"24 24 3 1",
" 	c none",
".	c #000000000000",
"X	c #FFFFAEAE1A1A",
"    .                   ",
"    ..                  ",
"    .X.                 ",
"    .XX.                ",
"    .XXX.               ",
"    .XXXX.              ",
"    .XXXXX.             ",
"    .XXXXXX.            ",
"    .XXXXXXX.           ",
"    .XXXXXXXX.          ",
"    .XXXXXXXXX.         ",
"    .XXXXXXXXXX.        ",
"    .XXXXXXXXX.         ",
"    .XXXXXXXX.          ",
"    .XXXXXXX.           ",
"    .XXXXXX.            ",
"    .XXXXX.             ",
"    .XXXX.              ",
"    .XXX.               ",
"    .XX.                ",
"    .X.                 ",
"    ..                  ",
"    .                   ",
"                        "};
}


set objOpenMini {
/* XPM */
static char * objOpenMini_xpm[] = {
"16 16 3 1",
" 	c none",
".	c #000000000000",
"X	c #FFFFAEAE1A1A",
"                ",
"                ",
"                ",
"                ",
"                ",
" ...............",
"  .XXXXXXXXXXX. ",
"   .XXXXXXXXX.  ",
"    .XXXXXXX.   ",
"     .XXXXX.    ",
"      .XXX.     ",
"       .X.      ",
"        .       ",
"                ",
"                ",
"                "};
}
set objCloseMini {
/* XPM */
static char * objCloseMini_xpm[] = {
"16 16 3 1",
" 	c none",
".	c #000000000000",
"X	c #FFFFAEAE1A1A",
"                ",
"     .          ",
"     ..         ",
"     .X.        ",
"     .XX.       ",
"     .XXX.      ",
"     .XXXX.     ",
"     .XXXXX.    ",
"     .XXXXXX.   ",
"     .XXXXX.    ",
"     .XXXX.     ",
"     .XXX.      ",
"     .XX.       ",
"     .X.        ",
"     ..         ",
"     .          "};
}



set todoStatIcon(DONE) {
/* XPM */
static char * todoDone_xpm[] = {
"24 24 2 1",
" 	c none",
"* 	c #3B3BD7D70000",
"                        ",
"                        ",
"                      * ",
"                    *** ",
"                   ***  ",
"                 *****  ",
"                *****   ",
"               *****    ",
"              *****     ",
" ***         *****      ",
" ****       *****       ",
" ******    *****        ",
"  ******   ****         ",
"   *****  ****          ",
"     **** ***           ",
"      *******           ",
"      ******            ",
"       *****            ",
"       *****            ",
"        ***             ",
"        ***             ",
"        ***             ",
"                        ",
"                        "};
}
set todoStatIcon(NEW) {
/* XPM */
static char * todoNew_xpm[] = {
"24 24 3 1",
" 	c none",
"*	c #000000000000",
"X	c #00000000CCCC",
"                        ",
"                        ",
"             *          ",
"             **         ",
"             *X*        ",
"             *XX*       ",
"             *XXX*      ",
"             *XXXX*     ",
"  ************XXXXX*    ",
"  *XXXXXXXXXXXXXXXXX*   ",
"  *XXXXXXXXXXXXXXXXXX*  ",
"  *XXXXXXXXXXXXXXXXXXX* ",
"  *XXXXXXXXXXXXXXXXXXX* ",
"  *XXXXXXXXXXXXXXXXXX*  ",
"  *XXXXXXXXXXXXXXXXX*   ",
"  ************XXXXX*    ",
"             *XXXX*     ",
"             *XXX*      ",
"             *XX*       ",
"             *X*        ",
"             **         ",
"             *          ",
"                        ",
"                        "};
}
set todoStatIcon(OPEN) {
/* XPM */
static char * todoOpen_xpm[] = {
"24 24 2 1",
" 	c none",
".	c #BDBD00002323",
"                        ",
"                        ",
"                        ",
"        ......          ",
"       ..   ....        ",
"      ....   ....       ",
"      ....   ....       ",
"       ..    ....       ",
"             ....       ",
"             ...        ",
"            ...         ",
"           ...          ",
"          ..            ",
"         ..             ",
"         ..             ",
"                        ",
"         ...            ",
"        .....           ",
"        .....           ",
"        .....           ",
"         ...            ",
"                        ",
"                        ",
"                        "};
}
set todoStatIcon(KILL) {
/* XPM */
static char * todoKilled_xpm[] = {
"24 24 2 1",
" 	c none",
".	c #CCCC00000000",
"                        ",
"                        ",
" ....            ....   ",
" ......         .....   ",
" .......       ......   ",
"  ........    .....     ",
"    .......  ......     ",
"      ..... ......      ",
"       .........        ",
"        ........        ",
"         ......         ",
"        ......          ",
"       ........         ",
"      ..........        ",
"      ..... .....       ",
"     .....  ......      ",
"     ....    ......     ",
"    ....      ......    ",
"   .....       .....    ",
"  .....         .....   ",
"  .....          ....   ",
"  ....            ...   ",
"                        ",
"                        "};
}
set todoStatIcon(WAIT) {
/* XPM */
static char * todoWait_xpm[] = {
"24 24 5 1",
" 	c none",
".	c #000000000000",
"X	c #FAFAFAFAFAFA",
"o	c #FFFFAEAE1A1A",
"O	c #FFFFFFFFFFFF",
"                        ",
"                        ",
"         .....          ",
"       ..XX.XX..        ",
"     ...XXooXXX...      ",
"    .XXX.XooXX.XXX.     ",
"    .XXXXXooXXXXXX.     ",
"   ..XXXXXooXXXXXX..    ",
"   .X.XXXXooXXXXX.X.    ",
"  .XXXXXXXooXXXXXXXX.   ",
"  .XXXXXXXooXXXXXXXX.   ",
"  ....XXXXo.ooXXX....   ",
"  .XXXXXXXXooooOOXXX.   ",
"  .XXXXXXXXXXXooOXXX.   ",
"   .X.XXXXXXXXOXX.X.    ",
"   ..XXXXXXXXXXXXX..    ",
"    .XXXXXXXXXXXXX.     ",
"    .XXX.XX.XX.XXX.     ",
"     ...XXX.XXX...      ",
"       ..XX.XX..        ",
"         .....          ",
"                        ",
"                        ",
"                        "};
}
set todoStatIcon(HOLD) {
/* XPM */
static char * todoStopped_xpm[] = {
"24 24 4 1",
" 	c none",
".	c #757575757575",
"X	c #CCCC05052323",
"o	c #FFFFFFFFFFFF",
"                        ",
"        .......         ",
"       .XXXXXXX.        ",
"      .XXXXXXXXX.       ",
"     .XXXXXXXXXXX.      ",
"    .XXXXXXXXXXXXX.     ",
"   .XXXXXXXXXXXXXXX.    ",
"  .XXXXXXXXXXXXXXXXX.   ",
" .XXXoooXoXXXXXXXXXXX.  ",
" .XXooXXXoXXXXXXXXXXX.  ",
" .XXooXXoooXoooXoooXX.  ",
" .XXXXooXoXoXXXooXXoX.  ",
" .XXXXXoXoXoXXXooXXoX.  ",
" .XXoooXXooXoooXoooXX.  ",
" .XXXXXXXXXXXXXXoXXXX.  ",
" .XXXXXXXXXXXXXXoXXXX.  ",
"  .XXXXXXXXXXXXXXXXX.   ",
"   .XXXXXXXXXXXXXXX.    ",
"    .XXXXXXXXXXXXX.     ",
"     .XXXXXXXXXXX.      ",
"      .XXXXXXXXX.       ",
"       .XXXXXXX.        ",
"        .......         ",
"                        "};
}
set todoStatIcon(WIP) {
/* XPM */
static char * todoWIP_xpm[] = {
"24 24 7 1",
" 	c none",
".	c #FFFFAEAE1A1A",
"X	c #FAFAFAFAFAFA",
"o	c #00000000CCCC",
"O	c #CCCC05052323",
"+	c #000000000000",
"@	c #3B3BD7D70000",
"                        ",
"         ...            ",
"        ....            ",
"       ...XoX           ",
"       ..XXXX           ",
"       ..XXO            ",
"         XX             ",
"        +..             ",
"       ++..+            ",
"      ++ ..+            ",
"     ++  ..++           ",
"     +++ .. ++          ",
"       +++.  ++         ",
"         ..             ",
"         ++@            ",
"        @@@@@           ",
"        @@ @@@          ",
"        @@  @@@         ",
"       @@@   @@@        ",
"      @@@     @@        ",
"    +@@       @@@       ",
"   +++         @@ +     ",
"    +++        @+++     ",
"     +++        ++      "};
}
set todoStatIcon(DELAY) {
/* XPM */
static char * todoDelayed_xpm[] = {
"24 24 4 1",
" 	c none",
".	c #E6E600000000",
"X	c #FFFFFFFFFFFF",
"o	c #000000000000",
"                        ",
"  ....................  ",
"  ....................  ",
"   ..................   ",
"   ...XXXXXXXXXXXX...   ",
"    ..XXXXXooXXXXX..    ",
"    ...XXXooooXXX...    ",
"     ..XXXooooXXX..     ",
"     ...XXooooXX...     ",
"     ...XXooooXX...     ",
"      ..XXXooXXX..      ",
"      ...XXooXX...      ",
"      ...XXooXX...      ",
"       ..XXXXXX..       ",
"       ...XooX...       ",
"        ..XooX..        ",
"        ...XX...        ",
"        ...XX...        ",
"         ......         ",
"         ......         ",
"          ....          ",
"          ....          ",
"           ..           ",
"                        "};
}

set mileStoneIcon {
/* XPM */
static char * milestone_xpm[] = {
"24 24 4 1",
" 	c #999999999999",
".	c #424242424242",
"X	c #000000000000",
"o	c #F2F2F2F2F2F2",
"                        ",
"           ....         ",
"         XXXXX...       ",
"       XXoooooXX..      ",
"      XoooooooooX..     ",
"     XoooooooooooX.     ",
"     XoooooooooooX..    ",
"    XoooooooooooooX.    ",
"    XoooooooooooooX..   ",
"   XoooooooooooooooX.   ",
"   XoooooooooooooooX.   ",
"   XoooooooooooooooX..  ",
"   XoooooooooooooooX..  ",
"  XoooooooooooooooooX.  ",
"  XoooooooooooooooooX.  ",
"  XoooooooooooooooooX.  ",
"  XoooooooooooooooooX.  ",
"  XoooooooooooooooooX.  ",
"  XoooooooooooooooooX.  ",
"  XoooooooooooooooooX.  ",
"  XoooooooooooooooooX.  ",
"  XoooooooooooooooooX.  ",
"  XXXXXXXXXXXXXXXXXXX   ",
"                        "};
}
}

# initTODO
# organiseTODOlist
# toplevel .tdd
# drawToDo .tdd
# button .abb -text "Exit" -command exit -height 2
# pack .abb -fill both
# wm geometry . 200x40-400+400
# fillTODO 
