#!/bin/sh

if [ $# -lt 5 ] 
then
    echo "usage doInstall.sh INSTALL_DIR BIN_DIR MASTER_PORT SERVER AUTO_MRR BUILD_ROOT"
    exit -1
fi


INSTALL_PATH=$1
BIN_DIR=$2
MASTERPORT=$3
SERVER=$4
AUTO_MRR=$5
BUILD_ROOT=$6

if [  ! -x findTclTkLibVersion ]
then
    cc unixX11/findLibVersion.cc  -o findTclTkLibVersion
fi

if [  ! -x libVersion.sh ]
then
    echo "#!/bin/sh" > libVersion.sh
    echo "./findTclTkLibVersion | gawk '{printf(\"tcl%s tk%s tix%s\n\",\$1,\$2,\$3)}'" >>libVersion.sh
    chmod a+rx libVersion.sh
fi

echo
echo "creating Makefile"

echo "INSTALL_DIR=$INSTALL_PATH/client" >Makefile
echo "DOCU_DIR=$INSTALL_PATH/html" >>Makefile
echo "BIN_DIR=$BIN_DIR" >>Makefile
echo "MASTERPORT=$MASTERPORT" >>Makefile
echo >>Makefile
cat unixX11/Makefile.rpm >>Makefile

echo "#!/bin/sh"             > startMrr.sh
echo "$INSTALL_PATH/client/mrr &" >> startMrr.sh


sleep 1

echo
echo "making binary and installing TCl-Sckripts"

if [ -f ./client ]
then
    rm client
fi

make 

cat unixX11/etc-minkowsky.defaults  |grep -v MINKO |grep -v AUTO_INSTALL_MRR > minkowsky.tmp


echo
echo "making Configuration-file"

mkdir  etc
if [ "$AUTO_MRR" == "y" ]
then
    AUTO_MRRF=1
else
    AUTO_MRRF=0
fi

echo MINKO_PATH $INSTALL_PATH >> minkowsky.tmp
echo MINKO_SERVER $SERVER  >> minkowsky.tmp
echo "AUTO_INSTALL_MRR $AUTO_MRRF" >> minkowsky.tmp
exit
