#! /bin/sh 

. lang.sh

CONFIG_FILE=/etc/minkowsky
DEVEL=0
AUTO_MRR="y"
WITHVERSION=0

#Evaluate the Commandline
while [ $# -gt 0 ]
do
    if [ "$1" == "-d" ]
    then
	CONFIG_FILE=$HOME/.minkowsky.devel
	DEVEL=1
	DPORT=42001
    fi
    shift
done



#echo $CONFIG_FILE

#Set defaults either from previously build config-file or from scratch
if [ -f $CONFIG_FILE ]
then
    echo "reading old config"
    INST_PATH=`cat $CONFIG_FILE |grep MINKO_PATH  |gawk '{print $2}'`
    echo "inst=$INST_PATH"
    if [ "$INST_PATH" == "" ]
    then
	if [ $DEVEL -eq 0 ]
	then
	    INST_PATH="/opt/minkowsky"
	else
	    INST_PATH="$HOME/minkowsky"
	fi
    fi
else
    if [ $DEVEL -eq 0 ]
    then
	INST_PATH="/opt/minkowsky"
    else
	INST_PATH="$HOME/minkowsky"
    fi
fi
INSTALL_PATH=$INST_PATH

cd  ../
# Check if necessary libaries are avialable

echo
echo "STARTE MINKOWSKY-CLIENT-DOCUMENTATION-INSTALLTIONS"*
echo
echo "Installing documentation on $INSTALL_PATH/html"
echo 





echo
echo "creating Makefile"

echo "s/html\//html\/$DOCU_LANG\//g" >> tmp.sed

echo "DOCU_DIR=$INSTALL_PATH/html/$DOCU_LANG" >Makefile
echo >>Makefile
cat unixX11/Makefile |sed -f tmp.sed >>Makefile
rm tmp.sed

sleep 1


make install


echo
echo
echo "Installation des Minkowsky-Clients abgeschlossen"
echo
exit
