#! /bin/sh 

_LANG=`echo $LANG|cut -c-2`
CONFIG_FILE=/etc/minkowsky
DEVEL=0
AUTO_MRR="y"
WITHVERSION=0

#Evaluate the Commandline
while [ $# -gt 0 ]
do
    if [ "$1" == "-withVersionControl" ]
    then
	WITHVERSION=1
    else
	WITHVERSION=0
    fi
    if [ "$1" == "-d" ]
    then
	CONFIG_FILE=$HOME/.minkowsky.devel
	DEVEL=1
	DPORT=42001
    fi
    shift
done


#Set defaults either from previously build config-file or from scratch
if [ -f $CONFIG_FILE ]
then
    echo "reading old config"
    INST_PATH=`cat $CONFIG_FILE |grep MINKO_PATH  |gawk '{print $2}'`
    if [ "$INST_PATH" == "" ]
    then
	if [ $DEVEL -eq 0 ]
	then
	    INST_PATH="/opt/minkowsky"
	else
	    INST_PATH="$HOME/minkowsky"
	fi
    fi
    SRV=`cat $CONFIG_FILE |grep MINKO_SERVER  |gawk '{print $2}'`
    if [ "$SRV" == "" ]
    then
	SRV="localhost"    
    fi

    if [ $DEVEL -eq 0 ]
    then
	BINDIR="/usr/bin"
    else
	BINDIR="$HOME/bin"
    fi
    AUTO_MRR=`cat /etc/minkowsky | grep AUTO | grep MRR | gawk 'BEGIN{c=0}{c++}END{if(c>0){print "y"}else{print "n"}}'`
    if [ "$AUTO_MRR" == "" ]
    then
	if [ $DEVEL -eq 0 ]
	then
	    AUTO_MRR=y
	else
	    AUTO_MRR=n
	fi
    fi
else
    if [ $DEVEL -eq 0 ]
    then
	INST_PATH="/opt/minkowsky"
	BINDIR="/usr/bin"
	SRV="localhost"
	AUTO_MRR=y
    else
	INST_PATH="$HOME/minkowsky"
	BINDIR="$HOME/bin"
	SRV="localhost"
	AUTO_MRR=n
    fi
fi


cd  ../
# Check if necessary libaries are avialable

if [ "$_LANG" == "de" ]
then
    echo
    echo "STARTE MINKOWSKY-CLIENT-INSTALLTIONS"*
    echo
else
    echo
    echo "STARTING MINKOWSKY-CLIENT-INSTALATION"*
    echo
fi 


#Erstelle lokale libVersion.sh
cc unixX11/findLibVersion.cc  -o findTclTkLibVersion
echo "#!/bin/sh" > libVersion.sh
echo "./findTclTkLibVersion | gawk '{printf(\"tcl%s tk%s tix%s\n\",\$1,\$2,\$3)}'" >>libVersion.sh
chmod a+rx libVersion.sh




echo -n "Suche TCL/Tk/Tix-Libs                "
TCLLIB=`./libVersion.sh`
TCLOK=`echo $TCLLIB | awk '{if(NF==3){print "OK"}else{print "error"}}'`
if [ "$TCLOK" != "OK" ]
then
    if [ "$_LANG" == "de" ]
    then
	echo
	echo "ERROR"
	echo "Ich kann eine der bentigten Bibliothekne nicht finden"
	echo "Es mssen TCl, TK und Tix installiert sein"
    else
	echo
	echo "ERROR"
	echo "The installer can't find the required libraries."
	echo "You must have Tcl, Tk and Tix installed to run the Minkowsky client"
    fi
    exit
fi
echo "done"

echo -n "berprfe TCL/TL/Tix-LibsVersionen    "
TCLVER=`echo $TCLLIB |sed -e 's/[a-z]//g'|sed -e 's/\.//g'`
TCLOK=`echo $TCLVER | awk '{n=$1;while(n<1000){n=n*10;}; if(n>=8000){print "OK"}else{print "error"}}'`
echo  -n "."
TK_OK=`echo $TCLVER | awk '{n=$2; while(n<1000){n=n*10}; if(n>=8000){print "OK"}else{print "error"}}' `
echo  -n "."
TIXOK=`echo $TCLVER | awk '{n=$3; while(n<1000){n=n*10}; if(n>=4180){print "OK"}else{print "error"}}' `
echo "."

if [ "$TCLOK" != "OK" ]
then
    if [ "$_LANG" == "de" ]
    then
	echo
	echo "WARNUNG"
	echo "======="
	echo
	echo "Minkowsky wurde mit TCL 8.0 entwickelt."
	echo "Ob es auch mit TCL <8.0 funktioniert ist unbekannt"
	echo "Sie knnen die Installation gerne fortsetzen und es ausprobieren"
	echo -n "    Fortsetzen  [n] "
    else
	echo
	echo "WARNING"
	echo "======="
	echo
	echo "Minkowsky has been developed with  TCL 8.x."
	echo "If Minkowsky will work with earlier version is unknown"
	echo "Will you try to use Minkowsky anyway?"
	echo -n "    Continue [n]"
    fi
    read ans
    echo $ans
    ANS=`echo $ans |awk '{if($1=="j" || $1=="J" ||$1=="y" ||$1=="Y"){print "OK"}else{print "stop"}}'`
    if [ "$ANS" != "OK" ]
    then
	exit
    fi
fi

if [ "$TK_OK" != "OK" ]
then
    if [ "$_LANG" == "de" ]
    then
	echo
	echo "WARNUNG"
	echo "======="
	echo
	echo "Minkowsky wurde mit TK 8.0 entwickelt."
	echo "Ob es auch mit TK <8.0 funktioniert ist unbekannt"
	echo "Sie knnen die Installation gerne fortsetzen und es ausprobieren"
	echo -n "    Fortsetzen  [n] "
    else
	echo
	echo "WARNING"
	echo "======="
	echo
	echo "Minkowsky has been developed with  Tk 8.x."
	echo "If Minkowsky will work with earlier version is unknown"
	echo "Will you try to use Minkowsky anyway?"
	echo -n "    Continue [n]"
    fi
    read ans
    echo $ans
    ANS=`echo $ans |awk '{if($1=="j" || $1=="J" ||$1=="y" ||$1=="Y"){print "OK"}else{print "stop"}}'`
    if [ "$ANS" != "OK" ]
    then
	exit
    fi
fi

if [ "$TIXOK" != "OK" ]
then
    if [ "$_LANG" == "de" ]
    then
	echo
	echo "WARNUNG"
	echo "======="
	echo
	echo "Minkowsky wurde mit Tix 4.1.8.0 bzw.Tix 8.x  entwickelt."
	echo "Ob es auch mit Tix <4.1.8.0 funktioniert ist unbekannt"
	echo "Sie knnen die Installation gerne fortsetzen und es ausprobieren"
	echo -n "    Fortsetzen  [n] "
    else
	echo
	echo "WARNING"
	echo "======="
	echo
	echo "Minkowsky has been developed with  TixCL 4.1.8.0 and Tix 8.x"
	echo "If Minkowsky will work with earlier version is unknown"
	echo "Will you try to use Minkowsky anyway?"
	echo -n "    Continue [n]"
    fi
    read ans
    echo $ans
    ANS=`echo $ans |awk '{if($1=="j" || $1=="J" ||$1=="y" ||$1=="Y"){print "OK"}else{print "stop"}}'`
    if [ "$ANS" != "OK" ]
    then
	exit
    fi
fi


#Ask for Configuration options
echo
echo 

if [ "$_LANG" == "de" ]
then
    echo "Auf diesem Installation-Pfad wird das Executable und die "
    echo "TCL-Scripten abgelegt. Der Installer wird dort zwei Verzeichnisse"
    echo "names 'client' und 'html' dort anlegen. Daher bentigt der Installer"
    echo -n "Schreibrechte auf auf dem Installation-Pfad [$INST_PATH]  "
else
    echo "On which path you want to install the Binaries and the Tcl-scripts".
    echo "The installer will create two subdirectories named 'client' and 'html' there"
    echo "The installer need write permission on this path [$INST_PATH]  "
fi
read ans
if [ "$ans" == "" ]
then
    INSTALL_PATH=$INST_PATH
else
    INSTALL_PATH=$ans
fi

if [ "$_LANG" == "de" ]
then
    echo 
    echo "Auf diesem Pfad legt der Installer symbolische Link(s) auf das"
    echo "Executable auf $INST_PATH ab"
    echo "Diese Verzeichnis muss in der Environment-Variable PATH stehen,"
    echo "damit minkowsky (aus einer Shell) gestartet werden kann."
    echo -n "Link-Installation-Pfad [$BINDIR]           "
else
    echo 
    echo "The installer will create a symbolic link to the binary in"
    echo "$INST_PATH. The directory in which this link will be created"
    echo "should be listed in the environment variable PATH "
    echo "in order to start minkowsky from shell without the full path"
    echo -n "Link installation Path [$BINDIR]           "
fi
read ans
if [ "$ans" == "" ]
then
    BIN_DIR=$BINDIR
else
    BIN_DIR=$ans
fi

if [ "$_LANG" == "de" ]
then
    echo 
    echo "Die Termin usw. werden nicht vom Minkowsky-Client sondern"
    echo "vom Server verwaltet. Der Minkowsky-client muss aber wissen"
    echo "wo der Minkowsky-Server luft. Wenn Minkowsky nicht in einem "
    echo "Netzwerk arbeitet, luft der Server auf demselben Rechner wie"
    echo "der client in diesem Fall ist der Server der 'localhost'"
    echo "Wenn Minkowsky in einem Netzwerk arbeitet, muss nun noch"
    echo "der Name oder die IP des Minkowsky-Server angegeben werden"
    echo
    echo -n "Name (oder IP) des Rechners auf dem der Minkowsky-Server luft [$SRV] ? "
else
    echo 
    echo "The management of the appointment task etc data is done"
    echo "not by this client but the Minkowsky server. However the client"
    echo "application needs to know on which host the Minkowsky server is"
    echo "running. This might be the some machine. In this case the servers"
    echo "name is 'localhost'. Otherwise enter the name or IP of the host"
    echo "running the Minkowsky-Server."
    echo
    echo -n "Name  or IP of the host running the Minkowsky-Server [$SRV] ? "
fi
read ans
if [ "$ans" == "" ]
then
    SERVER=$SRV
else
    SERVER=$ans
fi

if [ "$_LANG" == "de" ]
then
    echo
    echo "Damit Erinnerungen per Dialog-Fenster ausgeliefert werden knnen muss ein"
    echo "Zusatzprogramm im Hintergrund laufen (der Minkowsky-Remote-Reminder mrr)"
    echo "Dieses sollte ber einen Autostart-Mechanismuss gestartet werden."
    echo "Der Minkowsky-Client kann bei einigen Oberflchen dies beim Starten"
    echo "berprfen und ggfs. diese Mechnaismus aktivieren"
    echo -n "Soll der Client dies tun ? (j/n) [$AUTO_MRR] "
else
    echo
    echo "In order to deliver reminder by a dialog rather than by mail a second"
    echo "Application is need (the so called Minkowsky-Remote-Reminder mrr)"
    echo "Its is advisable to start this app through the Autostart mechanism"
    echo "of your Desktop environment or your window manager. Minkowsky can check"
    echo "check this on some of them and install this app for autostart on them."
    echo -n "Do you want Minkowsky to do this ? (y/n) [$AUTO_MRR] "
fi
read ans
if [ "$ans" == "y"  ]
then
    AUTO_MRR=y
fi
if [ "$ans" == "Y"  ]
then
    AUTO_MRR=y
fi
if [ "$ans" == "J"  ]
then
    AUTO_MRR=y
fi
if [ "$ans" == "j"  ]
then
    AUTO_MRR=y
fi
if [ "$ans" == "n"  ]
then
    AUTO_MRR=N
fi
if [ "$ans" == "N"  ]
then
    AUTO_MRR=n
fi


if [ $DEVEL -eq 1 ]
then
    if [ "$_LANG" == "de" ]
    then
	echo
	echo "Auf welchem Port soll der die Entwicklerversion"
	echo -n "von Minkowsky lauschen (41999 ist verboten) [$DPORT] ?"
    else
	echo
	echo "On which port should the developmental version"
	echo -n "listen  (port 41999 is not allowed) [$DPORT] ?"
    fi
    read ans
    if [ "$ans" != "" ]
    then
	DPORT=$ans
    fi
    if [ $DPORT -eq 41999 ]
    then 
	DPORT=0
    fi
    if [ $DPORT -le 1024 ]
    then 
	DPORT=0
    fi
    while [ $DPORT == 0 ]
    do
	DPORT=42001
	if [ "$_LANG" == "de" ]
	then
	    echo "Der Port muss oberhalb von 1024 liegen  und"
	    echo "darf nicht 41999 sein (um Konflickte mit der"
	    echo -n "regulren Verion zu vermeiden, also [$DPORT]:"
	else
	    echo "The port must be above of 1024 and must not be"
	    echo "41999 to avoid conflicts with productive versions"
	    echo -n "of Minkowsky. Hence which port:[$DPORT]: "
	fi
	read ans
	if [ "$ans" != "" ]
	then
	    DPORT=$ans
	fi
	if [ $DPORT -eq 41999 ]
	then 
	    DPORT=0
	fi
	if [ $DPORT -le 1024 ]
	then 
	    DPORT=0
	fi
    done
fi

if [ "$_LANG" == "de" ]
then
    echo
    echo
    echo "Installationverzeichnis  : $INSTALL_PATH"
    echo "Programm-Bin-)Verzeichnis: $BIN_DIR"
    echo "Minkowsky-Server         : $SERVER"
    echo "automatische MRR-Install.: $AUTO_MRR"
    if [ $DEVEL -eq 1 ]
    then
	echo "Configurationfile        : $CONFIG_FILE"
	echo "Server-Port              : $DPORT"
    fi
    echo
    echo -n "Stimmen diese Angaben  [j] "
else
    echo
    echo
    echo "Installation path        : $INSTALL_PATH"
    echo "Link path                : $BIN_DIR"
    echo "Minkowsky Server         : $SERVER"
    echo "automatic MRR install.   : $AUTO_MRR"
    if [ $DEVEL -eq 1 ]
    then
	echo "Configuration file       : $CONFIG_FILE"
	echo "Server-Port              : $DPORT"
    fi
    echo
    echo -n "Is this correct ?  [y] "

fi
read ans
OK=`echo $ans|awk '{if(NF>=1){if($1=="j" ||$1=="J" ||$1=="y" ||$1=="Y"){print "OK"}else {print "new"}}else{print "OK"}}'`
echo $OK
if [ "$OK" != "OK" ]
then
    if [ "$_LANG" == "de" ]
    then
	echo
	echo "OK. Versuchen wir es noch einmal"
	echo
	echo
    else
	echo
	echo "OK. Try again"
	echo
	echo
    fi
    if [ $WITHVERSION -eq 1 ]
    then
	./installer.sh -withVersionControl
    else 
	./installer.sh
    fi
    exit
fi



echo
echo "creating Makefile"

echo "INSTALL_DIR=$INSTALL_PATH/client" >Makefile
echo "DOCU_DIR=$INSTALL_PATH/html" >>Makefile
echo "BIN_DIR=$BIN_DIR" >>Makefile
if [ $DEVEL -eq 1 ]
then
    echo "MASTERPORT=$DPORT" >>Makefile
else
    echo "MASTERPORT=41999" >>Makefile
fi
echo >>Makefile
if [ $WITHVERSION -eq 1 ]
then
    echo "#! /bin/sh"  > mrrVersion.sh
    echo -n 'VERSIONS=`/lan/minkowsky/client/findTclTkLibVersion|gawk ' >> mrrVersion.sh
    echo -n "'" >> mrrVersion.sh
    echo -n '{printf("%s-%s-%s\n",$1,$2,$3)}' >> mrrVersion.sh
    echo  "'\`" >> mrrVersion.sh
    echo 'echo "mrr-$VERSIONS"' >> mrrVersion.sh

    echo "#! /bin/sh"  > binVersion.sh
    echo -n 'VERSIONS=`/lan/minkowsky/client/findTclTkLibVersion|gawk ' >> binVersion.sh
    echo -n "'" >> binVersion.sh
    echo -n '{printf("%s-%s-%s\n",$1,$2,$3)}' >> binVersion.sh
    echo  "'\`" >> binVersion.sh
    echo 'echo "client-$VERSIONS"' >> binVersion.sh
    
    echo "#! /bin/sh"  > mrr.sh
    echo -n 'VERSIONS=`/lan/minkowsky/client/findTclTkLibVersion|gawk ' >> mrr.sh
    echo -n "'" >> mrr.sh
    echo -n '{printf("%s-%s-%s\n",$1,$2,$3)}' >> mrr.sh
    echo  "'\`" >> mrr.sh
    echo -n "$INSTALL_PATH/client/" >> mrr.sh
    echo 'mrr-$VERSIONS $*' >> mrr.sh
    

    chmod u+rx mrrVersion.sh binVersion.sh mrr.sh

    cat unixX11/Makefile.wv >>Makefile
    cp -f findTclTkLibVersion $INSTALL_PATH/client/
    #Bearbeiet minkowesky-Skript wenn ntig
    echo "#!/bin/sh" > m.sh
    echo "VERSIONS=\`$INSTALL_PATH/client/findTclTkLibVersion |gawk '{printf(\"%s-%s-%s\n\",\$1,\$2,\$3)}'\`">> m.sh
    echo "$INSTALL_PATH/client/client-\$VERSIONS \$*">> m.sh
    mv -f  m.sh minkowsky
    chmod a+rx minkowsky
else 
    cat unixX11/Makefile.ov >>Makefile
fi

echo "#!/bin/sh"             > startMrr.sh
echo "$INSTALL_PATH/client/mrr &" >> startMrr.sh


sleep 1

echo
echo "making binary and installing TCl-Sckripts"

if [ -f ./client ]
then
    rm client
fi

make install

#make install-doc

if [ -f $CONFIG_FILE ]
then
    cat $CONFIG_FILE |grep -v MINKO |grep -v AUTO_INSTALL_MRR > /tmp/minkowsky
else
    touch /tmp/minkowsky
fi

echo
echo "making Configuration-file"


echo MINKO_PATH $INSTALL_PATH >> /tmp/minkowsky
echo MINKO_SERVER $SERVER  >> /tmp/minkowsky
if [ "$AUTO_MRR" == "y" ]
then
    echo "MINKO_AUTO_MRR " >> /tmp/minkowsky
fi
if [ "$_LANG" == "de" ]
then
    echo
    echo
    echo "Die Installation  des globalen Konfiguartionsfile"
    echo "muss von root-vorgenommen werden"
    echo "Der Installer ruft nun eine Skript das dies tut."
    echo "Bitte geben sie das root-passwort ein:"
    echo "  (Falls sie dem Installer mistrauen knnen sie"
    echo "   selbstverstndlich die Sourcen einsehen. Es sind"
    echo "   einfache Shellskripte)"
else
    echo
    echo
    echo "The installation of the central configuration must be"
    echo "done as root. The installer will now call a script to do this."
    echo "Please enter your root password:"
    echo "  (In case you don't trust the installer you may want to"
    echo "   inspect this scripts. They are simple shells scripts. You"
    echo "   find them on unixX11/installer.sh and scripts/rootInstall.sh)"
fi
su -c "scripts/rootInstall.sh /etc/minkowsky $INSTALL_PATH $BIN_DIR"

#mv -f  /tmp/minkowsky $CONFIG_FILE 
#chmod a+r $CONFIG_FILE 

if [ "$_LANG" == "de" ]
then
    echo
    echo
    echo "Installation des Minkowsky-Clients abgeschlossen"
    echo
else
    echo
    echo
    echo "Installation of the Minkowsky client is complete"
    echo
fi
exit
