#!/usr/bin/X11/tixwish
#  File: utils.tcl
# 
#      This file is part of minkowsky
# 
#      Copyright (C) 2001-2002 by Rdiger Goetz
#      Author: Rdiger Goetz <minkowsky@r-goetz.de>
# 
#      Time-stamp: <25-May-2002 19:57:17 goetz>
# 
#      This program is free software; you can redistribute it and/or modify
#      it under the terms of the GNU General Public License as published by
#      the Free Software Foundation; either version 2 of the License, or
#      (at your option) any later version.
# 
#      This program is distributed in the hope that it will be useful,
#      but WITHOUT ANY WARRANTY; without even the implied warranty of
#      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#      GNU General Public License for more details.
# 
#      You should have received a copy of the GNU General Public License
#      along with this program; if not, write to the Free Software
#      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#  
proc compareNames { name1 name2 } {
    set lastName1 [string trim [lindex [split $name1] end]]
    set lastName2 [string trim [lindex [split $name2] end]]

    
    if {$lastName1 == "" && $lastName2 ==""} { set ret 0
    } elseif {$lastName1 == "" } { set ret  1
    } elseif {$lastName2 == "" } { set ret -1
    } else { set ret [ string compare $lastName1 $lastName2 ]}
#    puts "'$lastName1'       vs  '$lastName2'            -> $ret"
    return $ret
}
proc check4NewLists { } {
    global lastListUpdate username
    set t [request lastUListUpdate]
    if { $t == "Error" } { return }
#     if { [string first $t "ServerDown"] >=0 } {ServerDownDialog}
    if { $t > $lastListUpdate } { 
	getNewLists 
	set lastListUpdate $t
    }
    set ret [request getBriefAdrList $username]
    if { $ret == "Error" } { return }
    if { $ret != "unchanged" } { 
	set extList [lsort -command compareNames $ret] }
}

proc getNewLists { } {
    global userList groupList userListExeptDonts groupListExeptDonts roomList fullUserNameList
    global extList username
    global fullUserNames usersByGroup
    global holidays holidayNames holidayMonth
    global colorList dontList
    global _allgText

    set lastUserList 0
    set lastGroupList 0
    set lastRoomList 0
    
    set ret [ request getLists]
    if { $ret == "Error" } { return }
#    if { [string first $ret "ServerDown"] >=0 } {ServerDownDialog}
    
    set userList  [lindex $ret 0]
    set groupList [lindex $ret 1]
    set roomList  [lindex $ret 2]
    set fullUserNameList [lindex $ret 3]
    set hlist [lindex $ret 4]
    set ubgList [ lindex $ret 5]
    set userColorList [ lindex $ret 6]
    set groupColorList [ lindex $ret 7]
    set dlList [ lindex $ret 8]

    set anz [llength $userList]
    for {set i 0} { $i < $anz } {incr i} {
	set name [lindex $userList $i]
	set fullUserNames(u-$name) [lindex $fullUserNameList $i]
	set colorList(u-$name) [lindex $userColorList $i]
	set dontList(u-$name) 0
    }
    set anz [llength $groupList]
    for {set i 0} { $i < $anz } {incr i} {
	set name [lindex $groupList $i]
	set fullUserNames(g-$name) "$_allgText(Gruppe) $name"
	set colorList(g-$name) [lindex $groupColorList $i]
	set dontList(g-$name) 0
    }

    set anz [llength $roomList]
    for {set i 0} { $i < $anz } {incr i} {
	set name [lindex $roomList $i]
	set fullUserNames(r-$name) "$_allgText(Raum) $name"
	set dontList(r-$name) 0
    }
    
    foreach list $ubgList {
	set group [lindex $list 0]
	set usersByGroup($group) [lindex $list 1]
    }

    foreach ent $dlList {
	set dontList($ent) 1
    }
    set userListExeptDonts ""
    foreach user $userList {
	if { $dontList(u-$user) == 0 } {
	    lappend userListExeptDonts $user
	}
    }

    set groupListExeptDonts ""
    foreach group $groupList {
	if { $dontList(g-$group) == 0 } {
	    lappend groupListExeptDonts $group
	}
    }

    set holidayMonth ""
    foreach list  $hlist {
	set anz [llength $list]
	if {$anz <2} { break }
	
	set tag [ format "%04d-%02d" [lindex $list 0] [lindex $list 1]]
	set holidays($tag) ""
	set holidayNames($tag) ""
	for {set i 2} { $i < $anz } {incr i} {
	    lappend holidays($tag) [lindex $list $i]
	    incr i
	    lappend holidayNames($tag) [lindex $list $i]
	}
	lappend holidayMonth $tag
    }

}

proc getPresence { } { 
    global userList userPresence

    foreach user $userList {
	set userPresence($user) 0
    }
    set list [ request getPresenceList ]
    if { $list == "Error" } { return }
    if { $list == "??? unchecked" } {
	foreach user $userList {
	    set userPresence($user) 1
	}
    } else {
	foreach user $list {
	    set userPresence($user) 1
	}
    }
}

proc getLists { } {check4NewLists }
proc getUserList { } {check4NewLists }
proc getGroupList { } {check4NewLists }
proc getRoomList { } {check4NewLists }

proc getFullUserName { name ig} {
    global userList fullUserNameList _allgText
    
#     puts "getFullUsername for $name/$ig"
#     puts "userList = $userList"
#     puts "fullList = $fullUserNameList"

    if { $ig == "u" } {
	set idx [lsearch $userList $name ]
	if { $idx>=0 } {
	    return [ lindex $fullUserNameList $idx ]
	}
    } elseif { $ig == "g" } {
	set idx [lsearch $groupList $name ]
	if { $idx>=0 } {
	    return "$allgText(Gruppe) $name"
	}
    }
    return "-"
}


proc strTrunc { str l } {
    set len [string length $str ]
    if {$len >$l} {
	set str [format "%s..." [string range $str 0 [expr $l-4] ] ]
    }
    return $str
}
proc strTrunc2 { txt count fnt } { 
    set width [expr $count *[font measure $fnt "0" ]]
    if { [font measure $fnt $txt] <= $width } {
	return $txt
    }
    set l [string length $txt]
    set txt2 "[string range $txt 0 $l]..."
    while { [font measure $fnt $txt2]  <= $width } {
	incr l -1
	set txt2 "[string range $txt 0 $l]..."
    }
    return $txt2
}
proc strTrunc3 { txt width fnt count } { 
    set tw [font measure $fnt $txt]
    if { $tw <= $width } {
	return $txt
    }
    
    set l $count
    set c1 0
    set c2 0
    set txt2 "[string range $txt 0 $l]..."
    set tw [font measure $fnt $txt2]
    while { $tw  < $width } {
	incr l 
	set txt2 "[string range $txt 0 $l]..."
	set tw [font measure $fnt $txt2]
	incr c1
    }
    while { $tw  >= $width } {
	incr l -1
	set txt2 "[string range $txt 0 $l]..."
	set tw [font measure $fnt $txt2]
	incr c2
    }
    return $txt2
}
proc strWarpTrunc3 { txt width fnt lines } { 
    if { [font measure $fnt $txt] <= $width } {
	return $txt
    }

    for { set line 0 } { $line < $lines } {incr line}  { set text($line) "" } 

    set p0 0
    set l [string length $txt]
    for { set line 0 } { $line < $lines } {incr line} { 
#	puts "Line $line starting at $p0 / $l"
	set tw 0
	set p1 $p0
	while { $tw <= $width } {
	    set p2 [string wordend $txt $p1 ]
	    set ttxt [string range $txt $p0  [expr $p2 -1] ]
	    set tw  [font measure $fnt $ttxt]
#	    puts "range $p0 $p2 -> '$ttxt' width=$tw"
	    if { $tw < $width } {  set p1 $p2 }
	    if { $p1 == $l} {
		break
	    }
	}
	if { $p1 > $p0 } {
	    set text($line) [string range $txt $p0 [expr $p1 -1]]
	    set p0 [expr $p1 -1]
	} else {
	    set text($line) [string range $txt $p0 [expr $p2 -1]]
	    set p0 [expr $p2 -1]	    
	}
	incr p0
	if { $p1 == $l} {
	    break 
	}
    }
    set txt2 $text(0)

    for { set line 1 } { $line < $lines } {incr line}  { set txt2 "$txt2\n$text($line)" }

    return $txt2
}
proc trimLead0 { txt } {
    set txt [string trimleft $txt 0 ]
    if { $txt == "" } { return 0}
    return $txt
}

proc nameStrTrunc { str l } {

    set titelElem "Dr. med. rer. nat. rer.nat. phil. pol. rer.pol.  vet. Ing. Prof. Professor"
    set len [string length $str ]
    if {$len >$l} {
	set parts [ split $str]
	set titel ""
	set titel2 ""
	set name1 ""
	set init ""
	set name2 ""
	set anz [llength $parts]
	set ta 1
	set i 1
	set wt 0
	foreach part $parts {
	    if { [string first $part $titelElem] >=0 } {
		if {$part == "Professor" } {
		    set titel "$titel Prof."
		    set titel2 "$titel2 Prof."
		} else {
		    set titel "$titel $part"
		    if {$part == "Dr." || $part == "Prof."} {
			set titel2 "$titel2 $part"
		    }
		}
		set wt 1
	    } else {
		set ta 0
		if {$i <$anz} {
		    set name1 "$name1 $part"
		    set init [format "%s %s." $init [string range $part 0 0]]
		} else {
		    set name2 "$name2 $part"
		}
	    }
	    incr i
	}
	set name1 [ string trim $name1]
	set name2 [ string trim $name2]
	set init  [ string trim $init]
	set init2 [ string range $init 0 1]
	if {$wt == 1} {
	    set titel  [ string trim $titel]
	    set titel2 [ string trim $titel2]
	    set str "$titel $init $name2"
	    if { [string length $str] <= $l } { return $str}
	    set str "$titel2 $init $name2"
	    if { [string length $str] <= $l } { return $str}
	    set str "$titel $init2 $name2"
	    if { [string length $str] <= $l } { return $str}
	    set str "$titel2 $init2 $name2"
	    if { [string length $str] <= $l } { return $str}
	    set str "$titel $name2"
	    if { [string length $str] <= $l } { return $str}
	    set str "$titel2 $name2"
	    if { [string length $str] <= $l } { return $str}
	}
	set str "$init $name2"
	if { [string length $str] <= $l } { return $str}
	set str "$init2 $name2"
	if { [string length $str] <= $l } { return $str}
	set str [format "%s..." [string range $str 0 [expr $l-4] ] ]
    }
    return $str
}

proc dateToStr { datum yw } {
    global _dateOrder
    
    switch $yw {
	4 { set year [expr ($datum /10000) %10000 ] }
	3 { set year [expr ($datum /10000) %1000 ] }
	2 -
	default { set year [expr ($datum /10000) %100 ] }
    }
    set mon [expr ($datum /100) % 100 ]
    set day [expr $datum %100 ]

    switch -exact $_dateOrder {
	de {set str [format "%2d.%2d.%0*d" $day $mon $yw $year]}
	en  -
	default {set str [format "%2d/%2d/%0*d" $mon $day $yw $year]}
    }
    return $str
}
proc date3ToStr { day mon year yw } {
    global _dateOrder
    switch -exact $_dateOrder {
	de {set str [format "%2d.%2d.%0*d" $day $mon $yw $year]}
	en  -
	default {set str [format "%2d/%2d/%0*d" $mon $day $yw $year]}
    }
    return $str
}




proc date2lstr { datum } {
    return [ dateToStr $datum 4]
}
proc date2list  { datum } {
    set year [expr $datum /10000 ]
    set mon  [expr ($datum /100) % 100 ]
    set day  [expr $datum %100 ]

    return [format "%2d %2d %4d" $day $mon $year]
}

proc date2Str {str } {
    global langType
    return [ dateToStr $str 2]

}
proc date2LongStr {day mon year } {
    global langType

    return [ date3ToStr $day $mon $year 4]

}

proc date2ShortNamedStr {day mon year } {
    global langType monAbk
    switch -exact $langType {
	de {set  str  [format  "%2d.%4s %4d" $day [lindex $monAbk $mon] $year ]}
	en  -
	default {
	    set ext "th"
	    if { [expr ($day %10) ] == 1 } { set ext "st" }
	    if { [expr ($day %10) ] == 2 } { set ext "nd" }
	    set  str  [format  "%5s %2d%2s %02d" $[lindex $monAbk $mon] $day $ext [expr ($year ]
	}
    }
    return  $str
}

proc date2NamedStr {day mon year } {
    global langType monAbk

    switch -exact $langType {
	de {set  str  [format  "%2d.%4s %4d" $day [lindex $monAbk $mon] $year ]}
	en  -
	default {
	    set ext "th"
	    if { [expr ($day %10) ] == 1 } { set ext "st" }
	    if { [expr ($day %10) ] == 2 } { set ext "nd" }
	    set  str  [format  "%5s %2d%2s %4d" [lindex $monAbk $mon] $day $ext $year ]
	}
    }
    return  $str
}

proc time2Str { str} { 
    set hour [expr $str /100]
    set min [expr $str %100]
    set str [format "%2d:%02d" $hour $min]
    return $str
}

proc drawDelDialogLines { win  text1 text2 objName sorting font } {
    
    if { $sorting == "O12" } {
	label $win.1 -text "\"$objName\""  -font $font -justify center -anchor n
	label $win.2 -text $text1    -font $font -justify center -anchor n
	label $win.3 -text "$text2 ?"   -font $font -justify center -anchor n
    }
    if { $sorting == "102" } {
	label $win.1 -text $text1         -font $font -justify center -anchor n
	label $win.2 -text "\"$objName\"" -font $font -justify center -anchor n
	label $win.3 -text "$text2 ?"     -font $font -justify center -anchor n
    }
    if { $sorting == "12O" } {
	label $win.1 -text $text1        -font $font -justify center -anchor n
	label $win.2 -text $text2        -font $font -justify center -anchor n
	label $win.3 -text "\"$objName\" ?"  -font $font -justify center -anchor n
    }
    pack $win.1 $win.2 $win.3 -side top -fill x
}


proc checkEntryText { var len  ins c  clist } {

    if { $ins == 1 } {
	if { $len>0 } {
	    if { [string length $var] >  $len } {
		puts "\a"
		return  0
	    }
	}
	if { [string first $c "{}$clist" ] >=0 } {
	    puts "\a"
	    return  0
	}	    
    }
    return 1
}

proc checkEntryText_withCharList { var len  ins c clist } {

    if { $ins == 1 } {
	if { $len>0 } {
	    if { [string length $var] >  $len } {
		puts "\a"
		return  0
	    }
	}
	if { [string first $c "{}$clist" ]  >=0 } {
	    puts "\a"
	    return  0
	}	    
    }
    return 1
}

proc braces2parenthesis { inp} {
    regsub -all {\{} $inp \( tmp
    regsub -all {\}} $tmp \) out
    return $out
}

proc transfer args {
    global _allgText
    set tries 8
    while { $tries > 0} {
	set cmd "server $args"
	#    puts "TRANSFER '$cmd'"
	set ret [ eval $cmd]
	if { [string first  "ServerDown" $ret] >=0 } {
	    ServerDownDialog2
	    incr tries -1
	    continue
#	    ServerBackDialog
#	    return "Error"
	} else {
	    if { [string  toupper [string range [string trim $ret] 0 4] ]  == "ERROR" } {
		ErrorDialog "$_allgText(errorOnTransfer1):[lindex $args 0]\n$_allgText(errorOnTransfer2):\n$ret"
		return "Error"
	    }
	}
	return $ret
    }
    ServerBackDialog
    return "Error"
}
proc request args {
    global _allgText

    set tries 8
    while { $tries > 0} {

	set cmd "server $args"
	set ret [ eval $cmd]

	#    puts ""
	#    puts "ret [string first  "ServerDown" $ret] : '[string range $ret 0 70]' "
	if { [string first "ServerDown" $ret ] >=0 } {
	    #	puts "args ='$args'"
	    ServerDownDialog2
	    incr tries -1
	    continue
	    #	    ServerBackDialog
	    # 	puts "BACK"
	    # 	request $args
	    #`	return "Error"
	} else {
	    if { [string  toupper [string range [string trim $ret] 0 4] ]  == "ERROR" } {
		ErrorDialog "$_allgText(errorOnTransfer1):[lindex $args 0]\n$_allgText(errorOnTransfer2):\n$ret"
		return "Error"
	    }
	}
	return $ret
    }
    ServerBackDialog
    return "Error"
}
