#!/usr/bin/X11/tixwish
#  File: viewDate.tcl
# 
#      This file is part of minkowsky
# 
#      Copyright (C) 2001-2002 by Rdiger Goetz
#      Author: Rdiger Goetz <minkowsky@r-goetz.de>
# 
#      Time-stamp: <19-Apr-2002 17:15:00 goetz>
# 
#      This program is free software; you can redistribute it and/or modify
#      it under the terms of the GNU General Public License as published by
#      the Free Software Foundation; either version 2 of the License, or
#      (at your option) any later version.
# 
#      This program is distributed in the hope that it will be useful,
#      but WITHOUT ANY WARRANTY; without even the implied warranty of
#      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#      GNU General Public License for more details.
# 
#      You should have received a copy of the GNU General Public License
#      along with this program; if not, write to the Free Software
#      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#  

proc viewDate { did date tim } { 
    global fnt bfnt fnt12 bfnt12  bfnt11 fnt11 bfnt10 fnt10 bifnt
    global partStatus partStatusStr username eddv_repTypStr
    global userList fullUserNameList
    global curr_did eddLock curr_perms
    global curDateTitel fullUsername curDate
    global currDate currTime
    global currRefDate currRefTime
    global vdStatusPopWin vdCan
    global vd_igno vd_noRem
    global vdo_igno vdo_noRem
    global vd_needReDraw
    global vd_deleteDateIcon vd_suspendDateIcon vd_shiftDateIcon 
    global vd_modifyDateIcon vd_reminderOnIcon vd_reminderOffIcon
    global ignoreIcon_in ignoreIcon_out
    global _calText _buttonText _allgText _ballonText

    set currDate $date
    set currTime $tim
    set vd_needReDraw 0

    if { [winfo exists .vd ] == 1 } { return }
    killDateToolTip
    toplevel .vd
    busyCursor .vd

    frame .vd.t -relief raised -bd 1
    frame .vd.b
    pack .vd.t .vd.b -side top -fill x -expand 1 -pady 2 

    frame .vd.t.b -relief raised -bd 1
    frame .vd.t.2 -relief ridge -bd 2
    frame .vd.t.4 -relief ridge -bd 2

    pack .vd.t.b   .vd.t.2   .vd.t.4 -side top -fill x -expand 1 -pady 2 -padx 4 -ipadx 2 -pady 2



#    puts stdout "request for $did"

    set ret [ request getBriefDate $username $did $date]
    if { $ret == "Error" } { 
	return 
	destroy .vd
    }
    set curr_did $did

    set perm  [val2perm [lindex $ret 18]]
    perm2rw  $perm 
    set titel [lindex $ret 1]
    set curDateTitel $titel
    set date0 [lindex $ret 2]
    set tim   [lindex $ret 3]
    set y0    [expr $date0/10000 ]
    set mon0  [expr [expr $date0 /100] % 100 ]
    set day0  [expr $date0 %100 ]
    set h0    [expr $tim /100 ]
    set m0    [expr $tim %100 ]
    set date1 [lindex $ret 4]
    set tim   [lindex $ret 5]
    set y1    [expr $date1 /10000 ]
    set mon1  [expr [expr $date1 /100] % 100 ]
    set day1  [expr $date1 %100 ]
    set h1    [expr $tim /100 ]
    set m1    [expr $tim %100 ]
    set repTyp [lindex $ret 12]
    set noTime [lindex $ret 13]
    set currRefDate [lindex $ret 14]
    set currRefTime [lindex $ret 15]
    set vd_igno  [lindex $ret 16]
    set vd_noRem [lindex $ret 17]

    set room  [lindex $ret 6]
    set details [lindex $ret 7]
    set priv ""
    set seePrivatDate 1
    if { [lindex $ret 9] == 1} { set priv "($_calText(private4Group))   "}
    if { [lindex $ret 8] == 1} { set priv "($_calText(private))   "}
    if { [lindex $ret 8] == 3} { 
	set priv "($_calText(private))   "    
	set seePrivatDate 0
    }
#    puts "[lindex $ret 8] -> $priv $seePrivatDate"
    set part [lindex $ret 10]
    set group [lindex $ret 11]




#Der Toolbar
    set vd_ballon .vd.bal
    tixBalloon $vd_ballon  -initwait 2000 -state balloon

    button .vd.t.b.del -image [image create pixmap -data $vd_deleteDateIcon] -command {
	    set del_did $curr_did
	    checkDelDateDialog
    }
    if { $repTyp !=0 } {
	button .vd.t.b.susp -image [image create pixmap -data $vd_suspendDateIcon] -command {
	    closeWin .vd
	    checkSuspDateDialog $curr_did
	}
#	puts "currRefDate = $currRefDate"
	button .vd.t.b.shift -image [image create pixmap -data $vd_shiftDateIcon]  -command {
	    closeWin .vd
	    shiftDate $curr_did $currDate $currTime $currRefDate $currRefTime
	} 
    }
    button .vd.t.b.edit -image [image create pixmap -data $vd_modifyDateIcon] -command {
	closeWin .vd
	editDate $curr_did }
    pack .vd.t.b.del -side left 
    if {  $repTyp !=0 } {
	pack .vd.t.b.susp -side left -padx 16
	pack .vd.t.b.shift .vd.t.b.edit -side left -padx 2
    } else  {
	pack  .vd.t.b.edit -side left -padx 20
    }
    
#    puts ">>> $vd_igno  $vd_noRem <<<"

    button .vd.t.b.ign -image [image create pixmap -data $ignoreIcon_in] -command {
	if {$vd_igno == 1} {
	    set vd_igno 0
	    .vd.t.b.ign configure -image [image create pixmap -data $ignoreIcon_in]
	} else {
	    set vd_igno 1
	    .vd.t.b.ign configure -image [image create pixmap -data $ignoreIcon_out]
	}
	set ret [transfer ignoreDate $curr_did $username $vd_igno]
	if { $ret != "Error" } {
	    set vd_needReDraw 1
	}
    }
    $vd_ballon bind .vd.t.b.ign -balloonmsg $_ballonText(viewDate_Ignore)
    button .vd.t.b.rem  -image [image create pixmap -data $vd_reminderOnIcon] -command {
	if {$vd_noRem == 1} {
	    set vd_noRem 0
	    .vd.t.b.rem configure  -image [image create pixmap -data $vd_reminderOnIcon]
	} else {
	    set vd_noRem 1
	    .vd.t.b.rem configure -image [image create pixmap -data $vd_reminderOffIcon]
	}
	transfer doNotremind $curr_did $username $vd_noRem
    }
    $vd_ballon bind .vd.t.b.rem -balloonmsg $_ballonText(viewDate_noReminder)
    pack .vd.t.b.ign -side right
    pack .vd.t.b.rem -side right -padx 2

    if { $vd_igno  == 1 } {.vd.t.b.ign configure  -image [image create pixmap -data $ignoreIcon_out]}
    if { $vd_noRem == 1 } {.vd.t.b.rem configure  -image [image create pixmap -data $vd_reminderOffIcon]}

    
#    puts "PERM: $perm -> $curr_perms(dd) !"
    if { $curr_perms(dd) == 0} { 
	.vd.t.b.del configure -state disabled 
	if { $repTyp !=0 } { .vd.t.b.susp configure -state disabled}
    } else {
	if { $repTyp !=0 } {
	    $vd_ballon bind .vd.t.b.del -balloonmsg  $_ballonText(viewDate_DeleteRepAll)
	    $vd_ballon bind .vd.t.b.susp -balloonmsg $_ballonText(viewDate_Susepend)
	} else {
	    $vd_ballon bind .vd.t.b.del -balloonmsg $_ballonText(viewDate_Delete)
	}
    }
    if { $curr_perms(wz) == 0} { 
	.vd.t.b.edit configure -state disabled 
	if { $repTyp !=0 } {	.vd.t.b.shift configure -state disabled}
    } else {
	$vd_ballon bind .vd.t.b.edit -balloonmsg $_ballonText(viewDate_Modify)
	if { $repTyp !=0 } {$vd_ballon bind .vd.t.b.shift -balloonmsg $_ballonText(viewDate_Shift) }
    }

 #   puts "->     $curr_perms(r) $curr_perms(rz) $seePrivatDate"
    if { $curr_perms(r)==1 } {
	if { $seePrivatDate == 0} {
	    label .vd.t.b.t -justify center  -text $titel -font $bifnt -anchor n  -width 108 -relief sunken -bd 1
	} else { 
	    label .vd.t.b.t -justify center  -text $titel -font $bfnt -anchor n  -width 108 -relief sunken -bd 1
	}
    } else {
	if { $seePrivatDate == 0} {
	    label .vd.t.b.t -justify center  -text $titel -font $bifnt -anchor n  -width 108 -relief sunken -bd 1
	} else { 
	    label .vd.t.b.t -justify center  -text $_calText(HiddenTitle) -font $bifnt -anchor n  -width 108 -relief sunken -bd 1
	}
    }
    pack .vd.t.b.t -side right


    frame .vd.t.2.1
    frame .vd.t.2.2
    pack  .vd.t.2.1  .vd.t.2.2 -side top -fill x -pady 2

    label .vd.t.2.1.l -text "$_calText(Zeit)  : " -font $bfnt
    if { $curr_perms(rz) == 1} {
	if { $date0 == $date1 } {
	    if { $noTime == 0 } {
		set txt [format "%10s, %2d:%02d %s  %2d:%02d" \
			     [date2LongStr $day0 $mon0 $y0] $h0 $m0 \
			     $_calText(bis)  $h1 $m1 ]
	    } else { 
		set txt [format "%10s" [date2LongStr $day0 $mon0 $y0] ]
	    }
	} else { 
	    if { $noTime == 0 } {
		set txt [format "%10s, %2d:%02d %s %10s, %2d:%02d" \
			     [date2LongStr $day0 $mon0 $y0] $h0 $m0 \
			     $_calText(bis) [date2LongStr $day1 $mon1 $y1] $h1 $m1 ]
	    } else { 
		set txt [format "%10s %s %10s" \
			     [date2LongStr $day0 $mon0 $y0] \
			     $_calText(bis) [date2LongStr $day1 $mon1 $y1]]
	    }
	}
	if { $repTyp == 0} {  set txt "$txt ([lindex $eddv_repTypStr $repTyp])" }
	label .vd.t.2.1.t -font $fnt -text $txt
    } else { 
	label .vd.t.2.1.t -text "" -font $fnt
    }
    label .vd.t.2.1.g -font $fnt -text $priv
    pack .vd.t.2.1.l  .vd.t.2.1.t -side left 
    pack .vd.t.2.1.g -side right

    label .vd.t.2.2.l -text "$_allgText(Ort)   : " -font $bfnt
    if { $curr_perms(rz) == 1} {
	label .vd.t.2.2.t -font $fnt -text $room
    } else {
	label .vd.t.2.2.t -text "" -font $fnt
    }
    label .vd.t.2.2.lg -text "$_allgText(Gruppe) : " -font $bfnt 
    if { $curr_perms(rt) == 1} {
	label .vd.t.2.2.tg -font $fnt -text $group -width 16 -justify right -anchor e
    } else {
	label .vd.t.2.2.tg -text "" -font $fnt -width 16 -justify right -anchor e
    }
    label .vd.t.2.2.spc -text "   " 
    pack .vd.t.2.2.l  .vd.t.2.2.t  -side left 
    pack  .vd.t.2.2.spc .vd.t.2.2.tg  .vd.t.2.2.lg -side right 


    frame .vd.t.4.l -relief raised -bd 1
    frame .vd.t.4.r -relief raised -bd 1
    pack .vd.t.4.l .vd.t.4.r -side left -fill x -padx 2 -pady 2
    frame .vd.t.4.l.l 
    frame .vd.t.4.l.t
    pack .vd.t.4.l.l .vd.t.4.l.t -side top -fill x
    label .vd.t.4.l.l.l -text "$_calText(Details):" -font $bfnt
    tixScrolledText .vd.t.4.l.t.t  -width 256 -height 128
    .vd.t.4.l.t.t subwidget text configure -font $fnt12
    .vd.t.4.l.t.t subwidget text configure -wrap word
    .vd.t.4.l.t.t subwidget vsb configure -width 12
    .vd.t.4.l.t.t subwidget hsb configure -width 12
    pack  .vd.t.4.l.l.l .vd.t.4.l.t.t  -side left
    .vd.t.4.l.t.t subwidget text delete 0.0 end
    if { $curr_perms(r) == 1} {
	.vd.t.4.l.t.t subwidget text insert end $details
    }
    .vd.t.4.l.t.t subwidget text configure -state disabled
    

    

    frame .vd.t.4.r.l 
    frame .vd.t.4.r.t
    pack .vd.t.4.r.l .vd.t.4.r.t -side top -fill x

    set scan .vd.t.4.r.t.t
    label .vd.t.4.r.l.l -text "$_calText(Teilnehmer):" -font $bfnt -anchor nw 
    label .vd.t.4.r.l.r -text "$_calText(Status) " -font $bifnt -anchor nw 
    tixCObjView  $scan -width 272 -height 128 -scrollbar "auto -x"
    $scan subwidget vsb configure -width 12
    $scan subwidget hsb configure -width 12
    pack .vd.t.4.r.l.l  $scan -side left
    pack .vd.t.4.r.l.r -side right

    set vdCan [$scan subwidget canvas]
    
    set y 3
    set dy 15
    set meListed 0

    set vdStatusPopWin .vd.pu
    tixPopupMenu $vdStatusPopWin -title "$_calText(Status):" -spring false
    set anz [ llength $partStatus]
    for { set i 1 } { $i <$anz } {incr i} {
	$vdStatusPopWin subwidget menu add command -label [lindex $partStatusStr $i] -command {vdSetPartStatus %W}
	$vdStatusPopWin subwidget menu entryconfigure  [lindex $partStatusStr $i] -command "vdSetPartStatus $i"
    }

    foreach val $part {
	set type  [ lindex $val 0]
	set name  [ lindex $val 1]
	set stat  [ lindex $val 2]
	set ugType [ lindex $val 3]


#	puts "VD: PERM=$curr_perms(rt) // '$name' != '$fullUsername' ? "
	if {$curr_perms(rt)== 0 && $name != $fullUsername } {
	    continue 
	}
	if { $name == $fullUsername } { set meListed 1}
	
	if {$ugType == "g"} { 
	    set uname $name
	    set name "Gruppe $name"
	}
	if {$ugType == "u"} { 
	    set uname [ lindex $userList [ lsearch $fullUserNameList $name] ]
	}
	
	set y2 $y
	switch $type {
	    I {	$vdCan create text 8 $y2 -text " I " -anchor n -justify center -fill red -font $bfnt12}
	    E {	$vdCan create text 9 $y2 -text " E " -anchor n -justify center -fill DarkOrange -font $bfnt12}
	    T {	$vdCan create text 8 $y2 -text " T " -anchor n -justify center -fill green4 -font $bfnt12}
	    A {	$vdCan create text 8 $y2 -text " A " -anchor n -justify center -fill blue2 -font $bfnt12} 
	    i {	$vdCan create text 8 $y2 -text " i " -anchor n -justify center -fill black -font $bfnt12} 
	    * {	$vdCan create text 8 $y2 -text " T " -anchor n -justify center -fill green3 -font $bfnt12} 
	}
	set tag "stat-$ugType-$uname"
	$vdCan create text 16 $y -text $name -anchor nw -font $fnt12 -tag $tag
	$vdCan create text 268 $y -text [ lindex $partStatusStr $stat] -justify right -anchor ne -font $fnt12 -tag $tag
	if { $meListed ==1 || $curr_perms(wt) == 1} {
	    $vdCan bind $tag <Button> {statusPopup  $vdCan %x %y }
#	    puts "binding on tag /$tag/"
	}
	incr y $dy
    }
    $vd_ballon bind $vdCan -balloonmsg $_ballonText(viewDate_SetStatus)  
	
    
    button .vd.b.close -text " $_buttonText(Close) " -command {
	closeWin .vd
	set eddLock 0
	if { $vd_needReDraw == 1} {drawCal}
    }
#    puts "pack close"
    pack  .vd.b.close -side right
#    puts "done"
 
    if { $curr_perms(r)==1 } {
	wm title .vd [format "$_calText(Termin): %s" $titel ]
    }
    centerWin .vd 558 298 
    grab .vd 
    update
    stdCursor .vd
}
proc statusPopup {cwin x y} {
    global vdStatusPopWin vdCan vd_popupTag
    set list [ $cwin gettags [ $cwin find closest $x $y]]
    set id [lsearch  -glob $list stat-* ]
    set vd_popupTag [ lindex $list $id]
#    puts "$x/$y -> '$list' -> '$id' ->'$vd_popupTag'"
    $vdStatusPopWin post $cwin  $x $y
}
    
proc vdSetPartStatus {status} {
    global vdCan currUser vd_popupTag partStatusStr currRefDate currRefTime curr_did

    set list  [split $vd_popupTag -]
    set uname [lindex  $list 2]
    set ug  [lindex  $list 1]
    transfer changeStatus $curr_did $currRefDate $currRefTime $uname $status $ug
    $vdCan itemconfigure $vd_popupTag -text [ lindex $partStatusStr $status]
}

proc checkDelDateDialog { } {
    global curDateTitel
    global bfnt  eddLock _calText _buttonText

    if { [winfo exists .cdd ] == 1 } { return }
    toplevel .cdd
    frame .cdd.t -relief raised -bd 1
    frame .cdd.b 
    pack .cdd.t  -side top -fill x
    pack .cdd.b -side top -fill x -pady 3

    label .cdd.t.1 -text $_calText(delDate1) -font $bfnt -justify center -anchor n
    label .cdd.t.2 -text "\"$curDateTitel\""  -font $bfnt -justify center -anchor n
    label .cdd.t.3 -text $_calText(delDate2)  -font $bfnt -justify center -anchor n
    pack .cdd.t.1 .cdd.t.2 .cdd.t.3 -side top -fill x
    
    button .cdd.b.abb -text "   $_buttonText(no)   "   -font $bfnt -command {
	closeWin .cdd
    }
    pack .cdd.b.abb -side right
    button .cdd.b.del -text " $_buttonText(yes) "  -font $bfnt -command {
	closeWin  .cdd
	closeWin .vd
	doDeleteDate
	set eddLock 0
    }
    pack .cdd.b.del -side left
    centerWin .cdd 320 100
    update
    grab .cdd

}
proc checkSuspDateDialog { did } {
    global curDateTitel
    global bfnt  eddLock fnt
    global del_tag del_did
    global dateByTag timeByTag
    global shiftNotify _calText _buttonText

    set shiftNotify "__"

    set del_did $did
    if { [winfo exists .cdd ] == 1 } { return }
    toplevel .cdd
    frame .cdd.t -relief raised -bd 1
    frame .cdd.b 
    pack .cdd.t  -side top -fill x -expand 1
    pack .cdd.b -side top -fill x -pady 3

    label .cdd.t.1 -text $_calText(suspendDate1) -font $bfnt -justify center -anchor n
    label .cdd.t.2 -text "\"$curDateTitel\""  -font $bfnt -justify center -anchor n
    label .cdd.t.3 -text [format "$_calText(am) %s $_calText(am) %s" [date2Str $dateByTag($del_tag)] [time2Str $timeByTag($del_tag)]  ] \
	-font $bfnt -justify center -anchor n
    label .cdd.t.4 -text $_calText(suspendDate2)  -font $bfnt -justify center -anchor n
    frame .cdd.t.5
    pack .cdd.t.1 .cdd.t.2 .cdd.t.3 .cdd.t.4 -side top -fill x -expand 1 -padx 4 -pady 2
    pack .cdd.t.5 -side top -fill x -padx 4 -pady 4

    frame .cdd.t.5.1
    frame .cdd.t.5.2
    pack .cdd.t.5.1 .cdd.t.5.2 -side top -fill x

    label .cdd.t.5.1.l  -text $_calText(sendAnn) -font $fnt -justify left -anchor nw
    label .cdd.t.5.2.l -text "  " -width 4 -font $fnt -justify left -anchor nw
    radiobutton .cdd.t.5.2.a -text $_calText(partAll) -value "__all" -variable shiftNotify  -font $fnt
    radiobutton .cdd.t.5.2.i -text $_calText(partInternal) -value "__int" -variable shiftNotify  -font $fnt
    radiobutton .cdd.t.5.2.e -text $_calText(partExternal) -value "__ext" -variable shiftNotify  -font $fnt
    radiobutton .cdd.t.5.2.n -text $_calText(partNoone) -value "__" -variable shiftNotify  -font $fnt
    pack .cdd.t.5.2.l .cdd.t.5.1.l .cdd.t.5.2.a .cdd.t.5.2.i .cdd.t.5.2.e .cdd.t.5.2.n -side left -fill x 

    button .cdd.b.abb -text "   $_buttonText(no)   "   -font $bfnt -command {
	closeWin .cdd
    }
    pack .cdd.b.abb -side right
    button .cdd.b.del -text " $_buttonText(yes) "  -font $bfnt -command {
	closeWin  .cdd
	closeWin .vd
	doSuspendDate
	set eddLock 0
    }
    pack .cdd.b.del -side left
    centerWin .cdd 480 180
    update
#    puts [wm geometry .cdd]
    grab .cdd

}

proc doSuspendDate {  } {
    global del_did username del_tag
    global currRefDate currRefTime shiftNotify
    

   #    puts "request suspendDate $del_did $username $currRefDate $currRefTime"
    set ret [request suspendDate $del_did $username $currRefDate $currRefTime $shiftNotify ]
    if { $ret == "Error" } { return
	closeWin .dd
    }

#     if { [string first $ret "ServerDown"] >=0 } {ServerDownDialog}
#     if { [string range $ret 0 2] =="ERR"} {
# 	ErrorDialog [string range $ret 3 end]
#     } else {
	drawUsersCalendar
#     }
    closeWin .dd
}


proc shiftDate { did date tim rdate rtim} {
    global shiftTitel
    global shiftStartDay shiftStartMon shiftStartYear shiftStartHour shiftStartMin
    global shiftStopDay shiftStopMon shiftStopYear shiftStopHour shiftStopMin
    global shiftRoom shiftAddDet shiftRefDate shiftRefTime shiftDid
    global shiftNotify
    global roomList
    global sdo_startDy sdo_startDm sdo_startDd sdo_startTh sdo_startTm 
    global sdo_stopDy sdo_stopDm sdo_stopDd sdo_stopTh sdo_stopTm 
    global sdo_room
    global fnt bfnt fnt12 bfnt12 pfnt
    global dateByTag timeByTag
    global _calText _buttonText _allgText _dateOrder
    
    set shiftDid $did
    set shiftRefDate $rdate
    set shiftRefTime $rtim
    set shiftNotify "__"

    set ret [request shiftDateInfo  $did $rdate $rtim ]
    if { $ret == "Error" } { return }
    set shiftTitel     [lindex $ret 0]
    set dlist           [date2list [lindex $ret 1]]
    set shiftStartDay  [lindex $dlist 0]
    set shiftStartMon  [lindex $dlist 1]
    set shiftStartYear [lindex $dlist 2]
    set shiftStartHour [expr [lindex $ret 2] /100 ]
    set shiftStartMin  [expr [lindex $ret 2] %100 ]
    set dlist          [date2list [lindex $ret 3]]
    set shiftStopDay   [lindex $dlist 0]
    set shiftStopMon   [lindex $dlist 1]
    set shiftStopYear  [lindex $dlist 2]
    set shiftStopHour  [expr [lindex $ret 4] /100 ]
    set shiftStopMin   [expr [lindex $ret 4] %100 ]
    set shiftRoom      [lindex $ret 5]
    set shiftAddDet    [lindex $ret 6]

    if { [winfo exists .sd ] == 1 } { return }
    toplevel .sd


    frame .sd.t -relief raised -bd 1
    frame .sd.b
    pack .sd.t .sd.b -side top -fill x

    frame .sd.t.d -relief ridge -bd 2
    frame .sd.t.r -relief ridge -bd 2
    frame .sd.t.c -relief ridge -bd 2
    frame .sd.t.n  -relief ridge -bd 2
    pack .sd.t.d  .sd.t.r  .sd.t.c .sd.t.n -side top -fill x

  
    frame .sd.t.d.1
    frame .sd.t.d.2
    frame .sd.t.d.3
    pack .sd.t.d.1 .sd.t.d.2 .sd.t.d.3 -side top -fill x

    label .sd.t.d.1.l -text $_calText(shiftDateTime) -font $bfnt12
    pack .sd.t.d.1.l -side left

    set sdo_startDy .sd.t.d.2.dy
    set sdo_startDm .sd.t.d.2.dm
    set sdo_startDd .sd.t.d.2.dd
    set sdo_startTh .sd.t.d.2.th
    set sdo_startTm .sd.t.d.2.tm

    label .sd.t.d.2.l0 -text $_calText(Beginn) -width 12 -font $bfnt
    tixControl $sdo_startDd -min 0 -max 31 -integer 1 -labelside right -label $_allgText(dateSep)\
	-options {  entry.width 2 label.width 2 } -selectmode immediate -autorepeat true -variable shiftStartDay
    tixControl $sdo_startDm -options { entry.width 2 label.width 2} -labelside right  -label $_allgText(dateSep)  -min 0 -max 12 -integer 1 -validatecmd adoptMaxShiftStartDay  -selectmode immediate -autorepeat true -variable shiftStartMon
    tixControl $sdo_startDy -options { entry.width 4}  -min 1999 -max 2100 -integer 1  -selectmode immediate -autorepeat true -variable shiftStartYear
    tixControl $sdo_startTh -options { entry.width 2} -label "    -    "  -min 0 -max 23 -integer 1  -selectmode immediate -autorepeat true -variable shiftStartHour
    tixControl $sdo_startTm -options { entry.width 2} -label ":"  -min 0 -max 59 -integer 1  -selectmode immediate -autorepeat true -variable shiftStartMin
    label .sd.t.d.2.l -text " " -width 1 -font $bfnt
    if {$_dateOrder == "de" } {
	pack  .sd.t.d.2.l0 $sdo_startDd $sdo_startDm $sdo_startDy $sdo_startTh $sdo_startTm .sd.t.d.2.l -side left
    } else {
	pack  .sd.t.d.2.l0 $sdo_startDm $sdo_startDd $sdo_startDy $sdo_startTh $sdo_startTm .sd.t.d.2.l -side left
    }
    set sdo_stopDy .sd.t.d.3.dy
    set sdo_stopDm .sd.t.d.3.dm
    set sdo_stopDd .sd.t.d.3.dd
    set sdo_stopTh .sd.t.d.3.th
    set sdo_stopTm .sd.t.d.3.tm
    label .sd.t.d.3.l0 -text $_calText(Ende) -width 12 -font $bfnt
    tixControl $sdo_stopDd -min 0 -max 31 -integer 1 -labelside right -label $_allgText(dateSep)\
	-options {  entry.width 2 label.width 2 } -selectmode immediate -autorepeat true -variable shiftStopDay
    tixControl $sdo_stopDm -options { entry.width 2 label.width 2} -labelside right  -label $_allgText(dateSep)  -min 0 -max 12 -integer 1 -validatecmd adoptMaxShiftStopDay  -selectmode immediate -autorepeat true -variable shiftStopMon
    tixControl $sdo_stopDy -options { entry.width 4} -min 1999 -max 2100 -integer 1  -selectmode immediate -autorepeat true -variable shiftStopYear
    tixControl $sdo_stopTh -options { entry.width 2} -label "    -    "  -min 0 -max 23 -integer 1  -selectmode immediate -autorepeat true -variable shiftStopHour
    tixControl $sdo_stopTm -options { entry.width 2} -label ":" -min 0 -max 59 -integer 1 -selectmode immediate -autorepeat true -variable shiftStopMin
    label .sd.t.d.3.l -text " " -width 1 -font $bfnt
    if {$_dateOrder == "de" } {
	pack  .sd.t.d.3.l0 $sdo_stopDd $sdo_stopDm $sdo_stopDy $sdo_stopTh $sdo_stopTm .sd.t.d.3.l -side left
    } else {
	pack  .sd.t.d.3.l0 $sdo_stopDm $sdo_stopDd $sdo_stopDy $sdo_stopTh $sdo_stopTm .sd.t.d.3.l -side left
    }

    set datelem "$sdo_stopDd $sdo_stopDm $sdo_stopDy $sdo_stopTh $sdo_stopTm $sdo_startDd $sdo_startDm $sdo_startDy $sdo_startTh $sdo_startTm"
    foreach w $datelem {
	$w subwidget entry configure  -font $pfnt
	$w subwidget label configure  -font $bfnt
    }
	     
	     
    frame .sd.t.r.1
    frame .sd.t.r.2
    pack .sd.t.r.1 .sd.t.r.2 -side top -fill x

    label .sd.t.r.1.l -text $_calText(shiftDateRoom) -font $bfnt12
    pack .sd.t.r.1.l -side left
    
    set sdo_room .sd.t.r.2.m
    tixOptionMenu $sdo_room  -options {menubutton.width 14 label.width 18 } -label $_allgText(Ort)
    $sdo_room subwidget label configure -font $bfnt
    $sdo_room subwidget menubutton configure  -font $bfnt12
    pack   $sdo_room -side left 
    foreach room $roomList { $sdo_room add command $room -label $room }
    $sdo_room configure  -variable shiftRoom

    frame .sd.t.c.1
    frame .sd.t.c.2
    pack .sd.t.c.1 .sd.t.c.2 -side top -fill x
    
    label .sd.t.c.1.l -text "$_calText(shiftDateDetails):" -font $bfnt12
    pack .sd.t.c.1.l -side left -fill x
    text  .sd.t.c.2.t  -width 50 -height 4
    .sd.t.c.2.t insert 0.0 $shiftAddDet
    pack .sd.t.c.2.t -side left -fill x

    frame .sd.t.n.1
    frame .sd.t.n.2
    pack .sd.t.n.1 .sd.t.n.2 -side top -fill x

    label .sd.t.n.1.l  -text $_calText(sendAnn) -font $fnt -justify left -anchor nw
    label .sd.t.n.2.l -text "  " -width 4 -font $fnt -justify left -anchor nw
    radiobutton .sd.t.n.2.a -text $_calText(partAll) -value "__all" -variable shiftNotify  -font $fnt
    radiobutton .sd.t.n.2.i -text $_calText(partInternal) -value "__int" -variable shiftNotify  -font $fnt
    radiobutton .sd.t.n.2.e -text $_calText(partExternal) -value "__ext" -variable shiftNotify  -font $fnt
    radiobutton .sd.t.n.2.n -text $_calText(partNoone) -value "__" -variable shiftNotify  -font $fnt
    pack .sd.t.n.2.l .sd.t.n.1.l .sd.t.n.2.a .sd.t.n.2.i .sd.t.n.2.e .sd.t.n.2.n -side left -fill x 

    button .sd.b.abb -text "$_buttonText(Cancel)" -command {closeWin .sd}
    pack .sd.b.abb -side left

    button .sd.b.ok -text "$_calText(butShift)" -command sendShiftDate
    pack .sd.b.ok -side right

    wm title .sd "$_calText(wmTitelShiftDate1) '$shiftTitel' $_calText(wmTitelShiftDate2)"
    grab .sd
    centerWin .sd 415 290
    update
#     puts [wm geometry .sd ]
   
}
proc adoptMaxShiftStartDay { mon } {
    global sdo_startDd monlen

    $sdo_startDd configure -max [ lindex monlen  $mon ]
    return $mon
}
proc adoptMaxShiftStopDay { mon } {
    global sdo_stopDd monlen

    $sdo_stopDd configure -max [ lindex monlen  $mon ]
    return $mon
}
proc sendShiftDate { } {
    global shiftStartDay shiftStartMon shiftStartYear shiftStartHour shiftStartMin
    global shiftStopDay shiftStopMon shiftStopYear shiftStopHour shiftStopMin
    global shiftRoom shiftAddDet shiftRefDate shiftRefTime shiftDid
    global shiftNotify
    

    set shiftAddDet [string trim [ .sd.t.c.2.t get 0.0 end] ]
    if { [string length $shiftAddDet] == 0 }  { set shiftAddDet "___"}

    set ret [transfer shiftDate $shiftDid $shiftRefDate $shiftRefTime \
		 [format "%04d%02d%02d" $shiftStartYear $shiftStartMon $shiftStartDay]\
		 [format "%2d%02d" $shiftStartHour $shiftStartMin ] \
		 [format "%04d%02d%02d" $shiftStopYear $shiftStopMon $shiftStopDay]\
		 [format "%2d%02d" $shiftStopHour $shiftStopMin ] \
		 $shiftRoom $shiftAddDet $shiftNotify]
    if { $ret != "Error" } {
	drawUsersCalendar
    }
    closeWin .sd    
}

