#!/usr/bin/X11/tixwish
#  File: wochenView.tcl
# 
#      This file is part of minkowsky
# 
#      Copyright (C) 2001-2002 by Rdiger Goetz
#      Author: Rdiger Goetz <minkowsky@r-goetz.de>
# 
#      Time-stamp: <28-May-2002 19:00:47 goetz>
# 
#      This program is free software; you can redistribute it and/or modify
#      it under the terms of the GNU General Public License as published by
#      the Free Software Foundation; either version 2 of the License, or
#      (at your option) any later version.
# 
#      This program is distributed in the hope that it will be useful,
#      but WITHOUT ANY WARRANTY; without even the implied warranty of
#      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#      GNU General Public License for more details.
# 
#      You should have received a copy of the GNU General Public License
#      along with this program; if not, write to the Free Software
#      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#  




proc switch2CalTyp { typ} {
    global calTyp
    
    set calTyp $typ
    drawCal
}

proc jump2Today { } {
    global calTyp today thisWeekStartD thisWeekStartM thisWeekStartY tday tmon tyear
    global curDay curMon curYear
    
    switch  $calTyp  {
	d {
	    set curDay  $tday
	    set curMon  $tmon
	    set curYear $tyear
	}
	w {
	    set curDay  $thisWeekStartD
	    set curMon  $thisWeekStartM
	    set curYear $thisWeekStartY
	}
	m {
	    set curDay  $tday
	    set curMon  $tmon
	    set curYear $tyear
	}
    }
    drawCal
}

proc jump2DateDialog { } {
    global curDay curMon curYear
    displayYearCal $curDay $curMon $curYear
}

proc jump2Date { } {
    global curDay curMon curYear curOffset calTyp
    global sDay sMon sYear

    closeWin .j2d

    set curDay  $sDay
    set curMon  $sMon
    set curYear $sYear

    if { $calTyp == "w" } {
	set shift  [ weekDayByDate $sDay $sMon $sYear]
	
	set ret [calcDate $sDay $sMon $sYear [expr -1* $shift]]
	
	set curDay  [lindex $ret 0]
	set curMon  [lindex $ret 1]
	set curYear [lindex $ret 2]
    }
    drawCal
}

proc calUserList2NameList { calList } {
    global fullUserNames
    
    set who ""
    foreach ent $calList {
 	if { $who == "" } {
 	    set who $fullUserNames($ent)
 	} else {
 	    set who "$who, $fullUserNames($ent)"
 	}
    }
    return $who
}
proc calUserList2UnameList { calList } {
    global fullUserNames
    
    set who ""
    foreach ent $calList {
 	if { $who == "" } {
 	    set who $fullUserNames($ent)
 	} else {
 	    set who "$who, $fullUserNames($ent)"
 	}
    }
    return $who
}

proc drawCal { } { #proc
    global calTyp groupByUsers canParent cur_Cal  groupList calDrawn can hbfnt xmax ysmax ymax
    global groupWeekView yOffAnz dateTagKO yScrollOn  calAllDayList usersByGroup fullUserNames
    global can canParent calUserName
    global gridTagKOList calAnz
    global requestCal
    global _calText

     set groupWeekView 0
     $can delete all

     switch  $calTyp  { 
 	d {
 	    set calUserName(0) [calUserList2NameList $cur_Cal]
 	    set requestCal $cur_Cal
 	    set gridTagKOList ""
 	    set calAllDayList ""
 	    drawDayGrid
 	    setTagList 1 [llength $gridTagKOList]  [join $gridTagKOList]
 	    drawUsersCalendar
 	}
	w { # W
	    set gridTagKOList ""
#	    set calUserName(0) [calUserList2NameList $cur_Cal]
	    set calUserName(0) $cur_Cal
	    if { $groupByUsers == 1 } {
		set groupWeekView 1

		set list "" 
		foreach usr $cur_Cal {
		    if { [string range $usr 0 0 ] == "g" } {
			set group [string range $usr 2 end]
			set users $usersByGroup($group)
#			if { [string first $users "ServerDown"] >=0 } {ServerDownDialog}
			foreach usr2 $users {
			    lappend list "u-$usr2"
			}
		    } else {
			lappend list $usr
		    }
		}
		set requestCal "$list"
		if { [llength $list ] >1 } {
		    set yScrollOn 1
		    $canParent configure -scrollbar y
		}

		if { $calDrawn == 1 } {
		    $can delete all
		}
		set i 0
		set dateTagKO ""
		set calAllDayList ""
		set calAnz 0
		#Doubletten lschen
		set list [lsort -ascii $list]
		set lastUser ""
		foreach user $list {
		    if { $lastUser != $user } {
			drawWeekGroupGrid $i $fullUserNames($user)
			addUsersCalendar  $user
#			set calUserName($i)  $fullUserNames($user)
			set calUserName($i)  $user
			incr i
			set lastUser $user
		    }
		}
		set dateTagKO [lsort $dateTagKO]
		setTagList 0 [llength $dateTagKO] [join $dateTagKO]


		set yOffAnz $i
		if { [llength $cur_Cal] ==  1 } {
		    $can create text [expr $xmax /2] 4 -text "$_calText(CalOfGroup) $fullUserNames([lindex $cur_Cal 0])" -font $hbfnt -anchor n
		} else {
		    $can create text [expr $xmax /2] 4 -text $_calText(CalOfSets) -font $hbfnt -anchor n
		}
		$canParent adjustscrollregion
#		set cur_Cal $keep_cur_Cal
#FIXME
#		setCurCalMenuTitel
		set calDrawn 1
		redrawMainCanvas
		_drawCurrentTime
	    } else {
		set requestCal $cur_Cal
		set calAllDayList ""
		drawWeekGrid
		drawUsersCalendar
	    }
	    setTagList 1 [llength $gridTagKOList]  [join $gridTagKOList]
	}
 	m { 
# 	    set calUserName(0) [calUserList2NameList $cur_Cal]
 	    set calUserName(0)  $cur_Cal
 	    set requestCal $cur_Cal
 	    set gridTagKOList ""
 	    set calAllDayList ""
 	    drawMonGrid
 	    drawUsersCalendar
 	    setTagList 1 [llength $gridTagKOList] [join $gridTagKOList]
 	}
     }
     $canParent adjustscrollregion
}



# 
# Indizes: 
#          cid= calNr-ZeilenNr
#         lcid= calNr-ZielenNr-TagesNr
# 
# 
# Variable, die von cid abhgen
#         
#         yday0       : Oberkante des Kopfbereiches
#         yday1       : Oberkante des Kalenders
#         yday2       : Oberkante des eigentlichen Kalenders (ohne ganztgge Termine)
#         yTitelType  : Werte 'full' oder 'small', gibt an ob ein- oder zweizeile Spaltentitel verwendet werden
#         calStart    : Stunde zu der der Kalender beginnt (i.d.r  =0 ausser bei gesplitteten Kalendern)
#         calEnd      : Stunde zu der der Kalender endet (i.d.r  =24  ausser bei gesplitteten Kalendern)
#         calDayList  : Liste aller lcids zu einer cid
#         xLeftLegend : Linke X-koordinate der linken Zeitleiste
#         xRightLegend: Linke X-koordinate der rechten Zeitleiste
#         
#         
# Variable, die von lcid abhgen
#         
#         xday        : linke Kante des Tages
#         calDayStr   : String des Tages
#         calDay   \ 
#         calMon    | : zusammen das Dartum des Tages 
#         calYear  /
#         calWD       : Index des Wochentages des Tages
#         calSplitOffset : Offset im zweiten Teil eines gesplitteten Kalenders
#         
# Varibalen die vin calNr abhngen
#
#         calLineList : Liste mit allen cids
#         calUserName : name des Users des Calendes
#
# Variablen, die keine Arrays sind
#         dxd         : Breite eine Tages
#         dxs         : Breite der Zeitleiste
#         dyh         : Hhe einer Stunde
#         dyCal       : Hhe des Kalenders unter der Titelzeile
#         hourModulo  : Scrittweite der Stundenanzeige in der Zeitleiste
#         calHourLineStep : Zahl der Stunden pro Linie im Kalender
#         calLineAnz 
#         calJumpMode : w oder m je nachdem ob Monatskalender (m) oder nicht
#         calStrList    : Liste mit allen Tagesstrings in der Reiehnfolge
#         calAllDayList : Liste mit Listen, die die Zeilen und Tages indezied enyhalten,
#                               in derselben Reiehenfolge wie calStrList
#         calAllDayList2: wie calAllDayList, aber fr den zweiten Teil eine gesplitteten Kalenders
#         calNr       : Nummer des aktuellen Kalenders
#         calKernStart : Beginn der Kernzeit
#         calKernEnd   : End der Kernzeit
#         calKernLen  : Lnge der Kernzeit
#         calSplitHour : Stunde zu der der Kalender gesplittet wird
#         calAnz      :Anzahl der Kalender    
#         calGlobalSlots : Zahl der "Stunden" die fr ganztages Termine reserviert sind.

proc drawDayGrid {  } {
    global dyh dxd dxb dxs dyt wdList xday xday2 yday yday2 calDay calMon calYear calWD calDayCount
    global weekDays monlen monAbk
    global curDay curMon curYear curOffset 
    global yOffset xmax xmx ymax xbl xbr dyCal yOffList yOffList2 yOffAnz hourModulo yScrollOn
    global calKernStart calKernEnd calSplitHour calKernLen calGlobalSlots
    global xLeftLegend xRightLegend xLeftLegend2 xRightLegend2 yLegend yLegend2 legendAnz
    global xday yday0 yday1 yday2 calDay calMon calYear calWD calStart calEnd calDayList yTitelType calLineAnz
    global calNr calDayStr calHourLineStep calLineList calJumpMode calAllDayList calAllDayList2 calStrList
    global calSplitOffset calUserName calAnz
    global uCalKernStart uCalKernEnd uGlobalSlotsD


     set day    $curDay
     set mon    $curMon
     set year   $curYear
#     set offset $curOffset
    set offset  [weekDayByDate $day $mon $year]

    set calKernStart $uCalKernStart
    set calKernEnd $uCalKernEnd
    set calKernLen [expr $calKernEnd -$calKernStart]
    set calGlobalSlots $uGlobalSlotsD

    set wdList ""
    set calDayCount 1
    set dyh 18

    set xmx [ expr $xmax - $yScrollOn *12 ]
    set dxd [ expr int(floor((double($xmx)/2.-84-8)))]
    set dxs [expr ($xmx/2 -$dxd-8)/2 ]

    set xoffset [expr ($xmx/2)+7]

    set xbl [expr $dxs -1]
    set xbr [expr $xbl + $calDayCount *$dxd ]
    set dxb 20
    set dyt 32
    set yOffset 0
    set yOffAnz 1
    set hourModulo 1



    set slots [expr 24+($calKernEnd-$calKernStart)+$calGlobalSlots ]
    if { [ expr $slots %2] == 1} {
	incr slots
	incr calGlobalSlots
    }
    set k1slots [expr $slots/2 - $calGlobalSlots - $calKernStart ]
    if { $k1slots < [expr 2* $calKernLen ]} {
	if { [ expr $k1slots %2] == 1 } {
	    incr k1slots -1
	    incr slots 2
	    incr calGlobalSlots 2
	}
	set calSplitHour [expr $calKernStart + $k1slots/2]
    } else {
	set calSplitHour [expr $calKernEnd + ($k1slots -2*$calKernLen) ]
    }

    set dyh [ expr int (floor(2*(double($ymax)-$dyt)/$slots))]
    set dyCal [ expr $slots/2 * $dyh]

    set wdList ""
    set calDayCount 1

    set hourModulo 1
    set calHourLineStep 1
    set calLineAnz 1
    set legendAnz 1
    set calJumpMode "w"
    set calStrList ""

    set cid "0-0"
    set lcid "0-0-0"
    set yday0($cid) 0
    set yday1($cid) $dyt
    set yday2($cid) [expr $dyt +$calGlobalSlots *$dyh]
    set yTitelType($cid) "full"
    set calStart($cid) 0
    set calEnd($cid) 12
    set calDayList($cid) ""
    set xday($lcid) $dxs
    set dstr [format "%4d%02d%02d" $year $mon $day ] 
    lappend calStrList $dstr
    set calDayStr($lcid) $dstr
    set calDay($lcid)  $day
    set calMon($lcid)  $mon
    set calYear($lcid) $year
    set calWD($lcid)   [expr $offset % 7 ]
    lappend calDayList($cid) $lcid
    lappend calAllDayList "0 0"
    set xLeftLegend($cid)   [expr $xday(0-0-0) -$dxs]
    set xRightLegend($cid)  [expr $xday(0-0-0) + $dxd ]
    set calSplitOffset($lcid) 0

    set cid "0-1"
    set lcid "0-1-0"
    set yday0($cid) 0
    set yday1($cid) $dyt
    set yday2($cid) $dyt
    set yTitelType($cid) "full"
    set calStart($cid) 12
    set calEnd($cid) 24
    set calDayList($cid) ""
    set xday($lcid) [ expr $dxs+ $xoffset ]
    set dstr [format "%4d%02d%02d" $year $mon $day ] 
    set calDayStr($lcid) $dstr
    set calDay($lcid)  $day
    set calMon($lcid)  $mon
    set calYear($lcid) $year
    set calWD($lcid)   [expr $offset % 7 ]
    lappend calDayList($cid) $lcid
    lappend calAllDayList2 "1 0"
    set xLeftLegend($cid)   [expr $xday(0-1-0) -$dxs]
    set xRightLegend($cid)  [expr $xday(0-1-0) + $dxd ]
#    set calSplitOffset($lcid) [expr ($slots1 - $calGlobalSlots)  *$dyh]
    set calSplitOffset($lcid) [expr ($slots/2 - $calGlobalSlots) *$dyh]

    set calNr 0
    set calLineList(0) " 0-0 0-1"
    set calAnz 1

    set yOffList(0) $yday2(0-0)
    set yOffList2(0) $yday1(0-0)


#    puts "calSplitHour=$calSplitHour $calGlobalSlots $calSplitOffset($lcid) $dyh $dyCal"
    drawCalGrid 
}


proc drawWeekGrid {  } {
    global dyh dxd dxb dxs dyt wdList xday xday2 yday yday2 calDay calMon calYear calWD calDayCount
    global weekDays monlen monAbk
    global curDay curMon curYear curOffset 
    global yOffset xmx xmax ymax xbl xbr canParent dyCal yOffList yOffList2 yOffAnz hourModulo yScrollOn
    global calKernStart calKernEnd calKernLen calSplitHour calGlobalSlots 

    global xLeftLegend xRightLegend xLeftLegend2 xRightLegend2 yLegend yLegend2 legendAnz
    global xday yday0 yday1 yday2 calDay calMon calYear calWD calStart calEnd  yTitelType calLineAnz
    global calNr calDayStr calHourLineStep calDayList calLineList calJumpMode calAllDayList calStrList
    global calSplitOffset calUserName calAnz
    global uCalKernStart uCalKernEnd uGlobalSlotsW
#    global day mon year

    set day    $curDay
    set mon    $curMon
    set year   $curYear
    set offset  [weekDayByDate $day $mon $year]

    set calKernStart $uCalKernStart
    set calKernEnd $uCalKernEnd
    set calKernLen [expr $calKernEnd -$calKernStart]
    set calGlobalSlots $uGlobalSlotsW
    set calSplitHour 25

    set wdList ""
    set calDayCount 7
    set xmx [ expr $xmax - $yScrollOn *16 ]
    set dxd [expr int(floor(double($xmx -76)/$calDayCount)) ]
    set dxs [expr ($xmx -$calDayCount *$dxd)/2 ]
#     set xbl [expr $dxs -1]
#     set xbr [ expr $xbl + $calDayCount *$dxd ]
    set dxb 20
    set yOffset 0
    set dyt 32
    set slots  [ expr $calKernLen +24 +$calGlobalSlots ]
    set dyh [expr int(floor(double($ymax-$dyt)/$slots))]
    set dyCal [expr $slots * $dyh]
#    puts "slots=$slots , $dyh $ymax"
    set yOffList(0) $yOffset
    set yOffAnz 1


    set hourModulo 1
    set calHourLineStep 1
    set calLineAnz 1
    set legendAnz 1
    set calJumpMode "w"

    set cid "0-0"
    set yday0($cid) 0
    set yday1($cid) $dyt
    set yday2($cid) [expr $dyt +$calGlobalSlots *$dyh]
    set yTitelType($cid) "full"
    set calStart($cid) 0
    set calEnd($cid) 24
    set calDayList($cid) ""

    set calStrList ""
    for { set i 0} { $i < $calDayCount } { incr i } {
	set lcid "0-0-$i"
	set xday($lcid) [ expr $dxs + $i *$dxd ]
	set calSplitOffset($lcid) 0
	set dstr [format "%4d%02d%02d" $year $mon $day ] 
	lappend calStrList $dstr
	lappend wdList $dstr
	set calDayStr($lcid) $dstr
	set calDay($lcid)  $day
	set calMon($lcid)  $mon
	set calYear($lcid) $year
	set calWD($lcid)   [expr ($i +$offset) % 7 ]
	lappend calDayList($cid) $lcid
	lappend calAllDayList "0 $i"
	
	incr day
	set extend 0
	if { $day > [lindex $monlen $mon] } {
	    if { $mon == 2} {
		if { [ expr $year % 4] == 4 } {
		    if { $day<=29 } { set extend 1} } }
	    if { $extend == 0 } { 
		incr mon
		set day 1
		if { $mon > 12 } {
		    incr year
		    set mon 1
		}
	    }
	}	
    }
    set xLeftLegend($cid)   0
    set xRightLegend($cid)  [expr $dxs +$calDayCount * $dxd]
    set yOffList(0) $yday2(0-0)
    set yOffList2(0) $yday1(0-0)
    set calNr 0
    set calLineList(0) " 0-0"
    set calAnz 1

    drawCalGrid 
    $canParent adjustscrollregion
}

proc drawWeekGroupGrid { idx full } {
    global dyh dxd dxb dxs dyt wdList xday xday2 yday yday2 calDay calMon calYear calWD calDayCount
    global weekDays monlen monAbk
    global curDay curMon curYear curOffset 
    global yOffset xmx xmax ymax xbl xbr canParent dyCal
    global can lbfnt
    global yOffList yOffList2 ysmax hourModulo yScrollOn
    global calKernStart calKernEnd calKernLen calSplitHour calGlobalSlots

    global xLeftLegend xRightLegend xLeftLegend2 xRightLegend2 yLegend yLegend2 legendAnz
    global xday yday0 yday1 yday2 calDay calMon calYear calWD calStart calEnd  yTitelType calLineAnz
    global calNr calDayStr calHourLineStep calDayList calLineList calJumpMode calAllDayList calStrList
    global calSplitOffset calUserName calAnz
    global uGlobalSlotsWG
    global _calText 

    set calNr $idx

    set day    $curDay
    set mon    $curMon
    set year   $curYear
    set offset  [weekDayByDate $day $mon $year]

    set calKernStart 25
    set calKernEnd 25
    set calKernLen [expr $calKernEnd -$calKernStart]
    set calGlobalSlots $uGlobalSlotsWG
#    set calGlobalSlots 2
    set calSplitHour 25


    set wdList ""
    set calDayCount 7
    set xmx [ expr $xmax - $yScrollOn *16 ]
#    puts "Xmax: $xmax -> $xmx"
    set dxd [expr int(floor(double($xmx -72)/$calDayCount)) ]
    set dxs [expr ($xmx -$calDayCount *$dxd)/2 ]
    set xbl [expr $dxs -1]
#    puts "$dxs $dxd"
    set dyh 12
    set slots  [ expr 24 +$calGlobalSlots ]
    set dyCal [expr $slots * $dyh]
    set yOffList($idx) $yOffset

    set hourModulo 2
    set calHourLineStep 1
#    set calLineAnz 1
#    set legendAnz 1
    set calJumpMode "w"

    set cid "$calNr-0"
    set yday0($cid) [expr 64+ $calNr * ($dyCal+$dyt+32) ]
    set yday1($cid) [expr $yday0($cid) +$dyt ]
    set yday2($cid) [expr $yday0($cid) +$dyt +$calGlobalSlots *$dyh]
    set yTitelType($cid) "full"
    set calStart($cid) 0
    set calEnd($cid) 24
    set calDayList($cid) ""

    set calStrList ""
    for { set i 0} { $i < $calDayCount } { incr i } {
	set lcid "$cid-$i"
	set calSplitOffset($lcid) 0
	set xday($lcid) [ expr $dxs + $i *$dxd ]
	set dstr [format "%4d%02d%02d" $year $mon $day ] 
	lappend calStrList $dstr
	lappend wdList $dstr
	set calDayStr($lcid) $dstr
	set calDay($lcid)  $day
	set calMon($lcid)  $mon
	set calYear($lcid) $year
	set calWD($lcid)   [expr ($i +$offset) % 7 ]
	lappend calDayList($cid) $lcid
	lappend calAllDayList "0 $i"


	incr day
	set extend 0
	if { $day > [lindex $monlen $mon] } {
	    if { $mon == 2} {
		if { [ expr $year % 4] == 4 } {
		    if { $day<=29 } { set extend 1} } }
	    if { $extend == 0 } { 
		incr mon
		set day 1
		if { $mon > 12 } {
		    incr year
		    set mon 1
		}
	    }
	}	
    }
    set calLineList($calNr) "$cid"
    set xLeftLegend($cid)   0
    set xRightLegend($cid)  [expr $dxs +$calDayCount * $dxd]
    incr calAnz

    $can create text [expr $xmx /2] [expr $yday0($cid) -2] -text "$_calText(CalOfUser) $full" -font $lbfnt -anchor s
    addCalGrid
    $canParent adjustscrollregion
}
proc drawMonGrid {  } {
    global dyh dxd dxb dxs dyt wdList xday xday2 yday yday2 calDay calMon calYear calWD calDayCount
    global weekDays monlen monAbk
    global curDay curMon curYear curOffset 
    global yOffset xmx xmax ymax xbl xbr canParent dyCal yOffList yOffList2 yOffAnz hourModulo yScrollOn
    global calKernStart calKernEnd calKernLen calSplitHour calGlobalSlots

    global xLeftLegend xRightLegend xLeftLegend2 xRightLegend2 yLegend yLegend2 legendAnz
    global xday yday0 yday1 yday2 calDay calMon calYear calWD calStart calEnd  yTitelType calLineAnz
    global calNr calDayStr calHourLineStep calDayList calLineList calJumpMode calStrList calAllDayList
    global calUserName calSplitOffset calAnz
    global uGlobalSlotsW
#    global day mon year

    set day    1
    set mon    $curMon
    set year   $curYear
    set offset  [weekDayByDate $day $mon $year]

    set datum [ calcDate 1 $mon $year  [expr -1*$offset] ]
    set day  [lindex $datum 0]
    set mon  [lindex $datum 1]
    set year [lindex $datum 2]
    set offset  [weekDayByDate $day $mon $year]

#    puts "offset of $day.$mon is $offset"

    set calKernStart 25
    set calKernEnd 25
    set calKernLen [expr $calKernEnd -$calKernStart]
    set calGlobalSlots $uGlobalSlotsW
#    set calGlobalSlots 3
    set calSplitHour 25

    set wdList ""
    set calDayCount 7
    set xmx [ expr $xmax - $yScrollOn *16 ]
    set dxd [expr int(floor(double($xmx -76)/7)) ]
    set dxs [expr ($xmx -7 *$dxd)/2 ]
#    set dxb 20
#    set yOffset 0
    set dyt 16
    set slots  [ expr 24 +$calGlobalSlots ]
    set dyh [expr int(floor(double($ymax-$dyt)/$slots/5))]
    set dyCal [expr $slots * $dyh]
    set yh [expr $dyCal +$dyt]
#    puts "slots=$slots , $dyh $ymax"
    set yOffList(0) $yOffset
    set yOffAnz 1


    set hourModulo 4
    set calHourLineStep 2
    set calLineAnz 1
    set legendAnz 1
    set calJumpMode "m"
    set calLineList(0) ""

    for {set l 0} { $l <5 } {incr l} {
	set cid "0-$l"
	set y0 [expr $l *$yh ]
	set yday0($cid) $y0
	set yday1($cid) [expr $y0 + $dyt]
	set yday2($cid) [expr $y0 + $dyt +$calGlobalSlots *$dyh]
	set yTitelType($cid) "small"
	set calStart($cid) 0
	set calEnd($cid) 24
	set calDayList($cid) ""
	set xLeftLegend($cid)   0
	set xRightLegend($cid)  [expr $dxs +7*$dxd]
	lappend calLineList(0)  $cid
	set calDayList($cid) ""
    }

    set l 0
    set cid "0-$l"
#    set calDayCount [ lindex $monlen $mon]

#    puts ">>>>>>>>>>>>>>$calAllDayList<<"
    set calStrList ""
    for { set i 0} { $i < 35 } { incr i } {
	set wd [expr ($i +$offset) % 7 ]
	if {$wd == 0 && $i >0 } {
	    incr l
	    set cid "0-$l"
	}
	set lcid "$cid-$i"
	set xday($lcid) [ expr $dxs + $wd *$dxd ]
	set calSplitOffset($lcid) 0
	set dstr [format "%4d%02d%02d" $year $mon $day ] 
	lappend calStrList $dstr
	lappend wdList $dstr
	set calDayStr($lcid) $dstr
	set calDay($lcid)  $day
	set calMon($lcid)  $mon
	set calYear($lcid) $year
	set calWD($lcid)   $wd
	lappend calDayList($cid) $lcid
	lappend calAllDayList "$l $i"
	
	incr day
	set extend 0
	if { $day > [lindex $monlen $mon] } {
	    if { $mon == 2} {
		if { [ expr $year % 4] == 4 } {
		    if { $day<=29 } { set extend 1} } }
	    if { $extend == 0 } { 
		incr mon
		set day 1
		if { $mon > 12 } {
		    incr year
		    set mon 1
		}
	    }
	}	
    }
#    puts ">>>>>>>>>>>>>>$calAllDayList<<"
    set yOffList(0) $yday2(0-0)
    set yOffList2(0) $yday1(0-0)
    set calNr 0
    set calAnz 1
    drawCalGrid 
    $canParent adjustscrollregion
}

proc drawCalGrid {  } {
    global can calDrawn
    
    
    if { $calDrawn == 1 } {
	$can delete termin
	update
    }

    addCalGrid
}
    
proc addCalGrid {  } {
    ### 
    global can xmx ymax dxs xbl xbr dyCal hourModulo
    global xday xday2 yday dyt yday2
    global weekDays weekDaysAbk monlen monAbk
    global wdList dxd dyh dxb xday  calDay calMon calYear calWD calDayCount
    global calDrawn  today 
    global yOffset pfnt pfnt12 fnt fnt12 fnt10 fnt9 fnt8  bfnt10 bfnt9 bfnt8  
    global calKernStart calKernEnd calSplitHour calGlobalSlots calKernLen
    global xoffset calSplitYoffset 
    global xLeftLegend xRightLegend xLeftLegend2 xRightLegend2 yLegend yLegend2 legendAnz
    global xday yday0 yday1 yday2 calDay calMon calYear calWD calStart calEnd calDayList calLineAnz yTitelType
    global calNr calDayStr calHourLineStep calLineList calJumpMode 
    global gridTagKOList canAddDateRibbon
    global holidays holidayNames holidayMonth langType

    #     $can create rectangle 1 [expr $yOffset +1] $xmx [expr $yOffset + $dyCal] -fill grey90 -outline grey65
    set canAddDateRibbon 0
    foreach cid $calLineList($calNr) {
	#Zeittafeln
	#	puts "cl: $cid:  $xRightLegend($cid) $yday0($cid) $yday2($cid) $dyh $calKernStart $calKernEnd"
	if { $xLeftLegend($cid) >=0 } {
	    set x0 [ expr $xLeftLegend($cid)]
	    set x1 [ expr $x0 +$dxs]
	    set x2 [ expr $x0 +$dxs -2]
	    set y  $yday0($cid)
	    $can create line $x0 $y $x1 $y 
	    set y  $yday1($cid)
	    $can create line $x0 $y $x1 $y 
	    set y  $yday2($cid)
	    $can create line $x0 $y $x1 $y 
	    $can create line $x0 [expr $y-1] $x1 [expr $y-1]
	    for { set h [expr $calStart($cid)+1] } {$h <= $calEnd($cid)} {incr h } {
		incr y $dyh
		if { $calKernStart < $h && $h <= $calKernEnd } {
		    incr y $dyh
		}	    
		set yt [expr $y +2]
		if { [expr $h % $hourModulo] == 0} {
		    $can create text $x2 $yt -anchor se -text [format "%2d:00" $h ] -font $fnt12
		    $can create line $x0 $y $x1 $y 
		}
	    }
	    $can create line $x0 $yday0($cid) $x0 [expr $yday1($cid)+$dyCal] 
	    $can create line $x1 $yday0($cid) $x1 [expr $yday1($cid)+$dyCal] 
	    
	    set x1 [expr $x0 +3]
	    set x2 [expr $x0 +$dxs -1 ]
	    set xs [expr ($x1+$x2)/2 ]
	    set y0 $yday0($cid)
	    set y1 [expr $y0 +3]
	    set y2 [expr $y0 +16]
	    set y3 [expr $y0 +18]
	    set y4 [expr $y0 +31]
	    if { $calJumpMode == "w" } {
		rButton $can $x1 $y1 $x2 $y2 dayBack
		rButton $can $x1 $y3 $x2 $y4 weekBack
		# 		$can create text $xs $y2 -anchor s -text "<"   -tag dayBack
		# 		$can create text $xs $y4 -anchor s -text "<<<" -tag weekBack
		$can create text $xs $y2 -anchor s -text "<< 1 <<"   -tag dayBack  -font $bfnt10
		$can create text $xs $y4 -anchor s -text "<< 7 <<" -tag weekBack -font $bfnt10
		$can bind dayBack   <ButtonRelease> { changeDate -1 }
		$can bind weekBack  <ButtonRelease> { changeDate -7 }
	    } elseif { $calJumpMode == "m" } {
		rButton $can $x1 $y1 $x2 $y2 monthBack
		#		$can create text $xs $y2 -anchor s -text "<<<<"   -tag monthBack
		$can create text $xs $y2 -anchor s -text "<< 30"   -tag monthBack -font $bfnt10
		$can bind monthBack   <ButtonRelease> { changeDateByMonth -1 }
	    }
	}
	if { $xRightLegend($cid) >=0 } {
	    set x0 [ expr $xRightLegend($cid)]
	    set x1 [ expr $x0 +$dxs]
	    set x2 [ expr $x0 +$dxs -3]
	    set y  $yday0($cid)
	    $can create line $x0 $y $x1 $y 
	    set y  $yday1($cid)
	    $can create line $x0 $y $x1 $y 
	    set y  $yday2($cid)
	    $can create line $x0 $y $x1 $y 
	    $can create line $x0 [expr $y-1] $x1 [expr $y-1]
	    for { set h [expr $calStart($cid)+1] } {$h <= $calEnd($cid)} {incr h  } {
		incr y $dyh
		if { $calKernStart < $h && $h <= $calKernEnd } {
		    incr y $dyh
		}	    
		set yt [expr $y +2]
		if { [expr $h % $hourModulo] == 0} {
		    $can create text $x2 $yt -anchor se -text [format "%2d:00" $h ] -font $fnt12
		    $can create line $x0 $y $x1 $y 
		}
	    }
	    incr x1 -1
	    $can create line $x0 $yday0($cid) $x0 [expr $yday1($cid)+$dyCal] 
	    $can create line $x1 $yday0($cid) $x1 [expr $yday1($cid)+$dyCal] 
	    set x1 [expr $x0 +1]
	    set x2 [expr $x0 +$dxs -3 ]
	    set xs [expr ($x1+$x2)/2 ]
	    set y0 $yday0($cid)
	    set y1 [expr $y0 +3]
	    set y2 [expr $y0 +16]
	    set y3 [expr $y0 +18]
	    set y4 [expr $y0 +31]
	    if { $calJumpMode == "w" } {
		rButton $can $x1 $y1 $x2 $y2 dayForw
		rButton $can $x1 $y3 $x2 $y4 weekForw
		# 		$can create text $xs $y2 -anchor s -text ">"   -tag dayForw
		# 		$can create text $xs $y4 -anchor s -text ">>>" -tag weekForw
 		$can create text $xs $y2 -anchor s -text ">> 1 >>"   -tag dayForw -font $bfnt10
 		$can create text $xs $y4 -anchor s -text ">> 7 >>" -tag weekForw -font $bfnt10
		$can bind dayForw   <ButtonRelease> { changeDate 1 }
		$can bind weekForw  <ButtonRelease> { changeDate 7 }
	    } elseif { $calJumpMode == "m" } {
		rButton $can $x1 $y1 $x2 $y2 monthForw
		#		$can create text $xs $y2 -anchor s -text ">>>>"   -tag monthForw
		$can create text $xs $y2 -anchor s -text "30 >>"   -tag monthForw -font $bfnt10
		$can bind monthForw   <ButtonRelease> { changeDateByMonth 1 }
	    }
	}


	foreach lcid $calDayList($cid) {
	    #	    puts "ID: $cid / $lcid"

	    #senkrechte Einteilung
	    set y0 [expr $yday0($cid)]
	    set y1 [expr $y0 + 17]        
	    set y2 [expr $y0 + 32]
	    set y3 $yday1($cid)
	    set y4 $yday2($cid)
	    set yl [expr $yday1($cid) +$dyCal ]
	    
	    set x  $xday($lcid)
	    set x1 [ expr $x +$dxd/2] 
	    set x3 [ expr $x +$dxd -1]
	    set dstr $calDayStr($lcid)

	    set WDstr [lindex $weekDays $calWD($lcid) ]
	    set mtag [format "%04d-%02d" $calYear($lcid) $calMon($lcid) ]
	    set holiday 0
	    if { [lsearch $holidayMonth $mtag] >=0 } {
		set i [lsearch $holidays($mtag) $calDay($lcid)]
		if { $i >=0} {
		    set WDstr [lindex $holidayNames($mtag) $i]
		    set holiday 1
		}
	    }

	    if { $today == $dstr } {
		if { $y4 > $y3} {
		    $can create rectangle $x $y3 $x3 $y4 -fill PeachPuff -outline PeachPuff  -tag gd$lcid
		    $can create rectangle $x $y4 $x3 $yl -fill PapayaWhip -outline PapayaWhip  -tag wd$lcid
		    lappend gridTagKOList "gd$lcid $x $y3 $x3 $y4"
		    lappend gridTagKOList "wd$lcid $x $y4 $x3 $yl"
		    $can bind gd$lcid <ButtonPress> { canStoreButtonPressKO %x %y %b}
		    $can bind gd$lcid <Motion> { canDrawAddDateRibbon %x %y %b}
		    $can bind gd$lcid <ButtonRelease> { canAddDate %x %y %b}
		} else {
		    $can create rectangle $x $y3 $x3 $yl -fill PapayaWhip  -outline PapayaWhip  -tag wd$lcid
		    lappend gridTagKOList "wd$lcid $x $y3 $x3 $yl"

		}

		if { $yTitelType($cid) == "full" } {
		    if { $holiday == 0 } {
			$can create rectangle $x $y0 $x3 $y2 -fill ivory -outline ivory
		    } else { 
			$can create rectangle $x $y0 $x3 $y2 -fill DarkOliveGreen3 -outline DarkOliveGreen3
		    }
		    $can create text $x1 $y1 -anchor s -tag jt$lcid -text $WDstr -fill red4
		    $can create text $x1 $y2 -anchor s  -tag jt$lcid -fill red4 \
			-text [ date2NamedStr $calDay($lcid) $calMon($lcid) $calYear($lcid)] 
		    lappend gridTagKOList "jt$lcid $x $y0 $x3 $y2"
		} else {
		    $can create rectangle $x $y0 $x3 $y1 -fill ivory -outline ivory
		    set txt  [format "%2s, %s" [lindex $weekDaysAbk $calWD($lcid)] \
				  [date2NamedStr $calDay($lcid) $calMon($lcid) $calYear($lcid)]]
		$can create text $x1 $y1 -anchor s  -tag jt$lcid -fill red4 -text $txt
		lappend gridTagKOList "jt$lcid $x $y0 $x3 $y1"
	    }

	    $can create line $x  $y0 $x $yl -fill black -tag wd$lcid
	} else {
	    if { $y4 > $y3} {
		$can create rectangle $x $y3 $x3 $y4 -fill grey80 -outline grey90  -tag gd$lcid
		$can create rectangle $x $y4 $x3 $yl -fill grey95 -outline grey95  -tag wd$lcid
		lappend gridTagKOList "gd$lcid $x $y3 $x3 $y4"
		lappend gridTagKOList "wd$lcid $x $y4 $x3 $yl"
		$can bind gd$lcid <ButtonPress> { canStoreButtonPressKO %x %y %b}
		$can bind gd$lcid <Motion> { canDrawAddDateRibbon %x %y %b}
		$can bind gd$lcid <ButtonRelease> { canAddDate %x %y %b}
	    } else {
		$can create rectangle $x $y3 $x3 $yl -fill grey95 -outline grey95  -tag wd$lcid
		lappend gridTagKOList "wd$lcid $x $y3 $x3 $yl"
	    }
	    if { $yTitelType($cid) == "full" } {
		if { $holiday == 0 } {
		    $can create rectangle $x $y0 $x3 $y2 -fill grey98 -outline grey98
		} else { 
		    $can create rectangle $x $y0 $x3 $y2 -fill DarkOliveGreen3 -outline DarkOliveGreen3
		}
		$can create text $x1 $y1 -tag jt$lcid -anchor s -text $WDstr
		$can create text $x1 $y2 -tag jt$lcid -anchor s \
		    -text [ date2NamedStr $calDay($lcid) $calMon($lcid) $calYear($lcid)]
		lappend gridTagKOList "jt$lcid $x $y0 $x3 $y2"
	    } else {
		$can create rectangle $x $y0 $x3 $y1 -fill grey98 -outline grey98
		set txt [format "%2s, %s" [lindex $weekDaysAbk $calWD($lcid)] \
			     [ date2NamedStr $calDay($lcid) $calMon($lcid) $calYear($lcid)]]
		$can create text $x1 $y1 -tag jt$lcid -anchor s -text  $txt
		lappend gridTagKOList "jt$lcid $x $y0 $x3 $y1"
	    }
	    
	    $can create line $x  $y0 $x $yl -fill black  -tag wd$lcid
	}

	#StundLinien
	set y  $yday0($cid)
	$can create line $x $y $x3 $y 
	set y  $yday1($cid)
	$can create line $x $y $x3 $y 
	set y  $yday2($cid)
	$can create line $x $y $x3 $y 
	$can create line $x [expr $y-1] $x3 [expr $y-1]
	set dy [expr $dyh * $calHourLineStep]
	for { set h [expr $calStart($cid)+1] } {$h <= $calEnd($cid)} {incr h $calHourLineStep } {
	    incr y $dy
	    if { $calKernStart < $h && $h <= $calKernEnd } {
		incr y $dy
	    }	    
	    $can create line $x $y $x3 $y   -tag wd$cid
	}
	#
	$can bind wd$lcid <ButtonPress> { canStoreButtonPressKO %x %y %b}
	$can bind wd$lcid <Motion> { canDrawAddDateRibbon %x %y %b}
	$can bind wd$lcid <ButtonRelease> { canAddDate %x %y %b}
	$can bind jt$lcid <ButtonRelease> { canAddDate %x %y %b}

    }
}
}



proc drawCalendar { } { 
#    drawUsersCalendar

    drawCal
}

proc compareCalEntries2 { c1 c2 } {
    set d1 [ lindex $c1 0]
    set t1 [ lindex $c1 1]
    set n1 [ lindex $c1 4]
    set d2 [ lindex $c2 0]
    set t2 [ lindex $c2 1]
    set n2 [ lindex $c2 4]

    set r 0
    
#    set n [expr $n1 +$n2]

    if { $n1 ==1 } { set t1 0  }
    if { $n2 ==1 } { set t2 0  }
    
    if { $d1 > $d2} {set r  1}
    if { $d1 < $d2} {set r -1}
    if {$r == 0 } {
	if { $t1 > $t2} {set r  1}
	if { $t1 < $t2} {set r -1}
    }
    
#    puts "cmp /$c1/ vs /$c2/  =>   /$d1,$t1/ vs /$d2,$t2/   -> $r"
    return $r
}

proc compareCalEntries { c1 c2 } {
    set d1 [ lindex $c1 0]
    set t1 [ lindex $c1 1]
    set n1 [ lindex $c1 4]
    set d2 [ lindex $c2 0]
    set t2 [ lindex $c2 1]
    set n2 [ lindex $c2 4]

    set r 0

    #bei noTime verdrehtes Vorzeichen, da ganztagesTermine am Anfang stehen sollen
    if { $n1 > $n2 } { set r -1 }
    if { $n1 < $n2 } { set r  1 }
    
    if { $r == 0} {
	if { $d1 > $d2} {set r  1}
	if { $d1 < $d2} {set r -1}
    }
    if {$r == 0 } {
	# Wenn beide Termine ganztgig sind spielt die uhrzeit keine Rolle und der Time-Wert hat keine Bedeutung
	if { $n1 == 0 } {
	    if { $t1 > $t2} {set r  1}
	    if { $t1 < $t2} {set r -1}
	}
    }
#    puts "cmp /$c1/ vs /$c2/  =>   /$d1,$t1/ vs /$d2,$t2/   -> $r"
    return $r
}



proc drawUsersCalendar { } { 
    global can calDrawn cur_Cal dateTagKO prvCal requestCal
    if { $calDrawn == 1}  {
	$can delete termin
	update
    }
    set dateTagKO ""
    addUsersCalendar $requestCal
    set dateTagKO [lsort $dateTagKO]
    setTagList 0 [llength $dateTagKO] [join $dateTagKO]
    set calDrawn 1
    redrawMainCanvas
    _drawCurrentTime
}
proc addUsersCalendar { cur_Cal } { 
    global username wdList  can dxb dyh dxd smallWeekCalFont weekCalFont eddv_repTypStr prvCal
    global dateID showIgnore  calDrawn  calDayCount groupOnlyCommon ignoreInfo
    global yOffset  dateTagKO dateByTag timeByTag
    global calKernStart calKernEnd calSplitHour calKernLen
    global xday yday0 yday1 yday2 calDay calMon calYear calWD calStart calEnd calDayList yTitelType calLineAnz
    global calNr calDayStr calHourLineStep calLineList calJumpMode calAllDayList calAllDayList2 calStrList
    global calSplitOffset calGlobalSlots
    global colorList

    set dateNr 0

#    doLock
    set dateColor "#F8FFF8"
    set privatColor "#FFE8E0"
    set infoColor   "#EDEDED"
    set priorityRing "black purple4 blue4 green4 green2 yellow2 orange red"

    set first [ lindex $calStrList 0]
    set last [ lindex $calStrList end]
    set calList [request getUserCal $username  $cur_Cal $first $last  $showIgnore $ignoreInfo [expr 1 - $groupOnlyCommon] ]
    if { $calList == "Error" } { return }

#    if { [string first $calList "ServerDown"] >=0 } {ServerDownDialog}
    
    set calList [lsort -command compareCalEntries $calList]
    set anz [llength $calList]
#    puts "size of calendar : $anz : '$calList'"
    if { $anz == 0 } { return }

    set maxlevel 1
    for {set i 0} { $i < $anz } { incr i } { 
	set level($i) 1
	set maxLevel($i) 1
	set grp($i) 0
    }
#Erstmal die ganztages Termine
    set gdList ""
    for { set i 0 } {$i< $anz} {incr i} {
	set date [lindex $calList $i ]
	set startD [lindex $date 0]
	set stopD [lindex $date 2]
	set noTime [lindex $date 4]
	if { $noTime == 1} { 
	    set startIdx [lsearch $calStrList $startD]
	    set stopIdx [lsearch $calStrList $stopD]
	    for {set idx $startIdx } {$idx <= $stopIdx} {incr idx} {
		set dat [ lindex $calStrList $idx ]
		lappend gdList $dat
	    }
	}
    }
    foreach date $gdList { set gdCount($date) 0}
#    puts $gdList
    for { set i 0 } {$i< $anz} {incr i} {
	set date [lindex $calList $i ]
	set startD [lindex $date 0]
	set stopD [lindex $date 2]
	set noTime [lindex $date 4]
	if { $noTime == 1} { 
	    set startIdx [lsearch $calStrList $startD]
	    set stopIdx [lsearch $calStrList $stopD]
#	    puts ">>> $startD $stopD ==> $startIdx $stopIdx"
	    for {set idx $startIdx } {$idx <= $stopIdx} {incr idx} {
		set dat [ lindex $calStrList $idx ]
#		puts "   -> $idx = $dat"
		set level($i-$dat) $gdCount($dat)
		incr gdCount($dat)
	    }
	}
    }
    set baseHour [expr -1*$calGlobalSlots]
    set gLen [expr 60 *$calGlobalSlots]


#Suche nach parrallel Terminen    
    set activeList ""
    set lastGroupD -9999999
    set lastGroupT -9999
    for { set i 0 } {$i<=8} {incr i} {
	set lastD($i) -9999999
	set lastT($i) -9999
    }
    set depth 1
    for {set i 0} { $i < $anz } { incr i } {
	set date [lindex $calList $i ]
	set startD [lindex $date 0]
	set startT [lindex $date 1]
	set stopD  [lindex $date 2]
	set stopT  [lindex $date 3]
	set noTime [lindex $date 4]
	set titel  [lindex $date 5]
	set did    [lindex $date 6]
	set prior  [lindex $date 8]

	if {$noTime == 1 } { continue }


	# Gehrt dieser Termin zur selben Gruppe wie der letzte
	if { [ isDate1GreaterThanDate2 $lastGroupD $lastGroupT $startD $startT] >0 } {
	    lappend activeList $i
	    #finde eine Spur/Level in der der aktuelle Termin passt
	    set spur -1
	    for { set l 1} {$l<=$depth} {incr l} {
		if { [isDate1GreaterThanDate2 $startD $startT $lastD($l) $lastT($l) ] > 0 } {
		    set spur $l
		    break
		}
	    }
	    #keine passende Spur gefunden ? Dann fge eine neue Spur hinzu
	    if { $spur == -1 } {
		incr depth
		set spur $depth
	    }
	    set lastD($spur) $stopD
	    set lastT($spur) $stopT
	    if { [ isDate1GreaterThanDate2 $stopD $stopT $lastGroupD $lastGroupT ] >0 } {
		set lastGroupD $stopD
		set lastGroupT $stopT
	    }
	    set level($i) [expr  $spur -1]
	} else {
	    #Dieser Termin gehrt einer neuen Gruppe an
	    #Ist eine vorherige Gruppe zu schliessen
	    if { [llength $activeList] >0 } {
		foreach ent $activeList {
		    set maxLevel($ent) $depth
		}
		set activeList ""
		set depth 1
	    }


	    lappend activeList $i
	    set lastGroupD $stopD
	    set lastGroupT $stopT
	    set lastD(1) $stopD
	    set lastT(1) $stopT
	    set level($i) 0
	}
    }
    #Die letzte Gruppe noch schliessen
    if { [llength $activeList] >0 } {
	foreach ent $activeList {
	    set maxLevel($ent) $depth
	}
    }


    set tc 0
    set dx [expr $dxd  -1]
    for {set i 0 } { $i < $anz } { incr i} {
	set date [lindex $calList $i ]
	set startD [lindex $date 0]
	set startT [lindex $date 1]
	set stopD  [lindex $date 2]
	set stopT  [lindex $date 3]
	set noTime [lindex $date 4]
	set titel  [lindex $date 5]
	set did    [lindex $date 6]
	set repTyp [lindex $date 7]
	set prior  [lindex $date 8]
	set plist  [lindex $date 9]
	set isprivat [lindex $date 10]
	set isInfo [lindex $date 11]

#	puts "found date $did : $startD $startT - $stopD $stopT not=$noTime $titel  / $isprivat $isInfo"
	set startIdx [lsearch $calStrList $startD]
	set stopIdx [lsearch $calStrList $stopD]
	for {set idx $startIdx } {$idx <= $stopIdx} {incr idx} {
	    set list [lindex $calAllDayList $idx]
	    set lin  [lindex $list 0]
	    set dt   [lindex $list 1]
	    set lcid "$calNr-$lin-$dt"
	    set  cid "$calNr-$lin"

	    if { $noTime == 1 } {
                set date [lindex $calStrList $idx]
 		set h [ expr double($gLen)/$gdCount($date)]
		set w $dx
		set startM [ expr int(floor( $h *$level($i-$date)))]
		set stopM  [expr int(floor( $h *$level($i-$date) +$h))]
		set startT [expr $baseHour *100]
		set stopT $startT
		set startH $baseHour
		set stopH $startH
		
		while { $startM>0} {
		    incr startM -60
		    incr startT 100
		    incr startH
		}
		incr startT $startM
		while { $stopM>0} {
		    incr stopM -60
		    incr stopT 100
		    incr stopH
		}
		incr stopT $stopM
		set x1 [expr $xday($lcid) + 1]
		set x2 [expr $x1  + $dxd-1]
		set list "{$startH $startM $stopH $stopM}"
	    } else {
		if { $idx == $startIdx} {
		    set t0 $startT
		} else {
		    set t0 0
		}
		if { $idx == $stopIdx} {
		    set t1 $stopT
		} else {
		    set t1 2359
		}
		set w [expr int (floor(double($dx) /$maxLevel($i)))]

		set x1 [expr $xday($lcid) + $level($i) *$w +1]
		set x2 [expr $x1  + $w-1]
		
		set min1  [ expr $t0 % 100 ]
		set hour1 [ expr ($t0-$min1)/100 ]
		set min2  [ expr $t1 % 100 ]
		set hour2 [ expr ($t1-$min2)/100 ]

		if { $hour1 < $calSplitHour && $hour2 > $calSplitHour} {
		    set list "{$hour1 $min1 $calSplitHour 0} {$calSplitHour 0 $hour2 $min2}"
		} elseif { $hour1 < $calSplitHour && $hour2 == $calSplitHour && $min2 >0 } {
		    set list "{$hour1 $min1 $calSplitHour 0} {$calSplitHour 0 $hour2 $min2}"
		} else {
		    set list "{$hour1 $min1 $hour2 $min2}"
		}
	    }
	    foreach ent $list {
		set yShift 0
		set hour [lindex $ent 0]
		set min  [lindex $ent 1]
		if { $hour >= $calSplitHour } {
		    set list [lindex $calAllDayList2 $idx]
		    set lin  [lindex $list 0]
		    set dt   [lindex $list 1]
		    set lcid "$calNr-$lin-$dt"
		    set  cid "$calNr-$lin"
		    set yShift $calSplitOffset($lcid)
		} 
		set yb0 [expr $yday2($cid) - $yShift]
		set yb1 [expr $yb0 +$calKernStart * $dyh]
		set yb2 [expr $yb1 +$calKernLen *$dyh*2 ]
		if { $noTime == 1} {
		    set x1 [expr $xday($lcid) +1]
		    set x2 [expr $x1  + $dxd-1]
		} else {
		    set x1 [expr $xday($lcid) + $level($i) *$w +1]
		    set x2 [expr $x1  + $w-1]
		}

		if { $hour < $calKernStart } {
		    set y1 [expr $yb0 +$hour* $dyh +  int((double($min)/60)*$dyh) ]
		} elseif { $hour < $calKernEnd } {
		    set y1 [expr $yb1 +($hour-$calKernStart)*$dyh *2+ int((double($min)/30)*$dyh) ]
		} else {
		    set y1 [expr $yb2 +($hour-$calKernEnd)*$dyh + int((double($min)/60)*$dyh)]
		}

		set hour [lindex $ent 2]
		set min  [lindex $ent 3]
		if { $hour < $calKernStart } {
		    set y2 [expr $yb0 + $hour* $dyh +  int((double($min)/60)*$dyh) ]
		} elseif { $hour < $calKernEnd } {
		    set y2 [expr $yb1 +($hour-$calKernStart)*$dyh*2 + int((double($min)/30)*$dyh) ]
		} else {
		    set y2 [expr $yb2 + ($hour-$calKernEnd)* $dyh +  int((double($min)/60)*$dyh) ]
		}
		if { [expr $y2 -$y1] < 6 } {
		    set y2 [ expr $y1+6]
		}
		
		incr y1
		set dtag "term$dateNr"
		incr dateNr
		if { $isprivat == 0 } {
		    if { $isInfo == 0 } {
			set col $dateColor
		    } else {
			set col $infoColor
		    }
		} else {
		    set col $privatColor
		}

		$can create rectangle $x1 $y1 $x2 $y2 -fill $col -tag "$dtag termin" 
		$can create line $x1 [expr $y1+1] $x2 [expr $y1+1] -width 2 -fill [lindex $priorityRing $prior] -tag "$dtag termin"

		set xc0 [expr $x1 +1 ]
		set xc1 [expr $x1 +7 ]
		set xc2 [expr $x1 +8 ]
		set yc0  [expr $y2-1]
		set yc1  [expr $y2-2]
		set yc2  [expr $y2-3]
		set yc3  [expr $y2-5]
		set yc4  [expr $y2-7]
		$can create rectangle $x1 $y2 $x2 $yc4 -fill black -outline black -tag "$dtag termin" 
		$can create rectangle $x1 $y2 $x2 $yc3 -fill white -outline black -tag "$dtag termin" 
		foreach part $plist {
		    if { [ string range $part 0 0] == "u" } {
			set col1 [lindex $colorList($part) 0]
			set col2 [lindex $colorList($part) 1]
			$can create rectangle $xc0 $yc0 $xc1 $yc1 -outline $col1 -fill $col1 -tag "$dtag termin"
			$can create rectangle $xc0 $yc2 $xc1 $yc3 -outline $col2 -fill $col2 -tag "$dtag termin"
			$can create line $xc2 $yc4 $xc2 $y2 -fill black -tag "$dtag termin"
			incr xc0 8
			incr xc1 8
			incr xc2 8
		    } elseif { [ string range $part 0 0] == "g" } {
			incr xc1 4
			incr xc2 4
			set col1 $colorList($part)
			$can create rectangle  $xc0 $yc0 $xc1 $yc4 -outline $col1 -fill $col1 -tag "$dtag termin"
			$can create line $xc2 $yc4 $xc2 $y2 -fill black -tag "$dtag termin"
			incr xc1 8
			incr xc2 8
			incr xc0 12
		    }
		    if { $xc1 > $x2 } { break}
		}
		set tagKO "$dtag $x1 $y1 $x2 $y2"
		lappend dateTagKO $tagKO
		
		set weekCalFont -*-helvetica-medium-r-*-*-10-*-*-*-*-*-*-*
		if {$repTyp >0 && [expr $y2-$y1]>20 } {
		    set str [format "%s\n(%s)" $titel [lindex $eddv_repTypStr $repTyp]]
		} else { 
		    set str $titel
		}
		if { [expr $y2-$y1] < 17 } {
		    set weekCalFont -*-helvetica-medium-r-*-*-8-*-*-*-*-*-*-*
		}
		if { [expr $y2-$y1] < 14 } {
		    set weekCalFont -*-fixed-medium-r-*-*-7-*-*-*-*-*-*-*
		}
		if { [expr $y2-$y1] < 10} {
		    set str ""
		}
		incr x1 
		incr y1
		set tag2 "txt-$lcid-$tc"
		if { $str != "" } {
		    $can create text $x1 $y1 -anchor nw -text  $str -width $w -font $weekCalFont -tag "$dtag termin $tag2"
		    incr tc
		}
		
		set tlen [string length $str]
 		if { [expr [lindex [$can bbox $tag2 ] 3 ] - $yc2] > 1 } {
 		    while { [expr [lindex [$can bbox $tag2 ] 3 ] - $yc2] > 1 } {
 			$can dchars $tag2 $tlen
 			incr tlen -1
 			if { $tlen <=0} { break }
 		    }
 		    if {$tlen >5} {
 			$can insert $tag2 end " ..."
			while { [expr [lindex [$can bbox $tag2 ] 3 ] - $yc2] > 1 } {
			    $can dchars $tag2 $tlen
			    incr tlen -1
			    if { $tlen <=0} { break }
			}

 		    }
 		}
	    }
	    set dateID($dtag) $did
	    set dateByTag($dtag) $startD
	    set timeByTag($dtag) $startT
	    $can bind $dtag <ButtonRelease> {modifyDate %x %y %b }
	    $can bind $dtag <Enter> { delayDateToolTip %x %y %d }
	}	
    }
#    unLock
    bind $can  <Motion> { setDelayDateToolTipCoords %x %y }
}

proc setDelayDateToolTipCoords { x y } {
    global can dateToolTip_x dateToolTip_y
    set dateToolTip_x [expr int([ $can canvasy $x])]
    set dateToolTip_y [expr int([ $can canvasy $y])]
}


proc delayDateToolTip { x y  d} {
    global delayDateToolTip_id dateToolTipDid dateToolTipTag dateToolTipDate dateToolTip_x dateToolTip_y
    global dateByTag can dateID  delayDateToolTip_block

    if { [winfo exists .edd ] == 1 } { return }
    if { [winfo exists .vd  ] == 1 } { return }

    ## which tag is calling
    set y  [expr int([ $can canvasy $y])]
    set x  [expr int([ $can canvasy $x])]
    set tag [getTag 0 $x $y]
    if { $tag != ""} {
	set did -1
	catch {set did $dateID($tag)}
    }

    if { $did >=0 } {
	catch { set dateToolTipDate $dateByTag($tag) }
	set dateToolTipTag $tag
	set dateToolTip_x $x
	set dateToolTip_y $y
	if { $did >= 0 } {
	    if { $delayDateToolTip_id >0 } { 
		after cancel delayDateToolTip_id 
	    }
	    set dateToolTipDid $did
	    if { [winfo exists .edd ] == 1 } { return }
	    if { [winfo exists .vd  ] == 1 } { return }
	    set delayDateToolTip_id [after 2000 showDateToolTip ]
	}
    }
}
proc showDateToolTip {  } {
    global dateToolTipDid  dateToolTip_x dateToolTip_y _calText can dateToolTipTag
    global username dateToolTipDate 
    global fnt10 _allgText

    set ret [ request getBriefDate $username $dateToolTipDid $dateToolTipDate]
    set details [string trimright [lindex $ret 7] \n]
    set part [lindex $ret 10]

    if { [winfo exists .edd ] == 1 } { return }
    if { [winfo exists .vd  ] == 1 } { return }

    # avoid tool tips if mouse has mopved avway
    set x $dateToolTip_x
    set y $dateToolTip_y
    set curTag [getTag 0 $x $y]
#    puts "curTag =$curTag  vs $dateToolTipTag"
    if { $curTag != $dateToolTipTag } { 
#	puts "OUTSIDE no ToolTip"
	return
    }
#    puts "INSIDE"

    set tlist ""
    set dots 0
    foreach val $part {
	set name  [ lindex $val 1]
	set ugType [ lindex $val 3]
	if { $ugType == "u" } {
	    set anz [llength $name]
	    set nam ""
	    incr  anz -1
	    for { set i 0} { $i <$anz } { incr i } {
		set nam "$nam [string range [lindex $name $i] 0 0]."
	    }
	    set nam [string trim "$nam [lindex $name end]"]
	    set tlist "$tlist $nam,"
	} elseif { $ugType == "g" } {
	    set tlist "$tlist $_allgText(GruppeAbk) $name,"
	}
	if { [ font measure $fnt10 $tlist] >224  } {
	    set dots 1
	    break
	}
    }
    set tlist [string trim  [ string trimright $tlist ,]]
    if { $dots == 1 } {
	set l [ string length $tlist ]
	incr l -1
	set list [ string range $tlist 0 $l ]
	while  { [ font measure $fnt10 "$list ..." ] >224  }  {
	    set list [ string range $tlist 0 $l ]
	    incr l -1
	}
	set tlist "$list ..."
    }

    set x $dateToolTip_x
    set y $dateToolTip_y
    set curTag [getTag 0 $x $y]
#    puts "curTag =$curTag  vs $dateToolTipTag"
    if { $curTag != $dateToolTipTag } { 
#	puts "OUTSIDE no ToolTip"
	return
    }

    incr x -4
    incr y -8

    set dlines [llength [ split $details \n ] ]
#    puts "dlines = $dlines <- '$details'"
    set x1 [ expr $x + 300]
    set y1 [ expr $y + 28 +12*$dlines]
    

    set cx [winfo width $can]
    set cy [winfo height $can]
    
#    puts "$x $y $x1 $y1 // $cx $cy"
    if { $x1 > $cx } {
	set dx [expr int($cx - $x1)]
#	puts "$x $dx"
	incr x  $dx
	incr x1 $dx
    }
    if { $y1 > $cy } {
	set dy [expr int($cy - $y1)]
	incr y  $dy
	incr y1 $dy
    }

    if { [$can gettags "dateToolTip" ] != "" } { $can delete dateToolTip}
    update
#    puts "$x $y $x1 $y1 // $cx $cy"

    $can create rectangle $x $y $x1 $y1 -outline black -fill yellow -tag "dateToolTip"
    $can create text [expr $x +14] [expr $y +2 ] -text "Teilnehmer" -anchor nw -font $fnt10  -tag "dateToolTip"
    $can create text [expr $x +14] [expr $y +14] -text "Ort"        -anchor nw -font $fnt10 -tag "dateToolTip"
    $can create text [expr $x +14] [expr $y +26] -text "Details"    -anchor nw -font $fnt10 -tag "dateToolTip"

    $can create text [expr $x +70] [expr $y + 2] -text ":" -anchor nw -font $fnt10  -tag "dateToolTip"
    $can create text [expr $x +70] [expr $y +14] -text ":" -anchor nw -font $fnt10 -tag "dateToolTip"
    $can create text [expr $x +70] [expr $y +26] -text ":" -anchor nw -font $fnt10 -tag "dateToolTip"

    $can create text [expr $x +74] [expr $y+ 2] -text $tlist -anchor nw -font $fnt10 -tag "dateToolTip"
    $can create text [expr $x +74] [expr $y+14] -text [lindex $ret 6]  -anchor nw -font $fnt10 -tag "dateToolTip"
    $can create text [expr $x +74] [expr $y+26] -text $details -anchor nw -font $fnt10 -tag "dateToolTip" 

    $can bind dateToolTip <Leave> {
	$can bind  $dateToolTipTag <Enter> {}
	after 500  killDateToolTip
    }
    update 
    after 100
    after 60000 killDateToolTip
#    puts "end SHOW TOOLTIP\n-------------------------------\n\n\n"
}

proc killDateToolTip { } {
    global can delayDateToolTip_id dateToolTipTag

    $can delete dateToolTip
    set dateToolTip ""
    if { $delayDateToolTip_id >0 } { 
	after cancel delayDateToolTip_id 
    }
    set delayDateToolTip_id -1
    if { [info exists  dateToolTipTag ] == 1 } {
	$can bind $dateToolTipTag <Enter> { delayDateToolTip %x %y %d }
    }
}


proc drawCalItem { } {
}

proc drawCurrentTime { } {
    global lastRefresh refreshEna

    set curTime [ currentDateTime ]
#    puts "cutTime: $curTime $lastRefresh"
    set min  [string trimleft [lindex $curTime 2 ] 0]
    if {$min  == "" } {set min 0}
#    if { [expr $min %5 ] != 0 } { 
	set waitTime 60000
	set refIncr 1
#    } else {
#	set waitTime 300000
#	set refIncr 5
#    }
    if { [expr $min % 5 ] == 0 } {
	_drawCurrentTime 
    }
    if { $refreshEna == 1} {
#	puts -nonewline "TCL checking Server: "
	set server [checkServer]
#	puts $server
	if { $server == "down" } {
#	    puts "TCL: Server down !!!!"
	    ServerDownDialog2
	}
    }

    if { $lastRefresh >  15 } {
	if { $refreshEna == 1} {
	    drawNewView
	    set lastRefresh 0
	}
    }
    incr lastRefresh $refIncr
    after $waitTime drawCurrentTime

}
proc _drawCurrentTime { } {
    global curTimeMark wdList xday dxd can dyh  calSplitHour xday2 yOffList yOffList2 yOffAnz 
    global calKernStart calKernEnd calKernLen calStrList
    global calAnz calStrList calAllDayList calAllDayList2 yday2 calSplitOffset

    set curTime [ currentDateTime ]
    set min  [string trimleft [lindex $curTime 2 ] 0]
    if {$min  == "" } {set min 0}
    set idx [ lsearch $calStrList [lindex $curTime 0 ] ]
#    #FIXME
#    return
    if { $idx >=0 } {
	if {$curTimeMark == 1} {
	    $can delete curTime
	}

	for {set i 0} {$i<$calAnz} {incr i} {
	    set hour [lindex $curTime 1 ]
	    if {$hour == "00" } {
		set hour 0
	    } else {
		set hour [string trimleft [lindex $curTime 1 ] 0]
	    }
	    if { $hour >= $calSplitHour } {
		set list [lindex $calAllDayList2 $idx]
		set cid [format "%d-%d" $i [lindex $list 0] ]
		set lcid [format "%d-%d-%d" $i [lindex $list 0] [lindex $list 1]]
		set yShift $calSplitOffset($lcid)
	    } else {
		set list [lindex $calAllDayList $idx]
		set cid [format "%d-%d" $i [lindex $list 0] ]
		set lcid [format "%d-%d-%d" $i [lindex $list 0] [lindex $list 1]]
		set yShift 0
	    }
	    
	    set x0 [expr $xday($lcid) +11 ]
	    set x1 [ expr $x0 +1  ]
	    set x2 [expr $x0 +$dxd -21]
	    set x3 [ expr $x2 -1  ]
	    set y0 [expr $yday2($cid) -$yShift]

	    
	    if { $hour <$calKernStart } {
		set y  [expr $y0 + $hour* $dyh +  int((double($min)/60)*$dyh) ]
	    } elseif { $hour < $calKernEnd } {
		set y0 [expr $y0 + $calKernStart*$dyh]
		set y  [expr $y0 + ($hour-$calKernStart)* $dyh *2+ int((double($min)/30)*$dyh) ]
	    } else {
		set y0 [expr $y0 +($calKernLen)*$dyh*2 +$calKernStart*$dyh ]
		set y  [expr $y0 + ($hour-$calKernEnd)* $dyh + int((double($min)/60)*$dyh)]
	    }

	    $can create line $x0 $y $x1 $y -fill red -tag curTime -arrow first -arrowshape "-12 -12 3" -width 1
	    $can create line $x2 $y $x3 $y -fill red -tag curTime -arrow first -arrowshape "-12 -12 3" -width 1
	}
	set curTimeMark 1
    }
}

proc redrawMainCanvas { } {
    global can xmax ymax refreshEna

    if { $refreshEna == 1 } {
	set x [winfo rootx $can]
	set y [winfo rooty $can]
	set geo [format "%dx%d+%d+%d"  $xmax $ymax $x $y ]
	
#	exec xrefresh  -geometry $geo
	update
	after 100
    }
#    puts "xrefresh"
}

proc modifyDate { x y b} {
    global can dateID username del_tag eddLock canParent ysmax dateByTag timeByTag
 
    set y  [ $can canvasy $y]

    update
    if { [winfo exists .edd ] == 0 } {
	set eddLock 1
	set tag [getTag 0 $x $y]
	if { $tag != ""} {
	    set did -1
	    catch {set did $dateID($tag)}
	    if { $did >=0} {
		if { $b == 3} {
		    set del_tag $tag
		    viewDate $did $dateByTag($tag) $timeByTag($tag)
		}
		if { $b == 1} {
		    editDate $did
		}
	    } else {
		set eddLock 0
	    }
	}
    }
}

proc coords2did { x  y} {
    global can dateID
    
    set did -1
    if { [winfo exists .edd ] == 0 } {
#	puts "Coords $x $y"
	set y  [ $can canvasy $y]
	set tag [getTag 0 $x $y]
#	puts "$x $y -> $tag"
	if { $tag != ""} {
	    set did -1
	    catch {set did $dateID($tag)}
#	    puts "$x $y -> $tag -> $did"
	    return $did
	}
    }
    return -1
}


proc deleteDialog {  } {
    global dateID del_tag can del_did
    global _calText _buttonText
    
    if { [winfo exists .dd ] == 1 } { return }
    toplevel .dd
    frame .dd.t -relief raised -bd 1
    frame .dd.b 
    pack .dd.t  -side top -fill x
    pack  .dd.b -side top -fill x -padx 2 -pady 4

    set del_did $dateID($del_tag)
    if { [string range $del_tag 0 3] ==  "term" } {
	set dtag $del_tag
    } else {
	set dtag [format "term%s" [string range $del_tag 3 end] ]
    }
#    puts stdout "$del_tag -> $dtag"
    message .dd.t.msg -text "$_calText(delDate1) '[$can itemcget $dtag -text ]' $_calText(delDate2)" -width 240
    pack .dd.t.msg -fill x
    button .dd.b.abb -text $_buttonText(Cancel) -command {closeWin .dd}
    button .dd.b.del -text $_buttonText(Delete) -command {doDeleteDate}
    pack .dd.b.abb -side left
    pack .dd.b.del -side right
    centerWin .dd 256 80
    update
    grab .dd
    

}
proc doDeleteDate {  } {
    global del_did username
    global _calText

    set ret [request deleteDate $del_did $username]
    if { $ret == "Error" } { 
	closeWin .dd
	_ErrorDialog $_calText(ErrorCantDelete) "$_allgText(Error): $_calText(ErrorCantDelete)\n$_calText(Reason):\n$ret"
	return 
    }
#     if { [string first $ret "ServerDown"] >=0 } {ServerDownDialog}
#     if { [string range $ret 0 2] =="ERR"} {
# 	ErrorDialog [string range $ret 3 end]
#     } else {
	drawUsersCalendar
#     }
    closeWin .dd
}

proc isDate1GreaterThanDate2 {d1 t1 d2 t2 } {
    if { $d1 >  $d2 } { 
	return 1
    }
    if { $d1 == $d2 } {
	if { $t1 > $t2 } { return 2}
    }

    return 0	
}

proc changeDate { step } {
    global monlen
    global curDay curMon curYear curOffset

#    puts -nonewline  "$curDay $curMon $curYear --> "
    set datum [ calcDate $curDay $curMon $curYear $step]
    set curDay  [lindex $datum 0]
    set curMon  [lindex $datum 1]
    set curYear [lindex $datum 2]

#    puts "$step ---> $curDay $curMon $curYear "
    drawCal
}

proc changeDateByMonth { step } {
    global curDay curMon curYear curOffset

    incr curMon $step
    while { $curMon >12} {
	incr curYear
	incr curMon -12
    }
    while { $curMon <1} {
	incr curYear -1
	incr curMon 12
    }
    drawCal
}  
proc calcDate2Str { str step} {
    set year [expr ($str /10000) ]
    set mon [expr ($str /100) % 100 ]
    set day [expr $str %100 ]
    set ret [calcDate $day $mon $year $step ]
    set day  [ lindex $ret 0]
    set mon  [ lindex $ret 1]
    set year [ lindex $ret 2]
    return [ format "%2d.%2d.%02d" $day $mon $year ]
}
proc calcDate2dstr { str step} {
    set year [expr ($str /10000) ]
    set mon [expr ($str /100) % 100 ]
    set day [expr $str %100 ]
    set ret [calcDate $day $mon $year $step ]
    set day  [ lindex $ret 0]
    set mon  [ lindex $ret 1]
    set year [ lindex $ret 2]
    return [ format "%04d%02d%02d"  $year $mon $day ]
}

proc calcDate { day mon year step} {
    global monlen curOffset

    incr day  $step
    set curOffset [expr ($curOffset  +$step +14) % 7 ]

    set extend 0
    if { $day > [lindex $monlen $mon] } {
	if { $mon == 2} {
	    if { [ expr $year % 4] == 4 } {
		if { $day<=29 } { set extend 1} } }
	if { $extend == 0 } { 
	    set day [expr $day - [lindex $monlen $mon]]
	    incr mon
	    if { $mon > 12 } {
		incr year
		set mon 1
	    }
	}
    }

    if { $day <1 } {
	incr mon -1
	if { $mon <1 } {
	    incr year -1
	    set mon 12
	}
	set day [ expr $day + [lindex $monlen $mon] ]
	if { $mon == 2} {
	    if { [ expr $year % 4] == 4 } {
		if { $day<=29 } { incr day} } }
    }
    return "$day $mon $year"
}

# proc tstBind { ev} {
#     puts "-> '$ev'"
# }


proc canStoreButtonPressKO {x y b } {
    global canAddStart_x canAddStart_y
    global xday can canAddDateRibbon

    set canAddDateRibbon 0

    $can delete ribbonCorner ribbon
    if { $b == 1} {
	set canAddStart_x $x
	set canAddStart_y $y
	
	set y1 [ $can canvasy $y]
	set tag [getTag 1 $x $y]
	set lcid [ string range $tag 2 end]
	
	$can create line $xday($lcid) [expr $y+6] $xday($lcid) $y [expr $xday($lcid)+6] $y -fill goldenrod -tag ribbonCorner -width 3
	
	after 250 update
	set canAddDateRibbon 1
    } else {
	set canAddStart_x 0
	set canAddStart_y 0 
	set canAddDateRibbon 0
    }
}

proc canDrawAddDateRibbon { x y b } {
    global xday can canAddDateRibbon canAddStart_y dxd logedIn canHeight canAddActiveLcid 
    
    if { $logedIn == 0 } { return }

    if { [expr [mouseStatus] & 256] == 0 } {
	set canAddDateRibbon 0
	$can delete ribbonCorner
	$can delete ribbon
	return
    }
    if { $canAddDateRibbon ==  1 } {
#	set y1 [ $can canvasy $y]
	if { $y <0 } { set y 0}
	if { $y >= $canHeight } {
	    set y $canHeight 
	    incr y -1
	}
	set tag [getTag 1 $x $y]
	set lcid [ string range $tag 2 end]
	if { $lcid == "" } { return }
	set canAddActiveLcid $lcid
	$can delete ribbon
	$can create rectangle $xday($lcid) $canAddStart_y [expr $xday($lcid) + $dxd] $y  -outline darkgoldenrod1 -tag ribbon -width 2
	$can raise ribbonCorner ribbon
	update
    }
}

proc canAddDate { x y b} {
    global wdList dyh username eddLock yOffAnz yOffList  can yday yday2
    global calKernStart calKernEnd calKernLen calDayStr yday2 calSplitOffset
    global groupList userList cur_Cal calUserName
    global canAddStart_x canAddStart_y
    global can  canAddDateRibbon
    global canAddActiveLcid

    #    puts "canAddDate  $x $y $eddLock"
    
    set canAddDateRibbon 0
    if { [winfo exists .edd ] == 0 } {
	set y1 [ $can canvasy $y]

	set tag [getTag 1 $x $y]

	set kind [string range $tag 0 1]
	set lcid [ string range $tag 2 end]
	set pos [ string last "-" $lcid ]
	set cid  [ string range $lcid 0 [expr $pos-1] ]
	set pos [ string first "-" $lcid ]
	set calNr  [ string range $lcid 0 [expr $pos-1] ]


	if { $kind != "jt" } {
	    set y2 [ $can canvasy $canAddStart_y]
	    if { [expr abs($y2 -$y1) ] > 5 } {
		set tag2 [getTag 1 $canAddStart_x $y2]
		set kind "wd"
		if { $y2 > $y1 } {
		    set list [ _cid2time $lcid $cid $y]
		    set hour  [ lindex $list 0]
		    set min   [ lindex $list 1]

		    set lcid2 [ string range $tag2 2 end]
		    set pos   [ string last "-" $lcid2  ]
		    set cid   [ string range $lcid2  0 [expr $pos-1] ]

		    set list  [ _cid2time $lcid2  $cid  $y2]
		    set hour2 [ lindex $list 0]
		    set min2  [ lindex $list 1]
		} else { 
		    set list  [ _cid2time $lcid $cid $y]
		    set hour2 [ lindex $list  0]
		    set min2  [ lindex $list  1]

		    set lcid2  [ string range $tag2 2 end]
		    set pos   [ string last "-" $lcid2  ]
		    set cid   [ string range $lcid2  0 [expr $pos-1] ]

		    set list [ _cid2time $lcid2  $cid  $y2]
		    set hour  [ lindex $list 0]
		    set min   [ lindex $list 1]
		}
		if { $hour < 0 } {
		    set hour 0
		    set min  0 
		}
		if { $hour2 < 0 } {
		    set hour2 23
		    set min2 59 
		}
		set lcid $canAddActiveLcid
	    } else {
		set list [ _cid2time $lcid $cid $y]
		set hour  [ lindex $list 0]
		set min   [ lindex $list 1]
		set hour2 -1
		set min2  -1
	    }
	}
	
	if { $lcid == "" } { return }
		    
	if { $kind == "wd" } {
	    if {"u-$username" == $cur_Cal } {
		invite $username - -  $calDayStr($lcid)  $hour $min $hour2 $min2
	    } else {
		set nam [string range $calUserName($calNr) 2 end] 
		if { [llength $nam ] > 1 } {
		    invite $username - - $calDayStr($lcid) $hour $min $hour2 $min2
		} else {
		    if { [ lsearch $userList $nam] >=0 } {
			invite $username  $nam u $calDayStr($lcid) $hour $min $hour2 $min2
		    } elseif { [ lsearch $groupList $nam] >=0 } {
			invite $username  $nam g $calDayStr($lcid) $hour $min $hour2 $min2
		    }
		}
	    }
	} elseif { $kind == "gd" } {
	    if {"u-$username" == $cur_Cal } {
		invite $username - - $calDayStr($lcid) -1 -1 -1 -1
	    } else {
		if { [ llength $calUserName($calNr)] >1 } {
		    invite $username - -  $calDayStr($lcid) -1 -1 -1 -1
		} else {
		    if { [ lsearch $userList $calUserName($calNr)] >=0 } {
			invite $username  $calUserName($calNr) u $calDayStr($lcid) -1 -1 -1 -1
		    } elseif { [ lsearch $groupList $calUserName($calNr)] >=0 } {
			invite $username  $calUserName($calNr) g $calDayStr($lcid) -1 -1 -1 -1
		    }
		}
	    }	    
	} elseif {$kind == "jt" } {
	    global calDay calMon calYear calTyp
	    global curDay curMon curYear
	    set curDay  $calDay($lcid)
	    set curMon  $calMon($lcid)
	    set curYear $calYear($lcid)
	    set calTyp d
	    drawCal
	}


#	newDate $username  [lindex $wdList $idx] [format "%2d%02d" $hour $min]
    }
    $can delete ribbonCorner
    $can delete ribbon
    update 

}

proc _cid2time { lcid cid y } {
    global wdList dyh username eddLock yOffAnz yOffList  can yday yday2
    global calKernStart calKernEnd calKernLen calDayStr yday2 calSplitOffset


    if { $lcid == ""  || $cid == "" } { return "-1 -1"}

    set yk    [expr $y -$yday2($cid) + $calSplitOffset($lcid)] 
    set ym(0) [expr 0  + $calKernStart*$dyh ]
    set ym(1) [expr $ym(0) + ($calKernLen)*$dyh  * 2]
    set ym(2) [expr $ym(1) + (24-$calKernEnd)*$dyh]
    set yb(0) 0
    set yb(1) $ym(0)
    set yb(2) $ym(1)
    set dy(0) $dyh
    set dy(1) [expr $dyh  * 2]
    set dy(2) $dyh
    set hb(0) 0
    set hb(1) $calKernStart
    set hb(2) $calKernEnd
    set hour 0
    for { set i 0 } { $i <3} {incr i} {
	if {$yk<$ym($i)} {
	    set h [expr double($yk - $yb($i))/$dy($i) +$hb($i) ]
	    set hour [ expr int(floor($h)) ]
	    set min  [ expr int(floor(($h-$hour) *4+.5))*15 ]
	    if {$min >=60 } {
		set min 0 
		incr hour
	    }
	    break
	}
    }

    if { $hour <0 } { 
	set hour  0
	set min 0 
    }
    if { $hour >=24 } {
	set hour 23
	set min 59
    }
    return "$hour $min"
}
