//!/usr/bin/X11/tixwish
//  File: address.cc
// 
//      This file is part of minkowsky
// 
//      Copyright (C) 2001-2002 by Rdiger Goetz
//      Author: Rdiger Goetz <minkowsky@r-goetz.de>
// 
//      Time-stamp: <10-Jun-2002 11:22:23 goetz>
// 
//      This program is free software; you can redistribute it and/or modify
//      it under the terms of the GNU General Public License as published by
//      the Free Software Foundation; either version 2 of the License, or
//      (at your option) any later version.
// 
//      This program is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU General Public License for more details.
// 
//      You should have received a copy of the GNU General Public License
//      along with this program; if not, write to the Free Software
//      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//  
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <errno.h>  
#include <time.h>  

#define ADDRESS 
#include "termin.h"

int fillStr2Address(char *tp[],Address *adr);
int adress2str(char *t,Address *adr,char *permStr);
int access2Adr(int uid, Address *adr);
int readAccess2Adr(int uid, Address *adr);
int access2Adr(int uid, Address *adr, char *permStr);
int readNotiz(Address *adr);
int readNotiz(AddressFolder *adf);
int readNotiz(FILE *fp,NotizControl *nc);
int writeNotiz(Address *adr);
int writeNotiz(AddressFolder *adf);
int writeNotiz(FILE *fp, NotizControl *nc);
int nextNotizID(int aid,int parent);
int nextDirNotizID(int dirid,int parent);
int addAdrNotiz(int aid,int parent, int uid,int date, int time, char *title, char *text);
int addDirNotiz(int dirid,int parent, int uid,int date, int time, char *title, char *text);
int fillNotiz(Notiz *ntz,int parent, int uid,int date, int time, char *title, char *text);
int addNotiz(int socket, char *str);
int changeNotiz(NotizControl *nc, int nid, char *text);
int changeNotiz(int aid, int nid, char *text);
int changeDirNotiz(int dirid, int nid, char *text);

void convertAdress0410(Address*adr, Address_0410 *adr410,int anz);
int adress2detailedStr(char *t,Address *adr,char *permStr);
void initAdrFolderList();
void clearAdrFolderList ();
void extendAdrFolderList();
int readAdrFolderList();
int writeAdrFolderList();
int createDefaultAdrFolderList ( );
int access2AdrFolder(int uid, AddressFolder *adf);
int owner2id(char *name);
char *id2owner(int id,char *t);
int folderName2dirid(char *name);

FileHeader addrFileHeader,addrFolderFileHeader;
char *adrFootPrint=NULL;


void initAdrList()
{
 adrList = new ( Address *) [DATEBLOCKSIZE];
 adrAnz=0;
 adrBlocks=1;
 adrMax = DATEBLOCKSIZE;
 strncpy(addrFileHeader.magic,FILEHEADER_MAGIC,8);
 strncpy(addrFileHeader.type,FILEHEADER_ADDR,4);
 strncpy(addrFileHeader.version,CURRENT_FILEVERSION_ADDR,4);
 addrFileHeader.size =0;
 initAdrFolderList();
}
void clearAdrList ()
{
 delete adrList;
}

void extendAdrList()
{
 Address **tmp;
 int anz,anz0;
 int i;
 
 printf("extending space for addresses\n");

 adrBlocks++;
 anz= adrBlocks * DATEBLOCKSIZE;
 tmp= new ( Address *) [anz];
 adrMax=anz;
 anz0= (adrBlocks-1)  * DATEBLOCKSIZE;

 memcpy(tmp,adrList,anz0*sizeof(Address *));
 delete adrList;
 adrList=tmp;
 for(i=anz0;i<anz; i++)
  adrList[i]=NULL;
}

void initAdrFolderList()
{
 int i;

 adfList = new ( AddressFolder *) [DATEBLOCKSIZE];
 adfAnz=0;
 adfBlocks=1;
 adfMax = DATEBLOCKSIZE;
 strncpy(addrFolderFileHeader.magic,FILEHEADER_MAGIC,8);
 strncpy(addrFolderFileHeader.type,FILEHEADER_ADDF,4);
 strncpy(addrFolderFileHeader.version,CURRENT_FILEVERSION_ADDF,4);
 addrFolderFileHeader.size =0;
 for(i=0;i<adfMax; i++)
  adfList[i]=NULL;
}
void clearAdrFolderList ()
{
 delete adfList;
}
void extendAdrFolderList()
{
 AddressFolder **tmp;
 int anz,anz0;
 int i;
 
 printf("extending space for addresses folders\n");

 adfBlocks++;
 anz= adfBlocks * DATEBLOCKSIZE;
 tmp= new ( AddressFolder *) [anz];
 adfMax=anz;
 anz0= (adfBlocks-1)  * DATEBLOCKSIZE;

 memcpy(tmp,adfList,anz0*sizeof(AddressFolder *));
 delete adfList;
 adfList=tmp;
 for(i=anz0;i<anz; i++)
  adfList[i]=NULL;
}


int updateDateCountsInAddress()
{
 int i,j,idx;
 Date *d;

 for(i=0; i<adrAnz; i++)
  adrList[i]->dateCount =0;

 for(i=0;i<dateAnz; i++)
  {
   d= dateList[i];
   if(d!=NULL)
    for(j=0;j<d->partAnz; j++)
     if(d->part[j].id >=ADDRESOFFSET && d->part[j].id <=MAX_ID)
      {
       idx = aid2idx(d->part[j].id-ADDRESOFFSET);
       //       printf("idx=%d\n",idx);
       if(idx>=0)
	adrList[idx]->dateCount++;
      }
  }
}
int deleteAddress(int socket,char *str)
{
 char *tp[4],buffer[8192];
 int aid,uid;
 Address *adr;

 split(str,tp,4);
 uid = uname2uid(tp[0]);
 aid=atoi(tp[1]);
 adr = adrList[aid2idx(aid)];

 if(access2Adr(uid,adr))
  adr->deleted=true;
 if (adr->deleted)
  {
   char file[1024];
   struct stat fstat;
   sprintf(file,"%s/notiz/Adr%08d.txt",dataDir,adr->id);
   if(stat(file,&fstat)==0)
     unlink(file);
   writeAdrList();
  }
 
 send2Client(socket,"done");
}

int changeAdress(int socket,char *ds)
{
 char *tp[128],*t,*s,buffer[16384];
 int aid,idx,uid;
 Address *adr;

 t=skip2nonWS(ds);
 if(*t!='{' && *t!='"')
  {
   s=buffer+1;
   buffer[0]=' ';
  }
 else
  s=buffer;
 strcpy(s,t);

 split(s,tp,128);

 aid=atoi(tp[0]);
 if(aid<0)
  {
   lastAid++;
   aid=lastAid;
   adr = new Address;
   memset(adr,0,sizeof(Address));
   adrList[adrAnz] = adr;
   adrAnz++;
   if(adrAnz >adrMax)
    extendAdrList();
   adr->id=lastAid;
   adr->dateCount=0;
   adr->notiz=NULL;

   uid =fillStr2Address(tp,adr);
   adr->created = adr->modified = today;
   adr->creator = adr->modifier = uid;
   adr->deleted = false;
  }
 else
  {
   idx = aid2idx(aid);
   adr =adrList[idx];
   if(!adr->deleted)
    {
     uid = fillStr2Address(tp,adr);
     adr->modified = today;
     adr->modifier = uid;
    }
  }
 sprintf(buffer,"%d",adr->id);
 send2Client(socket,buffer);
 writeAdrList();
}

//Format
// 0     1    2     3      4    5       6      7      8    9    10   11    12   13   14    15    16    17  18   19
// id  namet name1 nameM name2  compS compPos compa  fon0 fon1 fom2 fon3  fon4  fax fax2  mail mail2 mail3 www www2
//
//  20     21    22    23   24    25       26      27  28    29   20       31
//  adr1a adr1b adr1c plz1 city1 country1  adr2a adr2b adr2c plz2 city2 country2  
//
//   32    33    34    35   36     37       38     39     40  41     42
//  ad31a adr3b adr3c plz3 city3 country3  descrS descr info info2  geb 
//
//    43       44     45     46     47      48     49    50      51     52     53      54       55 
//  kontoInh1 -num1 -bank1 -blz1 kontoInh2 -num2 -bank2 -blz2  steuer  owner noteOnly readOnly user

int fillStr2Address(char *tp[],Address *adr)
{
 int id,i,uid;
 NotizControl *nc;
 void *ptr;


 strcpy(adr->titel       ,strTrim(tp[ 1]));
 strcpy(adr->name1       ,strTrim(tp[ 2]));
 adr->nameM = tp[3][0];
 strcpy(adr->name2       ,strTrim(tp[ 4]));
 strcpy(adr->compShort   ,strTrim(tp[ 5]));
 strcpy(adr->compPos     ,strTrim(tp[ 6]));
 strcpy(adr->company     ,strTrim(tp[ 7]));
 for(i=0;i<5;i++)
  strcpy(adr->fon[i]      ,strTrim(tp[ 8+i]));
 strcpy(adr->fax[0]      ,strTrim(tp[13]));
 strcpy(adr->fax[1]      ,strTrim(tp[14]));
 strcpy(adr->mail[0]     ,strTrim(tp[15]));
 strcpy(adr->mail[1]     ,strTrim(tp[16]));
 strcpy(adr->mail[2]     ,strTrim(tp[17]));
 strcpy(adr->www[0]      ,strTrim(tp[18]));
 strcpy(adr->www[1]      ,strTrim(tp[19]));
 for(i=0;i<3;i++)
  {
   strcpy(adr->addres[i][0],strTrim(tp[20+i*6]));
   strcpy(adr->addres[i][1],strTrim(tp[21+i*6]));
   strcpy(adr->addres[i][2],strTrim(tp[22+i*6]));
   strcpy(adr->plz[i]      ,strTrim(tp[23+i*6]));
   strcpy(adr->city[i]     ,strTrim(tp[24+i*6]));
   strcpy(adr->country[i]  ,strTrim(tp[25+i*6]));
  }
 strcpy(adr->descrShort  ,strTrim(tp[38]));
 strcpy(adr->descr       ,strTrim(tp[39]));
 strcpy(adr->info[0]     ,strTrim(tp[40]));
 strcpy(adr->info[1]     ,strTrim(tp[41]));
 strcpy(adr->geb         ,strTrim(tp[42]));
 strcpy(adr->kontoInh[0] ,strTrim(tp[43]));
 strcpy(adr->kontoNum[0] ,strTrim(tp[44]));
 strcpy(adr->kontoBank[0],strTrim(tp[45]));
 strcpy(adr->kontoBLZ[0] ,strTrim(tp[46]));
 strcpy(adr->kontoInh[1] ,strTrim(tp[47]));
 strcpy(adr->kontoNum[1] ,strTrim(tp[48]));
 strcpy(adr->kontoBank[1],strTrim(tp[49]));
 strcpy(adr->kontoBLZ[1] ,strTrim(tp[50]));
 strcpy(adr->steuer      ,strTrim(tp[51]));
 adr->owner    = owner2id(tp[52]);
 adr->noteOnly = owner2id(tp[53]);
 adr->readOnly = owner2id(tp[54]);

 uid =uname2uid(tp[55]);
 if(uid < 0 || uid > userAnz)
  uid=0;
 return(uid);
}

int sendAdrFolderList(int socket,char *str)
{
 char *tp[4],buffer[1024000],txt[8192],owner[64],*perm,*fname;
 int i,uid;

 split(str,tp,4);
 uid = uname2uid(tp[0]);
 if (uid <0 || uid > userAnz)
  {
   send2Client(socket,"no such user");
   return(false);
  }
 if (userList[uid].id  != uid)
  {
   send2Client(socket,"no such user");
   return(false);
  }
 
 strcpy(buffer,"");
 for(i=0;i<adfAnz; i++)
  if(adfList[i] !=NULL)
   if(!adfList[i]->deleted)
    {
     if(access2AdrFolder(uid,adfList[i]))
      perm="rwn";
     else
      perm="r--";
     
     if ( adfList[i]->id == 0 )
      {
       switch (serverLang)
	{
	case  MINKO_LANG_DE:
	 fname = "Adressbuch";
	 break;
	case  MINKO_LANG_EN:
	default:
	 fname = "Address book";
	}
      }
     else
      fname = adfList[i]->name;

     id2owner(adfList[i]->owner,owner);
     sprintf(txt,"{%d {%s} %d {%s} %d {%s}} ",adfList[i]->id,fname,adfList[i]->dirID,owner ,
	     adfList[i]->status &ADRF_START_OPEN,perm );
     strcat(buffer,txt);
    }
 send2Client(socket,buffer);
 return(true);
}

int makeAdrFolder(char *name, int owner, int parent)
{
 int dirid;

 dirid = adfAnz;
 adfAnz++;
 while(adfAnz>adfMax)
  extendAdrFolderList();
 
 adfList[dirid]  = new AddressFolder;
 memset(adfList[dirid],0,sizeof(AddressFolder));
 adfList[dirid]->id = dirid;
 adfList[dirid]->dirID = parent;
 strcpy(adfList[dirid]->name,name);
 adfList[dirid]->deleted =false;
 adfList[dirid]->notiz =NULL;
 adfList[dirid]->owner = owner;
 adfList[dirid]->status = 0;
 writeAdrFolderList();

 return(dirid);
}
// format dirid = makeAdrFolder  uid name owmner parent
int makeAdrFolder(int socket, char *str)
{
 char *tp[8],ret[64];
 int owner,uid,dirid,parent;

 split(str,tp,6);
 uid = uname2uid(tp[0]);
 if (uid <0 || uid > userAnz)
  {
   send2Client(socket,"no such user");
   return(false);
  }
 if (userList[uid].id  != uid)
  {
   send2Client(socket,"no such user");
   return(false);
  }
 
 parent = atoi(tp[3]);
 if(adfList[parent] == NULL)
  {
   send2Client(socket,"Error: parent does not exist\n");
   return(false);
  }
 if(adfList[parent]->deleted)
  {
   send2Client(socket,"Error: parent has been deleted\n");
   return(false);
  }
 
 dirid = makeAdrFolder(tp[1],owner2id(tp[2]),parent);

//  dirid = adfAnz;
//  adfAnz++;
//  while(adfAnz>adfMax)
//   extendAdrFolderList();
 
//  adfList[dirid]  = new AddressFolder;

//  adfList[dirid]->id = dirid;
//  adfList[dirid]->dirID = parent;
//  strcpy(adfList[dirid]->name,tp[1]);
//  adfList[dirid]->deleted =false;
//  adfList[dirid]->notiz =NULL;
//  adfList[dirid]->owner = owner2id(tp[2]);
 
 sprintf(ret,"%d",dirid);
 send2Client(socket,ret);
 return(true);
}


// format  changeAdrFolder   uid dirid name owmner [startClosed]
int changeAdrFolder(int socket, char *str)
{
 char *tp[8];
 int owner,uid,dirid,anz;

 anz =  split(str,tp,6);
 uid = uname2uid(tp[0]);
 if (uid <0 || uid > userAnz)
  {
   send2Client(socket,"no such user");
   return(false);
  }
 if (userList[uid].id  != uid)
  {
   send2Client(socket,"no such user");
   return(false);
  }
 
 dirid = atoi(tp[1]);
 if(adfList[dirid] == NULL)
  {
   send2Client(socket,"Error: folder does not exist\n");
   return(false);
  }
 if(adfList[dirid]->deleted)
  {
   send2Client(socket,"Error: folder has been deleted\n");
   return(false);
  }

 strcpy(adfList[dirid]->name,tp[2]);
 adfList[dirid]->deleted =false;
 adfList[dirid]->owner = owner2id(tp[3]);
 if (anz > 4)
  {
   if(tp[4][0]=='1')
    adfList[dirid]->status |= ADRF_START_OPEN;
   if(tp[4][0]=='0')
    adfList[dirid]->status &= ~ADRF_START_OPEN;
  }
 writeAdrFolderList();
 send2Client(socket,"done");
}
// format moveAdrObjToFolder  uid objtype(dir|adr) obj-id  destDirID
int moveAdrObjToFolder(int socket, char *str)
{
 char *tp[16384];
 int uid,id,idx,destid,i,j,anz;

 anz = split(str,tp,16383);
 uid = uname2uid(tp[0]);
 if (uid <0 || uid > userAnz)
  {
   send2Client(socket,"no such user");
   return(false);
  }
 if (userList[uid].id  != uid)
  {
   send2Client(socket,"no such user");
   return(false);
  }
 

 destid = atoi(tp[1]);
 if(adfList[destid] == NULL)
  {
   send2Client(socket,"Error: dest-folder does not exist\n");
   return(false);
  }
 if(adfList[destid]->deleted)
  {
   send2Client(socket,"Error: dest-folder has been deleted\n");
   return(false);
  }

 for(i=2; i<anz; i+=2)
  {
   if(i+1>=anz)
    break;
   
   id = atoi(tp[i+1]);
   if(strcasecmp(tp[i],"adr")==0)
    {
     idx =aid2idx(id);
     if(idx<0 || idx> adrAnz)
      continue;
     if(adrList[idx]->deleted)
      continue;
     adrList[idx]->dirID=destid;
    }
   else  if(strcasecmp(tp[i],"dir")==0)
    {
     if(adfList[id] == NULL)
      continue;
     if(adfList[id]->deleted)
      continue;
     if ( destid != id)
      adfList[id]->dirID = destid;
     else
      printf("\n\nWARNING: Movbing adrressfolder %d into itself (%d) forbidden\n",id,destid);
    }
   else
    continue;
  }
 writeAdrFolderList();
 writeAdrList();
 send2Client(socket,"done");
}

//TCL: delAdrFolder user dirid
int deleteAdrFolder (int socket, char *str)
{
 AddressFolder *adf;
 char *tp[5];
 int uid,dirid;
 
 split(str,tp,4);
 uid = uname2uid(tp[0]);
 dirid=atoi(tp[1]);

 if(access2AdrFolder(uid,adfList[dirid]))
  {
   adfList[dirid]->deleted=true;
   writeAdrFolderList();
  }
 send2Client(socket,"done");
}

int readAdrFolderList()
{
 FILE *fp;
 char file[4096],*buffer;
 int i,anz,j;
 struct stat fstat;
 AddressFolder *adf;
 FileHeader fh;
 int modified=false;
 int folderAnz;

 sprintf(file,"%s/addressFolders",dataDir);
 if((i=stat(file,&fstat))<0)
  {
   if(errno == ENOENT)
    {
     fp=fopen(file,"w");
     fclose(fp);
     if(stat(file,&fstat)<0)
      {
       printf("Can't open or create %s\n",file);
       exit(-1);
      }
     createDefaultAdrFolderList();
     writeAdrFolderList();
    }
   else
    {
     char msg[1024];
     perror("");
     printf("Bad file  %s \n",file);
     exit(-1);
    }
  }
 if (fstat.st_size == 0)
  {
   adfAnz =0;
   makeAdrFolder("Addressbuch",-1,-1);
   writeAdrFolderList();
   return(true);
  }
 
 fp=fopen(file,"r");
 if(fp==NULL)
  {
   printf("can't open %s\n",file);
   exit(-1);
  }

 fread(&fh,sizeof(FileHeader),1,fp);

 if(strncmp(fh.magic,FILEHEADER_MAGIC,8) !=0)
  {
   fprintf(stderr,"Error in reading AddressFolders, Format mismatch\n");
   exit(-1);
  }
 else
  {
   if(strncmp(fh.type,FILEHEADER_ADDF,4) !=0)
    {
     printf("address-folder-file structure damaged\n");
     exit(-1);
    }
   if(fh.size>0)
    {
     buffer = new char [fh.size+2];
     fread(buffer,sizeof(char),fh.size,fp);
    }
   if(strncmp(fh.version,CURRENT_FILEVERSION_ADDF,4) ==0)
    {

     adfAnz = (fstat.st_size/sizeof(AddressFolder));
     printf("reading %d addresses  folder (%d)\n",adfAnz,i);
     if(adfAnz==0)
      return(0);
     
     while(adfAnz>adfMax)
      extendAdrFolderList();
     
     adf = new AddressFolder [adfAnz+1];
     fread(adf,sizeof(AddressFolder),adfAnz,fp);
     fclose(fp);
    }
   if(strncmp(fh.version,"0411",4) ==0)
    {
     AddressFolder_0411 *adf_0411;
     adfAnz  = (fstat.st_size/sizeof(AddressFolder_0411));
     printf("reading %d addresses  folder (%d)\n",adfAnz,i);
     if(adfAnz==0)
      return(0);
     
     while(adfAnz>adfMax)
      extendAdrFolderList();
     
     adf_0411 = new AddressFolder_0411 [adfAnz+1];
     adf = new AddressFolder [adfAnz+1];
     fread(adf_0411,sizeof(AddressFolder_0411),adfAnz,fp);
     fclose(fp);
     for(j=0;j<adfAnz; j++)
      {
       memcpy(&adf[j],&adf_0411[j],sizeof(AddressFolder_0411));
       adf[j].status =0;
       memset(adf[j].res,0,64);
      }

    }
  }
 folderAnz=adfAnz;
 for(i=0;i<folderAnz; i++)
  {
   int id = adf[i].id;
   if(id>=adfAnz)
    adfAnz=id+1;
   while(adfAnz>adfMax)
    extendAdrFolderList();
   adfList[id] = adf+i;
   adfList[id]->notiz=NULL;
  }
 if(modified)
  writeAdrFolderList();
}

int writeAdrFolderList()
{
 FILE *fp;
 char file[4096];
 int i;

 sprintf(file,"%s/addressFolders",dataDir);
 fp=fopen(file,"w");
 if(fp==NULL)
  {
   printf("can't open %s\n",file);
   exit(-1);
  }
 fwrite(&addrFolderFileHeader,sizeof(FileHeader),1,fp);
 for(i=0;i<adfAnz; i++)
  if(adfList[i]!=NULL)
   if(! adfList[i]->deleted)
    fwrite(adfList[i],sizeof(AddressFolder),1,fp);

 fclose(fp);
}
int createDefaultAdrFolderList ( ) 
{
 
 adfList[0]  = new AddressFolder;

 adfList[0]->id =0;
 adfList[0]->dirID = -1;
 strcpy(adfList[0]->name,"Addressbuch");
 adfList[0]->deleted =false;
 adfList[0]->notiz =NULL;
 adfList[0]->owner =-1;
 adfAnz=1;
}

int readAdrList()
{
 FILE *fp;
 char file[4096],*buffer;
 int i,anz,j;
 struct stat fstat;
 Address *adr;
 FileHeader fh;
 int modified=false;

 
 readAdrFolderList();

 sprintf(file,"%s/address",dataDir);
 if((i=stat(file,&fstat))<0)
  {
   if(errno == ENOENT)
    {
     fp=fopen(file,"w");
     fwrite(&addrFileHeader,sizeof(FileHeader),1,fp);
     fclose(fp);
     if(stat(file,&fstat)<0)
      {
       printf("Can't open or create %s\n",file);
       exit(-1);
      }
    }
   else
    {
     char msg[1024];
     perror("");
     printf("Bad file  %s \n",file);
     exit(-1);
    }
  }
 if (fstat.st_size == 0)
  {
   adrAnz =0;
   writeAdrList();
   return(true);
  }
 
 fp=fopen(file,"r");
 if(fp==NULL)
  {
   printf("can't open %s\n",file);
   exit(-1);
  }

 fread(&fh,sizeof(FileHeader),1,fp);

 if(strncmp(fh.magic,FILEHEADER_MAGIC,8) !=0)
  {
   Address_0410 *adr410;
   rewind(fp);
   adrAnz = (fstat.st_size/sizeof(Address));
   printf("reading %d addresses (%d)\n",adrAnz,i);
   if(adrAnz==0)
    return(0);
   
   while(adrAnz>adrMax)
    extendAdrList();
   
   adr410 =  new Address_0410 [adrAnz+1];
   adr    =  new Address [adrAnz+1];
   fread(adr410,sizeof(Address_0410),adrAnz,fp);
   fclose(fp);
   convertAdress0410(adr,adr410,adrAnz);
   modified=true;
  }
 else
  {
   if(strncmp(fh.type,FILEHEADER_ADDR,4) !=0)
    {
     printf("address-file structure damaged\n");
     exit(-1);
    }
   if(fh.size>0)
    {
     buffer = new char [fh.size+2];
     fread(buffer,sizeof(char),fh.size,fp);
    }
   if(strncmp(fh.version,CURRENT_FILEVERSION_ADDR,4) ==0)
    {

     adrAnz = (fstat.st_size/sizeof(Address));
     printf("reading %d addresses (%d)\n",adrAnz,i);
     if(adrAnz==0)
      return(0);
     
     while(adrAnz>adrMax)
      extendAdrList();
     
     adr = new Address [adrAnz+1];
     fread(adr,sizeof(Address),adrAnz,fp);
     fclose(fp);
    }
   if(strncmp(fh.version,"0410",4) ==0)
    {
     Address_0410 *adr410;
     adrAnz = (fstat.st_size/sizeof(Address_0410));
     printf("reading %d addresses (%d)\n",adrAnz,i);
     if(adrAnz==0)
      return(0);
     
     while(adrAnz>adrMax)
      extendAdrList();
     
     adr410 =  new Address_0410 [adrAnz+1];
     adr    =  new Address [adrAnz+1];
     fread(adr410,sizeof(Address_0410),adrAnz,fp);
     fclose(fp);
     convertAdress0410(adr,adr410,adrAnz);
     modified=true;
    }
   
  }

 lastAid=-1;
 for(i=0;i<adrAnz; i++)
  {
   adrList[i] = adr+i;
   adrList[i]->notiz=NULL;
   if(adrList[i]->id>lastAid)
    lastAid = adrList[i]->id;
  }
 if(modified)
  writeAdrList();
}

void convertAdress0410(Address*adr, Address_0410 *adr410,int anz)
{
 int i;
 for( i=0 ;i<anz; i++)
  {
   adr[i].id      = adr410[i].id;
   adr[i].owner   = adr410[i].owner;
   adr[i].deleted = false;
   strcpy( adr[i].titel     ,adr410[i].titel      );
   strcpy( adr[i].name1     ,adr410[i].name1      );
   strcpy( adr[i].name2     ,adr410[i].name2      );
   strcpy( adr[i].compShort ,adr410[i].compShort  );
   strcpy( adr[i].company   ,adr410[i].company    );
   strcpy( adr[i].addres[0][0]  ,adr410[i].addres[0]    );
   strcpy( adr[i].addres[0][1]  ,adr410[i].addres[1]    );
   strcpy( adr[i].addres[0][2]  ,adr410[i].addres[2]    );
   strcpy( adr[i].city[0]       ,adr410[i].addres[3]    );
   strcpy( adr[i].country[0]    ,adr410[i].addres[4]    );
   strcpy( adr[i].fon[0]    ,adr410[i].fon[0]     );
   strcpy( adr[i].fon[4]    ,adr410[i].fon[1]     );
   strcpy( adr[i].fax[0]    ,adr410[i].fax        );
   strcpy( adr[i].mail[0]   ,adr410[i].mail       );
   strcpy( adr[i].www[0]    ,adr410[i].www        );
   strcpy( adr[i].descrShort,adr410[i].descrShort );
   strcpy( adr[i].descr     ,adr410[i].descr      );

   adr[i].nameM = ' ';
   strcpy(adr[i].compPos     ,"");
   strcpy(adr[i].plz[0]      ,"");
   strcpy(adr[i].addres[1][0] ,"");
   strcpy(adr[i].addres[1][2] ,"");
   strcpy(adr[i].addres[1][3] ,"");
   strcpy(adr[i].plz[1]      ,"");
   strcpy(adr[i].city[1]     ,"");
   strcpy(adr[i].country[1]  ,"");
   strcpy(adr[i].addres[2][0] ,"");
   strcpy(adr[i].addres[2][2] ,"");
   strcpy(adr[i].addres[2][3] ,"");
   strcpy(adr[i].plz[2]      ,"");
   strcpy(adr[i].city[2]     ,"");
   strcpy(adr[i].country[2]  ,"");
   strcpy(adr[i].fon[1]      ,"");
   strcpy(adr[i].fon[2]      ,"");
   strcpy(adr[i].fon[3]      ,"");
   strcpy(adr[i].fax[1]      ,"");
   strcpy(adr[i].mail[1]     ,"");
   strcpy(adr[i].mail[2]     ,"");
   strcpy(adr[i].www[1]      ,"");
   strcpy(adr[i].info[0]     ,"");
   strcpy(adr[i].info[1]     ,"");
   strcpy(adr[i].kontoInh[0] ,"");
   strcpy(adr[i].kontoNum[0] ,"");
   strcpy(adr[i].kontoBank[0],"");
   strcpy(adr[i].kontoBLZ[0] ,"");
   strcpy(adr[i].kontoInh[1] ,"");
   strcpy(adr[i].kontoNum[1] ,"");
   strcpy(adr[i].kontoBank[1],"");
   strcpy(adr[i].kontoBLZ[1] ,"");
   strcpy(adr[i].steuer      ,"");
   strcpy(adr[i].geb         ,"");
   adr[i].noteOnly  = adr[i].owner;
   adr[i].readOnly  = adr[i].owner;
   adr[i].dirID     = 0;
   adr[i].created   = 20011231;
   adr[i].modified  = 20011231;
   adr[i].creator   = 0;
   adr[i].modifier  = 0;
   memset(adr[i].reserved,0,sizeof(char)*256);
   memset(adr[i].resv,0,sizeof(int)*8);
   adr[i].action =NULL;
  }
}
int writeAdrList()
{
 FILE *fp;
 char file[4096];
 int i;

 sprintf(file,"%s/address",dataDir);
 fp=fopen(file,"w");
 if(fp==NULL)
  {
   printf("can't open %s\n",file);
   exit(-1);
  }
 fwrite(&addrFileHeader,sizeof(FileHeader),1,fp);
 for(i=0;i<adrAnz; i++)
  if(adrList[i]!=NULL)
   if(! adrList[i]->deleted)
    fwrite(adrList[i],sizeof(Address),1,fp);

 fclose(fp);
}

int sendBriefAdressList(int socket,char *str)
{ 
 int uid,i,perm,gid,j;
 char buffer[250000],txt[128];
 char *tp[4];

 split (str,tp,4);
 uid = uname2uid(tp[0]);
 briefAdressList(uid,buffer);
 send2Client(socket,buffer);
}

char *briefAdressList(int uid, char *buffer)
{
 int i;
 char txt[128];

 strcpy(buffer,"");
 for(i=0;i<adrAnz; i++)
  {
   if(readAccess2Adr(uid,adrList[i]))
    {
     adrIdx2cname(i,txt);
     strcat(buffer,txt);
    }
  }

}
int sendAddresssList(int socket,char *str)
{
 char *tp[4],buffer[1024000],txt[8192],adrPrmStr[16];
 int i,uid;

 split(str,tp,4);
 uid = uname2uid(tp[0]);
 // uid=atoi(tp[0]);
 
 strcpy(buffer,"");
 for(i=0;i<adrAnz; i++)
  if(access2Adr(uid,adrList[i],adrPrmStr))
   {
    txt[0]='{';
    adress2str(txt+1,adrList[i],adrPrmStr);
    strcat(txt,"} ");
    strcat(buffer,txt);
   }

 send2Client(socket,buffer);
}
int sendAddress(int socket,char *str)  // request 
{
 char *tp[4],buffer[4096], adrPrmStr[16];
 int aid,uid,i,anz;
 Address *adr;

 split(str,tp,4);
 uid = uname2uid(tp[0]);
 // uid=atoi(tp[0]);
 aid=atoi(tp[1]);
 adr = adrList[aid2idx(aid)];

 if(access2Adr(uid,adr,adrPrmStr))
  adress2str(buffer,adr,adrPrmStr);
 
 send2Client(socket,buffer);

}

// Syntax getFullAddr username {aid-list} 
//     or getFullAddr username aid
int sendFullAddress(int socket,char *str)  // request 
{
 char *tp[4],*tp2[1024],buf[4096],adrPrmStr[16],*buffer;
 int aid,uid,anz,i;
 Address *adr;

 split(str,tp,4);
 uid = uname2uid(tp[0]);
 anz  = split(tp[1],tp2,1024);
 if ( anz ==0  )
  {
   sprintf(buf,"Error: no address requested");
   send2Client(socket,buf);
   return(0);
  }

 printf("%d : %s\n",anz,tp2[0]);
 buffer = new char [4086*anz];
 if (buffer == NULL) 
  {
   sprintf(buf,"Error: no memory on server");
   send2Client(socket,buf);
   return(0);
  }
 buffer[0]='\0';
 // uid=atoi(tp[0]);
 for(i=0;i<anz; i++)
  {
   aid=atoi(tp2[i]);
   adr = adrList[aid2idx(aid)];

   if(access2Adr(uid,adr,adrPrmStr) )
    adress2detailedStr(buf,adr,adrPrmStr);
   else
    {
     if(verbose)
      printf("no access for %s to aid=%d\n",tp[0],aid);
    }
   if (anz>1)
    strcat(buffer,"{");
   strcat(buffer,buf);
   if (anz>1)
    strcat(buffer,"} ");
  }
 if ( buffer[0] == '\0' )
  sprintf(buffer,"Error: no access");

 
 send2Client(socket,buffer);
 printf("removing memory\n");
 delete buffer;
}


//Format
// 0     1    2     3      4    5       6      7      8    9    10   11    12   13   14   
// id  namet name1 nameM name2  compS compPos compa  fon0 fon1 fom2 fax   mail mail2 www  
//
//   15    16   17  18  19    20      21     22     23       24      25     26     27
//  adr1 adr2 adr3 plz city country descrS  owner noteOnly readOnly status dirID  rwn
int adress2str(char *t,Address *adr,char *adrPrmStr)
{
 char owner[32],noteOnly[32],readOnly[32],mi;
 int status=0;

 id2owner(adr->owner,owner);
 id2owner(adr->noteOnly,noteOnly);
 id2owner(adr->readOnly,readOnly);


 if(adr->dateCount>0)
  status=1;
 if (adr->nameM == '\0')
  mi =' ';
 else
  mi = adr->nameM;
 sprintf(t,"%d   {%s} {%s} {%c} {%s}   {%s} {%s} {%s}   {%s} {%s} {%s} {%s}   {%s} {%s} {%s}   {%s} {%s} {%s} {%s} {%s} {%s}   {%s}   {%s} {%s} {%s}  %d %d {%s}",
	 adr->id,adr->titel,adr->name1,mi,adr->name2,
	 adr->compShort,adr->compPos,adr->company, adr->fon[0],adr->fon[1],adr->fon[2],adr->fax[0],
	 adr->mail[0],adr->mail[1],adr->www[0],   
	 adr->addres[0][0],adr->addres[0][1],adr->addres[0][2],adr->plz[0],adr->city[0],adr->country[0],
	 adr->descr,owner,noteOnly,readOnly,status,adr->dirID,adrPrmStr);
 //rintf("adr %d -> %s\n",adr->id,t);
}
//Format
// 0     1    2     3      4    5       6      7      8    9    10   11    12   13   14    15    16    17  18   19
// id  namet name1 nameM name2  compS compPos compa  fon0 fon1 fom2 fon3  fon4  fax fax2  mail mail2 mail3 www www2
//
//  20     21    22    23   24    25       26      27  28    29   30       31
//  adr1a adr1b adr1c plz1 city1 country1  adr2a adr2b adr2c plz2 city2 country2  
//
//   32    33    34    35   36     37       38     39     40  41     42
//  ad31a adr3b adr3c plz3 city3 country3  descrS descr info info2  geb 
//
//    43       44     45     46     47      48     49    50      51     52     53      54       55    
//  kontoInh1 -num1 -bank1 -blz1 kontoInh2 -num2 -bank2 -blz2  steuer  owner noteOnly readOnly status 
//
//    56      57     58      59        60     61
//  created modified creator modifier dirID  rwn
int adress2detailedStr(char *t,Address *adr,char *adrPrmStr)
{
 char owner[32],noteOnly[32],readOnly[32],mi;
 int status=0;

 id2owner(adr->owner,owner);
 id2owner(adr->noteOnly,noteOnly);
 id2owner(adr->readOnly,readOnly);


 if(adr->dateCount>0)
  status=1;

 if (adr->nameM == '\0')
  mi =' ';
 else
  mi = adr->nameM;
 sprintf(t,"%d {%s} {%s} {%c} {%s}   {%s} {%s} {%s}     {%s} {%s} {%s} {%s} {%s} {%s} {%s}    {%s} {%s} {%s} {%s} {%s}     {%s} {%s} {%s} {%s} {%s} {%s}  {%s} {%s} {%s} {%s} {%s} {%s}  {%s} {%s} {%s} {%s} {%s} {%s}    {%s} {%s} {%s} {%s}    {%s}    {%s} {%s} {%s} {%s}   {%s} {%s} {%s} {%s}    {%s}   {%s} {%s} {%s}   %d %d %d {%s} {%s} %d   {%s}",
	 adr->id,adr->titel,adr->name1,mi,adr->name2,
	 adr->compShort,adr->compPos,adr->company, 
	 adr->fon[0],adr->fon[1],adr->fon[2],adr->fon[3],adr->fon[4],adr->fax[0],adr->fax[1],
	 adr->mail[0],adr->mail[1],adr->mail[2],adr->www[0], adr->www[1],   
	 adr->addres[0][0],adr->addres[0][1],adr->addres[0][2],adr->plz[0],adr->city[0],adr->country[0],
	 adr->addres[1][0],adr->addres[1][1],adr->addres[1][2],adr->plz[1],adr->city[1],adr->country[1],
	 adr->addres[2][0],adr->addres[2][1],adr->addres[2][2],adr->plz[2],adr->city[2],adr->country[2],
	 adr->descrShort,adr->descr, adr->info[0],adr->info[1],adr->geb,
	 adr->kontoInh[0],adr->kontoNum[0],adr->kontoBank[0],adr->kontoBLZ[0],
	 adr->kontoInh[1],adr->kontoNum[1],adr->kontoBank[1],adr->kontoBLZ[1],adr->steuer,
	 owner,noteOnly,readOnly,status,adr->created,adr->modified,
	 userList[adr->creator].name, userList[adr->modifier].name,adr->dirID,adrPrmStr);
 return(true);
}



int access2Adr(int uid, Address *adr)
{
 int perm,j,gid,i;
 
 if(adr->deleted)
  return(false);



 perm=false;

 if(uid==0)
  return(true);

 if(adr->owner == -1)
  perm=true;
 else if(adr->owner >=GROUPOFFSET)
  {
   gid = adr->owner -GROUPOFFSET;
   for(j=0;groupList[gid].anz; j++)
    if(groupList[gid].membr[j] == uid)
     {
      perm=true;
      break;
     }
  }
 else if(adr->owner == uid)
  perm=true;

 for(i=0;groupList[0].anz; i++)
  if(groupList[0].membr[i] == uid)
   return(true);

 return(perm);
}

int readAccess2Adr(int uid, Address *adr)
{
 int perm=false,j,gid;

 
 if(adr->deleted)
  return(false);

 perm=false;
 if(adr->owner == -1 || adr->noteOnly == -1 || adr->readOnly == -1)
  {
   perm=true;
  }
 else if(adr->owner == uid || adr->noteOnly == uid || adr->readOnly == uid)
  {
   perm=true;
   
  }
 if(!perm)
  if(adr->owner >=GROUPOFFSET)
   {
    gid = adr->owner -GROUPOFFSET;
    for(j=0;j<groupList[gid].anz; j++)
     if(groupList[gid].membr[j] == uid)
      {
       perm=true;
       break;
      }
   }
 if(!perm)
  if(adr->noteOnly >=GROUPOFFSET)
   {
    gid = adr->noteOnly -GROUPOFFSET;
    for(j=0;j<groupList[gid].anz; j++)
     if(groupList[gid].membr[j] == uid)
      {
       perm=true;
       break;
      }
   }
 if(!perm)
  if(adr->noteOnly >=GROUPOFFSET)
   {
    gid = adr->noteOnly -GROUPOFFSET;
    for(j=0;j<groupList[gid].anz; j++)
     if(groupList[gid].membr[j] == uid)
      {
       perm=true;
       break;
      }
   }
 return(perm);
}

int access2Adr(int uid, Address *adr, char *adrPrmStr)
{
 int perm=false,j,gid;

 strcpy(adrPrmStr,"");
 
 if(adr->deleted)
  return(false);

 perm=false;
 if(adr->owner == -1)
  {
   strcpy(adrPrmStr,"rwn");
   perm=true;
  }
 else if(adr->owner >=GROUPOFFSET)
  {
   gid = adr->owner -GROUPOFFSET;
   for(j=0;j<groupList[gid].anz; j++)
    if(groupList[gid].membr[j] == uid)
     {
      strcpy(adrPrmStr,"rwn");
      perm=true;
      break;
     }
  }
 else if(adr->owner == uid)
  {
   strcpy(adrPrmStr,"rwn");
   perm=true;
  }
 
 if(perm)
  return(perm);

 if(adr->noteOnly == -1)
  {
   strcpy(adrPrmStr,"r-n");
   perm=true;
  }
 else if(adr->noteOnly >=GROUPOFFSET)
  {
   gid = adr->noteOnly -GROUPOFFSET;
   for(j=0;j<groupList[gid].anz; j++)
    if(groupList[gid].membr[j] == uid)
     {
      strcpy(adrPrmStr,"r-n");
      perm=true;
      break;
     }
  }
 else if(adr->noteOnly == uid)
  {
   strcpy(adrPrmStr,"r-n");
   perm=true;
  }

 if(perm)
  return(perm);

 if(adr->readOnly == -1)
  {
   strcpy(adrPrmStr,"r--");
   perm=true;
  }
 else if(adr->readOnly >=GROUPOFFSET)
  {
   gid = adr->readOnly -GROUPOFFSET;
   for(j=0;j<groupList[gid].anz; j++)
    if(groupList[gid].membr[j] == uid)
     {
      strcpy(adrPrmStr,"r--");
      perm=true;
      break;
     }
  }
 else if(adr->readOnly == uid)
  {
   strcpy(adrPrmStr,"r--");
   perm=true;
  }
 
 return(perm);
}

int access2AdrFolder(int uid, AddressFolder *adf)
{
 int perm,j,gid,i;
 
 if(adf->deleted)
  return(false);

 if(uid==0)
  return true;


 perm=false;
 if(adf->owner == -1)
  perm=true;
 else if(adf->owner >=GROUPOFFSET)
  {
   gid = adf->owner -GROUPOFFSET;
   for(j=0;j<groupList[gid].anz; j++)
    if(groupList[gid].membr[j] == uid)
     {
      perm=true;
      break;
     }
  }
 else if(adf->owner == uid)
  perm=true;

 for(i=0;groupList[0].anz; i++)
  if(groupList[0].membr[i] == uid)
   return(true);

 return(perm);
}





int aname2aid(char *name)
{
 int i=-1;
 char cname[256];

 for(i=0; i<adrAnz; i++)
  {
   adrIdx2name(i,cname);
   printf("cname='%s' name='%s'\n",cname,name);
   if(strcmp(name,cname)==0)
    return(adrList[i]->id);
  }
 return(-1);
}

int aname2idx(char *name)
{
 int i;
 char cname[256];

 for(i=0; i<adrAnz; i++)
  {
   adrIdx2name(i,cname);
   if(strcmp(name,cname)==0)
    return(i);
  }
 return(-1);
}

int aid2idx(int aid)
{
 int i=-1;
 for(i=0;i<adrAnz; i++)
  if(adrList[i]->id==aid)
   return(i);
 return(-1);
}

char * aid2name(int aid,char *t)
{
 Address *adr;
 int idx;

 idx =aid2idx(aid);
 if(idx<0)
   strcpy(t,"?? adress unknown ??");
 else
  {
   adr= adrList[idx];
   
   if(adr->titel[0] == '\0')
    sprintf(t,"%s %s",adr->name1,adr->name2);
   else
    sprintf(t,"%s %s %s",adr->titel,adr->name1,adr->name2);
  }
 return(t);
}
char * adrIdx2name(int idx,char *t)
{
 Address *adr;

 if(idx<0)
  strcpy(t,"?? adress unknown ??");
 else 
  {
   adr= adrList[idx];
   
   if(adr->titel[0] == '\0')
    sprintf(t,"%s %s",adr->name1,adr->name2);
   else
    sprintf(t,"%s %s %s",adr->titel,adr->name1,adr->name2);
  }
 return(t);
}
char * aid2cname(int aid,char *t)
{
 int idx;
 char tx[256];

 idx =aid2idx(aid);
 sprintf(t,"{%s} ",adrIdx2name(idx,tx));
 return(t);
}
char * adrIdx2cname(int idx,char *t)
{
 char tx[256];

 sprintf(t,"{%s} ",adrIdx2name(idx,tx));
 return(t);
}


int  owner2id(char *name)
{
 int id=-1;
 
 if(strcmp(name,"Allgemein")==0)
  id=-1;
 else
  {
   id=uname2uid(name);
   if(id>=0)
    id=id;
   else
    {
     id=gname2gid(name);
     if(id>=0)
      id=id+GROUPOFFSET;
     else
      id=-1;
    }
  }
 return (id);
}

char *id2owner(int id,char *t)
{
 if(id <0)
  strcpy(t,"Allgemein");
 else if(id >=GROUPOFFSET)
  strcpy(t,groupList[id-GROUPOFFSET].name);
 else
  strcpy(t,userList[id].name);
 return(t);
}


int folderName2dirid(char *name)
{
 int i;
 for(i=0;i<adfAnz;i++)
  if(adfList[i]!=NULL)
   if(!adfList[i]->deleted)
    if(strcmp(adfList[i]->name,name)==0)
     return(adfList[i]->id);
 return(-1);
}

// new notiz blocks
NotizControl *initNotizList(int id,int type)
{
 int i;
 NotizControl *nc;
 
 nc = new  NotizControl;
 nc->notiz = new Notiz [DATEBLOCKSIZE];
 nc->max =DATEBLOCKSIZE;
 nc->anz=0;
 nc->aid=id;
 nc->type=type;
 for(i =0; i< DATEBLOCKSIZE ;i++)\
  {
   nc->notiz[i].title =NULL;
   nc->notiz[i].text =NULL;
   nc->notiz[i].id=-1;
   nc->notiz[i].status = NOTIZ_EMPTY;
  }
 return(nc);
}
void initNotizList(int aid)
{
 Address *adr;
 int aidx;

 aidx=aid2idx(aid);
 if(0<=aidx && aidx <=adrAnz)
  if(adrList[aidx]->notiz ==NULL)
   adrList[aidx]->notiz=initNotizList(aid,ADDRESS_NOTIZ);
//   {
//    initNotizList(adrList[aidx]);
}
void initDirNotizList(int dirid)
{
 AddressFolder *adf;
 int aidx;

 if(0<=dirid && dirid <=adrAnz)
  {
   adf = adfList[dirid];
   if(adf !=NULL)
    if(adf->notiz ==NULL)
     adf->notiz=initNotizList(dirid,FOLDER_NOTIZ);
  }
}



void clearNotizList ( NotizControl *nc)
{
 Address *adr;
 int i;

 if(nc!= NULL)
  {
   for(i=0;i<nc->anz ; nc++)
    if(nc->notiz[i].id>=0)
     {
      if(nc->notiz[i].title !=NULL)
       delete nc->notiz[i].title;
      if(nc->notiz[i].text !=NULL)
       delete nc->notiz[i].text;
     }
   delete nc->notiz;
   delete nc;
  }
}

void extendNotizList(NotizControl *nc)
{
 Notiz *tmp;
 int i;
 
 tmp = new Notiz [nc->max + DATEBLOCKSIZE];
 memcpy(tmp,nc->notiz, sizeof(Notiz) * nc->max);
 delete nc->notiz;
 nc->notiz = tmp;
 for(i =nc->max; i<nc->max + DATEBLOCKSIZE ;i++)\
  {
   nc->notiz[i].title =NULL;
   nc->notiz[i].text =NULL;
   nc->notiz[i].id=-1; 
   nc->notiz[i].status = NOTIZ_EMPTY;
  }
 nc->max += DATEBLOCKSIZE;
}
void extendNotizList(int aid)
{
 Address *adr;
 int aidx;

 aidx=aid2idx(aid);
 if(0<=aidx && aidx <=adrAnz)
  {
   adr = adrList[aidx];
   if(adr->notiz ==NULL)
    adr->notiz=initNotizList(aid,ADDRESS_NOTIZ);
   extendNotizList(adr->notiz);
  }
}
void extendDirNotizList(int dirid)
{
 AddressFolder *adf;
 int aidx;

 if(0<=dirid && dirid <=adfAnz)
  {
   adf = adfList[dirid];
   if(adf !=NULL)
    {
     if(adf->notiz ==NULL)
      adf->notiz=initNotizList(dirid,FOLDER_NOTIZ);
     extendNotizList(adf->notiz);
    }
  }
}

int readNotiz(Address *adr)
{
 FILE *fp;
 char file[1024];
 struct stat fstat;

 if(adr->notiz == NULL)
  adr->notiz = initNotizList(adr->id,ADDRESS_NOTIZ);

 sprintf(file,"%s/notiz/Adr%08d.txt",dataDir,adr->id);
 if(stat(file,&fstat)<0)
  return(false);
 
 fp=fopen(file,"r");
 if(fp==NULL)
  {
   printf("can't open %s\n",file);
   return(false);
  }

 printf("reading Notiz form '%s'\n",file);
 readNotiz(fp,adr->notiz);
 fclose(fp);
 return(true); 
}
int readNotiz(AddressFolder *adf)
{
 FILE *fp;
 char file[1024];
 struct stat fstat;

 if(adf->notiz == NULL)
  adf->notiz= initNotizList(adf->id,FOLDER_NOTIZ);

 sprintf(file,"%s/notiz/Dir%08d.txt",dataDir,adf->id);
 if(stat(file,&fstat)<0)
  return(false);
 
 fp=fopen(file,"r");
 if(fp==NULL)
  {
   printf("can't open %s\n",file);
   return(false);
  }

 readNotiz(fp,adf->notiz);
 fclose(fp);
 return(true); 
}
int readNotiz(FILE *fp,NotizControl *nc)
{
 char line[4096],*tp[64];
 int count=0,i;
 int nid;
 Notiz *ntz;
 char *buffer,*tmp;
 int bufferLen;
 int textLen,len;

 while (fgets(line,4095,fp) !=NULL)
  {
   if(strncmp(line,"%$NOTIZ",7)==0)
    count ++;
  }
 rewind(fp);
 while(count >=nc->max)
  extendNotizList(nc);

 buffer=new char [65536];
 bufferLen=65536;

 printf("\t\treading %d notizen\n",count);
 for(i=0;i<count; i++)
  {
   if(fgets(line,4095,fp)!=NULL)
    {
     split(line,tp,64);
     nid = atoi(tp[1]);
     if(nid <= nc->anz)
      nc->anz = nid +1;
     if(nc->anz >= nc->max)
      extendNotizList(nc);
     ntz = &nc->notiz[nid];
     ntz->id =nid;
     ntz->parent= atoi(tp[2]);
     ntz->uid   = uname2uid(tp[3]);
     ntz->date  = atoi(tp[4]);
     ntz->time  = atoi(tp[5]);
     ntz->title = new char [strlen(tp[6]) +4];
     strcpy(ntz->title,tp[6]);
     textLen=0;
     strcpy(buffer,"");

     for(;;)
      {
       if(fgets(line,4095,fp)!=NULL)
	{
	 if(strncmp(line,"%$END",5)==0)
	  {
	   break;
	  }
	 else
	  {
	   len = strlen(line);
	   while(len+textLen > bufferLen)
	    {
	     tmp = new char [bufferLen +65536];
	     strcpy(tmp,buffer);
	     delete buffer;
	     buffer =tmp;
	     bufferLen += 65536;
	    }
	   strcat(buffer,line);
	   textLen += len+1;
	  }
	}
      }
     ntz->text = new char [ strlen(buffer)+4];
     strcpy(ntz->text,buffer);
     ntz->status = NOTIZ_FILLED;
    }
  }
}
int writeNotiz(Address *adr)
{
 char file[1024];
 FILE *fp;

 printf("writing Notiz : %p\n",adr->notiz);
 if(adr->notiz == NULL)
  return(true);
 
 sprintf(file,"%s/notiz/Adr%08d.txt",dataDir,adr->id);
 fp=fopen(file,"w");
 if(fp==NULL)
  {
   printf("can't open %s\n",file);
   delete adr->notiz;
   adr->notiz=NULL;
   return(false);
  }
 writeNotiz(fp,adr->notiz);
 fclose(fp);
}
int writeNotiz(AddressFolder *adf)
{
 char file[1024];
 FILE *fp;

 printf("writing Notiz : %p\n",adf->notiz);
 if(adf->notiz == NULL)
  return(true);
 
 sprintf(file,"%s/notiz/Dir%08d.txt",dataDir,adf->id);
 fp=fopen(file,"w");
 if(fp==NULL)
  {
   printf("can't open %s\n",file);
   delete adf->notiz;
   adf->notiz=NULL;
   return(false);
  }
 writeNotiz(fp,adf->notiz);
 fclose(fp);
}
int writeNotiz(FILE *fp,NotizControl *nc)
{
 Notiz *ntz;
 int i;

 for(i=0;i<nc->anz ; i++)
  {
   ntz = &nc->notiz[i];

   printf("%$NOTIZ %d %d %s %d %d {%s}\n",ntz->id, ntz->parent, userList[ntz->uid].name, ntz->date,ntz->time,ntz->title);
   fprintf(fp,"%$NOTIZ %d %d %s %d %d {%s}\n",ntz->id, ntz->parent, userList[ntz->uid].name, ntz->date,ntz->time,ntz->title);
   fprintf(fp,"%s\n",ntz->text);
   fprintf(fp,"%$END\n");
  }
}

int nextNotizID(int aid,int parent)
{
 Address *adr;
 int nid;
 int aidx;

 aidx=aid2idx(aid);
 if(0<=aidx && aidx <=adrAnz)
  {
   adr = adrList[aidx];
   if(adr->notiz==NULL)
    initNotizList(aid);
   nid = adr->notiz->anz;
   if(parent<-1 || parent>= adr->notiz->anz)
    parent =-1;

   printf("notiz anz for %d = %d\n",aid,adr->notiz->anz);
   adr->notiz->anz++;
   if(adr->notiz->anz >= adr->notiz->max)
    extendNotizList(aid);
   adr->notiz->notiz[nid].id = nid;
   adr->notiz->notiz[nid].parent = parent;
   adr->notiz->notiz[nid].status = NOTIZ_ALLOC;
   return(adr->notiz->anz-1);
  }
 return(-1);
}
int nextDirNotizID(int dirid,int parent)
{
 AddressFolder *adf;
 int nid;
 int aidx;

 
 if(0<=dirid && dirid <=adfAnz)
  {
   adf = adfList[dirid];
   if(adf!=NULL)
    {
     if(adf->notiz==NULL)
      initDirNotizList(dirid);
     nid = adf->notiz->anz;
     if(parent<-1 || parent>= adf->notiz->anz)
      parent =-1;

     adf->notiz->anz++;
     if(adf->notiz->anz >= adf->notiz->max)
      extendDirNotizList(dirid);
     adf->notiz->notiz[nid].id = nid;
     adf->notiz->notiz[nid].parent = parent;
     adf->notiz->notiz[nid].status = NOTIZ_ALLOC;
     return(adf->notiz->anz-1);
    }
   return(-1);
  }
 return(-1);
}

int addAdrNotiz(int aid,int parent, int uid,int date, int time, char *title, char *text)
{ 
 Address *adr;
 Notiz *ntz;
 int nid;
 int aidx;

 aidx = aid2idx(aid);
 
 
 if(aidx<0 || aidx>=adrAnz)
  return(false);
 adr = adrList[aidx];
 if(adr->notiz==NULL)
  readNotiz(adr);
 if(adr->notiz==NULL)
  return(false);
 if(parent<0 || parent > adr->notiz->anz )
  parent =-1;

 nid=  nextNotizID(aid,parent);
 if(nid<0)
  return(nid);
 
 fillNotiz(&adr->notiz->notiz[nid],parent,uid,date,time,title,text);
//  ntz->uid   = uid;
//  ntz->date  = date;
//  ntz->time  = time;
//  ntz->title = new char [strlen(title) +4];
//  ntz->text  = new char [strlen(text) +4];
//  strcpy(ntz->title,title);
//  strcpy(ntz->text,text);
//  ntz->status = NOTIZ_FILLED;
 printf("adr->notiz=%p\n",adr->notiz);
 writeNotiz(adr);

 return(nid);
}
int addDirNotiz(int dirid,int parent, int uid,int date, int time, char *title, char *text)
{ 
 AddressFolder *adf;
 Notiz *ntz;
 int nid;

 
 
 if(dirid<0 || dirid>=adfAnz)
  return(false);
 
 adf = adfList[dirid];
 if(adf == NULL)
  return(false);
 if(adf->notiz==NULL)
  readNotiz(adf);
 if(adf->notiz==NULL)
  return(false);
 if(parent<0 || parent > adf->notiz->anz )
  parent =-1;

 nid=  nextDirNotizID(dirid,parent);
 if(nid<0)
  return(nid);
 
 fillNotiz(&adf->notiz->notiz[nid],parent,uid,date,time,title,text);
 // ntz = &adr->notiz->notiz[nid];
//  ntz->uid   = uid;
//  ntz->date  = date;
//  ntz->time  = time;
//  ntz->title = new char [strlen(title) +4];
//  ntz->text  = new char [strlen(text) +4];
//  strcpy(ntz->title,title);
//  strcpy(ntz->text,text);
//  ntz->status = NOTIZ_FILLED;
 printf("adf->notiz=%p\n",adf->notiz);
 writeNotiz(adf);

 return(nid);
}

int fillNotiz(Notiz *ntz,int parent, int uid,int date, int time, char *title, char *text)
{
 ntz->uid   = uid;
 ntz->date  = date;
 ntz->time  = time;
 ntz->title = new char [strlen(title) +4];
 ntz->text  = new char [strlen(text) +4];
 strcpy(ntz->title,title);
 strcpy(ntz->text,text);
}
// TCL uname id parent date time title text
int addNotiz(int socket, char *str,int type)
{
 char *tp[64],ans[256];
 int id,uid,nid,date,time;

 split(str,tp,64);
 uid = uname2uid(tp[0]);
 if(uid<0 || uid >= userAnz)
  {
   send2Client(socket,"Error: No such user\n");
   return(false);
  }
 if(tp[1][0] == 'd')
  {
   type = FOLDER_NOTIZ;
   id = atoi(tp[1]+1);
  }
 else
  {
   type = ADDRESS_NOTIZ;
   id = atoi(tp[1]);
  }
 date= atoi(tp[3]);
 time= atoi(tp[4]);

 if(type==FOLDER_NOTIZ)
  nid = addDirNotiz(id,atoi(tp[2]),uid,date,time,tp[5],tp[6]);
 else
  nid = addAdrNotiz(id,atoi(tp[2]),uid,date,time,tp[5],tp[6]);

 if( nid <0)
  {
   send2Client(socket,"Error add notiz\n");
   return(false);
  }
 sprintf(ans,"%d",nid);
 send2Client(socket,ans);
}

int changeNotiz(NotizControl *nc, int nid, char *text)
{
 Notiz *ntz;

 if(nid<0 || nid > nc->anz )
  return(false);
 ntz = &nc->notiz[nid];
 delete ntz->text;
 ntz->text  = new char [strlen(text) +4];
 strcpy(ntz->text,text);
 // printf("adr->notiz=%p\n",adr->notiz);
 return(true);
}

int changeNotiz(int aid, int nid, char *text)
{
 Address *adr;
 int aidx;

 aidx=aid2idx(aid);
 
 if(aidx<0 || aidx>=adrAnz)
  return(false);
 adr = adrList[aidx];
 if(adr->notiz==NULL)
  readNotiz(adr);
 if(adr->notiz==NULL)
  return(false);
 if(!changeNotiz(adr->notiz,nid,text))
  return(false);
//  if(nid<0 || nid > adr->notiz->anz )
//   return(false);
//  ntz = &adr->notiz->notiz[nid];
//  delete ntz->text;
//  ntz->text  = new char [strlen(text) +4];
//  strcpy(ntz->text,text);
//  printf("adr->notiz=%p\n",adr->notiz);
 writeNotiz(adr);
 return(true);
}
int changeDirNotiz(int dirid, int nid, char *text)
{
 AddressFolder *adf;
 int aidx;

 
 if(dirid<0 || dirid>=adfAnz)
  return(false);
 adf = adfList[dirid];
 if(adf == NULL)
  return(false);
 if(adf->notiz==NULL)
  readNotiz(adf);
 if(adf->notiz==NULL)
  return(false);
 if(!changeNotiz(adf->notiz,nid,text))
  return(false); 
 writeNotiz(adf);
 return(true);
}

int changeNotiz(int socket, char *str,int type)
{
 char *tp[64];
 int aid,nid,success;

 split(str,tp,64);
 if (tp[0][0] == 'd' )
  {
   type = FOLDER_NOTIZ;
   aid = atoi(tp[0]+1);
  }
 else
  {
   type = ADDRESS_NOTIZ;
   aid = atoi(tp[0]);
  }
 //  aidx = aid2idx(aid);
//  if(aidx<0 || aidx>= adrAnz)
//   {
//    send2Client(socket,"Error: No such Address\n");
//    return(false);
//   }
 nid = atoi(tp[1]);
//  if(nid<0 || nid >= adrList[aidx]->notiz->anz)
//   {
//    printf("NID=%d\n",nid);
//    send2Client(socket,"Error: Note not allocated\n");
//    return(false);
//   }
 if(type == ADDRESS_NOTIZ)
  success=changeNotiz(aid,nid,tp[2]);
 else
  success=changeDirNotiz(aid,nid,tp[2]);
 if(!success)
  {
   send2Client(socket,"Error changing Notiz");
   return(false);
  }
 send2Client(socket,"done");
}

// Format getNotiz uid id [id [ id ....]]
// Format getDirNotiz uid id
int getNotiz(int socket, char *str,int type)
{
 char *tp[1024],permStr[16];
 int uid,aid,aidx,dirid,id,anz,j;
 int i;
 Address *adr;
 NotizControl *nc;
 Notiz *ntz;
 char *buffer;
 int bufferLen;
 int textLen=0,len;
 char miniBuffer[65536];
 char prefix=' ';

 anz = split(str,tp,1023);
 uid = uname2uid(tp[0]);

 if(uid<0 || uid >= userAnz)
  {
   send2Client(socket,"Error: No such user\n");
   return(false);
  }

 
 buffer = new char [65536];
 bufferLen = 65500;
 buffer[0]='\0';

 for (j=1;j<anz; j++)
  {
   if (tp[j][0]== 'd')
    {
     id = dirid = atoi(tp[j]+1);
     prefix='d';
     if(dirid<0 || dirid >= adfAnz || adfList[dirid] == NULL)
      continue;
     
     if(access2AdrFolder(uid,adfList[dirid]))
      strcpy(permStr,"rwn");
     else
      strcpy(permStr,"r--");
     nc= adfList[dirid]->notiz;
     if(nc==NULL)
      {
       readNotiz(adfList[dirid]);
       nc= adfList[dirid]->notiz;
      }
     if(nc==NULL)
      continue;
    }
   else 
    {
     id=aid = atoi(tp[j]);
     aidx = aid2idx(aid);
     if(aidx<0 || aidx >= adrAnz)
      continue;
     prefix=' ';

     if (! access2Adr(uid,adrList[aidx],permStr) )
      continue;

     nc= adrList[aidx]->notiz;
     if(nc==NULL)
      {
       readNotiz(adrList[aidx]);
       nc= adrList[aidx]->notiz;
      }
     if(nc==NULL)
      continue;
    } 


   strcat(buffer,"{ ");
   strcat(buffer,permStr);
   strcat(buffer," { ");
   for(i=0;i<nc->anz; i++)
    {
     ntz = &nc->notiz[i];
     sprintf(miniBuffer,"{%c%d-%d { %d %d %s %d %d %d {%s} {%s}}}",
	     prefix,id,ntz->id,aid,ntz->id,userList[ntz->uid].name,ntz->date,ntz->time,ntz->parent,ntz->title,ntz->text);
     len = strlen(miniBuffer) ;
     while(len+textLen +2> bufferLen)
      {
       char *tmp;
       tmp = new char [bufferLen +65536];
       strcpy(tmp,buffer);
       delete buffer;
       buffer =tmp;
       bufferLen += 65536;
      }
     strcat(buffer," ");
     strcat(buffer,miniBuffer);
     textLen += len+1;
    }
   strcat(buffer,"} } ");
  }
 send2Client(socket,buffer);
}

int sendMail2(char *to, char *smtp,char *subj, char *text)
{
 char *cmd;

 cmd = new char [strlen(text)+4096];
 if (smtp == NULL)
  sprintf(cmd,"echo '%s' |mail -s \"%s\" %s",text,subj,to);
 else
  {
   if(smtp[0] == '\0')
    sprintf(cmd,"echo '%s' |mail -s \"%s\" %s",text,subj,to);
   else
    sprintf(cmd,"%s %s %s  %s \"%s\" \"%s\"",mail2smtp,smtp,to,replyAddress,subj,text);
  }
 system(cmd);
 printf("Send Mail '%s' to %s via Email:\n",subj,to);
 printf("%s\n\n",cmd);
 delete cmd;
 return(true);
}

int sendMail2(int *to,int anz,char *subj, char *text)
{
 int i,j,gid,k,uid;
 
 for(i=0;i<userAnz;i++)
  userList[i].internalStatus =false;

 for(i=0;i<anz;i++)
  {
   printf("sending Mail to id=%d\n",to[i]);
   if(to[i]>=0)
    {
     if(to[i]<GROUPOFFSET)
      {
       uid = to[i];
       if(uid<userAnz)
	if(!userList[uid].internalStatus)
	 for(k=0;k<4;k++)
	  if(userList[uid].mail[k][0] !='\0')
	   {
	    sendMail2(userList[uid].mail[k],userList[uid].smtp[k],subj,text);
	    userList[uid].internalStatus =true;
	   }
      }
     else if(to[i]<ADDRESOFFSET)
      {
       gid=to[i] -GROUPOFFSET;
       if(gid < groupAnz)
	for(j=0;j<groupList[gid].anz; j++)
	 {
	  uid = groupList[gid].membr[j];
	  if(!userList[uid].internalStatus)
	   for(k=0;k<4;k++)
	    if(userList[uid].mail[k][0] !='\0')
	     {
	      sendMail2(userList[uid].mail[k],userList[uid].smtp[k],subj,text);
	      userList[uid].internalStatus =true;
	     }
	 }
      }  
    }
  }
}
// sendNotizByMail id nid to, [to ...]
int sendNotizByMail(int socket, char *str,int type)
{
 char *tp[8],*tp2[1024],subj[2048];
 int anz,tanz;
 int nid, aid, aidx,i,*to;
 char *buffer;
 Notiz *ntz;
 char txt[256];
 NotizControl *nc;
 char name[400];
 int dirid;

 anz = split(str,tp,7);
 
 if(anz<3)
  {
   send2Client(socket,"Error insufficent data");
   return false;
  }

 if(tp[0][0] == 'd')
  {
   dirid =atoi(tp[0]+1);
   if(dirid<0 || dirid > adfAnz || adfList[dirid] == NULL)
    {
     send2Client(socket,"Error no such address folder");
     return false;
    }
   sprintf(name,"zum Addressordner %s",adfList[dirid]->name);
   nc = adfList[dirid]->notiz;
   if(nc == NULL)
    {
     readNotiz(adfList[dirid]);
     nc= adrList[dirid]->notiz;
    }
   if(nc==NULL)
    {
     send2Client(socket,"Error no such note");
     return(false);
    }
  }
 else
  {
   aid =atoi(tp[0]);
   aidx =aid2idx(aid);
   if(aidx<0 || aidx> adrAnz)
    {
     send2Client(socket,"Error no such address");
     return false;
    }
   strcpy(name,"zur Addresse ");
   if(adrList[aidx]->titel[0] != '\0')
    {
     strcat(name,adrList[aidx]->titel);
     strcat(name," ");
    }
   if(adrList[aidx]->name1[0] != '\0')
    {
     strcat(name,adrList[aidx]->name1);
     strcat(name," ");
    }
   if(adrList[aidx]->nameM != '\0' && adrList[aidx]->nameM != ' ')
    {
     int len =strlen(name);
     name[len] = adrList[aidx]->nameM;
     len++;
     name[len] = '.';
     len++;
     name[len] = ' ';
     len++;
    }
   if(adrList[aidx]->name2[0] != '\0')
    {
     strcat(name,adrList[aidx]->name2);
     strcat(name," ");
    }
   
   nc = adrList[aidx]->notiz;
   if(nc == NULL)
    {
     readNotiz(adrList[aidx]);
     nc= adrList[aidx]->notiz;
    }
   if(nc==NULL)
    {
     send2Client(socket,"Error no such note");
     return(false);
    }
  }

 nid =atoi(tp[1]);
 if(nid<0 || nid >= nc->anz)
  {
   send2Client(socket,"Error: No such Note\n");
   return(false);
  }

 anz = split(tp[2],tp2,1023);
 to =  new int [anz];
 tanz=0;
 for(i=0;i<anz ; i++)
  {
   to[tanz] = uname2uid(tp2[i]);
   if(to[tanz] >=0)
    tanz++;
  }
 printf("sending mail2 %d receipients: \n",tanz);
 for(i=0;i<anz ; i++)
  printf("%d ",to[i]);
 printf("\n");

 ntz  = &nc->notiz[nid];
 sprintf(subj,"Gesprchsnotiz %s': %s",	 name,ntz->title);

 buffer  = new char [strlen(nc->notiz[nid].text) +2048];
 sprintf(buffer,"Gesprchsnotiz %s'\nAngelegt von %s am %s um %s:\n\n%s\n____________________________________________________________\n%s\n\n--------------\n(c) %s   bei   %s\n",
	 name,
	 userList[ntz->uid].full,date2Str(ntz->date,txt),time2Str(ntz->time,txt+128),ntz->title,ntz->text,
	 progName,company);
 send2Client(socket,"done");
 sendMail2(to,tanz,subj,buffer);
 delete to;
}


void fillIntoAdr(Address *adr, char *t, int field);
int addresseEquivalent(Address *adr1,Address *adr2);
int makeFootPrintString ();
int readCSVFormat(char *file);
int readCSVfile(char *file,char sep,int dirid, int start);
int importCSVAddress(char *formatFile, char *csvFile, char sep,char *folder,int start);


//FORMAT: importCSV username formatfile csv-file separator import-folder startline
int importCSV(int socket, int cuid, char *str)
{
 char *tp[8],sep;
 int uid;

 if(cuid != 0)
  {
   send2Client(socket,"Error: This is an preveligued command. Only the Minkowsky Administrator can do this");
   return(false);
  }
 
 split(str,tp,7);
 
 uid = uname2uid(tp[0]);
 if(uid != 0)
  {
   send2Client(socket,"Error: This is an preveligued command. Only the Minkowsky Administrator can do this");
   return(false);
  }


 if(strcasecmp(tp[3],"TAB")==0)
  sep ='\t';
 else
  sep =tp[3][0];

 if(!importCSVAddress(tp[1],tp[2],sep,tp[4],atoi(tp[5])))
  {
   char txt[2560];
   sprintf(txt,"Error: CSV-Import of '%s' using '%s' failed\n",tp[2],tp[1]);
   send2Client(socket,txt);
   return(false);
  }
 send2Client(socket,"done");
}

int importCSVAddress(char *formatFile, char *csvFile, char sep,char *folder,int start)
{
 int dirid;

 if( (dirid = folderName2dirid(folder) ) <0)
  {
   if( (dirid = makeAdrFolder(folder,-1, 0)) <0)
    return(false);
  }

 

 makeFootPrintString();
 if(!readCSVFormat(formatFile))
  return(false);
 if(!readCSVfile(csvFile,sep,dirid,start))
  return(false);
}

char *footPrint(Address *adr, char *t, int withID)
{
 if(withID)
  sprintf(t,"%s%s%s#%08d; ",adr->titel,adr->name1,adr->name2,adr->id);
 else
  sprintf(t,"%s%s%s# ",adr->titel,adr->name1,adr->name2);
 return(t);
}

int makeFootPrintString ()
{
 int i;
 char txt[160];

 if(adrFootPrint != NULL)
  delete adrFootPrint;
 adrFootPrint = new char [adrAnz*160];
 
 strcpy(adrFootPrint,"");
 for(i=0;i<adrAnz ;i++)
  if(adrList[i] != NULL)
   if(!adrList[i]->deleted)
    {
     //     sprintf(txt,"%s%s%s#%08d; ",adrList[i]->titel,adrList[i]->name1,adrList[i]->name2,adrList->id);
     strcat(adrFootPrint,footPrint(adrList[i],txt,true));
    }
}

int readCSVFormat(char *file)
{
 char inp[1024],*p;
 int fnr;
 int i;
 FILE *fp;

 fp =fopen(file,"r");
 if(fp==NULL)
  {
   printf("Can't open '%s' get format for csv-import csv-addresse \n",file);
   return(false);
  }

 fnr=0;
 // while(fscanf(fp,"%s",inp)>0)
 while(fgets(inp,1023,fp) != NULL)
  {
   p = strchr(inp,'#');
   if(p !=NULL)
    *p ='\0';
   strTrim(inp);
   csvImportFields[fnr] = ADR_FIELD_IGNORE;
   for(i=0;i<ADR_TAG_ANZ;i++)
    if(strcmp(inp,adrTags[i].tag)==0)
     {
      if(verbose)
       printf("got %s for field %d\n",adrTags[i].tag,fnr);
      csvImportFields[fnr] = adrTags[i].field;
      break;
     }
   if(verbose)
    if ( csvImportFields[fnr] == ADR_FIELD_IGNORE)
     printf("Can't identify TAG '%s', asuming IGNORE\n",inp);
   fnr++;
  }
 fclose(fp);
 return(true);
}
int readCSVfile(char *file,char sep,int dirid, int start)
{
 FILE *fp;
 char line[8192],*t,*s,*p,*f,*idp,ids[16],foot[256];
 int fnr,done,importAdr;
 Address *adr;
 int lc=0;

 fp =fopen(file,"r");
 if(fp==NULL)
  {
   printf("Can't open '%s' to import csv-addresse \n",file);
   return(false);
  }

 adr =new Address;
 while(fgets(line,8191,fp)!=NULL)
  {
   t=line;
   fnr=0;
   done =false;
   while (*t !='\0')
    {
     adr->owner    = -1;
     adr->noteOnly = -1;
     adr->readOnly = -1;
     adr->creator  = adr->modifier =0;
     adr->created  = adr->modified = today;
     s = strchr(t,sep);
     if(s!=NULL)
      *s='\0';
     else
      done =true;
     if(*t=='\"')
      t++;
     if(t[strlen(t)-1] == '\"')
      t[strlen(t)-1] ='\0';
     fillIntoAdr(adr,t,csvImportFields[fnr]);
     fnr++;
     if(done)
      break;
     t=s+1;
    }
   lc++;

   // Suche hnliche Addressen
   footPrint(adr,foot,false);
   f = adrFootPrint;
   importAdr=true;
   for(;;)
    {
     int aidx;
     p = strstr(f,foot);
     if(p!=NULL)
      {
       idp = strchr(p,'#')+1;
       strncpy(ids,idp,8);
       ids[8]='\0';
       aidx =atoi(ids);
       if(addresseEquivalent(adr,adrList[aidx]) )
	{
	 NotizControl *nc;
	 int own,dc,id;
	 id  = adrList[aidx]->id;
	 own = adrList[aidx]->owner;
	 dc  = adrList[aidx]->dateCount;
	 nc  = adrList[aidx]->notiz;
	 memcpy(adrList[aidx],adr,sizeof(Address));
	 adrList[aidx]->id =id;
	 adrList[aidx]->owner =own ;
	 adrList[aidx]->dateCount =dc;
	 adrList[aidx]->notiz =nc;
	 importAdr =false;
	}
       p=strchr(p,';');
       if(p==NULL)
	break;
       p+=2;
      }
     else
      break;
    }
   if(lc>=start)
    if(importAdr)
     {
      lastAid++;
      adrList[adrAnz] = adr;
      adrAnz++;
      if(adrAnz >adrMax)
       extendAdrList();
      adr->id=lastAid;
      adr->dateCount=0;
      adr->notiz=NULL;
      adr->dirID = dirid;
      adr=new Address;
     }
  }
 fclose(fp);
 writeAdrList();
 
 return(true);
}


int addresseEquivalent(Address *adrNew,Address *adrOld)
{
 int erc=0,i,j;

 if(adrOld->name1[0] !='\0')
  if(strcmp(adrNew->name1,adrOld->name1) != 0)
   return(false);
 if(adrOld->name2[0] !='\0')
  if(strcmp(adrNew->name2,adrOld->name2) != 0)
   return(false);

 if(adrOld->company[0] !='\0')
  if(strcmp(adrNew->company,adrOld->company) != 0)
   erc+=2;

 for(j=0;j<3;j++)
  {
   if(adrOld->city[j] != '\0' || adrOld->addres[j][0][0] != '\0' || adrOld->plz[j][0] != '\0')
    {
     if(strcmp(adrNew->plz[j],adrOld->plz[j])!=0)
      erc+=2;
     else if (strcmp(adrNew->city[j],adrOld->city[j])!=0)
      erc+=2;
     else if (strcmp(adrNew->country[j],adrOld->country[j])!=0)
      erc+=2;
     else
      for(i=0;i<3;i++)
       if(strcmp(&adrNew->addres[j][i][0],&adrOld->addres[j][i][0]) != 0)
	{
	 break;
	 erc+=2;
	}
    }
  }

 for(i=0;i<5;i++)
  if(adrOld->fon[i][0] != '\0')
   if(strcmp(&adrNew->fon[i][0],&adrOld->fon[i][0]) != 0)
    erc++;
 for(i=0;i<2;i++)
  {
   if(adrOld->fax[i][0] != '\0')
    if(strcmp(adrNew->fax[i],adrOld->fax[i]) != 0)
     erc++;
   if(adrOld->www[i][0] != '\0')
    if(strcmp(adrNew->www[i],adrOld->www[i]) != 0)
     erc++;
  }
 for(i=0;i<3;i++)
  if(adrOld->mail[i][0] != '\0')
   if(strcmp(adrNew->mail[i],adrOld->mail[i]) != 0)
    erc++;
 

 if(erc>=3)
  return(false);
 return(true);
}

void fillIntoAdr(Address *adr, char *t, int field)
{
 char *p,*p2;
 int k=0;
 int l;
   
 switch(field)
  {

  case ADR_FIELD_IGNORE :
   break;
  case ADR_FIELD_ID :
   adr->id = atoi(t);
   break;
  case ADR_FIELD_TITEL :
   strncpy(adr->titel,t,15);
   adr->titel[15]='\0';
   break;
  case ADR_FIELD_NAME_1 :
   strncpy(adr->name1,t,63);
   adr->name1[63]='\0';
   break;
  case ADR_FIELD_NAME_M :
   adr->nameM = t[0];
   break;
  case ADR_FIELD_NAME_2 :
   strncpy(adr->name2,t,63);
   adr->name2[63]='\0';
   break;
  case ADR_FIELD_NAME1M2 :
   // FIXME mittelinitail
   p = strrchr(t,' ');
   if(p == NULL)
    {
     strncpy(adr->name2,t,63);
     adr->name2[63]='\0';
    }
   else
    {
     strncpy(adr->name2,p,63);
     adr->name2[63]='\0';
     *p='\0';
     strncpy(adr->name1,p,63);
     adr->name1[63]='\0';
    }
   break;
  case ADR_FIELD_COMPS  :
   strncpy(adr->compShort,t,15);
   adr->compShort[15]='\0';
   break;
  case ADR_FIELD_COMPA  :
   strncpy(adr->company,t,63);
   adr->company[63]='\0';
   break;
  case ADR_FIELD_COMPPOS:
   strncpy(adr->compPos,t,31);
   adr->compPos[31]='\0';
   break;
  case ADR_FIELD_ADDR1A :
   strncpy(&adr->addres[0][0][0],t,63);
   adr->addres[0][0][63]='\0';
   break;
  case ADR_FIELD_ADDR1B :
   strncpy(&adr->addres[0][1][0],t,63);
   adr->addres[0][1][63]='\0';
   break;
  case ADR_FIELD_ADDR1C :
   strncpy(&adr->addres[0][2][0],t,63);
   adr->addres[0][2][63]='\0';
   break;
  case ADR_FIELD_PLZ1 :
   strncpy(&adr->plz[0][0],t,15);
   adr->plz[0][15]='\0';
   break;
  case ADR_FIELD_CITY1 :
   strncpy(&adr->city[0][0],t,63);
   adr->city[0][63]='\0';
   break;
  case ADR_FIELD_CNTRY1 :
   strncpy(&adr->country[0][0],t,63);
   adr->country[0][63]='\0';
   break;
  case ADR_FIELD_ADDR2A :
   strncpy(&adr->addres[1][0][0],t,63);
   adr->addres[1][0][63]='\0';
   break;
  case ADR_FIELD_ADDR2B :
   strncpy(&adr->addres[1][1][0],t,63);
   adr->addres[1][1][63]='\0';
   break;
  case ADR_FIELD_ADDR2C :
   strncpy(&adr->addres[1][2][0],t,63);
   adr->addres[1][2][63]='\0';
   break;
  case ADR_FIELD_PLZ2 :
   strncpy(&adr->plz[1][0],t,15);
   adr->plz[1][15]='\0';
   break;
  case ADR_FIELD_CITY2 :
   strncpy(&adr->city[1][0],t,63);
   adr->city[1][63]='\0';
   break;
  case ADR_FIELD_CNTRY2 :
   strncpy(&adr->country[1][0],t,63);
   adr->country[1][63]='\0';
   break;
  case ADR_FIELD_ADDR3A :
   strncpy(&adr->addres[2][0][0],t,63);
   adr->addres[2][0][63]='\0';
   break;
  case ADR_FIELD_ADDR3B :
   strncpy(&adr->addres[2][1][0],t,63);
   adr->addres[2][1][63]='\0';
   break;
  case ADR_FIELD_ADDR3C :
   strncpy(&adr->addres[2][2][0],t,63);
   adr->addres[2][2][63]='\0';
   break;
  case ADR_FIELD_PLZ3 :
   strncpy(&adr->plz[2][0],t,15);
   adr->plz[2][15]='\0';
   break;
  case ADR_FIELD_CITY3 :
   strncpy(&adr->city[2][0],t,63);
   adr->city[2][63]='\0';
   break;
  case ADR_FIELD_CNTRY3 :
   strncpy(&adr->country[2][0],t,63);
   adr->country[2][63]='\0';
   break;
  case ADR_FIELD_FON1 :
   strncpy(&adr->fon[0][0],t,31);
   adr->fon[0][31]='\0';
   break;
  case ADR_FIELD_FON2 :
   strncpy(&adr->fon[1][0],t,31);
   adr->fon[1][31]='\0';
   break;
  case ADR_FIELD_FON3 :
   strncpy(&adr->fon[2][0],t,31);
   adr->fon[2][31]='\0';
   break;
  case ADR_FIELD_FON4 :
   strncpy(&adr->fon[3][0],t,31);
   adr->fon[3][31]='\0';
   break;
  case ADR_FIELD_FON_P :
   strncpy(&adr->fon[4][0],t,31);
   adr->fon[4][31]='\0';
   break;
  case ADR_FIELD_FAX :
   strncpy(&adr->fax[0][0],t,31);
   adr->fax[0][31]='\0';
   break;
  case ADR_FIELD_FAX_P :
   strncpy(&adr->fax[1][0],t,31);
   adr->fax[1][31]='\0';
   break;
  case ADR_FIELD_WWW :
   strncpy(&adr->www[0][0],t,127);
   adr->www[0][127]='\0';
   break;
  case ADR_FIELD_WWW_P :
   strncpy(&adr->www[0][0],t,127);
   adr->www[0][127]='\0';
   break;
  case ADR_FIELD_MAIL :
   strncpy(&adr->mail[0][0],t,63);
   adr->mail[0][63]='\0';
   break;
  case ADR_FIELD_MAIL2 :
   strncpy(&adr->mail[1][0],t,63);
   adr->mail[1][63]='\0';
   break;
  case ADR_FIELD_MAIL_P :
   strncpy(&adr->mail[2][0],t,63);
   adr->mail[2][63]='\0';
   break;
  case ADR_FIELD_DESCR_S :
   strncpy(adr->descrShort,t,63);
   adr->descrShort[63]='\0';
   break;
  case ADR_FIELD_DESCR_L :
   strncpy(adr->descr,t,255);
   adr->descr[255]='\0';
   break;
  case ADR_FIELD_DESCR_L_ADD :
   if (strlen(t)>0)
    {
     l =255-strlen(adr->descr)-2;
     if(l>0)
      {
       strcat(adr->descr,"; ");
       strncat(adr->descr,t,l);
      }
     adr->descr[255]='\0';
    }
   break;
  case ADR_FIELD_KONTO1INH :
   strncpy(&adr->kontoInh[0][0],t,31);
   adr->kontoInh[0][31]='\0';
   break;
  case ADR_FIELD_KONTO1NUM :
   strncpy(&adr->kontoNum[0][0],t,15);
   adr->kontoNum[0][15]='\0';
   break;
  case ADR_FIELD_KONTO1BNK :
   strncpy(&adr->kontoBank[0][0],t,31);
   adr->kontoBank[0][31]='\0';
   break;
  case ADR_FIELD_KONTO1BLZ :
   strncpy(&adr->kontoBLZ[0][0],t,15);
   adr->kontoBLZ[0][15]='\0';
   break;
  case ADR_FIELD_KONTO2INH :
   strncpy(&adr->kontoInh[1][0],t,31);
   adr->kontoInh[1][31]='\0';
   break;
  case ADR_FIELD_KONTO2NUM :
   strncpy(&adr->kontoNum[1][0],t,15);
   adr->kontoNum[1][15]='\0';
   break;
  case ADR_FIELD_KONTO2BNK :
   strncpy(&adr->kontoBank[1][0],t,31);
   adr->kontoBank[1][31]='\0';
   break;
  case ADR_FIELD_KONTO2BLZ :
   strncpy(&adr->kontoBLZ[1][0],t,15);
   adr->kontoBLZ[1][15]='\0';
   break;
  case ADR_FIELD_STEUER :
   strncpy(adr->steuer,t,31);
   adr->steuer[31]='\0';
   break;
  case ADR_FIELD_INFO1 :
   strncpy(&adr->info[0][0],t,255);
   adr->info[0][255]='\0';
   break;
  case ADR_FIELD_INFO2 :
   strncpy(&adr->info[1][0],t,255);
   adr->info[1][255]='\0';
   break;
  case ADR_FIELD_INFO1_ADD :
   if (strlen(t)>0)
    {
     l =255-strlen(&adr->info[0][0])-2;
     if(l>0)
      {
       strcat(&adr->info[0][0],"; ");
       strncat(&adr->info[0][0],t,l);
      }
     adr->info[0][255]='\0';
    }
   break;
  case ADR_FIELD_INFO2_ADD :
   if (strlen(t)>0)
    {
     l =255-strlen(&adr->info[1][0])-2;
     if(l>0)
      {
       strcat(&adr->info[1][0],"; ");
       strncat(&adr->info[1][0],t,l);
      }
     adr->info[1][255]='\0';
    }
   break;
  case ADR_FIELD_GEBURTST :
   strncpy(adr->geb,t,15);
   adr->geb[15]='\0';
   break;
  case ADR_FIELD_OWNER :
   adr->owner = owner2id(t);
   break;
  case ADR_FIELD_NOTEONLY :
   adr->noteOnly = owner2id(t);
   break;
  case ADR_FIELD_READONLY :
   adr->readOnly = owner2id(t);
   break;
  case ADR_FIELD_CREATE :
   break;
  case ADR_FIELD_CREATOR :
   adr->creator = uname2uid(t);
   if(adr->creator<0)
    adr->creator=0;
   break;
  }
}

