//  File: address.h
// 
//      This file is part of minkowsky
// 
//      Copyright (C) 2001-2002 by Rdiger Goetz
//      Author: Rdiger Goetz <minkowsky@r-goetz.de>
// 
//      Time-stamp: <19-Apr-2002 17:15:00 goetz>
// 
//      This program is free software; you can redistribute it and/or modify
//      it under the terms of the GNU General Public License as published by
//      the Free Software Foundation; either version 2 of the License, or
//      (at your option) any later version.
// 
//      This program is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU General Public License for more details.
// 
//      You should have received a copy of the GNU General Public License
//      along with this program; if not, write to the Free Software
//      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//  
#define NOTIZ_EMPTY 0
#define NOTIZ_ALLOC 1
#define NOTIZ_FILLED 2

typedef struct {
 int status;
 int id;
 int parent;
 int date;
 int time;
 int uid;
 char *title;
 char * text;
 int childAnz; // termprar
} Notiz;

#define ADDRESS_NOTIZ 1
#define FOLDER_NOTIZ 2

typedef struct
{
 int aid;
 int max;
 int anz;
 int dirty;
 Notiz *notiz;
 int type;
}NotizControl;


#define ADR_FIELD_IGNORE  0
#define ADR_FIELD_ID      1
#define ADR_FIELD_TITEL   2
#define ADR_FIELD_NAME_1  3
#define ADR_FIELD_NAME_M  4
#define ADR_FIELD_NAME_2  5
#define ADR_FIELD_NAME1M2 6
#define ADR_FIELD_COMPS   7
#define ADR_FIELD_COMPA   8
#define ADR_FIELD_COMPPOS 9
#define ADR_FIELD_ADDR1   10
#define ADR_FIELD_ADDR1A  10
#define ADR_FIELD_ADDR1B  11
#define ADR_FIELD_ADDR1C  12
#define ADR_FIELD_PLZ1    13
#define ADR_FIELD_CITY1   14
#define ADR_FIELD_CNTRY1  15
#define ADR_FIELD_ADDR2   20
#define ADR_FIELD_ADDR2A  21
#define ADR_FIELD_ADDR2B  22
#define ADR_FIELD_ADDR2C  23
#define ADR_FIELD_PLZ2    24
#define ADR_FIELD_CITY2   25
#define ADR_FIELD_CNTRY2  26 
#define ADR_FIELD_ADDR3   30
#define ADR_FIELD_ADDR3A  31
#define ADR_FIELD_ADDR3B  32
#define ADR_FIELD_ADDR3C  33
#define ADR_FIELD_PLZ3    34
#define ADR_FIELD_CITY3   35
#define ADR_FIELD_CNTRY3  36
#define ADR_FIELD_FON1    40
#define ADR_FIELD_FON2    41
#define ADR_FIELD_FON3    42
#define ADR_FIELD_FON4    43
#define ADR_FIELD_FON_P   44
#define ADR_FIELD_FAX     45
#define ADR_FIELD_FAX_P   46
#define ADR_FIELD_WWW     47
#define ADR_FIELD_WWW_P   48
#define ADR_FIELD_MAIL    49
#define ADR_FIELD_MAIL2   50
#define ADR_FIELD_MAIL_P  51
#define ADR_FIELD_DESCR_S 52
#define ADR_FIELD_DESCR_L 53
#define ADR_FIELD_DESCR_L_ADD 153
#define ADR_FIELD_KONTO1INH 60
#define ADR_FIELD_KONTO1NUM 61
#define ADR_FIELD_KONTO1BNK 62
#define ADR_FIELD_KONTO1BLZ 63
#define ADR_FIELD_KONTO2INH 64
#define ADR_FIELD_KONTO2NUM 65
#define ADR_FIELD_KONTO2BNK 66
#define ADR_FIELD_KONTO2BLZ 67
#define ADR_FIELD_STEUER    68
#define ADR_FIELD_INFO1     70
#define ADR_FIELD_INFO2     71
#define ADR_FIELD_INFO1_ADD 170
#define ADR_FIELD_INFO2_ADD 171
#define ADR_FIELD_GEBURTST  72
#define ADR_FIELD_OWNER     80
#define ADR_FIELD_NOTEONLY  81
#define ADR_FIELD_READONLY  82
#define ADR_FIELD_CREATE    85
#define ADR_FIELD_CREATOR   86


typedef struct 
{
 char tag[32];
 int field;
} AddressTags;

typedef struct
{
 int id;
 char titel[16];
 char name1[64];
 char nameM;
 char name2[64];
 char compShort[16];
 char compPos[32];
 char company[64];
 char addres[3][3][64]; // 0=main, 1=addi, 2=priv
 char plz[3][16];
 char city[3][64];
 char country[3][64];
 char fon[5][32];       // 0,1,3 normal 2 = handy 4 =privat
 char mail[3][64];      // 0,1 normal 2 =privat
 char fax[2][32];       // 0 normal 1=privat
 char www[2][128];       // 0 normal 1=privat
 char kontoInh[2][32];
 char kontoNum[2][16];
 char kontoBank[2][32];
 char kontoBLZ[2][16];
 char steuer[32];
 char descrShort[64];
 char descr[256];
 char info [2][256];     // 0 normal 1=privat
 char geb[16];
 int owner;
 int noteOnly;
 int readOnly;
 int deleted;
 int dateCount;
 int dirID;
 int created;
 int modified;
 int creator;
 int modifier;
 NotizControl *notiz;
 char reserved[256];
 int  resv[8];
 void *action;
}Address;

typedef struct
{
 int id;
 char titel[16];
 char name1[64];
 char name2[64];
 char compShort[16];
 char company[64];
 char addres[5][64];
 char fon[2][32];
 char mail[64];
 char fax[32];
 char www[128];
 char descrShort[64];
 char descr[256];
 int owner;
 int deleted;
 // int lock;
 int dateCount;
 NotizControl *notiz;
}Address_0410;

#define ADRF_STATUS_EMPTY 0x0000
#define ADRF_START_OPEN   0x0001

typedef struct
{
 int id;
 int dirID;
 int owner;
 int deleted;
 char name [64];
 NotizControl *notiz;
 int status;
 char res[64];
}AddressFolder;

typedef struct
{
 int id;
 int dirID;
 int owner;
 int deleted;
 char name [64];
 NotizControl *notiz;
}AddressFolder_0411;

#ifdef ADDRESS
#define __EXTERN
#else
#define __EXTERN extern
#endif
__EXTERN Address **adrList;
__EXTERN AddressFolder **adfList;
__EXTERN int adrAnz,adrBlocks,adrMax;
__EXTERN int adfAnz,adfBlocks,adfMax;
__EXTERN int lastAid;
__EXTERN int csvImportFields[256];
#undef __EXTERN

#ifdef ADDRESS
#define ADR_TAG_ANZ 73
AddressTags adrTags[ADR_TAG_ANZ]= {
{"IGNORE"    ,ADR_FIELD_IGNORE    },
{"ID"        ,ADR_FIELD_ID        },
{"TITEL"     ,ADR_FIELD_TITEL     },
{"NAME_1"    ,ADR_FIELD_NAME_1    },
{"NAME_M"    ,ADR_FIELD_NAME_M    },
{"NAME_2"    ,ADR_FIELD_NAME_2    },
{"NAME1"     ,ADR_FIELD_NAME_1    },
{"NAMEM"     ,ADR_FIELD_NAME_M    },
{"NAME2"     ,ADR_FIELD_NAME_2    },
{"NAME1M2"   ,ADR_FIELD_NAME1M2   },
{"COMPS"     ,ADR_FIELD_COMPS     },
{"COMPA"     ,ADR_FIELD_COMPA     },
{"COMPANY"   ,ADR_FIELD_COMPA     },
{"COMPPOS"   ,ADR_FIELD_COMPPOS   },
{"ADDR1"     ,ADR_FIELD_ADDR1     },
{"ADDR1A"    ,ADR_FIELD_ADDR1A    },
{"ADDR1B"    ,ADR_FIELD_ADDR1B    },
{"ADDR1C"    ,ADR_FIELD_ADDR1C    },
{"PLZ1"      ,ADR_FIELD_PLZ1      },
{"CITY1"     ,ADR_FIELD_CITY1     },
{"CNTRY1"    ,ADR_FIELD_CNTRY1    },
{"ADDR2"     ,ADR_FIELD_ADDR2     },
{"ADDR2A"    ,ADR_FIELD_ADDR2A    },
{"ADDR2B"    ,ADR_FIELD_ADDR2B    },
{"ADDR2C"    ,ADR_FIELD_ADDR2C    },
{"PLZ2"      ,ADR_FIELD_PLZ2      },
{"CITY2"     ,ADR_FIELD_CITY2     },
{"CNTRY2"    ,ADR_FIELD_CNTRY2    },
{"ADDR3"     ,ADR_FIELD_ADDR3     },
{"ADDR3A"    ,ADR_FIELD_ADDR3A    },
{"ADDR3B"    ,ADR_FIELD_ADDR3B    },
{"ADDR3C"    ,ADR_FIELD_ADDR3C    },
{"PLZ3"      ,ADR_FIELD_PLZ3      },
{"CITY3"     ,ADR_FIELD_CITY3     },
{"CNTRY3"    ,ADR_FIELD_CNTRY3    },
{"FON1"      ,ADR_FIELD_FON1      },
{"FON2"      ,ADR_FIELD_FON2      },
{"FON3"      ,ADR_FIELD_FON3      },
{"FON4"      ,ADR_FIELD_FON4      },
{"FON_P"     ,ADR_FIELD_FON_P     },
{"FONP"      ,ADR_FIELD_FON_P     },
{"FAX"       ,ADR_FIELD_FAX       },
{"FAX_P"     ,ADR_FIELD_FAX_P     },
{"FAXP"      ,ADR_FIELD_FAX_P     },
{"WWW"       ,ADR_FIELD_WWW       },
{"WWW_P"     ,ADR_FIELD_WWW_P     },
{"WWWP"      ,ADR_FIELD_WWW_P     },
{"MAIL"      ,ADR_FIELD_MAIL      },
{"MAIL2"     ,ADR_FIELD_MAIL2     },
{"MAIL_P"    ,ADR_FIELD_MAIL_P    },
{"MAILP"     ,ADR_FIELD_MAIL_P    },
{"DESCR_S"   ,ADR_FIELD_DESCR_S   },
{"DESCR_L"   ,ADR_FIELD_DESCR_L   },
{"+DESCR_L"  ,ADR_FIELD_DESCR_L_ADD},
{"KONTO1INH" ,ADR_FIELD_KONTO1INH },
{"KONTO1NUM" ,ADR_FIELD_KONTO1NUM },
{"KONTO1BNK" ,ADR_FIELD_KONTO1BNK },
{"KONTO1BLZ" ,ADR_FIELD_KONTO1BLZ },
{"KONTO2INH" ,ADR_FIELD_KONTO2INH },
{"KONTO2NUM" ,ADR_FIELD_KONTO2NUM },
{"KONTO2BNK" ,ADR_FIELD_KONTO2BNK },
{"KONTO2BLZ" ,ADR_FIELD_KONTO2BLZ },
{"STEUER"    ,ADR_FIELD_STEUER    },
{"INFO1"     ,ADR_FIELD_INFO1     },
{"INFO2"     ,ADR_FIELD_INFO2     },
{"+INFO1"    ,ADR_FIELD_INFO1_ADD },
{"+INFO2"    ,ADR_FIELD_INFO2_ADD },
{"GEBURTST"  ,ADR_FIELD_GEBURTST  },
{"OWNER"     ,ADR_FIELD_OWNER     },
{"NOTEONLY"  ,ADR_FIELD_NOTEONLY  },
{"READONLY"  ,ADR_FIELD_READONLY  },
{"CREATE"    ,ADR_FIELD_CREATE    },
{"CREATOR"   ,ADR_FIELD_CREATOR   }
};

#else
extern AddressTags adrTags[64];
#endif
void initAdrList();
void clearAdrList ();
void extendAdrList();

int changeAdress(int socket,char *ds);
int readAdrList();
int writeAdrList();
int sendBriefAdressList(int socket,char *str);
int sendAddresssList(int socket,char *str);
int sendAddress(int socket,char *str);  // request 
int sendFullAddress(int socket,char *str); // request 
int deleteAddress(int socket,char *ds);

int addNotiz(int socket,char *str,int type);
int getNotiz(int socket,char *str,int type);

int updateDateCountsInAddress();

int sendAdrFolderList(int socket,char *str);
int makeAdrFolder(int socket, char *str);
int changeAdrFolder(int socket, char *str);
int moveAdrObjToFolder(int socket, char *str);


int aname2aid(char *name);
int aname2idx(char *name);
int aid2idx(int aid);
char * aid2name(int aid,char *t);
char * adrIdx2name(int idx,char *t);
char * aid2cname(int aid,char *t);
char * adrIdx2cname(int idx,char *t);
int importCSV(int socket, int cuid,char *str);
int deleteAdrFolder (int socket, char *str);
