//  File: date.cc
// 
//      This file is part of minkowsky
// 
//      Copyright (C) 2001-2002 by Rdiger Goetz
//      Author: Rdiger Goetz <minkowsky@r-goetz.de>
// 
//      Time-stamp: <30-May-2002 19:35:00 goetz>
// 
//      This program is free software; you can redistribute it and/or modify
//      it under the terms of the GNU General Public License as published by
//      the Free Software Foundation; either version 2 of the License, or
//      (at your option) any later version.
// 
//      This program is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU General Public License for more details.
// 
//      You should have received a copy of the GNU General Public License
//      along with this program; if not, write to the Free Software
//      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//  
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <errno.h>  
#include <time.h>  
 
#include "termin.h"
#define DATE_SHIFTED 1
#define DATE_NORMAL 0

int minkoLog2(const char *fmt, ...);

void extendDateList();
int fillUserListInDateList(UserInDate *uid,char *names);
int fillUserInDateList(UserInDate *uid,char *str);
void fillUserInDate(UserInDate *uid, int id,int stat,int flag,int perm);
char * id2string(int id);
void exportDate(Date *d,char *file);
void addDate2Calendar(Date*d, int id);
int  addDate2RoomCalendar(Date *d, int uid);
int  addDate2UserCalendar(Date *d, int uid);
int  addDate2GroupCalendar(Date *d, int gid);
void sortDateList(Date **list,int anz);
int compareDateByStartTime(const void * p1,const void *p2);
int UiDlist2str(UserInDate *ul, char *t,int anz);
int changed (int v1, int v2);
int changed (int v1a, int v1b,int v2a, int v2b);
int changed (char* v1, char * v2);
int UiDlist2BriefStr(UserInDate *ul, Date *d, char *t,int anz,int init,int refDate, int RefTime);
int  modifyPartList(UserInDate *ref,int refAnz, UserInDate *cur,int curAnz, UserInDate *chg,int chgAnz,char *reject, char* done);
int modifySingleUserInDate(UserInDate *ref,UserInDate *cur,UserInDate *chg,UserInDate *tmp,char *reject, char* done);
UserInDate * findEntry4User(int id,UserInDate* list, int anz);
int skip2nextOLD(CalendarItem *ci,Date *d);
int skip2next(CalendarItem *ci,Date *d);
int addReminderList2Date(char *t,Date *d);
int getBlockedTimes4User(int startDay,int stopDay,Calendar *cal, char *buffer,int ignoreDid);
int modifyReminder(char *t,Date *cur, Date*ref,char *reject, char *done);
void addCal2Buffer(char *buffer, Calendar *cal, int uid,int cid,int startDay, int stopDay,int igno,int ignoInfo,int stamp);
void addUserCal2Buffer(int uid,int cid,int gid, int startDay, int stopDay,int igno,char *buffer,int ignoInfo);
int nextDateAfterDate (CalendarItem *ci,CalendarItem *oci,Date *d, int datum, int tim);
int removeDateFromUserCal(Date *d,int  uid);

void initDateShiftList(Date *d);
void extendDateShiftList(Date *d);
void extendDatShiftMasterList();
int skip2next(CalendarItem *ici,CalendarItem *oci,Date *d);
CalendarItem *shiftDateIfNeeded(CalendarItem *ici,CalendarItem *oci,Date *d);
int compareDateShiftsByDate(const void *v1, const void * v2);;
int readDateShifts();
void initCalendarItem(Date *d ,CalendarItem *ci);
void checkDateShiftsAndRecontruct();

UserDateModification *getUserModification4Date(int did,int uid);
void initDateUserModification(UserDateModification *umodi);
int dateIsIgnoredByMe(int did,int uid);
int dateOnlyAsInfo(Date *d,int uid);
void clearDateShifts ();
void clearDateUserModification ();

void briefDate2String(char *buffer,Date *d,int baseDate , int uid);

int removeDateFromUserCal(Date *d,int  uid);
int skip2Last(Date *d);
int skip2NextDateAfter(CalendarItem *ci,CalendarItem *wci,Date *d);
int jump2NextDateAfter(CalendarItem *ci,CalendarItem *wci,Date *d,int refDate,int refTime);
int jump2NextDateAfter(CalendarItem *ci,CalendarItem *wci,Date *d,int refDate);
int jump2NextDateAfter(CalendarItem *ci,CalendarItem *wci,Date *d,int refDate,int refTime,int withShift);
int stopDate4StartDate(int startDate,Date *d);
int diffDates(int date1, int date2);
int dateIsDeletedOrShifted(CalendarItem *ci, Date *d);
int beginningOfMonth(int date);
int beginningOfNextMonth(int date);
int diffMonth(int date1, int date2);
void writeComm(int did, char *t);

void writeAllDates( int backup);
void writeAllDateShifts(int backup);
void writeUserMods();
char *  addPartList(Date *d,char *partList);
int doAquireDate(int uid,int did);


FileHeader dateFileHeader,dateShiftFileHeader;
//int datesDirty=false;
int datesDeleted=false;
int weekDayMask[7] = {1,2,4,8,16,32,64};

void initDateList()
{
 int i;
 char path[1024];
 struct stat fs;

 dateList = new ( Date *) [DATEBLOCKSIZE];
 dateAnz=0;
 dateBlocks=1;
 dateMax = DATEBLOCKSIZE;
 for(i=0;i<dateMax; i++)
  dateList[i]=NULL;

 dateShiftList = new (DateShift *) [DATEBLOCKSIZE];
 dateShiftAnz=0;
 dateShiftMax=DATEBLOCKSIZE;
 for(i=0;i<dateShiftMax;i++)
  dateShiftList[i]=NULL;

 strncpy(dateFileHeader.magic,FILEHEADER_MAGIC,8);
 strncpy(dateFileHeader.type,FILEHEADER_DATE,4);
 strncpy(dateFileHeader.version,CURRENT_FILEVERSION_DATE,4);
 dateFileHeader.size =0;

 sprintf(path,"%s/comments",dataDir);
 if (stat(path,&fs) !=0)
  mkdir(path,0770);
 else
  if ( ! S_ISDIR(fs.st_mode))
   {
    printf("Error: File %s must be directory\n",path);
    exit(-1);
   }

}
void clearDateList ()
{
 int i,j;
 // FIXME memory leak. einzelne Objekte auf die dateList und dateShiftList zeigen lschen

 clearDateShifts ();
 clearDateUserModification();

 for(i=0; i<dateAnz; i++)
  {
   if(dateList[i] != NULL)
    {
     if(dateList[i]->shifts!=NULL)
      for(j=0;j<dateList[i]->dateShiftAnz; j++)
       {
	delete dateList[i]->shifts[j];
	dateList[i]->shifts[j] =NULL;
       }
     delete dateList[i];
     dateList[i]=NULL;
    }
  }
 delete dateList;
 dateList=NULL;
 // delete dateShiftList;
}

void extendDateList()
{
 Date **tmp;
 int anz,anz0;
 int i;
 
 dateBlocks++;
 anz= dateBlocks * DATEBLOCKSIZE;
 tmp= new ( Date *) [anz];
 dateMax=anz;
 anz0= (dateBlocks-1)  * DATEBLOCKSIZE;
 memcpy(tmp,dateList,anz0*sizeof(Date *));
 delete dateList;
 dateList=tmp;
 for(i=anz0;i<anz; i++)
  dateList[i]=NULL;
}

void extendCalList(Calendar *cal)
{
 Date **tmp;
 int anz;
 
 anz= cal->max + DATEBLOCKSIZE;
 tmp= new ( Date *) [anz];

 memcpy(tmp,cal->list,cal->max*sizeof(Date *));
 cal->max=anz;
 delete cal->list;
 cal->list=tmp;
}

void initDateShiftList(Date *d)
{
 int i;
 d->shifts = new ( DateShift *) [DATEBLOCKSIZE];
 d->dateShiftMax = DATEBLOCKSIZE;
 d->dateShiftAnz = 0;
 for(i=0;i<d->dateShiftMax;i++)
  d->shifts[i]=NULL;
 strncpy(dateShiftFileHeader.magic,FILEHEADER_MAGIC,8);
 strncpy(dateShiftFileHeader.type,FILEHEADER_SHIFT,4);
 strncpy(dateShiftFileHeader.version,CURRENT_FILEVERSION_SHIFT,4);
 dateShiftFileHeader.size =0;
}

void extendDatShiftMasterList()
{
 DateShift **tmp;
 int anz,anz0,i;
 
 //FIXME
 anz0 = dateShiftMax;
 anz  = dateShiftMax  + DATEBLOCKSIZE;
 tmp= new ( DateShift *) [anz];

 memcpy(tmp,dateShiftList,dateShiftMax*sizeof(DateShift *));
 dateShiftMax=anz;
 delete dateShiftList;
 dateShiftList=tmp;
 for(i=anz0;i<anz; i++)
  dateShiftList[i]=NULL;
}
void extendDateShiftList(Date *d)
{
 DateShift **tmp;
 int anz,anz0,i;
 
 //FIXME
 anz0 = d->dateShiftMax;
 anz= d->dateShiftMax + DATEBLOCKSIZE;
 tmp= new ( DateShift *) [anz];

 memcpy(tmp,d->shifts,d->dateShiftMax*sizeof(DateShift *));
 d->dateShiftMax=anz;
 delete d->shifts;
 d->shifts=tmp;
 for(i=anz0;i<anz; i++)
  d->shifts[i]=NULL;

}

void clearDateShifts ()
{
 int i;
 for(i=0;i<dateAnz; i++)
  if(dateList[i]!=NULL)
   if(!dateList[i]->deleted)
    {
     dateList[i]->dateShiftAnz=0;
     dateList[i]->dateShiftMax=0;
     delete dateList[i]->shifts;
     dateList[i]->shifts = NULL;
    }
 for(i=0;i<dateShiftAnz; i++)
  if(dateShiftList[i] != NULL)
   {
    delete dateShiftList[i];
    dateShiftList[i]=NULL;
   }
 dateShiftAnz=0;
 dateShiftMax=0;
 delete dateShiftList;
}


void initDateUserModification(User *usr)
{
 usr->dmodi    = new ( UserDateModification) [DATEBLOCKSIZE];
 usr->dmodiMax = DATEBLOCKSIZE;
 usr->dmodiAnz = 0;
}

void extendDateUserModification(User *usr)
{
 UserDateModification *tmp;
 int anz;
 
 anz= usr->dmodiMax + DATEBLOCKSIZE;
 tmp= new ( UserDateModification) [anz];

 memcpy(tmp,usr->dmodi,usr->dmodiMax*sizeof(UserDateModification));
 usr->dmodiMax=anz;
 delete usr->dmodi;
 usr->dmodi=tmp;
}
void initDateUserModification(UserDateModification *umodi)
{
 umodi -> ignored = false;
 umodi -> noReminder =false;
}

void clearDateUserModification ()
{
 int i;
 for(i=0;i<=userAnz; i++)
  if(userList[i].id==i)
   {
    delete userList[i].dmodi;
    userList[i].dmodi =NULL;
    userList[i].dmodiAnz=0;
    userList[i].dmodiMax=0;
    }
}

int deleteDate(int socket,char *t)
{
 int did,uid,i,u;
 int del_ok=false;
 char *tp[8];

 split(t,tp,8);
 did =atoi(tp[0]);
 uid =uname2uid(tp[1]);
 if(uid<0)
  {
   send2Client(socket,"ERR user unknown, no permissions to delete");
   return(0);
  }
 if(dateList[did]->init.id == uid)
  del_ok=true;
 else
  {
   for(i=0; i<dateList[did]->partAnz; i++)
    if ( (dateList[did]->part[i].perm & DELE_DATE) == DELE_DATE)
     { del_ok=true; break ;}
 }

if(!del_ok)
  {
   char tx[256];
   sprintf(tx,"ERR user %s has no permissions to delete this date",tp[1]);
   send2Client(socket,tx);
   return(0);
  }
 dateList[did]->deleted=true;

 // FIXME eleganter wird langsam bei vielen shifts
 for(i=0;i<dateShiftAnz;i++)
  if(dateShiftList[i]!=NULL)
   if(dateShiftList[i]->did == did)
    {
     dateShiftList[i]=NULL;
    }
 // FIXME Garbage collection fehlt
 dateList[did]->dateShiftAnz=0;

 for(u=0;u<=userAnz; u++)
  if(userList[u].id >=0)
   if(userList[u].dmodiAnz>0)
    {
     for(i=0;i<=userList[u].dmodiAnz; i++)
      {
       if(userList[u].dmodi[i].did == did)
	userList[u].dmodi[i].did =-1;
      }
     userList[uid].dmodiDirty=true;
    }


 
 recreateReminderList();
 datesDeleted=true;
 announceDate(dateList[did],NOTIFIER_DATE_IS_DELE);
 send2Client(socket,"done");
}

int addDate(char *ds)
{
 Date *d;
 char buffer[16384],*tp[64],*t,*s;

 int j;



 t=skip2nonWS(ds);
 if(*t!='{' && *t!='"')
  {
   s=buffer+1;
   buffer[0]=' ';
  }
 else
  s=buffer;
 strcpy(s,t);

 split(s,tp,64);

 // tp[0] enthlt die did, die bei add Date noch ungestetz ist
 if(!checkPermission(NULL,WRITE_NEW,uname2uid(tp[1])))
  return(false);

 d= new Date;
 fillUserInDate(&d->init,uname2uid(tp[2]),DATE_STAT_UKN,0,PERM_ALL);
 d->partAnz = fillUserListInDateList(d->part,tp[3]);
 for(j=0;j<d->partAnz; j++)
  if(d->part[j].id >=ADDRESOFFSET && d->part[j].id<=MAX_ID)
   {
    int idx = aid2idx(d->part[j].id-ADDRESOFFSET);
    adrList[idx]->dateCount++;
   }

 d-> startDate = atoi(tp[4]);
 d-> startTime = atoi(tp[5]);
 d-> stopDate = atoi(tp[6]);
 d-> stopTime = atoi(tp[ 7]);
 strcpy(d->descr,trimRight(tp[ 8]));
 checkString(d->descr);
 d->tlen=strlen(tp[ 8])+1;
 strcpy(d->descr+d->tlen,trimRight(tp[9]));
 checkString(d->descr+d->tlen);
 d->room = rname2rid(tp[10]);
 d->group = gname2gid(tp[11]);
 d->flags = DATE_FLAG_PRIVAT *atoi(tp[12]) + DATE_FLAG_GROUPINTERN *atoi(tp[13]) +
  DATE_FLAG_NOTIME *atoi(tp[20]) +DATE_FLAG_NONBLOCK * atoi(tp[21]);
 d->repeatTyp       = atoi(tp[14]);
 d->repeatStopDate  = atoi(tp[15]);
 d->repeatIntervall = atoi(tp[16]);
 d->repeatUnit      = atoi(tp[17]);
 d->priority        = atoi(tp[18]);
 addReminderList2Date(tp[19],d);

 d->comm =NULL;
 d->deleted =false;
 
 dateList[dateAnz]=d;
 d->id=dateAnz;
 dateAnz++;
 if(dateAnz>dateMax)
  extendDateList();

 for(j=0;j<d->partAnz; j++)
  addDate2Calendar(d,d->part[j].id);
 addDate2RoomCalendar(d,d->room);
 announceDate(d,NOTIFIER_DATE_IS_ADD);
 lastDateChange =time(NULL);
 initDateShiftList(d);

 d->seekPtr=0;
 d->dirty=true;
 return(true);
}

int addReminderList2Date(char *t,Date *d)
{
 char *tp[256];
 int anz,i;

 if( strlen(trimRight(t))==0)
  return(true);

 for(i=0;i<REMINDERS_IN_DATE; i++)
  d->reminder[i].ct.ctrl = NULL;

 anz=split(t,tp,255);
 d->remAnz =0;
 for(i=0;i<anz; i++)
  addReminder2Date(d,tp[i]);
 updateReminderList();
 recreateReminderList();
 return(true);
}

int aquireDate(int socket,char *ds)
{
 int did,uid;
 char *tp[8];

 split(ds,tp,8);
 did = atoi (tp[1]);
 uid = uname2uid(tp[0]);
 doAquireDate(uid,did);
 send2Client(socket,"done");
}
int doAquireDate(int uid,int did)
{
 userList[uid].editDate = new Date;
 memcpy(userList[uid].editDate,dateList[did],sizeof(Date));
}
int cancelEditDate (int socket,char *ds)
{
 int uid;
 uid = uname2uid(ds);
 if (userList[uid].editDate != NULL)
  {
   delete userList[uid].editDate;
   userList[uid].editDate =NULL;
  }
 send2Client(socket,"done");
}
 
		 
// FIXME language settings
int modifyDate(int socket,char *ds)
{
 Date *d,*ed;
 char buffer[16384],*tp[64],*t,*s;
 char done[4096],reject[4096];
 int v1,v2;
 int j,did,uid;
 char tmp[4096];
 UserInDate tmpUiD[512];
 int tmpAnz;
 int mustRecalcReminder=false;
 int nb;

 t=skip2nonWS(ds);
 if(*t!='{' && *t!='"')
  {
   s=buffer+1;
   buffer[0]=' ';
  }
 else
  s=buffer;
 strcpy(s,t);

 split(s,tp,64);

 did = atoi (tp[0]);
 d= dateList[did];
 uid = uname2uid(tp[1]);
 ed =  userList[uid].editDate;
 // tp[2] enthlt den inititator, der bei Modify nicht gendert werden kann
 
 strcpy(done,"");
 strcpy(reject,"");

 tmpAnz = fillUserListInDateList(tmpUiD,tp[3]);
 for(j=0;j<d->partAnz; j++)
  if(d->part[j].id >=ADDRESOFFSET && d->part[j].id<=MAX_ID)
   {
    int idx = aid2idx(d->part[j].id-ADDRESOFFSET);
    adrList[idx]->dateCount--;
   }

 d->partAnz=modifyPartList(ed->part,ed->partAnz,d->part,d->partAnz,tmpUiD,tmpAnz,reject,done);
 for(j=0;j<ed->partAnz; j++)
  if( (ed->part[j].flags & UID_FLAG_DELETED) > 1)
   {
    int ruid;
    if(verbose)
     if(ed->part[j].id<GROUPOFFSET)
      {
       if ( userList[ed->part[j].id].id == ed->part[j].id)
        printf("removing Date %d from user %d/%s\n",d->id,ed->part[j].id,uid2uname(ed->part[j].id)); //                 was userList[ed->part[j].id].name 
       else
        printf("removing Date %d from user %d\n",d->id,ed->part[j].id);
      }
     else
      printf("removing Date %d from user %d\n",d->id,ed->part[j].id);
    removeDateFromUserCal(d,ed->part[j].id);
   }
 for(j=0;j<d->partAnz; j++)
  if(d->part[j].id >=ADDRESOFFSET && d->part[j].id<=MAX_ID)
   {
    int idx = aid2idx(d->part[j].id-ADDRESOFFSET);
    adrList[idx]->dateCount++;
   }





 v1= atoi(tp[4]);
 v2= atoi(tp[5]);
 if(changed(ed->startDate,ed->startTime,v1,v2))  // Wurde diese Feld gendert?
  {
   if(d->dateShiftAnz>0 && d->repeatTyp!= NO_REPEAT)  // Wenn zwischenzeitlich bei einem Wiederholungstermin
    strcat(reject,"Anfangszeit ");                    // ein Shift eingetragen wurden, drfen die
   //                                                    Anfangszeiten nicht mehr gendert werden

   if(!changed(ed->startDate,ed->startTime,d->startDate,d->startTime))// Wurde inzwischen dieses Feld gendert?
    {
     d-> startDate = v1;
     d-> startTime = v2;
     strcat(done,"Anfangszeit ");
     mustRecalcReminder=true;
    }
   else
    strcat(reject,"Anfangszeit ");
  }
 v1= atoi(tp[6]);
 v2= atoi(tp[ 7]);
 if(changed(ed->stopDate,ed->stopTime,v1,v2))  // Wurde diese Feld gendert?
  {
   if(!changed(ed->stopDate,ed->stopTime,d->stopDate,d->stopTime))// Wurde  inzwischen dieses Feld gendert?
    {
     d-> stopDate = v1;
     d-> stopTime = v2;
     strcat(done,"Endzeit ");
    }
   else
    strcat(reject,"Endzeit ");
  }

 if(changed(ed->descr,tp[ 8]))
  {
   if(!changed(ed->descr,d->descr))
    {
     strcpy(tmp,trimRight(tp[ 8]));
     strcat(done,"Titel ");
    }
   else
    {
     strcpy(tmp,d->descr);
     strcat(reject,"Titel ");
    }
  }
 else
  {
   strcpy(tmp,ed->descr);
  }
 v1 = strlen(tmp)+1;

 if(changed(ed->descr + ed->tlen, tp[ 9]))
  {
   if(!changed(ed->descr + ed->tlen,d->descr + d->tlen))
    {
     strcpy(tmp+v1,trimRight(tp[ 9]));
     strcat(done,"Details ");
    }
   else
    {
     strcpy(tmp+v1,d->descr + d->tlen);
     strcat(done,"Details ");
    }
  }
 else
  strcpy(tmp+v1,ed->descr + ed->tlen);

 strcpy(d->descr,tmp);
 checkString(d->descr);
 d->tlen=v1;
 strcpy(d->descr+d->tlen,tmp+v1);
 checkString(d->descr+d->tlen);

 v1 =rname2rid(tp[10]);
 if(changed(ed->room,v1))
  {
   if(!changed(ed->room,d->room))
    {
     d->room=v1;
     strcat(done,"Ort ");
    }
   else
     strcat(reject,"Ort ");
  }

 v1 =gname2gid(tp[11]);
 if(changed(ed->group,v1))
  {
   if(!changed(ed->group,d->group))
    {
     d->group=v1;
     strcat(done,"Gruppe ");
    }
   else
     strcat(reject,"Gruppe ");
  }


 int pr,gi,nt;
 v1  = DATE_FLAG_PRIVAT*atoi(tp[12]);
 if(changed(ed->flags&DATE_FLAG_PRIVAT,v1))
  {
   if(!changed(ed->flags&DATE_FLAG_PRIVAT,d->flags&DATE_FLAG_PRIVAT))
    {
     pr = v1;
     strcat(done,"Privat-Status ");
    }
   else
    {
     strcat(reject,"Privat-Status ");
     pr = d->flags&DATE_FLAG_PRIVAT;
    }
  }
 else
  pr = d->flags&DATE_FLAG_PRIVAT;

 v1 =DATE_FLAG_GROUPINTERN *atoi(tp[13]);
 if(changed(ed->flags&DATE_FLAG_GROUPINTERN,v1))
  {
   if(!changed(ed->flags&DATE_FLAG_GROUPINTERN,d->flags&DATE_FLAG_GROUPINTERN))
    {
     gi = v1;
     strcat(done,"Gruppenintern-Status ");
    }
   else
    {
     strcat(reject,"Gruppenintern-Status ");
     gi = d->flags&DATE_FLAG_GROUPINTERN;
    }
  }
 else
  gi = d->flags&DATE_FLAG_GROUPINTERN;

 v1 =DATE_FLAG_NOTIME *atoi(tp[20]);
 if(changed(ed->flags & DATE_FLAG_NOTIME,v1))
  {
   if(!changed(ed->flags& DATE_FLAG_NOTIME,d->flags& DATE_FLAG_NOTIME))
    {
     nt=v1;
     strcat(done,"Ganztgigkeit ");
    }
   else
    {
     strcat(reject,"Ganztgigkeit ");
     nt = d->flags& DATE_FLAG_NOTIME;
    }
  }
 else
  nt = d->flags& DATE_FLAG_NOTIME;

 v1 =DATE_FLAG_NONBLOCK *atoi(tp[21]);
 if(changed(ed->flags & DATE_FLAG_NONBLOCK,v1))
  {
   if(!changed(ed->flags& DATE_FLAG_NONBLOCK,d->flags& DATE_FLAG_NONBLOCK))
    {
     nb=v1;
     strcat(done,"Blockadestatus ");
    }
   else
    {
     strcat(reject,"Blockadestatus ");
     nb = d->flags& DATE_FLAG_NONBLOCK;
    }
  }
 else
  nb = d->flags& DATE_FLAG_NONBLOCK;

 d->flags = pr+gi+nt+nb;

 

 v1=atoi(tp[14]);
 if(changed(ed->repeatTyp,v1))
  {
   if(d->dateShiftAnz>0 && v1== NO_REPEAT)  // Wenn zwischenzeitlich bei einem Wiederholungstermin ein Shift
    strcat(reject,"Anfangszeit ");          // eingetragen wurden, darf der REPEAT_TYP nicht NO_REPEAT werden.

   if(!changed(ed->repeatTyp,d->repeatTyp))
    {
     d->repeatTyp=v1;
     strcat(done,"Wiederholungart ");
    }
   else
     strcat(reject,"Wiederholungart ");
  }
 v1=atoi(tp[15]);
 if(changed(ed->repeatStopDate,v1))
  {
   if(!changed(ed->repeatStopDate,d->repeatStopDate))
    {
     d->repeatStopDate=v1;
     strcat(done,"Wiederholungshufigkeit ");
    }
   else
    strcat(reject,"Wiederholunsghufigkeit ");
  }
 v1=atoi(tp[16]);
 if(changed(ed->repeatIntervall,v1))
  {
   if(!changed(ed->repeatIntervall,d->repeatIntervall))
    {
     d->repeatIntervall=v1;
     strcat(done,"Wiederholungs-Sonderintervall ");
    }
   else
     strcat(reject,"Wiederholungs-Sonderintervall ");
  }
 v1=atoi(tp[17]);
 if(changed(ed->repeatUnit,v1))
  {
   if(!changed(ed->repeatUnit,d->repeatUnit))
    {
     d->repeatUnit=v1;
     strcat(done,"Wiederholungs-Sonderintervall-Einheit ");
    }
   else
     strcat(reject,"Wiederholungs-Sonderintervall-Einheit ");
  }
 v1=atoi(tp[18]);
 if(changed(ed->priority,v1))
  {
   if(!changed(ed->priority,d->priority))
    {
     d->priority=v1;
     strcat(done,"Prioritt ");
    }
   else
     strcat(reject,"Prioritt ");
  }

 modifyReminder(tp[19],d,ed,reject,done);
 recalcReminder(d);
//  if( mustRecalcReminder)
//   resetReminderStates(d);
 recreateReminderList();
 
 for(j=0;j<d->partAnz; j++)
  addDate2Calendar(d,d->part[j].id);
 addDate2RoomCalendar(d,d->room);

 if ( userList[uid].editDate  != NULL)
  {
   delete userList[uid].editDate;
   userList[uid].editDate =NULL;
  }
 if(strlen(reject)>0)
  {
   sprintf(buffer,"WARN: modify incomplete {%s} {%s}",done,reject);
   send2Client(socket,buffer);
  }
 else
  send2Client(socket,"OK");

 lastDateChange =time(NULL);

 announceDate(d,NOTIFIER_DATE_IS_MODI);
 d->dirty=true;
 return(true);
}

int modifyReminder(char *t,Date *cur, Date *ref,char *reject, char *done)
{
 Reminder mod[REMINDERS_IN_DATE],*crem,*rrem;
 Reminder *rl[REMINDERS_IN_DATE];
 int curRemStat[REMINDERS_IN_DATE];
 int modRemStat[REMINDERS_IN_DATE];
 int i,mremAnz,crid,mrid,mustReject=false,d;

 memset (curRemStat,0,REMINDERS_IN_DATE*sizeof(int));
 memset (modRemStat,0,REMINDERS_IN_DATE*sizeof(int));

 mremAnz = buildTempReminderList(cur,mod,t);


 // Analysiere was mit den Remindern passieren soll die aus ref stammen.
 for(i=0;i<ref->remAnz; i++)
  {
   rrem = &ref->reminder[i];
   crid = findReminderInList(rrem,cur->reminder,cur->remAnz);
   mrid = findReminderInList(rrem,mod,mremAnz);

   if (crid>=0 ) // Reminder ist in cur noch enthalten
    {
     if(mrid >=0)  // Reminder ist in mod noch enthalten
      {
       modRemStat[mrid]=1;
       curRemStat[crid]=1;
      }
     else       // Wenn Reminder in mod gelscht wurde, tue dies auch in cur
       curRemStat[crid]=-1;      
    }
   else  // Reminder wurde aus cur gelscht
    {
     if(mrid >=0)     // Wenn er noch in mod enthalten ist geben mustReject Signal und ignoriere Reminder in mod
      {
       modRemStat[mrid]=-1;
       mustReject=true;
      }
    }
  }

 // Nun alle Reminder die in cur neu hinzugekommen sind.
 for(i=0;i<cur->remAnz; i++)
  if(curRemStat[i]==0)           // reminder ist neu
   {
    crem = &cur->reminder[i];
    mrid = findReminderInList(crem,mod,mremAnz);
    if(mrid>=0)   // Wenn er auch in mod enthalten ist, weise diesen zurck.
     {
      modRemStat[mrid]= 1;
      mustReject=true;
     }
   }

 // Lsche die CReminderControll-Strukturen aller zu lschenden Remin er
 for(i=0;i<cur->remAnz; i++)
  if(curRemStat[i]< 0)
   {
    delete cur->reminder[d].ct.ctrl;
    cur->reminder[d].ct.ctrl=NULL;
   }

 // Kompacktiere die Reminder in cur
 d=0;
 for(i=0;i<cur->remAnz; i++)
  if(curRemStat[i]>=0)
   {
    if(d<i)
     memcpy(&cur->reminder[d],&cur->reminder[i],sizeof(Reminder));
    d++;
   }
 

 // Nun die neuen von mod hinzufgen
 for(i=0;i<mremAnz; i++)
  {
   if(modRemStat[i] == 0)
    {
     memcpy(&cur->reminder[d],&mod[i],sizeof(Reminder));
     d++;
    }
  }
 cur->remAnz=d;

 if(mustReject>0)
  strcat(reject,"Erinnerer(teilw.)");
 else
  strcat(done,"Erinnerer(alles) ");

 return(true);
}

int  modifyPartList(UserInDate *ref,int refAnz, UserInDate *cur,int curAnz, UserInDate *chg,int chgAnz,char *reject, char* done)
{
 UserInDate tmp[512],*ruid,*cuid,*uid;
 int tmpAnz=0,i;
 int tryChange,add;
 char tx[256];

 
  for(i=0;i<refAnz; i++)
   ref[i].flags |= UID_FLAG_DELETED;

 for(i=0;i<chgAnz; i++)
  {
   uid = &chg[i];
   ruid = findEntry4User(uid->id,ref,refAnz);
   cuid = findEntry4User(uid->id,cur,curAnz);
   add=false;
   tryChange=false;
   
   if( ruid ==NULL)
    {
     if(cuid==NULL)
      add=true;
     else
      {
       sprintf(tx,"Teilnehmer.%s.all ",uid2uname(uid->id));  //                 was userList[uid->id].name 
       strcat(reject,tx);
      }
    }
   else
    {
     if(cuid==NULL)
      {
       sprintf(tx,"Teilnehmer.%s.deleted ",uid2uname(uid->id));  //                 was userList[uid->id].name 
       strcat(reject,tx);
      }
     else
      tryChange=true;
    }

   if(add)
    {
     char nam[128];
     memcpy(&tmp[tmpAnz],uid,sizeof(UserInDate));
     if(uid->id<GROUPOFFSET)
      sprintf(tx,"Teilnehmer.%s.added ",uid2uname(uid->id));  //                 was userList[uid->id].name 
     else if (uid->id>=ADDRESOFFSET && uid->id<=MAX_ID)
      sprintf(tx,"Teilnehmer.%s.added ",aid2cname(uid->id-ADDRESOFFSET,nam)); 
     else
      sprintf(tx,"Teilnehmer.%s.added ",gid2gname(uid->id-GROUPOFFSET));  //                 was groupList[uid->id-GROUPOFFSET].name 
     
     strcat(done,tx);
     tmpAnz++;
    }
   if(tryChange)
    {
     modifySingleUserInDate(ruid,cuid,uid,&tmp[tmpAnz],reject,done);
     tmpAnz++;
     ruid->flags &= (~UID_FLAG_DELETED);
    }
  }



 // Alle UiD bernehmen die in cur hinzugekommen sind, nachdem ref abgespeichert wurde
 for(i=0;i<curAnz; i++)
  {
   cuid = &cur[i];
   ruid = findEntry4User(cuid->id,ref,refAnz);
   if(ruid==NULL)
    {
     memcpy(&tmp[tmpAnz],cuid,sizeof(UserInDate));
     tmpAnz++;
     ruid->flags &= (~UID_FLAG_DELETED);
    }
  }
   
 memcpy(cur,tmp,sizeof(UserInDate)*tmpAnz);
 return(tmpAnz);
}
int removeDateFromUserCal(Date *d,int  uid)
{
 Date **t;
 int i,j;
 Calendar *cal;

 if(uid<GROUPOFFSET)
  cal = & userList[uid].cal;
 else if(uid<ROOMOFFSET)
  cal = & groupList[uid-GROUPOFFSET].cal;
 else if(uid<ADDRESOFFSET)
  cal = & roomList[uid-ROOMOFFSET].cal;
 else 
  return true;

 for(i=0;i<cal->anz;i++)
  if(d == cal->list[i])
   break;

 if (d == cal->list[i])
  for(j=i+1; j< cal->anz; j++)
   cal->list[j-1] =cal->list[j];
 
 cal->anz --;
}
int modifySingleUserInDate(UserInDate *ref,UserInDate *cur,UserInDate *chg,UserInDate *tmp,char *reject, char* done)
{
 char tx[256],name[128];
 

 if(chg->id>=ADDRESOFFSET && chg->id<=MAX_ID)
  strcpy(name,aid2cname(chg->id-ADDRESOFFSET,tx));
 else if(chg->id>=GROUPOFFSET)
  strcpy(name,gid2gname(chg->id-GROUPOFFSET)); //                 was groupList[chg->id-GROUPOFFSET].name 
 else 
  strcpy(name,uid2uname(chg->id)); //                 was userList[chg->id].name 

 tmp->id = chg->id;
 if(changed(ref->status,chg->status))
  {
   if(!changed(cur->status,ref->status))
    {
     sprintf(tx,"Teilnehmer.%s.status ",name); 
     strcat(done,tx);
     tmp->status=chg->status;
    }
   else
    {
     sprintf(tx,"Teilnehmer.%s.status ",name); 
     strcat(reject,tx);
     tmp->status=cur->status;
    }
  }
 else 
  tmp->status=ref->status;

 if(changed(ref->flags & UID_NONLOCAL_FLAG_MASK,chg->flags & UID_NONLOCAL_FLAG_MASK))
  {
   if(!changed(cur->flags & UID_NONLOCAL_FLAG_MASK,ref->flags & UID_NONLOCAL_FLAG_MASK))
    {
     sprintf(tx,"Teilnehmer.%s.flags ",name); 
     strcat(done,tx);
     tmp->flags=chg->flags;
    }
   else
    {
     sprintf(tx,"Teilnehmer.%s.flags ",name); 
     strcat(reject,tx);
     tmp->flags=cur->flags;
    }
  }
 else 
  tmp->flags=ref->flags;

 if(changed(ref->perm,chg->perm))
  {
   if(!changed(cur->perm,ref->perm))
    {
     sprintf(tx,"Teilnehmer.%s.perm ",name); 
     strcat(done,tx);
     tmp->perm=chg->perm;
    }
   else
    {
     sprintf(tx,"Teilnehmer.%s.perm ",name); 
     strcat(reject,tx);
     tmp->perm=cur->perm;
    }
  }
 else 
  tmp->perm=ref->perm;

 if(changed(ref->typ,chg->typ))
  {
   if(!changed(cur->typ,ref->typ))
    {
     sprintf(tx,"Teilnehmer.%s.typ ",name); 
     strcat(done,tx);
     tmp->typ=chg->typ;
    }
   else
    {
     sprintf(tx,"Teilnehmer.%s.typ ",name); 
     strcat(reject,tx);
     tmp->typ=cur->typ;
    }
  }
 else 
  tmp->typ=ref->typ;

 return(true);
}

UserInDate * findEntry4User(int id,UserInDate* list, int anz)
{
 int i;
 for(i=0; i<anz; i++)
  if(list[i].id == id)
   return(&list[i]);
 return(NULL);
}

int changed (int v1, int v2)
{
 if(v1 == v2)
  return false;
 return true;
}
int changed (int v1a,int v1b, int v2a, int v2b)
{
 if(v1a == v2a && v1b == v2b)
  return false;
 return true;
}
int changed (char* v1, char * v2)
{
 trimRight(v1);
 trimRight(v2);
//  printf("(\"%s\" = \"%s\") =%d\n",v1,v2,strcmp(v1,v2));
 if(strcmp(v1,v2)==0)
  return false;
 return true;
}
char * trimRight (char *t)
{
 char *s;
 s= t+strlen(t)-1;
 while (*s ==' ' || *s=='\n' || *s=='\t')
  s--;
 if(s[1] !='\0' && s>t)
  s[1]='\0';
 return(t);
}

char * strTrim (char *t)
{
 char *s,*z;

 s= t+strlen(t)-1;
 while (*s ==' ' || *s=='\n' || *s=='\t')
  s--;
 if(s[1] !='\0' && s>t)
  s[1]='\0';

 s=t;
 while(*s ==' ' || *s=='\n' || *s=='\t')
  s++;
 if(s>t)
  {
   z=t;
   while(*s!='\0')
    {
     *z=*s;
     z++;
     s++;
    }
   // t++;
   *z='\0';
  }
 return(t);
}

int fillUserListInDateList(UserInDate *uid,char *names)
{
 int i,anz,id,skipped=0;
 char *tp[257],*s;

 if(skip2nonWS(names) == NULL)
  return(0);

 anz = split(names,tp,257);
 for(i=0;i<anz; i++)
  if ( ! fillUserInDateList(&uid[i-skipped],tp[i]))
   skipped++;

 return(anz-skipped);
}

int fillUserInDateList(UserInDate *uid,char *str)
{
 int i,anz,id,skipped=0;
 char *tp[16],*s;

 if(skip2nonWS(str) == NULL)
  return(0);

 split(str,tp,16);
 if (atoi(tp[4])==1)
  {
   id = gname2gid(tp[0]);      // FIXME was ist mit externen
   if(id>=0)
    id+= GROUPOFFSET;
  }
 else if (atoi(tp[4])==2)
  {
   id = aname2aid(tp[0]);      // FIXME was ist mit externen
   if(id>=0)
    id+= ADDRESOFFSET;
  }
 else
  id = uname2uid(tp[0]);

 if(id>=0)
  {
   uid->id =id;
   uid->status=atoi(tp[1]);
   uid->flags=atoi(tp[2]);
   uid->perm=atoi(tp[3]);
   uid->typ=tp[5][0];
   return true;
  }
 return false;
}

void fillUserInDate(UserInDate *uid, int id,int stat,int flag,int perm)
{
 uid->id=id;
 uid->status=stat;
 uid->perm =perm;
 uid->flags=flag;
}


void addComm(int socket,char *t)
{
 char *tp[64],text[8192],*s;
 int did,r,l;

 split(t,tp,64);
 did =atoi(tp[0]);
 if(did>dateAnz || did<0)
  {
   send2Client(socket,"no such data");
  }
 else
  {
   sprintf(text,"%s: %s\n",tp[1],trimRight(tp[2]));
   checkString(text);
   if(dateList[did]->comm!=NULL)
    l = strlen(dateList[did]->comm);
   else
    l=0;
   s= new char [l + strlen(text) +4];
   if(s!=NULL)
    {
     if(dateList[did]->comm !=NULL)
      strcpy(s,dateList[did]->comm);
     strcat(s,text);
     if(dateList[did]->comm!=NULL)
      delete dateList[did]->comm;
     dateList[did]->comm=s;
     writeComm(did,dateList[did]->comm);
    }
   else
    printf("Can't get memroy for comments, ignoring\n");
   send2Client(socket,"OK");
  }
}
void writeComm(int did, char *t)
{
 char file[1024];
 FILE *fp;
 sprintf(file,"%s/comments/%09d.txt",dataDir,did);
 fp =fopen(file,"w");
 if(fp == NULL)
  printf("WARNING Can't open %s for writing\n",file);
 else
  {
   fprintf(fp,"%s\n",t);
   fclose(fp);
  }
}

void getComm (int socket,char *t)
{
 int did;
 char tx[8196];
 did =atoi(t);
 send2Client(socket,dateList[did]->comm);
}

int sendBriefDate(int socket, char *t)
{
 char *tp[8],buffer[65536];
 static int uid,did;
 int baseDate;
 Date *d;

 split(t,tp,8);
 uid = uname2uid(tp[0]);
 if(uid<0)
  { 
   send2Client(socket,"ERR: no such user (code 1)");
   return 0;
  }
 if(uid >userAnz)
  {
   send2Client(socket,"ERR: no such user (code 2)");
   return 0;
  }
 if(userList[uid].id<0)
  {
   send2Client(socket,"ERR: no such user (code 3)");
   return 0;
  }
 did = atoi(tp[1]); // FIXME check ob date existiert.
 if ( dateList[did] == NULL)
  {
   send2Client(socket,"ERR: no such date");
   return 0;
  }

 d=dateList[did];
 baseDate=atoi(tp[2]);

 briefDate2String(buffer,d,baseDate,uid);
 send2Client(socket,buffer);
}
int sendMultiBriefDate(int socket, char *t)
{
 char *tp[256],tmp[65536],buffer[512000];
 static int uid,did;
 int baseDate,anz,i;
 Date *d;

 anz= split(t,tp,255);
 uid = uname2uid(tp[0]);
 if(uid<0)
  { 
   printf("no such user '%s'\n",tp[0]);
   send2Client(socket,"ERR: no such user (code 1)");
   return 0;
  }
 if(uid >userAnz)
  {
   send2Client(socket,"ERR: no such user (code 2)");
   return 0;
  }
 if(userList[uid].id<0)
  {
   send2Client(socket,"ERR: no such user (code 3)");
   return 0;
  }
 strcpy(buffer,"");

 for(i=1;i+1<anz; i+=2)
  {
   did = atoi(tp[i]); // FIXME check ob date existiert.
   if ( dateList[did] == NULL)
    {
     send2Client(socket,"ERR: no such date");
     return 0;
    }

   d=dateList[did];
   baseDate=atoi(tp[i+1]);

   briefDate2String(tmp,d,baseDate,uid);
   if( strlen(buffer)+strlen(tmp)<512000 )
    {
     strcat(buffer,"{");
     strcat(buffer,tmp);
     strcat(buffer,"} ");
    }
   else
    {
     strcat(buffer,"{ EOL }");
     break;
    }
  }
 send2Client(socket,buffer);
}

void briefDate2String(char *buffer,Date *d,int baseDate , int uid)
{
 int privat=0,gintern=0,perm,noTime=0,nonBlock=0;
 char eList[16384],tList[16384],aList[16384],iList[16384];
 CalendarItem ci,wci;
 UserDateModification *umodi;
 int noRem=false,igno=false;
 int refDate,refTime;
 int startDate=-1,startTime=-1,stopDate=-1,stopTime=-1;

 perm = getPermission(d,uid,d->group);
 umodi = getUserModification4Date(d->id,uid);
 if(umodi!=NULL)
  {
   noRem = umodi->noReminder;
   igno  = umodi->ignored;
  }


 if( (d->flags & DATE_FLAG_PRIVAT)>0)
  privat=1;
 if( (d->flags & DATE_FLAG_GROUPINTERN)>0)
  gintern=1;
 if( (d->flags & DATE_FLAG_NOTIME)>0)
  noTime=1;
 
 if(d->repeatTyp == NO_REPEAT)
  {
   startDate = d->startDate;
   startTime = d->startTime;
   stopDate  = d->stopDate;
   stopTime  = d->stopTime;
  } else {
   ci.startDate=d->startDate;
   ci.startTime=d->startTime;
   ci.stopDate =d->stopDate;
   ci.stopTime =d->stopTime;
   ci.count=0;
   ci.dshStartPtr=0;
   ci.startwDay=weekDayByDate(ci.startDate);
   memcpy(&wci,&ci,sizeof(CalendarItem));
   d->dateShiftPtr =0;
   
   jump2NextDateAfter(&ci,&wci,d,baseDate);
   if ( wci.type == DATE_SHIFTED)
    {
     refDate = d->shifts[wci.dshStartPtr]->refDate;
     refTime = d->shifts[wci.dshStartPtr]->refTime;
    }
   else
    {
     refDate = wci.startDate;
     refTime = wci.startTime;
    }
   startDate = wci.startDate;
   startTime = wci.startTime;
   stopDate  = wci.stopDate;
   stopTime  = wci.stopTime;
  }

 if(dateIs2Privat2Me(d,uid) )
  {
   int i,tl,ul;
   sprintf(tList,"privater Termin von %s",uid2Fullname(d->init.id));
   strcpy(aList,tList);
   tl = strlen(tList);
   for(i=1;i<d->partAnz; i++)
    {
     ul = strlen(uid2Fullname(d->part[i].id))+2;
     //     ul = strlen(uid2Fullname(d->part[i].id))+2; //                 was userList[d->part[i].id].full 
     if(tl+ul<80)
      {
       strcat(tList,", ");
       strcat(tList,uid2Fullname(d->part[i].id));
       tl += ul;
      }
     else
      {
       strcat(tList," ...");
       break;
      }
     strcat(aList,", ");
     strcat(aList,uid2Fullname(d->part[i].id));
    }
   printf("perm =%d ; aList='%s'\n",perm,aList);
   sprintf(buffer,"%d {%s} %d %d %d %d {}  {%s} %d %d {}  {} 0 %d  %d %d  %d %d  %d",
	   d->id,tList,startDate,startTime,stopDate,stopTime,
	   aList,privat+2,gintern,noTime,
	   refDate,refTime,igno,noRem,perm);
 }
 else
  {
   strcpy(tList,"");
   UiDlist2BriefStr(d->part,d,tList,d->partAnz,d->init.id,0,0);
   sprintf(buffer,"%d {%s} %d %d %d %d {%s}  {%s} %d %d {%s}  {%s} %d %d  %d %d  %d %d  %d",
	   d->id,d->descr,startDate,startTime,stopDate,stopTime,rid2rname(d->room), 
	   d->descr+d->tlen,privat,gintern,tList,gid2gname(d->group),d->repeatTyp,noTime, 
	   refDate,refTime,igno,noRem,perm);
  }

}

int UiDlist2BriefStr(UserInDate *ul,Date *d, char *t,int anz,int init,int refDate,int refTime)
{
 char ent[256],name[128],ig,tp;
 int i,id;
 int status;

 for(i=0;i<anz; i++)
  {
   ig=0;
   if(ul[i].id == init)
    tp='I';
   else
    tp=(char) ul[i].typ;

   if(ul[i].id>=ADDRESOFFSET && ul[i].id<=MAX_ID)                 // FIXME externe
    {
     ig='a';
     id  = ul[i].id-ADDRESOFFSET;
     printf("id=%d <- %d\n",id,ul[i].id);
     strcpy(name,aid2name(id,ent));
     status = ul[i].status;
    }
   else if(ul[i].id>=GROUPOFFSET)                 // FIXME externe
    {
     ig='g';
     strcpy(name,gid2gname(ul[i].id-GROUPOFFSET)); //                 was groupList[ul[i].id-GROUPOFFSET].name 
     status = ul[i].status;
    }
   else
    {
     ig='u';
     //     strcpy(name,uid2Fullname(ul[i].id)); //                 was userList[ul[i].id].full 
     strcpy(name,uid2Fullname(ul[i].id));
     status = ul[i].status;
     if (d->repeatTyp != NO_REPEAT)
      {
       int j,k;
       for(j=0;j<d->dateShiftAnz; j++)
	if(d->shifts[j]->refDate == refDate && d->shifts[j]->refTime == refTime)
	 {
	  if( d->shifts[j]->partStatus[i] !=0)
	   status = d->shifts[j]->partStatus[i];
	 }
      }
    }
   sprintf(ent,"{%c {%s} %d %c }",tp,name,status,ig);
   strcat(t,ent);
   strcat(t," ");
  }
}

int sendDate(int socket, char *t,int aquire)
{
 char *tp[8],buffer[400000],gList[16384],aList[200000];
 char tList[16384],rList[16384],txt[128],*comm;
 int uid,did,perm,i;
 int privat=0,gintern=0,noTime=0,nonBlock=0;
 Date *d;
 UserInDate *self;

 split(t,tp,8);
 uid = uname2uid(tp[0]);
 if(uid<0)
  { 
   send2Client(socket,"ERR: no such user (code 1)");
   return 0;
  }
 if(uid >userAnz)
  {
   send2Client(socket,"ERR: no such user (code 2)");
   return 0;
  }
 if(userList[uid].id<0)
  {
   send2Client(socket,"ERR: no such user (code 3)");
   return 0;
  }
 did = atoi(tp[1]); // FIXME check ob date existiert.
 if ( dateList[did] == NULL)
  {
   send2Client(socket,"ERR: no such date");
   return 0;
  }
 d=dateList[did];
 perm = getPermission(d,uid,d->group);

 strcpy(tList,"");
 UiDlist2str(d->part,tList,d->partAnz);

 if( (d->flags & DATE_FLAG_PRIVAT)>0)
  privat=1;
 if( (d->flags & DATE_FLAG_GROUPINTERN)>0)
  gintern=1;
 if( (d->flags & DATE_FLAG_NOTIME)>0)
  noTime=1;
 if( (d->flags & DATE_FLAG_NONBLOCK)>0)
  nonBlock=1;

 strcpy(rList,"");
 for (i=0;i<d->remAnz; i++)
  {
   strcat(rList,reminder2Str4Date(&d->reminder[i],txt));
  }
 if(d->comm!=NULL)
  comm = d->comm;
 else
  comm = "";

 //               0 1   2   3  4  5  6  7    8     9    10  11 12 13 14 15 16 17 18   19  20  21 22 23    24  25
//  sprintf(buffer,"%d %s {%s} %d %d %d %d {%s} {%s} {%s} {%s} %d %d %d %d %d %d %d {%s} %d {%s} %d %d {%s} {%s} %d",
 sprintf(buffer,"%d %s {%s} %d %d %d %d {%s} {%s} {%s} {%s} %d %d %d %d %d %d %d {%s} %d {%s} %d %d {%s} {%s} %d",
	 perm,uid2uname(d->init.id),tList,d->startDate,d->startTime,d->stopDate,d->stopTime,
	 d->descr, d->descr+d->tlen,rid2rname(d->room),gid2gname(d->group),privat,gintern,  
	 d->repeatTyp,d->repeatStopDate,d->repeatIntervall,d->repeatUnit,d->priority,rList,noTime,comm,
	 d->dateShiftAnz,nonBlock,groupsOfUser(uid,gList),briefAdressList(uid,aList),ulistUpdateTim);
 if(aquire)
  doAquireDate(uid,did);
 send2Client(socket,buffer);
}

int sendInfo4NewDate(int socket, char *t)
{
 int uid;
 char *tp[8],buffer[400000],gList[16384],aList[200000];

 split(t,tp,8);
 uid = uname2uid(tp[0]);
 if(uid<0)
  { 
   send2Client(socket,"ERR: no such user (code 1)");
   return 0;
  }
 if(uid >userAnz)
  {
   send2Client(socket,"ERR: no such user (code 2)");
   return 0;
  }
 if(userList[uid].id<0)
  {
   send2Client(socket,"ERR: no such user (code 3)");
   return 0;
  }
 sprintf(buffer," {%s} {%s} %d",groupsOfUser(uid,gList),briefAdressList(uid,aList),ulistUpdateTim);
 send2Client(socket,buffer);
}
int UiDlist2str(UserInDate *ul, char *t,int anz)
{
 char ent[256],name[128],ig,full[128];
 int i,id;
 for(i=0;i<anz; i++)
  {
   ig=0;
   if(ul[i].id>=ADDRESOFFSET && ul[i].id<=MAX_ID)                 // FIXME externe
    {
     ig='a';
     strcpy(name,aid2cname(ul[i].id-ADDRESOFFSET,ent));
     strcpy(full,aid2name(ul[i].id-ADDRESOFFSET,ent));  // Bei full werden Klammer untern gesetzt, da auch 'user' 
    }                                                   // diese braucht ;-)
   else if(ul[i].id>=GROUPOFFSET)                 // FIXME externe
    {
     ig='g';
     strcpy(name,gid2gname(ul[i].id-GROUPOFFSET)); //                 was groupList[ul[i].id-GROUPOFFSET].name 
     sprintf(full,"Gruppe %s",gid2gname(ul[i].id-GROUPOFFSET)); //                 was groupList[ul[i].id-GROUPOFFSET].name 
    }
   else
    {
     ig='u';
     strcpy(name,uid2uname(ul[i].id)); //                 was userList[ul[i].id].name 
     strcpy(full,uid2Fullname(ul[i].id)); //                 was userList[ul[i].id].full 
    }
   sprintf(ent,"{%s %d %d %d %c %c {%s}} ",name,ul[i].status,ul[i].flags,ul[i].perm,ig,ul[i].typ,full);
   strcat(t,ent);
  }
}

int split(char *txt,char **tp ,int max)
{
 int sc=0,bc=0,qc=0;
 int i=0,anz;
 char *s,*t;

 s=skip2nonWS(txt);
 if(s==NULL)
  tp[0]=txt;
 else
  {
   tp[i]=s;
   i++;

   for(t=s; *t!='\0'; t++)
    {
     // Alle "" '' {}-Blcke dedektieren
     if(sc==0 && qc==0) // In Quotes und strings nicht nach {}-Blcken suchen
      {
       if(*t=='{')
	bc++;
       if(*t=='}')
	bc--;
      }
     if(*t=='"')
      sc =sc ^1;

     if(sc==0 && qc==0 && bc==0)// In "" '' {}-Blcken  nicht nach WS suchen
      if(*t==' ' || *t=='\t')
       {
	if(t==s)             // Falls t auf den Nachfolger des letzten tp zeigt (d.h. meherer WS hinter einander
	 {                   // verschiebe den letzten tp nur , sonst lege einen neunen an
	  tp[i-1]=t;
	  s=t+1;
	 }
	else
	 {
	  tp[i]=t;
	  i++;
	  if(i==max)
	   break;
	  s=t+1;
	 }
       }	
    }
  }

 anz=i;
 for(i=0;i<anz;i++)
  {
   s=skip2nonWSnl(tp[i]);
   if(s==NULL)
    anz=i;
   else
    {
     tp[i]=s;
     s--;
     if(s>=txt)
      *s='\0';
    }
  }
 for(i=0;i<anz;i++)
  {
   s=tp[i];
   if(*s=='{')
    {
     tp[i]=s+1;
     s=strrchr(tp[i],'}');
     *s='\0';
    }
   if(*s=='"')
    {
     tp[i]=s+1;
     s=strrchr(tp[i],'"');
     *s='\0';
    }
   if(*s=='\'')
    {
     tp[i]=s+1;
     s=strrchr(tp[i],'\'');
     *s='\0';
    }
  }


 if (anz >0)
  {
   s=tp[anz-1]+strlen(tp[anz-1])-1;
   while (*s== ' ' || *s =='\t')
    s--;
   s++;
   *s='\0';
  }
 return(anz);
}

void exportDate(Date *d,char *file)
{
 FILE *fp;
 int i;

 fp=fopen(file,"w");
 
 fprintf(fp,"TERMIN           : %s\n",d->descr);
 fprintf(fp,"Zeit             : %d %6.2f - %d %6.2f\n",d->startDate,(float)d->startTime/100,d->stopDate,(float)d->stopTime/100);
 fprintf(fp,"eingetragen durch: %s/%d\n",uid2uname(d->init.id),d->init.id); //                 was userList[d->init.id].name 
 fprintf(fp,"Teilnehmer:        ");
 if(d->partAnz>0)
  for(i=0;i<d->partAnz; i++)
   fprintf(fp,"%c %s/%d ",d->part[i].typ,id2string(d->part[i].id),d->part[i].id);
 else
  fprintf(fp,"N/A");
 fprintf(fp,"\n");
 fprintf(fp,"Erluterung     : %s\n",d->descr+d->tlen);
 fclose(fp);
}

char * id2string(int id)
{
 static char str[1024];
 if(id>=ADDRESOFFSET && id<=MAX_ID)
  aid2name(id,str);
 else if (id>=ROOMOFFSET)
  strcpy(str,rid2rname(id-ROOMOFFSET)); //                 was roomList[id-ROOMOFFSET].name 
 else if (id>=GROUPOFFSET)
  strcpy(str,gid2gname(id-GROUPOFFSET)); //                 was groupList[id-GROUPOFFSET].name 
 else 
  strcpy(str,uid2uname(id)); //                 was userList[id].name 
 return(str);
}

int writeDates()
{
 FILE *fp;
 char file[4096],file2[4100];
 int i,j,r,rtim;
 ReminderControl *rctrl[512];
 int globalDirty=false;
 int dirtyDates=false;
 int c=0,cs;

 if(datesDeleted)
  {
   writeAllDates();
   datesDeleted=false;
   return(true);
  }

 for(i=0;i<dateAnz; i++)
  if(dateList[i]!=NULL)
   if(dateList[i]->dirty)
    {
     dirtyDates=true;
     break;
    }
 
 if(dirtyDates)
  {
   if(verbose)
    printf("found dirty Dates\n");
   sprintf(file,"%s/dates",dataDir);
   fp=fopen(file,"r+");
   if(fp==NULL)
    {
     printf("can't open %s\n",file);
     exit(-1);
    }

   c=0;
   for(i=0;i<dateAnz; i++)
    if(dateList[i]!=NULL)
     if(! dateList[i]->deleted)
      if( dateList[i]->dirty)
       {
	for(r=0;r<dateList[i]->remAnz ; r++)
	 {
	  rctrl[r]=dateList[i]->reminder[r].ct.ctrl;
	  if (dateList[i]->reminder[r].ct.ctrl !=NULL)
	   {
	    rtim = dateList[i]->reminder[r].ct.ctrl->lastSendTim;
	    dateList[i]->reminder[r].ct.tim = rtim;
	   }
	  else
	   printf("Reminder %d of Date %s/%s has now controll\n",r,dateList[i]->id,dateList[i]->descr);
	 }
	if (dateList[i]->seekPtr >0)
	 {
	  printf("seekptr is %d \t moving to \bn",ftell(fp),dateList[i]->seekPtr);
	  fseek(fp,dateList[i]->seekPtr,SEEK_SET);
	  printf("seekptr is now %d\n",ftell(fp));
	  fwrite(dateList[i],sizeof(Date),1,fp);
	  printf("seekptr is now %d\n\n",ftell(fp));
	 }
	else
	 globalDirty=true;
	for(r=0;r<dateList[i]->remAnz ; r++)
	 {
	  if (rctrl[r] !=NULL)
	   dateList[i]->reminder[r].ct.ctrl = rctrl[r];
	 }
	if(globalDirty)
	 break;
	dateList[i]->dirty=false;
	c++;
       }
   fclose(fp);
  }

 if(globalDirty)
  {
   printf("dates globally dirty\n");
   writeAllDates(false);
  }
 cs=0;
 globalDirty=false;
 dirtyDates=false;
 for(i=0;i<dateShiftAnz; i++)
  if(dateShiftList[i]!=NULL)
   {
    if(dateShiftList[i]->dirty)
     {
      dirtyDates=true;
      break;
     }
    int id = dateShiftList[i]->did;
    if(id<0 || id>=dateAnz)
     {
      checkDateShiftsAndRecontruct();
      writeAllDates(false);
      dirtyDates=false;
      break;
     }
    else if(dateList[id] == NULL)
     {
      checkDateShiftsAndRecontruct();
      writeAllDates(false);
      dirtyDates=false;
      break;
     }
    else if (dateShiftList[i]->refDate ==0 )
     {
      checkDateShiftsAndRecontruct();
      writeAllDates(false);
      dirtyDates=false;
      break;
     }
   }
 if(dirtyDates)
  {
   printf("dirty shifts\n");
   sprintf(file,"%s/dates.shift",dataDir);
   fp=fopen(file,"a");
   if(fp==NULL)
    {
     printf("can't open %s\n",file);
     exit(-1);
    }
   for(i=0;i<dateShiftAnz; i++)
    if(dateShiftList[i]!=NULL)
     if(dateShiftList[i]->dirty)
      {
       if(dateShiftList[i]->seekPtr>0)
	{
	 fseek(fp,dateShiftList[i]->seekPtr,SEEK_SET);
	 fwrite(dateShiftList[i],sizeof(DateShift),1,fp);
	}
       else
	{
	 globalDirty=true;
	 break;
	}
       dateShiftList[i]->dirty=false;
       cs++;
      }
   fclose(fp);
  }
   
 if(globalDirty)
  writeAllDateShifts(false);
 else
  if(c+cs>0)
   printf("dates written (%d %d)\n",c,cs);
 writeUserMods();

}

void writeUserMods()
{
 int i,j;
 FILE *fp;
 char file[4096],file2[4100];

 for (i=0; i<=userAnz; i++)
  {
   if(userList[i].id==i)
    if(userList[i].dmodiDirty)
     {
      sprintf(file,"%s/userData/%d.usrmod",dataDir,i);
      fp = fopen(file,"w");
      if(verbose)
       printf("Write usermodification for %d/%s\n",i,uid2uname(i)); //                 was userList[i].name 
      for(j=0;j<userList[i].dmodiAnz; j++)
       if(userList[i].dmodi[j].did>=0)
	{
	 if(verbose)
	  printf("writing mod #%d of %s for date #%d\n",j,uid2uname(i),userList[i].dmodi[j].did); //                 was userList[i].name 
	 fwrite(&userList[i].dmodi[j],sizeof(UserDateModification),1,fp);
	}
       else
	{
	 if(verbose)
	  printf("skipping wiped out mod #%d of %s (date is %d)\n",j,uid2uname(i),userList[i].dmodi[j].did); //                 was userList[i].name 
	}
      userList[i].dmodiDirty =false;
      fclose(fp);
     }
  }
}
void writeAllDates()
{
 int i,j;
 char file[1024];
 FILE *fp;

 printf("WAD: dates\n");
 writeAllDates(true);
 printf("WAD: shifts\n");
 writeAllDateShifts(true);
 printf("WAD: umods\n");
 writeUserMods();
 printf("all dates written\n");
}
void writeAllDates( int backup)
{
 FILE *fp;
 char file[4096],file2[4100];
 int i,j,r,rtim;
 ReminderControl *rctrl[512];

 sprintf(file,"%s/dates",dataDir);
 if(backup)
  {
   sprintf(file2,"%s.bak",file);
   rename(file,file2);
   usleep(500);
  }
 fp=fopen(file,"w");
 if(fp==NULL)
  {
   printf("can't open %s\n",file);
   exit(-1);
  }
 fwrite(&dateFileHeader,sizeof(FileHeader),1,fp);
 for(i=0;i<dateAnz; i++)
  if(dateList[i]!=NULL)
   {
    if(! dateList[i]->deleted)
     {
      for(r=0;r<dateList[i]->remAnz ; r++)
       {
	rctrl[r]=dateList[i]->reminder[r].ct.ctrl;
	if (dateList[i]->reminder[r].ct.ctrl !=NULL)
	 {
	  rtim = dateList[i]->reminder[r].ct.ctrl->lastSendTim;
	  dateList[i]->reminder[r].ct.tim = rtim;
	 }
	else
	 printf("Reminder %d of Date %s/%s has now controll\n",r,dateList[i]->id,dateList[i]->descr);
       }
      dateList[i]->seekPtr=ftell(fp);
      fwrite(dateList[i],sizeof(Date),1,fp);
      for(r=0;r<dateList[i]->remAnz ; r++)
       {
	if (rctrl[r] !=NULL)
	 dateList[i]->reminder[r].ct.ctrl = rctrl[r];
       }
     }
    dateList[i]->dirty=false;
   }
 fclose(fp);
}
void writeAllDateShifts(int backup)
{
 FILE *fp;
 char file[4096],file2[4100];
 int i;

 sprintf(file,"%s/dates.shift",dataDir);
 if(backup)
  {
   sprintf(file2,"%s.bak",file);
   rename(file,file2);
   usleep(500);
  }
 fp=fopen(file,"w");
 if(fp==NULL)
  {
   printf("can't open %s\n",file);
   exit(-1);
  }
 fwrite(&dateShiftFileHeader,sizeof(FileHeader),1,fp);
 for(i=0;i<dateShiftAnz; i++)
  if(dateShiftList[i]!=NULL)
   if(dateShiftList[i]->valid)
    {
     dateShiftList[i]->seekPtr=ftell(fp);
     fwrite(dateShiftList[i],sizeof(DateShift),1,fp);
    }
 
 fclose(fp);
}

int convertDateFrom0400(Date *d, Date_0400 *dold);
int readDates_0400( FILE *fp,int size)
{
 Date_0400 dold;
 int i,did,maxDid=0;
 Date *d;

 printf("Importing Dates from Datefile version 0.4.0.0\n");

 dateAnz = (size/sizeof(Date_0400));
 printf("reading %d dates (from v0400)\n",dateAnz);
 if(dateAnz==0)
  return(0);
 
 while(dateAnz>dateMax)
  extendDateList();

 // d= new Date [dateAnz];
 for(i=0;i<dateAnz; i++)
  {
   fread(&dold,sizeof(Date_0400),1,fp);
   d = new Date;
   printf("\tconverting date #%6d   id=%6d\n",i,dold.id);
   convertDateFrom0400(d,&dold);
   printf("\t    '%s' @%d,%d rep=%d, shifts=%d\n",dold.descr,dold.startDate,dold.startTime,dold.repeatTyp,dold.dateShiftAnz);
   printf("\t => '%s' @%d,%d rep=%d, shifts=%d\n",d[i].descr,d[i].startDate,d[i].startTime,d[i].repeatTyp,d[i].dateShiftAnz);
   d->dirty=true;
   
   did = d[i].id;
   while(did>dateMax)
    extendDateList();
   if(did>maxDid)
    maxDid=did;
   dateList[did] = d; 
  }
 fclose(fp);
 dataImported=true;
 return(maxDid);
}
int convertUIDFrom0400(UserInDate *uid,UserInDate_0400 *old);
int convertReminderFrom0400(Reminder *rem, Reminder_0400 *old);
int convertDateFrom0400(Date *d, Date_0400 *dold)
{
 int i;
 char *t;
 
 d->dateBlockType = DATE_BLOCK_DATE;
 d->seekPtr=0;

 d->partAnz = dold->partAnz;
 d->remAnz  = dold->remAnz;
 convertUIDFrom0400(&d->init,&dold->init);
 for(i=0;i<dold->partAnz; i++)
  {
   if(i> PARTANZ_IN_DATE)
    {
     printf("Number of participant reduced. omitting additional entries in date '%s' @ %d\n",dold->descr,dold->startDate);
     break;
    }
   convertUIDFrom0400(&d->part[i],&dold->part[i]);
  }
 for(i=0;i<dold->remAnz; i++)
  {
   if(i> REMINDERS_IN_DATE)
    {
     printf("Number of reminder reduced. omitting additional entries in date '%s' @ %d\n",dold->descr,dold->startDate);
     break;
    }
   convertReminderFrom0400(&d->reminder[i],&dold->reminder[i]);
  }
  d->room            = dold->room;
  d->group           = dold->group;
  d->flags           = dold->flags;
  d->id              = dold->id;
  d->startDate       = dold->startDate;
  d->stopDate        = dold->stopDate;
  d->startTime       = dold->startTime;
  d->stopTime        = dold->stopTime;
  memcpy(d->descr,dold->descr,768);
  d->descr[767]      ='\0';
  writeComm(d->id,dold->comm);
  t = new char [strlen(dold->comm)+4];
  d->comm=t;
  strcpy(d->comm,dold->comm);
  d->dateShiftAnz    = dold->dateShiftAnz;
  d->dateShiftMax    = dold->dateShiftMax;
  d->dateShiftPtr    = dold->dateShiftPtr;
  d->tlen            = dold->tlen;
  d->repeatTyp       = dold->repeatTyp;
  d->repeatStopDate  = dold->repeatStopDate;
  d->repeatStopTime  = 0;
  d->priority        = dold->priority;
  d->repeatIntervall = dold->repeatIntervall;
  d->repeatUnit      = dold->repeatUnit;     
}
int convertUIDFrom0400(UserInDate *uid,UserInDate_0400 *old)
{
 uid->id     = old->id;
 uid->status = old->status;
 uid->typ    = old->typ;
 uid->flags  = old->flags;
 uid->perm   = old->perm;

}
int convertReminderFrom0400(Reminder *rem, Reminder_0400 *old)
{
 rem->id      = old->id;
 rem->offset  = old->offset;
 rem->offset2 = old->offset2;
 rem->unit    = old->unit;
 rem->ct.tim  = old->ct.tim;
 rem->typ     = old->typ; 
 rem->status  = old->status;
}

int readDates()
{
 FILE *fp;
 char file[4096];
 int i,anz,j,r;
 struct stat fstat;
 Date *d;
 int dateCount;
 FileHeader fh;
 char *buffer;
 int inputFormatVersion;

 // printf("//sizeof(Date_0400) =%d sizeof(Date)=%d\n",sizeof(Date_0400),sizeof(Date));

 sprintf(file,"%s/dates",dataDir);
 if((i=stat(file,&fstat))<0)
  {
   if(errno == ENOENT)
    {
     fp=fopen(file,"w");
     fclose(fp);
     if(stat(file,&fstat)<0)
      {
       printf("Can't open or create %s\n",file);
       exit(-1);
      }
    }
   else
    {
     char msg[1024];
     perror("");
     printf("Bad file  %s \n",file);
     exit(-1);
    }
  }
 if (fstat.st_size == 0)
  {
   projAnz =0;
   writeAllDates();
   return(true);
  }

 fp=fopen(file,"r");
 if(fp==NULL)
  {
   printf("can't open %s\n",file);
   exit(-1);
  }
 fread(&fh,sizeof(FileHeader),1,fp);
 // printf("raeadinf date  header\n");
 if(strncmp(fh.magic,FILEHEADER_MAGIC,8) !=0)
  {
   rewind(fp);
   //   printf("importing dates\n");
   //   d = readDates_0400(fp,fstat.st_size);
   maxDid = readDates_0400(fp,fstat.st_size);
   inputFormatVersion =400;
  }
 else
  {
   if(strncmp(fh.type,FILEHEADER_DATE,4) !=0)
    {
     printf("Datefile structure damaged\n");
     exit(-1);
    }
   if(fh.size>0)
    {
     buffer = new char [fh.size+2];
     fread(buffer,sizeof(char),fh.size,fp);
    }
   if(strncmp(fh.version,CURRENT_FILEVERSION_DATE,4) ==0)
    {
     inputFormatVersion =410;
     dateAnz = ((fstat.st_size-sizeof(FileHeader)-fh.size)/sizeof(Date));
     printf("reading %d dates (%d)\n",dateAnz,i);
     if(dateAnz==0)
      return(0);
 
     while(dateAnz>dateMax)
      extendDateList();

     maxDid=dateAnz;
     for(i=0;i<dateAnz; i++)
      {
       int did;
       d = new Date;
       fread(d,sizeof(Date),1,fp);
       did = d->id;
       while(did>dateMax)
	extendDateList();
       if(did>maxDid)
	maxDid=did;
       dateList[did] = d; 
       d->dirty =false;
      }
//      d= new Date [dateAnz];
//      fread(d,sizeof(Date),dateAnz,fp);
     fclose(fp);
    }
   else
    {
     printf("Datefile structure damaged (unkown file version (%c%c%c%c vs %s)\n",
	    fh.version[0],fh.version[1],fh.version[2],fh.version[3],CURRENT_FILEVERSION_DATE);
     exit(-1);
    }
  }

//  maxDid=dateAnz;
//  for(i=0;i<dateAnz; i++)
//   {
//    int did;
//    did = d[i].id;
//    if(did>dateMax)
//     extendDateList();
//    if(did>maxDid)
//      maxDid=did;
//    dateList[did] = d +i; 
//    d[i].dirty=false;
//   }
 dateCount=dateAnz;
 dateAnz =maxDid+1;

 // sortDateList(dateList,dateAnz);
 printf("\t\t\t\t %d date read\n",dateAnz);

#ifdef V0506
 for(i=0;i<dateAnz; i++)
  if(dateList[i] != NULL)
   {
    // Um alte Daten einzulesen
    if(dateList[i]->repeatTyp != NO_REPEAT)
     {
      if(dateList[i]->repeatStopDate<1900000 && dateList[i]->repeatStopDate  != 0)
       {
	printf("INFO: RepeatCount of %d ...",dateList[i]->repeatStopDate);
	if(inputFormatVersion==400)
	 dateList[i]->repeatStopDate = skip2Last(d+i);
	else
	 dateList[i]->repeatStopDate =0;
	printf("is converted to repeatStopDate %d\n",dateList[i]->repeatStopDate);
       }
     }
    
    for(j=0;j<dateList[i]->partAnz; j++)
     addDate2Calendar(dateList[i],dateList[i]->part[j].id);
    addDate2RoomCalendar(dateList[i],dateList[i]->room);
    
    for(r=0;r<REMINDERS_IN_DATE ; r++)
     {
      if(r<dateList[i]->remAnz)
       {
	int lst = dateList[i]->reminder[r].ct.tim;
	dateList[i]->reminder[r].ct.ctrl = new ReminderControl;
	dateList[i]->reminder[r].ct.ctrl->lastSendTim = lst;
       }
      else
       dateList[i]->reminder[r].ct.ctrl=NULL;
     }
    
    recalcReminder(dateList[i]);
    initDateShiftList(dateList[i]);
   }
#else
 for(i=0;i<dateCount; i++)
  {
   // Um alte Daten einzulesen
   if(d[i].repeatTyp != NO_REPEAT)
    {
     if(d[i].repeatStopDate<1900000 && d[i].repeatStopDate  != 0)
      {
       printf("INFO: RepeatCount of %d ...",d[i].repeatStopDate);
       if(inputFormatVersion==400)
	d[i].repeatStopDate = skip2Last(d+i);
       else
	d[i].repeatStopDate =0;
       printf("is converted to repeatStopDate %d\n",d[i].repeatStopDate);
      }
    }

   for(j=0;j<d[i].partAnz; j++)
    addDate2Calendar(d+i,d[i].part[j].id);
   addDate2RoomCalendar(d+i,d[i].room);
   
   for(r=0;r<REMINDERS_IN_DATE ; r++)
    {
     if(r<d[i].remAnz)
      {
       int lst = d[i].reminder[r].ct.tim;
       d[i].reminder[r].ct.ctrl = new ReminderControl;
       d[i].reminder[r].ct.ctrl->lastSendTim = lst;
      }
     else
      d[i].reminder[r].ct.ctrl=NULL;
    }
   
   recalcReminder(d+i);
   initDateShiftList(d+i);
  }
#endif
 printf("reading shifts\n");
 readDateShifts();

 for (i=0; i<=userAnz; i++)
  {
   if(userList[i].id==i)
    {
     sprintf(file,"%s/userData/%d.usrmod",dataDir,i);
     fp = fopen(file,"r");
     if(fp !=NULL)
      {
       if(stat(file,&fstat)==0)
	{
	 anz = (fstat.st_size/sizeof(UserDateModification));
	 while(anz > userList[i].dmodiMax)
	  extendDateUserModification(&userList[i]);
	 fread(userList[i].dmodi,sizeof(UserDateModification),anz,fp);
	 userList[i].dmodiAnz=anz;
	}
       else
	{
	 printf("error reading user modifications for user %d/%s\n",i,uid2uname(i)); //                 was userList[i].name 
	}
       fclose(fp);
      }
    }
  }
}

DateShift* readDateShifts_0400( FILE *fp,int size)
{
 DateShift_0400 dold;
 int i,j,k;
 DateShift *dsh;

 printf("Importing Dates Shifts from Datefile version 0.4.0.0 (%d/%d/%d)\n",size,sizeof(DateShift_0400),sizeof(DateShift));

 dateShiftAnz = (size/sizeof(DateShift_0400));
 printf("reading %d shifts \n",dateShiftAnz);
 if(dateShiftAnz==0)
  return(0);
 
 while(dateShiftAnz>dateShiftMax)
  extendDatShiftMasterList();
 
 dsh= new DateShift [dateShiftAnz];

 k=0;
 for(i=0;i<dateShiftAnz; i++)
  {
   fread(&dold,sizeof(DateShift_0400),1,fp);
   if(dold.did == 0)
    {
     printf("\tdeleting   dateShift #%6d   date-id=%6d. Shift seem to be invalid\n",i,dold.did);
     continue;
    }
   printf("\tconverting dateShift #%6d   date-id=%6d\n",i,dold.did);
   dsh[k].did = dold.did ;
   dsh[k].seekPtr = 0;
   dsh[k].refDate = dold.refDate ;
   dsh[k].refTime = dold.refTime ;
   dsh[k].deleted = dold.deleted ;
   dsh[k].room = dold.room ;
   dsh[k].startDate = dold.startDate ;
   dsh[k].startTime = dold.startTime ;
   dsh[k].stopDate = dold.stopDate ;
   dsh[k].stopTime = dold.stopTime ;
   memcpy(dsh[k].addDetails,dold.addDetails,100);
   dsh[k].addDetails[99]= '\0';
   for(j=0;j<dateList[dold.did]->partAnz; j++)
    {
     if(j> PARTANZ_IN_DATE)
      printf("Number of participant reduced. omitting additional entries in shift #%d from date '%s' (starting @ %d)\n",i,dateList[dold.did]->descr,dateList[dold.did]->startDate);
     dsh[k].partStatus[j] = dold.partStatus[j] ;
    }
   convertReminderFrom0400(&dsh[k].reminder,&dold.reminder);
   dsh[k].dirty=true;
   dsh[k].valid=true;
   k++;
  }
 fclose(fp);
 
 dataImported=true;
 dateShiftAnz=k;
 return(dsh);
}

int readDateShifts()
{
 FILE *fp;
 char file[4096];
 int i,anz,j;
 struct stat fstat;
 DateShift *dsh;
 Date *d;
 FileHeader fh;
 char *buffer;


 sprintf(file,"%s/dates.shift",dataDir);
 if((i=stat(file,&fstat))<0)
  {
   if(errno == ENOENT)
    {
     fp=fopen(file,"w");
     fclose(fp);
     if(stat(file,&fstat)<0)
      {
       printf("Can't open or create %s\n",file);
       exit(-1);
      }
    }
   else
    {
     char msg[1024];
     perror("");
     printf("Bad file  %s \n",file);
     exit(-1);
    }
  }

 fp=fopen(file,"r");
 if(fp==NULL)
  {
   printf("can't open %s\n",file);
   exit(-1);
  }
 
 fread(&fh,sizeof(FileHeader),1,fp);
 if(strncmp(fh.magic,FILEHEADER_MAGIC,8) !=0)
  {
   rewind(fp);
   dsh = readDateShifts_0400(fp,fstat.st_size);
  }
 else
  {
   if(strncmp(fh.type,FILEHEADER_SHIFT,4) !=0)
    {
     printf("DateShiftfile structure damaged\n");
     exit(-1);
    }
   if(fh.size>0)
    {
     buffer = new char [fh.size+2];
     fread(buffer,sizeof(char),fh.size,fp);
    }
   
   if(strncmp(fh.version,CURRENT_FILEVERSION_DATE,4) ==0)
    {
     dateShiftAnz = ((fstat.st_size- sizeof(FileHeader)-fh.size)/sizeof(DateShift));
     printf("reading %d shifts \n",dateShiftAnz);
     if(dateShiftAnz==0)
      return(0);
 
     while(dateShiftAnz>dateShiftMax)
      extendDatShiftMasterList();

     dsh= new DateShift [dateShiftAnz];
     fread(dsh,sizeof(DateShift),dateShiftAnz,fp);
     fclose(fp);
    }
   else
    {
     printf("DateShiftfile structure damaged (unkown file version (%c%c%c%c vs %s)\n",
	    fh.version[0],fh.version[1],fh.version[2],fh.version[3],CURRENT_FILEVERSION_SHIFT);
     exit(-1);
    }
  }

 for(i=0;i<dateShiftAnz; i++)
  {
   d =dateList[dsh[i].did];
   dsh[i].dirty=false;
   if(d !=NULL)
    {
     dateShiftList[i]=dsh+i;
     d->shifts[d->dateShiftAnz] = dsh+i;
     d->dateShiftAnz ++;
     if(d->dateShiftAnz >d->dateShiftMax)
      extendDateShiftList(d);
    }
   else
    printf("ignoring DateShift for non existing date %d\n",dsh->did);
  }

 for(i=0;i<dateAnz; i++)
  {
   d= dateList[i];
   if(d!=NULL)
    if(d->dateShiftAnz>0)
     
     qsort(d->shifts,d->dateShiftAnz,sizeof(DateShift *),compareDateShiftsByDate);
  }
}

void addDate2Calendar(Date*d, int id)
{
 if(id<ADDRESOFFSET)
  {
   if(id>=ROOMOFFSET)
    addDate2RoomCalendar(d,id-ROOMOFFSET);
   else if(id>=GROUPOFFSET)
    addDate2GroupCalendar(d,id-GROUPOFFSET);
   else 
    addDate2UserCalendar(d,id);
  }
}
int addDate2RoomCalendar(Date *d, int uid)
{
 if(uid >roomAnz)
  return(0);

 if(roomList[uid].id<0)
  return(0);
 
 roomList[uid].cal.list[ roomList[uid].cal.anz] = d;
 roomList[uid].cal.anz++;
 if(roomList[uid].cal.anz >=  roomList[uid].cal.max)
  extendCalList(&roomList[uid].cal);
}
int addDate2UserCalendar(Date *d, int uid)
{
 Date *t;
 int i;
 if(uid >userAnz)
  return(0);
 if(userList[uid].id<0)
  return(0);
 for(i=0;i<userList[uid].cal.anz; i++)
  if(userList[uid].cal.list[ i] == d)
   return(0);


 userList[uid].cal.list[ userList[uid].cal.anz] = d;
 userList[uid].cal.anz++;
 if(userList[uid].cal.anz >=  userList[uid].cal.max)
  extendCalList(&userList[uid].cal);
}
int addDate2GroupCalendar(Date *d, int gid)
{
 int i;
 if(gid >groupAnz)
  return(0);
 if(groupList[gid].id<0)
  return(0);

 for(i=0;i< groupList[gid].anz; i++)
  addDate2UserCalendar(d,groupList[gid].membr[i]);

 for(i=0;i<groupList[gid].cal.anz; i++)
  if(groupList[gid].cal.list[ i] == d)
   return(0);
//  printf("\t\t add to %d/%s\n",gid,gid2gname(gid)); //                 was groupList[gid].name 
 groupList[gid].cal.list[ groupList[gid].cal.anz] = d;
 groupList[gid].cal.anz++;
 if(groupList[gid].cal.anz >=  groupList[gid].cal.max)
  extendCalList(&groupList[gid].cal);
}

void sortDateList(Date **list,int anz)
{
 // qsort(list,anz,sizeof(Date *),compareDateByStartTime);
}

int compareDateByStartTime(const void * p1,const void *p2)
{
 Date *d1,*d2,**h1,**h2;

 h1= (Date **) p1;
 h2= (Date **) p2;
 d1= *h1;
 d2= *h2;
 
 if( d1->startDate < d2->startDate)
  return(-1);
 else if ( d1->startDate > d2->startDate)
  return(1);
 else
  {
   if( d1->startTime < d2->startTime)
    return(-1);
   else if ( d1->startTime > d2->startTime)
    return(1);
   else
    return(0);
  }
 return(0);
}

int suspendReminder(int socket,char *str)
{
 UserDateModification *umodi;
 int did,uid,stat;
 int anz;
 char *tp[64];
 
 
 anz = split(str,tp,64);

 did = atoi(tp[0]);
 if(dateList[did]==NULL)
  {
   send2Client(socket,"Error: no such date");
   return(-1);
  }

 uid = uname2uid(tp[1]);
 if(uid<0 || uid> userAnz)
  {
   send2Client(socket,"Error: no such user");
   return(-1);
  }
 stat =atoi(tp[2]);
 
 umodi=getUserModification4Date(did,uid);
 if(umodi==NULL)
  {
   umodi = &userList[uid].dmodi[userList[uid].dmodiAnz];
   userList[uid].dmodiAnz ++;
   if(userList[uid].dmodiAnz > userList[uid].dmodiMax)
    extendDateUserModification(&userList[uid]);
   initDateUserModification(umodi);
  }
 umodi->did = did;
 if(stat==1)
  umodi->noReminder = true;
 else
  umodi->noReminder = false;
 userList[uid].dmodiDirty=true;
 send2Client(socket,"done");
}
int ignoreDate(int socket,char *str)
{
 UserDateModification *umodi;
 int did,uid,stat;
 int anz;
 char *tp[64];
 
 
 anz = split(str,tp,64);

 did = atoi(tp[0]);
 if(dateList[did]==NULL)
  {
   send2Client(socket,"Error: no such date");
   return(-1);
  }

 uid = uname2uid(tp[1]);
 if(uid<0 || uid> userAnz)
  {
   send2Client(socket,"Error: no such user");
   return(-1);
  }
 stat =atoi(tp[2]);

 umodi=getUserModification4Date(did,uid);
 if(umodi==NULL)
  {
   umodi = &userList[uid].dmodi[userList[uid].dmodiAnz];
   userList[uid].dmodiAnz ++;
   if(userList[uid].dmodiAnz > userList[uid].dmodiMax)
    extendDateUserModification(&userList[uid]);
   initDateUserModification(umodi);
  }
 umodi->did = did;
 if(stat==1)
  umodi->ignored = true;
 else
  umodi->ignored = false;
 userList[uid].dmodiDirty=true;
 send2Client(socket,"done");
}

DateShift *getDateShift4Date(Date *d, int date, int stime,int create);
int compareDateShiftsByDate(const void *v1, const void * v2);

DateShift *getDateShift4Date(Date *d, int date, int stime,int create)
{
 int i;
 DateShift *dsh;

 minkoLog("getting dateShift for #%d of %d, %d (%s) (create=%d)\n",d->id,date,stime,d->descr,create);
 for(i=0;i< d->dateShiftAnz; i++)
  if(d->shifts[i]->refDate ==date)
   if(d->shifts[i]->refTime ==stime)
    return(d->shifts[i]);
 
 if(create)
  {
   minkoLog("createing dateShift for #%d of %d, %d (%s)\n",d->id,date,stime,d->descr);
   dsh = new DateShift;
   if(dsh==NULL)
    return(NULL);
   dsh->did  = d->id;
   dsh->deleted = false;
   dsh->refDate =dsh->startDate =dsh->stopDate =0;
   dsh->refTime =dsh->startTime =dsh->stopTime =0;
   dsh->room =-1;
   dsh->seekPtr =0;
   strcpy(dsh->addDetails,"");
   for(i=0;i< PARTANZ_IN_DATE;i++)
    dsh->partStatus[i]=0;

   d->shifts[d->dateShiftAnz] = dsh;
   d->dateShiftAnz ++;
   if (d->dateShiftAnz > d->dateShiftMax)
    extendDateShiftList(d);
   
   dateShiftList[dateShiftAnz]=dsh;
   dateShiftAnz++;
   if (dateShiftAnz > dateShiftMax)
    extendDatShiftMasterList();
   
   qsort(d->shifts,d->dateShiftAnz,sizeof(DateShift *),compareDateShiftsByDate);
  }
 else
  dsh =NULL;
 return(dsh);
}


void checkDateShiftsAndRecontruct()
{
 int id,i;
 Date *d;
 
 minkoLog("check DateShifts and reconstruction\n");

 for(i=0;i<dateShiftAnz; i++)
  if(dateShiftList[i]!=NULL)
   {
    id = dateShiftList[i]->did;
    if(id<0 || id>dateAnz)
     dateShiftList[i]->valid = false;
    else if(dateList[id] == NULL)
     dateShiftList[i]->valid = false;
    else if(dateShiftList[i]->refDate ==0 )
     dateShiftList[i]->valid = false;
   }
 for(i=0;i<dateAnz; i++)
  dateList[i]->dateShiftAnz=0;

 // Baue shift-Listen an den Date neu auf.
 for(i=0;i<dateShiftAnz; i++)
  if(dateShiftList[i]!=NULL)
   if(dateShiftList[i]->valid)
    {
     d =dateList[dateShiftList[i]->did];
     if(d !=NULL)
      {
       d->shifts[d->dateShiftAnz] = dateShiftList[i];
       d->dateShiftAnz ++;
       if(d->dateShiftAnz >d->dateShiftMax)
	extendDateShiftList(d);
      }
    }
}

int compareDateShiftsByDate(const void *v1, const void * v2)
{
 DateShift *dsh1,*dsh2;

 dsh1 = *((DateShift **) v1) ;
 dsh2 = *((DateShift **) v2) ;
 if( dsh1->startDate < dsh2->startDate)
  return(-1);
 else if ( dsh1->startDate > dsh2->startDate)
  return(1);
 else
  {
   if( dsh1->startTime < dsh2->startTime)
    return(-1);
   else if ( dsh1->startTime > dsh2->startTime)
    return(1);
   else
    return(0);
  }
 return(0);
}


// TCl Binding
// shiftDate did refDate refTime  startDate startTime stopdate stopTime room 'details'
//
int shiftDate(int socket, char * str)
{
 char *tp[64];
 int anz;
 int did,refDate,refTime;
 DateShift *dsh;
 Date *d;
 int notify=0;

 anz = split(str,tp,64);
 did = atoi(tp[0]);
 refDate = atoi(tp[1]);
 refTime = atoi(tp[2]);
 d = dateList[did];

 minkoLog("shift date #%d of %d, %d (%s)\n",did,refDate,refTime,d->descr);
 // Fixme intelligentes Modifiy
 dsh = getDateShift4Date(d,refDate,refTime,true);
 if(dsh == NULL)
  {
   send2Client(socket,"Error: No matching shift or can't create shift\n");
  }
 dsh->startDate = atoi(tp[3]);
 dsh->startTime = atoi(tp[4]);
 dsh->stopDate  = atoi(tp[5]);
 dsh->stopTime  = atoi(tp[6]);
 dsh->room = rname2rid(tp[7]);
 if(dsh->refDate ==0)
  {
   dsh->refDate   = refDate;
   dsh->refTime   = refTime;
  }
 strncpy(dsh->addDetails,tp[8],127);
 dsh->addDetails[127] = '\0';
 if(strcmp(dsh->addDetails,"___")==0)
  strcpy(dsh->addDetails,"");
 if(strcmp(tp[9],"__all") == 0)
  notify = REMIND_ALL_USER;
 else if(strcmp(tp[9],"__int") == 0)
  notify = REMIND_ALL_INTERN;
 else if(strcmp(tp[9],"__ext") == 0)
  notify = REMIND_ALL_EXTERN;
 else 
  notify=0;
 qsort(d->shifts,d->dateShiftAnz,sizeof(DateShift *),compareDateShiftsByDate);
 announceDateShift(dsh,NOTIFIER_DATE_IS_SHIFT);
 if(notify>0)
  {
   sendReminder4DateShift(dsh,dsh->startDate,dsh->startTime,notify);
  }
 dsh->valid=true;
 dsh->dirty=true;
 send2Client(socket,"done");
}

int getShiftDateInfo(int socket, char *str)
{
 char *tp[64], line[1024];
 int anz;
 int did,refDate,refTime;
 DateShift *dsh;
 Date *d;
 CalendarItem ci,wci;

 anz = split(str,tp,64);
 did = atoi(tp[0]);
 refDate = atoi(tp[1]);
 refTime = atoi(tp[2]);
 d = dateList[did];

 minkoLog("get shift date info #%d of %d, %d (%s)\n",did,refDate,refTime,d->descr);
 dsh =  getDateShift4Date(d,refDate,refTime,false);
 if( dsh == NULL)
  {
   initCalendarItem(d ,&ci);
   jump2NextDateAfter(&ci,&wci,d,refDate,refTime,true);
   if(ci.startDate!=refDate && ci.startTime != refTime)
    {
     send2Client(socket,"Err: No such Date");
     return(-1);
    }
   sprintf(line,"{%s} %d %d %d %d {%s} {}",d->descr,wci.startDate,wci.startTime,wci.stopDate,wci.stopTime,rid2rname(d->room)); //                 was roomList[d->room].name 
  }
 else
    sprintf(line,"{%s} %d %d %d %d {%s} {%s}",d->descr,dsh->startDate,dsh->startTime,dsh->stopDate,dsh->stopTime,rid2rname(dsh->room),dsh->addDetails); //                 was roomList[dsh->room].name 
 send2Client(socket,line);
}

//TCL-Binding
// changeStatus did refdate refTime uid status-code
int changeDateStatus4User(int socket, char * str)
{
 char *tp[64];
 int anz;
 int did,refDate,refTime,uid,i;
 DateShift *dsh;
 Date *d;
 char *ug;

 anz = split(str,tp,64);
 did = atoi(tp[0]);
 refDate = atoi(tp[1]);
 refTime = atoi(tp[2]);
 d = dateList[did];
 ug  = tp[5]; 

 minkoLog("change Date Users Stat for Date #%d of %d, %d (%s)\n",did,refDate,refTime,d->descr);
 if(d->repeatTyp == NO_REPEAT)
  {
   if(*ug == 'u')
    uid = uname2uid(tp[3]); 
   else if (*ug == 'g')
    uid = gname2gid(tp[3]); 
   else 
    uid =-1;
   for(i=0;i<d->partAnz; i++)
    if(d->part[i].id == uid)
     {
      d->part[i].status = atoi(tp[4]);
      break;
     }
  }
 else
  {
   uid = uname2uid(tp[3]); 
   dsh = getDateShift4Date(d,refDate,refTime,true);
   for(i=0;i<d->partAnz; i++)
    if(d->part[i].id == uid)
     {
      dsh->partStatus[i] = atoi(tp[4]);
      if(dsh->refDate ==0)
       {
	dsh->refDate =refDate;
	dsh->refTime =refTime;
       }
      break;
     }
   dsh->valid=true;
  }
 dsh->dirty=true;
 send2Client(socket,"done");
}

//TCL-Binding
// suspendDate did username refdate refTime 
int suspendDate(int socket, char * str)
{
 char *tp[64],txt[1024];
 int anz;
 int did,refDate,refTime,uid,i;
 DateShift *dsh;
 int notify=0;
 // Date *d;

 printf("SUSPEND: %s\n",str);
 anz = split(str,tp,64);
 did = atoi(tp[0]);
 uid = uname2uid(tp[1]);
 if(uid<0)
  {
   send2Client(socket,"ERR Permission denied");
   return(-1);
  }
 refDate = atoi(tp[2]);
 refTime = atoi(tp[3]);
 if(strcmp(tp[4],"__all") == 0)
  notify = REMIND_ALL_USER;
 else if(strcmp(tp[4],"__int") == 0)
  notify = REMIND_ALL_INTERN;
 else if(strcmp(tp[4],"__ext") == 0)
  notify = REMIND_ALL_EXTERN;
 else 
  notify=0;

 minkoLog("suspend date #%d of %d, %d (%s)\n",did,refDate,refTime,dateList[did]->descr);
 dsh = getDateShift4Date(dateList[did],refDate,refTime,true);
 dsh->deleted =true;
 dsh->refDate = refDate;
 dsh->refTime = refTime;
 if(dsh->startDate == 0)
  {
   dsh->startDate = refDate;
   dsh->startTime = refTime;
  }
 
 announceDateShift(dsh,NOTIFIER_DATE_IS_SUSP);
 if(notify>0)
  {
   if(dsh->startDate>0)
    sendReminder4DateShift(dsh,dsh->startDate,dsh->startTime,notify);  
   else
    sendReminder4DateShift(dsh,dsh->refDate,dsh->refTime,notify);  
  }
 dsh->valid=true;
 dsh->dirty=true;
 send2Client(socket,"done");
}



int getBlockedTimes(int socket,char *str)
{
 char *tp[8],*tp2[1024];
 int id;
 Calendar *cal;
 char buffer[16384];
 int startDay,stopDay;
 int i,anz,n,m;
 int ignoreDid;
 
 split(str,tp,8);

 ignoreDid= atoi(tp[0]);
 startDay = atoi(tp[1]);
 stopDay  = atoi(tp[2]);
 strcpy(buffer,"");

 anz = split(tp[3],tp2,1023);
 for(n=0 ; n<anz ; n+=2)
  {
   m=n+1;
   if ( tp2[n][0] == 'g')
    {
     id=gname2gid(tp2[m]);
     if(id<0)
      {
       printf("getBlockedTimes: group '%s' unknown\n",tp2[m]);
       continue;
      }
     else
      cal    = & userList[id].cal;
    }
   else if( tp2[n][0] == 'r')
    {
     id=rname2rid(tp2[m]);
     if(id<0)
      {
       printf("getBlockedTimes: room '%s' unknown\n",tp2[m]);
       continue;
      }
     else
      cal    = & roomList[id].cal;
    }
   else if ( tp2[n][0] == 'a')
    continue;
   else 
    {
     id=uname2uid(tp2[m]);
     if(id<0)
      {
       printf("getBlockedTimes: user '%s' unknown\n",tp2[m]);
       continue;
      }
     else
      cal= & userList[id].cal;
    }
   strcat(buffer,"{ ");
   getBlockedTimes4User(startDay,stopDay,cal,buffer,ignoreDid);
   strcat(buffer," } ");
  }
 send2Client(socket,buffer);
}



int getBlockedTimes4User(int startDay,int stopDay,Calendar *cal, char *buffer,int ignoreDid)
{
 int i,start,stop,tstop,tstart;
 char tx[1024];
 CalendarItem ci,wci;

 for(i=0;i<cal->anz ; i++)
  {
   if( cal->list[i]->id != ignoreDid )
    if( ! cal->list[i]->deleted )
     if( (cal->list[i]->flags & DATE_FLAG_NOTIME) == 0)
      if( (cal->list[i]->flags & DATE_FLAG_NONBLOCK) == 0)
       {
	ci.startDate=cal->list[i]->startDate;
	ci.startTime=cal->list[i]->startTime;
	ci.stopDate =cal->list[i]->stopDate;
	ci.stopTime =cal->list[i]->stopTime;
	ci.count=0;
	ci.startwDay=weekDayByDate(ci.startDate);
	cal->list[i]->dateShiftPtr =0;
	memcpy(&wci,&ci,sizeof(CalendarItem));
	jump2NextDateAfter(&ci,&wci,cal->list[i],startDay);
	start =wci.startDate;
	stop  =wci.stopDate;
	
	while( start<= stopDay && stop>=startDay)
	 {
	  if(start<startDay)
	   {
	    start=startDay;
	    tstart=0;
	   }
	  else
	   tstart = cal->list[i]->startTime;
	  if(stop>stopDay)
	   {
	    stop=stopDay;
	    tstop=24;
	   }
	  else
	   tstop = cal->list[i]->stopTime;
	  
	  sprintf(tx,"{%d %d %d %d} ",start,tstart,stop,tstop);
	  strcat(buffer,tx);
	  
	  if(!skip2NextDateAfter(&ci,&wci,cal->list[i]))
	   break;
	  start =wci.startDate;
	  stop  =wci.stopDate;	 
	 }
       }
  }
}

void getUserCal(char *str,int socket)
{
 int uid,start,stop,igno,cid,wuc,ignoInfo;
 char *tp[8],*list[256],*nam;
 int anz,i,stamp;
 char buffer[250000],tx[1024];

 split(str,tp,8);
  uid = uname2uid(tp[0]);
 start = atoi(tp[2]);
 stop  = atoi(tp[3]);
 igno  = atoi(tp[4]);
 ignoInfo =atoi(tp[5]);
 

 if(uid<0)
  send2Client(socket,"ERR: user unknown");
 else 
  { 
   clearUserSelection();
   clearGroupSelection();
   stamp=time(NULL);
   strcpy(buffer,"");
   strTrim(tp[1]);
   anz = split (tp[1],list,256);

   for (i=0;i<anz; i++)
    {
     nam = list[i]+2;
     if(list[i][0] == 'u')
      {
       cid = uname2uid(trimRight(nam));
       userList[cid].selected =true;
      }
     else if (list[i][0] == 'g')
      {
       cid = gname2gid(trimRight(nam));
       groupList[cid].selected =true;
      }
    }

   for (i=0;i<anz; i++)
    {
     nam = list[i]+2;
     if(list[i][0] == 'r')
      {
       if(i==0)
	{
	 cid = rname2rid(trimRight(nam));
	 getRoomCal(buffer,uid,cid,start,stop,igno,ignoInfo);
	 break;
	}
       else
	continue;
      }
     else if (list[i][0] == 'g')
      {
       cid = uname2uid(trimRight(nam));
       if(cid>=0)
	addCal2Buffer(buffer,&groupList[cid].cal,uid,cid,start,stop,igno,ignoInfo,stamp);
      }
     else if (list[i][0] == 'u')
      {
       cid = uname2uid(trimRight(nam));
       if(cid>=0)
	addCal2Buffer(buffer,&userList[cid].cal,uid,cid,start,stop,igno,ignoInfo,stamp);
      }
    }
    send2Client(socket,buffer);
  }
}

UserInDate * findUserInDate(Date *d,int uid)
{
 int i;
 for(i=0;i<d->partAnz; i++)
  {
   if(d->part[i].id==uid)
    return(&d->part[i]);
  }
 return(NULL);
}

// Referenzdatum steht in wci, das das alte Dateum enthlt
int skip2NextDateAfter(CalendarItem *ci,CalendarItem *wci,Date *d)
{
 DateShift **dsh;
 dsh = d->shifts;

 if(d->repeatTyp == NO_REPEAT)
  return(false);

 if(d->dateShiftAnz==0)
  {
   skip2next(ci,d);
   memcpy(wci,ci,sizeof(CalendarItem));
   wci->type=DATE_NORMAL;
  }
 else
  {
   if(wci->type == DATE_SHIFTED)
    do
     {
      ci->dshStartPtr++;
      if(ci->dshStartPtr>= d->dateShiftAnz)
       break;
     }while(dsh[ci->dshStartPtr]->deleted);
   else
    {
     do
      {
       skip2next(ci,d);
      }while(dateIsDeletedOrShifted(ci,d));
    }

   if ( ci->dshStartPtr >= d-> dateShiftAnz)
    {
     memcpy(wci,ci,sizeof(CalendarItem));
     wci->type=DATE_NORMAL;
    }
   else if(ci->startDate > dsh[ci->dshStartPtr]->startDate || 
      (ci->startDate == dsh[ci->dshStartPtr]->startDate && ci->startTime > dsh[ci->dshStartPtr]->startTime))
    {
     wci->startDate = dsh[ci->dshStartPtr]->startDate;
     wci->startTime = dsh[ci->dshStartPtr]->startTime;
     wci->stopDate = dsh[ci->dshStartPtr]->stopDate;
     wci->stopTime = dsh[ci->dshStartPtr]->stopTime;
     wci->dshStartPtr = ci->dshStartPtr;
     wci->type=DATE_SHIFTED;
    }
   else
    {
     memcpy(wci,ci,sizeof(CalendarItem));
     wci->type=DATE_NORMAL;
    }
  }
 if(d->repeatStopDate==0)
  return(true);
 if(wci->startDate > d->repeatStopDate)
  return(false);
 return(true);
}

int jump2NextDateAfter(CalendarItem *ci,CalendarItem *wci,Date *d,int refDate)
{
 return(jump2NextDateAfter(ci,wci,d,refDate,0,true));
}
int jump2NextDateAfter(CalendarItem *ci,CalendarItem *wci,Date *d,int refDate,int refTime)
{
 return(jump2NextDateAfter(ci,wci,d,refDate,refTime,true));
}
int jump2NextDateAfter(CalendarItem *ci,CalendarItem *wci,Date *d,int refDate,int refTime,int withShift)
{
 char otyp[8]="hdwmy";
 int dd,dm;
 int startDate;

 if(d->repeatTyp == NO_REPEAT)
  return(false);
 if(d->repeatStopDate<refDate && d->repeatStopDate >0 )
  return(false);


 if(d->startDate > refDate)
  startDate = d->startDate;
 else
  startDate =refDate;
 
 
 ci->startDate = d->startDate;
 ci->startTime = d->startTime;
 ci->stopDate  = d->stopDate;
 ci->stopTime  = d->stopTime;
 switch(d->repeatTyp)
  {
  case REPEAT_TAGL:
   ci->startDate = startDate; 
   ci->stopDate  = stopDate4StartDate(startDate,d);
   ci->startwDay = weekDayByDate(ci->startDate);
   while((d->repeatUnit & weekDayMask[ci->startwDay]) > 0)
    {
     calcDate(&ci->startDate,&ci->startTime,1,0,'d');
     calcDate(&ci->stopDate ,&ci->stopTime ,1,0,'d');
     ci->startwDay ++;
     if(ci->startwDay>6)
      ci->startwDay-=7;
    }
   break;
  case REPEAT_WTAGL:
   ci->startDate = startDate; 
   ci->stopDate  = stopDate4StartDate(startDate,d);
   ci->startwDay = weekDayByDate(ci->startDate);
   while(ci->startwDay>4)
    {
     calcDate(&ci->startDate,&ci->startTime,1,0,'d');
     calcDate(&ci->stopDate ,&ci->stopTime ,1,0,'d');
     ci->startwDay ++;
     if(ci->startwDay>6)
      ci->startwDay-=7;
    }
   break;
  case REPEAT_WOCHE:
   dd = diffDates(d->startDate,startDate);
   dd += (7- (dd % 7)) % 7 ;
   calcDate(&ci->startDate,&ci->startTime,dd,0,'d');
   calcDate(&ci->stopDate ,&ci->stopTime ,dd,0,'d');
   break;
  case REPEAT_MONAT:
   dm = diffMonth(d->startDate,startDate);
   calcDate(&ci->startDate,&ci->startTime,dm,0,'M');
   calcDate(&ci->stopDate ,&ci->stopTime ,dm,0,'M');
   break;
  case REPEAT_ALLE:
   //FIXME schneller
   while(ci->startDate<refDate || (ci->startDate==refDate && ci->startTime==refTime) )
    {
     calcDate(&ci->startDate,&ci->startTime,d->repeatIntervall,0,otyp[d->repeatUnit]);
     calcDate(&ci->stopDate, &ci->stopTime, d->repeatIntervall,0,otyp[d->repeatUnit]);
    }
   break;
  case REPEAT_JEDEN: 
   {
    int wc,rwd,wd,dc;
    
    getWeekDayInMonth(&wc,&rwd,ci->startDate);
    ci->startDate=beginningOfMonth(ci->startDate);
    dm = diffMonth(ci->startDate,startDate);             // WieveielMOnate sind seit dem vergangen?
    int sd = ci->startDate;
    calcDate(&ci->startDate,&ci->startTime,dm,0,'M');
    if(ci->startDate <d->startDate)
     {
      printf("illegal date cal;clualtion : %d + %d M -> %d\n",sd,dm,ci->startDate);
      return(false);
     }
    while(true)
     {
      ci->startwDay = weekDayByDate(ci->startDate);
      dc=0;
      while(ci->startwDay  != rwd)
       {
	dc++;
	ci->startwDay ++;
	if(ci->startwDay>6)
	 ci->startwDay-=7;
       }
      dc += wc*7;
      calcDate(&ci->startDate,&ci->startTime,dc,0,'d');
      if(ci->startDate < refDate)
       ci->startDate=beginningOfNextMonth(ci->startDate);
      else 
       break;
     }
    ci->stopDate  = stopDate4StartDate(ci->startDate,d);
    break;
   }
  }


 // Wenn es keine Shifts gibt sind wir hier fertig
 if(d->dateShiftAnz==0 || !withShift)
  {
   ci->dshStartPtr=0;
   ci->dshRefPtr=0;
   memcpy(wci,ci,sizeof(CalendarItem));
   wci->type=DATE_NORMAL;
   return(true);
  }


 DateShift **dsh;
 ci->dshStartPtr=0;
 ci->dshRefPtr=0;
 dsh = d->shifts;

 // Wenn der eben berechnete Termin geshifted ist, springe zum nchsten
 while(dateIsDeletedOrShifted(ci,d))
  {
   skip2next(ci,d);
  }

 // Suche den ersten ShiftTermin nach dem refDate
 // while(dsh[ci->dshStartPtr]->startDate<refDate && dsh[ci->dshStartPtr]->startTime<refTime)
 if(ci->dshStartPtr < d->dateShiftAnz)
  while(dsh[ci->dshStartPtr]->startDate < refDate ||
	(dsh[ci->dshStartPtr]->startDate == refDate && dsh[ci->dshStartPtr]->startTime<refTime))
   {
    ci->dshStartPtr++;
    if(ci->dshStartPtr >= d->dateShiftAnz)
     break;
   }
 // berspule nun noch die gelschten Instanzen
 if(ci->dshStartPtr<d->dateShiftAnz)
  while(dsh[ci->dshStartPtr]->deleted)
   {
    ci->dshStartPtr++;
    if(ci->dshStartPtr >= d->dateShiftAnz)
     break;   
   }
 //Bestimme die ob der regulre oder der geshiftetd Termin frher ist
 if ( ci->dshStartPtr >= d-> dateShiftAnz)
  {
   memcpy(wci,ci,sizeof(CalendarItem));
   wci->type=DATE_NORMAL;
  }
 else if(ci->startDate > dsh[ci->dshStartPtr]->startDate || 
    (ci->startDate == dsh[ci->dshStartPtr]->startDate && ci->startTime > dsh[ci->dshStartPtr]->startTime))
  {
   wci->startDate = dsh[ci->dshStartPtr]->startDate;
   wci->startTime = dsh[ci->dshStartPtr]->startTime;
   wci->stopDate = dsh[ci->dshStartPtr]->stopDate;
   wci->stopTime = dsh[ci->dshStartPtr]->stopTime;
   wci->dshStartPtr = ci->dshStartPtr;
   wci->type=DATE_SHIFTED;
  }
 else
  {
   memcpy(wci,ci,sizeof(CalendarItem));
   wci->type=DATE_NORMAL;
  }
 if(wci->startDate > d->repeatStopDate)
  return(false);
 return(true);
}
int dateIsDeletedOrShifted(CalendarItem *ci, Date *d)
{
 DateShift **dsh;

 if(d->dateShiftAnz==0)
  return(false);

 dsh = d->shifts;

 if(ci->dshRefPtr < d->dateShiftAnz)
  while( dsh[ci->dshRefPtr]->refDate<ci->startDate ||
	  (dsh[ci->dshRefPtr]->refDate<ci->startDate &&
	   dsh[ci->dshRefPtr]->refTime<ci->startTime ) )
   {
    ci->dshRefPtr++;
    if (ci->dshRefPtr >= d->dateShiftAnz )
     break;
   }
   
 if(ci->dshRefPtr < d->dateShiftAnz)
  if(dsh[ci->dshRefPtr]->refDate == ci->startDate && dsh[ci->dshRefPtr]->refTime<=ci->startTime)
   return(true);

 return(false);
}

int beginningOfMonth(int date)
{
 int d,m,y;
 d = (date %100);
 m = (date-d) /100;
 y = (date-d-m*100) /10000;
 return(10000*y+m*100+1);
}
int beginningOfNextMonth(int date)
{
 int d,m,y;
 d = (date %100);
 m = ((date-d) /100)%100;
 y = (date-d-m*100) /10000;
 if( m==12)
  {
   return(10000*y+m*100+8901);
  }
 return(10000*y+m*100+101);
}
int stopDate4StartDate(int startDate,Date *d)
{
 int stopDate=startDate;
 int stopTime=1200;
 int dd = diffDates(d->startDate,d->stopDate);
 
 calcDate(&stopDate,&stopTime,dd,0,'d');
 return(stopDate);
}
int diffDates(int date1, int date2)
{
 int d1,d2,m1,m2,y1,y2;
 int dd,m,y;
 int monLen[13]={0,31,28,31,30,31,30,31,31,30,31,30,31};    

 d1 = (date1 %100);
 m1 = ((date1-d1) /100 ) %100;
 y1 = (date1-d1-m1*100) /10000;
 d2 = (date2 %100);
 m2 = ((date2-d2) /100) %100;
 y2 = (date2-d2-m2*100) /10000;

 if(m1==m2 && y1 == y2)
  dd=d2-d1;
 else
  {
   dd = monLen[m1] - d1;
   m=m1+1;
   y=y1;
   if(m>12)
    {
     m=1; 
     y++;
    }
   //FIXME Tablle optimieren
   while(m<m2 || y<y2)
    {
     dd += monLen[m];
     if(m==2)
      if((y%4)==0)
       dd++;
     m++;
     if(m>12)
      {
       m=1;
       y++;
      }
    }
   dd+= d2;
  }
 return(dd);
}
int diffMonth(int date1, int date2)
{
 int d1,d2,m1,m2,y1,y2;
 int dm=0,m,y;
  

 d1 = (date1 %100);
 m1 = ((date1-d1) /100 ) %100;
 y1 = (date1-d1-m1*100) /10000;
 d2 = (date2 %100);
 m2 = ((date2-d2) /100) %100;
 y2 = (date2-d2-m2*100) /10000;
 
 if(y2 == y1)
  dm = m2-m1;
 else
  {
   dm=0;
   m=m1;
   y=y1;
   while(m<m2 || y < y2)
    {
     m++;
     if(m>12)
      {
       m=1;
       y++;
      }
     dm++;
    }
  }
 return(dm);
}


int nextDateAfterNow(CalendarItem *ci,Date *d)
{
 char tstr[64],*t;
 int heute,jetzt;
 CalendarItem wci;
 int ret;

 time_t tim=time(NULL);
 strftime(tstr,255,"%Y%m%d %H%M",localtime(&tim));0;   
 t=strchr(tstr+4,' ');
 if(t!=NULL)
  *t='\0';
 heute = atoi(tstr);
 jetzt = atoi(t+1);
 ret = nextDateAfterDate(ci,&wci,d,heute,jetzt);
 memcpy(ci,&wci,sizeof(CalendarItem));
 return( ret);
}
int nextDateAfterDate (CalendarItem *ci,CalendarItem *wci,Date *d, int datum, int tim)
{
 char tstr[64],*t;

 if(! jump2NextDateAfter(ci,wci,d,datum,tim))
  return(false);
 while(wci->startDate<datum || ( wci->startDate==datum && wci->startTime < tim) )
  if( ! skip2NextDateAfter(ci,wci,d))
   return(false);
 return(true);
}
int skip2Last(Date *d)
{
 CalendarItem ci;
 if(d->repeatStopDate==0)
  return(0);
 ci.startDate=d->startDate;
 ci.startTime=d->startTime;
 ci.stopDate =d->stopDate;
 ci.stopTime =d->stopTime;
 ci.count=0;
 ci.startwDay = weekDayByDate(ci.startDate);
 for(;;)
  if( ! skip2nextOLD(&ci,d))
   break;
 return( ci.startDate);
}



int skip2nextOLD(CalendarItem *ci,Date *d)
{
 char otyp[8]="hdwmy";
 char wds[8][8]={"Mo","Di","Mi","Do","Fr","Sa","So"};
 int wc,wd;

 ci->count++;
 if(ci->count >  d->repeatStopDate && d->repeatStopDate >0)
  return(false);

 if(ci->startDate <0  || ci->stopDate<0 || (ci->startDate % 10000 > 1231) || (ci->stopDate % 10000 > 1231) )
  {
   printf("Strange Date(s) : %d %d; skipping repaet \n", ci->startDate,ci->stopDate);
   return(false);
  }

 switch(d->repeatTyp)
  {
  case NO_REPEAT:
   return(false);
   break;
  case REPEAT_TAGL:
   calcDate(&ci->startDate,&ci->startTime,1,0,'d');
   calcDate(&ci->stopDate ,&ci->stopTime ,1,0,'d');
   while((d->repeatUnit & weekDayMask[ci->startwDay]) > 0)
    {
     calcDate(&ci->startDate,&ci->startTime,1,0,'d');
     calcDate(&ci->stopDate ,&ci->stopTime ,1,0,'d');
     ci->startwDay ++;
     if(ci->startwDay>6)
      ci->startwDay-=7;
    }
   break;
  case REPEAT_WTAGL:
   do
    {
     calcDate(&ci->startDate,&ci->startTime,1,0,'d');
     calcDate(&ci->stopDate ,&ci->stopTime ,1,0,'d');
     ci->startwDay ++;
     if(ci->startwDay>6)
      ci->startwDay-=7;
    }while(ci->startwDay>4);
   break;
  case REPEAT_WOCHE:
   calcDate(&ci->startDate,&ci->startTime,1,0,'w');
   calcDate(&ci->stopDate ,&ci->stopTime ,1,0,'w');
   break;
  case REPEAT_MONAT:
   calcDate(&ci->startDate,&ci->startTime,1,0,'M');
   calcDate(&ci->stopDate ,&ci->stopTime ,1,0,'M');
   break;
  case REPEAT_ALLE:
   calcDate(&ci->startDate,&ci->startTime,d->repeatIntervall,0,otyp[d->repeatUnit]);
   calcDate(&ci->stopDate, &ci->stopTime, d->repeatIntervall,0,otyp[d->repeatUnit]);
   break;
  case REPEAT_JEDEN: 
   getWeekDayInMonth(&wc,&wd,ci->startDate);
   calcDate(&ci->startDate,&ci->startTime,1,0,'M');
   ci->startDate = getCountedWeekDayDatum(wc,wd,ci->startDate);
   

   getWeekDayInMonth(&wc,&wd,ci->stopDate);
   calcDate(&ci->stopDate ,&ci->stopTime ,1,0,'M');
   ci->stopDate = getCountedWeekDayDatum(wc,wd,ci->stopDate);
   break;
  }
 return(true);
}


int skip2next(CalendarItem *ci,Date *d)
{
 char otyp[8]="hdwmy";
 char wds[8][8]={"Mo","Di","Mi","Do","Fr","Sa","So"};
 int wc,wd;


 if(ci->startDate <0  || ci->stopDate<0 || (ci->startDate % 10000 > 1231) || (ci->stopDate % 10000 > 1231) )
  {
   printf("Strange Date(s) : %d %d; skipping repaet \n", ci->startDate,ci->stopDate);
   return(false);
   
  }

 switch(d->repeatTyp)
  {
  case NO_REPEAT:
   return(false);
   break;
  case REPEAT_TAGL:
   calcDate(&ci->startDate,&ci->startTime,1,0,'d');
   calcDate(&ci->stopDate ,&ci->stopTime ,1,0,'d');
   ci->startwDay ++;
   while((d->repeatUnit & weekDayMask[ci->startwDay]) > 0)
    {
     calcDate(&ci->startDate,&ci->startTime,1,0,'d');
     calcDate(&ci->stopDate ,&ci->stopTime ,1,0,'d');
     ci->startwDay ++;
     if(ci->startwDay>6)
      ci->startwDay-=7;
    }
   break;
  case REPEAT_WTAGL:
   do
    {
     calcDate(&ci->startDate,&ci->startTime,1,0,'d');
     calcDate(&ci->stopDate ,&ci->stopTime ,1,0,'d');
     ci->startwDay ++;
     if(ci->startwDay>6)
      ci->startwDay-=7;
    }while(ci->startwDay>4);
   break;
  case REPEAT_WOCHE:
   calcDate(&ci->startDate,&ci->startTime,1,0,'w');
   calcDate(&ci->stopDate ,&ci->stopTime ,1,0,'w');
   break;
  case REPEAT_MONAT:
   calcDate(&ci->startDate,&ci->startTime,1,0,'M');
   calcDate(&ci->stopDate ,&ci->stopTime ,1,0,'M');
   break;
  case REPEAT_ALLE:
   calcDate(&ci->startDate,&ci->startTime,d->repeatIntervall,0,otyp[d->repeatUnit]);
   calcDate(&ci->stopDate, &ci->stopTime, d->repeatIntervall,0,otyp[d->repeatUnit]);
   break;
  case REPEAT_JEDEN: 
   getWeekDayInMonth(&wc,&wd,ci->startDate);
   calcDate(&ci->startDate,&ci->startTime,1,0,'M');
   ci->startDate = getCountedWeekDayDatum(wc,wd,ci->startDate);
//    printf("old date was %d. %s new is %d\n",wc+1,wds[wd],ci->startDate);
   

   getWeekDayInMonth(&wc,&wd,ci->stopDate);
   calcDate(&ci->stopDate ,&ci->stopTime ,1,0,'M');
   ci->stopDate = getCountedWeekDayDatum(wc,wd,ci->stopDate);
   break;
  }
 return(true);
}

CalendarItem *shiftDateIfNeeded(CalendarItem *ici,CalendarItem *oci,Date *d)
{
 DateShift *dsh;

 if(d->dateShiftPtr < d->dateShiftAnz)
  {
   dsh = d->shifts[d->dateShiftPtr];
   if(ici->startDate == dsh->refDate && ici->startTime == dsh->refTime)
    {
     if(dsh->deleted)
      return(NULL);
     oci->startDate = dsh->startDate;
     oci->startTime = dsh->startTime;
     oci->stopDate = dsh->stopDate;
     oci->stopTime = dsh->stopTime;
     d->dateShiftPtr++;
    }
   else
    memcpy(oci,ici,sizeof(CalendarItem));
  }
 else
  memcpy(oci,ici,sizeof(CalendarItem));
 return(oci);
}




void initCalendarItem(Date *d ,CalendarItem *ci)
{
 ci->startDate=d->startDate;
 ci->startTime=d->startTime;
 ci->stopDate =d->stopDate;
 ci->stopTime =d->stopTime;
 ci->count=0;
 ci->startwDay=weekDayByDate(ci->startDate);
 d->dateShiftPtr =0;
}


void addCal2Buffer(char *buffer, Calendar *cal, int uid,int cid,int startDay, int stopDay,int igno,int ignoInfo,int stamp)
{
 char tx[1024];
 int start,stop;
 int tstart,tstop;
 int notime;
 int i,status,perm;
 int privatDateIsClosed2Me;
 UserInDate *self;
 CalendarItem ci,wci;
 char plist[4096];
 int adminToUser;
 int j;
 int dateAsInfo=0;

 for(i=0;i<cal->anz ; i++)
  if( ! cal->list[i]->deleted )
   if (cal->list[i]->internalStatus !=stamp)
    { //stamp
     dateAsInfo = dateOnlyAsInfo(cal->list[i],uid);
     if(dateAsInfo)
      printf("date '%s' only as info for %d\n",cal->list[i]->descr,uid);
     if(ignoInfo == 1)
      if(dateAsInfo)
       {
	printf("date is ignored for %d (%d) %d\n",uid,ignoInfo,dateAsInfo);
	continue;
       }
     
     privatDateIsClosed2Me = dateIs2Privat2Me(cal->list[i],uid);
     adminToUser = admin2User(cid,uid);
     perm = getPermission(cal->list[i],uid,cid);
     if( !dateIsIgnoredByMe(cal->list[i]->id,uid) || igno == 1)
      if( (perm & READ_TIMES) == READ_TIMES )
       if(!privatDateIsClosed2Me || adminToUser)
	{
	 ci.startDate=cal->list[i]->startDate;
	 ci.startTime=cal->list[i]->startTime;
	 ci.stopDate =cal->list[i]->stopDate;
	 ci.stopTime =cal->list[i]->stopTime;
	 ci.count=0;
	 ci.startwDay=weekDayByDate(ci.startDate);
	 cal->list[i]->dateShiftPtr =0;
	 memcpy(&wci,&ci,sizeof(CalendarItem));
	 jump2NextDateAfter(&ci,&wci,cal->list[i],startDay);
	 start =wci.startDate;
	 stop  =wci.stopDate;
	 while( start<= stopDay && stop>=startDay)
	  {
	   if(start<startDay)
	    {
	     start=startDay;
	     tstart=0;
	    }
	   else
	    tstart = wci.startTime;
	   if(stop>stopDay)
	    {
	     stop=stopDay;
	     tstop=2359;
	    }
	   else
	    tstop = wci.stopTime;
	   
	   notime = (cal->list[i]->flags & DATE_FLAG_NOTIME) >> DATE_FLAG_NOTIME_SHIFT;
	   if(privatDateIsClosed2Me)
	    {
	     sprintf(tx,"{%d %d %d %d %d {%s} %d %d %d {%s} 1 %d} ",
		     start,tstart,stop,tstop,notime,"",cal->list[i]->id,
		     NO_REPEAT,3,addPartList(cal->list[i],plist),dateAsInfo);
	    }
	   else
	    {
	     if( (perm & READ_HEADS) == READ_HEADS )
	      sprintf(tx,"{%d %d %d %d %d {%s} %d %d %d {%s} %d %d} ",
		      start,tstart,stop,tstop,notime,cal->list[i]->descr,cal->list[i]->id,
		      cal->list[i]->repeatTyp,cal->list[i]->priority,addPartList(cal->list[i],plist),
		      cal->list[i]->flags&DATE_FLAG_PRIVAT,dateAsInfo);
	     else
	      sprintf(tx,"{%d %d %d %d %d {%s} %d %d %d {%s} %d %d} ",
		      start,tstart,stop,tstop,notime," ",cal->list[i]->id,
		      cal->list[i]->repeatTyp,cal->list[i]->priority,addPartList(cal->list[i],plist),
		      cal->list[i]->flags&DATE_FLAG_PRIVAT,dateAsInfo);
	    }
	   strcat(buffer,tx);
	   if(!skip2NextDateAfter(&ci,&wci,cal->list[i]))
	    break;	   
	   start =wci.startDate;
	   stop  =wci.stopDate;
	  }
	}
     cal->list[i]->internalStatus =stamp;
    }
}

char *  addPartList(Date *d,char *partList)
{
 int i,j,id;
 static int *userSelected=NULL;
 static int userSelectedAnz=0;
 int alreadySelected;

 if(userSelected == NULL)
  {
   userSelected = new int [userAnz];
   userSelectedAnz = userAnz;
  }
 if(userAnz > userSelectedAnz)
  {
   delete userSelected;
   userSelected = new int [userAnz];
   userSelectedAnz = userAnz;
  }
 for(i=0;i<userAnz; i++)
  userSelected[i]=false;

 partList[0]='\0';
 for (i=0;i<d->partAnz; i++)
  if(d->part[i].id <GROUPOFFSET)
   {
    id = d->part[i].id;
    if(!userSelected[id])
     {
      strcat(partList," u-");
      strcat(partList,uid2uname(id)); //                 was userList[id].name 
      userSelected[id] =true;
     }
   }


 for (i=0;i<d->partAnz; i++)
  if(d->part[i].id >= GROUPOFFSET)
   if (d->part[i].id <ROOMOFFSET)
    {
     id = d->part[i].id-GROUPOFFSET;
     
     strcat(partList," g-");
     strcat(partList,gid2gname(id)); //                 was groupList[id].name 
    }
 
 if(partList[0] == '\0')
  {
   printf("WARINIG: partList for Date %d/%s ist empty\nPartticipator:\n",d->id,d->descr);
   for(i=0;i<d->partAnz; i++)
    if(d->part[i].id <GROUPOFFSET)
     printf("User %s %d\n",uid2uname(id),userList[id].selected); //                 was userList[id].name 
    else if (d->part[i].id <ROOMOFFSET)
     printf("Group %s %d\n",gid2gname(id),groupList[id].selected); //                 was groupList[id].name 
  }

 return(partList);
}

void getRoomCal(char *buffer, int uid, int cid, int startDay, int stopDay,int igno,int ignoInfo)
{
 char tx[1024];
 int start,stop;
 int tstart,tstop;
 int notime;
 int i,perm;
 UserInDate *self;
 CalendarItem ci,wci;
 int dateAsInfo=false;

 strcpy(buffer,"");
 // sortDateList(roomList[cid].cal.list,roomList[cid].cal.anz);
 for(i=0;i<roomList[cid].cal.anz ; i++)
  {
   if( ! roomList[cid].cal.list[i]->deleted )
    {

     dateAsInfo = dateOnlyAsInfo(roomList[cid].cal.list[i],uid);
     if(ignoInfo == 1)
      if(dateAsInfo)
       continue;
     perm = getPermission(roomList[cid].cal.list[i],uid,cid);
     if( (perm & READ_TIMES) == READ_TIMES )
      {
       ci.startDate=roomList[cid].cal.list[i]->startDate;
       ci.startTime=roomList[cid].cal.list[i]->startTime;
       ci.stopDate =roomList[cid].cal.list[i]->stopDate;
       ci.stopTime =roomList[cid].cal.list[i]->stopTime;
       ci.count=0;
       ci.startwDay=weekDayByDate(ci.startDate);
       roomList[cid].cal.list[i]->dateShiftPtr =0;
       memcpy(&wci,&ci,sizeof(CalendarItem));
       jump2NextDateAfter(&ci,&wci,roomList[cid].cal.list[i],startDay);
       start =wci.startDate;
       stop  =wci.stopDate;

       while( start<= stopDay && stop>=startDay)
	{
	 if(start<startDay)
	  {
	   start=startDay;
	   tstart=0;
	  }
	 else
	  tstart = wci.startTime;

	 if(stop>stopDay)
	  {
	   stop=stopDay;
	   tstop=2359;
	  }
	 else
	  tstop = wci.stopTime;

	 
	 notime = (roomList[cid].cal.list[i]->flags & DATE_FLAG_NOTIME) >> DATE_FLAG_NOTIME_SHIFT;
	 if( (perm & READ_HEADS) == READ_HEADS )
	  sprintf(tx,"{%d %d %d %d %d {%s} %d %d %d {} %d %d}  ",
		  start,tstart,stop,tstop,notime,roomList[cid].cal.list[i]->descr,roomList[cid].cal.list[i]->id,
		  roomList[cid].cal.list[i]->repeatTyp,roomList[cid].cal.list[i]->priority,
		  roomList[cid].cal.list[i]->flags&DATE_FLAG_PRIVAT,dateAsInfo);
	 else
	  sprintf(tx,"{%d %d %d %d %d {%s} %d %d %d {} %d %d} ",
		  start,tstart,stop,tstop,notime," ",roomList[cid].cal.list[i]->id,
		  roomList[cid].cal.list[i]->repeatTyp,roomList[cid].cal.list[i]->priority,
		  roomList[cid].cal.list[i]->flags&DATE_FLAG_PRIVAT,dateAsInfo);

	 strcat(buffer,tx);
	 if(!skip2NextDateAfter(&ci,&wci,roomList[cid].cal.list[i]))
	  break;	   
	 start =wci.startDate;
	 stop  =wci.stopDate;
	}
      }
    }
  }
}

UserDateModification *getUserModification4Date(int did,int uid)
{
 int i;
 User *usr;

 usr =&userList[uid];
 for(i=0;i<usr->dmodiAnz; i++)
  if(usr->dmodi[i].did == did)
   return(&usr->dmodi[i]);

 return(NULL);
}
int dateIsIgnoredByMe(int did,int uid)
{
 int i;
 User *usr;

 usr =&userList[uid];
 for(i=0;i<usr->dmodiAnz; i++)
  if(usr->dmodi[i].did == did)
   return(usr->dmodi[i].ignored);

 return(false);
}

int dateOnlyAsInfo(Date *d,int uid)
{
 int i,j,gid;
 int groupIsPart=false;
 int groupIsInfo=false;

 for(i=0;i<d->partAnz; i++)
  {
   if(d->part[i].id <GROUPOFFSET)
    {
     if(d->part[i].id==uid)
      {
       if(d->part[i].typ == UID_TYP_INFO)            // Wenn der Nutzer explizit als Info eintragen ist -> true
	return(true);
       else
	return(false);                         // Wenn der Nutzer explizit als Teilnehmer  eintragen ist -> false
      }
    }
   else
    {
     gid = d->part[i].id-GROUPOFFSET;
     for(j=0;j<userList[uid].ganz; j++)
      if(userList[uid].groups[j] == gid)
       if(d->part[i].typ != UID_TYP_INFO)
	groupIsPart=true;
       else
	groupIsInfo=true;

     if(groupIsPart)                 // Wenn der Nutzer in einer Gruppe ist, die explizit teilnimmt 
      return(false);                 //         -> nicht onlyInfo -> false
     if(groupIsInfo)                 // Ween der Nuzter nur in Gruppen ist, die als info eingetrage sind ->true
      return(true);
    }
  }
 return(false); // Wenn der Nuzter gar nicht eingetragen ist -> false
}



void checkString(char *t)
{
 char *s;

 for(s=t; *s!='\0'; s++)
  {
   if( *s=='{')
    *s='(';
   if( *s=='}')
    *s='}';
  }
}
