//  File: main.cc
// 
//      This file is part of minkowsky
// 
//      Copyright (C) 2001-2002 by Rdiger Goetz
//      Author: Rdiger Goetz <minkowsky@r-goetz.de>
// 
//      Time-stamp: <28-May-2002 21:16:54 goetz>
// 
//      This program is free software; you can redistribute it and/or modify
//      it under the terms of the GNU General Public License as published by
//      the Free Software Foundation; either version 2 of the License, or
//      (at your option) any later version.
// 
//      This program is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU General Public License for more details.
// 
//      You should have received a copy of the GNU General Public License
//      along with this program; if not, write to the Free Software
//      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//  
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <unistd.h>  
#include <errno.h>    
#include <netinet/in.h>  
#include <fcntl.h>  
#include <time.h>       
#include <sys/poll.h>  
#include <signal.h>     
#include <stdarg.h>      

#define ___MAIN
#include "termin.h"

#define MAX_CLIENTS 1000
#ifndef MASTERPORT
#define MASTERPORT  41999
#endif

typedef struct
{

}MinkowskySocketsInfo;

struct sockaddr_in MasterSocketAddress;
struct sockaddr_in clientSocketAddress[MAX_CLIENTS];
int masterPort;
//int port[MAX_CLIENTS],clientSocket[MAX_CLIENTS],tcSocket[MAX_CLIENTS],cidUsed[MAX_CLIENTS];
int masterSocket,tmpSocket;
//int remSocket[MAX_CLIENTS],freeReminderSince[MAX_CLIENTS];
//int freeSince[MAX_CLIENTS];
//int connectedUser[MAX_CLIENTS];
int doReload=false;
char tclMsg[16384];
int localVerbose=false;
int doCloseAllConnection=false;
char configFile[1024];
int develServer=false;
FILE *fpl;
short int delay[ 65526];

void initCloseAllConnection(int vlaue);
int ckeck4ClientOnMasterPort( );
void initSockets();
void openMasterSocket();
int checkSocket(int socket,int retries);
int checkSocket(int socket);
int send2Client(int socket,char *msg);
int send2Client_(int socket,char *msg);
int sendACK(int socket);
int get4ClientMessage(int socket,char *t, int l);
int check4ClientMessage(int socket,char *t, int l);
int check4ClientMessageVerbose(int socket,char *t, int l);
int nextFreeCID();
void initReload(int value);
void closeAllConnection(int value);
int freeSocketsTotal(int cid);
int freeSockets(int cid);
int _freeSockets(int cid ,int total,int expectSocket);
void getToday ( );
#define MINKO_VERSION "MINKOVERSION"

int main(int argc, char *argv[])
{
 char buffer[16384],*p,*s,file[1024];
 int l,canz,tmpSocket;
 int cid,i,stat;
 char *t;
 int stim,rtim,ntim,rctim,tim;
 int notifyInterval =900;
 FILE *fp,*fpp;
 int ret,uid;
 int mrrTim=0,curTim;
 char tmpServerLang[5];

 printf("Starting Minkowsky Server %s\n",MINKOVERSION);

 verbose=false;
 noReminder=false;
 strcpy(progName,"Minkowsky Raum/Zeit Verwaltung");
 strcpy(company,"");
 dataDir=NULL;
 doCheckPresence=false;
 presenceList=NULL;
 if ( getenv("LANG") == NULL )
  strcpy(tmpServerLang,"de");
 else
  strcpy(tmpServerLang,getenv("LANG"));


 strcpy(configFile,"/etc/minkowsky");

 if(argc>1)
  {
   int ac=1;
   while(ac<argc)
    {
     if(strcmp(argv[ac],"-v")==0)
      verbose=true;
     else if(strcmp(argv[ac],"-nr")==0)
      noReminder=true;
     else if(strcmp(argv[ac],"-f")==0)
      {
       ac++;
       strcpy(configFile,argv[ac]);
      }
     ac++;
    }
  }



 fp=fopen(configFile,"r");
 if(fp!=NULL)
  {
   p=fgets(buffer,8190,fp);
   while(p!=NULL)
    {
     //     printf("reading resource: %s (%d)\n",buffer,verbose);
     if(strncmp(buffer,"DATA_PATH",9 )==0)
      {
       t=skip2nonWS(buffer+10);
       s= t+strlen(t)-1;
       if(*s=='\n')
	*s='\0';
       dataDir = new char [strlen(t)+4];
       strcpy(dataDir,t);
      }
     else if(strncmp(buffer,"TERMIN_DATA_PATH",15)==0)
      {
       t=skip2nonWS(buffer+16);
       s= t+strlen(t)-1;
       if(*s=='\n')
	*s='\0';
       dataDir = new char [strlen(t)+4];
       strcpy(dataDir,t);
      }
     else if(strncmp(buffer,"SERVER_BIN_PATH",15)==0)
      {
       t=skip2nonWS(buffer+16);
       s= t+strlen(t)-1;
       if(*s=='\n')
	*s='\0';
       serverBinPath = new char [strlen(t)+4];
       mail2smtp = new char [strlen(t)+32];
       strcpy(serverBinPath,t);
       sprintf(mail2smtp,"%s/mail2smtp",serverBinPath);
      }
     else if(strncmp(buffer,"VERBOSE",7)==0)
      {
       s=skip2nonWS(buffer+8);
       //       printf("s=%s\n",s);
       verbose=true;
	if(s !=NULL)
         if(strncasecmp(s,"off",3)==0)
  	  verbose=false;
      }
     else if(strncmp(buffer,"COMPANY",7)==0)
      {
       t=skip2nonWS(buffer+8);
       s= t+strlen(t)-1;
       if(*s=='\n')
	*s='\0';
       if(strlen(t)>127)
	{
	 strncpy(company,t,127);
	 company[127]='\0';
	}
       else
	 strcpy(company,t);
      }
     else if(strncmp(buffer,"SERVER_LANGUAGE",15)==0)
      {
       t=skip2nonWS(buffer+16);
       s= t+strlen(t)-1;
       if(*s=='\n')
	*s='\0';
       tmpServerLang[0]=t[0];
       tmpServerLang[1]=t[1];
       tmpServerLang[2]='\0';
      }
     else if(strncmp(buffer,"REPLY_ADDRESS",13)==0)
      {
       t=skip2nonWS(buffer+14);
       strcpy(replyAddress,strChop(t));
      }
     else if(strncmp(buffer,"NOTIFY_EVERY",12)==0)
      {
       t=skip2nonWS(buffer+13);
       notifyInterval = atoi(strChop(t));
      }
     else if(strncmp(buffer,"DEVELSERVER",11)==0)
      {
       develServer=true;
      }
     else if(strncmp(buffer,"CHECKPRESENCE",13)==0)
      {
       s=skip2nonWS(buffer+14);

       doCheckPresence=true;

       if(strncasecmp(s,"off",3)==0)
	doCheckPresence=false;

       if(strncasecmp(s,"on",2)==0)
	{
	 s =skip2WS(s+2);
	 s =skip2nonWS(s);
	}
       if (doCheckPresence )
	{
	 strcpy(checkPresenceFile,s);
	 strTrim(checkPresenceFile);
	}
      }
     else if(strncmp(buffer,"MYSELF",7)==0)
      {
       t=skip2nonWS(buffer+8);
       s= t+strlen(t)-1;
       if(*s=='\n')
	*s='\0';
       if(strlen(s)>63)
	{
	 strncpy(progName,s,63);
	 progName[63]='\0';
	}
       else
	 strcpy(progName,s);
      }
     p=fgets(buffer,8190,fp);
    }
   fclose(fp);
  }
 else
  printf("Can't open %s (%p)\n",configFile,fp);
 if(dataDir==NULL)
  {
   dataDir= new char [32];
   strcpy(dataDir,"/usr/local/share/termine");
  }

 if(!develServer)
  {
   sprintf(file,"%s/.minkowsky.pid",getenv("HOME"));
   fpp=fopen(file,"w");
   if(fpp==NULL)
    {
     printf("Can't open %s",file);
     exit(-1);
    }
   fprintf(fpp,"%d",getpid());
   fclose(fpp);
  }
 


 if(verbose)
  printf("Running in Verbose Mode\n");

 if(tmpServerLang[0] == 'd' && tmpServerLang[1] == 'e')
  serverLang = MINKO_LANG_DE;
 else
  serverLang = MINKO_LANG_EN;

 mailMaskEinlExternText=NULL;
 mailMaskEinlExternSubj=NULL;
 mailMaskEinlInternText=NULL;
 mailMaskEinlInternSubj=NULL;
 mailMaskErinExternText=NULL;
 mailMaskErinExternSubj=NULL;
 mailMaskErinInternText=NULL;
 mailMaskErinInternSubj=NULL;
 mailMaskErinToDoText=NULL;
 mailMaskErinToDoSubj=NULL;
 mailMaskMahnToDoText=NULL;
 mailMaskMahnToDoSubj=NULL;



 sprintf(file,"%s/minkowsky.log",dataDir);
 fpl=fopen(file,"a");
 if(fpl==NULL)
  printf("Can't open log-file %s\n",file);

 dataImported=false;
 readLists();
 initDateList();
 initReminderList();
 initAdrList();
 initTodoList();
 initProjList();
 readAdrList();
 readDates();
 readTodoList();
 readProjList();
 recreateReminderList();
 updateDateCountsInAddress();
 lastDateChange =time(NULL);
 ulistUpdateTim = stim = lastReminderListCreation =  rtim  = ntim= time(NULL);
 signal(SIGUSR1,initReload);  
 signal(SIGTERM,initCloseAllConnection);  
 signal(SIGINT ,initCloseAllConnection);  
 if(dataImported)
  {
   writeAllDates();
  }

 if(doCheckPresence)
  checkPresence();
 initSockets();
 // watch for request
 for(;;)
  {
   // check Master Port
   if( (tmpSocket=ckeck4ClientOnMasterPort()) >=0)
    { // tmp
     if(verbose)
      printf("Masterport connection on %d\n",tmpSocket);
     if( (canz=check4ClientMessageVerbose(tmpSocket,buffer,16383)) >0)
      {
       buffer[16383]='\0';
       if(verbose)
	printf("Got on %d: %s\n",tmpSocket,buffer);
       
       if(strncmp(buffer,"openReminder",12)==0 )
	{
	 char user[256],dummy[256];
	 if(verbose)
	  printf("Connecting Reminder via '%s'\n",buffer);
	 sscanf(buffer,"%s %s",dummy,user); //FIXME AUTH
	 uid=uname2uid(user);
	 if(uid<0)
	  {
	   if(verbose)
	    printf("no such user '%s'\n",user);
	   send2Client(tmpSocket,"denied");
	   continue;
	  }
	 if(userList[uid].rsocket>0)
	  {
	   if(verbose)
	    printf("Reopenning Connection to Reminder of %s/%d (old socket =%d)\n",userList[uid].name,uid,userList[uid].rsocket);
	   ret = shutdown(userList[uid].rsocket,2);
// 	   ret = shutdown(userList[uid].socket,2);
// 	   ret = close(userList[uid].socket);
	   ret = close(userList[uid].rsocket);
	  }
	 userList[uid].rsocket= tmpSocket;
	 send2Client(userList[uid].rsocket,"registered");
	 if(verbose)
	  printf("Reminder App for %s/%d has been registered on Socket %d\n",userList[uid].name,uid,userList[uid].rsocket);

	 
	}
       else if(strncmp(buffer,"connect",7)==0 ||strncmp(buffer,"reconnect",9)==0 )
	{ // reqPort
	 char user[32],pwd[32],dummy[32],dummy2[32],npwd[32],salt[4],oldCidStr[64];
	 int reconn=false;
	 
	 if(strncmp(buffer,"reconnect",9)==0 )
	  {
	   if(verbose)
	    printf("Reconnecting via '%s'\n",buffer);
	   minkoLog("reconnected via '%s'\n",buffer);
	   reconn=true;
	  }
	 else
	  if(verbose)
	   printf("Connecting via '%s'\n",buffer);

	 sscanf(buffer,"%s %s %s %s",dummy,user,pwd,oldCidStr); //FIXME AUTH
	 uid=uname2uid(user);
	 if(uid<0)
	  {
	   if(verbose)
	    printf("no such user %s\n",user);
	   send2Client(tmpSocket,"denied");
	   continue;
	  }
	 if(userList[uid].id!=uid )
	  {
	   if(verbose)
	    printf("no such user %s\n",user);
	   send2Client(tmpSocket,"denied");
	   continue;
	  }
	 readUserPrefs(uid);
	 strncpy(salt,userList[uid].pwd,2);
	 salt[2]='\0';
	 strcpy(npwd,text2Pwd(pwd,salt));
	 if(strcmp(pwd,"")!=0 || strlen(userList[uid].pwd)>0)
	  if(strcmp(npwd,userList[uid].pwd)!=0)
	   {
	    if(verbose)
	     printf("AUTH error '%s' '%s'\n",userList[uid].pwd,text2Pwd(pwd,userList[uid].pwd));
	    send2Client(tmpSocket,"denied");
	    continue;
	   }
	 if(reconn)
	  {
	   if(userList[uid].socket >=0)
	    {
	     if(verbose)
	      printf("freeing old socket for uid  %d\n",uid);
	     _freeSockets(uid,true,tmpSocket);
	    }
	  }
	 userList[uid].socket = tmpSocket;
	 userList[uid].lastAction = (int) time(NULL);
	 if(verbose)
	  printf("User %s/%d connetced on socket %d\n",user,uid,userList[uid].socket);
	 usleep(1000);
	 sprintf(tclMsg,"connected %d",1);
	 send2Client(userList[uid].socket,tclMsg);
	 if(verbose)
	  printf("expecting 'ack'\n");
	 if( (canz=get4ClientMessage(userList[uid].socket,buffer,16383)) >0)
	  {
	   if (strcmp(buffer,"client connected")==0)
	    {
	     send2Client(userList[uid].socket,"connection verified");
	     delay[userList[uid].socket] =0;
	    }
	   else
	    freeSocketsTotal(uid);
	  }
	 else
	  freeSocketsTotal(uid);
	}
       else
	shutdown(tmpSocket,2);
      }
     if(verbose)
      printf ("canz=%d from %d (%d) \n",canz,masterSocket,tmpSocket);
    }
   curTim = time(NULL);
   if(curTim >mrrTim)
    {
     for(uid=0;uid<=userAnz; uid++)
      if(userList[uid].rsocket>0)
       {
	if( (canz=check4ClientMessage(userList[uid].rsocket,buffer,16383)) >0)
	 {
	  buffer[16383]='\0';
	  if (strncmp(buffer,"exit",4)==0)
	   {
	    if(verbose)
	     printf("Closing connection to reminder of %s/%d\n",userList[uid].name,uid);
	    ret = shutdown(userList[uid].rsocket,2);
// 	    ret = shutdown(userList[uid].rsocket,2);
// 	    ret = close(userList[uid].rsocket);
	    ret = close(userList[uid].rsocket);
	    userList[uid].rsocket=-1;
	   }
	 }
       }
     mrrTim=curTim;
    }

//    for(cid=0;cid<MAX_CLIENTS; cid++)
//     if(cidUsed[cid])
   for(uid=0;uid<=userAnz; uid++)
    if(userList[uid].socket>0)
     {
      int curSocket = userList[uid].socket;
      if( (canz=check4ClientMessage(curSocket,buffer,16383)) >0)
       {
	buffer[16383]='\0';
	if(verbose)
	 printf("Got: %s\n",buffer);



	if (strcmp(buffer,"client connected")==0)
	 send2Client(curSocket,"connection verified");
	else if(strncmp(buffer,"registerDelay",13)==0)
	 {
	  delay [ curSocket ]  =atoi(buffer +14);
	 }
	else if(strncmp(buffer,"addDate",7)==0)
	 {
	  if(addDate(buffer+8))
	   send2Client(curSocket,"OK");
	  else
	   send2Client(curSocket,"denied");
	 }
	else if(strncmp(buffer,"modifyDate",10)==0)
	 {
	  modifyDate(curSocket,buffer+11);
	 }
	else if (strncmp(buffer,"aquireDate",10)==0)
	  aquireDate(curSocket,buffer+11 );
	else if (strncmp(buffer,"cancelEditDate",14)==0)
	  cancelEditDate(curSocket,buffer+15 );
	else if (strncmp(buffer,"shiftDateInfo",13)==0)
	  getShiftDateInfo(curSocket,buffer+14 );
	else if (strncmp(buffer,"shiftDate",9)==0)
	  shiftDate(curSocket,buffer+10 );
	else if (strncmp(buffer,"changeStatus ",13)==0)
	  changeDateStatus4User(curSocket,buffer+13 );
	else if (strncmp(buffer,"suspendDate",11)==0)
	  suspendDate(curSocket,buffer+12 );
	
	
	else if(strncmp(buffer,"getUserCal",10)==0)
	 getUserCal(buffer+11,curSocket);
 	else if(strncmp(buffer,"getUserPrefs",12)==0)
	 getUserPrefs(buffer+13,curSocket);
  	else if(strncmp(buffer,"saveUserPrefs",13)==0)
	 setUserPrefs(buffer+14,curSocket);
  	else if(strncmp(buffer,"saveSet",7)==0)
	 saveIDset(buffer+8,curSocket);
  	else if(strncmp(buffer,"getLists",8)==0)
	 getLists(curSocket);
  	else if(strncmp(buffer,"getMemberLists",14)==0)
	 getGroupMembersList(curSocket);
  	else if(strncmp(buffer,"getUserList",11)==0)
	 getUserList(curSocket);
  	else if(strncmp(buffer,"getGroupList",12)==0)
	 getGroupList(curSocket);
  	else if(strncmp(buffer,"getRoomList",11)==0)
	 getRoomList(curSocket);
   	else if(strncmp(buffer,"getFullUserName",15)==0)
	 getFullUserName(curSocket,buffer+16);
	else if (strncmp(buffer,"groupListByUser",15)==0)
	 getGroupsOfUser(curSocket,buffer+16);
	else if (strncmp(buffer,"usersOfGroup",12)==0)
	 getUsersOfGroup(curSocket,buffer+13);
	else if (strncmp(buffer,"deleteDate",10)==0)
	  deleteDate(curSocket,buffer+11);
	else if (strncmp(buffer,"getDateAndAquire",16)==0)
	  sendDate(curSocket,buffer+17 ,true);
	else if (strncmp(buffer,"getInfo4NewDate",15)==0)
	  sendInfo4NewDate(curSocket,buffer+16);	
	else if (strncmp(buffer,"getDate",7)==0)
	  sendDate(curSocket,buffer+8 ,false);
	else if (strncmp(buffer,"getBriefDate",12)==0)
	  sendBriefDate(curSocket,buffer+13 );
	else if (strncmp(buffer,"getMultiBriefDate",17)==0)
	  sendMultiBriefDate(curSocket,buffer+18 );
	else if (strncmp(buffer,"getBlockedTimes",15)==0)
	  getBlockedTimes(curSocket,buffer+16 );
	else if (strncmp(buffer,"ignoreDate",10)==0)
	  ignoreDate(curSocket,buffer+11 );
	else if (strncmp(buffer,"doNotremind",11)==0)
	  suspendReminder(curSocket,buffer+12 );
	else if (strncmp(buffer,"lastUListUpdate",15)==0)
	 {
	  sprintf(tclMsg,"%d",ulistUpdateTim);
	  send2Client(curSocket,tclMsg);
	 }
	else if (strncmp(buffer,"addComm",7)==0)
	  addComm(curSocket,buffer+8 );
	else if (strncmp(buffer,"updateComm",10)==0)
	  getComm(curSocket,buffer+10 );
	else if (strncmp(buffer,"lastChangeDate",14)==0)
	 {
	  sprintf(tclMsg,"%d",lastDateChange);
	  send2Client(curSocket,tclMsg);
	 }

	else if (strncmp(buffer,"getAdrFolders", 13)==0)
	  sendAdrFolderList(curSocket,buffer+ 14 );
	else if (strncmp(buffer,"makeAdrFolder", 13)==0)
	  makeAdrFolder(curSocket,buffer+ 14 );
	else if (strncmp(buffer,"changeAdrFolder",15)==0)
	  changeAdrFolder(curSocket,buffer+ 16 );
	else if (strncmp(buffer,"moveAdrObjToFolder",18)==0)
	  moveAdrObjToFolder(curSocket,buffer+ 19 );
	else if (strncmp(buffer,"delAdrFolder", 12)==0)
	  deleteAdrFolder(curSocket,buffer+ 13 );
	else if (strncmp(buffer,"changeAdr", 9)==0)
	  changeAdress(curSocket,buffer+10 );
	else if (strncmp(buffer,"getAdrList",10)==0)
	  sendAddresssList(curSocket,buffer+11 );
	else if (strncmp(buffer,"getBriefAdrList",15)==0)
	  sendBriefAdressList(curSocket,buffer+16 );
	else if (strncmp(buffer,"getAdr", 6)==0)
	  sendAddress(curSocket,buffer+ 7 );
	else if (strncmp(buffer,"getFullAdr",10)==0)
	  sendFullAddress(curSocket,buffer+ 11 );
	else if (strncmp(buffer,"delAdr", 6)==0)
	  deleteAddress(curSocket,buffer+ 7 );
	
	else if (strncmp(buffer,"addNotiz", 8)==0)
	  addNotiz(curSocket,buffer+ 9,ADDRESS_NOTIZ );
	else if (strncmp(buffer,"changeNotiz", 11)==0)
	  changeNotiz(curSocket,buffer+ 12 ,ADDRESS_NOTIZ );
	else if (strncmp(buffer,"getNotiz", 8)==0)
	  getNotiz(curSocket,buffer+ 9 ,ADDRESS_NOTIZ);
	else if (strncmp(buffer,"sendNotizByMail", 15)==0)
	  sendNotizByMail(curSocket,buffer+ 16,ADDRESS_NOTIZ );
	else if (strncmp(buffer,"addDirNotiz", 8)==0)
	  addNotiz(curSocket,buffer+ 9,FOLDER_NOTIZ );
	else if (strncmp(buffer,"changeDirNotiz", 11)==0)
	  changeNotiz(curSocket,buffer+ 12 ,FOLDER_NOTIZ );
	else if (strncmp(buffer,"getDirNotiz", 8)==0)
	  getNotiz(curSocket,buffer+ 9 ,FOLDER_NOTIZ);
	else if (strncmp(buffer,"sendDirNotizByMail", 15)==0)
	  sendNotizByMail(curSocket,buffer+ 16,FOLDER_NOTIZ );

	else if (strncmp(buffer,"changeTodo",10)==0)
	 changeToDo(curSocket,buffer+11);
	else if (strncmp(buffer,"changeStatus4Todo",17)==0)
	 changeTodoStatus(curSocket,buffer+18);
	else if (strncmp(buffer,"changeProject",13)==0)
	 changeProject(curSocket,buffer+14);
	else if (strncmp(buffer,"getTODO", 7)==0)
	 sendTodo(curSocket,buffer+ 8);
	else if (strncmp(buffer,"getProject",10)==0)
	 sendProject(curSocket,buffer+11);
	else if (strncmp(buffer,"getProjLists",12)==0)
	 sendProjectAndTodoLists(curSocket,buffer+13);
	else if (strncmp(buffer,"getLastProjTodoChange",21)==0)
	 getLastProjTodoChange(curSocket);
	else if (strncmp(buffer,"deleteTodo",10)==0)
	 deleteTodo(curSocket,buffer+11);
	else if (strncmp(buffer,"deleteProject",13)==0)
	 deleteProject(curSocket,buffer+14);

	else if (strncmp(buffer,"getPresenceList",13)==0)
	 getPresence(curSocket);

	else if(strncmp(buffer,"importCSV",9)==0)
	 importCSV(curSocket,uid,buffer+10);
	
	else if (strncmp(buffer,"ServerUp?",9)==0)
	  send2Client(curSocket,"ServerIsUp");
	else if (strncmp(buffer,"exit",4)==0)
	 freeSockets(cid);
	else
	 {
	  printf("Err unknown Command: %s",buffer);
	  send2Client(curSocket,"Err unknown Command");
	 }
       }      
     }


   usleep(10000);
   tim =  time(NULL);   
   if( (tim %60)<15)
    if(tim-rtim>30)
     {
      rtim=tim;
      check4Reminder();
      getToday();
      
      printf("wakueup to mrr\n");
      for(i=0 ;i<=userAnz; i++)
       if(userList[i].rsocket>=0)
	{
	 if(verbose)
	  printf("send alive to mrr(%s) on socket %d\n",userList[i].name,userList[i].rsocket);
	 send2Client(userList[i].rsocket,"ServerUp");
	}
     }
   if((tim %notifyInterval)<15 || (tim -ntim) >notifyInterval +15)
    if( (tim -ntim) > 16)
     {
      checkNotifiers();
      ntim=tim;
     }
   if(tim -stim >60)
    {
     stim=tim;
     writeDates();
     if(doCheckPresence)
      checkPresence();
    }
   if(tim-lastReminderListCreation >3600)
    {
     recreateReminderList();
     updateDateCountsInAddress();
    }
   if(doCloseAllConnection)
    {
     closeAllConnection(1);
     exit(0);
    }
   if(doReload)
    {
     writeAdrList();
     writeDates();
     sleep(1);
     clearDateList();
     clearTodoList();
     clearProjList();
     clearLists();
     clearReminderList();
     clearAdrList();


     readLists();
     initDateList();
     initAdrList();
     initTodoList();
     initProjList();
     readAdrList();
     readDates();
     readTodoList();
     readProjList();
     initReminderList();
     recreateReminderList();
     ulistUpdateTim=stim =time(NULL);
     doReload=false;
    }
  }
}


void initSockets()
{
 int i;
//  for(i=0;i<MAX_CLIENTS; i++)
//   {
//    cidUsed[i]=false;
//    connectedUser[i]=-1;
//    port[i]=MASTERPORT+1+i;
//   }
 masterPort=MASTERPORT;
 openMasterSocket();
}

void openMasterSocket()
{
 unsigned int addrlen;
 int ret,i;

 masterSocket=socket(AF_INET,SOCK_STREAM,0);
 if(masterSocket<0)
  {
   printf("Can't create masterSocket\n\tReason: Error #%d ; '%s'\n",errno,strerror(errno));
   exit(-1);
  }
 if(verbose)
  printf("Master Socket on port %d created id=%d\n",masterPort,masterSocket);

 MasterSocketAddress.sin_family = AF_INET;
 MasterSocketAddress.sin_addr.s_addr = INADDR_ANY;
 // Port festlegen
 MasterSocketAddress.sin_port = htons(masterPort);

 ret = bind(masterSocket,(struct sockaddr *)&MasterSocketAddress,sizeof(MasterSocketAddress));
 while(ret<0)
  {
   int tmp;
   printf("Can't bind  masterSocket to port %d \n\tReason: Error #%d ; '%s'\n",
          masterPort,errno,strerror(errno));
   printf("\tWaiting for port to become free\n\n");
   sleep(5);
   ret = bind(masterSocket,(struct sockaddr *)&MasterSocketAddress,sizeof(MasterSocketAddress));
  }
 for(i=0; i<3; i++)
  {
   printf("%c",'G'-'@');
   fflush(stdout);
   usleep(200000);
  }
 
 if(verbose)
  printf("Master Scocket(%d) bound to port %d : %d\n",masterSocket,masterPort,ret);
 if(ret<0)
  printf("Error :%d/%s\n",errno,strerror(errno));
 // Lausche ob jemand mit dir quatschen will
 ret=listen(masterSocket,3);
 if(ret<0)
  {
   printf("Can't listen on  masterSocket\n\tReason: Error #%d ; '%s'\n",errno,strerror(errno))
;
   exit(-1);
  }
 if(verbose)
  printf("Master Scocket(%d) listening : %d\n",masterSocket,ret);
 fcntl(masterSocket, F_SETFL, O_NONBLOCK);
}
int ckeck4ClientOnMasterPort( )
{
 struct sockaddr_in address;
 socklen_t len;
 int socket;

 address.sin_family = AF_INET;
 address.sin_addr.s_addr = INADDR_ANY;
 address.sin_port = htons(masterPort);
 len = sizeof(struct sockaddr_in);
 socket = accept(masterSocket, (struct sockaddr *)&address,&len);
 if(socket<0)
  {
   if(errno != EAGAIN)
    {
     char erc[1024];
     int ern=errno;
     strncpy(erc,strerror(ern),1023);
     erc[1023]='\0';
     if(verbose)
      printf("unexpected failure on checking socket for new conenctions:\n\tErrorcode #%d = '%s'\n",ern,erc);
     minkoLog("unexpected failure on checking socket for new conenctions:\n\tErrorcode #%d = '%s'\n",ern,erc);
    }
   return(socket);
  }

 if(verbose)
  printf("Connection established on socket %d\n",socket);
 fcntl(socket, F_SETFL, O_NONBLOCK);
 return(socket);
}



int checkSocket(int socket,int retries)
{
 int rt;
 for(rt=0;rt<retries;rt++)
  if(checkSocket(socket))
   return(true);
 return(false);
}
int checkSocket(int socket)
{
 struct pollfd ps={socket,POLLOUT,0};
 if(poll(&ps,1,5)<0) // was 100
  return(false);
 if( (ps.revents & (POLLERR | POLLHUP | POLLNVAL)) >0)
  return false;
 if( (ps.revents & POLLOUT) >0)
   return true;

//   printf("poll return : %02X -> %02X & %02X \n",ps.revents,
//  	(ps.revents & (POLLERR | POLLHUP | POLLNVAL)), (ps.revents & POLLOUT));
 return false;
}

#define MAX_MSG_BLOCK 8192
int send2Client(int socket,char *msg)
{
 int ret;
 int socketUp=false;
 int rt=16;
 int len;
 int ptr=0;
 char bmsg[256];

 if( !checkSocket(socket,8))
   return(-1);

 len = strlen(msg);
 sprintf(bmsg,"%%# %d %%#",len);
 if(verbose)
  printf("\t\t\tsending %s\n",bmsg);
 usleep(delay[socket]+500);
 ret=send(socket,bmsg,strlen(bmsg),MSG_NOSIGNAL);
 if(ret<0)
  {
   printf("Error sending '%s' to socket %d' abborted\n",msg,socket);
   return(ret);
  }

 if(len>MAX_MSG_BLOCK)
  {
   printf("BIG MESSAGE sending in special mode \n");
   while(len-ptr>MAX_MSG_BLOCK)
    {
     printf("\t\tsending block from %dk\n",ptr/1024);
     ret=send(socket,msg+ptr,MAX_MSG_BLOCK,MSG_NOSIGNAL);
     printf("done (ret=%d)\n",ret);
     ptr += MAX_MSG_BLOCK;
     usleep(10);
     printf("checking socket\n");
     if( !checkSocket(socket,8))
      return(-1);
     printf("checking socket done\n");
    }
   printf("\t\tsending final  block\n");
   ret=send(socket,msg+ptr,len-ptr+1,MSG_NOSIGNAL);
  }
 else
  {
   printf("\t\t\tsending %s\n",msg);
   ret=send(socket,msg,strlen(msg)+1,MSG_NOSIGNAL);
  }


 if(ret<0)
  printf("Error sending '%s' to socket %d' abborted\n",msg,socket);
 else
  {
   ret=send(socket,"EOT",4,MSG_NOSIGNAL);
   if(ret<0)
    printf("Error sending EOT to socket %d' abborted\n",msg,socket);
   else if(verbose)
    {
     if(len<32768)
      printf("sen to Client: ''%sEOT''\n",msg);
     else
      {
       strncpy(bmsg,msg,255);
       bmsg[255]='\0';
       printf("sen to Client: '%s' .... '%sEOT'\n",bmsg,msg+len-1000);
      }
    }
  }
 return(ret);
}

int sendACK(int socket)
{
 int ret;
 if(!checkSocket(socket,8))
  return(-1);
 ret=send(socket,"ACK",4,MSG_NOSIGNAL);
 if(verbose)
  printf("send ACK  to Client\n");
 return(ret);
}

int check4ClientMessage(int socket,char *t, int l)
{
 char buffer[16384];
 int ret,tl,ttl=16,st=2000;
 struct pollfd ps={socket,POLLIN,0};
 int timeout=10; //was 100
 int retries =2;
 int slp=1000;

 while((ret=poll(&ps,(unsigned int) 1,timeout))<1)
  {
   usleep(slp);
   slp *= 2;
   retries --;
   if(retries<0)
     return(-1);
  }

 ret=recv(socket,t,l,MSG_NOSIGNAL);
 if(ret>0)
  {
   tl=ret;
   while(t[tl-1] !='\0')
    {
     ret=recv(socket,buffer,1024,MSG_NOSIGNAL);
     if(ret>0)
      {
       strcat(t,buffer);
       tl +=ret;
      }
     else
      {
       if(ttl<=0)
	break;
       printf("trying to get data from client ; ttl=%d\n",ttl);
       usleep(st);
       st =st*2;
       ttl--;
      }
    }
   if(sendACK(socket)<0)
    return(-1);
   return(ret);
  }
 return(-1);
}
int get4ClientMessage(int socket,char *t, int l)
{
 char buffer[16384];
 int ret,tl,ttl=16,st=2000;
 struct pollfd ps={socket,POLLIN,0};
 int timeout=500; // was 1000
 int retries =2 ;
 int slp=200000;

 while((ret=poll(&ps,(unsigned int) 1,timeout))<1)
  {
   if(verbose)
    printf("client slient %d %d %d\n",socket,ret,ps.revents);
   usleep(slp);
   slp *= 3;
   retries --;
   if(retries<0)
     return(-1);
  }
 printf("poll:  %d %d %d\n",socket,ret,ps.revents);
 ret=recv(socket,t,l,MSG_NOSIGNAL);
 printf("got %d chars :'%s'\n",ret,t);
 if(ret<0)
  printf("error receiving data: %d %s\n",errno,strerror(errno));

 if(ret>0)
  {
   tl=ret;
   while(t[tl-1] !='\0')
    {
     ret=recv(socket,buffer,1024,MSG_NOSIGNAL);
     if(ret>0)
      {
       strcat(t,buffer);
       tl +=ret;
      }
     else
      {
       if(ttl<=0)
	break;
       printf("trying to get data from client ; ttl=%d\n",ttl);
       usleep(st);
       st =st*2;
       ttl--;
      }
    }
   return(ret);
  }
 return(-1);
}
int check4ClientMessageVerbose(int socket,char *t, int l)
{
 char buffer[16384];
 int ret,tl,ttl=16,st=2000;
 struct pollfd ps={socket,POLLIN,0};
 int timeout=50; // was 1000
 int retries =4;
 int slp=200000;

 while((ret=poll(&ps,(unsigned int) 1,timeout))<1)
  {
   if(verbose)
    printf("client slient %d %d\n",ret,ps.revents);
   usleep(slp);
   slp *= 2;
   retries --;
   if(retries<0)
    return(-1);
  }


 ret=recv(socket,t,l,MSG_NOSIGNAL);
 if(ret>0)
  {
   tl=ret;
   while(t[tl-1] !='\0')
    {
     ret=recv(socket,buffer,1024,MSG_NOSIGNAL);
     if(ret>0)
      {
       strcat(t,buffer);
       tl +=ret;
      }
     else
      {
       if(ttl<=0)
	break;
       printf("trying to get data from client ; ttl=%d\n",ttl);
       usleep(st);
       st =st*2;
       ttl--;
      }
    }
   return(ret);
  }
 printf("givving up (%d)\n",ret);
 return(-1);
}


int freeSocketsTotal(int uid)
{
 return(_freeSockets(uid,true,-1));
}

int freeSockets(int uid)
{
 return(_freeSockets(uid,false,-1));
}
int _freeSockets(int uid,int total,int expectSocket)
{
 int ret;
 if(verbose)
  printf("freeing Socket for uid %d\n",uid);
 if(expectSocket != userList[uid].socket)
  ret = shutdown(userList[uid].socket,2);
//  if(expectSocket != clientSocket[cid])
//   ret = shutdown(clientSocket[cid],2);

 if(expectSocket != userList[uid].socket)
  ret = close(userList[uid].socket);
//  if(verbose)
//   printf("%d\t",ret);
//  if(expectSocket != clientSocket[cid])
//   ret = close(clientSocket[cid]);
 userList[uid].socket =-1;

//  if(verbose)
//   printf("%d\n",ret);
//  cidUsed[cid]=false;
//  connectedUser[cid]=-1;
}


void initReload(int value)
{
 doReload=true;
}

void initCloseAllConnection(int vlaue)
{
 doCloseAllConnection=true;
}

void closeAllConnection (int vlaue)
{
 int cid,uid;

 // FIXME todos, projs ?
 writeAdrList();
 writeAllDates();


 printf("shutting down connections\n");
 for(uid=0;uid<=userAnz; uid++)
  {
   if(userList[uid].rsocket>0)
    send2Client(userList[uid].rsocket,"suspend");
   if(userList[uid].socket>0)
    {
     shutdown(userList[uid] .socket,2);
     close(userList[uid].socket);
    }
  }
  
 shutdown(masterSocket,2);
 shutdown(tmpSocket,2);
 close(tmpSocket);
 close(masterSocket);
 printf("done\n");
 writeDates();
 sleep(1);
 exit(0);
}

void getToday ( )
{
 char tstr[64];
 time_t tim=time(NULL);
 strftime(tstr,255,"%Y%m%d",localtime(&tim));0;   
 today=atoi(tstr);
}

int minkoLog(const char *fmt, ...)
{
 va_list ap;
 char txt[256];

 if(fpl == NULL)
  return(0);

 va_start(ap, fmt);

 time_t tim=time(NULL);
 strftime(txt,255,"%Y%m%d %H %M",localtime(&tim));0;   
 fprintf(fpl,"%s: ",txt);
 fflush(fpl);
 
 vfprintf(fpl,fmt,ap);
 fflush(fpl);
 va_end(ap);   
}
