//  File: notify.cc
// 
//      This file is part of minkowsky
// 
//      Copyright (C) 2001-2002 by Rdiger Goetz
//      Author: Rdiger Goetz <minkowsky@r-goetz.de>
// 
//      Time-stamp: <28-May-2002 12:48:59 goetz>
// 
//      This program is free software; you can redistribute it and/or modify
//      it under the terms of the GNU General Public License as published by
//      the Free Software Foundation; either version 2 of the License, or
//      (at your option) any later version.
// 
//      This program is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU General Public License for more details.
// 
//      You should have received a copy of the GNU General Public License
//      along with this program; if not, write to the Free Software
//      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//  
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <errno.h>  
#include <time.h>  
 
#include "termin.h"

void addNotifier(void *d,User *usr, int type);
void checkNotifiers(int uid);


void announceDate(Date *d, int type)
{
 int i,j,id;
 

 for (i=0; i<d->partAnz; i++)
  if(d->part[i].id < GROUPOFFSET)
   {
    if(userList[d->part[i].id].hasNotifier)
     addNotifier(d,&userList[d->part[i].id],type);
   }
  else if (d->part[i].id <ROOMOFFSET)
   {
    id = d->part[i].id-GROUPOFFSET;
    for(j=0;j<groupList[id].anz; j++)
     if(userList[groupList[id].membr[j]].hasNotifier)
      addNotifier(d,&userList[groupList[id].membr[j]],type);
   }
}
void announceDateShift(DateShift *dsh, int type)
{
 int i,j,id;
 Date * d;
 
 
 d= dateList[dsh->did];
 for (i=0; i<d->partAnz; i++)
  if(d->part[i].id < GROUPOFFSET)
   {
    if(userList[d->part[i].id].hasNotifier)
     addNotifier(dsh,&userList[d->part[i].id],type);
   }
  else
   {
    id = d->part[i].id-GROUPOFFSET;
    for(j=0;j<groupList[id].anz; j++)
     if(userList[groupList[id].membr[j]].hasNotifier)
      addNotifier(dsh,&userList[groupList[id].membr[j]],type);
   }
}

void addNotifier(void *d,User *usr, int type)
{
 int i = usr->notifierAnz;
 usr->notifierDate[i] = d;
 usr->notifierType[i] = type;
 usr->notifierAnz++;
}

void checkNotifiers()
{
 int i;

 for(i=0;i<=userAnz; i++)
  if(userList[i].isNotified)
   if(userList[i].notified4[0]>=0)
    checkNotifiers(i);

 for(i=0;i<=userAnz; i++)
  if(userList[i].hasNotifier)
   userList[i].notifierAnz =0;

}
void checkNotifiers(int uid)
{
 char buffer[256000],txt[256],tx[2][64];
 int count=0;
 int i,j,k;
 DateShift *dsh;
 Date *d;
 int nid;
 char smtp[64];
 char titel[1024];
 // language dependen variables
 char *am,*um,*newDate,*dateChanged,*repDateModiTotal1,*repDateModiTotal2,*details,*mailText;
 char *mailTitle,*userTitle1,*userTitle2,*privateDate,*dateDeleted,*dateShifted,*dateSuspended,*dateUndef;

 switch (serverLang)
  {
  case MINKO_LANG_DE:
   {
    mailTitle                  = "Hinweis auf Terminnderungen";
    userTitle1                 = "Terminnderungen fr";
    userTitle2                 = "";
    mailText                   = "In folgenden Kalendern wurden Termine gendert"; 
    details                    = "im Detail";
    privateDate                = "privater Termin";
    newDate                    = "neuer Termin";
    dateChanged                = "Termin gendert";
    repDateModiTotal1          = "regelmiger Termin";
    repDateModiTotal2          = " insgesamt gendert";
    dateDeleted                = "Termin gelscht";
    dateShifted                = "Termin verlegt";
    dateSuspended              = "Termin ausgesetzt";
    dateUndef                  = "Termin ???????";
    am                         = "am";
    um                         = "um";
    break;
   }
  case MINKO_LANG_EN:
  default:
   {
    mailTitle                  = "Note about changes in Appointments";
    userTitle1                 = "Modification in";
    userTitle2                 = "'s calendar";
    mailText                   = "Appointments in this calendars have been modified";
    details                    = "in detail";
    privateDate                = "private Appointment";
    newDate                    = "new Appointment";
    dateChanged                = "Appointment modifiyed";
    repDateModiTotal1          = "repeated Appointment\n";
    repDateModiTotal2          = "modification on all instances\n";
    dateDeleted                = "Appointment deleted";
    dateShifted                = "Appointment shifted";
    dateSuspended              = "Appointment suspended";
    dateUndef                  = "Appointment ???????";
    am                         = "at";
    um                         = "at";    
    break;
   }
  }
 if(verbose)
  printf("checking notfiers for '%s'\n",userList[uid].name);

 strcpy(smtp,userList[uid].smtp[0]);
 if(smtp[0] == '\0')
  strcpy(buffer,"echo '");
 else
  sprintf(buffer,"%s %s %s  %s \"%s\" \"",mail2smtp,
	  userList[uid].smtp[0],userList[uid].mail[0],replyAddress,mailTitle);

 
 sprintf(buffer,"%s:\n",mailText);
 for(k=0;userList[uid].notified4[k]>=0; k++)
  {
   nid = userList[uid].notified4[k];

   if(userList[nid].notifierAnz>0)
    {
     sprintf(txt,"  %s\n",userList[nid].full);
     strcat(buffer,txt);
    }
  }

 sprintf(buffer,"\n------\n\n%s:\n",details);
 for(k=0;userList[uid].notified4[k]>=0; k++)
  {
    
   nid = userList[uid].notified4[k];
   if(userList[nid].notifierAnz>0)
    {
     sprintf(txt,"\n  %s %s%s\n",userTitle1,userList[nid].full,userTitle2);
     strcat(buffer,txt);
     for(j=0;j<userList[nid].notifierAnz; j++)
      {
       d   = (Date *)      userList[nid].notifierDate[j];
       dsh = (DateShift *) userList[nid].notifierDate[j];
       if (userList[nid].notifierType[j] ==NOTIFIER_DATE_IS_SHIFT || 
	   userList[nid].notifierType[j] ==NOTIFIER_DATE_IS_SUSP )
	d = dateList[dsh->did];

       if(dateIs2Privat2Me(d,uid) )
	strcpy(titel,privateDate);
       else
	strcpy(titel,d->descr);


       switch(userList[nid].notifierType[j])
	{
	case NOTIFIER_DATE_IS_ADD:   
	 sprintf(txt,"    %20s: %s %s %s %s '%s'\n",newDate,
		 am,date2Str(d->startDate,tx[0]),um,time2Str(d->startTime,tx[1]),titel);
	 break;
	case NOTIFIER_DATE_IS_MODI:
	 if (d->repeatTyp == NO_REPEAT)
	  sprintf(txt,"    %20s: %s %s %s %s '%s'\n",dateChanged,
		  am,date2Str(d->startDate,tx[0]),um,time2Str(d->startTime,tx[1]),titel);
	 else
	  {
	   CalendarItem ci;
	   nextDateAfterNow(&ci,d);
	   sprintf(txt,"    %20s\n    %20s: ab %s ,  %s '%s'\n",repDateModiTotal1,repDateModiTotal2,
		   am,date2Str(ci.startDate,tx[0]),um,time2Str(ci.startTime,tx[1]),titel);
	  }
	 break;
	case NOTIFIER_DATE_IS_DELE:
	 sprintf(txt,"    %20s: %s %s %s %s '%s'\n",dateDeleted,
		 am,date2Str(d->startDate,tx[0]),um,time2Str(d->startTime,tx[1]),titel);
	 break;
	case NOTIFIER_DATE_IS_SHIFT:
	 sprintf(txt,"    %20s : %s %s %s %s '%s'\n",dateShifted,
		 am,date2Str(dsh->startDate,tx[0]),um,time2Str(dsh->startTime,tx[1]),titel);
	 break;
	case NOTIFIER_DATE_IS_SUSP:
	 sprintf(txt,"    %20s: %s %s %s %s '%s'\n",dateSuspended,
		 am,date2Str(dsh->startDate,tx[0]),um,time2Str(dsh->startTime,tx[1]),titel);
	 break;
	default:
	 sprintf(txt,"    %20s: %s %s %s %s '%s'\n",dateUndef,
		 am,date2Str(d->startDate,tx[0]),um,time2Str(d->startTime,tx[1]),titel);
	 break;
	}
       strcat(buffer,txt);
       count++;
      }
    }
  }
 
 if(count >0)
  {
 
   if(smtp[0] == '\0')
    {
     sprintf(txt,"' |mail -s \"%s\" %s",mailTitle,userList[uid].mail[0]);
     strcat(buffer,txt);
    }
   else
    strcat(buffer,"\"");
   if(verbose)
    printf("Sending Notification to '%s' :\n %s\n\n",userList[uid].name,buffer);
   if( userList[uid].mail[0][0] != '\0')
    system(buffer);
  }
 else
  {
   if(verbose)
    printf("No Notification for '%s' \n",userList[uid].name);

  }
}
