//  File: perm.cc
// 
//      This file is part of minkowsky
// 
//      Copyright (C) 2001-2002 by Rdiger Goetz
//      Author: Rdiger Goetz <minkowsky@r-goetz.de>
// 
//      Time-stamp: <01-May-2002 12:23:04 goetz>
// 
//      This program is free software; you can redistribute it and/or modify
//      it under the terms of the GNU General Public License as published by
//      the Free Software Foundation; either version 2 of the License, or
//      (at your option) any later version.
// 
//      This program is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU General Public License for more details.
// 
//      You should have received a copy of the GNU General Public License
//      along with this program; if not, write to the Free Software
//      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//  
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include "termin.h"

int checkPermission(Date *d,int mode ,int id)
{
 return(true);
}


//FIXME permissions for multiple calenders
int getPermission(Date *d, int uid,int cid)   // Rechte von uid an am Datum d aus dem  Calender von cid
{
 UserInDate *self;
 int i,j;
 int perm;
 int userDatePerm=0,groupDatePerm=0, userCalPerm=0,groupAdminPerm=0,masterAdminPerm=0,userCalGroupPerm=0;

 self = findUserInDate(d,uid);
 if(self !=NULL)
  if(d->init.id == uid)
   userDatePerm = PERM_ALL;
  else
   userDatePerm = self->perm; // Gruppenmitgliedschaften bercksichigen
 else
  userDatePerm =0;;
 
 groupDatePerm=0;
 for(i=0;i<userList[uid].ganz; i++)
  {
   self = findUserInDate(d,userList[uid].groups[i]+GROUPOFFSET);
   if(self != NULL)
    groupDatePerm |= self->perm;
  }

 userCalGroupPerm=0;                                          // TODO Was wird hier festgestellt ?
 for(i=0;i<userList[uid].ganz; i++)
  for(j=0;j<userList[cid].gpanz;j++)
   if(userList[uid].groups[i] == userList[cid].gPerm[j].id)
    userCalGroupPerm |=  userList[cid].gPerm[j].perm;

 userCalPerm =0;
 if(cid< GROUPOFFSET) // UserCal
  {
   if(cid == uid)
    userCalPerm =READ_TIMES|READ_HEADS;
   else
    {
     if (userCalGroupPerm == 0)
      userCalPerm = userList[cid].calPerm;
    }
  }
 else if (cid< ROOMOFFSET)
  {
   int gid = cid-GROUPOFFSET;

   userCalPerm = groupList[gid].otherPerm;
   for(i=0;i<groupList[gid].anz; i++)
    if(groupList[gid].membr[i] ==uid)
      userCalPerm    |= groupList[gid].membrPerm;
  }
 else
  {
   int rid = cid -ROOMOFFSET;
   userCalPerm = roomList[rid].calPerm;
  }
 
 groupAdminPerm=0;
 for(i=0;i<groupList[d->group].anz; i++)
  if(groupList[d->group].membr[i] ==uid)
   if(groupList[d->group].mstat[i] == GROUP_ADMIN)
    groupAdminPerm |= groupList[d->group].adminPerm;



 masterAdminPerm=0;
 for(i=0;i<groupList[0].anz; i++)
  if(groupList[0].membr[i] ==uid)
   if(groupList[0].mstat[i] == GROUP_ADMIN)
    masterAdminPerm |= groupList[0].adminPerm;
 



 if(userDatePerm!=0)
  perm = userDatePerm | groupAdminPerm | masterAdminPerm ;
 else if(groupDatePerm !=0)
  perm = groupDatePerm | groupAdminPerm | masterAdminPerm ;
 else
  perm = userCalPerm | userCalGroupPerm | groupAdminPerm | masterAdminPerm ;
//  if(verbose)
//   {
//    printf("PERM for %s on %s, cid=%d uid=%d :\t",userList[uid].name,d->descr,cid,uid);
//    printf("     %X / %X %X %X / %X %X  ->%X \n",
// 	  userDatePerm,groupDatePerm,userCalPerm,userCalGroupPerm,groupAdminPerm,masterAdminPerm,
// 	  perm);
//   }
 return(perm);
}

int dateIs2Privat2Me(Date *d, int uid)
{
 int i;

 for(i=0;i<d->partAnz; i++)
  if(d->part[i].id == uid)
   return(false);

 if ((d->flags &DATE_FLAG_PRIVAT) == DATE_FLAG_PRIVAT)
  if(d->init.id != uid)
   return true;

 if ((d->flags &DATE_FLAG_GROUPINTERN) == DATE_FLAG_GROUPINTERN)
  {
   for(i=0;i<groupList[d->group].anz; i++)
    if(groupList[d->group].membr[i]==uid)
     return(false);
   return(true);
  }

 return(false);
}

int admin2User(int uid, int me)
{
 int i,j,gid;

 for(i=0;i<userList[uid].ganz; i++)
  {
   gid = userList[uid].groups[i];
   for(j=0;j<groupList[gid].anz; j++)
    if(groupList[gid].membr[j] == me)
     {
      if(groupList[gid].mstat[j] == GROUP_ADMIN)
       return(true);
      break;
     }
  }
 return(false);
}
