//  File: prefs.cc
// 
//      This file is part of minkowsky
// 
//      Copyright (C) 2001-2002 by Rdiger Goetz
//      Author: Rdiger Goetz <minkowsky@r-goetz.de>
// 
//      Time-stamp: <09-May-2002 18:56:57 goetz>
// 
//      This program is free software; you can redistribute it and/or modify
//      it under the terms of the GNU General Public License as published by
//      the Free Software Foundation; either version 2 of the License, or
//      (at your option) any later version.
// 
//      This program is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU General Public License for more details.
// 
//      You should have received a copy of the GNU General Public License
//      along with this program; if not, write to the Free Software
//      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//  
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <sys/types.h>
#include <sys/stat.h>
//#include <unistd.h>
#define _XOPEN_SOURCE
#include <unistd.h>
#include <crypt.h>
 
 
#include "termin.h"

void saveStandardPrefs(FILE *fp);
void extendIdSetList (int uid);

void extendIdSetList (int uid)
{
 IDset *tmp;
 int anz;

 anz = userList[uid].idSetMax + DATEBLOCKSIZE;
 tmp = new IDset [anz];
 if(userList[uid].set != NULL)
  {
   memcpy(tmp,userList[uid].set,userList[uid].idSetMax);
   delete userList[uid].set;
  }
 userList[uid].set=tmp;
 userList[uid].idSetMax = anz;
}

int getUserPrefs (char *str,int socket)
{
 char buffer[200000],setList[150000],*t;
 char gpermList[16000],tx[256],txt[256];
 int uid,i,j;

 t=skip2WS(str+2);
 *t='\0';
 uid = uname2uid(str);
 if(uid<0)
  {
   sprintf(buffer,"ERR: No User '%s' registerd\n",str);
   send2Client(socket,buffer);
   return(0);
  }

 readUserPrefs(uid);
 sprintf(gpermList,"{default %s}",perm2str(userList[uid].calPerm,tx));
 for(i=0 ; i<userList[uid].gpanz; i++)
  {
   sprintf(txt," {%s %s}",groupList[userList[uid].gPerm[i].id].name,perm2str(userList[uid].gPerm[i].perm,tx));
   strcat(gpermList,txt);
  }
 if(userList[uid].idSetAnz >0 && userList[uid].set !=NULL)
  {
   strcpy(setList,"");
   for(i=0;i<userList[uid].idSetAnz; i++)
    {
     sprintf(txt,"{%s {",userList[uid].set[i].name);
     strcat(setList,txt);

     for(j=0;j<userList[uid].set[i].anz; j++)
      {
       if(userList[uid].set[i].id[j]<GROUPOFFSET)
	{
	 strcat(setList,"u-");
	 strcat(setList,userList[userList[uid].set[i].id[j]].name);
	}
       else
	{
	 strcat(setList,"g-");
	 strcat(setList,groupList[userList[uid].set[i].id[j]-GROUPOFFSET ].name);
	}
       strcat(setList," ");
      }
     strcat(setList,"}} ");
    }
  }
 else
  {
   strcpy(setList,"");
  }
 
 printf("setList(%d): /%s/\n",uid,setList);
 sprintf(buffer,"{%s} %d {%s} {%s} {%s} %d %d %d {%d %d %d %d}         {%s} {%s} {%s}",
	 userList[uid].defPermStr,userList[uid].sig.beep,userList[uid].sig.cmd,gpermList,userList[uid].calFormat
	 ,userList[uid].displayIgnore,userList[uid].displayInfo,userList[uid].displayToolTips,
	 userList[uid].direction_dateRemind, userList[uid].direction_dateInvite,
	 userList[uid].direction_todoRemind,userList[uid].direction_todoMahn,setList,
	 userList[uid].browser,userList[uid].browserCmd);

 send2Client(socket,buffer);
}
int readUserPrefs(int uid)
{
 char file[2096],buffer[16384] ,*tp[64],*t,*tp2[8],*s,*s2,*tp3[1024];
 FILE *fp;
 int ret,gpanz,gid;

 sprintf(file,"%s/prefs/%d.prefs",dataDir,uid);
 fp=fopen(file,"r");
 // printf("-> %p (%s)\n",fp,file);
 if(fp==NULL)
  {
   fp=fopen(file,"w");
   perror(NULL);
   if(fp==NULL)
    {
     printf("ERR: Can;t write default-Prefs");
     return(false);
    }
   else
    {
     //     printf("saving default prefs\n");
     saveStandardPrefs(fp);
     fclose(fp);
     fp=fopen(file,"r");
    }
  }


 userList[uid].idSetAnz=0;
 // printf("-> %p\n",fp);
 if(fp==NULL)
  {
   printf("ERR: Can;t open Prefs");
   return(false);
  }
 else
  {
   gpanz=0;
   t=fgets(buffer,16383,fp);
   while(t!=NULL)
    {
     strChop(t);
     if(strncmp(buffer,"DEFPERM",7)==0)
      {
       t=skip2nonWS(buffer+8);
       strcpy(userList[uid].defPermStr,t);
      }
     else if (strncmp(buffer,"FLAGS",5)==0)
      {
       t=skip2nonWS(buffer+6);
       split(t,tp2,8);
       userList[uid].displayIgnore   =atoi(tp2[0]);
       userList[uid].displayInfo     =atoi(tp2[1]);
       userList[uid].displayToolTips =atoi(tp2[2]);
      }
     else if (strncmp(buffer,"SIGNAL",6)==0)
      {
       int l;
       t=skip2nonWS(buffer+7);
       split(t,tp2,2);
       userList[uid].sig.beep =atoi(tp2[0]);
       l = strlen(tp2[1]);
       if(userList[uid].sig.cmd !=NULL)
	delete userList[uid].sig.cmd;
       userList[uid].sig.cmd = new char [l+4];
       strcpy(userList[uid].sig.cmd,tp2[1]);
      }
     else if (strncmp(buffer,"GROUPPERM",9)==0)
      {
       int done=false;
       t=fgets(buffer,16383,fp);
       while(t!=NULL && strcmp(buffer,"ENDGROUPPERM")!= 0)
	{
	 if (strstr(buffer,"ENDGROUPPERM")!=NULL)
	  done=true;
	 split(buffer,tp2,8);
	 trimRight(tp2[0]);
	 if(strcmp(tp2[0],"default")==0)
	  {
	   userList[uid].calPerm = perm2val(tp2[1]);
	  }
	 else
	  {
	   gid = gname2gid(tp2[0]);
	   if(gid>=0)
	    {
	     userList[uid].gPerm[gpanz].id   = gid;
	     userList[uid].gPerm[gpanz].perm = perm2val(tp2[1]);
	     //	     printf("got groupPrem for %s @ %s : %s->%d",groupList[gid].name,userList[uid].name,tp2[1],userList[uid].gPerm[gpanz].perm);
	     gpanz++;
	    }
	  }
	 if(done)
	  break;
	 t=fgets(buffer,16383,fp);
	}
     }
     else if (strncmp(buffer,"PWD",3)==0)
      {
       s=skip2nonWS(buffer+3);
       strcpy(userList[uid].pwd,strTrim(s));
      }
     else if (strncmp(buffer,"REMINDER",8)==0)
      {
       s=skip2nonWS(buffer+9);
       sscanf(s,"%d %d %d %d",
	      &userList[uid].direction_dateRemind,&userList[uid].direction_dateInvite,
	      &userList[uid].direction_todoRemind,&userList[uid].direction_todoMahn);
      }
     else if (strncmp(buffer,"CALFORMAT",9)==0)
      {
       s=skip2nonWS(buffer+9);
       strcpy(userList[uid].calFormat,strTrim(s));
       //       printf("got CALFORMAT '%s // %s'",s,userList[uid].calFormat);
      }
     else if (strncmp(buffer,"SET",3)==0)
      {
       int sid,i,anz    ;
       while(userList[uid].idSetAnz >= userList[uid].idSetMax)
 	extendIdSetList(uid);
       
       sid = userList[uid].idSetAnz;
       userList[uid].idSetAnz ++;
       
       anz = split(skip2nonWS(buffer+4), tp3,1002);
       strcpy(userList[uid].set[sid].name, strTrim(tp3[0]));
       for(i=1;i<anz; i++)
 	userList[uid].set[sid].id[i-1] =atoi(tp3[i]);
       userList[uid].set[sid].anz=anz-1;
      }
     else if (strncmp(buffer,"BROWSER",7)==0)
      {
       s=skip2nonWS(buffer+7);
       s2=skip2WS(s+1);
       strncpy(userList[uid].browser,s,s2-s);
       userList[uid].browser[s2-s+1]='\0';
       if(*s2 != '\0')
	{
	 s=skip2nonWS(s2);
	 if(s !=NULL)
	  strcpy(userList[uid].browserCmd,strTrim(s));
	 else
	  userList[uid].browserCmd[0]='\0';
	}
       else
	userList[uid].browserCmd[0]='\0';
      }
     if(t!=NULL)
      t=fgets(buffer,16383,fp);
    }
   userList[uid].gpanz =gpanz;
   fclose(fp);
  }
 return(true);
}

void saveStandardPrefs(FILE *fp)
{
 fprintf(fp,"DEFPERM ztkztk- ztk---k- ztk----- ztk-----\n");
 fprintf(fp,"SIGNAL 1 beep\n");
 fprintf(fp,"CALFORMAT 7 20 3 3 2 3\n");
 fprintf(fp,"FLAGS 0 1 1\n");
 fprintf(fp,"BRWOSER minkowsky");
 fprintf(fp,"GROUPPERM\n");
 fprintf(fp,"default ztk-----\n");
 fprintf(fp,"ENDGROUPPERM\n");
}
int  setUserPrefs (char *str,int socket)
{
 char file[2096],buffer[16384] ,*tp[64],*tp2[200],cpwd[17],salt[3];
 // char calFormat[64];
 int uid,anz,l,gpanz,i,gid;
 // int havePWD=true;
 FILE *fp;

 anz= split(str,tp,16);
 
 uid = uname2uid(tp[0]);
 if(uid<0)
  {
   send2Client(socket,"ERR: No such user");
   return(-1);
  }

 sprintf(userList[uid].defPermStr,"%s %s %s %s\n",tp[1],tp[2],tp[3],tp[4]);
 userList[uid].sig.beep =atoi(tp[5]);
 l = strlen(tp[6]);
 if(userList[uid].sig.cmd !=NULL)
  delete userList[uid].sig.cmd;
 userList[uid].sig.cmd = new char [l+4];
 strcpy(userList[uid].sig.cmd,tp[6]);

 gpanz=0;
 anz=split(tp[7],tp2,200);
 for(i=0 ; i<anz; i+=2)
  {
   if(strcmp(tp2[i],"default")==0)
    userList[uid].calPerm = perm2val(tp2[i+1]);
   else
    {
     gid = gname2gid(tp2[i]);
     if(gid>=0)
      {
       userList[uid].gPerm[gpanz].id   = gid;
       userList[uid].gPerm[gpanz].perm = perm2val(tp2[i+1]);
       gpanz++;
      }
    }
  }
 userList[uid].gpanz =gpanz;

 strcpy(salt,"kp");
 strTrim(tp[8]);
 printf("PWD -------> /%s/ %d \n",tp[8],strlen(tp[8]));
 if(strlen(tp[8])<=0 || tp[8][0] =='')
  userList[uid].hasPWD=false;
 else
  {
  userList[uid].hasPWD=true;
  strcpy(userList[uid].pwd,text2Pwd(tp[8],salt));
  }
 strcpy(userList[uid].calFormat,tp[9]);
 
 userList[uid].displayIgnore   = atoi(tp[10]);
 userList[uid].displayInfo     = atoi(tp[11]);
 userList[uid].displayToolTips = atoi(tp[12]);
 anz=split(tp[13],tp2,200);
 userList[uid].direction_dateRemind =atoi(tp2[0]);
 userList[uid].direction_dateInvite =atoi(tp2[1]);
 userList[uid].direction_todoRemind =atoi(tp2[2]);
 userList[uid].direction_todoMahn   =atoi(tp2[3]);

 strcpy(userList[uid].browser,tp[14]);
 strcpy(userList[uid].browserCmd,tp[15]);
 

 if(!saveUserPrefs(uid))
  {
   send2Client(socket,"Error: Can;t write Prefs");
   return(false);
  }
 send2Client(socket,"done");
}

int saveUserPrefs( int uid)
{
 FILE *fp;
 int i,j;
 char file[2096],buffer[1024];

 sprintf(file,"%s/prefs/%d.prefs",dataDir,uid);
 fp=fopen(file,"w");
 if(verbose)
  printf("saveing prefs to %s\n",file);
 if(fp==NULL)
  {
   return(false);
   //   send2Client(socket,"ERR: Can;t write Prefs");
  }
 else
  {
   fprintf(fp,"DEFPERM %s\n",userList[uid].defPermStr);
   fprintf(fp,"SIGNAL %d %s\n",userList[uid].sig.beep,userList[uid].sig.cmd);
   if(userList[uid].hasPWD)
    fprintf(fp,"PWD %s\n",userList[uid].pwd);
   fprintf(fp,"CALFORMAT %s\n",userList[uid].calFormat);
   fprintf(fp,"FLAGS %d %d %d\n",userList[uid].displayIgnore,userList[uid].displayInfo,userList[uid].displayToolTips);
   fprintf(fp,"REMINDER %d %d %d %d\n",
	      userList[uid].direction_dateRemind,userList[uid].direction_dateInvite,
	      userList[uid].direction_todoRemind,userList[uid].direction_todoMahn);

   fprintf(fp,"BROWSER %s %s\n",userList[uid].browser,userList[uid].browserCmd);
   if(userList[uid].idSetAnz >0 && userList[uid].set !=NULL)
    {
     for(i=0;i<userList[uid].idSetAnz; i++)
      {
       fprintf(fp,"SET %s ",userList[uid].set[i].name);
       for(j=0;j<userList[uid].set[i].anz; j++)
	fprintf(fp,"%d ",userList[uid].set[i].id[j]);
       fprintf(fp,"\n");
      }
    }

   fprintf(fp,"GROUPPERM\n");
   fprintf(fp,"default %s\n",perm2str(userList[uid].calPerm,buffer));
   for(i=0 ; i<userList[uid].gpanz; i++)
     fprintf(fp,"%s %s\n",groupList[userList[uid].gPerm[i].id].name,perm2str(userList[uid].gPerm[i].perm,buffer));
   fprintf(fp,"ENDGROUPPERM\n");
   fclose(fp);
  }
 return(true);
}

char *text2Pwd(char *t,char *salt)
{
 char cpwd[9],*s;
 strncpy(cpwd,t,8);
 cpwd[8]='0';
 s =crypt(cpwd,salt); 
 // printf("'%s' -> '%s' via '%s'  -> '%s'\n",t,cpwd,salt,s);
 return(s);
}

// int checkAuth(char *pwd, int uid)
// {
//  char npwd[32];
 
//  if(strcmp(pwd,"") && strlen(userList[uid].pwd)

//  strcpy(npwd,text2Pwd(pwd,userList[uid].pwd));
// }


int  saveIDset (char *str,int socket)
{
 char *tp[8],*tp2[1001],buffer[256];
 int uid,sid=-1,anz,c=0,i,id,override;
 
 anz= split(str,tp,8);
 uid = uname2uid(tp[0]);
 if(uid<0)
  {
   sprintf(buffer,"ERR: No User '%s' registerd\n",str);
   send2Client(socket,buffer);
   return(0);
  }
 strcpy(buffer,strTrim(tp[1]));
 override  = atoi(tp[2]);
 if ( override == 1) 
  {
   for(i=0; i<userList[uid].idSetAnz; i++)
    if(strcmp(userList[uid].set[i].name,buffer) == 0)
     {
      sid=i;
      break;
     }
  }
 if(sid <0)
  {
   while(userList[uid].idSetAnz >= userList[uid].idSetMax)
    extendIdSetList(uid);
 
   sid = userList[uid].idSetAnz;
   userList[uid].idSetAnz ++;
  }
 strcpy(userList[uid].set[sid].name,buffer);
 
 anz = split(tp[3],tp2,1001);
 for(i=0; i<anz; i++)
  {
   if(tp2[i][0] == 'u')
    {
     id= uname2uid(tp2[i]+2);
     if(id>=0)
      {
       userList[uid].set[sid].id[c] = id;
       c++;
      }
    }
   if(tp2[i][0] == 'g')
    {
     id= gname2gid(tp2[i]+2);
     if(id>=0)
      {
       userList[uid].set[sid].id[c] = id + GROUPOFFSET;
       c++;
      }
    }
  }
 userList[uid].set[sid].anz=c;
 if(!saveUserPrefs(uid))
  {
   send2Client(socket,"ERR: Can;t write Prefs");
   return(false);
  }

 send2Client(socket,"saved");
}
