//  File: termin.h
// 
//      This file is part of minkowsky
// 
//      Copyright (C) 2001-2002 by Rdiger Goetz
//      Author: Rdiger Goetz <minkowsky@r-goetz.de>
// 
//      Time-stamp: <07-Jun-2002 09:15:27 goetz>
// 
//      This program is free software; you can redistribute it and/or modify
//      it under the terms of the GNU General Public License as published by
//      the Free Software Foundation; either version 2 of the License, or
//      (at your option) any later version.
// 
//      This program is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU General Public License for more details.
// 
//      You should have received a copy of the GNU General Public License
//      along with this program; if not, write to the Free Software
//      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//  
/* #define V036 */
/* #define V037 */
/* #define V0372 */
/* #define V038 */
#define V0405
#define V405
#define V0409
#define V409
#define V0409a
#define V0501
#define V0505
#define V0506

#include "perm.h"
#include "address.h"

#define MINKO_LANG_EN 0
#define MINKO_LANG_DE 1

#define PARTANZ_IN_DATE 100
#define REMINDERS_IN_DATE 100
#define REMINDERS_IN_TODO 100

#define DATE_STAT_UKN2 0
#define DATE_STAT_UKN  1
#define DATE_STAT_ZUSAGE 2
#define DATE_STAT_ABSAGE 3
#define DATE_STAT_UNSICHER 4
#define DATE_STAT_VERSCHIEBUNG 5
#define DATE_STAT_IGNORIEREN  6

#define GROUPOFFSET 10000000
#define ROOMOFFSET 30000000
#define ADDRESOFFSET 40000000
#define MAX_ID       79999999
#define REMIND_ALL_USER 80000000
#define REMIND_ALL_INTERN 80000001
#define REMIND_ALL_EXTERN 80000002


#define DATEBLOCKSIZE 1024

#define DATE_FLAG_PRIVAT 0x0001
#define DATE_FLAG_GROUPINTERN 0x0002
#define DATE_FLAG_NOTIME 0x0004
#define DATE_FLAG_NONBLOCK 0x0008

#define DATE_FLAG_PRIVAT_SHIFT 0
#define DATE_FLAG_GROUPINTERN_SHIFT 1
#define DATE_FLAG_NOTIME_SHIFT 2

#define UID_TYP_INIT  'I'
#define UID_TYP_EINL  'E'
#define UID_TYP_TEILN 'T'
#define UID_TYP_EXT   'A'
#define UID_TYP_INFO  'i'

#define UID_FLAG_DELETED 0x4000
#define UID_LOCAL_FLAG_MASK 0xF000
#define UID_NONLOCAL_FLAG_MASK 0x0FFF

#define GROUP_MEMBER 0
#define GROUP_ADMIN 1

#define REMINDER_WAITING 0
#define REMINDER_DONE 1

#define REMINDER_BY_EMAIL  1
#define REMINDER_BY_DIALOG 2
#define REMINDER_BY_SIGNAL 4
#define REMINDER_DEST_MASK 7
#define REMINDER_ALWAYS_BY_MAIL 1
#define REMINDER_ALWAYS_BY_DEFAULT 0
#define REMINDER_ALWAYS_BY_DIALOG -1

#define REMINDER_FOR_TODO  0x1000

#define REMINDER_EINLADUNG  0x0100
#define REMINDER_ERINNERUNG 0x0200
#define REMINDER_MAHNUNG    0x0400
#define REMINDER_SHIFT      0x0800
#define REMINDER_TYPE_MASK  0x0F00

#define NO_REPEAT    0
#define REPEAT_TAGL  1
#define REPEAT_WOCHE 2
#define REPEAT_MONAT 3
#define REPEAT_JEDEN 4
#define REPEAT_ALLE  5
#define REPEAT_WTAGL 6

#define REPEAT_UNIT_STUND 0
#define REPEAT_UNIT_TAG   1
#define REPEAT_UNIT_WOCHE 2
#define REPEAT_UNIT_MONAT 3
#define REPEAT_UNIT_JAHR  4

#define DATE_BLOCK_DATE 0
#define DATE_BLOCK_EXTRAPART 1

#define FILEHEADER_MAGIC "MiNkO-RZ"
#define FILEHEADER_DATE "DATE"
#define FILEHEADER_SHIFT "SHIF"
#define FILEHEADER_TODO  "TODO"
#define FILEHEADER_PROJ  "PROJ"
#define FILEHEADER_ADDR  "ADDR"
#define FILEHEADER_ADDF  "ADDF"
#define CURRENT_FILEVERSION_DATE "0410"
#define CURRENT_FILEVERSION_SHIFT "0410"
#define CURRENT_FILEVERSION_TODO  "0410"
#define CURRENT_FILEVERSION_PROJ  "0410"
#define CURRENT_FILEVERSION_ADDR  "0411"
#define CURRENT_FILEVERSION_ADDF  "0412"

#define NOTIFIER_DATE_IS_ADD   1
#define NOTIFIER_DATE_IS_MODI  2
#define NOTIFIER_DATE_IS_DELE  3
#define NOTIFIER_DATE_IS_SHIFT 4
#define NOTIFIER_DATE_IS_SUSP  5





typedef struct
{
 int id;         // ID des Users
 short int status;     // Status desUsers (UKN, OK, NO OPEN)
 short int typ;        // Typ des Users (Injit, Einl, Teiln, Ext, Info)
 int flags;      //
 int perm;       // Rechte des Users
} UserInDate;

// Structure die zur Verwaltung der Reminder beim recreate gefllt wird.
typedef struct
{
 int tim;
 int startDate;
 int startTime;
 int stopDate;
 int stopTime;
 int lastSendTim;
}ReminderControl;

typedef union
{
 ReminderControl *ctrl;
 int tim;
} ReminderCtrlUnion;

typedef struct
{
 int id;         // Addressat des Reminders
 short int offset;     // Zeitversatz des Reminders 
 short int offset2;    // Zeitversatz des Reminders in der nchst kleineren Einheit (nur bei unit =h oder d)
 char unit;      // Einheit des Zeitversatz (m= Minute, h=Stunde, d=Tag)
 ReminderCtrlUnion ct;
 short int typ;       // Art des Reminders 
 short int status;     // status= REMINDER_DONE, oder REMINDER_WAITING;
 void *date;     // Rckkopplung zum Date oder TODO
}Reminder;


typedef struct
{
 Reminder **list;
 int anz;
 int max;
 int blocks;
} ReminderList;



#include "date.old.h"

#include "todo.h"

typedef struct
{ 
 char magic[8];
 char type[4];
 char version[4];
 int size;
}FileHeader;


typedef struct
{
 int  did;                  // ID des Dates das geshiftet wird.
 unsigned int seekPtr;
 int  refDate,refTime;      // Zeit  zu der der Termin eigentlich angesetzt war.
 char partStatus[PARTANZ_IN_DATE];      // Stati der Teilnehmer bei dieser Instanz eines Wiederholungstermins
 short int dirty;
 short int  deleted;              // Wenn true: Termin findet nicht statt.
 int  room;                 // Termin ist in diesen Raum verlegt (-1 = nicht verlegt)
 int  startDate,startTime;  // neuer Termin
 int  stopDate, stopTime;
 char addDetails [100];     // zustzliche Details
 Reminder reminder;
 short int valid;
 char reserved [62];
} DateShift;


typedef struct 
{
 short int dateBlockType;
 short int dirty;
 unsigned int seekPtr;
 UserInDate init;
 UserInDate part[PARTANZ_IN_DATE];
 Reminder reminder[REMINDERS_IN_DATE];
 short int partAnz;
 short int remAnz;
 int room;
 int group;
 int flags;
 int id;
 int startDate;
 int stopDate;
 int startTime;
 int stopTime;
 char descr[768];
 char *comm;
 int reserverd [20];
 int dateShiftAnz;
 int dateShiftMax;
 int dateShiftPtr;
 DateShift **shifts;

 short int tlen;
 short int repeatTyp;          // Typ siehe #define REPAET_????
 int repeatStopDate;     // Tag an dem die letzte Wiederholung statfindet, 0= unbegrenzt
 int repeatStopTime;  
 short int priority;           // Prioritt des Termins
 short int repeatIntervall;    // Bei REPEAT_ALLE lnge des Intervall in Einheiten 'repeatUnit'
 short int repeatUnit;         // Bei REPEAT_ALLE Einheit von repaet.interval
 short int deleted;
 int internalStatus;     // interner Status
} Date;




typedef struct
{
 int did;
 int ignored;
 int noReminder;
 int reserved[32];
}UserDateModification;

typedef struct
{
 int startDate;
 int startTime;
 int stopDate;
 int stopTime;
 int count;
 int startwDay;
 int dshStartPtr;  // Pointer auf zeithnliches Shiftdate
 int dshRefPtr;    // Pointer der gebraucht wirtd um, das nchste ungeschifted Date zu finden.
 int type;
 Date *d;
} CalendarItem;

typedef struct
{
 int id;
 int anz;
 int max;
 Date **list;
} Calendar;

typedef struct
{
 int perm;
 int id;
}UserGroupPerm;

typedef struct
{
 int beep;
 char *cmd;
}ReminderSignal;


typedef struct
{
 char name [64];
 int anz;
 int id[1000];
} IDset;

typedef struct
{
 int id;
 char name[16];
 char full[73];
 char pwd[17];
 int groups[100];
 int ganz;
 UserGroupPerm gPerm[100];
 int gpanz;
 int calPerm;      // Rechte dritter am eigenen Kalender
 char defPermStr [64];
 char mail[4][128];
 char smtp[4][128];
 Calendar cal;
 TodoList todo;
 ProjectList proj;
 Date *editDate;
 ReminderSignal sig;
 int lastAction;
 char calFormat[64];
 UserDateModification *dmodi;
 int dmodiAnz;
 int dmodiMax;
 int dmodiDirty;
 int displayIgnore;
 int displayInfo;
 int displayToolTips;
 void * notifierDate[256]; // Zeiger auf ein Date oder eine DateShift
 int notifierType[256];
 int notifierAnz;
 int hasNotifier;
 int isNotified;
 int notified4[256]; // -1 Terminierte Liste
 char color[8],color2[8];
 int selected;
 int socket;
 int rsocket;  // socket for mrr
 int direction_dateRemind;
 int direction_dateInvite;
 int direction_todoRemind;
 int direction_todoMahn;
 int hasPWD;
 int idSetAnz;
 int idSetMax;
 IDset *set;
 int dontList; // == 1 wenn User nicht in User-Auflistung erscheinen soll.
 int presence;
 int internalStatus;
 char browser[64];
 char browserCmd[1024];
} User;

typedef struct
{
 int id;
 char name[32];
 int anz;
 int membr[2048];
 int mstat[2048];
 int adminPerm;
 int membrPerm;
 int otherPerm;
 Calendar cal;
 TodoList todo;
 ProjectList proj;
 char color[8];
 int selected;
 int dontList; // == 1 wenn User nicht in User-Auflistung erscheinen soll.
} Group;

typedef struct
{
 int id;
 char name[64];
 char descr[188];
 int calPerm;
 Calendar cal;
 int dontList; // == 1 wenn User nicht in User-Auflistung erscheinen soll.
} Room;



#ifdef ___MAIN
#define __EXTERN
#else
#define __EXTERN extern
#endif

__EXTERN char *dataDir;
__EXTERN User *userList;
__EXTERN Group *groupList;
__EXTERN Room *roomList;
__EXTERN int userAnz,groupAnz,roomAnz;

__EXTERN Date **dateList;
__EXTERN int dateAnz,dateBlocks,dateMax,maxDid;

__EXTERN DateShift **dateShiftList;
__EXTERN int dateShiftAnz,dateShiftMax;

__EXTERN int defGroupAdminPerm,defGroupMembrPerm,defGroupOtherPerm,defUserCalPerm,defRoomCalPerm;
__EXTERN int primGroup;

__EXTERN ReminderList reminderList;
__EXTERN int nextReminder,lastReminderListCreation;


__EXTERN char progName[64],company[128];

__EXTERN int lastDateChange;

__EXTERN int today;
__EXTERN int verbose;
__EXTERN int noReminder;
__EXTERN char *serverBinPath;
__EXTERN char *mail2smtp;

__EXTERN char *mailMaskEinlExternText, *mailMaskEinlExternSubj;
__EXTERN char *mailMaskEinlInternText, *mailMaskEinlInternSubj;
__EXTERN char *mailMaskErinExternText, *mailMaskErinExternSubj;
__EXTERN char *mailMaskErinInternText, *mailMaskErinInternSubj;
__EXTERN char *mailMaskErinToDoText,   *mailMaskErinToDoSubj;
__EXTERN char *mailMaskMahnToDoText,   *mailMaskMahnToDoSubj;
__EXTERN char *mailMaskShiftInternText,*mailMaskShiftInternSubj;
__EXTERN char *mailMaskSuspInternText ,*mailMaskSuspInternSubj;
__EXTERN char *mailMaskShiftExternText,*mailMaskShiftExternSubj;
__EXTERN char *mailMaskSuspExternText ,*mailMaskSuspExternSubj;


__EXTERN char **holidays;
__EXTERN int holidayLines;

__EXTERN char replyAddress[256];

__EXTERN int monJumpLen[13][13];
__EXTERN int monlen[13];
__EXTERN int datesDirty;
__EXTERN int dataImported;

__EXTERN int ulistUpdateTim;


__EXTERN int doCheckPresence;
__EXTERN char checkPresenceFile[1024];;
__EXTERN char *presenceList;

//__EXTERN char serverLang[4];
__EXTERN int serverLang;

void readLists();
char *skip2nonWS(char *t);
char *skip2WS(char *t);
char *skip2nonWSnl(char *t);
char *skip2WSnl(char *t);
int gname2gid(char *name);
char * gid2gname(int gid);
int uname2uid(char *name);
char * uid2uname(int uid);
char * uid2Fullname(int uid);
int rname2rid(char *name);
char * rid2rname(int rid);
void initDateList();
int addDate(char *ds);
void writeAllDates( );
int  writeDates();
int  readDates();
int checkPermission(Date *d,int mode ,int id);
int getPermission(Date *d, int uid,int cid);
void exportDate(Date *d,char *file);
void extendCalList(Calendar *cal);
void sendUserCal(int socket, int uid, int cid, int startDay, int stopDay,int igno,int ignoInfo);
void sendGroupCal(int socket, int uid, int cid, int startDay, int stopDay,int igno,int withUserDates,int ignoInfo);
void sendRoomCal(int socket, int uid, int cid, int startDay, int stopDay,int igno,int ignoInfo);
void getRoomCal(char *buffer, int uid, int cid, int startDay, int stopDay,int igno,int ignoInfo);
void getUserCal(char *str,int socket);
int send2Client(int socket,char *msg);
int split(char *txt,char **tp ,int max);
int getUserPrefs (char *str,int socket);
int setUserPrefs (char *str,int socket);
int saveUserPrefs (int uid);
int  saveIDset (char *str,int socket);
int getLists (int socket);
int getUserList (int socket);
int getGroupList (int socket);
int getRoomList (int socket);
int getFullUserName (int socket,char *s);
int getGroupsOfUser (int socket,char *s);
char * groupsOfUser(int uid,char *buffer);
int getUsersOfGroup (int socket,char *s);
int deleteDate(int socket,char *t);
int sendDate(int socket, char *t,int aquire);
int sendInfo4NewDate(int socket, char *t);
int getBlockedTimes(int socket, char *t);
int modifyDate(int socket,char *ds);
int aquireDate(int socket, char *ds);
int cancelEditDate (int socket,char *ds);
int sendBriefDate(int socket, char *t);
int sendMultiBriefDate(int socket, char *t);
char *briefAdressList(int uid, char *buffer);
void clearLists ();
void clearDateList ();
void addComm(int socket, char *t);
void getComm (int socket, char *t);
int perm2val(char *p);
char * perm2str(int v, char *p);
UserInDate * findUserInDate(Date *d,int uid);
int readUserPrefs(int uid);
int dateIs2Privat2Me(Date *d, int uid);
int admin2User(int uid, int me);
char * trimRight (char *t);
char * strTrim (char *t);
int nextDateAfterNow(CalendarItem *ci,Date *d);
int getGroupMembersList (int socket);
char * strChop(char *t);


int shiftDate(int socket, char * str);
int changeDateStatus4User(int socket, char * str);
int suspendDate(int socket, char * str);
int getShiftDateInfo(int socket, char *str);
void initDateUserModification(User *usr);
void extendDateUserModification(User *usr);
int suspendReminder(int socket,char *str);
int ignoreDate(int socket,char *str);
void checkString(char *t);
void clearUserSelection() ;
void clearGroupSelection() ;



//REminder
void initReminderList();
void clearReminderList ();
int addReminder2Date ( Date *d, char *t);
int addReminder2Date ( Date *d, Reminder *r);
int sendReminder4DateShift ( DateShift *d, int refDate,int refTime,int target);
int addReminder2Todo ( TodoItem *todo, char *t);
int addReminder2Todo ( TodoItem *todo, Reminder *r);
int recreateReminderList();
int updateReminderList ();
int check4Reminder();
char *date2Str(int datum, int tim,char *t);
char *date2Str(int datum, char *t);
char *time2Str(int tim,char *t);
int calcDate (int *datum, int *tim, int offset, int offset2 , int unit);
int getWeekDayInMonth(int *weekCount, int *wday,int datum);
int getCountedWeekDayDatum(int weekCount, int wday, int datum);
char *reminder2Str4Date(Reminder *r,char *t);
char *reminder2Str4Todo(Reminder *r,char *t);
int reminderIsInList(Reminder *r, Reminder *list, int anz);
int findReminderInList(Reminder *r, Reminder *list, int anz);

int str2Reminder(Reminder *r,char *t,const Date *d);
int str2Reminder(Reminder *r,char *t,const TodoItem *todo);
int recalcReminder(Date *d);
int resetReminderStates(Date *d);
int weekDayByDate(int datum);
int buildTempReminderList (const Date *d, Reminder *r,char *t);

char *replaceBraces(char *t);
char *text2Pwd(char *t,char *salt);

// notify
void announceDate(Date *d, int type);
void announceDateShift(DateShift *d, int type);
void checkNotifiers();
int minkoLog(const char *fmt, ...);

void checkPresence();
int getPresence (int socket);
int strChopLen(const char *t);
int changeNotiz(int socket, char *str,int type);
int sendNotizByMail(int socket, char *str,int type);
