#!/bin/sh

PRV=$1
STD_BIN_PATH=$2
MUID=$3
TMP=/tmp/minkowsky

cp /etc/minkowsky  /etc/minkowsky.new

cp /dev/null /tmp/minkowsky


#merge previous /etc/minkowsky into new, keep previous values if available

if [ -e $PRV ]
then
    OPTS=`cat /etc/minkowsky | cut -d' ' -f 1 | grep -v MINKO |sed -e 's/TERMIN_DATA_PATH/DATA_PATH/' `

    for opt in $OPTS
    do
	val=`cat $PRV |grep $opt |cut -d' ' -f 2 `
	if [ -z "$val" ] 
	then
	    val=`cat /etc/minkowsky|grep $opt |cut -d' ' -f 2 `
	fi
	echo "$opt $val">> /tmp/minkowsky
    done
    test -z "`domainname`" && echo "REPLY_ADDRESS minkowsky@`hostname`" >> /tmp/minkowsky
    test ! -z "`domainname`" && echo "REPLY_ADDRESS minkowsky@`hostname`.`domainname`" >> /tmp/minkowsky

    #keep optional parameters from previous /etc/minkowsky
    OPTS=`cat $PRV | cut -d' ' -f 1 | grep -v MINKO |sed -e 's/TERMIN_DATA_PATH/DATA_PATH/' `
    for opt in $OPTS
    do
	val=`cat /tmp/minkowsky|grep $opt `
	if [ -z "$val" ]
	then
	    val=`cat $PRV |grep $opt |cut -d' ' -f 2 `
	    echo "$opt $val">> /tmp/minkowsky
	fi
    done

    #keep client parameters from previous /etc/minkowsky
    cat $PRV |grep MINKO >> /tmp/minkowsky

    binPath=`cat /tmp/minkowsky |grep SERVER_BIN_PATH|cut -d' ' -f 2 `
    if [ ! -z "$binPath" ]
    then
	if [ "$binPath" != "$STD_BIN_PATH" ]
	then
	    echo "moving binaries from $STD_BIN_PATH to $binPath"
	fi
    fi

else
    test -z "`domainname`" && echo "REPLY_ADDRESS minkowsky@`hostname`" >> /etc/minkowsky
    test ! -z "`domainname`" && echo "REPLY_ADDRESS minkowsky@`hostname`.`domainname`" >> /etc/minkowsky
    binPath=`cat /tmp/minkowsky |grep SERVER_BIN_PATH|cut -d' ' -f 2 `
fi


muser=`cat /tmp/minkowsky |grep SERVER_USER|cut -d' ' -f 2 `
id $muser >/dev/null
if [ $? -ne 0 ]
then
    echo "adding user $muser as Minkowsky server user"
    echo "$muser:x:$MUID:$MUID:Minkowsky-Server-User:/home/$muser:/bin/bash" >> /etc/passwd
    echo "$muser:*:8902:0:10000::::" >> /etc/shadow
    echo "$muser::$MUID:" >>/etc/group
fi
chown -R $muser $binPath


chmod u+rx /etc/rc.d/minkowsky
if [ -s /sbin/insserv ] 
then
    /sbin/insserv -r /etc/rc.d/minkowsky
    /sbin/insserv /etc/rc.d/minkowsky
else
    if [ -s /usr/sbin/insserv ] 
    then
	/usr/sbin/insserv -r /etc/rc.d/minkowsky
	/usr/sbin/insserv /etc/rc.d/minkowsky
    else
	echo "Please add /etc/rc.d/minkowsky to the appropriate runlevels"i
    fi
fi




#create data structure if not existing

DATA_PATH=`cat /tmp/minkowsky |grep DATA_PATH|cut -d' ' -f 2 `
if [ ! -d $DATA_PATH ]
then
    mkdirhier $DATA_PATH 
fi

info="0"
if [ ! -f $DATA_PATH/users ]
then
    cp $binPath/defaults/users $DATA_PATH/
    test $info -eq 0 && echo
    info="1"
    if [ "$_LANG" == "de " ]
    then
	echo "INFO:  Da noch keine Benuzterdatei existiert"
	echo "       wurde eine mit dem Benutzer  'admin' angelegt"
    else
	echo "INFO:  Since no users file was found a new users file"
	echo "       with one account named 'admin' was created"
    fi
fi
if [ ! -f $DATA_PATH/groups ]
then
    cp $binPath/defaults/groups $DATA_PATH/
    test $info -eq 0 && echo
    info="1"
    if [ "$_LANG" == "de " ]
    then
	echo "INFO:  Da noch keine Gruppendatei existiert"
	echo "       wurde eine mit der Grupe  'alle' angelegt"
    else
	echo "INFO:  Since no groups file was found a new groups file"
	echo "       with one group named 'alle' was created"
    fi
fi
if [ ! -f $DATA_PATH/rooms ]
then
    cp $binPath/defaults/rooms $DATA_PATH/
    test $info -eq 0 && echo
    info="1"
    if [ "$_LANG" == "de " ]
    then
	echo "INFO: Da noch keine Raum-Datei existiert"
	echo "      wurde eine mit dem Raum  'zu Hause' angelegt"
    else
	echo "INFO:  Since no rooms file was found a new rooms file"
	echo "       with one room 'zu Hause' was created"
    fi
fi
    

dirs="prefs notiz comments userData"
for dir in $dirs 
do
if [ ! -d $DATA_PATH/$dir ]
then
    if [  -f $DATA_PATH/$dir ]
    then
	mv $DATA_PATH/$dir $DATA_PATH/$dir.bak
    fi
    mkdir $DATA_PATH/$dir
fi
done

chown -R $muser $DATA_PATH

test $info -eq 1 && echo
