//
//  File: address.cc
// 
//      This file is part of minkowsky
// 
//      Copyright (C) 2001-2002 by Rdiger Goetz
//      Author: Rdiger Goetz <minkowsky@r-goetz.de>
// 
//      Time-stamp: <27-Oct-2002 19:41:33 goetz>
// 
//      This program is free software; you can redistribute it and/or modify
//      it under the terms of the GNU General Public License as published by
//      the Free Software Foundation; either version 2 of the License, or
//      (at your option) any later version.
// 
//      This program is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU General Public License for more details.
// 
//      You should have received a copy of the GNU General Public License
//      along with this program; if not, write to the Free Software
//      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//  
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <errno.h>  
#include <time.h>  

#define ADDRESS 
#include "termin.h"

int fillStr2Address(char *tp[],Address *adr);
int adress2str(char *t,Address *adr,char *permStr);
int access2Adr(int uid, Address *adr);
int readAccess2Adr(int uid, Address *adr);
int access2Adr(int uid, Address *adr, char *permStr);
int readNotiz(Address *adr);
int readNotiz(AddressFolder *adf);
//int readNotiz(FILE *fp,NotizControl *nc);
int writeNotiz(Address *adr);
int writeNotiz(AddressFolder *adf);
//int writeNotiz(FILE *fp, NotizControl *nc);

void convertAdress0410(Address*adr, Address_0410 *adr410,int anz);
void convertAdress0411(Address*adr, Address_0411 *adr411,int anz);
int adress2detailedStr(char *t,Address *adr,char *permStr);
void initAdrFolderList();
void clearAdrFolderList ();
void extendAdrFolderList();
int readAdrFolderList();
int createDefaultAdrFolderList ( );
int access2AdrFolder(int uid, AddressFolder *adf);
int owner2id(char *name);
char *id2owner(int id,char *t);
int folderName2dirid(char *name);



FileHeader addrFileHeader,addrFolderFileHeader;
char *adrFootPrint=NULL;


void initAdrList()
{
 adrList = new ( Address *) [DATEBLOCKSIZE];
 adrAnz=0;
 adrBlocks=1;
 adrMax = DATEBLOCKSIZE;
 strncpy(addrFileHeader.magic,FILEHEADER_MAGIC,8);
 strncpy(addrFileHeader.type,FILEHEADER_ADDR,4);
 strncpy(addrFileHeader.version,CURRENT_FILEVERSION_ADDR,4);
 addrFileHeader.size =0;
 initAdrFolderList();
}
void clearAdrList ()
{
 delete adrList;
}

void extendAdrList()
{
 Address **tmp;
 int anz,anz0;
 int i;
 
 printf("extending space for addresses\n");

 adrBlocks++;
 anz= adrBlocks * DATEBLOCKSIZE;
 tmp= new ( Address *) [anz];
 adrMax=anz;
 anz0= (adrBlocks-1)  * DATEBLOCKSIZE;

 memcpy(tmp,adrList,anz0*sizeof(Address *));
 delete adrList;
 adrList=tmp;
 for(i=anz0;i<anz; i++)
  adrList[i]=NULL;
}

void initAdrFolderList()
{
 int i;

 adfList = new ( AddressFolder *) [DATEBLOCKSIZE];
 adfAnz=0;
 adfBlocks=1;
 adfMax = DATEBLOCKSIZE;
 strncpy(addrFolderFileHeader.magic,FILEHEADER_MAGIC,8);
 strncpy(addrFolderFileHeader.type,FILEHEADER_ADDF,4);
 strncpy(addrFolderFileHeader.version,CURRENT_FILEVERSION_ADDF,4);
 addrFolderFileHeader.size =0;
 for(i=0;i<adfMax; i++)
  adfList[i]=NULL;
}
void clearAdrFolderList ()
{
 delete adfList;
}
void extendAdrFolderList()
{
 AddressFolder **tmp;
 int anz,anz0;
 int i;
 
 printf("extending space for addresses folders\n");

 adfBlocks++;
 anz= adfBlocks * DATEBLOCKSIZE;
 tmp= new ( AddressFolder *) [anz];
 adfMax=anz;
 anz0= (adfBlocks-1)  * DATEBLOCKSIZE;

 memcpy(tmp,adfList,anz0*sizeof(AddressFolder *));
 delete adfList;
 adfList=tmp;
 for(i=anz0;i<anz; i++)
  adfList[i]=NULL;
}


int updateDateCountsInAddress()
{
 int i,j,idx;
 Date *d;

 for(i=0; i<adrAnz; i++)
  adrList[i]->dateCount =0;

 for(i=0;i<dateAnz; i++)
  {
   d= dateList[i];
   if(d!=NULL)
    for(j=0;j<d->partAnz; j++)
     if(d->part[j].id >=ADDRESOFFSET && d->part[j].id <=MAX_ID)
      {
       idx = aid2idx(d->part[j].id-ADDRESOFFSET);
       //       printf("idx=%d\n",idx);
       if(idx>=0)
	adrList[idx]->dateCount++;
      }
  }
}

int deleteAddresses(int socket,char *str)
{
 char *tp[16384],buffer[8192];
 int aid,uid,anz,i,changed=false;;
 Address *adr;

 anz = split(str,tp,16383);
 uid = uname2uid(tp[0]);

 for(i=1; i<anz; i++)
  {
   aid=atoi(tp[i]);
   adr = adrList[aid2idx(aid)];

   if(adr != NULL)
    {
     if(access2Adr(uid,adr))
      {
       adr->deleted=true;
       changed=true;
      }
     if (adr->deleted)
      {
       char file[1024];
       struct stat fstat;
       sprintf(file,"%s/notiz/Adr%08d.txt",dataDir,adr->id);
       if(stat(file,&fstat)==0)
	unlink(file);
      }
    }
  }
 if(changed)
  writeAdrList();

 
 send2Client(socket,"done");
}

int deleteAddress(int socket,char *str)
{
 char *tp[4],buffer[8192];
 int aid,uid;
 Address *adr;

 split(str,tp,4);
 uid = uname2uid(tp[0]);
 aid=atoi(tp[1]);
 adr = adrList[aid2idx(aid)];

 if(adr != NULL)
  {
   if(access2Adr(uid,adr))
    adr->deleted=true;
   if (adr->deleted)
    {
     char file[1024];
     struct stat fstat;
     sprintf(file,"%s/notiz/Adr%08d.txt",dataDir,adr->id);
     if(stat(file,&fstat)==0)
      unlink(file);
     writeAdrList();
    }
  }
 
 send2Client(socket,"done");
}

int changeAdress(int socket,char *ds)
{
 char *tp[128],*t,*s,buffer[16384];
 int aid,idx,uid;
 Address *adr;

 t=skip2nonWS(ds);
 if(*t!='{' && *t!='"')
  {
   s=buffer+1;
   buffer[0]=' ';
  }
 else
  s=buffer;
 strcpy(s,t);

 split(s,tp,128);

 aid=atoi(tp[0]);
 if(aid<0)
  {
   lastAid++;
   aid=lastAid;
   adr = new Address;
   memset(adr,0,sizeof(Address));
   adrList[adrAnz] = adr;
   adrAnz++;
   if(adrAnz >adrMax)
    extendAdrList();
   adr->id=lastAid;
   adr->dateCount=0;
   adr->notiz=NULL;
   adr->tmp =NULL;

   uid =fillStr2Address(tp,adr);
   adr->created = adr->modified = today;
   adr->creator = adr->modifier = uid;
   adr->deleted = false;
  }
 else
  {
   idx = aid2idx(aid);
   adr =adrList[idx];
   if(!adr->deleted)
    {
     uid = fillStr2Address(tp,adr);
     adr->modified = today;
     adr->modifier = uid;
    }
  }
 sprintf(buffer,"%d",adr->id);
 send2Client(socket,buffer);
 writeAdrList();
}

//Format
// 0     1    2     3      4    5       6      7      8    9    10   11    12   13   14    15    16    17  18   19
// id  namet name1 nameM name2  compS compPos compa  fon0 fon1 fom2 fon3  fon4  fax fax2  mail mail2 mail3 www www2
//
//  20     21    22    23   24    25       26      27  28    29   20       31
//  adr1a adr1b adr1c plz1 city1 country1  adr2a adr2b adr2c plz2 city2 country2  
//
//   32    33    34    35   36     37       38     39     40  41     42
//  ad31a adr3b adr3c plz3 city3 country3  descrS descr info info2  geb 
//
//    43       44     45     46     47      48     49    50      51     52     53      54       55 
//  kontoInh1 -num1 -bank1 -blz1 kontoInh2 -num2 -bank2 -blz2  steuer  owner noteOnly readOnly user
//    
//     56      57      58     59
//   mobile1 mobile2 mobileP faxP 


int fillStr2Address(char *tp[],Address *adr)
{
 int id,i,uid;
 NotizControl *nc;
 void *ptr;


 strcpy(adr->titel       ,strTrim(tp[ 1]));
 strcpy(adr->name1       ,strTrim(tp[ 2]));
 adr->nameM = tp[3][0];
 strcpy(adr->name2       ,strTrim(tp[ 4]));
 strcpy(adr->compShort   ,strTrim(tp[ 5]));
 strcpy(adr->compPos     ,strTrim(tp[ 6]));
 strcpy(adr->company     ,strTrim(tp[ 7]));
 for(i=0;i<5;i++)
  strcpy(adr->fon[i]      ,strTrim(tp[ 8+i]));
 strcpy(adr->fax[0]      ,strTrim(tp[13]));
 strcpy(adr->fax[1]      ,strTrim(tp[14]));
 strcpy(adr->mail[0]     ,strTrim(tp[15]));
 strcpy(adr->mail[1]     ,strTrim(tp[16]));
 strcpy(adr->mail[2]     ,strTrim(tp[17]));
 strcpy(adr->www[0]      ,strTrim(tp[18]));
 strcpy(adr->www[1]      ,strTrim(tp[19]));
 for(i=0;i<3;i++)
  {
   strcpy(adr->adr[i].addres[0],strTrim(tp[20+i*6]));
   strcpy(adr->adr[i].addres[1],strTrim(tp[21+i*6]));
   strcpy(adr->adr[i].addres[2],strTrim(tp[22+i*6]));
   strcpy(adr->adr[i].plz      ,strTrim(tp[23+i*6]));
   strcpy(adr->adr[i].city     ,strTrim(tp[24+i*6]));
   strcpy(adr->adr[i].country  ,strTrim(tp[25+i*6]));
  }
 strcpy(adr->descrShort  ,strTrim(tp[38]));
 strcpy(adr->descr       ,strTrim(tp[39]));
 strcpy(adr->info[0]     ,strTrim(tp[40]));
 strcpy(adr->info[1]     ,strTrim(tp[41]));
 strcpy(adr->geb         ,strTrim(tp[42]));
 strcpy(adr->kontoInh[0] ,strTrim(tp[43]));
 strcpy(adr->kontoNum[0] ,strTrim(tp[44]));
 strcpy(adr->kontoBank[0],strTrim(tp[45]));
 strcpy(adr->kontoBLZ[0] ,strTrim(tp[46]));
 strcpy(adr->kontoInh[1] ,strTrim(tp[47]));
 strcpy(adr->kontoNum[1] ,strTrim(tp[48]));
 strcpy(adr->kontoBank[1],strTrim(tp[49]));
 strcpy(adr->kontoBLZ[1] ,strTrim(tp[50]));
 strcpy(adr->steuer      ,strTrim(tp[51]));

 strcpy(adr->mobile[0]   ,strTrim(tp[56]));
 strcpy(adr->mobile[1]   ,strTrim(tp[57]));
 strcpy(adr->mobile[2]   ,strTrim(tp[58]));
 strcpy(adr->fax[2]      ,strTrim(tp[59]));

 adr->owner    = owner2id(tp[52]);
 adr->noteOnly = owner2id(tp[53]);
 adr->readOnly = owner2id(tp[54]);

 uid =uname2uid(tp[55]);
 if(uid < 0 || uid > userAnz)
  uid=0;
 return(uid);
}

int sendAdrFolderList(int socket,char *str)
{
 char *tp[4],buffer[1024000],txt[8192],owner[64],*perm,*fname;
 int i,uid;

 split(str,tp,4);
 uid = uname2uid(tp[0]);
 if (uid <0 || uid > userAnz)
  {
   send2Client(socket,"no such user");
   return(false);
  }
 if (userList[uid].id  != uid)
  {
   send2Client(socket,"no such user");
   return(false);
  }
 
 strcpy(buffer,"");
 for(i=0;i<adfAnz; i++)
  if(adfList[i] !=NULL)
   if(!adfList[i]->deleted)
    {
     if(access2AdrFolder(uid,adfList[i]))
      perm="rwn";
     else
      perm="r--";
     
     if ( adfList[i]->id == 0 )
      {
       switch (serverLang)
	{
	case  MINKO_LANG_DE:
	 fname = "Adressbuch";
	 break;
	case  MINKO_LANG_EN:
	default:
	 fname = "Address book";
	}
      }
     else
      fname = adfList[i]->name;

     id2owner(adfList[i]->owner,owner);
     sprintf(txt,"{%d {%s} %d {%s} %d {%s}} ",adfList[i]->id,fname,adfList[i]->dirID,owner ,
	     adfList[i]->status &ADRF_START_OPEN,perm );
     strcat(buffer,txt);
    }
 send2Client(socket,buffer);
 return(true);
}

int makeAdrFolder(char *name, int owner, int parent)
{
 int dirid;

 dirid = adfAnz;
 adfAnz++;
 while(adfAnz>adfMax)
  extendAdrFolderList();
 
 adfList[dirid]  = new AddressFolder;
 memset(adfList[dirid],0,sizeof(AddressFolder));
 adfList[dirid]->id = dirid;
 adfList[dirid]->dirID = parent;
 strcpy(adfList[dirid]->name,name);
 adfList[dirid]->deleted =false;
 adfList[dirid]->notiz =NULL;
 adfList[dirid]->owner = owner;
 adfList[dirid]->status = 0;
 writeAdrFolderList();

 return(dirid);
}
// format dirid = makeAdrFolder  uid name owmner parent
int makeAdrFolder(int socket, char *str)
{
 char *tp[8],ret[64];
 int owner,uid,dirid,parent;

 split(str,tp,6);
 uid = uname2uid(tp[0]);
 if (uid <0 || uid > userAnz)
  {
   send2Client(socket,"no such user");
   return(false);
  }
 if (userList[uid].id  != uid)
  {
   send2Client(socket,"no such user");
   return(false);
  }
 
 parent = atoi(tp[3]);
 if(adfList[parent] == NULL)
  {
   send2Client(socket,"Error: parent does not exist\n");
   return(false);
  }
 if(adfList[parent]->deleted)
  {
   send2Client(socket,"Error: parent has been deleted\n");
   return(false);
  }
 
 dirid = makeAdrFolder(tp[1],owner2id(tp[2]),parent);

//  dirid = adfAnz;
//  adfAnz++;
//  while(adfAnz>adfMax)
//   extendAdrFolderList();
 
//  adfList[dirid]  = new AddressFolder;

//  adfList[dirid]->id = dirid;
//  adfList[dirid]->dirID = parent;
//  strcpy(adfList[dirid]->name,tp[1]);
//  adfList[dirid]->deleted =false;
//  adfList[dirid]->notiz =NULL;
//  adfList[dirid]->owner = owner2id(tp[2]);
 
 sprintf(ret,"%d",dirid);
 send2Client(socket,ret);
 return(true);
}


// format  changeAdrFolder   uid dirid name owmner [startClosed]
int changeAdrFolder(int socket, char *str)
{
 char *tp[8];
 int owner,uid,dirid,anz;

 anz =  split(str,tp,6);
 uid = uname2uid(tp[0]);
 if (uid <0 || uid > userAnz)
  {
   send2Client(socket,"no such user");
   return(false);
  }
 if (userList[uid].id  != uid)
  {
   send2Client(socket,"no such user");
   return(false);
  }
 
 dirid = atoi(tp[1]);
 if(adfList[dirid] == NULL)
  {
   send2Client(socket,"Error: folder does not exist\n");
   return(false);
  }
 if(adfList[dirid]->deleted)
  {
   send2Client(socket,"Error: folder has been deleted\n");
   return(false);
  }

 strcpy(adfList[dirid]->name,tp[2]);
 adfList[dirid]->deleted =false;
 adfList[dirid]->owner = owner2id(tp[3]);
 if (anz > 4)
  {
   if(tp[4][0]=='1')
    adfList[dirid]->status |= ADRF_START_OPEN;
   if(tp[4][0]=='0')
    adfList[dirid]->status &= ~ADRF_START_OPEN;
  }
 writeAdrFolderList();
 send2Client(socket,"done");
}
// format moveAdrObjToFolder  uid objtype(dir|adr) obj-id  destDirID
int moveAdrObjToFolder(int socket, char *str)
{
 char *tp[16384];
 int uid,id,idx,destid,i,j,anz;

 anz = split(str,tp,16383);
 uid = uname2uid(tp[0]);
 if (uid <0 || uid > userAnz)
  {
   send2Client(socket,"no such user");
   return(false);
  }
 if (userList[uid].id  != uid)
  {
   send2Client(socket,"no such user");
   return(false);
  }
 

 destid = atoi(tp[1]);
 if(adfList[destid] == NULL)
  {
   send2Client(socket,"Error: dest-folder does not exist\n");
   return(false);
  }
 if(adfList[destid]->deleted)
  {
   send2Client(socket,"Error: dest-folder has been deleted\n");
   return(false);
  }

 for(i=2; i<anz; i+=2)
  {
   if(i+1>=anz)
    break;
   
   id = atoi(tp[i+1]);
   if(strcasecmp(tp[i],"adr")==0)
    {
     idx =aid2idx(id);
     if(idx<0 || idx> adrAnz)
      continue;
     if(adrList[idx]->deleted)
      continue;
     adrList[idx]->dirID=destid;
    }
   else  if(strcasecmp(tp[i],"dir")==0)
    {
     if(adfList[id] == NULL)
      continue;
     if(adfList[id]->deleted)
      continue;
     if ( destid != id)
      adfList[id]->dirID = destid;
     else
      printf("\n\nWARNING: Movbing adrressfolder %d into itself (%d) forbidden\n",id,destid);
    }
   else
    continue;
  }
 writeAdrFolderList();
 writeAdrList();
 send2Client(socket,"done");
}

int deleteAdrFolders (int socket, char *str)
{
 AddressFolder *adf;
 char *tp[16384];
 int uid,dirid,anz,i,changed=false;
 
 anz =split(str,tp,16383);
 uid = uname2uid(tp[0]);
 for(i=1; i<anz; i++)
  {
   dirid=atoi(tp[i]);

   if(adfList[dirid] != NULL)
    if(access2AdrFolder(uid,adfList[dirid]))
     {
      adfList[dirid]->deleted=true;
      changed=true;
     }
  }
 if(changed)
  writeAdrFolderList();
 send2Client(socket,"done");
}

//TCL: delAdrFolder user dirid
int deleteAdrFolder (int socket, char *str)
{
 AddressFolder *adf;
 char *tp[5];
 int uid,dirid;
 
 split(str,tp,4);
 uid = uname2uid(tp[0]);
 dirid=atoi(tp[1]);

 if(adfList[dirid] != NULL)
  if(access2AdrFolder(uid,adfList[dirid]))
   {
    adfList[dirid]->deleted=true;
    writeAdrFolderList();
   }
 send2Client(socket,"done");
}

int readAdrFolderList()
{
 FILE *fp;
 char file[4096],*buffer;
 int i,anz,j;
 struct stat fstat;
 AddressFolder *adf;
 FileHeader fh;
 int modified=false;
 int folderAnz;

 sprintf(file,"%s/addressFolders",dataDir);
 if((i=stat(file,&fstat))<0)
  {
   if(errno == ENOENT)
    {
     fp=fopen(file,"w");
     fclose(fp);
     if(stat(file,&fstat)<0)
      {
       printf("Can't open or create %s\n",file);
       exit(-1);
      }
     createDefaultAdrFolderList();
     writeAdrFolderList();
    }
   else
    {
     char msg[1024];
     perror("");
     printf("Bad file  %s \n",file);
     exit(-1);
    }
  }
 if (fstat.st_size == 0)
  {
   adfAnz =0;
   makeAdrFolder("Addressbuch",-1,-1);
   writeAdrFolderList();
   return(true);
  }
 
 fp=fopen(file,"r");
 if(fp==NULL)
  {
   printf("can't open %s\n",file);
   exit(-1);
  }

 fread(&fh,sizeof(FileHeader),1,fp);

 if(strncmp(fh.magic,FILEHEADER_MAGIC,8) !=0)
  {
   fprintf(stderr,"Error in reading AddressFolders, Format mismatch\n");
   exit(-1);
  }
 else
  {
   if(strncmp(fh.type,FILEHEADER_ADDF,4) !=0)
    {
     printf("address-folder-file structure damaged\n");
     exit(-1);
    }
   if(fh.size>0)
    {
     buffer = new char [fh.size+2];
     fread(buffer,sizeof(char),fh.size,fp);
    }
   if(strncmp(fh.version,CURRENT_FILEVERSION_ADDF,4) ==0)
    {

     adfAnz = (fstat.st_size/sizeof(AddressFolder));
     printf("reading %d addresses  folder (%d)\n",adfAnz,i);
     if(adfAnz==0)
      return(0);
     
     while(adfAnz>adfMax)
      extendAdrFolderList();
     
     adf = new AddressFolder [adfAnz+1];
     fread(adf,sizeof(AddressFolder),adfAnz,fp);
     fclose(fp);
    }
   if(strncmp(fh.version,"0411",4) ==0)
    {
     AddressFolder_0411 *adf_0411;
     adfAnz  = (fstat.st_size/sizeof(AddressFolder_0411));
     printf("reading %d addresses  folder (%d)\n",adfAnz,i);
     if(adfAnz==0)
      return(0);
     
     while(adfAnz>adfMax)
      extendAdrFolderList();
     
     adf_0411 = new AddressFolder_0411 [adfAnz+1];
     adf = new AddressFolder [adfAnz+1];
     fread(adf_0411,sizeof(AddressFolder_0411),adfAnz,fp);
     fclose(fp);
     for(j=0;j<adfAnz; j++)
      {
       memcpy(&adf[j],&adf_0411[j],sizeof(AddressFolder_0411));
       adf[j].status =0;
       memset(adf[j].res,0,64);
      }

    }
  }
 folderAnz=adfAnz;
 for(i=0;i<folderAnz; i++)
  {
   int id = adf[i].id;
   if(id>=adfAnz)
    adfAnz=id+1;
   while(adfAnz>adfMax)
    extendAdrFolderList();
   adfList[id] = adf+i;
   adfList[id]->notiz=NULL;
  }
 if(modified)
  writeAdrFolderList();
}

int writeAdrFolderList()
{
 FILE *fp;
 char file[4096];
 int i;

 sprintf(file,"%s/addressFolders",dataDir);
 fp=fopen(file,"w");
 if(fp==NULL)
  {
   printf("can't open %s\n",file);
   exit(-1);
  }
 fwrite(&addrFolderFileHeader,sizeof(FileHeader),1,fp);
 for(i=0;i<adfAnz; i++)
  if(adfList[i]!=NULL)
   if(! adfList[i]->deleted)
    fwrite(adfList[i],sizeof(AddressFolder),1,fp);

 fclose(fp);
}
int createDefaultAdrFolderList ( ) 
{
 
 adfList[0]  = new AddressFolder;

 adfList[0]->id =0;
 adfList[0]->dirID = -1;
 strcpy(adfList[0]->name,"Addressbuch");
 adfList[0]->deleted =false;
 adfList[0]->notiz =NULL;
 adfList[0]->owner =-1;
 adfAnz=1;
}

int readAdrList()
{
 FILE *fp;
 char file[4096],*buffer;
 int i,anz,j;
 struct stat fstat;
 Address *adr;
 FileHeader fh;
 int modified=false;

 
 readAdrFolderList();

 sprintf(file,"%s/address",dataDir);
 if((i=stat(file,&fstat))<0)
  {
   if(errno == ENOENT)
    {
     fp=fopen(file,"w");
     fwrite(&addrFileHeader,sizeof(FileHeader),1,fp);
     fclose(fp);
     if(stat(file,&fstat)<0)
      {
       printf("Can't open or create %s\n",file);
       exit(-1);
      }
    }
   else
    {
     char msg[1024];
     perror("");
     printf("Bad file  %s \n",file);
     exit(-1);
    }
  }
 if (fstat.st_size == 0)
  {
   adrAnz =0;
   writeAdrList();
   return(true);
  }
 
 fp=fopen(file,"r");
 if(fp==NULL)
  {
   printf("can't open %s\n",file);
   exit(-1);
  }

 fread(&fh,sizeof(FileHeader),1,fp);

 if(strncmp(fh.magic,FILEHEADER_MAGIC,8) !=0)
  {
   Address_0410 *adr410;
   rewind(fp);
   adrAnz = (fstat.st_size/sizeof(Address));
   printf("reading %d addresses (%d)\n",adrAnz,i);
   if(adrAnz==0)
    return(0);
   
   while(adrAnz>adrMax)
    extendAdrList();
   
   adr410 =  new Address_0410 [adrAnz+1];
   adr    =  new Address [adrAnz+1];
   fread(adr410,sizeof(Address_0410),adrAnz,fp);
   fclose(fp);
   convertAdress0410(adr,adr410,adrAnz);
   modified=true;
  }
 else
  {
   if(strncmp(fh.type,FILEHEADER_ADDR,4) !=0)
    {
     printf("address-file structure damaged\n");
     exit(-1);
    }
   if(fh.size>0)
    {
     buffer = new char [fh.size+2];
     fread(buffer,sizeof(char),fh.size,fp);
     printf("extra header read (%d)\n",fh.size);
     serverAddrID = new char[12];
     strncpy(serverAddrID,buffer,11);
     serverAddrID[11]='\0';
    }
   if(strncmp(fh.version,CURRENT_FILEVERSION_ADDR,4) ==0)
    {

     adrAnz = (fstat.st_size/sizeof(Address));
     printf("reading %d addresses (%d)\n",adrAnz,i);
     if(adrAnz==0)
      return(0);
     
     while(adrAnz>adrMax)
      extendAdrList();
     
     adr = new Address [adrAnz+1];
     fread(adr,sizeof(Address),adrAnz,fp);
     fclose(fp);
    }
   else if(strncmp(fh.version,"0411",4) ==0)
    {
     Address_0411 *adr411;
     adrAnz = (fstat.st_size/sizeof(Address_0410));
     printf("reading %d addresses (%d)\n",adrAnz,i);
     if(adrAnz==0)
      return(0);
     
     while(adrAnz>adrMax)
      extendAdrList();
     
     adr411 =  new Address_0411 [adrAnz+1];
     adr    =  new Address [adrAnz+1];
     fread(adr411,sizeof(Address_0411),adrAnz,fp);
     fclose(fp);
     convertAdress0411(adr,adr411,adrAnz);
     modified=true;
    }
   else if(strncmp(fh.version,"0410",4) ==0)
    {
     Address_0410 *adr410;
     adrAnz = (fstat.st_size/sizeof(Address_0410));
     printf("reading %d addresses (%d)\n",adrAnz,i);
     if(adrAnz==0)
      return(0);
     
     while(adrAnz>adrMax)
      extendAdrList();
     
     adr410 =  new Address_0410 [adrAnz+1];
     adr    =  new Address [adrAnz+1];
     fread(adr410,sizeof(Address_0410),adrAnz,fp);
     fclose(fp);
     convertAdress0410(adr,adr410,adrAnz);
     modified=true;
    }
   
  }

 Address *empty = new Address;
 bzero(empty,sizeof(Address));

 lastAid=-1;
 for(i=0;i<adrAnz; i++)
  {
   char tmp[256];
   adrList[i] = adr+i;
   if(memcmp(adrList[i],empty,sizeof(Address)) == 0)
    {
     printf("removing address on index %d from addressList\n",i);
     adrList[i]->deleted = true;
     modified=true;
     continue;
    }
   adrList[i]->notiz=NULL;
   adrList[i]->tmp = NULL;
   if(adrList[i]->id>lastAid)
    lastAid = adrList[i]->id;
   // zero out fields for temp-sync struct
   for(j=0;j<5; j++)
    strTrim(adr->fon[j]);
   for(j=0;j<3; j++)
    {
     strTrim(adr->mobile[j]);
     strTrim(adr->mail[j]);
     strTrim(adr->fax[j]);
     strTrim(adr->adr[j].addres[0]);
     strTrim(adr->adr[j].addres[1]);
     strTrim(adr->adr[j].addres[2]);
     strTrim(adr->adr[j].plz);
     strTrim(adr->adr[j].city);
     strTrim(adr->adr[j].country);
    }
  }


 if(serverAddrID==NULL)
  {
   serverAddrID = new char[12];
   makeServerID(serverAddrID);
   printf("new server address created\n");
   modified=true;
  }
 if(modified)
  writeAdrList();
 printf("serverAddrID=%s\n",serverAddrID);
}

void convertAdress0410(Address*adr, Address_0410 *adr410,int anz)
{
 int i;
 for( i=0 ;i<anz; i++)
  {
   adr[i].id      = adr410[i].id;
   adr[i].owner   = adr410[i].owner;
   adr[i].deleted = false;
   strcpy( adr[i].titel     ,adr410[i].titel      );
   strcpy( adr[i].name1     ,adr410[i].name1      );
   strcpy( adr[i].name2     ,adr410[i].name2      );
   strcpy( adr[i].compShort ,adr410[i].compShort  );
   strcpy( adr[i].company   ,adr410[i].company    );
   strcpy( adr[i].adr[0].addres[0]  ,adr410[i].addres[0]    );
   strcpy( adr[i].adr[0].addres[1]  ,adr410[i].addres[1]    );
   strcpy( adr[i].adr[0].addres[2]  ,adr410[i].addres[2]    );
   strcpy( adr[i].adr[0].city       ,adr410[i].addres[3]    );
   strcpy( adr[i].adr[0].country    ,adr410[i].addres[4]    );
   strcpy( adr[i].fon[0]    ,adr410[i].fon[0]     );
   strcpy( adr[i].fon[4]    ,adr410[i].fon[1]     );
   strcpy( adr[i].fax[0]    ,adr410[i].fax        );
   strcpy( adr[i].mail[0]   ,adr410[i].mail       );
   strcpy( adr[i].www[0]    ,adr410[i].www        );
   strcpy( adr[i].descrShort,adr410[i].descrShort );
   strcpy( adr[i].descr     ,adr410[i].descr      );

   adr[i].nameM = ' ';
   strcpy(adr[i].compPos     ,"");
   strcpy(adr[i].adr[0].plz      ,"");
   strcpy(adr[i].adr[1].addres[0] ,"");
   strcpy(adr[i].adr[1].addres[2] ,"");
   strcpy(adr[i].adr[1].addres[3] ,"");
   strcpy(adr[i].adr[1].plz      ,"");
   strcpy(adr[i].adr[1].city     ,"");
   strcpy(adr[i].adr[1].country  ,"");
   strcpy(adr[i].adr[2].addres[0] ,"");
   strcpy(adr[i].adr[2].addres[2] ,"");
   strcpy(adr[i].adr[2].addres[3] ,"");
   strcpy(adr[i].adr[2].plz      ,"");
   strcpy(adr[i].adr[2].city     ,"");
   strcpy(adr[i].adr[2].country  ,"");
   strcpy(adr[i].fon[1]      ,"");
   strcpy(adr[i].fon[2]      ,"");
   strcpy(adr[i].fon[3]      ,"");
   strcpy(adr[i].fax[1]      ,"");
   strcpy(adr[i].fax[2]      ,"");
   strcpy(adr[i].mobile[0]   ,"");
   strcpy(adr[i].mobile[1]   ,"");
   strcpy(adr[i].mobile[2]   ,"");
   strcpy(adr[i].mail[1]     ,"");
   strcpy(adr[i].mail[2]     ,"");
   strcpy(adr[i].www[1]      ,"");
   strcpy(adr[i].info[0]     ,"");
   strcpy(adr[i].info[1]     ,"");
   strcpy(adr[i].kontoInh[0] ,"");
   strcpy(adr[i].kontoNum[0] ,"");
   strcpy(adr[i].kontoBank[0],"");
   strcpy(adr[i].kontoBLZ[0] ,"");
   strcpy(adr[i].kontoInh[1] ,"");
   strcpy(adr[i].kontoNum[1] ,"");
   strcpy(adr[i].kontoBank[1],"");
   strcpy(adr[i].kontoBLZ[1] ,"");
   strcpy(adr[i].steuer      ,"");
   strcpy(adr[i].geb         ,"");
   adr[i].noteOnly  = adr[i].owner;
   adr[i].readOnly  = adr[i].owner;
   adr[i].dirID     = 0;
   adr[i].created   = 20011231;
   adr[i].modified  = 20011231;
   adr[i].creator   = 0;
   adr[i].modifier  = 0;
   memset(adr[i].reserved,0,sizeof(char)*256);
   memset(adr[i].resv,0,sizeof(int)*8);
   adr[i].action =NULL;
   adr[i].tmp = NULL;
  }
}
void convertAdress0411(Address*adr, Address_0411 *adr411,int anz)
{
 int i,j;
 for( i=0 ;i<anz; i++)
  {
   adr[i].id      = adr411[i].id;
   adr[i].owner   = adr411[i].owner;
   adr[i].deleted = false;
   strcpy( adr[i].titel     ,adr411[i].titel      );
   strcpy( adr[i].name1     ,adr411[i].name1      );
   adr[i].nameM            = adr411[i].nameM;
   strcpy( adr[i].name2     ,adr411[i].name2      );
   strcpy( adr[i].compShort ,adr411[i].compShort  );
   strcpy( adr[i].company   ,adr411[i].company    );
   strcpy( adr[i].compPos   ,adr411[i].compPos    );
   for(j=0;j<3; j++)
    {
     strcpy( adr[i].adr[j].addres[0]  ,adr411[i].addres[j][0]    );
     strcpy( adr[i].adr[j].addres[1]  ,adr411[i].addres[j][1]    );
     strcpy( adr[i].adr[j].addres[2]  ,adr411[i].addres[j][2]    );
     strcpy( adr[i].adr[j].city       ,adr411[i].city[j]         );
     strcpy( adr[i].adr[j].plz        ,adr411[i].plz[j]          );
     strcpy( adr[i].adr[j].country    ,adr411[i].country[j]      );
    }
   strcpy( adr[i].fon[0]    ,adr411[i].fon[0]     );
   strcpy( adr[i].fon[1]    ,adr411[i].fon[1]     );
   strcpy( adr[i].fon[2]    ,""                   );
   strcpy( adr[i].fon[3]    ,adr411[i].fon[3]     );
   strcpy( adr[i].fon[4]    ,adr411[i].fon[4]     );
   strcpy( adr[i].mobile[0] ,adr411[i].fon[2]     );
   strcpy( adr[i].mobile[1] ,""                   );
   strcpy( adr[i].mobile[2] ,""                   );
   strcpy( adr[i].fax[0]    ,adr411[i].fax[0]     );
   strcpy( adr[i].fax[1]    ,""                   );
   strcpy( adr[i].fax[2]    ,adr411[i].fax[1]     );
   strcpy( adr[i].mail[0]   ,adr411[i].mail[0]    );
   strcpy( adr[i].mail[1]   ,adr411[i].mail[1]    );
   strcpy( adr[i].mail[2]   ,adr411[i].mail[2]    );
   strcpy( adr[i].www[0]    ,adr411[i].www[0]     );
   strcpy( adr[i].www[1]    ,adr411[i].www[1]     );
   strcpy(adr[i].kontoInh[0] ,adr411[i].kontoInh[0]);
   strcpy(adr[i].kontoNum[0] ,adr411[i].kontoNum[0]);
   strcpy(adr[i].kontoBank[0],adr411[i].kontoBank[0]);
   strcpy(adr[i].kontoBLZ[0] ,adr411[i].kontoBLZ[0]);
   strcpy(adr[i].kontoInh[1] ,adr411[i].kontoInh[1]);
   strcpy(adr[i].kontoNum[1] ,adr411[i].kontoNum[1]);
   strcpy(adr[i].kontoBank[1],adr411[i].kontoBank[1]);
   strcpy(adr[i].kontoBLZ[1] ,adr411[i].kontoBLZ[1]);
   strcpy(adr[i].steuer      ,adr411[i].steuer);
   strcpy(adr[i].geb         ,adr411[i].geb);
   strcpy(adr[i].info[0]     ,adr411[i].info[0]);
   strcpy(adr[i].info[1]     ,adr411[i].info[1]);
   strcpy( adr[i].descrShort,adr411[i].descrShort );
   strcpy( adr[i].descr     ,adr411[i].descr      );


   adr[i].owner     = adr411[i].owner;
   adr[i].noteOnly  = adr411[i].noteOnly;
   adr[i].readOnly  = adr411[i].readOnly;
   adr[i].deleted   = adr411[i].deleted;
   adr[i].dateCount = adr411[i].dateCount;
   adr[i].dirID     = adr411[i].dirID;
   adr[i].created   = adr411[i].created;
   adr[i].modified  = adr411[i].modified ;
   adr[i].creator   = adr411[i].creator;
   adr[i].modifier  = adr411[i].modifier;
   memset(adr[i].reserved,0,sizeof(char)*256);
   memset(adr[i].resv,0,sizeof(int)*8);
   adr[i].action =NULL;
   adr[i].tmp = NULL;
  }
}
int writeAdrList()
{
 FILE *fp;
 char file[4096];
 int i;

 if(serverAddrID==NULL)
  {
   serverAddrID = new char[12];
   makeServerID(serverAddrID);
   printf("new server address created\n");
  }


 sprintf(file,"%s/address",dataDir);
 fp=fopen(file,"w");
 if(fp==NULL)
  {
   printf("can't open %s\n",file);
   exit(-1);
  }
 addrFileHeader.size =12;
 fwrite(&addrFileHeader,sizeof(FileHeader),1,fp);
 fwrite(serverAddrID,sizeof(char),12,fp);
 for(i=0;i<adrAnz; i++)
  if(adrList[i]!=NULL)
   if(! adrList[i]->deleted)
    fwrite(adrList[i],sizeof(Address),1,fp);

 fclose(fp);
}

int sendBriefAdressList(int socket,char *str)
{ 
 int uid,i,perm,gid,j;
 char buffer[250000],txt[128];
 char *tp[4];

 split (str,tp,4);
 uid = uname2uid(tp[0]);
 briefAdressList(uid,buffer);
 send2Client(socket,buffer);
}

char *briefAdressList(int uid, char *buffer)
{
 int i;
 char txt[128];

 strcpy(buffer,"");
 for(i=0;i<adrAnz; i++)
  {
   if(readAccess2Adr(uid,adrList[i]))
    {
     adrIdx2cname(i,txt);
     strcat(buffer,txt);
    }
  }

}
int sendAddresssList(int socket,char *str)
{
 char *tp[4],buffer[1024000],txt[8192],adrPrmStr[16];
 int i,uid;

 split(str,tp,4);
 uid = uname2uid(tp[0]);
 // uid=atoi(tp[0]);
 
 strcpy(buffer,"");
 for(i=0;i<adrAnz; i++)
  if(access2Adr(uid,adrList[i],adrPrmStr))
   {
    txt[0]='{';
    adress2str(txt+1,adrList[i],adrPrmStr);
    strcat(txt,"} ");
    strcat(buffer,txt);
   }

 send2Client(socket,buffer);
}
int sendAddress(int socket,char *str)  // request 
{
 char *tp[4],buffer[4096], adrPrmStr[16];
 int aid,uid,i,anz;
 Address *adr;

 split(str,tp,4);
 uid = uname2uid(tp[0]);
 // uid=atoi(tp[0]);
 aid=atoi(tp[1]);
 adr = adrList[aid2idx(aid)];

 if(access2Adr(uid,adr,adrPrmStr))
  adress2str(buffer,adr,adrPrmStr);
 
 send2Client(socket,buffer);

}

// Syntax getFullAddr username {aid-list} 
//     or getFullAddr username aid
int sendFullAddress(int socket,char *str)  // request 
{
 char *tp[4],*tp2[1024],buf[4096],adrPrmStr[16],*buffer;
 int aid,uid,anz,i;
 Address *adr;

 split(str,tp,4);
 uid = uname2uid(tp[0]);
 anz  = split(tp[1],tp2,1024);
 if ( anz ==0  )
  {
   sprintf(buf,"Error: no address requested");
   send2Client(socket,buf);
   return(0);
  }

 printf("%d : %s\n",anz,tp2[0]);
 buffer = new char [4086*anz];
 if (buffer == NULL) 
  {
   sprintf(buf,"Error: no memory on server");
   send2Client(socket,buf);
   return(0);
  }
 buffer[0]='\0';
 // uid=atoi(tp[0]);
 for(i=0;i<anz; i++)
  {
   aid=atoi(tp2[i]);
   adr = adrList[aid2idx(aid)];

   if(access2Adr(uid,adr,adrPrmStr) )
    adress2detailedStr(buf,adr,adrPrmStr);
   else
    {
     if(verbose)
      printf("no access for %s to aid=%d\n",tp[0],aid);
    }
   if (anz>1)
    strcat(buffer,"{");
   strcat(buffer,buf);
   if (anz>1)
    strcat(buffer,"} ");
  }
 if ( buffer[0] == '\0' )
  sprintf(buffer,"Error: no access");

 
 send2Client(socket,buffer);
 printf("removing memory\n");
 delete buffer;
}


//Format
// 0     1    2     3      4    5       6      7      8    9    10     11    12   13   14   
// id  namet name1 nameM name2  compS compPos compa  fon0 fon1 mobile0 fax   mail mail2 www  
//
//   15    16   17  18  19    20      21     22     23       24      25     26     27
//  adr1 adr2 adr3 plz city country descrS  owner noteOnly readOnly status dirID  rwn
int adress2str(char *t,Address *adr,char *adrPrmStr)
{
 char owner[32],noteOnly[32],readOnly[32],mi;
 int status=0;

 id2owner(adr->owner,owner);
 id2owner(adr->noteOnly,noteOnly);
 id2owner(adr->readOnly,readOnly);


 if(adr->dateCount>0)
  status=1;
 if (adr->nameM == '\0')
  mi =' ';
 else
  mi = adr->nameM;
 sprintf(t,"%d   {%s} {%s} {%c} {%s}   {%s} {%s} {%s}   {%s} {%s} {%s} {%s}   {%s} {%s} {%s}   {%s} {%s} {%s} {%s} {%s} {%s}   {%s}   {%s} {%s} {%s}  %d %d {%s}",
	 adr->id,adr->titel,adr->name1,mi,adr->name2,
	 adr->compShort,adr->compPos,adr->company, adr->fon[0],adr->fon[1],adr->mobile[0],adr->fax[0],
	 adr->mail[0],adr->mail[1],adr->www[0],   
	 adr->adr[0].addres[0],adr->adr[0].addres[1],adr->adr[0].addres[2],
	 adr->adr[0].plz,      adr->adr[0].city,     adr->adr[0].country,
	 adr->descr,owner,noteOnly,readOnly,status,adr->dirID,adrPrmStr);
 //rintf("adr %d -> %s\n",adr->id,t);
}
//Format
// 0     1    2     3      4    5       6      7      8    9    10   11    12   13   14    15    16    17  18   19
// id  namet name1 nameM name2  compS compPos compa  fon0 fon1 fom2 fon3  fon4  fax fax2  mail mail2 mail3 www www2
//
//  20     21    22    23   24    25       26      27  28    29   30       31
//  adr1a adr1b adr1c plz1 city1 country1  adr2a adr2b adr2c plz2 city2 country2  
//
//   32    33    34    35   36     37       38     39     40  41     42
//  ad31a adr3b adr3c plz3 city3 country3  descrS descr info info2  geb 
//
//    43       44     45     46     47      48     49    50      51     52     53      54       55    
//  kontoInh1 -num1 -bank1 -blz1 kontoInh2 -num2 -bank2 -blz2  steuer  owner noteOnly readOnly status 
//
//    56      57     58      59        60     61    62    63       64      65
//  created modified creator modifier dirID  rwn mobile0 mobile1 mobile2 faxP
int adress2detailedStr(char *t,Address *adr,char *adrPrmStr)
{
 char owner[32],noteOnly[32],readOnly[32],mi;
 int status=0;

 id2owner(adr->owner,owner);
 id2owner(adr->noteOnly,noteOnly);
 id2owner(adr->readOnly,readOnly);


 if(adr->dateCount>0)
  status=1;

 if (adr->nameM == '\0')
  mi =' ';
 else
  mi = adr->nameM;
 sprintf(t,"%d {%s} {%s} {%c} {%s}   {%s} {%s} {%s}     {%s} {%s} {%s} {%s} {%s} {%s} {%s}    {%s} {%s} {%s} {%s} {%s}     {%s} {%s} {%s} {%s} {%s} {%s}  {%s} {%s} {%s} {%s} {%s} {%s}  {%s} {%s} {%s} {%s} {%s} {%s}    {%s} {%s} {%s} {%s}    {%s}    {%s} {%s} {%s} {%s}   {%s} {%s} {%s} {%s}    {%s}   {%s} {%s} {%s}   %d %d %d {%s} {%s} %d   {%s}  {%s} {%s} {%s} {%s}",
	 adr->id,adr->titel,adr->name1,mi,adr->name2,
	 adr->compShort,adr->compPos,adr->company, 
	 adr->fon[0],adr->fon[1],adr->fon[2],adr->fon[3],adr->fon[4],adr->fax[0],adr->fax[1],
	 adr->mail[0],adr->mail[1],adr->mail[2],adr->www[0], adr->www[1],   
	 adr->adr[0].addres[0],adr->adr[0].addres[1],adr->adr[0].addres[2],
	 adr->adr[0].plz,      adr->adr[0].city,     adr->adr[0].country,
	 adr->adr[1].addres[0],adr->adr[1].addres[1],adr->adr[2].addres[2],
	 adr->adr[1].plz,      adr->adr[1].city,     adr->adr[1].country,
	 adr->adr[2].addres[0],adr->adr[2].addres[1],adr->adr[2].addres[2],
	 adr->adr[2].plz,      adr->adr[2].city,     adr->adr[2].country,
	 adr->descrShort,adr->descr, adr->info[0],adr->info[1],adr->geb,
	 adr->kontoInh[0],adr->kontoNum[0],adr->kontoBank[0],adr->kontoBLZ[0],
	 adr->kontoInh[1],adr->kontoNum[1],adr->kontoBank[1],adr->kontoBLZ[1],adr->steuer,
	 owner,noteOnly,readOnly,status,adr->created,adr->modified,
	 userList[adr->creator].name, userList[adr->modifier].name,adr->dirID,adrPrmStr,
	 adr->mobile[0],adr->mobile[1],adr->mobile[2],adr->fax[2]);
 return(true);
}


int access2Adr(int uid, Address *adr)
{
 int perm,j,gid,i;
 
 if(adr->deleted)
  return(false);



 perm=false;

 if(uid==0)
  return(true);

 if(adr->owner == -1)
  perm=true;
 else if(adr->owner >=GROUPOFFSET)
  {
   gid = adr->owner -GROUPOFFSET;
   for(j=0;groupList[gid].anz; j++)
    if(groupList[gid].membr[j] == uid)
     {
      perm=true;
      break;
     }
  }
 else if(adr->owner == uid)
  perm=true;

 for(i=0;groupList[0].anz; i++)
  if(groupList[0].membr[i] == uid)
   return(true);

 return(perm);
}

int readAccess2Adr(int uid, Address *adr)
{
 int perm=false,j,gid;

 
 if(adr->deleted)
  return(false);

 perm=false;
 if(adr->owner == -1 || adr->noteOnly == -1 || adr->readOnly == -1)
  {
   perm=true;
  }
 else if(adr->owner == uid || adr->noteOnly == uid || adr->readOnly == uid)
  {
   perm=true;
   
  }
 if(!perm)
  if(adr->owner >=GROUPOFFSET)
   {
    gid = adr->owner -GROUPOFFSET;
    for(j=0;j<groupList[gid].anz; j++)
     if(groupList[gid].membr[j] == uid)
      {
       perm=true;
       break;
      }
   }
 if(!perm)
  if(adr->noteOnly >=GROUPOFFSET)
   {
    gid = adr->noteOnly -GROUPOFFSET;
    for(j=0;j<groupList[gid].anz; j++)
     if(groupList[gid].membr[j] == uid)
      {
       perm=true;
       break;
      }
   }
 if(!perm)
  if(adr->noteOnly >=GROUPOFFSET)
   {
    gid = adr->noteOnly -GROUPOFFSET;
    for(j=0;j<groupList[gid].anz; j++)
     if(groupList[gid].membr[j] == uid)
      {
       perm=true;
       break;
      }
   }
 return(perm);
}

int access2Adr(int uid, Address *adr, char *adrPrmStr)
{
 int perm=false,j,gid;

 strcpy(adrPrmStr,"");
 
 if(adr->deleted)
  return(false);

 perm=false;
 if(adr->owner == -1)
  {
   strcpy(adrPrmStr,"rwn");
   perm=true;
  }
 else if(adr->owner >=GROUPOFFSET)
  {
   gid = adr->owner -GROUPOFFSET;
   for(j=0;j<groupList[gid].anz; j++)
    if(groupList[gid].membr[j] == uid)
     {
      strcpy(adrPrmStr,"rwn");
      perm=true;
      break;
     }
  }
 else if(adr->owner == uid)
  {
   strcpy(adrPrmStr,"rwn");
   perm=true;
  }
 
 if(perm)
  return(perm);

 if(adr->noteOnly == -1)
  {
   strcpy(adrPrmStr,"r-n");
   perm=true;
  }
 else if(adr->noteOnly >=GROUPOFFSET)
  {
   gid = adr->noteOnly -GROUPOFFSET;
   for(j=0;j<groupList[gid].anz; j++)
    if(groupList[gid].membr[j] == uid)
     {
      strcpy(adrPrmStr,"r-n");
      perm=true;
      break;
     }
  }
 else if(adr->noteOnly == uid)
  {
   strcpy(adrPrmStr,"r-n");
   perm=true;
  }

 if(perm)
  return(perm);

 if(adr->readOnly == -1)
  {
   strcpy(adrPrmStr,"r--");
   perm=true;
  }
 else if(adr->readOnly >=GROUPOFFSET)
  {
   gid = adr->readOnly -GROUPOFFSET;
   for(j=0;j<groupList[gid].anz; j++)
    if(groupList[gid].membr[j] == uid)
     {
      strcpy(adrPrmStr,"r--");
      perm=true;
      break;
     }
  }
 else if(adr->readOnly == uid)
  {
   strcpy(adrPrmStr,"r--");
   perm=true;
  }
 
 return(perm);
}

int access2AdrFolder(int uid, AddressFolder *adf)
{
 int perm,j,gid,i;
 
 if(adf->deleted)
  return(false);

 if(uid==0)
  return true;


 perm=false;
 if(adf->owner == -1)
  perm=true;
 else if(adf->owner >=GROUPOFFSET)
  {
   gid = adf->owner -GROUPOFFSET;
   for(j=0;j<groupList[gid].anz; j++)
    if(groupList[gid].membr[j] == uid)
     {
      perm=true;
      break;
     }
  }
 else if(adf->owner == uid)
  perm=true;

 for(i=0;groupList[0].anz; i++)
  if(groupList[0].membr[i] == uid)
   return(true);

 return(perm);
}



void unblockAllAdrFolders()
{
 int i;
 for(i=0;i<adfAnz; i++)
  if(adfList[i] !=NULL)
   if(!adfList[i]->deleted)
    adfList[i]->blocked =false;
}
void blockFolder(int dirid)
{
 adfList[dirid]->blocked = true;
}
void blockFoldersInBlockedFolders()
{
 int changes =1;
 int parent;
 int i;

 while (changes >0)
  {
   changes =0;
   for(i=1;i<adfAnz; i++)
    if(adfList[i] !=NULL)
     if(!adfList[i]->deleted)
      {
       parent = adfList[i]->dirID;
       if(adfList[parent]->blocked)
	{
	 changes++;
	 adfList[i]->blocked = true;
	}
      }
  }
}

void blockAdrInBlockedFolders()
{
 int parent;

 for(int i=0;i<adrAnz; i++)
  if(adrList[i] !=NULL)
   if(!adrList[i]->deleted)
    {
     parent = adrList[i]->dirID;
     if(adfList[parent]->blocked)
      adrList[i]->blocked = true;
    }
}


int aname2aid(char *name)
{
 int i=-1;
 char cname[256];

 for(i=0; i<adrAnz; i++)
  {
   adrIdx2name(i,cname);
   printf("cname='%s' name='%s'\n",cname,name);
   if(strcmp(name,cname)==0)
    return(adrList[i]->id);
  }
 return(-1);
}

int aname2idx(char *name)
{
 int i;
 char cname[256];

 for(i=0; i<adrAnz; i++)
  {
   adrIdx2name(i,cname);
   if(strcmp(name,cname)==0)
    return(i);
  }
 return(-1);
}

int aid2idx(int aid)
{
 int i=-1;
 for(i=0;i<adrAnz; i++)
  if(adrList[i]->id==aid)
   return(i);
 return(-1);
}

char * aid2name(int aid,char *t)
{
 Address *adr;
 int idx;

 idx =aid2idx(aid);
 if(idx<0)
   strcpy(t,"?? adress unknown ??");
 else
  {
   adr= adrList[idx];
   
   if(adr->titel[0] == '\0')
    sprintf(t,"%s %s",adr->name1,adr->name2);
   else
    sprintf(t,"%s %s %s",adr->titel,adr->name1,adr->name2);
  }
 return(t);
}
char * adrIdx2name(int idx,char *t)
{
 Address *adr;

 if(idx<0)
  strcpy(t,"?? adress unknown ??");
 else 
  {
   adr= adrList[idx];
   
   if(adr->titel[0] == '\0')
    sprintf(t,"%s %s",adr->name1,adr->name2);
   else
    sprintf(t,"%s %s %s",adr->titel,adr->name1,adr->name2);
  }
 return(t);
}
char * aid2cname(int aid,char *t)
{
 int idx;
 char tx[256];

 idx =aid2idx(aid);
 sprintf(t,"{%s} ",adrIdx2name(idx,tx));
 return(t);
}
char * adrIdx2cname(int idx,char *t)
{
 char tx[256];

 sprintf(t,"{%s} ",adrIdx2name(idx,tx));
 return(t);
}


int  owner2id(char *name)
{
 int id=-1;
 
 if(strcmp(name,"Allgemein")==0)
  id=-1;
 else
  {
   id=uname2uid(name);
   if(id>=0)
    id=id;
   else
    {
     id=gname2gid(name);
     if(id>=0)
      id=id+GROUPOFFSET;
     else
      id=-1;
    }
  }
 return (id);
}

char *id2owner(int id,char *t)
{
 if(id <0)
  strcpy(t,"Allgemein");
 else if(id >=GROUPOFFSET)
  strcpy(t,groupList[id-GROUPOFFSET].name);
 else
  strcpy(t,userList[id].name);
 return(t);
}


int folderName2dirid(char *name)
{
 int i;
 for(i=0;i<adfAnz;i++)
  if(adfList[i]!=NULL)
   if(!adfList[i]->deleted)
    if(strcmp(adfList[i]->name,name)==0)
     return(adfList[i]->id);
 return(-1);
}


//////////////////////////////
// NOTIZ                    //
//////////////////////////////
int readNotiz(AddressFolder *adf)
{
 FILE *fp;
 char file[1024];
 struct stat fstat;

 if(adf->notiz == NULL)
  adf->notiz= initNotizList(adf->id,FOLDER_NOTIZ);

 sprintf(file,"%s/notiz/Dir%08d.txt",dataDir,adf->id);
 if(stat(file,&fstat)<0)
  return(false);
 
 fp=fopen(file,"r");
 if(fp==NULL)
  {
   printf("can't open %s\n",file);
   return(false);
  }

 readNotiz(fp,adf->notiz);
 fclose(fp);
 return(true); 
}
int readNotiz(FILE *fp,NotizControl *nc)
{
 char line[4096],*tp[64];
 int count=0,i;
 int nid;
 Notiz *ntz;
 char *buffer,*tmp;
 int bufferLen;
 int textLen,len;

 while (fgets(line,4095,fp) !=NULL)
  {
   if(strncmp(line,"%$NOTIZ",7)==0)
    count ++;
  }
 rewind(fp);
 while(count >=nc->max)
  extendNotizList(nc);

 buffer=new char [65536];
 bufferLen=65536;

 printf("\t\treading %d notizen\n",count);
 for(i=0;i<count; i++)
  {
   if(fgets(line,4095,fp)!=NULL)
    {
     split(line,tp,64);
     nid = atoi(tp[1]);
     if(nid <= nc->anz)
      nc->anz = nid +1;
     if(nc->anz >= nc->max)
      extendNotizList(nc);
     ntz = &nc->notiz[nid];
     ntz->id =nid;
     ntz->parent= atoi(tp[2]);
     ntz->uid   = uname2uid(tp[3]);
     ntz->date  = atoi(tp[4]);
     ntz->time  = atoi(tp[5]);
     ntz->title = new char [strlen(tp[6]) +4];
     strcpy(ntz->title,tp[6]);
     textLen=0;
     strcpy(buffer,"");

     for(;;)
      {
       if(fgets(line,4095,fp)!=NULL)
	{
	 if(strncmp(line,"%$END",5)==0)
	  {
	   break;
	  }
	 else
	  {
	   len = strlen(line);
	   while(len+textLen > bufferLen)
	    {
	     tmp = new char [bufferLen +65536];
	     strcpy(tmp,buffer);
	     delete buffer;
	     buffer =tmp;
	     bufferLen += 65536;
	    }
	   strcat(buffer,line);
	   textLen += len+1;
	  }
	}
      }
     ntz->text = new char [ strlen(buffer)+4];
     strcpy(ntz->text,buffer);
     ntz->status = NOTIZ_FILLED;
    }
  }
}
int writeNotiz(Address *adr)
{
 char file[1024];
 FILE *fp;

 printf("writing Notiz : %p\n",adr->notiz);
 if(adr->notiz == NULL)
  return(true);
 
 sprintf(file,"%s/notiz/Adr%08d.txt",dataDir,adr->id);
 fp=fopen(file,"w");
 if(fp==NULL)
  {
   printf("can't open %s\n",file);
   delete adr->notiz;
   adr->notiz=NULL;
   return(false);
  }
 writeNotiz(fp,adr->notiz);
 fclose(fp);
}
int writeNotiz(AddressFolder *adf)
{
 char file[1024];
 FILE *fp;

 printf("writing Notiz : %p\n",adf->notiz);
 if(adf->notiz == NULL)
  return(true);
 
 sprintf(file,"%s/notiz/Dir%08d.txt",dataDir,adf->id);
 fp=fopen(file,"w");
 if(fp==NULL)
  {
   printf("can't open %s\n",file);
   delete adf->notiz;
   adf->notiz=NULL;
   return(false);
  }
 writeNotiz(fp,adf->notiz);
 fclose(fp);
}
int writeNotiz(FILE *fp,NotizControl *nc)
{
 Notiz *ntz;
 int i;

 for(i=0;i<nc->anz ; i++)
  {
   ntz = &nc->notiz[i];

   printf("%$NOTIZ %d %d %s %d %d {%s}\n",ntz->id, ntz->parent, userList[ntz->uid].name, ntz->date,ntz->time,ntz->title);
   fprintf(fp,"%$NOTIZ %d %d %s %d %d {%s}\n",ntz->id, ntz->parent, userList[ntz->uid].name, ntz->date,ntz->time,ntz->title);
   fprintf(fp,"%s\n",ntz->text);
   fprintf(fp,"%$END\n");
  }
}
