//  File: address.h
// 
//      This file is part of minkowsky
// 
//      Copyright (C) 2001-2002 by Rdiger Goetz
//      Author: Rdiger Goetz <minkowsky@r-goetz.de>
// 
//      Time-stamp: <27-Oct-2002 19:39:14 goetz>
// 
//      This program is free software; you can redistribute it and/or modify
//      it under the terms of the GNU General Public License as published by
//      the Free Software Foundation; either version 2 of the License, or
//      (at your option) any later version.
// 
//      This program is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//     GNU General Public License for more details.
// 
//      You should have received a copy of the GNU General Public License
//      along with this program; if not, write to the Free Software
//      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//  
#define NOTIZ_EMPTY 0
#define NOTIZ_ALLOC 1
#define NOTIZ_FILLED 2

typedef struct {
 int status;
 int id;
 int parent;
 int date;
 int time;
 int uid;
 char *title;
 char * text;
 int childAnz; // termprar
} Notiz;

#define ADDRESS_NOTIZ 1
#define FOLDER_NOTIZ 2
#define TASK_NOTIZ  3
#define PROJECT_NOTIZ 4
#define CALENDAR_NOTIZ 5

typedef struct
{
 int id;
 int max;
 int anz;
 int dirty;
 Notiz *notiz;
 int type;
}NotizControl;


#define ADR_FIELD_IGNORE  0
#define ADR_FIELD_CAT     1
#define ADR_FIELD_TITEL   2
#define ADR_FIELD_NAME_1  3
#define ADR_FIELD_NAME_M  4
#define ADR_FIELD_NAME_2  5
#define ADR_FIELD_NAME1M2 6
#define ADR_FIELD_COMPS   7
#define ADR_FIELD_COMPA   8
#define ADR_FIELD_COMPPOS 9
#define ADR_FIELD_ADDR1   10
#define ADR_FIELD_ADDR1A  11
#define ADR_FIELD_ADDR1B  12
#define ADR_FIELD_ADDR1C  13
#define ADR_FIELD_PLZ1    14
#define ADR_FIELD_CITY1   15
#define ADR_FIELD_CNTRY1  16
#define ADR_FIELD_ADDR2   20
#define ADR_FIELD_ADDR2A  21
#define ADR_FIELD_ADDR2B  22
#define ADR_FIELD_ADDR2C  23
#define ADR_FIELD_PLZ2    24
#define ADR_FIELD_CITY2   25
#define ADR_FIELD_CNTRY2  26 
#define ADR_FIELD_ADDR3   30
#define ADR_FIELD_ADDR3A  31
#define ADR_FIELD_ADDR3B  32
#define ADR_FIELD_ADDR3C  33
#define ADR_FIELD_PLZ3    34
#define ADR_FIELD_CITY3   35
#define ADR_FIELD_CNTRY3  36
#define ADR_FIELD_FON1    40
#define ADR_FIELD_FON2    41
#define ADR_FIELD_FON3    42
#define ADR_FIELD_FON4    43
#define ADR_FIELD_FON_P   44
#define ADR_FIELD_MOBILE1 45
#define ADR_FIELD_MOBILE2 46
#define ADR_FIELD_MOBILE_P 47
#define ADR_FIELD_FAX     48
#define ADR_FIELD_FAX1    49
#define ADR_FIELD_FAX2    50
#define ADR_FIELD_FAX_P   51
#define ADR_FIELD_WWW     52
#define ADR_FIELD_WWW_P   53
#define ADR_FIELD_MAIL    54
#define ADR_FIELD_MAIL2   55
#define ADR_FIELD_MAIL_P  56
#define ADR_FIELD_DESCR_S 57
#define ADR_FIELD_DESCR_L 58
#define ADR_FIELD_DESCR_L_ADD 158
#define ADR_FIELD_DESCR_L_WITH_TAGS 258
#define ADR_FIELD_DESCR_L_ADD_WITH_TAGS 358
#define ADR_FIELD_KONTO1INH 60
#define ADR_FIELD_KONTO1NUM 61
#define ADR_FIELD_KONTO1BNK 62
#define ADR_FIELD_KONTO1BLZ 63
#define ADR_FIELD_KONTO2INH 64
#define ADR_FIELD_KONTO2NUM 65
#define ADR_FIELD_KONTO2BNK 66
#define ADR_FIELD_KONTO2BLZ 67
#define ADR_FIELD_STEUER    68
#define ADR_FIELD_INFO1     70
#define ADR_FIELD_INFO2     71
#define ADR_FIELD_INFO1_ADD 170
#define ADR_FIELD_INFO2_ADD 171
#define ADR_FIELD_GEBURTST  72
#define ADR_FIELD_OWNER     80
#define ADR_FIELD_NOTEONLY  81
#define ADR_FIELD_READONLY  82
#define ADR_FIELD_CREATE    85
#define ADR_FIELD_CREATOR   86
#define ADR_FIELD_CUSTOM1   87
#define ADR_FIELD_CUSTOM2   88
#define ADR_FIELD_CUSTOM3   89
#define ADR_FIELD_CUSTOM4   90
#define ADR_FIELD_CUSTOM5   91
#define ADR_FIELD_CUSTOM6   92
#define ADR_FIELD_CUSTOM7   93
#define ADR_FIELD_CUSTOM8   94

#define ADR_PDA_START      500
#define ADR_PDA_PHON       500
#define ADR_PDA_PHON_TYPE  501
#define ADR_PDA_PHON_TMP   502
#define ADR_PDA_MOBILE_TMP 503
#define ADR_PDA_FAX_TMP    504
#define ADR_PDA_MAIL_TMP   505
#define ADR_PDA_WWW_TMP    506
#define ADR_PDA_ADR_A      510
#define ADR_PDA_ADR_B      511
#define ADR_PDA_ADR_C      512
#define ADR_PDA_ADR_PLZ    513
#define ADR_PDA_ADR_CITY   514
#define ADR_PDA_ADR_CNTRY  515
#define ADR_PDA_ADR        516
#define ADR_PDA_ADR_TYPE   518
#define ADR_PDA_ADR_TMP_A      520
#define ADR_PDA_ADR_TMP_B      521
#define ADR_PDA_ADR_TMP_C      522
#define ADR_PDA_ADR_TMP_PLZ    523
#define ADR_PDA_ADR_TMP_CITY   524
#define ADR_PDA_ADR_TMP_CNTRY  525
#define ADR_PDA_SEND 550

#define ADR_FIELD_UNDEF    997
#define ADR_FIELD_MINKOID  998
#define ADR_FIELD_FOLDER   999


#define ADR_ADR_ANZ   3
#define ADR_FON_ANZ   5
#define ADR_MOBIL_ANZ 3
#define ADR_FAX_ANZ   3
#define ADR_MAIL_ANZ  3
#define ADR_WWW_ANZ   2
#define ADR_KONTO_ANZ 2
#define ADR_INFO_ANZ  2

#define ADR_ADR_PRIV_ANZ   1
#define ADR_FON_PRIV_ANZ   1
#define ADR_MOBIL_PRIV_ANZ 1
#define ADR_FAX_PRIV_ANZ   1
#define ADR_MAIL_PRIV_ANZ  1
#define ADR_WWW_PRIV_ANZ   1
#define ADR_INFO_PRIV_ANZ  1


#define ADR_ADR_WORK_ANZ   ADR_ADR_ANZ   - ADR_ADR_PRIV_ANZ
#define ADR_FON_WORK_ANZ   ADR_FON_ANZ   - ADR_FON_PRIV_ANZ
#define ADR_MOBIL_WORK_ANZ ADR_MOBIL_ANZ - ADR_MOBIL_PRIV_ANZ
#define ADR_FAX_WORK_ANZ   ADR_FAX_ANZ   - ADR_FAX_PRIV_ANZ
#define ADR_MAIL_WORK_ANZ  ADR_MAIL_ANZ  - ADR_MAIL_PRIV_ANZ
#define ADR_WWW_WORK_ANZ   ADR_WWW_ANZ   - ADR_WWW_PRIV_ANZ
#define ADR_INFO_WORK_ANZ  ADR_INFO_ANZ  - ADR_INFO_PRIV_ANZ

#define ADR_ADR_PRIV_FNR   ADR_ADR_ANZ   - ADR_ADR_PRIV_ANZ
#define ADR_FON_PRIV_FNR   ADR_FON_ANZ   - ADR_FON_PRIV_ANZ
#define ADR_MOBIL_PRIV_FNR ADR_MOBIL_ANZ - ADR_MOBIL_PRIV_ANZ
#define ADR_FAX_PRIV_FNR   ADR_FAX_ANZ   - ADR_FAX_PRIV_ANZ
#define ADR_MAIL_PRIV_FNR  ADR_MAIL_ANZ  - ADR_MAIL_PRIV_ANZ
#define ADR_WWW_PRIV_FNR   ADR_WWW_ANZ   - ADR_WWW_PRIV_ANZ
#define ADR_INFO_PRIV_FNR  ADR_INFO_ANZ  - ADR_INFO_PRIV_ANZ


typedef struct 
{
 char tag[32];
 int field;
 char name[32];
} AddressTags;

typedef struct 
{
 char addres[3][64]; // 0=main, 1=addi, 2=priv
 char plz[16];
 char city[64];
 char country[64];
} Addresse;

#ifndef WITH_CLASS
typedef struct
{
#else
class AddressSyncTemp
{
public:
#endif

 // temperary data storage
 Addresse adr[ADR_ADR_ANZ-1];
 char fon[ADR_FON_ANZ-1][32];
 char mobile[ADR_MOBIL_ANZ-1][32];
 char fax[ADR_FAX_ANZ-1][32];
 char mail[ADR_MAIL_ANZ-1][64];
 char www[128];
 // remeber which addresses are filled already
 int adrFilled[ADR_ADR_ANZ];
 int adrExported[ADR_ADR_ANZ];
 
 // connection between temp-adr-fileds and csv-field-ids 
 int adrTempId[ADR_ADR_ANZ-1][3];
 int plzTempId[ADR_ADR_ANZ-1];
 int cityTempId[ADR_ADR_ANZ-1];
 int countryTempId[ADR_ADR_ANZ-1];
 int adrWithId[ADR_ADR_ANZ-1];
 int fonTempId[ADR_FON_ANZ-1];
 int mobileTempId[ADR_MOBIL_ANZ-1];
 int faxTempId[ADR_FAX_ANZ-1];
 int mailTempId[ADR_MAIL_ANZ-1];
 int wwwTempId;
 // connection between adr-fileds and csv-field-ids 
 int adrId[ADR_ADR_ANZ][3];
 int plzId[ADR_ADR_ANZ];
 int cityId[ADR_ADR_ANZ];
 int countryId[ADR_ADR_ANZ];
 int fonId[ADR_FON_ANZ];   
 int mobileId[ADR_MOBIL_ANZ];
 int mailId[ADR_MAIL_ANZ];  
 int faxId[ADR_FAX_ANZ];   
 int wwwId[ADR_WWW_ANZ];   

 // skip address >
 int skip;

 // csv structures
 csvData *csvIn;
 csvData *csvOut;
 
#ifdef WITH_CLASS
 inline AddressSyncTemp ()
  {
   int i;

   printf("new ast class obj\n");
   clear();
  };
 inline ~AddressSyncTemp ()
 {
   printf("deleting ast class obj\n");
  if(csvIn != NULL)
   destroyCsvDataStruct(csvIn);
  csvIn =NULL;
  if(csvOut != NULL)
   destroyCsvDataStruct(csvOut);
  csvOut =NULL;
 }
 inline void clear()
 {
     int i;

   for(i=0; i< ADR_ADR_ANZ ; i++)
    {
     if(i<ADR_ADR_ANZ -1)
      {
       adr[i].addres[0][0]='\0';
       adr[i].addres[1][0]='\0';
       adr[i].addres[2][0]='\0';
       adr[i].plz[0]='\0';
       adr[i].city[0]='\0';
       adr[i].country[0]='\0';
       adrTempId[i][0]=-1;
       adrTempId[i][1]=-1;
       adrTempId[i][2]=-1;
       plzTempId[i]=-1;
       cityTempId[i]=-1;
       countryTempId[i]=-1;
       adrWithId[i]= false;
      }
     adrFilled[i] = false;
     adrExported[i] = false;
     adrId[0][i] = -1;
     adrId[1][i] = -1;
     adrId[2][i] = -1;
     plzId[i] = -1;
     cityId[i] = -1;
     countryId[i] = -1;
    }
   for(i=0; i< ADR_FON_ANZ ; i++)
    {
     if(i<ADR_FON_ANZ -1)
      {
       fon[i][0]='\0';
       fonTempId[i]=-1;
      }
     fonId[i]=-1;
    }
   for(i=0; i< ADR_MAIL_ANZ ; i++)
    {
     if(i<ADR_MAIL_ANZ -1)
      {
       mail[i][0]='\0';
       mailTempId[i]=-1;
      }
     mailId[i]=-1;
    }
   for(i=0; i< ADR_MOBIL_ANZ ; i++)
    {
     if(i<ADR_MAIL_ANZ -1)
      {
       mobile[i][0]='\0';
       mobileTempId[i] = -1;
      }
     mobileId[i]=-1;
    }
   for(i=0; i< ADR_FAX_ANZ ; i++)
    {
     if(i<ADR_MAIL_ANZ -1)
      {
       fax[i][0]='\0';
       faxTempId[i] = -1;
      }
     faxId[i]=-1;
    }
   www[0]='\0';
   wwwTempId=-1;
   wwwId[0]=-1;
   wwwId[1]=-1;
   skip=false;
   csvIn=NULL;
   csvOut=NULL;
 }
};
#else
} AddressSyncTemp;
#endif

typedef struct
{
 int id;
 char titel[16];
 char name1[64];
 char nameM;
 char name2[64];
 char compShort[16];
 char compPos[32];
 char company[64];
 Addresse adr[ADR_ADR_ANZ];    // 0=main, 1=additional, 2=priv
 char fon[ADR_FON_ANZ][32];       // 0-3 normal  4 =privat
 char mobile[ADR_MOBIL_ANZ][32];    // 0,1 normal 2 privat
 char mail[ADR_MAIL_ANZ][64];      // 0,1 normal 2 =privat
 char fax[ADR_FAX_ANZ][32];       // 0,1 normal 1=privat
 char www[ADR_WWW_ANZ][128];       // 0 normal 1=privat
 char kontoInh[ADR_KONTO_ANZ][32];
 char kontoNum[ADR_KONTO_ANZ][16];
 char kontoBank[ADR_KONTO_ANZ][32];
 char kontoBLZ[ADR_KONTO_ANZ][16];
 char steuer[32];
 char descrShort[64];
 char descr[256];
 char info [ADR_INFO_ANZ][256];     // 0 normal 1=privat
 char geb[16];
 int owner;
 int noteOnly;
 int readOnly;
 int deleted;
 int dateCount;
 int dirID;
 int created;
 int modified;
 int creator;
 int modifier;
 NotizControl *notiz;
 char reserved[256];
 int  resv[6];
 int  blocked; // need by sync
 AddressSyncTemp *tmp;
 void *action;
}Address;


typedef struct
{
 int id;
 char titel[16];
 char name1[64];
 char nameM;
 char name2[64];
 char compShort[16];
 char compPos[32];
 char company[64];
 char addres[3][3][64]; // 0=main, 1=addi, 2=priv
 char plz[3][16];
 char city[3][64];
 char country[3][64];
 char fon[5][32];       // 0,1,3 normal 2 = handy 4 =privat
 char mail[3][64];      // 0,1 normal 2 =privat
 char fax[2][32];       // 0 normal 1=privat
 char www[2][128];       // 0 normal 1=privat
 char kontoInh[2][32];
 char kontoNum[2][16];
 char kontoBank[2][32];
 char kontoBLZ[2][16];
 char steuer[32];
 char descrShort[64];
 char descr[256];
 char info [2][256];     // 0 normal 1=privat
 char geb[16];
 int owner;
 int noteOnly;
 int readOnly;
 int deleted;
 int dateCount;
 int dirID;
 int created;
 int modified;
 int creator;
 int modifier;
 NotizControl *notiz;
 char reserved[256];
 int  resv[8];
 void *action;
}Address_0411;



typedef struct
{
 int id;
 char titel[16];
 char name1[64];
 char name2[64];
 char compShort[16];
 char company[64];
 char addres[5][64];
 char fon[2][32];
 char mail[64];
 char fax[32];
 char www[128];
 char descrShort[64];
 char descr[256];
 int owner;
 int deleted;
 // int lock;
 int dateCount;
 NotizControl *notiz;
}Address_0410;

#define ADRF_STATUS_EMPTY 0x0000
#define ADRF_START_OPEN   0x0001

typedef struct
{
 int id;
 int dirID;
 int owner;
 int deleted;
 char name [64];
 NotizControl *notiz;
 int status;
 char res[60];
 int blocked; // need by Sync
}AddressFolder;

typedef struct
{
 int id;
 int dirID;
 int owner;
 int deleted;
 char name [64];
 NotizControl *notiz;
}AddressFolder_0411;




#ifdef ADDRESS
#define __EXTERN
#else
#define __EXTERN extern
#endif
__EXTERN Address **adrList;
__EXTERN AddressFolder **adfList;
__EXTERN int adrAnz,adrBlocks,adrMax;
__EXTERN int adfAnz,adfBlocks,adfMax;
__EXTERN int lastAid;
__EXTERN int csvImportFields[256];

#define ADR_TAG_ANZ 96
__EXTERN char *adrTagName[10000];
#ifndef ADDRESS
extern AddressTags *adrDescrTags,adrTags[ADR_TAG_ANZ];
extern int adrDescrTagsAnz;
#else
AddressTags *adrDescrTags;
int adrDescrTagsAnz;
AddressTags adrTags[ADR_TAG_ANZ]= {
{"IGNORE"    ,ADR_FIELD_IGNORE    },
{"CATEGORY"  ,ADR_FIELD_CAT       },
{"TITEL"     ,ADR_FIELD_TITEL     },
{"NAME_1"    ,ADR_FIELD_NAME_1    },
{"NAME_M"    ,ADR_FIELD_NAME_M    },
{"NAME_2"    ,ADR_FIELD_NAME_2    },
{"NAME1"     ,ADR_FIELD_NAME_1    },
{"NAMEM"     ,ADR_FIELD_NAME_M    },
{"NAME2"     ,ADR_FIELD_NAME_2    },
{"NAME1M2"   ,ADR_FIELD_NAME1M2   },
{"COMPS"     ,ADR_FIELD_COMPS     },
{"COMPA"     ,ADR_FIELD_COMPA     },
{"COMPANY"   ,ADR_FIELD_COMPA     },
{"COMPPOS"   ,ADR_FIELD_COMPPOS   },
{"ADDR1A"    ,ADR_FIELD_ADDR1A    },
{"ADDR1B"    ,ADR_FIELD_ADDR1B    },
{"ADDR1C"    ,ADR_FIELD_ADDR1C    },
{"PLZ1"      ,ADR_FIELD_PLZ1      },
{"CITY1"     ,ADR_FIELD_CITY1     },
{"CNTRY1"    ,ADR_FIELD_CNTRY1    },
{"ADDR2A"    ,ADR_FIELD_ADDR2A    },
{"ADDR2B"    ,ADR_FIELD_ADDR2B    },
{"ADDR2C"    ,ADR_FIELD_ADDR2C    },
{"PLZ2"      ,ADR_FIELD_PLZ2      },
{"CITY2"     ,ADR_FIELD_CITY2     },
{"CNTRY2"    ,ADR_FIELD_CNTRY2    },
{"ADDR_A_P"  ,ADR_FIELD_ADDR3A    },
{"ADDR_B_P"  ,ADR_FIELD_ADDR3B    },
{"ADDR_C_P"  ,ADR_FIELD_ADDR3C    },
{"PLZ_P"     ,ADR_FIELD_PLZ3      },
{"CITY_P"    ,ADR_FIELD_CITY3     },
{"CNTRY_P"   ,ADR_FIELD_CNTRY3    },
{"FON1"      ,ADR_FIELD_FON1      },
{"FON2"      ,ADR_FIELD_FON2      },
{"FON3"      ,ADR_FIELD_FON3      },
{"FON4"      ,ADR_FIELD_FON4      },
{"FON_P"     ,ADR_FIELD_FON_P     },
{"FONP"      ,ADR_FIELD_FON_P     },
{"MOBILE1"   ,ADR_FIELD_MOBILE1   },
{"MOBILE2"   ,ADR_FIELD_MOBILE2   },
{"MOBILEP"   ,ADR_FIELD_MOBILE_P  },
{"MOBILE_P"  ,ADR_FIELD_MOBILE_P  },
{"FAX"       ,ADR_FIELD_FAX       },
{"FAX1"      ,ADR_FIELD_FAX1      },
{"FAX2"      ,ADR_FIELD_FAX2      },
{"FAX_P"     ,ADR_FIELD_FAX_P     },
{"FAXP"      ,ADR_FIELD_FAX_P     },
{"WWW"       ,ADR_FIELD_WWW       },
{"WWW_P"     ,ADR_FIELD_WWW_P     },
{"WWWP"      ,ADR_FIELD_WWW_P     },
{"MAIL"      ,ADR_FIELD_MAIL      },
{"MAIL2"     ,ADR_FIELD_MAIL2     },
{"MAIL_P"    ,ADR_FIELD_MAIL_P    },
{"MAILP"     ,ADR_FIELD_MAIL_P    },
{"DESCR_S"   ,ADR_FIELD_DESCR_S   },
{"DESCR_L"   ,ADR_FIELD_DESCR_L   },
{"+DESCR_L"  ,ADR_FIELD_DESCR_L_ADD},
{"KONTO1INH" ,ADR_FIELD_KONTO1INH },
{"KONTO1NUM" ,ADR_FIELD_KONTO1NUM },
{"KONTO1BNK" ,ADR_FIELD_KONTO1BNK },
{"KONTO1BLZ" ,ADR_FIELD_KONTO1BLZ },
{"KONTO2INH" ,ADR_FIELD_KONTO2INH },
{"KONTO2NUM" ,ADR_FIELD_KONTO2NUM },
{"KONTO2BNK" ,ADR_FIELD_KONTO2BNK },
{"KONTO2BLZ" ,ADR_FIELD_KONTO2BLZ },
{"STEUER"    ,ADR_FIELD_STEUER    },
{"INFO1"     ,ADR_FIELD_INFO1     },
{"INFO2"     ,ADR_FIELD_INFO2     },
{"+INFO1"    ,ADR_FIELD_INFO1_ADD },
{"+INFO2"    ,ADR_FIELD_INFO2_ADD },
{"GEBURTST"  ,ADR_FIELD_GEBURTST  },
{"OWNER"     ,ADR_FIELD_OWNER     },
{"NOTEONLY"  ,ADR_FIELD_NOTEONLY  },
{"READONLY"  ,ADR_FIELD_READONLY  },
{"CREATE"    ,ADR_FIELD_CREATE    },
{"CREATOR"   ,ADR_FIELD_CREATOR   },
{"MINKO_ID"  ,ADR_FIELD_MINKOID   },
{"FOLDER"    ,ADR_FIELD_FOLDER    },
{"CUSTOM1"   ,ADR_FIELD_CUSTOM1   },
{"CUSTOM2"   ,ADR_FIELD_CUSTOM2   },
{"CUSTOM3"   ,ADR_FIELD_CUSTOM3   },
{"CUSTOM4"   ,ADR_FIELD_CUSTOM4   },
{"CUSTOM5"   ,ADR_FIELD_CUSTOM5   },
{"CUSTOM6"   ,ADR_FIELD_CUSTOM6   },
{"CUSTOM7"   ,ADR_FIELD_CUSTOM7   },
{"CUSTOM8"   ,ADR_FIELD_CUSTOM8   },
{"PDA_PHON"  ,ADR_PDA_PHON        },
{"PDA_PHON_TYPE",ADR_PDA_PHON_TYPE},
{"PDA_ADDR  ",ADR_PDA_ADR         },
{"PDA_ADDR1A",ADR_PDA_ADR_A       },
{"PDA_ADDR1B",ADR_PDA_ADR_B       },
{"PDA_ADDR1C",ADR_PDA_ADR_C       },
{"PDA_PLZ"   ,ADR_PDA_ADR_PLZ     },
{"PDA_CITY"  ,ADR_PDA_ADR_CITY    },
{"PDA_CNTRY" ,ADR_PDA_ADR_CNTRY   },
{"PDA_ADDRES_TYPE",ADR_PDA_ADR_TYPE},
};

#endif
void initAdrList();
void clearAdrList ();
void extendAdrList();

int changeAdress(int socket,char *ds);
int readAdrList();
int writeAdrList();
int writeAdrFolderList();
int sendBriefAdressList(int socket,char *str);
int sendAddresssList(int socket,char *str);
int sendAddress(int socket,char *str);  // request 
int sendFullAddress(int socket,char *str); // request 
int deleteAddresses(int socket,char *ds);
int deleteAddress(int socket,char *ds);

int addNotiz(int socket,char *str,int type);
int getNotiz(int socket,char *str,int type);

int updateDateCountsInAddress();

int sendAdrFolderList(int socket,char *str);
int makeAdrFolder(int socket, char *str);
int makeAdrFolder(char *name, int owner, int parent);
int changeAdrFolder(int socket, char *str);
int moveAdrObjToFolder(int socket, char *str);

void unblockAllAdrFolders();
void blockFolder(int dirid);
void blockFoldersInBlockedFolders();
void blockAdrInBlockedFolders();

int aname2aid(char *name);
int aname2idx(char *name);
int aid2idx(int aid);
char * aid2name(int aid,char *t);
char * adrIdx2name(int idx,char *t);
char * aid2cname(int aid,char *t);
char * adrIdx2cname(int idx,char *t);
int importCSV(int socket, int cuid,char *str);
int deleteAdrFolder (int socket, char *str);
int deleteAdrFolders (int socket, char *str);

void clearAdrSyncTemp(int uid);
int clearAdrSyncTemp(Address *adr);
AddressSyncTemp * newAddressSyncTempStruct ();
#ifndef WITH_CLASS
void clearAddressSyncTemp(AddressSyncTemp *ast);
// #else  
// #define newAddressSyncTempStruct new AddressSyncTemp
#endif

#undef __EXTERN
