// File: adrSync.cc
// 
//      This file is part of minkowsky
// 
//      Copyright (C) 2001-2002 by Rdiger Goetz
//      Author: Rdiger Goetz <minkowsky@r-goetz.de>
// 
//      Time-stamp: <27-Oct-2002 21:03:52 goetz>
// 
//      This program is free software; you can redistribute it and/or modify
//      it under the terms of the GNU General Public License as published by
//      the Free Software Foundation; either version 2 of the License, or
//      (at your option) any later version.
// 
//      This program is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU General Public License for more details.
// 
//      You should have received a copy of the GNU General Public License
//      along with this program; if not, write to the Free Software
//      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//  
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <errno.h>  
#include <time.h>  

#include "termin.h"
#include "sync.h"
//#include "address.h"

char *id2owner(int id,char *t);


int folderName2dirid(char *name);
int access2Adr(int uid, Address *adr);
int syncAccess2Adr(int uid, Address *adr);
int owner2id(char *name);

void fillIntoAdr(syncUserInfo *syncUI, Address *adr, char *t, int fnr);
void fillIntoAdrIfNonEmpty(syncUserInfo *syncUI,Address *adr, char *t, int field, int fnr);
void fillIntoAdr(syncUserInfo *syncUI, Address *adr, char *t,int field, int fnr);
//void fillCsvDataIntoAddress(syncUserInfo *syncUI, Address *adr,int copyOnlyFull);
int fillCsvDataIntoAddress(syncUserInfo *syncUI, csvData *csv, Address *adr,int copyOnlyFull);
int addresseEquivalent(Address *adr1,Address *adr2);
int compareRestAddress(Address *neu,Address *ref);
int makeFootPrintString ();
int importCSVAddress(char *formatFile, char *csvFile, char sep,char *folder,int star,int uidt);
int importCSV2Adr(syncUserInfo *syncUI, char *csv, int uid,int doImport);
int addressDiffers(Address *neu, Address *ref);
void fillAdrTempIntoAdr(syncUserInfo *syncUI,Address *adr);
int str2PDAtype(char *t);
void fillPDAphone2Adr(syncUserInfo *syncUI,Address *adr, char *t,int fnr);
void syncAdrIntoAdr(syncUserInfo *syncUI,Address *dest, Address *src,int copyEmpty);
void transferAdrSyncTemp(Address *dest, Address *src);
//void fillPDAadr2Adr(syncUserInfo *syncUI,Address *adr, char *t);



static int phonTypes[ADR_FON_WORK_ANZ]     = {ADR_FIELD_FON1,   ADR_FIELD_FON2,    ADR_FIELD_FON3,ADR_FIELD_FON4};
static int mailTypes[ADR_MAIL_WORK_ANZ]    = {ADR_FIELD_MAIL,   ADR_FIELD_MAIL2};
static int mobileTypes[ADR_MOBIL_WORK_ANZ] = {ADR_FIELD_MOBILE1,ADR_FIELD_MOBILE2};
static int faxTypes[ADR_FAX_WORK_ANZ]      = {ADR_FIELD_FAX1,   ADR_FIELD_FAX2};
static int adrTypes[ADR_ADR_ANZ][3]  = { {ADR_FIELD_ADDR1A,  ADR_FIELD_ADDR1B, ADR_FIELD_ADDR1C},
					 {ADR_FIELD_ADDR2A,  ADR_FIELD_ADDR2B, ADR_FIELD_ADDR2C},
					 {ADR_FIELD_ADDR3A,  ADR_FIELD_ADDR3B, ADR_FIELD_ADDR3C}
};
static int plzTypes[ADR_ADR_ANZ]     =   {ADR_FIELD_PLZ1,   ADR_FIELD_PLZ2,   ADR_FIELD_PLZ3};
static int cityTypes[ADR_ADR_ANZ]    =   {ADR_FIELD_CITY1,  ADR_FIELD_CITY2,  ADR_FIELD_CITY3};
static int countryTypes[ADR_ADR_ANZ] =   {ADR_FIELD_CNTRY1, ADR_FIELD_CNTRY2, ADR_FIELD_CNTRY3};


int importCSV(int socket, int cuid, char *str)
{
 send2Client(socket,"Error: Command obsolete and unsuported");
}


#ifdef OLD
int readCSVadrFormatFile(syncUserInfo *syncUI, char *file)
{
 char inp[1024],*p;
 int fnr;
 int i;
 FILE *fp;

 fp =fopen(file,"r");
 if(fp==NULL)
  {
   printf("Can't open '%s' get format for csv-import csv-addresse \n",file);
   return(false);
  }

 fnr=0;

 while(fgets(inp,1023,fp) != NULL)
  {
   p = strchr(inp,'#');
   if(p !=NULL)
    *p ='\0';
   strTrim(inp);
   addAdrCSVField(syncUI,inp);
  }
 fclose(fp);
 return(true);
}

int readCSVadrFormatString(syncUserInfo *syncUI, char *str)
{
 char inp[1024];
 int i;
 char *tp[1025];
 int anz;

 anz=split(str,tp,1024);
 for(i=0;i<anz;i++)
  {
   strcpy(inp,tp[i]);
   strTrim(inp);
   addAdrCSVField(syncUI,inp);
  }
 return(true);
}

int addAdrCSVField(syncUserInfo *syncUI,char *field)
{
 int fnr = syncUI->syncFieldCount;
 int i;

 syncUI->csvImportFields[fnr] = ADR_FIELD_UNDEF;
 for(i=0;i<ADR_TAG_ANZ;i++)
  if(strcmp(field,adrTags[i].tag)==0)
   {
    if(verbose)
     printf("got %s for field %d\n",adrTags[i].tag,fnr);
    syncUI->csvImportFields[fnr] = adrTags[i].field;
    break;
   }
 if(verbose)
  if ( syncUI->csvImportFields[fnr] == ADR_FIELD_UNDEF)
   {
    syncUI->csvImportFields[fnr] = ADR_FIELD_IGNORE;
    printf("Can't identify TAG '%s', asuming IGNORE\n",field);
   }
 syncUI->syncFieldCount++;
}
#endif

void clearAdrSyncTemp(int uid)
{
 int i;

 for(i=0;i<adrAnz; i++)
  if(access2Adr(uid,adrList[i]))
   clearAdrSyncTemp(adrList[i]);
}

int clearAdrSyncTemp(Address *adr)
{
 int i,j;
 AddressSyncTemp *ast = adr->tmp;

 if(ast == NULL)
  return true;
#ifdef WITH_CLASS
 ast->clear();
#else
 clearAddressSyncTemp(ast);
#endif
 return true;
}


void clearAdrSyncUI(syncUserInfo *syncUI)
{
 syncUI->adr.pdaAdrTypeHomeDone =false;
 syncUI->adr.adrAnz=0;
 syncUI->adr.adrNum=-1;
 syncUI->adr.phonAnz=0;
 syncUI->adr.mobileAnz=0;
 syncUI->adr.faxAnz=0;
 syncUI->adr.mailAnz=0;
 syncUI->adr.wwwAnz=0;
 syncUI->adr.phonPrivAnz=0;
 syncUI->adr.mobilePrivAnz=0;
 syncUI->adr.faxPrivAnz=0;
 syncUI->adr.mailPrivAnz=0;
 syncUI->adr.wwwPrivAnz=0;

}

int syncAdrInto(int socket,syncUserInfo *syncUI,char *csv,int doImport)
{
 int uid  = syncCtrl.user->id;

// int importCSV2Adr(syncUserInfo *syncUI, char *csv, int uid,int doImport)
// {
 static Address *adr=NULL;
 char *t,*s;
 int fnr=0;
 int aid,idx;
 int diff;
 int thresh=10;
 int status=0;
 int i;

 printf("syncAdrInto : %s\n",csv);
 if(adr ==NULL)
  {
   adr = new Address;
   adr->tmp =NULL;
  }

 memset(adr,0,sizeof(Address));

 adr->owner    = -1;
 adr->noteOnly = -1;
 adr->readOnly = -1;
 adr->creator  = adr->modifier = uid;
 adr->created  = adr->modified = today;
 adr->dirID    = syncUI->adr.defaultFolder;
 adr->id       = -1;
 clearAdrSyncUI(syncUI);

 // flle address in Structur
 if(adr->tmp == NULL)
  adr->tmp = newAddressSyncTempStruct();
 for(i=0;i<ADR_ADR_ANZ;i++)
  adr->tmp->adrFilled[i] = false;

 if(adr->tmp->csvIn != NULL)
  destroyCsvDataStruct(adr->tmp->csvIn);



 adr->tmp->csvIn = unsplitCsv(csv,syncUI->syncFieldCount,syncUI->csvSep);
 if(!fillCsvDataIntoAddress(syncUI,adr->tmp->csvIn,adr,false))
  {
   send2Client(socket,"done");
   return true;
  }

   
 // Finde passende Addresse aus dem bestand sofern vorhanden
 diff=999;
 aid = equivalentAddress(syncUI,adr,&diff);
 // printf("Address %5d is equivalent to imported address of %s %s of %s\n",aid,adr->name1, adr->name2, adr->company);
 minkoLog("Address %5d is equivalent to imported address of %s %s of %s\n",aid,adr->name1, adr->name2, adr->company);
 
 if(aid>=0)
  {
   idx = aid2idx(aid);
   if(diff==0)
    {
     if(!addressDiffers(adr,adrList[idx]) )
      status = SYNC_STAT_SAME;
     else
      status = SYNC_STAT_DIFFER;
    }
   // FIXME definme diff-thresh
   else if(diff < thresh)
    status = SYNC_STAT_DIFFER;
   else
    status = SYNC_STAT_NEW;
  }
 else
  status = SYNC_STAT_NEW;


 switch (status)
  {
  case SYNC_STAT_DIFFER:
   status = SYNC_STAT_MODI_OUT;
   // address was unchanged but since last sync out, but differs, hence changed on PDA
   if (syncUI->lastAdrSync> adrList[idx]->modified)
    {
     if(access2Adr(uid,adr))
      {
       if(doImport)
	syncAdrIntoAdr(syncUI,adrList[idx],adr,false);
       status = SYNC_STAT_MODI_IN ;
      }
    }
   transferAdrSyncTemp(adrList[idx],adr);
   adrList[idx]->blocked = false;
   break;
  case SYNC_STAT_SAME:
   transferAdrSyncTemp(adrList[idx],adr);
   adrList[idx]->blocked = false;
   break;
  case SYNC_STAT_NEW:
   if(doImport)
    {
     lastAid++;
     adr->id=lastAid;
     aid= adr->id;
     adr->dateCount=0;
     adr->notiz=NULL;
     adr->created = adr->modified = today;
     adr->creator = adr->modifier = uid;
     adr->deleted = false;
     adrList[adrAnz] = adr;
     adrList[adrAnz]->blocked = false;
     minkoLog("\t\t On %8d   imported address of %s %s of %s is added.\n",aid, adrList[adrAnz]->name1, adrList[adrAnz]->name2,  adrList[adrAnz]->company);

     adrAnz++;
     adr = NULL;
     status = SYNC_STAT_IMPORT;
    }
   else
    {
     syncUI->csvTmp[syncUI->csvTmpAnz] = adr->tmp->csvIn ;
     syncUI->csvTmpAnz++;
     adr->tmp->csvIn = NULL;
    }
   break;
  }
 // printf("aid=%d\n",aid);
 if(aid>=0)
  syncUI->status[aid] = status;
 send2Client(socket,"done");
}
void transferAdrSyncTemp(Address *dest, Address *src)
{
 if(dest->tmp !=NULL)
  {
   // done now by destructor
//    if(dest->tmp->csvIn != NULL)
//     destroyCsvDataStruct(dest->tmp->csvIn);
//    if(dest->tmp->csvOut != NULL)
//     destroyCsvDataStruct(dest->tmp->csvOut);
   delete dest->tmp;
   dest->tmp =NULL;
  }
 dest->tmp = src->tmp;
 src->tmp  = NULL;
}

int fillCsvDataIntoAddress(syncUserInfo *syncUI, csvData *csv, Address *adr,int copyOnlyFull)
{
 char *t,*s;
 char buf[4096];
 int fnr=0;
 int i;

 int anz = syncUI->syncFieldCount;
 if(adr->tmp == NULL)
  adr->tmp = newAddressSyncTempStruct();
 adr->tmp->skip = false;

 for(i=0;i<syncUI->syncFieldCount ;i++)
  {
   if(i>= csv->filled)
    break;
   if(csv->col[i] != NULL)
    fillIntoAdr(syncUI,adr,csv->col[i],i);
   else if (! copyOnlyFull)
    fillIntoAdr(syncUI,adr,"",i);
   if( adr->tmp->skip )
    return false;
  }
 fillAdrTempIntoAdr(syncUI,adr);
 return true;
}


int equivalentAddress(syncUserInfo *syncUI, Address *adr, int *diff)
{
 int d,bestIdx=-1,idx;
 int diff2=9999999;
 // *diff=9999999;
 *diff=32;

 for( idx=0; idx<adrAnz; idx++)
  {
   if(adrList[idx]!=NULL)
    if(!adrList[idx]->deleted)
     if(syncUI->status[adrList[idx]->id] !=  SYNC_STAT_IMPORT)
      {
       if(adr->id == adrList[idx]->id)   // if id are identical this is the address we looking for
	{
	 minkoLog("\t\tequiAdr minko-ID match: %d/%d on adr %d \n",adr->id,adrList[idx]->id,adrList[idx]->id);
	 return(adrList[idx]->id);
	}

       d = compareAddress(adr,adrList[idx]);
       if(d == 0)                            // if main part of address are identical
	{
	 *diff=d;
	 d = compareRestAddress(adr,adrList[idx]);  
	 minkoLog("\t\tequiAdr diff=%d/%d on adr %d \n",*diff,d,adrList[idx]->id);
	 minkoLog("\t\t        priv phon: %s vs %s\n",adr->fon[4],adrList[idx]->fon[4]);
	 if( d== 0 )                         // if all other parts are identical this is the address we looking for
	  return(adrList[idx]->id);
	 else
	  {
	   if(*diff == 0)                   // if the previous most equivalent address was identical
	    {                               // in the main part take the one best in the other parts
	     if(d <diff2)
	      {
	       *diff =0;
	       diff2=d;
	       bestIdx=idx;
	      }
	    }
	   else                            // if the previous most equivalent address was not identical
	    {                              // in the main part take this  as most equivalent
	     *diff =0;
	     diff2=d;
	     bestIdx=idx;
	    }
	  }
	}
       if(d<*diff)
	{
	 *diff=d;
	 bestIdx=idx;
	}
      }
  }
 if(bestIdx<0)
  return -1;

 minkoLog("\t\tequiAdr done with diff=%d/%d\n",*diff,diff2);
 return(adrList[bestIdx]->id);
}

int adrStringChanged(char *neu, char*ref, int *fieldCount, int * changeCount)
{
 if(*neu != '\0' || *ref != '\0')
  {
   *fieldCount += 1;
   if(strcmp(neu,ref)!=0)
    {
     *changeCount += 1;
     return true;
    }
  }
 return false;
}

int compareAddress(Address *adrNew,Address *adrOld)
{
 int erc=0,sd,sd2,j,i;
 int fc=0; // number of checked nonempty fields
 int cc=0; // number of checked nonempty fields that changed

 sd  = strEditDist(adrNew->name1,adrOld->name1,4,10);
 if(adrNew->name1[0] !='\0' || adrOld->name1[0] != '\0')
  {
   fc++;
   if(sd>0)
    cc++;
  }

 sd2 = strEditDist(adrNew->name2,adrOld->name2,4,10);
 if(adrNew->name2[0] !='\0' || adrOld->name2[0] != '\0')
  {
   fc++;
   if(sd2>0)
    cc++;
  }
 sd+= sd2;
 // 1-> 1; 2-> 2; 3->5 ; 4->10 ; 5->17 ,...
 if(sd>0)
  erc = 1+(sd-1)*(sd-1);

 sd  = strEditDist(adrNew->company,adrOld->company,4,10);
 if(adrNew->company[0] !='\0' || adrOld->company[0] != '\0')
  {
   fc++;
   if(sd>0)
    cc++;
  }
 if(sd>0)
  erc += (1+(sd-1)*(sd-1));

 for(j=0;j<ADR_ADR_ANZ;j++)
  {
   //Address #j existing?
   if(adrOld->adr[j].city[0] != '\0' || adrOld->adr[j].addres[0][0] != '\0' || adrOld->adr[j].plz[0] != '\0')
    {
     if(adrStringChanged(adrNew->adr[j].plz,adrOld->adr[j].plz,&fc,&cc))
      erc+=3;
     else if (adrStringChanged(adrNew->adr[j].city,adrOld->adr[j].city,&fc,&cc))
      erc+=3;
     else if (adrStringChanged(adrNew->adr[j].country,adrOld->adr[j].country,&fc,&cc))
      erc+=2;
     else
      for(i=0;i<3;i++)
       if(adrOld->adr[j].addres[i][0] != '\0')
	if(adrStringChanged(&adrNew->adr[j].addres[i][0],&adrOld->adr[j].addres[i][0],&fc,&cc))
	 {
	  break;
	  erc+=2;
	 }
    }
  }

 for(i=0;i<ADR_FON_ANZ;i++)
  if(adrOld->fon[0] != '\0')
   if(adrStringChanged(&adrNew->fon[i][0],&adrOld->fon[i][0],&fc,&cc))
    erc+=2;
 for(i=0;i<ADR_MOBIL_ANZ;i++)
  if(adrOld->mobile[i][0] != '\0')
   if(adrStringChanged(&adrNew->mobile[i][0],&adrOld->mobile[i][0],&fc,&cc))
    erc+=2;
 for(i=0;i<ADR_WWW_ANZ;i++)
   if(adrOld->www[i][0] != '\0')
    if(adrStringChanged(adrNew->www[i],adrOld->www[i],&fc,&cc))
     erc++;
 for(i=0;i<ADR_FAX_ANZ;i++)
   if(adrOld->fax[i][0] != '\0')
    if(adrStringChanged(adrNew->fax[i],adrOld->fax[i],&fc,&cc))
     erc+=2;
 for(i=0;i<ADR_MAIL_ANZ;i++)   if(adrOld->mail[i][0] != '\0')
    if(adrStringChanged(adrNew->mail[i],adrOld->mail[i],&fc,&cc))
     erc+=2;


 // empty addresses should be diffrent to all addresses
 if(fc==0)
  return(999);

 if(cc == fc)
  if(erc>sqrt(fc)*4)
   return(999);

  

 return(erc);
}

int compareRestAddress(Address *neu,Address *ref)
{
 int erc=0;
 int fc=0,cc=0;
 int i;

 if(adrStringChanged(neu->compShort       ,ref->compShort       ,&fc,&cc)) erc++;
 if(adrStringChanged(neu->compPos         ,ref->compPos         ,&fc,&cc)) erc++;

 if(adrStringChanged(neu->descrShort       ,ref->descrShort      ,&fc,&cc)) erc++;
 if(adrStringChanged(neu->descr            ,ref->descr           ,&fc,&cc)) erc++;
 for(i=0;i<ADR_KONTO_ANZ;i++)
  {
   if(adrStringChanged(neu->kontoInh[i]     ,ref->kontoInh[i]     ,&fc,&cc)) erc++;
   if(adrStringChanged(neu->kontoNum[i]     ,ref->kontoNum[i]     ,&fc,&cc)) erc++;
   if(adrStringChanged(neu->kontoBank[i]    ,ref->kontoBank[i]    ,&fc,&cc)) erc++;
   if(adrStringChanged(neu->kontoBLZ[i]     ,ref->kontoBLZ[i]     ,&fc,&cc)) erc++;
  }
 for(i=0;i<ADR_INFO_ANZ;i++)
   if(adrStringChanged(neu->info[i]         ,ref->info[i]         ,&fc,&cc)) erc++;

 if(adrStringChanged(neu->steuer          ,ref->steuer          ,&fc,&cc)) erc++;
 if(adrStringChanged(neu->geb             ,ref->geb             ,&fc,&cc)) erc++;

 if(fc == 0 )
  return 0;
 
 return(erc);
}

// FIXME skip already filled fields

void fillAdrTempIntoAdr(syncUserInfo *syncUI,Address *adr)
{
 int i,j;

 for(i=0;i<syncUI->adr.phonAnz; i++)
  {
   for(j=0;j<ADR_FON_WORK_ANZ; j++)
    if(adr->fon[j][0] == '\0')
     {
      fillIntoAdrIfNonEmpty(syncUI,adr,adr->tmp->fon[i],phonTypes[j],adr->tmp->fonTempId[i]);
      break;
     }
  }

 for(i=0;i<syncUI->adr.mailAnz; i++)
  {
   for(j=0;j<ADR_MAIL_WORK_ANZ; j++)
    if(adr->mail[j][0] == '\0')
     {
      fillIntoAdrIfNonEmpty(syncUI,adr,adr->tmp->mail[i],mailTypes[j],adr->tmp->mailTempId[i]);
      break;
     }
  }

 for(i=0;i<syncUI->adr.mobileAnz; i++)
  {
   for(j=0;j<ADR_MOBIL_WORK_ANZ; j++)
    if(adr->mobile[j][0] == '\0')
     {
      fillIntoAdrIfNonEmpty(syncUI,adr,adr->tmp->mobile[i],mobileTypes[j],adr->tmp->mobileTempId[i]);
      break;
     }
  }

 for(i=0;i<syncUI->adr.faxAnz; i++)
  {
   for(j=0;j<ADR_FAX_WORK_ANZ; j++)
    if(adr->fax[j][0] == '\0')
     {
      fillIntoAdrIfNonEmpty(syncUI,adr,adr->tmp->fax[i],faxTypes[j],adr->tmp->faxTempId[i]);
      break;
     }
  }

 if(syncUI->adr.wwwAnz >=1)
  fillIntoAdrIfNonEmpty(syncUI,adr,adr->tmp->www,ADR_FIELD_WWW,adr->tmp->wwwTempId);

 for(i=0;i<syncUI->adr.adrAnz; i++)
  {
   adr->tmp->adrWithId[i] = false;
   for(j=0;j<ADR_ADR_ANZ-1; j++)
    if(!adr->tmp->adrFilled[j])
     {
      fillIntoAdrIfNonEmpty(syncUI,adr,adr->tmp->adr[i].addres[0],adrTypes[j][0],  adr->tmp->adrTempId[i][0]);
      fillIntoAdrIfNonEmpty(syncUI,adr,adr->tmp->adr[i].addres[1],adrTypes[j][1],  adr->tmp->adrTempId[i][1]);
      fillIntoAdrIfNonEmpty(syncUI,adr,adr->tmp->adr[i].addres[2],adrTypes[j][2],  adr->tmp->adrTempId[i][2]);
      fillIntoAdrIfNonEmpty(syncUI,adr,adr->tmp->adr[i].plz,      plzTypes[j],     adr->tmp->plzTempId[i]);
      fillIntoAdrIfNonEmpty(syncUI,adr,adr->tmp->adr[i].city,     cityTypes[j],    adr->tmp->cityTempId[i]);
      fillIntoAdrIfNonEmpty(syncUI,adr,adr->tmp->adr[i].country,  countryTypes[j], adr->tmp->countryTempId[i]);
      adr->tmp->adrWithId[i] = true;
      break;
     }
  }
 // check home-address
 adr->tmp->adrWithId[2] = true;
 if(adr->tmp->adrId[2][0] <0)
  if(adr->tmp->adrId[2][1] <0)
   if(adr->tmp->adrId[2][2] <0)
    if(adr->tmp->plzId[2]    <0)
     if(adr->tmp->cityId[2]    <0)
      if(adr->tmp->countryId[2]    <0)
       adr->tmp->adrWithId[2] = false;
}


//void fillIntoAdr(syncUserInfo *syncUI,Address *adr, char *t, int field)

inline void fillIntoAdr(syncUserInfo *syncUI,Address *adr, char *t, int fnr)
{
 fillIntoAdr(syncUI,adr,t,syncUI->csvImportFields[fnr],fnr);
}

void fillIntoAdrIfNonEmpty(syncUserInfo *syncUI,Address *adr, char *t, int field, int fnr)
{
 char *s;
 if(t!=NULL)
  {
   s=t;
   while(*s == ' ' || *s == '\t' || *s == '\n')
    s++;
   if(*s != '\0')
    fillIntoAdr(syncUI,adr,t,field,fnr);
  }
}
void fillIntoAdr(syncUserInfo *syncUI,Address *adr, char *t, int field, int fnr)
{
 char *p,*p2;
 int k=0;
 int l;
 char buf[65536];

 switch(field)
  {

  case ADR_FIELD_IGNORE :
   break;
  case ADR_FIELD_CAT :
   if(adr->tmp == NULL)
    adr->tmp = newAddressSyncTempStruct();
   for(k=0;k<syncUI->adr.blockedCatAnz; k++)
    if(strncasecmp(t,syncUI->adr.blockedCat[k],syncUI->adr.blockedCatLen[k]) == 0)
     adr->tmp->skip =true;
   break;
//   case ADR_FIELD_ID :
//    adr->id = atoi(t);
//    break;
  case ADR_FIELD_TITEL :
   strncpy(adr->titel,t,15);
   adr->titel[15]='\0';
   break;
  case ADR_FIELD_NAME_1 :
   strncpy(adr->name1,t,63);
   adr->name1[63]='\0';
   break;
  case ADR_FIELD_NAME_M :
   adr->nameM = t[0];
   break;
  case ADR_FIELD_NAME_2 :
   strncpy(adr->name2,t,63);
   adr->name2[63]='\0';
   break;
  case ADR_FIELD_NAME1M2 :
   // FIXME mittelinitail
   p = strrchr(t,' ');
   if(p == NULL)
    {
     strncpy(adr->name2,t,63);
     adr->name2[63]='\0';
    }
   else
    {
     strncpy(adr->name2,p,63);
     adr->name2[63]='\0';
     *p='\0';
     strncpy(adr->name1,p,63);
     adr->name1[63]='\0';
    }
   break;
  case ADR_FIELD_COMPS  :
   strncpy(adr->compShort,t,15);
   adr->compShort[15]='\0';
   break;
  case ADR_FIELD_COMPA  :
   strncpy(adr->company,t,63);
   adr->company[63]='\0';
   break;
  case ADR_FIELD_COMPPOS :
   strncpy(adr->compPos,t,31);
   adr->compPos[31]='\0';
   break;
  case ADR_FIELD_ADDR1A :
   strncpy(&adr->adr[0].addres[0][0],t,63);
   adr->adr[0].addres[0][63]='\0';
   adr->tmp->adrFilled[0] =true;
   adr->tmp->adrId[0][0] = fnr;
   break;
  case ADR_FIELD_ADDR1B :
   strncpy(&adr->adr[0].addres[1][0],t,63);
   adr->adr[0].addres[1][63]='\0';
   adr->tmp->adrFilled[0] =true;
   adr->tmp->adrId[0][1] = fnr;
   break;
  case ADR_FIELD_ADDR1C :
   strncpy(&adr->adr[0].addres[2][0],t,63);
   adr->adr[0].addres[2][63]='\0';
   adr->tmp->adrFilled[0] =true;
   adr->tmp->adrId[0][2] = fnr;
   break;
  case ADR_FIELD_PLZ1 :
   strncpy(&adr->adr[0].plz[0],t,15);
   adr->adr[0].plz[15]='\0';
   adr->tmp->adrFilled[0] =true;
   adr->tmp->plzId[0] = fnr;
   break;
  case ADR_FIELD_CITY1 :
   strncpy(&adr->adr[0].city[0],t,63);
   adr->adr[0].city[63]='\0';
   adr->tmp->adrFilled[0] =true;
   adr->tmp->cityId[0] = fnr;
   break;
  case ADR_FIELD_CNTRY1 :
   strncpy(&adr->adr[0].country[0],t,63);
   adr->adr[0].country[63]='\0';
   adr->tmp->adrFilled[0] =true;
   adr->tmp->countryId[0] = fnr;
   break;
  case ADR_FIELD_ADDR2A :
   strncpy(&adr->adr[1].addres[0][0],t,63);
   adr->adr[1].addres[0][63]='\0';
   adr->tmp->adrFilled[1] =true;
   adr->tmp->adrId[1][0] = fnr;
   break;
  case ADR_FIELD_ADDR2B :
   strncpy(&adr->adr[1].addres[1][0],t,63);
   adr->adr[1].addres[1][63]='\0';
   adr->tmp->adrFilled[1] =true;
   adr->tmp->adrId[1][1] = fnr;
   break;
  case ADR_FIELD_ADDR2C :
   strncpy(&adr->adr[1].addres[2][0],t,63);
   adr->adr[1].addres[2][63]='\0';
   adr->tmp->adrFilled[1] =true;
   adr->tmp->adrId[1][2] = fnr;
   break;
  case ADR_FIELD_PLZ2 :
   strncpy(&adr->adr[1].plz[0],t,15);
   adr->adr[1].plz[15]='\0';
   adr->tmp->adrFilled[1] =true;
   adr->tmp->plzId[1] = fnr;
   break;
  case ADR_FIELD_CITY2 :
   strncpy(&adr->adr[1].city[0],t,63);
   adr->adr[1].city[63]='\0';
   adr->tmp->adrFilled[1] =true;
   adr->tmp->cityId[1] = fnr;
   break;
  case ADR_FIELD_CNTRY2 :
   strncpy(&adr->adr[1].country[0],t,63);
   adr->adr[1].country[63]='\0';
   adr->tmp->adrFilled[1] =true;
   adr->tmp->countryId[1] = fnr;
   break;
  case ADR_FIELD_ADDR3A :
   strncpy(&adr->adr[2].addres[0][0],t,63);
   adr->adr[2].addres[0][63]='\0';
   adr->tmp->adrFilled[2] =true;
   adr->tmp->adrId[2][0] = fnr;
   break;
  case ADR_FIELD_ADDR3B :
   strncpy(&adr->adr[2].addres[1][0],t,63);
   adr->adr[2].addres[1][63]='\0';
   adr->tmp->adrFilled[2] =true;
   adr->tmp->adrId[2][1] = fnr;
   break;
  case ADR_FIELD_ADDR3C :
   strncpy(&adr->adr[2].addres[2][0],t,63);
   adr->adr[2].addres[2][63]='\0';
   adr->tmp->adrFilled[2] =true;
   adr->tmp->adrId[2][2] = fnr;
   break;
  case ADR_FIELD_PLZ3 :
   strncpy(&adr->adr[2].plz[0],t,15);
   adr->adr[2].plz[15]='\0';
   adr->tmp->adrFilled[2] =true;
   adr->tmp->plzId[2] = fnr;
   break;
  case ADR_FIELD_CITY3 :
   strncpy(&adr->adr[2].city[0],t,63);
   adr->adr[2].city[63]='\0';
   adr->tmp->adrFilled[2] =true;
   adr->tmp->cityId[2] = fnr;
   break;
  case ADR_FIELD_CNTRY3 :
   strncpy(&adr->adr[2].country[0],t,63);
   adr->adr[2].country[63]='\0';
   adr->tmp->adrFilled[2] =true;
   adr->tmp->countryId[2] = fnr;
   break;
  case ADR_FIELD_FON1 :
   strncpy(&adr->fon[0][0],t,31);
   adr->fon[0][31]='\0';
   if(adr->tmp == NULL)
    adr->tmp = newAddressSyncTempStruct();
   adr->tmp->fonId[0] = fnr;
   break;
  case ADR_FIELD_FON2 :
   strncpy(&adr->fon[1][0],t,31);
   adr->fon[1][31]='\0';
   if(adr->tmp == NULL)
    adr->tmp = newAddressSyncTempStruct();
   adr->tmp->fonId[1] = fnr;
   break;
  case ADR_FIELD_FON3 :
   strncpy(&adr->fon[2][0],t,31);
   adr->fon[2][31]='\0';
   if(adr->tmp == NULL)
    adr->tmp = newAddressSyncTempStruct();
   adr->tmp->fonId[2] = fnr;
   break;
  case ADR_FIELD_FON4 :
   strncpy(&adr->fon[3][0],t,31);
   adr->fon[3][31]='\0';
   if(adr->tmp == NULL)
    adr->tmp = newAddressSyncTempStruct();
   adr->tmp->fonId[3] = fnr;
   break;
  case ADR_FIELD_FON_P :
   strncpy(&adr->fon[4][0],t,31);
   adr->fon[4][31]='\0';
   if(adr->tmp == NULL)
    adr->tmp = newAddressSyncTempStruct();
   adr->tmp->fonId[4] = fnr;
   break;
  case ADR_FIELD_MOBILE1 :
   strncpy(&adr->mobile[0][0],t,31);
   adr->mobile[0][31]='\0';
   if(adr->tmp == NULL)
    adr->tmp = newAddressSyncTempStruct();
   adr->tmp->mobileId[0] = fnr;
   break;
  case ADR_FIELD_MOBILE2 :
   strncpy(&adr->mobile[1][0],t,31);
   adr->mobile[1][31]='\0';
   if(adr->tmp == NULL)
    adr->tmp = newAddressSyncTempStruct();
   adr->tmp->mobileId[1] = fnr;
   break;
  case ADR_FIELD_MOBILE_P :
   strncpy(&adr->mobile[2][0],t,31);
   adr->mobile[2][31]='\0';
   if(adr->tmp == NULL)
    adr->tmp = newAddressSyncTempStruct();
   adr->tmp->mobileId[2] = fnr;
   break;
  case ADR_FIELD_FAX :
   strncpy(&adr->fax[0][0],t,31);
   adr->fax[0][31]='\0';
   if(adr->tmp == NULL)
    adr->tmp = newAddressSyncTempStruct();
   adr->tmp->faxId[0] = fnr;
   break;
  case ADR_FIELD_FAX1 :
   strncpy(&adr->fax[0][0],t,31);
   adr->fax[0][31]='\0';
   if(adr->tmp == NULL)
    adr->tmp = newAddressSyncTempStruct();
   adr->tmp->faxId[0] = fnr;
   break;
  case ADR_FIELD_FAX2 :
   strncpy(&adr->fax[1][0],t,31);
   adr->fax[1][31]='\0';
   if(adr->tmp == NULL)
    adr->tmp = newAddressSyncTempStruct();
   adr->tmp->faxId[1] = fnr;
   break;
  case ADR_FIELD_FAX_P :
   strncpy(&adr->fax[2][0],t,31);
   adr->fax[2][31]='\0';
   if(adr->tmp == NULL)
    adr->tmp = newAddressSyncTempStruct();
   adr->tmp->faxId[2] = fnr;
   break;
  case ADR_FIELD_WWW :
   strncpy(&adr->www[0][0],t,127);
   adr->www[0][127]='\0';
   if(adr->tmp == NULL)
    adr->tmp = newAddressSyncTempStruct();
   adr->tmp->wwwId[0] = fnr;
   break;
  case ADR_FIELD_WWW_P :
   strncpy(&adr->www[1][0],t,127);
   adr->www[1][127]='\0';
   if(adr->tmp == NULL)
    adr->tmp = newAddressSyncTempStruct();
   adr->tmp->wwwId[1] = fnr;
   break;
  case ADR_FIELD_MAIL :
   strncpy(&adr->mail[0][0],t,63);
   adr->mail[0][63]='\0';
   if(adr->tmp == NULL)
    adr->tmp = newAddressSyncTempStruct();
   adr->tmp->mailId[0] = fnr;
   break;
  case ADR_FIELD_MAIL2 :
   strncpy(&adr->mail[1][0],t,63);
   adr->mail[1][63]='\0';
   if(adr->tmp == NULL)
    adr->tmp = newAddressSyncTempStruct();
   adr->tmp->mailId[1] = fnr;
   break;
  case ADR_FIELD_MAIL_P :
   strncpy(&adr->mail[2][0],t,63);
   adr->mail[2][63]='\0';
   if(adr->tmp == NULL)
    adr->tmp = newAddressSyncTempStruct();
   adr->tmp->mailId[2] = fnr;
   break;
  case ADR_FIELD_DESCR_S :
   strncpy(adr->descrShort,t,63);
   adr->descrShort[63]='\0';
   break;
  case ADR_FIELD_DESCR_L :
   strncpy(adr->descr,t,255);
   adr->descr[255]='\0';
   break;
  case ADR_FIELD_DESCR_L_ADD :
   if (strlen(t)>0)
    {
     l =255-strlen(adr->descr)-2;
     if(l>0)
      {
       strcat(adr->descr,"; ");
       strncat(adr->descr,t,l);
      }
     adr->descr[255]='\0';
    }
   break;
  case ADR_FIELD_DESCR_L_WITH_TAGS :
   {
    p = cutLineFromDescr(syncUI,adr,t);
    strncpy(adr->descr,p,255);
    adr->descr[255]='\0';
   }
   break;
  case ADR_FIELD_DESCR_L_ADD_WITH_TAGS :
   if (strlen(t)>0)
    {
     p = cutLineFromDescr(syncUI,adr,t);
     l =255-strlen(adr->descr)-2;
     if(l>0)
      {
       strcat(adr->descr,"; ");
       strncat(adr->descr,p,l);
      }
     adr->descr[255]='\0';
    }
   break;
  case ADR_FIELD_KONTO1INH :
   strncpy(&adr->kontoInh[0][0],t,31);
   adr->kontoInh[0][31]='\0';
   break;
  case ADR_FIELD_KONTO1NUM :
   strncpy(&adr->kontoNum[0][0],t,15);
   adr->kontoNum[0][15]='\0';
   break;
  case ADR_FIELD_KONTO1BNK :
   strncpy(&adr->kontoBank[0][0],t,31);
   adr->kontoBank[0][31]='\0';
   break;
  case ADR_FIELD_KONTO1BLZ :
   strncpy(&adr->kontoBLZ[0][0],t,15);
   adr->kontoBLZ[0][15]='\0';
   break;
  case ADR_FIELD_KONTO2INH :
   strncpy(&adr->kontoInh[1][0],t,31);
   adr->kontoInh[1][31]='\0';
   break;
  case ADR_FIELD_KONTO2NUM :
   strncpy(&adr->kontoNum[1][0],t,15);
   adr->kontoNum[1][15]='\0';
   break;
  case ADR_FIELD_KONTO2BNK :
   strncpy(&adr->kontoBank[1][0],t,31);
   adr->kontoBank[1][31]='\0';
   break;
  case ADR_FIELD_KONTO2BLZ :
   strncpy(&adr->kontoBLZ[1][0],t,15);
   adr->kontoBLZ[1][15]='\0';
   break;
  case ADR_FIELD_STEUER :
   strncpy(adr->steuer,t,31);
   adr->steuer[31]='\0';
   break;
  case ADR_FIELD_INFO1 :
   strncpy(&adr->info[0][0],t,255);
   adr->info[0][255]='\0';
   break;
  case ADR_FIELD_INFO2 :
   strncpy(&adr->info[1][0],t,255);
   adr->info[1][255]='\0';
   break;
  case ADR_FIELD_INFO1_ADD :
   if (strlen(t)>0)
    {
     l =255-strlen(&adr->info[0][0])-2;
     if(l>0)
      {
       strcat(&adr->info[0][0],"; ");
       strncat(&adr->info[0][0],t,l);
      }
     adr->info[0][255]='\0';
    }
   break;
  case ADR_FIELD_INFO2_ADD :
   if (strlen(t)>0)
    {
     l =255-strlen(&adr->info[1][0])-2;
     if(l>0)
      {
       strcat(&adr->info[1][0],"; ");
       strncat(&adr->info[1][0],t,l);
      }
     adr->info[1][255]='\0';
    }
   break;
  case ADR_FIELD_GEBURTST :
   strncpy(adr->geb,t,15);
   adr->geb[15]='\0';
   break;
  case ADR_FIELD_OWNER :
   adr->owner = owner2id(t);
   break;
  case ADR_FIELD_NOTEONLY :
   adr->noteOnly = owner2id(t);
   break;
  case ADR_FIELD_READONLY :
   adr->readOnly = owner2id(t);
   break;
  case ADR_FIELD_CREATE :
   break;
  case ADR_FIELD_CREATOR :
   adr->creator = uname2uid(t);
   if(adr->creator<0)
    adr->creator=0;
   break;
  case ADR_FIELD_CUSTOM1 :
   fillIntoAdr(syncUI, adr, t, syncUI->adr.customFields[0],fnr);
   break;
  case ADR_FIELD_CUSTOM2 :
   fillIntoAdr(syncUI, adr, t, syncUI->adr.customFields[1],fnr);
   break;
  case ADR_FIELD_CUSTOM3 :
   fillIntoAdr(syncUI, adr, t, syncUI->adr.customFields[2],fnr);
   break;
  case ADR_FIELD_CUSTOM4 :
   fillIntoAdr(syncUI, adr, t, syncUI->adr.customFields[3],fnr);
   break;
  case ADR_FIELD_CUSTOM5 :
   fillIntoAdr(syncUI, adr, t, syncUI->adr.customFields[4],fnr);
   break;
  case ADR_FIELD_CUSTOM6 :
   fillIntoAdr(syncUI, adr, t, syncUI->adr.customFields[5],fnr);
   break;
  case ADR_FIELD_CUSTOM7 :
   fillIntoAdr(syncUI, adr, t, syncUI->adr.customFields[6],fnr);
   break;
  case ADR_FIELD_CUSTOM8 :
   fillIntoAdr(syncUI, adr, t, syncUI->adr.customFields[7],fnr);
   break;
  case ADR_FIELD_FOLDER :
   int dirid;
   if( (dirid = folderName2dirid(t) ) <0)
    {
     if( (dirid = makeAdrFolder(t,adr->dirID, 0)) <0)
      break;
    }
   adr->dirID = dirid;
   break;
  case ADR_FIELD_MINKOID :
   char ref[64],*s;
   sprintf(ref,"Minkowsky%11s#",serverAddrID);
   s = strstr(t,ref);
   if( s!= NULL)
    adr->id = atoi(s+21);



  case ADR_PDA_PHON_TYPE:
   syncUI->adr.pdaPhonType = str2PDAtype(t);
   break;
  case ADR_PDA_PHON:
   fillPDAphone2Adr(syncUI,adr,t,fnr);
   break;
  case ADR_PDA_PHON_TMP:
   if(adr->tmp == NULL)
    adr->tmp = newAddressSyncTempStruct();
   if(syncUI->adr.phonAnz<ADR_FON_WORK_ANZ)
    {
     strncpy(adr->tmp->fon[syncUI->adr.phonAnz],t,31);
     adr->tmp->fon[syncUI->adr.phonAnz][31]='\0';
     adr->tmp->fonTempId[syncUI->adr.phonAnz] = fnr;
     syncUI->adr.phonAnz++;
    }
   break;
  case ADR_PDA_MOBILE_TMP:
   if(adr->tmp == NULL)
    adr->tmp = newAddressSyncTempStruct();
   if(syncUI->adr.mobileAnz<ADR_MOBIL_WORK_ANZ)
    {
     strncpy(adr->tmp->mobile[syncUI->adr.mobileAnz],t,31);
     adr->tmp->mobile[syncUI->adr.mobileAnz][31]='\0';
     adr->tmp->mobileTempId[syncUI->adr.mobileAnz] = fnr;
     syncUI->adr.mobileAnz++;
    }
   break;
  case ADR_PDA_FAX_TMP:
   if(adr->tmp == NULL)
    adr->tmp = newAddressSyncTempStruct();
   if(syncUI->adr.faxAnz<ADR_FAX_WORK_ANZ)
    {
     strncpy(adr->tmp->fax[syncUI->adr.faxAnz],t,31);
     adr->tmp->fax[syncUI->adr.faxAnz][31]='\0';
     adr->tmp->faxTempId[syncUI->adr.faxAnz] = fnr;
     syncUI->adr.faxAnz++;
    }
   break;
  case ADR_PDA_MAIL_TMP:
   if(adr->tmp == NULL)
    adr->tmp = newAddressSyncTempStruct();
   if(syncUI->adr.mailAnz<ADR_MAIL_WORK_ANZ)
    {
     strncpy(adr->tmp->mail[syncUI->adr.mailAnz],t,63);
     adr->tmp->mail[syncUI->adr.mailAnz][63]='\0';
     adr->tmp->mailTempId[syncUI->adr.mailAnz] = fnr;
     syncUI->adr.mailAnz++;
    }
   break;
  case ADR_PDA_WWW_TMP:
   if(adr->tmp == NULL)
    adr->tmp = newAddressSyncTempStruct();
   if(syncUI->adr.wwwAnz<ADR_WWW_WORK_ANZ)
    {
     strncpy(adr->tmp->www,t,127);
     adr->tmp->www[127]='\0';
     adr->tmp->wwwTempId = fnr;
     syncUI->adr.wwwAnz++;
    }
   break;
  case ADR_PDA_ADR_TYPE:
   syncUI->adr.pdaAdrType = str2PDAtype(t);
   if(syncUI->adr.pdaAdrType == PDA_TYPE_HOME )
    {
     if(syncUI->adr.pdaAdrTypeHomeDone)
      syncUI->adr.pdaAdrType = PDA_TYPE_OTHER;
     else 
      syncUI->adr.pdaAdrTypeHomeDone =true;
    }

   if(syncUI->adr.pdaAdrType != PDA_TYPE_HOME )
    {
     syncUI->adr.adrAnz++;
     syncUI->adr.adrNum++;
    }
   break;
  case ADR_PDA_ADR_A:
   if(syncUI->adr.pdaAdrType == PDA_TYPE_HOME)
    fillIntoAdrIfNonEmpty(syncUI,adr,t,ADR_FIELD_ADDR3A,fnr);
   else 
    fillIntoAdr(syncUI,adr,t,ADR_PDA_ADR_TMP_A,fnr);
   break;
  case ADR_PDA_ADR_B:
   if(syncUI->adr.pdaAdrType == PDA_TYPE_HOME)
    fillIntoAdrIfNonEmpty(syncUI,adr,t,ADR_FIELD_ADDR3B,fnr);
   else 
    fillIntoAdr(syncUI,adr,t,ADR_PDA_ADR_TMP_B,fnr);
   break;
  case ADR_PDA_ADR_C:
   if(syncUI->adr.pdaAdrType == PDA_TYPE_HOME)
    fillIntoAdrIfNonEmpty(syncUI,adr,t,ADR_FIELD_ADDR3C,fnr);
   else 
    fillIntoAdr(syncUI,adr,t,ADR_PDA_ADR_TMP_C,fnr);
   break;
  case ADR_PDA_ADR_PLZ:
   if(syncUI->adr.pdaAdrType == PDA_TYPE_HOME)
    fillIntoAdrIfNonEmpty(syncUI,adr,t,ADR_FIELD_PLZ3,fnr);
   else 
    fillIntoAdr(syncUI,adr,t,ADR_PDA_ADR_TMP_PLZ,fnr);
   break;
  case ADR_PDA_ADR_CITY:
   if(syncUI->adr.pdaAdrType == PDA_TYPE_HOME)
    fillIntoAdrIfNonEmpty(syncUI,adr,t,ADR_FIELD_CITY3,fnr);
   else 
    fillIntoAdr(syncUI,adr,t,ADR_PDA_ADR_TMP_CITY,fnr);
   break;
  case ADR_PDA_ADR_CNTRY:
   if(syncUI->adr.pdaAdrType == PDA_TYPE_HOME)
    fillIntoAdrIfNonEmpty(syncUI,adr,t,ADR_FIELD_CNTRY3,fnr);
   else 
    fillIntoAdr(syncUI,adr,t,ADR_PDA_ADR_TMP_CNTRY,fnr);
   break;
  case ADR_PDA_ADR_TMP_A:
   if(syncUI->adr.adrAnz<3)
    {
     strncpy(&adr->tmp->adr[syncUI->adr.adrNum].addres[0][0],t,63);
     adr->tmp->adr[syncUI->adr.adrNum].addres[0][63]='\0';
     adr->tmp->adrTempId[syncUI->adr.adrNum][0] = fnr;
    }
   break;
  case ADR_PDA_ADR_TMP_B:
   if(syncUI->adr.adrAnz<3)
    {
     strncpy(&adr->tmp->adr[syncUI->adr.adrNum].addres[1][0],t,63);
     adr->tmp->adr[syncUI->adr.adrNum].addres[1][63]='\0';
     adr->tmp->adrTempId[syncUI->adr.adrNum][1] = fnr;
    }
   break;
  case ADR_PDA_ADR_TMP_C:
   if(syncUI->adr.adrAnz<3)
    {
     strncpy(&adr->tmp->adr[syncUI->adr.adrNum].addres[2][0],t,63);
     adr->tmp->adr[syncUI->adr.adrNum].addres[2][63]='\0';
     adr->tmp->adrTempId[syncUI->adr.adrNum][2] = fnr;
    }
   break;
  case ADR_PDA_ADR_TMP_PLZ:
   if(syncUI->adr.adrAnz<3)
    {
     strncpy(&adr->tmp->adr[syncUI->adr.adrNum].plz[0],t,15);
     adr->tmp->adr[syncUI->adr.adrNum].plz[15]='\0';
     adr->tmp->plzTempId[syncUI->adr.adrNum] = fnr;
    }
   break;
  case ADR_PDA_ADR_TMP_CITY:
   if(syncUI->adr.adrAnz<3)
    {
     strncpy(&adr->tmp->adr[syncUI->adr.adrNum].city[0],t,63);
     adr->tmp->adr[syncUI->adr.adrNum].city[63]='\0';
     adr->tmp->cityTempId[syncUI->adr.adrNum] = fnr;
    }
   break;
  case ADR_PDA_ADR_TMP_CNTRY:
   if(syncUI->adr.adrAnz<3)
    {
     strncpy(&adr->tmp->adr[syncUI->adr.adrNum].country[0],t,63);
     adr->tmp->adr[syncUI->adr.adrNum].country[63]='\0';
     adr->tmp->countryTempId[syncUI->adr.adrNum] = fnr;
    }
   break;
  
  }
}

void fillPDAphone2Adr(syncUserInfo *syncUI,Address *adr, char *t,int fnr)
{
 switch (syncUI->adr.pdaPhonType)
  {
  case PDA_TYPE_HOME:
   if(syncUI->adr.phonPrivAnz<ADR_FON_PRIV_ANZ)
    {
     fillIntoAdr(syncUI,adr,t,ADR_FIELD_FON_P,fnr);
     syncUI->adr.phonPrivAnz++;
    }
   else           
    fillIntoAdr(syncUI,adr,t,ADR_PDA_PHON_TMP,fnr);
   break;

  case PDA_TYPE_HOMEMOBILE:
   if(syncUI->adr.mobilePrivAnz<ADR_MOBIL_PRIV_ANZ)
    {
     fillIntoAdr(syncUI,adr,t,ADR_FIELD_MOBILE_P,fnr);
     syncUI->adr.mobilePrivAnz++;
    }
   else           
    fillIntoAdr(syncUI,adr,t,ADR_PDA_MOBILE_TMP,fnr);
   break;

  case PDA_TYPE_HOMEMAIL:
   if(syncUI->adr.mailPrivAnz<ADR_MAIL_PRIV_ANZ)
    {
     fillIntoAdr(syncUI,adr,t,ADR_FIELD_MAIL_P,fnr);
     syncUI->adr.mailPrivAnz++;
    }
   else           
    fillIntoAdr(syncUI,adr,t,ADR_PDA_MAIL_TMP,fnr);
   break;

  case PDA_TYPE_HOMEURL:
   if(syncUI->adr.wwwPrivAnz<ADR_WWW_PRIV_ANZ)
    {
     fillIntoAdr(syncUI,adr,t,ADR_FIELD_WWW_P,fnr);
     syncUI->adr.wwwPrivAnz++;
    }
   else           
    fillIntoAdr(syncUI,adr,t,ADR_PDA_WWW_TMP,fnr);
   break;
  case PDA_TYPE_HOMEFAX:
   if(syncUI->adr.faxPrivAnz<ADR_FAX_PRIV_ANZ)
    {
     fillIntoAdr(syncUI,adr,t,ADR_FIELD_FAX_P,fnr);
     syncUI->adr.faxPrivAnz++;
    }
   else
    fillIntoAdr(syncUI,adr,t,ADR_PDA_FAX_TMP,fnr);
   break;
   
  case PDA_TYPE_FAX:
   if(syncUI->adr.faxAnz<ADR_FAX_WORK_ANZ)
    fillIntoAdr(syncUI,adr,t,ADR_PDA_FAX_TMP,fnr);
   else           
    fillIntoAdr(syncUI,adr,t,ADR_PDA_PHON_TMP,fnr);
   break;
  case PDA_TYPE_MOBILE:
   if(syncUI->adr.mobileAnz<ADR_MOBIL_WORK_ANZ)
    fillIntoAdr(syncUI,adr,t,ADR_PDA_MOBILE_TMP,fnr);
   else           
    fillIntoAdr(syncUI,adr,t,ADR_PDA_PHON_TMP,fnr);
   break;
  case PDA_TYPE_EMAIL:
   fillIntoAdr(syncUI,adr,t,ADR_PDA_MAIL_TMP,fnr);
   break;
  case PDA_TYPE_URL:
   fillIntoAdr(syncUI,adr,t,ADR_PDA_WWW_TMP,fnr);
   break;
  case PDA_TYPE_OTHER:
  case PDA_TYPE_MAIN:
  case PDA_TYPE_WORK:
  case PDA_TYPE_PAGER:
  default:
   fillIntoAdr(syncUI,adr,t,ADR_PDA_PHON_TMP,fnr);
   break;
  }
}
int str2PDAtype(char *t)
{
 for (int i =0 ; i<PDA_DATA_TYPE_ANZ ; i++)
  if(strcasecmp(t,pdaDataType[i].tag)==0)
   return(pdaDataType[i].id);
 return 0;
}


void syncAdrIntoAdr(syncUserInfo *syncUI,Address *dest, Address *src,int copyEmpty)
{
 int i,j;

 // dest->id      = src->id;
 // dest->owner   = src->owner;
 // dest->deleted = false;
 if(copyEmpty || '\0' == *(src->titel))
  strcpy( dest->titel     ,src->titel      );
 if(copyEmpty || '\0' == *(src->name1))
  strcpy( dest->name1     ,src->name1      );
 if(copyEmpty || '\0' ==   src->nameM )
  dest->nameM             = src->nameM;
 if(copyEmpty || '\0' == *(src->name2))
  strcpy( dest->name2     ,src->name2      );
 if(copyEmpty || '\0' == *(src->compShort))
  strcpy( dest->compShort ,src->compShort  );
 if(copyEmpty || '\0' == *(src->company))
  strcpy( dest->company   ,src->company    );
 if(copyEmpty || '\0' == *(src->compPos))
  strcpy( dest->compPos   ,src->compPos    );
 for(j=0;j<3; j++)
  {
   if(copyEmpty || '\0' == *(src->adr[j].addres[0]))
    strcpy( dest->adr[j].addres[0]  ,src->adr[j].addres[0]);
   if(copyEmpty || '\0' == *(src->adr[j].addres[1]))
    strcpy( dest->adr[j].addres[1]  ,src->adr[j].addres[1]);
   if(copyEmpty || '\0' == *(src->adr[j].addres[2]))
    strcpy( dest->adr[j].addres[2]  ,src->adr[j].addres[2]);
   if(copyEmpty || '\0' == *(src->adr[j].plz))
    strcpy( dest->adr[j].plz        ,src->adr[j].plz     );
   if(copyEmpty || '\0' == *(src->adr[j].city))
    strcpy( dest->adr[j].city       ,src->adr[j].city    );
   if(copyEmpty || '\0' == *(src->adr[j].country))
    strcpy( dest->adr[j].country    ,src->adr[j].country    );
  }
 for(j=0;j<5; j++)
  if(copyEmpty || '\0' == *(src->fon[j]))
   strcpy( dest->fon[j]    ,src->fon[j]     );
 for(j=0;j<3; j++)
  {
   if(copyEmpty || '\0' == *(src->mobile[j]))
    strcpy( dest->mobile[j] ,src->mobile[j]     );
   if(copyEmpty || '\0' == *(src->fax[j]))
    strcpy( dest->fax[j]    ,src->fax[j]     );
   if(copyEmpty || '\0' == *(src->mail[j]))
    strcpy( dest->mail[j]   ,src->mail[j]    );
  }
 for(j=0;j<2; j++)
  {
   if(copyEmpty || '\0' ==  *(src->www[j]))
    strcpy( dest->www[j]     ,src->www[j]     );
   if(copyEmpty || '\0' ==  *(src->kontoInh[j]))
    strcpy(dest->kontoInh[j] ,src->kontoInh[j]);
   if(copyEmpty || '\0' ==  *(src->kontoNum[j]))
    strcpy(dest->kontoNum[j] ,src->kontoNum[j]);
   if(copyEmpty || '\0' ==  *(src->kontoBank[j]))
    strcpy(dest->kontoBank[j],src->kontoBank[j]);
   if(copyEmpty || '\0' ==  *(src->kontoBLZ[j]))
    strcpy(dest->kontoBLZ[j] ,src->kontoBLZ[j]);
  }
 if(copyEmpty || '\0' ==  *(src->steuer))
  strcpy(dest->steuer      ,src->steuer);
 if(copyEmpty || '\0' ==  *(src->geb))
  strcpy(dest->geb         ,src->geb);
 if(copyEmpty || '\0' ==  *(src->info[0]))
  strcpy(dest->info[0]     ,src->info[0]);
 if(copyEmpty || '\0' ==  *(src->info[1]))
  strcpy(dest->info[1]     ,src->info[1]);
 if(copyEmpty || '\0' ==  *(src->descrShort))
  strcpy(dest->descrShort  ,src->descrShort );
 if(copyEmpty || '\0' ==  *(src->descr))
  strcpy(dest->descr       ,src->descr      );
 
 
 dest->modified  = today;
 //FIXME
 dest->modifier  = syncUI->ctrl->user->id;
 memset(dest->reserved,0,sizeof(char)*256);
 memset(dest->resv,0,sizeof(int)*8);
 dest->action =NULL;
}

int addressDiffers(Address *neu, Address *ref)
{
 int i,j;

 if(!stringIdentical(neu->titel           ,ref->titel           )) return true;
 if(!stringIdentical(neu->name1           ,ref->name1           )) return true;
 if(!charIdentical  (neu->nameM           ,ref->nameM           )) return true;
 if(!stringIdentical(neu->name2           ,ref->name2           )) return true;
 if(!stringIdentical(neu->compShort       ,ref->compShort       )) return true;
 if(!stringIdentical(neu->compPos         ,ref->compPos         )) return true;
 if(!stringIdentical(neu->company         ,ref->company         )) return true;
 for(i=0;i<ADR_ADR_ANZ;i++)
  {
   for(j=0;j<3;j++)
    if(!stringIdentical(neu->adr[i].addres[j]   ,ref->adr[i].addres[j]    )) return true;
   if(!stringIdentical(neu->adr[i].plz          ,ref->adr[i].plz          )) return true;
   if(!stringIdentical(neu->adr[i].city         ,ref->adr[i].city         )) return true;
   if(!stringIdentical(neu->adr[i].country      ,ref->adr[i].country      )) return true;
  }
 for(i=0;i<ADR_FON_ANZ;i++)
  if(!stringIdentical(neu->fon[i]          ,ref->fon[i]          )) return true;
 for(i=0;i<ADR_MOBIL_ANZ;i++)
  if(!stringIdentical(neu->mobile[i]       ,ref->mobile[i]       )) return true;
 for(i=0;i<ADR_MAIL_ANZ;i++)
  if(!stringIdentical(neu->mail[i]         ,ref->mail[i]         )) return true;
 for(i=0;i<ADR_FAX_ANZ;i++)
   if(!stringIdentical(neu->fax[i]          ,ref->fax[i]          )) return true;
 for(i=0;i<ADR_WWW_ANZ;i++)
   if(!stringIdentical(neu->www[i]          ,ref->www[i]          )) return true;    

 for(i=0;i<ADR_KONTO_ANZ;i++)
  {
   if(!stringIdentical(neu->kontoInh[i]     ,ref->kontoInh[i]     )) return true;
   if(!stringIdentical(neu->kontoNum[i]     ,ref->kontoNum[i]     )) return true;
   if(!stringIdentical(neu->kontoBank[i]    ,ref->kontoBank[i]    )) return true;
   if(!stringIdentical(neu->kontoBLZ[i]     ,ref->kontoBLZ[i]     )) return true;
  }
 for(i=0;i<ADR_INFO_ANZ;i++)
   if(!stringIdentical(neu->info[i]         ,ref->info[i]         )) return true;

 if(!stringIdentical(neu->steuer          ,ref->steuer          )) return true;
 if(!stringIdentical(neu->geb             ,ref->geb             )) return true;

 return false;
} 

int stringIdentical(char *neu , char *ref)
{
 if(neu==NULL && ref==NULL)
  return true;
 if(neu==NULL)
  return false;
 if(ref==NULL)
  return false;

 if(*neu=='\0' && *ref == '\0')
  return true;
 if(*neu=='\0')
  return false;
 if(*ref=='\0')
  return false;

 if(strcmp(neu,ref) != 0)
  return false;
 return true;
}
int charIdentical(char t1 , char t2)
{
 if(t1==t2)
  return true;
 return false;
}

char *cutLineFromDescr(syncUserInfo *syncUI,Address *adr, char *str)
{
 static char buf [65536],buf2[4096];
 char *p,*p2;
 int field,l;
 
 p =str;
 buf[0]='\0';
 while ( p != NULL)
  {
   p2=strchr(p,'\n');
   if(p2!=NULL)
    l=p2-p;
   else
    l=strlen(p);
   strncpy (buf2,p,l);
   buf2[l]='\0';
   field = tagInTaggedAdrText (buf2);
   if (field == -1)
    {
     strcat(buf,buf2);
     strcat(buf,"\n");
    }
   else
    fillIntoAdr(syncUI, adr,p,field);
   if(p2!=NULL)
    p=p2+1;
   if(*p=='\0')
    break;
  }
 return(buf);
} 

int tagInTaggedAdrText(char *str)
{
 int i;
 for(i=0;i<adrDescrTagsAnz; i++)
  if ( strncmp(adrDescrTags[i].tag,str,strlen(adrDescrTags[i].tag)) == 0)
   return(adrDescrTags[i].field);

 return -1;
}


void fillInputIntoCsvIfNull(syncUserInfo *syncUI,  csvData *out,csvData *inp, int fnr);
void fillDefaultIntoCsvIfNull(syncUserInfo *syncUI,  csvData *out, int fnr);
void fillEmptyIntoCsvIfNull(csvData *out, int fnr);
int  conditionalFillPDAfon(syncUserInfo *syncUI, AddressSyncTemp *ast,int fid,char *val);
void fillPDAfield(syncUserInfo *syncUI, AddressSyncTemp *ast, int fnr,char *val, int useDefaultType);
int nextPDAfonField (syncUserInfo *syncUI, csvData *out);
int * nextPDAadrFields(syncUserInfo *syncUI, csvData *out);
void fillAdrDataIntoCsv(syncUserInfo *syncUI, csvData *out, Address *adr, int fnr,int type);
void fillAdrDataIntoStr(syncUserInfo *syncUI, char **strp, Address *adr, int type);

void  fillAdressIntoCsv( syncUserInfo *syncUI, Address *adr);

int  syncAccess2Adr(int uid, Address *adr)
{
 if(adr->blocked)
  return false;
 return access2Adr(uid,adr);
}

csvData *  getnextAdrListCsv (int uid, syncUserInfo *syncUI)
{
 int access;

 
 syncUI->listPtr ++;

 if(syncUI->listPtr >=adrAnz)
  return NULL;

 if(syncUI->listPtr <adrAnz)
  {
   while( !(access = syncAccess2Adr(uid,adrList[syncUI->listPtr]))) 
    {
     syncUI->listPtr ++;
     if(syncUI->listPtr >=adrAnz)
       return NULL;
    }
  }

 if(!access)
  return(NULL);

 fillAdressIntoCsv(syncUI,adrList[syncUI->listPtr]);
 return(adrList[syncUI->listPtr]->tmp->csvOut);
}

void  fillAdressIntoCsv( syncUserInfo *syncUI, Address *adr)
{
 csvData *out;
 csvData *inp;
 int i,fnr,typeFnr;

 if(adr->tmp == NULL)
  adr->tmp = newAddressSyncTempStruct();
 if(adr->tmp->csvIn == NULL)
  adr->tmp->csvIn = newCsvDataStruct (syncUI->syncFieldCount);
   
//    for(int i=0; i<adr->tmp->csvIn->cols ; i++)
//     {
//      adr->tmp->csvIn->col[i] = new char [2];
//      adr->tmp->csvIn->col[i][0] ='\0';
//     }
//  }
 inp = adr->tmp->csvIn;
  

 if(adr->tmp->csvOut != NULL)
  delete adr->tmp->csvOut;
 adr->tmp->csvOut =  newCsvDataStruct (syncUI->syncFieldCount);
 out = adr->tmp->csvOut;

 clearCsvData(out);
 adr->tmp->adrExported[0] = false;
 adr->tmp->adrExported[1] = false;
 adr->tmp->adrExported[2] = false;

 // fillAddressWith ID
 for(i=0 ; i<ADR_ADR_ANZ ; i++)
  {
   if(adr->tmp->adrFilled[i])
    if(adr->tmp->adrWithId[i])
     {
      int fnr=-1,typeFnr;
      printf("exporting adr %d of address %d\n",i,adr->id);
      // fields that doen't have id>=0 are not synced in and hence have equivalent on PDA
      // (This are only address which has been synec.compared in already)
      if(adr->tmp->adrId[i][0] >= 0)
       {
	allocateAndCopy( out,adr->tmp->adrId[i][0], adr->adr[i].addres[0]);
	fnr = adr->tmp->adrId[i][0];
       }
      if(adr->tmp->adrId[i][1] >= 0)
       {
	allocateAndCopy( out,adr->tmp->adrId[i][1], adr->adr[i].addres[1]);
	fnr = adr->tmp->adrId[i][1];
       }
      if(adr->tmp->adrId[i][2] >= 0)
       {
	allocateAndCopy( out,adr->tmp->adrId[i][2], adr->adr[i].addres[2]);
 	fnr = adr->tmp->adrId[i][2];
       }
      if(adr->tmp->plzId[i] >= 0)
       {
	allocateAndCopy( out,adr->tmp->plzId[i],    adr->adr[i].plz);
	fnr = adr->tmp->plzId[i];
       }
      if(adr->tmp->cityId[i] >= 0)
       {
	allocateAndCopy( out,adr->tmp->cityId[i],   adr->adr[i].city);
	fnr = adr->tmp->cityId[i];
       }
      if(adr->tmp->countryId[i] >= 0)
       {
	allocateAndCopy( out,adr->tmp->countryId[i],adr->adr[i].country);
	fnr = adr->tmp->countryId[i];
       }
      if(fnr>0)
       if ( (typeFnr = syncUI->csvImportTypeField[fnr]) >= 0 )
	allocateAndCopy( out, typeFnr, inp->col[syncUI->csvImportTypeField[fnr]]);
      adr->tmp->adrExported[i] = true;
     }
  }
 // fillAddress (rest) // FIXME PDA_ADR
 for(i=0 ; i<ADR_ADR_ANZ ; i++)
  {
   if(adr->tmp->adrFilled[i])
    if(!adr->tmp->adrExported[i])
     {
      int * adrFields = nextPDAadrFields(syncUI,out);
      if(adrFields[0]>=0)
       fillPDAfield(syncUI, adr->tmp,adrFields[0],adr->adr[i].addres[0], true);
      if(adrFields[1]>=0)
       fillPDAfield(syncUI, adr->tmp,adrFields[1],adr->adr[i].addres[1], true);
      //       allocateAndCopy( out,adrFields[1], adr->adr[i].addres[1]);
      if(adrFields[2]>=0)
       fillPDAfield(syncUI, adr->tmp,adrFields[2],adr->adr[i].addres[2], true);
      if(adrFields[3]>=0)
       fillPDAfield(syncUI, adr->tmp,adrFields[3],adr->adr[i].plz,       true);
      if(adrFields[4]>=0)
       fillPDAfield(syncUI, adr->tmp,adrFields[4],adr->adr[i].city,      true);
      if(adrFields[5]>=0)
       fillPDAfield(syncUI, adr->tmp,adrFields[5],adr->adr[i].country,   true);
      adr->tmp->adrExported[i] = true;
     }
  }
 

 // fill communications with ID
 for(i=0 ; i<ADR_FON_ANZ ; i++)
  if(adr->tmp->fonId[i]>=0 )
   fillPDAfield(syncUI, adr->tmp, adr->tmp->fonId[i],    adr->fon[i],    false);  
 for(i=0 ; i<ADR_MOBIL_ANZ ; i++)
  if(adr->tmp->mobileId[i]>=0 )
   fillPDAfield(syncUI, adr->tmp, adr->tmp->mobileId[i], adr->mobile[i], false);  
 for(i=0 ; i<ADR_FAX_ANZ ; i++)
  if(adr->tmp->faxId[i]>=0 )
   fillPDAfield(syncUI, adr->tmp, adr->tmp->faxId[i],    adr->fax[i],    false);  
 for(i=0 ; i<ADR_MAIL_ANZ ; i++)
  if(adr->tmp->mailId[i]>=0 )
   fillPDAfield(syncUI, adr->tmp, adr->tmp->mailId[i],   adr->mail[i],   false);  
 for(i=0 ; i<ADR_WWW_ANZ ; i++)
  if(adr->tmp->wwwId[i]>=0 )
   fillPDAfield(syncUI, adr->tmp, adr->tmp->wwwId[i],    adr->www[i],    false);  


 // Fill Communcation Rest 
 // fill order fon_0  mobile_0 fax_0 mail_0 www_0 fon_p mobile_p fax_p mail_p www_p 
 //            fon(rest) mobile(rest) fax(rest) mail(rest) www(rest)


 int cont=false;
 if(conditionalFillPDAfon(syncUI, adr->tmp,     adr->tmp->fonId[0],    adr->fon[0]))
  if(conditionalFillPDAfon(syncUI, adr->tmp,    adr->tmp->mobileId[0], adr->mobile[0]))
   if(conditionalFillPDAfon(syncUI, adr->tmp,   adr->tmp->faxId[0],    adr->fax[0]))
    if(conditionalFillPDAfon(syncUI, adr->tmp,  adr->tmp->mailId[0],   adr->mail[0]))
     if(conditionalFillPDAfon(syncUI, adr->tmp, adr->tmp->wwwId[0],    adr->www[0]))
      cont=true;
 
 if(cont)
  {
   cont =false;
   if(conditionalFillPDAfon(syncUI, adr->tmp,    
			    adr->tmp->fonId[ADR_FON_PRIV_FNR],      adr->fon[ADR_FON_PRIV_FNR]))
    if(conditionalFillPDAfon(syncUI, adr->tmp, 
			     adr->tmp->mobileId[ADR_MOBIL_PRIV_FNR],adr->mobile[ADR_MOBIL_PRIV_FNR]))
     if(conditionalFillPDAfon(syncUI, adr->tmp,  
			      adr->tmp->faxId[ADR_FAX_PRIV_FNR],    adr->fax[ADR_FAX_PRIV_FNR]))
      if(conditionalFillPDAfon(syncUI, adr->tmp, 
			       adr->tmp->mailId[ADR_MAIL_PRIV_FNR], adr->mail[ADR_MAIL_PRIV_FNR]))
       if(conditionalFillPDAfon(syncUI, adr->tmp,
				adr->tmp->wwwId[ADR_WWW_PRIV_FNR],  adr->www[ADR_WWW_PRIV_FNR]))
	cont = true;
  }

 if(cont)
  for(i=1; i< ADR_FON_WORK_ANZ ; i++)
   if(!conditionalFillPDAfon(syncUI, adr->tmp,     adr->tmp->fonId[i],    adr->fon[i]))
    {
     cont =false;
     break;
    }
 if(cont)
  for(i=1; i< ADR_MOBIL_WORK_ANZ ; i++)
   if(!conditionalFillPDAfon(syncUI, adr->tmp,     adr->tmp->mobileId[i], adr->mobile[i]))
    {
     cont =false;
     break;
    }
 if(cont)
  for(i=1; i< ADR_FAX_WORK_ANZ ; i++)
   if(!conditionalFillPDAfon(syncUI, adr->tmp,     adr->tmp->faxId[i],    adr->fax[i]))
    {
     cont =false;
     break;
    }
 if(cont)
  for(i=1; i< ADR_MAIL_WORK_ANZ ; i++)
   if(!conditionalFillPDAfon(syncUI, adr->tmp,     adr->tmp->mailId[i],    adr->mail[i]))
    {
     cont =false;
     break;
    }
 if(cont)
  for(i=1; i< ADR_WWW_WORK_ANZ ; i++)
   if(!conditionalFillPDAfon(syncUI, adr->tmp,     adr->tmp->wwwId[i],    adr->www[i]))
    {
     cont =false;
     break;
    }


 // fill all other fields
 for (i=0;i< syncUI->syncFieldCount ; i++)
  {
   if(out->col[i] == NULL)
    fillAdrDataIntoCsv(syncUI,out,adr,i,syncUI->csvImportFields[i]);
  }
}


void fillAdrDataIntoCsv(syncUserInfo *syncUI,csvData *out, Address *adr, int fnr,int type)
{

 switch (type)
  {
  case ADR_PDA_PHON:
  case ADR_PDA_ADR:
  case ADR_PDA_ADR_A:
  case ADR_PDA_ADR_B:
  case ADR_PDA_ADR_C:
  case ADR_PDA_ADR_PLZ:
  case ADR_PDA_ADR_CITY:
  case ADR_PDA_ADR_CNTRY:
   fillEmptyIntoCsvIfNull(out, fnr);
   break;

  case ADR_PDA_PHON_TYPE:
  case ADR_PDA_ADR_TYPE:
  case ADR_FIELD_IGNORE:
  case ADR_FIELD_CREATE:
   fillInputIntoCsvIfNull(syncUI,  out, adr->tmp->csvIn, fnr);
   break;

  case ADR_FIELD_CUSTOM1:
   fillAdrDataIntoCsv(syncUI, out, adr, fnr,syncUI->adr.customFields[0]); break;
  case ADR_FIELD_CUSTOM2:
   fillAdrDataIntoCsv(syncUI, out, adr, fnr,syncUI->adr.customFields[1]); break;
  case ADR_FIELD_CUSTOM3:
   fillAdrDataIntoCsv(syncUI, out, adr, fnr,syncUI->adr.customFields[2]); break;
  case ADR_FIELD_CUSTOM4:
   fillAdrDataIntoCsv(syncUI, out, adr, fnr,syncUI->adr.customFields[3]); break;
  case ADR_FIELD_CUSTOM5:
   fillAdrDataIntoCsv(syncUI, out, adr, fnr,syncUI->adr.customFields[4]); break;
  case ADR_FIELD_CUSTOM6:
   fillAdrDataIntoCsv(syncUI, out, adr, fnr,syncUI->adr.customFields[5]); break;
  case ADR_FIELD_CUSTOM7:
   fillAdrDataIntoCsv(syncUI, out, adr, fnr,syncUI->adr.customFields[6]); break;
  case ADR_FIELD_CUSTOM8:
   fillAdrDataIntoCsv(syncUI, out, adr, fnr,syncUI->adr.customFields[7]); break;


  case ADR_FIELD_CAT:   
   if(adr->tmp->csvIn->col[fnr] == NULL)
    allocateAndCopy( out, fnr, syncUI->adr.defaultCategory);
   else
    allocateAndCopy( out, fnr, adr->tmp->csvIn->col[fnr] );
   break;
  default:
   fillAdrDataIntoStr(syncUI, &out->col[fnr],adr,type);
   break;
  }
}
void fillAdrDataIntoStr(syncUserInfo *syncUI,char **strp, Address *adr, int type)
{
 char txt[32768],*t;
 int i;
 
 switch (type)
  {
//   case ADR_FIELD_ID:
//    allocateAndCopy( strp, adr->id); break;
  case ADR_FIELD_TITEL:
   allocateAndCopy( strp, adr->titel); break;
  case ADR_FIELD_NAME_1:
   allocateAndCopy( strp, adr->name1); break;
  case ADR_FIELD_NAME_M:
   allocateAndCopy( strp, adr->nameM); break;
  case ADR_FIELD_NAME_2:
   allocateAndCopy( strp, adr->name2); break;
  case ADR_FIELD_NAME1M2:
   sprintf("%s %c. %s",adr->name1,adr->nameM,adr->name2);
   allocateAndCopy( strp, txt); break;
  case ADR_FIELD_COMPS:
   allocateAndCopy( strp, adr->compShort); break;
  case ADR_FIELD_COMPA:
   allocateAndCopy( strp, adr->company); break;
  case ADR_FIELD_COMPPOS:
   allocateAndCopy( strp, adr->compPos); break;
  case ADR_FIELD_ADDR1A:
   allocateAndCopy( strp, adr->adr[0].addres[0]); break;
  case ADR_FIELD_ADDR1B:
   allocateAndCopy( strp, adr->adr[0].addres[1]); break;
  case ADR_FIELD_ADDR1C:
   allocateAndCopy( strp, adr->adr[0].addres[2]); break;
  case ADR_FIELD_PLZ1:
   allocateAndCopy( strp, adr->adr[0].plz); break;
  case ADR_FIELD_CITY1:
   allocateAndCopy( strp, adr->adr[0].city); break;
  case ADR_FIELD_CNTRY1:
   allocateAndCopy( strp, adr->adr[0].country); break;
  case ADR_FIELD_ADDR2A:
   allocateAndCopy( strp, adr->adr[1].addres[0]); break;
  case ADR_FIELD_ADDR2B:
   allocateAndCopy( strp, adr->adr[1].addres[1]); break;
  case ADR_FIELD_ADDR2C:
   allocateAndCopy( strp, adr->adr[1].addres[2]); break;
  case ADR_FIELD_PLZ2:
   allocateAndCopy( strp, adr->adr[1].plz); break;
  case ADR_FIELD_CITY2:
   allocateAndCopy( strp, adr->adr[1].city); break;
  case ADR_FIELD_CNTRY2:
   allocateAndCopy( strp, adr->adr[1].country); break;
  case ADR_FIELD_ADDR3A:
   allocateAndCopy( strp, adr->adr[2].addres[0]); break;
  case ADR_FIELD_ADDR3B:
   allocateAndCopy( strp, adr->adr[2].addres[1]); break;
  case ADR_FIELD_ADDR3C:
   allocateAndCopy( strp, adr->adr[2].addres[2]); break;
  case ADR_FIELD_PLZ3:
   allocateAndCopy( strp, adr->adr[2].plz); break;
  case ADR_FIELD_CITY3:
   allocateAndCopy( strp, adr->adr[2].city); break;
  case ADR_FIELD_CNTRY3:
   allocateAndCopy( strp, adr->adr[2].country); break;
  case ADR_FIELD_FON1:
   allocateAndCopy( strp, adr->fon[0]); break;
  case ADR_FIELD_FON2:
   allocateAndCopy( strp, adr->fon[1]); break;
  case ADR_FIELD_FON3:
   allocateAndCopy( strp, adr->fon[2]); break;
  case ADR_FIELD_FON4:
   allocateAndCopy( strp, adr->fon[3]); break;
  case ADR_FIELD_FON_P:
   allocateAndCopy( strp, adr->fon[4]); break;
  case ADR_FIELD_MOBILE1:
   allocateAndCopy( strp, adr->mobile[0]); break;
  case ADR_FIELD_MOBILE2:
   allocateAndCopy( strp, adr->mobile[1]); break;
  case ADR_FIELD_MOBILE_P:
   allocateAndCopy( strp, adr->mobile[2]); break;
  case ADR_FIELD_FAX:
   allocateAndCopy( strp, adr->fax[0]); break;
  case ADR_FIELD_FAX1:
   allocateAndCopy( strp, adr->fax[0]); break;
  case ADR_FIELD_FAX2:
   allocateAndCopy( strp, adr->fax[1]); break;
  case ADR_FIELD_FAX_P:
   allocateAndCopy( strp, adr->fax[2]); break;
  case ADR_FIELD_WWW:
   allocateAndCopy( strp, adr->www[0]); break;
  case ADR_FIELD_WWW_P:
   allocateAndCopy( strp, adr->www[1]); break;
  case ADR_FIELD_MAIL:
   allocateAndCopy( strp, adr->mail[0]); break;
  case ADR_FIELD_MAIL2:
   allocateAndCopy( strp, adr->mail[1]); break;
  case ADR_FIELD_MAIL_P:
   allocateAndCopy( strp, adr->mail[2]); break;
  case ADR_FIELD_DESCR_S:
   allocateAndCopy( strp, adr->descrShort); break;
  case ADR_FIELD_DESCR_L:
   allocateAndCopy( strp, adr->descr); break;
  case ADR_FIELD_DESCR_L_ADD:
   allocateAndCopy( strp, ""); break;
  case ADR_FIELD_DESCR_L_WITH_TAGS:
   // FIXME overflow
   t=NULL;
   strcpy(txt,adr->descr);
   for(i=0;i<adrDescrTagsAnz; i++)
    {
     strcat(txt,"\n");
     strcat(txt,adrDescrTags[i].tag);
     strcat(txt," ");
     fillAdrDataIntoStr(syncUI,&t,adr,adrDescrTags[i].field);
     strcat(txt,t);
    }
   txt[32767]='\0';
   allocateAndCopy(strp , txt); 
   break;
   
  case ADR_FIELD_DESCR_L_ADD_WITH_TAGS:
   allocateAndCopy( strp, ""); break;
  case ADR_FIELD_KONTO1INH:
   allocateAndCopy( strp, adr->kontoInh[0]); break;
  case ADR_FIELD_KONTO1NUM:
   allocateAndCopy( strp, adr->kontoNum[0]); break;
  case ADR_FIELD_KONTO1BNK:
   allocateAndCopy( strp, adr->kontoBank[0]); break;
  case ADR_FIELD_KONTO1BLZ:
   allocateAndCopy( strp, adr->kontoBLZ[0]); break;
  case ADR_FIELD_KONTO2INH:
   allocateAndCopy( strp, adr->kontoInh[1]); break;
  case ADR_FIELD_KONTO2NUM:
   allocateAndCopy( strp, adr->kontoNum[1]); break;
  case ADR_FIELD_KONTO2BNK:
   allocateAndCopy( strp, adr->kontoBank[1]); break;
  case ADR_FIELD_KONTO2BLZ:
   allocateAndCopy( strp, adr->kontoBLZ[1]); break;
  case ADR_FIELD_STEUER:
   allocateAndCopy( strp, adr->steuer); break;
  case ADR_FIELD_INFO1:
   allocateAndCopy( strp, adr->info[0]); break;
  case ADR_FIELD_INFO2:
   allocateAndCopy( strp, adr->info[1]); break;
  case ADR_FIELD_INFO1_ADD:
   allocateAndCopy( strp, ""); break;
  case ADR_FIELD_INFO2_ADD:
   allocateAndCopy( strp, ""); break;
  case ADR_FIELD_GEBURTST:
   allocateAndCopy( strp, adr->geb); break;
  case ADR_FIELD_OWNER:
   allocateAndCopy( strp,id2owner( adr->owner,txt)); break;
  case ADR_FIELD_NOTEONLY:
   allocateAndCopy( strp,id2owner( adr->noteOnly,txt)); break;
  case ADR_FIELD_READONLY:
   allocateAndCopy( strp,id2owner( adr->readOnly,txt)); break;
  case ADR_FIELD_CREATOR:
   allocateAndCopy( strp,userList[adr->creator].name); break;
  case ADR_FIELD_FOLDER:
   allocateAndCopy( strp,adfList[adr->dirID]->name); break;
  case ADR_FIELD_MINKOID:
   sprintf(txt,"Minkowsky%11s#%d",serverAddrID,adr->id); break;
   allocateAndCopy( strp,txt); break;
  default:
   break;
  }
}

void fillInputIntoCsvIfNull(syncUserInfo *syncUI,  csvData *out,csvData *inp, int fnr)
{
 if(out->col[fnr] == NULL)
  {
   if(inp->col[fnr] == NULL)
    {
     if ( syncUI->csvImportTypeDefault[fnr] != NULL)
      allocateAndCopy( out, fnr, syncUI->csvImportTypeDefault[fnr]);
     else
      allocateAndCopy( out, fnr, "");
    }
   else
    allocateAndCopy( out, fnr,inp->col[fnr] );
  }
}
void fillDefaultIntoCsvIfNull(syncUserInfo *syncUI,  csvData *out, int fnr)
{
 if(out->col[fnr] == NULL)
  allocateAndCopy( out, fnr, syncUI->csvImportTypeDefault[fnr]);
}
void fillEmptyIntoCsvIfNull(csvData *out, int fnr)
{
 if(out->col[fnr] == NULL)
  {
   out->col[fnr] = new char [1];
   out->col[fnr][0] = '\0';
  }
}
int  conditionalFillPDAfon(syncUserInfo *syncUI, AddressSyncTemp *ast,int fid,char *val)
{
 csvData *out = ast->csvOut;
 int fnr = nextPDAfonField(syncUI,out);
 if(fnr<0)
  return (false);

 if(fid == -1)
  if(val[0] != '\0' )
   fillPDAfield(syncUI,ast,fnr,val,true);
 return true;
}
void fillPDAfield(syncUserInfo *syncUI, AddressSyncTemp *ast, int fnr,char *val, int useDefaultType)
{
 csvData *out = ast->csvOut;
 csvData *inp = ast->csvIn;
 int typeFnr = syncUI->csvImportTypeField[fnr];

 allocateAndCopy( out, fnr,     val);
 if(useDefaultType)
  allocateAndCopy( out, typeFnr, syncUI->csvImportTypeDefault[typeFnr]);
 else
  allocateAndCopy( out, typeFnr, inp->col[typeFnr]);
}

int nextPDAfonField (syncUserInfo *syncUI, csvData *out)
{
 int i;

 for (i=0;i< syncUI->syncFieldCount ; i++)
  if(syncUI->csvImportFields[i] == ADR_PDA_PHON)
   if(out->col[i] == NULL)
    return i;

 return -1;
}

int * nextPDAadrFields(syncUserInfo *syncUI, csvData *out)
{
 static int fnr[6];
 int i, tf=-1;

 for(i=0; i<6 ; i++)
  fnr[i]= -1;

 for (i=0;i< syncUI->syncFieldCount ; i++)
  if(syncUI->csvImportFields[i] == ADR_PDA_ADR_TYPE)
   tf = i;

 for (i=0;i< syncUI->syncFieldCount ; i++)
  if(syncUI->csvImportTypeField[i] == tf)
   switch(syncUI->csvImportFields[i])
    {
    case ADR_PDA_ADR_A:
     fnr[0] = i;
     break;
   case ADR_PDA_ADR_B:
     fnr[1] = i;
     break;
   case ADR_PDA_ADR_C:
     fnr[2] = i;
     break;
   case ADR_PDA_ADR_PLZ:
     fnr[3] = i;
     break;
   case ADR_PDA_ADR_CITY:
     fnr[4] = i;
     break;
   case ADR_PDA_ADR_CNTRY:
     fnr[5] = i;
     break;
    default:
     break;
    }
 return(fnr);
}
//id fillAddressIntoCsvFields(csvData)

AddressSyncTemp * newAddressSyncTempStruct () 
{
 AddressSyncTemp *ast;

 ast = new AddressSyncTemp;

#ifndef WITH_CLASS
 if(ast != NULL)
  clearAddressSyncTemp(ast);
#endif
 return ast;
}

#ifndef WITH_CLASS
void clearAddressSyncTemp(AddressSyncTemp *ast)
{
 int i;
 
 for(i=0; i< ADR_ADR_ANZ ; i++)
  {
   if(i<ADR_ADR_ANZ -1)
    {
     ast->adr[i].addres[0][0]='\0';
     ast->adr[i].addres[1][0]='\0';
     ast->adr[i].addres[2][0]='\0';
     ast->adr[i].plz[0]='\0';
     ast->adr[i].city[0]='\0';
     ast->adr[i].country[0]='\0';
     ast->adrTempId[i][0]=-1;
     ast->adrTempId[i][1]=-1;
     ast->adrTempId[i][2]=-1;
     ast->plzTempId[i]=-1;
     ast->cityTempId[i]=-1;
     ast->countryTempId[i]=-1;
     ast->adrWithId[i]= false;
    }
   ast->adrFilled[i] = false;
   ast->adrExported[i] = false;
   ast->adrId[0][i] = -1;
   ast->adrId[1][i] = -1;
   ast->adrId[2][i] = -1;
   ast->plzId[i] = -1;
   ast->cityId[i] = -1;
   ast->countryId[i] = -1;
  }
 for(i=0; i< ADR_FON_ANZ ; i++)
  {
   if(i<ADR_FON_ANZ -1)
    {
     ast->fon[i][0]='\0';
     ast->fonTempId[i]=-1;
    }
   ast->fonId[i]=-1;
  }
 for(i=0; i< ADR_MAIL_ANZ ; i++)
  {
   if(i<ADR_MAIL_ANZ -1)
    {
     ast->mail[i][0]='\0';
     ast->mailTempId[i]=-1;
    }
   ast->mailId[i]=-1;
  }
 for(i=0; i< ADR_MOBIL_ANZ ; i++)
  ast->mobileId[i]=-1;
 for(i=0; i< ADR_FAX_ANZ ; i++)
  ast->faxId[i]=-1;
 ast->www[0]='\0';
 ast->wwwTempId=-1;
 ast->wwwId[0]=-1;
 ast->wwwId[1]=-1;
 ast->skip=false;
 ast->csvIn=NULL;
 ast->csvOut=NULL;
}
#endif
