//  File: comm.cc
// 
//      This file is part of minkowsky
// 
//      Copyright (C) 2001-2002 by Rdiger Goetz
//      Author: Rdiger Goetz <minkowsky@r-goetz.de>
// 
//      Time-stamp: <19-Sep-2002 21:41:03 goetz>
// 
//      This program is free software; you can redistribute it and/or modify
//      it under the terms of the GNU General Public License as published by
//      the Free Software Foundation; either version 2 of the License, or
//      (at your option) any later version.
// 
//      This program is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU General Public License for more details.
// 
//      You should have received a copy of the GNU General Public License
//      along with this program; if not, write to the Free Software
//      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//  
#define _GNU_SOURCE
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <unistd.h>  
#include <errno.h>    
#include <netinet/in.h>  
#include <fcntl.h>  
#include <time.h>       
#include <sys/poll.h>  
#include <signal.h>     
#include <stdarg.h>     
#include "termin.h"


struct sockaddr_in MasterSocketAddress;
//struct sockaddr_in clientSocketAddress[MAX_CLIENTS];
int masterPort;
int masterSocket;
extern int verbose;
extern int tmpSocket;
short int delay[ 65526];
void initSockets();
void openMasterSocket();
int checkSocket(int socket,int retries);
int checkSocket(int socket);
int send2Client(int socket,char *msg);
int send2Client_(int socket,char *msg);
int sendACK(int socket);
int get4ClientMessage(int socket,char *t, int l);
int check4ClientMessage(int socket,char *t, int l);
int check4ClientMessageVerbose(int socket,char *t, int l);
int _freeSockets(int cid ,int total,int expectSocket);
int taskIdBySocket(int socket);


void initSockets()
{
 int i;
 masterPort=MASTERPORT;
 openMasterSocket();
}

void openMasterSocket()
{
 unsigned int addrlen;
 int ret,i;

 masterSocket=socket(AF_INET,SOCK_STREAM,0);
 if(masterSocket<0)
  {
   printf("Can't create masterSocket\n\tReason: Error #%d ; '%s'\n",errno,strerror(errno));
   exit(-1);
  }
 if(verbose)
  printf("Master Socket on port %d created id=%d\n",masterPort,masterSocket);

 MasterSocketAddress.sin_family = AF_INET;
 MasterSocketAddress.sin_addr.s_addr = INADDR_ANY;
 // Port festlegen
 MasterSocketAddress.sin_port = htons(masterPort);

 ret = bind(masterSocket,(struct sockaddr *)&MasterSocketAddress,sizeof(MasterSocketAddress));
 while(ret<0)
  {
   int tmp;
   printf("Can't bind  masterSocket to port %d \n\tReason: Error #%d ; '%s'\n",
          masterPort,errno,strerror(errno));
   printf("\tWaiting for port to become free\n\n");
   sleep(5);
   ret = bind(masterSocket,(struct sockaddr *)&MasterSocketAddress,sizeof(MasterSocketAddress));
  }
//  for(i=0; i<3; i++)
//   {
//    printf("%c",'G'-'@');
//    fflush(stdout);
//    usleep(200000);
//   }
 
 if(verbose)
  printf("Master Scocket(%d) bound to port %d : %d\n",masterSocket,masterPort,ret);
 if(ret<0)
  printf("Error :%d/%s\n",errno,strerror(errno));
 // Lausche ob jemand mit dir quatschen will
 ret=listen(masterSocket,3);
 if(ret<0)
  {
   printf("Can't listen on  masterSocket\n\tReason: Error #%d ; '%s'\n",errno,strerror(errno))
;
   exit(-1);
  }
 if(verbose)
  printf("Master Scocket(%d) listening : %d\n",masterSocket,ret);
 fcntl(masterSocket, F_SETFL, O_NONBLOCK);
}


//int ckeck4ClientOnMasterPort( )
int check4NewConnection()
{
 struct sockaddr_in address;
 socklen_t len;
 int socket;

 address.sin_family = AF_INET;
 address.sin_addr.s_addr = INADDR_ANY;
 address.sin_port = htons(masterPort);
 len = sizeof(struct sockaddr_in);
 socket = accept(masterSocket, (struct sockaddr *)&address,&len);
 if(socket<0)
  {
   if(errno != EAGAIN)
    {
     char erc[1024];
     int ern=errno;
     strncpy(erc,strerror(ern),1023);
     erc[1023]='\0';
     if(verbose)
      printf("unexpected failure on checking socket for new conenctions:\n\tErrorcode #%d = '%s'\n",ern,erc);
     minkoLog("unexpected failure on checking socket for new conenctions:\n\tErrorcode #%d = '%s'\n",ern,erc);
    }
   return(socket);
  }

 if(verbose)
  printf("Connection established on socket %d\n",socket);
 fcntl(socket, F_SETFL, O_NONBLOCK);
 return(socket);
}



int checkSocket(int socket,int retries)
{
 int rt;
 for(rt=0;rt<retries;rt++)
  if(checkSocket(socket))
   return(true);
 return(false);
}
int checkSocket(int socket)
{
 struct pollfd ps={socket,POLLOUT,0};
 if(poll(&ps,1,5)<0) // was 100
  {
//    printf("cs error\n");
   return(false);
  }
 if( (ps.revents & (POLLERR | POLLHUP | POLLNVAL)) >0)
  {
//    printf("cs error event\n");
   return false;
  }
 if( (ps.revents & POLLOUT) >0)
   return true;

//  printf("cs no event %X\n",ps.revents);
 return false;
}


#define MAX_MSG_BLOCK 8192
int sendTicket2Socket(int socket,int ticket)
{
 int ret,len;
 char buffer [64];

 sprintf(buffer,"ACK %d",ticket);
 len = strlen(buffer)+1;
 if(!checkSocket(socket,8))
  return(-1);
 ret=send(socket,buffer,len,MSG_NOSIGNAL);
 if(verbose)
  printf("send Ticket %d  to Client(%d)  (%s)\n",ticket,socket,buffer);
 return(ret);
}
int sendMsg2Socket(int socket,char *msg)
{
 int ret,len;

 
 len = strlen(msg)+1;
 if(!checkSocket(socket,8))
  return(-1);
 ret=send(socket,msg,len,MSG_NOSIGNAL);
 if(verbose)
  printf("send Message '%s'  to Client (%d) (->%d)\n",msg,socket,ret);
 return(ret);
}

int send2Socket(int socket,char *msg)
{
 int ret;
 int socketUp=false;
 int rt=16;
 int len;
 int ptr=0;
 char bmsg[256];
 char eot[16];
 static int tid=0;
 char localBuffer[MAX_MSG_BLOCK+256];
 int localBufferLen;

 sprintf(eot," EOT%02X",tid &255);
 tid++;

 if( !checkSocket(socket,8))
  {
   printf("check on socket FAILED\n");
   return(-1);
  }

 len = strlen(msg);
 sprintf(bmsg,"%%# %d %%#",len);
 if(verbose)
  printf("\t\t\tsending %s\n",bmsg);
 usleep(delay[socket]+1000);

 if(len<=MAX_MSG_BLOCK)
  {
   strcpy(localBuffer,msg);
   strcat(localBuffer,eot);
   localBufferLen  = strlen(localBuffer)+1;
  }

 ret=send(socket,bmsg,strlen(bmsg),MSG_NOSIGNAL);
 usleep(25);
 if(ret<0)
  {
   printf("Error sending '%s' to socket %d' abborted\n",msg,socket);
   return(ret);
  }

 if(len>MAX_MSG_BLOCK)
  {
   if(verbose)
    printf("BIG MESSAGE sending in special mode \n");
   while(len-ptr>MAX_MSG_BLOCK)
    {
     if(verbose)
      printf("\t\tsending block from %dk\n",ptr/1024);
     ret=send(socket,msg+ptr,MAX_MSG_BLOCK,MSG_NOSIGNAL);
     if(verbose)
      printf("done (ret=%d)\n",ret);
     ptr += MAX_MSG_BLOCK;
     usleep(10);
     if(verbose)
      printf("checking socket\n");
     if( !checkSocket(socket,8))
      return(-1);
     if(verbose)
      printf("checking socket done\n");
    }
   if(verbose)
    printf("\t\tsending final  block\n");
   ret=send(socket,msg+ptr,len-ptr+1,MSG_NOSIGNAL);
   ret=send(socket,eot,7,MSG_NOSIGNAL);
  }
 else
  {
   // printf("\t\t\tsending %s\n",msg);
//    ret=send(socket,msg,strlen(msg),MSG_NOSIGNAL);
//    ret=send(socket,eot,7,MSG_NOSIGNAL);
   ret=send(socket,localBuffer,localBufferLen,MSG_NOSIGNAL);
   printf("data send via LocalBuffer (end='%s')\n",localBuffer+localBufferLen-16);
  }


 if(ret<0)
  if(verbose)
   printf("Error sending '%s' to socket %d' abborted\n",msg,socket);
 else
  {
   //   ret=send(socket,"EOT",4,MSG_NOSIGNAL);
 //   ret=send(socket,eot,7,MSG_NOSIGNAL);
//    if(ret<0)
//     printf("Error sending EOT to socket %d' abborted\n",msg,socket);
//    else if(verbose)
//     {
//      if(len<32768)
//       printf("sen to Client: ''%s%s''\n",msg,eot);
//      else
//       {
//        strncpy(bmsg,msg,255);
//        bmsg[255]='\0';
//        printf("sen to Client: '%s' .... '%sEOT'\n",bmsg,msg+len-1000);
//       }
//     }
   if(verbose)
    printf("\t\tsending successful\n");
  }
 return(ret);
}

int sendACK(int socket)
{
 int ret;
 if(!checkSocket(socket,8))
  return(-1);
 ret=send(socket,"ACK",4,MSG_NOSIGNAL);
 if(verbose)
  printf("send ACK  to Client\n");
 return(ret);
}

int check4ClientMessage(int socket,char *t, int l, int mode)
{
 char buffer[16384];
 int ret,tl,ttl=16,st=2000;
 struct pollfd ps={socket,POLLIN,0};
 int timeout=10; //was 100
 int retries =2;
 int slp=1000;
 int doSendAck=false;

 if(mode == MSG_MODE_LOGIN)
  {
   timeout = 250;
   retries = 4;
   slp     = 250000;
   doSendAck = false;
  }
 if(mode == 2)
  doSendAck=true;

 while((ret=poll(&ps,(unsigned int) 1,timeout))<1)
  {
   usleep(slp);
   // slp *= 2;
   retries --;
   if(retries<0)
     return(-1);
  }

 ret=recv(socket,t,l,MSG_NOSIGNAL);
 if(ret>0)
  {
   tl=ret;
   while(t[tl-1] !='\0')
    {
     ret=recv(socket,buffer,1024,MSG_NOSIGNAL);
     if(ret>0)
      {
       strcat(t,buffer);
       tl +=ret;
      }
     else
      {
       if(ttl<=0)
	break;
       printf("trying to get data from client ; ttl=%d\n",ttl);
       usleep(st);
       st =st*2;
       ttl--;
      }
    }
   if(doSendAck)
    if(sendACK(socket)<0)
     return(-1);
   return(ret);
  }
 return(-1);
}

void closeAllConnection (int vlaue)
{
 int cid,uid;

 // FIXME todos, projs ?
 writeAdrList(); writeAllDates();


 printf("shutting down connections\n");
 for(uid=0;uid<=userAnz; uid++)
  {
   if(userList[uid].rsocket>0)
    send2Socket(userList[uid].rsocket,"suspend");
   if(userList[uid].socket>0)
    {
     shutdown(userList[uid] .socket,2);
     close(userList[uid].socket);
    }
  }
  
 shutdown(masterSocket,2);
 shutdown(tmpSocket,2);
 close(tmpSocket);
 close(masterSocket);
 printf("done\n");
 writeDates();
 sleep(1);
 exit(0);
}



int freeSocketsTotal(int uid)
{
 return(_freeSockets(uid,true,-1));
}

int freeSockets(int uid)
{
 return(_freeSockets(uid,false,-1));
}
int _freeSockets(int uid,int total,int expectSocket)
{
 int ret;
 if(verbose)
  printf("freeing Socket for uid %d\n",uid);
 if(expectSocket != userList[uid].socket)
  ret = shutdown(userList[uid].socket,2);
 if(expectSocket != userList[uid].socket)
  ret = close(userList[uid].socket);
 userList[uid].socket =-1;
 userList[uid].connectionTime =0;

}

