//  File: date.old.h
// 
//      This file is part of minkowsky
// 
//      Copyright (C) 2001-2002 by Rdiger Goetz
//      Author: Rdiger Goetz <minkowsky@r-goetz.de>
// 
//      Time-stamp: <19-Apr-2002 17:15:00 goetz>
// 
//      This program is free software; you can redistribute it and/or modify
//      it under the terms of the GNU General Public License as published by
//      the Free Software Foundation; either version 2 of the License, or
//      (at your option) any later version.
// 
//      This program is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU General Public License for more details.
// 
//      You should have received a copy of the GNU General Public License
//      along with this program; if not, write to the Free Software
//      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//  
#define PARTANZ_IN_DATE_0400 512
#define REMINDERS_IN_DATE_0400 512

typedef struct
{
 int id;         // ID des Users
 int status;     // Status desUsers (UKN, OK, NO OPEN)
 int flags;      //
 int perm;       // Rechte des Users
 int typ;        // Typ des Users (Injit, Einl, Teiln, Ext, Info)
} UserInDate_0400;

typedef struct
{
 int id;         // Addressat des Reminders
 int offset;     // Zeitversatz des Reminders 
 int offset2;    // Zeitversatz des Reminders in der nchst kleineren Einheit (nur bei unit =h oder d)
 char unit;      // Einheit des Zeitversatz (m= Minute, h=Stunde, d=Tag)
 ReminderCtrlUnion ct;
 int typ;       // Art des Reminders 
 int status;     // status= REMINDER_DONE, oder REMINDER_WAITING;
 void *date;     // Rckkopplung zum Date oder TODO
}Reminder_0400;

typedef struct
{
 int  did;                  // ID des Dates das geshiftet wird.
 int  refDate,refTime;      // Zeit  zu der der Termin eigentlich angesetzt war.
 char partStatus[PARTANZ_IN_DATE_0400];      // Stati der Teilnehmer bei dieser Instanz eines Wiederholungstermins
 int  deleted;              // Wenn true: Termin findet nicht statt.
 int  room;                 // Termin ist in diesen Raum verlegt (-1 = nicht verlegt)
 int  startDate,startTime;  // neuer Termin
 int  stopDate, stopTime;
 char addDetails [128];     // zustzliche Details
 Reminder_0400 reminder;
 char reserved [64];
} DateShift_0400;

typedef struct 
{
 UserInDate_0400 init;
 UserInDate_0400 part[PARTANZ_IN_DATE_0400];
 int partAnz;
 Reminder_0400 reminder[REMINDERS_IN_DATE_0400];
 int remAnz;
 int room;
 int group;
 int flags;
 int id;
 int startDate;
 int stopDate;
 int startTime;
 int stopTime;
 char descr[1024];
 int tlen;
 char comm[4000];
 int reserverd [20];
 int dateShiftAnz;
 int dateShiftMax;
 int dateShiftPtr;
 DateShift_0400 **shifts;

 int repeatTyp;          // Typ siehe #define REPAET_????
 // int repeatCount;        // Zahl der Wiederholung , 0= unbegrnzt
 int repeatStopDate;     // Tag an dem die letzte Wiederholung statfindet, 0= unbegrenzt
 int priority;           // Prioritt des Termins
 int repeatIntervall;    // Bei REPEAT_ALLE lnge des Intervall in Einheiten 'repeatUnit'
 int repeatUnit;         // Bei REPEAT_ALLE Einheit von repaet.interval
 int deleted;
} Date_0400;
