//  File: lang.cc
// 
//      This file is part of minkowsky
// 
//      Copyright (C) 2001-2002 by Rdiger Goetz
//      Author: Rdiger Goetz <minkowsky@r-goetz.de>
// 
//      Time-stamp: <15-Sep-2002 12:05:59 goetz>
// 
//      This program is free software; you can redistribute it and/or modify
//      it under the terms of the GNU General Public License as published by
//      the Free Software Foundation; either version 2 of the License, or
//      (at your option) any later version.
// 
//      This program is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU General Public License for more details.
// 
//      You should have received a copy of the GNU General Public License
//      along with this program; if not, write to the Free Software
//      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//  
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <errno.h>  
#include <time.h>  

#include "termin.h"




void getLanguageDependedVariables ( )
{
 printf("LANG=%d\n",serverLang);
 switch (serverLang)
  {
  case MINKO_LANG_DE : getDeVariables() ; break;
  case MINKO_LANG_EN : 
  default            : getEnVariables() ; break;
  }
}
void getDeVariables ( )
{
 int i;

 serverMsg[SERVER_MSG_ALREADY_LOGED_IN] = "Error: Sie (d.h. der Users %s) sind bereits eingelogged.\nSollte ihr Minkowsky abgestrtzt sein, so warten sie bitte 3 Minuten, bevor sie sichn erneut einloggen. Danke\n";


 for(i=0;i<10000; i++)
  adrTagName[i]=NULL;

 adrTagName[ADR_FIELD_IGNORE  ] ="";
 adrTagName[ADR_FIELD_CAT     ] ="";
 adrTagName[ADR_FIELD_TITEL   ] ="";
 adrTagName[ADR_FIELD_NAME_1  ] ="";
 adrTagName[ADR_FIELD_NAME_M  ] ="";
 adrTagName[ADR_FIELD_NAME_2  ] ="";
 adrTagName[ADR_FIELD_NAME1M2 ] ="";
 adrTagName[ADR_FIELD_COMPS   ] ="";
 adrTagName[ADR_FIELD_COMPA   ] ="";
 adrTagName[ADR_FIELD_COMPPOS ] ="";
 adrTagName[ADR_FIELD_ADDR1   ] ="";
 adrTagName[ADR_FIELD_ADDR1A  ] ="";
 adrTagName[ADR_FIELD_ADDR1B  ] ="";
 adrTagName[ADR_FIELD_ADDR1C  ] ="";
 adrTagName[ADR_FIELD_PLZ1    ] ="";
 adrTagName[ADR_FIELD_CITY1   ] ="";
 adrTagName[ADR_FIELD_CNTRY1  ] ="";
 adrTagName[ADR_FIELD_ADDR2   ] ="";
 adrTagName[ADR_FIELD_ADDR2A  ] ="";
 adrTagName[ADR_FIELD_ADDR2B  ] ="";
 adrTagName[ADR_FIELD_ADDR2C  ] ="";
 adrTagName[ADR_FIELD_PLZ2    ] ="";
 adrTagName[ADR_FIELD_CITY2   ] ="";
 adrTagName[ADR_FIELD_CNTRY2  ] ="";
 adrTagName[ADR_FIELD_ADDR3   ] ="";
 adrTagName[ADR_FIELD_ADDR3A  ] ="";
 adrTagName[ADR_FIELD_ADDR3B  ] ="";
 adrTagName[ADR_FIELD_ADDR3C  ] ="";
 adrTagName[ADR_FIELD_PLZ3    ] ="";
 adrTagName[ADR_FIELD_CITY3   ] ="";
 adrTagName[ADR_FIELD_CNTRY3  ] ="";
 adrTagName[ADR_FIELD_FON1    ] ="";
 adrTagName[ADR_FIELD_FON2    ] ="";
 adrTagName[ADR_FIELD_FON3    ] ="";
 adrTagName[ADR_FIELD_FON4    ] ="";
 adrTagName[ADR_FIELD_FON_P   ] ="";
 adrTagName[ADR_FIELD_FAX     ] ="";
 adrTagName[ADR_FIELD_FAX_P   ] ="";
 adrTagName[ADR_FIELD_WWW     ] ="";
 adrTagName[ADR_FIELD_WWW_P   ] ="";
 adrTagName[ADR_FIELD_MAIL    ] ="";
 adrTagName[ADR_FIELD_MAIL2   ] ="";
 adrTagName[ADR_FIELD_MAIL_P  ] ="";
 adrTagName[ADR_FIELD_DESCR_S ] ="";
 adrTagName[ADR_FIELD_DESCR_L ] ="";
 adrTagName[ADR_FIELD_DESCR_L_ADD ] ="";
 adrTagName[ADR_FIELD_DESCR_L_WITH_TAGS ] ="";
 adrTagName[ADR_FIELD_DESCR_L_ADD_WITH_TAGS ] ="";
 adrTagName[ADR_FIELD_KONTO1INH ] ="";
 adrTagName[ADR_FIELD_KONTO1NUM ] ="";
 adrTagName[ADR_FIELD_KONTO1BNK ] ="";
 adrTagName[ADR_FIELD_KONTO1BLZ ] ="";
 adrTagName[ADR_FIELD_KONTO2INH ] ="";
 adrTagName[ADR_FIELD_KONTO2NUM ] ="";
 adrTagName[ADR_FIELD_KONTO2BNK ] ="";
 adrTagName[ADR_FIELD_KONTO2BLZ ] ="";
 adrTagName[ADR_FIELD_STEUER    ] ="";
 adrTagName[ADR_FIELD_INFO1     ] ="";
 adrTagName[ADR_FIELD_INFO2     ] ="";
 adrTagName[ADR_FIELD_INFO1_ADD ] ="";
 adrTagName[ADR_FIELD_INFO2_ADD ] ="";
 adrTagName[ADR_FIELD_GEBURTST  ] ="";
 adrTagName[ADR_FIELD_OWNER     ] ="";
 adrTagName[ADR_FIELD_NOTEONLY  ] ="";
 adrTagName[ADR_FIELD_READONLY  ] ="";
 adrTagName[ADR_FIELD_CREATE    ] ="";
 adrTagName[ADR_FIELD_CREATOR   ] ="";
 adrTagName[ADR_FIELD_CUSTOM1   ] ="";
 adrTagName[ADR_FIELD_CUSTOM2   ] ="";
 adrTagName[ADR_FIELD_CUSTOM3   ] ="";
 adrTagName[ADR_FIELD_CUSTOM4   ] ="";

 adrTagName[ADR_FIELD_UNDEF   ] ="";
 adrTagName[ADR_FIELD_MINKOID ] ="";
 adrTagName[ADR_FIELD_FOLDER  ] ="";

}
void getEnVariables ( )
{
 int i;

serverMsg[SERVER_MSG_ALREADY_LOGED_IN] = "Error: You (or another one on user account %s) has been loged in on Minkowsky.\nIf your Minkowsky client crashed, please wait for 3 minutes. Thanks\n";


 for(i=0;i<10000; i++)
  adrTagName[i]=NULL;

 printf("using EN vars\n");
 adrTagName[ADR_FIELD_IGNORE  ] ="ignored";
 adrTagName[ADR_FIELD_CAT     ] ="Category";
 adrTagName[ADR_FIELD_TITEL   ] ="Person's Title";
 adrTagName[ADR_FIELD_NAME_1  ] ="First Name";
 adrTagName[ADR_FIELD_NAME_M  ] ="Middle Initial";
 adrTagName[ADR_FIELD_NAME_2  ] ="Last Name";
 adrTagName[ADR_FIELD_NAME1M2 ] ="Full Name";
 adrTagName[ADR_FIELD_COMPS   ] ="Company Name (short)";
 adrTagName[ADR_FIELD_COMPA   ] ="Company Name";
 adrTagName[ADR_FIELD_COMPPOS ] ="Position in Company";
 adrTagName[ADR_FIELD_ADDR1   ] ="1st Address (All)";
 adrTagName[ADR_FIELD_ADDR1A  ] ="1st Address (Line 1)";
 adrTagName[ADR_FIELD_ADDR1B  ] ="1st Address (Line 2)";
 adrTagName[ADR_FIELD_ADDR1C  ] ="1st Address (Line 3)";
 adrTagName[ADR_FIELD_PLZ1    ] ="1st Address' ZIP code";
 adrTagName[ADR_FIELD_CITY1   ] ="1st Address' City";
 adrTagName[ADR_FIELD_CNTRY1  ] ="1st Address' Contry";
 adrTagName[ADR_FIELD_ADDR2   ] ="2nd Address (All)";
 adrTagName[ADR_FIELD_ADDR2A  ] ="2nd Address (Line 1)";
 adrTagName[ADR_FIELD_ADDR2B  ] ="2nd Address (Line 2)";
 adrTagName[ADR_FIELD_ADDR2C  ] ="2nd Address (Line 3)";
 adrTagName[ADR_FIELD_PLZ2    ] ="2nd Address' ZIP code";
 adrTagName[ADR_FIELD_CITY2   ] ="2nd Address' City";
 adrTagName[ADR_FIELD_CNTRY2  ] ="2nd Address' Contry";

 adrTagName[ADR_FIELD_ADDR3   ] ="private Address (All)";
 adrTagName[ADR_FIELD_ADDR3A  ] ="private Address (Line 1)";
 adrTagName[ADR_FIELD_ADDR3B  ] ="private Address (Line 2)";
 adrTagName[ADR_FIELD_ADDR3C  ] ="private Address (Line 3)";
 adrTagName[ADR_FIELD_PLZ3    ] ="private Address' ZIP code";
 adrTagName[ADR_FIELD_CITY3   ] ="private Address' City";
 adrTagName[ADR_FIELD_CNTRY3  ] ="private Address' Contry";
 adrTagName[ADR_FIELD_FON1    ] ="Phone # 1";
 adrTagName[ADR_FIELD_FON2    ] ="Phone # 2";
 adrTagName[ADR_FIELD_FON3    ] ="Phone # 3";
 adrTagName[ADR_FIELD_FON4    ] ="Phone # 4 (mobile)";
 adrTagName[ADR_FIELD_FON_P   ] ="private Phone";
 adrTagName[ADR_FIELD_FAX     ] ="FAX";
 adrTagName[ADR_FIELD_FAX_P   ] ="private FAX";
 adrTagName[ADR_FIELD_WWW     ] ="Web-URL";
 adrTagName[ADR_FIELD_WWW_P   ] ="private Web-URL";
 adrTagName[ADR_FIELD_MAIL    ] ="Mail Address";
 adrTagName[ADR_FIELD_MAIL2   ] ="alternative Mail Address";
 adrTagName[ADR_FIELD_MAIL_P  ] ="private Mail Address";
 adrTagName[ADR_FIELD_DESCR_S ] ="short Description";
 adrTagName[ADR_FIELD_DESCR_L ] ="full Description";
 adrTagName[ADR_FIELD_DESCR_L_ADD ] ="part of full Description ";
 adrTagName[ADR_FIELD_DESCR_L_WITH_TAGS ] ="full Description, with tagged Information";
 adrTagName[ADR_FIELD_DESCR_L_ADD_WITH_TAGS ] ="part of full Description (with tagged Information)";
 adrTagName[ADR_FIELD_KONTO1INH ] ="owner of Bank account 1";
 adrTagName[ADR_FIELD_KONTO1NUM ] ="bank account 1";
 adrTagName[ADR_FIELD_KONTO1BNK ] ="bank of bankaccount 1";
 adrTagName[ADR_FIELD_KONTO1BLZ ] ="bank code of bankaccount 1";
 adrTagName[ADR_FIELD_KONTO2INH ] ="owner of Bank account 2";
 adrTagName[ADR_FIELD_KONTO2NUM ] ="bank account 2";
 adrTagName[ADR_FIELD_KONTO2BNK ] ="bank of bankaccount 2";
 adrTagName[ADR_FIELD_KONTO2BLZ ] ="bank code of bankaccount 2";
 adrTagName[ADR_FIELD_STEUER    ] ="Tax Number";
 adrTagName[ADR_FIELD_INFO1     ] ="additonal Info";
 adrTagName[ADR_FIELD_INFO2     ] ="additonal private Info";
 adrTagName[ADR_FIELD_INFO1_ADD ] ="part of additonal Info";
 adrTagName[ADR_FIELD_INFO2_ADD ] ="part of additonal private Info";
 adrTagName[ADR_FIELD_GEBURTST  ] ="Birthday";
 adrTagName[ADR_FIELD_OWNER     ] ="Owner of Address";
 adrTagName[ADR_FIELD_NOTEONLY  ] ="Group without write permission on address";
 adrTagName[ADR_FIELD_READONLY  ] ="Group with readonly permission on address";
 adrTagName[ADR_FIELD_CREATE    ] ="creation date of address";
 adrTagName[ADR_FIELD_CREATOR   ] ="creator of address";
 adrTagName[ADR_FIELD_CUSTOM1   ] ="User defined field #1";
 adrTagName[ADR_FIELD_CUSTOM2   ] ="User defined field #2";
 adrTagName[ADR_FIELD_CUSTOM3   ] ="User defined field #3";
 adrTagName[ADR_FIELD_CUSTOM4   ] ="User defined field #4";
 adrTagName[ADR_FIELD_CUSTOM5   ] ="User defined field #5";
 adrTagName[ADR_FIELD_CUSTOM6   ] ="User defined field #6";
 adrTagName[ADR_FIELD_CUSTOM7   ] ="User defined field #7";
 adrTagName[ADR_FIELD_CUSTOM8   ] ="User defined field #8";

 adrTagName[ADR_FIELD_UNDEF   ] ="undefined";
 adrTagName[ADR_FIELD_MINKOID ] ="Minkowsky internal address ID";
 adrTagName[ADR_FIELD_FOLDER  ] ="Minkowsky folder name";

}
