//  File: main.cc
// 
//      This file is part of minkowsky
// 
//      Copyright (C) 2001-2002 by Rdiger Goetz
//      Author: Rdiger Goetz <minkowsky@r-goetz.de>
// 
//      Time-stamp: <27-Oct-2002 19:41:59 goetz>
// 
//      This program is free software; you can redistribute it and/or modify
//      it under the terms of the GNU General Public License as published by
//      the Free Software Foundation; either version 2 of the License, or
//      (at your option) any later version.
// 
//      This program is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU General Public License for more details.
// 
//      You should have received a copy of the GNU General Public License
//      along with this program; if not, write to the Free Software
//      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//  
#define _GNU_SOURCE
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <unistd.h>  
#include <errno.h>    
#include <netinet/in.h>  
#include <fcntl.h>  
#include <time.h>       
#include <sys/poll.h>  
#include <signal.h>     
//#include <stdarg.h>      

#define ___MAIN
#include "termin.h"

#ifndef MASTERPORT
#define MASTERPORT  41999
#endif

class scheduleTask 
{
public:
 static int anz;
 static int inp;
 static int prc;
 static int baseTicket;
 char *cmd;
 char *answer;
 int free;
 int active;
 int skip;
 int done;
 // int sendTask;
 int sending;
 int sendingDone;
 int sendStamp;
 int socket;
 int ticket;
 int uid;
 int time;
 
 inline  scheduleTask ()
 {
  cmd =NULL;
  answer=NULL;
  reset();
  anz++;
 }
 inline ~scheduleTask()
 {
  if(cmd != NULL)
   delete cmd;
  if(answer != NULL)
   delete answer;
  answer = cmd =NULL;
  anz --;
 }
 inline void reset()
 {
  active=false;
  skip =false;
  done =false;
  //  sendTask =false;
  sending =false;
  sendingDone =false;
  sendStamp =0;
  ticket = -1;
  socket =-1;
  uid -1;
  time =0;
  if(answer != NULL)
   delete answer;
  answer= NULL;
  if(cmd != NULL)
   delete cmd;
  cmd= NULL;

  free=true;
 }
};


typedef struct
{
 pthread_t thr;
 pthread_mutex_t start,wait;
 int taskId;
 int tid;
 int done;
 int avail;
}SendThread;


typedef struct
{
 int notifyInterval;
 int doCheckPresence;
} ProccessThreadInfo;


int scheduleTask::anz;
int scheduleTask::baseTicket=0;
int scheduleTask::inp=0;
int scheduleTask::prc=0;
scheduleTask *tasks;

int doReload=false;
int localVerbose=false;
int doCloseAllConnection=false;
char configFile[1024];
int develServer=false;
FILE *fpl;
extern short int delay[ 65526];

// threads coordination
int suspendProcessThread=false;
int suspendListenThread=false;
int suspendLoginThread=false;
int suspendsendThreads=false;
int processThreadStopped =false;
int listenThreadStopped =false;
int loginThreadStopped =false;
int sendThreadAnz=0;
ProccessThreadInfo  proccessThreadInfo;


int loginThreads=8;
int senderThreads=16;
int loginThreadsActive=false;
int senderThreadsActive=false;
int commandThreadActive=false;
int tmpSocket;
extern int masterSocket;
char tclMsg[16384];
int thrCount=0;

void initCloseAllConnection(int vlaue);
int check4NewConnection();
int check4ClientMessage(int socket,char *t, int l, int mode);
//int ckeck4ClientOnMasterPort( );
void initSockets();
void openMasterSocket();
int checkSocket(int socket,int retries);
int checkSocket(int socket);
int sendTicket2Socket(int socket,int ticket);
int send2Client(int socket,char *msg);
int send2Client_(int socket,char *msg);
int send2Socket(int socket,char *msg);
int sendACK(int socket);
int sendMsg2Socket(int socket,char *msg);
// int get4ClientMessage(int socket,char *t, int l);
// int check4ClientMessage(int socket,char *t, int l);
// int check4ClientMessageVerbose(int socket,char *t, int l);
int nextFreeCID();
void initReload(int value);
void closeAllConnection(int value);
int freeSocketsTotal(int cid);
int freeSockets(int cid);
int _freeSockets(int cid ,int total,int expectSocket);
void getToday ( );
void getLanguageDependedVariables ( );
void getEnVariables ( );
void getDeVariables ( );
#define MINKO_VERSION "MINKOVERSION"
void *execListenThread( void *ptr);
void *processClientCommands( void *ptr);
void *processClientCommands( int notifyInterval, int doCheckPresence);
void processClientCommand();
void *processLogins( void *ptr);
void * sendAnswer(void *ptr);
void * senderThread(void *ptr);
int sendAnswer(int uid,char *str,SendThread *info);
void cancelUsersTasks(int uid);
void cancelTask(int p);
void *processLogin( void *ptr);
void *processOpenReminder( void *ptr);

int main(int argc, char *argv[])
{
 char buffer[16384],*p,*s,file[1024];
 int l,canz,tmpSocket;
 int cid,i,stat;
 char *t;
 int stim,rtim,ntim,rctim;
 int notifyInterval =900;
 FILE *fp,*fpp;
 int ret,uid;
 int mrrTim=0,curTim;
 char tmpServerLang[5];

 printf("Starting Minkowsky Server %s\n",MINKOVERSION);



 verbose=false;
 noReminder=false;
 enableBackup=false;
 permanentBackupHour=0;
 strcpy(progName,"Minkowsky Raum/Zeit Verwaltung");
 strcpy(company,"");
 dataDir=NULL;
 doCheckPresence=false;
 presenceList=NULL;
 if ( getenv("LANG") == NULL )
  strcpy(tmpServerLang,"de");
 else
  strcpy(tmpServerLang,getenv("LANG"));


 strcpy(configFile,"/etc/minkowsky");

 if(argc>1)
  {
   int ac=1;
   while(ac<argc)
    {
     if(strcmp(argv[ac],"-v")==0)
      verbose=true;
     else if(strcmp(argv[ac],"-nr")==0)
      noReminder=true;
     else if(strcmp(argv[ac],"-f")==0)
      {
       ac++;
       strcpy(configFile,argv[ac]);
      }
     ac++;
    }
  }



 fp=fopen(configFile,"r");
 if(fp!=NULL)
  {
//    p=fgets(buffer,8190,fp);
//    while(p!=NULL)
   while( (p=fgets(buffer,8190,fp)) != NULL)
    {
     //     printf("reading resource: %s (%d)\n",buffer,verbose);
     if(buffer[0] == '#')
      continue;
     if(strncmp(buffer,"DATA_PATH",9 )==0)
      {
       t=skip2nonWS(buffer+10);
       if(t==NULL)
	continue;
       s= t+strlen(t)-1;
       if(*s=='\n')
	*s='\0';
       dataDir = new char [strlen(t)+4];
       strcpy(dataDir,t);
      }
     else if(strncmp(buffer,"TERMIN_DATA_PATH",15)==0)
      {
       t=skip2nonWS(buffer+16);
       if(t==NULL)
	continue;
       s= t+strlen(t)-1;
       if(*s=='\n')
	*s='\0';
       dataDir = new char [strlen(t)+4];
       strcpy(dataDir,t);
      }
     else if(strncmp(buffer,"SERVER_BIN_PATH",15)==0)
      {
       t=skip2nonWS(buffer+16);
       if(t==NULL)
	continue;
       s= t+strlen(t)-1;
       if(*s=='\n')
	*s='\0';
       serverBinPath = new char [strlen(t)+4];
       mail2smtp = new char [strlen(t)+32];
       strcpy(serverBinPath,t);
       sprintf(mail2smtp,"%s/mail2smtp",serverBinPath);
      }
     else if(strncmp(buffer,"VERBOSE",7)==0)
      {
       verbose=true;
       s=skip2nonWS(buffer+8);
       if(s !=NULL)
	if(strncasecmp(s,"off",3)==0)
	 verbose=false;
       printf("VERBOSE is set to %d (true=%d)\n",verbose,true);
      }
     else if(strncmp(buffer,"COMPANY",7)==0)
      {
       t=skip2nonWS(buffer+8);
       if(t==NULL)
	continue;
       s= t+strlen(t)-1;
       if(*s=='\n')
	*s='\0';
       if(strlen(t)>127)
	{
	 strncpy(company,t,127);
	 company[127]='\0';
	}
       else
	 strcpy(company,t);
      }
     else if(strncmp(buffer,"SERVER_LANGUAGE",15)==0)
      {
       t=skip2nonWS(buffer+16);
       if(t==NULL)
	continue;
       s= t+strlen(t)-1;
       if(*s=='\n')
	*s='\0';
       tmpServerLang[0]=t[0];
       tmpServerLang[1]=t[1];
       tmpServerLang[2]='\0';
      }
     else if(strncmp(buffer,"REPLY_ADDRESS",13)==0)
      {
       t=skip2nonWS(buffer+14);
       if(t==NULL)
	continue;
       strcpy(replyAddress,strChop(t));
      }
     else if(strncmp(buffer,"NOTIFY_EVERY",12)==0)
      {
       t=skip2nonWS(buffer+13);
       if(t==NULL)
	continue;
       notifyInterval = atoi(strChop(t));
      }
     else if(strncmp(buffer,"DEVELSERVER",11)==0)
      {
       develServer=true;
      }
     else if(strncmp(buffer,"LOGINTHREADS",12)==0)
      {
       t=skip2nonWS(buffer+13);
       if(t!= NULL)
	loginThreads = atoi(t);
      }
     else if(strncmp(buffer,"SENDERTHREADS",13)==0)
      {
       t=skip2nonWS(buffer+14);
       if(t!= NULL)
	senderThreads = atoi(t);
      }
     else if(strncmp(buffer,"CHECKPRESENCE",13)==0)
      {
       s=skip2nonWS(buffer+14);

       doCheckPresence=true;

       if(strncasecmp(s,"off",3)==0)
	doCheckPresence=false;

       if(strncasecmp(s,"on",2)==0)
	{
	 s =skip2WS(s+2);
	 s =skip2nonWS(s);
	}
       if (doCheckPresence )
	{
	 strcpy(checkPresenceFile,s);
	 strTrim(checkPresenceFile);
	}
      }
     else if(strncmp(buffer,"MYSELF",7)==0)
      {
       t=skip2nonWS(buffer+8);
       if(t==NULL)
	continue;
       s= t+strlen(t)-1;
       if(*s=='\n')
	*s='\0';
       if(strlen(s)>63)
	{
	 strncpy(progName,s,63);
	 progName[63]='\0';
	}
       else
	 strcpy(progName,s);
      }
     else if(strncmp(buffer,"BACKUP_PATH",11)==0)
      {
       t=skip2nonWS(buffer+12);
       if(t==NULL)
	continue;
       s= t+strlen(t)-1;
       if(*s=='\n')
	*s='\0';
       allocateAndCopy(&backupPath,t);
       enableBackup=true;
      }
    else if(strncmp(buffer,"PERMANENT_BACKUP_AT",19)==0)
      {
       t=skip2nonWS(buffer+20);
       if(t!= NULL)
	permanentBackupHour = atoi(t);
      }
     //     p=fgets(buffer,8190,fp);
    }
   fclose(fp);
  }
 else
  printf("Can't open %s (%p)\n",configFile,fp);
 if(dataDir==NULL)
  {
   dataDir= new char [32];
   strcpy(dataDir,"/usr/local/share/termine");
  }

 if(!develServer)
  {
   sprintf(file,"%s/.minkowsky.pid",getenv("HOME"));
   fpp=fopen(file,"w");
   if(fpp==NULL)
    {
     printf("Can't open %s",file);
     exit(-1);
    }
   fprintf(fpp,"%d",getpid());
   fclose(fpp);
  }
 
 // printf("Backupo PATH: '%s'\n",backupPath);
 if(verbose)
  printf("Running in Verbose Mode\n");

 if(tmpServerLang[0] == 'd' && tmpServerLang[1] == 'e')
  serverLang = MINKO_LANG_DE;
 else
  serverLang = MINKO_LANG_EN;

 getLanguageDependedVariables();
 mailMaskEinlExternText=NULL;
 mailMaskEinlExternSubj=NULL;
 mailMaskEinlInternText=NULL;
 mailMaskEinlInternSubj=NULL;
 mailMaskErinExternText=NULL;
 mailMaskErinExternSubj=NULL;
 mailMaskErinInternText=NULL;
 mailMaskErinInternSubj=NULL;
 mailMaskErinToDoText=NULL;
 mailMaskErinToDoSubj=NULL;
 mailMaskMahnToDoText=NULL;
 mailMaskMahnToDoSubj=NULL;
 serverDateID=NULL;
 serverToDoID=NULL;
 serverAddrID=NULL;
 syncCtrl.user=NULL;
 syncCtrl.open=false;
 syncCtrl.type= SYNC_OFF;
 syncCtrl.timeStamp = 0;

 sprintf(file,"%s/minkowsky.log",dataDir);
 fpl=fopen(file,"a");
 if(fpl==NULL)
  printf("Can't open log-file %s\n",file);


 if(senderThreads<4)
  senderThreads=4;
 if(loginThreads<2)
  loginThreads=2;

 dataImported=false;
 readLists();
 initSync();
 initDateList();
 initReminderList();
 initAdrList();
 initTodoList();
 initProjList();
 readAdrList();
 readDates();
 readTodoList();
 readProjList();
 recreateReminderList();
 updateDateCountsInAddress();
 lastDateChange =time(NULL);
 ulistUpdateTim = stim = lastReminderListCreation =  rtim  = ntim= time(NULL);

 // FIXME fix errr in initReload
//  signal(SIGUSR1,initReload);  
//  signal(SIGHUP,initReload);  
 signal(SIGTERM,initCloseAllConnection);  
 signal(SIGINT ,initCloseAllConnection);  
 if(dataImported)
  {
   writeAllDates();
  }


 tasks =  new scheduleTask [256];
 printf("tasks: anz = %d cur=%d / %d\n",tasks[0].anz,tasks[0].inp,tasks[1].prc);
 printf("      0:  %p %p %d %d %d\n",tasks[0].cmd, tasks[0].answer, tasks[0].free, tasks[0].done,tasks[0].socket);


 if(doCheckPresence)
  checkPresence();
 initSockets();
 usleep(500000);

 pthread_t listenThread;
 pthread_create( &listenThread, NULL,execListenThread, NULL);

 sleep(2);
 // printf("Backupo PATH: '%s'\n",backupPath);
 commandThreadActive =true;
 while (!loginThreadsActive || !senderThreadsActive)
  usleep(100000);
 
 usleep(200000);
 
 if(verbose)
  printf("Wating for Commands\n");

  processClientCommands(notifyInterval,doCheckPresence);
}

void *processClientCommands( int notifyInterval, int doCheckPresence)
{
 int p;
 int stim,rtim,ntim,rctim,tim;
 int c=0;
 struct tm *lt;
 int nextBackup;

 thrCount++;
 processThreadStopped =false;
 printf("process Loop started (pid=%d)\n",getpid());
 stim = lastReminderListCreation =  rtim  = ntim= time(NULL);
 
 if(enableBackup)
  {
   tim = time(NULL);
   lt = localtime((const time_t *)&tim);
   lt->tm_sec=15;
   lt->tm_min=0;
   nextBackup = mktime(lt)+3600;
  }

 p = tasks[0].prc;
 for(;;)
  { // for ever
   c++;
   if(!tasks[p].free)
    {
     if(verbose)
      printf("\t\t\tprocessing command on %3d (%s)\n",p,tasks[p].cmd);
     processClientCommand();     
     if(verbose)
      printf("\t\t\tprocessing command on %3d done\n",p,tasks[p].cmd);
     p = tasks[0].prc;
   }
   usleep(1000);

   
  tim =  time(NULL);   
  if( (tim %60)<15)
   if(tim-rtim>30)
    {
     rtim=tim;
     check4Reminder();
     getToday();
     
     if(verbose)
      printf("wakueup to mrr (current Task: %d)\n",tasks[0].prc);
     for(int i=0 ;i<=userAnz; i++)
      if(userList[i].rsocket>=0)
       {
	if(verbose)
	 printf("send alive to mrr(%s) on socket %d\n",userList[i].name,userList[i].rsocket);
	send2Client(userList[i].rsocket,"ServerUp");
       }
//      printf("nextBackup: %d cur =%d\n",nextBackup,tim);

    }
  if((tim % notifyInterval)<15 || (tim -ntim) > notifyInterval +15)
   if( (tim -ntim) > 16)
    {
     checkNotifiers();
     ntim=tim;
    }
  if(tim -stim >60)
   {
    stim=tim;
    writeDates();
    if(doCheckPresence)
     checkPresence();
//     printf("nextBackup= %20s = %d\n",ctime((const time_t *)&nextBackup),nextBackup);
//     printf("cur       = %20s = %d\n",ctime((const time_t *)&tim),tim);
   }
  if(tim-lastReminderListCreation >3600)
   {
    recreateReminderList();
    updateDateCountsInAddress();
   }
  if(enableBackup)
   if(tim>nextBackup)
    {
     //     printf("BackupData !!!!!!!!!!\n");
     backupData();
     nextBackup += 3600;
    }


   if(doCloseAllConnection || doReload)
    { // main if
     suspendListenThread =true;
     suspendLoginThread   =true;

     if(listenThreadStopped)
      if(loginThreadStopped)
       { // ifs
	if(doCloseAllConnection)
	 {
	  closeAllConnection(1);
	  exit(0);
	 }
	if(doReload)
	 {
	  writeAdrList();
	  writeDates();
	  sleep(1);
	  clearDateList();
	  clearTodoList();
	  clearProjList();
	  clearLists();
	  clearReminderList();
	  clearAdrList();
	  
	   
	  readLists();
	  initDateList();
	  initAdrList();
	  initTodoList();
	  initProjList();
	  readAdrList();
	  readDates();
	  readTodoList();
	  readProjList();
	  initReminderList();
	  recreateReminderList();
	  ulistUpdateTim=stim =time(NULL);
	  doReload=false;
	 }
	suspendListenThread=false;
	suspendLoginThread=false;
       }
    }

  
  }

}

void processClientCommand()
{
 char *buffer;
 int socket;
 int p;

 p = tasks[0].prc;
 while(tasks[p].free)
  usleep(1000);


 tasks[p].active=true;

 buffer = tasks[p].cmd;
 socket = tasks[p].socket;

 if(strncmp(buffer,"registerDelay",13)==0)
  {
   delay [ socket ]  =atoi(buffer +14);
  }
 else if(strncmp(buffer,"addDate",7)==0)
  {
   if(addDate(buffer+8))
    send2Client(socket,"OK");
   else
    send2Client(socket,"denied");
  }
 else if(strncmp(buffer,"modifyDate",10)==0)
  {
   modifyDate(socket,buffer+11);
  }
 else if (strncmp(buffer,"aquireDate",10)==0)
  aquireDate(socket,buffer+11 );
 else if (strncmp(buffer,"cancelEditDate",14)==0)
  cancelEditDate(socket,buffer+15 );
 else if (strncmp(buffer,"shiftDateInfo",13)==0)
  getShiftDateInfo(socket,buffer+14 );
 else if (strncmp(buffer,"shiftDate",9)==0)
  shiftDate(socket,buffer+10 );
 else if (strncmp(buffer,"changeStatus ",13)==0)
  changeDateStatus4User(socket,buffer+13 );
 else if (strncmp(buffer,"suspendDate",11)==0)
  suspendDate(socket,buffer+12 );
	
	
 else if(strncmp(buffer,"getUserCal",10)==0)
  getUserCal(buffer+11,socket);
 else if(strncmp(buffer,"getUserPrefs",12)==0)
  getUserPrefs(buffer+13,socket);
 else if(strncmp(buffer,"getUserView",11)==0)
  sendUsersView(socket,buffer+12);
 else if(strncmp(buffer,"saveUserPrefs",13)==0)
  setUserPrefs(buffer+14,socket);
 else if(strncmp(buffer,"getSyncPrefs",12)==0)
  getSyncPrefs(socket,buffer+13);
 else if(strncmp(buffer,"saveUsersView",13)==0)
  saveUsersView(socket,buffer+14);
 else if(strncmp(buffer,"saveSyncPrefs",13)==0)
  saveSyncPrefs(socket,buffer+14);
 else if(strncmp(buffer,"clearPwd",8)==0)
  clearPWD(socket,buffer+9);
 else if(strncmp(buffer,"saveSet",7)==0)
  saveIDset(buffer+8,socket);
 else if(strncmp(buffer,"getLists",8)==0)
  getLists(socket);
 else if(strncmp(buffer,"getMemberLists",14)==0)
  getGroupMembersList(socket);
 else if(strncmp(buffer,"getUserList",11)==0)
  getUserList(socket);
 else if(strncmp(buffer,"getGroupList",12)==0)
  getGroupList(socket);
 else if(strncmp(buffer,"getRoomList",11)==0)
  getRoomList(socket);
 else if(strncmp(buffer,"getFullUserName",15)==0)
  getFullUserName(socket,buffer+16);
 else if (strncmp(buffer,"groupListByUser",15)==0)
  getGroupsOfUser(socket,buffer+16);
 else if (strncmp(buffer,"usersOfGroup",12)==0)
  getUsersOfGroup(socket,buffer+13);
 else if (strncmp(buffer,"deleteDate",10)==0)
  deleteDate(socket,buffer+11);
 else if (strncmp(buffer,"getDateAndAquire",16)==0)
  sendDate(socket,buffer+17 ,true);
 else if (strncmp(buffer,"getInfo4NewDate",15)==0)
  sendInfo4NewDate(socket,buffer+16);	
 else if (strncmp(buffer,"getDate",7)==0)
  sendDate(socket,buffer+8 ,false);
 else if (strncmp(buffer,"getBriefDate",12)==0)
  sendBriefDate(socket,buffer+13 );
 else if (strncmp(buffer,"getMultiBriefDate",17)==0)
  sendMultiBriefDate(socket,buffer+18 );
 else if (strncmp(buffer,"getBlockedTimes",15)==0)
  getBlockedTimes(socket,buffer+16 );
 else if (strncmp(buffer,"ignoreDate",10)==0)
  ignoreDate(socket,buffer+11 );
 else if (strncmp(buffer,"doNotremind",11)==0)
  suspendReminder(socket,buffer+12 );
 else if (strncmp(buffer,"lastUListUpdate",15)==0)
  {
   sprintf(tclMsg,"%d",ulistUpdateTim);
   send2Client(socket,tclMsg);
  }
 else if (strncmp(buffer,"addComm",7)==0)
  addComm(socket,buffer+8 );
 else if (strncmp(buffer,"updateComm",10)==0)
  getComm(socket,buffer+10 );
 else if (strncmp(buffer,"lastChangeDate",14)==0)
  {
   sprintf(tclMsg,"%d",lastDateChange);
   send2Client(socket,tclMsg);
  }

 else if (strncmp(buffer,"getAdrFolders", 13)==0)
  sendAdrFolderList(socket,buffer+ 14 );
 else if (strncmp(buffer,"makeAdrFolder", 13)==0)
  makeAdrFolder(socket,buffer+ 14 );
 else if (strncmp(buffer,"changeAdrFolder",15)==0)
  changeAdrFolder(socket,buffer+ 16 );
 else if (strncmp(buffer,"moveAdrObjToFolder",18)==0)
  moveAdrObjToFolder(socket,buffer+ 19 );
 else if (strncmp(buffer,"delAdrFolder", 12)==0)
  deleteAdrFolder(socket,buffer+ 13 );
 else if (strncmp(buffer,"delMultiAdrFolder", 17)==0)
  deleteAdrFolders(socket,buffer+ 18 );
 else if (strncmp(buffer,"changeAdr", 9)==0)
  changeAdress(socket,buffer+10 );
 else if (strncmp(buffer,"getAdrList",10)==0)
  sendAddresssList(socket,buffer+11 );
 else if (strncmp(buffer,"getBriefAdrList",15)==0)
  sendBriefAdressList(socket,buffer+16 );
 else if (strncmp(buffer,"getAdr", 6)==0)
  sendAddress(socket,buffer+ 7 );
 else if (strncmp(buffer,"getFullAdr",10)==0)
  sendFullAddress(socket,buffer+ 11 );
 else if (strncmp(buffer,"delAdr", 6)==0)
  deleteAddress(socket,buffer+ 7 );
 else if (strncmp(buffer,"delMultiAdr", 11)==0)
  deleteAddresses(socket,buffer+ 12 );
	
 else if (strncmp(buffer,"addNotiz", 8)==0)
  addNotiz(socket,buffer+ 9,ADDRESS_NOTIZ );
 else if (strncmp(buffer,"changeNotiz", 11)==0)
  changeNotiz(socket,buffer+ 12 ,ADDRESS_NOTIZ );
 else if (strncmp(buffer,"getNotiz", 8)==0)
  getNotiz(socket,buffer+ 9 ,ADDRESS_NOTIZ);
 else if (strncmp(buffer,"sendNotizByMail", 15)==0)
  sendNotizByMail(socket,buffer+ 16,ADDRESS_NOTIZ );
 else if (strncmp(buffer,"addDirNotiz", 8)==0)
  addNotiz(socket,buffer+ 9,FOLDER_NOTIZ );
 else if (strncmp(buffer,"changeDirNotiz", 11)==0)
  changeNotiz(socket,buffer+ 12 ,FOLDER_NOTIZ );
 else if (strncmp(buffer,"getDirNotiz", 8)==0)
  getNotiz(socket,buffer+ 9 ,FOLDER_NOTIZ);
 else if (strncmp(buffer,"sendDirNotizByMail", 15)==0)
  sendNotizByMail(socket,buffer+ 16,FOLDER_NOTIZ );

 else if (strncmp(buffer,"changeTodo",10)==0)
  changeToDo(socket,buffer+11);
 else if (strncmp(buffer,"changeStatus4Todo",17)==0)
  changeTodoStatus(socket,buffer+18);
 else if (strncmp(buffer,"changeProject",13)==0)
  changeProject(socket,buffer+14);
 else if (strncmp(buffer,"getTODO", 7)==0)
  sendTodo(socket,buffer+ 8);
 else if (strncmp(buffer,"getProject",10)==0)
  sendProject(socket,buffer+11);
 else if (strncmp(buffer,"getProjLists",12)==0)
  sendProjectAndTodoLists(socket,buffer+13);
 else if (strncmp(buffer,"getLastProjTodoChange",21)==0)
  getLastProjTodoChange(socket);
 else if (strncmp(buffer,"deleteTodo",10)==0)
  deleteTodo(socket,buffer+11);
 else if (strncmp(buffer,"deleteProject",13)==0)
  deleteProject(socket,buffer+14);

 else if (strncmp(buffer,"getPresenceList",13)==0)
  getPresence(socket);

 else if(strncmp(buffer,"importCSV",9)==0)
  importCSV(socket,tasks[p].uid,buffer+10);

 else if (strncmp(buffer,"getSyncParameters",17)==0)
  getSyncParameters(socket);
 else if (strncmp(buffer,"openSync",8)==0)
  openSync(socket,buffer+9);
 else if (strncmp(buffer,"initSync",8)==0)
  initSync(socket,buffer+9);
 else if (strncmp(buffer,"syncIntoStop",12)==0)
  syncIntoStop(socket,buffer+13);
 else if (strncmp(buffer,"syncInto",8)==0)
  syncInto(socket,buffer+9);
 else if (strncmp(buffer,"nextCsv",7)==0)
  getNextCsvFromServer(socket,buffer+8);
 else if (strncmp(buffer,"endSync",7)==0)
  endSync(socket,buffer+8);
 else if (strncmp(buffer,"closeSync",9)==0)
  closeSync(socket,buffer+10);
 else
  {
   printf("Err unknown Command: %s",buffer);
   send2Client(socket,"Err unknown Command");
  }

 tasks[p].active = false;
 if(!tasks[p].skip)
  tasks[p].done = true;
 else
  tasks[p].free = true;



 tasks[0].prc = (tasks[0].prc +1) % tasks [0].anz;
}


void *execListenThread( void *ptr)
{
 int curTim,mrrTim=0;
 int uid;
 char buffer[16384];
 int i;
 int canz;
 int ret;
 pthread_t loginThread;


 if(verbose)
  printf("Listen Thread started (pid=%d)\n",getpid());

 pthread_create( &loginThread, NULL,processLogins, NULL);

 SendThread *sender, *nextSender;
 sender = new SendThread [senderThreads];
 for(i=0;i<senderThreads; i++)
  {
   pthread_mutex_init(&sender[i].start,NULL);
   pthread_mutex_init(&sender[i].wait,NULL);
   pthread_mutex_lock(&sender[i].start);
   pthread_mutex_unlock(&sender[i].wait);
   sender[i].avail  = true;
   sender[i].done   = false;
   sender[i].tid    = i;
   sender[i].taskId = -1;
   pthread_create( &sender[i].thr, NULL,senderThread,&sender[i]);
  }
 if(verbose)
  printf("Listen Thread active\n");
 senderThreadsActive =true;
 while (!loginThreadsActive || !commandThreadActive)
  usleep(100000);
 if(verbose)
  printf("Listening for requests\n");


 for(;;)
  {
   
   while(suspendListenThread)
    {
     listenThreadStopped =true;
     usleep(100000);
    }
   listenThreadStopped =false;

   curTim = time(NULL);
   if(curTim >mrrTim)
    {
     for(uid=0;uid<=userAnz; uid++)
      if(userList[uid].rsocket>0)
       {
	if( (canz=check4ClientMessage(userList[uid].rsocket,buffer,16383,2)) >0)
	 {
	  buffer[16383]='\0';
	  if (strncmp(buffer,"exit",4)==0)
	   {
	    if(verbose)
	     printf("Closing connection to reminder of %s/%d\n",userList[uid].name,uid);
	    ret = shutdown(userList[uid].rsocket,2);
	    ret = close(userList[uid].rsocket);
	    userList[uid].rsocket=-1;
	   }
	 }
       }
     mrrTim=curTim;
    }

   for(uid=0;uid<=userAnz; uid++)
    if(userList[uid].socket>0)
     {
      if( (canz=check4ClientMessage(userList[uid].socket,buffer,16383,MSG_MODE_CMD)) >0)
       {
	buffer[16383]='\0';

	if(verbose)
	 printf("Got: %s\n",buffer);
	
	if (strcmp(buffer,"client connected")==0)
	 sendMsg2Socket(userList[uid].socket,"connection verified");
	else if (strncmp(buffer,"getAnswer",9)==0)
	 {
// 	  if(verbose)
// 	   printf("checking sender threads\n");
	  for(i=0;i<senderThreads; i++)
	   if(!sender[i].avail)
	    if(sender[i].done)
	     {
// 	      if(verbose)
// 	       printf("reenable sender %2d\n",i);
	      pthread_mutex_trylock(&sender[i].start);
	      pthread_mutex_unlock(&sender[i].wait);
	      // don't set sender[i].avail=true here. This will be done by the threasd if its ready
	      sender[i].done =false;
	      if(verbose)
	       printf("reenable sender %2d done\n",i);
	     }
	  nextSender=NULL;
	  for(i=0;i<senderThreads; i++)
	   if(sender[i].avail)
	    {
	     nextSender = sender +i;
	     break;
	    }
	  if(nextSender != NULL)
	   {
	    if(verbose)
	     printf("checking sender threads done, sending via %d\n",nextSender->tid);
	    sendAnswer(uid,buffer+10,nextSender);
	   }
	  else
	   {
	    if(verbose)
	     printf("checking sender threads done, no sender aviaable (next=%p)\n",nextSender);
	    sendMsg2Socket(userList[uid].socket,"pending");
	   }
	 }
	else if (strncmp(buffer,"ServerUp?",9)==0)
	 {
	  sendMsg2Socket(userList[uid].socket,"ServerIsUp");
	  userList[uid].lastAction = time(NULL);
	 }
	else if (strncmp(buffer,"exit",4)==0)
	 {
	  userList[uid].lastAction =0;
	  closeSync(uid);
	  freeSockets(uid);
	 }
	else
	 {
	  int p= tasks[0].inp,p2;
	  if(!tasks[p].free)
	   {
	    int ttim = time(NULL);
	    if(ttim - tasks[p].time > 600 )
	     {
	      if(verbose)
	       printf("Ticket %d on tasks %d not used, remove ticket\n",tasks[p].ticket,p);
	      minkoLog("Ticket %d on tasks %d not used, remove ticket\n",tasks[p].ticket,p);
	      tasks[p].reset();
	     }
	   }


	  if(tasks[p].free)
	   {
	    if (userList[uid].ticket >=0 )
	     cancelTask(userList[uid].ticket % tasks [0].anz);

	    allocateAndCopy(&tasks[p].cmd ,buffer);
	    tasks[p].socket = userList[uid].socket;
	    tasks[p].uid    = uid;
	    tasks[p].ticket = tasks[p].baseTicket + p;
	    tasks[p].time   = time(NULL);
	    userList[uid].ticket = tasks[p].ticket;
	    tasks[0].inp ++;

	    if(verbose)
	     printf("command added at %3d (%s; %d; %d/%d)\n",p,tasks[p].cmd,
		    tasks[p].uid,tasks[p].socket,userList[uid].socket);
	    tasks[p].free = false;
	    sendTicket2Socket(userList[uid].socket, userList[uid].ticket);

	    while(tasks[0].inp >= tasks [0].anz)
	     {
	      tasks[0].inp        -= tasks [0].anz;
	      tasks[0].baseTicket =  (tasks[0].baseTicket + tasks [0].anz) & 0x7fffffff;
	     }	    
	   }
	  else
	   {
	    sendMsg2Socket(userList[uid].socket,"Error: The command queue on the server is full of tasks. Minkowsky can't handle any more right now. Please try again later\n");
	   }
	 }
       }      
     }

   int tim =  time(NULL);   
   for(int t=0; t<tasks[0].anz; t++)
    if(tasks[t].sendingDone)
     if(tim-tasks[t].sendStamp > 5)
      {
       //       printf("\t\treseting task %d\n",t);
       tasks[t].reset();
       //       printf("\t\treseting task %d done\n",t);
      }

   usleep(10000);
  }
}

void cancelTask(int p)
{
 if(!tasks[p].active && !tasks[p].done )
  tasks[p].reset();
 else
  {
   if(!tasks[p]. sending)
    tasks[p].skip = true;
  }

}



int sendAnswer(int uid,char *str,SendThread *info)
{
 int ticket = atoi(str);
 int p,taskId=-1,*tp,err,i;
 pthread_t sendThread;
 static SendThread *sender =NULL;
 int senderAnz=16;


 info->avail=false;
 
 if( userList[uid].ticket != ticket)
  {
   sendMsg2Socket(tasks[taskId].socket,"Error requested ticket is not yours. Maybe you are loged into Minkowsky twice.");
   return false;
  }

 taskId = (ticket %  tasks[0].anz);
 if(tasks[taskId].ticket != ticket)
  {
   for(p=0;p<tasks[0].anz; p++)
    if(tasks[p].ticket == ticket)
     {
      taskId=p;
      break;
     }
  }
 if(tasks[taskId].ticket != ticket)
  {
   sendMsg2Socket(tasks[taskId].socket,"Error Command ticket does not exists on server or may be expired\n");
   return false;
  }

 if(tasks[taskId].uid != uid )
  {
   sendMsg2Socket(tasks[taskId].socket,"Error requested task-ID is not yours exists. Maybe you are loged into Minkowsky twice.");
   return false;
  }

 if(tasks[taskId].done)
  if(tasks[taskId].skip)
   {
    tasks[taskId].reset();
    sendMsg2Socket(tasks[taskId].socket,"Error requested task-ID does not exists. Maybe you are loged into Minkowsky twice.");
    return false;
   }
 
 while(suspendsendThreads)
  usleep(10000);
 
 if(tasks[taskId].done)
  {
   info->taskId=taskId;
   printf("start sending on thread %d (1)\n",info->tid);
   if(pthread_mutex_trylock(&info->wait) ==0)
    {
     printf("start sending on thread %d (2)\n",info->tid);
     pthread_mutex_unlock(&info->start);
     printf("start sending on thread %d done\n",info->tid);
    }
  }
 else
  {
   info->avail = true;
   sendMsg2Socket(tasks[taskId].socket,"pending");
   if(verbose)
    printf("task %d/%d still pending\n",taskId,ticket);
   if (fpl != NULL)
    fprintf(fpl,"TASK %d/%d is still pending (%s)\n",taskId,ticket,tasks[taskId].cmd);
  }

 return true;
}

void *senderThread( void *ptr)
{
 SendThread * info = (SendThread *) ptr;
 char buf[33];
 int taskId;

 for (;;)
  {
   info->avail =true;
   if(verbose)
    printf("sender %2d waiting for job %d\n",info->tid,info->avail);
   // waiting for something to do
   pthread_mutex_lock(&info->start);
   pthread_mutex_unlock(&info->start);
   taskId = info->taskId;

   tasks[taskId].sending =true;
   tasks[taskId].sendingDone =false;
   if(verbose)
    {
     printf("sender %2d: SENDING ANSWER FOR %d on %d // %s\n",info->tid,taskId,tasks[taskId].socket,tasks[taskId].cmd);
     strncpy(buf,tasks[taskId].answer,32);
     printf("\t\t\tans =%s...\n",buf);
    }
   send2Socket(tasks[taskId].socket,tasks[taskId].answer);
   
   tasks[taskId].sending = false;
   tasks[taskId].sendingDone = true;
   tasks[taskId].sendStamp = time(NULL);
   //   tasks[taskId].sendTask = false;
   info->done =true;
   if(verbose)
    printf("sender %2d  job done\n",info->tid);
   // waiting to be reset   
   pthread_mutex_lock(&info->wait);
   pthread_mutex_unlock(&info->wait);
//    printf("sender %d frees wait mutex\n",info->tid);
  }   

 pthread_exit(NULL);
}


int send2Client(int socket,char *msg)
{
 int taskId =-1;
 int p;

 for(p=0;p<tasks[0].anz; p++)
  if(tasks[p].active)
   if(tasks[p].socket = socket)
    {
     taskId =p;
     break;
    }
 
 if( taskId <0 )
  return false;
 
 allocateAndCopy(&tasks[taskId].answer,msg);
 return true;
}


#define LOGIN_NOTHING 0
#define LOGIN_CONNECT 1
#define LOGIN_REMINDER 2
typedef struct
{
 pthread_t thr;
 pthread_mutex_t start,wait;
 char buffer[256];
 int tmpSocket;
 int id;
 int tid;
 int done;
 int avail;
 int type;
}LoginThread;

void *processLogins( void *ptr)
{
 char buffer[256];
 int tmpSocket;
 int canz;
 int uid;
 int ret;
 int err;
 // LoginInfo *info;
 // unsigned int lc=0;
 int loginId=0;
 LoginThread *login;
 // int loginThreads=8;
 int i;
 int nextFreeLoginId;

 loginThreadStopped =false;
 thrCount++;
 if(verbose)
  printf("login Thread started (pid=%d)\n",getpid());


 login = new LoginThread [loginThreads];
 for(i=0;i<loginThreads; i++)
  {
   pthread_mutex_init(&login[i].start,NULL);
   pthread_mutex_init(&login[i].wait,NULL);
   pthread_mutex_lock(&login[i].start);
   pthread_mutex_unlock(&login[i].wait);
   login[i].avail = true;
   login[i].done  = false;
   login[i].tid   = i;
   pthread_create( &login[i].thr, NULL,processLogin,&login[i]);
  }
 if(verbose)
  printf("Login Threads active\n");
 loginThreadsActive =true;
 while (!senderThreadsActive || !commandThreadActive)
  usleep(100000);
 if(verbose)
  printf("wating for logins\n");

 for(;;)
  {
   usleep(100000);
   //   lc = (lc+1) & 0xFFFF;
   while(suspendLoginThread)
    {
     loginThreadStopped =true;
     usleep(100000);
    }
   loginThreadStopped =false;

   for(i=0;i<loginThreads; i++)
    if(! login[i].avail)
     if(login[i].done)
      {
       printf("reenable loginThread %d\n",i);
       pthread_mutex_lock(&login[i].start);
       pthread_mutex_unlock(&login[i].wait);
       printf("reenable loginThread %d done\n",i);
       login[i].done =false;
      }
     
   nextFreeLoginId=-1;     
   for(i=0;i<loginThreads; i++)
    if(login[i].avail)
     {
      nextFreeLoginId=i;
      break;
     }


   if( (tmpSocket=check4NewConnection()) >=0)
    { // tmp
     if(nextFreeLoginId<0)
      sendMsg2Socket(tmpSocket,"noResource; try later");
     else
      {
       int id=nextFreeLoginId;
       if(verbose)
	printf("Masterport connection on %d\n",tmpSocket);
       if( (canz=check4ClientMessage(tmpSocket,login[id].buffer,255,MSG_MODE_LOGIN)) >0)
	{
	 login[id].buffer[255]='\0';
	 if(verbose)
	  printf("Got on %d: %s\n",tmpSocket,login[id].buffer);
	 
	 if(strncmp(login[id].buffer,"openReminder",12)==0 )
	  login[id].type= LOGIN_REMINDER;
	 else if(strncmp(login[id].buffer,"connect",7)==0 ||strncmp(login[id].buffer,"reconnect",9)==0 )
	  login[id].type= LOGIN_CONNECT;
	 else
	  {
	   login[id].type= LOGIN_NOTHING;
	   shutdown(tmpSocket,2);
	  }
	 if(login[id].type != LOGIN_NOTHING)
	  {
	   login[id].avail = false;
	   //	   strncpy(login[id].buffer,buffer,256);
	   //	   login[id].buffer[255]='\0';
	   login[id].tmpSocket=tmpSocket;
	   login[id].id = loginId++;
	   pthread_mutex_unlock(&login[i].start);
	   pthread_mutex_lock(&login[i].wait);
	  }
	}
      }
    }
  }
}

void *processLogin( void *ptr)
{
 char user[32],pwd[32],dummy[32],dummy2[32],npwd[32],salt[4],oldCidStr[64];
 int reconn=false;
 int uid,canz;
 char *buffer;
 int tmpSocket;
 LoginThread *info = (LoginThread *) ptr;
 int id;
 int tim;
 int ret;

 thrCount++;


 buffer =  info->buffer;
 for(;;)
  {
   info->avail = true;
   minkoLog("LOGIN: CONNECT thread %d waiting for job\n",info->tid);
   
   // waiting for something to do
   pthread_mutex_lock(&info->start);
   pthread_mutex_unlock(&info->start);
   tmpSocket = info->tmpSocket;

   minkoLog("LOGIN: CONNECT thread %d activated for job %d \n",info->tid,info->id);
   

   if(info->type == LOGIN_REMINDER)
    {
     if(verbose)
      printf("Connecting Reminder via '%s'\n",buffer);
     sscanf(buffer,"%s %s",dummy,user); //FIXME AUTH
     uid=uname2uid(user);
     if(uid<0)
      {
       if(verbose)
	printf("no such user '%s'\n",user);
       send2Socket(tmpSocket,"denied");
       return NULL;
      }
     if(userList[uid].rsocket>0)
      {
       if(verbose)
	printf("Reopenning Connection to Reminder of %s/%d (old socket =%d)\n",userList[uid].name,uid,userList[uid].rsocket);
       ret = shutdown(userList[uid].rsocket,2);
       ret = close(userList[uid].rsocket);
      }
     userList[uid].rsocket= tmpSocket;
     send2Socket(userList[uid].rsocket,"registered");
     if(verbose)
      printf("Reminder App for %s/%d has been registered on Socket %d\n",userList[uid].name,uid,userList[uid].rsocket);
    }
   else
    {
     if(strncmp(buffer,"reconnect",9)==0 )
      {
       if(verbose)
	printf("LOGIN: Reconnecting via '%s'\n",buffer);
       minkoLog("LOGIN: reconnected via '%s'\n",buffer);
       reconn=true;
      }
     else
      if(verbose)
       printf("LOGIN-%03d: Connecting on %d via '%s'\n",info->id,info->tmpSocket,buffer);
   
     sscanf(buffer,"%s %s %s %s",dummy,user,pwd,oldCidStr); //FIXME AUTH
   
     uid=uname2uid(user);
     if(uid<0)
      {
       if(verbose)
	printf("LOGIN: no such user %s\n",user);
       sendMsg2Socket(tmpSocket,"denied");
       goto LoginDone;
      }
   
     if(userList[uid].id!=uid )
      {
       if(verbose)
	printf("LOGIN: no such user %s\n",user);
       sendMsg2Socket(tmpSocket,"denied");
       goto LoginDone;
      }
   
   
     if(pthread_mutex_trylock(&userList[uid].connectMutex) != 0)
      {
       printf("LOGIN-%03d: mutex for uid %d is locked by another thread\n",info->id,uid);
       minkoLog("LOGIN: CONNECT thread %d mutex for uid %d is locked by anoither thread\n",info->id,uid);
       pthread_mutex_lock(&userList[uid].connectMutex); 
       minkoLog("LOGIN: CONNECT thread %d mutex locked for uid %d\n",info->id,uid);
       printf("LOGIN-%03d: mutex locked for uid %d \n",info->id,uid);
      }
     else
      {
       minkoLog("LOGIN: CONNECT thread %d mutex locked for uid %d\n",info->id,uid);
       printf("LOGIN-%03d: mutex locked for uid %d \n",info->id,uid);
      }
   
   
     tim=time(NULL);
     if(tim -userList[uid].connectionTime <5)
      {
       if(verbose)
	printf("LOGIN:\nLOGIN: Earlier connect already loged in\n");
       minkoLog("LOGIN: CONNECT thread %d blocked; other thread finished login\n",info->id);
       sendMsg2Socket(tmpSocket,"blocked");
       pthread_mutex_unlock(&userList[uid].connectMutex);  
       goto LoginDone;
      }
     if(! reconn)
      if (tim - userList[uid].lastAction < 180)
       {
	if(verbose)
	 printf("LOGIN:\nLOGIN: User %d already loged in\n",uid);
	minkoLog("LOGIN: CONNECT thread %d: User %d already loged in\n",info->id,uid);
	sprintf(tclMsg,serverMsg[SERVER_MSG_ALREADY_LOGED_IN],user);
	sendMsg2Socket(tmpSocket,tclMsg);
	pthread_mutex_unlock(&userList[uid].connectMutex);  
	goto LoginDone;
       }
   
     readUserPrefs(uid);
     strncpy(salt,userList[uid].pwd,2);
     salt[2]='\0';
     strcpy(npwd,text2Pwd(pwd,salt));
     if(strcmp(pwd,"")!=0 || strlen(userList[uid].pwd)>0)
      if(strcmp(npwd,userList[uid].pwd)!=0)
       {
	if(verbose)
	 printf("LOGIN: AUTH error '%s' '%s'\n",userList[uid].pwd,text2Pwd(pwd,userList[uid].pwd));
	sendMsg2Socket(tmpSocket,"denied");
	// printf("LOGIN-%03d: mark 5\n",info->id)
	pthread_mutex_unlock(&userList[uid].connectMutex);  
	goto LoginDone;
       }
     if(reconn)
      {
       if(userList[uid].socket >=0)
	{
	 if(verbose)
	  printf("LOGIN: reconnect: freeing old socket (%d) for uid  %d\n",userList[uid].socket,uid);
	 _freeSockets(uid,true,tmpSocket);
	}
      }
     // printf("LOGIN-%03d: mark 7\n",info->id);
   
     if(verbose)
      printf("LOGIN-%03d: User %s/%d connetced on socket %d\n",info->id,user,uid,tmpSocket);
     usleep(1000);
     sprintf(tclMsg,"connected %d",1);
     sendMsg2Socket(tmpSocket,tclMsg);

     //  if(verbose)
     //   printf("LOGIN-%03d: expecting 'ack'\n");
     if( (canz=check4ClientMessage(tmpSocket,buffer,255,MSG_MODE_LOGIN)) >0)
      {
       if (strcmp(buffer,"client connected")==0)
	{
	 sendMsg2Socket(tmpSocket,"connection verified");
	 userList[uid].socket = tmpSocket;
	 userList[uid].lastAction = (int) time(NULL);
	 delay[userList[uid].socket] =0;
	 userList[uid].connectionTime =tim;
	 if(verbose)
	  printf("LOGIN: connection for User %s/%d verified on socket %d\n",user,uid,userList[uid].socket);
	 minkoLog("LOGIN: CONNECT thread %d: Success for User %d.\n",info->id,uid);
	}
       else
	{
	 if(verbose)
	  printf("LOGIN: got wrong ack\n");
	 freeSocketsTotal(uid);
	}
      }
     else
      {
       if(verbose)
	printf("LOGIN: got no ack\n");
       freeSocketsTotal(uid);
      }
   
     if(verbose)
      printf("LOGIN: done\n");
     pthread_mutex_unlock(&userList[uid].connectMutex);  
     minkoLog("LOGIN: CONNECT thread %d done, mutex unlock for uid=%d\n",info->id,uid);
    }
  LoginDone:
   info->done =true;
   // waiting to be reset
   
   minkoLog("LOGIN: CONNECT thread %d, job %d done, waiting to go on\n",info->tid,info->id);
   pthread_mutex_lock(&info->wait);
   pthread_mutex_unlock(&info->wait);
  }
 pthread_exit(NULL);
}

void initReload(int value)
{
 doReload=true;
}

void initCloseAllConnection(int vlaue)
{
 doCloseAllConnection=true;
}


