//  File: notiz.cc
// 
//      This file is part of minkowsky
// 
//      Copyright (C) 2001-2002 by Rdiger Goetz
//      Author: Rdiger Goetz <minkowsky@r-goetz.de>
// 
//      Time-stamp: <14-Oct-2002 19:55:01 goetz>
// 
//      This program is free software; you can redistribute it and/or modify
//      it under the terms of the GNU General Public License as published by
//      the Free Software Foundation; either version 2 of the License, or
//      (at your option) any later version.
// 
//      This program is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU General Public License for more details.
// 
//      You should have received a copy of the GNU General Public License
//      along with this program; if not, write to the Free Software
//      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//  
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <errno.h>  
#include <time.h>  

#include "termin.h"


#define NCP_READ 1
#define NCP_INIT 2
#define NCP_EXTEND 3
int nextNotizID(int aid,int parent);
int nextDirNotizID(int dirid,int parent);
int addAdrNotiz(int aid,int parent, int uid,int date, int time, char *title, char *text);
int addDirNotiz(int dirid,int parent, int uid,int date, int time, char *title, char *text);
int fillNotiz(Notiz *ntz,int parent, int uid,int date, int time, char *title, char *text);
int addNotiz(int socket, char *str);
int changeNotiz(NotizControl *nc, int nid, char *text);
int changeNotiz(int aid, int nid, char *text);
int changeDirNotiz(int dirid, int nid, char *text);
NotizControl * checkNotizControl(int id, int type, int mode);

int access2AdrFolder(int uid, AddressFolder *adf);
int access2Adr(int uid, Address *adr, char *permStr);

// new notiz blocks
NotizControl *initNotizList(int id,int type)
{
 NotizControl *nc;

 // printf("\t\tinit: check on %d/%d\n",id,type);
 nc = checkNotizControl(id,type,NCP_INIT);
 return(nc);
}
NotizControl *_initNotizList(int id,int type)
{
 int i;
 NotizControl *nc;
 nc = new  NotizControl;
 nc->notiz = new Notiz [DATEBLOCKSIZE];
 nc->max =DATEBLOCKSIZE;
 nc->anz=0;
 nc->id =id;
 nc->type=type;
 for(i =0; i< DATEBLOCKSIZE ;i++)\
  {
   nc->notiz[i].title =NULL;
   nc->notiz[i].text =NULL;
   nc->notiz[i].id=-1;
   nc->notiz[i].status = NOTIZ_EMPTY;
  }
 // printf("\t\tinit: nc=%p\n",nc);
 // printf("\t\tinit: anz=%d\n",nc->anz);
 return(nc);
}



void clearNotizList ( NotizControl *nc)
{
 Address *adr;
 int i;

 if(nc!= NULL)
  {
   for(i=0;i<nc->anz ; nc++)
    if(nc->notiz[i].id>=0)
     {
      if(nc->notiz[i].title !=NULL)
       delete nc->notiz[i].title;
      if(nc->notiz[i].text !=NULL)
       delete nc->notiz[i].text;
     }
   delete nc->notiz;
   delete nc;
  }
}

void extendNotizList(NotizControl *nc)
{
 Notiz *tmp;
 int i;
 
 tmp = new Notiz [nc->max + DATEBLOCKSIZE];
 memcpy(tmp,nc->notiz, sizeof(Notiz) * nc->max);
 delete nc->notiz;
 nc->notiz = tmp;
 for(i =nc->max; i<nc->max + DATEBLOCKSIZE ;i++)\
  {
   nc->notiz[i].title =NULL;
   nc->notiz[i].text =NULL;
   nc->notiz[i].id=-1; 
   nc->notiz[i].status = NOTIZ_EMPTY;
  }
 nc->max += DATEBLOCKSIZE;
}
void extendNotizList(int id, int type)
{
 checkNotizControl(id,type,NCP_EXTEND);
}


int readNotiz(Address *adr)
{
 FILE *fp;
 char file[1024];
 struct stat fstat;

 if(adr->notiz == NULL)
  adr->notiz = initNotizList(adr->id,ADDRESS_NOTIZ);

 sprintf(file,"%s/notiz/Adr%08d.txt",dataDir,adr->id);
 if(stat(file,&fstat)<0)
  return(false);
 
 fp=fopen(file,"r");
 if(fp==NULL)
  {
   printf("can't open %s\n",file);
   return(false);
  }

 printf("reading Notiz form '%s'\n",file);
 readNotiz(fp,adr->notiz);
 fclose(fp);
 return(true); 
}


int nextNotizID(int id,int parent, int type)
{
 NotizControl *nc;
 int idx;


 nc  = checkNotizControl(id,type,NCP_INIT);
 if(nc ==  NULL)
  return -1;
 return(_nextNotizID(nc,parent));
}
int _nextNotizID(NotizControl *nc, int parent)
{
 int nid;

 nid = nc->anz;
 if(parent<-1 || parent>= nc->anz)
  parent =-1;

 nc->anz++;
 if(nc->anz >= nc->max)
  extendNotizList(nc->id,nc->type);
 nc->notiz[nid].id = nid;
 nc->notiz[nid].parent = parent;
 nc->notiz[nid].status = NOTIZ_ALLOC;
 return(nc->anz-1);
}


int fillNotiz(Notiz *ntz,int parent, int uid,int date, int time, char *title, char *text)
{
 ntz->uid   = uid;
 ntz->date  = date;
 ntz->time  = time;
 ntz->title = new char [strlen(title) +4];
 ntz->text  = new char [strlen(text) +4];
 strcpy(ntz->title,title);
 strcpy(ntz->text,text);
}
// TCL uname id parent date time title text
int addNotiz(int socket, char *str,int type)
{
 char *tp[64],ans[256];
 int id,idx,uid,nid,date,time,parent;
 NotizControl *nc;
 
 split(str,tp,64);
 uid = uname2uid(tp[0]);
 if(uid<0 || uid >= userAnz)
  {
   send2Client(socket,"Error: No such user\n");
   return(false);
  }

 parent = atoi(tp[2]);
 date= atoi(tp[3]);
 time= atoi(tp[4]);
 switch ( tp[1][0] )
  {
  case 'd' :
   type = FOLDER_NOTIZ;
   id = atoi(tp[1]+1);
   break;
  case 't' :
   type = TASK_NOTIZ;
   id = atoi(tp[1]+1);
   break;
  case 'p' :
   type = PROJECT_NOTIZ;
   id = atoi(tp[1]+1);
   break;
  case 'c' :
   type = CALENDAR_NOTIZ;
   id = atoi(tp[1]+1);
   break;
  default:
   type = ADDRESS_NOTIZ;
   id = atoi(tp[1]);
   break;
  }

 nc  = checkNotizControl(id,type,NCP_READ);
 if(nc == NULL)
  {
   send2Client(socket,"Error add Notiz (nc==NULL)");
   return(-1);
  }

 nid=  nextNotizID(id,parent,type);
 if( nid <0)
  {
   send2Client(socket,"Error add notiz\n");
   return(false);
  }
 fillNotiz(&nc->notiz[nid],parent,uid,date,time,tp[5],tp[6]);
 
 switch (type)
  {
  case FOLDER_NOTIZ:
   writeNotiz(adfList[id]);
   break;
  case TASK_NOTIZ:
   idx = tid2idx(id);
   writeNotiz(todoList[idx]);
   break;
  case PROJECT_NOTIZ:
   idx = pid2idx(id);
   writeNotiz(projList[idx]);
   break;
  case CALENDAR_NOTIZ:
   //   idx = pid2idx(id);
   writeNotiz(dateList[id]);
   break;
  case ADDRESS_NOTIZ:
  default:
   idx = aid2idx(id);
   writeNotiz(adrList[idx]);
   break;
  }

 sprintf(ans,"%d",nid);
 send2Client(socket,ans);
 return 0;
}

int changeNotiz(NotizControl *nc, int nid, char *text)
{
 Notiz *ntz;

 if(nid<0 || nid > nc->anz )
  return(false);
 ntz = &nc->notiz[nid];
 delete ntz->text;
 ntz->text  = new char [strlen(text) +4];
 strcpy(ntz->text,text);
 return(true);
}

int changeNotiz(int socket, char *str,int type)
{
 char *tp[64];
 int id,idx,nid,success;
 NotizControl *nc;

 split(str,tp,64);

 nid = atoi(tp[1]);
 switch( tp[0][0])
  {
  case 'd': 
   type = FOLDER_NOTIZ;
   id  = atoi(tp[0]+1);
   break;
  case 't':
   type = TASK_NOTIZ;
   id = atoi(tp[0]+1);
   break;
  case 'p':
   type = PROJECT_NOTIZ;
   id = atoi(tp[0]+1);
   break;
  case 'c':
   type = CALENDAR_NOTIZ;
   id = atoi(tp[0]+1);
   break;
  default:
   type = ADDRESS_NOTIZ;
   id = atoi(tp[0]);
   break;
  }
 nc   = checkNotizControl(id,type,NCP_READ);
 if(nc == NULL)
  {
   send2Client(socket,"Error changing Notiz (nc==NULL)");
   return(false);
  }
  
 success=changeNotiz(nc,nid,tp[2]);

 if(!success)
  {
   send2Client(socket,"Error changing Notiz (can't change)");
   return(false);
  }

 switch (type)
  {
  case FOLDER_NOTIZ:
   writeNotiz(adfList[id]);
   break;
  case TASK_NOTIZ:
   idx = tid2idx(id);
   writeNotiz(todoList[idx]);
   break;
  case PROJECT_NOTIZ:
   idx = pid2idx(id);
   writeNotiz(projList[idx]);
   break;
  case CALENDAR_NOTIZ:
   writeNotiz(dateList[id]);
   break;
  case ADDRESS_NOTIZ:
  default:
   idx = aid2idx(id);
   writeNotiz(adrList[idx]);
   break;
  }
 send2Client(socket,"done");
}


NotizControl * checkNotizControl(int id, int type, int mode)
{
 int idx;

 switch (type)
  {
  case FOLDER_NOTIZ:
   AddressFolder *adf;

   if(id<0 || id>=adfAnz)
    return(NULL);
   adf = adfList[id];
   if(adf == NULL)
    return(NULL);

   if(adf->notiz==NULL)
    switch (mode)
     {
     case NCP_READ:
      readNotiz(adf);
      break;
     case NCP_INIT:
     case NCP_EXTEND:
      adf->notiz =  _initNotizList (id,type);
      break;
     }
   else
    if(mode ==  NCP_EXTEND)
     extendNotizList(adf->notiz);

   return(adf->notiz);
   break;

  case TASK_NOTIZ:
   TodoItem *todo;

   idx=tid2idx(id);
   if(idx<0 || idx>=todoAnz)
    return(NULL);
   todo = todoList[idx];
   if(todo == NULL)
    return(NULL);    

   if(todo->notiz==NULL)
    switch (mode)
     {
     case NCP_READ:
      readNotiz(todo);
      break;
     case NCP_INIT:
     case NCP_EXTEND:
      todo->notiz =  _initNotizList (id,type);
      break;
     }
   else
    if(mode ==  NCP_EXTEND)
     extendNotizList(todo->notiz);

   return(todo->notiz);
   break;
  case PROJECT_NOTIZ:
   Project *proj;

   //   printf("\t\tcheck:\n");
   idx=pid2idx(id);
   //   printf("\t\tcheck: idx=%d\n",idx);
   if(idx<0 || idx >=projAnz)
    return NULL;
   proj = projList[idx];
   //   printf("\t\tcheck: proj=%p\n",proj);
   if(proj == NULL)
    return(NULL);

   //   printf("\t\tcheck: notiz=%p\n",proj->notiz);
   if(proj->notiz==NULL)
    switch (mode)
     {
     case NCP_READ:
      readNotiz(proj);
      break;
     case NCP_INIT:
     case NCP_EXTEND:
      //      printf("\t\tcheck: alloc\n");
      proj->notiz =  _initNotizList (id,type);
      //      printf("\t\tcheck:-> %p\n",proj->notiz);
      break;
     }
   else
    if(mode ==  NCP_EXTEND)
     extendNotizList(proj->notiz);

   //   printf("\t\tcheck: -> %p\n",proj->notiz);
   //   printf("\t\tcheck: -> %d\n",proj->notiz->anz);
   return(proj->notiz);
   break;

  case CALENDAR_NOTIZ:
   Date *d;

   //   idx=tid2idx(id);
   if(id<0 || id>=dateAnz)
    return(NULL);
   d = dateList[id];
   if(d == NULL)
    return(NULL);    

   if(d->notiz==NULL)
    switch (mode)
     {
     case NCP_READ:
      readNotiz(d);
      break;
     case NCP_INIT:
     case NCP_EXTEND:
      d->notiz =  _initNotizList (id,type);
      break;
     }
   else
    if(mode ==  NCP_EXTEND)
     extendNotizList(d->notiz);

   return(d->notiz);
   break;

  case ADDRESS_NOTIZ:
  default:
   Address *adr;
   
   idx=aid2idx(id);
 
   if(idx<0 || idx>=adrAnz)
    return(NULL);
   adr = adrList[idx];

   if(adr->notiz==NULL)
    switch (mode)
     {
     case NCP_READ:
      readNotiz(adr);
      break;
     case NCP_INIT:
     case NCP_EXTEND:
      adr->notiz =  _initNotizList (id,type);
      break;
     }
   else
    if(mode ==  NCP_EXTEND)
     extendNotizList(adr->notiz);

   return(adr->notiz);
   break;
  }
 return NULL;
}

// Format getNotiz uid id [id [ id ....]]
// Format getDirNotiz uid id
int getNotiz(int socket, char *str,int type)
{
 char *tp[1024],permStr[16];
 int uid,aid,aidx,dirid,id,anz,j;
 int i;
 Address *adr;
 NotizControl *nc;
 Notiz *ntz;
 char *buffer;
 int bufferLen;
 int textLen=0,len;
 char miniBuffer[65536];
 char prefix=' ';
 int cid=-99;
 char *cals[1024];
 int canz=-1;

 anz = split(str,tp,1023);
 uid = uname2uid(tp[0]);

 if(uid<0 || uid >= userAnz)
  {
   send2Client(socket,"Error: No such user\n");
   return(false);
  }

 
 buffer = new char [65536];
 bufferLen = 65500;
 buffer[0]='\0';


 for (j=2;j<anz; j++)
  {
   //   printf("searching for memo '%s'\n",tp[j]);
   int next=false;
   nc = NULL;
   switch (tp[j][0])
    {
    case 'd' : 
     {
      id = dirid = atoi(tp[j]+1);
      prefix='d';
      if(dirid<0 || dirid >= adfAnz || adfList[dirid] == NULL)
       { 
	next =true;
	break;
       }     
      if(access2AdrFolder(uid,adfList[dirid]))
       strcpy(permStr,"rwn");
      else
       strcpy(permStr,"r--");
      nc= adfList[dirid]->notiz;
      if(nc==NULL)
       {
	if(readNotiz(adfList[dirid]))
	 nc= adfList[dirid]->notiz;
       }
      if(nc==NULL)
       next=true;
      break;
     }
    case 't' : 
     {
      int tid,idx,perm;
      
      id = tid = atoi(tp[j]+1);
      if( (idx = tid2idx(tid)) < 0)
       { 
	next =true;
	break;
       }     
      prefix='t';
      perm = permission4Todo(todoList[idx],uid);
      if(perm == TODO_SEND_NOT)
       { 
	next =true;
	break;
       }     
      else if (perm == TODO_SEND)
       strcpy(permStr,"rwn");
      else
       strcpy(permStr,"r--");
      nc= todoList[idx]->notiz;
      if(nc==NULL)
       {
	if(readNotiz(todoList[idx]))
	 nc= todoList[idx]->notiz;
       }
      if(nc==NULL)
       next=true;
      break;
     }
    case 'p' : 
     {
      int pid,idx,perm;
      
      //      printf("%s-1: nc=%p\n",tp[j],nc);
      id = pid = atoi(tp[j]+1);
      if( (idx = pid2idx(pid)) < 0)
       { 
	next =true;
	break;
       }     
      prefix='p';
      perm = permission4Proj(projList[idx],uid);
      if(perm == TODO_SEND_NOT)
       { 
	next =true;
	break;
       }     
      else if (perm == TODO_SEND)
       strcpy(permStr,"rwn");
      else
       strcpy(permStr,"r--");
      //      printf("%s-2: nc=%p\n",tp[j],nc);
      nc= projList[idx]->notiz;
      if(nc==NULL)
       {
	if(readNotiz(projList[idx]))
	 nc= projList[idx]->notiz;
       }
      //      printf("%s-3: nc=%p\n",tp[j],nc);
      if(nc==NULL)
       next=true;
      break;
     }

    case 'c' : 
     {
      int perm;
      
      id = atoi(tp[j]+1);
      if(id<0 || id> dateAnz)
       {
	next =true;
	break;
       }
 
      prefix='c';

      if(canz <0)
       canz = split(tp[1],cals,1023);

      perm=0;
      for(int c=0;c<canz; c++)
       {
	cid =  name2FullID(cals[c]);
	if(cid<0)
	 continue;
	perm |= getPermission(dateList[id],uid,cid);
       }
	//      perm = getPermission(dateList[id],uid,cid);
      //      printf("\tPERM=%3X\n",perm);
      if( (perm  & READ_OTHER) == 0)
       { 
	next =true;
	break;
       }     
      else if (perm  & MODI_OTHER)
       strcpy(permStr,"rwn");
      else
       strcpy(permStr,"r--");
      nc= dateList[id]->notiz;
      if(nc==NULL)
       {
	if(readNotiz(dateList[id]))
	 nc= dateList[id]->notiz;
       }
      if(nc==NULL)
       next=true;
      break;
     }

    default:
     {
      id=aid = atoi(tp[j]);
      aidx = aid2idx(aid);
      if(aidx<0 || aidx >= adrAnz)
       { 
	next =true;
	break;
       }     
      prefix=' ';
      
      if (! access2Adr(uid,adrList[aidx],permStr) )
       continue;
      nc= adrList[aidx]->notiz;
      if(nc==NULL)
       {
	if(readNotiz(adrList[aidx]))
	 nc= adrList[aidx]->notiz;
       }
      if(nc==NULL)
       next=true;
      break;
     } 
    }
   if(next)
    continue;

   strcat(buffer,"{ ");
   strcat(buffer,permStr);
   strcat(buffer," { ");
   for(i=0;i<nc->anz; i++)
    {
     ntz = &nc->notiz[i];
     sprintf(miniBuffer,"{%c%d-%d { %d %d %s %d %d %d {%s} {%s}}}",
	     prefix,id,ntz->id,aid,ntz->id,userList[ntz->uid].name,ntz->date,ntz->time,ntz->parent,ntz->title,ntz->text);
     len = strlen(miniBuffer) ;
     while(len+textLen +2> bufferLen)
      {
       char *tmp;
       tmp = new char [bufferLen +65536];
       strcpy(tmp,buffer);
       delete buffer;
       buffer =tmp;
       bufferLen += 65536;
      }
     strcat(buffer," ");
     strcat(buffer,miniBuffer);
     textLen += len+1;
    }
   strcat(buffer,"} } ");
   //   printf("MEMO: //%s//\n",buffer);
  }
 send2Client(socket,buffer);
}

int sendMail2(char *to, char *smtp,char *subj, char *text)
{
 char *cmd;

 cmd = new char [strlen(text)+4096];
 if (smtp == NULL)
  sprintf(cmd,"echo '%s' |mail -s \"%s\" %s",text,subj,to);
 else
  {
   if(smtp[0] == '\0')
    sprintf(cmd,"echo '%s' |mail -s \"%s\" %s",text,subj,to);
   else
    sprintf(cmd,"%s %s %s  %s \"%s\" \"%s\"",mail2smtp,smtp,to,replyAddress,subj,text);
  }
 system(cmd);
 printf("Send Mail '%s' to %s via Email:\n",subj,to);
 printf("%s\n\n",cmd);
 delete cmd;
 return(true);
}

int sendMail2(int *to,int anz,char *subj, char *text)
{
 int i,j,gid,k,uid;
 
 for(i=0;i<userAnz;i++)
  userList[i].internalStatus =false;

 for(i=0;i<anz;i++)
  {
   printf("sending Mail to id=%d\n",to[i]);
   if(to[i]>=0)
    {
     if(to[i]<GROUPOFFSET)
      {
       uid = to[i];
       if(uid<userAnz)
	if(!userList[uid].internalStatus)
	 for(k=0;k<4;k++)
	  if(userList[uid].mail[k][0] !='\0')
	   {
	    sendMail2(userList[uid].mail[k],userList[uid].smtp[k],subj,text);
	    userList[uid].internalStatus =true;
	   }
      }
     else if(to[i]<ADDRESOFFSET)
      {
       gid=to[i] -GROUPOFFSET;
       if(gid < groupAnz)
	for(j=0;j<groupList[gid].anz; j++)
	 {
	  uid = groupList[gid].membr[j];
	  if(!userList[uid].internalStatus)
	   for(k=0;k<4;k++)
	    if(userList[uid].mail[k][0] !='\0')
	     {
	      sendMail2(userList[uid].mail[k],userList[uid].smtp[k],subj,text);
	      userList[uid].internalStatus =true;
	     }
	 }
      }  
    }
  }
}
// sendNotizByMail id nid to, [to ...]
int sendNotizByMail(int socket, char *str,int type)
{
 char *tp[8],*tp2[1024],subj[2048];
 int anz,tanz;
 int nid, id, idx,i,*to;
 char *buffer;
 Notiz *ntz;
 char txt[256];
 NotizControl *nc;
 char name[400];
 int dirid;

 anz = split(str,tp,7);
 
 if(anz<3)
  {
   send2Client(socket,"Error insufficent data");
   return false;
  }

 switch( tp[0][0])
  {
  case 'd': 
   type = FOLDER_NOTIZ;
   id  = atoi(tp[0]+1);
   break;
  case 't':
   type = TASK_NOTIZ;
   id = atoi(tp[0]+1);
   break;
  case 'p':
   type = PROJECT_NOTIZ;
   id = atoi(tp[0]+1);
   break;
  default:
   type = ADDRESS_NOTIZ;
   id = atoi(tp[0]);
   break;
  }
 nc   = checkNotizControl(id,type,NCP_READ);
 if(nc==NULL)
  {
   send2Client(socket,"Error no such memo");
   return(false);
  }


 // FIXME Lanaguage
 switch (type)
  {
  case TASK_NOTIZ:
   sprintf(name,"zur Aufgabe %s",todoList[id]->descr);
  case PROJECT_NOTIZ:
   sprintf(name,"zum Projekt %s",projList[dirid]->descr);
  case FOLDER_NOTIZ:
   sprintf(name,"zum Addressordner %s",adfList[id]->name);
   break;
  case ADDRESS_NOTIZ:
   idx  = aid2idx(id);
   strcpy(name,"zur Addresse ");
   if(adrList[idx]->titel[0] != '\0')
    {
     strcat(name,adrList[idx]->titel);
     strcat(name," ");
    }
   if(adrList[idx]->name1[0] != '\0')
    {
     strcat(name,adrList[idx]->name1);
     strcat(name," ");
    }
   if(adrList[idx]->nameM != '\0' && adrList[idx]->nameM != ' ')
    {
     int len =strlen(name);
     name[len] = adrList[idx]->nameM;
     len++;
     name[len] = '.';
     len++;
     name[len] = ' ';
    }
   if(adrList[idx]->name2[0] != '\0')
    {
     strcat(name,adrList[idx]->name2);
     strcat(name," ");
    }
   break;
  }

 nid =atoi(tp[1]);
 if(nid<0 || nid >= nc->anz)
  {
   send2Client(socket,"Error: No such Note\n");
   return(false);
  }

 anz = split(tp[2],tp2,1023);
 to =  new int [anz];
 tanz=0;
 for(i=0;i<anz ; i++)
  {
   to[tanz] = uname2uid(tp2[i]);
   if(to[tanz] >=0)
    tanz++;
  }
 printf("sending mail2 %d receipients: \n",tanz);
 for(i=0;i<anz ; i++)
  printf("%d ",to[i]);
 printf("\n");

 ntz  = &nc->notiz[nid];
 sprintf(subj,"Gesprchsnotiz %s': %s",	 name,ntz->title);

 buffer  = new char [strlen(nc->notiz[nid].text) +2048];
 sprintf(buffer,"Gesprchsnotiz %s'\nAngelegt von %s am %s um %s:\n\n%s\n____________________________________________________________\n%s\n\n--------------\n(c) %s   bei   %s\n",
	 name,
	 userList[ntz->uid].full,date2Str(ntz->date,txt),time2Str(ntz->time,txt+128),ntz->title,ntz->text,
	 progName,company);
 send2Client(socket,"done");
 sendMail2(to,tanz,subj,buffer);
 delete to;
}
