//  File: perm.cc
// 
//      This file is part of minkowsky
// 
//      Copyright (C) 2001-2002 by Rdiger Goetz
//      Author: Rdiger Goetz <minkowsky@r-goetz.de>
// 
//      Time-stamp: <15-Sep-2002 16:07:53 goetz>
// 
//      This program is free software; you can redistribute it and/or modify
//      it under the terms of the GNU General Public License as published by
//      the Free Software Foundation; either version 2 of the License, or
//      (at your option) any later version.
// 
//      This program is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU General Public License for more details.
// 
//      You should have received a copy of the GNU General Public License
//      along with this program; if not, write to the Free Software
//      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//  
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include "termin.h"




//FIXME permissions for multiple calenders
int getPermission(Date *d, int uid,int cid)   // Rechte von uid an am Datum d aus dem  Calender von cid
{
 UserInDate *self;
 int i,j;
 int perm;
 int userDatePerm=0,groupDatePerm=0, userCalPerm=0,groupAdminPerm=0,masterAdminPerm=0,userCalGroupPerm=0;



 self = findUserInDate(d,uid);
 if(self !=NULL)
  if(d->init.id == uid)
   userDatePerm = PERM_ALL;
  else
   userDatePerm = self->perm; // Gruppenmitgliedschaften bercksichigen
 else
  userDatePerm =0;;
 
 groupDatePerm=0;
 for(i=0;i<userList[uid].ganz; i++)
  {
   self = findUserInDate(d,userList[uid].groups[i]+GROUPOFFSET);
   if(self != NULL)
    groupDatePerm |= self->perm;
  }

 // Calendar owner might specific special permission for ceratain groups
 // only available for calendar owned by users but not by groups or rooms
 if(cid < GROUPOFFSET)
  {
   userCalGroupPerm=0;                                      
   for(i=0;i<userList[uid].ganz; i++)
    for(j=0;j<userList[cid].gpanz;j++)
     if(userList[uid].groups[i] == userList[cid].gPerm[j].id)
      userCalGroupPerm |=  userList[cid].gPerm[j].perm;
  }


 userCalPerm =0;
 if(cid< GROUPOFFSET) // UserCal
  {
   if(cid == uid)
    userCalPerm =READ_TIMES|READ_HEADS;
   else
    {
     if (userCalGroupPerm == 0)
      userCalPerm = userList[cid].calPerm;
    }
  }
 else if (cid< ROOMOFFSET)
  {
   int gid = cid-GROUPOFFSET;

   userCalPerm = groupList[gid].otherPerm;
   for(i=0;i<groupList[gid].anz; i++)
    if(groupList[gid].membr[i] ==uid)
      userCalPerm    |= groupList[gid].membrPerm;
  }
 else
  {
   int rid = cid -ROOMOFFSET;
   userCalPerm = roomList[rid].calPerm;
  }
 
 groupAdminPerm=0;
 for(i=0;i<groupList[d->group].anz; i++)
  if(groupList[d->group].membr[i] ==uid)
   if(groupList[d->group].mstat[i] == GROUP_ADMIN)
    groupAdminPerm |= groupList[d->group].adminPerm;



 masterAdminPerm=0;
 for(i=0;i<groupList[0].anz; i++)
  if(groupList[0].membr[i] ==uid)
   if(groupList[0].mstat[i] == GROUP_ADMIN)
    masterAdminPerm |= groupList[0].adminPerm;
 



 if(userDatePerm!=0)
  perm = userDatePerm | groupAdminPerm | masterAdminPerm ;
 else if(groupDatePerm !=0)
  perm = groupDatePerm | groupAdminPerm | masterAdminPerm ;
 else
  perm = userCalPerm | userCalGroupPerm | groupAdminPerm | masterAdminPerm ;


 // printf("\n\n>>>> permissions for uid=%3d on date %4d in calendar %09d: %03X<<< \n",uid,d->id,cid,perm);
 return(perm);
}

int dateIs2Privat2Me(Date *d, int uid)
{
 int i;

 for(i=0;i<d->partAnz; i++)
  if(d->part[i].id == uid)
   return(false);

 if ((d->flags &DATE_FLAG_PRIVAT) == DATE_FLAG_PRIVAT)
  if(d->init.id != uid)
   return true;

 if ((d->flags &DATE_FLAG_GROUPINTERN) == DATE_FLAG_GROUPINTERN)
  {
   for(i=0;i<groupList[d->group].anz; i++)
    if(groupList[d->group].membr[i]==uid)
     return(false);
   return(true);
  }

 return(false);
}

//checked of me Admin von cid ist

int admin2User(int cid, int me)
{
 int i,j,gid;
 int uid;

 if(cid <GROUPOFFSET)
  {
   uid = cid;
   for(i=0;i<userList[uid].ganz; i++)
    {
     gid = userList[uid].groups[i];
     for(j=0;j<groupList[gid].anz; j++)
      if(groupList[gid].membr[j] == me)
       {
	if(groupList[gid].mstat[j] == GROUP_ADMIN)
	 return(true);
	break;
       }
    }
  }
 else if (cid <ROOMOFFSET)
  {
   gid  = cid -GROUPOFFSET;
   for(j=0;j<groupList[gid].anz; j++)
    if(groupList[gid].membr[j] == me)
     {
      if(groupList[gid].mstat[j] == GROUP_ADMIN)
       return(true);
      break;
     }
  }
 return(false);
}
