//  File: prefs.cc
// 
//      This file is part of minkowsky
// 
//      Copyright (C) 2001-2002 by Rdiger Goetz
//      Author: Rdiger Goetz <minkowsky@r-goetz.de>
// 
//      Time-stamp: <26-Oct-2002 11:38:56 goetz>
// 
//      This program is free software; you can redistribute it and/or modify
//      it under the terms of the GNU General Public License as published by
//      the Free Software Foundation; either version 2 of the License, or
//      (at your option) any later version.
// 
//      This program is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU General Public License for more details.
// 
//      You should have received a copy of the GNU General Public License
//      along with this program; if not, write to the Free Software
//      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//  
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <sys/types.h>
#include <sys/stat.h>
//#include <unistd.h>
#define _XOPEN_SOURCE
#include <unistd.h>
#include <crypt.h>
  
 
#include "termin.h"

void saveStandardPrefs(FILE *fp);
void extendIdSetList (int uid);

void extendIdSetList (int uid)
{
 IDset *tmp;
 int anz;

 anz = userList[uid].idSetMax + DATEBLOCKSIZE;
 tmp = new IDset [anz];
 if(userList[uid].set != NULL)
  {
   memcpy(tmp,userList[uid].set,userList[uid].idSetMax);
   delete userList[uid].set;
  }
 userList[uid].set=tmp;
 userList[uid].idSetMax = anz;
}

int getUserPrefs (char *str,int socket)
{
 char buffer[200000],setList[150000],*t;
 char gpermList[16000],tx[256],txt[256];
 int uid,i,j;

 t=skip2WS(str+2);
 if(t!=NULL)
  *t='\0';
 uid = uname2uid(str);
 if(uid<0)
  {
   sprintf(buffer,"ERR: No User '%s' registerd\n",str);
   send2Client(socket,buffer);
   return(0);
  }

 readUserPrefs(uid);
 sprintf(gpermList,"{default %s}",perm2str(userList[uid].calPerm,tx));
 for(i=0 ; i<userList[uid].gpanz; i++)
  {
   sprintf(txt," {%s %s}",groupList[userList[uid].gPerm[i].id].name,perm2str(userList[uid].gPerm[i].perm,tx));
   strcat(gpermList,txt);
  }
 if(userList[uid].idSetAnz >0 && userList[uid].set !=NULL)
  {
   strcpy(setList,"");
   for(i=0;i<userList[uid].idSetAnz; i++)
    {
     sprintf(txt,"{%s {",userList[uid].set[i].name);
     strcat(setList,txt);

     for(j=0;j<userList[uid].set[i].anz; j++)
      {
       if(userList[uid].set[i].id[j]<GROUPOFFSET)
	{
	 strcat(setList,"u-");
	 strcat(setList,userList[userList[uid].set[i].id[j]].name);
	}
       else
	{
	 strcat(setList,"g-");
	 strcat(setList,groupList[userList[uid].set[i].id[j]-GROUPOFFSET ].name);
	}
       strcat(setList," ");
      }
     strcat(setList,"}} ");
    }
  }
 else
  {
   strcpy(setList,"");
  }
 
 printf("setList(%d): /%s/\n",uid,setList);
 sprintf(buffer,"{%s} %d {%s} {%s} {%s} %d %d %d {%d %d %d %d}         {%s} {%s} {%s} {%d %d %d}",
	 userList[uid].defPermStr,userList[uid].sig.beep,userList[uid].sig.cmd,gpermList,userList[uid].calFormat
	 ,userList[uid].displayIgnore,userList[uid].displayInfo,userList[uid].displayToolTips,
	 userList[uid].direction_dateRemind, userList[uid].direction_dateInvite,
	 userList[uid].direction_todoRemind,userList[uid].direction_todoMahn,setList,
	 userList[uid].browser,userList[uid].browserCmd,
	 userList[uid].saveCalViewOnLogout,userList[uid].savePrjViewOnLogout,userList[uid].saveAdrViewOnLogout);
	

 send2Client(socket,buffer);
}
int readUserPrefs(int uid)
{
 char file[2096],buffer[16384] ,*tp[64],*t,*tp2[8],*s,*s2,*tp3[1024];
 FILE *fp;
 int ret,gpanz,gid;

 sprintf(file,"%s/prefs/%d.prefs",dataDir,uid);
 fp=fopen(file,"r");
 // printf("-> %p (%s)\n",fp,file);
 if(fp==NULL)
  {
   fp=fopen(file,"w");
   perror(NULL);
   if(fp==NULL)
    {
     printf("ERR: Can't write default-Prefs");
     return(false);
    }
   else
    {
     //     printf("saving default prefs\n");
     saveStandardPrefs(fp);
     fclose(fp);
     fp=fopen(file,"r");
    }
  }


 userList[uid].idSetAnz=0;
 // printf("-> %p\n",fp);
 if(fp==NULL)
  {
   printf("ERR: Can't open Prefs");
   return(false);
  }
 else
  {
   gpanz=0;
   t=fgets(buffer,16383,fp);
   while(t!=NULL)
    {
     strChop(t);
     if(strncmp(buffer,"DEFPERM",7)==0)
      {
       t=skip2nonWS(buffer+8);
       strcpy(userList[uid].defPermStr,t);
      }
     else if (strncmp(buffer,"FLAGS",5)==0)
      {
       t=skip2nonWS(buffer+6);
       split(t,tp2,8);
       userList[uid].displayIgnore   =atoi(tp2[0]);
       userList[uid].displayInfo     =atoi(tp2[1]);
       userList[uid].displayToolTips =atoi(tp2[2]);
      }
     else if (strncmp(buffer,"SIGNAL",6)==0)
      {
       int l;
       t=skip2nonWS(buffer+7);
       split(t,tp2,2);
       userList[uid].sig.beep =atoi(tp2[0]);
       l = strlen(tp2[1]);
       if(userList[uid].sig.cmd !=NULL)
	delete userList[uid].sig.cmd;
       userList[uid].sig.cmd = new char [l+4];
       strcpy(userList[uid].sig.cmd,tp2[1]);
      }
     else if (strncmp(buffer,"GROUPPERM",9)==0)
      {
       int done=false;
       t=fgets(buffer,16383,fp);
       while(t!=NULL && strcmp(buffer,"ENDGROUPPERM")!= 0)
	{
	 if (strstr(buffer,"ENDGROUPPERM")!=NULL)
	  done=true;
	 split(buffer,tp2,8);
	 trimRight(tp2[0]);
	 if(strcmp(tp2[0],"default")==0)
	  {
	   userList[uid].calPerm = perm2val(tp2[1]);
	  }
	 else
	  {
	   gid = gname2gid(tp2[0]);
	   if(gid>=0)
	    {
	     userList[uid].gPerm[gpanz].id   = gid;
	     userList[uid].gPerm[gpanz].perm = perm2val(tp2[1]);
	     //	     printf("got groupPrem for %s @ %s : %s->%d",groupList[gid].name,userList[uid].name,tp2[1],userList[uid].gPerm[gpanz].perm);
	     gpanz++;
	    }
	  }
	 if(done)
	  break;
	 t=fgets(buffer,16383,fp);
	}
     }
     else if (strncmp(buffer,"PWD",3)==0)
      {
       s=skip2nonWS(buffer+3);
       strcpy(userList[uid].pwd,strTrim(s));
      }
     else if (strncmp(buffer,"REMINDER",8)==0)
      {
       s=skip2nonWS(buffer+9);
       sscanf(s,"%d %d %d %d",
	      &userList[uid].direction_dateRemind,&userList[uid].direction_dateInvite,
	      &userList[uid].direction_todoRemind,&userList[uid].direction_todoMahn);
      }
     else if (strncmp(buffer,"CALFORMAT",9)==0)
      {
       s=skip2nonWS(buffer+9);
       strcpy(userList[uid].calFormat,strTrim(s));
       //       printf("got CALFORMAT '%s // %s'",s,userList[uid].calFormat);
      }
     else if (strncmp(buffer,"SAVE_VIEW_ON_LOGOUT",19)==0)
      {
       s=skip2nonWS(buffer+20);
       sscanf(s,"%d %d %d",
	      &userList[uid].saveCalViewOnLogout,
	      &userList[uid].savePrjViewOnLogout,
	      &userList[uid].saveAdrViewOnLogout);
      }
     else if (strncmp(buffer,"CAL_VIEW",8)==0)
      {
       s=skip2nonWS(buffer+9);
       allocateAndCopy(&userList[uid].calView,s);
       printf("uid=%3d: buffer='%s' -> s='%s'/%p  -> calView='%s'/%p\n",
	      uid,buffer,s,s,userList[uid].calView,userList[uid].calView);
      }
     else if (strncmp(buffer,"PRJ_VIEW",8)==0)
      {
       s=skip2nonWS(buffer+9);
       allocateAndCopy(&userList[uid].prjView,s);
      }
     else if (strncmp(buffer,"ADR_VIEW",8)==0)
      {
       s=skip2nonWS(buffer+9);
       allocateAndCopy(&userList[uid].adrView,s);
      }
     else if (strncmp(buffer,"SYNC_GENERAL",12)==0)
      {
       s=skip2nonWS(buffer+13);
       allocateAndCopy(&userList[uid].syncPref,s);
      }
      else if (strncmp(buffer,"SYNC_ADR",8)==0)
      {
       s=skip2nonWS(buffer+9);
       allocateAndCopy(&userList[uid].syncAdrPref,s);
      }
     else if (strncmp(buffer,"SYNC_PRJ",8)==0)
      {
       s=skip2nonWS(buffer+9);
       allocateAndCopy(&userList[uid].syncPrjPref,s);
      }
     else if (strncmp(buffer,"SYNC_CAL",8)==0)
      {
       s=skip2nonWS(buffer+9);
       allocateAndCopy(&userList[uid].syncCalPref,s);
      }
     else if (strncmp(buffer,"SET",3)==0)
      {
       int sid,i,anz    ;
       while(userList[uid].idSetAnz >= userList[uid].idSetMax)
 	extendIdSetList(uid);
       
       sid = userList[uid].idSetAnz;
       userList[uid].idSetAnz ++;
       
       anz = split(skip2nonWS(buffer+4), tp3,1002);
       strcpy(userList[uid].set[sid].name, strTrim(tp3[0]));
       for(i=1;i<anz; i++)
 	userList[uid].set[sid].id[i-1] =atoi(tp3[i]);
       userList[uid].set[sid].anz=anz-1;
      }
     else if (strncmp(buffer,"BROWSER",7)==0)
      {
       s=skip2nonWS(buffer+7);
       s2=skip2WS(s+1);
       strncpy(userList[uid].browser,s,s2-s);
       userList[uid].browser[s2-s+1]='\0';
       if(*s2 != '\0')
	{
	 s=skip2nonWS(s2);
	 if(s !=NULL)
	  strcpy(userList[uid].browserCmd,strTrim(s));
	 else
	  userList[uid].browserCmd[0]='\0';
	}
       else
	userList[uid].browserCmd[0]='\0';
      }
     if(t!=NULL)
      t=fgets(buffer,16383,fp);
    }
   userList[uid].gpanz =gpanz;
   fclose(fp);
  }
 return(true);
}

int clearPWD(int socket, char *str)
{
 char *t;
 int uid;
 char buffer[1024];

 t=skip2WS(str+2);
 if(t!=NULL)
  *t='\0';
 uid = uname2uid(str);
 if(uid<0)
  {
   sprintf(buffer,"ERR: No User '%s' registerd\n",str);
   send2Client(socket,buffer);
   return false;
  }
 strcpy(userList[uid].pwd,"");
 userList[uid].hasPWD=false;
 printf ("clearPWD(%d): %d (false=%d)\n",uid,userList[uid].hasPWD,false);
 if(!saveUserPrefs(uid))
  {
   send2Client(socket,"Error: Can't write Prefs");
   return false;
  }
 else
  send2Client(socket,"done");

}

void saveStandardPrefs(FILE *fp)
{
 fprintf(fp,"DEFPERM ztkztk- ztk---k- ztk----- ztk-----\n");
 fprintf(fp,"SIGNAL 1 beep\n");
 fprintf(fp,"CALFORMAT 7 20 3 3 2 3\n");
 fprintf(fp,"FLAGS 0 1 1\n");
 fprintf(fp,"BRWOSER minkowsky\n");
 fprintf(fp,"SYNCSTAMP 0 0 0\n");
 fprintf(fp,"GROUPPERM\n");
 fprintf(fp,"default ztk-----\n");
 fprintf(fp,"ENDGROUPPERM\n");
}
int  setUserPrefs (char *str,int socket)
{
 char file[2096],buffer[16384] ,*tp[64],*tp2[200],cpwd[17],salt[3];
 // char calFormat[64];
 int uid,anz,l,gpanz,i,gid;
 // int havePWD=true;
 FILE *fp;

 anz= split(str,tp,63);
 
 uid = uname2uid(tp[0]);
 if(uid<0)
  {
   send2Client(socket,"ERR: No such user");
   return(-1);
  }

 sprintf(userList[uid].defPermStr,"%s %s %s %s\n",tp[1],tp[2],tp[3],tp[4]);
 userList[uid].sig.beep =atoi(tp[5]);
 l = strlen(tp[6]);
 if(userList[uid].sig.cmd !=NULL)
  delete userList[uid].sig.cmd;
 userList[uid].sig.cmd = new char [l+4];
 strcpy(userList[uid].sig.cmd,tp[6]);

 gpanz=0;
 anz=split(tp[7],tp2,200);
 for(i=0 ; i<anz; i+=2)
  {
   if(strcmp(tp2[i],"default")==0)
    userList[uid].calPerm = perm2val(tp2[i+1]);
   else
    {
     gid = gname2gid(tp2[i]);
     if(gid>=0)
      {
       userList[uid].gPerm[gpanz].id   = gid;
       userList[uid].gPerm[gpanz].perm = perm2val(tp2[i+1]);
       gpanz++;
      }
    }
  }
 userList[uid].gpanz =gpanz;

 strcpy(salt,"kp");
 strTrim(tp[8]);
 printf("PWD -------> /%s/ %d \n",tp[8],strlen(tp[8]));
 if(strlen(tp[8])>0) // if no passwd send, leave erverything unchanged
  {
   if( tp[8][0] =='')                  
    userList[uid].hasPWD=false;
   else
    {
     userList[uid].hasPWD=true;
     strcpy(userList[uid].pwd,text2Pwd(tp[8],salt));
    }
  }
 strcpy(userList[uid].calFormat,tp[9]);
 
 userList[uid].displayIgnore   = atoi(tp[10]);
 userList[uid].displayInfo     = atoi(tp[11]);
 userList[uid].displayToolTips = atoi(tp[12]);
 anz=split(tp[13],tp2,200);
 userList[uid].direction_dateRemind =atoi(tp2[0]);
 userList[uid].direction_dateInvite =atoi(tp2[1]);
 userList[uid].direction_todoRemind =atoi(tp2[2]);
 userList[uid].direction_todoMahn   =atoi(tp2[3]);

 strcpy(userList[uid].browser,tp[14]);
 strcpy(userList[uid].browserCmd,tp[15]);
 
 if(anz >16)
  {
   split(tp[16],tp2,200);
   userList[uid].saveCalViewOnLogout = atoi(tp2[0]);
   userList[uid].savePrjViewOnLogout = atoi(tp2[1]);
   userList[uid].saveAdrViewOnLogout = atoi(tp2[2]);   
  }

 if(!saveUserPrefs(uid))
  {
   send2Client(socket,"Error: Can't write Prefs");
   return(false);
  }
 send2Client(socket,"done");
}

int saveUserPrefs( int uid)
{
 FILE *fp;
 int i,j;
 char file[2096],buffer[1024];

 sprintf(file,"%s/prefs/%d.prefs",dataDir,uid);
 fp=fopen(file,"w");
 if(verbose)
  printf("saveing prefs to %s\n",file);
 if(fp==NULL)
  {
   return(false);
   //   send2Client(socket,"ERR: Can't write Prefs");
  }
 else
  {
   fprintf(fp,"DEFPERM %s\n",userList[uid].defPermStr);
   fprintf(fp,"SIGNAL %d %s\n",userList[uid].sig.beep,userList[uid].sig.cmd);
   if(userList[uid].hasPWD)
    fprintf(fp,"PWD %s\n",userList[uid].pwd);
   else
    printf("no password for %d (%d)\n",uid);
   fprintf(fp,"CALFORMAT %s\n",userList[uid].calFormat);
   fprintf(fp,"FLAGS %d %d %d\n",userList[uid].displayIgnore,userList[uid].displayInfo,userList[uid].displayToolTips);
   fprintf(fp,"REMINDER %d %d %d %d\n",
	      userList[uid].direction_dateRemind,userList[uid].direction_dateInvite,
	      userList[uid].direction_todoRemind,userList[uid].direction_todoMahn);

   fprintf(fp,"SAVE_VIEW_ON_LOGOUT %d %d %d\n"
	   ,userList[uid].saveCalViewOnLogout,userList[uid].savePrjViewOnLogout,userList[uid].saveAdrViewOnLogout);
   if(userList[uid].calView != NULL)
    fprintf(fp,"CAL_VIEW %s\n",userList[uid].calView);
   if(userList[uid].prjView != NULL)
    fprintf(fp,"PRJ_VIEW %s\n",userList[uid].prjView);
   if(userList[uid].adrView != NULL)
    fprintf(fp,"ADR_VIEW %s\n",userList[uid].adrView);
   //#ifdef WITH_SYNCPREF
   printf("SAVING SYNC PREFS for %d\n",uid);
   if(userList[uid].syncPref !=NULL)
    fprintf(fp,"SYNC_GENERAL %s\n",userList[uid].syncPref);
   if(userList[uid].syncAdrPref !=NULL)
    fprintf(fp,"SYNC_ADR %s\n",userList[uid].syncAdrPref);
   if(userList[uid].syncPrjPref !=NULL)
    fprintf(fp,"SYNC_PRJ %s\n",userList[uid].syncPrjPref);
   if(userList[uid].syncCalPref !=NULL)
    fprintf(fp,"SYNC_CAL %s\n",userList[uid].syncCalPref);
   //#endif
   fprintf(fp,"BROWSER %s %s\n",userList[uid].browser,userList[uid].browserCmd);
   fprintf(fp,"SYNCSTAMP %d %d %d\n",
	   userList[uid].sync->lastCalSync,
	   userList[uid].sync->lastPrjSync,
	   userList[uid].sync->lastAdrSync);
   if(userList[uid].idSetAnz >0 && userList[uid].set !=NULL)
    {
     for(i=0;i<userList[uid].idSetAnz; i++)
      {
       fprintf(fp,"SET %s ",userList[uid].set[i].name);
       for(j=0;j<userList[uid].set[i].anz; j++)
	fprintf(fp,"%d ",userList[uid].set[i].id[j]);
       fprintf(fp,"\n");
      }
    }

   fprintf(fp,"\nGROUPPERM\n");
   fprintf(fp,"default %s\n",perm2str(userList[uid].calPerm,buffer));
   for(i=0 ; i<userList[uid].gpanz; i++)
     fprintf(fp,"%s %s\n",groupList[userList[uid].gPerm[i].id].name,perm2str(userList[uid].gPerm[i].perm,buffer));
   fprintf(fp,"ENDGROUPPERM\n");
   fclose(fp);
  }
 return(true);
}

int sendUsersView(int socket, char *str)
{
 char *tp[4],*buffer;
 int l=32;
 int uid;

 split(str,tp,3);
 uid = uname2uid(str);
 if(uid<0)
  {
   sprintf(buffer,"ERR: No User '%s' registerd\n",str);
   send2Client(socket,buffer);
   return(0);
  }

 if(userList[uid].calView != NULL)
  l += strlen(userList[uid].calView);
 if(userList[uid].prjView != NULL)
  l += strlen(userList[uid].prjView);
 if(userList[uid].adrView != NULL)
  l += strlen(userList[uid].adrView);
   
   
 buffer = new char [l];
 strcpy(buffer,"{ ");
 if(userList[uid].calView != NULL)
  strcat(buffer,userList[uid].calView);
 strcat(buffer," } { ");
 if(userList[uid].prjView != NULL)
  strcat(buffer,userList[uid].prjView);
 strcat(buffer," } { ");
 if(userList[uid].adrView != NULL)
  strcat(buffer,userList[uid].adrView);
 strcat(buffer," }");
	
 send2Client(socket,buffer);
 delete buffer;
}

int saveUsersView(int socket,char *str)
{
 char *tp[8],*buffer;
 int uid;

 split(str,tp,7);
 uid = uname2uid(str);
 if(uid<0)
  {
   sprintf(buffer,"ERR: No User '%s' registerd\n",str);
   send2Client(socket,buffer);
   return(0);
  }
 if(strTrim(tp[1]) != '\0')
  allocateAndCopy(&userList[uid].calView,strTrim(tp[1]));
 if(strTrim(tp[2]) != '\0')
  allocateAndCopy(&userList[uid].prjView,strTrim(tp[2]));
 if(strTrim(tp[3]) != '\0')
  allocateAndCopy(&userList[uid].adrView,strTrim(tp[3]));
 saveUserPrefs(uid);
 send2Client(socket,"done");
}

int readUserSyncStamps (int uid)
{
 char file[2048],*t,line[4096];
 FILE *fp;
 sprintf(file,"%s/prefs/%d.prefs",dataDir,uid);
 fp=fopen(file,"r");
 if(verbose)
  printf("saveing prefs to %s\n",file);
 userList[uid].sync->lastCalSync =0;
 userList[uid].sync->lastPrjSync =0;
 userList[uid].sync->lastAdrSync =0;
 if(fp==NULL)
  {
   return(false);
  }

 while ( (t=fgets(line,4095,fp)) != NULL)
  {
   if(strncmp(line,"SYNCSTAMP",9)==0)
    {
     sscanf(line+10,"%d %d %d",
	    &userList[uid].sync->lastCalSync,
	    &userList[uid].sync->lastPrjSync,
	    &userList[uid].sync->lastAdrSync);
     break;
    }
  }
 fclose(fp);
 return(true);
}
int saveUserSyncStamps (int uid)
{
 char file[2048],file2[2048],*t,line[4096];
 FILE *fp,*out  ;

 sprintf(file, "%s/prefs/%d.prefs",dataDir,uid);
 sprintf(file2,"/tmp/minkowsky-%d.prefs",dataDir,uid);
 fp =fopen(file, "r");
 out=fopen(file2,"w");
 if(verbose)
  printf("saveing prefs to %s\n",file);
 if(fp==NULL || out == NULL)
  {
   if(fp!=NULL)
    fclose(fp);
   if(out!=NULL)
    fclose(out);
   return(false);
  }

 userList[uid].sync->lastCalSync =0;
 userList[uid].sync->lastPrjSync =0;
 userList[uid].sync->lastAdrSync =0;
 while ( (t=fgets(line,4095,fp)) != NULL)
  {
   if(strncmp(line,"SYNCSTAMP",9)==0)
    {
     fprintf(out,"SYNCSTAMP %d %d %d",
	     userList[uid].sync->lastCalSync,
	     userList[uid].sync->lastPrjSync,
	     userList[uid].sync->lastAdrSync);
     
    }
   else
    fprintf(out,line);
  }
 fclose(fp);
 fclose(out);
 return(true);
}

char *text2Pwd(char *t,char *salt)
{
 char cpwd[9],*s;
 strncpy(cpwd,t,8);
 cpwd[8]='0';
 s =crypt(cpwd,salt); 
 return(s);
}


int  saveIDset (char *str,int socket)
{
 char *tp[8],*tp2[1001],buffer[256];
 int uid,sid=-1,anz,c=0,i,id,override;
 
 anz= split(str,tp,8);
 uid = uname2uid(tp[0]);
 if(uid<0)
  {
   sprintf(buffer,"ERR: No User '%s' registerd\n",str);
   send2Client(socket,buffer);
   return(0);
  }
 strcpy(buffer,strTrim(tp[1]));
 override  = atoi(tp[2]);
 if ( override == 1) 
  {
   for(i=0; i<userList[uid].idSetAnz; i++)
    if(strcmp(userList[uid].set[i].name,buffer) == 0)
     {
      sid=i;
      break;
     }
  }
 if(sid <0)
  {
   while(userList[uid].idSetAnz >= userList[uid].idSetMax)
    extendIdSetList(uid);
 
   sid = userList[uid].idSetAnz;
   userList[uid].idSetAnz ++;
  }
 strcpy(userList[uid].set[sid].name,buffer);
 
 anz = split(tp[3],tp2,1001);
 for(i=0; i<anz; i++)
  {
   if(tp2[i][0] == 'u')
    {
     id= uname2uid(tp2[i]+2);
     if(id>=0)
      {
       userList[uid].set[sid].id[c] = id;
       c++;
      }
    }
   if(tp2[i][0] == 'g')
    {
     id= gname2gid(tp2[i]+2);
     if(id>=0)
      {
       userList[uid].set[sid].id[c] = id + GROUPOFFSET;
       c++;
      }
    }
  }
 userList[uid].set[sid].anz=c;
 if(!saveUserPrefs(uid))
  {
   send2Client(socket,"ERR: Can't write Prefs");
   return(false);
  }

 send2Client(socket,"saved");
}


//#ifdef WITH_SYNCPREF
int getSyncPrefs(int socket, char *str)
{
 char *t;
 int uid;
 char buffer[4096];

 t=skip2WS(str+2);
 if(t != NULL)
  *t='\0';
 uid = uname2uid(str);
 if(uid<0)
  {
   sprintf(buffer,"ERR: No User '%s' registerd\n",str);
   send2Client(socket,buffer);
   return(0);
  }

 readUserPrefs(uid);
 
 buffer[0]= '\0';
 strcat(buffer,"{");
 if ( userList[uid].syncPref !=NULL)
  strcat(buffer,userList[uid].syncPref);

 strcat(buffer,"}     {");
 if ( userList[uid].syncCalPref !=NULL)
  strcat(buffer,userList[uid].syncCalPref);

 strcat(buffer,"}     {");
 if ( userList[uid].syncPrjPref !=NULL)
  strcat(buffer,userList[uid].syncPrjPref);

 strcat(buffer,"}     {");
 if ( userList[uid].syncAdrPref !=NULL)
  strcat(buffer,userList[uid].syncAdrPref);
 strcat(buffer,"}");

 send2Client(socket,buffer);
 return true;
}

// TCL: saveSyncPrefs username general-sync-prefs cal-sync-prefs prj-sync-prefs adr-sync-prefs
int saveSyncPrefs(int socket, char *str)
{
 char *tp[16];
 int anz;
 int uid;
 char buffer[4096];
 char *t;


 anz =split(str,tp,15);

 uid = uname2uid(tp[0]);
 if(uid<0)
  {
   sprintf(buffer,"ERR: No User '%s' registerd\n",str);
   send2Client(socket,buffer);
   return(0);
  }

 if(userList[uid].syncPref!=NULL)
  {
   delete userList[uid].syncPref;
   userList[uid].syncPref =NULL;
  }
 t =strTrim(tp[1]);
 if(t[0] !='\0')
  allocateAndCopy(&userList[uid].syncPref,t);

 if(userList[uid].syncCalPref!=NULL)
  {
   delete userList[uid].syncCalPref;
   userList[uid].syncCalPref =NULL;
  }
 t =strTrim(tp[2]);
 if(t[0] !='\0')
  allocateAndCopy(&userList[uid].syncCalPref,t);

 if(userList[uid].syncPrjPref!=NULL)
  {
   delete userList[uid].syncPrjPref;
   userList[uid].syncPrjPref =NULL;
  }
 t =strTrim(tp[3]);
 if(t[0] !='\0')
  allocateAndCopy(&userList[uid].syncPrjPref,t);

 if(userList[uid].syncAdrPref!=NULL)
  {
   delete userList[uid].syncAdrPref;
   userList[uid].syncAdrPref =NULL;
  }
 t =strTrim(tp[4]);
 if(t[0] !='\0')
  allocateAndCopy(&userList[uid].syncAdrPref,t);

 if(!saveUserPrefs(uid))
  {
   send2Client(socket,"Error: Can't write Prefs");
   return(false);
  }

 send2Client(socket,"done");
 return true;
 
}
//#endif
