//  File: proj.cc
// 
//      This file is part of minkowsky
// 
//      Copyright (C) 2001-2002 by Rdiger Goetz
//      Author: Rdiger Goetz <minkowsky@r-goetz.de>
// 
//      Time-stamp: <14-Oct-2002 19:54:23 goetz>
// 
//      This program is free software; you can redistribute it and/or modify
//      it under the terms of the GNU General Public License as published by
//      the Free Software Foundation; either version 2 of the License, or
//      (at your option) any later version.
// 
//      This program is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU General Public License for more details.
// 
//      You should have received a copy of the GNU General Public License
//      along with this program; if not, write to the Free Software
//      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//  
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <errno.h>  
#include <time.h>  

#define  ____TODO
#include "termin.h"

void extendTodoList(TodoList *todos);
void extendProjList(ProjectList *projs);
int fillStr2Todo(char *tp[],TodoItem *todo);
void addTODO2Lists(TodoItem *todo);
void addTODO2GroupsList(TodoItem *todo, int gid);
void addTODO2UsersList(TodoItem *todo, int uid);
int fillStr2Project(char *tp[],Project *proj);
void addProject2Lists(Project *proj);
void addProject2GroupsList(Project *proj, int gid);
void addProject2UsersList(Project *proj, int uid);
void addTODO2str(char *t, TodoItem *todo, int uid,int enclose);
void addProj2str(char *t, Project *proj, int uid,int enclose);
int deletePermission4Todo(TodoItem *todo,int uid);
int deletePermission4Proj(Project *proj,int uid);
TodoItem * readTodoList_0400(FILE *fp,int fsize);
extern int convertReminderFrom0400(Reminder *rem, Reminder_0400 *old);
int isProjectIncluded(int pid1, int pid2);
void getSubProjects();
void getSubProjects( int pidx);

FileHeader todoFileHeader,projFileHeader;

void initTodoList()
{
 todoList = new ( TodoItem *) [DATEBLOCKSIZE];
 todoAnz=0;
 todoBlocks=1;
 todoMax = DATEBLOCKSIZE;
 strncpy(todoFileHeader.magic,FILEHEADER_MAGIC,8);
 strncpy(todoFileHeader.type,FILEHEADER_TODO,4);
 strncpy(todoFileHeader.version,CURRENT_FILEVERSION_TODO,4);
 todoFileHeader.size =0;

}
void clearTodoList ()
{
 delete todoList;
}

void extendTodoList()
{
 TodoItem **tmp;
 int anz,anz0;
 int i;
 
 // printf("extending space for addresses\n");

 todoBlocks++;
 anz= todoBlocks * DATEBLOCKSIZE;
 tmp= new ( TodoItem *) [anz];
 todoMax=anz;
 anz0= (todoBlocks-1)  * DATEBLOCKSIZE;

 memcpy(tmp,todoList,anz0*sizeof(Date *));
 delete todoList;
 todoList=tmp;
 for(i=anz0;i<anz; i++)
  todoList[i]=NULL;
}
void extendTodoList(TodoList *todos)
{
 TodoItem **tmp;
 int anz;
 
 anz= todos->max + DATEBLOCKSIZE;
 tmp= new ( TodoItem *) [anz];

 memcpy(tmp,todos->list,todos->max*sizeof(TodoItem *));
 todos->max=anz;
 delete todos->list;
 todos->list=tmp;
}

void initProjList()
{
 projList = new ( Project *) [DATEBLOCKSIZE];
 projAnz=0;
 projBlocks=1;
 projMax = DATEBLOCKSIZE;
 strncpy(projFileHeader.magic,FILEHEADER_MAGIC,8);
 strncpy(projFileHeader.type,FILEHEADER_PROJ,4);
 strncpy(projFileHeader.version,CURRENT_FILEVERSION_PROJ,4);
 projFileHeader.size =0;
}
void clearProjList ()
{
 delete projList;
}

void extendProjList()
{
 Project **tmp;
 int anz,anz0;
 int i;
 
 // printf("extending space for addresses\n");

 projBlocks++;
 anz= projBlocks * DATEBLOCKSIZE;
 tmp= new ( Project *) [anz];
 projMax=anz;
 anz0= (projBlocks-1)  * DATEBLOCKSIZE;

 memcpy(tmp,projList,anz0*sizeof(Date *));
 delete projList;
 projList=tmp;
 for(i=anz0;i<anz; i++)
  projList[i]=NULL;
}
void extendProjList(ProjectList *projs)
{
 Project  **tmp;
 int anz;
 
 anz= projs->max + DATEBLOCKSIZE;
 tmp= new ( Project  *) [anz];

 memcpy(tmp,projs->list,projs->max*sizeof(Project  *));
 projs->max=anz;
 delete projs->list;
 projs->list=tmp;
}

int readTodoList()
{
 FILE *fp;
 char file[4096],*buffer;
 int i,anz,j;
 struct stat fstat;
 TodoItem *todo;
 FileHeader fh;
 int modified=false;

 sprintf(file,"%s/todos",dataDir);
 if((i=stat(file,&fstat))<0)
  {
   if(errno == ENOENT)
    {
     fp=fopen(file,"w");
     fclose(fp);
     if(stat(file,&fstat)<0)
      {
       printf("Can't open or create %s\n",file);
       exit(-1);
      }
    }
   else
    {
     char msg[1024];
     perror("");
     printf("Bad file  %s \n",file);
     exit(-1);
    }
  }
 
 if (fstat.st_size == 0)
  {
   todoAnz =0;
   writeTodoList();
   lastProjTODOchange=(int)time(NULL);
   return(true);
  }


 fp=fopen(file,"r");
 if(fp==NULL)
  {
   printf("can't open %s\n",file);
   exit(-1);
  }

 fread(&fh,sizeof(FileHeader),1,fp);
 if(strncmp(fh.magic,FILEHEADER_MAGIC,8) !=0)
  {
   rewind(fp);
   todo = readTodoList_0400(fp,fstat.st_size);
   modified=true;
  }
 else
  {
   if(strncmp(fh.type,FILEHEADER_TODO,4) !=0)
    {
     printf("todofile structure damaged\n");
     exit(-1);
    }
   if(fh.size>0)
    {
     buffer = new char [fh.size+2];
     fread(buffer,sizeof(char),fh.size,fp);
    }
   if(strncmp(fh.version,CURRENT_FILEVERSION_TODO,4) ==0)
    {
     todoAnz = (fstat.st_size/sizeof(TodoItem));
     printf("reading %d TODOs (%d)\n",todoAnz,i);
     if(todoAnz==0)
      return(0);
 
     while(todoAnz>todoMax)
      extendTodoList();
     
     todo = new TodoItem [todoAnz+1];
     fread(todo,sizeof(TodoItem),todoAnz,fp);
     fclose(fp);
    }
   else
    {
     printf("todofile structure damaged (unkown file version (%c%c%c%c vs %s)\n",
	    fh.version[0],fh.version[1],fh.version[2],fh.version[3],CURRENT_FILEVERSION_PROJ);
     exit(-1);
    }
  }

 lastTid=-1;
 for(i=0;i<todoAnz; i++)
  {
   todoList[i] = todo+i;
   if(todoList[i]->group<0)
    todoList[i]->group=TODO_GROUP_ALLG;

   if(todoList[i]->id>lastTid)
    lastTid = todoList[i]->id;
   todoList[i]->notiz =NULL;
   addTODO2Lists(todo+i);
  }
 if(modified)
  writeTodoList();
 lastProjTODOchange=(int)time(NULL);
}
TodoItem * readTodoList_0400(FILE *fp,int fsize)
{
 TodoItem_0400 told;
 int i,j,k;
 TodoItem *todo;

 printf("Importing Todos from File version 0.4.0.0 (%d/%d/%d)\n",fsize,sizeof(TodoItem_0400),sizeof(TodoItem));

 todoAnz = (fsize/sizeof(TodoItem_0400));
 printf("reading %d todos (%d/%d)  \n",todoAnz,fsize,sizeof(TodoItem_0400));
 if(todoAnz==0)
  return(0);
 
 while(todoAnz>todoMax)
  extendTodoList();
 
 todo= new TodoItem [todoAnz];

 k=0;
 for(i=0;i<todoAnz; i++)
  {
   fread(&told,sizeof(TodoItem_0400),1,fp);
   printf("\tconverting TodoItem #%6d , id=%6d\n",i,told.id);
   todo[k].id         = told.id;
   strncpy(todo[k].descr,told.descr,2048);
   todo[k].tlen       = told.tlen;
   todo[k].startDate  = told.startDate;
   todo[k].stopDate   = told.stopDate;
   todo[k].status     = told.status;
   todo[k].complete   = told.complete;
   todo[k].dring      = told.dring;
   todo[k].dringDynam = told.dringDynam;
   todo[k].init       = told.init;
   todo[k].uanz       = told.uanz;
   todo[k].remAnz     = told.remAnz;
   todo[k].deleted    = told.deleted;
   todo[k].group      = told.group;
   todo[k].tmp        = told.tmp;                 // temporrer Wert beim senden benuzt
   todo[k].tmp2       = told.tmp2;
   todo[k].selected   = false;
   memcpy(todo[k].miles,told.miles,sizeof(MileStone)*8);
   memcpy(todo[k].user,told.user,sizeof(UserInTodo)*128);
   for(j=0;j<told.remAnz; j++)
    {
     if(j> REMINDERS_IN_TODO)
      {
       printf("Number of reminder reduced. omitting additional entries in date '%s'\n",told.descr);
       break;
      }
     convertReminderFrom0400(&todo[k].reminder[j],&told.reminder[j]);
    }
   k++;
  }
 fclose(fp);
 todoAnz=k;
 return(todo);
}
int writeTodoList()
{
 FILE *fp;
 char file[4096];
 int i,c=0;

 sprintf(file,"%s/todos",dataDir);
 fp=fopen(file,"w");
 if(fp==NULL)
  {
   printf("can't open %s\n",file);
   exit(-1);
  }
 fwrite(&todoFileHeader,sizeof(FileHeader),1,fp);
 for(i=0;i<todoAnz; i++)
  if(todoList[i]!=NULL)
   if(! todoList[i]->deleted)
    {
     fwrite(todoList[i],sizeof(TodoItem),1,fp);
     c++;
    }
 if(verbose)
  printf("%d todo written to %s\n",c,file);
 fclose(fp);
}
int readProjList()
{
 FILE *fp;
 char file[4096],*buffer;
 int i,anz,j;
 struct stat fstat;
 Project *proj;
 FileHeader fh;
 int modified=false;

 sprintf(file,"%s/projs",dataDir);
 if((i=stat(file,&fstat))<0)
  {
   if(errno == ENOENT)
    {
     fp=fopen(file,"w");
     fclose(fp);
     if(stat(file,&fstat)<0)
      {
       printf("Can't open or create %s\n",file);
       exit(-1);
      }
    }
   else
    {
     char msg[1024];
     perror("");
     printf("Bad file  %s \n",file);
     exit(-1);
    }
  }
 if (fstat.st_size == 0)
  {
   projAnz =0;
   writeProjList();
   lastProjTODOchange=(int)time(NULL);
   return(true);
  }
 
 fp=fopen(file,"r");
 if(fp==NULL)
  {
   printf("can't open %s\n",file);
   exit(-1);
  }

 fread(&fh,sizeof(FileHeader),1,fp);

 if(strncmp(fh.magic,FILEHEADER_MAGIC,8) !=0)
  {
   rewind(fp);
   projAnz = (fstat.st_size/sizeof(Project_0400));
   printf("importing %d PROJs (%d)\n",projAnz,i);
   if(projAnz==0)
    return(0);
   
   while(projAnz>projMax)
    extendProjList();
   
   proj = new Project [projAnz+1];
   for(i=0;i<projAnz; i++)
    fread(&proj[i],sizeof(Project_0400),1,fp);
   fclose(fp);
   modified=true;
  }
 else
  {
   if(strncmp(fh.type,FILEHEADER_PROJ,4) !=0)
    {
     printf("todofile structure damaged\n");
     exit(-1);
    }
   if(fh.size>0)
    {
     buffer = new char [fh.size+2];
     fread(buffer,sizeof(char),fh.size,fp);
    }

   if(strncmp(fh.version,CURRENT_FILEVERSION_PROJ,4) ==0)
    {
     projAnz = (fstat.st_size/sizeof(Project));
     printf("reading %d PROJs (%d)\n",projAnz,i);
     if(projAnz==0)
      return(0);
 
     while(projAnz>projMax)
      extendProjList();

     proj = new Project [projAnz+1];
     fread(proj,sizeof(Project),projAnz,fp);
     fclose(fp);
    }
   else
    {
     printf("projfile structure damaged (unkown file version (%c%c%c%c vs %s)\n",
	    fh.version[0],fh.version[1],fh.version[2],fh.version[3],CURRENT_FILEVERSION_PROJ);
     exit(-1);
    }
  }

 int shiftProjectIDs=false;

 for(i=0;i<projAnz; i++)
  {
   projList[i] = proj+i;
   if(projList[i]->id == 0 )
    shiftProjectIDs =true;
  }

 if(shiftProjectIDs)
  printf("Warning: Project -IDs are shifted by 1 to avoid project0ID==0\n");

 lastPid=-1;
 for(i=0;i<projAnz; i++)
  {
   if(shiftProjectIDs)
    projList[i]->id++;

   if(projList[i]->id>lastPid)
    lastPid = projList[i]->id;
   projList[i]->notiz = NULL;
   addProject2Lists(proj+i);
  }
 if(modified)
  writeProjList();
 lastProjTODOchange=(int)time(NULL);
}
int writeProjList()
{
 FILE *fp;
 char file[4096];
 int i;

 sprintf(file,"%s/projs",dataDir);
 fp=fopen(file,"w");
 if(fp==NULL)
  {
   printf("can't open %s\n",file);
   exit(-1);
  }
 fwrite(&projFileHeader,sizeof(FileHeader),1,fp);
 for(i=0;i<projAnz; i++)
  if(projList[i]!=NULL)
   if(! projList[i]->deleted)
    fwrite(projList[i],sizeof(Project),1,fp);

 fclose(fp);
}

//     #TODO-Item%
//     # ID perm status Titel start stop completion {{users aufwand} ... }  init dringlichkeit -dynamisch Beschr 
//     # 0     1     2   3     4         5       6                     7     8              9         10     11
//     #
//     # {Milestone-list}  {reminder-list}  group 
//     #     12                 13            14
//     #
//     # Milestoine-Item: Status  Titel  compl
//     #                    0       1       2      
//     #
//     # beim sendTODO ist perm durch username ersetzt

int changeToDo(int socket,char *ds)
{
 char *tp[32],*t,*s,buffer[16384];
 int tid,uid;
 TodoItem *todo;

 t=skip2nonWS(ds);
 if(*t!='{' && *t!='"')
  {
   s=buffer+1;
   buffer[0]=' ';
  }
 else
  s=buffer;
 strcpy(s,t);

 split(s,tp,32);

 tid = atoi(tp[0]);
 uid = uname2uid(tp[1]);
 if(uid<0)
  {
   send2Client(socket,"ERR: no such user");
   return 0;
  }
 

 if(tid<0)
  {
   lastTid++;
   tid=lastTid;
   todo= new TodoItem;
   todoList[todoAnz] = todo;
   todoAnz++;
   if(todoAnz >todoMax)
    extendTodoList();
   todo->id=lastTid;
   fillStr2Todo(tp,todo);
   addTODO2Lists(todo);
  }
 else
  {
   todo =todoList[tid2idx(tid)];
   if(!todo->deleted)
    if (permission4Todo(todo,uid)== TODO_SEND)
     fillStr2Todo(tp,todo);
  }
 lastProjTODOchange=(int)time(NULL);
 sprintf(buffer,"%d",todo->id);
 send2Client(socket,buffer);
 writeTodoList();
}

//     #TODO-Item%
//     # ID perm status Titel start stop completion {{users aufwand perm} ... }  init dringlichkeit -dynamisch Beschr 
//     # 0     1     2   3     4         5       6                     7     8              9         10     11
//     #
//     # {Milestone-list}  {reminder-list}  group 
//     #     12                 13            14
//     #
//     # Milestoine-Item: Status  Titel  compl
//     #                    0       1       2      
//     #
//     # beim sendTODO ist perm durch username ersetzt
int fillStr2Todo(char *tp[],TodoItem *todo)
{
 char *tp2[512],*tp3[8];
 int anz,i;

 todo->status     = atoi(tp[2]);
 strcpy(todo->descr    ,strTrim(tp[3]));
 todo->tlen       = strlen(todo->descr)+1;
 todo->startDate  = atoi(tp[4]);
 todo->stopDate   = atoi(tp[5]);
 todo->complete   = atoi(tp[6]);
 todo->init       = uname2uid(tp[8]);
 todo->dring      = atoi(tp[9]);
 todo->dringDynam = atoi(tp[10]);
 if(strcmp(tp[14],"_privToDo")==0)
  todo->group = TODO_GROUP_PRIVAT;
 else if(strcmp(tp[14],"__allgemein")==0)
  todo->group = TODO_GROUP_ALLG;
 else
  {
   todo->group      = gname2gid(tp[14]);
   if(todo->group<0)
    todo->group = TODO_GROUP_ALLG;
  }
 strcpy(todo->descr + todo->tlen ,tp[11]);
 todo->deleted    = false;

 // User-Perm-List
 anz = split(tp[7],tp2,130);
 int j=0,id;
 for(i=0; i<anz && i<128; i++)
  {
   split(tp2[j],tp3,4);
   id =  uname2uid(tp3[0]);
   if(id<0)
    {
     id = gname2gid(tp3[0]);
     if(id>=0)
      id+=GROUPOFFSET;
    }
   if(id>=0)
    {
     todo->user[j].id   = id;
     todo->user[j].last = atoi(tp3[1]);
     if(strcmp(tp3[2],"rwd")==0)
       todo->user[j].perm = TODO_RWD;
     else if(strcmp(tp3[2],"rw")==0)
       todo->user[j].perm = TODO_RW;
     else
       todo->user[j].perm = TODO_RO;
     
     //     printf("perm=%s -> %d\n",tp3[2],todo->user[j].perm);
     j++;
    }
  }
 todo->uanz= j;
 // Milestones
 anz = split(tp[12],tp2,9);
 for(i=0; i<anz; i++)
  {
   split(tp2[i],tp3,3);
   todo->miles[i].status = atoi(tp3[0]);
   strncpy(todo->miles[i].titel,tp3[1],127);
   todo->miles[i].titel[127]='\0';
   todo->miles[i].complete = atoi(tp3[2]);
  }

 if( strlen(trimRight(tp[13]))>0)
  {
   anz=split(tp[13],tp2,255);
   todo->remAnz =0;
   for(i=0;i<anz; i++)
    addReminder2Todo(todo,tp2[i]);
   updateReminderList();
  }

 //FIXEME Reminders
}


int changeTodoStatus(int socket, char *str)
{
 char *tp[32],*t,*s,buffer[16384];
 int tid,uid,idx,anz;
 TodoItem *todo;

 t=skip2nonWS(str);
 if(*t!='{' && *t!='"')
  {
   s=buffer+1;
   buffer[0]=' ';
  }
 else
  s=buffer;
 strcpy(s,t);

 split(s,tp,32);

 uid = uname2uid(tp[0]);
 if(uid<0)
  {
   send2Client(socket,"ERR: no such user");
   return 0;
  }

 tid = atoi(tp[1]);
 idx = tid2idx(tid);
 if(idx<0)
  {
   send2Client(socket,"ERR: no such TODO");
   return 0;
  }
 todoList[idx]->status=atoi(tp[2]);
 
 lastProjTODOchange=(int)time(NULL);
 send2Client(socket,"done");
 writeTodoList();
}

void addTODO2Lists(TodoItem *todo)
{
 int i;
 for (i=0; i< todo->uanz; i++)
  if(todo->user[i].id <GROUPOFFSET)
   addTODO2UsersList(todo,todo->user[i].id);
  else
   addTODO2GroupsList(todo,todo->user[i].id-GROUPOFFSET);

 addTODO2UsersList(todo,todo->init);
}

void  addTODO2GroupsList(TodoItem *todo, int gid)
{
 int i;
 for(i=0;i<groupList[gid].anz; i++)
  addTODO2UsersList(todo,groupList[gid].membr[i]);

 groupList[gid].todo.list[ groupList[gid].todo.anz] = todo;
 groupList[gid].todo.anz ++;
 if (groupList[gid].todo.anz > groupList[gid].todo.max)
  extendTodoList(&groupList[gid].todo);
}
void  addTODO2UsersList(TodoItem *todo, int uid)
{
 userList[uid].todo.list[ userList[uid].todo.anz] = todo;
 userList[uid].todo.anz ++;
 if (userList[uid].todo.anz > userList[uid].todo.max)
  extendTodoList(&userList[uid].todo);
}


int deleteTodo(int socket, char *str)
{
 int uid,tid,idx;
 char *tp[4];

 split(str,tp,3);
 uid = uname2uid(tp[0]);
 if(uid<0)
  {
   send2Client(socket,"ERR No such user");
   return 0;
  }
 tid = atoi(tp[1]);
 idx = tid2idx(tid);
 if(idx<0)
  {
   send2Client(socket,"ERR No such TODO");
   return 0;
  }
 
 if(deletePermission4Todo(todoList[idx],uid))
  {
   todoList[idx]->deleted =true;
   writeTodoList();  
  }
 send2Client(socket,"done");
 return 0;
}

//     #Project-Item
//     # ID type perm open/close status Titel start stop {users ... } init dringl. -dynamisch {todo-List} 
//     # 0   1     2        3       4     5     6     7       8         9     10         11         12
//     # 
//     # {reminder-list} Beschr group 
//     #     13           14     15
//     # type = TODO -> einfahces TODO
//     # type = PROJ -> project
//     #
//     # TODO-List: pro TODO : {TODO-ID  {depend-List} lvl}
//     # Depend-List: jedes Depend: {tid type val}

int changeProject(int socket,char *ds)
{
 char *tp[32],*t,*s,buffer[16384];
 int pid,uid;
 Project  *proj;

 t=skip2nonWS(ds);
 if(*t!='{' && *t!='"')
  {
   s=buffer+1;
   buffer[0]=' ';
  }
 else
  s=buffer;
 strcpy(s,t);

 split(s,tp,32);

 pid = atoi(tp[0]);
 uid = uname2uid(tp[1]);
 if(uid<0)
  {
   send2Client(socket,"ERR: no such user");
   return 0;
  }

 if(pid<0)
  {
   lastPid++;
   pid=lastPid;
   proj= new Project ;
   projList[projAnz] = proj;
   projAnz++;
   if(projAnz >projMax)
    extendProjList();
   proj->id=lastPid;
   fillStr2Project(tp,proj);
   addProject2Lists(proj);
  }
 else
  {
   proj =projList[pid2idx(pid)];
   if(!proj->deleted)
    if (permission4Proj(proj,uid)== TODO_SEND)
     fillStr2Project(tp,proj);
  }
 lastProjTODOchange=(int)time(NULL);
 sprintf(buffer,"%d",proj->id);
 send2Client(socket,buffer);
 writeProjList();
}



//     #Project-Item
//     # ID type perm open/close status Titel start stop {users ... } init dringl. -dynamisch {todo-List} 
//     # 0   1     2        3       4     5     6     7       8         9     10         11         12
//     # 
//     # {reminder-list} Beschr group 
//     #     13           14     15
//     # type = TODO -> einfahces TODO
//     # type = PROJ -> project
//     #
//     # TODO-List: pro TODO : {TODO-ID  {depend-List} lvl}
//     # Depend-List: jedes Depend: {tid type val}
int fillStr2Project(char *tp[],Project *proj)
{
 char *tp2[521],*tp3[8],*tp4[32],*tp5[8];
 int anz,i,danz,stat;

 if(strcmp(tp[2],"OPEN")==0)
  proj->open=true;
 else
  proj->open=false;
 
 strcpy(proj->descr    ,strTrim(tp[3]));
 proj->tlen       = strlen(proj->descr)+1;
 proj->stopDate   = atoi(tp[5]);
 proj->init       = uname2uid(tp[7]);
 proj->deleted    = false;
 strcpy(proj->descr + proj->tlen ,tp[10]);

 if(strcmp(tp[11],"_privProj")==0)
  proj->group = TODO_GROUP_PRIVAT;
 else if(strcmp(tp[11],"__allgemein")==0)
  proj->group = TODO_GROUP_ALLG;
 else
  {
   proj->group      = gname2gid(tp[11]);
   if(proj->group<0)
    proj->group = TODO_GROUP_ALLG;
  }

 // User-Perm-List
 anz = split(tp[6],tp2,520);
 int j=0,id;
 for(i=0; i<anz && i<128; i++)
  {
   split(tp2[j],tp3,4);
   id =  uname2uid(tp3[0]);
   if(id<0)
    {
     id = gname2gid(tp3[0]);
     if(id>=0)
      id+=GROUPOFFSET;
    }
   if(id>=0)
    {
     proj->user[j].id   = id;
     if(strcmp(tp3[1],"rwd")==0)
      proj->user[j].perm = TODO_RWD;
     else if(strcmp(tp3[1],"rw")==0)
      proj->user[j].perm = TODO_RW;
     else
      proj->user[j].perm = TODO_RO;
     j++;
    }
  }
 proj->uanz= j;
 // TODO-List
//     # TODO-List: pro TODO : {TODO-ID  {depend-List} lvl}
//     # Depend-List: jedes Depend: {tid type val}
 anz = split(tp[ 8],tp2,130);
 stat = TODO_STAT_DONE;
 int tanz=0;
 for(i=0; i<anz; i++)
  {
   int idx,tid;
   split(tp2[i],tp3,3);
   tid = atoi(tp3[0]);

   // Check if proj is already subproject to project #-tid
   if (tid<0)
    if(isProjectIncluded(proj->id,-tid))
     continue;

   proj->todo[i].tid = tid;
   proj->todo[i].lvl = atoi(tp3[2]);
   trimRight(tp3[1]);
   if (tp3[1][0] != '\0')
    {
     danz = split(tp3[1],tp4,33);
     for(j=0;j<danz; j++)
      {
       split(tp4[j],tp5,4);
       proj->todo[i].dep[j].tid  = atoi(tp5[0]);
       proj->todo[i].dep[j].type = atoi(tp5[1]);
       proj->todo[i].dep[j].val  = atoi(tp5[2]);
      }
     proj->todo[i].anz=danz;
    }
   else
    proj->todo[i].anz=0;
   
   if(tid >=0 )
    {
     idx = tid2idx(tid);
     if(stat< todoList[idx]->status)
      stat = todoList[idx]->status;
    } else { 
     idx = pid2idx(-tid);
     if(stat< projList[idx]->status)
      stat = projList[idx]->status;
    }
   tanz++;
  }
 proj->status =stat;
 proj->tanz=tanz;


}


// isProjectIncluded check if project #pid1 is subproject to project #pid2
int isProjectIncluded(int pid1, int pid2)
{
 Project *proj;

 proj =  projList[pid2idx(pid2)];
 for(int i=0 ;i<proj->tanz; i++)
  if(proj->todo[i].tid<0)
   {
    if(proj->todo[i].tid == -pid1)
     return true;
    else
     return isProjectIncluded(pid1,-proj->todo[i].tid);
   }
 return false;
}
void getSubProjects()
{
 int i;

 for(i=0;i<projAnz ; i++)
  projList[i]->isSubProject == 0;
 
 for(i=0;i<projAnz ; i++)
  if(projList[i]->isSubProject==0)
   getSubProjects(i);
}

void getSubProjects( int pidx)
{
 Project *proj;
 int idx;

 proj =  projList[pidx];
 for(int i=0 ;i<proj->tanz; i++)
  if(proj->todo[i].tid<0)
   {
    idx= pid2idx(-proj->todo[i].tid);
    projList[idx]->isSubProject=1;
    getSubProjects(idx);
   }
}

void addProject2Lists(Project *proj)
{
 int i;
 for (i=0; i< proj->uanz; i++)
  if(proj->user[i].id <GROUPOFFSET)
   addProject2UsersList(proj,proj->user[i].id);
  else
   addProject2GroupsList(proj,proj->user[i].id-GROUPOFFSET);
 addProject2UsersList(proj,proj->init);
}

void  addProject2GroupsList(Project *proj, int gid)
{
 int i;
 for(i=0;i<groupList[gid].anz; i++)
  addProject2UsersList(proj,groupList[gid].membr[i]);

 groupList[gid].proj.list[ groupList[gid].proj.anz] = proj;
 groupList[gid].proj.anz ++;
 if (groupList[gid].proj.anz > groupList[gid].proj.max)
  extendProjList(&groupList[gid].proj);
}
void  addProject2UsersList(Project *proj, int uid)
{
 userList[uid].proj.list[ userList[uid].proj.anz] = proj;
 userList[uid].proj.anz ++;
 if (userList[uid].proj.anz > userList[uid].proj.max)
  extendProjList(&userList[uid].proj);
}

int deleteProject(int socket, char *str)
{
 int uid,pid,idx;
 char *tp[4];

 split(str,tp,3);
 uid = uname2uid(tp[0]);
 if(uid<0)
  {
   send2Client(socket,"ERR No such user");
   return 0;
  }
 pid = atoi(tp[1]);
 idx = pid2idx(pid);
 if(idx<0)
  {
   send2Client(socket,"ERR No such Project");
   return 0;
  }
 
 if(deletePermission4Proj(projList[idx],uid))
  {
   projList[idx]->deleted =true;
   writeProjList();
  }
 send2Client(socket,"done");
 return 0;
}

int sendTodo(int socket,char *str)
{
 char buffer[8192],*tp[8];
 int i,j,uid,tid,perm,idx;
 TodoItem *todo;

 split(str,tp,7);
 uid = uname2uid(tp[0]);
 if(uid<0)
  { 
   send2Client(socket,"ERR: no such user (code 1)");
   return 0;
  }
 if(uid >userAnz)
  {
   send2Client(socket,"ERR: no such user (code 2)");
   return 0;
  }
 if(userList[uid].id<0)
  {
   send2Client(socket,"ERR: no such user (code 3)");
   return 0;
  }
 tid  =  atoi(tp[1]);
 idx  =  tid2idx(tid);
 if (idx<0)
  {
   send2Client(socket,"ERR: no such TODO");
   return 0;
  }
 
 todo = todoList[idx];
 if ( (todo->tmp= permission4Todo(todo,uid)) == TODO_SEND_NOT )
  {
   send2Client(socket,"no permission");
   return true;
  }
 if( todo->deleted)
  {
   send2Client(socket,"ERR: no such todo (code 4)");
   return 0;
  }

 buffer[0]='\0';
 addTODO2str(buffer,todo,uid,false);
 send2Client(socket,buffer);

 return true;
}
int sendProject(int socket,char *str)
{
 char buffer[8192],*tp[8];
 int i,j,uid,pid,perm,idx;
 Project *proj;

 split(str,tp,7);
 uid = uname2uid(tp[0]);
 if(uid<0)
  { 
   send2Client(socket,"ERR: no such user (code 1)");
   return 0;
  }
 if(uid >userAnz)
  {
   send2Client(socket,"ERR: no such user (code 2)");
   return 0;
  }
 if(userList[uid].id<0)
  {
   send2Client(socket,"ERR: no such user (code 3)");
   return 0;
  }
 pid  =  atoi(tp[1]);
 idx  = pid2idx(pid);
 if (idx<0)
  {
   send2Client(socket,"ERR: no such project (code 4)");
   return 0;
  }
 proj = projList[idx];
 if ( (proj->tmp= permission4Proj(proj,uid)) == TODO_SEND_NOT )
  {
   send2Client(socket,"ERR: no permission");
   return true;
  }
 if( proj->deleted)
  {
   send2Client(socket,"ERR: no such project (code 4)");
   return 0;
  }


 
 buffer[0]='\0';
 addProj2str(buffer,proj,uid,false);
 send2Client(socket,buffer);

 return true;
}
//  getProjLists me list-user
int sendProjectAndTodoLists(int socket,char *str)
{
 char buffer[256000],*tp[8],*tp2[1024],list[4096],tx[16];
 int i,j,k,uid,ruid,perm,idx,anz;

 Project *proj;
 TodoItem *todo;

 split(str,tp,7);
 ruid = uname2uid(tp[0]);
 if(ruid <0)
  { 
   send2Client(socket,"ERR: no such user (code 1)");
   return 0;
  }
 if(ruid >userAnz)
  {
   send2Client(socket,"ERR: no such user (code 2)");
   return 0;
  }
 if(userList[ruid].id<0)
  {
   send2Client(socket,"ERR: no such user (code 3)");
   return 0;
  }

 anz = split(tp[1],tp2,1023);


 getSubProjects();
 for(i=0;i<projAnz;i++)
  projList[i]->tmp = TODO_SEND_NOT;
 for (i=0;i<todoAnz; i++)
  {
   todoList[i]->tmp = TODO_SEND_NOT;
   todoList[i]->tmp2= TODO_FREE;
   todoList[i]->selected=false;
  }
   
 for(k=0;k<anz; k++)
  {
   if(tp2[k][0] != 'u')
    continue;
   uid = uname2uid(tp2[k]+2); // Den Vorsatz u- ignoriren
   if (uid<0 || uid>userAnz || userList[uid].id <0)
    continue;
    
   for(i=0;i<userList[uid].proj.anz; i++)
    {
     proj= userList[uid].proj.list[i];
     if(!proj->deleted)
      {
       proj->tmp= permission4Proj(proj,ruid);
       if(proj->tmp != TODO_SEND_NOT)
	// Alle TODO in einem Project drfen auf jeden Fall gelistet werden
	for(j=0;j<proj->tanz;j++)
	 {
	  idx = tid2idx(proj->todo[j].tid);
	  if(idx>=0)
	   if(! todoList[idx]->deleted)
	    {
	     todoList[idx]->tmp = TODO_SEND_LO;  
	     todoList[idx]->tmp2 = TODO_IN_PROJ;
	    }
	 }
      }
    }
  
   for(i=0;i<userList[uid].todo.anz; i++)
    {
     todo =  userList[uid].todo.list[i];
     if(!todo->deleted)
      // Wenn perm = TODO_SEND_NOT lassen ggfs. ein TODO_SEND_LO stehen
      if( (perm = permission4Todo(todo,ruid)) != TODO_SEND_NOT)
       todo->tmp= perm;
    }
  }
 strcpy(buffer,"{");
 for (i=0;i<todoAnz; i++)
  if( todoList[i]->tmp != TODO_SEND_NOT)
   addTODO2str(buffer,todoList[i],uid,true);
  else
   printf("Dont send TODO %d: %s %d %d\n",todoList[i]->id,todoList[i]->descr,todoList[i]->group,todoList[i]->init);
 strcat(buffer,"} {");

 for (i=0;i<projAnz; i++)
  if( projList[i]->tmp != TODO_SEND_NOT)
   addProj2str(buffer,projList[i],uid,true);
 strcat(buffer,"}");
 send2Client(socket,buffer);
}
int permission4Proj(Project *proj, int uid)
{
 int i,gid;
 // Init hat immer  volle Rechte
 if(proj->init ==uid)
  return TODO_SEND;
 

 if(proj->group == TODO_GROUP_PRIVAT)
  return TODO_SEND_NOT;

// Wenn man Master-Group-admin ist, hat man rw-Rechte
 for(i=0;i<groupList[0].anz; i++)
  if(groupList[0].membr[i] ==uid)
   if(groupList[0].mstat[i] == GROUP_ADMIN)
     return TODO_SEND;

 // Wenn man Group-admin ist, hat man rw-Rechte
 if(proj->group == TODO_GROUP_ALLG)
  gid=0;
 else
  gid = proj->group;
 for(i=0;i<groupList[gid].anz; i++)
  if(groupList[gid].membr[i] ==uid)
   if(groupList[gid].mstat[i] == GROUP_ADMIN)
    return TODO_SEND;

 // Bearbeiter haben immer Read-Recht und wenn gesetzt auch Write-Recht
 for(i=0;i<proj->uanz; i++)
  if(proj->user[i].id == uid)
   {
    if((proj->user[i].perm | TODO_W)>0)
     return TODO_SEND;
    else
     return TODO_SEND_RO;
   }

 if(proj->group == TODO_GROUP_ALLG)
  return TODO_SEND_RO;

 return TODO_SEND_NOT;
}
int permission4Todo(TodoItem *todo,int uid)
{
 int i;
 int gid;

 // Init hat immer  volle Rechte
 if(todo->init ==uid)
  return TODO_SEND;
 

 if(todo->group == TODO_GROUP_PRIVAT)
  return TODO_SEND_NOT;

// Wenn man Master-Group-admin ist, hat man rw-Rechte
 for(i=0;i<groupList[0].anz; i++)
  if(groupList[0].membr[i] ==uid)
   if(groupList[0].mstat[i] == GROUP_ADMIN)
     return TODO_SEND;

 // Wenn man Group-admin ist, hat man rw-Rechte
 if(todo->group == TODO_GROUP_ALLG)
  gid=0;
 else
  gid = todo->group;
 for(i=0;i<groupList[gid].anz; i++)
  if(groupList[gid].membr[i] ==uid)
   if(groupList[gid].mstat[i] == GROUP_ADMIN)
    return TODO_SEND;

 // Bearbeiter haben immer Read-Recht und wenn gesetzt auch Write-Recht
 for(i=0;i<todo->uanz; i++)
  if(todo->user[i].id == uid)
   {
    //    printf("PERM: %s @ %s : %d\n",userList[uid].name,todo->descr,todo->user[i].perm);
    if((todo->user[i].perm | TODO_W)>0)
     return TODO_SEND;
    else
     return TODO_SEND_RO;
   }
 if(todo->group == TODO_GROUP_ALLG)
  return TODO_SEND_RO;

return TODO_SEND_NOT;
}

int deletePermission4Proj(Project *proj,int uid)
{
 int i,gid;
  if(proj->init ==uid)
   return(true);
 if(proj->group == TODO_GROUP_PRIVAT)
  return false;
// Wenn man Master-Group-admin ist, hat man rw-Rechte
 for(i=0;i<groupList[0].anz; i++)
  if(groupList[0].membr[i] ==uid)
   if(groupList[0].mstat[i] == GROUP_ADMIN)
     return true;
 if(proj->group == TODO_GROUP_ALLG)
  gid=0;
 else
  gid = proj->group;
 // Wenn man Group-admin ist, hat man rw-Rechte
 for(i=0;i<groupList[gid].anz; i++)
  if(groupList[gid].membr[i] ==uid)
   if(groupList[gid].mstat[i] == GROUP_ADMIN)
    return true;
  // Bearbeiter haben immer Read-Recht und wenn gesetzt auch Write-Recht
 for(i=0;i<proj->uanz; i++)
  if(proj->user[i].id == uid)
   {
    if((proj->user[i].perm | TODO_D)>0)
     return true;
    else
     return false;
   }
 return false;
}
int deletePermission4Todo(TodoItem *todo,int uid)
{
 int i,gid;
  if(todo->init ==uid)
   return(true);
 if(todo->group == TODO_GROUP_PRIVAT)
  return false;
// Wenn man Master-Group-admin ist, hat man rw-Rechte
 for(i=0;i<groupList[0].anz; i++)
  if(groupList[0].membr[i] ==uid)
   if(groupList[0].mstat[i] == GROUP_ADMIN)
     return true;
 // Wenn man Group-admin ist, hat man rw-Rechte
 if(todo->group == TODO_GROUP_ALLG)
  gid=0;
 else
  gid = todo->group;
 for(i=0;i<groupList[gid].anz; i++)
  if(groupList[gid].membr[i] ==uid)
   if(groupList[gid].mstat[i] == GROUP_ADMIN)
    return true;
  // Bearbeiter haben immer Read-Recht und wenn gesetzt auch Write-Recht
 for(i=0;i<todo->uanz; i++)
  if(todo->user[i].id == uid)
   {
    if((todo->user[i].perm | TODO_D)>0)
     return true;
    else
     return false;
   }
 return false;
}

void addTODO2str(char *t, TodoItem *todo,int uid,int enclose)
{
 char buffer[16384],uList[8192],mList[1024],rList[4096],txt[256],gname[40];
 char *perm[4]={"r","rw","rd","rwd"};
 char *perm2[5]={"-","rw","r","-","rwd"}; // NOT_SEND, RW, RO, LO
 char uperm[4];
 int i;

 strcpy(uList,"");
 for(i=0; i<todo->uanz; i++)
  sprintf(uList,"%s{%s %d %s} ",uList,userList[todo->user[i].id].name,todo->user[i].last,perm[todo->user[i].perm]);

 strcpy(mList,"");
 for(i=0; i<8; i++)
  sprintf(mList,"%s{%d {%s} %d} ",mList,todo->miles[i].status,todo->miles[i].titel,todo->miles[i].complete);

 switch (todo->group)
  {
  case TODO_GROUP_ALLG:   strcpy(gname,"__allgemein"); break;
  case TODO_GROUP_PRIVAT: strcpy(gname,"_privToDo"); break;
  default: strcpy(gname,groupList[todo->group].name); break;
  }

 strcpy(rList,"");
 for (i=0;i<todo->remAnz; i++)
  {
   strcat(rList,reminder2Str4Date(&todo->reminder[i],txt));
  }

 strcpy(uperm,perm2[todo->tmp]);
 if ( todo->tmp == TODO_SEND )
  if(deletePermission4Todo(todo,uid))
   strcpy(uperm,"rwd");


 if(enclose)
  sprintf(buffer,"{%d %s %d {%s} %d %d %d {%s} %s %d %d {%s} {%s} {%s} %s} ",
	  todo->id,uperm,todo->status,replaceBraces(todo->descr),todo->startDate,todo->stopDate,
	  todo->complete,
	  uList,userList[todo->init].name,todo->dring,todo->dringDynam,
	  replaceBraces(todo->descr+todo->tlen),mList,rList,gname);
 else
  sprintf(buffer,"%d %s %d {%s} %d %d %d {%s} %s %d %d {%s} {%s} {%s} %s ",
	  todo->id,uperm,todo->status,replaceBraces(todo->descr),todo->startDate,todo->stopDate,
	  todo->complete,
	  uList,userList[todo->init].name,todo->dring,todo->dringDynam,
	  replaceBraces(todo->descr+todo->tlen),mList,rList,gname);

 //printf("len=%d ; str='%s'\n",strlen(buffer),buffer);
 strcat(t,buffer);
}
void addProj2str(char *t, Project *proj,int uid,int enclose)
{
 char buffer[16384],uList[8192],tList[1024],rList[4096],txt[256],dList[256],gname[40];
 char *perm[4]={"r","rw","rd","rwd"};
 char *perm2[4]={"-","rw","r","-"}; // NOT_SEND, RW, RO, LO
 char uperm[4];
 char openStr[8];
 int i,j;

 if(proj->open)
  strcpy(openStr,"OPEN");
 else
  strcpy(openStr,"CLOSE");
 
 strcpy(uList,"");
 for(i=0; i<proj->uanz; i++)
  sprintf(uList,"%s{%s %s} ",uList,userList[proj->user[i].id].name,perm[proj->user[i].perm]);

 strcpy(tList,"");
 for(i=0; i<proj->tanz; i++)
  {
   strcpy(dList,"");
   for(j=0; j<proj->todo[i].anz; j++)
    sprintf(dList,"%s{%d %d %d} ",dList,proj->todo[i].dep[j].tid,proj->todo[i].dep[j].type,proj->todo[i].dep[j].val);
   sprintf(tList,"%s{%d {%s} %d} ",tList,proj->todo[i].tid,dList,proj->todo[i].lvl);
  }

 switch (proj->group)
  {
  case TODO_GROUP_ALLG:   strcpy(gname,"__allgemein"); break;
  case TODO_GROUP_PRIVAT: strcpy(gname,"_privProj"); break;
  default: strcpy(gname,groupList[proj->group].name); break;
  }

 strcpy(uperm,perm2[proj->tmp]);
 if ( proj->tmp == TODO_SEND )
  if(deletePermission4Proj(proj,uid))
   strcpy(uperm,"rwd");

 if(enclose)
  sprintf(buffer,"{%d %s %s {%s} %d %d {%s} %s {%s} {%s} {%s} %s %d} ",
	  proj->id,uperm,openStr,replaceBraces(proj->descr)
	  ,0,proj->stopDate,uList,userList[proj->init].name,
	  tList,rList,replaceBraces(proj->descr+proj->tlen),gname,proj->isSubProject);
 else
  sprintf(buffer,"%d %s %s {%s} %d %d {%s} %s {%s} {%s} {%s} %s %d",
	  proj->id,uperm,openStr,replaceBraces(proj->descr),0,
	  proj->stopDate,uList,userList[proj->init].name,
	  tList,rList,replaceBraces(proj->descr+proj->tlen),gname,proj->isSubProject);
 strcat(t,buffer);
}

int getLastProjTodoChange(int socket)
{
 char buffer[64];
 sprintf(buffer,"%d",lastProjTODOchange);
 send2Client(socket,buffer);
 return true;
}


int readNotiz(TodoItem *todo)
{
 FILE *fp;
 char file[1024];
 struct stat fstat;

 if(todo->notiz == NULL)
  todo->notiz = initNotizList(todo->id,TASK_NOTIZ);

 sprintf(file,"%s/notiz/Task%08d.txt",dataDir,todo->id);
 if(stat(file,&fstat)<0)
  return(false);
 
 fp=fopen(file,"r");
 if(fp==NULL)
  {
   printf("can't open %s\n",file);
   return(false);
  }

 // printf("reading Notiz form '%s'\n",file);
 readNotiz(fp,todo->notiz);
 fclose(fp);
 return(true); 
}
int readNotiz(Project *proj)
{
 FILE *fp;
 char file[1024];
 struct stat fstat;

 if(proj->notiz == NULL)
  {
   //   printf("\t\tread: initNotizList:\n");
   proj->notiz = initNotizList(proj->id,PROJECT_NOTIZ);
   //   printf("\t\tread: initNotizList: -> %p\n",proj->notiz);
  }

 sprintf(file,"%s/notiz/Proj%08d.txt",dataDir,proj->id);
 if(stat(file,&fstat)<0)
  return(false);
 
 fp=fopen(file,"r");
 if(fp==NULL)
  {
   printf("can't open %s\n",file);
   return(false);
  }

 // printf("reading Notiz form '%s'\n",file);
 readNotiz(fp,proj->notiz);
 fclose(fp);
 return(true); 
}

int writeNotiz(TodoItem *todo)
{
 char file[1024];
 FILE *fp;

 if(todo->notiz == NULL)
  return(true);
 printf("writing Notiz : %p\n",todo->notiz);
 
 sprintf(file,"%s/notiz/Task%08d.txt",dataDir,todo->id);
 fp=fopen(file,"w");
 if(fp==NULL)
  {
   printf("can't open %s\n",file);
   delete todo->notiz;
   todo->notiz=NULL;
   return(false);
  }
 writeNotiz(fp,todo->notiz);
 fclose(fp);
}
int writeNotiz(Project *proj)
{
 char file[1024];
 FILE *fp;

 if(proj->notiz == NULL)
  return(true);

 printf("writing Notiz : %p\n",proj->notiz);
 
 sprintf(file,"%s/notiz/Proj%08d.txt",dataDir,proj->id);
 fp=fopen(file,"w");
 if(fp==NULL)
  {
   printf("can't open %s\n",file);
   delete proj->notiz;
   proj->notiz=NULL;
   return(false);
  }
 writeNotiz(fp,proj->notiz);
 fclose(fp);
}

// Utis

int tid2idx(int tid)
{
 int i=-1;
 for(i=0;i<todoAnz; i++)
  if(todoList[i]->id==tid)
   return(i);
 return(-1);
}
int pid2idx(int pid)
{
 int i=-1;
 for(i=0;i<projAnz; i++)
  if(projList[i]->id==pid)
   return(i);
 return(-1);
}



