#!/bin/sh

_LANG=`echo $LANG|cut -c-2`

DEVEL=$1
DATA_DIR=$2
TMP_PATH=$3
MUSER=$5

cd $TMP_PATH

make install2 TMP_INST_PATH=$TMP_PATH STARTSCRIPT=$4

if [ ! -d $DATA_DIR ]
then
    if [ -f $DATA_DIR ]
    then
	echo "Can't create $DATA_DIR"
	echo "File exists and is not directory"
	exit
    fi
    mkdirhier $DATA_DIR
fi

if [ $DEVEL -eq 0 ]
then
    if [ ! -f $DATA_DIR/users ]
    then
	cp defaults/users $DATA_DIR/
	if [ "$_LANG" == "de " ]
	then
	    echo "INFO:"
	    echo "    Da noch keine Benuzterdatei existiert"
	    echo "    wurde eine mit dem Benutzer  'admin' angelegt"
	else
	    echo "INFO:"
	    echo "    Since no users file was found a new users file"
	    echo "    with one account named 'admin' was created"
	fi
    fi
    if [ ! -f $DATA_DIR/groups ]
    then
	cp defaults/groups $DATA_DIR/
	if [ "$_LANG" == "de " ]
	then
	    echo "INFO:"
	    echo "    Da noch keine Gruppendatei existiert"
	    echo "    wurde eine mit der Grupe  'alle' angelegt"
	else
	    echo "INFO:"
	    echo "    Since no groups file was found a new groups file"
	    echo "    with one group named 'alle' was created"
	fi
    fi
    if [ ! -f $DATA_DIR/rooms ]
    then
	cp defaults/rooms $DATA_DIR/
	if [ "$_LANG" == "de " ]
	then
	    echo "INFO:"
	    echo "   Da noch keine Raum-Datei existiert"
	    echo "   wurde eine mit dem Raum  'zu Hause' angelegt"
	else
	    echo "INFO:"
	    echo "    Since no rooms file was found a new rooms file"
	    echo "    with one room 'zu Hause' was created"
	fi
    fi
    if [ ! -f $DATA_DIR/pda ]
    then
	cp defaults/pda $DATA_DIR/
	if [ "$_LANG" == "de " ]
	then
	    echo "INFO:"
	    echo "   Da noch keine PDA-Datei existiert"
	    echo "   wurde eine  angelegt"
	else
	    echo "INFO:"
	    echo "    Since no pda file was found a new rooms file"
	    echo "    with one  was created"
	fi
    fi
    

    dirs="prefs notiz comments userData"
    for dir in $dirs 
    do
	echo "echecking $DATA_DIR/$dir"
	if [ ! -d $DATA_DIR/$dir ]
	then
	    if [  -f $DATA_DIR/$dir ]
	    then
		mv $DATA_DIR/$dir $DATA_DIR/$dir.bak
	    fi
	    mkdir $DATA_DIR/$dir
	fi
    done
fi

chmod -R u+rw  $MUSER $DATA_DIR
