// File: sync.cc
// 
//      This file is part of minkowsky
// 
//      Copyright (C) 2001-2002 by Rdiger Goetz
//      Author: Rdiger Goetz <minkowsky@r-goetz.de>
// 
//      Time-stamp: <27-Oct-2002 11:21:17 goetz>
// 
//      This program is free software; you can redistribute it and/or modify
//      it under the terms of the GNU General Public License as published by
//      the Free Software Foundation; either version 2 of the License, or
//      (at your option) any later version.
// 
//      This program is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU General Public License for more details.
// 
//      You should have received a copy of the GNU General Public License
//      along with this program; if not, write to the Free Software
//      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//  

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <errno.h>  
#include <time.h>  

#define SYNC
#include "termin.h"
#include "sync.h"
int folderName2dirid(char *name);


void initPDAconfig (PDAconfig *p);
int readSyncConfigurations ( ) ;
void parseCSVstring(syncUserInfo *syncUI, char *csv);

void initSync ()
{
 
 readSyncConfigurations();
}
void initPDAconfig (PDAconfig *p)
{
 p->name=NULL;
 p->connectCmd=NULL;
 p->connectCheckCmd=NULL;
 p->connectMsg=NULL;
 p->connectHelp=NULL;
 p->disConnectCmd=NULL;
 p->adrReadCmd=NULL;
 p->adrWriteCmd=NULL;
 p->adrCsv=NULL;
 p->adrCsvSep =',';
 p->adrCommonAnz=0;
 p->todoReadCmd=NULL;
 p->todoWriteCmd=NULL;
 p->todoCsv=NULL;
 p->todoCsvSep =',';
 p->calReadCmd=NULL;
 p->calWriteCmd=NULL;
 p->calCsv=NULL;
 p->calCsvSep =',';
}
int readSyncConfigurations ( ) 
{
 FILE *fp;
 char file [1024],*t,line[16384],*s;
 int anz=0,p,l;

 sprintf(file,"%s/pda",dataDir);
 fp=fopen(file,"r");
 if(fp==NULL)
  {
   printf("can't open %s\n",file);
   exit(-1);
  }

 pdaConfigAnz=0;
 while( (t=fgets(line,16383,fp)) != NULL)
  if(strncmp(line,"NAME",4)==0)
   pdaConfigAnz++;
 rewind(fp);
 
 pdaConfig =  new PDAconfig[pdaConfigAnz];

 p=-1;
 while( (t=fgets(line,16383,fp)) != NULL)
  {
   s=strTrim(line);
   if(*s =='#' || *s == '\n')
    continue;
   if(*s==' ' || *s == '\t')
    s=skip2nonWS(s);
   s=skip2WS(s);
   s=skip2nonWS(s);

   printf("line=%s  -> %s'\n",line,s);

   if(strncmp(line,"NAME",4)==0)
    {
     p++;
     initPDAconfig(&pdaConfig[p]);
     allocateAndCopy(&pdaConfig[p].name,s);
    }
   else if(strncmp(line,"CONNECT_COMMAND",15)==0)
    allocateAndCopy(&pdaConfig[p].connectCmd,s);
   else if(strncmp(line,"CONNECT_CHECK",13)==0)
    allocateAndCopy(&pdaConfig[p].connectCheckCmd,s);
   else if(strncmp(line,"CONNECT_TEXT",12)==0)
    allocateAndCopy(&pdaConfig[p].connectMsg,s);
   else if(strncmp(line,"CONNECT_HELP",12)==0)
    allocateAndCopy(&pdaConfig[p].connectHelp,s);
   else if(strncmp(line,"DISCONNECT_COMMAND",18)==0)
    allocateAndCopy(&pdaConfig[p].disConnectCmd,s);
   else if(strncmp(line,"ADDRESS_READ",12)==0)
    allocateAndCopy(&pdaConfig[p].adrReadCmd,s);
   else if(strncmp(line,"ADDRESS_WRITE",13)==0)
    allocateAndCopy(&pdaConfig[p].adrWriteCmd,s);
   else if(strncmp(line,"ADDRESS_CSV_START_LINE",22)==0)
    pdaConfig[p].adrStartLine =atoi(s);
   else if(strncmp(line,"ADDRESS_CSV_SEPARATOR",21)==0)
    {
     char *s2=s;
     
     while (*s2 == ' ' || *s2 =='\t')
      s2++;
     pdaConfig[p].adrCsvSep = *s2;
    }
   else if(strncmp(line,"ADDRESS_CSV",11)==0)
    allocateAndCopy(&pdaConfig[p].adrCsv,s);
   else if(strncmp(line,"ADDRESS_CUSTOM_FIELDS",21)==0)
    {
     pdaConfig[p].adrCommonAnz =atoi(s);
     if (pdaConfig[p].adrCommonAnz > 8 )
      pdaConfig[p].adrCommonAnz =8;
     printf(">>> pda %d = %d\n",p,pdaConfig[p].adrCommonAnz);
    }
   else if(strncmp(line,"ADDRESS_DEFAULT_CAT",19)==0)
    allocateAndCopy(&pdaConfig[p].defaultCat,s);
   else if(strncmp(line,"ADDRESS_DEFAULT_FOLDER",22)==0)
    allocateAndCopy(&pdaConfig[p].defaultFolder,s);

   else if(strncmp(line,"TODO_READ",12)==0)
    allocateAndCopy(&pdaConfig[p].todoReadCmd,s);
   else if(strncmp(line,"TODO_WRITE",13)==0)
    allocateAndCopy(&pdaConfig[p].todoWriteCmd,s);
   else if(strncmp(line,"TODO_CSV_START_LINE",22)==0)
    pdaConfig[p].todoStartLine =atoi(s);
   else if(strncmp(line,"TODO_CSV",11)==0)
    allocateAndCopy(&pdaConfig[p].todoCsv,s);

   else if(strncmp(line,"CALENDAR_READ",12)==0)
    allocateAndCopy(&pdaConfig[p].calReadCmd,s);
   else if(strncmp(line,"CALENDAR_WRITE",13)==0)
    allocateAndCopy(&pdaConfig[p].calWriteCmd,s);
   else if(strncmp(line,"CAL_CSV_START_LINE",22)==0)
    pdaConfig[p].calStartLine =atoi(s);
   else if(strncmp(line,"CALENDAR_CSV",11)==0)
    allocateAndCopy(&pdaConfig[p].calCsv,s);
  }
}

void parseCSVstring(syncUserInfo *syncUI, char *csv)
{
 char *t,tag[256],*s,*ts;
 int fnr,ofnr, typeFnr=-1,f;
 

 t = csv;
 fnr=0;
 ofnr=-1;
 do 
  {
   while ( *t != '<'  && *t != '\0')
    t++;
   if(*t == '\0')
    break;
   t++;

   s=tag;
   while(*t != '>' && *t != '\0' && *t != ' ')
    {
     *s = *t;
     s++;
     t++;
    }
   *s='\0';

   for(f=0;f<ADR_TAG_ANZ; f++)
    if(strcasecmp(tag,adrTags[f].tag) == 0)
     {
      syncUI->csvImportFields[fnr] = adrTags[f].field;
      syncUI->csvIds[adrTags[f].field] =fnr;
      ofnr =fnr;
      fnr++;
      break;
     }

   if(ofnr>0)
    {
     if(syncUI->csvImportFields[ofnr] == ADR_PDA_PHON_TYPE ||
	syncUI->csvImportFields[ofnr] == ADR_PDA_ADR_TYPE )
      typeFnr= ofnr;
     else
      {
       if(strncasecmp(tag,"PDA_",4) == 0)
	{
	 syncUI->csvImportTypeField[ofnr] = typeFnr;
	}
      }
     if ( *t == ' ')
      {
       while(*t==' '  )
	t++;
       s=tag;
       while(*t != '>' && *t != '\0')
	{
	 *s = *t;
	 s++;
	 t++;
	}
       *s='\0';
       allocateAndCopy(&syncUI->csvImportTypeDefault[ofnr],tag);
      }
     else
      {
       while(*t != '>' && *t != '\0')
	t++;
      }
    }
  }while ( *t != '\0' && fnr <4096);

 syncUI->syncFieldCount = fnr;

//  for(int i=0;i<fnr; i++)
//   printf("%3d: %2d / %s\n",i,syncUI->csvImportFields[i],adrTagName[syncUI->csvImportFields[i]]);


}

// TCL  getSyncParameters
int getSyncParameters (int socket)
{
 int pda,i;
 char buffer[65536],buf2[65536];
 buffer[0]='\0';

 strcat(buffer,"{ ");
 for(pda=0;pda<pdaConfigAnz; pda++)
  {
   strcat(buffer,"{");
   strcat(buffer,pdaConfig[pda].name);
   strcat(buffer,"} ");
  }
 strcat(buffer,"} { ");
 for(pda=0;pda<pdaConfigAnz; pda++)
  {
   sprintf(buf2,"{{%s} {%s} {%s} {%s} {%s}   {%s} {%s} {%s} {%c}  {%s} {%s}  %d %d    {%s} {%s} {%s} {%c} %d     {%s} {%s} {%s} {%c} %d} ",
	   pdaConfig[pda].connectCmd,pdaConfig[pda].connectMsg,pdaConfig[pda].connectHelp,
	   pdaConfig[pda].connectCheckCmd,pdaConfig[pda].disConnectCmd,
	   pdaConfig[pda].adrReadCmd ,pdaConfig[pda].adrWriteCmd ,
	   pdaConfig[pda].adrCsv ,pdaConfig[pda].adrCsvSep ,
	   pdaConfig[pda].defaultCat,pdaConfig[pda].defaultFolder,
	   pdaConfig[pda].adrStartLine, pdaConfig[pda].adrCommonAnz,
	   pdaConfig[pda].todoReadCmd,pdaConfig[pda].todoWriteCmd,
	   pdaConfig[pda].todoCsv,pdaConfig[pda].todoCsvSep,
	   pdaConfig[pda].todoStartLine ,
	   pdaConfig[pda].calReadCmd,pdaConfig[pda].calWriteCmd,
	   pdaConfig[pda].calCsv,pdaConfig[pda].calCsvSep,   
	   pdaConfig[pda].calStartLine);
   strcat(buffer,buf2);
  }
 strcat(buffer,"} { ");
 buf2[0]='\0';
 for (i=0;i<900;i++)
  {
//    if(i<60)
//     printf("at: %3d: %p  %s\n",i,adrTagName[i],adrTagName[i]);
   if (adrTagName[i] != NULL)
    {
     sprintf(buf2,"{ %d { %s }} ",i,adrTagName[i]);
     strcat(buffer,buf2);
    }
  }
 strcat(buffer,"}");
//  printf(">>> adrTags: '%s'\n",buf2);
     
 send2Client(socket,buffer);
}


//TCL openSync Username
int openSync(int socket,char *str)
{
 char *tp[4];
 int anz;
 int tim;
 int uid;
 syncUserInfo *syncUI;

 anz = split(str,tp,4);
 uid = uname2uid(tp[0]);
 tim = (int) time(NULL);

 if(syncCtrl.timeStamp >0)
  {
   if( (tim -syncCtrl.timeStamp) < 15*60) 
    {
     send2Client(socket,"Error: There is another sync process active\nPlease wait until this process is finished or expired\n");
     return true;
    }
  }

 syncCtrl.open      = true;
 syncCtrl.timeStamp = tim;
 syncCtrl.user      = &userList[uid];
 syncUI             = userList[uid].sync;
 syncUI->active     = true;
 syncUI->timeStamp  = tim;
 syncUI->ctrl       = &syncCtrl;

 adrDescrTags=NULL;
 adrDescrTagsAnz=0;

 send2Client(socket,"sync opened");
}

//TCL initSync Username mode type  formatstring pda-entrycount
//1   mode                 = one of 'into' , 'out' ,'inout'
//2   type                 = type of data to stnc (cal,prj,adr)
//3   formatstring         = filename of the csv-format or string conatining the csv-format
//4   csv-separator-key
//5   pda-entrycount       = number of csv-line in the csv-file
// options for type=cal : 
// options for type=prj : 
// options for type=adr : 6  default-folder 
//                        7  default-cat 
//                        8  tag-list(for tagged descr) (Format: { tagInDescr field-tag tagInDescr field-tag ...}
//                        9  customFieldsList         (Format: { field-tag-for-custom1  field-tag-for-custom2 ...}
//                       10  blocked categories (on PDA)
//                       11  blocked folders

int initSync(int socket,char *str)
{
 char *tp[256],*tp2[4096];
 int anz;
 int pdaEntries;
 int tim;
 int uid;
 syncUserInfo *syncUI;
 int l,i,j,k,anz2;

 anz = split(str,tp,255);
 uid = uname2uid(tp[0]);
 if(syncCtrl.user != NULL)
  if( syncCtrl.user->id != uid)
   {
    send2Client(socket,"Error: sync session expired while syncing. Please check the data in your PDA and in Minkowsky\n");
    return(true);
   }

 tim = (int) time(NULL);
 syncCtrl.timeStamp = tim;
 syncUI  =  syncCtrl.user->sync;

 syncUI->timeStamp= tim;


 syncUI->mode = SYNC_OFF;
 if(strncmp(tp[1],"into",4) == 0 )
  syncUI->mode = SYNC_MODE_IN;
 else if(strncmp(tp[1],"out",3) == 0 )
  syncUI->mode = SYNC_MODE_OUT;
 else if(strncmp(tp[1],"inout",5) == 0 )
  syncUI->mode = SYNC_MODE_INOUT;


 syncUI->type = SYNC_OFF;
 if(strncmp(tp[2],"cal",3) == 0 )
  syncUI->type = SYNC_CAL;
 else if(strncmp(tp[2],"prj",3) == 0 )
  syncUI->type = SYNC_PRJ;
 else if(strncmp(tp[2],"adr",3) == 0 )
  syncUI->type = SYNC_ADR;


 allocateAndCopy(&syncUI->format,tp[3]);
 syncUI->csvSep = tp[4][0];
 
 // syncUI->startLine = atoi(tp[4]);
 pdaEntries = atoi(tp[5]);

 // goto initSyncDone;

 if(syncUI->type == SYNC_OFF)
  {
   send2Client(socket,"Error: sync type unkown; closing sync session\n");
   closeSync(uid);
   return(true);
  }

 switch (syncUI->type)
  {
  case SYNC_CAL:
   break;
  case SYNC_PRJ:
   break;
  case SYNC_ADR:
   if(syncUI->mode  == SYNC_MODE_OUT )
    syncUI->csvTmp = new (csvData*) [pdaEntries+1];
   syncUI->csvTmpAnz = 0;
   syncUI->status = new char [adrMax +pdaEntries +16];
   syncUI->status2 = NULL;
   bzero(syncUI->status,sizeof(char) * (adrMax +pdaEntries +15));
   syncUI->syncFieldCount =0;

   if(strcmp(tp[6],"-")==0 )
    syncUI->adr.defaultFolder=0;
   else
    if( (syncUI->adr.defaultFolder = folderName2dirid(tp[6]) ) <0)
     {
      if( (syncUI->adr.defaultFolder = makeAdrFolder(tp[6],-1, 0)) <0)
       {
	char txt[256];
	sprintf(txt,"Error: Can't open or created folder '%s' as default fodler for sync in addresses\n",tp[5]);
	closeSync(uid);
	send2Client(socket,txt);
       }
     }
   
   allocateAndCopy(&syncUI->adr.defaultCategory,tp[7]);
   parseCSVstring(syncUI,syncUI->format);

   // tag-list (tag TAG-name tag tag-Name)
   anz2 = split(tp[8],tp2,255);
   anz2 = anz2 - (anz2 %2);
   if(anz2 > 0)
    {
     adrDescrTags = new  AddressTags [ anz2/2];
     adrDescrTagsAnz = anz/2;
     for(i=0;i<adrDescrTagsAnz ; i++)
      {
       k =i*2;
       strncpy(adrDescrTags[i].tag,tp2[k],31);
       adrDescrTags[i].tag[31]='\0';
       for(j=0;j<ADR_TAG_ANZ;j++)
	if(strcmp(tp2[k+1],adrTags[j].tag)==0)
	 {
	  adrDescrTags[i].field = j;
	  break;
	 }
      }
    }

   anz2 = split(tp[9],tp2,255);
   for(i=0;i<anz2; i++)
    {
     for(j=0;j<10000;j++)
      if(adrTagName[j] != NULL)
       if(strcmp(tp2[i],adrTagName[j])==0)
       {
 	syncUI->adr.customFields[i] = j;
 	break;
       }
    }

   if(tp[10][0] != '-' && tp[10][1] != '\0')
    {
     syncUI->adr.blockedCatStr = new char [ strlen (tp[10])];
     strcpy(syncUI->adr.blockedCatStr,tp[10]);
     anz2 = split(syncUI->adr.blockedCatStr,syncUI->adr.blockedCat, 4095);
     syncUI->adr.blockedCatAnz =anz2;
    } 
   else
    {
     syncUI->adr.blockedCatStr = new char [ 2];
     syncUI->adr.blockedCatStr[0]='\0';
     syncUI->adr.blockedCatAnz =0;
    }
   


   unblockAllAdrFolders();   
   if(tp[11][0] != '-' && tp[11][1] != '\0')
    {
     anz2 = split(tp[11],tp2,255);
     for(i=0;i<anz2; i++)
      {
       int dirid =  folderName2dirid(tp2[i]);
       if(dirid >=0)
	blockFolder(dirid);
      }   
     blockFoldersInBlockedFolders();
     blockAdrInBlockedFolders();
    }

   syncUI->adr.adrAnz=0;
   syncUI->adr.adrNum=-1;
   syncUI->adr.phonAnz=0;
   syncUI->adr.mobileAnz=0;
   syncUI->adr.faxAnz=0;
   syncUI->adr.mailAnz=0;
   syncUI->adr.wwwAnz=0;
   syncUI->adr.phonPrivAnz=0;
   syncUI->adr.mobilePrivAnz=0;
   syncUI->adr.faxPrivAnz=0;
   syncUI->adr.mailPrivAnz=0;
   syncUI->adr.wwwPrivAnz=0;

   clearAdrSyncTemp(uid);
   break;
  }
 send2Client(socket,"inti sync done");
}
// syncInto username 'csv-string'
int syncInto (int socket, char *str)
{
 int anz,uid;
 syncUserInfo *syncUI;
 char *tp[256];
 int doImport=true;



 anz = split(str,tp,255);
 uid = uname2uid(tp[0]);
 if(syncCtrl.user != NULL)
  if( syncCtrl.user->id != uid)
   {
    send2Client(socket,"Error: sync session expired while syncing. Please check the data in your PDA and in Minkowsky\n");
    return(true);
   }

 if(syncCtrl.user->sync->mode  ==  SYNC_MODE_OUT)
  doImport =false;

 switch (syncCtrl.user->sync -> type)
  {
  case SYNC_CAL:
   break;
  case SYNC_PRJ:
   break;
  case SYNC_ADR:
   return(syncAdrInto(socket,syncCtrl.user->sync,tp[1],doImport));
   break;
  default:
   send2Client(socket,"Error Unknown sync mode");
   closeSync(uid);
   break;
  }
}

// TCL syncInStop username
int syncIntoStop (int socket, char *str)
{
 int anz,uid;
 syncUserInfo *syncUI;
 char *tp[256];

 anz = split(str,tp,255);
 uid = uname2uid(tp[0]);
 if(syncCtrl.user != NULL)
  if( syncCtrl.user->id != uid)
   {
    send2Client(socket,"Error: Sync session expired while syncing. Please check the data in your PDA and in Minkowsky\n");
    return(true);
   }

 syncUI = syncCtrl.user->sync;
 syncUI->listPtr = -1;
 syncUI->tempPtr = 0;
 send2Client(socket,"done");
}


// TCL nextCsv usernane
int getNextCsvFromServer(int socket, char *str)
{
 int anz,uid;
 syncUserInfo *syncUI;
 char *tp[256],*csv;
 csvData *cd;
 char fromTemp=false;


 anz = split(str,tp,255);
 uid = uname2uid(tp[0]);
 if(syncCtrl.user != NULL)
  if( syncCtrl.user->id != uid)
   {
    send2Client(socket,"Error: sync session expired while syncing. Please check the data in your PDA and in Minkowsky\n");
    return(true);
   }

 syncUI = syncCtrl.user->sync;

 if(! fromTemp)
  {
   switch (syncCtrl.user->sync -> type)
    {
    case SYNC_CAL:
     break;
    case SYNC_PRJ:
     break;
    case SYNC_ADR:
     if( (cd = getnextAdrListCsv(uid,syncUI)) == NULL)
      if(syncUI->mode == SYNC_MODE_OUT)
       fromTemp = true;
     break;
    }
  }
 if(fromTemp)
  {
   if(syncUI->tempPtr < syncUI->csvTmpAnz)
    {
     cd = syncUI->csvTmp[syncUI->tempPtr];
     syncUI->tempPtr++;
    }
   else
    cd=NULL;
  }
 
 if( cd ==  NULL)
  {
   send2Client(socket,"done");
   return(true);
  }
 
 csv = concatCsv(cd,syncUI->csvSep);
 send2Client(socket,csv);
}
//TCL endSync Username
int endSync(int socket,char *str)
{
 char *tp[4];
 int anz;
 int tim;
 syncUserInfo *syncUI;
 int expired =false;
 int cleaning =false;
 int uid;

 anz = split(str,tp,4);
 uid = uname2uid(tp[0]);
 tim = (int) time(NULL);

 if(!syncCtrl.open)
  expired=true;
 if(syncCtrl.user == NULL)
  expired=true;
 else
  {
   if( syncCtrl.user->id != uid)
    expired=true;
   else if(!syncCtrl.user->sync->active)
    {
     expired=true;
     cleaning =true;
    }
  }
 if(expired)
  {
   send2Client(socket,"Error: sync session expired while syncing. Please check the data in tyour PDA and in Minkowsky\n");
   if(! cleaning)
    return(true);
  }
 
 syncUI             = userList[uid].sync;
 switch (syncUI->type)
  {
  case SYNC_CAL:
   syncUI->lastCalSync =tim;
   break;
  case SYNC_PRJ:
   syncUI->lastPrjSync =tim;
   break;
  case SYNC_ADR:
   clearAdrSyncTemp(uid);
   syncUI->lastAdrSync =tim;
   if(adrDescrTags != NULL)
    delete adrDescrTags;
   adrDescrTags =NULL;
   adrDescrTagsAnz=0;
   writeAdrFolderList();
   writeAdrList();
   break;
  }
 
 if(syncUI->status != NULL)
  {
   delete syncUI->status;
   syncUI->status = NULL;
  }
 if(syncUI->status2 != NULL)
  {
   delete syncUI->status2;
   syncUI->status2 = NULL;
  }
 syncUI->type = SYNC_OFF;

 if(!expired)
  send2Client(socket,"sync terminated");
 return true;
}

//TCL closeSync Usernamemake
int closeSync(int socket,char *str)
{
 char *tp[4];
 int anz;
 int uid;
 int ret;

 anz = split(str,tp,4);
 uid = uname2uid(tp[0]);
 if(! closeSync(uid))
   send2Client(socket,"Error: sync session expired while syncing. Please check the data in tyour PDA and in Minkowsky\n");
 else
  send2Client(socket,"sync closed");
 return true;
   
 
}


int closeSync(int uid)
{
 int tim;
 syncUserInfo *syncUI;
 int expired =false;
 int cleaning =false;


 tim = (int) time(NULL);

 if(!syncCtrl.open)
  expired=true;
 if(syncCtrl.user == NULL)
  expired=true;
 else
  {
   if( syncCtrl.user->id != uid)
    expired=true;
   else if(!syncCtrl.user->sync->active)
    {
     expired=true;
     cleaning =true;
    }
  }
 if(expired)
  {
   //   send2Client(socket,"Error: sync session expired while syncing. Please check the data in tyour PDA and in Minkowsky\n");
   if(! cleaning)
    return(-1);
    //    return(true);
  }

 syncUI = syncCtrl.user->sync;
 if(syncUI->mode  == SYNC_MODE_OUT )
  {
   for(int i=0; i<syncUI->csvTmpAnz ; i++)
    destroyCsvDataStruct(syncUI->csvTmp[i]);
   delete syncUI->csvTmp;
  }

 switch (syncUI->type)
  {
  case SYNC_CAL:
   break;
  case SYNC_PRJ:
   break;
  case SYNC_ADR:
   break;
  }
 syncUI             = userList[uid].sync;
 syncUI->timeStamp  = 0;
 syncUI->active     = false;
 syncUI->ctrl       = NULL;
 syncUI->type       = SYNC_OFF;
 syncUI->syncFieldCount =0;
 if(syncUI->status != NULL)
  delete syncUI->status;
 if(syncUI->status2 != NULL)
  delete syncUI->status2;
 syncCtrl.user      = NULL;
 syncCtrl.timeStamp = 0;
 syncCtrl.open      = false;


//  if(!expired)
//   send2Client(socket,"sync closed");
 return true;
}



// char *endOfCsvEntry(char *t,char sep)
// {
 
//  while(*t != '\0' )
//   {
//    if(t[0] == '\0')
//     return NULL;
//    if(t[0] == sep)
//     if(t[-1] != '\\' )
//      {
//       *t='\0';
//       if (t[-1] == '"')
//        if(t[-2] != '\\')
// 	t[-1] == '\0';
//       return(t);
//      }
//    t++;
//   }
//  return NULL;
// }

