// File: sync.h
// 
//      This file is part of minkowsky
// 
//      Copyright (C) 2001-2002 by Rdiger Goetz
//      Author: Rdiger Goetz <minkowsky@r-goetz.de>
// 
//      Time-stamp: <27-Oct-2002 11:20:43 goetz>
// 
//      This program is free software; you can redistribute it and/or modify
//      it under the terms of the GNU General Public License as published by
//      the Free Software Foundation; either version 2 of the License, or
//      (at your option) any later version.
// 
//      This program is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU General Public License for more details.
// 
//      You should have received a copy of the GNU General Public License
//      along with this program; if not, write to the Free Software
//      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//  

# ifndef SYNC_H_INCLUDED
# define SYNC_H_INCLUDED

#ifdef SYNC
#define SYNC_EXTERN
#else
#define SYNC_EXTERN extern
#endif

typedef struct 
{
 char *name;
 char *connectCmd;
 char *connectCheckCmd;
 char *connectMsg;
 char *connectHelp;
 char *disConnectCmd;
 char *adrReadCmd;
 char *adrWriteCmd;
 char *adrCsv;
 char  adrCsvSep;
 int   adrStartLine;
 int   adrCommonAnz;
 char *defaultFolder;
 char *defaultCat;
 char *todoReadCmd;
 char *todoWriteCmd;
 char  todoCsvSep;
 char *todoCsv;
 int   todoStartLine;
 char *calReadCmd;
 char *calWriteCmd;
 char *calCsv;
 char  calCsvSep;
 int   calStartLine;
} PDAconfig;


typedef struct
{
 int id;
 char *tag;
} pdaDataTypes;
SYNC_EXTERN PDAconfig *pdaConfig;
SYNC_EXTERN int pdaConfigAnz;

#define PDA_TYPE_OTHER  0
#define PDA_TYPE_MAIN   1
#define PDA_TYPE_HOME   2
#define PDA_TYPE_WORK   3
#define PDA_TYPE_FAX    4
#define PDA_TYPE_EMAIL  5
#define PDA_TYPE_MOBILE 6
#define PDA_TYPE_PAGER  7
#define PDA_TYPE_URL    8
#define PDA_TYPE_HOMEFAX     9
#define PDA_TYPE_HOMEMAIL   10
#define PDA_TYPE_HOMEMOBILE 11
#define PDA_TYPE_HOMEURL    12
#define PDA_DATA_TYPE_ANZ 13
#ifndef SYNC
extern pdaDataTypes pdaDataType[PDA_DATA_TYPE_ANZ];
#else
pdaDataTypes pdaDataType[PDA_DATA_TYPE_ANZ] =
 {
  { PDA_TYPE_OTHER,   "other"},
  { PDA_TYPE_MAIN,    "main"},
  { PDA_TYPE_HOME,    "home"},
  { PDA_TYPE_WORK,    "work"},
  { PDA_TYPE_FAX,     "fax"},
  { PDA_TYPE_EMAIL,   "e-mail"},
  { PDA_TYPE_MOBILE,  "mobile"},
  { PDA_TYPE_PAGER,   "pager"},
  { PDA_TYPE_URL,     "URL"},
  { PDA_TYPE_HOMEFAX, "Home-FAX"},
  { PDA_TYPE_HOMEMAIL,"Home-e-mail"},
  { PDA_TYPE_HOMEMOBILE,"Home-mobile"},
  { PDA_TYPE_HOMEURL, "Home-URL"}
 };
#endif

#ifdef PRV
#define SYNC_CAL_IN  0x11
#define SYNC_CAL_OUT 0x12
#define SYNC_CAL_BI  0x13
#define SYNC_PRJ_IN  0x21
#define SYNC_PRJ_OUT 0x22
#define SYNC_PRJ_BI  0x23
#define SYNC_ADR_IN  0x41
#define SYNC_ADR_OUT 0x42
#define SYNC_ADR_BI  0x43

typedef struct {
 User *user;
 int  open;
 int  type;
 int  timeStamp;
} syncControl;

typedef struct {
 syncControl *ctrl;
 int active;
 int type;
 int timeStamp;
 int lastCalSync;
 int lastPrjSync;
 int lastAdrSync;
 int syncFieldCount;
 int csvImportFields[256]
} syncUserInfo;
#endif
# endif
