//  File: todo.h
// 
//      This file is part of minkowsky
// 
//      Copyright (C) 2001-2002 by Rdiger Goetz
//      Author: Rdiger Goetz <minkowsky@r-goetz.de>
// 
//      Time-stamp: <26-Aug-2002 17:40:43 goetz>
// 
//      This program is free software; you can redistribute it and/or modify
//      it under the terms of the GNU General Public License as published by
//      the Free Software Foundation; either version 2 of the License, or
//      (at your option) any later version.
// 
//      This program is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU General Public License for more details.
// 
//      You should have received a copy of the GNU General Public License
//      along with this program; if not, write to the Free Software
//      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//  


//    set TODOstati "DONE NEW OPEN KILL WAIT  HOLD WIP DELAY"
#define TODO_STAT_DONE  0
#define TODO_STAT_NEW   1
#define TODO_STAT_OPEN  2
#define TODO_STAT_KILL  3
#define TODO_STAT_WAIT  4
#define TODO_STAT_HOLD  5
#define TODO_STAT_WIP   6
#define TODO_STAT_DELAY 7


//  set depType "ONWIP ONDELAY ONDONE ONKILL ONHOLD ONCOMPL ONMILES"
#define TODO_DEP_ONWIP   0
#define TODO_DEP_ONDELAY 1
#define TODO_DEP_ONDONE  2
#define TODO_DEP_ONKILL  3
#define TODO_DEP_ONHOLD  4
#define TODO_DEP_ONCOMPL 5
#define TODO_DEP_ONMILES 6

#define TODO_RO 0
#define TODO_RW 1
#define TODO_RWD 3
#define TODO_W 1
#define TODO_D 2

#define TODO_SEND_LO 3  // SENT list only
#define TODO_SEND_RO 2 
#define TODO_SEND 1
#define TODO_SEND_DEL 4
#define TODO_SEND_NOT 0

#define TODO_GROUP_ALLG -2
#define TODO_GROUP_PRIVAT -3

#define TODO_IN_PROJ 1
#define TODO_FREE 0

#define TODOS_PER_PROJ 128

typedef struct
{
 int status;
 char titel[128];
 int complete;
} MileStone;

typedef struct
{
 int id;
 int last;
 int perm;  
}UserInTodo;

typedef struct 
{
 int id;
 char descr [2048];
 int tlen;
 int startDate,stopDate;
 int status;
 int complete;
 int dring;
 int dringDynam;
 MileStone miles[8];
 int init;
 int uanz;
 UserInTodo user[128];
 int remAnz;
 Reminder reminder[100];
 int deleted;
 int group;
 int tmp;                 // temporrer Wert beim senden benuzt
 int tmp2;
 int selected;
 NotizControl *notiz;
 int reserved[15];
} TodoItem;

typedef struct 
{
 int id;
 char descr [2048];
 int tlen;
 int startDate,stopDate;
 int status;
 int complete;
 int dring;
 int dringDynam;
 MileStone miles[8];
 int init;
 int uanz;
 UserInTodo user[128];
 int remAnz;
 Reminder_0400 reminder[512];
 int deleted;
 int group;
 int tmp;                 // temporrer Wert beim senden benuzt
 int tmp2;
} TodoItem_0400;


typedef struct
{
 int tid;
 int type;
 int val;
}ToDoDepend;

typedef struct
{
 int tid;
 int anz;
 ToDoDepend dep[32];
 int lvl;
}ToDoInProj;

typedef struct
{
 int init;
 int id;
 char descr [4096];
 int tlen;
 int open;
 int stopDate;
 int status;     // wird beim setzen as den Stati der Todos ermittelt
 int uanz;
 UserInTodo user[512];
 int tanz;
 ToDoInProj todo[TODOS_PER_PROJ];
 int group;
 int deleted;
 int tmp;
 int selected;
 int isSubProject;
 NotizControl *notiz;
 int reserved[14];
} Project;
typedef struct
{
 int init;
 int id;
 char descr [4096];
 int tlen;
 int open;
 int stopDate;
 int status;     // wird beim setzen as den Stati der Todos ermittelt
 int uanz;
 UserInTodo user[512];
 int tanz;
 ToDoInProj todo[128];
 int group;
 int deleted;
 int tmp;
} Project_0400;


typedef struct
{
 int id;  // ID des Eigentmers
 int anz;
 int max;
 TodoItem **list;
}TodoList;
typedef struct
{
 int id;  // ID des Eigentmers
 int anz;
 int max;
 Project **list;
}ProjectList;

#ifdef ____TODO
#define __EXTERN
#else
#define __EXTERN extern
#endif
__EXTERN TodoItem **todoList;
__EXTERN Project **projList;
__EXTERN int todoAnz,todoBlocks,todoMax;
__EXTERN int projAnz,projBlocks,projMax;
__EXTERN int lastPid, lastTid;
__EXTERN int lastProjTODOchange;
#undef __EXTERN


void initTodoList();
void clearTodoList ();
void extendTodoList();
void initProjList();
void clearProjList ();
void extendProjList();
int readTodoList();
int writeTodoList();
int readProjList();
int writeProjList();
int changeToDo(int socket,char *ds);

int changeToDo(int socket,char *ds);
int changeProject(int socket,char *ds);
int sendTodo(int socket,char *str);
int sendProject(int socket,char *str);
int sendProjectAndTodoLists(int socket,char *str);
int getLastProjTodoChange(int socket);
int deleteTodo(int socket, char *str);
int deleteProject(int socket, char *str);
int changeTodoStatus(int socket, char *str);
