#! /bin/sh 

_LANG=`echo $LANG|cut -c-2`

if [ "$_LANG" == "de" ]
then
    echo
    echo "STARTE MINKOWSKY-SERVER-INSTALLTION"*
    echo
else
    echo
    echo "STARTING MINKOWSKY-SERVER-INSTALATION"*
    echo
fi 

CONFIG_FILE=/etc/minkowsky
DEVEL=0
DEBUG_RC=0
TMP_PATH=/tmp/minkowsky.d

#echo "args: $*"
if [ $# -gt 0 ]
then
    if [ "$1" == "-d" ]
    then
	CONFIG_FILE=$HOME/.minkowsky.devel
	DEVEL=1
	DPORT=42001
    fi
    if [ "$1" == "-drc" ]
    then
	CONFIG_FILE=/etc/minkowsky
	DEBUG_RC=1
    fi
fi


if [ "$_LANG" == "de" ]
then
    echo "Minkowsky sollte nicht unter root laufen, sondern unter einem eigenen User"
    echo "    ( Falls ein solcher User noch nicht existiert, sollte er jetzt"
    echo "      angelegt werden. Es empfiehlt sich ihn 'minkowsky' zu nennen"
    echo "      und ausserdem eine Gruppe dieses Names fr ihn anzulegen.)"
    echo "Wie heisst der User unter dessen Namen der Minkwosky-Server"
    echo -n "laufen soll: [minkowsky] ? "
else
    echo "It is not advisable to run the Minkowsky server as root process, but"
    echo "as another users process, preferably a special user for that purpose)"
    echo "    ( If no such user already exists, its now a good time to create one"
    echo "      I suggest to name the account 'minkowsky'"
    echo "      and to create a group 'minkowsky', as well)"
    echo "What's the name of the user who should run the"
    echo -n "Minkowsky server process: [minkowsky] ? "
fi

read muser
if [ "$muser" == "" ]
then
    muser=minkowsky
fi

id $muser  2>1 >/dev/null
if [ $? != 0 ]
then
    if [ "$_LANG" == "de" ]
    then
	echo
	echo "ERROR"
	echo " Der User '$muser' existiert noch nicht"
	echo " Bitte legen Sie ihn an, und starten den installer neu"
	echo " der versuchen Sie es mit einem anderen User noch einmal"
	echo
	exit
    else
	echo
	echo "ERROR"
	echo " The user '$muser' doesn't exists"
	echo " Please create it and restart the installer again."
	echo " Or retry the instalation with another account name."
	echo
	exit
    fi
fi
echo



if [ -f $CONFIG_FILE ]
then
    echo "reading old config"
    INST_PATH=`cat $CONFIG_FILE |grep SERVER_BIN_PATH  |gawk '{print $2}'  |sed -e 's/\/server$//' `
    if [ "$INST_PATH" == "" ]
    then
	if [ $DEVEL -eq 0 ]
	then
	    INST_PATH="/opt/minkowsky"
	else
	    INST_PATH="$HOME/minkowsky"
	fi
    fi
    DEF_DATA_DIR=`cat $CONFIG_FILE |grep TERMIN_DATA_PATH  |gawk '{print $2}'`
    if [ "$DEF_DATA_DIR" == "" ]
    then
	if [ "$INSTALL_PATH" == "" ]
	then
	    DEF_DATA_DIR="/var/minkowsky/share"
	else
	    DEF_DATA_DIR="$INSTALL_PATH/share"
	fi
    fi
    COMPA=`cat $CONFIG_FILE |grep COMPANY | sed -e 's/COMPANY *//'`
    REP=`cat $CONFIG_FILE |grep REPLY_ADDRESS  | sed -e 's/REPLY_ADDRESS  *//'`
else
    if [ $DEVEL -eq 0 ]
    then
	INST_PATH=`bash -c "ls -d ~$muser"`
	DEF_DATA_DIR="$INST_PATH/share"
	COMPA=""
	REP=""
    else
	INST_PATH="$HOME/minkowsky"
	DEF_DATA_DIR="$INST_PATH/share"
	COMPA="Minko-Test-Server"
	REP=""
    fi
fi





echo -n "Installation-Pfad [$INST_PATH]   "
read ans
if [ "$ans" == "" ]
then
    INSTALL_PATH=$INST_PATH
else
    INSTALL_PATH=$ans
fi

if [ "$_LANG" == "de" ]
then
    echo
    echo -n "Wo sollen die Termine usw. abgelegt werden? [$DEF_DATA_DIR] "
else
    echo
    echo "On which path do you wish to store the "
    echo -n "appointments etc data? [$DEF_DATA_DIR] "
fi

read ans
if [ "$ans" == "" ]
then
    DATA_DIR=$DEF_DATA_DIR
else
    DATA_DIR=$ans
fi

if [ "$_LANG" == "de" ]
then
    echo
    echo "In Einladungs und Erinnerungmails, die von Minkowsky"
    echo "verschickt werden erscheint u.a. der Name der desjenigen"
    echo "bei dem Minkwosky luft. Die kann der Name der Firma sein,"
    echo "oder auch der Name der Familie auf dessen Privatrechener"
    echo "Minkowsky luft. Dieser Text kann jederzeit in der:"
    echo "Konfiguartionsdatei $CONFIG_FILE gendert werden." 
    echo -n "Welcher Text soll als Absender erscheinen: [$COMPA]  "
else
    echo
    echo "Minkowsky will send Mails as invitation and reminders"
    echo "This mails may contain the name of your organization (see"
    echo "Administration guide for details)."
    echo "You may change this text later in /etc/minkowsky"
    echo -n "What text do you wish to see as senders name: [$COMPA]  "
fi
read COMPANY
if [ "$COMPANY" == "" ]
then
    COMPANY=$COMPA
fi

if [ "$_LANG" == "de" ]
then
    echo
    echo "Welcher Address soll bei Erinnerungsmails als"
    echo  -n "Reply addresse angegeben werden: [$REP] "
else
    echo
    echo "Which e mail address should be used as Reply address in mails"
    echo  -n "automatically by the Minkowsky server: [$REP] "
fi
read REPLY
if [ "$REPLY" == "" ]
then
    REPLY=$REP
fi

if [ $DEVEL -eq 1 ]
then
    if [ "$_LANG" == "de" ]
    then
	echo
	echo "Auf welchem Port soll der die Entwicklerversion"
	echo -n "von Minkowsky lauschen (41999 ist verboten) [$DPORT] ?"
    else
	echo
	echo "On which port should the developmental version"
	echo -n "listen  (port 41999 is not allowed) [$DPORT] ?"
    fi
    read ans
    if [ "$ans" != "" ]
    then
	DPORT=$ans
    fi
    if [ $DPORT -eq 41999 ]
    then 
	DPORT=0
    fi
    if [ $DPORT -le 1024 ]
    then 
	DPORT=0
    fi
    while [ $DPORT == 0 ]
    do
	DPORT=42001
	if [ "$_LANG" == "de" ]
	then
	    echo "Der Port muss oberhalb von 1024 liegen  und"
	    echo "darf nicht 41999 sein (um Konflickte mit der"
	    echo -n "regulren Verion zu vermeiden, also [$DPORT]: "
	else
	    echo "The port must be above of 1024 and must not be"
	    echo "41999 to avoid conflicts with productive versions"
	    echo -n "of Minkowsky. Hence which port:[$DPORT]: "
	fi
	read ans
	if [ "$ans" != "" ]
	then
	    DPORT=$ans
	fi
	if [ $DPORT -eq 41999 ]
	then 
	    DPORT=0
	fi
	if [ $DPORT -le 1024 ]
	then 
	    DPORT=0
	fi
    done
fi



$INSTALL_PATH=$1
$DATA_DIR=$2
$COMPANY=$3
muser=$4
$REPLY="$muser"
DEVEL=0



cd ..

echo
echo "creating Makefile"

cp /dev/null Makefile
echo "INSTALL_PATH=$INSTALL_PATH/server" >Makefile
echo "DOCU_DIR=$INSTALL_PATH/server/docu" >>Makefile
echo "MASTERPORT=41999" >>Makefile
echo >>Makefile
cat unixX11/Makefile.base >>Makefile







echo
echo "Compling Server"|
echo


make install-tmp TMP_INST_PATH=$TMP_PATH STARTSCRIPT=$STARTSCRIPT



echo
echo "making Configuration-file"

cp /dev/null /tmp/minkowsky
if [ -f $CONFIG_FILE ]
then
    cat $CONFIG_FILE |egrep  "^MINKO" > /tmp/minkowsky
else
    touch /tmp/minkowsky
fi

#cat /tmp/minkowsky


echo SERVER_BIN_PATH $INSTALL_PATH/server >>/tmp/minkowsky
echo DATA_PATH $DATA_DIR >>/tmp/minkowsky
echo SERVER_USER $muser >>/tmp/minkowsky
echo 
if [ "$COMPANY" != "" ]
then
    echo COMPANY $COMPANY>>/tmp/minkowsky
fi
echo MYSELF Minkowsky Raum/Zeit-Verwaltung >>/tmp/minkowsky
echo "REPLY_ADDRESS $REPLY"  >>/tmp/minkowsky

if [ $DEVEL -eq 1 ]
then
    echo "DEVELSERVER 1"  >>/tmp/minkowsky
fi

if [ $DEBUG_RC == 0 ]
then
    echo "DEBUG_SERVER" >> /tmp/minkowsky
fi


if [ "$_LANG" == "de" ]
then
    echo
    echo
    echo "Die Installation des init-Skriptes und des globalen"
    echo "Konfigurationsfile muss von root-vorgenommen werden"
    echo "Der Installer ruft nun eine Skript das dies tut."
    echo "Bitte geben sie das root-passwort ein:"
    echo "  (Falls sie dem Installer mistrauen knnen sie"
    echo "   selbstverstndlich die Sourcen einsehen. Es sind"
    echo "   einfache Shellskripte. Sie finden sie unter"
    echo "   unixX11/installer.sh und scripts/installRC.sh)"
else
    echo
    echo
    echo "The installation of the init script in /etc/rc.d and of"
    echo "the central configuration file must be done as root."
    echo "The installer will now call a script to do this."
    echo "Please enter your root password:"
    echo "  (In case you don't trust the installer you may want to"
    echo "   inspect this scripts. They are simple shells scripts. You"
    echo "   find them on unixX11/installer.sh and scripts/installRC.sh)"
fi

    su -c "scripts/installRC.sh rc.minkowsky /tmp/minkowsky $muser $DATA_DIR"


if [ "$USER" != "$muser" ]
then
    if [ "$_LANG" == "de" ]
    then
	echo
	echo "Der Rest muss nun als User $muser installiert werden"
	echo "geben sie bitte das Passwort von $muser ein."
    else
	echo
	echo "The final part of the instalation must be done as $muser"
	echo "Please enter $musers's password"
	echo "(Again you may inspect the script on scripts/completeInstall.sh)"
    fi
    cp scripts/completeInstall.sh /tmp/completeInstall.sh
    chmod a+rx /tmp/completeInstall.sh
    su -m -c "/tmp/completeInstall.sh $DEVEL  $DATA_DIR $TMP_PATH $STARTSCRIPT" - $muser
    rm /tmp/completeInstall.sh
    echo
else
    scripts/completeInstall.sh $DEVEL $DATA_DIR $TMP_PATH $STARTSCRIPT
fi

make remove-tmp TMP_INST_PATH=$TMP_PATH

if [ "$_LANG" == "de" ]
then
    echo
    echo
    echo "Installation des Minkowsky-Servers abgeschlossen"
    echo
else
    echo
    echo
    echo "Installation of the Minkowsky server is complete"
    echo
fi
exit
