// File: unsplitCsv.cc
// 
//      This file is part of minkowsky
// 
//      Copyright (C) 2001-2002 by Rdiger Goetz
//      Author: Rdiger Goetz <minkowsky@r-goetz.de>
// 
//      Time-stamp: <26-Oct-2002 15:02:56 goetz>
// 
//      This program is free software; you can redistribute it and/or modify
//      it under the terms of the GNU General Public License as published by
//      the Free Software Foundation; either version 2 of the License, or
//      (at your option) any later version.
// 
//      This program is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU General Public License for more details.
// 
//      You should have received a copy of the GNU General Public License
//      along with this program; if not, write to the Free Software
//      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//  
# include <stdio.h>
# include <stdlib.h>
# include <string.h>
# include <math.h>
# include <unistd.h>
#include "unsplitCsv.h"

static char *buf=NULL;
static int buflen=0;

csvData *newCsvDataStruct(int len, int anz)
{
 return(newCsvDataStruct(anz));
}
csvData *newCsvDataStruct( int anz)
{
 csvData *cd;
#ifdef WITH_CLASS
 cd = new csvData (anz);
#else
 printf("new csv strcut\n");
 cd       = new csvData;
 cd->cols = anz;
 cd->col  = new (char *) [anz+1];
 for(int i=0; i<cd->cols ; i++)
  cd->col[i] = NULL;

 char *tst = new char [256];
#endif
 return cd;
}

void destroyCsvDataStruct(csvData *cd)
{
 printf("deleting CSVstruct at %p\n",cd);
#ifndef WITH_CLASS
 for(int i=0; i<cd->cols ; i++)
  if(cd->col[i] != NULL)
   {
    delete cd->col[i];
    cd->col[i] = NULL;
   }
 delete cd->col;
#endif
 delete cd;
}

csvData * unsplitCsv(char *str,int anz,char sep)
{
#ifdef WITH_CLASS
 csvData *cd = new csvData;
 cd->init(anz);

 if(cd== NULL)
  return NULL;

 if(cd->unsplit(str,sep))
  return cd;
 return NULL;
#else
 csvData *cd;
 int len = strlen(str);
 char *t,*s,*n;
 int c=0,l;
 char *tmp;

 
 tmp = new char [len+2];
 memcpy(tmp,str,sizeof(char)*(len+1));
 tmp[len] ='\0';

 cd = newCsvDataStruct(anz);


 t=tmp;
 while(t[len-1] == '\n')
  {
   t[len-1] = '\0';
   len --;
   if(len <=0)
    break;
  }
 
 do
  {
   s = endOfCsvEntry(t,sep);
   if(s !=NULL)
    *s='\0';
   if(buf == NULL)
    {
     buf = new char [256];
     buflen=256;
    }

   n = unquoteSpecialChars(t,sep);
   allocateAndCopy(cd,c,n);
   c++;
   if(c>= anz)
    break;
   t = s+1;
  }while(s != NULL);
 
 cd ->filled =c;
 delete tmp;
 return cd;
#endif
}
char *concatCsv(csvData *cd,char sep)
{
#ifdef WITH_CLASS
 char *str;

 str = cd->concatCsv(sep);
 return(str);
#else
 char *n;
 char *str,*t;
 int len,l;
 int max;
 int i;

 str = new char [16384];
 max= 16384;
 len =0;

 *str='\0';
 for(i=0;i<cd->cols; i++)
  {
   if(cd->col[i]!=NULL)
    n=quoteSpecialChars(cd->col[i],sep);
   else
    n="";
   l= strlen(n);
   while(l+len+8 > max)
    {
     t = new char [max+8192];
     memcpy(t,str,max);
     delete str;
     str=t;
     max += 8192;
    }
   if(i>0)
    {
     str[len]=sep;
     len++;
     str[len]='\0';
    }
//    str[len]='"';
//    len++;
   strcat(str,n);
   len += l;
//    str[len]='"';
//    len++;
  }
 return(str);
}

void clearCsvData(csvData *cd)
{
 for(int i=0;i<cd->cols; i++)
  {
   if(cd->col[i] != NULL)
    delete cd->col[i];
   cd->col[i] =NULL;
  }
}
char *endOfCsvEntry(char *t, char sep)
{
 int qc=0,dqc=0;

 while( *t != '\0')
  {
   if(t[0] == '\0')
    return NULL;
   
   if(t[0] == '\\' )
    {
     if( t[1] == '"' || t[1] == '\'' || t[1] == '\\' || t[1] == sep || t[1] == 'n' || t[1] == 't')
      {
       t+=2;
       continue;
      }
    }

   if(t[0] == '"' )
    dqc ^= 1;
   if(t[0] == '\'' )
    qc ^= 1;

   if(dqc==0 && qc==0)
    if(t[0] == sep)
     return t;
   
   t++;
  }
 return NULL;
}


char * quoteSpecialChars(char *t,char sep)
{
 static char *buf =NULL;
 static int buflen=0;
 int l;
 int rep=false;
 char *s,*d;


 
 l =strlen(t)+1;
 if(2*l>buflen)
  {
   if(buf != NULL)
    {
     printf("qsc: resize buffer %d -> %d\n", buflen, 2*l);
     delete buf;
    }
   buflen=2*l;
   buf = new char [2*l];
  }
 d=buf;

 for(s =t; *s !='\0'; s++)
  {
   if( *s == '"' || *s == '\'' || *s == '\\' || *s == sep)
    {
     *d='\\';
     d++;
     *d=*s;
     rep=true;
    }
   else if (*s=='\n')
    {
     *d='\\';
     d++;
     *d='n';
     rep=true;     
    }
   else if (*s=='\t')
    {
     *d='\\';
     d++;
     *d='t';
     rep=true;     
    }
   else 
    *d=*s;
   d++;
  }
 *d='\0';

 if(rep)   
   return buf;

 return t;
#endif
}

char * unquoteSpecialChars(char *t,char sep)
{
//  static char *buf =NULL;
//  static int buflen=0;
 int l;
 char *s,*d;
 int rep;

 l =strlen(t)+1;
 if(2*l>buflen)
  {
   if(buf != NULL)
    {
     printf("uqc: resize buffer %d -> %d\n", buflen, 2*l);
     delete buf;
    }
   buflen=2*l;
   buf = new char [2*l];
  }
 d=buf;


 rep=false;
 s=t;
 for(s =t; *s !='\0'; s++)
  {
   int skip=false;
   if(s[0]=='\\')
    {
     if( s[1] == '"' || s[1] == '\'' || s[1] == sep  )
      {
       rep=true;
       s++;
      }
#ifdef MINKOWSKY
     else if (s[1] == '\\')
      {
       rep=true;
       s++;
       skip=true;
      }
#else
     else if (s[1] == '\\')
      {
       rep=true;
       s++;
      }
#endif
     else if (s[1] == 'n')
      {
       rep=true;
       s++;
       *d='\n';
       d++;
       continue;
      }
     else if (s[1] == 't')
      {
       rep=true;
       s++;
       *d='\t';
       d++;
       continue;
      }
    }
   if( !skip)
    {
     *d=*s; 
     d++;
    }
  }
 *d='\0';
 if(rep)
  return buf;
 return t;
}

void allocateAndCopy(csvData *cd, int fnr, char *s)
{
 if(s != NULL)
  {
   int l =strlen(s);
   char *t = cd->col[fnr];
 
   
   if(t != NULL)
    {
     //    printf("!!!>>>>>>>  removing old memory (cd<-s) <<<<<<<<<<<<\n");
     delete t;
    }
   t = new char [l+2];
   strncpy(t,s,l+2);
   t[l] ='\0';
   
   cd->col[fnr] = t;
  }
}
void allocateAndCopy(csvData *cd, int fnr, char s)
{
 char *t = cd->col[fnr];
 
  
 if(t != NULL)
  {
//    printf("!!!>>>>>>>  removing old memory (cd<-c) <<<<<<<<<<<<\n");
   delete t;
  }
 t = new char [2];
 t[0] = s;
 t[1] ='\0';

 cd->col[fnr] = t;
}
void allocateAndCopy(csvData *cd, int fnr, int v)
{
 char *t = cd->col[fnr];
 
  
 if(t != NULL)
  {
//    printf("!!!>>>>>>>  removing old memory (cd<-i) <<<<<<<<<<<<\n");
   delete t;
  }
 t = new char [16];
 sprintf(t,"%d",v);
 cd->col[fnr] = t;
}

void allocateAndCopy(csvData *cd, void*  fnrp, char *s)
{
 if(s != NULL)
  {
   int fnr = *((int *) fnrp);
   int l =strlen(s);
   char *t = cd->col[fnr];
   
   if(t != NULL)
    {
     //    printf("!!!>>>>>>>  removing old memory  (cd<-&i) <<<<<<<<<<\n");
     delete t;
    }
   t = new char [l+2];
   strncpy(t,s,l+2);
   t[l] ='\0';
   
   cd->col[fnr] = t;
  }
}

void allocateAndCopy(char **t, char *s)
{
 char *e;
 
 if(s != NULL)
  {

   int l =strlen(s);
   
   if(*t != NULL)
    {
     //    printf(">>>>>>>>>>  removing old memory (s<-s) <<<<<<<<<<<<\n");
     delete *t;
    }
   
   *t = new char [l+2];
   e = *t;
   strncpy(*t,s,l+2);
   e[l] ='\0';
  }
}
void allocateAndCopy(char **t, char *s1, char *s2)
{
 char *e;
 
 if(s1 != NULL || s2 != NULL)
  {
   int l1=0,l2=0,l,lt;
   
   if(s1 != NULL)
    l1 =strlen(s1);
   if(s2 != NULL)
    l2 =strlen(s2);
   l=l1+l2;

   if(*t != NULL)
    {
     //    printf(">>>>>>>>>>  removing old memory (s<-s) <<<<<<<<<<<<\n");
     delete *t;
    }
   
   *t = new char [l+2];
   e = *t;
   if(s1 != NULL)
    {
     strncpy(*t,s1,l1+2);
     e[l1] ='\0';
    }
   else
    e[0]='\0';

   if(s2 != NULL)
    {
     lt=strlen(*t);
     strncat(*t,s2,l2+2);
     e[l2+lt]='\0';
    }
  }
}
void allocateAndCopy(char **t, char s)
{
 char *e;

 if(*t != NULL)
  {
//    printf(">>>>>>>>>>  removing old memory (s<-c) <<<<<<<<<<<<\n");
   delete *t;
  }
 *t = new char [2];
 e = *t;
 e[0] = s;
 e[1] = '\0';
}

void allocateAndCopy(char **t, int v)
{
 char *e;


 if(*t != NULL)
  {
//    printf(">>>>>>>>>>  removing old memory (s<-i) <<<<<<<<<<<<\n");
   delete *t;
  }
 *t = new char [16];
 sprintf(*t,"%d",v);
}
