
#ifndef __UNSPLIT_CSV__
#define __UNSPLIT_CSV__
char *endOfCsvEntry(char *t, char sep);
char * quoteSpecialChars(char *t,char sep);
char * unquoteSpecialChars(char *t,char sep);
void allocateAndCopy(char **t, char *s1, char *s2);
void allocateAndCopy(char **t, char *s);
void allocateAndCopy(char **t, char s);
void allocateAndCopy(char **t, int v);

#ifdef WITH_CLASS
#undef WITH_CLASS
#endif

#ifdef WITH_CLASS
class csvData
{
public:
 int cols;
 int filled;
 char **col;

 csvData ()
 {
  cols =0;
  filled=0;
 }

 csvData (int anz)
 {
  filled=0;
  init(anz);
 }
 ~csvData ()
 {
  for(int i=0; i<cols ; i++)
   if(col[i] != NULL)
    {
     delete col[i];
     col[i] = NULL;
    }
  delete col;
 }

 void init(int anz)
 {
  cols=anz;
  col = new (char *) [anz+1];
  for(int i=0; i<cols ; i++)
   col[i] = NULL;
 }
 int unsplit(char *str,char sep)
 {
  int len = strlen(str);
  char *t,*s,*n;
  int c=0,l;
  char *tmp;
  
  
  tmp = new char [len+2];
  memcpy(tmp,str,sizeof(char)*(len+1));
  tmp[len] ='\0';
  
  t=tmp;
  while(t[len-1] == '\n')
   {
    t[len-1] = '\0';
    len --;
    if(len <=0)
     break;
   }
  
  do
   {
    s = endOfCsvEntry(t,sep);
    if(s !=NULL)
     *s='\0';
    n = unquoteSpecialChars(t,sep);
    allocateAndCopy(&col[c],n);
    c++;
    if(c>= cols)
     break;
    t = s+1;
   }while(s != NULL);
  
  filled =c;
  delete tmp;
  return true;
 }
 
 char *concatCsv(char sep)
 {
  char *n;
  char *str,*t;
  int len,l;
  int max;
  int i;
  
  len=0;
  for(i=0;i<cols; i++)
   len += l= strlen(n);
  
  str = new char [len*2];
  max= 16384;
  len =0;
  
  *str='\0';
  for(i=0;i<cols; i++)
   {
    if(col[i]!=NULL)
     n=quoteSpecialChars(col[i],sep);
    else
     n="";
    l= strlen(n);
    while(l+len+8 > max)
     {
      t = new char [max+8192];
      memcpy(t,str,max);
      delete str;
      str=t;
      max += 8192;
     }
    if(i>0)
     {
      str[len]=sep;
      len++;
      str[len]='\0';
     }
    strcat(str,n);
    len += l;
   }
  return(str);
 }
};
#else
 typedef struct {
  int cols;
  int filled;
  char **col;
 } csvData;
#endif

csvData *newCsvDataStruct(int anz);
csvData *newCsvDataStruct(int len, int anz);
void destroyCsvDataStruct(csvData *cd);
csvData * unsplitCsv(char *str,int anz,char sep);
char *concatCsv(csvData *cd,char sep);
void clearCsvData(csvData *cd);
void allocateAndCopy(csvData *cd, int fnr, char *s);
void allocateAndCopy(csvData *cd, int fnr, char v);
void allocateAndCopy(csvData *cd, int fnr, int v);
void allocateAndCopy(csvData *cd, void*  fnrp, char *s);
#endif
